/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind.patch;

import com.jsql.model.injection.strategy.blind.patch.Diff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;

public class DiffMatchPatch {
    public static final float DIFF_TIMEOUT = 1.0f;
    public static final short DIFF_EDIT_COST = 4;
    private static final Pattern BLANK_LINE_END = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private static final Pattern BLANK_LINE_START = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    public LinkedList<Diff> diffMain(String text1, String text2, boolean checklines) {
        long deadline = System.currentTimeMillis() + 1000L;
        return this.diffMain(text1, text2, checklines, deadline);
    }

    private LinkedList<Diff> diffMain(String valueText1, String valueText2, boolean checklines, long deadline) {
        String text1 = valueText1;
        String text2 = valueText2;
        if (text1 == null || text2 == null) {
            throw new IllegalArgumentException("Null inputs. (diff_main)");
        }
        if (text1.equals(text2)) {
            LinkedList<Diff> diffs = new LinkedList<Diff>();
            if (!text1.isEmpty()) {
                diffs.add(new Diff(Operation.EQUAL, text1));
            }
            return diffs;
        }
        int commonlength = this.diffCommonPrefix(text1, text2);
        String commonprefix = text1.substring(0, commonlength);
        text1 = text1.substring(commonlength);
        text2 = text2.substring(commonlength);
        commonlength = this.diffCommonSuffix(text1, text2);
        String commonsuffix = text1.substring(text1.length() - commonlength);
        text1 = text1.substring(0, text1.length() - commonlength);
        text2 = text2.substring(0, text2.length() - commonlength);
        LinkedList<Diff> diffs = this.diffCompute(text1, text2, checklines, deadline);
        if (!commonprefix.isEmpty()) {
            diffs.addFirst(new Diff(Operation.EQUAL, commonprefix));
        }
        if (!commonsuffix.isEmpty()) {
            diffs.addLast(new Diff(Operation.EQUAL, commonsuffix));
        }
        this.diffCleanupMerge(diffs);
        return diffs;
    }

    private LinkedList<Diff> diffCompute(String text1, String text2, boolean checklines, long deadline) {
        String shorttext;
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        if (text1.isEmpty()) {
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        if (text2.isEmpty()) {
            diffs.add(new Diff(Operation.DELETE, text1));
            return diffs;
        }
        String longtext = text1.length() > text2.length() ? text1 : text2;
        int i = longtext.indexOf(shorttext = text1.length() > text2.length() ? text2 : text1);
        if (i != -1) {
            Operation op = text1.length() > text2.length() ? Operation.DELETE : Operation.INSERT;
            diffs.add(new Diff(op, longtext.substring(0, i)));
            diffs.add(new Diff(Operation.EQUAL, shorttext));
            diffs.add(new Diff(op, longtext.substring(i + shorttext.length())));
            return diffs;
        }
        if (shorttext.length() == 1) {
            diffs.add(new Diff(Operation.DELETE, text1));
            diffs.add(new Diff(Operation.INSERT, text2));
            return diffs;
        }
        String[] hm = this.diffHalfMatch(text1, text2);
        if (hm != null) {
            String text1A = hm[0];
            String text1B = hm[1];
            String text2A = hm[2];
            String text2B = hm[3];
            String midCommon = hm[4];
            LinkedList<Diff> diffsA = this.diffMain(text1A, text2A, checklines, deadline);
            LinkedList<Diff> diffsB = this.diffMain(text1B, text2B, checklines, deadline);
            diffs = diffsA;
            diffs.add(new Diff(Operation.EQUAL, midCommon));
            diffs.addAll(diffsB);
            return diffs;
        }
        if (checklines && text1.length() > 100 && text2.length() > 100) {
            return this.diffLineMode(text1, text2, deadline);
        }
        return this.diffBisect(text1, text2, deadline);
    }

    private LinkedList<Diff> diffLineMode(String valueText1, String valueText2, long deadline) {
        LinesToCharsResult b = this.diffLinesToChars(valueText1, valueText2);
        String text1 = b.chars1;
        String text2 = b.chars2;
        List<String> linearray = b.lineArray;
        LinkedList<Diff> diffs = this.diffMain(text1, text2, false, deadline);
        this.diffCharsToLines(diffs, linearray);
        this.diffCleanupSemantic(diffs);
        diffs.add(new Diff(Operation.EQUAL, ""));
        int countDelete = 0;
        int countInsert = 0;
        StringBuilder textDelete = new StringBuilder();
        StringBuilder textInsert = new StringBuilder();
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            switch (thisDiff.getOperation().ordinal()) {
                case 1: {
                    ++countInsert;
                    textInsert.append(thisDiff.getText());
                    break;
                }
                case 0: {
                    ++countDelete;
                    textDelete.append(thisDiff.getText());
                    break;
                }
                case 2: {
                    if (countDelete >= 1 && countInsert >= 1) {
                        pointer.previous();
                        for (int j = 0; j < countDelete + countInsert; ++j) {
                            pointer.previous();
                            pointer.remove();
                        }
                        for (Diff newDiff : this.diffMain(textDelete.toString(), textInsert.toString(), false, deadline)) {
                            pointer.add(newDiff);
                        }
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete.setLength(0);
                    textInsert.setLength(0);
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        diffs.removeLast();
        return diffs;
    }

    protected LinkedList<Diff> diffBisect(String text1, String text2, long deadline) {
        int text1Length = text1.length();
        int text2Length = text2.length();
        int maxD = (text1Length + text2Length + 1) / 2;
        int vLength = 2 * maxD;
        int[] v1 = new int[vLength];
        int[] v2 = new int[vLength];
        for (int x = 0; x < vLength; ++x) {
            v1[x] = -1;
            v2[x] = -1;
        }
        v1[maxD + 1] = 0;
        v2[maxD + 1] = 0;
        int delta = text1Length - text2Length;
        boolean front = delta % 2 != 0;
        int k1start = 0;
        int k1end = 0;
        int k2start = 0;
        int k2end = 0;
        for (int d = 0; d < maxD && System.currentTimeMillis() <= deadline; ++d) {
            for (int k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {
                int x2;
                int k2Offset;
                int y1;
                int k1Offset = maxD + k1;
                int x1 = k1 == -d || k1 != d && v1[k1Offset - 1] < v1[k1Offset + 1] ? v1[k1Offset + 1] : v1[k1Offset - 1] + 1;
                for (y1 = x1 - k1; x1 < text1Length && y1 < text2Length && text1.charAt(x1) == text2.charAt(y1); ++x1, ++y1) {
                }
                v1[k1Offset] = x1;
                if (x1 > text1Length) {
                    k1end += 2;
                    continue;
                }
                if (y1 > text2Length) {
                    k1start += 2;
                    continue;
                }
                if (!front || (k2Offset = maxD + delta - k1) < 0 || k2Offset >= vLength || v2[k2Offset] == -1 || x1 < (x2 = text1Length - v2[k2Offset])) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
            for (int k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {
                int k1Offset;
                int y2;
                int k2Offset = maxD + k2;
                int x2 = k2 == -d || k2 != d && v2[k2Offset - 1] < v2[k2Offset + 1] ? v2[k2Offset + 1] : v2[k2Offset - 1] + 1;
                for (y2 = x2 - k2; x2 < text1Length && y2 < text2Length && text1.charAt(text1Length - x2 - 1) == text2.charAt(text2Length - y2 - 1); ++x2, ++y2) {
                }
                v2[k2Offset] = x2;
                if (x2 > text1Length) {
                    k2end += 2;
                    continue;
                }
                if (y2 > text2Length) {
                    k2start += 2;
                    continue;
                }
                if (front || (k1Offset = maxD + delta - k2) < 0 || k1Offset >= vLength || v1[k1Offset] == -1) continue;
                int x1 = v1[k1Offset];
                int y1 = maxD + x1 - k1Offset;
                if (x1 < (x2 = text1Length - x2)) continue;
                return this.diffBisectSplit(text1, text2, x1, y1, deadline);
            }
        }
        LinkedList<Diff> diffs = new LinkedList<Diff>();
        diffs.add(new Diff(Operation.DELETE, text1));
        diffs.add(new Diff(Operation.INSERT, text2));
        return diffs;
    }

    private LinkedList<Diff> diffBisectSplit(String text1, String text2, int x, int y, long deadline) {
        String text1a = text1.substring(0, x);
        String text2a = text2.substring(0, y);
        String text1b = text1.substring(x);
        String text2b = text2.substring(y);
        LinkedList<Diff> diffs = this.diffMain(text1a, text2a, false, deadline);
        LinkedList<Diff> diffsb = this.diffMain(text1b, text2b, false, deadline);
        diffs.addAll(diffsb);
        return diffs;
    }

    protected LinesToCharsResult diffLinesToChars(String text1, String text2) {
        ArrayList<String> lineArray = new ArrayList<String>();
        HashMap<String, Integer> lineHash = new HashMap<String, Integer>();
        lineArray.add("");
        String chars1 = this.diffLinesToCharsMunge(text1, lineArray, lineHash);
        String chars2 = this.diffLinesToCharsMunge(text2, lineArray, lineHash);
        return new LinesToCharsResult(chars1, chars2, lineArray);
    }

    private String diffLinesToCharsMunge(String text, List<String> lineArray, Map<String, Integer> lineHash) {
        int lineStart = 0;
        int lineEnd = -1;
        StringBuilder chars = new StringBuilder();
        while (lineEnd < text.length() - 1) {
            lineEnd = text.indexOf(10, lineStart);
            if (lineEnd == -1) {
                lineEnd = text.length() - 1;
            }
            String line = text.substring(lineStart, lineEnd + 1);
            lineStart = lineEnd + 1;
            if (lineHash.containsKey(line)) {
                chars.append((char)lineHash.get(line).intValue());
                continue;
            }
            lineArray.add(line);
            lineHash.put(line, lineArray.size() - 1);
            chars.append((char)(lineArray.size() - 1));
        }
        return chars.toString();
    }

    protected void diffCharsToLines(List<Diff> diffs, List<String> lineArray) {
        for (Diff diff : diffs) {
            StringBuilder text = new StringBuilder();
            for (int y = 0; y < diff.getText().length(); ++y) {
                text.append(lineArray.get(diff.getText().charAt(y)));
            }
            diff.setText(text.toString());
        }
    }

    public int diffCommonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public int diffCommonSuffix(String text1, String text2) {
        int text1Length = text1.length();
        int text2Length = text2.length();
        int n = Math.min(text1Length, text2Length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1Length - i) == text2.charAt(text2Length - i)) continue;
            return i - 1;
        }
        return n;
    }

    protected int diffCommonOverlap(String valueText1, String valueText2) {
        String text1 = valueText1;
        String text2 = valueText2;
        int text1Length = text1.length();
        int text2Length = text2.length();
        if (text1Length == 0 || text2Length == 0) {
            return 0;
        }
        if (text1Length > text2Length) {
            text1 = text1.substring(text1Length - text2Length);
        } else if (text1Length < text2Length) {
            text2 = text2.substring(0, text1Length);
        }
        int textLength = Math.min(text1Length, text2Length);
        if (text1.equals(text2)) {
            return textLength;
        }
        int best = 0;
        int length = 1;
        String pattern;
        int found;
        while ((found = text2.indexOf(pattern = text1.substring(textLength - length))) != -1) {
            if (found != 0 && !text1.substring(textLength - (length += found)).equals(text2.substring(0, length))) continue;
            best = length++;
        }
        return best;
    }

    protected String[] diffHalfMatch(String text1, String text2) {
        String[] hm;
        String shorttext;
        String longtext = text1.length() > text2.length() ? text1 : text2;
        String string = shorttext = text1.length() > text2.length() ? text2 : text1;
        if (longtext.length() < 4 || shorttext.length() * 2 < longtext.length()) {
            return null;
        }
        String[] hm1 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 3) / 4);
        String[] hm2 = this.diffHalfMatchI(longtext, shorttext, (longtext.length() + 1) / 2);
        if (hm1 == null && hm2 == null) {
            return null;
        }
        if (hm2 == null) {
            hm = hm1;
        } else if (hm1 == null) {
            hm = hm2;
        } else {
            String[] stringArray = hm = hm1[4].length() > hm2[4].length() ? hm1 : hm2;
        }
        if (text1.length() > text2.length()) {
            return hm;
        }
        return new String[]{hm[2], hm[3], hm[0], hm[1], hm[4]};
    }

    private String[] diffHalfMatchI(String longtext, String shorttext, int i) {
        String seed = longtext.substring(i, i + longtext.length() / 4);
        int j = -1;
        Object bestCommon = "";
        String bestLongtextA = "";
        String bestLongtextB = "";
        String bestShorttextA = "";
        String bestShorttextB = "";
        while ((j = shorttext.indexOf(seed, j + 1)) != -1) {
            int prefixLength = this.diffCommonPrefix(longtext.substring(i), shorttext.substring(j));
            int suffixLength = this.diffCommonSuffix(longtext.substring(0, i), shorttext.substring(0, j));
            if (((String)bestCommon).length() >= suffixLength + prefixLength) continue;
            bestCommon = shorttext.substring(j - suffixLength, j) + shorttext.substring(j, j + prefixLength);
            bestLongtextA = longtext.substring(0, i - suffixLength);
            bestLongtextB = longtext.substring(i + prefixLength);
            bestShorttextA = shorttext.substring(0, j - suffixLength);
            bestShorttextB = shorttext.substring(j + prefixLength);
        }
        if (((String)bestCommon).length() * 2 >= longtext.length()) {
            return new String[]{bestLongtextA, bestLongtextB, bestShorttextA, bestShorttextB, bestCommon};
        }
        return null;
    }

    public void diffCleanupSemantic(LinkedList<Diff> diffs) {
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        int lengthInsertions1 = 0;
        int lengthDeletions1 = 0;
        int lengthInsertions2 = 0;
        int lengthDeletions2 = 0;
        Diff thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.getOperation() == Operation.EQUAL) {
                equalities.push(thisDiff);
                lengthInsertions1 = lengthInsertions2;
                lengthDeletions1 = lengthDeletions2;
                lengthInsertions2 = 0;
                lengthDeletions2 = 0;
                lastequality = thisDiff.getText();
            } else {
                if (thisDiff.getOperation() == Operation.INSERT) {
                    lengthInsertions2 += thisDiff.getText().length();
                } else {
                    lengthDeletions2 += thisDiff.getText().length();
                }
                if (lastequality != null && lastequality.length() <= Math.max(lengthInsertions1, lengthDeletions1) && lastequality.length() <= Math.max(lengthInsertions2, lengthDeletions2)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    pointer.add(new Diff(Operation.INSERT, lastequality));
                    equalities.pop();
                    if (!equalities.empty()) {
                        equalities.pop();
                    }
                    if (equalities.empty()) {
                        while (pointer.hasPrevious()) {
                            pointer.previous();
                        }
                    } else {
                        thisDiff = (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                    }
                    lengthInsertions1 = 0;
                    lengthInsertions2 = 0;
                    lengthDeletions1 = 0;
                    lengthDeletions2 = 0;
                    lastequality = null;
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
        this.diffCleanupSemanticLossless(diffs);
        pointer = diffs.listIterator();
        Diff prevDiff = null;
        thisDiff = null;
        if (pointer.hasNext()) {
            prevDiff = (Diff)pointer.next();
            if (pointer.hasNext()) {
                thisDiff = (Diff)pointer.next();
            }
        }
        while (thisDiff != null) {
            if (prevDiff.getOperation() == Operation.DELETE && thisDiff.getOperation() == Operation.INSERT) {
                int overlapLength2;
                String insertion;
                String deletion = prevDiff.getText();
                int overlapLength1 = this.diffCommonOverlap(deletion, insertion = thisDiff.getText());
                if (overlapLength1 >= (overlapLength2 = this.diffCommonOverlap(insertion, deletion))) {
                    if ((double)overlapLength1 >= (double)deletion.length() / 2.0 || (double)overlapLength1 >= (double)insertion.length() / 2.0) {
                        pointer.previous();
                        pointer.add(new Diff(Operation.EQUAL, insertion.substring(0, overlapLength1)));
                        prevDiff.setText(deletion.substring(0, deletion.length() - overlapLength1));
                        thisDiff.setText(insertion.substring(overlapLength1));
                    }
                } else if ((double)overlapLength2 >= (double)deletion.length() / 2.0 || (double)overlapLength2 >= (double)insertion.length() / 2.0) {
                    pointer.previous();
                    pointer.add(new Diff(Operation.EQUAL, deletion.substring(0, overlapLength2)));
                    prevDiff.setOperation(Operation.INSERT);
                    prevDiff.setText(insertion.substring(0, insertion.length() - overlapLength2));
                    thisDiff.setOperation(Operation.DELETE);
                    thisDiff.setText(deletion.substring(overlapLength2));
                }
                thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
            }
            prevDiff = thisDiff;
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
    }

    public void diffCleanupSemanticLossless(List<Diff> diffs) {
        Diff nextDiff;
        StringBuilder equality1 = new StringBuilder();
        StringBuilder equality2 = new StringBuilder();
        ListIterator<Diff> pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? pointer.next() : null;
        Diff thisDiff = pointer.hasNext() ? pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                String substring;
                equality1.setLength(0);
                equality1.append(prevDiff.getText());
                Object edit = thisDiff.getText();
                equality2.setLength(0);
                equality2.append(nextDiff.getText());
                int commonOffset = this.diffCommonSuffix(equality1.toString(), (String)edit);
                if (commonOffset != 0) {
                    String commonString = ((String)edit).substring(((String)edit).length() - commonOffset);
                    substring = equality1.substring(0, equality1.length() - commonOffset);
                    equality1.setLength(0);
                    equality1.append(substring);
                    edit = commonString + ((String)edit).substring(0, ((String)edit).length() - commonOffset);
                    equality2.insert(0, commonString);
                }
                String bestEquality1 = equality1.toString();
                Object bestEdit = edit;
                String bestEquality2 = equality2.toString();
                int bestScore = this.diffCleanupSemanticScore(equality1.toString(), (String)edit) + this.diffCleanupSemanticScore((String)edit, equality2.toString());
                while (!((String)edit).isEmpty() && !equality2.isEmpty() && ((String)edit).charAt(0) == equality2.charAt(0)) {
                    equality1.append(((String)edit).charAt(0));
                    edit = ((String)edit).substring(1) + equality2.charAt(0);
                    substring = equality2.substring(1);
                    equality2.setLength(0);
                    equality2.append(substring);
                    int score = this.diffCleanupSemanticScore(equality1.toString(), (String)edit) + this.diffCleanupSemanticScore((String)edit, equality2.toString());
                    if (score < bestScore) continue;
                    bestScore = score;
                    bestEquality1 = equality1.toString();
                    bestEdit = edit;
                    bestEquality2 = equality2.toString();
                }
                if (!prevDiff.getText().equals(bestEquality1)) {
                    if (!bestEquality1.isEmpty()) {
                        prevDiff.setText(bestEquality1);
                    } else {
                        pointer.previous();
                        pointer.previous();
                        pointer.previous();
                        pointer.remove();
                        pointer.next();
                        pointer.next();
                    }
                    thisDiff.setText((String)bestEdit);
                    if (!bestEquality2.isEmpty()) {
                        nextDiff.setText(bestEquality2);
                    } else {
                        pointer.remove();
                        nextDiff = thisDiff;
                        thisDiff = prevDiff;
                    }
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? pointer.next() : null;
        }
    }

    private int diffCleanupSemanticScore(String one, String two) {
        boolean blankLine2;
        if (one.isEmpty() || two.isEmpty()) {
            return 6;
        }
        char char1 = one.charAt(one.length() - 1);
        char char2 = two.charAt(0);
        boolean nonAlphaNumeric1 = !Character.isLetterOrDigit(char1);
        boolean nonAlphaNumeric2 = !Character.isLetterOrDigit(char2);
        boolean whitespace1 = nonAlphaNumeric1 && Character.isWhitespace(char1);
        boolean whitespace2 = nonAlphaNumeric2 && Character.isWhitespace(char2);
        boolean lineBreak1 = whitespace1 && Character.getType(char1) == 15;
        boolean lineBreak2 = whitespace2 && Character.getType(char2) == 15;
        boolean blankLine1 = lineBreak1 && BLANK_LINE_END.matcher(one).find();
        boolean bl = blankLine2 = lineBreak2 && BLANK_LINE_START.matcher(two).find();
        if (blankLine1 || blankLine2) {
            return 5;
        }
        if (lineBreak1 || lineBreak2) {
            return 4;
        }
        if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {
            return 3;
        }
        if (whitespace1 || whitespace2) {
            return 2;
        }
        if (nonAlphaNumeric1 || nonAlphaNumeric2) {
            return 1;
        }
        return 0;
    }

    public void diffCleanupEfficiency(LinkedList<Diff> diffs) {
        Diff thisDiff;
        if (diffs.isEmpty()) {
            return;
        }
        boolean changes = false;
        Stack<Diff> equalities = new Stack<Diff>();
        String lastequality = null;
        ListIterator<Diff> pointer = diffs.listIterator();
        boolean preIns = false;
        boolean preDel = false;
        boolean postIns = false;
        boolean postDel = false;
        Diff safeDiff = thisDiff = (Diff)pointer.next();
        while (thisDiff != null) {
            if (thisDiff.getOperation() == Operation.EQUAL) {
                if (thisDiff.getText().length() < 4 && (postIns || postDel)) {
                    equalities.push(thisDiff);
                    preIns = postIns;
                    preDel = postDel;
                    lastequality = thisDiff.getText();
                } else {
                    equalities.clear();
                    lastequality = null;
                    safeDiff = thisDiff;
                }
                postDel = false;
                postIns = false;
            } else {
                if (thisDiff.getOperation() == Operation.DELETE) {
                    postDel = true;
                } else {
                    postIns = true;
                }
                if (lastequality != null && (preIns && preDel && postIns && postDel || lastequality.length() < 2 && (preIns ? 1 : 0) + (preDel ? 1 : 0) + (postIns ? 1 : 0) + (postDel ? 1 : 0) == 3)) {
                    while (thisDiff != equalities.lastElement()) {
                        thisDiff = (Diff)pointer.previous();
                    }
                    pointer.next();
                    pointer.set(new Diff(Operation.DELETE, lastequality));
                    thisDiff = new Diff(Operation.INSERT, lastequality);
                    pointer.add(thisDiff);
                    equalities.pop();
                    lastequality = null;
                    if (preIns && preDel) {
                        postDel = true;
                        postIns = true;
                        equalities.clear();
                        safeDiff = thisDiff;
                    } else {
                        if (!equalities.empty()) {
                            equalities.pop();
                        }
                        thisDiff = equalities.empty() ? safeDiff : (Diff)equalities.lastElement();
                        while (thisDiff != pointer.previous()) {
                        }
                        postDel = false;
                        postIns = false;
                    }
                    changes = true;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public void diffCleanupMerge(LinkedList<Diff> diffs) {
        Diff nextDiff;
        diffs.add(new Diff(Operation.EQUAL, ""));
        ListIterator<Diff> pointer = diffs.listIterator();
        int countDelete = 0;
        int countInsert = 0;
        StringBuilder textDelete = new StringBuilder();
        StringBuilder textInsert = new StringBuilder();
        Diff thisDiff = (Diff)pointer.next();
        Diff prevEqual = null;
        while (thisDiff != null) {
            switch (thisDiff.getOperation().ordinal()) {
                case 1: {
                    ++countInsert;
                    textInsert.append(thisDiff.getText());
                    prevEqual = null;
                    break;
                }
                case 0: {
                    ++countDelete;
                    textDelete.append(thisDiff.getText());
                    prevEqual = null;
                    break;
                }
                case 2: {
                    if (countDelete + countInsert > 1) {
                        boolean bothTypes = countDelete != 0 && countInsert != 0;
                        pointer.previous();
                        while (countDelete-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        while (countInsert-- > 0) {
                            pointer.previous();
                            pointer.remove();
                        }
                        if (bothTypes) {
                            String substringDel;
                            String substringIns;
                            int commonlength = this.diffCommonPrefix(textInsert.toString(), textDelete.toString());
                            if (commonlength != 0) {
                                if (pointer.hasPrevious()) {
                                    thisDiff = (Diff)pointer.previous();
                                    thisDiff.setText(thisDiff.getText() + textInsert.substring(0, commonlength));
                                    pointer.next();
                                } else {
                                    pointer.add(new Diff(Operation.EQUAL, textInsert.substring(0, commonlength)));
                                }
                                substringIns = textInsert.substring(commonlength);
                                textInsert.setLength(0);
                                textInsert.append(substringIns);
                                substringDel = textDelete.substring(commonlength);
                                textDelete.setLength(0);
                                textDelete.append(substringDel);
                            }
                            if ((commonlength = this.diffCommonSuffix(textInsert.toString(), textDelete.toString())) != 0) {
                                thisDiff = (Diff)pointer.next();
                                thisDiff.setText(textInsert.substring(textInsert.length() - commonlength) + thisDiff.getText());
                                substringIns = textInsert.substring(0, textInsert.length() - commonlength);
                                textInsert.setLength(0);
                                textInsert.append(substringIns);
                                substringDel = textDelete.substring(0, textDelete.length() - commonlength);
                                textDelete.setLength(0);
                                textDelete.append(substringDel);
                                pointer.previous();
                            }
                        }
                        if (!textDelete.isEmpty()) {
                            pointer.add(new Diff(Operation.DELETE, textDelete.toString()));
                        }
                        if (!textInsert.isEmpty()) {
                            pointer.add(new Diff(Operation.INSERT, textInsert.toString()));
                        }
                        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    } else if (prevEqual != null) {
                        prevEqual.setText(prevEqual.getText() + thisDiff.getText());
                        pointer.remove();
                        thisDiff = (Diff)pointer.previous();
                        pointer.next();
                    }
                    countInsert = 0;
                    countDelete = 0;
                    textDelete.setLength(0);
                    textInsert.setLength(0);
                    prevEqual = thisDiff;
                }
            }
            thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (diffs.getLast().getText().isEmpty()) {
            diffs.removeLast();
        }
        boolean changes = false;
        pointer = diffs.listIterator();
        Diff prevDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        thisDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        Diff diff = nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        while (nextDiff != null) {
            if (prevDiff.getOperation() == Operation.EQUAL && nextDiff.getOperation() == Operation.EQUAL) {
                if (thisDiff.getText().endsWith(prevDiff.getText())) {
                    thisDiff.setText(prevDiff.getText() + thisDiff.getText().substring(0, thisDiff.getText().length() - prevDiff.getText().length()));
                    nextDiff.setText(prevDiff.getText() + nextDiff.getText());
                    pointer.previous();
                    pointer.previous();
                    pointer.previous();
                    pointer.remove();
                    pointer.next();
                    thisDiff = (Diff)pointer.next();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                } else if (thisDiff.getText().startsWith(nextDiff.getText())) {
                    prevDiff.setText(prevDiff.getText() + nextDiff.getText());
                    thisDiff.setText(thisDiff.getText().substring(nextDiff.getText().length()) + nextDiff.getText());
                    pointer.remove();
                    nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
                    changes = true;
                }
            }
            prevDiff = thisDiff;
            thisDiff = nextDiff;
            nextDiff = pointer.hasNext() ? (Diff)pointer.next() : null;
        }
        if (changes) {
            this.diffCleanupMerge(diffs);
        }
    }

    public static enum Operation {
        DELETE,
        INSERT,
        EQUAL;

    }

    protected record LinesToCharsResult(String chars1, String chars2, List<String> lineArray) {
    }
}

