/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.engine.model.Engine;
import com.jsql.model.injection.strategy.blind.callable.AbstractCallableBit;
import com.jsql.model.injection.strategy.blind.callable.CallableEngine;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionEngine {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String blankFalseMark;
    private List<Diff> constantTrueMark = new ArrayList<Diff>();
    protected final InjectionModel injectionModel;
    private final List<String> falsy;

    public InjectionEngine(InjectionModel injectionModel, String engineSpecificWithOperator, Engine engine) {
        this.injectionModel = injectionModel;
        List<String> truthy = this.injectionModel.getMediatorEngine().getEngine().instance().getTruthyBit();
        this.falsy = this.injectionModel.getMediatorEngine().getEngine().instance().getFalsyBit();
        if (truthy.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.blankFalseMark = this.callUrl("", "vendor:" + String.valueOf(engine));
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().threadUtil().getExecutor("CallableVendorTagTrue");
        ArrayList<CallableEngine> listCallableTagTrue = new ArrayList<CallableEngine>();
        for (String urlTest : truthy) {
            listCallableTagTrue.add(new CallableEngine(engineSpecificWithOperator.replace("${test}", urlTest), this, "vendor#true"));
        }
        try {
            List listTagTrue = taskExecutor.invokeAll(listCallableTagTrue);
            this.injectionModel.getMediatorUtils().threadUtil().shutdown(taskExecutor);
            for (int i = 1; i < listTagTrue.size(); ++i) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.constantTrueMark.isEmpty()) {
                    this.constantTrueMark = ((CallableEngine)listTagTrue.get(i).get()).getOpcodes();
                    continue;
                }
                this.constantTrueMark.retainAll(((CallableEngine)listTagTrue.get(i).get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.initFalseMarks(engineSpecificWithOperator);
    }

    private void initFalseMarks(String engineSpecificWithMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().threadUtil().getExecutor("CallableVendorTagFalse");
        ArrayList<CallableEngine> listCallableTagFalse = new ArrayList<CallableEngine>();
        for (String urlTest : this.falsy) {
            listCallableTagFalse.add(new CallableEngine(engineSpecificWithMode.replace("${test}", urlTest), this, "vendor#false"));
        }
        try {
            List listTagFalse = taskExecutor.invokeAll(listCallableTagFalse);
            this.injectionModel.getMediatorUtils().threadUtil().shutdown(taskExecutor);
            for (Future falseTag : listTagFalse) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                this.constantTrueMark.removeAll(((CallableEngine)falseTag.get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public boolean isInjectable(String engineSpecificWithMode) throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableEngine blindTest = new CallableEngine(engineSpecificWithMode.replace("${test}", this.injectionModel.getMediatorEngine().getEngine().instance().sqlBlindConfirm()), this, "vendor#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && !this.constantTrueMark.isEmpty();
    }

    public String callUrl(String urlString, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess);
    }

    public String callUrl(String urlString, String metadataInjectionProcess, AbstractCallableBit<?> callableBoolean) {
        return this.injectionModel.injectWithoutIndex(urlString, metadataInjectionProcess, callableBoolean);
    }

    public String getBlankFalseMark() {
        return this.blankFalseMark;
    }

    public List<Diff> getConstantTrueMark() {
        return this.constantTrueMark;
    }
}

