/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.model.suspendable.SuspendableGetIndexes;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyUnion
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String indexesInUrl = "";
    protected String visibleIndex;
    protected String sourceIndexesFound = "";
    private int nbIndexesFound = 0;
    private String performanceLength = "0";

    public StrategyUnion(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws JSqlException {
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isStrategyUnionDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        this.logChecking();
        this.indexesInUrl = new SuspendableGetIndexes(this.injectionModel).run();
        if (StringUtils.isNotEmpty(this.indexesInUrl)) {
            this.visibleIndex = this.getVisibleIndex(this.sourceIndexesFound);
        }
        boolean bl = this.isApplicable = StringUtils.isNotEmpty(this.indexesInUrl) && Integer.parseInt(this.injectionModel.getMediatorStrategy().getUnion().getPerformanceLength()) > 0 && StringUtils.isNotBlank(this.visibleIndex);
        if (this.isApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} [{}] at index [{}] showing [{}] characters", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), this::getName, () -> this.visibleIndex, () -> this.performanceLength);
            this.allow(new int[0]);
        } else {
            this.unallow(new int[0]);
        }
    }

    @Override
    public void allow(int ... i) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName()) + this.injectionModel.getReportWithIndexes(this.injectionModel.getMediatorEngine().getEngine().instance().sqlUnion(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "0", true), "metadataInjectionProcess"));
        this.injectionModel.sendToViews(new Seal.MarkStrategyVulnerable(this));
    }

    @Override
    public void unallow(int ... i) {
        this.injectionModel.sendToViews(new Seal.MarkStrategyInvulnerable(this));
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) {
        return this.injectionModel.injectWithIndexes(this.injectionModel.getMediatorEngine().getEngine().instance().sqlUnion(sqlQuery, startPosition, false), metadataInjectionProcess);
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            this.injectionModel.sendToViews(new Seal.ActivateStrategy(this));
        }
    }

    public String getVisibleIndex(String firstSuccessPageSource) {
        String regexAllIndexes = String.format("1337%s7331", "(\\d+?)");
        Matcher regexSearch = Pattern.compile("(?s)" + regexAllIndexes).matcher(firstSuccessPageSource);
        ArrayList<String> listFoundIndexes = new ArrayList<String>();
        while (regexSearch.find()) {
            listFoundIndexes.add(regexSearch.group(1));
        }
        CharSequence[] arrayFoundIndexes = listFoundIndexes.toArray(new String[0]);
        String performanceQuery = this.injectionModel.getMediatorEngine().getEngine().instance().sqlCapacity((String[])arrayFoundIndexes);
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(performanceQuery, "union#size");
        regexSearch = Pattern.compile("(?s)SqLi(\\d+)(a+)").matcher(performanceSourcePage);
        ArrayList<String[]> performanceResults = new ArrayList<String[]>();
        while (regexSearch.find()) {
            performanceResults.add(new String[]{regexSearch.group(1), regexSearch.group(2)});
        }
        if (performanceResults.isEmpty()) {
            this.performanceLength = "0";
            return null;
        }
        Integer[][] lengthFields = new Integer[performanceResults.size()][2];
        for (int i = 0; i < performanceResults.size(); ++i) {
            lengthFields[i] = new Integer[]{((String[])performanceResults.get(i))[1].length() + ((String[])performanceResults.get(i))[0].length(), Integer.parseInt(((String[])performanceResults.get(i))[0])};
        }
        Arrays.sort(lengthFields, Comparator.comparing(s -> s[0]));
        Integer[] bestLengthFields = lengthFields[lengthFields.length - 1];
        this.performanceLength = bestLengthFields[0].toString();
        String regexAllExceptIndexesFound = String.format("1337%s7331", "(?!" + String.join((CharSequence)"|", arrayFoundIndexes) + "7331)\\d*");
        String indexesInUrlFixed = this.indexesInUrl.replaceAll(regexAllExceptIndexesFound, "1");
        String regexAllIndexesExceptBest = String.format("1337%s7331", "(?!" + bestLengthFields[1] + "7331)\\d*");
        this.indexesInUrl = indexesInUrlFixed.replaceAll(regexAllIndexesExceptBest, "1");
        return Integer.toString(bestLengthFields[1]);
    }

    @Override
    public String getPerformanceLength() {
        return this.performanceLength;
    }

    @Override
    public String getName() {
        return "Union";
    }

    public String getVisibleIndex() {
        return this.visibleIndex;
    }

    public void setVisibleIndex(String visibleIndex) {
        this.visibleIndex = visibleIndex;
    }

    public void setSourceIndexesFound(String sourceIndexesFound) {
        this.sourceIndexesFound = sourceIndexesFound;
    }

    public int getNbIndexesFound() {
        return this.nbIndexesFound;
    }

    public void setNbIndexesFound(int nbIndexesFound) {
        this.nbIndexesFound = nbIndexesFound;
    }

    public String getIndexesInUrl() {
        return this.indexesInUrl;
    }

    public void setIndexesInUrl(String indexesInUrl) {
        this.indexesInUrl = indexesInUrl;
    }
}

