/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.injection.engine.model.EngineYaml;
import com.jsql.model.injection.engine.model.yaml.Configuration;
import com.jsql.model.injection.engine.model.yaml.Strategy;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyStack
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String performanceLength = "0";

    public StrategyStack(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() {
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isStrategyStackDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        this.isApplicable = false;
        Strategy strategyYaml = this.injectionModel.getMediatorEngine().getEngine().instance().getModelYaml().getStrategy();
        Configuration configurationYaml = strategyYaml.getConfiguration();
        this.logChecking();
        boolean methodIsApplicable = this.isApplicable(configurationYaml, strategyYaml.getStack());
        if (methodIsApplicable) {
            Matcher regexSearch = this.getPerformance(configurationYaml, strategyYaml.getStack());
            if (!regexSearch.find()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} but injectable size is incorrect", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), () -> "Stack");
                methodIsApplicable = false;
            } else {
                this.performanceLength = String.valueOf(regexSearch.group(1).length());
            }
        }
        if (methodIsApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} Stack injection showing [{}] characters", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), () -> this.performanceLength);
            this.allow(new int[0]);
        } else {
            this.unallow(new int[0]);
        }
    }

    private boolean isApplicable(Configuration configurationYaml, String stack) {
        boolean methodIsApplicable = false;
        String indexZeroToFind = "0";
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(EngineYaml.replaceTags(stack.replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getFailsafe().replace("${indice}", indexZeroToFind)).replace("${window.char}", "1").replace("${capacity}", "65565")), "stack#confirm");
        String regexIndexZero = String.format("1337%s7331", indexZeroToFind);
        if (performanceSourcePage.matches("(?s).*" + regexIndexZero + ".*")) {
            methodIsApplicable = true;
            this.isApplicable = true;
        }
        return methodIsApplicable;
    }

    private Matcher getPerformance(Configuration configurationYaml, String stack) {
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(EngineYaml.replaceTags(stack.replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getCalibrator()).replace("${window.char}", "1").replace("${capacity}", "65565")), "stack#size");
        return Pattern.compile("(?s)SqLi(a+)").matcher(performanceSourcePage);
    }

    @Override
    public void allow(int ... i) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName()) + this.injectionModel.getReportWithoutIndex(this.injectionModel.getMediatorEngine().getEngine().instance().sqlStack(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "0", true), "metadataInjectionProcess"));
        this.injectionModel.sendToViews(new Seal.MarkStrategyVulnerable(this));
    }

    @Override
    public void unallow(int ... i) {
        this.injectionModel.sendToViews(new Seal.MarkStrategyInvulnerable(this));
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorEngine().getEngine().instance().sqlStack(sqlQuery, startPosition, false), metadataInjectionProcess);
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName);
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            this.injectionModel.sendToViews(new Seal.ActivateStrategy(this));
        }
    }

    @Override
    public String getPerformanceLength() {
        return this.performanceLength;
    }

    @Override
    public String getName() {
        return "Stack";
    }
}

