/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.InjectionBlindBit;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyBlindBit
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private InjectionBlindBit injection;

    public StrategyBlindBit(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws StoppedByUserSlidingException {
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isStrategyBlindBitDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        if (StringUtils.isEmpty(this.injectionModel.getMediatorEngine().getEngine().instance().getModelYaml().getStrategy().getBinary().getTest().getBit())) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Strategy [{}] for [{}] not implemented, share a working example on GitHub to speed up release", (Object)this.getName(), (Object)this.injectionModel.getMediatorEngine().getEngine());
            return;
        }
        this.checkInjection(AbstractInjectionBit.BlindOperator.OR);
        this.checkInjection(AbstractInjectionBit.BlindOperator.AND);
        this.checkInjection(AbstractInjectionBit.BlindOperator.STACK);
        this.checkInjection(AbstractInjectionBit.BlindOperator.NO_MODE);
        if (this.isApplicable) {
            this.allow(new int[0]);
            this.injectionModel.sendToViews(new Seal.MessageBinary(this.injection.getInfoMessage()));
        } else {
            this.unallow(new int[0]);
        }
    }

    private void checkInjection(AbstractInjectionBit.BlindOperator blindOperator) throws StoppedByUserSlidingException {
        if (this.isApplicable) {
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} [{}] with [{}]...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"), this::getName, () -> blindOperator);
        this.injection = new InjectionBlindBit(this.injectionModel, blindOperator);
        this.isApplicable = this.injection.isInjectable();
        if (this.isApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} [{}] injection with [{}]", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), this::getName, () -> blindOperator);
        }
    }

    @Override
    public void allow(int ... i) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName()) + this.injectionModel.getReportWithoutIndex(this.injectionModel.getMediatorEngine().getEngine().instance().sqlTestBlindWithOperator(this.injectionModel.getMediatorEngine().getEngine().instance().sqlBlind(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "0", true), this.injection.getBlindOperator()), "metadataInjectionProcess", null));
        this.injectionModel.sendToViews(new Seal.MarkStrategyVulnerable(this));
    }

    @Override
    public void unallow(int ... i) {
        this.injectionModel.sendToViews(new Seal.MarkStrategyInvulnerable(this));
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injection.inject(this.injectionModel.getMediatorEngine().getEngine().instance().sqlBlind(sqlQuery, startPosition, false), stoppable);
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}] with [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName, () -> this.injection.getBlindOperator().name());
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            this.injectionModel.sendToViews(new Seal.ActivateStrategy(this));
        }
    }

    @Override
    public String getPerformanceLength() {
        return "65565";
    }

    @Override
    public String getName() {
        return "Blind bit";
    }
}

