/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model;

import com.jsql.model.AbstractModelObservable;
import com.jsql.model.MediatorUtils;
import com.jsql.model.accessible.DataAccess;
import com.jsql.model.accessible.ResourceAccess;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.model.injection.engine.MediatorEngine;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.model.injection.method.MediatorMethod;
import com.jsql.model.injection.strategy.MediatorStrategy;
import com.jsql.model.injection.strategy.blind.callable.AbstractCallableBit;
import com.jsql.util.AuthenticationUtil;
import com.jsql.util.CertificateUtil;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.CookiesUtil;
import com.jsql.util.CsrfUtil;
import com.jsql.util.DigestUtil;
import com.jsql.util.ExceptionUtil;
import com.jsql.util.FormUtil;
import com.jsql.util.GitUtil;
import com.jsql.util.HeaderUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.JsonUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.MultipartUtil;
import com.jsql.util.ParameterUtil;
import com.jsql.util.PreferencesUtil;
import com.jsql.util.PropertiesUtil;
import com.jsql.util.ProxyUtil;
import com.jsql.util.SoapUtil;
import com.jsql.util.StringUtil;
import com.jsql.util.TamperingUtil;
import com.jsql.util.ThreadUtil;
import com.jsql.util.UserAgentUtil;
import com.jsql.view.subscriber.Seal;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionModel
extends AbstractModelObservable
implements Serializable {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final transient MediatorEngine mediatorEngine = new MediatorEngine(this);
    private final transient MediatorMethod mediatorMethod = new MediatorMethod(this);
    private final transient DataAccess dataAccess = new DataAccess(this);
    private final transient ResourceAccess resourceAccess = new ResourceAccess(this);
    private final transient PropertiesUtil propertiesUtil = new PropertiesUtil();
    private final transient MediatorUtils mediatorUtils;
    private final transient MediatorStrategy mediatorStrategy = new MediatorStrategy(this);
    public static final String STAR = "*";
    public static final String BR = "<br>&#10;";
    private String analysisReport = "";
    private boolean shouldErasePreviousInjection = false;
    private boolean isScanning = false;

    public InjectionModel() {
        this.mediatorUtils = new MediatorUtils(this.propertiesUtil, new ConnectionUtil(this), new AuthenticationUtil(), new GitUtil(this), new HeaderUtil(this), new ParameterUtil(this), new ExceptionUtil(this), new SoapUtil(this), new MultipartUtil(this), new CookiesUtil(this), new JsonUtil(this), new PreferencesUtil(), new ProxyUtil(), new ThreadUtil(this), new TamperingUtil(), new UserAgentUtil(), new CsrfUtil(this), new DigestUtil(this), new FormUtil(this), new CertificateUtil());
    }

    public void resetModel() {
        this.mediatorStrategy.getTime().setApplicable(false);
        this.mediatorStrategy.getBlindBin().setApplicable(false);
        this.mediatorStrategy.getBlindBit().setApplicable(false);
        this.mediatorStrategy.getMultibit().setApplicable(false);
        this.mediatorStrategy.getDns().setApplicable(false);
        this.mediatorStrategy.getError().setApplicable(false);
        this.mediatorStrategy.getStack().setApplicable(false);
        this.mediatorStrategy.getUnion().setApplicable(false);
        this.mediatorStrategy.setStrategy(null);
        this.mediatorStrategy.getSpecificUnion().setVisibleIndex(null);
        this.mediatorStrategy.getSpecificUnion().setIndexesInUrl("");
        this.analysisReport = "";
        this.isStoppedByUser = false;
        this.shouldErasePreviousInjection = false;
        this.mediatorUtils.csrfUtil().setTokenCsrf(null);
        this.mediatorUtils.digestUtil().setTokenDigest(null);
        this.mediatorUtils.threadUtil().reset();
    }

    public void beginInjection() {
        this.resetModel();
        try {
            if (this.mediatorUtils.proxyUtil().isNotLive(GitUtil.ShowOnConsole.YES)) {
                return;
            }
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{}: {}", () -> I18nUtil.valueByKey("LOG_START_INJECTION"), () -> this.mediatorUtils.connectionUtil().getUrlByUser());
            this.mediatorUtils.parameterUtil().checkParametersFormat();
            this.mediatorUtils.connectionUtil().testConnection();
            boolean hasFoundInjection = this.mediatorMethod.getQuery().testParameters(false);
            hasFoundInjection = this.mediatorUtils.multipartUtil().testParameters(hasFoundInjection);
            hasFoundInjection = this.mediatorUtils.soapUtil().testParameters(hasFoundInjection);
            hasFoundInjection = this.mediatorMethod.getRequest().testParameters(hasFoundInjection);
            hasFoundInjection = this.mediatorMethod.getHeader().testParameters(hasFoundInjection);
            hasFoundInjection = this.mediatorUtils.cookiesUtil().testParameters(hasFoundInjection);
            if (hasFoundInjection && !this.isScanning) {
                if (!this.getMediatorUtils().preferencesUtil().isNotShowingVulnReport()) {
                    this.sendToViews(new Seal.CreateAnalysisReport(this.analysisReport));
                }
                if (this.getMediatorUtils().preferencesUtil().isZipStrategy()) {
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using Zip mode for reduced query size");
                } else if (this.getMediatorUtils().preferencesUtil().isDiosStrategy()) {
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Using Dump In One Shot strategy for single query dump");
                }
                if (!this.mediatorUtils.preferencesUtil().isNotInjectingMetadata()) {
                    this.dataAccess.getDatabaseInfos();
                }
                this.dataAccess.listDatabases();
            }
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_DONE"));
            this.shouldErasePreviousInjection = hasFoundInjection;
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (JSqlException | JSqlRuntimeException | IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Interruption: {}", (Object)(e.getMessage() == null ? InjectionModel.getImplicitReason(e) : e.getMessage()));
        }
        finally {
            this.sendToViews(new Seal.EndPreparation());
        }
    }

    public static String getImplicitReason(Throwable e) {
        Object message = e.getClass().getSimpleName();
        if (e.getMessage() != null) {
            message = (String)message + ": " + e.getMessage();
        }
        if (e.getCause() != null && !e.equals(e.getCause())) {
            message = (String)message + " > " + InjectionModel.getImplicitReason(e.getCause());
        }
        return message;
    }

    @Override
    public String inject(String dataInjection, boolean isUsingIndex, String metadataInjectionProcess, AbstractCallableBit<?> callableBoolean, boolean isReport) {
        URL urlObject;
        String urlInjectionFixed;
        String urlInjection = this.mediatorUtils.connectionUtil().getUrlBase();
        urlInjection = this.mediatorStrategy.buildPath(urlInjection, isUsingIndex, dataInjection);
        urlInjection = StringUtil.cleanSql(urlInjection.trim());
        try {
            urlInjectionFixed = this.initQueryString(isUsingIndex, urlInjection, dataInjection);
            urlObject = new URI(urlInjectionFixed).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect Query Url: {}", (Object)e.getMessage());
            return "";
        }
        String pageSource = "";
        try {
            HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(URI.create(urlObject.toString())).setHeader("Content-Type", "text/plain").timeout(Duration.ofSeconds(15L));
            this.mediatorUtils.csrfUtil().addHeaderToken(httpRequestBuilder);
            this.mediatorUtils.digestUtil().addHeaderToken(httpRequestBuilder);
            this.mediatorUtils.connectionUtil().setCustomUserAgent(httpRequestBuilder);
            String body = this.initRequest(isUsingIndex, dataInjection, httpRequestBuilder);
            this.initHeader(isUsingIndex, dataInjection, httpRequestBuilder);
            HttpRequest httpRequest = httpRequestBuilder.build();
            if (isReport) {
                Color colorReport = UIManager.getColor("TextArea.inactiveForeground");
                String report = BR + StringUtil.formatReport(colorReport, "Method: ") + httpRequest.method();
                report = report + BR + StringUtil.formatReport(colorReport, "Path: ") + httpRequest.uri().getPath();
                if (httpRequest.uri().getQuery() != null) {
                    report = report + BR + StringUtil.formatReport(colorReport, "Query: ") + httpRequest.uri().getQuery();
                }
                if (!this.mediatorUtils.parameterUtil().getListRequest().isEmpty() || this.mediatorUtils.csrfUtil().getTokenCsrf() != null) {
                    report = report + BR + StringUtil.formatReport(colorReport, "Body: ") + body;
                }
                report = report + BR + StringUtil.formatReport(colorReport, "Header: ") + httpRequest.headers().map().entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), String.join((CharSequence)"", (Iterable)entry.getValue()))).collect(Collectors.joining(BR));
                return report;
            }
            HttpResponse<String> response = this.getMediatorUtils().connectionUtil().getHttpClient().build().send(httpRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            if (this.mediatorUtils.parameterUtil().isRequestSoap()) {
                pageSource = URLDecoder.decode(response.body(), StandardCharsets.UTF_8);
                pageSource = StringUtil.fromHtml(pageSource);
            } else {
                pageSource = response.body();
            }
            Map<String, String> headersResponse = ConnectionUtil.getHeadersMap(response);
            int sizeHeaders = headersResponse.keySet().stream().map(key -> ((String)headersResponse.get(key)).length() + key.length()).mapToInt(Integer::intValue).sum();
            float size = (float)(pageSource.length() + sizeHeaders) / 1024.0f;
            DecimalFormat decimalFormat = new DecimalFormat("0.000");
            String pageSourceFixed = pageSource.replaceAll("(a){60,}", "$1...").replaceAll("(jIyM){60,}", "$1...");
            this.sendToViews(new Seal.MessageHeader(urlInjectionFixed, body, ConnectionUtil.getHeadersMap(httpRequest.headers()), headersResponse, pageSourceFixed, decimalFormat.format(size), this.mediatorStrategy.getMeta(), metadataInjectionProcess, callableBoolean));
        }
        catch (IOException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Error during connection: {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return pageSource;
    }

    private String initQueryString(boolean isUsingIndex, String urlInjection, String dataInjection) {
        Object urlInjectionFixed = urlInjection;
        if (this.mediatorUtils.parameterUtil().getListQueryString().isEmpty() && !this.mediatorUtils.preferencesUtil().isProcessingCsrf()) {
            return urlInjectionFixed;
        }
        if (!((String)urlInjectionFixed).contains("?")) {
            urlInjectionFixed = (String)urlInjectionFixed + "?";
        }
        urlInjectionFixed = (String)urlInjectionFixed + this.buildQuery(this.mediatorMethod.getQuery(), this.mediatorUtils.parameterUtil().getQueryStringFromEntries(), isUsingIndex, dataInjection);
        return this.mediatorUtils.csrfUtil().addQueryStringToken((String)urlInjectionFixed);
    }

    private void initHeader(boolean isUsingIndex, String dataInjection, HttpRequest.Builder httpRequest) {
        if (!this.mediatorUtils.parameterUtil().getListHeader().isEmpty()) {
            Stream.of(this.buildQuery(this.mediatorMethod.getHeader(), this.mediatorUtils.parameterUtil().getHeaderFromEntries(), isUsingIndex, dataInjection).split("\\\\r\\\\n")).forEach(header -> {
                if (header.split(":").length == 2) {
                    try {
                        HeaderUtil.sanitizeHeaders(httpRequest, new AbstractMap.SimpleEntry<String, String>(header.split(":")[0], header.split(":")[1]));
                    }
                    catch (JSqlException e) {
                        LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Headers sanitizing issue caught already during connection, ignoring", (Throwable)e);
                    }
                }
            });
        }
    }

    private String initRequest(boolean isUsingIndex, String dataInjection, HttpRequest.Builder httpRequest) {
        if (this.mediatorUtils.parameterUtil().getListRequest().isEmpty() && this.mediatorUtils.csrfUtil().getTokenCsrf() == null) {
            return dataInjection;
        }
        if (this.mediatorUtils.parameterUtil().isRequestSoap()) {
            httpRequest.setHeader("Content-Type", "text/xml");
        } else {
            httpRequest.setHeader("Content-Type", "application/x-www-form-urlencoded");
        }
        StringBuilder body = new StringBuilder();
        this.mediatorUtils.csrfUtil().addRequestToken(body);
        if (this.mediatorUtils.connectionUtil().getTypeRequest().matches("PUT|POST")) {
            if (this.mediatorUtils.parameterUtil().isRequestSoap()) {
                body.append(this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.parameterUtil().getRawRequest(), isUsingIndex, dataInjection).replace("\u0001", "&#01;").replace("\u0003", "&#03;").replace("\u0004", "&#04;").replace("\u0005", "&#05;").replace("\u0006", "&#06;").replace("\u0007", "&#07;").replace("+", "%2B"));
            } else {
                body.append(this.buildQuery(this.mediatorMethod.getRequest(), this.mediatorUtils.parameterUtil().getRequestFromEntries(), isUsingIndex, dataInjection));
            }
        }
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(body.toString());
        httpRequest.method(this.mediatorUtils.connectionUtil().getTypeRequest(), bodyPublisher);
        return body.toString();
    }

    private String buildQuery(AbstractMethodInjection methodInjection, String paramLead, boolean isUsingIndex, String sqlTrail) {
        String paramLeadFixed = paramLead.replace(STAR, "<tampering>*</tampering>");
        String query = this.mediatorUtils.connectionUtil().getMethodInjection() != methodInjection || this.mediatorUtils.connectionUtil().getUrlBase().contains(STAR) ? paramLeadFixed : (paramLeadFixed.contains(STAR) ? this.initStarInjection(paramLeadFixed, isUsingIndex, sqlTrail) : this.initRawInjection(paramLeadFixed, isUsingIndex, sqlTrail));
        query = this.cleanQuery(methodInjection, query);
        if (this.mediatorUtils.connectionUtil().getMethodInjection() == methodInjection) {
            query = this.mediatorUtils.tamperingUtil().tamper(query);
        }
        return this.applyEncoding(methodInjection, query);
    }

    private String initRawInjection(String paramLead, boolean isUsingIndex, String sqlTrail) {
        String query = !isUsingIndex ? paramLead + sqlTrail : paramLead + this.getMediatorStrategy().getSpecificUnion().getIndexesInUrl().replaceAll(String.format("1337%s7331", this.mediatorStrategy.getSpecificUnion().getVisibleIndex()), Matcher.quoteReplacement(sqlTrail));
        return query + this.mediatorEngine.getEngine().instance().endingComment();
    }

    private String initStarInjection(String paramLead, boolean isUsingIndex, String sqlTrail) {
        String query = !isUsingIndex ? paramLead.replace(STAR, sqlTrail + this.mediatorEngine.getEngine().instance().endingComment()) : paramLead.replace(STAR, this.mediatorStrategy.getSpecificUnion().getIndexesInUrl().replace(String.format("1337%s7331", this.mediatorStrategy.getSpecificUnion().getVisibleIndex()), sqlTrail) + this.mediatorEngine.getEngine().instance().endingComment());
        return query;
    }

    private String cleanQuery(AbstractMethodInjection methodInjection, String query) {
        String queryFixed = query;
        if (methodInjection == this.mediatorMethod.getRequest() && (this.mediatorUtils.parameterUtil().isRequestSoap() || this.mediatorUtils.parameterUtil().isMultipartRequest())) {
            queryFixed = StringUtil.removeSqlComment(queryFixed).replace("+", " ").replace("%2b", "+").replace("%23", "#");
            if (this.mediatorUtils.parameterUtil().isMultipartRequest()) {
                queryFixed = queryFixed.replaceAll("(?s)\\\\n", "\r\n");
            }
        } else {
            queryFixed = StringUtil.cleanSql(queryFixed);
        }
        return queryFixed;
    }

    private String applyEncoding(AbstractMethodInjection methodInjection, String query) {
        String queryFixed = query;
        if (!this.mediatorUtils.parameterUtil().isRequestSoap()) {
            if (methodInjection == this.mediatorMethod.getQuery()) {
                if (!this.mediatorUtils.preferencesUtil().isUrlEncodingDisabled()) {
                    queryFixed = queryFixed.replace("'", "%27");
                    queryFixed = queryFixed.replace("(", "%28");
                    queryFixed = queryFixed.replace(")", "%29");
                    queryFixed = queryFixed.replace("{", "%7b");
                    queryFixed = queryFixed.replace("[", "%5b");
                    queryFixed = queryFixed.replace("]", "%5d");
                    queryFixed = queryFixed.replace("}", "%7d");
                    queryFixed = queryFixed.replace(">", "%3e");
                    queryFixed = queryFixed.replace("<", "%3c");
                    queryFixed = queryFixed.replace("?", "%3f");
                    queryFixed = queryFixed.replace("_", "%5f");
                    queryFixed = queryFixed.replace(",", "%2c");
                }
                queryFixed = queryFixed.replace(" ", "+");
                queryFixed = queryFixed.replace("`", "%60");
                queryFixed = queryFixed.replace("\"", "%22");
                queryFixed = queryFixed.replace("|", "%7c");
                queryFixed = queryFixed.replace("\\", "%5c");
            } else if (methodInjection != this.mediatorMethod.getRequest()) {
                queryFixed = queryFixed.replace("+", "%20");
                queryFixed = queryFixed.replace(",", "%2c");
                try {
                    queryFixed = URLDecoder.decode(queryFixed, StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect values in [{}], please check the parameters", (Object)methodInjection.name());
                    throw new JSqlRuntimeException(e);
                }
            }
        }
        return queryFixed;
    }

    public void sendResponseFromSite(String message, String source) {
        LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{}, response from site:", (Object)message);
        LOGGER.log(LogLevelUtil.CONSOLE_ERROR, ">>>{}", (Object)source);
    }

    public boolean shouldErasePreviousInjection() {
        return this.shouldErasePreviousInjection;
    }

    public void setIsScanning(boolean isScanning) {
        this.isScanning = isScanning;
    }

    public PropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    public MediatorUtils getMediatorUtils() {
        return this.mediatorUtils;
    }

    public MediatorEngine getMediatorEngine() {
        return this.mediatorEngine;
    }

    public MediatorMethod getMediatorMethod() {
        return this.mediatorMethod;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public ResourceAccess getResourceAccess() {
        return this.resourceAccess;
    }

    public MediatorStrategy getMediatorStrategy() {
        return this.mediatorStrategy;
    }

    public void appendAnalysisReport(String analysisReport) {
        this.appendAnalysisReport(analysisReport, false);
    }

    public void appendAnalysisReport(String analysisReport, boolean isInit) {
        this.analysisReport = this.analysisReport + (isInit ? "" : "<br>&#10;<br>&#10;") + analysisReport;
    }
}

