/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.scan.ScanListTerminal;
import com.jsql.view.swing.list.BeanInjection;
import com.jsql.view.swing.list.DnDListScan;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.list.ItemListScan;
import com.jsql.view.swing.list.ListTransfertHandlerScan;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class ManagerScan
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String NAME = "listManagerScan";

    public ManagerScan() {
        super("swing/list/scan-page.json");
        this.listPaths.setTransferHandler(null);
        this.listPaths.setTransferHandler(new ListTransfertHandlerScan());
        this.listPaths.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ItemList itemList = (ItemList)value;
                if (itemList.isVulnerable()) {
                    label.setIcon(UiUtil.TICK_GREEN.getIcon());
                }
                return label;
            }
        });
        this.listPaths.setName(NAME);
        JPanel lastLine = this.getLastLinePanel();
        this.add((Component)lastLine, "South");
        this.listPaths.addListSelectionListener(e -> {
            if (this.listPaths.getSelectedValue() == null) {
                return;
            }
            BeanInjection beanInjection = ((ItemListScan)this.listPaths.getSelectedValue()).getBeanInjection();
            MediatorHelper.panelAddressBar().getTextFieldAddress().setText(beanInjection.getUrl());
            MediatorHelper.panelAddressBar().getTextFieldHeader().setText(beanInjection.getHeader());
            MediatorHelper.panelAddressBar().getTextFieldRequest().setText(beanInjection.getRequest());
            String requestType = beanInjection.getRequestType();
            if (requestType != null && !requestType.isEmpty()) {
                MediatorHelper.panelAddressBar().getAtomicRadioMethod().setText(requestType);
            } else {
                MediatorHelper.panelAddressBar().getAtomicRadioMethod().setText("GET");
            }
            AbstractMethodInjection method = beanInjection.getMethodInstance();
            if (method == MediatorHelper.model().getMediatorMethod().getHeader()) {
                MediatorHelper.panelAddressBar().getAtomicRadioHeader().setSelected(true);
            } else if (method == MediatorHelper.model().getMediatorMethod().getRequest()) {
                MediatorHelper.panelAddressBar().getAtomicRadioMethod().setSelected(true);
            } else {
                MediatorHelper.panelAddressBar().getAtomicRadioRequest().setSelected(true);
            }
        });
    }

    @Override
    public void buildList(String nameFile) {
        StringBuilder jsonScan = new StringBuilder();
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream(nameFile);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(inputStream), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonScan.append(line);
            }
            JSONArray jsonArrayScan = new JSONArray(jsonScan.toString());
            for (int i = 0; i < jsonArrayScan.length(); ++i) {
                this.itemsList.add(new ItemListScan(jsonArrayScan.getJSONObject(i)));
            }
            this.listPaths = new DnDListScan(this.itemsList);
        }
        catch (IOException | JSONException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private JPanel getLastLinePanel() {
        JPanel lastLine = new JPanel();
        lastLine.setOpaque(false);
        lastLine.setLayout(new BoxLayout(lastLine, 0));
        this.buildRunButton("SCAN_RUN_BUTTON_LABEL", "SCAN_RUN_BUTTON_TOOLTIP");
        this.run.addActionListener(new ActionScan());
        lastLine.add(this.horizontalGlue);
        lastLine.add(this.progressBar);
        lastLine.add(this.run);
        return lastLine;
    }

    public void scan(List<ItemList> urlsItemList) {
        MediatorHelper.frame().resetInterface();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Request requestUnsubscribe = new Request();
        requestUnsubscribe.setMessage(Interaction.UNSUBSCRIBE);
        MediatorHelper.model().sendToViews(requestUnsubscribe);
        MediatorHelper.model().subscribe(new ScanListTerminal());
        MediatorHelper.model().setIsScanning(true);
        MediatorHelper.model().getResourceAccess().setScanStopped(false);
        for (ItemList urlItemList : urlsItemList) {
            if (MediatorHelper.model().isStoppedByUser() || MediatorHelper.model().getResourceAccess().isScanStopped()) break;
            ItemListScan urlItemListScan = (ItemListScan)urlItemList;
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Scanning {}", (Object)urlItemListScan.getBeanInjection().getUrl());
            Optional<Vendor> optionalVendor = MediatorHelper.model().getMediatorVendor().getVendors().stream().filter(vendor -> vendor.toString().equalsIgnoreCase(urlItemListScan.getBeanInjection().getVendor())).findAny();
            MediatorHelper.model().getMediatorVendor().setVendorByUser(optionalVendor.orElse(MediatorHelper.model().getMediatorVendor().getAuto()));
            MediatorHelper.model().getMediatorUtils().getParameterUtil().controlInput(urlItemListScan.getBeanInjection().getUrl(), urlItemListScan.getBeanInjection().getRequest(), urlItemListScan.getBeanInjection().getHeader(), urlItemListScan.getBeanInjection().getMethodInstance(), urlItemListScan.getBeanInjection().getRequestType(), true);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        MediatorHelper.model().sendToViews(requestUnsubscribe);
        MediatorHelper.model().subscribe(MediatorHelper.frame().getSubscriber());
        MediatorHelper.model().setIsScanning(false);
        MediatorHelper.model().setIsStoppedByUser(false);
        MediatorHelper.model().getResourceAccess().setScanStopped(false);
        this.endProcess();
    }

    private class ActionScan
    implements ActionListener {
        private ActionScan() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ManagerScan.this.listPaths.getSelectedValuesList().isEmpty()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Select URL(s) to scan");
                return;
            }
            new Thread(() -> {
                if (ManagerScan.this.run.getState() == StateButton.STARTABLE) {
                    ManagerScan.this.run.setText(I18nViewUtil.valueByKey("SCAN_RUN_BUTTON_STOP"));
                    ManagerScan.this.run.setState(StateButton.STOPPABLE);
                    ManagerScan.this.progressBar.setVisible(true);
                    ManagerScan.this.horizontalGlue.setVisible(false);
                    DefaultListModel listModel = (DefaultListModel)ManagerScan.this.listPaths.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        ((ItemList)listModel.get(i)).reset();
                    }
                    ManagerScan.this.scan(ManagerScan.this.listPaths.getSelectedValuesList());
                } else {
                    MediatorHelper.model().getResourceAccess().setScanStopped(true);
                    MediatorHelper.model().setIsStoppedByUser(true);
                    ManagerScan.this.run.setEnabled(false);
                    ManagerScan.this.run.setState(StateButton.STOPPING);
                }
            }, "ThreadScan").start();
        }
    }
}

