/* Capstone Disassembly Engine, http://www.capstone-engine.org */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2022, */
/*    Rot127 <unisono@quyllur.org> 2022-2023 */
/* Automatically translated source file from LLVM. */

/* LLVM-commit: <commit> */
/* LLVM-tag: <tag> */

/* Only small edits allowed. */
/* For multiple similar edits, please create a Patch for the translator. */

/* Capstone's C++ file translator: */
/* https://github.com/capstone-engine/capstone/tree/next/suite/auto-sync */

//===- ARCInstPrinter.h - Convert ARC MCInst to assembly syntax -*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
///
/// \file
/// This file contains the declaration of the ARCInstPrinter class,
/// which is used to print ARC MCInst to a .s file.
///
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_ARC_INSTPRINTER_ARCINSTPRINTER_H
#define LLVM_LIB_TARGET_ARC_INSTPRINTER_ARCINSTPRINTER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <capstone/platform.h>

#include "../../SStream.h"
#include "../../MCInst.h"

#define CONCAT(a, b) CONCAT_(a, b)
#define CONCAT_(a, b) a##_##b

// Autogenerated by tblgen.
static void printInstruction(MCInst *MI, uint64_t Address, SStream *O);
static void printRegName(SStream *OS, MCRegister Reg);
static void printInst(MCInst *MI, uint64_t Address, const char *Annot,
		      SStream *O);
static void printCCOperand(MCInst *MI, int OpNum, SStream *O);
static void printU6(MCInst *MI, int OpNum, SStream *O);
static void printMemOperandRI(MCInst *MI, unsigned OpNum, SStream *O);
static void printOperand(MCInst *MI, unsigned OpNum, SStream *O);
static void printOperandAddr(MCInst *MI, uint64_t Address, unsigned OpNum,
			     SStream *O);
static void printPredicateOperand(MCInst *MI, unsigned OpNum, SStream *O);
static void printBRCCPredicateOperand(MCInst *MI, unsigned OpNum, SStream *O);
static void printU6ShiftedBy(unsigned ShiftBy, MCInst *MI, int OpNum,
			     SStream *O);
;
// end namespace llvm

#endif // LLVM_LIB_TARGET_ARC_INSTPRINTER_ARCINSTPRINTER_H
