find_path(PANGOCAIRO_INCLUDE_DIR pango/pangocairo.h PATH_SUFFIXES pango-1.0)
find_path(GLIB_INCLUDE_DIR glib.h PATH_SUFFIXES glib-2.0)
find_path(GLIBCONFIG_INCLUDE_DIR glibconfig.h PATH_SUFFIXES glib-2.0/include)

find_library(GLIB_LIBRARY NAMES glib-2.0)
find_library(GOBJECT_LIBRARY NAMES gobject-2.0)
find_library(PANGO_LIBRARY NAMES pango-1.0)
find_library(PANGOCAIRO_LIBRARY NAMES pangocairo-1.0)

find_file(GLIB_RUNTIME_LIBRARY NAMES glib-2.dll)
find_file(GOBJECT_RUNTIME_LIBRARY NAMES gobject-2.dll)
find_file(HARFBUZZ_RUNTIME_LIBRARY NAMES libharfbuzz-0.dll)
find_file(PANGO_RUNTIME_LIBRARY NAMES pango-1.dll)
find_file(PANGOCAIRO_RUNTIME_LIBRARY NAMES pangocairo-1.dll)
find_file(PANGOFT_RUNTIME_LIBRARY NAMES pangoft2-1.dll)
find_file(PANGOWIN_RUNTIME_LIBRARY NAMES pangowin32-1.dll)

include(FindPackageHandleStandardArgs)
if (WIN32)
    find_package_handle_standard_args(PANGOCAIRO DEFAULT_MSG
        GLIB_INCLUDE_DIR
        GLIBCONFIG_INCLUDE_DIR
        PANGOCAIRO_INCLUDE_DIR

        GLIB_LIBRARY
        GOBJECT_LIBRARY
        PANGO_LIBRARY
        PANGOCAIRO_LIBRARY

        GLIB_RUNTIME_LIBRARY
        GOBJECT_RUNTIME_LIBRARY
        HARFBUZZ_RUNTIME_LIBRARY
        PANGO_RUNTIME_LIBRARY
        PANGOCAIRO_RUNTIME_LIBRARY
        PANGOFT_RUNTIME_LIBRARY
        PANGOWIN_RUNTIME_LIBRARY
    )
else()
    find_package_handle_standard_args(PANGOCAIRO DEFAULT_MSG
        GLIB_INCLUDE_DIR
        GLIBCONFIG_INCLUDE_DIR
        PANGOCAIRO_INCLUDE_DIR

        GLIB_LIBRARY
        GOBJECT_LIBRARY
        PANGO_LIBRARY
        PANGOCAIRO_LIBRARY
    )
endif()

mark_as_advanced(
    GLIB_INCLUDE_DIR
    GLIBCONFIG_INCLUDE_DIR
    PANGOCAIRO_INCLUDE_DIR

    GLIB_LIBRARY
    GOBJECT_LIBRARY
    PANGO_LIBRARY
    PANGOCAIRO_LIBRARY

    GLIB_RUNTIME_LIBRARY
    GOBJECT_RUNTIME_LIBRARY
    HARFBUZZ_RUNTIME_LIBRARY
    PANGO_RUNTIME_LIBRARY
    PANGOCAIRO_RUNTIME_LIBRARY
    PANGOFT_RUNTIME_LIBRARY
    PANGOWIN_RUNTIME_LIBRARY
)

set(PANGOCAIRO_INCLUDE_DIRS
    ${GLIB_INCLUDE_DIR}
    ${GLIBCONFIG_INCLUDE_DIR}
    ${PANGOCAIRO_INCLUDE_DIR}
)

set(PANGOCAIRO_LIBRARIES
    ${GLIB_LIBRARY}
    ${GOBJECT_LIBRARY}
    ${PANGO_LIBRARY}
    ${PANGOCAIRO_LIBRARY}
)

set(PANGOCAIRO_RUNTIME_LIBRARIES
    ${GLIB_RUNTIME_LIBRARY}
    ${GOBJECT_RUNTIME_LIBRARY}
    ${HARFBUZZ_RUNTIME_LIBRARY}
    ${PANGO_RUNTIME_LIBRARY}
    ${PANGOCAIRO_RUNTIME_LIBRARY}
    ${PANGOFT_RUNTIME_LIBRARY}
    ${PANGOWIN_RUNTIME_LIBRARY}
)
