#!/bin/bash

echo -e '// Code generated by "go generate gonum.org/v1/gonum/stat/card"; DO NOT EDIT.\n' > hll64.go
< hll32.go cat \
| gofmt -r 'HyperLogLog32 -> HyperLogLog64' \
| gofmt -r 'Hash32 -> Hash64' \
| gofmt -r 'Sum32 -> Sum64' \
| gofmt -r 'rho32 -> rho64' \
| gofmt -r 'uint32 -> uint64' \
| gofmt -r 'bits.LeadingZeros32 -> bits.LeadingZeros64' \
\
| sed \
	-e 's/\[4, 32\]/[4, 64]/' \
	-e 's/rho32/rho64/' \
	-e 's/HyperLogLog32/HyperLogLog64/g' \
	-e 's/Hash32/Hash64/' \
	-e 's/hash32/hash64/' \
	-e 's/w32/w64/g' \
>> hll64.go