#define EMOJI_SEQUENCE_LENGTH 10
struct EmojiCharacter
{
  const gunichar uc[10];
  int length;
  const char *name;
};
#define EMOJI_CHARACTER_COUNT 3781
static const struct EmojiCharacter emoji_characters[3781] =
  {
    { { 0x23, 0xFE0F, 0x20E3 }, 3, "KEYCAP: #" },
    { { 0x2A, 0xFE0F, 0x20E3 }, 3, "KEYCAP: *" },
    { { 0x30, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 0" },
    { { 0x31, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 1" },
    { { 0x32, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 2" },
    { { 0x33, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 3" },
    { { 0x34, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 4" },
    { { 0x35, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 5" },
    { { 0x36, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 6" },
    { { 0x37, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 7" },
    { { 0x38, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 8" },
    { { 0x39, 0xFE0F, 0x20E3 }, 3, "KEYCAP: 9" },
    { { 0xA9, 0xFE0F }, 2, "COPYRIGHT" },
    { { 0xAE, 0xFE0F }, 2, "REGISTERED" },
    { { 0x203C, 0xFE0F }, 2, "DOUBLE EXCLAMATION MARK" },
    { { 0x2049, 0xFE0F }, 2, "EXCLAMATION QUESTION MARK" },
    { { 0x2122, 0xFE0F }, 2, "TRADE MARK" },
    { { 0x2139, 0xFE0F }, 2, "INFORMATION" },
    { { 0x2194, 0xFE0F }, 2, "LEFT-RIGHT ARROW" },
    { { 0x2195, 0xFE0F }, 2, "UP-DOWN ARROW" },
    { { 0x2196, 0xFE0F }, 2, "UP-LEFT ARROW" },
    { { 0x2197, 0xFE0F }, 2, "UP-RIGHT ARROW" },
    { { 0x2198, 0xFE0F }, 2, "DOWN-RIGHT ARROW" },
    { { 0x2199, 0xFE0F }, 2, "DOWN-LEFT ARROW" },
    { { 0x21A9, 0xFE0F }, 2, "RIGHT ARROW CURVING LEFT" },
    { { 0x21AA, 0xFE0F }, 2, "LEFT ARROW CURVING RIGHT" },
    { { 0x231A }, 1, "WATCH" },
    { { 0x231B }, 1, "HOURGLASS DONE" },
    { { 0x2328, 0xFE0F }, 2, "KEYBOARD" },
    { { 0x23CF, 0xFE0F }, 2, "EJECT BUTTON" },
    { { 0x23E9 }, 1, "FAST-FORWARD BUTTON" },
    { { 0x23EA }, 1, "FAST REVERSE BUTTON" },
    { { 0x23EB }, 1, "FAST UP BUTTON" },
    { { 0x23EC }, 1, "FAST DOWN BUTTON" },
    { { 0x23ED, 0xFE0F }, 2, "NEXT TRACK BUTTON" },
    { { 0x23EE, 0xFE0F }, 2, "LAST TRACK BUTTON" },
    { { 0x23EF, 0xFE0F }, 2, "PLAY OR PAUSE BUTTON" },
    { { 0x23F0 }, 1, "ALARM CLOCK" },
    { { 0x23F1, 0xFE0F }, 2, "STOPWATCH" },
    { { 0x23F2, 0xFE0F }, 2, "TIMER CLOCK" },
    { { 0x23F3 }, 1, "HOURGLASS NOT DONE" },
    { { 0x23F8, 0xFE0F }, 2, "PAUSE BUTTON" },
    { { 0x23F9, 0xFE0F }, 2, "STOP BUTTON" },
    { { 0x23FA, 0xFE0F }, 2, "RECORD BUTTON" },
    { { 0x24C2, 0xFE0F }, 2, "CIRCLED M" },
    { { 0x25AA, 0xFE0F }, 2, "BLACK SMALL SQUARE" },
    { { 0x25AB, 0xFE0F }, 2, "WHITE SMALL SQUARE" },
    { { 0x25B6, 0xFE0F }, 2, "PLAY BUTTON" },
    { { 0x25C0, 0xFE0F }, 2, "REVERSE BUTTON" },
    { { 0x25FB, 0xFE0F }, 2, "WHITE MEDIUM SQUARE" },
    { { 0x25FC, 0xFE0F }, 2, "BLACK MEDIUM SQUARE" },
    { { 0x25FD }, 1, "WHITE MEDIUM-SMALL SQUARE" },
    { { 0x25FE }, 1, "BLACK MEDIUM-SMALL SQUARE" },
    { { 0x2600, 0xFE0F }, 2, "SUN" },
    { { 0x2601, 0xFE0F }, 2, "CLOUD" },
    { { 0x2602, 0xFE0F }, 2, "UMBRELLA" },
    { { 0x2603, 0xFE0F }, 2, "SNOWMAN" },
    { { 0x2604, 0xFE0F }, 2, "COMET" },
    { { 0x260E, 0xFE0F }, 2, "TELEPHONE" },
    { { 0x2611, 0xFE0F }, 2, "CHECK BOX WITH CHECK" },
    { { 0x2614 }, 1, "UMBRELLA WITH RAIN DROPS" },
    { { 0x2615 }, 1, "HOT BEVERAGE" },
    { { 0x2618, 0xFE0F }, 2, "SHAMROCK" },
    { { 0x261D, 0xFE0F }, 2, "INDEX POINTING UP" },
    { { 0x261D, 0x1F3FB }, 2, "INDEX POINTING UP: LIGHT SKIN TONE" },
    { { 0x261D, 0x1F3FC }, 2, "INDEX POINTING UP: MEDIUM-LIGHT SKIN TONE" },
    { { 0x261D, 0x1F3FD }, 2, "INDEX POINTING UP: MEDIUM SKIN TONE" },
    { { 0x261D, 0x1F3FE }, 2, "INDEX POINTING UP: MEDIUM-DARK SKIN TONE" },
    { { 0x261D, 0x1F3FF }, 2, "INDEX POINTING UP: DARK SKIN TONE" },
    { { 0x2620, 0xFE0F }, 2, "SKULL AND CROSSBONES" },
    { { 0x2622, 0xFE0F }, 2, "RADIOACTIVE" },
    { { 0x2623, 0xFE0F }, 2, "BIOHAZARD" },
    { { 0x2626, 0xFE0F }, 2, "ORTHODOX CROSS" },
    { { 0x262A, 0xFE0F }, 2, "STAR AND CRESCENT" },
    { { 0x262E, 0xFE0F }, 2, "PEACE SYMBOL" },
    { { 0x262F, 0xFE0F }, 2, "YIN YANG" },
    { { 0x2638, 0xFE0F }, 2, "WHEEL OF DHARMA" },
    { { 0x2639, 0xFE0F }, 2, "FROWNING FACE" },
    { { 0x263A, 0xFE0F }, 2, "SMILING FACE" },
    { { 0x2640, 0xFE0F }, 2, "FEMALE SIGN" },
    { { 0x2642, 0xFE0F }, 2, "MALE SIGN" },
    { { 0x2648 }, 1, "ARIES" },
    { { 0x2649 }, 1, "TAURUS" },
    { { 0x264A }, 1, "GEMINI" },
    { { 0x264B }, 1, "CANCER" },
    { { 0x264C }, 1, "LEO" },
    { { 0x264D }, 1, "VIRGO" },
    { { 0x264E }, 1, "LIBRA" },
    { { 0x264F }, 1, "SCORPIO" },
    { { 0x2650 }, 1, "SAGITTARIUS" },
    { { 0x2651 }, 1, "CAPRICORN" },
    { { 0x2652 }, 1, "AQUARIUS" },
    { { 0x2653 }, 1, "PISCES" },
    { { 0x265F, 0xFE0F }, 2, "CHESS PAWN" },
    { { 0x2660, 0xFE0F }, 2, "SPADE SUIT" },
    { { 0x2663, 0xFE0F }, 2, "CLUB SUIT" },
    { { 0x2665, 0xFE0F }, 2, "HEART SUIT" },
    { { 0x2666, 0xFE0F }, 2, "DIAMOND SUIT" },
    { { 0x2668, 0xFE0F }, 2, "HOT SPRINGS" },
    { { 0x267B, 0xFE0F }, 2, "RECYCLING SYMBOL" },
    { { 0x267E, 0xFE0F }, 2, "INFINITY" },
    { { 0x267F }, 1, "WHEELCHAIR SYMBOL" },
    { { 0x2692, 0xFE0F }, 2, "HAMMER AND PICK" },
    { { 0x2693 }, 1, "ANCHOR" },
    { { 0x2694, 0xFE0F }, 2, "CROSSED SWORDS" },
    { { 0x2695, 0xFE0F }, 2, "MEDICAL SYMBOL" },
    { { 0x2696, 0xFE0F }, 2, "BALANCE SCALE" },
    { { 0x2697, 0xFE0F }, 2, "ALEMBIC" },
    { { 0x2699, 0xFE0F }, 2, "GEAR" },
    { { 0x269B, 0xFE0F }, 2, "ATOM SYMBOL" },
    { { 0x269C, 0xFE0F }, 2, "FLEUR-DE-LIS" },
    { { 0x26A0, 0xFE0F }, 2, "WARNING" },
    { { 0x26A1 }, 1, "HIGH VOLTAGE" },
    { { 0x26A7, 0xFE0F }, 2, "TRANSGENDER SYMBOL" },
    { { 0x26AA }, 1, "WHITE CIRCLE" },
    { { 0x26AB }, 1, "BLACK CIRCLE" },
    { { 0x26B0, 0xFE0F }, 2, "COFFIN" },
    { { 0x26B1, 0xFE0F }, 2, "FUNERAL URN" },
    { { 0x26BD }, 1, "SOCCER BALL" },
    { { 0x26BE }, 1, "BASEBALL" },
    { { 0x26C4 }, 1, "SNOWMAN WITHOUT SNOW" },
    { { 0x26C5 }, 1, "SUN BEHIND CLOUD" },
    { { 0x26C8, 0xFE0F }, 2, "CLOUD WITH LIGHTNING AND RAIN" },
    { { 0x26CE }, 1, "OPHIUCHUS" },
    { { 0x26CF, 0xFE0F }, 2, "PICK" },
    { { 0x26D1, 0xFE0F }, 2, "RESCUE WORKER’S HELMET" },
    { { 0x26D3, 0xFE0F }, 2, "CHAINS" },
    { { 0x26D3, 0xFE0F, 0x200D, 0x1F4A5 }, 4, "BROKEN CHAIN" },
    { { 0x26D4 }, 1, "NO ENTRY" },
    { { 0x26E9, 0xFE0F }, 2, "SHINTO SHRINE" },
    { { 0x26EA }, 1, "CHURCH" },
    { { 0x26F0, 0xFE0F }, 2, "MOUNTAIN" },
    { { 0x26F1, 0xFE0F }, 2, "UMBRELLA ON GROUND" },
    { { 0x26F2 }, 1, "FOUNTAIN" },
    { { 0x26F3 }, 1, "FLAG IN HOLE" },
    { { 0x26F4, 0xFE0F }, 2, "FERRY" },
    { { 0x26F5 }, 1, "SAILBOAT" },
    { { 0x26F7, 0xFE0F }, 2, "SKIER" },
    { { 0x26F8, 0xFE0F }, 2, "ICE SKATE" },
    { { 0x26F9, 0xFE0F }, 2, "PERSON BOUNCING BALL" },
    { { 0x26F9, 0xFE0F, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL" },
    { { 0x26F9, 0xFE0F, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL" },
    { { 0x26F9, 0x1F3FB }, 2, "PERSON BOUNCING BALL: LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL: LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL: LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FC }, 2, "PERSON BOUNCING BALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x26F9, 0x1F3FD }, 2, "PERSON BOUNCING BALL: MEDIUM SKIN TONE" },
    { { 0x26F9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL: MEDIUM SKIN TONE" },
    { { 0x26F9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL: MEDIUM SKIN TONE" },
    { { 0x26F9, 0x1F3FE }, 2, "PERSON BOUNCING BALL: MEDIUM-DARK SKIN TONE" },
    { { 0x26F9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL: MEDIUM-DARK SKIN TONE" },
    { { 0x26F9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL: MEDIUM-DARK SKIN TONE" },
    { { 0x26F9, 0x1F3FF }, 2, "PERSON BOUNCING BALL: DARK SKIN TONE" },
    { { 0x26F9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOUNCING BALL: DARK SKIN TONE" },
    { { 0x26F9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOUNCING BALL: DARK SKIN TONE" },
    { { 0x26FA }, 1, "TENT" },
    { { 0x26FD }, 1, "FUEL PUMP" },
    { { 0x2702, 0xFE0F }, 2, "SCISSORS" },
    { { 0x2705 }, 1, "CHECK MARK BUTTON" },
    { { 0x2708, 0xFE0F }, 2, "AIRPLANE" },
    { { 0x2709, 0xFE0F }, 2, "ENVELOPE" },
    { { 0x270A }, 1, "RAISED FIST" },
    { { 0x270A, 0x1F3FB }, 2, "RAISED FIST: LIGHT SKIN TONE" },
    { { 0x270A, 0x1F3FC }, 2, "RAISED FIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x270A, 0x1F3FD }, 2, "RAISED FIST: MEDIUM SKIN TONE" },
    { { 0x270A, 0x1F3FE }, 2, "RAISED FIST: MEDIUM-DARK SKIN TONE" },
    { { 0x270A, 0x1F3FF }, 2, "RAISED FIST: DARK SKIN TONE" },
    { { 0x270B }, 1, "RAISED HAND" },
    { { 0x270B, 0x1F3FB }, 2, "RAISED HAND: LIGHT SKIN TONE" },
    { { 0x270B, 0x1F3FC }, 2, "RAISED HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x270B, 0x1F3FD }, 2, "RAISED HAND: MEDIUM SKIN TONE" },
    { { 0x270B, 0x1F3FE }, 2, "RAISED HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x270B, 0x1F3FF }, 2, "RAISED HAND: DARK SKIN TONE" },
    { { 0x270C, 0xFE0F }, 2, "VICTORY HAND" },
    { { 0x270C, 0x1F3FB }, 2, "VICTORY HAND: LIGHT SKIN TONE" },
    { { 0x270C, 0x1F3FC }, 2, "VICTORY HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x270C, 0x1F3FD }, 2, "VICTORY HAND: MEDIUM SKIN TONE" },
    { { 0x270C, 0x1F3FE }, 2, "VICTORY HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x270C, 0x1F3FF }, 2, "VICTORY HAND: DARK SKIN TONE" },
    { { 0x270D, 0xFE0F }, 2, "WRITING HAND" },
    { { 0x270D, 0x1F3FB }, 2, "WRITING HAND: LIGHT SKIN TONE" },
    { { 0x270D, 0x1F3FC }, 2, "WRITING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x270D, 0x1F3FD }, 2, "WRITING HAND: MEDIUM SKIN TONE" },
    { { 0x270D, 0x1F3FE }, 2, "WRITING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x270D, 0x1F3FF }, 2, "WRITING HAND: DARK SKIN TONE" },
    { { 0x270F, 0xFE0F }, 2, "PENCIL" },
    { { 0x2712, 0xFE0F }, 2, "BLACK NIB" },
    { { 0x2714, 0xFE0F }, 2, "CHECK MARK" },
    { { 0x2716, 0xFE0F }, 2, "MULTIPLY" },
    { { 0x271D, 0xFE0F }, 2, "LATIN CROSS" },
    { { 0x2721, 0xFE0F }, 2, "STAR OF DAVID" },
    { { 0x2728 }, 1, "SPARKLES" },
    { { 0x2733, 0xFE0F }, 2, "EIGHT-SPOKED ASTERISK" },
    { { 0x2734, 0xFE0F }, 2, "EIGHT-POINTED STAR" },
    { { 0x2744, 0xFE0F }, 2, "SNOWFLAKE" },
    { { 0x2747, 0xFE0F }, 2, "SPARKLE" },
    { { 0x274C }, 1, "CROSS MARK" },
    { { 0x274E }, 1, "CROSS MARK BUTTON" },
    { { 0x2753 }, 1, "RED QUESTION MARK" },
    { { 0x2754 }, 1, "WHITE QUESTION MARK" },
    { { 0x2755 }, 1, "WHITE EXCLAMATION MARK" },
    { { 0x2757 }, 1, "RED EXCLAMATION MARK" },
    { { 0x2763, 0xFE0F }, 2, "HEART EXCLAMATION" },
    { { 0x2764, 0xFE0F }, 2, "RED HEART" },
    { { 0x2764, 0xFE0F, 0x200D, 0x1F525 }, 4, "HEART ON FIRE" },
    { { 0x2764, 0xFE0F, 0x200D, 0x1FA79 }, 4, "MENDING HEART" },
    { { 0x2795 }, 1, "PLUS" },
    { { 0x2796 }, 1, "MINUS" },
    { { 0x2797 }, 1, "DIVIDE" },
    { { 0x27A1, 0xFE0F }, 2, "RIGHT ARROW" },
    { { 0x27B0 }, 1, "CURLY LOOP" },
    { { 0x27BF }, 1, "DOUBLE CURLY LOOP" },
    { { 0x2934, 0xFE0F }, 2, "RIGHT ARROW CURVING UP" },
    { { 0x2935, 0xFE0F }, 2, "RIGHT ARROW CURVING DOWN" },
    { { 0x2B05, 0xFE0F }, 2, "LEFT ARROW" },
    { { 0x2B06, 0xFE0F }, 2, "UP ARROW" },
    { { 0x2B07, 0xFE0F }, 2, "DOWN ARROW" },
    { { 0x2B1B }, 1, "BLACK LARGE SQUARE" },
    { { 0x2B1C }, 1, "WHITE LARGE SQUARE" },
    { { 0x2B50 }, 1, "STAR" },
    { { 0x2B55 }, 1, "HOLLOW RED CIRCLE" },
    { { 0x3030, 0xFE0F }, 2, "WAVY DASH" },
    { { 0x303D, 0xFE0F }, 2, "PART ALTERNATION MARK" },
    { { 0x3297, 0xFE0F }, 2, "JAPANESE “CONGRATULATIONS” BUTTON" },
    { { 0x3299, 0xFE0F }, 2, "JAPANESE “SECRET” BUTTON" },
    { { 0x1F004 }, 1, "MAHJONG RED DRAGON" },
    { { 0x1F0CF }, 1, "JOKER" },
    { { 0x1F170, 0xFE0F }, 2, "A BUTTON (BLOOD TYPE)" },
    { { 0x1F171, 0xFE0F }, 2, "B BUTTON (BLOOD TYPE)" },
    { { 0x1F17E, 0xFE0F }, 2, "O BUTTON (BLOOD TYPE)" },
    { { 0x1F17F, 0xFE0F }, 2, "P BUTTON" },
    { { 0x1F18E }, 1, "AB BUTTON (BLOOD TYPE)" },
    { { 0x1F191 }, 1, "CL BUTTON" },
    { { 0x1F192 }, 1, "COOL BUTTON" },
    { { 0x1F193 }, 1, "FREE BUTTON" },
    { { 0x1F194 }, 1, "ID BUTTON" },
    { { 0x1F195 }, 1, "NEW BUTTON" },
    { { 0x1F196 }, 1, "NG BUTTON" },
    { { 0x1F197 }, 1, "OK BUTTON" },
    { { 0x1F198 }, 1, "SOS BUTTON" },
    { { 0x1F199 }, 1, "UP! BUTTON" },
    { { 0x1F19A }, 1, "VS BUTTON" },
    { { 0x1F1E6, 0x1F1E8 }, 2, "FLAG: ASCENSION ISLAND" },
    { { 0x1F1E6, 0x1F1E9 }, 2, "FLAG: ANDORRA" },
    { { 0x1F1E6, 0x1F1EA }, 2, "FLAG: UNITED ARAB EMIRATES" },
    { { 0x1F1E6, 0x1F1EB }, 2, "FLAG: AFGHANISTAN" },
    { { 0x1F1E6, 0x1F1EC }, 2, "FLAG: ANTIGUA & BARBUDA" },
    { { 0x1F1E6, 0x1F1EE }, 2, "FLAG: ANGUILLA" },
    { { 0x1F1E6, 0x1F1F1 }, 2, "FLAG: ALBANIA" },
    { { 0x1F1E6, 0x1F1F2 }, 2, "FLAG: ARMENIA" },
    { { 0x1F1E6, 0x1F1F4 }, 2, "FLAG: ANGOLA" },
    { { 0x1F1E6, 0x1F1F6 }, 2, "FLAG: ANTARCTICA" },
    { { 0x1F1E6, 0x1F1F7 }, 2, "FLAG: ARGENTINA" },
    { { 0x1F1E6, 0x1F1F8 }, 2, "FLAG: AMERICAN SAMOA" },
    { { 0x1F1E6, 0x1F1F9 }, 2, "FLAG: AUSTRIA" },
    { { 0x1F1E6, 0x1F1FA }, 2, "FLAG: AUSTRALIA" },
    { { 0x1F1E6, 0x1F1FC }, 2, "FLAG: ARUBA" },
    { { 0x1F1E6, 0x1F1FD }, 2, "FLAG: ÅLAND ISLANDS" },
    { { 0x1F1E6, 0x1F1FF }, 2, "FLAG: AZERBAIJAN" },
    { { 0x1F1E7, 0x1F1E6 }, 2, "FLAG: BOSNIA & HERZEGOVINA" },
    { { 0x1F1E7, 0x1F1E7 }, 2, "FLAG: BARBADOS" },
    { { 0x1F1E7, 0x1F1E9 }, 2, "FLAG: BANGLADESH" },
    { { 0x1F1E7, 0x1F1EA }, 2, "FLAG: BELGIUM" },
    { { 0x1F1E7, 0x1F1EB }, 2, "FLAG: BURKINA FASO" },
    { { 0x1F1E7, 0x1F1EC }, 2, "FLAG: BULGARIA" },
    { { 0x1F1E7, 0x1F1ED }, 2, "FLAG: BAHRAIN" },
    { { 0x1F1E7, 0x1F1EE }, 2, "FLAG: BURUNDI" },
    { { 0x1F1E7, 0x1F1EF }, 2, "FLAG: BENIN" },
    { { 0x1F1E7, 0x1F1F1 }, 2, "FLAG: ST. BARTHÉLEMY" },
    { { 0x1F1E7, 0x1F1F2 }, 2, "FLAG: BERMUDA" },
    { { 0x1F1E7, 0x1F1F3 }, 2, "FLAG: BRUNEI" },
    { { 0x1F1E7, 0x1F1F4 }, 2, "FLAG: BOLIVIA" },
    { { 0x1F1E7, 0x1F1F6 }, 2, "FLAG: CARIBBEAN NETHERLANDS" },
    { { 0x1F1E7, 0x1F1F7 }, 2, "FLAG: BRAZIL" },
    { { 0x1F1E7, 0x1F1F8 }, 2, "FLAG: BAHAMAS" },
    { { 0x1F1E7, 0x1F1F9 }, 2, "FLAG: BHUTAN" },
    { { 0x1F1E7, 0x1F1FB }, 2, "FLAG: BOUVET ISLAND" },
    { { 0x1F1E7, 0x1F1FC }, 2, "FLAG: BOTSWANA" },
    { { 0x1F1E7, 0x1F1FE }, 2, "FLAG: BELARUS" },
    { { 0x1F1E7, 0x1F1FF }, 2, "FLAG: BELIZE" },
    { { 0x1F1E8, 0x1F1E6 }, 2, "FLAG: CANADA" },
    { { 0x1F1E8, 0x1F1E8 }, 2, "FLAG: COCOS (KEELING) ISLANDS" },
    { { 0x1F1E8, 0x1F1E9 }, 2, "FLAG: CONGO - KINSHASA" },
    { { 0x1F1E8, 0x1F1EB }, 2, "FLAG: CENTRAL AFRICAN REPUBLIC" },
    { { 0x1F1E8, 0x1F1EC }, 2, "FLAG: CONGO - BRAZZAVILLE" },
    { { 0x1F1E8, 0x1F1ED }, 2, "FLAG: SWITZERLAND" },
    { { 0x1F1E8, 0x1F1EE }, 2, "FLAG: CÔTE D’IVOIRE" },
    { { 0x1F1E8, 0x1F1F0 }, 2, "FLAG: COOK ISLANDS" },
    { { 0x1F1E8, 0x1F1F1 }, 2, "FLAG: CHILE" },
    { { 0x1F1E8, 0x1F1F2 }, 2, "FLAG: CAMEROON" },
    { { 0x1F1E8, 0x1F1F3 }, 2, "FLAG: CHINA" },
    { { 0x1F1E8, 0x1F1F4 }, 2, "FLAG: COLOMBIA" },
    { { 0x1F1E8, 0x1F1F5 }, 2, "FLAG: CLIPPERTON ISLAND" },
    { { 0x1F1E8, 0x1F1F6 }, 2, "FLAG: SARK" },
    { { 0x1F1E8, 0x1F1F7 }, 2, "FLAG: COSTA RICA" },
    { { 0x1F1E8, 0x1F1FA }, 2, "FLAG: CUBA" },
    { { 0x1F1E8, 0x1F1FB }, 2, "FLAG: CAPE VERDE" },
    { { 0x1F1E8, 0x1F1FC }, 2, "FLAG: CURAÇAO" },
    { { 0x1F1E8, 0x1F1FD }, 2, "FLAG: CHRISTMAS ISLAND" },
    { { 0x1F1E8, 0x1F1FE }, 2, "FLAG: CYPRUS" },
    { { 0x1F1E8, 0x1F1FF }, 2, "FLAG: CZECHIA" },
    { { 0x1F1E9, 0x1F1EA }, 2, "FLAG: GERMANY" },
    { { 0x1F1E9, 0x1F1EC }, 2, "FLAG: DIEGO GARCIA" },
    { { 0x1F1E9, 0x1F1EF }, 2, "FLAG: DJIBOUTI" },
    { { 0x1F1E9, 0x1F1F0 }, 2, "FLAG: DENMARK" },
    { { 0x1F1E9, 0x1F1F2 }, 2, "FLAG: DOMINICA" },
    { { 0x1F1E9, 0x1F1F4 }, 2, "FLAG: DOMINICAN REPUBLIC" },
    { { 0x1F1E9, 0x1F1FF }, 2, "FLAG: ALGERIA" },
    { { 0x1F1EA, 0x1F1E6 }, 2, "FLAG: CEUTA & MELILLA" },
    { { 0x1F1EA, 0x1F1E8 }, 2, "FLAG: ECUADOR" },
    { { 0x1F1EA, 0x1F1EA }, 2, "FLAG: ESTONIA" },
    { { 0x1F1EA, 0x1F1EC }, 2, "FLAG: EGYPT" },
    { { 0x1F1EA, 0x1F1ED }, 2, "FLAG: WESTERN SAHARA" },
    { { 0x1F1EA, 0x1F1F7 }, 2, "FLAG: ERITREA" },
    { { 0x1F1EA, 0x1F1F8 }, 2, "FLAG: SPAIN" },
    { { 0x1F1EA, 0x1F1F9 }, 2, "FLAG: ETHIOPIA" },
    { { 0x1F1EA, 0x1F1FA }, 2, "FLAG: EUROPEAN UNION" },
    { { 0x1F1EB, 0x1F1EE }, 2, "FLAG: FINLAND" },
    { { 0x1F1EB, 0x1F1EF }, 2, "FLAG: FIJI" },
    { { 0x1F1EB, 0x1F1F0 }, 2, "FLAG: FALKLAND ISLANDS" },
    { { 0x1F1EB, 0x1F1F2 }, 2, "FLAG: MICRONESIA" },
    { { 0x1F1EB, 0x1F1F4 }, 2, "FLAG: FAROE ISLANDS" },
    { { 0x1F1EB, 0x1F1F7 }, 2, "FLAG: FRANCE" },
    { { 0x1F1EC, 0x1F1E6 }, 2, "FLAG: GABON" },
    { { 0x1F1EC, 0x1F1E7 }, 2, "FLAG: UNITED KINGDOM" },
    { { 0x1F1EC, 0x1F1E9 }, 2, "FLAG: GRENADA" },
    { { 0x1F1EC, 0x1F1EA }, 2, "FLAG: GEORGIA" },
    { { 0x1F1EC, 0x1F1EB }, 2, "FLAG: FRENCH GUIANA" },
    { { 0x1F1EC, 0x1F1EC }, 2, "FLAG: GUERNSEY" },
    { { 0x1F1EC, 0x1F1ED }, 2, "FLAG: GHANA" },
    { { 0x1F1EC, 0x1F1EE }, 2, "FLAG: GIBRALTAR" },
    { { 0x1F1EC, 0x1F1F1 }, 2, "FLAG: GREENLAND" },
    { { 0x1F1EC, 0x1F1F2 }, 2, "FLAG: GAMBIA" },
    { { 0x1F1EC, 0x1F1F3 }, 2, "FLAG: GUINEA" },
    { { 0x1F1EC, 0x1F1F5 }, 2, "FLAG: GUADELOUPE" },
    { { 0x1F1EC, 0x1F1F6 }, 2, "FLAG: EQUATORIAL GUINEA" },
    { { 0x1F1EC, 0x1F1F7 }, 2, "FLAG: GREECE" },
    { { 0x1F1EC, 0x1F1F8 }, 2, "FLAG: SOUTH GEORGIA & SOUTH SANDWICH ISLANDS" },
    { { 0x1F1EC, 0x1F1F9 }, 2, "FLAG: GUATEMALA" },
    { { 0x1F1EC, 0x1F1FA }, 2, "FLAG: GUAM" },
    { { 0x1F1EC, 0x1F1FC }, 2, "FLAG: GUINEA-BISSAU" },
    { { 0x1F1EC, 0x1F1FE }, 2, "FLAG: GUYANA" },
    { { 0x1F1ED, 0x1F1F0 }, 2, "FLAG: HONG KONG SAR CHINA" },
    { { 0x1F1ED, 0x1F1F2 }, 2, "FLAG: HEARD & MCDONALD ISLANDS" },
    { { 0x1F1ED, 0x1F1F3 }, 2, "FLAG: HONDURAS" },
    { { 0x1F1ED, 0x1F1F7 }, 2, "FLAG: CROATIA" },
    { { 0x1F1ED, 0x1F1F9 }, 2, "FLAG: HAITI" },
    { { 0x1F1ED, 0x1F1FA }, 2, "FLAG: HUNGARY" },
    { { 0x1F1EE, 0x1F1E8 }, 2, "FLAG: CANARY ISLANDS" },
    { { 0x1F1EE, 0x1F1E9 }, 2, "FLAG: INDONESIA" },
    { { 0x1F1EE, 0x1F1EA }, 2, "FLAG: IRELAND" },
    { { 0x1F1EE, 0x1F1F1 }, 2, "FLAG: ISRAEL" },
    { { 0x1F1EE, 0x1F1F2 }, 2, "FLAG: ISLE OF MAN" },
    { { 0x1F1EE, 0x1F1F3 }, 2, "FLAG: INDIA" },
    { { 0x1F1EE, 0x1F1F4 }, 2, "FLAG: BRITISH INDIAN OCEAN TERRITORY" },
    { { 0x1F1EE, 0x1F1F6 }, 2, "FLAG: IRAQ" },
    { { 0x1F1EE, 0x1F1F7 }, 2, "FLAG: IRAN" },
    { { 0x1F1EE, 0x1F1F8 }, 2, "FLAG: ICELAND" },
    { { 0x1F1EE, 0x1F1F9 }, 2, "FLAG: ITALY" },
    { { 0x1F1EF, 0x1F1EA }, 2, "FLAG: JERSEY" },
    { { 0x1F1EF, 0x1F1F2 }, 2, "FLAG: JAMAICA" },
    { { 0x1F1EF, 0x1F1F4 }, 2, "FLAG: JORDAN" },
    { { 0x1F1EF, 0x1F1F5 }, 2, "FLAG: JAPAN" },
    { { 0x1F1F0, 0x1F1EA }, 2, "FLAG: KENYA" },
    { { 0x1F1F0, 0x1F1EC }, 2, "FLAG: KYRGYZSTAN" },
    { { 0x1F1F0, 0x1F1ED }, 2, "FLAG: CAMBODIA" },
    { { 0x1F1F0, 0x1F1EE }, 2, "FLAG: KIRIBATI" },
    { { 0x1F1F0, 0x1F1F2 }, 2, "FLAG: COMOROS" },
    { { 0x1F1F0, 0x1F1F3 }, 2, "FLAG: ST. KITTS & NEVIS" },
    { { 0x1F1F0, 0x1F1F5 }, 2, "FLAG: NORTH KOREA" },
    { { 0x1F1F0, 0x1F1F7 }, 2, "FLAG: SOUTH KOREA" },
    { { 0x1F1F0, 0x1F1FC }, 2, "FLAG: KUWAIT" },
    { { 0x1F1F0, 0x1F1FE }, 2, "FLAG: CAYMAN ISLANDS" },
    { { 0x1F1F0, 0x1F1FF }, 2, "FLAG: KAZAKHSTAN" },
    { { 0x1F1F1, 0x1F1E6 }, 2, "FLAG: LAOS" },
    { { 0x1F1F1, 0x1F1E7 }, 2, "FLAG: LEBANON" },
    { { 0x1F1F1, 0x1F1E8 }, 2, "FLAG: ST. LUCIA" },
    { { 0x1F1F1, 0x1F1EE }, 2, "FLAG: LIECHTENSTEIN" },
    { { 0x1F1F1, 0x1F1F0 }, 2, "FLAG: SRI LANKA" },
    { { 0x1F1F1, 0x1F1F7 }, 2, "FLAG: LIBERIA" },
    { { 0x1F1F1, 0x1F1F8 }, 2, "FLAG: LESOTHO" },
    { { 0x1F1F1, 0x1F1F9 }, 2, "FLAG: LITHUANIA" },
    { { 0x1F1F1, 0x1F1FA }, 2, "FLAG: LUXEMBOURG" },
    { { 0x1F1F1, 0x1F1FB }, 2, "FLAG: LATVIA" },
    { { 0x1F1F1, 0x1F1FE }, 2, "FLAG: LIBYA" },
    { { 0x1F1F2, 0x1F1E6 }, 2, "FLAG: MOROCCO" },
    { { 0x1F1F2, 0x1F1E8 }, 2, "FLAG: MONACO" },
    { { 0x1F1F2, 0x1F1E9 }, 2, "FLAG: MOLDOVA" },
    { { 0x1F1F2, 0x1F1EA }, 2, "FLAG: MONTENEGRO" },
    { { 0x1F1F2, 0x1F1EB }, 2, "FLAG: ST. MARTIN" },
    { { 0x1F1F2, 0x1F1EC }, 2, "FLAG: MADAGASCAR" },
    { { 0x1F1F2, 0x1F1ED }, 2, "FLAG: MARSHALL ISLANDS" },
    { { 0x1F1F2, 0x1F1F0 }, 2, "FLAG: NORTH MACEDONIA" },
    { { 0x1F1F2, 0x1F1F1 }, 2, "FLAG: MALI" },
    { { 0x1F1F2, 0x1F1F2 }, 2, "FLAG: MYANMAR (BURMA)" },
    { { 0x1F1F2, 0x1F1F3 }, 2, "FLAG: MONGOLIA" },
    { { 0x1F1F2, 0x1F1F4 }, 2, "FLAG: MACAO SAR CHINA" },
    { { 0x1F1F2, 0x1F1F5 }, 2, "FLAG: NORTHERN MARIANA ISLANDS" },
    { { 0x1F1F2, 0x1F1F6 }, 2, "FLAG: MARTINIQUE" },
    { { 0x1F1F2, 0x1F1F7 }, 2, "FLAG: MAURITANIA" },
    { { 0x1F1F2, 0x1F1F8 }, 2, "FLAG: MONTSERRAT" },
    { { 0x1F1F2, 0x1F1F9 }, 2, "FLAG: MALTA" },
    { { 0x1F1F2, 0x1F1FA }, 2, "FLAG: MAURITIUS" },
    { { 0x1F1F2, 0x1F1FB }, 2, "FLAG: MALDIVES" },
    { { 0x1F1F2, 0x1F1FC }, 2, "FLAG: MALAWI" },
    { { 0x1F1F2, 0x1F1FD }, 2, "FLAG: MEXICO" },
    { { 0x1F1F2, 0x1F1FE }, 2, "FLAG: MALAYSIA" },
    { { 0x1F1F2, 0x1F1FF }, 2, "FLAG: MOZAMBIQUE" },
    { { 0x1F1F3, 0x1F1E6 }, 2, "FLAG: NAMIBIA" },
    { { 0x1F1F3, 0x1F1E8 }, 2, "FLAG: NEW CALEDONIA" },
    { { 0x1F1F3, 0x1F1EA }, 2, "FLAG: NIGER" },
    { { 0x1F1F3, 0x1F1EB }, 2, "FLAG: NORFOLK ISLAND" },
    { { 0x1F1F3, 0x1F1EC }, 2, "FLAG: NIGERIA" },
    { { 0x1F1F3, 0x1F1EE }, 2, "FLAG: NICARAGUA" },
    { { 0x1F1F3, 0x1F1F1 }, 2, "FLAG: NETHERLANDS" },
    { { 0x1F1F3, 0x1F1F4 }, 2, "FLAG: NORWAY" },
    { { 0x1F1F3, 0x1F1F5 }, 2, "FLAG: NEPAL" },
    { { 0x1F1F3, 0x1F1F7 }, 2, "FLAG: NAURU" },
    { { 0x1F1F3, 0x1F1FA }, 2, "FLAG: NIUE" },
    { { 0x1F1F3, 0x1F1FF }, 2, "FLAG: NEW ZEALAND" },
    { { 0x1F1F4, 0x1F1F2 }, 2, "FLAG: OMAN" },
    { { 0x1F1F5, 0x1F1E6 }, 2, "FLAG: PANAMA" },
    { { 0x1F1F5, 0x1F1EA }, 2, "FLAG: PERU" },
    { { 0x1F1F5, 0x1F1EB }, 2, "FLAG: FRENCH POLYNESIA" },
    { { 0x1F1F5, 0x1F1EC }, 2, "FLAG: PAPUA NEW GUINEA" },
    { { 0x1F1F5, 0x1F1ED }, 2, "FLAG: PHILIPPINES" },
    { { 0x1F1F5, 0x1F1F0 }, 2, "FLAG: PAKISTAN" },
    { { 0x1F1F5, 0x1F1F1 }, 2, "FLAG: POLAND" },
    { { 0x1F1F5, 0x1F1F2 }, 2, "FLAG: ST. PIERRE & MIQUELON" },
    { { 0x1F1F5, 0x1F1F3 }, 2, "FLAG: PITCAIRN ISLANDS" },
    { { 0x1F1F5, 0x1F1F7 }, 2, "FLAG: PUERTO RICO" },
    { { 0x1F1F5, 0x1F1F8 }, 2, "FLAG: PALESTINIAN TERRITORIES" },
    { { 0x1F1F5, 0x1F1F9 }, 2, "FLAG: PORTUGAL" },
    { { 0x1F1F5, 0x1F1FC }, 2, "FLAG: PALAU" },
    { { 0x1F1F5, 0x1F1FE }, 2, "FLAG: PARAGUAY" },
    { { 0x1F1F6, 0x1F1E6 }, 2, "FLAG: QATAR" },
    { { 0x1F1F7, 0x1F1EA }, 2, "FLAG: RÉUNION" },
    { { 0x1F1F7, 0x1F1F4 }, 2, "FLAG: ROMANIA" },
    { { 0x1F1F7, 0x1F1F8 }, 2, "FLAG: SERBIA" },
    { { 0x1F1F7, 0x1F1FA }, 2, "FLAG: RUSSIA" },
    { { 0x1F1F7, 0x1F1FC }, 2, "FLAG: RWANDA" },
    { { 0x1F1F8, 0x1F1E6 }, 2, "FLAG: SAUDI ARABIA" },
    { { 0x1F1F8, 0x1F1E7 }, 2, "FLAG: SOLOMON ISLANDS" },
    { { 0x1F1F8, 0x1F1E8 }, 2, "FLAG: SEYCHELLES" },
    { { 0x1F1F8, 0x1F1E9 }, 2, "FLAG: SUDAN" },
    { { 0x1F1F8, 0x1F1EA }, 2, "FLAG: SWEDEN" },
    { { 0x1F1F8, 0x1F1EC }, 2, "FLAG: SINGAPORE" },
    { { 0x1F1F8, 0x1F1ED }, 2, "FLAG: ST. HELENA" },
    { { 0x1F1F8, 0x1F1EE }, 2, "FLAG: SLOVENIA" },
    { { 0x1F1F8, 0x1F1EF }, 2, "FLAG: SVALBARD & JAN MAYEN" },
    { { 0x1F1F8, 0x1F1F0 }, 2, "FLAG: SLOVAKIA" },
    { { 0x1F1F8, 0x1F1F1 }, 2, "FLAG: SIERRA LEONE" },
    { { 0x1F1F8, 0x1F1F2 }, 2, "FLAG: SAN MARINO" },
    { { 0x1F1F8, 0x1F1F3 }, 2, "FLAG: SENEGAL" },
    { { 0x1F1F8, 0x1F1F4 }, 2, "FLAG: SOMALIA" },
    { { 0x1F1F8, 0x1F1F7 }, 2, "FLAG: SURINAME" },
    { { 0x1F1F8, 0x1F1F8 }, 2, "FLAG: SOUTH SUDAN" },
    { { 0x1F1F8, 0x1F1F9 }, 2, "FLAG: SÃO TOMÉ & PRÍNCIPE" },
    { { 0x1F1F8, 0x1F1FB }, 2, "FLAG: EL SALVADOR" },
    { { 0x1F1F8, 0x1F1FD }, 2, "FLAG: SINT MAARTEN" },
    { { 0x1F1F8, 0x1F1FE }, 2, "FLAG: SYRIA" },
    { { 0x1F1F8, 0x1F1FF }, 2, "FLAG: ESWATINI" },
    { { 0x1F1F9, 0x1F1E6 }, 2, "FLAG: TRISTAN DA CUNHA" },
    { { 0x1F1F9, 0x1F1E8 }, 2, "FLAG: TURKS & CAICOS ISLANDS" },
    { { 0x1F1F9, 0x1F1E9 }, 2, "FLAG: CHAD" },
    { { 0x1F1F9, 0x1F1EB }, 2, "FLAG: FRENCH SOUTHERN TERRITORIES" },
    { { 0x1F1F9, 0x1F1EC }, 2, "FLAG: TOGO" },
    { { 0x1F1F9, 0x1F1ED }, 2, "FLAG: THAILAND" },
    { { 0x1F1F9, 0x1F1EF }, 2, "FLAG: TAJIKISTAN" },
    { { 0x1F1F9, 0x1F1F0 }, 2, "FLAG: TOKELAU" },
    { { 0x1F1F9, 0x1F1F1 }, 2, "FLAG: TIMOR-LESTE" },
    { { 0x1F1F9, 0x1F1F2 }, 2, "FLAG: TURKMENISTAN" },
    { { 0x1F1F9, 0x1F1F3 }, 2, "FLAG: TUNISIA" },
    { { 0x1F1F9, 0x1F1F4 }, 2, "FLAG: TONGA" },
    { { 0x1F1F9, 0x1F1F7 }, 2, "FLAG: TÜRKIYE" },
    { { 0x1F1F9, 0x1F1F9 }, 2, "FLAG: TRINIDAD & TOBAGO" },
    { { 0x1F1F9, 0x1F1FB }, 2, "FLAG: TUVALU" },
    { { 0x1F1F9, 0x1F1FC }, 2, "FLAG: TAIWAN" },
    { { 0x1F1F9, 0x1F1FF }, 2, "FLAG: TANZANIA" },
    { { 0x1F1FA, 0x1F1E6 }, 2, "FLAG: UKRAINE" },
    { { 0x1F1FA, 0x1F1EC }, 2, "FLAG: UGANDA" },
    { { 0x1F1FA, 0x1F1F2 }, 2, "FLAG: U.S. OUTLYING ISLANDS" },
    { { 0x1F1FA, 0x1F1F3 }, 2, "FLAG: UNITED NATIONS" },
    { { 0x1F1FA, 0x1F1F8 }, 2, "FLAG: UNITED STATES" },
    { { 0x1F1FA, 0x1F1FE }, 2, "FLAG: URUGUAY" },
    { { 0x1F1FA, 0x1F1FF }, 2, "FLAG: UZBEKISTAN" },
    { { 0x1F1FB, 0x1F1E6 }, 2, "FLAG: VATICAN CITY" },
    { { 0x1F1FB, 0x1F1E8 }, 2, "FLAG: ST. VINCENT & GRENADINES" },
    { { 0x1F1FB, 0x1F1EA }, 2, "FLAG: VENEZUELA" },
    { { 0x1F1FB, 0x1F1EC }, 2, "FLAG: BRITISH VIRGIN ISLANDS" },
    { { 0x1F1FB, 0x1F1EE }, 2, "FLAG: U.S. VIRGIN ISLANDS" },
    { { 0x1F1FB, 0x1F1F3 }, 2, "FLAG: VIETNAM" },
    { { 0x1F1FB, 0x1F1FA }, 2, "FLAG: VANUATU" },
    { { 0x1F1FC, 0x1F1EB }, 2, "FLAG: WALLIS & FUTUNA" },
    { { 0x1F1FC, 0x1F1F8 }, 2, "FLAG: SAMOA" },
    { { 0x1F1FD, 0x1F1F0 }, 2, "FLAG: KOSOVO" },
    { { 0x1F1FE, 0x1F1EA }, 2, "FLAG: YEMEN" },
    { { 0x1F1FE, 0x1F1F9 }, 2, "FLAG: MAYOTTE" },
    { { 0x1F1FF, 0x1F1E6 }, 2, "FLAG: SOUTH AFRICA" },
    { { 0x1F1FF, 0x1F1F2 }, 2, "FLAG: ZAMBIA" },
    { { 0x1F1FF, 0x1F1FC }, 2, "FLAG: ZIMBABWE" },
    { { 0x1F201 }, 1, "JAPANESE “HERE” BUTTON" },
    { { 0x1F202, 0xFE0F }, 2, "JAPANESE “SERVICE CHARGE” BUTTON" },
    { { 0x1F21A }, 1, "JAPANESE “FREE OF CHARGE” BUTTON" },
    { { 0x1F22F }, 1, "JAPANESE “RESERVED” BUTTON" },
    { { 0x1F232 }, 1, "JAPANESE “PROHIBITED” BUTTON" },
    { { 0x1F233 }, 1, "JAPANESE “VACANCY” BUTTON" },
    { { 0x1F234 }, 1, "JAPANESE “PASSING GRADE” BUTTON" },
    { { 0x1F235 }, 1, "JAPANESE “NO VACANCY” BUTTON" },
    { { 0x1F236 }, 1, "JAPANESE “NOT FREE OF CHARGE” BUTTON" },
    { { 0x1F237, 0xFE0F }, 2, "JAPANESE “MONTHLY AMOUNT” BUTTON" },
    { { 0x1F238 }, 1, "JAPANESE “APPLICATION” BUTTON" },
    { { 0x1F239 }, 1, "JAPANESE “DISCOUNT” BUTTON" },
    { { 0x1F23A }, 1, "JAPANESE “OPEN FOR BUSINESS” BUTTON" },
    { { 0x1F250 }, 1, "JAPANESE “BARGAIN” BUTTON" },
    { { 0x1F251 }, 1, "JAPANESE “ACCEPTABLE” BUTTON" },
    { { 0x1F300 }, 1, "CYCLONE" },
    { { 0x1F301 }, 1, "FOGGY" },
    { { 0x1F302 }, 1, "CLOSED UMBRELLA" },
    { { 0x1F303 }, 1, "NIGHT WITH STARS" },
    { { 0x1F304 }, 1, "SUNRISE OVER MOUNTAINS" },
    { { 0x1F305 }, 1, "SUNRISE" },
    { { 0x1F306 }, 1, "CITYSCAPE AT DUSK" },
    { { 0x1F307 }, 1, "SUNSET" },
    { { 0x1F308 }, 1, "RAINBOW" },
    { { 0x1F309 }, 1, "BRIDGE AT NIGHT" },
    { { 0x1F30A }, 1, "WATER WAVE" },
    { { 0x1F30B }, 1, "VOLCANO" },
    { { 0x1F30C }, 1, "MILKY WAY" },
    { { 0x1F30D }, 1, "GLOBE SHOWING EUROPE-AFRICA" },
    { { 0x1F30E }, 1, "GLOBE SHOWING AMERICAS" },
    { { 0x1F30F }, 1, "GLOBE SHOWING ASIA-AUSTRALIA" },
    { { 0x1F310 }, 1, "GLOBE WITH MERIDIANS" },
    { { 0x1F311 }, 1, "NEW MOON" },
    { { 0x1F312 }, 1, "WAXING CRESCENT MOON" },
    { { 0x1F313 }, 1, "FIRST QUARTER MOON" },
    { { 0x1F314 }, 1, "WAXING GIBBOUS MOON" },
    { { 0x1F315 }, 1, "FULL MOON" },
    { { 0x1F316 }, 1, "WANING GIBBOUS MOON" },
    { { 0x1F317 }, 1, "LAST QUARTER MOON" },
    { { 0x1F318 }, 1, "WANING CRESCENT MOON" },
    { { 0x1F319 }, 1, "CRESCENT MOON" },
    { { 0x1F31A }, 1, "NEW MOON FACE" },
    { { 0x1F31B }, 1, "FIRST QUARTER MOON FACE" },
    { { 0x1F31C }, 1, "LAST QUARTER MOON FACE" },
    { { 0x1F31D }, 1, "FULL MOON FACE" },
    { { 0x1F31E }, 1, "SUN WITH FACE" },
    { { 0x1F31F }, 1, "GLOWING STAR" },
    { { 0x1F320 }, 1, "SHOOTING STAR" },
    { { 0x1F321, 0xFE0F }, 2, "THERMOMETER" },
    { { 0x1F324, 0xFE0F }, 2, "SUN BEHIND SMALL CLOUD" },
    { { 0x1F325, 0xFE0F }, 2, "SUN BEHIND LARGE CLOUD" },
    { { 0x1F326, 0xFE0F }, 2, "SUN BEHIND RAIN CLOUD" },
    { { 0x1F327, 0xFE0F }, 2, "CLOUD WITH RAIN" },
    { { 0x1F328, 0xFE0F }, 2, "CLOUD WITH SNOW" },
    { { 0x1F329, 0xFE0F }, 2, "CLOUD WITH LIGHTNING" },
    { { 0x1F32A, 0xFE0F }, 2, "TORNADO" },
    { { 0x1F32B, 0xFE0F }, 2, "FOG" },
    { { 0x1F32C, 0xFE0F }, 2, "WIND FACE" },
    { { 0x1F32D }, 1, "HOT DOG" },
    { { 0x1F32E }, 1, "TACO" },
    { { 0x1F32F }, 1, "BURRITO" },
    { { 0x1F330 }, 1, "CHESTNUT" },
    { { 0x1F331 }, 1, "SEEDLING" },
    { { 0x1F332 }, 1, "EVERGREEN TREE" },
    { { 0x1F333 }, 1, "DECIDUOUS TREE" },
    { { 0x1F334 }, 1, "PALM TREE" },
    { { 0x1F335 }, 1, "CACTUS" },
    { { 0x1F336, 0xFE0F }, 2, "HOT PEPPER" },
    { { 0x1F337 }, 1, "TULIP" },
    { { 0x1F338 }, 1, "CHERRY BLOSSOM" },
    { { 0x1F339 }, 1, "ROSE" },
    { { 0x1F33A }, 1, "HIBISCUS" },
    { { 0x1F33B }, 1, "SUNFLOWER" },
    { { 0x1F33C }, 1, "BLOSSOM" },
    { { 0x1F33D }, 1, "EAR OF CORN" },
    { { 0x1F33E }, 1, "SHEAF OF RICE" },
    { { 0x1F33F }, 1, "HERB" },
    { { 0x1F340 }, 1, "FOUR LEAF CLOVER" },
    { { 0x1F341 }, 1, "MAPLE LEAF" },
    { { 0x1F342 }, 1, "FALLEN LEAF" },
    { { 0x1F343 }, 1, "LEAF FLUTTERING IN WIND" },
    { { 0x1F344 }, 1, "MUSHROOM" },
    { { 0x1F344, 0x200D, 0x1F7EB }, 3, "BROWN MUSHROOM" },
    { { 0x1F345 }, 1, "TOMATO" },
    { { 0x1F346 }, 1, "EGGPLANT" },
    { { 0x1F347 }, 1, "GRAPES" },
    { { 0x1F348 }, 1, "MELON" },
    { { 0x1F349 }, 1, "WATERMELON" },
    { { 0x1F34A }, 1, "TANGERINE" },
    { { 0x1F34B }, 1, "LEMON" },
    { { 0x1F34B, 0x200D, 0x1F7E9 }, 3, "LIME" },
    { { 0x1F34C }, 1, "BANANA" },
    { { 0x1F34D }, 1, "PINEAPPLE" },
    { { 0x1F34E }, 1, "RED APPLE" },
    { { 0x1F34F }, 1, "GREEN APPLE" },
    { { 0x1F350 }, 1, "PEAR" },
    { { 0x1F351 }, 1, "PEACH" },
    { { 0x1F352 }, 1, "CHERRIES" },
    { { 0x1F353 }, 1, "STRAWBERRY" },
    { { 0x1F354 }, 1, "HAMBURGER" },
    { { 0x1F355 }, 1, "PIZZA" },
    { { 0x1F356 }, 1, "MEAT ON BONE" },
    { { 0x1F357 }, 1, "POULTRY LEG" },
    { { 0x1F358 }, 1, "RICE CRACKER" },
    { { 0x1F359 }, 1, "RICE BALL" },
    { { 0x1F35A }, 1, "COOKED RICE" },
    { { 0x1F35B }, 1, "CURRY RICE" },
    { { 0x1F35C }, 1, "STEAMING BOWL" },
    { { 0x1F35D }, 1, "SPAGHETTI" },
    { { 0x1F35E }, 1, "BREAD" },
    { { 0x1F35F }, 1, "FRENCH FRIES" },
    { { 0x1F360 }, 1, "ROASTED SWEET POTATO" },
    { { 0x1F361 }, 1, "DANGO" },
    { { 0x1F362 }, 1, "ODEN" },
    { { 0x1F363 }, 1, "SUSHI" },
    { { 0x1F364 }, 1, "FRIED SHRIMP" },
    { { 0x1F365 }, 1, "FISH CAKE WITH SWIRL" },
    { { 0x1F366 }, 1, "SOFT ICE CREAM" },
    { { 0x1F367 }, 1, "SHAVED ICE" },
    { { 0x1F368 }, 1, "ICE CREAM" },
    { { 0x1F369 }, 1, "DOUGHNUT" },
    { { 0x1F36A }, 1, "COOKIE" },
    { { 0x1F36B }, 1, "CHOCOLATE BAR" },
    { { 0x1F36C }, 1, "CANDY" },
    { { 0x1F36D }, 1, "LOLLIPOP" },
    { { 0x1F36E }, 1, "CUSTARD" },
    { { 0x1F36F }, 1, "HONEY POT" },
    { { 0x1F370 }, 1, "SHORTCAKE" },
    { { 0x1F371 }, 1, "BENTO BOX" },
    { { 0x1F372 }, 1, "POT OF FOOD" },
    { { 0x1F373 }, 1, "COOKING" },
    { { 0x1F374 }, 1, "FORK AND KNIFE" },
    { { 0x1F375 }, 1, "TEACUP WITHOUT HANDLE" },
    { { 0x1F376 }, 1, "SAKE" },
    { { 0x1F377 }, 1, "WINE GLASS" },
    { { 0x1F378 }, 1, "COCKTAIL GLASS" },
    { { 0x1F379 }, 1, "TROPICAL DRINK" },
    { { 0x1F37A }, 1, "BEER MUG" },
    { { 0x1F37B }, 1, "CLINKING BEER MUGS" },
    { { 0x1F37C }, 1, "BABY BOTTLE" },
    { { 0x1F37D, 0xFE0F }, 2, "FORK AND KNIFE WITH PLATE" },
    { { 0x1F37E }, 1, "BOTTLE WITH POPPING CORK" },
    { { 0x1F37F }, 1, "POPCORN" },
    { { 0x1F380 }, 1, "RIBBON" },
    { { 0x1F381 }, 1, "WRAPPED GIFT" },
    { { 0x1F382 }, 1, "BIRTHDAY CAKE" },
    { { 0x1F383 }, 1, "JACK-O-LANTERN" },
    { { 0x1F384 }, 1, "CHRISTMAS TREE" },
    { { 0x1F385 }, 1, "SANTA CLAUS" },
    { { 0x1F385, 0x1F3FB }, 2, "SANTA CLAUS: LIGHT SKIN TONE" },
    { { 0x1F385, 0x1F3FC }, 2, "SANTA CLAUS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F385, 0x1F3FD }, 2, "SANTA CLAUS: MEDIUM SKIN TONE" },
    { { 0x1F385, 0x1F3FE }, 2, "SANTA CLAUS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F385, 0x1F3FF }, 2, "SANTA CLAUS: DARK SKIN TONE" },
    { { 0x1F386 }, 1, "FIREWORKS" },
    { { 0x1F387 }, 1, "SPARKLER" },
    { { 0x1F388 }, 1, "BALLOON" },
    { { 0x1F389 }, 1, "PARTY POPPER" },
    { { 0x1F38A }, 1, "CONFETTI BALL" },
    { { 0x1F38B }, 1, "TANABATA TREE" },
    { { 0x1F38C }, 1, "CROSSED FLAGS" },
    { { 0x1F38D }, 1, "PINE DECORATION" },
    { { 0x1F38E }, 1, "JAPANESE DOLLS" },
    { { 0x1F38F }, 1, "CARP STREAMER" },
    { { 0x1F390 }, 1, "WIND CHIME" },
    { { 0x1F391 }, 1, "MOON VIEWING CEREMONY" },
    { { 0x1F392 }, 1, "BACKPACK" },
    { { 0x1F393 }, 1, "GRADUATION CAP" },
    { { 0x1F396, 0xFE0F }, 2, "MILITARY MEDAL" },
    { { 0x1F397, 0xFE0F }, 2, "REMINDER RIBBON" },
    { { 0x1F399, 0xFE0F }, 2, "STUDIO MICROPHONE" },
    { { 0x1F39A, 0xFE0F }, 2, "LEVEL SLIDER" },
    { { 0x1F39B, 0xFE0F }, 2, "CONTROL KNOBS" },
    { { 0x1F39E, 0xFE0F }, 2, "FILM FRAMES" },
    { { 0x1F39F, 0xFE0F }, 2, "ADMISSION TICKETS" },
    { { 0x1F3A0 }, 1, "CAROUSEL HORSE" },
    { { 0x1F3A1 }, 1, "FERRIS WHEEL" },
    { { 0x1F3A2 }, 1, "ROLLER COASTER" },
    { { 0x1F3A3 }, 1, "FISHING POLE" },
    { { 0x1F3A4 }, 1, "MICROPHONE" },
    { { 0x1F3A5 }, 1, "MOVIE CAMERA" },
    { { 0x1F3A6 }, 1, "CINEMA" },
    { { 0x1F3A7 }, 1, "HEADPHONE" },
    { { 0x1F3A8 }, 1, "ARTIST PALETTE" },
    { { 0x1F3A9 }, 1, "TOP HAT" },
    { { 0x1F3AA }, 1, "CIRCUS TENT" },
    { { 0x1F3AB }, 1, "TICKET" },
    { { 0x1F3AC }, 1, "CLAPPER BOARD" },
    { { 0x1F3AD }, 1, "PERFORMING ARTS" },
    { { 0x1F3AE }, 1, "VIDEO GAME" },
    { { 0x1F3AF }, 1, "BULLSEYE" },
    { { 0x1F3B0 }, 1, "SLOT MACHINE" },
    { { 0x1F3B1 }, 1, "POOL 8 BALL" },
    { { 0x1F3B2 }, 1, "GAME DIE" },
    { { 0x1F3B3 }, 1, "BOWLING" },
    { { 0x1F3B4 }, 1, "FLOWER PLAYING CARDS" },
    { { 0x1F3B5 }, 1, "MUSICAL NOTE" },
    { { 0x1F3B6 }, 1, "MUSICAL NOTES" },
    { { 0x1F3B7 }, 1, "SAXOPHONE" },
    { { 0x1F3B8 }, 1, "GUITAR" },
    { { 0x1F3B9 }, 1, "MUSICAL KEYBOARD" },
    { { 0x1F3BA }, 1, "TRUMPET" },
    { { 0x1F3BB }, 1, "VIOLIN" },
    { { 0x1F3BC }, 1, "MUSICAL SCORE" },
    { { 0x1F3BD }, 1, "RUNNING SHIRT" },
    { { 0x1F3BE }, 1, "TENNIS" },
    { { 0x1F3BF }, 1, "SKIS" },
    { { 0x1F3C0 }, 1, "BASKETBALL" },
    { { 0x1F3C1 }, 1, "CHEQUERED FLAG" },
    { { 0x1F3C2 }, 1, "SNOWBOARDER" },
    { { 0x1F3C2, 0x1F3FB }, 2, "SNOWBOARDER: LIGHT SKIN TONE" },
    { { 0x1F3C2, 0x1F3FC }, 2, "SNOWBOARDER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C2, 0x1F3FD }, 2, "SNOWBOARDER: MEDIUM SKIN TONE" },
    { { 0x1F3C2, 0x1F3FE }, 2, "SNOWBOARDER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C2, 0x1F3FF }, 2, "SNOWBOARDER: DARK SKIN TONE" },
    { { 0x1F3C3 }, 1, "PERSON RUNNING" },
    { { 0x1F3C3, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN RUNNING" },
    { { 0x1F3C3, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN RUNNING FACING RIGHT" },
    { { 0x1F3C3, 0x200D, 0x2642, 0xFE0F }, 4, "MAN RUNNING" },
    { { 0x1F3C3, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN RUNNING FACING RIGHT" },
    { { 0x1F3C3, 0x200D, 0x27A1, 0xFE0F }, 4, "PERSON RUNNING FACING RIGHT" },
    { { 0x1F3C3, 0x1F3FB }, 2, "PERSON RUNNING: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RUNNING: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN RUNNING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RUNNING: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN RUNNING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FB, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON RUNNING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC }, 2, "PERSON RUNNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RUNNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN RUNNING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RUNNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN RUNNING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FC, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON RUNNING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD }, 2, "PERSON RUNNING: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RUNNING: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN RUNNING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RUNNING: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN RUNNING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FD, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON RUNNING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE }, 2, "PERSON RUNNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RUNNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN RUNNING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RUNNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN RUNNING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FE, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON RUNNING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF }, 2, "PERSON RUNNING: DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RUNNING: DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN RUNNING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RUNNING: DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN RUNNING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F3C3, 0x1F3FF, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON RUNNING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F3C4 }, 1, "PERSON SURFING" },
    { { 0x1F3C4, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN SURFING" },
    { { 0x1F3C4, 0x200D, 0x2642, 0xFE0F }, 4, "MAN SURFING" },
    { { 0x1F3C4, 0x1F3FB }, 2, "PERSON SURFING: LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SURFING: LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SURFING: LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FC }, 2, "PERSON SURFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SURFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SURFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C4, 0x1F3FD }, 2, "PERSON SURFING: MEDIUM SKIN TONE" },
    { { 0x1F3C4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SURFING: MEDIUM SKIN TONE" },
    { { 0x1F3C4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SURFING: MEDIUM SKIN TONE" },
    { { 0x1F3C4, 0x1F3FE }, 2, "PERSON SURFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SURFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SURFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C4, 0x1F3FF }, 2, "PERSON SURFING: DARK SKIN TONE" },
    { { 0x1F3C4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SURFING: DARK SKIN TONE" },
    { { 0x1F3C4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SURFING: DARK SKIN TONE" },
    { { 0x1F3C5 }, 1, "SPORTS MEDAL" },
    { { 0x1F3C6 }, 1, "TROPHY" },
    { { 0x1F3C7 }, 1, "HORSE RACING" },
    { { 0x1F3C7, 0x1F3FB }, 2, "HORSE RACING: LIGHT SKIN TONE" },
    { { 0x1F3C7, 0x1F3FC }, 2, "HORSE RACING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3C7, 0x1F3FD }, 2, "HORSE RACING: MEDIUM SKIN TONE" },
    { { 0x1F3C7, 0x1F3FE }, 2, "HORSE RACING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3C7, 0x1F3FF }, 2, "HORSE RACING: DARK SKIN TONE" },
    { { 0x1F3C8 }, 1, "AMERICAN FOOTBALL" },
    { { 0x1F3C9 }, 1, "RUGBY FOOTBALL" },
    { { 0x1F3CA }, 1, "PERSON SWIMMING" },
    { { 0x1F3CA, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN SWIMMING" },
    { { 0x1F3CA, 0x200D, 0x2642, 0xFE0F }, 4, "MAN SWIMMING" },
    { { 0x1F3CA, 0x1F3FB }, 2, "PERSON SWIMMING: LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SWIMMING: LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SWIMMING: LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FC }, 2, "PERSON SWIMMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SWIMMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SWIMMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CA, 0x1F3FD }, 2, "PERSON SWIMMING: MEDIUM SKIN TONE" },
    { { 0x1F3CA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SWIMMING: MEDIUM SKIN TONE" },
    { { 0x1F3CA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SWIMMING: MEDIUM SKIN TONE" },
    { { 0x1F3CA, 0x1F3FE }, 2, "PERSON SWIMMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SWIMMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SWIMMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CA, 0x1F3FF }, 2, "PERSON SWIMMING: DARK SKIN TONE" },
    { { 0x1F3CA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SWIMMING: DARK SKIN TONE" },
    { { 0x1F3CA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SWIMMING: DARK SKIN TONE" },
    { { 0x1F3CB, 0xFE0F }, 2, "PERSON LIFTING WEIGHTS" },
    { { 0x1F3CB, 0xFE0F, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS" },
    { { 0x1F3CB, 0xFE0F, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS" },
    { { 0x1F3CB, 0x1F3FB }, 2, "PERSON LIFTING WEIGHTS: LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS: LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS: LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FC }, 2, "PERSON LIFTING WEIGHTS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CB, 0x1F3FD }, 2, "PERSON LIFTING WEIGHTS: MEDIUM SKIN TONE" },
    { { 0x1F3CB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS: MEDIUM SKIN TONE" },
    { { 0x1F3CB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS: MEDIUM SKIN TONE" },
    { { 0x1F3CB, 0x1F3FE }, 2, "PERSON LIFTING WEIGHTS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CB, 0x1F3FF }, 2, "PERSON LIFTING WEIGHTS: DARK SKIN TONE" },
    { { 0x1F3CB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN LIFTING WEIGHTS: DARK SKIN TONE" },
    { { 0x1F3CB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN LIFTING WEIGHTS: DARK SKIN TONE" },
    { { 0x1F3CC, 0xFE0F }, 2, "PERSON GOLFING" },
    { { 0x1F3CC, 0xFE0F, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING" },
    { { 0x1F3CC, 0xFE0F, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING" },
    { { 0x1F3CC, 0x1F3FB }, 2, "PERSON GOLFING: LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING: LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING: LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FC }, 2, "PERSON GOLFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F3CC, 0x1F3FD }, 2, "PERSON GOLFING: MEDIUM SKIN TONE" },
    { { 0x1F3CC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING: MEDIUM SKIN TONE" },
    { { 0x1F3CC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING: MEDIUM SKIN TONE" },
    { { 0x1F3CC, 0x1F3FE }, 2, "PERSON GOLFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F3CC, 0x1F3FF }, 2, "PERSON GOLFING: DARK SKIN TONE" },
    { { 0x1F3CC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GOLFING: DARK SKIN TONE" },
    { { 0x1F3CC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GOLFING: DARK SKIN TONE" },
    { { 0x1F3CD, 0xFE0F }, 2, "MOTORCYCLE" },
    { { 0x1F3CE, 0xFE0F }, 2, "RACING CAR" },
    { { 0x1F3CF }, 1, "CRICKET GAME" },
    { { 0x1F3D0 }, 1, "VOLLEYBALL" },
    { { 0x1F3D1 }, 1, "FIELD HOCKEY" },
    { { 0x1F3D2 }, 1, "ICE HOCKEY" },
    { { 0x1F3D3 }, 1, "PING PONG" },
    { { 0x1F3D4, 0xFE0F }, 2, "SNOW-CAPPED MOUNTAIN" },
    { { 0x1F3D5, 0xFE0F }, 2, "CAMPING" },
    { { 0x1F3D6, 0xFE0F }, 2, "BEACH WITH UMBRELLA" },
    { { 0x1F3D7, 0xFE0F }, 2, "BUILDING CONSTRUCTION" },
    { { 0x1F3D8, 0xFE0F }, 2, "HOUSES" },
    { { 0x1F3D9, 0xFE0F }, 2, "CITYSCAPE" },
    { { 0x1F3DA, 0xFE0F }, 2, "DERELICT HOUSE" },
    { { 0x1F3DB, 0xFE0F }, 2, "CLASSICAL BUILDING" },
    { { 0x1F3DC, 0xFE0F }, 2, "DESERT" },
    { { 0x1F3DD, 0xFE0F }, 2, "DESERT ISLAND" },
    { { 0x1F3DE, 0xFE0F }, 2, "NATIONAL PARK" },
    { { 0x1F3DF, 0xFE0F }, 2, "STADIUM" },
    { { 0x1F3E0 }, 1, "HOUSE" },
    { { 0x1F3E1 }, 1, "HOUSE WITH GARDEN" },
    { { 0x1F3E2 }, 1, "OFFICE BUILDING" },
    { { 0x1F3E3 }, 1, "JAPANESE POST OFFICE" },
    { { 0x1F3E4 }, 1, "POST OFFICE" },
    { { 0x1F3E5 }, 1, "HOSPITAL" },
    { { 0x1F3E6 }, 1, "BANK" },
    { { 0x1F3E7 }, 1, "ATM SIGN" },
    { { 0x1F3E8 }, 1, "HOTEL" },
    { { 0x1F3E9 }, 1, "LOVE HOTEL" },
    { { 0x1F3EA }, 1, "CONVENIENCE STORE" },
    { { 0x1F3EB }, 1, "SCHOOL" },
    { { 0x1F3EC }, 1, "DEPARTMENT STORE" },
    { { 0x1F3ED }, 1, "FACTORY" },
    { { 0x1F3EE }, 1, "RED PAPER LANTERN" },
    { { 0x1F3EF }, 1, "JAPANESE CASTLE" },
    { { 0x1F3F0 }, 1, "CASTLE" },
    { { 0x1F3F3, 0xFE0F }, 2, "WHITE FLAG" },
    { { 0x1F3F3, 0xFE0F, 0x200D, 0x26A7, 0xFE0F }, 5, "TRANSGENDER FLAG" },
    { { 0x1F3F3, 0xFE0F, 0x200D, 0x1F308 }, 4, "RAINBOW FLAG" },
    { { 0x1F3F4 }, 1, "BLACK FLAG" },
    { { 0x1F3F4, 0x200D, 0x2620, 0xFE0F }, 4, "PIRATE FLAG" },
    { { 0x1F3F4, 0xE0067, 0xE0062, 0xE0065, 0xE006E, 0xE0067, 0xE007F }, 7, "FLAG: ENGLAND" },
    { { 0x1F3F4, 0xE0067, 0xE0062, 0xE0073, 0xE0063, 0xE0074, 0xE007F }, 7, "FLAG: SCOTLAND" },
    { { 0x1F3F4, 0xE0067, 0xE0062, 0xE0077, 0xE006C, 0xE0073, 0xE007F }, 7, "FLAG: WALES" },
    { { 0x1F3F5, 0xFE0F }, 2, "ROSETTE" },
    { { 0x1F3F7, 0xFE0F }, 2, "LABEL" },
    { { 0x1F3F8 }, 1, "BADMINTON" },
    { { 0x1F3F9 }, 1, "BOW AND ARROW" },
    { { 0x1F3FA }, 1, "AMPHORA" },
    { { 0x1F400 }, 1, "RAT" },
    { { 0x1F401 }, 1, "MOUSE" },
    { { 0x1F402 }, 1, "OX" },
    { { 0x1F403 }, 1, "WATER BUFFALO" },
    { { 0x1F404 }, 1, "COW" },
    { { 0x1F405 }, 1, "TIGER" },
    { { 0x1F406 }, 1, "LEOPARD" },
    { { 0x1F407 }, 1, "RABBIT" },
    { { 0x1F408 }, 1, "CAT" },
    { { 0x1F408, 0x200D, 0x2B1B }, 3, "BLACK CAT" },
    { { 0x1F409 }, 1, "DRAGON" },
    { { 0x1F40A }, 1, "CROCODILE" },
    { { 0x1F40B }, 1, "WHALE" },
    { { 0x1F40C }, 1, "SNAIL" },
    { { 0x1F40D }, 1, "SNAKE" },
    { { 0x1F40E }, 1, "HORSE" },
    { { 0x1F40F }, 1, "RAM" },
    { { 0x1F410 }, 1, "GOAT" },
    { { 0x1F411 }, 1, "EWE" },
    { { 0x1F412 }, 1, "MONKEY" },
    { { 0x1F413 }, 1, "ROOSTER" },
    { { 0x1F414 }, 1, "CHICKEN" },
    { { 0x1F415 }, 1, "DOG" },
    { { 0x1F415, 0x200D, 0x1F9BA }, 3, "SERVICE DOG" },
    { { 0x1F416 }, 1, "PIG" },
    { { 0x1F417 }, 1, "BOAR" },
    { { 0x1F418 }, 1, "ELEPHANT" },
    { { 0x1F419 }, 1, "OCTOPUS" },
    { { 0x1F41A }, 1, "SPIRAL SHELL" },
    { { 0x1F41B }, 1, "BUG" },
    { { 0x1F41C }, 1, "ANT" },
    { { 0x1F41D }, 1, "HONEYBEE" },
    { { 0x1F41E }, 1, "LADY BEETLE" },
    { { 0x1F41F }, 1, "FISH" },
    { { 0x1F420 }, 1, "TROPICAL FISH" },
    { { 0x1F421 }, 1, "BLOWFISH" },
    { { 0x1F422 }, 1, "TURTLE" },
    { { 0x1F423 }, 1, "HATCHING CHICK" },
    { { 0x1F424 }, 1, "BABY CHICK" },
    { { 0x1F425 }, 1, "FRONT-FACING BABY CHICK" },
    { { 0x1F426 }, 1, "BIRD" },
    { { 0x1F426, 0x200D, 0x2B1B }, 3, "BLACK BIRD" },
    { { 0x1F426, 0x200D, 0x1F525 }, 3, "PHOENIX" },
    { { 0x1F427 }, 1, "PENGUIN" },
    { { 0x1F428 }, 1, "KOALA" },
    { { 0x1F429 }, 1, "POODLE" },
    { { 0x1F42A }, 1, "CAMEL" },
    { { 0x1F42B }, 1, "TWO-HUMP CAMEL" },
    { { 0x1F42C }, 1, "DOLPHIN" },
    { { 0x1F42D }, 1, "MOUSE FACE" },
    { { 0x1F42E }, 1, "COW FACE" },
    { { 0x1F42F }, 1, "TIGER FACE" },
    { { 0x1F430 }, 1, "RABBIT FACE" },
    { { 0x1F431 }, 1, "CAT FACE" },
    { { 0x1F432 }, 1, "DRAGON FACE" },
    { { 0x1F433 }, 1, "SPOUTING WHALE" },
    { { 0x1F434 }, 1, "HORSE FACE" },
    { { 0x1F435 }, 1, "MONKEY FACE" },
    { { 0x1F436 }, 1, "DOG FACE" },
    { { 0x1F437 }, 1, "PIG FACE" },
    { { 0x1F438 }, 1, "FROG" },
    { { 0x1F439 }, 1, "HAMSTER" },
    { { 0x1F43A }, 1, "WOLF" },
    { { 0x1F43B }, 1, "BEAR" },
    { { 0x1F43B, 0x200D, 0x2744, 0xFE0F }, 4, "POLAR BEAR" },
    { { 0x1F43C }, 1, "PANDA" },
    { { 0x1F43D }, 1, "PIG NOSE" },
    { { 0x1F43E }, 1, "PAW PRINTS" },
    { { 0x1F43F, 0xFE0F }, 2, "CHIPMUNK" },
    { { 0x1F440 }, 1, "EYES" },
    { { 0x1F441, 0xFE0F }, 2, "EYE" },
    { { 0x1F441, 0xFE0F, 0x200D, 0x1F5E8, 0xFE0F }, 5, "EYE IN SPEECH BUBBLE" },
    { { 0x1F442 }, 1, "EAR" },
    { { 0x1F442, 0x1F3FB }, 2, "EAR: LIGHT SKIN TONE" },
    { { 0x1F442, 0x1F3FC }, 2, "EAR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F442, 0x1F3FD }, 2, "EAR: MEDIUM SKIN TONE" },
    { { 0x1F442, 0x1F3FE }, 2, "EAR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F442, 0x1F3FF }, 2, "EAR: DARK SKIN TONE" },
    { { 0x1F443 }, 1, "NOSE" },
    { { 0x1F443, 0x1F3FB }, 2, "NOSE: LIGHT SKIN TONE" },
    { { 0x1F443, 0x1F3FC }, 2, "NOSE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F443, 0x1F3FD }, 2, "NOSE: MEDIUM SKIN TONE" },
    { { 0x1F443, 0x1F3FE }, 2, "NOSE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F443, 0x1F3FF }, 2, "NOSE: DARK SKIN TONE" },
    { { 0x1F444 }, 1, "MOUTH" },
    { { 0x1F445 }, 1, "TONGUE" },
    { { 0x1F446 }, 1, "BACKHAND INDEX POINTING UP" },
    { { 0x1F446, 0x1F3FB }, 2, "BACKHAND INDEX POINTING UP: LIGHT SKIN TONE" },
    { { 0x1F446, 0x1F3FC }, 2, "BACKHAND INDEX POINTING UP: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F446, 0x1F3FD }, 2, "BACKHAND INDEX POINTING UP: MEDIUM SKIN TONE" },
    { { 0x1F446, 0x1F3FE }, 2, "BACKHAND INDEX POINTING UP: MEDIUM-DARK SKIN TONE" },
    { { 0x1F446, 0x1F3FF }, 2, "BACKHAND INDEX POINTING UP: DARK SKIN TONE" },
    { { 0x1F447 }, 1, "BACKHAND INDEX POINTING DOWN" },
    { { 0x1F447, 0x1F3FB }, 2, "BACKHAND INDEX POINTING DOWN: LIGHT SKIN TONE" },
    { { 0x1F447, 0x1F3FC }, 2, "BACKHAND INDEX POINTING DOWN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F447, 0x1F3FD }, 2, "BACKHAND INDEX POINTING DOWN: MEDIUM SKIN TONE" },
    { { 0x1F447, 0x1F3FE }, 2, "BACKHAND INDEX POINTING DOWN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F447, 0x1F3FF }, 2, "BACKHAND INDEX POINTING DOWN: DARK SKIN TONE" },
    { { 0x1F448 }, 1, "BACKHAND INDEX POINTING LEFT" },
    { { 0x1F448, 0x1F3FB }, 2, "BACKHAND INDEX POINTING LEFT: LIGHT SKIN TONE" },
    { { 0x1F448, 0x1F3FC }, 2, "BACKHAND INDEX POINTING LEFT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F448, 0x1F3FD }, 2, "BACKHAND INDEX POINTING LEFT: MEDIUM SKIN TONE" },
    { { 0x1F448, 0x1F3FE }, 2, "BACKHAND INDEX POINTING LEFT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F448, 0x1F3FF }, 2, "BACKHAND INDEX POINTING LEFT: DARK SKIN TONE" },
    { { 0x1F449 }, 1, "BACKHAND INDEX POINTING RIGHT" },
    { { 0x1F449, 0x1F3FB }, 2, "BACKHAND INDEX POINTING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F449, 0x1F3FC }, 2, "BACKHAND INDEX POINTING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F449, 0x1F3FD }, 2, "BACKHAND INDEX POINTING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F449, 0x1F3FE }, 2, "BACKHAND INDEX POINTING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F449, 0x1F3FF }, 2, "BACKHAND INDEX POINTING RIGHT: DARK SKIN TONE" },
    { { 0x1F44A }, 1, "ONCOMING FIST" },
    { { 0x1F44A, 0x1F3FB }, 2, "ONCOMING FIST: LIGHT SKIN TONE" },
    { { 0x1F44A, 0x1F3FC }, 2, "ONCOMING FIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44A, 0x1F3FD }, 2, "ONCOMING FIST: MEDIUM SKIN TONE" },
    { { 0x1F44A, 0x1F3FE }, 2, "ONCOMING FIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44A, 0x1F3FF }, 2, "ONCOMING FIST: DARK SKIN TONE" },
    { { 0x1F44B }, 1, "WAVING HAND" },
    { { 0x1F44B, 0x1F3FB }, 2, "WAVING HAND: LIGHT SKIN TONE" },
    { { 0x1F44B, 0x1F3FC }, 2, "WAVING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44B, 0x1F3FD }, 2, "WAVING HAND: MEDIUM SKIN TONE" },
    { { 0x1F44B, 0x1F3FE }, 2, "WAVING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44B, 0x1F3FF }, 2, "WAVING HAND: DARK SKIN TONE" },
    { { 0x1F44C }, 1, "OK HAND" },
    { { 0x1F44C, 0x1F3FB }, 2, "OK HAND: LIGHT SKIN TONE" },
    { { 0x1F44C, 0x1F3FC }, 2, "OK HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44C, 0x1F3FD }, 2, "OK HAND: MEDIUM SKIN TONE" },
    { { 0x1F44C, 0x1F3FE }, 2, "OK HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44C, 0x1F3FF }, 2, "OK HAND: DARK SKIN TONE" },
    { { 0x1F44D }, 1, "THUMBS UP" },
    { { 0x1F44D, 0x1F3FB }, 2, "THUMBS UP: LIGHT SKIN TONE" },
    { { 0x1F44D, 0x1F3FC }, 2, "THUMBS UP: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44D, 0x1F3FD }, 2, "THUMBS UP: MEDIUM SKIN TONE" },
    { { 0x1F44D, 0x1F3FE }, 2, "THUMBS UP: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44D, 0x1F3FF }, 2, "THUMBS UP: DARK SKIN TONE" },
    { { 0x1F44E }, 1, "THUMBS DOWN" },
    { { 0x1F44E, 0x1F3FB }, 2, "THUMBS DOWN: LIGHT SKIN TONE" },
    { { 0x1F44E, 0x1F3FC }, 2, "THUMBS DOWN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44E, 0x1F3FD }, 2, "THUMBS DOWN: MEDIUM SKIN TONE" },
    { { 0x1F44E, 0x1F3FE }, 2, "THUMBS DOWN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44E, 0x1F3FF }, 2, "THUMBS DOWN: DARK SKIN TONE" },
    { { 0x1F44F }, 1, "CLAPPING HANDS" },
    { { 0x1F44F, 0x1F3FB }, 2, "CLAPPING HANDS: LIGHT SKIN TONE" },
    { { 0x1F44F, 0x1F3FC }, 2, "CLAPPING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F44F, 0x1F3FD }, 2, "CLAPPING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F44F, 0x1F3FE }, 2, "CLAPPING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F44F, 0x1F3FF }, 2, "CLAPPING HANDS: DARK SKIN TONE" },
    { { 0x1F450 }, 1, "OPEN HANDS" },
    { { 0x1F450, 0x1F3FB }, 2, "OPEN HANDS: LIGHT SKIN TONE" },
    { { 0x1F450, 0x1F3FC }, 2, "OPEN HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F450, 0x1F3FD }, 2, "OPEN HANDS: MEDIUM SKIN TONE" },
    { { 0x1F450, 0x1F3FE }, 2, "OPEN HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F450, 0x1F3FF }, 2, "OPEN HANDS: DARK SKIN TONE" },
    { { 0x1F451 }, 1, "CROWN" },
    { { 0x1F452 }, 1, "WOMAN’S HAT" },
    { { 0x1F453 }, 1, "GLASSES" },
    { { 0x1F454 }, 1, "NECKTIE" },
    { { 0x1F455 }, 1, "T-SHIRT" },
    { { 0x1F456 }, 1, "JEANS" },
    { { 0x1F457 }, 1, "DRESS" },
    { { 0x1F458 }, 1, "KIMONO" },
    { { 0x1F459 }, 1, "BIKINI" },
    { { 0x1F45A }, 1, "WOMAN’S CLOTHES" },
    { { 0x1F45B }, 1, "PURSE" },
    { { 0x1F45C }, 1, "HANDBAG" },
    { { 0x1F45D }, 1, "CLUTCH BAG" },
    { { 0x1F45E }, 1, "MAN’S SHOE" },
    { { 0x1F45F }, 1, "RUNNING SHOE" },
    { { 0x1F460 }, 1, "HIGH-HEELED SHOE" },
    { { 0x1F461 }, 1, "WOMAN’S SANDAL" },
    { { 0x1F462 }, 1, "WOMAN’S BOOT" },
    { { 0x1F463 }, 1, "FOOTPRINTS" },
    { { 0x1F464 }, 1, "BUST IN SILHOUETTE" },
    { { 0x1F465 }, 1, "BUSTS IN SILHOUETTE" },
    { { 0x1F466 }, 1, "BOY" },
    { { 0x1F466, 0x1F3FB }, 2, "BOY: LIGHT SKIN TONE" },
    { { 0x1F466, 0x1F3FC }, 2, "BOY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F466, 0x1F3FD }, 2, "BOY: MEDIUM SKIN TONE" },
    { { 0x1F466, 0x1F3FE }, 2, "BOY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F466, 0x1F3FF }, 2, "BOY: DARK SKIN TONE" },
    { { 0x1F467 }, 1, "GIRL" },
    { { 0x1F467, 0x1F3FB }, 2, "GIRL: LIGHT SKIN TONE" },
    { { 0x1F467, 0x1F3FC }, 2, "GIRL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F467, 0x1F3FD }, 2, "GIRL: MEDIUM SKIN TONE" },
    { { 0x1F467, 0x1F3FE }, 2, "GIRL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F467, 0x1F3FF }, 2, "GIRL: DARK SKIN TONE" },
    { { 0x1F468 }, 1, "MAN" },
    { { 0x1F468, 0x200D, 0x2695, 0xFE0F }, 4, "MAN HEALTH WORKER" },
    { { 0x1F468, 0x200D, 0x2696, 0xFE0F }, 4, "MAN JUDGE" },
    { { 0x1F468, 0x200D, 0x2708, 0xFE0F }, 4, "MAN PILOT" },
    { { 0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468 }, 6, "COUPLE WITH HEART: MAN, MAN" },
    { { 0x1F468, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468 }, 8, "KISS: MAN, MAN" },
    { { 0x1F468, 0x200D, 0x1F33E }, 3, "MAN FARMER" },
    { { 0x1F468, 0x200D, 0x1F373 }, 3, "MAN COOK" },
    { { 0x1F468, 0x200D, 0x1F37C }, 3, "MAN FEEDING BABY" },
    { { 0x1F468, 0x200D, 0x1F393 }, 3, "MAN STUDENT" },
    { { 0x1F468, 0x200D, 0x1F3A4 }, 3, "MAN SINGER" },
    { { 0x1F468, 0x200D, 0x1F3A8 }, 3, "MAN ARTIST" },
    { { 0x1F468, 0x200D, 0x1F3EB }, 3, "MAN TEACHER" },
    { { 0x1F468, 0x200D, 0x1F3ED }, 3, "MAN FACTORY WORKER" },
    { { 0x1F468, 0x200D, 0x1F466 }, 3, "FAMILY: MAN, BOY" },
    { { 0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466 }, 5, "FAMILY: MAN, BOY, BOY" },
    { { 0x1F468, 0x200D, 0x1F467 }, 3, "FAMILY: MAN, GIRL" },
    { { 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466 }, 5, "FAMILY: MAN, GIRL, BOY" },
    { { 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467 }, 5, "FAMILY: MAN, GIRL, GIRL" },
    { { 0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466 }, 5, "FAMILY: MAN, MAN, BOY" },
    { { 0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F466, 0x200D, 0x1F466 }, 7, "FAMILY: MAN, MAN, BOY, BOY" },
    { { 0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467 }, 5, "FAMILY: MAN, MAN, GIRL" },
    { { 0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F466 }, 7, "FAMILY: MAN, MAN, GIRL, BOY" },
    { { 0x1F468, 0x200D, 0x1F468, 0x200D, 0x1F467, 0x200D, 0x1F467 }, 7, "FAMILY: MAN, MAN, GIRL, GIRL" },
    { { 0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466 }, 5, "FAMILY: MAN, WOMAN, BOY" },
    { { 0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466 }, 7, "FAMILY: MAN, WOMAN, BOY, BOY" },
    { { 0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467 }, 5, "FAMILY: MAN, WOMAN, GIRL" },
    { { 0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466 }, 7, "FAMILY: MAN, WOMAN, GIRL, BOY" },
    { { 0x1F468, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467 }, 7, "FAMILY: MAN, WOMAN, GIRL, GIRL" },
    { { 0x1F468, 0x200D, 0x1F4BB }, 3, "MAN TECHNOLOGIST" },
    { { 0x1F468, 0x200D, 0x1F4BC }, 3, "MAN OFFICE WORKER" },
    { { 0x1F468, 0x200D, 0x1F527 }, 3, "MAN MECHANIC" },
    { { 0x1F468, 0x200D, 0x1F52C }, 3, "MAN SCIENTIST" },
    { { 0x1F468, 0x200D, 0x1F680 }, 3, "MAN ASTRONAUT" },
    { { 0x1F468, 0x200D, 0x1F692 }, 3, "MAN FIREFIGHTER" },
    { { 0x1F468, 0x200D, 0x1F9AF }, 3, "MAN WITH WHITE CANE" },
    { { 0x1F468, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 6, "MAN WITH WHITE CANE FACING RIGHT" },
    { { 0x1F468, 0x200D, 0x1F9B0 }, 3, "MAN: RED HAIR" },
    { { 0x1F468, 0x200D, 0x1F9B1 }, 3, "MAN: CURLY HAIR" },
    { { 0x1F468, 0x200D, 0x1F9B2 }, 3, "MAN: BALD" },
    { { 0x1F468, 0x200D, 0x1F9B3 }, 3, "MAN: WHITE HAIR" },
    { { 0x1F468, 0x200D, 0x1F9BC }, 3, "MAN IN MOTORIZED WHEELCHAIR" },
    { { 0x1F468, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 6, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT" },
    { { 0x1F468, 0x200D, 0x1F9BD }, 3, "MAN IN MANUAL WHEELCHAIR" },
    { { 0x1F468, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 6, "MAN IN MANUAL WHEELCHAIR FACING RIGHT" },
    { { 0x1F468, 0x1F3FB }, 2, "MAN: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2695, 0xFE0F }, 5, "MAN HEALTH WORKER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2696, 0xFE0F }, 5, "MAN JUDGE: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2708, 0xFE0F }, 5, "MAN PILOT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: MAN, MAN, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: MAN, MAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: MAN, MAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: MAN, MAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: MAN, MAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: MAN, MAN, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: MAN, MAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: MAN, MAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: MAN, MAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: MAN, MAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F33E }, 4, "MAN FARMER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F373 }, 4, "MAN COOK: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F37C }, 4, "MAN FEEDING BABY: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F393 }, 4, "MAN STUDENT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F3A4 }, 4, "MAN SINGER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F3A8 }, 4, "MAN ARTIST: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F3EB }, 4, "MAN TEACHER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F3ED }, 4, "MAN FACTORY WORKER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F4BB }, 4, "MAN TECHNOLOGIST: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F4BC }, 4, "MAN OFFICE WORKER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F527 }, 4, "MAN MECHANIC: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F52C }, 4, "MAN SCIENTIST: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F680 }, 4, "MAN ASTRONAUT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F692 }, 4, "MAN FIREFIGHTER: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "MEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "MEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "MEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "MEN HOLDING HANDS: LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9AF }, 4, "MAN WITH WHITE CANE: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WITH WHITE CANE FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9B0 }, 4, "MAN: LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9B1 }, 4, "MAN: LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9B2 }, 4, "MAN: LIGHT SKIN TONE, BALD" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9B3 }, 4, "MAN: LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9BC }, 4, "MAN IN MOTORIZED WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9BD }, 4, "MAN IN MANUAL WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FB, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MANUAL WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC }, 2, "MAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2695, 0xFE0F }, 5, "MAN HEALTH WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2696, 0xFE0F }, 5, "MAN JUDGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2708, 0xFE0F }, 5, "MAN PILOT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: MAN, MAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: MAN, MAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: MAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: MAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: MAN, MAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F33E }, 4, "MAN FARMER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F373 }, 4, "MAN COOK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F37C }, 4, "MAN FEEDING BABY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F393 }, 4, "MAN STUDENT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F3A4 }, 4, "MAN SINGER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F3A8 }, 4, "MAN ARTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F3EB }, 4, "MAN TEACHER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F3ED }, 4, "MAN FACTORY WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F4BB }, 4, "MAN TECHNOLOGIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F4BC }, 4, "MAN OFFICE WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F527 }, 4, "MAN MECHANIC: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F52C }, 4, "MAN SCIENTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F680 }, 4, "MAN ASTRONAUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F692 }, 4, "MAN FIREFIGHTER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "MEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "MEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "MEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "MEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9AF }, 4, "MAN WITH WHITE CANE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WITH WHITE CANE FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9B0 }, 4, "MAN: MEDIUM-LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9B1 }, 4, "MAN: MEDIUM-LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9B2 }, 4, "MAN: MEDIUM-LIGHT SKIN TONE, BALD" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9B3 }, 4, "MAN: MEDIUM-LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9BC }, 4, "MAN IN MOTORIZED WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9BD }, 4, "MAN IN MANUAL WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FC, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD }, 2, "MAN: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2695, 0xFE0F }, 5, "MAN HEALTH WORKER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2696, 0xFE0F }, 5, "MAN JUDGE: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2708, 0xFE0F }, 5, "MAN PILOT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: MAN, MAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: MAN, MAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: MAN, MAN, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: MAN, MAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: MAN, MAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F33E }, 4, "MAN FARMER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F373 }, 4, "MAN COOK: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F37C }, 4, "MAN FEEDING BABY: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F393 }, 4, "MAN STUDENT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F3A4 }, 4, "MAN SINGER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F3A8 }, 4, "MAN ARTIST: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F3EB }, 4, "MAN TEACHER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F3ED }, 4, "MAN FACTORY WORKER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F4BB }, 4, "MAN TECHNOLOGIST: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F4BC }, 4, "MAN OFFICE WORKER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F527 }, 4, "MAN MECHANIC: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F52C }, 4, "MAN SCIENTIST: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F680 }, 4, "MAN ASTRONAUT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F692 }, 4, "MAN FIREFIGHTER: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "MEN HOLDING HANDS: MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "MEN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "MEN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "MEN HOLDING HANDS: MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9AF }, 4, "MAN WITH WHITE CANE: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WITH WHITE CANE FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9B0 }, 4, "MAN: MEDIUM SKIN TONE, RED HAIR" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9B1 }, 4, "MAN: MEDIUM SKIN TONE, CURLY HAIR" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9B2 }, 4, "MAN: MEDIUM SKIN TONE, BALD" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9B3 }, 4, "MAN: MEDIUM SKIN TONE, WHITE HAIR" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9BC }, 4, "MAN IN MOTORIZED WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9BD }, 4, "MAN IN MANUAL WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FD, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FE }, 2, "MAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2695, 0xFE0F }, 5, "MAN HEALTH WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2696, 0xFE0F }, 5, "MAN JUDGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2708, 0xFE0F }, 5, "MAN PILOT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: MAN, MAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: MAN, MAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: MAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: MAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: MAN, MAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: MAN, MAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F33E }, 4, "MAN FARMER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F373 }, 4, "MAN COOK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F37C }, 4, "MAN FEEDING BABY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F393 }, 4, "MAN STUDENT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F3A4 }, 4, "MAN SINGER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F3A8 }, 4, "MAN ARTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F3EB }, 4, "MAN TEACHER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F3ED }, 4, "MAN FACTORY WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F4BB }, 4, "MAN TECHNOLOGIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F4BC }, 4, "MAN OFFICE WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F527 }, 4, "MAN MECHANIC: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F52C }, 4, "MAN SCIENTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F680 }, 4, "MAN ASTRONAUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F692 }, 4, "MAN FIREFIGHTER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "MEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "MEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "MEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "MEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9AF }, 4, "MAN WITH WHITE CANE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WITH WHITE CANE FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9B0 }, 4, "MAN: MEDIUM-DARK SKIN TONE, RED HAIR" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9B1 }, 4, "MAN: MEDIUM-DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9B2 }, 4, "MAN: MEDIUM-DARK SKIN TONE, BALD" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9B3 }, 4, "MAN: MEDIUM-DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9BC }, 4, "MAN IN MOTORIZED WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9BD }, 4, "MAN IN MANUAL WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FE, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF }, 2, "MAN: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2695, 0xFE0F }, 5, "MAN HEALTH WORKER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2696, 0xFE0F }, 5, "MAN JUDGE: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2708, 0xFE0F }, 5, "MAN PILOT: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: MAN, MAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: MAN, MAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: MAN, MAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: MAN, MAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: MAN, MAN, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: MAN, MAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: MAN, MAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: MAN, MAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: MAN, MAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: MAN, MAN, DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F33E }, 4, "MAN FARMER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F373 }, 4, "MAN COOK: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F37C }, 4, "MAN FEEDING BABY: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F393 }, 4, "MAN STUDENT: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F3A4 }, 4, "MAN SINGER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F3A8 }, 4, "MAN ARTIST: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F3EB }, 4, "MAN TEACHER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F3ED }, 4, "MAN FACTORY WORKER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F4BB }, 4, "MAN TECHNOLOGIST: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F4BC }, 4, "MAN OFFICE WORKER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F527 }, 4, "MAN MECHANIC: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F52C }, 4, "MAN SCIENTIST: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F680 }, 4, "MAN ASTRONAUT: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F692 }, 4, "MAN FIREFIGHTER: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "MEN HOLDING HANDS: DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "MEN HOLDING HANDS: DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "MEN HOLDING HANDS: DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "MEN HOLDING HANDS: DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9AF }, 4, "MAN WITH WHITE CANE: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WITH WHITE CANE FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9B0 }, 4, "MAN: DARK SKIN TONE, RED HAIR" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9B1 }, 4, "MAN: DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9B2 }, 4, "MAN: DARK SKIN TONE, BALD" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9B3 }, 4, "MAN: DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9BC }, 4, "MAN IN MOTORIZED WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MOTORIZED WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9BD }, 4, "MAN IN MANUAL WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F468, 0x1F3FF, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN IN MANUAL WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F469 }, 1, "WOMAN" },
    { { 0x1F469, 0x200D, 0x2695, 0xFE0F }, 4, "WOMAN HEALTH WORKER" },
    { { 0x1F469, 0x200D, 0x2696, 0xFE0F }, 4, "WOMAN JUDGE" },
    { { 0x1F469, 0x200D, 0x2708, 0xFE0F }, 4, "WOMAN PILOT" },
    { { 0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468 }, 6, "COUPLE WITH HEART: WOMAN, MAN" },
    { { 0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469 }, 6, "COUPLE WITH HEART: WOMAN, WOMAN" },
    { { 0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468 }, 8, "KISS: WOMAN, MAN" },
    { { 0x1F469, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469 }, 8, "KISS: WOMAN, WOMAN" },
    { { 0x1F469, 0x200D, 0x1F33E }, 3, "WOMAN FARMER" },
    { { 0x1F469, 0x200D, 0x1F373 }, 3, "WOMAN COOK" },
    { { 0x1F469, 0x200D, 0x1F37C }, 3, "WOMAN FEEDING BABY" },
    { { 0x1F469, 0x200D, 0x1F393 }, 3, "WOMAN STUDENT" },
    { { 0x1F469, 0x200D, 0x1F3A4 }, 3, "WOMAN SINGER" },
    { { 0x1F469, 0x200D, 0x1F3A8 }, 3, "WOMAN ARTIST" },
    { { 0x1F469, 0x200D, 0x1F3EB }, 3, "WOMAN TEACHER" },
    { { 0x1F469, 0x200D, 0x1F3ED }, 3, "WOMAN FACTORY WORKER" },
    { { 0x1F469, 0x200D, 0x1F466 }, 3, "FAMILY: WOMAN, BOY" },
    { { 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466 }, 5, "FAMILY: WOMAN, BOY, BOY" },
    { { 0x1F469, 0x200D, 0x1F467 }, 3, "FAMILY: WOMAN, GIRL" },
    { { 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466 }, 5, "FAMILY: WOMAN, GIRL, BOY" },
    { { 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467 }, 5, "FAMILY: WOMAN, GIRL, GIRL" },
    { { 0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466 }, 5, "FAMILY: WOMAN, WOMAN, BOY" },
    { { 0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F466, 0x200D, 0x1F466 }, 7, "FAMILY: WOMAN, WOMAN, BOY, BOY" },
    { { 0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467 }, 5, "FAMILY: WOMAN, WOMAN, GIRL" },
    { { 0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F466 }, 7, "FAMILY: WOMAN, WOMAN, GIRL, BOY" },
    { { 0x1F469, 0x200D, 0x1F469, 0x200D, 0x1F467, 0x200D, 0x1F467 }, 7, "FAMILY: WOMAN, WOMAN, GIRL, GIRL" },
    { { 0x1F469, 0x200D, 0x1F4BB }, 3, "WOMAN TECHNOLOGIST" },
    { { 0x1F469, 0x200D, 0x1F4BC }, 3, "WOMAN OFFICE WORKER" },
    { { 0x1F469, 0x200D, 0x1F527 }, 3, "WOMAN MECHANIC" },
    { { 0x1F469, 0x200D, 0x1F52C }, 3, "WOMAN SCIENTIST" },
    { { 0x1F469, 0x200D, 0x1F680 }, 3, "WOMAN ASTRONAUT" },
    { { 0x1F469, 0x200D, 0x1F692 }, 3, "WOMAN FIREFIGHTER" },
    { { 0x1F469, 0x200D, 0x1F9AF }, 3, "WOMAN WITH WHITE CANE" },
    { { 0x1F469, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 6, "WOMAN WITH WHITE CANE FACING RIGHT" },
    { { 0x1F469, 0x200D, 0x1F9B0 }, 3, "WOMAN: RED HAIR" },
    { { 0x1F469, 0x200D, 0x1F9B1 }, 3, "WOMAN: CURLY HAIR" },
    { { 0x1F469, 0x200D, 0x1F9B2 }, 3, "WOMAN: BALD" },
    { { 0x1F469, 0x200D, 0x1F9B3 }, 3, "WOMAN: WHITE HAIR" },
    { { 0x1F469, 0x200D, 0x1F9BC }, 3, "WOMAN IN MOTORIZED WHEELCHAIR" },
    { { 0x1F469, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 6, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT" },
    { { 0x1F469, 0x200D, 0x1F9BD }, 3, "WOMAN IN MANUAL WHEELCHAIR" },
    { { 0x1F469, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 6, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT" },
    { { 0x1F469, 0x1F3FB }, 2, "WOMAN: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2695, 0xFE0F }, 5, "WOMAN HEALTH WORKER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2696, 0xFE0F }, 5, "WOMAN JUDGE: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2708, 0xFE0F }, 5, "WOMAN PILOT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, MAN, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, MAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: WOMAN, MAN, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: WOMAN, MAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: WOMAN, MAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB }, 10, "KISS: WOMAN, WOMAN, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC }, 10, "KISS: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD }, 10, "KISS: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE }, 10, "KISS: WOMAN, WOMAN, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF }, 10, "KISS: WOMAN, WOMAN, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F33E }, 4, "WOMAN FARMER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F373 }, 4, "WOMAN COOK: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F37C }, 4, "WOMAN FEEDING BABY: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F393 }, 4, "WOMAN STUDENT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F3A4 }, 4, "WOMAN SINGER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F3A8 }, 4, "WOMAN ARTIST: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F3EB }, 4, "WOMAN TEACHER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F3ED }, 4, "WOMAN FACTORY WORKER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F4BB }, 4, "WOMAN TECHNOLOGIST: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F4BC }, 4, "WOMAN OFFICE WORKER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F527 }, 4, "WOMAN MECHANIC: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F52C }, 4, "WOMAN SCIENTIST: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F680 }, 4, "WOMAN ASTRONAUT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F692 }, 4, "WOMAN FIREFIGHTER: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "WOMAN AND MAN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "WOMAN AND MAN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "WOMAN AND MAN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "WOMAN AND MAN HOLDING HANDS: LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC }, 7, "WOMEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD }, 7, "WOMEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE }, 7, "WOMEN HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF }, 7, "WOMEN HOLDING HANDS: LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9AF }, 4, "WOMAN WITH WHITE CANE: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WITH WHITE CANE FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9B0 }, 4, "WOMAN: LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9B1 }, 4, "WOMAN: LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9B2 }, 4, "WOMAN: LIGHT SKIN TONE, BALD" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9B3 }, 4, "WOMAN: LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9BC }, 4, "WOMAN IN MOTORIZED WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9BD }, 4, "WOMAN IN MANUAL WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FB, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC }, 2, "WOMAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2695, 0xFE0F }, 5, "WOMAN HEALTH WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2696, 0xFE0F }, 5, "WOMAN JUDGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2708, 0xFE0F }, 5, "WOMAN PILOT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: WOMAN, MAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB }, 10, "KISS: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC }, 10, "KISS: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD }, 10, "KISS: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE }, 10, "KISS: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF }, 10, "KISS: WOMAN, WOMAN, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F33E }, 4, "WOMAN FARMER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F373 }, 4, "WOMAN COOK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F37C }, 4, "WOMAN FEEDING BABY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F393 }, 4, "WOMAN STUDENT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F3A4 }, 4, "WOMAN SINGER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F3A8 }, 4, "WOMAN ARTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F3EB }, 4, "WOMAN TEACHER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F3ED }, 4, "WOMAN FACTORY WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F4BB }, 4, "WOMAN TECHNOLOGIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F4BC }, 4, "WOMAN OFFICE WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F527 }, 4, "WOMAN MECHANIC: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F52C }, 4, "WOMAN SCIENTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F680 }, 4, "WOMAN ASTRONAUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F692 }, 4, "WOMAN FIREFIGHTER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB }, 7, "WOMEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD }, 7, "WOMEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE }, 7, "WOMEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF }, 7, "WOMEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9AF }, 4, "WOMAN WITH WHITE CANE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WITH WHITE CANE FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9B0 }, 4, "WOMAN: MEDIUM-LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9B1 }, 4, "WOMAN: MEDIUM-LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9B2 }, 4, "WOMAN: MEDIUM-LIGHT SKIN TONE, BALD" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9B3 }, 4, "WOMAN: MEDIUM-LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9BC }, 4, "WOMAN IN MOTORIZED WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9BD }, 4, "WOMAN IN MANUAL WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FC, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD }, 2, "WOMAN: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2695, 0xFE0F }, 5, "WOMAN HEALTH WORKER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2696, 0xFE0F }, 5, "WOMAN JUDGE: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2708, 0xFE0F }, 5, "WOMAN PILOT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: WOMAN, MAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: WOMAN, MAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: WOMAN, MAN, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: WOMAN, MAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: WOMAN, MAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB }, 10, "KISS: WOMAN, WOMAN, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC }, 10, "KISS: WOMAN, WOMAN, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD }, 10, "KISS: WOMAN, WOMAN, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE }, 10, "KISS: WOMAN, WOMAN, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF }, 10, "KISS: WOMAN, WOMAN, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F33E }, 4, "WOMAN FARMER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F373 }, 4, "WOMAN COOK: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F37C }, 4, "WOMAN FEEDING BABY: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F393 }, 4, "WOMAN STUDENT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F3A4 }, 4, "WOMAN SINGER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F3A8 }, 4, "WOMAN ARTIST: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F3EB }, 4, "WOMAN TEACHER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F3ED }, 4, "WOMAN FACTORY WORKER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F4BB }, 4, "WOMAN TECHNOLOGIST: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F4BC }, 4, "WOMAN OFFICE WORKER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F527 }, 4, "WOMAN MECHANIC: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F52C }, 4, "WOMAN SCIENTIST: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F680 }, 4, "WOMAN ASTRONAUT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F692 }, 4, "WOMAN FIREFIGHTER: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB }, 7, "WOMEN HOLDING HANDS: MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC }, 7, "WOMEN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE }, 7, "WOMEN HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF }, 7, "WOMEN HOLDING HANDS: MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9AF }, 4, "WOMAN WITH WHITE CANE: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WITH WHITE CANE FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9B0 }, 4, "WOMAN: MEDIUM SKIN TONE, RED HAIR" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9B1 }, 4, "WOMAN: MEDIUM SKIN TONE, CURLY HAIR" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9B2 }, 4, "WOMAN: MEDIUM SKIN TONE, BALD" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9B3 }, 4, "WOMAN: MEDIUM SKIN TONE, WHITE HAIR" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9BC }, 4, "WOMAN IN MOTORIZED WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9BD }, 4, "WOMAN IN MANUAL WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FD, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE }, 2, "WOMAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2695, 0xFE0F }, 5, "WOMAN HEALTH WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2696, 0xFE0F }, 5, "WOMAN JUDGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2708, 0xFE0F }, 5, "WOMAN PILOT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, MAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: WOMAN, MAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: WOMAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: WOMAN, MAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: WOMAN, MAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: WOMAN, MAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB }, 10, "KISS: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC }, 10, "KISS: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD }, 10, "KISS: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE }, 10, "KISS: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF }, 10, "KISS: WOMAN, WOMAN, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F33E }, 4, "WOMAN FARMER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F373 }, 4, "WOMAN COOK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F37C }, 4, "WOMAN FEEDING BABY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F393 }, 4, "WOMAN STUDENT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F3A4 }, 4, "WOMAN SINGER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F3A8 }, 4, "WOMAN ARTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F3EB }, 4, "WOMAN TEACHER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F3ED }, 4, "WOMAN FACTORY WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F4BB }, 4, "WOMAN TECHNOLOGIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F4BC }, 4, "WOMAN OFFICE WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F527 }, 4, "WOMAN MECHANIC: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F52C }, 4, "WOMAN SCIENTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F680 }, 4, "WOMAN ASTRONAUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F692 }, 4, "WOMAN FIREFIGHTER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FF }, 7, "WOMAN AND MAN HOLDING HANDS: MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB }, 7, "WOMEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC }, 7, "WOMEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD }, 7, "WOMEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FF }, 7, "WOMEN HOLDING HANDS: MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9AF }, 4, "WOMAN WITH WHITE CANE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WITH WHITE CANE FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9B0 }, 4, "WOMAN: MEDIUM-DARK SKIN TONE, RED HAIR" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9B1 }, 4, "WOMAN: MEDIUM-DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9B2 }, 4, "WOMAN: MEDIUM-DARK SKIN TONE, BALD" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9B3 }, 4, "WOMAN: MEDIUM-DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9BC }, 4, "WOMAN IN MOTORIZED WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9BD }, 4, "WOMAN IN MANUAL WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FE, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF }, 2, "WOMAN: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2695, 0xFE0F }, 5, "WOMAN HEALTH WORKER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2696, 0xFE0F }, 5, "WOMAN JUDGE: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2708, 0xFE0F }, 5, "WOMAN PILOT: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, MAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, MAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, MAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, MAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F468, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, MAN, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FB }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FC }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FD }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FE }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F469, 0x1F3FF }, 8, "COUPLE WITH HEART: WOMAN, WOMAN, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FB }, 10, "KISS: WOMAN, MAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FC }, 10, "KISS: WOMAN, MAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FD }, 10, "KISS: WOMAN, MAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FE }, 10, "KISS: WOMAN, MAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F468, 0x1F3FF }, 10, "KISS: WOMAN, MAN, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FB }, 10, "KISS: WOMAN, WOMAN, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FC }, 10, "KISS: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FD }, 10, "KISS: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FE }, 10, "KISS: WOMAN, WOMAN, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F469, 0x1F3FF }, 10, "KISS: WOMAN, WOMAN, DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F33E }, 4, "WOMAN FARMER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F373 }, 4, "WOMAN COOK: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F37C }, 4, "WOMAN FEEDING BABY: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F393 }, 4, "WOMAN STUDENT: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F3A4 }, 4, "WOMAN SINGER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F3A8 }, 4, "WOMAN ARTIST: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F3EB }, 4, "WOMAN TEACHER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F3ED }, 4, "WOMAN FACTORY WORKER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F4BB }, 4, "WOMAN TECHNOLOGIST: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F4BC }, 4, "WOMAN OFFICE WORKER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F527 }, 4, "WOMAN MECHANIC: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F52C }, 4, "WOMAN SCIENTIST: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F680 }, 4, "WOMAN ASTRONAUT: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F692 }, 4, "WOMAN FIREFIGHTER: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FB }, 7, "WOMAN AND MAN HOLDING HANDS: DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FC }, 7, "WOMAN AND MAN HOLDING HANDS: DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FD }, 7, "WOMAN AND MAN HOLDING HANDS: DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F468, 0x1F3FE }, 7, "WOMAN AND MAN HOLDING HANDS: DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FB }, 7, "WOMEN HOLDING HANDS: DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FC }, 7, "WOMEN HOLDING HANDS: DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FD }, 7, "WOMEN HOLDING HANDS: DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F469, 0x1F3FE }, 7, "WOMEN HOLDING HANDS: DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9AF }, 4, "WOMAN WITH WHITE CANE: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WITH WHITE CANE FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9B0 }, 4, "WOMAN: DARK SKIN TONE, RED HAIR" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9B1 }, 4, "WOMAN: DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9B2 }, 4, "WOMAN: DARK SKIN TONE, BALD" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9B3 }, 4, "WOMAN: DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9BC }, 4, "WOMAN IN MOTORIZED WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MOTORIZED WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9BD }, 4, "WOMAN IN MANUAL WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F469, 0x1F3FF, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN IN MANUAL WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F46A }, 1, "FAMILY" },
    { { 0x1F46B }, 1, "WOMAN AND MAN HOLDING HANDS" },
    { { 0x1F46B, 0x1F3FB }, 2, "WOMAN AND MAN HOLDING HANDS: LIGHT SKIN TONE" },
    { { 0x1F46B, 0x1F3FC }, 2, "WOMAN AND MAN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46B, 0x1F3FD }, 2, "WOMAN AND MAN HOLDING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F46B, 0x1F3FE }, 2, "WOMAN AND MAN HOLDING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46B, 0x1F3FF }, 2, "WOMAN AND MAN HOLDING HANDS: DARK SKIN TONE" },
    { { 0x1F46C }, 1, "MEN HOLDING HANDS" },
    { { 0x1F46C, 0x1F3FB }, 2, "MEN HOLDING HANDS: LIGHT SKIN TONE" },
    { { 0x1F46C, 0x1F3FC }, 2, "MEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46C, 0x1F3FD }, 2, "MEN HOLDING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F46C, 0x1F3FE }, 2, "MEN HOLDING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46C, 0x1F3FF }, 2, "MEN HOLDING HANDS: DARK SKIN TONE" },
    { { 0x1F46D }, 1, "WOMEN HOLDING HANDS" },
    { { 0x1F46D, 0x1F3FB }, 2, "WOMEN HOLDING HANDS: LIGHT SKIN TONE" },
    { { 0x1F46D, 0x1F3FC }, 2, "WOMEN HOLDING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46D, 0x1F3FD }, 2, "WOMEN HOLDING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F46D, 0x1F3FE }, 2, "WOMEN HOLDING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46D, 0x1F3FF }, 2, "WOMEN HOLDING HANDS: DARK SKIN TONE" },
    { { 0x1F46E }, 1, "POLICE OFFICER" },
    { { 0x1F46E, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN POLICE OFFICER" },
    { { 0x1F46E, 0x200D, 0x2642, 0xFE0F }, 4, "MAN POLICE OFFICER" },
    { { 0x1F46E, 0x1F3FB }, 2, "POLICE OFFICER: LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POLICE OFFICER: LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POLICE OFFICER: LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FC }, 2, "POLICE OFFICER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POLICE OFFICER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POLICE OFFICER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F46E, 0x1F3FD }, 2, "POLICE OFFICER: MEDIUM SKIN TONE" },
    { { 0x1F46E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POLICE OFFICER: MEDIUM SKIN TONE" },
    { { 0x1F46E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POLICE OFFICER: MEDIUM SKIN TONE" },
    { { 0x1F46E, 0x1F3FE }, 2, "POLICE OFFICER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POLICE OFFICER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POLICE OFFICER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F46E, 0x1F3FF }, 2, "POLICE OFFICER: DARK SKIN TONE" },
    { { 0x1F46E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POLICE OFFICER: DARK SKIN TONE" },
    { { 0x1F46E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POLICE OFFICER: DARK SKIN TONE" },
    { { 0x1F46F }, 1, "PEOPLE WITH BUNNY EARS" },
    { { 0x1F46F, 0x200D, 0x2640, 0xFE0F }, 4, "WOMEN WITH BUNNY EARS" },
    { { 0x1F46F, 0x200D, 0x2642, 0xFE0F }, 4, "MEN WITH BUNNY EARS" },
    { { 0x1F470 }, 1, "PERSON WITH VEIL" },
    { { 0x1F470, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN WITH VEIL" },
    { { 0x1F470, 0x200D, 0x2642, 0xFE0F }, 4, "MAN WITH VEIL" },
    { { 0x1F470, 0x1F3FB }, 2, "PERSON WITH VEIL: LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WITH VEIL: LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WITH VEIL: LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FC }, 2, "PERSON WITH VEIL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WITH VEIL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WITH VEIL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F470, 0x1F3FD }, 2, "PERSON WITH VEIL: MEDIUM SKIN TONE" },
    { { 0x1F470, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WITH VEIL: MEDIUM SKIN TONE" },
    { { 0x1F470, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WITH VEIL: MEDIUM SKIN TONE" },
    { { 0x1F470, 0x1F3FE }, 2, "PERSON WITH VEIL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F470, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WITH VEIL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F470, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WITH VEIL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F470, 0x1F3FF }, 2, "PERSON WITH VEIL: DARK SKIN TONE" },
    { { 0x1F470, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WITH VEIL: DARK SKIN TONE" },
    { { 0x1F470, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WITH VEIL: DARK SKIN TONE" },
    { { 0x1F471 }, 1, "PERSON: BLOND HAIR" },
    { { 0x1F471, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN: BLOND HAIR" },
    { { 0x1F471, 0x200D, 0x2642, 0xFE0F }, 4, "MAN: BLOND HAIR" },
    { { 0x1F471, 0x1F3FB }, 2, "PERSON: LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FC }, 2, "PERSON: MEDIUM-LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM-LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM-LIGHT SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FD }, 2, "PERSON: MEDIUM SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FE }, 2, "PERSON: MEDIUM-DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM-DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM-DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FF }, 2, "PERSON: DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F471, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: DARK SKIN TONE, BLOND HAIR" },
    { { 0x1F472 }, 1, "PERSON WITH SKULLCAP" },
    { { 0x1F472, 0x1F3FB }, 2, "PERSON WITH SKULLCAP: LIGHT SKIN TONE" },
    { { 0x1F472, 0x1F3FC }, 2, "PERSON WITH SKULLCAP: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F472, 0x1F3FD }, 2, "PERSON WITH SKULLCAP: MEDIUM SKIN TONE" },
    { { 0x1F472, 0x1F3FE }, 2, "PERSON WITH SKULLCAP: MEDIUM-DARK SKIN TONE" },
    { { 0x1F472, 0x1F3FF }, 2, "PERSON WITH SKULLCAP: DARK SKIN TONE" },
    { { 0x1F473 }, 1, "PERSON WEARING TURBAN" },
    { { 0x1F473, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN WEARING TURBAN" },
    { { 0x1F473, 0x200D, 0x2642, 0xFE0F }, 4, "MAN WEARING TURBAN" },
    { { 0x1F473, 0x1F3FB }, 2, "PERSON WEARING TURBAN: LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WEARING TURBAN: LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WEARING TURBAN: LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FC }, 2, "PERSON WEARING TURBAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WEARING TURBAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WEARING TURBAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F473, 0x1F3FD }, 2, "PERSON WEARING TURBAN: MEDIUM SKIN TONE" },
    { { 0x1F473, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WEARING TURBAN: MEDIUM SKIN TONE" },
    { { 0x1F473, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WEARING TURBAN: MEDIUM SKIN TONE" },
    { { 0x1F473, 0x1F3FE }, 2, "PERSON WEARING TURBAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F473, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WEARING TURBAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F473, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WEARING TURBAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F473, 0x1F3FF }, 2, "PERSON WEARING TURBAN: DARK SKIN TONE" },
    { { 0x1F473, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WEARING TURBAN: DARK SKIN TONE" },
    { { 0x1F473, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WEARING TURBAN: DARK SKIN TONE" },
    { { 0x1F474 }, 1, "OLD MAN" },
    { { 0x1F474, 0x1F3FB }, 2, "OLD MAN: LIGHT SKIN TONE" },
    { { 0x1F474, 0x1F3FC }, 2, "OLD MAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F474, 0x1F3FD }, 2, "OLD MAN: MEDIUM SKIN TONE" },
    { { 0x1F474, 0x1F3FE }, 2, "OLD MAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F474, 0x1F3FF }, 2, "OLD MAN: DARK SKIN TONE" },
    { { 0x1F475 }, 1, "OLD WOMAN" },
    { { 0x1F475, 0x1F3FB }, 2, "OLD WOMAN: LIGHT SKIN TONE" },
    { { 0x1F475, 0x1F3FC }, 2, "OLD WOMAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F475, 0x1F3FD }, 2, "OLD WOMAN: MEDIUM SKIN TONE" },
    { { 0x1F475, 0x1F3FE }, 2, "OLD WOMAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F475, 0x1F3FF }, 2, "OLD WOMAN: DARK SKIN TONE" },
    { { 0x1F476 }, 1, "BABY" },
    { { 0x1F476, 0x1F3FB }, 2, "BABY: LIGHT SKIN TONE" },
    { { 0x1F476, 0x1F3FC }, 2, "BABY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F476, 0x1F3FD }, 2, "BABY: MEDIUM SKIN TONE" },
    { { 0x1F476, 0x1F3FE }, 2, "BABY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F476, 0x1F3FF }, 2, "BABY: DARK SKIN TONE" },
    { { 0x1F477 }, 1, "CONSTRUCTION WORKER" },
    { { 0x1F477, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN CONSTRUCTION WORKER" },
    { { 0x1F477, 0x200D, 0x2642, 0xFE0F }, 4, "MAN CONSTRUCTION WORKER" },
    { { 0x1F477, 0x1F3FB }, 2, "CONSTRUCTION WORKER: LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CONSTRUCTION WORKER: LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CONSTRUCTION WORKER: LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FC }, 2, "CONSTRUCTION WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CONSTRUCTION WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CONSTRUCTION WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F477, 0x1F3FD }, 2, "CONSTRUCTION WORKER: MEDIUM SKIN TONE" },
    { { 0x1F477, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CONSTRUCTION WORKER: MEDIUM SKIN TONE" },
    { { 0x1F477, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CONSTRUCTION WORKER: MEDIUM SKIN TONE" },
    { { 0x1F477, 0x1F3FE }, 2, "CONSTRUCTION WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F477, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CONSTRUCTION WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F477, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CONSTRUCTION WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F477, 0x1F3FF }, 2, "CONSTRUCTION WORKER: DARK SKIN TONE" },
    { { 0x1F477, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CONSTRUCTION WORKER: DARK SKIN TONE" },
    { { 0x1F477, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CONSTRUCTION WORKER: DARK SKIN TONE" },
    { { 0x1F478 }, 1, "PRINCESS" },
    { { 0x1F478, 0x1F3FB }, 2, "PRINCESS: LIGHT SKIN TONE" },
    { { 0x1F478, 0x1F3FC }, 2, "PRINCESS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F478, 0x1F3FD }, 2, "PRINCESS: MEDIUM SKIN TONE" },
    { { 0x1F478, 0x1F3FE }, 2, "PRINCESS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F478, 0x1F3FF }, 2, "PRINCESS: DARK SKIN TONE" },
    { { 0x1F479 }, 1, "OGRE" },
    { { 0x1F47A }, 1, "GOBLIN" },
    { { 0x1F47B }, 1, "GHOST" },
    { { 0x1F47C }, 1, "BABY ANGEL" },
    { { 0x1F47C, 0x1F3FB }, 2, "BABY ANGEL: LIGHT SKIN TONE" },
    { { 0x1F47C, 0x1F3FC }, 2, "BABY ANGEL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F47C, 0x1F3FD }, 2, "BABY ANGEL: MEDIUM SKIN TONE" },
    { { 0x1F47C, 0x1F3FE }, 2, "BABY ANGEL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F47C, 0x1F3FF }, 2, "BABY ANGEL: DARK SKIN TONE" },
    { { 0x1F47D }, 1, "ALIEN" },
    { { 0x1F47E }, 1, "ALIEN MONSTER" },
    { { 0x1F47F }, 1, "ANGRY FACE WITH HORNS" },
    { { 0x1F480 }, 1, "SKULL" },
    { { 0x1F481 }, 1, "PERSON TIPPING HAND" },
    { { 0x1F481, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN TIPPING HAND" },
    { { 0x1F481, 0x200D, 0x2642, 0xFE0F }, 4, "MAN TIPPING HAND" },
    { { 0x1F481, 0x1F3FB }, 2, "PERSON TIPPING HAND: LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN TIPPING HAND: LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN TIPPING HAND: LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FC }, 2, "PERSON TIPPING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN TIPPING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN TIPPING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F481, 0x1F3FD }, 2, "PERSON TIPPING HAND: MEDIUM SKIN TONE" },
    { { 0x1F481, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN TIPPING HAND: MEDIUM SKIN TONE" },
    { { 0x1F481, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN TIPPING HAND: MEDIUM SKIN TONE" },
    { { 0x1F481, 0x1F3FE }, 2, "PERSON TIPPING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F481, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN TIPPING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F481, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN TIPPING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F481, 0x1F3FF }, 2, "PERSON TIPPING HAND: DARK SKIN TONE" },
    { { 0x1F481, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN TIPPING HAND: DARK SKIN TONE" },
    { { 0x1F481, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN TIPPING HAND: DARK SKIN TONE" },
    { { 0x1F482 }, 1, "GUARD" },
    { { 0x1F482, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GUARD" },
    { { 0x1F482, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GUARD" },
    { { 0x1F482, 0x1F3FB }, 2, "GUARD: LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GUARD: LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GUARD: LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FC }, 2, "GUARD: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GUARD: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GUARD: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F482, 0x1F3FD }, 2, "GUARD: MEDIUM SKIN TONE" },
    { { 0x1F482, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GUARD: MEDIUM SKIN TONE" },
    { { 0x1F482, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GUARD: MEDIUM SKIN TONE" },
    { { 0x1F482, 0x1F3FE }, 2, "GUARD: MEDIUM-DARK SKIN TONE" },
    { { 0x1F482, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GUARD: MEDIUM-DARK SKIN TONE" },
    { { 0x1F482, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GUARD: MEDIUM-DARK SKIN TONE" },
    { { 0x1F482, 0x1F3FF }, 2, "GUARD: DARK SKIN TONE" },
    { { 0x1F482, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GUARD: DARK SKIN TONE" },
    { { 0x1F482, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GUARD: DARK SKIN TONE" },
    { { 0x1F483 }, 1, "WOMAN DANCING" },
    { { 0x1F483, 0x1F3FB }, 2, "WOMAN DANCING: LIGHT SKIN TONE" },
    { { 0x1F483, 0x1F3FC }, 2, "WOMAN DANCING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F483, 0x1F3FD }, 2, "WOMAN DANCING: MEDIUM SKIN TONE" },
    { { 0x1F483, 0x1F3FE }, 2, "WOMAN DANCING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F483, 0x1F3FF }, 2, "WOMAN DANCING: DARK SKIN TONE" },
    { { 0x1F484 }, 1, "LIPSTICK" },
    { { 0x1F485 }, 1, "NAIL POLISH" },
    { { 0x1F485, 0x1F3FB }, 2, "NAIL POLISH: LIGHT SKIN TONE" },
    { { 0x1F485, 0x1F3FC }, 2, "NAIL POLISH: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F485, 0x1F3FD }, 2, "NAIL POLISH: MEDIUM SKIN TONE" },
    { { 0x1F485, 0x1F3FE }, 2, "NAIL POLISH: MEDIUM-DARK SKIN TONE" },
    { { 0x1F485, 0x1F3FF }, 2, "NAIL POLISH: DARK SKIN TONE" },
    { { 0x1F486 }, 1, "PERSON GETTING MASSAGE" },
    { { 0x1F486, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GETTING MASSAGE" },
    { { 0x1F486, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GETTING MASSAGE" },
    { { 0x1F486, 0x1F3FB }, 2, "PERSON GETTING MASSAGE: LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING MASSAGE: LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING MASSAGE: LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FC }, 2, "PERSON GETTING MASSAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING MASSAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING MASSAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F486, 0x1F3FD }, 2, "PERSON GETTING MASSAGE: MEDIUM SKIN TONE" },
    { { 0x1F486, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING MASSAGE: MEDIUM SKIN TONE" },
    { { 0x1F486, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING MASSAGE: MEDIUM SKIN TONE" },
    { { 0x1F486, 0x1F3FE }, 2, "PERSON GETTING MASSAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F486, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING MASSAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F486, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING MASSAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F486, 0x1F3FF }, 2, "PERSON GETTING MASSAGE: DARK SKIN TONE" },
    { { 0x1F486, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING MASSAGE: DARK SKIN TONE" },
    { { 0x1F486, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING MASSAGE: DARK SKIN TONE" },
    { { 0x1F487 }, 1, "PERSON GETTING HAIRCUT" },
    { { 0x1F487, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GETTING HAIRCUT" },
    { { 0x1F487, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GETTING HAIRCUT" },
    { { 0x1F487, 0x1F3FB }, 2, "PERSON GETTING HAIRCUT: LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING HAIRCUT: LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING HAIRCUT: LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FC }, 2, "PERSON GETTING HAIRCUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING HAIRCUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING HAIRCUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F487, 0x1F3FD }, 2, "PERSON GETTING HAIRCUT: MEDIUM SKIN TONE" },
    { { 0x1F487, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING HAIRCUT: MEDIUM SKIN TONE" },
    { { 0x1F487, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING HAIRCUT: MEDIUM SKIN TONE" },
    { { 0x1F487, 0x1F3FE }, 2, "PERSON GETTING HAIRCUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F487, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING HAIRCUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F487, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING HAIRCUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F487, 0x1F3FF }, 2, "PERSON GETTING HAIRCUT: DARK SKIN TONE" },
    { { 0x1F487, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GETTING HAIRCUT: DARK SKIN TONE" },
    { { 0x1F487, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GETTING HAIRCUT: DARK SKIN TONE" },
    { { 0x1F488 }, 1, "BARBER POLE" },
    { { 0x1F489 }, 1, "SYRINGE" },
    { { 0x1F48A }, 1, "PILL" },
    { { 0x1F48B }, 1, "KISS MARK" },
    { { 0x1F48C }, 1, "LOVE LETTER" },
    { { 0x1F48D }, 1, "RING" },
    { { 0x1F48E }, 1, "GEM STONE" },
    { { 0x1F48F }, 1, "KISS" },
    { { 0x1F48F, 0x1F3FB }, 2, "KISS: LIGHT SKIN TONE" },
    { { 0x1F48F, 0x1F3FC }, 2, "KISS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F48F, 0x1F3FD }, 2, "KISS: MEDIUM SKIN TONE" },
    { { 0x1F48F, 0x1F3FE }, 2, "KISS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F48F, 0x1F3FF }, 2, "KISS: DARK SKIN TONE" },
    { { 0x1F490 }, 1, "BOUQUET" },
    { { 0x1F491 }, 1, "COUPLE WITH HEART" },
    { { 0x1F491, 0x1F3FB }, 2, "COUPLE WITH HEART: LIGHT SKIN TONE" },
    { { 0x1F491, 0x1F3FC }, 2, "COUPLE WITH HEART: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F491, 0x1F3FD }, 2, "COUPLE WITH HEART: MEDIUM SKIN TONE" },
    { { 0x1F491, 0x1F3FE }, 2, "COUPLE WITH HEART: MEDIUM-DARK SKIN TONE" },
    { { 0x1F491, 0x1F3FF }, 2, "COUPLE WITH HEART: DARK SKIN TONE" },
    { { 0x1F492 }, 1, "WEDDING" },
    { { 0x1F493 }, 1, "BEATING HEART" },
    { { 0x1F494 }, 1, "BROKEN HEART" },
    { { 0x1F495 }, 1, "TWO HEARTS" },
    { { 0x1F496 }, 1, "SPARKLING HEART" },
    { { 0x1F497 }, 1, "GROWING HEART" },
    { { 0x1F498 }, 1, "HEART WITH ARROW" },
    { { 0x1F499 }, 1, "BLUE HEART" },
    { { 0x1F49A }, 1, "GREEN HEART" },
    { { 0x1F49B }, 1, "YELLOW HEART" },
    { { 0x1F49C }, 1, "PURPLE HEART" },
    { { 0x1F49D }, 1, "HEART WITH RIBBON" },
    { { 0x1F49E }, 1, "REVOLVING HEARTS" },
    { { 0x1F49F }, 1, "HEART DECORATION" },
    { { 0x1F4A0 }, 1, "DIAMOND WITH A DOT" },
    { { 0x1F4A1 }, 1, "LIGHT BULB" },
    { { 0x1F4A2 }, 1, "ANGER SYMBOL" },
    { { 0x1F4A3 }, 1, "BOMB" },
    { { 0x1F4A4 }, 1, "ZZZ" },
    { { 0x1F4A5 }, 1, "COLLISION" },
    { { 0x1F4A6 }, 1, "SWEAT DROPLETS" },
    { { 0x1F4A7 }, 1, "DROPLET" },
    { { 0x1F4A8 }, 1, "DASHING AWAY" },
    { { 0x1F4A9 }, 1, "PILE OF POO" },
    { { 0x1F4AA }, 1, "FLEXED BICEPS" },
    { { 0x1F4AA, 0x1F3FB }, 2, "FLEXED BICEPS: LIGHT SKIN TONE" },
    { { 0x1F4AA, 0x1F3FC }, 2, "FLEXED BICEPS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F4AA, 0x1F3FD }, 2, "FLEXED BICEPS: MEDIUM SKIN TONE" },
    { { 0x1F4AA, 0x1F3FE }, 2, "FLEXED BICEPS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F4AA, 0x1F3FF }, 2, "FLEXED BICEPS: DARK SKIN TONE" },
    { { 0x1F4AB }, 1, "DIZZY" },
    { { 0x1F4AC }, 1, "SPEECH BALLOON" },
    { { 0x1F4AD }, 1, "THOUGHT BALLOON" },
    { { 0x1F4AE }, 1, "WHITE FLOWER" },
    { { 0x1F4AF }, 1, "HUNDRED POINTS" },
    { { 0x1F4B0 }, 1, "MONEY BAG" },
    { { 0x1F4B1 }, 1, "CURRENCY EXCHANGE" },
    { { 0x1F4B2 }, 1, "HEAVY DOLLAR SIGN" },
    { { 0x1F4B3 }, 1, "CREDIT CARD" },
    { { 0x1F4B4 }, 1, "YEN BANKNOTE" },
    { { 0x1F4B5 }, 1, "DOLLAR BANKNOTE" },
    { { 0x1F4B6 }, 1, "EURO BANKNOTE" },
    { { 0x1F4B7 }, 1, "POUND BANKNOTE" },
    { { 0x1F4B8 }, 1, "MONEY WITH WINGS" },
    { { 0x1F4B9 }, 1, "CHART INCREASING WITH YEN" },
    { { 0x1F4BA }, 1, "SEAT" },
    { { 0x1F4BB }, 1, "LAPTOP" },
    { { 0x1F4BC }, 1, "BRIEFCASE" },
    { { 0x1F4BD }, 1, "COMPUTER DISK" },
    { { 0x1F4BE }, 1, "FLOPPY DISK" },
    { { 0x1F4BF }, 1, "OPTICAL DISK" },
    { { 0x1F4C0 }, 1, "DVD" },
    { { 0x1F4C1 }, 1, "FILE FOLDER" },
    { { 0x1F4C2 }, 1, "OPEN FILE FOLDER" },
    { { 0x1F4C3 }, 1, "PAGE WITH CURL" },
    { { 0x1F4C4 }, 1, "PAGE FACING UP" },
    { { 0x1F4C5 }, 1, "CALENDAR" },
    { { 0x1F4C6 }, 1, "TEAR-OFF CALENDAR" },
    { { 0x1F4C7 }, 1, "CARD INDEX" },
    { { 0x1F4C8 }, 1, "CHART INCREASING" },
    { { 0x1F4C9 }, 1, "CHART DECREASING" },
    { { 0x1F4CA }, 1, "BAR CHART" },
    { { 0x1F4CB }, 1, "CLIPBOARD" },
    { { 0x1F4CC }, 1, "PUSHPIN" },
    { { 0x1F4CD }, 1, "ROUND PUSHPIN" },
    { { 0x1F4CE }, 1, "PAPERCLIP" },
    { { 0x1F4CF }, 1, "STRAIGHT RULER" },
    { { 0x1F4D0 }, 1, "TRIANGULAR RULER" },
    { { 0x1F4D1 }, 1, "BOOKMARK TABS" },
    { { 0x1F4D2 }, 1, "LEDGER" },
    { { 0x1F4D3 }, 1, "NOTEBOOK" },
    { { 0x1F4D4 }, 1, "NOTEBOOK WITH DECORATIVE COVER" },
    { { 0x1F4D5 }, 1, "CLOSED BOOK" },
    { { 0x1F4D6 }, 1, "OPEN BOOK" },
    { { 0x1F4D7 }, 1, "GREEN BOOK" },
    { { 0x1F4D8 }, 1, "BLUE BOOK" },
    { { 0x1F4D9 }, 1, "ORANGE BOOK" },
    { { 0x1F4DA }, 1, "BOOKS" },
    { { 0x1F4DB }, 1, "NAME BADGE" },
    { { 0x1F4DC }, 1, "SCROLL" },
    { { 0x1F4DD }, 1, "MEMO" },
    { { 0x1F4DE }, 1, "TELEPHONE RECEIVER" },
    { { 0x1F4DF }, 1, "PAGER" },
    { { 0x1F4E0 }, 1, "FAX MACHINE" },
    { { 0x1F4E1 }, 1, "SATELLITE ANTENNA" },
    { { 0x1F4E2 }, 1, "LOUDSPEAKER" },
    { { 0x1F4E3 }, 1, "MEGAPHONE" },
    { { 0x1F4E4 }, 1, "OUTBOX TRAY" },
    { { 0x1F4E5 }, 1, "INBOX TRAY" },
    { { 0x1F4E6 }, 1, "PACKAGE" },
    { { 0x1F4E7 }, 1, "E-MAIL" },
    { { 0x1F4E8 }, 1, "INCOMING ENVELOPE" },
    { { 0x1F4E9 }, 1, "ENVELOPE WITH ARROW" },
    { { 0x1F4EA }, 1, "CLOSED MAILBOX WITH LOWERED FLAG" },
    { { 0x1F4EB }, 1, "CLOSED MAILBOX WITH RAISED FLAG" },
    { { 0x1F4EC }, 1, "OPEN MAILBOX WITH RAISED FLAG" },
    { { 0x1F4ED }, 1, "OPEN MAILBOX WITH LOWERED FLAG" },
    { { 0x1F4EE }, 1, "POSTBOX" },
    { { 0x1F4EF }, 1, "POSTAL HORN" },
    { { 0x1F4F0 }, 1, "NEWSPAPER" },
    { { 0x1F4F1 }, 1, "MOBILE PHONE" },
    { { 0x1F4F2 }, 1, "MOBILE PHONE WITH ARROW" },
    { { 0x1F4F3 }, 1, "VIBRATION MODE" },
    { { 0x1F4F4 }, 1, "MOBILE PHONE OFF" },
    { { 0x1F4F5 }, 1, "NO MOBILE PHONES" },
    { { 0x1F4F6 }, 1, "ANTENNA BARS" },
    { { 0x1F4F7 }, 1, "CAMERA" },
    { { 0x1F4F8 }, 1, "CAMERA WITH FLASH" },
    { { 0x1F4F9 }, 1, "VIDEO CAMERA" },
    { { 0x1F4FA }, 1, "TELEVISION" },
    { { 0x1F4FB }, 1, "RADIO" },
    { { 0x1F4FC }, 1, "VIDEOCASSETTE" },
    { { 0x1F4FD, 0xFE0F }, 2, "FILM PROJECTOR" },
    { { 0x1F4FF }, 1, "PRAYER BEADS" },
    { { 0x1F500 }, 1, "SHUFFLE TRACKS BUTTON" },
    { { 0x1F501 }, 1, "REPEAT BUTTON" },
    { { 0x1F502 }, 1, "REPEAT SINGLE BUTTON" },
    { { 0x1F503 }, 1, "CLOCKWISE VERTICAL ARROWS" },
    { { 0x1F504 }, 1, "COUNTERCLOCKWISE ARROWS BUTTON" },
    { { 0x1F505 }, 1, "DIM BUTTON" },
    { { 0x1F506 }, 1, "BRIGHT BUTTON" },
    { { 0x1F507 }, 1, "MUTED SPEAKER" },
    { { 0x1F508 }, 1, "SPEAKER LOW VOLUME" },
    { { 0x1F509 }, 1, "SPEAKER MEDIUM VOLUME" },
    { { 0x1F50A }, 1, "SPEAKER HIGH VOLUME" },
    { { 0x1F50B }, 1, "BATTERY" },
    { { 0x1F50C }, 1, "ELECTRIC PLUG" },
    { { 0x1F50D }, 1, "MAGNIFYING GLASS TILTED LEFT" },
    { { 0x1F50E }, 1, "MAGNIFYING GLASS TILTED RIGHT" },
    { { 0x1F50F }, 1, "LOCKED WITH PEN" },
    { { 0x1F510 }, 1, "LOCKED WITH KEY" },
    { { 0x1F511 }, 1, "KEY" },
    { { 0x1F512 }, 1, "LOCKED" },
    { { 0x1F513 }, 1, "UNLOCKED" },
    { { 0x1F514 }, 1, "BELL" },
    { { 0x1F515 }, 1, "BELL WITH SLASH" },
    { { 0x1F516 }, 1, "BOOKMARK" },
    { { 0x1F517 }, 1, "LINK" },
    { { 0x1F518 }, 1, "RADIO BUTTON" },
    { { 0x1F519 }, 1, "BACK ARROW" },
    { { 0x1F51A }, 1, "END ARROW" },
    { { 0x1F51B }, 1, "ON! ARROW" },
    { { 0x1F51C }, 1, "SOON ARROW" },
    { { 0x1F51D }, 1, "TOP ARROW" },
    { { 0x1F51E }, 1, "NO ONE UNDER EIGHTEEN" },
    { { 0x1F51F }, 1, "KEYCAP: 10" },
    { { 0x1F520 }, 1, "INPUT LATIN UPPERCASE" },
    { { 0x1F521 }, 1, "INPUT LATIN LOWERCASE" },
    { { 0x1F522 }, 1, "INPUT NUMBERS" },
    { { 0x1F523 }, 1, "INPUT SYMBOLS" },
    { { 0x1F524 }, 1, "INPUT LATIN LETTERS" },
    { { 0x1F525 }, 1, "FIRE" },
    { { 0x1F526 }, 1, "FLASHLIGHT" },
    { { 0x1F527 }, 1, "WRENCH" },
    { { 0x1F528 }, 1, "HAMMER" },
    { { 0x1F529 }, 1, "NUT AND BOLT" },
    { { 0x1F52A }, 1, "KITCHEN KNIFE" },
    { { 0x1F52B }, 1, "WATER PISTOL" },
    { { 0x1F52C }, 1, "MICROSCOPE" },
    { { 0x1F52D }, 1, "TELESCOPE" },
    { { 0x1F52E }, 1, "CRYSTAL BALL" },
    { { 0x1F52F }, 1, "DOTTED SIX-POINTED STAR" },
    { { 0x1F530 }, 1, "JAPANESE SYMBOL FOR BEGINNER" },
    { { 0x1F531 }, 1, "TRIDENT EMBLEM" },
    { { 0x1F532 }, 1, "BLACK SQUARE BUTTON" },
    { { 0x1F533 }, 1, "WHITE SQUARE BUTTON" },
    { { 0x1F534 }, 1, "RED CIRCLE" },
    { { 0x1F535 }, 1, "BLUE CIRCLE" },
    { { 0x1F536 }, 1, "LARGE ORANGE DIAMOND" },
    { { 0x1F537 }, 1, "LARGE BLUE DIAMOND" },
    { { 0x1F538 }, 1, "SMALL ORANGE DIAMOND" },
    { { 0x1F539 }, 1, "SMALL BLUE DIAMOND" },
    { { 0x1F53A }, 1, "RED TRIANGLE POINTED UP" },
    { { 0x1F53B }, 1, "RED TRIANGLE POINTED DOWN" },
    { { 0x1F53C }, 1, "UPWARDS BUTTON" },
    { { 0x1F53D }, 1, "DOWNWARDS BUTTON" },
    { { 0x1F549, 0xFE0F }, 2, "OM" },
    { { 0x1F54A, 0xFE0F }, 2, "DOVE" },
    { { 0x1F54B }, 1, "KAABA" },
    { { 0x1F54C }, 1, "MOSQUE" },
    { { 0x1F54D }, 1, "SYNAGOGUE" },
    { { 0x1F54E }, 1, "MENORAH" },
    { { 0x1F550 }, 1, "ONE O’CLOCK" },
    { { 0x1F551 }, 1, "TWO O’CLOCK" },
    { { 0x1F552 }, 1, "THREE O’CLOCK" },
    { { 0x1F553 }, 1, "FOUR O’CLOCK" },
    { { 0x1F554 }, 1, "FIVE O’CLOCK" },
    { { 0x1F555 }, 1, "SIX O’CLOCK" },
    { { 0x1F556 }, 1, "SEVEN O’CLOCK" },
    { { 0x1F557 }, 1, "EIGHT O’CLOCK" },
    { { 0x1F558 }, 1, "NINE O’CLOCK" },
    { { 0x1F559 }, 1, "TEN O’CLOCK" },
    { { 0x1F55A }, 1, "ELEVEN O’CLOCK" },
    { { 0x1F55B }, 1, "TWELVE O’CLOCK" },
    { { 0x1F55C }, 1, "ONE-THIRTY" },
    { { 0x1F55D }, 1, "TWO-THIRTY" },
    { { 0x1F55E }, 1, "THREE-THIRTY" },
    { { 0x1F55F }, 1, "FOUR-THIRTY" },
    { { 0x1F560 }, 1, "FIVE-THIRTY" },
    { { 0x1F561 }, 1, "SIX-THIRTY" },
    { { 0x1F562 }, 1, "SEVEN-THIRTY" },
    { { 0x1F563 }, 1, "EIGHT-THIRTY" },
    { { 0x1F564 }, 1, "NINE-THIRTY" },
    { { 0x1F565 }, 1, "TEN-THIRTY" },
    { { 0x1F566 }, 1, "ELEVEN-THIRTY" },
    { { 0x1F567 }, 1, "TWELVE-THIRTY" },
    { { 0x1F56F, 0xFE0F }, 2, "CANDLE" },
    { { 0x1F570, 0xFE0F }, 2, "MANTELPIECE CLOCK" },
    { { 0x1F573, 0xFE0F }, 2, "HOLE" },
    { { 0x1F574, 0xFE0F }, 2, "PERSON IN SUIT LEVITATING" },
    { { 0x1F574, 0x1F3FB }, 2, "PERSON IN SUIT LEVITATING: LIGHT SKIN TONE" },
    { { 0x1F574, 0x1F3FC }, 2, "PERSON IN SUIT LEVITATING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F574, 0x1F3FD }, 2, "PERSON IN SUIT LEVITATING: MEDIUM SKIN TONE" },
    { { 0x1F574, 0x1F3FE }, 2, "PERSON IN SUIT LEVITATING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F574, 0x1F3FF }, 2, "PERSON IN SUIT LEVITATING: DARK SKIN TONE" },
    { { 0x1F575, 0xFE0F }, 2, "DETECTIVE" },
    { { 0x1F575, 0xFE0F, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE" },
    { { 0x1F575, 0xFE0F, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE" },
    { { 0x1F575, 0x1F3FB }, 2, "DETECTIVE: LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE: LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE: LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FC }, 2, "DETECTIVE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F575, 0x1F3FD }, 2, "DETECTIVE: MEDIUM SKIN TONE" },
    { { 0x1F575, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE: MEDIUM SKIN TONE" },
    { { 0x1F575, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE: MEDIUM SKIN TONE" },
    { { 0x1F575, 0x1F3FE }, 2, "DETECTIVE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F575, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F575, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F575, 0x1F3FF }, 2, "DETECTIVE: DARK SKIN TONE" },
    { { 0x1F575, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN DETECTIVE: DARK SKIN TONE" },
    { { 0x1F575, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN DETECTIVE: DARK SKIN TONE" },
    { { 0x1F576, 0xFE0F }, 2, "SUNGLASSES" },
    { { 0x1F577, 0xFE0F }, 2, "SPIDER" },
    { { 0x1F578, 0xFE0F }, 2, "SPIDER WEB" },
    { { 0x1F579, 0xFE0F }, 2, "JOYSTICK" },
    { { 0x1F57A }, 1, "MAN DANCING" },
    { { 0x1F57A, 0x1F3FB }, 2, "MAN DANCING: LIGHT SKIN TONE" },
    { { 0x1F57A, 0x1F3FC }, 2, "MAN DANCING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F57A, 0x1F3FD }, 2, "MAN DANCING: MEDIUM SKIN TONE" },
    { { 0x1F57A, 0x1F3FE }, 2, "MAN DANCING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F57A, 0x1F3FF }, 2, "MAN DANCING: DARK SKIN TONE" },
    { { 0x1F587, 0xFE0F }, 2, "LINKED PAPERCLIPS" },
    { { 0x1F58A, 0xFE0F }, 2, "PEN" },
    { { 0x1F58B, 0xFE0F }, 2, "FOUNTAIN PEN" },
    { { 0x1F58C, 0xFE0F }, 2, "PAINTBRUSH" },
    { { 0x1F58D, 0xFE0F }, 2, "CRAYON" },
    { { 0x1F590, 0xFE0F }, 2, "HAND WITH FINGERS SPLAYED" },
    { { 0x1F590, 0x1F3FB }, 2, "HAND WITH FINGERS SPLAYED: LIGHT SKIN TONE" },
    { { 0x1F590, 0x1F3FC }, 2, "HAND WITH FINGERS SPLAYED: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F590, 0x1F3FD }, 2, "HAND WITH FINGERS SPLAYED: MEDIUM SKIN TONE" },
    { { 0x1F590, 0x1F3FE }, 2, "HAND WITH FINGERS SPLAYED: MEDIUM-DARK SKIN TONE" },
    { { 0x1F590, 0x1F3FF }, 2, "HAND WITH FINGERS SPLAYED: DARK SKIN TONE" },
    { { 0x1F595 }, 1, "MIDDLE FINGER" },
    { { 0x1F595, 0x1F3FB }, 2, "MIDDLE FINGER: LIGHT SKIN TONE" },
    { { 0x1F595, 0x1F3FC }, 2, "MIDDLE FINGER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F595, 0x1F3FD }, 2, "MIDDLE FINGER: MEDIUM SKIN TONE" },
    { { 0x1F595, 0x1F3FE }, 2, "MIDDLE FINGER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F595, 0x1F3FF }, 2, "MIDDLE FINGER: DARK SKIN TONE" },
    { { 0x1F596 }, 1, "VULCAN SALUTE" },
    { { 0x1F596, 0x1F3FB }, 2, "VULCAN SALUTE: LIGHT SKIN TONE" },
    { { 0x1F596, 0x1F3FC }, 2, "VULCAN SALUTE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F596, 0x1F3FD }, 2, "VULCAN SALUTE: MEDIUM SKIN TONE" },
    { { 0x1F596, 0x1F3FE }, 2, "VULCAN SALUTE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F596, 0x1F3FF }, 2, "VULCAN SALUTE: DARK SKIN TONE" },
    { { 0x1F5A4 }, 1, "BLACK HEART" },
    { { 0x1F5A5, 0xFE0F }, 2, "DESKTOP COMPUTER" },
    { { 0x1F5A8, 0xFE0F }, 2, "PRINTER" },
    { { 0x1F5B1, 0xFE0F }, 2, "COMPUTER MOUSE" },
    { { 0x1F5B2, 0xFE0F }, 2, "TRACKBALL" },
    { { 0x1F5BC, 0xFE0F }, 2, "FRAMED PICTURE" },
    { { 0x1F5C2, 0xFE0F }, 2, "CARD INDEX DIVIDERS" },
    { { 0x1F5C3, 0xFE0F }, 2, "CARD FILE BOX" },
    { { 0x1F5C4, 0xFE0F }, 2, "FILE CABINET" },
    { { 0x1F5D1, 0xFE0F }, 2, "WASTEBASKET" },
    { { 0x1F5D2, 0xFE0F }, 2, "SPIRAL NOTEPAD" },
    { { 0x1F5D3, 0xFE0F }, 2, "SPIRAL CALENDAR" },
    { { 0x1F5DC, 0xFE0F }, 2, "CLAMP" },
    { { 0x1F5DD, 0xFE0F }, 2, "OLD KEY" },
    { { 0x1F5DE, 0xFE0F }, 2, "ROLLED-UP NEWSPAPER" },
    { { 0x1F5E1, 0xFE0F }, 2, "DAGGER" },
    { { 0x1F5E3, 0xFE0F }, 2, "SPEAKING HEAD" },
    { { 0x1F5E8, 0xFE0F }, 2, "LEFT SPEECH BUBBLE" },
    { { 0x1F5EF, 0xFE0F }, 2, "RIGHT ANGER BUBBLE" },
    { { 0x1F5F3, 0xFE0F }, 2, "BALLOT BOX WITH BALLOT" },
    { { 0x1F5FA, 0xFE0F }, 2, "WORLD MAP" },
    { { 0x1F5FB }, 1, "MOUNT FUJI" },
    { { 0x1F5FC }, 1, "TOKYO TOWER" },
    { { 0x1F5FD }, 1, "STATUE OF LIBERTY" },
    { { 0x1F5FE }, 1, "MAP OF JAPAN" },
    { { 0x1F5FF }, 1, "MOAI" },
    { { 0x1F600 }, 1, "GRINNING FACE" },
    { { 0x1F601 }, 1, "BEAMING FACE WITH SMILING EYES" },
    { { 0x1F602 }, 1, "FACE WITH TEARS OF JOY" },
    { { 0x1F603 }, 1, "GRINNING FACE WITH BIG EYES" },
    { { 0x1F604 }, 1, "GRINNING FACE WITH SMILING EYES" },
    { { 0x1F605 }, 1, "GRINNING FACE WITH SWEAT" },
    { { 0x1F606 }, 1, "GRINNING SQUINTING FACE" },
    { { 0x1F607 }, 1, "SMILING FACE WITH HALO" },
    { { 0x1F608 }, 1, "SMILING FACE WITH HORNS" },
    { { 0x1F609 }, 1, "WINKING FACE" },
    { { 0x1F60A }, 1, "SMILING FACE WITH SMILING EYES" },
    { { 0x1F60B }, 1, "FACE SAVORING FOOD" },
    { { 0x1F60C }, 1, "RELIEVED FACE" },
    { { 0x1F60D }, 1, "SMILING FACE WITH HEART-EYES" },
    { { 0x1F60E }, 1, "SMILING FACE WITH SUNGLASSES" },
    { { 0x1F60F }, 1, "SMIRKING FACE" },
    { { 0x1F610 }, 1, "NEUTRAL FACE" },
    { { 0x1F611 }, 1, "EXPRESSIONLESS FACE" },
    { { 0x1F612 }, 1, "UNAMUSED FACE" },
    { { 0x1F613 }, 1, "DOWNCAST FACE WITH SWEAT" },
    { { 0x1F614 }, 1, "PENSIVE FACE" },
    { { 0x1F615 }, 1, "CONFUSED FACE" },
    { { 0x1F616 }, 1, "CONFOUNDED FACE" },
    { { 0x1F617 }, 1, "KISSING FACE" },
    { { 0x1F618 }, 1, "FACE BLOWING A KISS" },
    { { 0x1F619 }, 1, "KISSING FACE WITH SMILING EYES" },
    { { 0x1F61A }, 1, "KISSING FACE WITH CLOSED EYES" },
    { { 0x1F61B }, 1, "FACE WITH TONGUE" },
    { { 0x1F61C }, 1, "WINKING FACE WITH TONGUE" },
    { { 0x1F61D }, 1, "SQUINTING FACE WITH TONGUE" },
    { { 0x1F61E }, 1, "DISAPPOINTED FACE" },
    { { 0x1F61F }, 1, "WORRIED FACE" },
    { { 0x1F620 }, 1, "ANGRY FACE" },
    { { 0x1F621 }, 1, "ENRAGED FACE" },
    { { 0x1F622 }, 1, "CRYING FACE" },
    { { 0x1F623 }, 1, "PERSEVERING FACE" },
    { { 0x1F624 }, 1, "FACE WITH STEAM FROM NOSE" },
    { { 0x1F625 }, 1, "SAD BUT RELIEVED FACE" },
    { { 0x1F626 }, 1, "FROWNING FACE WITH OPEN MOUTH" },
    { { 0x1F627 }, 1, "ANGUISHED FACE" },
    { { 0x1F628 }, 1, "FEARFUL FACE" },
    { { 0x1F629 }, 1, "WEARY FACE" },
    { { 0x1F62A }, 1, "SLEEPY FACE" },
    { { 0x1F62B }, 1, "TIRED FACE" },
    { { 0x1F62C }, 1, "GRIMACING FACE" },
    { { 0x1F62D }, 1, "LOUDLY CRYING FACE" },
    { { 0x1F62E }, 1, "FACE WITH OPEN MOUTH" },
    { { 0x1F62E, 0x200D, 0x1F4A8 }, 3, "FACE EXHALING" },
    { { 0x1F62F }, 1, "HUSHED FACE" },
    { { 0x1F630 }, 1, "ANXIOUS FACE WITH SWEAT" },
    { { 0x1F631 }, 1, "FACE SCREAMING IN FEAR" },
    { { 0x1F632 }, 1, "ASTONISHED FACE" },
    { { 0x1F633 }, 1, "FLUSHED FACE" },
    { { 0x1F634 }, 1, "SLEEPING FACE" },
    { { 0x1F635 }, 1, "FACE WITH CROSSED-OUT EYES" },
    { { 0x1F635, 0x200D, 0x1F4AB }, 3, "FACE WITH SPIRAL EYES" },
    { { 0x1F636 }, 1, "FACE WITHOUT MOUTH" },
    { { 0x1F636, 0x200D, 0x1F32B, 0xFE0F }, 4, "FACE IN CLOUDS" },
    { { 0x1F637 }, 1, "FACE WITH MEDICAL MASK" },
    { { 0x1F638 }, 1, "GRINNING CAT WITH SMILING EYES" },
    { { 0x1F639 }, 1, "CAT WITH TEARS OF JOY" },
    { { 0x1F63A }, 1, "GRINNING CAT" },
    { { 0x1F63B }, 1, "SMILING CAT WITH HEART-EYES" },
    { { 0x1F63C }, 1, "CAT WITH WRY SMILE" },
    { { 0x1F63D }, 1, "KISSING CAT" },
    { { 0x1F63E }, 1, "POUTING CAT" },
    { { 0x1F63F }, 1, "CRYING CAT" },
    { { 0x1F640 }, 1, "WEARY CAT" },
    { { 0x1F641 }, 1, "SLIGHTLY FROWNING FACE" },
    { { 0x1F642 }, 1, "SLIGHTLY SMILING FACE" },
    { { 0x1F642, 0x200D, 0x2194, 0xFE0F }, 4, "HEAD SHAKING HORIZONTALLY" },
    { { 0x1F642, 0x200D, 0x2195, 0xFE0F }, 4, "HEAD SHAKING VERTICALLY" },
    { { 0x1F643 }, 1, "UPSIDE-DOWN FACE" },
    { { 0x1F644 }, 1, "FACE WITH ROLLING EYES" },
    { { 0x1F645 }, 1, "PERSON GESTURING NO" },
    { { 0x1F645, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GESTURING NO" },
    { { 0x1F645, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GESTURING NO" },
    { { 0x1F645, 0x1F3FB }, 2, "PERSON GESTURING NO: LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING NO: LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING NO: LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FC }, 2, "PERSON GESTURING NO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING NO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING NO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F645, 0x1F3FD }, 2, "PERSON GESTURING NO: MEDIUM SKIN TONE" },
    { { 0x1F645, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING NO: MEDIUM SKIN TONE" },
    { { 0x1F645, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING NO: MEDIUM SKIN TONE" },
    { { 0x1F645, 0x1F3FE }, 2, "PERSON GESTURING NO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F645, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING NO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F645, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING NO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F645, 0x1F3FF }, 2, "PERSON GESTURING NO: DARK SKIN TONE" },
    { { 0x1F645, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING NO: DARK SKIN TONE" },
    { { 0x1F645, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING NO: DARK SKIN TONE" },
    { { 0x1F646 }, 1, "PERSON GESTURING OK" },
    { { 0x1F646, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GESTURING OK" },
    { { 0x1F646, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GESTURING OK" },
    { { 0x1F646, 0x1F3FB }, 2, "PERSON GESTURING OK: LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING OK: LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING OK: LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FC }, 2, "PERSON GESTURING OK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING OK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING OK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F646, 0x1F3FD }, 2, "PERSON GESTURING OK: MEDIUM SKIN TONE" },
    { { 0x1F646, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING OK: MEDIUM SKIN TONE" },
    { { 0x1F646, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING OK: MEDIUM SKIN TONE" },
    { { 0x1F646, 0x1F3FE }, 2, "PERSON GESTURING OK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F646, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING OK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F646, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING OK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F646, 0x1F3FF }, 2, "PERSON GESTURING OK: DARK SKIN TONE" },
    { { 0x1F646, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN GESTURING OK: DARK SKIN TONE" },
    { { 0x1F646, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN GESTURING OK: DARK SKIN TONE" },
    { { 0x1F647 }, 1, "PERSON BOWING" },
    { { 0x1F647, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN BOWING" },
    { { 0x1F647, 0x200D, 0x2642, 0xFE0F }, 4, "MAN BOWING" },
    { { 0x1F647, 0x1F3FB }, 2, "PERSON BOWING: LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOWING: LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOWING: LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FC }, 2, "PERSON BOWING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOWING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOWING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F647, 0x1F3FD }, 2, "PERSON BOWING: MEDIUM SKIN TONE" },
    { { 0x1F647, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOWING: MEDIUM SKIN TONE" },
    { { 0x1F647, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOWING: MEDIUM SKIN TONE" },
    { { 0x1F647, 0x1F3FE }, 2, "PERSON BOWING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F647, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOWING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F647, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOWING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F647, 0x1F3FF }, 2, "PERSON BOWING: DARK SKIN TONE" },
    { { 0x1F647, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BOWING: DARK SKIN TONE" },
    { { 0x1F647, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BOWING: DARK SKIN TONE" },
    { { 0x1F648 }, 1, "SEE-NO-EVIL MONKEY" },
    { { 0x1F649 }, 1, "HEAR-NO-EVIL MONKEY" },
    { { 0x1F64A }, 1, "SPEAK-NO-EVIL MONKEY" },
    { { 0x1F64B }, 1, "PERSON RAISING HAND" },
    { { 0x1F64B, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN RAISING HAND" },
    { { 0x1F64B, 0x200D, 0x2642, 0xFE0F }, 4, "MAN RAISING HAND" },
    { { 0x1F64B, 0x1F3FB }, 2, "PERSON RAISING HAND: LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RAISING HAND: LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RAISING HAND: LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FC }, 2, "PERSON RAISING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RAISING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RAISING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64B, 0x1F3FD }, 2, "PERSON RAISING HAND: MEDIUM SKIN TONE" },
    { { 0x1F64B, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RAISING HAND: MEDIUM SKIN TONE" },
    { { 0x1F64B, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RAISING HAND: MEDIUM SKIN TONE" },
    { { 0x1F64B, 0x1F3FE }, 2, "PERSON RAISING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64B, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RAISING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64B, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RAISING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64B, 0x1F3FF }, 2, "PERSON RAISING HAND: DARK SKIN TONE" },
    { { 0x1F64B, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN RAISING HAND: DARK SKIN TONE" },
    { { 0x1F64B, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN RAISING HAND: DARK SKIN TONE" },
    { { 0x1F64C }, 1, "RAISING HANDS" },
    { { 0x1F64C, 0x1F3FB }, 2, "RAISING HANDS: LIGHT SKIN TONE" },
    { { 0x1F64C, 0x1F3FC }, 2, "RAISING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64C, 0x1F3FD }, 2, "RAISING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F64C, 0x1F3FE }, 2, "RAISING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64C, 0x1F3FF }, 2, "RAISING HANDS: DARK SKIN TONE" },
    { { 0x1F64D }, 1, "PERSON FROWNING" },
    { { 0x1F64D, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN FROWNING" },
    { { 0x1F64D, 0x200D, 0x2642, 0xFE0F }, 4, "MAN FROWNING" },
    { { 0x1F64D, 0x1F3FB }, 2, "PERSON FROWNING: LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FROWNING: LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FROWNING: LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FC }, 2, "PERSON FROWNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FROWNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FROWNING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64D, 0x1F3FD }, 2, "PERSON FROWNING: MEDIUM SKIN TONE" },
    { { 0x1F64D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FROWNING: MEDIUM SKIN TONE" },
    { { 0x1F64D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FROWNING: MEDIUM SKIN TONE" },
    { { 0x1F64D, 0x1F3FE }, 2, "PERSON FROWNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FROWNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FROWNING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64D, 0x1F3FF }, 2, "PERSON FROWNING: DARK SKIN TONE" },
    { { 0x1F64D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FROWNING: DARK SKIN TONE" },
    { { 0x1F64D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FROWNING: DARK SKIN TONE" },
    { { 0x1F64E }, 1, "PERSON POUTING" },
    { { 0x1F64E, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN POUTING" },
    { { 0x1F64E, 0x200D, 0x2642, 0xFE0F }, 4, "MAN POUTING" },
    { { 0x1F64E, 0x1F3FB }, 2, "PERSON POUTING: LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POUTING: LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POUTING: LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FC }, 2, "PERSON POUTING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POUTING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POUTING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64E, 0x1F3FD }, 2, "PERSON POUTING: MEDIUM SKIN TONE" },
    { { 0x1F64E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POUTING: MEDIUM SKIN TONE" },
    { { 0x1F64E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POUTING: MEDIUM SKIN TONE" },
    { { 0x1F64E, 0x1F3FE }, 2, "PERSON POUTING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POUTING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POUTING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64E, 0x1F3FF }, 2, "PERSON POUTING: DARK SKIN TONE" },
    { { 0x1F64E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN POUTING: DARK SKIN TONE" },
    { { 0x1F64E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN POUTING: DARK SKIN TONE" },
    { { 0x1F64F }, 1, "FOLDED HANDS" },
    { { 0x1F64F, 0x1F3FB }, 2, "FOLDED HANDS: LIGHT SKIN TONE" },
    { { 0x1F64F, 0x1F3FC }, 2, "FOLDED HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F64F, 0x1F3FD }, 2, "FOLDED HANDS: MEDIUM SKIN TONE" },
    { { 0x1F64F, 0x1F3FE }, 2, "FOLDED HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F64F, 0x1F3FF }, 2, "FOLDED HANDS: DARK SKIN TONE" },
    { { 0x1F680 }, 1, "ROCKET" },
    { { 0x1F681 }, 1, "HELICOPTER" },
    { { 0x1F682 }, 1, "LOCOMOTIVE" },
    { { 0x1F683 }, 1, "RAILWAY CAR" },
    { { 0x1F684 }, 1, "HIGH-SPEED TRAIN" },
    { { 0x1F685 }, 1, "BULLET TRAIN" },
    { { 0x1F686 }, 1, "TRAIN" },
    { { 0x1F687 }, 1, "METRO" },
    { { 0x1F688 }, 1, "LIGHT RAIL" },
    { { 0x1F689 }, 1, "STATION" },
    { { 0x1F68A }, 1, "TRAM" },
    { { 0x1F68B }, 1, "TRAM CAR" },
    { { 0x1F68C }, 1, "BUS" },
    { { 0x1F68D }, 1, "ONCOMING BUS" },
    { { 0x1F68E }, 1, "TROLLEYBUS" },
    { { 0x1F68F }, 1, "BUS STOP" },
    { { 0x1F690 }, 1, "MINIBUS" },
    { { 0x1F691 }, 1, "AMBULANCE" },
    { { 0x1F692 }, 1, "FIRE ENGINE" },
    { { 0x1F693 }, 1, "POLICE CAR" },
    { { 0x1F694 }, 1, "ONCOMING POLICE CAR" },
    { { 0x1F695 }, 1, "TAXI" },
    { { 0x1F696 }, 1, "ONCOMING TAXI" },
    { { 0x1F697 }, 1, "AUTOMOBILE" },
    { { 0x1F698 }, 1, "ONCOMING AUTOMOBILE" },
    { { 0x1F699 }, 1, "SPORT UTILITY VEHICLE" },
    { { 0x1F69A }, 1, "DELIVERY TRUCK" },
    { { 0x1F69B }, 1, "ARTICULATED LORRY" },
    { { 0x1F69C }, 1, "TRACTOR" },
    { { 0x1F69D }, 1, "MONORAIL" },
    { { 0x1F69E }, 1, "MOUNTAIN RAILWAY" },
    { { 0x1F69F }, 1, "SUSPENSION RAILWAY" },
    { { 0x1F6A0 }, 1, "MOUNTAIN CABLEWAY" },
    { { 0x1F6A1 }, 1, "AERIAL TRAMWAY" },
    { { 0x1F6A2 }, 1, "SHIP" },
    { { 0x1F6A3 }, 1, "PERSON ROWING BOAT" },
    { { 0x1F6A3, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN ROWING BOAT" },
    { { 0x1F6A3, 0x200D, 0x2642, 0xFE0F }, 4, "MAN ROWING BOAT" },
    { { 0x1F6A3, 0x1F3FB }, 2, "PERSON ROWING BOAT: LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ROWING BOAT: LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ROWING BOAT: LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FC }, 2, "PERSON ROWING BOAT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ROWING BOAT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ROWING BOAT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6A3, 0x1F3FD }, 2, "PERSON ROWING BOAT: MEDIUM SKIN TONE" },
    { { 0x1F6A3, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ROWING BOAT: MEDIUM SKIN TONE" },
    { { 0x1F6A3, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ROWING BOAT: MEDIUM SKIN TONE" },
    { { 0x1F6A3, 0x1F3FE }, 2, "PERSON ROWING BOAT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6A3, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ROWING BOAT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6A3, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ROWING BOAT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6A3, 0x1F3FF }, 2, "PERSON ROWING BOAT: DARK SKIN TONE" },
    { { 0x1F6A3, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ROWING BOAT: DARK SKIN TONE" },
    { { 0x1F6A3, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ROWING BOAT: DARK SKIN TONE" },
    { { 0x1F6A4 }, 1, "SPEEDBOAT" },
    { { 0x1F6A5 }, 1, "HORIZONTAL TRAFFIC LIGHT" },
    { { 0x1F6A6 }, 1, "VERTICAL TRAFFIC LIGHT" },
    { { 0x1F6A7 }, 1, "CONSTRUCTION" },
    { { 0x1F6A8 }, 1, "POLICE CAR LIGHT" },
    { { 0x1F6A9 }, 1, "TRIANGULAR FLAG" },
    { { 0x1F6AA }, 1, "DOOR" },
    { { 0x1F6AB }, 1, "PROHIBITED" },
    { { 0x1F6AC }, 1, "CIGARETTE" },
    { { 0x1F6AD }, 1, "NO SMOKING" },
    { { 0x1F6AE }, 1, "LITTER IN BIN SIGN" },
    { { 0x1F6AF }, 1, "NO LITTERING" },
    { { 0x1F6B0 }, 1, "POTABLE WATER" },
    { { 0x1F6B1 }, 1, "NON-POTABLE WATER" },
    { { 0x1F6B2 }, 1, "BICYCLE" },
    { { 0x1F6B3 }, 1, "NO BICYCLES" },
    { { 0x1F6B4 }, 1, "PERSON BIKING" },
    { { 0x1F6B4, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN BIKING" },
    { { 0x1F6B4, 0x200D, 0x2642, 0xFE0F }, 4, "MAN BIKING" },
    { { 0x1F6B4, 0x1F3FB }, 2, "PERSON BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FC }, 2, "PERSON BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B4, 0x1F3FD }, 2, "PERSON BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B4, 0x1F3FE }, 2, "PERSON BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B4, 0x1F3FF }, 2, "PERSON BIKING: DARK SKIN TONE" },
    { { 0x1F6B4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN BIKING: DARK SKIN TONE" },
    { { 0x1F6B4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN BIKING: DARK SKIN TONE" },
    { { 0x1F6B5 }, 1, "PERSON MOUNTAIN BIKING" },
    { { 0x1F6B5, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN MOUNTAIN BIKING" },
    { { 0x1F6B5, 0x200D, 0x2642, 0xFE0F }, 4, "MAN MOUNTAIN BIKING" },
    { { 0x1F6B5, 0x1F3FB }, 2, "PERSON MOUNTAIN BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MOUNTAIN BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MOUNTAIN BIKING: LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FC }, 2, "PERSON MOUNTAIN BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MOUNTAIN BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MOUNTAIN BIKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B5, 0x1F3FD }, 2, "PERSON MOUNTAIN BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B5, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MOUNTAIN BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B5, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MOUNTAIN BIKING: MEDIUM SKIN TONE" },
    { { 0x1F6B5, 0x1F3FE }, 2, "PERSON MOUNTAIN BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B5, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MOUNTAIN BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B5, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MOUNTAIN BIKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B5, 0x1F3FF }, 2, "PERSON MOUNTAIN BIKING: DARK SKIN TONE" },
    { { 0x1F6B5, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MOUNTAIN BIKING: DARK SKIN TONE" },
    { { 0x1F6B5, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MOUNTAIN BIKING: DARK SKIN TONE" },
    { { 0x1F6B6 }, 1, "PERSON WALKING" },
    { { 0x1F6B6, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN WALKING" },
    { { 0x1F6B6, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN WALKING FACING RIGHT" },
    { { 0x1F6B6, 0x200D, 0x2642, 0xFE0F }, 4, "MAN WALKING" },
    { { 0x1F6B6, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN WALKING FACING RIGHT" },
    { { 0x1F6B6, 0x200D, 0x27A1, 0xFE0F }, 4, "PERSON WALKING FACING RIGHT" },
    { { 0x1F6B6, 0x1F3FB }, 2, "PERSON WALKING: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WALKING: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN WALKING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WALKING: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN WALKING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FB, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON WALKING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC }, 2, "PERSON WALKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WALKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN WALKING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WALKING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN WALKING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FC, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON WALKING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD }, 2, "PERSON WALKING: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WALKING: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN WALKING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WALKING: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN WALKING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FD, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON WALKING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE }, 2, "PERSON WALKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WALKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN WALKING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WALKING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN WALKING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FE, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON WALKING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF }, 2, "PERSON WALKING: DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN WALKING: DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN WALKING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN WALKING: DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN WALKING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F6B6, 0x1F3FF, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON WALKING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F6B7 }, 1, "NO PEDESTRIANS" },
    { { 0x1F6B8 }, 1, "CHILDREN CROSSING" },
    { { 0x1F6B9 }, 1, "MEN’S ROOM" },
    { { 0x1F6BA }, 1, "WOMEN’S ROOM" },
    { { 0x1F6BB }, 1, "RESTROOM" },
    { { 0x1F6BC }, 1, "BABY SYMBOL" },
    { { 0x1F6BD }, 1, "TOILET" },
    { { 0x1F6BE }, 1, "WATER CLOSET" },
    { { 0x1F6BF }, 1, "SHOWER" },
    { { 0x1F6C0 }, 1, "PERSON TAKING BATH" },
    { { 0x1F6C0, 0x1F3FB }, 2, "PERSON TAKING BATH: LIGHT SKIN TONE" },
    { { 0x1F6C0, 0x1F3FC }, 2, "PERSON TAKING BATH: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6C0, 0x1F3FD }, 2, "PERSON TAKING BATH: MEDIUM SKIN TONE" },
    { { 0x1F6C0, 0x1F3FE }, 2, "PERSON TAKING BATH: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6C0, 0x1F3FF }, 2, "PERSON TAKING BATH: DARK SKIN TONE" },
    { { 0x1F6C1 }, 1, "BATHTUB" },
    { { 0x1F6C2 }, 1, "PASSPORT CONTROL" },
    { { 0x1F6C3 }, 1, "CUSTOMS" },
    { { 0x1F6C4 }, 1, "BAGGAGE CLAIM" },
    { { 0x1F6C5 }, 1, "LEFT LUGGAGE" },
    { { 0x1F6CB, 0xFE0F }, 2, "COUCH AND LAMP" },
    { { 0x1F6CC }, 1, "PERSON IN BED" },
    { { 0x1F6CC, 0x1F3FB }, 2, "PERSON IN BED: LIGHT SKIN TONE" },
    { { 0x1F6CC, 0x1F3FC }, 2, "PERSON IN BED: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F6CC, 0x1F3FD }, 2, "PERSON IN BED: MEDIUM SKIN TONE" },
    { { 0x1F6CC, 0x1F3FE }, 2, "PERSON IN BED: MEDIUM-DARK SKIN TONE" },
    { { 0x1F6CC, 0x1F3FF }, 2, "PERSON IN BED: DARK SKIN TONE" },
    { { 0x1F6CD, 0xFE0F }, 2, "SHOPPING BAGS" },
    { { 0x1F6CE, 0xFE0F }, 2, "BELLHOP BELL" },
    { { 0x1F6CF, 0xFE0F }, 2, "BED" },
    { { 0x1F6D0 }, 1, "PLACE OF WORSHIP" },
    { { 0x1F6D1 }, 1, "STOP SIGN" },
    { { 0x1F6D2 }, 1, "SHOPPING CART" },
    { { 0x1F6D5 }, 1, "HINDU TEMPLE" },
    { { 0x1F6D6 }, 1, "HUT" },
    { { 0x1F6D7 }, 1, "ELEVATOR" },
    { { 0x1F6DC }, 1, "WIRELESS" },
    { { 0x1F6DD }, 1, "PLAYGROUND SLIDE" },
    { { 0x1F6DE }, 1, "WHEEL" },
    { { 0x1F6DF }, 1, "RING BUOY" },
    { { 0x1F6E0, 0xFE0F }, 2, "HAMMER AND WRENCH" },
    { { 0x1F6E1, 0xFE0F }, 2, "SHIELD" },
    { { 0x1F6E2, 0xFE0F }, 2, "OIL DRUM" },
    { { 0x1F6E3, 0xFE0F }, 2, "MOTORWAY" },
    { { 0x1F6E4, 0xFE0F }, 2, "RAILWAY TRACK" },
    { { 0x1F6E5, 0xFE0F }, 2, "MOTOR BOAT" },
    { { 0x1F6E9, 0xFE0F }, 2, "SMALL AIRPLANE" },
    { { 0x1F6EB }, 1, "AIRPLANE DEPARTURE" },
    { { 0x1F6EC }, 1, "AIRPLANE ARRIVAL" },
    { { 0x1F6F0, 0xFE0F }, 2, "SATELLITE" },
    { { 0x1F6F3, 0xFE0F }, 2, "PASSENGER SHIP" },
    { { 0x1F6F4 }, 1, "KICK SCOOTER" },
    { { 0x1F6F5 }, 1, "MOTOR SCOOTER" },
    { { 0x1F6F6 }, 1, "CANOE" },
    { { 0x1F6F7 }, 1, "SLED" },
    { { 0x1F6F8 }, 1, "FLYING SAUCER" },
    { { 0x1F6F9 }, 1, "SKATEBOARD" },
    { { 0x1F6FA }, 1, "AUTO RICKSHAW" },
    { { 0x1F6FB }, 1, "PICKUP TRUCK" },
    { { 0x1F6FC }, 1, "ROLLER SKATE" },
    { { 0x1F7E0 }, 1, "ORANGE CIRCLE" },
    { { 0x1F7E1 }, 1, "YELLOW CIRCLE" },
    { { 0x1F7E2 }, 1, "GREEN CIRCLE" },
    { { 0x1F7E3 }, 1, "PURPLE CIRCLE" },
    { { 0x1F7E4 }, 1, "BROWN CIRCLE" },
    { { 0x1F7E5 }, 1, "RED SQUARE" },
    { { 0x1F7E6 }, 1, "BLUE SQUARE" },
    { { 0x1F7E7 }, 1, "ORANGE SQUARE" },
    { { 0x1F7E8 }, 1, "YELLOW SQUARE" },
    { { 0x1F7E9 }, 1, "GREEN SQUARE" },
    { { 0x1F7EA }, 1, "PURPLE SQUARE" },
    { { 0x1F7EB }, 1, "BROWN SQUARE" },
    { { 0x1F7F0 }, 1, "HEAVY EQUALS SIGN" },
    { { 0x1F90C }, 1, "PINCHED FINGERS" },
    { { 0x1F90C, 0x1F3FB }, 2, "PINCHED FINGERS: LIGHT SKIN TONE" },
    { { 0x1F90C, 0x1F3FC }, 2, "PINCHED FINGERS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F90C, 0x1F3FD }, 2, "PINCHED FINGERS: MEDIUM SKIN TONE" },
    { { 0x1F90C, 0x1F3FE }, 2, "PINCHED FINGERS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F90C, 0x1F3FF }, 2, "PINCHED FINGERS: DARK SKIN TONE" },
    { { 0x1F90D }, 1, "WHITE HEART" },
    { { 0x1F90E }, 1, "BROWN HEART" },
    { { 0x1F90F }, 1, "PINCHING HAND" },
    { { 0x1F90F, 0x1F3FB }, 2, "PINCHING HAND: LIGHT SKIN TONE" },
    { { 0x1F90F, 0x1F3FC }, 2, "PINCHING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F90F, 0x1F3FD }, 2, "PINCHING HAND: MEDIUM SKIN TONE" },
    { { 0x1F90F, 0x1F3FE }, 2, "PINCHING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F90F, 0x1F3FF }, 2, "PINCHING HAND: DARK SKIN TONE" },
    { { 0x1F910 }, 1, "ZIPPER-MOUTH FACE" },
    { { 0x1F911 }, 1, "MONEY-MOUTH FACE" },
    { { 0x1F912 }, 1, "FACE WITH THERMOMETER" },
    { { 0x1F913 }, 1, "NERD FACE" },
    { { 0x1F914 }, 1, "THINKING FACE" },
    { { 0x1F915 }, 1, "FACE WITH HEAD-BANDAGE" },
    { { 0x1F916 }, 1, "ROBOT" },
    { { 0x1F917 }, 1, "SMILING FACE WITH OPEN HANDS" },
    { { 0x1F918 }, 1, "SIGN OF THE HORNS" },
    { { 0x1F918, 0x1F3FB }, 2, "SIGN OF THE HORNS: LIGHT SKIN TONE" },
    { { 0x1F918, 0x1F3FC }, 2, "SIGN OF THE HORNS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F918, 0x1F3FD }, 2, "SIGN OF THE HORNS: MEDIUM SKIN TONE" },
    { { 0x1F918, 0x1F3FE }, 2, "SIGN OF THE HORNS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F918, 0x1F3FF }, 2, "SIGN OF THE HORNS: DARK SKIN TONE" },
    { { 0x1F919 }, 1, "CALL ME HAND" },
    { { 0x1F919, 0x1F3FB }, 2, "CALL ME HAND: LIGHT SKIN TONE" },
    { { 0x1F919, 0x1F3FC }, 2, "CALL ME HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F919, 0x1F3FD }, 2, "CALL ME HAND: MEDIUM SKIN TONE" },
    { { 0x1F919, 0x1F3FE }, 2, "CALL ME HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F919, 0x1F3FF }, 2, "CALL ME HAND: DARK SKIN TONE" },
    { { 0x1F91A }, 1, "RAISED BACK OF HAND" },
    { { 0x1F91A, 0x1F3FB }, 2, "RAISED BACK OF HAND: LIGHT SKIN TONE" },
    { { 0x1F91A, 0x1F3FC }, 2, "RAISED BACK OF HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91A, 0x1F3FD }, 2, "RAISED BACK OF HAND: MEDIUM SKIN TONE" },
    { { 0x1F91A, 0x1F3FE }, 2, "RAISED BACK OF HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91A, 0x1F3FF }, 2, "RAISED BACK OF HAND: DARK SKIN TONE" },
    { { 0x1F91B }, 1, "LEFT-FACING FIST" },
    { { 0x1F91B, 0x1F3FB }, 2, "LEFT-FACING FIST: LIGHT SKIN TONE" },
    { { 0x1F91B, 0x1F3FC }, 2, "LEFT-FACING FIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91B, 0x1F3FD }, 2, "LEFT-FACING FIST: MEDIUM SKIN TONE" },
    { { 0x1F91B, 0x1F3FE }, 2, "LEFT-FACING FIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91B, 0x1F3FF }, 2, "LEFT-FACING FIST: DARK SKIN TONE" },
    { { 0x1F91C }, 1, "RIGHT-FACING FIST" },
    { { 0x1F91C, 0x1F3FB }, 2, "RIGHT-FACING FIST: LIGHT SKIN TONE" },
    { { 0x1F91C, 0x1F3FC }, 2, "RIGHT-FACING FIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91C, 0x1F3FD }, 2, "RIGHT-FACING FIST: MEDIUM SKIN TONE" },
    { { 0x1F91C, 0x1F3FE }, 2, "RIGHT-FACING FIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91C, 0x1F3FF }, 2, "RIGHT-FACING FIST: DARK SKIN TONE" },
    { { 0x1F91D }, 1, "HANDSHAKE" },
    { { 0x1F91D, 0x1F3FB }, 2, "HANDSHAKE: LIGHT SKIN TONE" },
    { { 0x1F91D, 0x1F3FC }, 2, "HANDSHAKE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91D, 0x1F3FD }, 2, "HANDSHAKE: MEDIUM SKIN TONE" },
    { { 0x1F91D, 0x1F3FE }, 2, "HANDSHAKE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91D, 0x1F3FF }, 2, "HANDSHAKE: DARK SKIN TONE" },
    { { 0x1F91E }, 1, "CROSSED FINGERS" },
    { { 0x1F91E, 0x1F3FB }, 2, "CROSSED FINGERS: LIGHT SKIN TONE" },
    { { 0x1F91E, 0x1F3FC }, 2, "CROSSED FINGERS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91E, 0x1F3FD }, 2, "CROSSED FINGERS: MEDIUM SKIN TONE" },
    { { 0x1F91E, 0x1F3FE }, 2, "CROSSED FINGERS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91E, 0x1F3FF }, 2, "CROSSED FINGERS: DARK SKIN TONE" },
    { { 0x1F91F }, 1, "LOVE-YOU GESTURE" },
    { { 0x1F91F, 0x1F3FB }, 2, "LOVE-YOU GESTURE: LIGHT SKIN TONE" },
    { { 0x1F91F, 0x1F3FC }, 2, "LOVE-YOU GESTURE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F91F, 0x1F3FD }, 2, "LOVE-YOU GESTURE: MEDIUM SKIN TONE" },
    { { 0x1F91F, 0x1F3FE }, 2, "LOVE-YOU GESTURE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F91F, 0x1F3FF }, 2, "LOVE-YOU GESTURE: DARK SKIN TONE" },
    { { 0x1F920 }, 1, "COWBOY HAT FACE" },
    { { 0x1F921 }, 1, "CLOWN FACE" },
    { { 0x1F922 }, 1, "NAUSEATED FACE" },
    { { 0x1F923 }, 1, "ROLLING ON THE FLOOR LAUGHING" },
    { { 0x1F924 }, 1, "DROOLING FACE" },
    { { 0x1F925 }, 1, "LYING FACE" },
    { { 0x1F926 }, 1, "PERSON FACEPALMING" },
    { { 0x1F926, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN FACEPALMING" },
    { { 0x1F926, 0x200D, 0x2642, 0xFE0F }, 4, "MAN FACEPALMING" },
    { { 0x1F926, 0x1F3FB }, 2, "PERSON FACEPALMING: LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FACEPALMING: LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FACEPALMING: LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FC }, 2, "PERSON FACEPALMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FACEPALMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FACEPALMING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F926, 0x1F3FD }, 2, "PERSON FACEPALMING: MEDIUM SKIN TONE" },
    { { 0x1F926, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FACEPALMING: MEDIUM SKIN TONE" },
    { { 0x1F926, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FACEPALMING: MEDIUM SKIN TONE" },
    { { 0x1F926, 0x1F3FE }, 2, "PERSON FACEPALMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F926, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FACEPALMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F926, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FACEPALMING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F926, 0x1F3FF }, 2, "PERSON FACEPALMING: DARK SKIN TONE" },
    { { 0x1F926, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FACEPALMING: DARK SKIN TONE" },
    { { 0x1F926, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FACEPALMING: DARK SKIN TONE" },
    { { 0x1F927 }, 1, "SNEEZING FACE" },
    { { 0x1F928 }, 1, "FACE WITH RAISED EYEBROW" },
    { { 0x1F929 }, 1, "STAR-STRUCK" },
    { { 0x1F92A }, 1, "ZANY FACE" },
    { { 0x1F92B }, 1, "SHUSHING FACE" },
    { { 0x1F92C }, 1, "FACE WITH SYMBOLS ON MOUTH" },
    { { 0x1F92D }, 1, "FACE WITH HAND OVER MOUTH" },
    { { 0x1F92E }, 1, "FACE VOMITING" },
    { { 0x1F92F }, 1, "EXPLODING HEAD" },
    { { 0x1F930 }, 1, "PREGNANT WOMAN" },
    { { 0x1F930, 0x1F3FB }, 2, "PREGNANT WOMAN: LIGHT SKIN TONE" },
    { { 0x1F930, 0x1F3FC }, 2, "PREGNANT WOMAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F930, 0x1F3FD }, 2, "PREGNANT WOMAN: MEDIUM SKIN TONE" },
    { { 0x1F930, 0x1F3FE }, 2, "PREGNANT WOMAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F930, 0x1F3FF }, 2, "PREGNANT WOMAN: DARK SKIN TONE" },
    { { 0x1F931 }, 1, "BREAST-FEEDING" },
    { { 0x1F931, 0x1F3FB }, 2, "BREAST-FEEDING: LIGHT SKIN TONE" },
    { { 0x1F931, 0x1F3FC }, 2, "BREAST-FEEDING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F931, 0x1F3FD }, 2, "BREAST-FEEDING: MEDIUM SKIN TONE" },
    { { 0x1F931, 0x1F3FE }, 2, "BREAST-FEEDING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F931, 0x1F3FF }, 2, "BREAST-FEEDING: DARK SKIN TONE" },
    { { 0x1F932 }, 1, "PALMS UP TOGETHER" },
    { { 0x1F932, 0x1F3FB }, 2, "PALMS UP TOGETHER: LIGHT SKIN TONE" },
    { { 0x1F932, 0x1F3FC }, 2, "PALMS UP TOGETHER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F932, 0x1F3FD }, 2, "PALMS UP TOGETHER: MEDIUM SKIN TONE" },
    { { 0x1F932, 0x1F3FE }, 2, "PALMS UP TOGETHER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F932, 0x1F3FF }, 2, "PALMS UP TOGETHER: DARK SKIN TONE" },
    { { 0x1F933 }, 1, "SELFIE" },
    { { 0x1F933, 0x1F3FB }, 2, "SELFIE: LIGHT SKIN TONE" },
    { { 0x1F933, 0x1F3FC }, 2, "SELFIE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F933, 0x1F3FD }, 2, "SELFIE: MEDIUM SKIN TONE" },
    { { 0x1F933, 0x1F3FE }, 2, "SELFIE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F933, 0x1F3FF }, 2, "SELFIE: DARK SKIN TONE" },
    { { 0x1F934 }, 1, "PRINCE" },
    { { 0x1F934, 0x1F3FB }, 2, "PRINCE: LIGHT SKIN TONE" },
    { { 0x1F934, 0x1F3FC }, 2, "PRINCE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F934, 0x1F3FD }, 2, "PRINCE: MEDIUM SKIN TONE" },
    { { 0x1F934, 0x1F3FE }, 2, "PRINCE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F934, 0x1F3FF }, 2, "PRINCE: DARK SKIN TONE" },
    { { 0x1F935 }, 1, "PERSON IN TUXEDO" },
    { { 0x1F935, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN IN TUXEDO" },
    { { 0x1F935, 0x200D, 0x2642, 0xFE0F }, 4, "MAN IN TUXEDO" },
    { { 0x1F935, 0x1F3FB }, 2, "PERSON IN TUXEDO: LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN TUXEDO: LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN TUXEDO: LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FC }, 2, "PERSON IN TUXEDO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN TUXEDO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN TUXEDO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F935, 0x1F3FD }, 2, "PERSON IN TUXEDO: MEDIUM SKIN TONE" },
    { { 0x1F935, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN TUXEDO: MEDIUM SKIN TONE" },
    { { 0x1F935, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN TUXEDO: MEDIUM SKIN TONE" },
    { { 0x1F935, 0x1F3FE }, 2, "PERSON IN TUXEDO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F935, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN TUXEDO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F935, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN TUXEDO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F935, 0x1F3FF }, 2, "PERSON IN TUXEDO: DARK SKIN TONE" },
    { { 0x1F935, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN TUXEDO: DARK SKIN TONE" },
    { { 0x1F935, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN TUXEDO: DARK SKIN TONE" },
    { { 0x1F936 }, 1, "MRS. CLAUS" },
    { { 0x1F936, 0x1F3FB }, 2, "MRS. CLAUS: LIGHT SKIN TONE" },
    { { 0x1F936, 0x1F3FC }, 2, "MRS. CLAUS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F936, 0x1F3FD }, 2, "MRS. CLAUS: MEDIUM SKIN TONE" },
    { { 0x1F936, 0x1F3FE }, 2, "MRS. CLAUS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F936, 0x1F3FF }, 2, "MRS. CLAUS: DARK SKIN TONE" },
    { { 0x1F937 }, 1, "PERSON SHRUGGING" },
    { { 0x1F937, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN SHRUGGING" },
    { { 0x1F937, 0x200D, 0x2642, 0xFE0F }, 4, "MAN SHRUGGING" },
    { { 0x1F937, 0x1F3FB }, 2, "PERSON SHRUGGING: LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SHRUGGING: LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SHRUGGING: LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FC }, 2, "PERSON SHRUGGING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SHRUGGING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SHRUGGING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F937, 0x1F3FD }, 2, "PERSON SHRUGGING: MEDIUM SKIN TONE" },
    { { 0x1F937, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SHRUGGING: MEDIUM SKIN TONE" },
    { { 0x1F937, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SHRUGGING: MEDIUM SKIN TONE" },
    { { 0x1F937, 0x1F3FE }, 2, "PERSON SHRUGGING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F937, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SHRUGGING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F937, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SHRUGGING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F937, 0x1F3FF }, 2, "PERSON SHRUGGING: DARK SKIN TONE" },
    { { 0x1F937, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SHRUGGING: DARK SKIN TONE" },
    { { 0x1F937, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SHRUGGING: DARK SKIN TONE" },
    { { 0x1F938 }, 1, "PERSON CARTWHEELING" },
    { { 0x1F938, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN CARTWHEELING" },
    { { 0x1F938, 0x200D, 0x2642, 0xFE0F }, 4, "MAN CARTWHEELING" },
    { { 0x1F938, 0x1F3FB }, 2, "PERSON CARTWHEELING: LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CARTWHEELING: LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CARTWHEELING: LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FC }, 2, "PERSON CARTWHEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CARTWHEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CARTWHEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F938, 0x1F3FD }, 2, "PERSON CARTWHEELING: MEDIUM SKIN TONE" },
    { { 0x1F938, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CARTWHEELING: MEDIUM SKIN TONE" },
    { { 0x1F938, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CARTWHEELING: MEDIUM SKIN TONE" },
    { { 0x1F938, 0x1F3FE }, 2, "PERSON CARTWHEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F938, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CARTWHEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F938, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CARTWHEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F938, 0x1F3FF }, 2, "PERSON CARTWHEELING: DARK SKIN TONE" },
    { { 0x1F938, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CARTWHEELING: DARK SKIN TONE" },
    { { 0x1F938, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CARTWHEELING: DARK SKIN TONE" },
    { { 0x1F939 }, 1, "PERSON JUGGLING" },
    { { 0x1F939, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN JUGGLING" },
    { { 0x1F939, 0x200D, 0x2642, 0xFE0F }, 4, "MAN JUGGLING" },
    { { 0x1F939, 0x1F3FB }, 2, "PERSON JUGGLING: LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN JUGGLING: LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN JUGGLING: LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FC }, 2, "PERSON JUGGLING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN JUGGLING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN JUGGLING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F939, 0x1F3FD }, 2, "PERSON JUGGLING: MEDIUM SKIN TONE" },
    { { 0x1F939, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN JUGGLING: MEDIUM SKIN TONE" },
    { { 0x1F939, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN JUGGLING: MEDIUM SKIN TONE" },
    { { 0x1F939, 0x1F3FE }, 2, "PERSON JUGGLING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F939, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN JUGGLING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F939, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN JUGGLING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F939, 0x1F3FF }, 2, "PERSON JUGGLING: DARK SKIN TONE" },
    { { 0x1F939, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN JUGGLING: DARK SKIN TONE" },
    { { 0x1F939, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN JUGGLING: DARK SKIN TONE" },
    { { 0x1F93A }, 1, "PERSON FENCING" },
    { { 0x1F93C }, 1, "PEOPLE WRESTLING" },
    { { 0x1F93C, 0x200D, 0x2640, 0xFE0F }, 4, "WOMEN WRESTLING" },
    { { 0x1F93C, 0x200D, 0x2642, 0xFE0F }, 4, "MEN WRESTLING" },
    { { 0x1F93D }, 1, "PERSON PLAYING WATER POLO" },
    { { 0x1F93D, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN PLAYING WATER POLO" },
    { { 0x1F93D, 0x200D, 0x2642, 0xFE0F }, 4, "MAN PLAYING WATER POLO" },
    { { 0x1F93D, 0x1F3FB }, 2, "PERSON PLAYING WATER POLO: LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING WATER POLO: LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING WATER POLO: LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FC }, 2, "PERSON PLAYING WATER POLO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING WATER POLO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING WATER POLO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93D, 0x1F3FD }, 2, "PERSON PLAYING WATER POLO: MEDIUM SKIN TONE" },
    { { 0x1F93D, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING WATER POLO: MEDIUM SKIN TONE" },
    { { 0x1F93D, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING WATER POLO: MEDIUM SKIN TONE" },
    { { 0x1F93D, 0x1F3FE }, 2, "PERSON PLAYING WATER POLO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93D, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING WATER POLO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93D, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING WATER POLO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93D, 0x1F3FF }, 2, "PERSON PLAYING WATER POLO: DARK SKIN TONE" },
    { { 0x1F93D, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING WATER POLO: DARK SKIN TONE" },
    { { 0x1F93D, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING WATER POLO: DARK SKIN TONE" },
    { { 0x1F93E }, 1, "PERSON PLAYING HANDBALL" },
    { { 0x1F93E, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN PLAYING HANDBALL" },
    { { 0x1F93E, 0x200D, 0x2642, 0xFE0F }, 4, "MAN PLAYING HANDBALL" },
    { { 0x1F93E, 0x1F3FB }, 2, "PERSON PLAYING HANDBALL: LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING HANDBALL: LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING HANDBALL: LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FC }, 2, "PERSON PLAYING HANDBALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING HANDBALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING HANDBALL: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F93E, 0x1F3FD }, 2, "PERSON PLAYING HANDBALL: MEDIUM SKIN TONE" },
    { { 0x1F93E, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING HANDBALL: MEDIUM SKIN TONE" },
    { { 0x1F93E, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING HANDBALL: MEDIUM SKIN TONE" },
    { { 0x1F93E, 0x1F3FE }, 2, "PERSON PLAYING HANDBALL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93E, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING HANDBALL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93E, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING HANDBALL: MEDIUM-DARK SKIN TONE" },
    { { 0x1F93E, 0x1F3FF }, 2, "PERSON PLAYING HANDBALL: DARK SKIN TONE" },
    { { 0x1F93E, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN PLAYING HANDBALL: DARK SKIN TONE" },
    { { 0x1F93E, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN PLAYING HANDBALL: DARK SKIN TONE" },
    { { 0x1F93F }, 1, "DIVING MASK" },
    { { 0x1F940 }, 1, "WILTED FLOWER" },
    { { 0x1F941 }, 1, "DRUM" },
    { { 0x1F942 }, 1, "CLINKING GLASSES" },
    { { 0x1F943 }, 1, "TUMBLER GLASS" },
    { { 0x1F944 }, 1, "SPOON" },
    { { 0x1F945 }, 1, "GOAL NET" },
    { { 0x1F947 }, 1, "1ST PLACE MEDAL" },
    { { 0x1F948 }, 1, "2ND PLACE MEDAL" },
    { { 0x1F949 }, 1, "3RD PLACE MEDAL" },
    { { 0x1F94A }, 1, "BOXING GLOVE" },
    { { 0x1F94B }, 1, "MARTIAL ARTS UNIFORM" },
    { { 0x1F94C }, 1, "CURLING STONE" },
    { { 0x1F94D }, 1, "LACROSSE" },
    { { 0x1F94E }, 1, "SOFTBALL" },
    { { 0x1F94F }, 1, "FLYING DISC" },
    { { 0x1F950 }, 1, "CROISSANT" },
    { { 0x1F951 }, 1, "AVOCADO" },
    { { 0x1F952 }, 1, "CUCUMBER" },
    { { 0x1F953 }, 1, "BACON" },
    { { 0x1F954 }, 1, "POTATO" },
    { { 0x1F955 }, 1, "CARROT" },
    { { 0x1F956 }, 1, "BAGUETTE BREAD" },
    { { 0x1F957 }, 1, "GREEN SALAD" },
    { { 0x1F958 }, 1, "SHALLOW PAN OF FOOD" },
    { { 0x1F959 }, 1, "STUFFED FLATBREAD" },
    { { 0x1F95A }, 1, "EGG" },
    { { 0x1F95B }, 1, "GLASS OF MILK" },
    { { 0x1F95C }, 1, "PEANUTS" },
    { { 0x1F95D }, 1, "KIWI FRUIT" },
    { { 0x1F95E }, 1, "PANCAKES" },
    { { 0x1F95F }, 1, "DUMPLING" },
    { { 0x1F960 }, 1, "FORTUNE COOKIE" },
    { { 0x1F961 }, 1, "TAKEOUT BOX" },
    { { 0x1F962 }, 1, "CHOPSTICKS" },
    { { 0x1F963 }, 1, "BOWL WITH SPOON" },
    { { 0x1F964 }, 1, "CUP WITH STRAW" },
    { { 0x1F965 }, 1, "COCONUT" },
    { { 0x1F966 }, 1, "BROCCOLI" },
    { { 0x1F967 }, 1, "PIE" },
    { { 0x1F968 }, 1, "PRETZEL" },
    { { 0x1F969 }, 1, "CUT OF MEAT" },
    { { 0x1F96A }, 1, "SANDWICH" },
    { { 0x1F96B }, 1, "CANNED FOOD" },
    { { 0x1F96C }, 1, "LEAFY GREEN" },
    { { 0x1F96D }, 1, "MANGO" },
    { { 0x1F96E }, 1, "MOON CAKE" },
    { { 0x1F96F }, 1, "BAGEL" },
    { { 0x1F970 }, 1, "SMILING FACE WITH HEARTS" },
    { { 0x1F971 }, 1, "YAWNING FACE" },
    { { 0x1F972 }, 1, "SMILING FACE WITH TEAR" },
    { { 0x1F973 }, 1, "PARTYING FACE" },
    { { 0x1F974 }, 1, "WOOZY FACE" },
    { { 0x1F975 }, 1, "HOT FACE" },
    { { 0x1F976 }, 1, "COLD FACE" },
    { { 0x1F977 }, 1, "NINJA" },
    { { 0x1F977, 0x1F3FB }, 2, "NINJA: LIGHT SKIN TONE" },
    { { 0x1F977, 0x1F3FC }, 2, "NINJA: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F977, 0x1F3FD }, 2, "NINJA: MEDIUM SKIN TONE" },
    { { 0x1F977, 0x1F3FE }, 2, "NINJA: MEDIUM-DARK SKIN TONE" },
    { { 0x1F977, 0x1F3FF }, 2, "NINJA: DARK SKIN TONE" },
    { { 0x1F978 }, 1, "DISGUISED FACE" },
    { { 0x1F979 }, 1, "FACE HOLDING BACK TEARS" },
    { { 0x1F97A }, 1, "PLEADING FACE" },
    { { 0x1F97B }, 1, "SARI" },
    { { 0x1F97C }, 1, "LAB COAT" },
    { { 0x1F97D }, 1, "GOGGLES" },
    { { 0x1F97E }, 1, "HIKING BOOT" },
    { { 0x1F97F }, 1, "FLAT SHOE" },
    { { 0x1F980 }, 1, "CRAB" },
    { { 0x1F981 }, 1, "LION" },
    { { 0x1F982 }, 1, "SCORPION" },
    { { 0x1F983 }, 1, "TURKEY" },
    { { 0x1F984 }, 1, "UNICORN" },
    { { 0x1F985 }, 1, "EAGLE" },
    { { 0x1F986 }, 1, "DUCK" },
    { { 0x1F987 }, 1, "BAT" },
    { { 0x1F988 }, 1, "SHARK" },
    { { 0x1F989 }, 1, "OWL" },
    { { 0x1F98A }, 1, "FOX" },
    { { 0x1F98B }, 1, "BUTTERFLY" },
    { { 0x1F98C }, 1, "DEER" },
    { { 0x1F98D }, 1, "GORILLA" },
    { { 0x1F98E }, 1, "LIZARD" },
    { { 0x1F98F }, 1, "RHINOCEROS" },
    { { 0x1F990 }, 1, "SHRIMP" },
    { { 0x1F991 }, 1, "SQUID" },
    { { 0x1F992 }, 1, "GIRAFFE" },
    { { 0x1F993 }, 1, "ZEBRA" },
    { { 0x1F994 }, 1, "HEDGEHOG" },
    { { 0x1F995 }, 1, "SAUROPOD" },
    { { 0x1F996 }, 1, "T-REX" },
    { { 0x1F997 }, 1, "CRICKET" },
    { { 0x1F998 }, 1, "KANGAROO" },
    { { 0x1F999 }, 1, "LLAMA" },
    { { 0x1F99A }, 1, "PEACOCK" },
    { { 0x1F99B }, 1, "HIPPOPOTAMUS" },
    { { 0x1F99C }, 1, "PARROT" },
    { { 0x1F99D }, 1, "RACCOON" },
    { { 0x1F99E }, 1, "LOBSTER" },
    { { 0x1F99F }, 1, "MOSQUITO" },
    { { 0x1F9A0 }, 1, "MICROBE" },
    { { 0x1F9A1 }, 1, "BADGER" },
    { { 0x1F9A2 }, 1, "SWAN" },
    { { 0x1F9A3 }, 1, "MAMMOTH" },
    { { 0x1F9A4 }, 1, "DODO" },
    { { 0x1F9A5 }, 1, "SLOTH" },
    { { 0x1F9A6 }, 1, "OTTER" },
    { { 0x1F9A7 }, 1, "ORANGUTAN" },
    { { 0x1F9A8 }, 1, "SKUNK" },
    { { 0x1F9A9 }, 1, "FLAMINGO" },
    { { 0x1F9AA }, 1, "OYSTER" },
    { { 0x1F9AB }, 1, "BEAVER" },
    { { 0x1F9AC }, 1, "BISON" },
    { { 0x1F9AD }, 1, "SEAL" },
    { { 0x1F9AE }, 1, "GUIDE DOG" },
    { { 0x1F9AF }, 1, "WHITE CANE" },
    { { 0x1F9B4 }, 1, "BONE" },
    { { 0x1F9B5 }, 1, "LEG" },
    { { 0x1F9B5, 0x1F3FB }, 2, "LEG: LIGHT SKIN TONE" },
    { { 0x1F9B5, 0x1F3FC }, 2, "LEG: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B5, 0x1F3FD }, 2, "LEG: MEDIUM SKIN TONE" },
    { { 0x1F9B5, 0x1F3FE }, 2, "LEG: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B5, 0x1F3FF }, 2, "LEG: DARK SKIN TONE" },
    { { 0x1F9B6 }, 1, "FOOT" },
    { { 0x1F9B6, 0x1F3FB }, 2, "FOOT: LIGHT SKIN TONE" },
    { { 0x1F9B6, 0x1F3FC }, 2, "FOOT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B6, 0x1F3FD }, 2, "FOOT: MEDIUM SKIN TONE" },
    { { 0x1F9B6, 0x1F3FE }, 2, "FOOT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B6, 0x1F3FF }, 2, "FOOT: DARK SKIN TONE" },
    { { 0x1F9B7 }, 1, "TOOTH" },
    { { 0x1F9B8 }, 1, "SUPERHERO" },
    { { 0x1F9B8, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN SUPERHERO" },
    { { 0x1F9B8, 0x200D, 0x2642, 0xFE0F }, 4, "MAN SUPERHERO" },
    { { 0x1F9B8, 0x1F3FB }, 2, "SUPERHERO: LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERHERO: LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERHERO: LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FC }, 2, "SUPERHERO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERHERO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERHERO: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B8, 0x1F3FD }, 2, "SUPERHERO: MEDIUM SKIN TONE" },
    { { 0x1F9B8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERHERO: MEDIUM SKIN TONE" },
    { { 0x1F9B8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERHERO: MEDIUM SKIN TONE" },
    { { 0x1F9B8, 0x1F3FE }, 2, "SUPERHERO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERHERO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERHERO: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B8, 0x1F3FF }, 2, "SUPERHERO: DARK SKIN TONE" },
    { { 0x1F9B8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERHERO: DARK SKIN TONE" },
    { { 0x1F9B8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERHERO: DARK SKIN TONE" },
    { { 0x1F9B9 }, 1, "SUPERVILLAIN" },
    { { 0x1F9B9, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN SUPERVILLAIN" },
    { { 0x1F9B9, 0x200D, 0x2642, 0xFE0F }, 4, "MAN SUPERVILLAIN" },
    { { 0x1F9B9, 0x1F3FB }, 2, "SUPERVILLAIN: LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERVILLAIN: LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERVILLAIN: LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FC }, 2, "SUPERVILLAIN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERVILLAIN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERVILLAIN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9B9, 0x1F3FD }, 2, "SUPERVILLAIN: MEDIUM SKIN TONE" },
    { { 0x1F9B9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERVILLAIN: MEDIUM SKIN TONE" },
    { { 0x1F9B9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERVILLAIN: MEDIUM SKIN TONE" },
    { { 0x1F9B9, 0x1F3FE }, 2, "SUPERVILLAIN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERVILLAIN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERVILLAIN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9B9, 0x1F3FF }, 2, "SUPERVILLAIN: DARK SKIN TONE" },
    { { 0x1F9B9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN SUPERVILLAIN: DARK SKIN TONE" },
    { { 0x1F9B9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN SUPERVILLAIN: DARK SKIN TONE" },
    { { 0x1F9BA }, 1, "SAFETY VEST" },
    { { 0x1F9BB }, 1, "EAR WITH HEARING AID" },
    { { 0x1F9BB, 0x1F3FB }, 2, "EAR WITH HEARING AID: LIGHT SKIN TONE" },
    { { 0x1F9BB, 0x1F3FC }, 2, "EAR WITH HEARING AID: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9BB, 0x1F3FD }, 2, "EAR WITH HEARING AID: MEDIUM SKIN TONE" },
    { { 0x1F9BB, 0x1F3FE }, 2, "EAR WITH HEARING AID: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9BB, 0x1F3FF }, 2, "EAR WITH HEARING AID: DARK SKIN TONE" },
    { { 0x1F9BC }, 1, "MOTORIZED WHEELCHAIR" },
    { { 0x1F9BD }, 1, "MANUAL WHEELCHAIR" },
    { { 0x1F9BE }, 1, "MECHANICAL ARM" },
    { { 0x1F9BF }, 1, "MECHANICAL LEG" },
    { { 0x1F9C0 }, 1, "CHEESE WEDGE" },
    { { 0x1F9C1 }, 1, "CUPCAKE" },
    { { 0x1F9C2 }, 1, "SALT" },
    { { 0x1F9C3 }, 1, "BEVERAGE BOX" },
    { { 0x1F9C4 }, 1, "GARLIC" },
    { { 0x1F9C5 }, 1, "ONION" },
    { { 0x1F9C6 }, 1, "FALAFEL" },
    { { 0x1F9C7 }, 1, "WAFFLE" },
    { { 0x1F9C8 }, 1, "BUTTER" },
    { { 0x1F9C9 }, 1, "MATE" },
    { { 0x1F9CA }, 1, "ICE" },
    { { 0x1F9CB }, 1, "BUBBLE TEA" },
    { { 0x1F9CC }, 1, "TROLL" },
    { { 0x1F9CD }, 1, "PERSON STANDING" },
    { { 0x1F9CD, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN STANDING" },
    { { 0x1F9CD, 0x200D, 0x2642, 0xFE0F }, 4, "MAN STANDING" },
    { { 0x1F9CD, 0x1F3FB }, 2, "PERSON STANDING: LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN STANDING: LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN STANDING: LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FC }, 2, "PERSON STANDING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN STANDING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN STANDING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CD, 0x1F3FD }, 2, "PERSON STANDING: MEDIUM SKIN TONE" },
    { { 0x1F9CD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN STANDING: MEDIUM SKIN TONE" },
    { { 0x1F9CD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN STANDING: MEDIUM SKIN TONE" },
    { { 0x1F9CD, 0x1F3FE }, 2, "PERSON STANDING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN STANDING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN STANDING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CD, 0x1F3FF }, 2, "PERSON STANDING: DARK SKIN TONE" },
    { { 0x1F9CD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN STANDING: DARK SKIN TONE" },
    { { 0x1F9CD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN STANDING: DARK SKIN TONE" },
    { { 0x1F9CE }, 1, "PERSON KNEELING" },
    { { 0x1F9CE, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN KNEELING" },
    { { 0x1F9CE, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "WOMAN KNEELING FACING RIGHT" },
    { { 0x1F9CE, 0x200D, 0x2642, 0xFE0F }, 4, "MAN KNEELING" },
    { { 0x1F9CE, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 7, "MAN KNEELING FACING RIGHT" },
    { { 0x1F9CE, 0x200D, 0x27A1, 0xFE0F }, 4, "PERSON KNEELING FACING RIGHT" },
    { { 0x1F9CE, 0x1F3FB }, 2, "PERSON KNEELING: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN KNEELING: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FB, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN KNEELING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN KNEELING: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FB, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN KNEELING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FB, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON KNEELING FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC }, 2, "PERSON KNEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN KNEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN KNEELING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN KNEELING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN KNEELING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FC, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON KNEELING FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD }, 2, "PERSON KNEELING: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN KNEELING: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN KNEELING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN KNEELING: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN KNEELING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FD, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON KNEELING FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE }, 2, "PERSON KNEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN KNEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN KNEELING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN KNEELING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN KNEELING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FE, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON KNEELING FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF }, 2, "PERSON KNEELING: DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN KNEELING: DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF, 0x200D, 0x2640, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "WOMAN KNEELING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN KNEELING: DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF, 0x200D, 0x2642, 0xFE0F, 0x200D, 0x27A1, 0xFE0F }, 8, "MAN KNEELING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9CE, 0x1F3FF, 0x200D, 0x27A1, 0xFE0F }, 5, "PERSON KNEELING FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9CF }, 1, "DEAF PERSON" },
    { { 0x1F9CF, 0x200D, 0x2640, 0xFE0F }, 4, "DEAF WOMAN" },
    { { 0x1F9CF, 0x200D, 0x2642, 0xFE0F }, 4, "DEAF MAN" },
    { { 0x1F9CF, 0x1F3FB }, 2, "DEAF PERSON: LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "DEAF WOMAN: LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "DEAF MAN: LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FC }, 2, "DEAF PERSON: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "DEAF WOMAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "DEAF MAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9CF, 0x1F3FD }, 2, "DEAF PERSON: MEDIUM SKIN TONE" },
    { { 0x1F9CF, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "DEAF WOMAN: MEDIUM SKIN TONE" },
    { { 0x1F9CF, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "DEAF MAN: MEDIUM SKIN TONE" },
    { { 0x1F9CF, 0x1F3FE }, 2, "DEAF PERSON: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CF, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "DEAF WOMAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CF, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "DEAF MAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9CF, 0x1F3FF }, 2, "DEAF PERSON: DARK SKIN TONE" },
    { { 0x1F9CF, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "DEAF WOMAN: DARK SKIN TONE" },
    { { 0x1F9CF, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "DEAF MAN: DARK SKIN TONE" },
    { { 0x1F9D0 }, 1, "FACE WITH MONOCLE" },
    { { 0x1F9D1 }, 1, "PERSON" },
    { { 0x1F9D1, 0x200D, 0x2695, 0xFE0F }, 4, "HEALTH WORKER" },
    { { 0x1F9D1, 0x200D, 0x2696, 0xFE0F }, 4, "JUDGE" },
    { { 0x1F9D1, 0x200D, 0x2708, 0xFE0F }, 4, "PILOT" },
    { { 0x1F9D1, 0x200D, 0x1F33E }, 3, "FARMER" },
    { { 0x1F9D1, 0x200D, 0x1F373 }, 3, "COOK" },
    { { 0x1F9D1, 0x200D, 0x1F37C }, 3, "PERSON FEEDING BABY" },
    { { 0x1F9D1, 0x200D, 0x1F384 }, 3, "MX CLAUS" },
    { { 0x1F9D1, 0x200D, 0x1F393 }, 3, "STUDENT" },
    { { 0x1F9D1, 0x200D, 0x1F3A4 }, 3, "SINGER" },
    { { 0x1F9D1, 0x200D, 0x1F3A8 }, 3, "ARTIST" },
    { { 0x1F9D1, 0x200D, 0x1F3EB }, 3, "TEACHER" },
    { { 0x1F9D1, 0x200D, 0x1F3ED }, 3, "FACTORY WORKER" },
    { { 0x1F9D1, 0x200D, 0x1F4BB }, 3, "TECHNOLOGIST" },
    { { 0x1F9D1, 0x200D, 0x1F4BC }, 3, "OFFICE WORKER" },
    { { 0x1F9D1, 0x200D, 0x1F527 }, 3, "MECHANIC" },
    { { 0x1F9D1, 0x200D, 0x1F52C }, 3, "SCIENTIST" },
    { { 0x1F9D1, 0x200D, 0x1F680 }, 3, "ASTRONAUT" },
    { { 0x1F9D1, 0x200D, 0x1F692 }, 3, "FIREFIGHTER" },
    { { 0x1F9D1, 0x200D, 0x1F91D, 0x200D, 0x1F9D1 }, 5, "PEOPLE HOLDING HANDS" },
    { { 0x1F9D1, 0x200D, 0x1F9AF }, 3, "PERSON WITH WHITE CANE" },
    { { 0x1F9D1, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 6, "PERSON WITH WHITE CANE FACING RIGHT" },
    { { 0x1F9D1, 0x200D, 0x1F9B0 }, 3, "PERSON: RED HAIR" },
    { { 0x1F9D1, 0x200D, 0x1F9B1 }, 3, "PERSON: CURLY HAIR" },
    { { 0x1F9D1, 0x200D, 0x1F9B2 }, 3, "PERSON: BALD" },
    { { 0x1F9D1, 0x200D, 0x1F9B3 }, 3, "PERSON: WHITE HAIR" },
    { { 0x1F9D1, 0x200D, 0x1F9BC }, 3, "PERSON IN MOTORIZED WHEELCHAIR" },
    { { 0x1F9D1, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 6, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT" },
    { { 0x1F9D1, 0x200D, 0x1F9BD }, 3, "PERSON IN MANUAL WHEELCHAIR" },
    { { 0x1F9D1, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 6, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT" },
    { { 0x1F9D1, 0x200D, 0x1F9D1, 0x200D, 0x1F9D2 }, 5, "FAMILY: ADULT, ADULT, CHILD" },
    { { 0x1F9D1, 0x200D, 0x1F9D1, 0x200D, 0x1F9D2, 0x200D, 0x1F9D2 }, 7, "FAMILY: ADULT, ADULT, CHILD, CHILD" },
    { { 0x1F9D1, 0x200D, 0x1F9D2 }, 3, "FAMILY: ADULT, CHILD" },
    { { 0x1F9D1, 0x200D, 0x1F9D2, 0x200D, 0x1F9D2 }, 5, "FAMILY: ADULT, CHILD, CHILD" },
    { { 0x1F9D1, 0x1F3FB }, 2, "PERSON: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2695, 0xFE0F }, 5, "HEALTH WORKER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2696, 0xFE0F }, 5, "JUDGE: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2708, 0xFE0F }, 5, "PILOT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC }, 10, "KISS: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD }, 10, "KISS: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE }, 10, "KISS: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF }, 10, "KISS: PERSON, PERSON, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC }, 8, "COUPLE WITH HEART: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD }, 8, "COUPLE WITH HEART: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE }, 8, "COUPLE WITH HEART: PERSON, PERSON, LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF }, 8, "COUPLE WITH HEART: PERSON, PERSON, LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F33E }, 4, "FARMER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F373 }, 4, "COOK: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F37C }, 4, "PERSON FEEDING BABY: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F384 }, 4, "MX CLAUS: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F393 }, 4, "STUDENT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A4 }, 4, "SINGER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F3A8 }, 4, "ARTIST: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F3EB }, 4, "TEACHER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F3ED }, 4, "FACTORY WORKER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BB }, 4, "TECHNOLOGIST: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F4BC }, 4, "OFFICE WORKER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F527 }, 4, "MECHANIC: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F52C }, 4, "SCIENTIST: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F680 }, 4, "ASTRONAUT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F692 }, 4, "FIREFIGHTER: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB }, 7, "PEOPLE HOLDING HANDS: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC }, 7, "PEOPLE HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD }, 7, "PEOPLE HOLDING HANDS: LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE }, 7, "PEOPLE HOLDING HANDS: LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF }, 7, "PEOPLE HOLDING HANDS: LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9AF }, 4, "PERSON WITH WHITE CANE: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON WITH WHITE CANE FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B0 }, 4, "PERSON: LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B1 }, 4, "PERSON: LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B2 }, 4, "PERSON: LIGHT SKIN TONE, BALD" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9B3 }, 4, "PERSON: LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BC }, 4, "PERSON IN MOTORIZED WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BD }, 4, "PERSON IN MANUAL WHEELCHAIR: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FB, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT: LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC }, 2, "PERSON: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2695, 0xFE0F }, 5, "HEALTH WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2696, 0xFE0F }, 5, "JUDGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2708, 0xFE0F }, 5, "PILOT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB }, 10, "KISS: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD }, 10, "KISS: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE }, 10, "KISS: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF }, 10, "KISS: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F33E }, 4, "FARMER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F373 }, 4, "COOK: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F37C }, 4, "PERSON FEEDING BABY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F384 }, 4, "MX CLAUS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F393 }, 4, "STUDENT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A4 }, 4, "SINGER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F3A8 }, 4, "ARTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F3EB }, 4, "TEACHER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F3ED }, 4, "FACTORY WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BB }, 4, "TECHNOLOGIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F4BC }, 4, "OFFICE WORKER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F527 }, 4, "MECHANIC: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F52C }, 4, "SCIENTIST: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F680 }, 4, "ASTRONAUT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F692 }, 4, "FIREFIGHTER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB }, 7, "PEOPLE HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC }, 7, "PEOPLE HOLDING HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD }, 7, "PEOPLE HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE }, 7, "PEOPLE HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF }, 7, "PEOPLE HOLDING HANDS: MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9AF }, 4, "PERSON WITH WHITE CANE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON WITH WHITE CANE FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B0 }, 4, "PERSON: MEDIUM-LIGHT SKIN TONE, RED HAIR" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B1 }, 4, "PERSON: MEDIUM-LIGHT SKIN TONE, CURLY HAIR" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B2 }, 4, "PERSON: MEDIUM-LIGHT SKIN TONE, BALD" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9B3 }, 4, "PERSON: MEDIUM-LIGHT SKIN TONE, WHITE HAIR" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BC }, 4, "PERSON IN MOTORIZED WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BD }, 4, "PERSON IN MANUAL WHEELCHAIR: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FC, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD }, 2, "PERSON: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2695, 0xFE0F }, 5, "HEALTH WORKER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2696, 0xFE0F }, 5, "JUDGE: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2708, 0xFE0F }, 5, "PILOT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB }, 10, "KISS: PERSON, PERSON, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC }, 10, "KISS: PERSON, PERSON, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE }, 10, "KISS: PERSON, PERSON, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF }, 10, "KISS: PERSON, PERSON, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F33E }, 4, "FARMER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F373 }, 4, "COOK: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F37C }, 4, "PERSON FEEDING BABY: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F384 }, 4, "MX CLAUS: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F393 }, 4, "STUDENT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A4 }, 4, "SINGER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F3A8 }, 4, "ARTIST: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F3EB }, 4, "TEACHER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F3ED }, 4, "FACTORY WORKER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BB }, 4, "TECHNOLOGIST: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F4BC }, 4, "OFFICE WORKER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F527 }, 4, "MECHANIC: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F52C }, 4, "SCIENTIST: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F680 }, 4, "ASTRONAUT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F692 }, 4, "FIREFIGHTER: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB }, 7, "PEOPLE HOLDING HANDS: MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC }, 7, "PEOPLE HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD }, 7, "PEOPLE HOLDING HANDS: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE }, 7, "PEOPLE HOLDING HANDS: MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF }, 7, "PEOPLE HOLDING HANDS: MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9AF }, 4, "PERSON WITH WHITE CANE: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON WITH WHITE CANE FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B0 }, 4, "PERSON: MEDIUM SKIN TONE, RED HAIR" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B1 }, 4, "PERSON: MEDIUM SKIN TONE, CURLY HAIR" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B2 }, 4, "PERSON: MEDIUM SKIN TONE, BALD" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9B3 }, 4, "PERSON: MEDIUM SKIN TONE, WHITE HAIR" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BC }, 4, "PERSON IN MOTORIZED WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BD }, 4, "PERSON IN MANUAL WHEELCHAIR: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FD, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE }, 2, "PERSON: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2695, 0xFE0F }, 5, "HEALTH WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2696, 0xFE0F }, 5, "JUDGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2708, 0xFE0F }, 5, "PILOT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB }, 10, "KISS: PERSON, PERSON, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC }, 10, "KISS: PERSON, PERSON, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD }, 10, "KISS: PERSON, PERSON, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FF }, 10, "KISS: PERSON, PERSON, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FF }, 8, "COUPLE WITH HEART: PERSON, PERSON, MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F33E }, 4, "FARMER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F373 }, 4, "COOK: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F37C }, 4, "PERSON FEEDING BABY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F384 }, 4, "MX CLAUS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F393 }, 4, "STUDENT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A4 }, 4, "SINGER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F3A8 }, 4, "ARTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F3EB }, 4, "TEACHER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F3ED }, 4, "FACTORY WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BB }, 4, "TECHNOLOGIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F4BC }, 4, "OFFICE WORKER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F527 }, 4, "MECHANIC: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F52C }, 4, "SCIENTIST: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F680 }, 4, "ASTRONAUT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F692 }, 4, "FIREFIGHTER: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB }, 7, "PEOPLE HOLDING HANDS: MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC }, 7, "PEOPLE HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD }, 7, "PEOPLE HOLDING HANDS: MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE }, 7, "PEOPLE HOLDING HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF }, 7, "PEOPLE HOLDING HANDS: MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9AF }, 4, "PERSON WITH WHITE CANE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON WITH WHITE CANE FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B0 }, 4, "PERSON: MEDIUM-DARK SKIN TONE, RED HAIR" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B1 }, 4, "PERSON: MEDIUM-DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B2 }, 4, "PERSON: MEDIUM-DARK SKIN TONE, BALD" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9B3 }, 4, "PERSON: MEDIUM-DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BC }, 4, "PERSON IN MOTORIZED WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BD }, 4, "PERSON IN MANUAL WHEELCHAIR: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FE, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF }, 2, "PERSON: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2695, 0xFE0F }, 5, "HEALTH WORKER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2696, 0xFE0F }, 5, "JUDGE: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2708, 0xFE0F }, 5, "PILOT: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FB }, 10, "KISS: PERSON, PERSON, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FC }, 10, "KISS: PERSON, PERSON, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FD }, 10, "KISS: PERSON, PERSON, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F48B, 0x200D, 0x1F9D1, 0x1F3FE }, 10, "KISS: PERSON, PERSON, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FB }, 8, "COUPLE WITH HEART: PERSON, PERSON, DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FC }, 8, "COUPLE WITH HEART: PERSON, PERSON, DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FD }, 8, "COUPLE WITH HEART: PERSON, PERSON, DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x2764, 0xFE0F, 0x200D, 0x1F9D1, 0x1F3FE }, 8, "COUPLE WITH HEART: PERSON, PERSON, DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F33E }, 4, "FARMER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F373 }, 4, "COOK: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F37C }, 4, "PERSON FEEDING BABY: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F384 }, 4, "MX CLAUS: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F393 }, 4, "STUDENT: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A4 }, 4, "SINGER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F3A8 }, 4, "ARTIST: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F3EB }, 4, "TEACHER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F3ED }, 4, "FACTORY WORKER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BB }, 4, "TECHNOLOGIST: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F4BC }, 4, "OFFICE WORKER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F527 }, 4, "MECHANIC: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F52C }, 4, "SCIENTIST: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F680 }, 4, "ASTRONAUT: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F692 }, 4, "FIREFIGHTER: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FB }, 7, "PEOPLE HOLDING HANDS: DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FC }, 7, "PEOPLE HOLDING HANDS: DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FD }, 7, "PEOPLE HOLDING HANDS: DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FE }, 7, "PEOPLE HOLDING HANDS: DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F91D, 0x200D, 0x1F9D1, 0x1F3FF }, 7, "PEOPLE HOLDING HANDS: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9AF }, 4, "PERSON WITH WHITE CANE: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9AF, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON WITH WHITE CANE FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B0 }, 4, "PERSON: DARK SKIN TONE, RED HAIR" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B1 }, 4, "PERSON: DARK SKIN TONE, CURLY HAIR" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B2 }, 4, "PERSON: DARK SKIN TONE, BALD" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9B3 }, 4, "PERSON: DARK SKIN TONE, WHITE HAIR" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BC }, 4, "PERSON IN MOTORIZED WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BC, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MOTORIZED WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BD }, 4, "PERSON IN MANUAL WHEELCHAIR: DARK SKIN TONE" },
    { { 0x1F9D1, 0x1F3FF, 0x200D, 0x1F9BD, 0x200D, 0x27A1, 0xFE0F }, 7, "PERSON IN MANUAL WHEELCHAIR FACING RIGHT: DARK SKIN TONE" },
    { { 0x1F9D2 }, 1, "CHILD" },
    { { 0x1F9D2, 0x1F3FB }, 2, "CHILD: LIGHT SKIN TONE" },
    { { 0x1F9D2, 0x1F3FC }, 2, "CHILD: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D2, 0x1F3FD }, 2, "CHILD: MEDIUM SKIN TONE" },
    { { 0x1F9D2, 0x1F3FE }, 2, "CHILD: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D2, 0x1F3FF }, 2, "CHILD: DARK SKIN TONE" },
    { { 0x1F9D3 }, 1, "OLDER PERSON" },
    { { 0x1F9D3, 0x1F3FB }, 2, "OLDER PERSON: LIGHT SKIN TONE" },
    { { 0x1F9D3, 0x1F3FC }, 2, "OLDER PERSON: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D3, 0x1F3FD }, 2, "OLDER PERSON: MEDIUM SKIN TONE" },
    { { 0x1F9D3, 0x1F3FE }, 2, "OLDER PERSON: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D3, 0x1F3FF }, 2, "OLDER PERSON: DARK SKIN TONE" },
    { { 0x1F9D4 }, 1, "PERSON: BEARD" },
    { { 0x1F9D4, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN: BEARD" },
    { { 0x1F9D4, 0x200D, 0x2642, 0xFE0F }, 4, "MAN: BEARD" },
    { { 0x1F9D4, 0x1F3FB }, 2, "PERSON: LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FC }, 2, "PERSON: MEDIUM-LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM-LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM-LIGHT SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FD }, 2, "PERSON: MEDIUM SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FE }, 2, "PERSON: MEDIUM-DARK SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: MEDIUM-DARK SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: MEDIUM-DARK SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FF }, 2, "PERSON: DARK SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN: DARK SKIN TONE, BEARD" },
    { { 0x1F9D4, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN: DARK SKIN TONE, BEARD" },
    { { 0x1F9D5 }, 1, "WOMAN WITH HEADSCARF" },
    { { 0x1F9D5, 0x1F3FB }, 2, "WOMAN WITH HEADSCARF: LIGHT SKIN TONE" },
    { { 0x1F9D5, 0x1F3FC }, 2, "WOMAN WITH HEADSCARF: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D5, 0x1F3FD }, 2, "WOMAN WITH HEADSCARF: MEDIUM SKIN TONE" },
    { { 0x1F9D5, 0x1F3FE }, 2, "WOMAN WITH HEADSCARF: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D5, 0x1F3FF }, 2, "WOMAN WITH HEADSCARF: DARK SKIN TONE" },
    { { 0x1F9D6 }, 1, "PERSON IN STEAMY ROOM" },
    { { 0x1F9D6, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN IN STEAMY ROOM" },
    { { 0x1F9D6, 0x200D, 0x2642, 0xFE0F }, 4, "MAN IN STEAMY ROOM" },
    { { 0x1F9D6, 0x1F3FB }, 2, "PERSON IN STEAMY ROOM: LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN STEAMY ROOM: LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN STEAMY ROOM: LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FC }, 2, "PERSON IN STEAMY ROOM: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN STEAMY ROOM: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN STEAMY ROOM: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D6, 0x1F3FD }, 2, "PERSON IN STEAMY ROOM: MEDIUM SKIN TONE" },
    { { 0x1F9D6, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN STEAMY ROOM: MEDIUM SKIN TONE" },
    { { 0x1F9D6, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN STEAMY ROOM: MEDIUM SKIN TONE" },
    { { 0x1F9D6, 0x1F3FE }, 2, "PERSON IN STEAMY ROOM: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D6, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN STEAMY ROOM: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D6, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN STEAMY ROOM: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D6, 0x1F3FF }, 2, "PERSON IN STEAMY ROOM: DARK SKIN TONE" },
    { { 0x1F9D6, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN STEAMY ROOM: DARK SKIN TONE" },
    { { 0x1F9D6, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN STEAMY ROOM: DARK SKIN TONE" },
    { { 0x1F9D7 }, 1, "PERSON CLIMBING" },
    { { 0x1F9D7, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN CLIMBING" },
    { { 0x1F9D7, 0x200D, 0x2642, 0xFE0F }, 4, "MAN CLIMBING" },
    { { 0x1F9D7, 0x1F3FB }, 2, "PERSON CLIMBING: LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CLIMBING: LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CLIMBING: LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FC }, 2, "PERSON CLIMBING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CLIMBING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CLIMBING: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D7, 0x1F3FD }, 2, "PERSON CLIMBING: MEDIUM SKIN TONE" },
    { { 0x1F9D7, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CLIMBING: MEDIUM SKIN TONE" },
    { { 0x1F9D7, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CLIMBING: MEDIUM SKIN TONE" },
    { { 0x1F9D7, 0x1F3FE }, 2, "PERSON CLIMBING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D7, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CLIMBING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D7, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CLIMBING: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D7, 0x1F3FF }, 2, "PERSON CLIMBING: DARK SKIN TONE" },
    { { 0x1F9D7, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN CLIMBING: DARK SKIN TONE" },
    { { 0x1F9D7, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN CLIMBING: DARK SKIN TONE" },
    { { 0x1F9D8 }, 1, "PERSON IN LOTUS POSITION" },
    { { 0x1F9D8, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN IN LOTUS POSITION" },
    { { 0x1F9D8, 0x200D, 0x2642, 0xFE0F }, 4, "MAN IN LOTUS POSITION" },
    { { 0x1F9D8, 0x1F3FB }, 2, "PERSON IN LOTUS POSITION: LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN LOTUS POSITION: LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN LOTUS POSITION: LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FC }, 2, "PERSON IN LOTUS POSITION: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN LOTUS POSITION: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN LOTUS POSITION: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D8, 0x1F3FD }, 2, "PERSON IN LOTUS POSITION: MEDIUM SKIN TONE" },
    { { 0x1F9D8, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN LOTUS POSITION: MEDIUM SKIN TONE" },
    { { 0x1F9D8, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN LOTUS POSITION: MEDIUM SKIN TONE" },
    { { 0x1F9D8, 0x1F3FE }, 2, "PERSON IN LOTUS POSITION: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D8, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN LOTUS POSITION: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D8, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN LOTUS POSITION: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D8, 0x1F3FF }, 2, "PERSON IN LOTUS POSITION: DARK SKIN TONE" },
    { { 0x1F9D8, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN IN LOTUS POSITION: DARK SKIN TONE" },
    { { 0x1F9D8, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN IN LOTUS POSITION: DARK SKIN TONE" },
    { { 0x1F9D9 }, 1, "MAGE" },
    { { 0x1F9D9, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN MAGE" },
    { { 0x1F9D9, 0x200D, 0x2642, 0xFE0F }, 4, "MAN MAGE" },
    { { 0x1F9D9, 0x1F3FB }, 2, "MAGE: LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MAGE: LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MAGE: LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FC }, 2, "MAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MAGE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9D9, 0x1F3FD }, 2, "MAGE: MEDIUM SKIN TONE" },
    { { 0x1F9D9, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MAGE: MEDIUM SKIN TONE" },
    { { 0x1F9D9, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MAGE: MEDIUM SKIN TONE" },
    { { 0x1F9D9, 0x1F3FE }, 2, "MAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D9, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D9, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MAGE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9D9, 0x1F3FF }, 2, "MAGE: DARK SKIN TONE" },
    { { 0x1F9D9, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN MAGE: DARK SKIN TONE" },
    { { 0x1F9D9, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN MAGE: DARK SKIN TONE" },
    { { 0x1F9DA }, 1, "FAIRY" },
    { { 0x1F9DA, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN FAIRY" },
    { { 0x1F9DA, 0x200D, 0x2642, 0xFE0F }, 4, "MAN FAIRY" },
    { { 0x1F9DA, 0x1F3FB }, 2, "FAIRY: LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FAIRY: LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FAIRY: LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FC }, 2, "FAIRY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FAIRY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FAIRY: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DA, 0x1F3FD }, 2, "FAIRY: MEDIUM SKIN TONE" },
    { { 0x1F9DA, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FAIRY: MEDIUM SKIN TONE" },
    { { 0x1F9DA, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FAIRY: MEDIUM SKIN TONE" },
    { { 0x1F9DA, 0x1F3FE }, 2, "FAIRY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DA, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FAIRY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DA, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FAIRY: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DA, 0x1F3FF }, 2, "FAIRY: DARK SKIN TONE" },
    { { 0x1F9DA, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN FAIRY: DARK SKIN TONE" },
    { { 0x1F9DA, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN FAIRY: DARK SKIN TONE" },
    { { 0x1F9DB }, 1, "VAMPIRE" },
    { { 0x1F9DB, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN VAMPIRE" },
    { { 0x1F9DB, 0x200D, 0x2642, 0xFE0F }, 4, "MAN VAMPIRE" },
    { { 0x1F9DB, 0x1F3FB }, 2, "VAMPIRE: LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN VAMPIRE: LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN VAMPIRE: LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FC }, 2, "VAMPIRE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN VAMPIRE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN VAMPIRE: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DB, 0x1F3FD }, 2, "VAMPIRE: MEDIUM SKIN TONE" },
    { { 0x1F9DB, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN VAMPIRE: MEDIUM SKIN TONE" },
    { { 0x1F9DB, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN VAMPIRE: MEDIUM SKIN TONE" },
    { { 0x1F9DB, 0x1F3FE }, 2, "VAMPIRE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DB, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN VAMPIRE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DB, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN VAMPIRE: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DB, 0x1F3FF }, 2, "VAMPIRE: DARK SKIN TONE" },
    { { 0x1F9DB, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN VAMPIRE: DARK SKIN TONE" },
    { { 0x1F9DB, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN VAMPIRE: DARK SKIN TONE" },
    { { 0x1F9DC }, 1, "MERPERSON" },
    { { 0x1F9DC, 0x200D, 0x2640, 0xFE0F }, 4, "MERMAID" },
    { { 0x1F9DC, 0x200D, 0x2642, 0xFE0F }, 4, "MERMAN" },
    { { 0x1F9DC, 0x1F3FB }, 2, "MERPERSON: LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "MERMAID: LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MERMAN: LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FC }, 2, "MERPERSON: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "MERMAID: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MERMAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DC, 0x1F3FD }, 2, "MERPERSON: MEDIUM SKIN TONE" },
    { { 0x1F9DC, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "MERMAID: MEDIUM SKIN TONE" },
    { { 0x1F9DC, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MERMAN: MEDIUM SKIN TONE" },
    { { 0x1F9DC, 0x1F3FE }, 2, "MERPERSON: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DC, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "MERMAID: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DC, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MERMAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DC, 0x1F3FF }, 2, "MERPERSON: DARK SKIN TONE" },
    { { 0x1F9DC, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "MERMAID: DARK SKIN TONE" },
    { { 0x1F9DC, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MERMAN: DARK SKIN TONE" },
    { { 0x1F9DD }, 1, "ELF" },
    { { 0x1F9DD, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN ELF" },
    { { 0x1F9DD, 0x200D, 0x2642, 0xFE0F }, 4, "MAN ELF" },
    { { 0x1F9DD, 0x1F3FB }, 2, "ELF: LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FB, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ELF: LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FB, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ELF: LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FC }, 2, "ELF: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FC, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ELF: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FC, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ELF: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1F9DD, 0x1F3FD }, 2, "ELF: MEDIUM SKIN TONE" },
    { { 0x1F9DD, 0x1F3FD, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ELF: MEDIUM SKIN TONE" },
    { { 0x1F9DD, 0x1F3FD, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ELF: MEDIUM SKIN TONE" },
    { { 0x1F9DD, 0x1F3FE }, 2, "ELF: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DD, 0x1F3FE, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ELF: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DD, 0x1F3FE, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ELF: MEDIUM-DARK SKIN TONE" },
    { { 0x1F9DD, 0x1F3FF }, 2, "ELF: DARK SKIN TONE" },
    { { 0x1F9DD, 0x1F3FF, 0x200D, 0x2640, 0xFE0F }, 5, "WOMAN ELF: DARK SKIN TONE" },
    { { 0x1F9DD, 0x1F3FF, 0x200D, 0x2642, 0xFE0F }, 5, "MAN ELF: DARK SKIN TONE" },
    { { 0x1F9DE }, 1, "GENIE" },
    { { 0x1F9DE, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN GENIE" },
    { { 0x1F9DE, 0x200D, 0x2642, 0xFE0F }, 4, "MAN GENIE" },
    { { 0x1F9DF }, 1, "ZOMBIE" },
    { { 0x1F9DF, 0x200D, 0x2640, 0xFE0F }, 4, "WOMAN ZOMBIE" },
    { { 0x1F9DF, 0x200D, 0x2642, 0xFE0F }, 4, "MAN ZOMBIE" },
    { { 0x1F9E0 }, 1, "BRAIN" },
    { { 0x1F9E1 }, 1, "ORANGE HEART" },
    { { 0x1F9E2 }, 1, "BILLED CAP" },
    { { 0x1F9E3 }, 1, "SCARF" },
    { { 0x1F9E4 }, 1, "GLOVES" },
    { { 0x1F9E5 }, 1, "COAT" },
    { { 0x1F9E6 }, 1, "SOCKS" },
    { { 0x1F9E7 }, 1, "RED ENVELOPE" },
    { { 0x1F9E8 }, 1, "FIRECRACKER" },
    { { 0x1F9E9 }, 1, "PUZZLE PIECE" },
    { { 0x1F9EA }, 1, "TEST TUBE" },
    { { 0x1F9EB }, 1, "PETRI DISH" },
    { { 0x1F9EC }, 1, "DNA" },
    { { 0x1F9ED }, 1, "COMPASS" },
    { { 0x1F9EE }, 1, "ABACUS" },
    { { 0x1F9EF }, 1, "FIRE EXTINGUISHER" },
    { { 0x1F9F0 }, 1, "TOOLBOX" },
    { { 0x1F9F1 }, 1, "BRICK" },
    { { 0x1F9F2 }, 1, "MAGNET" },
    { { 0x1F9F3 }, 1, "LUGGAGE" },
    { { 0x1F9F4 }, 1, "LOTION BOTTLE" },
    { { 0x1F9F5 }, 1, "THREAD" },
    { { 0x1F9F6 }, 1, "YARN" },
    { { 0x1F9F7 }, 1, "SAFETY PIN" },
    { { 0x1F9F8 }, 1, "TEDDY BEAR" },
    { { 0x1F9F9 }, 1, "BROOM" },
    { { 0x1F9FA }, 1, "BASKET" },
    { { 0x1F9FB }, 1, "ROLL OF PAPER" },
    { { 0x1F9FC }, 1, "SOAP" },
    { { 0x1F9FD }, 1, "SPONGE" },
    { { 0x1F9FE }, 1, "RECEIPT" },
    { { 0x1F9FF }, 1, "NAZAR AMULET" },
    { { 0x1FA70 }, 1, "BALLET SHOES" },
    { { 0x1FA71 }, 1, "ONE-PIECE SWIMSUIT" },
    { { 0x1FA72 }, 1, "BRIEFS" },
    { { 0x1FA73 }, 1, "SHORTS" },
    { { 0x1FA74 }, 1, "THONG SANDAL" },
    { { 0x1FA75 }, 1, "LIGHT BLUE HEART" },
    { { 0x1FA76 }, 1, "GREY HEART" },
    { { 0x1FA77 }, 1, "PINK HEART" },
    { { 0x1FA78 }, 1, "DROP OF BLOOD" },
    { { 0x1FA79 }, 1, "ADHESIVE BANDAGE" },
    { { 0x1FA7A }, 1, "STETHOSCOPE" },
    { { 0x1FA7B }, 1, "X-RAY" },
    { { 0x1FA7C }, 1, "CRUTCH" },
    { { 0x1FA80 }, 1, "YO-YO" },
    { { 0x1FA81 }, 1, "KITE" },
    { { 0x1FA82 }, 1, "PARACHUTE" },
    { { 0x1FA83 }, 1, "BOOMERANG" },
    { { 0x1FA84 }, 1, "MAGIC WAND" },
    { { 0x1FA85 }, 1, "PIÑATA" },
    { { 0x1FA86 }, 1, "NESTING DOLLS" },
    { { 0x1FA87 }, 1, "MARACAS" },
    { { 0x1FA88 }, 1, "FLUTE" },
    { { 0x1FA89 }, 1, "HARP" },
    { { 0x1FA8F }, 1, "SHOVEL" },
    { { 0x1FA90 }, 1, "RINGED PLANET" },
    { { 0x1FA91 }, 1, "CHAIR" },
    { { 0x1FA92 }, 1, "RAZOR" },
    { { 0x1FA93 }, 1, "AXE" },
    { { 0x1FA94 }, 1, "DIYA LAMP" },
    { { 0x1FA95 }, 1, "BANJO" },
    { { 0x1FA96 }, 1, "MILITARY HELMET" },
    { { 0x1FA97 }, 1, "ACCORDION" },
    { { 0x1FA98 }, 1, "LONG DRUM" },
    { { 0x1FA99 }, 1, "COIN" },
    { { 0x1FA9A }, 1, "CARPENTRY SAW" },
    { { 0x1FA9B }, 1, "SCREWDRIVER" },
    { { 0x1FA9C }, 1, "LADDER" },
    { { 0x1FA9D }, 1, "HOOK" },
    { { 0x1FA9E }, 1, "MIRROR" },
    { { 0x1FA9F }, 1, "WINDOW" },
    { { 0x1FAA0 }, 1, "PLUNGER" },
    { { 0x1FAA1 }, 1, "SEWING NEEDLE" },
    { { 0x1FAA2 }, 1, "KNOT" },
    { { 0x1FAA3 }, 1, "BUCKET" },
    { { 0x1FAA4 }, 1, "MOUSE TRAP" },
    { { 0x1FAA5 }, 1, "TOOTHBRUSH" },
    { { 0x1FAA6 }, 1, "HEADSTONE" },
    { { 0x1FAA7 }, 1, "PLACARD" },
    { { 0x1FAA8 }, 1, "ROCK" },
    { { 0x1FAA9 }, 1, "MIRROR BALL" },
    { { 0x1FAAA }, 1, "IDENTIFICATION CARD" },
    { { 0x1FAAB }, 1, "LOW BATTERY" },
    { { 0x1FAAC }, 1, "HAMSA" },
    { { 0x1FAAD }, 1, "FOLDING HAND FAN" },
    { { 0x1FAAE }, 1, "HAIR PICK" },
    { { 0x1FAAF }, 1, "KHANDA" },
    { { 0x1FAB0 }, 1, "FLY" },
    { { 0x1FAB1 }, 1, "WORM" },
    { { 0x1FAB2 }, 1, "BEETLE" },
    { { 0x1FAB3 }, 1, "COCKROACH" },
    { { 0x1FAB4 }, 1, "POTTED PLANT" },
    { { 0x1FAB5 }, 1, "WOOD" },
    { { 0x1FAB6 }, 1, "FEATHER" },
    { { 0x1FAB7 }, 1, "LOTUS" },
    { { 0x1FAB8 }, 1, "CORAL" },
    { { 0x1FAB9 }, 1, "EMPTY NEST" },
    { { 0x1FABA }, 1, "NEST WITH EGGS" },
    { { 0x1FABB }, 1, "HYACINTH" },
    { { 0x1FABC }, 1, "JELLYFISH" },
    { { 0x1FABD }, 1, "WING" },
    { { 0x1FABE }, 1, "LEAFLESS TREE" },
    { { 0x1FABF }, 1, "GOOSE" },
    { { 0x1FAC0 }, 1, "ANATOMICAL HEART" },
    { { 0x1FAC1 }, 1, "LUNGS" },
    { { 0x1FAC2 }, 1, "PEOPLE HUGGING" },
    { { 0x1FAC3 }, 1, "PREGNANT MAN" },
    { { 0x1FAC3, 0x1F3FB }, 2, "PREGNANT MAN: LIGHT SKIN TONE" },
    { { 0x1FAC3, 0x1F3FC }, 2, "PREGNANT MAN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAC3, 0x1F3FD }, 2, "PREGNANT MAN: MEDIUM SKIN TONE" },
    { { 0x1FAC3, 0x1F3FE }, 2, "PREGNANT MAN: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAC3, 0x1F3FF }, 2, "PREGNANT MAN: DARK SKIN TONE" },
    { { 0x1FAC4 }, 1, "PREGNANT PERSON" },
    { { 0x1FAC4, 0x1F3FB }, 2, "PREGNANT PERSON: LIGHT SKIN TONE" },
    { { 0x1FAC4, 0x1F3FC }, 2, "PREGNANT PERSON: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAC4, 0x1F3FD }, 2, "PREGNANT PERSON: MEDIUM SKIN TONE" },
    { { 0x1FAC4, 0x1F3FE }, 2, "PREGNANT PERSON: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAC4, 0x1F3FF }, 2, "PREGNANT PERSON: DARK SKIN TONE" },
    { { 0x1FAC5 }, 1, "PERSON WITH CROWN" },
    { { 0x1FAC5, 0x1F3FB }, 2, "PERSON WITH CROWN: LIGHT SKIN TONE" },
    { { 0x1FAC5, 0x1F3FC }, 2, "PERSON WITH CROWN: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAC5, 0x1F3FD }, 2, "PERSON WITH CROWN: MEDIUM SKIN TONE" },
    { { 0x1FAC5, 0x1F3FE }, 2, "PERSON WITH CROWN: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAC5, 0x1F3FF }, 2, "PERSON WITH CROWN: DARK SKIN TONE" },
    { { 0x1FAC6 }, 1, "FINGERPRINT" },
    { { 0x1FACE }, 1, "MOOSE" },
    { { 0x1FACF }, 1, "DONKEY" },
    { { 0x1FAD0 }, 1, "BLUEBERRIES" },
    { { 0x1FAD1 }, 1, "BELL PEPPER" },
    { { 0x1FAD2 }, 1, "OLIVE" },
    { { 0x1FAD3 }, 1, "FLATBREAD" },
    { { 0x1FAD4 }, 1, "TAMALE" },
    { { 0x1FAD5 }, 1, "FONDUE" },
    { { 0x1FAD6 }, 1, "TEAPOT" },
    { { 0x1FAD7 }, 1, "POURING LIQUID" },
    { { 0x1FAD8 }, 1, "BEANS" },
    { { 0x1FAD9 }, 1, "JAR" },
    { { 0x1FADA }, 1, "GINGER ROOT" },
    { { 0x1FADB }, 1, "PEA POD" },
    { { 0x1FADC }, 1, "ROOT VEGETABLE" },
    { { 0x1FADF }, 1, "SPLATTER" },
    { { 0x1FAE0 }, 1, "MELTING FACE" },
    { { 0x1FAE1 }, 1, "SALUTING FACE" },
    { { 0x1FAE2 }, 1, "FACE WITH OPEN EYES AND HAND OVER MOUTH" },
    { { 0x1FAE3 }, 1, "FACE WITH PEEKING EYE" },
    { { 0x1FAE4 }, 1, "FACE WITH DIAGONAL MOUTH" },
    { { 0x1FAE5 }, 1, "DOTTED LINE FACE" },
    { { 0x1FAE6 }, 1, "BITING LIP" },
    { { 0x1FAE7 }, 1, "BUBBLES" },
    { { 0x1FAE8 }, 1, "SHAKING FACE" },
    { { 0x1FAE9 }, 1, "FACE WITH BAGS UNDER EYES" },
    { { 0x1FAF0 }, 1, "HAND WITH INDEX FINGER AND THUMB CROSSED" },
    { { 0x1FAF0, 0x1F3FB }, 2, "HAND WITH INDEX FINGER AND THUMB CROSSED: LIGHT SKIN TONE" },
    { { 0x1FAF0, 0x1F3FC }, 2, "HAND WITH INDEX FINGER AND THUMB CROSSED: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF0, 0x1F3FD }, 2, "HAND WITH INDEX FINGER AND THUMB CROSSED: MEDIUM SKIN TONE" },
    { { 0x1FAF0, 0x1F3FE }, 2, "HAND WITH INDEX FINGER AND THUMB CROSSED: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF0, 0x1F3FF }, 2, "HAND WITH INDEX FINGER AND THUMB CROSSED: DARK SKIN TONE" },
    { { 0x1FAF1 }, 1, "RIGHTWARDS HAND" },
    { { 0x1FAF1, 0x1F3FB }, 2, "RIGHTWARDS HAND: LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FC }, 5, "HANDSHAKE: LIGHT SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FD }, 5, "HANDSHAKE: LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FE }, 5, "HANDSHAKE: LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FB, 0x200D, 0x1FAF2, 0x1F3FF }, 5, "HANDSHAKE: LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FC }, 2, "RIGHTWARDS HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FB }, 5, "HANDSHAKE: MEDIUM-LIGHT SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FD }, 5, "HANDSHAKE: MEDIUM-LIGHT SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FE }, 5, "HANDSHAKE: MEDIUM-LIGHT SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FC, 0x200D, 0x1FAF2, 0x1F3FF }, 5, "HANDSHAKE: MEDIUM-LIGHT SKIN TONE, DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FD }, 2, "RIGHTWARDS HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FB }, 5, "HANDSHAKE: MEDIUM SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FC }, 5, "HANDSHAKE: MEDIUM SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FE }, 5, "HANDSHAKE: MEDIUM SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FD, 0x200D, 0x1FAF2, 0x1F3FF }, 5, "HANDSHAKE: MEDIUM SKIN TONE, DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FE }, 2, "RIGHTWARDS HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FB }, 5, "HANDSHAKE: MEDIUM-DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FC }, 5, "HANDSHAKE: MEDIUM-DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FD }, 5, "HANDSHAKE: MEDIUM-DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1FAF1, 0x1F3FE, 0x200D, 0x1FAF2, 0x1F3FF }, 5, "HANDSHAKE: MEDIUM-DARK SKIN TONE, DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FF }, 2, "RIGHTWARDS HAND: DARK SKIN TONE" },
    { { 0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FB }, 5, "HANDSHAKE: DARK SKIN TONE, LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FC }, 5, "HANDSHAKE: DARK SKIN TONE, MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FD }, 5, "HANDSHAKE: DARK SKIN TONE, MEDIUM SKIN TONE" },
    { { 0x1FAF1, 0x1F3FF, 0x200D, 0x1FAF2, 0x1F3FE }, 5, "HANDSHAKE: DARK SKIN TONE, MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF2 }, 1, "LEFTWARDS HAND" },
    { { 0x1FAF2, 0x1F3FB }, 2, "LEFTWARDS HAND: LIGHT SKIN TONE" },
    { { 0x1FAF2, 0x1F3FC }, 2, "LEFTWARDS HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF2, 0x1F3FD }, 2, "LEFTWARDS HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF2, 0x1F3FE }, 2, "LEFTWARDS HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF2, 0x1F3FF }, 2, "LEFTWARDS HAND: DARK SKIN TONE" },
    { { 0x1FAF3 }, 1, "PALM DOWN HAND" },
    { { 0x1FAF3, 0x1F3FB }, 2, "PALM DOWN HAND: LIGHT SKIN TONE" },
    { { 0x1FAF3, 0x1F3FC }, 2, "PALM DOWN HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF3, 0x1F3FD }, 2, "PALM DOWN HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF3, 0x1F3FE }, 2, "PALM DOWN HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF3, 0x1F3FF }, 2, "PALM DOWN HAND: DARK SKIN TONE" },
    { { 0x1FAF4 }, 1, "PALM UP HAND" },
    { { 0x1FAF4, 0x1F3FB }, 2, "PALM UP HAND: LIGHT SKIN TONE" },
    { { 0x1FAF4, 0x1F3FC }, 2, "PALM UP HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF4, 0x1F3FD }, 2, "PALM UP HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF4, 0x1F3FE }, 2, "PALM UP HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF4, 0x1F3FF }, 2, "PALM UP HAND: DARK SKIN TONE" },
    { { 0x1FAF5 }, 1, "INDEX POINTING AT THE VIEWER" },
    { { 0x1FAF5, 0x1F3FB }, 2, "INDEX POINTING AT THE VIEWER: LIGHT SKIN TONE" },
    { { 0x1FAF5, 0x1F3FC }, 2, "INDEX POINTING AT THE VIEWER: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF5, 0x1F3FD }, 2, "INDEX POINTING AT THE VIEWER: MEDIUM SKIN TONE" },
    { { 0x1FAF5, 0x1F3FE }, 2, "INDEX POINTING AT THE VIEWER: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF5, 0x1F3FF }, 2, "INDEX POINTING AT THE VIEWER: DARK SKIN TONE" },
    { { 0x1FAF6 }, 1, "HEART HANDS" },
    { { 0x1FAF6, 0x1F3FB }, 2, "HEART HANDS: LIGHT SKIN TONE" },
    { { 0x1FAF6, 0x1F3FC }, 2, "HEART HANDS: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF6, 0x1F3FD }, 2, "HEART HANDS: MEDIUM SKIN TONE" },
    { { 0x1FAF6, 0x1F3FE }, 2, "HEART HANDS: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF6, 0x1F3FF }, 2, "HEART HANDS: DARK SKIN TONE" },
    { { 0x1FAF7 }, 1, "LEFTWARDS PUSHING HAND" },
    { { 0x1FAF7, 0x1F3FB }, 2, "LEFTWARDS PUSHING HAND: LIGHT SKIN TONE" },
    { { 0x1FAF7, 0x1F3FC }, 2, "LEFTWARDS PUSHING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF7, 0x1F3FD }, 2, "LEFTWARDS PUSHING HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF7, 0x1F3FE }, 2, "LEFTWARDS PUSHING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF7, 0x1F3FF }, 2, "LEFTWARDS PUSHING HAND: DARK SKIN TONE" },
    { { 0x1FAF8 }, 1, "RIGHTWARDS PUSHING HAND" },
    { { 0x1FAF8, 0x1F3FB }, 2, "RIGHTWARDS PUSHING HAND: LIGHT SKIN TONE" },
    { { 0x1FAF8, 0x1F3FC }, 2, "RIGHTWARDS PUSHING HAND: MEDIUM-LIGHT SKIN TONE" },
    { { 0x1FAF8, 0x1F3FD }, 2, "RIGHTWARDS PUSHING HAND: MEDIUM SKIN TONE" },
    { { 0x1FAF8, 0x1F3FE }, 2, "RIGHTWARDS PUSHING HAND: MEDIUM-DARK SKIN TONE" },
    { { 0x1FAF8, 0x1F3FF }, 2, "RIGHTWARDS PUSHING HAND: DARK SKIN TONE" },
  };

#define EMOJI_SMILEYS_CHARACTER_COUNT 169
static const size_t emoji_smileys_characters[169] =
  {
    2199, 2202, 2203, 2200, 2205, 2204, 2683, 2201, 2268, 2271,
    3697, 2208, 2209, 2206, 2909, 2212, 2706, 2223, 2222, 78, 2225,
    2224, 2911, 2210, 2226, 2227, 2707, 2228, 2625, 2631, 2710, 3699,
    3700, 2708, 2628, 3698, 2624, 2705, 2215, 2216, 2255, 3702, 2256,
    2214, 2217, 2272, 2243, 2246, 2685, 3705, 2269, 2270, 2211, 2219,
    2241, 2684, 2252, 3706, 2257, 2626, 2629, 2682, 2711, 2704, 2914,
    2915, 2913, 2253, 2254, 2712, 2680, 2912, 2922, 2213, 2627, 3124,
    2220, 3701, 2230, 2267, 77, 2245, 2247, 2250, 2251, 2924, 2923,
    2237, 2238, 2239, 2248, 2236, 2233, 2244, 2249, 2221, 2234, 2229,
    2218, 2240, 2242, 2910, 2235, 2232, 2231, 2709, 2207, 1800, 1801,
    69, 1930, 2681, 1789, 1790, 1791, 1798, 1799, 2630, 2260, 2258,
    2259, 2261, 2262, 2263, 2266, 2265, 2264, 2327, 2328, 2329, 1891,
    1913, 1918, 1911, 1912, 1908, 1919, 1910, 1920, 204, 1909, 206,
    207, 205, 3594, 3556, 1916, 1915, 1914, 3592, 1917, 2617, 2173,
    3593, 2616, 1890, 1941, 1923, 1926, 1937, 1927, 1929, 2115, 1938,
    956, 2190, 2191, 1939, 1925,
  };

#define EMOJI_PEOPLE_CHARACTER_COUNT 2261
static const size_t emoji_people_characters[2261] =
  {
    1001, 1002, 1003, 1004, 1005, 1006, 2644, 2645, 2646, 2647,
    2648, 2649, 2155, 2156, 2157, 2158, 2159, 2160, 169, 170, 171,
    172, 173, 174, 2167, 2168, 2169, 2170, 2171, 2172, 3713, 3714,
    3719, 3724, 3729, 3734, 3739, 3740, 3741, 3742, 3743, 3744, 3745,
    3746, 3747, 3748, 3749, 3750, 3751, 3752, 3753, 3754, 3755, 3756,
    3769, 3770, 3771, 3772, 3773, 3774, 3775, 3776, 3777, 3778, 3779,
    3780, 1007, 1008, 1009, 1010, 1011, 1012, 2610, 2611, 2612, 2613,
    2614, 2615, 2618, 2619, 2620, 2621, 2622, 2623, 175, 176, 177,
    178, 179, 180, 2668, 2669, 2670, 2671, 2672, 2673, 3707, 3708,
    3709, 3710, 3711, 3712, 2674, 2675, 2676, 2677, 2678, 2679, 2632,
    2633, 2634, 2635, 2636, 2637, 2638, 2639, 2640, 2641, 2642, 2643,
    983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 971,
    972, 973, 974, 975, 976, 2161, 2162, 2163, 2164, 2165, 2166, 977,
    978, 979, 980, 981, 982, 63, 64, 65, 66, 67, 68, 3757, 3758, 3759,
    3760, 3761, 3762, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020,
    1021, 1022, 1023, 1024, 163, 164, 165, 166, 167, 168, 995, 996,
    997, 998, 999, 1000, 2650, 2651, 2652, 2653, 2654, 2655, 2656,
    2657, 2658, 2659, 2660, 2661, 1025, 1026, 1027, 1028, 1029, 1030,
    2348, 2349, 2350, 2351, 2352, 2353, 3763, 3764, 3765, 3766, 3767,
    3768, 1031, 1032, 1033, 1034, 1035, 1036, 2725, 2726, 2727, 2728,
    2729, 2730, 2662, 2663, 2664, 2665, 2666, 2667, 3715, 3716, 3717,
    3718, 3720, 3721, 3722, 3723, 3725, 3726, 3727, 3728, 3730, 3731,
    3732, 3733, 3735, 3736, 3737, 3738, 2390, 2391, 2392, 2393, 2394,
    2395, 181, 182, 183, 184, 185, 186, 1845, 1846, 1847, 1848, 1849,
    1850, 2731, 2732, 2733, 2734, 2735, 2736, 1931, 1932, 1933, 1934,
    1935, 1936, 3037, 3038, 2979, 2980, 2981, 2982, 2983, 2984, 2985,
    2986, 2987, 2988, 2989, 2990, 957, 958, 959, 960, 961, 962, 3029,
    3030, 3031, 3032, 3033, 3034, 963, 964, 965, 966, 967, 968, 3555,
    3659, 3660, 2991, 2978, 954, 955, 970, 969, 3703, 1759, 1760,
    1761, 1762, 1763, 1764, 3369, 3370, 3371, 3372, 3373, 3374, 1058,
    1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069,
    3125, 3159, 3201, 3243, 3285, 3327, 1705, 1708, 1711, 1714, 1717,
    1720, 1070, 1115, 1157, 1199, 1241, 1283, 3381, 3384, 3387, 3390,
    3393, 3396, 3383, 3386, 3389, 3392, 3395, 3398, 3382, 3385, 3388,
    3391, 3394, 3397, 1107, 1149, 1191, 1233, 1275, 1317, 1108, 1150,
    1192, 1234, 1276, 1318, 1110, 1152, 1194, 1236, 1278, 1320, 1109,
    1151, 1193, 1235, 1277, 1319, 1325, 1367, 1423, 1479, 1535, 1591,
    1359, 1415, 1471, 1527, 1583, 1639, 3147, 3193, 3235, 3277, 3319,
    3361, 1360, 1416, 1472, 1528, 1584, 1640, 3148, 3194, 3236, 3278,
    3320, 3362, 1362, 1418, 1474, 1530, 1586, 1642, 3150, 3196, 3238,
    3280, 3322, 3364, 1361, 1417, 1473, 1529, 1585, 1641, 3149, 3195,
    3237, 3279, 3321, 3363, 1706, 1709, 1712, 1715, 1718, 1721, 1707,
    1710, 1713, 1716, 1719, 1722, 3375, 3376, 3377, 3378, 3379, 3380,
    1747, 1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757,
    1758, 2354, 2357, 2360, 2363, 2366, 2369, 2356, 2359, 2362, 2365,
    2368, 2371, 2355, 2358, 2361, 2364, 2367, 2370, 2372, 2375, 2378,
    2381, 2384, 2387, 2374, 2377, 2380, 2383, 2386, 2389, 2373, 2376,
    2379, 2382, 2385, 2388, 2273, 2276, 2279, 2282, 2285, 2288, 2275,
    2278, 2281, 2284, 2287, 2290, 2274, 2277, 2280, 2283, 2286, 2289,
    2291, 2294, 2297, 2300, 2303, 2306, 2293, 2296, 2299, 2302, 2305,
    2308, 2292, 2295, 2298, 2301, 2304, 2307, 1802, 1805, 1808, 1811,
    1814, 1817, 1804, 1807, 1810, 1813, 1816, 1819, 1803, 1806, 1809,
    1812, 1815, 1818, 2330, 2333, 2336, 2339, 2342, 2345, 2332, 2335,
    2338, 2341, 2344, 2347, 2331, 2334, 2337, 2340, 2343, 2346, 3106,
    3109, 3112, 3115, 3118, 3121, 3108, 3111, 3114, 3117, 3120, 3123,
    3107, 3110, 3113, 3116, 3119, 3122, 2309, 2312, 2315, 2318, 2321,
    2324, 2311, 2314, 2317, 2320, 2323, 2326, 2310, 2313, 2316, 2319,
    2322, 2325, 2686, 2689, 2692, 2695, 2698, 2701, 2688, 2691, 2694,
    2697, 2700, 2703, 2687, 2690, 2693, 2696, 2699, 2702, 2767, 2770,
    2773, 2776, 2779, 2782, 2769, 2772, 2775, 2778, 2781, 2784, 2768,
    2771, 2774, 2777, 2780, 2783, 3126, 3160, 3202, 3244, 3286, 3328,
    1071, 1116, 1158, 1200, 1242, 1284, 1326, 1368, 1424, 1480, 1536,
    1592, 3133, 3175, 3217, 3259, 3301, 3343, 1079, 1132, 1174, 1216,
    1258, 1300, 1336, 1394, 1450, 1506, 1562, 1618, 3136, 3178, 3220,
    3262, 3304, 3346, 1082, 1135, 1177, 1219, 1261, 1303, 1339, 1397,
    1453, 1509, 1565, 1621, 3127, 3161, 3203, 3245, 3287, 3329, 1072,
    1117, 1159, 1201, 1243, 1285, 1327, 1369, 1425, 1481, 1537, 1593,
    3129, 3171, 3213, 3255, 3297, 3339, 1076, 1129, 1171, 1213, 1255,
    1297, 1333, 1391, 1447, 1503, 1559, 1615, 3130, 3172, 3214, 3256,
    3298, 3340, 1077, 1130, 1172, 1214, 1256, 1298, 1334, 1392, 1448,
    1504, 1560, 1616, 3140, 3182, 3224, 3266, 3308, 3350, 1101, 1139,
    1181, 1223, 1265, 1307, 1353, 1401, 1457, 1513, 1569, 1625, 3137,
    3179, 3221, 3263, 3305, 3347, 1083, 1136, 1178, 1220, 1262, 1304,
    1340, 1398, 1454, 1510, 1566, 1622, 3139, 3181, 3223, 3265, 3307,
    3349, 1100, 1138, 1180, 1222, 1264, 1306, 1352, 1400, 1456, 1512,
    1568, 1624, 3141, 3183, 3225, 3267, 3309, 3351, 1102, 1140, 1182,
    1224, 1266, 1308, 1354, 1402, 1458, 1514, 1570, 1626, 3138, 3180,
    3222, 3264, 3306, 3348, 1099, 1137, 1179, 1221, 1263, 1305, 1351,
    1399, 1455, 1511, 1567, 1623, 3134, 3176, 3218, 3260, 3302, 3344,
    1080, 1133, 1175, 1217, 1259, 1301, 1337, 1395, 1451, 1507, 1563,
    1619, 3135, 3177, 3219, 3261, 3303, 3345, 1081, 1134, 1176, 1218,
    1260, 1302, 1338, 1396, 1452, 1508, 1564, 1620, 3128, 3162, 3204,
    3246, 3288, 3330, 1073, 1118, 1160, 1202, 1244, 1286, 1328, 1370,
    1426, 1482, 1538, 1594, 3142, 3184, 3226, 3268, 3310, 3352, 1103,
    1141, 1183, 1225, 1267, 1309, 1355, 1403, 1459, 1515, 1571, 1627,
    3143, 3185, 3227, 3269, 3311, 3353, 1104, 1142, 1184, 1226, 1268,
    1310, 1356, 1404, 1460, 1516, 1572, 1628, 1666, 1669, 1672, 1675,
    1678, 1681, 1668, 1671, 1674, 1677, 1680, 1683, 1667, 1670, 1673,
    1676, 1679, 1682, 2122, 2125, 2128, 2131, 2134, 2137, 2124, 2127,
    2130, 2133, 2136, 2139, 2123, 2126, 2129, 2132, 2135, 2138, 1820,
    1823, 1826, 1829, 1832, 1835, 1822, 1825, 1828, 1831, 1834, 1837,
    1821, 1824, 1827, 1830, 1833, 1836, 2916, 2917, 2918, 2919, 2920,
    2921, 1765, 1768, 1771, 1774, 1777, 1780, 1767, 1770, 1773, 1776,
    1779, 1782, 1766, 1769, 1772, 1775, 1778, 1781, 3674, 3675, 3676,
    3677, 3678, 3679, 2737, 2738, 2739, 2740, 2741, 2742, 1783, 1784,
    1785, 1786, 1787, 1788, 1729, 1732, 1735, 1738, 1741, 1744, 1731,
    1734, 1737, 1740, 1743, 1746, 1730, 1733, 1736, 1739, 1742, 1745,
    1723, 1724, 1725, 1726, 1727, 1728, 3399, 3400, 3401, 3402, 3403,
    3404, 2743, 2746, 2749, 2752, 2755, 2758, 2745, 2748, 2751, 2754,
    2757, 2760, 2744, 2747, 2750, 2753, 2756, 2759, 1687, 1690, 1693,
    1696, 1699, 1702, 1689, 1692, 1695, 1698, 1701, 1704, 1688, 1691,
    1694, 1697, 1700, 1703, 2713, 2714, 2715, 2716, 2717, 2718, 3662,
    3663, 3664, 3665, 3666, 3667, 3668, 3669, 3670, 3671, 3672, 3673,
    2719, 2720, 2721, 2722, 2723, 2724, 1335, 1393, 1449, 1505, 1561,
    1617, 1078, 1131, 1173, 1215, 1257, 1299, 3131, 3173, 3215, 3257,
    3299, 3341, 1792, 1793, 1794, 1795, 1796, 1797, 651, 652, 653,
    654, 655, 656, 2761, 2762, 2763, 2764, 2765, 2766, 3132, 3174,
    3216, 3258, 3300, 3342, 2992, 2995, 2998, 3001, 3004, 3007, 2994,
    2997, 3000, 3003, 3006, 3009, 2993, 2996, 2999, 3002, 3005, 3008,
    3010, 3013, 3016, 3019, 3022, 3025, 3012, 3015, 3018, 3021, 3024,
    3027, 3011, 3014, 3017, 3020, 3023, 3026, 3459, 3462, 3465, 3468,
    3471, 3474, 3461, 3464, 3467, 3470, 3473, 3476, 3460, 3463, 3466,
    3469, 3472, 3475, 3477, 3480, 3483, 3486, 3489, 3492, 3479, 3482,
    3485, 3488, 3491, 3494, 3478, 3481, 3484, 3487, 3490, 3493, 3495,
    3498, 3501, 3504, 3507, 3510, 3497, 3500, 3503, 3506, 3509, 3512,
    3496, 3499, 3502, 3505, 3508, 3511, 3513, 3516, 3519, 3522, 3525,
    3528, 3515, 3518, 3521, 3524, 3527, 3530, 3514, 3517, 3520, 3523,
    3526, 3529, 3531, 3534, 3537, 3540, 3543, 3546, 3533, 3536, 3539,
    3542, 3545, 3548, 3532, 3535, 3538, 3541, 3544, 3547, 3549, 3551,
    3550, 3552, 3554, 3553, 3051, 1851, 1854, 1857, 1860, 1863, 1866,
    1853, 1856, 1859, 1862, 1865, 1868, 1852, 1855, 1858, 1861, 1864,
    1867, 1869, 1872, 1875, 1878, 1881, 1884, 1871, 1874, 1877, 1880,
    1883, 1886, 1870, 1873, 1876, 1879, 1882, 1885, 2501, 2507, 2513,
    2519, 2525, 2531, 2504, 2510, 2516, 2522, 2528, 2534, 2502, 2508,
    2514, 2520, 2526, 2532, 2506, 2512, 2518, 2524, 2530, 2536, 2503,
    2509, 2515, 2521, 2527, 2533, 2505, 2511, 2517, 2523, 2529, 2535,
    3052, 3055, 3058, 3061, 3064, 3067, 3054, 3057, 3060, 3063, 3066,
    3069, 3053, 3056, 3059, 3062, 3065, 3068, 3070, 3076, 3082, 3088,
    3094, 3100, 3073, 3079, 3085, 3091, 3097, 3103, 3071, 3077, 3083,
    3089, 3095, 3101, 3075, 3081, 3087, 3093, 3099, 3105, 3072, 3078,
    3084, 3090, 3096, 3102, 3074, 3080, 3086, 3092, 3098, 3104, 3145,
    3191, 3233, 3275, 3317, 3359, 3146, 3192, 3234, 3276, 3318, 3360,
    1105, 1147, 1189, 1231, 1273, 1315, 1106, 1148, 1190, 1232, 1274,
    1316, 1357, 1413, 1469, 1525, 1581, 1637, 1358, 1414, 1470, 1526,
    1582, 1638, 3151, 3197, 3239, 3281, 3323, 3365, 3152, 3198, 3240,
    3282, 3324, 3366, 1111, 1153, 1195, 1237, 1279, 1321, 1112, 1154,
    1196, 1238, 1280, 1322, 1363, 1419, 1475, 1531, 1587, 1643, 1364,
    1420, 1476, 1532, 1588, 1644, 3153, 3199, 3241, 3283, 3325, 3367,
    3154, 3200, 3242, 3284, 3326, 3368, 1113, 1155, 1197, 1239, 1281,
    1323, 1114, 1156, 1198, 1240, 1282, 1324, 1365, 1421, 1477, 1533,
    1589, 1645, 1366, 1422, 1478, 1534, 1590, 1646, 718, 724, 730,
    736, 742, 748, 721, 727, 733, 739, 745, 751, 719, 725, 731, 737,
    743, 749, 723, 729, 735, 741, 747, 753, 720, 726, 732, 738, 744,
    750, 722, 728, 734, 740, 746, 752, 1838, 1839, 1840, 1841, 1842,
    1843, 2144, 2145, 2146, 2147, 2148, 2149, 2116, 2117, 2118, 2119,
    2120, 2121, 1684, 1686, 1685, 3405, 3408, 3411, 3414, 3417, 3420,
    3407, 3410, 3413, 3416, 3419, 3422, 3406, 3409, 3412, 3415, 3418,
    3421, 3423, 3426, 3429, 3432, 3435, 3438, 3425, 3428, 3431, 3434,
    3437, 3440, 3424, 3427, 3430, 3433, 3436, 3439, 2821, 774, 775,
    776, 777, 778, 779, 137, 712, 713, 714, 715, 716, 717, 818, 821,
    824, 827, 830, 833, 820, 823, 826, 829, 832, 835, 819, 822, 825,
    828, 831, 834, 754, 757, 760, 763, 766, 769, 756, 759, 762, 765,
    768, 771, 755, 758, 761, 764, 767, 770, 2431, 2434, 2437, 2440,
    2443, 2446, 2433, 2436, 2439, 2442, 2445, 2448, 2432, 2435, 2438,
    2441, 2444, 2447, 782, 785, 788, 791, 794, 797, 784, 787, 790,
    793, 796, 799, 783, 786, 789, 792, 795, 798, 139, 142, 145, 148,
    151, 154, 141, 144, 147, 150, 153, 156, 140, 143, 146, 149, 152,
    155, 800, 803, 806, 809, 812, 815, 802, 805, 808, 811, 814, 817,
    801, 804, 807, 810, 813, 816, 2465, 2468, 2471, 2474, 2477, 2480,
    2467, 2470, 2473, 2476, 2479, 2482, 2466, 2469, 2472, 2475, 2478,
    2481, 2483, 2486, 2489, 2492, 2495, 2498, 2485, 2488, 2491, 2494,
    2497, 2500, 2484, 2487, 2490, 2493, 2496, 2499, 2785, 2788, 2791,
    2794, 2797, 2800, 2787, 2790, 2793, 2796, 2799, 2802, 2786, 2789,
    2792, 2795, 2798, 2801, 2822, 2824, 2823, 2825, 2828, 2831, 2834,
    2837, 2840, 2827, 2830, 2833, 2836, 2839, 2842, 2826, 2829, 2832,
    2835, 2838, 2841, 2843, 2846, 2849, 2852, 2855, 2858, 2845, 2848,
    2851, 2854, 2857, 2860, 2844, 2847, 2850, 2853, 2856, 2859, 2803,
    2806, 2809, 2812, 2815, 2818, 2805, 2808, 2811, 2814, 2817, 2820,
    2804, 2807, 2810, 2813, 2816, 2819, 3441, 3444, 3447, 3450, 3453,
    3456, 3443, 3446, 3449, 3452, 3455, 3458, 3442, 3445, 3448, 3451,
    3454, 3457, 2546, 2547, 2548, 2549, 2550, 2551, 2558, 2559, 2560,
    2561, 2562, 2563, 3144, 3186, 3187, 3188, 3189, 3190, 3228, 3229,
    3230, 3231, 3232, 3270, 3271, 3272, 3273, 3274, 3312, 3313, 3314,
    3315, 3316, 3354, 3355, 3356, 3357, 3358, 1660, 1661, 1409, 1410,
    1411, 1412, 1465, 1662, 1466, 1467, 1468, 1521, 1522, 1663, 1523,
    1524, 1577, 1578, 1579, 1664, 1580, 1633, 1634, 1635, 1636, 1665,
    1648, 1649, 1405, 1406, 1407, 1408, 1461, 1650, 1462, 1463, 1464,
    1517, 1518, 1651, 1519, 1520, 1573, 1574, 1575, 1652, 1576, 1629,
    1630, 1631, 1632, 1653, 1654, 1655, 1143, 1144, 1145, 1146, 1185,
    1656, 1186, 1187, 1188, 1227, 1228, 1657, 1229, 1230, 1269, 1270,
    1271, 1658, 1272, 1311, 1312, 1313, 1314, 1659, 1894, 1895, 1896,
    1897, 1898, 1899, 3163, 3164, 3165, 3166, 3205, 3206, 3207, 3208,
    3247, 3248, 3249, 3250, 3289, 3290, 3291, 3292, 3331, 3332, 3333,
    3334, 1331, 1381, 1382, 1383, 1384, 1385, 1437, 1438, 1439, 1440,
    1441, 1493, 1494, 1495, 1496, 1497, 1549, 1550, 1551, 1552, 1553,
    1605, 1606, 1607, 1608, 1609, 1075, 1124, 1125, 1126, 1127, 1128,
    1166, 1167, 1168, 1169, 1170, 1208, 1209, 1210, 1211, 1212, 1250,
    1251, 1252, 1253, 1254, 1292, 1293, 1294, 1295, 1296, 1332, 1386,
    1387, 1388, 1389, 1390, 1442, 1443, 1444, 1445, 1446, 1498, 1499,
    1500, 1501, 1502, 1554, 1555, 1556, 1557, 1558, 1610, 1611, 1612,
    1613, 1614, 1901, 1902, 1903, 1904, 1905, 1906, 3167, 3168, 3169,
    3170, 3209, 3210, 3211, 3212, 3251, 3252, 3253, 3254, 3293, 3294,
    3295, 3296, 3335, 3336, 3337, 3338, 1329, 1371, 1372, 1373, 1374,
    1375, 1427, 1428, 1429, 1430, 1431, 1483, 1484, 1485, 1486, 1487,
    1539, 1540, 1541, 1542, 1543, 1595, 1596, 1597, 1598, 1599, 1074,
    1119, 1120, 1121, 1122, 1123, 1161, 1162, 1163, 1164, 1165, 1203,
    1204, 1205, 1206, 1207, 1245, 1246, 1247, 1248, 1249, 1287, 1288,
    1289, 1290, 1291, 1330, 1376, 1377, 1378, 1379, 1380, 1432, 1433,
    1434, 1435, 1436, 1488, 1489, 1490, 1491, 1492, 1544, 1545, 1546,
    1547, 1548, 1600, 1601, 1602, 1603, 1604, 1094, 1096, 1097, 1095,
    1098, 1089, 1091, 1092, 1090, 1093, 1346, 1348, 1349, 1347, 1350,
    1084, 1085, 1086, 1087, 1088, 1341, 1342, 1343, 1344, 1345, 2189,
    1056, 1057, 3661, 1647, 3155, 3156, 3157, 3158, 1055, 3680,
  };

#define EMOJI_ANIMALS_CHARACTER_COUNT 159
static const size_t emoji_animals_characters[159] =
  {
    942, 904, 2943, 2969, 943, 907, 2976, 908, 930, 947, 2940,
    2959, 938, 893, 894, 2931, 936, 890, 891, 941, 3681, 3682, 900,
    2934, 2949, 2942, 2974, 935, 887, 888, 889, 944, 909, 910, 951,
    901, 903, 902, 931, 932, 2955, 2948, 911, 2965, 2945, 2957, 934,
    886, 885, 946, 937, 892, 953, 2973, 2950, 2937, 948, 949, 929,
    950, 2967, 2968, 2970, 2954, 2963, 952, 2933, 906, 905, 922, 923,
    924, 925, 928, 2084, 2935, 2936, 2964, 2939, 2966, 3649, 2971,
    2956, 2958, 3656, 926, 3658, 927, 945, 896, 921, 2944, 899, 939,
    895, 2951, 2952, 940, 897, 933, 2975, 918, 919, 920, 2938, 912,
    913, 3651, 3655, 2930, 2960, 2946, 2947, 2972, 898, 2941, 914,
    915, 916, 3645, 917, 2953, 3646, 2141, 2142, 2932, 2961, 3643,
    3644, 2962, 1900, 572, 1940, 3650, 880, 573, 2862, 574, 575, 576,
    571, 3654, 565, 3647, 566, 567, 568, 569, 578, 579, 62, 580, 581,
    582, 583, 3652, 3653, 584, 3657,
  };

#define EMOJI_FOOD_CHARACTER_COUNT 131
static const size_t emoji_food_characters[131] =
  {
    588, 589, 590, 591, 592, 593, 594, 595, 2906, 596, 597, 598,
    599, 600, 601, 3683, 2890, 586, 3685, 2898, 2878, 587, 2881, 2882,
    577, 570, 3684, 2879, 2905, 2899, 3043, 3044, 2889, 3691, 564,
    3693, 3694, 585, 3695, 612, 2877, 2883, 3686, 2901, 2908, 2891,
    3046, 3039, 604, 605, 2902, 2880, 602, 613, 603, 561, 2903, 562,
    563, 3687, 2886, 3045, 2887, 633, 2885, 632, 3688, 2896, 2884,
    645, 3047, 3041, 2904, 631, 606, 607, 608, 609, 610, 611, 614,
    616, 617, 618, 619, 2907, 615, 2892, 2893, 2894, 620, 621, 622,
    623, 624, 648, 630, 3040, 2900, 625, 626, 627, 628, 629, 642,
    2888, 61, 3689, 635, 636, 644, 637, 638, 639, 640, 641, 2864,
    2865, 3690, 2897, 3050, 3042, 3048, 3049, 2895, 643, 634, 2866,
    2063, 3692, 884,
  };

#define EMOJI_TRAVEL_CHARACTER_COUNT 218
static const size_t emoji_travel_characters[218] =
  {
    531, 532, 533, 534, 2193, 2197, 3568, 843, 131, 529, 2194,
    844, 845, 851, 852, 853, 854, 850, 846, 3572, 3635, 3648, 2571,
    847, 849, 855, 856, 857, 858, 859, 860, 861, 863, 864, 865, 866,
    867, 868, 870, 871, 1907, 2195, 2196, 130, 2086, 2570, 2087, 129,
    2085, 133, 157, 519, 521, 848, 522, 523, 524, 525, 527, 98, 678,
    2574, 679, 680, 1887, 688, 2398, 2399, 2400, 2401, 2402, 2403,
    2404, 2405, 2406, 2425, 2426, 2407, 2408, 2409, 2410, 2412, 2413,
    2414, 2415, 2416, 2417, 2418, 2419, 2420, 2421, 2595, 2422, 2423,
    2424, 837, 836, 2589, 3036, 3035, 2594, 2463, 2588, 2593, 2596,
    2411, 2580, 2581, 2579, 158, 2575, 2453, 2450, 2451, 2568, 2452,
    103, 2576, 136, 2590, 2449, 2587, 135, 2582, 2430, 161, 2583,
    2584, 2585, 3602, 1952, 2397, 2427, 2428, 2429, 2586, 2396, 2592,
    2565, 3574, 27, 40, 26, 37, 38, 39, 2114, 2100, 2112, 2089, 2101,
    2090, 2102, 2091, 2103, 2092, 2104, 2093, 2105, 2094, 2106, 2095,
    2107, 2096, 2108, 2097, 2109, 2098, 2110, 2099, 2111, 535, 536,
    537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 551, 53, 547,
    548, 3611, 221, 549, 550, 530, 54, 121, 122, 552, 553, 554, 555,
    556, 557, 558, 559, 560, 518, 526, 520, 55, 60, 132, 112, 196,
    56, 120, 57, 2058, 1928, 528,
  };

#define EMOJI_ACTIVITIES_CHARACTER_COUNT 85
static const size_t emoji_activities_characters[85] =
  {
    649, 650, 657, 658, 3563, 193, 659, 660, 661, 662, 664, 665,
    666, 667, 668, 3562, 646, 647, 672, 677, 689, 671, 773, 772, 2868,
    2869, 2870, 118, 119, 2875, 710, 839, 780, 781, 708, 2876, 697,
    838, 840, 841, 2874, 842, 882, 2871, 2872, 2867, 134, 138, 681,
    2861, 707, 709, 2591, 2873, 693, 3600, 3601, 2064, 695, 2067,
    3604, 692, 2143, 694, 696, 3564, 3579, 3605, 3636, 3606, 94, 96,
    97, 95, 93, 228, 227, 698, 691, 2178, 686, 3576, 3628, 3577, 3629,
    
  };

#define EMOJI_OBJECTS_CHARACTER_COUNT 264
static const size_t emoji_objects_characters[264] =
  {
    1039, 2140, 2927, 2926, 3028, 1040, 1041, 1042, 3558, 3559,
    3560, 3561, 1043, 1044, 2925, 3588, 3589, 3590, 1045, 1046, 3640,
    1047, 1048, 1049, 2564, 669, 3591, 1050, 1051, 2928, 2929, 1052,
    1053, 3587, 1054, 3641, 1037, 1038, 687, 670, 3557, 3617, 125,
    2020, 1844, 1892, 1893, 2028, 2029, 2030, 2031, 1992, 1993, 2005,
    2041, 2042, 706, 699, 700, 673, 674, 675, 682, 685, 2017, 701,
    3618, 702, 703, 704, 705, 3616, 2863, 3619, 3607, 3608, 3609,
    2007, 2008, 58, 1988, 1989, 1990, 2032, 3638, 2033, 1953, 2174,
    2175, 28, 2176, 2177, 1955, 1956, 1957, 1958, 3569, 683, 676,
    2019, 690, 2016, 2013, 2014, 2015, 2018, 2034, 2035, 2113, 1922,
    2059, 869, 3615, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977,
    1976, 1961, 1986, 1962, 2006, 2187, 1975, 2043, 881, 1942, 3620,
    1946, 1947, 1948, 1949, 1950, 1945, 3585, 1951, 162, 1997, 1998,
    1999, 1994, 1995, 1996, 2001, 2000, 2002, 2003, 2004, 2192, 187,
    188, 2152, 2151, 2153, 2154, 1987, 1954, 1959, 1960, 2179, 1963,
    1964, 2183, 2184, 1965, 1966, 1967, 1968, 1969, 1970, 1971, 1972,
    2150, 1973, 1974, 159, 2180, 2181, 2182, 2039, 2040, 2036, 2037,
    2038, 2186, 2061, 3614, 124, 102, 2577, 2188, 104, 1924, 3603,
    883, 2578, 3621, 2060, 3622, 2062, 108, 2185, 106, 2977, 2044,
    127, 126, 3624, 3571, 3573, 3623, 3610, 107, 3565, 3566, 3567,
    2065, 2066, 1991, 1888, 3595, 1889, 3596, 3599, 3597, 3598, 2455,
    2572, 3625, 3626, 2566, 2557, 3612, 2543, 3627, 2545, 2552, 3631,
    3613, 3575, 3578, 3580, 3581, 3582, 3630, 3583, 3704, 3632, 3584,
    3570, 2569, 2457, 116, 3633, 117, 3586, 3639, 2198, 3634, 3637,
    
  };

#define EMOJI_SYMBOLS_CHARACTER_COUNT 224
static const size_t emoji_symbols_characters[224] =
  {
    862, 2459, 2461, 101, 2539, 2540, 2541, 2542, 2544, 2553,
    2554, 2555, 2556, 111, 2538, 128, 2456, 2464, 2458, 2460, 2462,
    2537, 2011, 2051, 70, 71, 217, 21, 211, 22, 218, 23, 216, 20,
    19, 18, 24, 25, 214, 215, 2024, 2025, 2046, 2047, 2048, 2049,
    2050, 2567, 109, 2083, 192, 76, 75, 191, 72, 73, 74, 2088, 2068,
    3642, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 123, 2021,
    2022, 2023, 47, 30, 34, 36, 48, 31, 35, 2081, 32, 2082, 33, 41,
    42, 43, 29, 684, 2026, 2027, 2012, 2573, 2009, 2010, 79, 80, 113,
    190, 208, 209, 210, 2609, 100, 14, 15, 200, 201, 202, 203, 223,
    1943, 1944, 105, 99, 110, 2070, 1985, 2069, 222, 160, 59, 189,
    198, 199, 212, 213, 224, 194, 195, 197, 12, 13, 16, 3696, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 2052, 2053, 2054, 2055, 2056,
    2057, 229, 233, 230, 234, 235, 236, 17, 237, 44, 238, 239, 231,
    240, 232, 241, 242, 243, 503, 504, 512, 511, 506, 516, 514, 505,
    507, 517, 513, 509, 508, 225, 226, 515, 510, 2073, 2597, 2598,
    2599, 2074, 2600, 2601, 115, 114, 2602, 2604, 2605, 2606, 2603,
    2607, 2608, 219, 220, 50, 49, 52, 51, 45, 46, 2075, 2076, 2077,
    2078, 2079, 2080, 1921, 2045, 2072, 2071,
  };

#define EMOJI_FLAGS_CHARACTER_COUNT 270
static const size_t emoji_flags_characters[270] =
  {
    711, 2454, 663, 875, 872, 874, 873, 876, 244, 245, 246, 247,
    248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
    261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
    274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286,
    287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
    300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312,
    313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325,
    326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338,
    339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351,
    352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364,
    365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377,
    378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390,
    391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403,
    404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416,
    417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429,
    430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442,
    443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455,
    456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
    469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481,
    482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494,
    495, 496, 497, 498, 499, 500, 501, 502, 877, 878, 879,
  };

#define EMOJI_SINGULAR_CHARACTER_COUNT 1177
static const size_t emoji_singular_characters[1177] =
  {
    26, 27, 30, 31, 32, 33, 37, 40, 51, 52, 60, 61, 81, 82, 83,
    84, 85, 86, 87, 88, 89, 90, 91, 92, 101, 103, 112, 114, 115, 118,
    119, 120, 121, 123, 128, 130, 133, 134, 136, 157, 158, 160, 163,
    169, 193, 198, 199, 200, 201, 202, 203, 208, 209, 210, 212, 213,
    219, 220, 221, 222, 227, 228, 233, 234, 235, 236, 237, 238, 239,
    240, 241, 242, 243, 503, 505, 506, 507, 508, 509, 510, 511, 513,
    514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526,
    527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539,
    540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 561, 562,
    563, 564, 565, 566, 567, 568, 569, 571, 572, 573, 574, 575, 576,
    577, 578, 579, 580, 581, 582, 583, 584, 586, 587, 588, 589, 590,
    591, 592, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604,
    605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617,
    618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630,
    631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 641, 642, 644,
    645, 646, 647, 648, 649, 650, 651, 657, 658, 659, 660, 661, 662,
    663, 664, 665, 666, 667, 668, 669, 670, 678, 679, 680, 681, 682,
    683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695,
    696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708,
    709, 710, 711, 712, 718, 754, 772, 773, 774, 780, 781, 782, 838,
    839, 840, 841, 842, 855, 856, 857, 858, 859, 860, 861, 862, 863,
    864, 865, 866, 867, 868, 869, 870, 871, 875, 882, 883, 884, 885,
    886, 887, 888, 889, 890, 891, 892, 893, 895, 896, 897, 898, 899,
    900, 901, 902, 903, 904, 905, 906, 907, 909, 910, 911, 912, 913,
    914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 928,
    929, 930, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941,
    942, 943, 944, 945, 946, 947, 948, 950, 951, 952, 954, 957, 963,
    969, 970, 971, 977, 983, 989, 995, 1001, 1007, 1013, 1019, 1025,
    1031, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046,
    1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057,
    1058, 1064, 1070, 1325, 1647, 1648, 1654, 1660, 1666, 1684, 1687,
    1705, 1723, 1729, 1747, 1753, 1759, 1765, 1783, 1789, 1790, 1791,
    1792, 1798, 1799, 1800, 1801, 1802, 1820, 1838, 1844, 1845, 1851,
    1869, 1887, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1900, 1901,
    1907, 1908, 1909, 1910, 1911, 1912, 1913, 1914, 1915, 1916, 1917,
    1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928,
    1929, 1930, 1931, 1937, 1938, 1939, 1940, 1941, 1942, 1943, 1944,
    1945, 1946, 1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955,
    1956, 1957, 1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 1966,
    1967, 1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977,
    1978, 1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988,
    1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
    2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010,
    2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2020, 2021, 2022,
    2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 2033,
    2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043, 2044,
    2045, 2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055,
    2056, 2057, 2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066,
    2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077,
    2078, 2079, 2080, 2081, 2082, 2085, 2086, 2087, 2088, 2089, 2090,
    2091, 2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100, 2101,
    2102, 2103, 2104, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112,
    2144, 2161, 2167, 2173, 2194, 2195, 2196, 2197, 2198, 2199, 2200,
    2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 2209, 2210, 2211,
    2212, 2213, 2214, 2215, 2216, 2217, 2218, 2219, 2220, 2221, 2222,
    2223, 2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232, 2233,
    2234, 2235, 2236, 2237, 2238, 2239, 2240, 2241, 2242, 2243, 2244,
    2245, 2247, 2248, 2249, 2250, 2251, 2252, 2253, 2255, 2257, 2258,
    2259, 2260, 2261, 2262, 2263, 2264, 2265, 2266, 2267, 2268, 2271,
    2272, 2273, 2291, 2309, 2327, 2328, 2329, 2330, 2348, 2354, 2372,
    2390, 2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405,
    2406, 2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416,
    2417, 2418, 2419, 2420, 2421, 2422, 2423, 2424, 2425, 2426, 2427,
    2428, 2429, 2430, 2431, 2449, 2450, 2451, 2452, 2453, 2454, 2455,
    2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2483,
    2501, 2537, 2538, 2539, 2540, 2541, 2542, 2543, 2544, 2545, 2546,
    2552, 2553, 2554, 2555, 2556, 2558, 2567, 2568, 2569, 2570, 2571,
    2572, 2573, 2574, 2575, 2576, 2584, 2585, 2588, 2589, 2590, 2591,
    2592, 2593, 2594, 2595, 2596, 2597, 2598, 2599, 2600, 2601, 2602,
    2603, 2604, 2605, 2606, 2607, 2608, 2609, 2610, 2616, 2617, 2618,
    2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631, 2632, 2638, 2644,
    2650, 2656, 2662, 2668, 2674, 2680, 2681, 2682, 2683, 2684, 2685,
    2686, 2704, 2705, 2706, 2707, 2708, 2709, 2710, 2711, 2712, 2713,
    2719, 2725, 2731, 2737, 2743, 2761, 2767, 2785, 2803, 2821, 2822,
    2825, 2843, 2861, 2862, 2863, 2864, 2865, 2866, 2867, 2868, 2869,
    2870, 2871, 2872, 2873, 2874, 2875, 2876, 2877, 2878, 2879, 2880,
    2881, 2882, 2883, 2884, 2885, 2886, 2887, 2888, 2889, 2890, 2891,
    2892, 2893, 2894, 2895, 2896, 2897, 2898, 2899, 2900, 2901, 2902,
    2903, 2904, 2905, 2906, 2907, 2908, 2909, 2910, 2911, 2912, 2913,
    2914, 2915, 2916, 2922, 2923, 2924, 2925, 2926, 2927, 2928, 2929,
    2930, 2931, 2932, 2933, 2934, 2935, 2936, 2937, 2938, 2939, 2940,
    2941, 2942, 2943, 2944, 2945, 2946, 2947, 2948, 2949, 2950, 2951,
    2952, 2953, 2954, 2955, 2956, 2957, 2958, 2959, 2960, 2961, 2962,
    2963, 2964, 2965, 2966, 2967, 2968, 2969, 2970, 2971, 2972, 2973,
    2974, 2975, 2976, 2977, 2978, 2979, 2985, 2991, 2992, 3010, 3028,
    3029, 3035, 3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043, 3044,
    3045, 3046, 3047, 3048, 3049, 3050, 3051, 3052, 3070, 3106, 3124,
    3125, 3369, 3375, 3381, 3399, 3405, 3423, 3441, 3459, 3477, 3495,
    3513, 3531, 3549, 3552, 3555, 3556, 3557, 3558, 3559, 3560, 3561,
    3562, 3563, 3564, 3565, 3566, 3567, 3568, 3569, 3570, 3571, 3572,
    3573, 3574, 3575, 3576, 3577, 3578, 3579, 3580, 3581, 3582, 3583,
    3584, 3585, 3586, 3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594,
    3595, 3596, 3597, 3598, 3599, 3600, 3601, 3602, 3603, 3604, 3605,
    3606, 3607, 3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615, 3616,
    3617, 3618, 3619, 3620, 3621, 3622, 3623, 3624, 3625, 3626, 3627,
    3628, 3629, 3630, 3631, 3632, 3633, 3634, 3635, 3636, 3637, 3638,
    3639, 3640, 3641, 3642, 3643, 3644, 3645, 3646, 3647, 3648, 3649,
    3650, 3651, 3652, 3653, 3654, 3655, 3656, 3657, 3658, 3659, 3660,
    3661, 3662, 3668, 3674, 3680, 3681, 3682, 3683, 3684, 3685, 3686,
    3687, 3688, 3689, 3690, 3691, 3692, 3693, 3694, 3695, 3696, 3697,
    3698, 3699, 3700, 3701, 3702, 3703, 3704, 3705, 3706, 3707, 3713,
    3739, 3745, 3751, 3757, 3763, 3769, 3775,
  };

