// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/asset/v1p7beta1/asset_service.proto

package asset

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	_ "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The Cloud Organization Policy set on an asset.
	ContentType_ORG_POLICY ContentType = 4
	// The Cloud Access context manager Policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
	// The related resources.
	ContentType_RELATIONSHIP ContentType = 7
)

// Enum value maps for ContentType.
var (
	ContentType_name = map[int32]string{
		0: "CONTENT_TYPE_UNSPECIFIED",
		1: "RESOURCE",
		2: "IAM_POLICY",
		4: "ORG_POLICY",
		5: "ACCESS_POLICY",
		7: "RELATIONSHIP",
	}
	ContentType_value = map[string]int32{
		"CONTENT_TYPE_UNSPECIFIED": 0,
		"RESOURCE":                 1,
		"IAM_POLICY":               2,
		"ORG_POLICY":               4,
		"ACCESS_POLICY":            5,
		"RELATIONSHIP":             7,
	}
)

func (x ContentType) Enum() *ContentType {
	p := new(ContentType)
	*p = x
	return p
}

func (x ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes[0].Descriptor()
}

func (ContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes[0]
}

func (x ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentType.Descriptor instead.
func (ContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{0}
}

// This enum is used to determine the partition key column when exporting
// assets to BigQuery partitioned table(s). Note that, if the partition key is
// a timestamp column, the actual partition is based on its date value
// (expressed in UTC. see details in
// https://cloud.google.com/bigquery/docs/partitioned-tables#date_timestamp_partitioned_tables).
type PartitionSpec_PartitionKey int32

const (
	// Unspecified partition key. If used, it means using non-partitioned table.
	PartitionSpec_PARTITION_KEY_UNSPECIFIED PartitionSpec_PartitionKey = 0
	// The time when the snapshot is taken. If specified as partition key, the
	// result table(s) is partitoned by the additional timestamp column,
	// readTime. If [read_time] in ExportAssetsRequest is specified, the
	// readTime column's value will be the same as it. Otherwise, its value will
	// be the current time that is used to take the snapshot.
	PartitionSpec_READ_TIME PartitionSpec_PartitionKey = 1
	// The time when the request is received and started to be processed. If
	// specified as partition key, the result table(s) is partitoned by the
	// requestTime column, an additional timestamp column representing when the
	// request was received.
	PartitionSpec_REQUEST_TIME PartitionSpec_PartitionKey = 2
)

// Enum value maps for PartitionSpec_PartitionKey.
var (
	PartitionSpec_PartitionKey_name = map[int32]string{
		0: "PARTITION_KEY_UNSPECIFIED",
		1: "READ_TIME",
		2: "REQUEST_TIME",
	}
	PartitionSpec_PartitionKey_value = map[string]int32{
		"PARTITION_KEY_UNSPECIFIED": 0,
		"READ_TIME":                 1,
		"REQUEST_TIME":              2,
	}
)

func (x PartitionSpec_PartitionKey) Enum() *PartitionSpec_PartitionKey {
	p := new(PartitionSpec_PartitionKey)
	*p = x
	return p
}

func (x PartitionSpec_PartitionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartitionSpec_PartitionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes[1].Descriptor()
}

func (PartitionSpec_PartitionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes[1]
}

func (x PartitionSpec_PartitionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartitionSpec_PartitionKey.Descriptor instead.
func (PartitionSpec_PartitionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{7, 0}
}

// Export asset request.
type ExportAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types to take a snapshot for. For example:
	// "compute.googleapis.com/Disk".
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	//
	// If specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1p7beta1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to.
	OutputConfig *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A list of relationship types to export, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP. If specified, it will snapshot [asset_types]'
	// specified relationships, or give errors if any relationship_types'
	// supported types are not in [asset_types]. If not specified, it will
	// snapshot all [asset_types]' supported relationships. An unspecified
	// [asset_types] field means all supported asset_types. See [Introduction to
	// Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,6,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *ExportAssetsRequest) Reset() {
	*x = ExportAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsRequest) ProtoMessage() {}

func (x *ExportAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsRequest.ProtoReflect.Descriptor instead.
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{0}
}

func (x *ExportAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ExportAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation]
// method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field.
type ExportAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Output result indicating where the assets were exported to. For example, a
	// set of actual Google Cloud Storage object uris where the assets are
	// exported to. The uris can be different from what [output_config] has
	// specified, as the service will split the output object into multiple ones
	// once it exceeds a single Google Cloud Storage object limit.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportAssetsResponse) Reset() {
	*x = ExportAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsResponse) ProtoMessage() {}

func (x *ExportAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsResponse.ProtoReflect.Descriptor instead.
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{1}
}

func (x *ExportAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// Output configuration for export assets destination.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export destination.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{2}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Destination on Cloud Storage.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// Destination on BigQuery. The output table stores the fields in asset
	// proto as columns in BigQuery.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// Output result of export assets.
type OutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export result.
	//
	// Types that are assignable to Result:
	//	*OutputResult_GcsResult
	Result isOutputResult_Result `protobuf_oneof:"result"`
}

func (x *OutputResult) Reset() {
	*x = OutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputResult) ProtoMessage() {}

func (x *OutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputResult.ProtoReflect.Descriptor instead.
func (*OutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{3}
}

func (m *OutputResult) GetResult() isOutputResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *OutputResult) GetGcsResult() *GcsOutputResult {
	if x, ok := x.GetResult().(*OutputResult_GcsResult); ok {
		return x.GcsResult
	}
	return nil
}

type isOutputResult_Result interface {
	isOutputResult_Result()
}

type OutputResult_GcsResult struct {
	// Export result on Cloud Storage.
	GcsResult *GcsOutputResult `protobuf:"bytes,1,opt,name=gcs_result,json=gcsResult,proto3,oneof"`
}

func (*OutputResult_GcsResult) isOutputResult_Result() {}

// A Cloud Storage output result.
type GcsOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of uris of the Cloud Storage objects. Example:
	// "gs://bucket_name/object_name".
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *GcsOutputResult) Reset() {
	*x = GcsOutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputResult) ProtoMessage() {}

func (x *GcsOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputResult.ProtoReflect.Descriptor instead.
func (*GcsOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{4}
}

func (x *GcsOutputResult) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// A Cloud Storage location.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to ObjectUri:
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{5}
}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (x *GcsDestination) GetUri() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *GcsDestination) GetUriPrefix() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	// The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	// The uri prefix of all generated Cloud Storage objects. Example:
	// "gs://bucket_name/object_name_prefix". Each object uri is in format:
	// "gs://bucket_name/object_name_prefix/{ASSET_TYPE}/{SHARD_NUMBER} and only
	// contains assets for that type. <shard number> starts from 0. Example:
	// "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
	// the first shard of output objects containing all
	// compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
	// returned if file with the same name "gs://bucket_name/object_name_prefix"
	// already exists.
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

// A BigQuery destination for exporting assets to.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is `FALSE` or unset and the destination table already exists, the export
	// call returns an INVALID_ARGUMEMT error.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// [partition_spec] determines whether to export to partitioned table(s) and
	// how to partition the data.
	//
	// If [partition_spec] is unset or [partition_spec.partition_key] is unset or
	// `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
	// non-partitioned table(s). [force] will decide whether to overwrite existing
	// table(s).
	//
	// If [partition_spec] is specified. First, the snapshot results will be
	// written to partitioned table(s) with two additional timestamp columns,
	// readTime and requestTime, one of which will be the partition key. Secondly,
	// in the case when any destination table already exists, it will first try to
	// update existing table's schema as necessary by appending additional
	// columns. Then, if [force] is `TRUE`, the corresponding partition will be
	// overwritten by the snapshot results (data in different partitions will
	// remain intact); if [force] is unset or `FALSE`, it will append the data. An
	// error will be returned if the schema update or data appension fails.
	PartitionSpec *PartitionSpec `protobuf:"bytes,4,opt,name=partition_spec,json=partitionSpec,proto3" json:"partition_spec,omitempty"`
	// If this flag is `TRUE`, the snapshot results will be written to one or
	// multiple tables, each of which contains results of one asset type. The
	// [force] and [partition_spec] fields will apply to each of them.
	//
	// Field [table] will be concatenated with "_" and the asset type names (see
	// https://cloud.google.com/asset-inventory/docs/supported-asset-types for
	// supported asset types) to construct per-asset-type table names, in which
	// all non-alphanumeric characters like "." and "/" will be substituted by
	// "_". Example: if field [table] is "mytable" and snapshot results
	// contain "storage.googleapis.com/Bucket" assets, the corresponding table
	// name will be "mytable_storage_googleapis_com_Bucket". If any of these
	// tables does not exist, a new table with the concatenated name will be
	// created.
	//
	// When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema of
	// each table will include RECORD-type columns mapped to the nested fields in
	// the Asset.resource.data field of that asset type (up to the 15 nested level
	// BigQuery supports
	// (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)). The
	// fields in >15 nested levels will be stored in JSON format string as a child
	// column of its parent RECORD column.
	//
	// If error occurs when exporting to any table, the whole export call will
	// return an error but the export results that already succeed will persist.
	// Example: if exporting to table_type_A succeeds when exporting to
	// table_type_B fails during one export call, the results in table_type_A will
	// persist and there will not be partial results persisting in a table.
	SeparateTablesPerAssetType bool `protobuf:"varint,5,opt,name=separate_tables_per_asset_type,json=separateTablesPerAssetType,proto3" json:"separate_tables_per_asset_type,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{6}
}

func (x *BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryDestination) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *BigQueryDestination) GetPartitionSpec() *PartitionSpec {
	if x != nil {
		return x.PartitionSpec
	}
	return nil
}

func (x *BigQueryDestination) GetSeparateTablesPerAssetType() bool {
	if x != nil {
		return x.SeparateTablesPerAssetType
	}
	return false
}

// Specifications of BigQuery partitioned table as export destination.
type PartitionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition key for BigQuery partitioned table.
	PartitionKey PartitionSpec_PartitionKey `protobuf:"varint,1,opt,name=partition_key,json=partitionKey,proto3,enum=google.cloud.asset.v1p7beta1.PartitionSpec_PartitionKey" json:"partition_key,omitempty"`
}

func (x *PartitionSpec) Reset() {
	*x = PartitionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionSpec) ProtoMessage() {}

func (x *PartitionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionSpec.ProtoReflect.Descriptor instead.
func (*PartitionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP(), []int{7}
}

func (x *PartitionSpec) GetPartitionKey() PartitionSpec_PartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return PartitionSpec_PARTITION_KEY_UNSPECIFIED
}

var File_google_cloud_asset_v1p7beta1_asset_service_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x83, 0x03, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xf1, 0x01, 0x0a, 0x14, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0xde, 0x01,
	0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x57,
	0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68,
	0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4e,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x25, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x22,
	0x53, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75, 0x72, 0x69,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x22, 0xfd, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x52, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x42, 0x0a, 0x1e, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x50, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x4e, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x02, 0x2a, 0x7e, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x01,
	0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10, 0x04,
	0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53,
	0x48, 0x49, 0x50, 0x10, 0x07, 0x32, 0xda, 0x02, 0x0a, 0x0c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xfa, 0x01, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x29, 0x22, 0x24, 0x2f, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x65, 0x0a, 0x31,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xb8, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x11, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f,
	0x76, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xaa,
	0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0x50, 0x37, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x70, 0x37, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescData = file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDesc
)

func file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescData)
	})
	return file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDescData
}

var file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_asset_v1p7beta1_asset_service_proto_goTypes = []interface{}{
	(ContentType)(0),                // 0: google.cloud.asset.v1p7beta1.ContentType
	(PartitionSpec_PartitionKey)(0), // 1: google.cloud.asset.v1p7beta1.PartitionSpec.PartitionKey
	(*ExportAssetsRequest)(nil),     // 2: google.cloud.asset.v1p7beta1.ExportAssetsRequest
	(*ExportAssetsResponse)(nil),    // 3: google.cloud.asset.v1p7beta1.ExportAssetsResponse
	(*OutputConfig)(nil),            // 4: google.cloud.asset.v1p7beta1.OutputConfig
	(*OutputResult)(nil),            // 5: google.cloud.asset.v1p7beta1.OutputResult
	(*GcsOutputResult)(nil),         // 6: google.cloud.asset.v1p7beta1.GcsOutputResult
	(*GcsDestination)(nil),          // 7: google.cloud.asset.v1p7beta1.GcsDestination
	(*BigQueryDestination)(nil),     // 8: google.cloud.asset.v1p7beta1.BigQueryDestination
	(*PartitionSpec)(nil),           // 9: google.cloud.asset.v1p7beta1.PartitionSpec
	(*timestamppb.Timestamp)(nil),   // 10: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),   // 11: google.longrunning.Operation
}
var file_google_cloud_asset_v1p7beta1_asset_service_proto_depIdxs = []int32{
	10, // 0: google.cloud.asset.v1p7beta1.ExportAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,  // 1: google.cloud.asset.v1p7beta1.ExportAssetsRequest.content_type:type_name -> google.cloud.asset.v1p7beta1.ContentType
	4,  // 2: google.cloud.asset.v1p7beta1.ExportAssetsRequest.output_config:type_name -> google.cloud.asset.v1p7beta1.OutputConfig
	10, // 3: google.cloud.asset.v1p7beta1.ExportAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	4,  // 4: google.cloud.asset.v1p7beta1.ExportAssetsResponse.output_config:type_name -> google.cloud.asset.v1p7beta1.OutputConfig
	5,  // 5: google.cloud.asset.v1p7beta1.ExportAssetsResponse.output_result:type_name -> google.cloud.asset.v1p7beta1.OutputResult
	7,  // 6: google.cloud.asset.v1p7beta1.OutputConfig.gcs_destination:type_name -> google.cloud.asset.v1p7beta1.GcsDestination
	8,  // 7: google.cloud.asset.v1p7beta1.OutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1p7beta1.BigQueryDestination
	6,  // 8: google.cloud.asset.v1p7beta1.OutputResult.gcs_result:type_name -> google.cloud.asset.v1p7beta1.GcsOutputResult
	9,  // 9: google.cloud.asset.v1p7beta1.BigQueryDestination.partition_spec:type_name -> google.cloud.asset.v1p7beta1.PartitionSpec
	1,  // 10: google.cloud.asset.v1p7beta1.PartitionSpec.partition_key:type_name -> google.cloud.asset.v1p7beta1.PartitionSpec.PartitionKey
	2,  // 11: google.cloud.asset.v1p7beta1.AssetService.ExportAssets:input_type -> google.cloud.asset.v1p7beta1.ExportAssetsRequest
	11, // 12: google.cloud.asset.v1p7beta1.AssetService.ExportAssets:output_type -> google.longrunning.Operation
	12, // [12:13] is the sub-list for method output_type
	11, // [11:12] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1p7beta1_asset_service_proto_init() }
func file_google_cloud_asset_v1p7beta1_asset_service_proto_init() {
	if File_google_cloud_asset_v1p7beta1_asset_service_proto != nil {
		return
	}
	file_google_cloud_asset_v1p7beta1_assets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsOutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*OutputResult_GcsResult)(nil),
	}
	file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_asset_v1p7beta1_asset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1p7beta1_asset_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1p7beta1_asset_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1p7beta1_asset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1p7beta1_asset_service_proto = out.File
	file_google_cloud_asset_v1p7beta1_asset_service_proto_rawDesc = nil
	file_google_cloud_asset_v1p7beta1_asset_service_proto_goTypes = nil
	file_google_cloud_asset_v1p7beta1_asset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1p7beta1.Asset][google.cloud.asset.v1p7beta1.Asset] in
	// the JSON format; for BigQuery table destinations, the output table stores
	// the fields in asset proto as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API , which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p7beta1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1p7beta1.Asset][google.cloud.asset.v1p7beta1.Asset] in
	// the JSON format; for BigQuery table destinations, the output table stores
	// the fields in asset proto as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API , which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p7beta1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p7beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p7beta1/asset_service.proto",
}
