// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/discoveryengine/v1alpha/search_tuning_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [SearchTuningService.TrainCustomModel][google.cloud.discoveryengine.v1alpha.SearchTuningService.TrainCustomModel]
// method.
type TrainCustomModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Model training input.
	//
	// Types that are assignable to TrainingInput:
	//
	//	*TrainCustomModelRequest_GcsTrainingInput_
	TrainingInput isTrainCustomModelRequest_TrainingInput `protobuf_oneof:"training_input"`
	// Required. The resource name of the Data Store, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.
	// This field is used to identify the data store where to train the models.
	DataStore string `protobuf:"bytes,1,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
	// Model to be trained. Supported values are:
	//
	//   - **search-tuning**: Fine tuning the search system based on data provided.
	ModelType string `protobuf:"bytes,3,opt,name=model_type,json=modelType,proto3" json:"model_type,omitempty"`
	// The desired location of errors incurred during the data ingestion and
	// training.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,4,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
}

func (x *TrainCustomModelRequest) Reset() {
	*x = TrainCustomModelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainCustomModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainCustomModelRequest) ProtoMessage() {}

func (x *TrainCustomModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainCustomModelRequest.ProtoReflect.Descriptor instead.
func (*TrainCustomModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescGZIP(), []int{0}
}

func (m *TrainCustomModelRequest) GetTrainingInput() isTrainCustomModelRequest_TrainingInput {
	if m != nil {
		return m.TrainingInput
	}
	return nil
}

func (x *TrainCustomModelRequest) GetGcsTrainingInput() *TrainCustomModelRequest_GcsTrainingInput {
	if x, ok := x.GetTrainingInput().(*TrainCustomModelRequest_GcsTrainingInput_); ok {
		return x.GcsTrainingInput
	}
	return nil
}

func (x *TrainCustomModelRequest) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

func (x *TrainCustomModelRequest) GetModelType() string {
	if x != nil {
		return x.ModelType
	}
	return ""
}

func (x *TrainCustomModelRequest) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

type isTrainCustomModelRequest_TrainingInput interface {
	isTrainCustomModelRequest_TrainingInput()
}

type TrainCustomModelRequest_GcsTrainingInput_ struct {
	// Cloud Storage training input.
	GcsTrainingInput *TrainCustomModelRequest_GcsTrainingInput `protobuf:"bytes,2,opt,name=gcs_training_input,json=gcsTrainingInput,proto3,oneof"`
}

func (*TrainCustomModelRequest_GcsTrainingInput_) isTrainCustomModelRequest_TrainingInput() {}

// Response of the
// [TrainCustomModelRequest][google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest].
// This message is returned by the google.longrunning.Operations.response field.
type TrainCustomModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the data.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors in the request if set.
	ErrorConfig *ImportErrorConfig `protobuf:"bytes,2,opt,name=error_config,json=errorConfig,proto3" json:"error_config,omitempty"`
	// The trained model status. Possible values are:
	//
	//   - **bad-data**: The training data quality is bad.
	//   - **no-improvement**: Tuning didn't improve performance. Won't deploy.
	//   - **in-progress**: Model training is in progress.
	//   - **ready**: The model is ready for serving.
	ModelStatus string `protobuf:"bytes,3,opt,name=model_status,json=modelStatus,proto3" json:"model_status,omitempty"`
}

func (x *TrainCustomModelResponse) Reset() {
	*x = TrainCustomModelResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainCustomModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainCustomModelResponse) ProtoMessage() {}

func (x *TrainCustomModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainCustomModelResponse.ProtoReflect.Descriptor instead.
func (*TrainCustomModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescGZIP(), []int{1}
}

func (x *TrainCustomModelResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *TrainCustomModelResponse) GetErrorConfig() *ImportErrorConfig {
	if x != nil {
		return x.ErrorConfig
	}
	return nil
}

func (x *TrainCustomModelResponse) GetModelStatus() string {
	if x != nil {
		return x.ModelStatus
	}
	return ""
}

// Metadata related to the progress of the TrainCustomModel operation. This is
// returned by the google.longrunning.Operation.metadata field.
type TrainCustomModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *TrainCustomModelMetadata) Reset() {
	*x = TrainCustomModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainCustomModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainCustomModelMetadata) ProtoMessage() {}

func (x *TrainCustomModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainCustomModelMetadata.ProtoReflect.Descriptor instead.
func (*TrainCustomModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescGZIP(), []int{2}
}

func (x *TrainCustomModelMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TrainCustomModelMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Cloud Storage training data input.
type TrainCustomModelRequest_GcsTrainingInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud Storage corpus data which could be associated in train data.
	// The data path format is `gs://<bucket_to_data>/<jsonl_file_name>`.
	// A newline delimited jsonl/ndjson file.
	//
	// For search-tuning model, each line should have the _id, title
	// and text. Example: {"_id": "doc1", title: "relevant doc", "text":
	// "relevant text"}
	CorpusDataPath string `protobuf:"bytes,1,opt,name=corpus_data_path,json=corpusDataPath,proto3" json:"corpus_data_path,omitempty"`
	// The gcs query data which could be associated in train data.
	// The data path format is `gs://<bucket_to_data>/<jsonl_file_name>`.
	// A newline delimited jsonl/ndjson file.
	//
	// For search-tuning model, each line should have the _id
	// and text. Example: {"_id": "query1",  "text": "example query"}
	QueryDataPath string `protobuf:"bytes,2,opt,name=query_data_path,json=queryDataPath,proto3" json:"query_data_path,omitempty"`
	// Cloud Storage training data path whose format should be
	// `gs://<bucket_to_data>/<tsv_file_name>`. The file should be in tsv
	// format. Each line should have the doc_id and query_id and score (number).
	//
	// For search-tuning model, it should have the query-id corpus-id
	// score as tsv file header. The score should be a number in `[0, inf+)`.
	// The larger the number is, the more relevant the pair is. Example:
	//
	// * `query-id\tcorpus-id\tscore`
	// * `query1\tdoc1\t1`
	TrainDataPath string `protobuf:"bytes,3,opt,name=train_data_path,json=trainDataPath,proto3" json:"train_data_path,omitempty"`
	// Cloud Storage test data. Same format as train_data_path. If not provided,
	// a random 80/20 train/test split will be performed on train_data_path.
	TestDataPath string `protobuf:"bytes,4,opt,name=test_data_path,json=testDataPath,proto3" json:"test_data_path,omitempty"`
}

func (x *TrainCustomModelRequest_GcsTrainingInput) Reset() {
	*x = TrainCustomModelRequest_GcsTrainingInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrainCustomModelRequest_GcsTrainingInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrainCustomModelRequest_GcsTrainingInput) ProtoMessage() {}

func (x *TrainCustomModelRequest_GcsTrainingInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrainCustomModelRequest_GcsTrainingInput.ProtoReflect.Descriptor instead.
func (*TrainCustomModelRequest_GcsTrainingInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TrainCustomModelRequest_GcsTrainingInput) GetCorpusDataPath() string {
	if x != nil {
		return x.CorpusDataPath
	}
	return ""
}

func (x *TrainCustomModelRequest_GcsTrainingInput) GetQueryDataPath() string {
	if x != nil {
		return x.QueryDataPath
	}
	return ""
}

func (x *TrainCustomModelRequest_GcsTrainingInput) GetTrainDataPath() string {
	if x != nil {
		return x.TrainDataPath
	}
	return ""
}

func (x *TrainCustomModelRequest_GcsTrainingInput) GetTestDataPath() string {
	if x != nil {
		return x.TestDataPath
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x04, 0x0a, 0x17, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x7e, 0x0a, 0x12, 0x67, 0x63, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x47, 0x63, 0x73, 0x54,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x10,
	0x67, 0x63, 0x73, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x4f, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xb2, 0x01, 0x0a,
	0x10, 0x47, 0x63, 0x73, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x74, 0x68, 0x12, 0x26, 0x0a, 0x0f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x26, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x74, 0x68, 0x12, 0x24, 0x0a, 0x0e, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x74,
	0x68, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x22, 0xd2, 0x01, 0x0a, 0x18, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x18, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x32,
	0xc3, 0x03, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd7, 0x02, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x69,
	0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe4, 0x01, 0xca, 0x41, 0x7e,
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x01, 0x2a, 0x22, 0x58, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa4, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x42, 0x18, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x52,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62,
	0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e,
	0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x24, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_goTypes = []interface{}{
	(*TrainCustomModelRequest)(nil),                  // 0: google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest
	(*TrainCustomModelResponse)(nil),                 // 1: google.cloud.discoveryengine.v1alpha.TrainCustomModelResponse
	(*TrainCustomModelMetadata)(nil),                 // 2: google.cloud.discoveryengine.v1alpha.TrainCustomModelMetadata
	(*TrainCustomModelRequest_GcsTrainingInput)(nil), // 3: google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest.GcsTrainingInput
	(*ImportErrorConfig)(nil),                        // 4: google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	(*status.Status)(nil),                            // 5: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                    // 6: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                  // 7: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_depIdxs = []int32{
	3, // 0: google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest.gcs_training_input:type_name -> google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest.GcsTrainingInput
	4, // 1: google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	5, // 2: google.cloud.discoveryengine.v1alpha.TrainCustomModelResponse.error_samples:type_name -> google.rpc.Status
	4, // 3: google.cloud.discoveryengine.v1alpha.TrainCustomModelResponse.error_config:type_name -> google.cloud.discoveryengine.v1alpha.ImportErrorConfig
	6, // 4: google.cloud.discoveryengine.v1alpha.TrainCustomModelMetadata.create_time:type_name -> google.protobuf.Timestamp
	6, // 5: google.cloud.discoveryengine.v1alpha.TrainCustomModelMetadata.update_time:type_name -> google.protobuf.Timestamp
	0, // 6: google.cloud.discoveryengine.v1alpha.SearchTuningService.TrainCustomModel:input_type -> google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest
	7, // 7: google.cloud.discoveryengine.v1alpha.SearchTuningService.TrainCustomModel:output_type -> google.longrunning.Operation
	7, // [7:8] is the sub-list for method output_type
	6, // [6:7] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_import_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainCustomModelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainCustomModelResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainCustomModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrainCustomModelRequest_GcsTrainingInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*TrainCustomModelRequest_GcsTrainingInput_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_search_tuning_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SearchTuningServiceClient is the client API for SearchTuningService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SearchTuningServiceClient interface {
	// Trains a custom model.
	TrainCustomModel(ctx context.Context, in *TrainCustomModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type searchTuningServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSearchTuningServiceClient(cc grpc.ClientConnInterface) SearchTuningServiceClient {
	return &searchTuningServiceClient{cc}
}

func (c *searchTuningServiceClient) TrainCustomModel(ctx context.Context, in *TrainCustomModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1alpha.SearchTuningService/TrainCustomModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SearchTuningServiceServer is the server API for SearchTuningService service.
type SearchTuningServiceServer interface {
	// Trains a custom model.
	TrainCustomModel(context.Context, *TrainCustomModelRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSearchTuningServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSearchTuningServiceServer struct {
}

func (*UnimplementedSearchTuningServiceServer) TrainCustomModel(context.Context, *TrainCustomModelRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method TrainCustomModel not implemented")
}

func RegisterSearchTuningServiceServer(s *grpc.Server, srv SearchTuningServiceServer) {
	s.RegisterService(&_SearchTuningService_serviceDesc, srv)
}

func _SearchTuningService_TrainCustomModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainCustomModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SearchTuningServiceServer).TrainCustomModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1alpha.SearchTuningService/TrainCustomModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SearchTuningServiceServer).TrainCustomModel(ctx, req.(*TrainCustomModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SearchTuningService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1alpha.SearchTuningService",
	HandlerType: (*SearchTuningServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TrainCustomModel",
			Handler:    _SearchTuningService_TrainCustomModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1alpha/search_tuning_service.proto",
}
