/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.hfsexplorer.Util;

/** This class was generated by CStructToJavaClass. */
public class ResourceType implements StaticStruct, PrintableStruct {
    /*
     * struct ResourceType
     * size: 8 bytes
     * description: 
     * 
     * BP  Size  Type     Identifier           Description                                                                    
     * -----------------------------------------------------------------------------------------------------------------------
     * 0   1*4   Char[4]  type                 // Resource type.                                                              
     * 4   2     UInt16   instanceCount        // Number of resources of this type in map minus 1.                            
     * 6   2     UInt16   referenceListOffset  // Offset from beginning of resource type list to reference list for this type.
     */
    
    public static final int STRUCTSIZE = 8;
    
    private final byte[] type = new byte[1*4];
    private final byte[] instanceCount = new byte[2];
    private final byte[] referenceListOffset = new byte[2];
    
    public ResourceType(byte[] data, int offset) {
	System.arraycopy(data, offset+0, type, 0, 1*4);
	System.arraycopy(data, offset+4, instanceCount, 0, 2);
	System.arraycopy(data, offset+6, referenceListOffset, 0, 2);
    }
    
    public static int length() { return STRUCTSIZE; }
    
    /** // Resource type. */
    public byte[] getType() { return Util.readByteArrayBE(type); }
    /** // Number of resources of this type in map minus 1. */
    public short getInstanceCount() { return Util.readShortBE(instanceCount); }
    /** // Offset from beginning of resource type list to reference list for this type. */
    public short getReferenceListOffset() { return Util.readShortBE(referenceListOffset); }
    
    public void printFields(PrintStream ps, String prefix) {
	ps.println(prefix + " type: " + Util.toASCIIString(getType()));
	ps.println(prefix + " instanceCount: " + getInstanceCount());
	ps.println(prefix + " referenceListOffset: " + getReferenceListOffset());
    }
    
    public void print(PrintStream ps, String prefix) {
	ps.println(prefix + "ResourceType:");
	printFields(ps, prefix);
    }
    
    public byte[] getBytes() {
	byte[] result = new byte[length()];
	int offset = 0;
	System.arraycopy(this.type, 0, result, offset, this.type.length); offset += this.type.length;
	System.arraycopy(this.instanceCount, 0, result, offset, this.instanceCount.length); offset += this.instanceCount.length;
	System.arraycopy(this.referenceListOffset, 0, result, offset, this.referenceListOffset.length); offset += this.referenceListOffset.length;
	return result;
    }

    public int size() {
        return length();
    }
}
