#include <stdio.h>
#ifdef __USE_BSD
#undef __USE_BSD
#endif
#define __USE_BSD
#include <termios.h>
#undef __USE_BSD
#include <unistd.h>
#include <fcntl.h>
#define __USE_BSD
#include <errno.h>
#undef __USE_BSD

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <time.h>
#include <string.h>
#include <utmp.h>
#include <stdlib.h>
#include <signal.h>
#include <syslog.h>
#include "paths.h"

int Sample(int fd, int bits);

int main(int argc, char *argv[]) {
  int TTY_fd;
  int i, res, n1, mean;
  struct termios tt;
  speed_t baud;

  if (argc != 3) {
    printf("Usage: %s <tty> <baud>\n", argv[0]);
    exit(-1);
  }

  switch(atoi(argv[2])) {
  case 1200: baud = B1200; break;
  case 2400: baud = B2400; break;
  case 4800: baud = B4800; break;
  case 9600: baud = B9600; break;
  case 19200: baud = B19200; break;
  case 38400: baud = B38400; break;
  case 115200: baud = B115200; break;
  default:
    printf("%s: Baud rate %s not supported.\n", argv[0], argv[2]);
    exit(-1);
  }

  if ((TTY_fd = open(argv[1], O_RDWR | O_NDELAY)) < 0) {
    fprintf(stderr, "%s: %s\n", argv[1], sys_errlist[errno]);
    exit(1);
  }

  res = tcgetattr(TTY_fd, &tt);
  res = cfsetospeed(&tt, baud); 
  cfmakeraw(&tt);
  tt.c_oflag &= (~(TABDLY | ONLCR));
  res = tcsetattr(TTY_fd, TCSANOW, &tt);

  mean = 0;
  for (i = 0; i < 100; i++) {
    n1 = Sample(TTY_fd, 200);
    printf("%3d ", n1);
    fflush(stdout);
    if (i % 20 == 19) printf("\n");
    mean += n1;
  }
  printf("Mean of first 100 REG200 trials = %f\n", (double)mean / 100.0);

  exit(0);
  for (i = 100; i < 200; i++) {
    n1 = Sample(TTY_fd, i);
    printf("%3d: %3d\n", i, n1);
  }
  return 0;
}

static int oldbits = 0;
static int bitsleft = 0;
int Sample(int fd, int bits) {
  int bc, sum, n1;
  unsigned char c1;

  sum = bc = 0;
  while (bc < bits) {
    if (bitsleft) {
      sum += (oldbits & 0x01);
      oldbits >>= 1;
      bitsleft--;
      bc++;
    } else {
      do {
	n1 = read(fd, &c1, 1);
      } while (n1 == 0 || (n1 == -1 && errno == EAGAIN));
      if (n1 == -1) {
	/* Fatal error occurred, die now? */
	exit(-errno);
      }
      oldbits = c1;
      bitsleft = 8;
#if 0
      printf("Sampled %c%c%c%c%c%c%c%c\n",
	     ((oldbits & 0x80)?'1':'0'),
	     ((oldbits & 0x40)?'1':'0'),
	     ((oldbits & 0x20)?'1':'0'),
	     ((oldbits & 0x10)?'1':'0'),
	     ((oldbits & 0x08)?'1':'0'),
	     ((oldbits & 0x04)?'1':'0'),
	     ((oldbits & 0x02)?'1':'0'),
	     ((oldbits & 0x01)?'1':'0'));
#endif
    }
  }

  return sum;
}

  
