/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class PolylineConnection
extends Polyline
implements Connection,
AnchorListener {
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter.NULL;
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public PolylineConnection() {
        this.setLayoutManager(new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void addRoutingListener(RoutingListener listener) {
        ConnectionRouter connectionRouter = this.connectionRouter;
        if (connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)connectionRouter;
            notifier.listeners.add(listener);
        } else {
            this.connectionRouter = new RoutingNotifier(this.connectionRouter, listener);
        }
    }

    @Override
    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            this.getChildren().forEach(child -> {
                Rectangle rectangle = this.bounds.union(child.getBounds());
            });
        }
        return this.bounds;
    }

    @Override
    public ConnectionRouter getConnectionRouter() {
        ConnectionRouter connectionRouter = this.connectionRouter;
        if (connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier routingNotifier = (RoutingNotifier)connectionRouter;
            return routingNotifier.realRouter;
        }
        return this.connectionRouter;
    }

    @Override
    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint(this);
        }
        return null;
    }

    @Override
    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    @Override
    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener(this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener(this);
        }
    }

    @Override
    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.connectionRouter.route(this);
        }
        Rectangle oldBounds = this.bounds;
        super.layout();
        this.bounds = null;
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent(oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    @Override
    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.connectionRouter.remove(this);
        super.removeNotify();
    }

    public void removeRoutingListener(RoutingListener listener) {
        ConnectionRouter connectionRouter = this.connectionRouter;
        if (connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)connectionRouter;
            notifier.listeners.remove(listener);
            if (notifier.listeners.isEmpty()) {
                this.connectionRouter = notifier.realRouter;
            }
        }
    }

    @Override
    public void revalidate() {
        super.revalidate();
        this.connectionRouter.invalidate(this);
    }

    @Override
    public void setConnectionRouter(ConnectionRouter cr) {
        ConnectionRouter oldRouter;
        if (cr == null) {
            cr = ConnectionRouter.NULL;
        }
        if ((oldRouter = this.getConnectionRouter()) != cr) {
            this.connectionRouter.remove(this);
            ConnectionRouter connectionRouter = this.connectionRouter;
            if (connectionRouter instanceof RoutingNotifier) {
                RoutingNotifier routingNotifier = (RoutingNotifier)connectionRouter;
                routingNotifier.realRouter = cr;
            } else {
                this.connectionRouter = cr;
            }
            this.firePropertyChange("connectionRouter", oldRouter, cr);
            this.revalidate();
        }
    }

    @Override
    public void setRoutingConstraint(Object cons) {
        if (this.connectionRouter != null) {
            this.connectionRouter.setConstraint(this, cons);
        }
        this.revalidate();
    }

    @Override
    public void setSourceAnchor(ConnectionAnchor anchor) {
        if (anchor == this.startAnchor) {
            return;
        }
        this.unhookSourceAnchor();
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.startArrow == dec) {
            return;
        }
        if (this.startArrow != null) {
            this.remove(this.startArrow);
        }
        this.startArrow = dec;
        if (this.startArrow != null) {
            this.add((IFigure)this.startArrow, new ArrowLocator(this, 2));
        }
    }

    @Override
    public void setTargetAnchor(ConnectionAnchor anchor) {
        if (anchor == this.endAnchor) {
            return;
        }
        this.unhookTargetAnchor();
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.endArrow == dec) {
            return;
        }
        if (this.endArrow != null) {
            this.remove(this.endArrow);
        }
        this.endArrow = dec;
        if (this.endArrow != null) {
            this.add((IFigure)this.endArrow, new ArrowLocator(this, 3));
        }
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener(this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener(this);
        }
    }

    final class RoutingNotifier
    implements ConnectionRouter {
        ConnectionRouter realRouter;
        List<RoutingListener> listeners = new CopyOnWriteArrayList<RoutingListener>();

        RoutingNotifier(ConnectionRouter router, RoutingListener listener) {
            this.realRouter = router;
            this.listeners.add(listener);
        }

        @Override
        public Object getConstraint(Connection connection) {
            return this.realRouter.getConstraint(connection);
        }

        @Override
        public void invalidate(Connection connection) {
            this.listeners.forEach(listener -> listener.invalidate(connection));
            this.realRouter.invalidate(connection);
        }

        @Override
        public void route(Connection connection) {
            boolean consumed = false;
            for (RoutingListener listener2 : this.listeners) {
                consumed |= listener2.route(connection);
            }
            if (!consumed) {
                this.realRouter.route(connection);
            }
            this.listeners.forEach(listener -> listener.postRoute(connection));
        }

        @Override
        public void remove(Connection connection) {
            this.listeners.forEach(listener -> listener.remove(connection));
            this.realRouter.remove(connection);
        }

        @Override
        public void setConstraint(Connection connection, Object constraint) {
            this.listeners.forEach(listener -> listener.setConstraint(connection, constraint));
            this.realRouter.setConstraint(connection, constraint);
        }
    }
}

