/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import java.util.Objects;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.GtkDPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.StrictChecks;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.image.ImageColorTransformer;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long mask;
    public long surface;
    int transparentPixel = -1;
    GC memGC;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private ImageGcDrawer imageGcDrawer;
    private int styleFlag = 0;
    private int currentDeviceZoom = 100;

    Image(Device device) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
    }

    public Image(Device device, int width, int height) {
        super(device);
        Point size = new Point(width, height);
        this.init(size.x, size.y);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        long cairo;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = srcImage.type;
        this.imageDataProvider = srcImage.imageDataProvider;
        this.imageFileNameProvider = srcImage.imageFileNameProvider;
        this.imageGcDrawer = srcImage.imageGcDrawer;
        this.styleFlag = srcImage.styleFlag | flag;
        this.currentDeviceZoom = srcImage.currentDeviceZoom;
        if (flag != 1) {
            this.transparentPixel = srcImage.transparentPixel;
        }
        long imageSurface = srcImage.surface;
        int width = this.width = srcImage.width;
        int height = this.height = srcImage.height;
        int format = Cairo.cairo_surface_get_content(imageSurface) == 4096 ? 1 : 0;
        boolean hasAlpha = format == 0;
        this.surface = Cairo.cairo_image_surface_create(format, width, height);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        if (DPIUtil.getDeviceZoom() != this.currentDeviceZoom) {
            double scaleFactor = (float)DPIUtil.getDeviceZoom() / 100.0f;
            Cairo.cairo_surface_set_device_scale(this.surface, scaleFactor, scaleFactor);
        }
        if ((cairo = Cairo.cairo_create(this.surface)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_operator(cairo, 1);
        Cairo.cairo_set_source_surface(cairo, imageSurface, 0.0, 0.0);
        Cairo.cairo_paint(cairo);
        Cairo.cairo_destroy(cairo);
        if (flag != 0) {
            int ob;
            int og;
            int or;
            int oa;
            int stride = Cairo.cairo_image_surface_get_stride(this.surface);
            long data = Cairo.cairo_image_surface_get_data(this.surface);
            if (OS.BIG_ENDIAN) {
                oa = 0;
                or = 1;
                og = 2;
                ob = 3;
            } else {
                oa = 3;
                or = 2;
                og = 1;
                ob = 0;
            }
            switch (flag) {
                case 1: {
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        C.memmove(line, data + (long)(y * stride), (long)stride);
                        int x = 0;
                        int offset = 0;
                        while (x < width) {
                            int a = line[offset + oa] & 0xFF;
                            int r = line[offset + or] & 0xFF;
                            int g = line[offset + og] & 0xFF;
                            int b = line[offset + ob] & 0xFF;
                            if (hasAlpha && a != 0) {
                                r = r * 255 / a;
                                g = g * 255 / a;
                                b = b * 255 / a;
                            }
                            RGBA result = ImageColorTransformer.DEFAULT_DISABLED_IMAGE_TRANSFORMER.adaptPixelValue(r, g, b, a);
                            if (hasAlpha) {
                                result.rgb.red = result.rgb.red * result.alpha / 255;
                                result.rgb.green = result.rgb.green * result.alpha / 255;
                                result.rgb.blue = result.rgb.blue * result.alpha / 255;
                            }
                            line[offset + oa] = (byte)result.alpha;
                            line[offset + or] = (byte)result.rgb.red;
                            line[offset + og] = (byte)result.rgb.green;
                            line[offset + ob] = (byte)result.rgb.blue;
                            ++x;
                            offset += 4;
                        }
                        C.memmove(data + (long)(y * stride), line, (long)stride);
                        ++y;
                    }
                    break;
                }
                case 2: {
                    byte[] line = new byte[stride];
                    int y = 0;
                    while (y < height) {
                        C.memmove(line, data + (long)(y * stride), (long)stride);
                        int x = 0;
                        int offset = 0;
                        while (x < width) {
                            int a = line[offset + oa] & 0xFF;
                            int r = line[offset + or] & 0xFF;
                            int g = line[offset + og] & 0xFF;
                            int b = line[offset + ob] & 0xFF;
                            if (hasAlpha && a != 0) {
                                r = (r * 255 + a / 2) / a;
                                g = (g * 255 + a / 2) / a;
                                b = (b * 255 + a / 2) / a;
                            }
                            int intensity = r + r + g + g + g + g + g + b >> 3;
                            if (hasAlpha) {
                                intensity = intensity * a + 128;
                                intensity = intensity + (intensity >> 8) >> 8;
                            }
                            byte by = (byte)intensity;
                            line[offset + ob] = by;
                            line[offset + og] = by;
                            line[offset + or] = by;
                            ++x;
                            offset += 4;
                        }
                        C.memmove(data + (long)(y * stride), line, (long)stride);
                        ++y;
                    }
                    break;
                }
            }
        }
        this.init();
    }

    @Deprecated(since="2025-06", forRemoval=true)
    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        this(device, GtkDPIUtil.pointToPixel(device, data), DPIUtil.getDeviceZoom());
    }

    private Image(Device device, ImageData data, int zoom) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = zoom;
        this.init(data, zoom);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        source = GtkDPIUtil.pointToPixel(device, source);
        mask = GtkDPIUtil.pointToPixel(device, mask);
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(image);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom<ImageData> image = ImageDataLoader.load(stream, 100, this.currentDeviceZoom);
        ImageData data = DPIUtil.scaleImageData(device, image, this.currentDeviceZoom);
        this.init(data);
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom<ImageData> image = ImageDataLoader.load(filename, 100, this.currentDeviceZoom);
        ImageData data = DPIUtil.scaleImageData(device, image, this.currentDeviceZoom);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        this.initFromFileNameProvider(this.currentDeviceZoom);
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        this.initFromImageDataProvider(this.currentDeviceZoom);
        this.init();
        StrictChecks.runIfStrictChecksEnabled(() -> DPIUtil.validateLinearScaling(imageDataProvider));
    }

    public Image(Device device, ImageGcDrawer imageGcDrawer, int width, int height) {
        super(device);
        if (imageGcDrawer == null) {
            SWT.error(4);
        }
        this.imageGcDrawer = imageGcDrawer;
        this.currentDeviceZoom = 100;
        ImageData imageData = this.drawWithImageGcDrawer(width, height, this.currentDeviceZoom);
        this.init(imageData, this.currentDeviceZoom);
        this.init();
    }

    public boolean internal_gtk_refreshImageForZoom() {
        return this.refreshImageForZoom();
    }

    boolean refreshImageForZoom() {
        int deviceZoomLevel;
        boolean refreshed = false;
        int deviceZoom = DPIUtil.getDeviceZoom();
        if (this.imageFileNameProvider != null) {
            int deviceZoomLevel2 = deviceZoom;
            if (deviceZoomLevel2 != this.currentDeviceZoom) {
                this.destroy();
                this.initFromFileNameProvider(deviceZoomLevel2);
                this.init();
                refreshed = true;
                this.currentDeviceZoom = deviceZoomLevel2;
            }
        } else if (this.imageDataProvider != null) {
            int deviceZoomLevel3 = deviceZoom;
            if (deviceZoomLevel3 != this.currentDeviceZoom) {
                this.destroy();
                this.initFromImageDataProvider(deviceZoomLevel3);
                this.init();
                refreshed = true;
                this.currentDeviceZoom = deviceZoomLevel3;
            }
        } else if (this.imageGcDrawer != null && (deviceZoomLevel = deviceZoom) != this.currentDeviceZoom) {
            ImageData data = this.drawWithImageGcDrawer(this.width, this.height, deviceZoomLevel);
            this.destroy();
            this.init(data);
            this.init();
            refreshed = true;
            this.currentDeviceZoom = deviceZoomLevel;
        }
        return refreshed;
    }

    void initNative(String filename) {
        block6: {
            try {
                byte[] fileNameBuffer = Converter.javaStringToCString(filename);
                long pixbuf = GDK.gdk_pixbuf_new_from_file(fileNameBuffer, null);
                if (pixbuf == 0L) break block6;
                try {
                    this.createFromPixbuf(0, pixbuf);
                }
                finally {
                    if (pixbuf != 0L) {
                        OS.g_object_unref(pixbuf);
                    }
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    private void initFromFileNameProvider(int zoom) {
        DPIUtil.ElementAtZoom<String> fileForZoom = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, zoom);
        if (fileForZoom.zoom() == zoom) {
            this.initNative(fileForZoom.element());
        }
        if (this.surface == 0L) {
            DPIUtil.ElementAtZoom<ImageData> imageDataAtZoom = ImageDataLoader.load(fileForZoom.element(), fileForZoom.zoom(), zoom);
            ImageData imageData = imageDataAtZoom.element();
            if (imageDataAtZoom.zoom() != zoom) {
                imageData = DPIUtil.scaleImageData(this.device, imageDataAtZoom, zoom);
            }
            this.init(imageData);
        }
    }

    private void initFromImageDataProvider(int zoom) {
        DPIUtil.ElementAtZoom<ImageData> data = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, zoom);
        ImageData resizedData = DPIUtil.scaleImageData(this.device, data.element(), zoom, data.zoom());
        this.init(resizedData);
    }

    void createFromPixbuf(int type, long pixbuf) {
        this.type = type;
        int pixbufWidth = GDK.gdk_pixbuf_get_width(pixbuf);
        int pixbufHeight = GDK.gdk_pixbuf_get_height(pixbuf);
        double scaleFactor = (float)DPIUtil.getDeviceZoom() / 100.0f;
        this.width = (int)Math.round((double)pixbufWidth / scaleFactor);
        this.height = (int)Math.round((double)pixbufHeight / scaleFactor);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        int format = hasAlpha ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create(format, pixbufWidth, pixbufHeight);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_surface_set_device_scale(this.surface, scaleFactor, scaleFactor);
        long data = Cairo.cairo_image_surface_get_data(this.surface);
        int cairoStride = Cairo.cairo_image_surface_get_stride(this.surface);
        int oa = 0;
        int or = 0;
        int og = 0;
        int ob = 0;
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
        }
        byte[] line = new byte[stride];
        if (hasAlpha) {
            int y = 0;
            while (y < pixbufHeight) {
                C.memmove(line, pixels + (long)(y * stride), (long)stride);
                int x = 0;
                int offset = 0;
                while (x < pixbufWidth) {
                    int a = line[offset + 3] & 0xFF;
                    int r = (line[offset + 0] & 0xFF) * a + 128;
                    r = r + (r >> 8) >> 8;
                    int g = (line[offset + 1] & 0xFF) * a + 128;
                    g = g + (g >> 8) >> 8;
                    int b = (line[offset + 2] & 0xFF) * a + 128;
                    b = b + (b >> 8) >> 8;
                    line[offset + oa] = (byte)a;
                    line[offset + or] = (byte)r;
                    line[offset + og] = (byte)g;
                    line[offset + ob] = (byte)b;
                    ++x;
                    offset += 4;
                }
                C.memmove(data + (long)(y * stride), line, (long)stride);
                ++y;
            }
        } else {
            byte[] cairoLine = new byte[cairoStride];
            int y = 0;
            while (y < pixbufHeight) {
                C.memmove(line, pixels + (long)(y * stride), (long)stride);
                int x = 0;
                int offset = 0;
                int cairoOffset = 0;
                while (x < pixbufWidth) {
                    int r = line[offset + 0] & 0xFF;
                    int g = line[offset + 1] & 0xFF;
                    int b = line[offset + 2] & 0xFF;
                    cairoLine[cairoOffset + or] = (byte)r;
                    cairoLine[cairoOffset + og] = (byte)g;
                    cairoLine[cairoOffset + ob] = (byte)b;
                    ++x;
                    offset += 3;
                    cairoOffset += 4;
                }
                C.memmove(data + (long)(y * cairoStride), cairoLine, (long)cairoStride);
                ++y;
            }
        }
        Cairo.cairo_surface_mark_dirty(this.surface);
    }

    void createMask() {
        int tb;
        int tg;
        int tr;
        int ob;
        int og;
        int or;
        int oa;
        int width = this.width;
        int height = this.height;
        int stride = Cairo.cairo_image_surface_get_stride(this.surface);
        long surfaceData = Cairo.cairo_image_surface_get_data(this.surface);
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
            tr = this.transparentPixel >> 24 & 0xFF;
            tg = this.transparentPixel >> 16 & 0xFF;
            tb = this.transparentPixel >> 8 & 0xFF;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
            tr = this.transparentPixel >> 16 & 0xFF;
            tg = this.transparentPixel >> 8 & 0xFF;
            tb = this.transparentPixel >> 0 & 0xFF;
        }
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, surfaceData, (long)srcData.length);
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int a = srcData[offset + oa] & 0xFF;
                int r = srcData[offset + or] & 0xFF;
                int g = srcData[offset + og] & 0xFF;
                int b = srcData[offset + ob] & 0xFF;
                if (r == tr && g == tg && b == tb) {
                    b = 0;
                    g = 0;
                    r = 0;
                    a = 0;
                } else {
                    a = 255;
                }
                srcData[offset + oa] = (byte)a;
                srcData[offset + or] = (byte)r;
                srcData[offset + og] = (byte)g;
                srcData[offset + ob] = (byte)b;
                ++x;
                offset += 4;
            }
            ++y;
        }
        C.memmove(surfaceData, srcData, (long)srcData.length);
    }

    void createSurface() {
        if (this.surface != 0L) {
            return;
        }
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0L;
        this.surface = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        if (this.imageGcDrawer != null && image.imageGcDrawer != null) {
            return this.styleFlag == image.styleFlag && this.imageGcDrawer.equals(image.imageGcDrawer) && this.width == image.width && this.height == image.height;
        }
        return this.surface == image.surface;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBoundsInPixels();
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public Rectangle getBoundsInPixels() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public ImageData getImageDataAtCurrentZoom() {
        int ob;
        int og;
        int or;
        int oa;
        boolean hasAlpha;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        long surface = ImageList.convertSurface(this);
        int format = Cairo.cairo_image_surface_get_format(surface);
        int width = Cairo.cairo_image_surface_get_width(surface);
        int height = Cairo.cairo_image_surface_get_height(surface);
        int stride = Cairo.cairo_image_surface_get_stride(surface);
        long surfaceData = Cairo.cairo_image_surface_get_data(surface);
        boolean bl = hasAlpha = format == 0;
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
        }
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, surfaceData, (long)srcData.length);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, 32, palette, 4, srcData);
        if (hasAlpha) {
            data.alphaData = new byte[width * height];
            byte[] alphaData = data.alphaData;
            int y = 0;
            int offset = 0;
            int alphaOffset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int a = srcData[offset + oa] & 0xFF;
                    int r = srcData[offset + or] & 0xFF;
                    int g = srcData[offset + og] & 0xFF;
                    int b = srcData[offset + ob] & 0xFF;
                    srcData[offset + 0] = 0;
                    alphaData[alphaOffset++] = (byte)a;
                    if (a != 0) {
                        srcData[offset + 1] = (byte)((r * 255 + a / 2) / a);
                        srcData[offset + 2] = (byte)((g * 255 + a / 2) / a);
                        srcData[offset + 3] = (byte)((b * 255 + a / 2) / a);
                    }
                    ++x;
                    offset += 4;
                }
                ++y;
            }
        } else {
            int y = 0;
            int offset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + or];
                    byte g = srcData[offset + og];
                    byte b = srcData[offset + ob];
                    srcData[offset + 0] = 0;
                    srcData[offset + 1] = r;
                    srcData[offset + 2] = g;
                    srcData[offset + 3] = b;
                    ++x;
                    offset += 4;
                }
                ++y;
            }
        }
        Cairo.cairo_surface_destroy(surface);
        return data;
    }

    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (zoom == this.currentDeviceZoom) {
            return this.getImageDataAtCurrentZoom();
        }
        if (this.imageDataProvider != null) {
            DPIUtil.ElementAtZoom<ImageData> data = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, zoom);
            return DPIUtil.scaleImageData(this.device, data.element(), zoom, data.zoom());
        }
        if (this.imageFileNameProvider != null) {
            DPIUtil.ElementAtZoom<String> fileName = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, zoom);
            return DPIUtil.scaleImageData(this.device, new ImageData(fileName.element()), zoom, fileName.zoom());
        }
        if (this.imageGcDrawer != null) {
            return this.drawWithImageGcDrawer(this.width, this.height, zoom);
        }
        return DPIUtil.scaleImageData(this.device, this.getImageDataAtCurrentZoom(), zoom, this.currentDeviceZoom);
    }

    private ImageData drawWithImageGcDrawer(int width, int height, int zoom) {
        Image image;
        int gcStyle = this.imageGcDrawer.getGcStyle();
        if ((gcStyle & 0x40000000) != 0) {
            ImageData resultData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
            resultData.alphaData = new byte[width * height];
            image = new Image(this.device, resultData, zoom);
        } else {
            image = new Image(this.device, width, height);
        }
        GC gc = new GC(image, gcStyle);
        try {
            this.imageGcDrawer.drawOn(gc, width, height);
            ImageData imageData = image.getImageData(zoom);
            this.imageGcDrawer.postProcess(imageData);
            ImageData imageData2 = imageData;
            return imageData2;
        }
        finally {
            gc.dispose();
            image.dispose();
        }
    }

    public static Image gtk_new(Device device, int type, long imageHandle, long mask) {
        Image image = new Image(device);
        image.type = type;
        image.surface = imageHandle;
        image.mask = mask;
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int type, long pixbuf) {
        Image image = new Image(device);
        image.createFromPixbuf(type, pixbuf);
        image.type = type;
        return image;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        if (this.imageGcDrawer != null) {
            return Objects.hash(this.imageGcDrawer, this.width, this.height);
        }
        return (int)this.surface;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.surface = GTK.GTK4 ? Cairo.cairo_image_surface_create(1, width, height) : GDK.gdk_window_create_similar_surface(GDK.gdk_get_default_root_window(), 4096, width, height);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        this.currentDeviceZoom = 100;
        Cairo.cairo_surface_set_device_scale(this.surface, 1.0, 1.0);
        long cairo = Cairo.cairo_create(this.surface);
        if (cairo == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
        Cairo.cairo_rectangle(cairo, 0.0, 0.0, width, height);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_destroy(cairo);
        this.width = width;
        this.height = height;
    }

    void init(ImageData image) {
        this.init(image, DPIUtil.getDeviceZoom());
    }

    private void init(ImageData image, int zoom) {
        int destOrder;
        int blueMask;
        int greenMask;
        int redMask;
        if (image == null) {
            SWT.error(4);
        }
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        int imageDataWidth = image.width;
        int imageDataHeight = image.height;
        double scaleFactor = (float)zoom / 100.0f;
        this.width = (int)Math.round((double)imageDataWidth / scaleFactor);
        this.height = (int)Math.round((double)imageDataHeight / scaleFactor);
        boolean hasAlpha = image.transparentPixel != -1 || image.alpha != -1 || image.maskData != null || image.alphaData != null;
        int format = hasAlpha ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create(format, imageDataWidth, imageDataHeight);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_surface_set_device_scale(this.surface, scaleFactor, scaleFactor);
        int stride = Cairo.cairo_image_surface_get_stride(this.surface);
        long data = Cairo.cairo_image_surface_get_data(this.surface);
        int oa = 0;
        int or = 0;
        int og = 0;
        int ob = 0;
        int destDepth = 32;
        if (OS.BIG_ENDIAN) {
            oa = 0;
            or = 1;
            og = 2;
            ob = 3;
            redMask = 65280;
            greenMask = 0xFF0000;
            blueMask = -16777216;
            destOrder = 1;
        } else {
            oa = 3;
            or = 2;
            og = 1;
            ob = 0;
            redMask = 0xFF0000;
            greenMask = 65280;
            blueMask = 255;
            destOrder = 0;
        }
        byte[] buffer = image.data;
        if (!palette.isDirect || image.depth != destDepth || stride != image.bytesPerLine || palette.redMask != redMask || palette.greenMask != greenMask || palette.blueMask != blueMask || destOrder != image.getByteOrder()) {
            buffer = new byte[stride * imageDataHeight];
            if (palette.isDirect) {
                ImageData.blit(image.data, image.depth, image.bytesPerLine, image.getByteOrder(), imageDataWidth, imageDataHeight, palette.redMask, palette.greenMask, palette.blueMask, buffer, destDepth, stride, destOrder, imageDataWidth, imageDataHeight, redMask, greenMask, blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(imageDataWidth, imageDataHeight, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), srcReds, srcGreens, srcBlues, buffer, destDepth, stride, destOrder, redMask, greenMask, blueMask);
            }
        }
        boolean isIcon = image.getTransparencyType() == 2;
        int n = this.type = isIcon ? 1 : 0;
        if (isIcon || image.transparentPixel != -1) {
            if (image.transparentPixel != -1) {
                RGB rgb = null;
                if (palette.isDirect) {
                    rgb = palette.getRGB(image.transparentPixel);
                } else if (image.transparentPixel < palette.colors.length) {
                    rgb = palette.getRGB(image.transparentPixel);
                }
                if (rgb != null) {
                    this.transparentPixel = rgb.red << 16 | rgb.green << 8 | rgb.blue;
                }
            }
            ImageData mask = image.getTransparencyMask();
            int y = 0;
            int offset = 0;
            while (y < imageDataHeight) {
                int x = 0;
                while (x < imageDataWidth) {
                    alpha = mask.getPixel(x, y) == 0 ? 0 : 255;
                    int r = (buffer[offset + or] & 0xFF) * alpha + 128;
                    r = r + (r >> 8) >> 8;
                    int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                    g = g + (g >> 8) >> 8;
                    int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                    b = b + (b >> 8) >> 8;
                    buffer[offset + oa] = (byte)alpha;
                    buffer[offset + or] = (byte)r;
                    buffer[offset + og] = (byte)g;
                    buffer[offset + ob] = (byte)b;
                    ++x;
                    offset += 4;
                }
                ++y;
            }
        } else if (image.alpha != -1) {
            int alpha = image.alpha;
            int y = 0;
            int offset = 0;
            while (y < imageDataHeight) {
                int x = 0;
                while (x < imageDataWidth) {
                    int r = (buffer[offset + or] & 0xFF) * alpha + 128;
                    r = r + (r >> 8) >> 8;
                    int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                    g = g + (g >> 8) >> 8;
                    int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                    b = b + (b >> 8) >> 8;
                    buffer[offset + oa] = (byte)alpha;
                    buffer[offset + or] = (byte)r;
                    buffer[offset + og] = (byte)g;
                    buffer[offset + ob] = (byte)b;
                    ++x;
                    offset += 4;
                }
                ++y;
            }
        } else if (image.alphaData != null) {
            byte[] alphaData = image.alphaData;
            int y = 0;
            int offset = 0;
            while (y < imageDataHeight) {
                int x = 0;
                while (x < imageDataWidth) {
                    alpha = alphaData[y * imageDataWidth + x] & 0xFF;
                    int r = (buffer[offset + or] & 0xFF) * alpha + 128;
                    r = r + (r >> 8) >> 8;
                    int g = (buffer[offset + og] & 0xFF) * alpha + 128;
                    g = g + (g >> 8) >> 8;
                    int b = (buffer[offset + ob] & 0xFF) * alpha + 128;
                    b = b + (b >> 8) >> 8;
                    buffer[offset + oa] = (byte)alpha;
                    buffer[offset + or] = (byte)r;
                    buffer[offset + og] = (byte)g;
                    buffer[offset + ob] = (byte)b;
                    ++x;
                    offset += 4;
                }
                ++y;
            }
        }
        C.memmove(data, buffer, (long)(stride * imageDataHeight));
        Cairo.cairo_surface_mark_dirty(this.surface);
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long gc = Cairo.cairo_create(this.surface);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            } else if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
            data.device = this.device;
            data.foregroundRGBA = Device.COLOR_BLACK.handle;
            data.backgroundRGBA = Device.COLOR_WHITE.handle;
            data.font = this.device.systemFont;
            data.image = this;
        }
        return gc;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        Cairo.cairo_destroy(hDC);
    }

    @Override
    public boolean isDisposed() {
        return this.surface == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (this.imageFileNameProvider != null) {
            return "Image {" + this.imageFileNameProvider.getImagePath(100) + "}";
        }
        return "Image {" + this.surface + "}";
    }

    public static void drawScaled(GC gc, ImageData imageData, int width, int height, float scaleFactor) {
        StrictChecks.runWithStrictChecksDisabled(() -> {
            Image imageToDraw = new Image(gC.device, zoom -> imageData);
            gc.drawImage(imageToDraw, 0, 0, width, height, 0, 0, Math.round((float)width * scaleFactor), Math.round((float)height * scaleFactor));
            imageToDraw.dispose();
        });
    }
}

