# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [1.0.0-alpha.9](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.8...v1.0.0-alpha.9) (2024-08-14)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [1.0.0-alpha.8](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.7...v1.0.0-alpha.8) (2024-08-08)

### Features

- **reference:** loosen requirement for file extensions in parser plugins ([#4299](https://github.com/swagger-api/apidom/issues/4299)) ([e4ddc6d](https://github.com/swagger-api/apidom/commit/e4ddc6d4b45c4be213c7b3e89ae0d21ae2085067)), closes [#4298](https://github.com/swagger-api/apidom/issues/4298)

# [1.0.0-alpha.7](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.6...v1.0.0-alpha.7) (2024-08-05)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [1.0.0-alpha.6](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.5...v1.0.0-alpha.6) (2024-07-09)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [1.0.0-alpha.5](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.4...v1.0.0-alpha.5) (2024-05-29)

### Bug Fixes

- **deps:** add apidom-error package as direct dependency ([#4154](https://github.com/swagger-api/apidom/issues/4154)) ([f076207](https://github.com/swagger-api/apidom/commit/f0762072db8ba71c05fc1c14e7ea88f56326ae32))
- **reference:** fix versioning of optional dependencies ([#4153](https://github.com/swagger-api/apidom/issues/4153)) ([e561bd7](https://github.com/swagger-api/apidom/commit/e561bd7cad391fd12936a57560e5ed17f50becaf))

# [1.0.0-alpha.3](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.2...v1.0.0-alpha.3) (2024-05-21)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [1.0.0-alpha.2](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.1...v1.0.0-alpha.2) (2024-05-20)

### Features

- **ast:** add support for mutable node replacements ([#4121](https://github.com/swagger-api/apidom/issues/4121)) ([b37ecd2](https://github.com/swagger-api/apidom/commit/b37ecd2dba83aaa3813bb539ae64e98b290f0292)), closes [#4120](https://github.com/swagger-api/apidom/issues/4120)

# [1.0.0-alpha.1](https://github.com/swagger-api/apidom/compare/v1.0.0-alpha.0...v1.0.0-alpha.1) (2024-05-15)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [1.0.0-alpha.0](https://github.com/swagger-api/apidom/compare/v0.99.2...v1.0.0-alpha.0) (2024-05-14)

### Features

- **core:** change from stamps to TypeScript classes ([#4095](https://github.com/swagger-api/apidom/issues/4095)) ([3bb7131](https://github.com/swagger-api/apidom/commit/3bb71317420583b0b5e56ca9a6e55bbca9596bfc)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change all strategies from stamps to TypeScript classes ([#4103](https://github.com/swagger-api/apidom/issues/4103)) ([7e6dad4](https://github.com/swagger-api/apidom/commit/7e6dad4b3e076be1658b73d8c3e63245c65fd40a)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change dereference visitors from stamps to TypeScript classes ([#4104](https://github.com/swagger-api/apidom/issues/4104)) ([a0657fb](https://github.com/swagger-api/apidom/commit/a0657fb5f1b805fad0643ca442cb039a3de90c50)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change File from stamp to TypeScript class ([#4096](https://github.com/swagger-api/apidom/issues/4096)) ([cb4b90b](https://github.com/swagger-api/apidom/commit/cb4b90b63cfd358c2d40fecb162b21080b15b579)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change parsers from stamps to TypeScript classes ([#4102](https://github.com/swagger-api/apidom/issues/4102)) ([e3d195d](https://github.com/swagger-api/apidom/commit/e3d195db63b320a293ab5f1321580792f1dccf3e)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change Reference from stamp to TypeScript class ([#4099](https://github.com/swagger-api/apidom/issues/4099)) ([88f859c](https://github.com/swagger-api/apidom/commit/88f859cfcc63b2f134b290358808fe2dbf82929f)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change ReferenceSet from stamp to TypeScript class ([#4100](https://github.com/swagger-api/apidom/issues/4100)) ([aeb195b](https://github.com/swagger-api/apidom/commit/aeb195be620f20aab2a7fe65e14873e9e7aff122)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)
- **reference:** change resolvers from stamps to TypeScript classes ([#4101](https://github.com/swagger-api/apidom/issues/4101)) ([468259e](https://github.com/swagger-api/apidom/commit/468259ee7f8dec57fd278a4499acaf2ab2dc31d4)), closes [#3481](https://github.com/swagger-api/apidom/issues/3481)

### BREAKING CHANGES

- **reference:** all visitors from apidom-reference package became a class and requires to be instantiated with new operator.
- **reference:** all strategies from apidom-reference package became a class and requires to be instantiated with new operator.
- **reference:** parsers from apidom-reference package became a class and requires to be instantiated with new operator.
- **reference:** resolvers from apidom-reference package became a classes and requires to be instantiated with new operator.
- **reference:** ReferenceSet from apidom-reference package became a class and requires to be instantiated with new operator.
- **reference:** Reference from apidom-reference package became a class and requires to be instantiated with new operator.
- **reference:** File from apidom-reference package became a class
  and requires to be instantiated with new operator.
- **core:** IdentityManager from apidom-core package became a class and requires to be instantiated with new operator.

## [0.99.2](https://github.com/swagger-api/apidom/compare/v0.99.1...v0.99.2) (2024-04-30)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.99.1](https://github.com/swagger-api/apidom/compare/v0.99.0...v0.99.1) (2024-04-05)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.99.0](https://github.com/swagger-api/apidom/compare/v0.98.3...v0.99.0) (2024-04-03)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.98.3](https://github.com/swagger-api/apidom/compare/v0.98.2...v0.98.3) (2024-03-29)

### Performance Improvements

- **reference:** dereference fragments as quick as possible ([#3981](https://github.com/swagger-api/apidom/issues/3981)) ([48b4eb4](https://github.com/swagger-api/apidom/commit/48b4eb4d99c198802431af9fcf75b706534853a4)), closes [#3974](https://github.com/swagger-api/apidom/issues/3974)

## [0.98.2](https://github.com/swagger-api/apidom/compare/v0.98.1...v0.98.2) (2024-03-28)

### Bug Fixes

- **reference:** fix regression in AsyncAPI 2.x dereferencing ([#3975](https://github.com/swagger-api/apidom/issues/3975)) ([6e8d9a0](https://github.com/swagger-api/apidom/commit/6e8d9a014682a263dac44724df33c3b360502f0f)), closes [#3974](https://github.com/swagger-api/apidom/issues/3974)
- **reference:** fix regression in OpenAPI 2.0 derferencing ([#3976](https://github.com/swagger-api/apidom/issues/3976)) ([2e4d15a](https://github.com/swagger-api/apidom/commit/2e4d15a43a7c2160729d4adcf0be766481308131)), closes [#3974](https://github.com/swagger-api/apidom/issues/3974)
- **reference:** fix regression in OpenAPI 3.0.x dereferencing ([#3977](https://github.com/swagger-api/apidom/issues/3977)) ([45d706f](https://github.com/swagger-api/apidom/commit/45d706fd736112a1a33e416ddccfe498bbbff72d)), closes [#3974](https://github.com/swagger-api/apidom/issues/3974)
- **reference:** fix regression in OpenAPI 3.1.0 dereferencing ([#3978](https://github.com/swagger-api/apidom/issues/3978)) ([ff039fe](https://github.com/swagger-api/apidom/commit/ff039feb6a0f3356053720952039e7650df7b84f)), closes [#3974](https://github.com/swagger-api/apidom/issues/3974)

# [0.98.0](https://github.com/swagger-api/apidom/compare/v0.97.1...v0.98.0) (2024-03-21)

### Bug Fixes

- **reference:** fix regression in nested paths dereferencing ([#3960](https://github.com/swagger-api/apidom/issues/3960)) ([8435ee1](https://github.com/swagger-api/apidom/commit/8435ee1cfde37394e2ab0e4a4b805f4b59dcf737)), closes [#3959](https://github.com/swagger-api/apidom/issues/3959)

### Features

- **reference:** apply dereferencing architecture 2.0 to ApiDOM ([#3930](https://github.com/swagger-api/apidom/issues/3930)) ([bbb9a25](https://github.com/swagger-api/apidom/commit/bbb9a25eb85f6753c7c3a1b0060013da7666fae6))
- **reference:** apply dereferencing architecture 2.0 to AsyncAPI 2.x ([#3933](https://github.com/swagger-api/apidom/issues/3933)) ([856dc5c](https://github.com/swagger-api/apidom/commit/856dc5c4b53726c040c55a17635d9c0143c49379)), closes [#3932](https://github.com/swagger-api/apidom/issues/3932)
- **reference:** apply dereferencing architecture 2.0 to OpenAPI 2.0 ([#3931](https://github.com/swagger-api/apidom/issues/3931)) ([63a41d4](https://github.com/swagger-api/apidom/commit/63a41d40d63c09717cb6dfa4116ba90f78fce0e8)), closes [#3924](https://github.com/swagger-api/apidom/issues/3924)
- **reference:** apply dereferencing architecture 2.0 to OpenAPI 3.0.x ([#3917](https://github.com/swagger-api/apidom/issues/3917)) ([cc3a970](https://github.com/swagger-api/apidom/commit/cc3a9707b26bb87a911f2bc353d59406f61dc50b)), closes [#3916](https://github.com/swagger-api/apidom/issues/3916)
- **reference:** apply dereferencing architecture 2.0 to OpenAPI 3.1.0 ([#3942](https://github.com/swagger-api/apidom/issues/3942)) ([d57c318](https://github.com/swagger-api/apidom/commit/d57c318e3832ca2d13ddba1507c27647aa2d7c7e)), closes [#3941](https://github.com/swagger-api/apidom/issues/3941)

## [0.97.1](https://github.com/swagger-api/apidom/compare/v0.97.0...v0.97.1) (2024-03-08)

### Bug Fixes

- **reference:** base AsyncAPI 2.x resolver strategy on dereference strategy ([#3909](https://github.com/swagger-api/apidom/issues/3909)) ([98cb77f](https://github.com/swagger-api/apidom/commit/98cb77f922945302bbc9200a5bc6de185437afd3)), closes [#3452](https://github.com/swagger-api/apidom/issues/3452)
- **reference:** base OpenAPI 3.0.x resolver strategy on dereference strategy ([#3908](https://github.com/swagger-api/apidom/issues/3908)) ([e1ae4d1](https://github.com/swagger-api/apidom/commit/e1ae4d1c01f457e989d87ff12868033a757d4e31)), closes [#3452](https://github.com/swagger-api/apidom/issues/3452)
- **reference:** base OpenAPI 3.1.0 resolver strategy on dereference strategy ([#3910](https://github.com/swagger-api/apidom/issues/3910)) ([b21d7bf](https://github.com/swagger-api/apidom/commit/b21d7bfc4e626782c4a3fd483428d8fe42bdecbe)), closes [#3452](https://github.com/swagger-api/apidom/issues/3452)

# [0.97.0](https://github.com/swagger-api/apidom/compare/v0.96.0...v0.97.0) (2024-03-07)

### Features

- **reference): eat(reference:** add support for skipping internal references in AsyncAPI 2.x dereference strategy ([#3905](https://github.com/swagger-api/apidom/issues/3905)) ([ad82680](https://github.com/swagger-api/apidom/commit/ad826800b08a2b1f799ace209b41eff7e5c617ea)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** add dereference strategy that handles abstract RefElement ([#3887](https://github.com/swagger-api/apidom/issues/3887)) ([a2eabb6](https://github.com/swagger-api/apidom/commit/a2eabb667e75b48e328c99cc48877d3526d7b353)), closes [#3881](https://github.com/swagger-api/apidom/issues/3881)
- **reference:** add parser plugin for parsing dehydrated ApiDOM ([#3892](https://github.com/swagger-api/apidom/issues/3892)) ([6b97051](https://github.com/swagger-api/apidom/commit/6b970512e0ac9f688f1de748f40c8691c53c68e6)), closes [#3889](https://github.com/swagger-api/apidom/issues/3889)
- **reference:** add resolver strategy that handles abstract RefElement ([#3893](https://github.com/swagger-api/apidom/issues/3893)) ([9db6d3e](https://github.com/swagger-api/apidom/commit/9db6d3ec383c9f66ce03ed1593548d9c046fe59f)), closes [#3888](https://github.com/swagger-api/apidom/issues/3888)
- **reference:** add support for skipping internal references in OpenAPI 3.0.x dereference strategy ([#3904](https://github.com/swagger-api/apidom/issues/3904)) ([4da622a](https://github.com/swagger-api/apidom/commit/4da622a69ef2fd5ee4c7a12aabc151acff0e19d3)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** add support for skipping internal references in OpenAPI 3.1.0 dereference strategy ([#3906](https://github.com/swagger-api/apidom/issues/3906)) ([9d005db](https://github.com/swagger-api/apidom/commit/9d005dbb8d283465d77cc23377783b39549dadeb)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** skip processing internal refererences in apidom resolve strategy ([#3902](https://github.com/swagger-api/apidom/issues/3902)) ([0762e8b](https://github.com/swagger-api/apidom/commit/0762e8b13c32e87f4f447d5ee5e0c113c02ab2d7)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** skip processing internal refererences in OpenAPI 2.0 resolve strategy ([#3903](https://github.com/swagger-api/apidom/issues/3903)) ([dc787bf](https://github.com/swagger-api/apidom/commit/dc787bf26e07511430e74108677e67b742061f2b)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)

# [0.96.0](https://github.com/swagger-api/apidom/compare/v0.95.0...v0.96.0) (2024-02-28)

### Bug Fixes

- **reference:** add support for external cycles detection in AsyncAPI 2.x dereference strategy ([#3872](https://github.com/swagger-api/apidom/issues/3872)) ([910a974](https://github.com/swagger-api/apidom/commit/910a974acbfdb0e4dac28a4811304b17ae02754a)), closes [#3863](https://github.com/swagger-api/apidom/issues/3863)
- **reference:** add support for external cycles detection in OpenAPI 2.0 dereference strategy ([#3871](https://github.com/swagger-api/apidom/issues/3871)) ([5a2141d](https://github.com/swagger-api/apidom/commit/5a2141d230a6cda5b1cfddb0092799fdcd234219)), closes [#3863](https://github.com/swagger-api/apidom/issues/3863)
- **reference:** add support for external cycles detection in OpenAPI 3.0.x dereference strategy ([#3870](https://github.com/swagger-api/apidom/issues/3870)) ([0735471](https://github.com/swagger-api/apidom/commit/0735471a144303950bdb74ea1a7bba90145838ed)), closes [#3863](https://github.com/swagger-api/apidom/issues/3863)
- **reference:** add support for external cycles detection in OpenAPI 3.1.0 dereference strategy ([#3873](https://github.com/swagger-api/apidom/issues/3873)) ([9cd15ff](https://github.com/swagger-api/apidom/commit/9cd15ff864718f5687f71ef6e1f4dbf61e3c855b)), closes [#3863](https://github.com/swagger-api/apidom/issues/3863)

# [0.95.0](https://github.com/swagger-api/apidom/compare/v0.94.0...v0.95.0) (2024-02-09)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.94.0](https://github.com/swagger-api/apidom/compare/v0.93.0...v0.94.0) (2024-02-05)

### Features

- **converter:** add complete code infrastructure ([#3755](https://github.com/swagger-api/apidom/issues/3755)) ([f882828](https://github.com/swagger-api/apidom/commit/f8828281ab2e49394d365cc314448dc9164418ce)), closes [#3697](https://github.com/swagger-api/apidom/issues/3697) [#3743](https://github.com/swagger-api/apidom/issues/3743)

# [0.93.0](https://github.com/swagger-api/apidom/compare/v0.92.0...v0.93.0) (2024-01-23)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.92.0](https://github.com/swagger-api/apidom/compare/v0.91.0...v0.92.0) (2024-01-12)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.91.0](https://github.com/swagger-api/apidom/compare/v0.90.0...v0.91.0) (2024-01-08)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.90.0](https://github.com/swagger-api/apidom/compare/v0.89.0...v0.90.0) (2024-01-04)

### Features

- **reference:** add Workflows 1.0.0 JSON parser plugin ([#3568](https://github.com/swagger-api/apidom/issues/3568)) ([1b12b50](https://github.com/swagger-api/apidom/commit/1b12b50f833cc3e55691d378ef94dd4fd87d7bee)), closes [#3567](https://github.com/swagger-api/apidom/issues/3567)
- **reference:** add Workflows 1.0.0 YAML parser plugin ([#3572](https://github.com/swagger-api/apidom/issues/3572)) ([7e4ba45](https://github.com/swagger-api/apidom/commit/7e4ba451a986f32edbe3ec3f8035685447c038eb))

# [0.89.0](https://github.com/swagger-api/apidom/compare/v0.88.0...v0.89.0) (2023-12-19)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.88.0](https://github.com/swagger-api/apidom/compare/v0.87.0...v0.88.0) (2023-12-15)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.87.0](https://github.com/swagger-api/apidom/compare/v0.86.0...v0.87.0) (2023-12-12)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.86.0](https://github.com/swagger-api/apidom/compare/v0.85.0...v0.86.0) (2023-12-05)

### Features

- **reference:** add code infrastructure for bundle feature ([#3488](https://github.com/swagger-api/apidom/issues/3488)) ([29a4d51](https://github.com/swagger-api/apidom/commit/29a4d51bbc5cc3563c07b7f2ed287f7e6b15102b)), closes [#692](https://github.com/swagger-api/apidom/issues/692)

# [0.85.0](https://github.com/swagger-api/apidom/compare/v0.84.0...v0.85.0) (2023-11-30)

### Bug Fixes

- **reference:** fix internal/external URL determination for AsyncAPI 2.x ([#3453](https://github.com/swagger-api/apidom/issues/3453)) ([3cc0791](https://github.com/swagger-api/apidom/commit/3cc0791464ecc1f8e534aa7e6f19124ae8017b0d)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** fix internal/external URL determination for OpenAPI 2.0 ([#3454](https://github.com/swagger-api/apidom/issues/3454)) ([c720584](https://github.com/swagger-api/apidom/commit/c7205840e5ef1d107b3855ee1ef597cc5121d173)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** fix internal/external URL determination for OpenAPI 3.0.x ([#3455](https://github.com/swagger-api/apidom/issues/3455)) ([bac4850](https://github.com/swagger-api/apidom/commit/bac4850abfe6c61c14eba2735fffab12ee7765bf)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** fix internal/extrernal URL determ for OpenAPI 3.1.0 ([#3459](https://github.com/swagger-api/apidom/issues/3459)) ([2215480](https://github.com/swagger-api/apidom/commit/22154805c4906a08af5c06650bbdc0d80f9e3239)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)
- **reference:** lazy fetch URLs only when needed ([#3464](https://github.com/swagger-api/apidom/issues/3464)) ([222e3f0](https://github.com/swagger-api/apidom/commit/222e3f03b1cda9ca187a8b8292af48f3572419d3)), closes [#3451](https://github.com/swagger-api/apidom/issues/3451)

### Features

- **reference:** add OpenAPI 2.0 resolve strategy ([#3465](https://github.com/swagger-api/apidom/issues/3465)) ([8d968ae](https://github.com/swagger-api/apidom/commit/8d968aef0bd3d6f2a166764dbcce43a0aa7c5ac2)), closes [#3101](https://github.com/swagger-api/apidom/issues/3101)

# [0.84.0](https://github.com/swagger-api/apidom/compare/v0.83.0...v0.84.0) (2023-11-24)

### Features

- **reference:** add OpenAPI 2.0 dereference strategy ([#3435](https://github.com/swagger-api/apidom/issues/3435)) ([aa3710b](https://github.com/swagger-api/apidom/commit/aa3710be00fef5ecc177c7d9e2ae570a077e8b68)), closes [#3102](https://github.com/swagger-api/apidom/issues/3102)

# [0.83.0](https://github.com/swagger-api/apidom/compare/v0.82.2...v0.83.0) (2023-11-07)

### Bug Fixes

- **reference:** fix handling cycles in all dereference strategies ([#3361](https://github.com/swagger-api/apidom/issues/3361)) ([d84397c](https://github.com/swagger-api/apidom/commit/d84397c5371cac7b255c6e8c751cd2c14a23f302))

## [0.82.2](https://github.com/swagger-api/apidom/compare/v0.82.1...v0.82.2) (2023-11-03)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.82.1](https://github.com/swagger-api/apidom/compare/v0.82.0...v0.82.1) (2023-11-03)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.82.0](https://github.com/swagger-api/apidom/compare/v0.81.0...v0.82.0) (2023-11-01)

### Features

- **reference:** add OpenAPI 2.0 JSON parser plugin ([#3343](https://github.com/swagger-api/apidom/issues/3343)) ([70f345d](https://github.com/swagger-api/apidom/commit/70f345d3836bde9ab6923e20a6f21ed80c9d2609)), closes [#3100](https://github.com/swagger-api/apidom/issues/3100)
- **reference:** add OpenAPI 2.0 YAML parser plugin ([#3344](https://github.com/swagger-api/apidom/issues/3344)) ([ed60acc](https://github.com/swagger-api/apidom/commit/ed60accd16e5ce18f0a46f3a44c2e1b9e8196bba)), closes [#3100](https://github.com/swagger-api/apidom/issues/3100)

# [0.81.0](https://github.com/swagger-api/apidom/compare/v0.80.0...v0.81.0) (2023-10-30)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.80.0](https://github.com/swagger-api/apidom/compare/v0.79.0...v0.80.0) (2023-10-26)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.79.0](https://github.com/swagger-api/apidom/compare/v0.78.0...v0.79.0) (2023-10-24)

### Features

- **predicates:** implement TypeScript type guards ([#3289](https://github.com/swagger-api/apidom/issues/3289)) ([0cae70a](https://github.com/swagger-api/apidom/commit/0cae70aa3edc17ecc628c21e30a6b2ac1e992372)), closes [#3280](https://github.com/swagger-api/apidom/issues/3280)

# [0.78.0](https://github.com/swagger-api/apidom/compare/v0.77.0...v0.78.0) (2023-10-17)

### Bug Fixes

- **reference:** avoid double encoding special characters in url.sanitize() ([#3271](https://github.com/swagger-api/apidom/issues/3271)) ([60eb1f4](https://github.com/swagger-api/apidom/commit/60eb1f41f522445fb44b8aa61d65edfbfc9f35bb)), closes [#3270](https://github.com/swagger-api/apidom/issues/3270)
- **types:** fix regression in @types/ramda@0.29.6 ([#3281](https://github.com/swagger-api/apidom/issues/3281)) ([c6c279f](https://github.com/swagger-api/apidom/commit/c6c279f526e07b16221d8c00dd0041eeb93e1290)), closes [#3279](https://github.com/swagger-api/apidom/issues/3279)

# [0.77.0](https://github.com/swagger-api/apidom/compare/v0.76.2...v0.77.0) (2023-10-03)

### Bug Fixes

- **core:** always perform immutable async traversal ([#3164](https://github.com/swagger-api/apidom/issues/3164)) ([a47f870](https://github.com/swagger-api/apidom/commit/a47f87018fcca235bd1490e1f014bcdd2430b2d5)), closes [#3110](https://github.com/swagger-api/apidom/issues/3110)
- **reference:** fix how OpenAPI 3.1.0 Reference Object is merged ([#3215](https://github.com/swagger-api/apidom/issues/3215)) ([77a6823](https://github.com/swagger-api/apidom/commit/77a68230035cbbdd5b1042b65f16733864868454))

## [0.76.2](https://github.com/swagger-api/apidom/compare/v0.76.1...v0.76.2) (2023-09-08)

### Bug Fixes

- **build:** apply polyfills with transform runtime babel plugin ([#3132](https://github.com/swagger-api/apidom/issues/3132)) ([4b4754d](https://github.com/swagger-api/apidom/commit/4b4754da33a4a25d47f926c8a14b59cfdfa6b50c))

## [0.76.1](https://github.com/swagger-api/apidom/compare/v0.76.0...v0.76.1) (2023-09-07)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.76.0](https://github.com/swagger-api/apidom/compare/v0.75.0...v0.76.0) (2023-09-01)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.75.0](https://github.com/swagger-api/apidom/compare/v0.74.1...v0.75.0) (2023-08-22)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.74.1](https://github.com/swagger-api/apidom/compare/v0.74.0...v0.74.1) (2023-07-28)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.74.0](https://github.com/swagger-api/apidom/compare/v0.73.0...v0.74.0) (2023-07-24)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.73.0](https://github.com/swagger-api/apidom/compare/v0.72.0...v0.73.0) (2023-07-18)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.72.0](https://github.com/swagger-api/apidom/compare/v0.71.1...v0.72.0) (2023-07-17)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.71.1](https://github.com/swagger-api/apidom/compare/v0.71.0...v0.71.1) (2023-07-14)

### Reverts

- use babel plugin to capture error causes ([#2951](https://github.com/swagger-api/apidom/issues/2951)) ([e31fcae](https://github.com/swagger-api/apidom/commit/e31fcaea4b0238cabc3c0f97bc2d610f75ad56a5))

# [0.71.0](https://github.com/swagger-api/apidom/compare/v0.70.4...v0.71.0) (2023-07-13)

### Features

- **reference:** support native fragment deref/resolve - AsyncAPI 2.x ([#2945](https://github.com/swagger-api/apidom/issues/2945)) ([2b75f78](https://github.com/swagger-api/apidom/commit/2b75f785b21ff02605fb10d24865b876ffd4281a)), closes [#2934](https://github.com/swagger-api/apidom/issues/2934)
- **reference:** support native fragment deref/resolve - OpenAPI 3.1 / Path Item Object ([d7f82ee](https://github.com/swagger-api/apidom/commit/d7f82eec9ed80498f8d156a195042c5d6420027e)), closes [#2934](https://github.com/swagger-api/apidom/issues/2934)
- **reference:** support native fragment deref/resolve - OpenAPI 3.1 / Reference Object ([#2942](https://github.com/swagger-api/apidom/issues/2942)) ([c5520ef](https://github.com/swagger-api/apidom/commit/c5520efec7eda8e7525afedc9ebd4a592fbafc9e)), closes [#2934](https://github.com/swagger-api/apidom/issues/2934)
- **reference:** support native fragment deref/resolve - Schema Object ([#2941](https://github.com/swagger-api/apidom/issues/2941)) ([689b63a](https://github.com/swagger-api/apidom/commit/689b63a92a6ec2268422db0af2da1edc4c57a592)), closes [#2934](https://github.com/swagger-api/apidom/issues/2934)

## [0.70.4](https://github.com/swagger-api/apidom/compare/v0.70.3...v0.70.4) (2023-06-28)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.70.3](https://github.com/swagger-api/apidom/compare/v0.70.2...v0.70.3) (2023-06-27)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.70.2](https://github.com/swagger-api/apidom/compare/v0.70.1...v0.70.2) (2023-06-16)

### Performance Improvements

- **reference:** add caching capability for OpenAPI 3.1 uri selector ([#2869](https://github.com/swagger-api/apidom/issues/2869)) ([439764f](https://github.com/swagger-api/apidom/commit/439764f51efef4f810bf0f4a73c7c72278d4240a)), closes [#2867](https://github.com/swagger-api/apidom/issues/2867)

## [0.70.1](https://github.com/swagger-api/apidom/compare/v0.70.0...v0.70.1) (2023-06-15)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.70.0](https://github.com/swagger-api/apidom/compare/v0.69.3...v0.70.0) (2023-05-23)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.69.3](https://github.com/swagger-api/apidom/compare/v0.69.2...v0.69.3) (2023-04-27)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.69.2](https://github.com/swagger-api/apidom/compare/v0.69.1...v0.69.2) (2023-04-03)

### Bug Fixes

- **reference:** use parent in ancestors lineage ([#2675](https://github.com/swagger-api/apidom/issues/2675)) ([9498f41](https://github.com/swagger-api/apidom/commit/9498f414cc0ba011ad0214e118aeacbbc46251e5))

## [0.69.1](https://github.com/swagger-api/apidom/compare/v0.69.0...v0.69.1) (2023-03-28)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.69.0](https://github.com/swagger-api/apidom/compare/v0.68.1...v0.69.0) (2023-02-28)

### Features

- add support for publishing to npmjs.com ([#2597](https://github.com/swagger-api/apidom/issues/2597)) ([5ac3cd9](https://github.com/swagger-api/apidom/commit/5ac3cd9a83bbe3b4ce2fac732633fb179cd9747f)), closes [#2290](https://github.com/swagger-api/apidom/issues/2290)
- **reference:** mark the deps from saturated config as optional ([#2591](https://github.com/swagger-api/apidom/issues/2591)) ([28ff997](https://github.com/swagger-api/apidom/commit/28ff99776580c4a8f17218bdb8f02e838cd6c665)), closes [#2590](https://github.com/swagger-api/apidom/issues/2590)

## [0.68.1](https://github.com/swagger-api/apidom/compare/v0.68.0...v0.68.1) (2023-02-20)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.68.0](https://github.com/swagger-api/apidom/compare/v0.67.1...v0.68.0) (2023-02-16)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.67.1](https://github.com/swagger-api/apidom/compare/v0.67.0...v0.67.1) (2023-02-15)

### Bug Fixes

- **deps:** relax @babel/runtime-corejs3 version ([#2563](https://github.com/swagger-api/apidom/issues/2563)) ([3523a14](https://github.com/swagger-api/apidom/commit/3523a145a8390bb85139d9a8c3919b0c4ef75962)), closes [#2562](https://github.com/swagger-api/apidom/issues/2562)
- **reference:** fix extension of native errors ([#2565](https://github.com/swagger-api/apidom/issues/2565)) ([afd8905](https://github.com/swagger-api/apidom/commit/afd8905fffd966f223b3d8fb696b65c1ec82a78e)), closes [#2561](https://github.com/swagger-api/apidom/issues/2561)
- **reference:** use JavaScript error cause interface ([#2564](https://github.com/swagger-api/apidom/issues/2564)) ([f2e1b51](https://github.com/swagger-api/apidom/commit/f2e1b51b5477f86edec084d40159a2fc03de17f6)), closes [#2561](https://github.com/swagger-api/apidom/issues/2561)

# [0.67.0](https://github.com/swagger-api/apidom/compare/v0.66.0...v0.67.0) (2023-02-07)

### Features

- **reference:** add support for AsyncAPI 2.6.0 ([#2537](https://github.com/swagger-api/apidom/issues/2537)) ([36cbf2f](https://github.com/swagger-api/apidom/commit/36cbf2f730723996e61f111ca6cac1d76da26327)), closes [#2520](https://github.com/swagger-api/apidom/issues/2520)

# [0.66.0](https://github.com/swagger-api/apidom/compare/v0.65.0...v0.66.0) (2023-01-25)

### Features

- **reference:** export DereferenceStrategy symbol ([#2499](https://github.com/swagger-api/apidom/issues/2499)) ([3d6016d](https://github.com/swagger-api/apidom/commit/3d6016d909706a48f6e637c3fee3eec098f17c5e))

# [0.65.0](https://github.com/swagger-api/apidom/compare/v0.64.0...v0.65.0) (2023-01-20)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.64.0](https://github.com/swagger-api/apidom/compare/v0.63.1...v0.64.0) (2023-01-16)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.63.1](https://github.com/swagger-api/apidom/compare/v0.63.0...v0.63.1) (2023-01-10)

### Bug Fixes

- **reference:** avoid infinite traversal in AsyncAPI 2.5 dereference ([d4235c9](https://github.com/swagger-api/apidom/commit/d4235c9c77d4783cc95a4d3004a41d788be6a114))
- **reference:** avoid infinite traversal in OpenAPI 3.0 dereference ([9425a67](https://github.com/swagger-api/apidom/commit/9425a678142272e34b7d9794426a941125f5d99c))
- **reference:** avoid infinite traversal in OpenAPI 3.1 dereference ([#2452](https://github.com/swagger-api/apidom/issues/2452)) ([68b4f6b](https://github.com/swagger-api/apidom/commit/68b4f6b6f04a87335093b9941b5a6b6c2492cc87))
- **reference:** fix bug in OpenAPI 3.1.0 Schema Object resolving ([#2445](https://github.com/swagger-api/apidom/issues/2445)) ([5819ac9](https://github.com/swagger-api/apidom/commit/5819ac9c8502d37d3aca950efd83d7f06a68c94d))

# [0.63.0](https://github.com/swagger-api/apidom/compare/v0.62.1...v0.63.0) (2023-01-04)

### Features

- **reference:** add fallbacks for Node.js protocol imports ([#2441](https://github.com/swagger-api/apidom/issues/2441)) ([b8ce5e4](https://github.com/swagger-api/apidom/commit/b8ce5e42c6f4cde89652319323b242827509d605))

## [0.62.1](https://github.com/swagger-api/apidom/compare/v0.62.0...v0.62.1) (2023-01-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.62.0](https://github.com/swagger-api/apidom/compare/v0.61.0...v0.62.0) (2023-01-03)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.61.0](https://github.com/swagger-api/apidom/compare/v0.60.0...v0.61.0) (2022-12-31)

### Bug Fixes

- **reference:** fix values of sideEffects fields of package.json ([#2421](https://github.com/swagger-api/apidom/issues/2421)) ([726852f](https://github.com/swagger-api/apidom/commit/726852f07f055fa29d3d58d850b94e205bf1edd2)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)

### Features

- **reference:** export types for subpath exports in package.json ([#2420](https://github.com/swagger-api/apidom/issues/2420)) ([f5419ea](https://github.com/swagger-api/apidom/commit/f5419eafbd0da3c247ce9ce23441ad7a0307c37e)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)
- **reference:** expose new symbols to compose dereference strategies ([#2424](https://github.com/swagger-api/apidom/issues/2424)) ([a5fe0da](https://github.com/swagger-api/apidom/commit/a5fe0da40418c1b2fcef8a0d1f24a36f5a8ecf80)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)

# [0.60.0](https://github.com/swagger-api/apidom/compare/v0.59.0...v0.60.0) (2022-12-28)

### Features

- **reference:** expose File symbol as public API ([#2418](https://github.com/swagger-api/apidom/issues/2418)) ([e3965f4](https://github.com/swagger-api/apidom/commit/e3965f46999f64daefb4f31e0eed05aadd23cba4)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)
- **reference:** expose HTTPResolver symbol as public API ([#2417](https://github.com/swagger-api/apidom/issues/2417)) ([e101a57](https://github.com/swagger-api/apidom/commit/e101a57efbf4237bce88448722c76f7c7595d71b)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)

# [0.59.0](https://github.com/swagger-api/apidom/compare/v0.58.0...v0.59.0) (2022-12-27)

### Bug Fixes

- **reference:** fix main field ([#2415](https://github.com/swagger-api/apidom/issues/2415)) ([20566dc](https://github.com/swagger-api/apidom/commit/20566dc077d45354913e6bdf82b5f5f4c29f37a3)), closes [#2718](https://github.com/swagger-api/apidom/issues/2718)
- **reference:** fix OpenAPI 3.1 Schema Object resolution ([#2398](https://github.com/swagger-api/apidom/issues/2398)) ([bc3b33a](https://github.com/swagger-api/apidom/commit/bc3b33a95d7d1afb6bfa06136d24cfd8aea8f235))

### Features

- **reference:** separate abstractions from configuration ([#2409](https://github.com/swagger-api/apidom/issues/2409)) ([0bcf972](https://github.com/swagger-api/apidom/commit/0bcf972cb1624cb507aa5a6d67281480b76d2921)), closes [#2718](https://github.com/swagger-api/apidom/issues/2718)

# [0.58.0](https://github.com/swagger-api/apidom/compare/v0.57.0...v0.58.0) (2022-12-16)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.57.0](https://github.com/swagger-api/apidom/compare/v0.56.3...v0.57.0) (2022-12-08)

### Bug Fixes

- **reference:** dereference OpenAPI 3.1 Schema Object indirections ([#2339](https://github.com/swagger-api/apidom/issues/2339)) ([7e42f0c](https://github.com/swagger-api/apidom/commit/7e42f0c6c4954e1298d5bd9b1c94326b041aa644)), closes [#2338](https://github.com/swagger-api/apidom/issues/2338)

### Features

- **reference:** add support for allowMetaPatches option ([#2337](https://github.com/swagger-api/apidom/issues/2337)) ([22c5c7c](https://github.com/swagger-api/apidom/commit/22c5c7cb29e794f90e343d7828d3c8f7b13fdbeb)), closes [#2336](https://github.com/swagger-api/apidom/issues/2336)
- **reference:** add support for useCircularStructures option ([#2329](https://github.com/swagger-api/apidom/issues/2329)) ([de38ac3](https://github.com/swagger-api/apidom/commit/de38ac36dae3b1f5085fd68c12fb64c792099a64)), closes [#2328](https://github.com/swagger-api/apidom/issues/2328)
- **reference:** add swagger-client OpenAPI 3.1 dereferene strategy ([#2326](https://github.com/swagger-api/apidom/issues/2326)) ([40dbf2a](https://github.com/swagger-api/apidom/commit/40dbf2a036517b6b8b23ea9c0a57618f033d6d3c)), closes [#2289](https://github.com/swagger-api/apidom/issues/2289)
- **reference:** add SwaggerClient's HTTP Client resolver plugin ([#2303](https://github.com/swagger-api/apidom/issues/2303)) ([4fda4d8](https://github.com/swagger-api/apidom/commit/4fda4d85ed67e96d339b2cc5c20516e2ebcd862a)), closes [#2297](https://github.com/swagger-api/apidom/issues/2297)

## [0.56.2](https://github.com/swagger-api/apidom/compare/v0.56.1...v0.56.2) (2022-11-16)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.56.1](https://github.com/swagger-api/apidom/compare/v0.56.0...v0.56.1) (2022-11-11)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.56.0](https://github.com/swagger-api/apidom/compare/v0.55.1...v0.56.0) (2022-11-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.55.0](https://github.com/swagger-api/apidom/compare/v0.54.0...v0.55.0) (2022-11-04)

### Features

- **ns-asyncapi-2:** improve types for elements ([#2221](https://github.com/swagger-api/apidom/issues/2221)) ([810c9f9](https://github.com/swagger-api/apidom/commit/810c9f9010ca3b8cbf6d1ee90fcc8f51cdfd71eb)), closes [#2080](https://github.com/swagger-api/apidom/issues/2080)

# [0.54.0](https://github.com/swagger-api/apidom/compare/v0.53.0...v0.54.0) (2022-10-28)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.53.0](https://github.com/swagger-api/apidom/compare/v0.52.0...v0.53.0) (2022-10-27)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.52.0](https://github.com/swagger-api/apidom/compare/v0.51.1...v0.52.0) (2022-10-25)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.51.1](https://github.com/swagger-api/apidom/compare/v0.51.0...v0.51.1) (2022-10-21)

### Bug Fixes

- **reference:** bound options during resolution and parsing ([#2166](https://github.com/swagger-api/apidom/issues/2166)) ([89b946d](https://github.com/swagger-api/apidom/commit/89b946d8c7b28473a6acad67028251eb7d2b030f))

# [0.51.0](https://github.com/swagger-api/apidom/compare/v0.50.0...v0.51.0) (2022-10-20)

### Features

- **reference:** add support for file allow list for FileResolver ([#2159](https://github.com/swagger-api/apidom/issues/2159)) ([e1b914c](https://github.com/swagger-api/apidom/commit/e1b914cd6ed49302d0848647c9e1e9b1128ca560)), closes [#2154](https://github.com/swagger-api/apidom/issues/2154)

### BREAKING CHANGES

- **reference:** FileResolver will not detect and process any local file
  unless explicitly allowed by fileAllowList option

# [0.50.0](https://github.com/swagger-api/apidom/compare/v0.49.0...v0.50.0) (2022-10-13)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.49.0](https://github.com/swagger-api/apidom/compare/v0.48.0...v0.49.0) (2022-10-11)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.48.0](https://github.com/swagger-api/apidom/compare/v0.47.0...v0.48.0) (2022-10-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.47.0](https://github.com/swagger-api/apidom/compare/v0.46.0...v0.47.0) (2022-09-29)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.46.0](https://github.com/swagger-api/apidom/compare/v0.45.0...v0.46.0) (2022-09-21)

### Bug Fixes

- **reference:** decode array buffers using TextDecoder ([#2036](https://github.com/swagger-api/apidom/issues/2036)) ([571e2ed](https://github.com/swagger-api/apidom/commit/571e2ede1bbe16410fb2b5f2337c074f5fff1667)), closes [#2029](https://github.com/swagger-api/apidom/issues/2029)

# [0.45.0](https://github.com/swagger-api/apidom/compare/v0.44.0...v0.45.0) (2022-09-13)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.44.0](https://github.com/swagger-api/apidom/compare/v0.43.0...v0.44.0) (2022-09-05)

### Features

- **playground:** add support for OpenAPI 3.0.x ([#1958](https://github.com/swagger-api/apidom/issues/1958)) ([bfc5445](https://github.com/swagger-api/apidom/commit/bfc5445bb191bd836215e9876b86e11423ffddeb)), closes [#1943](https://github.com/swagger-api/apidom/issues/1943)
- **reference:** add OpenAPI 3.0.x JSON parser plugin ([c15294c](https://github.com/swagger-api/apidom/commit/c15294c12bdf9b869c31a6f831951d6e68bb1e2b)), closes [#1894](https://github.com/swagger-api/apidom/issues/1894)
- **reference:** add OpenAPI 3.0.x resolve strategy ([#1957](https://github.com/swagger-api/apidom/issues/1957)) ([9617cb3](https://github.com/swagger-api/apidom/commit/9617cb32f942b703a7c9099e29c86166e24ed088)), closes [#1895](https://github.com/swagger-api/apidom/issues/1895)
- **reference:** add OpenAPI 3.0.x YAML parser plugin ([0dfbabe](https://github.com/swagger-api/apidom/commit/0dfbabe3cb275dea5a3868f6f6439dffeb037496)), closes [#1894](https://github.com/swagger-api/apidom/issues/1894)
- **referene:** add OpenAPI 3.0.x dereference strategy ([#1955](https://github.com/swagger-api/apidom/issues/1955)) ([6ea5bfd](https://github.com/swagger-api/apidom/commit/6ea5bfd5098581f079fc56f9b3bfe15942f4f37b)), closes [#1896](https://github.com/swagger-api/apidom/issues/1896)

# [0.43.0](https://github.com/swagger-api/apidom/compare/v0.42.0...v0.43.0) (2022-08-31)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.42.0](https://github.com/swagger-api/apidom/compare/v0.41.1...v0.42.0) (2022-08-30)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.41.0](https://github.com/swagger-api/apidom/compare/v0.40.3...v0.41.0) (2022-08-19)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.40.3](https://github.com/swagger-api/apidom/compare/v0.40.2...v0.40.3) (2022-08-08)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.40.2](https://github.com/swagger-api/apidom/compare/v0.40.1...v0.40.2) (2022-08-08)

### Bug Fixes

- **reference:** fix encoding problem with file system paths ([b7696c6](https://github.com/swagger-api/apidom/commit/b7696c6e41c2f9ec5a0cd70fe877ff5f3fed3b95)), closes [#1793](https://github.com/swagger-api/apidom/issues/1793)

# [0.40.0](https://github.com/swagger-api/apidom/compare/v0.39.0...v0.40.0) (2022-08-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.39.0](https://github.com/swagger-api/apidom/compare/v0.38.0...v0.39.0) (2022-07-29)

### Features

- **reference:** add origin support for Channel Item Element ([b126f14](https://github.com/swagger-api/apidom/commit/b126f14e9a0a4ed325066a367694a05710c5c192))
- **reference:** add origin support for ExampleElement ([cf2c82d](https://github.com/swagger-api/apidom/commit/cf2c82d43ca2a7658fc30af38fd4bcfbe2399bd2))
- **reference:** add origin support for LinkElement ([437228a](https://github.com/swagger-api/apidom/commit/437228abe0466ff2efa422560257cbdaca74e546))
- **reference:** add origin support for PathItemElement ([863ae82](https://github.com/swagger-api/apidom/commit/863ae826bf980a5bbf7a598575337272b219ab81))
- **reference:** add origin support for SchemaElement ([d43a20f](https://github.com/swagger-api/apidom/commit/d43a20f527d916962552cab1e5addf74497f7d05))

# [0.38.0](https://github.com/swagger-api/apidom/compare/v0.37.0...v0.38.0) (2022-07-29)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.37.0](https://github.com/swagger-api/apidom/compare/v0.36.0...v0.37.0) (2022-07-29)

### Features

- **reference:** add origin support for ReferenceElement ([#1767](https://github.com/swagger-api/apidom/issues/1767)) ([fc6d091](https://github.com/swagger-api/apidom/commit/fc6d091fe9e9fdc6d4cf8530f8454934e3963dc0))

# [0.36.0](https://github.com/swagger-api/apidom/compare/v0.35.1...v0.36.0) (2022-07-13)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.35.0](https://github.com/swagger-api/apidom/compare/v0.34.0...v0.35.0) (2022-07-05)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.34.0](https://github.com/swagger-api/apidom/compare/v0.33.0...v0.34.0) (2022-07-01)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.33.0](https://github.com/swagger-api/apidom/compare/v0.32.0...v0.33.0) (2022-06-28)

### Features

- **reference:** add configurable interceptors for HttpResolverAxios ([#1680](https://github.com/swagger-api/apidom/issues/1680)) ([3c40bcf](https://github.com/swagger-api/apidom/commit/3c40bcfdc3f85fcb46186c11be6ede8e55c2ed24))

# [0.32.0](https://github.com/swagger-api/apidom/compare/v0.31.2...v0.32.0) (2022-06-27)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.31.2](https://github.com/swagger-api/apidom/compare/v0.31.1...v0.31.2) (2022-06-24)

### Bug Fixes

- **build:** make using minim an implementation detail ([a45009f](https://github.com/swagger-api/apidom/commit/a45009fef5855f3b2fba699c9e4faf560c613443)), closes [#1632](https://github.com/swagger-api/apidom/issues/1632)

## [0.31.1](https://github.com/swagger-api/apidom/compare/v0.31.0...v0.31.1) (2022-06-23)

### Bug Fixes

- **reference:** make FileResolver isomorphic ([#1639](https://github.com/swagger-api/apidom/issues/1639)) ([74c7494](https://github.com/swagger-api/apidom/commit/74c7494c1cb86c2db6360ccdffff27248caba276)), closes [#1633](https://github.com/swagger-api/apidom/issues/1633)

# [0.31.0](https://github.com/swagger-api/apidom/compare/v0.30.1...v0.31.0) (2022-06-21)

### Bug Fixes

- **build:** get rid of using blobal Buffer symbol ([#1607](https://github.com/swagger-api/apidom/issues/1607)) ([0db7685](https://github.com/swagger-api/apidom/commit/0db768510d6595da634cd7464a6a15c40af42490)), closes [#1606](https://github.com/swagger-api/apidom/issues/1606)

### Features

- **reference:** add support for API Design Systems ([#1605](https://github.com/swagger-api/apidom/issues/1605)) ([7d2b062](https://github.com/swagger-api/apidom/commit/7d2b0620f9dcaf5da763337aa94d8b33d29f131f)), closes [#1603](https://github.com/swagger-api/apidom/issues/1603)
- **reference:** unify spec/format detection with adapters ([#1615](https://github.com/swagger-api/apidom/issues/1615)) ([57f07e0](https://github.com/swagger-api/apidom/commit/57f07e0c9fc9eeebbcdfec33d82bbeb7cd380afa)), closes [#1604](https://github.com/swagger-api/apidom/issues/1604)
- **reference:** use smart spec/format detection with parser plugins ([#1617](https://github.com/swagger-api/apidom/issues/1617)) ([ed5f6e4](https://github.com/swagger-api/apidom/commit/ed5f6e461c8d58e9f10f7b6ec88c6f0d97b87f53)), closes [#1604](https://github.com/swagger-api/apidom/issues/1604)

## [0.30.1](https://github.com/swagger-api/apidom/compare/v0.30.0...v0.30.1) (2022-06-09)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.30.0](https://github.com/swagger-api/apidom/compare/v0.29.1...v0.30.0) (2022-06-07)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.29.1](https://github.com/swagger-api/apidom/compare/v0.29.0...v0.29.1) (2022-06-03)

### Bug Fixes

- **reference:** allow passing custom resolver opts ([#1535](https://github.com/swagger-api/apidom/issues/1535)) ([2cc8dbd](https://github.com/swagger-api/apidom/commit/2cc8dbd76628a2e800362b38d5649671cd527a9f))

# [0.29.0](https://github.com/swagger-api/apidom/compare/v0.28.0...v0.29.0) (2022-05-27)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.28.0](https://github.com/swagger-api/apidom/compare/v0.27.0...v0.28.0) (2022-05-22)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.27.0](https://github.com/swagger-api/apidom/compare/v0.26.0...v0.27.0) (2022-05-20)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.26.0](https://github.com/swagger-api/apidom/compare/v0.25.0...v0.26.0) (2022-05-20)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.25.0](https://github.com/swagger-api/apidom/compare/v0.24.1...v0.25.0) (2022-05-13)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.24.1](https://github.com/swagger-api/apidom/compare/v0.24.0...v0.24.1) (2022-05-05)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.24.0](https://github.com/swagger-api/apidom/compare/v0.23.0...v0.24.0) (2022-05-03)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.23.0](https://github.com/swagger-api/apidom/compare/v0.22.0...v0.23.0) (2022-04-25)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.22.0](https://github.com/swagger-api/apidom/compare/v0.21.0...v0.22.0) (2022-04-21)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.21.0](https://github.com/swagger-api/apidom/compare/v0.20.1...v0.21.0) (2022-04-18)

### Bug Fixes

- **reference:** enhance OpenAPI 3.1 dereferecing ([4b1bdbe](https://github.com/swagger-api/apidom/commit/4b1bdbee4ef85ee24792948844c0d62093b81b83)), closes [#1336](https://github.com/swagger-api/apidom/issues/1336)
- **reference:** enhance OpenAPI 3.1 resolution ([#1339](https://github.com/swagger-api/apidom/issues/1339)) ([1dff277](https://github.com/swagger-api/apidom/commit/1dff2770b415ad27d0c1f884416ad2971bba7228)), closes [#1337](https://github.com/swagger-api/apidom/issues/1337)

# [0.20.0](https://github.com/swagger-api/apidom/compare/v0.19.0...v0.20.0) (2022-04-11)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.19.0](https://github.com/swagger-api/apidom/compare/v0.18.1...v0.19.0) (2022-03-10)

### Bug Fixes

- **ns-asyncapi-2:** fix bug regarding refracting of Operation.message ([#1239](https://github.com/swagger-api/apidom/issues/1239)) ([f3e744c](https://github.com/swagger-api/apidom/commit/f3e744c9eff5db7ffb665a6240b7b67eb217af43)), closes [#427](https://github.com/swagger-api/apidom/issues/427)

## [0.18.1](https://github.com/swagger-api/apidom/compare/v0.18.0...v0.18.1) (2022-02-16)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.18.0](https://github.com/swagger-api/apidom/compare/v0.17.0...v0.18.0) (2022-02-16)

### Features

- **asyncapi-2:** add support for AsyncAPI 2.2.0 specification ([#1151](https://github.com/swagger-api/apidom/issues/1151)) ([f94c38f](https://github.com/swagger-api/apidom/commit/f94c38fbb26051d1ef9f62a9086533aeef7574c1)), closes [#1130](https://github.com/swagger-api/apidom/issues/1130)
- convert 3 additional packages to ESM modules ([#1185](https://github.com/swagger-api/apidom/issues/1185)) ([b1f314b](https://github.com/swagger-api/apidom/commit/b1f314bb68cb57e18d9e925e0c5191c31faba49a)), closes [#930](https://github.com/swagger-api/apidom/issues/930)

# [0.17.0](https://github.com/swagger-api/apidom/compare/v0.16.0...v0.17.0) (2022-01-14)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.16.0](https://github.com/swagger-api/apidom/compare/v0.15.1...v0.16.0) (2022-01-12)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.15.1](https://github.com/swagger-api/apidom/compare/v0.15.0...v0.15.1) (2021-12-29)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.15.0](https://github.com/swagger-api/apidom/compare/v0.14.0...v0.15.0) (2021-12-10)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.14.0](https://github.com/swagger-api/apidom/compare/v0.13.0...v0.14.0) (2021-12-08)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.13.0](https://github.com/swagger-api/apidom/compare/v0.12.0...v0.13.0) (2021-12-06)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.12.0](https://github.com/swagger-api/apidom/compare/v0.11.0...v0.12.0) (2021-12-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.11.0](https://github.com/swagger-api/apidom/compare/v0.10.0...v0.11.0) (2021-12-02)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.10.0](https://github.com/swagger-api/apidom/compare/v0.9.0...v0.10.0) (2021-11-25)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.9.0](https://github.com/swagger-api/apidom/compare/v0.8.0...v0.9.0) (2021-11-17)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.8.0](https://github.com/swagger-api/apidom/compare/v0.7.0...v0.8.0) (2021-11-15)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.7.0](https://github.com/swagger-api/apidom/compare/v0.6.0...v0.7.0) (2021-11-08)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.6.0](https://github.com/swagger-api/apidom/compare/v0.5.1...v0.6.0) (2021-11-04)

**Note:** Version bump only for package @swagger-api/apidom-reference

## [0.5.1](https://github.com/swagger-api/apidom/compare/v0.5.0...v0.5.1) (2021-11-01)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.5.0](https://github.com/swagger-api/apidom/compare/v0.4.0...v0.5.0) (2021-10-26)

**Note:** Version bump only for package @swagger-api/apidom-reference

# [0.4.0](https://github.com/swagger-api/apidom/compare/v0.3.0...v0.4.0) (2021-10-22)

### Features

- **reference:** expose errors from package ([3fd2bfc](https://github.com/swagger-api/apidom/commit/3fd2bfcc91a46401dabdefc0d6446354bd94ee88)), closes [#798](https://github.com/swagger-api/apidom/issues/798)

# [0.3.0](https://github.com/swagger-api/apidom/compare/v0.2.1...v0.3.0) (2021-10-05)

### Features

- add support for AsyncAPI 2.2.0 specification ([82f0e54](https://github.com/swagger-api/apidom/commit/82f0e543f62d0b013d145e23ebd817cb40097039)), closes [#688](https://github.com/swagger-api/apidom/issues/688)

## [0.2.1](https://github.com/swagger-api/apidom/compare/v0.2.0...v0.2.1) (2021-09-30)

**Note:** Version bump only for package @swagger-api/apidom-reference

# 0.2.0 (2021-09-28)

### Bug Fixes

- **reference:** fix incorrect JSON Schema dereference in OAS 3.1 ([2f1fefa](https://github.com/swagger-api/apidom/commit/2f1fefa948dbe49a80b208a3f6af054346723e8d)), closes [#607](https://github.com/swagger-api/apidom/issues/607)

# 0.1.0 (2021-09-28)

### Bug Fixes

- **reference:** fix incorrect JSON Schema dereference in OAS 3.1 ([2f1fefa](https://github.com/swagger-api/apidom/commit/2f1fefa948dbe49a80b208a3f6af054346723e8d)), closes [#607](https://github.com/swagger-api/apidom/issues/607)
