// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
import { IconName } from '@fortawesome/free-solid-svg-icons';

interface IconListItem {
    id: IconName;
    label: string;
}
export type IconList = IconListItem[];

// This array seems too big for type checking this
// TS2590: Expression produces a union type that is too complex to represent.
//@ts-ignore
export const freeIconsList: IconList = [
    {
        id: '0',
        label: '0',
    },
    {
        id: '1',
        label: '1',
    },
    {
        id: '2',
        label: '2',
    },
    {
        id: '3',
        label: '3',
    },
    {
        id: '4',
        label: '4',
    },
    {
        id: '5',
        label: '5',
    },
    {
        id: '6',
        label: '6',
    },
    {
        id: '7',
        label: '7',
    },
    {
        id: '8',
        label: '8',
    },
    {
        id: '9',
        label: '9',
    },
    {
        id: 'a',
        label: 'A',
    },
    {
        id: 'address-book',
        label: 'Address Book',
    },
    {
        id: 'address-card',
        label: 'Address Card',
    },
    {
        id: 'align-center',
        label: 'Align Center',
    },
    {
        id: 'align-justify',
        label: 'Align Justify',
    },
    {
        id: 'align-left',
        label: 'Align Left',
    },
    {
        id: 'align-right',
        label: 'Align Right',
    },
    {
        id: 'anchor',
        label: 'Anchor',
    },
    {
        id: 'anchor-circle-check',
        label: 'Anchor Circle Check',
    },
    {
        id: 'anchor-circle-exclamation',
        label: 'Anchor Circle Exclamation',
    },
    {
        id: 'anchor-circle-xmark',
        label: 'Anchor Circle Xmark',
    },
    {
        id: 'anchor-lock',
        label: 'Anchor Lock',
    },
    {
        id: 'angle-down',
        label: 'Angle Down',
    },
    {
        id: 'angle-left',
        label: 'Angle Left',
    },
    {
        id: 'angle-right',
        label: 'Angle Right',
    },
    {
        id: 'angles-down',
        label: 'Angles Down',
    },
    {
        id: 'angles-left',
        label: 'Angles Left',
    },
    {
        id: 'angles-right',
        label: 'Angles Right',
    },
    {
        id: 'angles-up',
        label: 'Angles Up',
    },
    {
        id: 'angle-up',
        label: 'Angle Up',
    },
    {
        id: 'ankh',
        label: 'Ankh',
    },
    {
        id: 'apple-whole',
        label: 'Apple Whole',
    },
    {
        id: 'archway',
        label: 'Archway',
    },
    {
        id: 'arrow-down',
        label: 'Arrow Down',
    },
    {
        id: 'arrow-down-1-9',
        label: 'Arrow Down 1 9',
    },
    {
        id: 'arrow-down-9-1',
        label: 'Arrow Down 9 1',
    },
    {
        id: 'arrow-down-a-z',
        label: 'Arrow Down A Z',
    },
    {
        id: 'arrow-down-long',
        label: 'Arrow Down Long',
    },
    {
        id: 'arrow-down-short-wide',
        label: 'Arrow Down Short Wide',
    },
    {
        id: 'arrow-down-up-across-line',
        label: 'Arrow Down Up Across Line',
    },
    {
        id: 'arrow-down-up-lock',
        label: 'Arrow Down Up Lock',
    },
    {
        id: 'arrow-down-wide-short',
        label: 'Arrow Down Wide Short',
    },
    {
        id: 'arrow-down-z-a',
        label: 'Arrow Down Z A',
    },
    {
        id: 'arrow-left',
        label: 'Arrow Left',
    },
    {
        id: 'arrow-left-long',
        label: 'Arrow Left Long',
    },
    {
        id: 'arrow-pointer',
        label: 'Arrow Pointer',
    },
    {
        id: 'arrow-right',
        label: 'Arrow Right',
    },
    {
        id: 'arrow-right-arrow-left',
        label: 'Arrow Right Arrow Left',
    },
    {
        id: 'arrow-right-from-bracket',
        label: 'Arrow Right From Bracket',
    },
    {
        id: 'arrow-right-long',
        label: 'Arrow Right Long',
    },
    {
        id: 'arrow-right-to-bracket',
        label: 'Arrow Right To Bracket',
    },
    {
        id: 'arrow-right-to-city',
        label: 'Arrow Right To City',
    },
    {
        id: 'arrow-rotate-left',
        label: 'Arrow Rotate Left',
    },
    {
        id: 'arrow-rotate-right',
        label: 'Arrow Rotate Right',
    },
    {
        id: 'arrows-down-to-line',
        label: 'Arrows Down To Line',
    },
    {
        id: 'arrows-down-to-people',
        label: 'Arrows Down To People',
    },
    {
        id: 'arrows-left-right',
        label: 'Arrows Left Right',
    },
    {
        id: 'arrows-left-right-to-line',
        label: 'Arrows Left Right To Line',
    },
    {
        id: 'arrows-rotate',
        label: 'Arrows Rotate',
    },
    {
        id: 'arrows-spin',
        label: 'Arrows Spin',
    },
    {
        id: 'arrows-split-up-and-left',
        label: 'Arrows Split Up And Left',
    },
    {
        id: 'arrows-to-circle',
        label: 'Arrows To Circle',
    },
    {
        id: 'arrows-to-dot',
        label: 'Arrows To Dot',
    },
    {
        id: 'arrows-to-eye',
        label: 'Arrows To Eye',
    },
    {
        id: 'arrows-turn-right',
        label: 'Arrows Turn Right',
    },
    {
        id: 'arrows-turn-to-dots',
        label: 'Arrows Turn To Dots',
    },
    {
        id: 'arrows-up-down',
        label: 'Arrows Up Down',
    },
    {
        id: 'arrows-up-down-left-right',
        label: 'Arrows Up Down Left Right',
    },
    {
        id: 'arrows-up-to-line',
        label: 'Arrows Up To Line',
    },
    {
        id: 'arrow-trend-down',
        label: 'Arrow Trend Down',
    },
    {
        id: 'arrow-trend-up',
        label: 'Arrow Trend Up',
    },
    {
        id: 'arrow-turn-down',
        label: 'Arrow Turn Down',
    },
    {
        id: 'arrow-turn-up',
        label: 'Arrow Turn Up',
    },
    {
        id: 'arrow-up',
        label: 'Arrow Up',
    },
    {
        id: 'arrow-up-1-9',
        label: 'Arrow Up 1 9',
    },
    {
        id: 'arrow-up-9-1',
        label: 'Arrow Up 9 1',
    },
    {
        id: 'arrow-up-a-z',
        label: 'Arrow Up A Z',
    },
    {
        id: 'arrow-up-from-bracket',
        label: 'Arrow Up From Bracket',
    },
    {
        id: 'arrow-up-from-ground-water',
        label: 'Arrow Up From Ground Water',
    },
    {
        id: 'arrow-up-from-water-pump',
        label: 'Arrow Up From Water Pump',
    },
    {
        id: 'arrow-up-long',
        label: 'Arrow Up Long',
    },
    {
        id: 'arrow-up-right-dots',
        label: 'Arrow Up Right Dots',
    },
    {
        id: 'arrow-up-right-from-square',
        label: 'Arrow Up Right From Square',
    },
    {
        id: 'arrow-up-short-wide',
        label: 'Arrow Up Short Wide',
    },
    {
        id: 'arrow-up-wide-short',
        label: 'Arrow Up Wide Short',
    },
    {
        id: 'arrow-up-z-a',
        label: 'Arrow Up Z A',
    },
    {
        id: 'asterisk',
        label: 'Asterisk',
    },
    {
        id: 'at',
        label: 'At',
    },
    {
        id: 'atom',
        label: 'Atom',
    },
    {
        id: 'audio-description',
        label: 'Audio Description',
    },
    {
        id: 'austral-sign',
        label: 'Austral Sign',
    },
    {
        id: 'award',
        label: 'Award',
    },
    {
        id: 'b',
        label: 'B',
    },
    {
        id: 'baby',
        label: 'Baby',
    },
    {
        id: 'baby-carriage',
        label: 'Baby Carriage',
    },
    {
        id: 'backward',
        label: 'Backward',
    },
    {
        id: 'backward-fast',
        label: 'Backward Fast',
    },
    {
        id: 'backward-step',
        label: 'Backward Step',
    },
    {
        id: 'bacon',
        label: 'Bacon',
    },
    {
        id: 'bacteria',
        label: 'Bacteria',
    },
    {
        id: 'bacterium',
        label: 'Bacterium',
    },
    {
        id: 'bag-shopping',
        label: 'Bag Shopping',
    },
    {
        id: 'bahai',
        label: 'Bahai',
    },
    {
        id: 'baht-sign',
        label: 'Baht Sign',
    },
    {
        id: 'ban',
        label: 'Ban',
    },
    {
        id: 'bandage',
        label: 'Bandage',
    },
    {
        id: 'bangladeshi-taka-sign',
        label: 'Bangladeshi Taka Sign',
    },
    {
        id: 'ban-smoking',
        label: 'Ban Smoking',
    },
    {
        id: 'barcode',
        label: 'Barcode',
    },
    {
        id: 'bars',
        label: 'Bars',
    },
    {
        id: 'bars-progress',
        label: 'Bars Progress',
    },
    {
        id: 'bars-staggered',
        label: 'Bars Staggered',
    },
    {
        id: 'baseball',
        label: 'Baseball',
    },
    {
        id: 'baseball-bat-ball',
        label: 'Baseball Bat Ball',
    },
    {
        id: 'basketball',
        label: 'Basketball',
    },
    {
        id: 'basket-shopping',
        label: 'Basket Shopping',
    },
    {
        id: 'bath',
        label: 'Bath',
    },
    {
        id: 'battery-empty',
        label: 'Battery Empty',
    },
    {
        id: 'battery-full',
        label: 'Battery Full',
    },
    {
        id: 'battery-half',
        label: 'Battery Half',
    },
    {
        id: 'battery-quarter',
        label: 'Battery Quarter',
    },
    {
        id: 'battery-three-quarters',
        label: 'Battery Three Quarters',
    },
    {
        id: 'bed',
        label: 'Bed',
    },
    {
        id: 'bed-pulse',
        label: 'Bed Pulse',
    },
    {
        id: 'beer-mug-empty',
        label: 'Beer Mug Empty',
    },
    {
        id: 'bell',
        label: 'Bell',
    },
    {
        id: 'bell-concierge',
        label: 'Bell Concierge',
    },
    {
        id: 'bell-slash',
        label: 'Bell Slash',
    },
    {
        id: 'bezier-curve',
        label: 'Bezier Curve',
    },
    {
        id: 'bicycle',
        label: 'Bicycle',
    },
    {
        id: 'binoculars',
        label: 'Binoculars',
    },
    {
        id: 'biohazard',
        label: 'Biohazard',
    },
    {
        id: 'bitcoin-sign',
        label: 'Bitcoin Sign',
    },
    {
        id: 'blender',
        label: 'Blender',
    },
    {
        id: 'blender-phone',
        label: 'Blender Phone',
    },
    {
        id: 'blog',
        label: 'Blog',
    },
    {
        id: 'bold',
        label: 'Bold',
    },
    {
        id: 'bolt',
        label: 'Bolt',
    },
    {
        id: 'bolt-lightning',
        label: 'Bolt Lightning',
    },
    {
        id: 'bomb',
        label: 'Bomb',
    },
    {
        id: 'bone',
        label: 'Bone',
    },
    {
        id: 'bong',
        label: 'Bong',
    },
    {
        id: 'book',
        label: 'Book',
    },
    {
        id: 'book-atlas',
        label: 'Book Atlas',
    },
    {
        id: 'book-bible',
        label: 'Book Bible',
    },
    {
        id: 'book-bookmark',
        label: 'Book Bookmark',
    },
    {
        id: 'book-journal-whills',
        label: 'Book Journal Whills',
    },
    {
        id: 'bookmark',
        label: 'Bookmark',
    },
    {
        id: 'book-medical',
        label: 'Book Medical',
    },
    {
        id: 'book-open',
        label: 'Book Open',
    },
    {
        id: 'book-open-reader',
        label: 'Book Open Reader',
    },
    {
        id: 'book-quran',
        label: 'Book Quran',
    },
    {
        id: 'book-skull',
        label: 'Book Skull',
    },
    {
        id: 'book-tanakh',
        label: 'Book Tanakh',
    },
    {
        id: 'border-all',
        label: 'Border All',
    },
    {
        id: 'border-none',
        label: 'Border None',
    },
    {
        id: 'border-top-left',
        label: 'Border Top Left',
    },
    {
        id: 'bore-hole',
        label: 'Bore Hole',
    },
    {
        id: 'bottle-droplet',
        label: 'Bottle Droplet',
    },
    {
        id: 'bottle-water',
        label: 'Bottle Water',
    },
    {
        id: 'bowl-food',
        label: 'Bowl Food',
    },
    {
        id: 'bowling-ball',
        label: 'Bowling Ball',
    },
    {
        id: 'bowl-rice',
        label: 'Bowl Rice',
    },
    {
        id: 'box',
        label: 'Box',
    },
    {
        id: 'box-archive',
        label: 'Box Archive',
    },
    {
        id: 'boxes-packing',
        label: 'Boxes Packing',
    },
    {
        id: 'boxes-stacked',
        label: 'Boxes Stacked',
    },
    {
        id: 'box-open',
        label: 'Box Open',
    },
    {
        id: 'box-tissue',
        label: 'Box Tissue',
    },
    {
        id: 'braille',
        label: 'Braille',
    },
    {
        id: 'brain',
        label: 'Brain',
    },
    {
        id: 'brazilian-real-sign',
        label: 'Brazilian Real Sign',
    },
    {
        id: 'bread-slice',
        label: 'Bread Slice',
    },
    {
        id: 'bridge',
        label: 'Bridge',
    },
    {
        id: 'bridge-circle-check',
        label: 'Bridge Circle Check',
    },
    {
        id: 'bridge-circle-exclamation',
        label: 'Bridge Circle Exclamation',
    },
    {
        id: 'bridge-circle-xmark',
        label: 'Bridge Circle Xmark',
    },
    {
        id: 'bridge-lock',
        label: 'Bridge Lock',
    },
    {
        id: 'bridge-water',
        label: 'Bridge Water',
    },
    {
        id: 'briefcase',
        label: 'Briefcase',
    },
    {
        id: 'briefcase-medical',
        label: 'Briefcase Medical',
    },
    {
        id: 'broom',
        label: 'Broom',
    },
    {
        id: 'broom-ball',
        label: 'Broom Ball',
    },
    {
        id: 'brush',
        label: 'Brush',
    },
    {
        id: 'bucket',
        label: 'Bucket',
    },
    {
        id: 'bug',
        label: 'Bug',
    },
    {
        id: 'bugs',
        label: 'Bugs',
    },
    {
        id: 'bug-slash',
        label: 'Bug Slash',
    },
    {
        id: 'building',
        label: 'Building',
    },
    {
        id: 'building-circle-arrow-right',
        label: 'Building Circle Arrow Right',
    },
    {
        id: 'building-circle-check',
        label: 'Building Circle Check',
    },
    {
        id: 'building-circle-exclamation',
        label: 'Building Circle Exclamation',
    },
    {
        id: 'building-circle-xmark',
        label: 'Building Circle Xmark',
    },
    {
        id: 'building-columns',
        label: 'Building Columns',
    },
    {
        id: 'building-flag',
        label: 'Building Flag',
    },
    {
        id: 'building-lock',
        label: 'Building Lock',
    },
    {
        id: 'building-ngo',
        label: 'Building Ngo',
    },
    {
        id: 'building-shield',
        label: 'Building Shield',
    },
    {
        id: 'building-un',
        label: 'Building Un',
    },
    {
        id: 'building-user',
        label: 'Building User',
    },
    {
        id: 'building-wheat',
        label: 'Building Wheat',
    },
    {
        id: 'bullhorn',
        label: 'Bullhorn',
    },
    {
        id: 'bullseye',
        label: 'Bullseye',
    },
    {
        id: 'burger',
        label: 'Burger',
    },
    {
        id: 'burst',
        label: 'Burst',
    },
    {
        id: 'bus',
        label: 'Bus',
    },
    {
        id: 'business-time',
        label: 'Business Time',
    },
    {
        id: 'bus-simple',
        label: 'Bus Simple',
    },
    {
        id: 'c',
        label: 'C',
    },
    {
        id: 'cable-car',
        label: 'Cable Car',
    },
    {
        id: 'cake-candles',
        label: 'Cake Candles',
    },
    {
        id: 'calculator',
        label: 'Calculator',
    },
    {
        id: 'calendar',
        label: 'Calendar',
    },
    {
        id: 'calendar-check',
        label: 'Calendar Check',
    },
    {
        id: 'calendar-day',
        label: 'Calendar Day',
    },
    {
        id: 'calendar-days',
        label: 'Calendar Days',
    },
    {
        id: 'calendar-minus',
        label: 'Calendar Minus',
    },
    {
        id: 'calendar-plus',
        label: 'Calendar Plus',
    },
    {
        id: 'calendar-week',
        label: 'Calendar Week',
    },
    {
        id: 'calendar-xmark',
        label: 'Calendar Xmark',
    },
    {
        id: 'camera',
        label: 'Camera',
    },
    {
        id: 'camera-retro',
        label: 'Camera Retro',
    },
    {
        id: 'camera-rotate',
        label: 'Camera Rotate',
    },
    {
        id: 'campground',
        label: 'Campground',
    },
    {
        id: 'candy-cane',
        label: 'Candy Cane',
    },
    {
        id: 'cannabis',
        label: 'Cannabis',
    },
    {
        id: 'capsules',
        label: 'Capsules',
    },
    {
        id: 'car',
        label: 'Car',
    },
    {
        id: 'caravan',
        label: 'Caravan',
    },
    {
        id: 'car-battery',
        label: 'Car Battery',
    },
    {
        id: 'car-burst',
        label: 'Car Burst',
    },
    {
        id: 'caret-down',
        label: 'Caret Down',
    },
    {
        id: 'caret-left',
        label: 'Caret Left',
    },
    {
        id: 'caret-right',
        label: 'Caret Right',
    },
    {
        id: 'caret-up',
        label: 'Caret Up',
    },
    {
        id: 'car-on',
        label: 'Car On',
    },
    {
        id: 'car-rear',
        label: 'Car Rear',
    },
    {
        id: 'carrot',
        label: 'Carrot',
    },
    {
        id: 'car-side',
        label: 'Car Side',
    },
    {
        id: 'cart-arrow-down',
        label: 'Cart Arrow Down',
    },
    {
        id: 'cart-flatbed',
        label: 'Cart Flatbed',
    },
    {
        id: 'cart-flatbed-suitcase',
        label: 'Cart Flatbed Suitcase',
    },
    {
        id: 'cart-plus',
        label: 'Cart Plus',
    },
    {
        id: 'cart-shopping',
        label: 'Cart Shopping',
    },
    {
        id: 'car-tunnel',
        label: 'Car Tunnel',
    },
    {
        id: 'cash-register',
        label: 'Cash Register',
    },
    {
        id: 'cat',
        label: 'Cat',
    },
    {
        id: 'cedi-sign',
        label: 'Cedi Sign',
    },
    {
        id: 'cent-sign',
        label: 'Cent Sign',
    },
    {
        id: 'certificate',
        label: 'Certificate',
    },
    {
        id: 'chair',
        label: 'Chair',
    },
    {
        id: 'chalkboard',
        label: 'Chalkboard',
    },
    {
        id: 'chalkboard-user',
        label: 'Chalkboard User',
    },
    {
        id: 'champagne-glasses',
        label: 'Champagne Glasses',
    },
    {
        id: 'charging-station',
        label: 'Charging Station',
    },
    {
        id: 'chart-area',
        label: 'Chart Area',
    },
    {
        id: 'chart-bar',
        label: 'Chart Bar',
    },
    {
        id: 'chart-column',
        label: 'Chart Column',
    },
    {
        id: 'chart-gantt',
        label: 'Chart Gantt',
    },
    {
        id: 'chart-line',
        label: 'Chart Line',
    },
    {
        id: 'chart-pie',
        label: 'Chart Pie',
    },
    {
        id: 'chart-simple',
        label: 'Chart Simple',
    },
    {
        id: 'check',
        label: 'Check',
    },
    {
        id: 'check-double',
        label: 'Check Double',
    },
    {
        id: 'check-to-slot',
        label: 'Check To Slot',
    },
    {
        id: 'cheese',
        label: 'Cheese',
    },
    {
        id: 'chess',
        label: 'Chess',
    },
    {
        id: 'chess-bishop',
        label: 'Chess Bishop',
    },
    {
        id: 'chess-board',
        label: 'Chess Board',
    },
    {
        id: 'chess-king',
        label: 'Chess King',
    },
    {
        id: 'chess-knight',
        label: 'Chess Knight',
    },
    {
        id: 'chess-pawn',
        label: 'Chess Pawn',
    },
    {
        id: 'chess-queen',
        label: 'Chess Queen',
    },
    {
        id: 'chess-rook',
        label: 'Chess Rook',
    },
    {
        id: 'chevron-down',
        label: 'Chevron Down',
    },
    {
        id: 'chevron-left',
        label: 'Chevron Left',
    },
    {
        id: 'chevron-right',
        label: 'Chevron Right',
    },
    {
        id: 'chevron-up',
        label: 'Chevron Up',
    },
    {
        id: 'child',
        label: 'Child',
    },
    {
        id: 'child-combatant',
        label: 'Child Combatant',
    },
    {
        id: 'child-dress',
        label: 'Child Dress',
    },
    {
        id: 'child-reaching',
        label: 'Child Reaching',
    },
    {
        id: 'children',
        label: 'Children',
    },
    {
        id: 'church',
        label: 'Church',
    },
    {
        id: 'circle',
        label: 'Circle',
    },
    {
        id: 'circle-arrow-down',
        label: 'Circle Arrow Down',
    },
    {
        id: 'circle-arrow-left',
        label: 'Circle Arrow Left',
    },
    {
        id: 'circle-arrow-right',
        label: 'Circle Arrow Right',
    },
    {
        id: 'circle-arrow-up',
        label: 'Circle Arrow Up',
    },
    {
        id: 'circle-check',
        label: 'Circle Check',
    },
    {
        id: 'circle-chevron-down',
        label: 'Circle Chevron Down',
    },
    {
        id: 'circle-chevron-left',
        label: 'Circle Chevron Left',
    },
    {
        id: 'circle-chevron-right',
        label: 'Circle Chevron Right',
    },
    {
        id: 'circle-chevron-up',
        label: 'Circle Chevron Up',
    },
    {
        id: 'circle-dollar-to-slot',
        label: 'Circle Dollar To Slot',
    },
    {
        id: 'circle-dot',
        label: 'Circle Dot',
    },
    {
        id: 'circle-down',
        label: 'Circle Down',
    },
    {
        id: 'circle-exclamation',
        label: 'Circle Exclamation',
    },
    {
        id: 'circle-h',
        label: 'Circle H',
    },
    {
        id: 'circle-half-stroke',
        label: 'Circle Half Stroke',
    },
    {
        id: 'circle-info',
        label: 'Circle Info',
    },
    {
        id: 'circle-left',
        label: 'Circle Left',
    },
    {
        id: 'circle-minus',
        label: 'Circle Minus',
    },
    {
        id: 'circle-nodes',
        label: 'Circle Nodes',
    },
    {
        id: 'circle-notch',
        label: 'Circle Notch',
    },
    {
        id: 'circle-pause',
        label: 'Circle Pause',
    },
    {
        id: 'circle-play',
        label: 'Circle Play',
    },
    {
        id: 'circle-plus',
        label: 'Circle Plus',
    },
    {
        id: 'circle-question',
        label: 'Circle Question',
    },
    {
        id: 'circle-radiation',
        label: 'Circle Radiation',
    },
    {
        id: 'circle-right',
        label: 'Circle Right',
    },
    {
        id: 'circle-stop',
        label: 'Circle Stop',
    },
    {
        id: 'circle-up',
        label: 'Circle Up',
    },
    {
        id: 'circle-user',
        label: 'Circle User',
    },
    {
        id: 'circle-xmark',
        label: 'Circle Xmark',
    },
    {
        id: 'city',
        label: 'City',
    },
    {
        id: 'clapperboard',
        label: 'Clapperboard',
    },
    {
        id: 'clipboard',
        label: 'Clipboard',
    },
    {
        id: 'clipboard-check',
        label: 'Clipboard Check',
    },
    {
        id: 'clipboard-list',
        label: 'Clipboard List',
    },
    {
        id: 'clipboard-question',
        label: 'Clipboard Question',
    },
    {
        id: 'clipboard-user',
        label: 'Clipboard User',
    },
    {
        id: 'clock',
        label: 'Clock',
    },
    {
        id: 'clock-rotate-left',
        label: 'Clock Rotate Left',
    },
    {
        id: 'clone',
        label: 'Clone',
    },
    {
        id: 'closed-captioning',
        label: 'Closed Captioning',
    },
    {
        id: 'cloud',
        label: 'Cloud',
    },
    {
        id: 'cloud-arrow-down',
        label: 'Cloud Arrow Down',
    },
    {
        id: 'cloud-arrow-up',
        label: 'Cloud Arrow Up',
    },
    {
        id: 'cloud-bolt',
        label: 'Cloud Bolt',
    },
    {
        id: 'cloud-meatball',
        label: 'Cloud Meatball',
    },
    {
        id: 'cloud-moon',
        label: 'Cloud Moon',
    },
    {
        id: 'cloud-moon-rain',
        label: 'Cloud Moon Rain',
    },
    {
        id: 'cloud-rain',
        label: 'Cloud Rain',
    },
    {
        id: 'cloud-showers-heavy',
        label: 'Cloud Showers Heavy',
    },
    {
        id: 'cloud-showers-water',
        label: 'Cloud Showers Water',
    },
    {
        id: 'cloud-sun',
        label: 'Cloud Sun',
    },
    {
        id: 'cloud-sun-rain',
        label: 'Cloud Sun Rain',
    },
    {
        id: 'clover',
        label: 'Clover',
    },
    {
        id: 'code',
        label: 'Code',
    },
    {
        id: 'code-branch',
        label: 'Code Branch',
    },
    {
        id: 'code-commit',
        label: 'Code Commit',
    },
    {
        id: 'code-compare',
        label: 'Code Compare',
    },
    {
        id: 'code-fork',
        label: 'Code Fork',
    },
    {
        id: 'code-merge',
        label: 'Code Merge',
    },
    {
        id: 'code-pull-request',
        label: 'Code Pull Request',
    },
    {
        id: 'coins',
        label: 'Coins',
    },
    {
        id: 'colon-sign',
        label: 'Colon Sign',
    },
    {
        id: 'comment',
        label: 'Comment',
    },
    {
        id: 'comment-dollar',
        label: 'Comment Dollar',
    },
    {
        id: 'comment-dots',
        label: 'Comment Dots',
    },
    {
        id: 'comment-medical',
        label: 'Comment Medical',
    },
    {
        id: 'comments',
        label: 'Comments',
    },
    {
        id: 'comments-dollar',
        label: 'Comments Dollar',
    },
    {
        id: 'comment-slash',
        label: 'Comment Slash',
    },
    {
        id: 'comment-sms',
        label: 'Comment Sms',
    },
    {
        id: 'compact-disc',
        label: 'Compact Disc',
    },
    {
        id: 'compass',
        label: 'Compass',
    },
    {
        id: 'compass-drafting',
        label: 'Compass Drafting',
    },
    {
        id: 'compress',
        label: 'Compress',
    },
    {
        id: 'computer',
        label: 'Computer',
    },
    {
        id: 'computer-mouse',
        label: 'Computer Mouse',
    },
    {
        id: 'cookie',
        label: 'Cookie',
    },
    {
        id: 'cookie-bite',
        label: 'Cookie Bite',
    },
    {
        id: 'copy',
        label: 'Copy',
    },
    {
        id: 'copyright',
        label: 'Copyright',
    },
    {
        id: 'couch',
        label: 'Couch',
    },
    {
        id: 'cow',
        label: 'Cow',
    },
    {
        id: 'credit-card',
        label: 'Credit Card',
    },
    {
        id: 'crop',
        label: 'Crop',
    },
    {
        id: 'crop-simple',
        label: 'Crop Simple',
    },
    {
        id: 'cross',
        label: 'Cross',
    },
    {
        id: 'crosshairs',
        label: 'Crosshairs',
    },
    {
        id: 'crow',
        label: 'Crow',
    },
    {
        id: 'crown',
        label: 'Crown',
    },
    {
        id: 'crutch',
        label: 'Crutch',
    },
    {
        id: 'cruzeiro-sign',
        label: 'Cruzeiro Sign',
    },
    {
        id: 'cube',
        label: 'Cube',
    },
    {
        id: 'cubes',
        label: 'Cubes',
    },
    {
        id: 'cubes-stacked',
        label: 'Cubes Stacked',
    },
    {
        id: 'd',
        label: 'D',
    },
    {
        id: 'database',
        label: 'Database',
    },
    {
        id: 'delete-left',
        label: 'Delete Left',
    },
    {
        id: 'democrat',
        label: 'Democrat',
    },
    {
        id: 'desktop',
        label: 'Desktop',
    },
    {
        id: 'dharmachakra',
        label: 'Dharmachakra',
    },
    {
        id: 'diagram-next',
        label: 'Diagram Next',
    },
    {
        id: 'diagram-predecessor',
        label: 'Diagram Predecessor',
    },
    {
        id: 'diagram-project',
        label: 'Diagram Project',
    },
    {
        id: 'diagram-successor',
        label: 'Diagram Successor',
    },
    {
        id: 'diamond',
        label: 'Diamond',
    },
    {
        id: 'diamond-turn-right',
        label: 'Diamond Turn Right',
    },
    {
        id: 'dice',
        label: 'Dice',
    },
    {
        id: 'dice-d20',
        label: 'Dice D20',
    },
    {
        id: 'dice-d6',
        label: 'Dice D6',
    },
    {
        id: 'dice-five',
        label: 'Dice Five',
    },
    {
        id: 'dice-four',
        label: 'Dice Four',
    },
    {
        id: 'dice-one',
        label: 'Dice One',
    },
    {
        id: 'dice-six',
        label: 'Dice Six',
    },
    {
        id: 'dice-three',
        label: 'Dice Three',
    },
    {
        id: 'dice-two',
        label: 'Dice Two',
    },
    {
        id: 'disease',
        label: 'Disease',
    },
    {
        id: 'display',
        label: 'Display',
    },
    {
        id: 'divide',
        label: 'Divide',
    },
    {
        id: 'dna',
        label: 'Dna',
    },
    {
        id: 'dog',
        label: 'Dog',
    },
    {
        id: 'dollar-sign',
        label: 'Dollar Sign',
    },
    {
        id: 'dolly',
        label: 'Dolly',
    },
    {
        id: 'dong-sign',
        label: 'Dong Sign',
    },
    {
        id: 'door-closed',
        label: 'Door Closed',
    },
    {
        id: 'door-open',
        label: 'Door Open',
    },
    {
        id: 'dove',
        label: 'Dove',
    },
    {
        id: 'down-left-and-up-right-to-center',
        label: 'Down Left And Up Right To Center',
    },
    {
        id: 'download',
        label: 'Download',
    },
    {
        id: 'down-long',
        label: 'Down Long',
    },
    {
        id: 'dragon',
        label: 'Dragon',
    },
    {
        id: 'draw-polygon',
        label: 'Draw Polygon',
    },
    {
        id: 'droplet',
        label: 'Droplet',
    },
    {
        id: 'droplet-slash',
        label: 'Droplet Slash',
    },
    {
        id: 'drum',
        label: 'Drum',
    },
    {
        id: 'drum-steelpan',
        label: 'Drum Steelpan',
    },
    {
        id: 'drumstick-bite',
        label: 'Drumstick Bite',
    },
    {
        id: 'dumbbell',
        label: 'Dumbbell',
    },
    {
        id: 'dumpster',
        label: 'Dumpster',
    },
    {
        id: 'dumpster-fire',
        label: 'Dumpster Fire',
    },
    {
        id: 'dungeon',
        label: 'Dungeon',
    },
    {
        id: 'e',
        label: 'E',
    },
    {
        id: 'ear-deaf',
        label: 'Ear Deaf',
    },
    {
        id: 'ear-listen',
        label: 'Ear Listen',
    },
    {
        id: 'earth-africa',
        label: 'Earth Africa',
    },
    {
        id: 'earth-americas',
        label: 'Earth Americas',
    },
    {
        id: 'earth-asia',
        label: 'Earth Asia',
    },
    {
        id: 'earth-europe',
        label: 'Earth Europe',
    },
    {
        id: 'earth-oceania',
        label: 'Earth Oceania',
    },
    {
        id: 'egg',
        label: 'Egg',
    },
    {
        id: 'eject',
        label: 'Eject',
    },
    {
        id: 'elevator',
        label: 'Elevator',
    },
    {
        id: 'ellipsis',
        label: 'Ellipsis',
    },
    {
        id: 'ellipsis-vertical',
        label: 'Ellipsis Vertical',
    },
    {
        id: 'envelope',
        label: 'Envelope',
    },
    {
        id: 'envelope-circle-check',
        label: 'Envelope Circle Check',
    },
    {
        id: 'envelope-open',
        label: 'Envelope Open',
    },
    {
        id: 'envelope-open-text',
        label: 'Envelope Open Text',
    },
    {
        id: 'envelopes-bulk',
        label: 'Envelopes Bulk',
    },
    {
        id: 'equals',
        label: 'Equals',
    },
    {
        id: 'eraser',
        label: 'Eraser',
    },
    {
        id: 'ethernet',
        label: 'Ethernet',
    },
    {
        id: 'euro-sign',
        label: 'Euro Sign',
    },
    {
        id: 'exclamation',
        label: 'Exclamation',
    },
    {
        id: 'expand',
        label: 'Expand',
    },
    {
        id: 'explosion',
        label: 'Explosion',
    },
    {
        id: 'eye',
        label: 'Eye',
    },
    {
        id: 'eye-dropper',
        label: 'Eye Dropper',
    },
    {
        id: 'eye-low-vision',
        label: 'Eye Low Vision',
    },
    {
        id: 'eye-slash',
        label: 'Eye Slash',
    },
    {
        id: 'f',
        label: 'F',
    },
    {
        id: 'face-angry',
        label: 'Face Angry',
    },
    {
        id: 'face-dizzy',
        label: 'Face Dizzy',
    },
    {
        id: 'face-flushed',
        label: 'Face Flushed',
    },
    {
        id: 'face-frown',
        label: 'Face Frown',
    },
    {
        id: 'face-frown-open',
        label: 'Face Frown Open',
    },
    {
        id: 'face-grimace',
        label: 'Face Grimace',
    },
    {
        id: 'face-grin',
        label: 'Face Grin',
    },
    {
        id: 'face-grin-beam',
        label: 'Face Grin Beam',
    },
    {
        id: 'face-grin-beam-sweat',
        label: 'Face Grin Beam Sweat',
    },
    {
        id: 'face-grin-hearts',
        label: 'Face Grin Hearts',
    },
    {
        id: 'face-grin-squint',
        label: 'Face Grin Squint',
    },
    {
        id: 'face-grin-squint-tears',
        label: 'Face Grin Squint Tears',
    },
    {
        id: 'face-grin-stars',
        label: 'Face Grin Stars',
    },
    {
        id: 'face-grin-tears',
        label: 'Face Grin Tears',
    },
    {
        id: 'face-grin-tongue',
        label: 'Face Grin Tongue',
    },
    {
        id: 'face-grin-tongue-squint',
        label: 'Face Grin Tongue Squint',
    },
    {
        id: 'face-grin-tongue-wink',
        label: 'Face Grin Tongue Wink',
    },
    {
        id: 'face-grin-wide',
        label: 'Face Grin Wide',
    },
    {
        id: 'face-grin-wink',
        label: 'Face Grin Wink',
    },
    {
        id: 'face-kiss',
        label: 'Face Kiss',
    },
    {
        id: 'face-kiss-beam',
        label: 'Face Kiss Beam',
    },
    {
        id: 'face-kiss-wink-heart',
        label: 'Face Kiss Wink Heart',
    },
    {
        id: 'face-laugh',
        label: 'Face Laugh',
    },
    {
        id: 'face-laugh-beam',
        label: 'Face Laugh Beam',
    },
    {
        id: 'face-laugh-squint',
        label: 'Face Laugh Squint',
    },
    {
        id: 'face-laugh-wink',
        label: 'Face Laugh Wink',
    },
    {
        id: 'face-meh',
        label: 'Face Meh',
    },
    {
        id: 'face-meh-blank',
        label: 'Face Meh Blank',
    },
    {
        id: 'face-rolling-eyes',
        label: 'Face Rolling Eyes',
    },
    {
        id: 'face-sad-cry',
        label: 'Face Sad Cry',
    },
    {
        id: 'face-sad-tear',
        label: 'Face Sad Tear',
    },
    {
        id: 'face-smile',
        label: 'Face Smile',
    },
    {
        id: 'face-smile-beam',
        label: 'Face Smile Beam',
    },
    {
        id: 'face-smile-wink',
        label: 'Face Smile Wink',
    },
    {
        id: 'face-surprise',
        label: 'Face Surprise',
    },
    {
        id: 'face-tired',
        label: 'Face Tired',
    },
    {
        id: 'fan',
        label: 'Fan',
    },
    {
        id: 'faucet',
        label: 'Faucet',
    },
    {
        id: 'faucet-drip',
        label: 'Faucet Drip',
    },
    {
        id: 'fax',
        label: 'Fax',
    },
    {
        id: 'feather',
        label: 'Feather',
    },
    {
        id: 'feather-pointed',
        label: 'Feather Pointed',
    },
    {
        id: 'ferry',
        label: 'Ferry',
    },
    {
        id: 'file',
        label: 'File',
    },
    {
        id: 'file-arrow-down',
        label: 'File Arrow Down',
    },
    {
        id: 'file-arrow-up',
        label: 'File Arrow Up',
    },
    {
        id: 'file-audio',
        label: 'File Audio',
    },
    {
        id: 'file-circle-check',
        label: 'File Circle Check',
    },
    {
        id: 'file-circle-exclamation',
        label: 'File Circle Exclamation',
    },
    {
        id: 'file-circle-minus',
        label: 'File Circle Minus',
    },
    {
        id: 'file-circle-plus',
        label: 'File Circle Plus',
    },
    {
        id: 'file-circle-question',
        label: 'File Circle Question',
    },
    {
        id: 'file-circle-xmark',
        label: 'File Circle Xmark',
    },
    {
        id: 'file-code',
        label: 'File Code',
    },
    {
        id: 'file-contract',
        label: 'File Contract',
    },
    {
        id: 'file-csv',
        label: 'File Csv',
    },
    {
        id: 'file-excel',
        label: 'File Excel',
    },
    {
        id: 'file-export',
        label: 'File Export',
    },
    {
        id: 'file-image',
        label: 'File Image',
    },
    {
        id: 'file-import',
        label: 'File Import',
    },
    {
        id: 'file-invoice',
        label: 'File Invoice',
    },
    {
        id: 'file-invoice-dollar',
        label: 'File Invoice Dollar',
    },
    {
        id: 'file-lines',
        label: 'File Lines',
    },
    {
        id: 'file-medical',
        label: 'File Medical',
    },
    {
        id: 'file-pdf',
        label: 'File Pdf',
    },
    {
        id: 'file-pen',
        label: 'File Pen',
    },
    {
        id: 'file-powerpoint',
        label: 'File Powerpoint',
    },
    {
        id: 'file-prescription',
        label: 'File Prescription',
    },
    {
        id: 'file-shield',
        label: 'File Shield',
    },
    {
        id: 'file-signature',
        label: 'File Signature',
    },
    {
        id: 'file-video',
        label: 'File Video',
    },
    {
        id: 'file-waveform',
        label: 'File Waveform',
    },
    {
        id: 'file-word',
        label: 'File Word',
    },
    {
        id: 'file-zipper',
        label: 'File Zipper',
    },
    {
        id: 'fill',
        label: 'Fill',
    },
    {
        id: 'fill-drip',
        label: 'Fill Drip',
    },
    {
        id: 'film',
        label: 'Film',
    },
    {
        id: 'filter',
        label: 'Filter',
    },
    {
        id: 'filter-circle-dollar',
        label: 'Filter Circle Dollar',
    },
    {
        id: 'filter-circle-xmark',
        label: 'Filter Circle Xmark',
    },
    {
        id: 'fingerprint',
        label: 'Fingerprint',
    },
    {
        id: 'fire',
        label: 'Fire',
    },
    {
        id: 'fire-burner',
        label: 'Fire Burner',
    },
    {
        id: 'fire-extinguisher',
        label: 'Fire Extinguisher',
    },
    {
        id: 'fire-flame-curved',
        label: 'Fire Flame Curved',
    },
    {
        id: 'fire-flame-simple',
        label: 'Fire Flame Simple',
    },
    {
        id: 'fish',
        label: 'Fish',
    },
    {
        id: 'fish-fins',
        label: 'Fish Fins',
    },
    {
        id: 'flag',
        label: 'Flag',
    },
    {
        id: 'flag-checkered',
        label: 'Flag Checkered',
    },
    {
        id: 'flag-usa',
        label: 'Flag Usa',
    },
    {
        id: 'flask',
        label: 'Flask',
    },
    {
        id: 'flask-vial',
        label: 'Flask Vial',
    },
    {
        id: 'floppy-disk',
        label: 'Floppy Disk',
    },
    {
        id: 'florin-sign',
        label: 'Florin Sign',
    },
    {
        id: 'folder',
        label: 'Folder',
    },
    {
        id: 'folder-closed',
        label: 'Folder Closed',
    },
    {
        id: 'folder-minus',
        label: 'Folder Minus',
    },
    {
        id: 'folder-open',
        label: 'Folder Open',
    },
    {
        id: 'folder-plus',
        label: 'Folder Plus',
    },
    {
        id: 'folder-tree',
        label: 'Folder Tree',
    },
    {
        id: 'font',
        label: 'Font',
    },
    {
        id: 'football',
        label: 'Football',
    },
    {
        id: 'forward',
        label: 'Forward',
    },
    {
        id: 'forward-fast',
        label: 'Forward Fast',
    },
    {
        id: 'forward-step',
        label: 'Forward Step',
    },
    {
        id: 'franc-sign',
        label: 'Franc Sign',
    },
    {
        id: 'frog',
        label: 'Frog',
    },
    {
        id: 'futbol',
        label: 'Futbol',
    },
    {
        id: 'g',
        label: 'G',
    },
    {
        id: 'gamepad',
        label: 'Gamepad',
    },
    {
        id: 'gas-pump',
        label: 'Gas Pump',
    },
    {
        id: 'gauge',
        label: 'Gauge',
    },
    {
        id: 'gauge-high',
        label: 'Gauge High',
    },
    {
        id: 'gauge-simple',
        label: 'Gauge Simple',
    },
    {
        id: 'gauge-simple-high',
        label: 'Gauge Simple High',
    },
    {
        id: 'gavel',
        label: 'Gavel',
    },
    {
        id: 'gear',
        label: 'Gear',
    },
    {
        id: 'gears',
        label: 'Gears',
    },
    {
        id: 'gem',
        label: 'Gem',
    },
    {
        id: 'genderless',
        label: 'Genderless',
    },
    {
        id: 'ghost',
        label: 'Ghost',
    },
    {
        id: 'gift',
        label: 'Gift',
    },
    {
        id: 'gifts',
        label: 'Gifts',
    },
    {
        id: 'glasses',
        label: 'Glasses',
    },
    {
        id: 'glass-water',
        label: 'Glass Water',
    },
    {
        id: 'glass-water-droplet',
        label: 'Glass Water Droplet',
    },
    {
        id: 'globe',
        label: 'Globe',
    },
    {
        id: 'golf-ball-tee',
        label: 'Golf Ball Tee',
    },
    {
        id: 'gopuram',
        label: 'Gopuram',
    },
    {
        id: 'graduation-cap',
        label: 'Graduation Cap',
    },
    {
        id: 'greater-than',
        label: 'Greater Than',
    },
    {
        id: 'greater-than-equal',
        label: 'Greater Than Equal',
    },
    {
        id: 'grip',
        label: 'Grip',
    },
    {
        id: 'grip-lines',
        label: 'Grip Lines',
    },
    {
        id: 'grip-lines-vertical',
        label: 'Grip Lines Vertical',
    },
    {
        id: 'grip-vertical',
        label: 'Grip Vertical',
    },
    {
        id: 'group-arrows-rotate',
        label: 'Group Arrows Rotate',
    },
    {
        id: 'guarani-sign',
        label: 'Guarani Sign',
    },
    {
        id: 'guitar',
        label: 'Guitar',
    },
    {
        id: 'gun',
        label: 'Gun',
    },
    {
        id: 'h',
        label: 'H',
    },
    {
        id: 'hammer',
        label: 'Hammer',
    },
    {
        id: 'hamsa',
        label: 'Hamsa',
    },
    {
        id: 'hand',
        label: 'Hand',
    },
    {
        id: 'hand-back-fist',
        label: 'Hand Back Fist',
    },
    {
        id: 'handcuffs',
        label: 'Handcuffs',
    },
    {
        id: 'hand-dots',
        label: 'Hand Dots',
    },
    {
        id: 'hand-fist',
        label: 'Hand Fist',
    },
    {
        id: 'hand-holding',
        label: 'Hand Holding',
    },
    {
        id: 'hand-holding-dollar',
        label: 'Hand Holding Dollar',
    },
    {
        id: 'hand-holding-droplet',
        label: 'Hand Holding Droplet',
    },
    {
        id: 'hand-holding-hand',
        label: 'Hand Holding Hand',
    },
    {
        id: 'hand-holding-heart',
        label: 'Hand Holding Heart',
    },
    {
        id: 'hand-holding-medical',
        label: 'Hand Holding Medical',
    },
    {
        id: 'hand-lizard',
        label: 'Hand Lizard',
    },
    {
        id: 'hand-middle-finger',
        label: 'Hand Middle Finger',
    },
    {
        id: 'hand-peace',
        label: 'Hand Peace',
    },
    {
        id: 'hand-point-down',
        label: 'Hand Point Down',
    },
    {
        id: 'hand-pointer',
        label: 'Hand Pointer',
    },
    {
        id: 'hand-point-left',
        label: 'Hand Point Left',
    },
    {
        id: 'hand-point-right',
        label: 'Hand Point Right',
    },
    {
        id: 'hand-point-up',
        label: 'Hand Point Up',
    },
    {
        id: 'hands',
        label: 'Hands',
    },
    {
        id: 'hands-asl-interpreting',
        label: 'Hands Asl Interpreting',
    },
    {
        id: 'hands-bound',
        label: 'Hands Bound',
    },
    {
        id: 'hands-bubbles',
        label: 'Hands Bubbles',
    },
    {
        id: 'hand-scissors',
        label: 'Hand Scissors',
    },
    {
        id: 'hands-clapping',
        label: 'Hands Clapping',
    },
    {
        id: 'handshake',
        label: 'Handshake',
    },
    {
        id: 'handshake-angle',
        label: 'Handshake Angle',
    },
    {
        id: 'handshake-simple',
        label: 'Handshake Simple',
    },
    {
        id: 'handshake-simple-slash',
        label: 'Handshake Simple Slash',
    },
    {
        id: 'handshake-slash',
        label: 'Handshake Slash',
    },
    {
        id: 'hands-holding',
        label: 'Hands Holding',
    },
    {
        id: 'hands-holding-child',
        label: 'Hands Holding Child',
    },
    {
        id: 'hands-holding-circle',
        label: 'Hands Holding Circle',
    },
    {
        id: 'hand-sparkles',
        label: 'Hand Sparkles',
    },
    {
        id: 'hand-spock',
        label: 'Hand Spock',
    },
    {
        id: 'hands-praying',
        label: 'Hands Praying',
    },
    {
        id: 'hanukiah',
        label: 'Hanukiah',
    },
    {
        id: 'hard-drive',
        label: 'Hard Drive',
    },
    {
        id: 'hashtag',
        label: 'Hashtag',
    },
    {
        id: 'hat-cowboy',
        label: 'Hat Cowboy',
    },
    {
        id: 'hat-cowboy-side',
        label: 'Hat Cowboy Side',
    },
    {
        id: 'hat-wizard',
        label: 'Hat Wizard',
    },
    {
        id: 'heading',
        label: 'Heading',
    },
    {
        id: 'headphones',
        label: 'Headphones',
    },
    {
        id: 'headphones-simple',
        label: 'Headphones Simple',
    },
    {
        id: 'headset',
        label: 'Headset',
    },
    {
        id: 'head-side-cough',
        label: 'Head Side Cough',
    },
    {
        id: 'head-side-cough-slash',
        label: 'Head Side Cough Slash',
    },
    {
        id: 'head-side-mask',
        label: 'Head Side Mask',
    },
    {
        id: 'head-side-virus',
        label: 'Head Side Virus',
    },
    {
        id: 'heart',
        label: 'Heart',
    },
    {
        id: 'heart-circle-bolt',
        label: 'Heart Circle Bolt',
    },
    {
        id: 'heart-circle-check',
        label: 'Heart Circle Check',
    },
    {
        id: 'heart-circle-exclamation',
        label: 'Heart Circle Exclamation',
    },
    {
        id: 'heart-circle-minus',
        label: 'Heart Circle Minus',
    },
    {
        id: 'heart-circle-plus',
        label: 'Heart Circle Plus',
    },
    {
        id: 'heart-circle-xmark',
        label: 'Heart Circle Xmark',
    },
    {
        id: 'heart-crack',
        label: 'Heart Crack',
    },
    {
        id: 'heart-pulse',
        label: 'Heart Pulse',
    },
    {
        id: 'helicopter',
        label: 'Helicopter',
    },
    {
        id: 'helicopter-symbol',
        label: 'Helicopter Symbol',
    },
    {
        id: 'helmet-safety',
        label: 'Helmet Safety',
    },
    {
        id: 'helmet-un',
        label: 'Helmet Un',
    },
    {
        id: 'highlighter',
        label: 'Highlighter',
    },
    {
        id: 'hill-avalanche',
        label: 'Hill Avalanche',
    },
    {
        id: 'hill-rockslide',
        label: 'Hill Rockslide',
    },
    {
        id: 'hippo',
        label: 'Hippo',
    },
    {
        id: 'hockey-puck',
        label: 'Hockey Puck',
    },
    {
        id: 'holly-berry',
        label: 'Holly Berry',
    },
    {
        id: 'horse',
        label: 'Horse',
    },
    {
        id: 'horse-head',
        label: 'Horse Head',
    },
    {
        id: 'hospital',
        label: 'Hospital',
    },
    {
        id: 'hospital-user',
        label: 'Hospital User',
    },
    {
        id: 'hotdog',
        label: 'Hotdog',
    },
    {
        id: 'hotel',
        label: 'Hotel',
    },
    {
        id: 'hot-tub-person',
        label: 'Hot Tub Person',
    },
    {
        id: 'hourglass',
        label: 'Hourglass',
    },
    {
        id: 'hourglass-end',
        label: 'Hourglass End',
    },
    {
        id: 'hourglass-half',
        label: 'Hourglass Half',
    },
    {
        id: 'hourglass-start',
        label: 'Hourglass Start',
    },
    {
        id: 'house',
        label: 'House',
    },
    {
        id: 'house-chimney',
        label: 'House Chimney',
    },
    {
        id: 'house-chimney-crack',
        label: 'House Chimney Crack',
    },
    {
        id: 'house-chimney-medical',
        label: 'House Chimney Medical',
    },
    {
        id: 'house-chimney-user',
        label: 'House Chimney User',
    },
    {
        id: 'house-chimney-window',
        label: 'House Chimney Window',
    },
    {
        id: 'house-circle-check',
        label: 'House Circle Check',
    },
    {
        id: 'house-circle-exclamation',
        label: 'House Circle Exclamation',
    },
    {
        id: 'house-circle-xmark',
        label: 'House Circle Xmark',
    },
    {
        id: 'house-crack',
        label: 'House Crack',
    },
    {
        id: 'house-fire',
        label: 'House Fire',
    },
    {
        id: 'house-flag',
        label: 'House Flag',
    },
    {
        id: 'house-flood-water',
        label: 'House Flood Water',
    },
    {
        id: 'house-flood-water-circle-arrow-right',
        label: 'House Flood Water Circle Arrow Right',
    },
    {
        id: 'house-laptop',
        label: 'House Laptop',
    },
    {
        id: 'house-lock',
        label: 'House Lock',
    },
    {
        id: 'house-medical',
        label: 'House Medical',
    },
    {
        id: 'house-medical-circle-check',
        label: 'House Medical Circle Check',
    },
    {
        id: 'house-medical-circle-exclamation',
        label: 'House Medical Circle Exclamation',
    },
    {
        id: 'house-medical-circle-xmark',
        label: 'House Medical Circle Xmark',
    },
    {
        id: 'house-medical-flag',
        label: 'House Medical Flag',
    },
    {
        id: 'house-signal',
        label: 'House Signal',
    },
    {
        id: 'house-tsunami',
        label: 'House Tsunami',
    },
    {
        id: 'house-user',
        label: 'House User',
    },
    {
        id: 'hryvnia-sign',
        label: 'Hryvnia Sign',
    },
    {
        id: 'hurricane',
        label: 'Hurricane',
    },
    {
        id: 'i',
        label: 'I',
    },
    {
        id: 'ice-cream',
        label: 'Ice Cream',
    },
    {
        id: 'icicles',
        label: 'Icicles',
    },
    {
        id: 'icons',
        label: 'Icons',
    },
    {
        id: 'i-cursor',
        label: 'I Cursor',
    },
    {
        id: 'id-badge',
        label: 'Id Badge',
    },
    {
        id: 'id-card',
        label: 'Id Card',
    },
    {
        id: 'id-card-clip',
        label: 'Id Card Clip',
    },
    {
        id: 'igloo',
        label: 'Igloo',
    },
    {
        id: 'image',
        label: 'Image',
    },
    {
        id: 'image-portrait',
        label: 'Image Portrait',
    },
    {
        id: 'images',
        label: 'Images',
    },
    {
        id: 'inbox',
        label: 'Inbox',
    },
    {
        id: 'indent',
        label: 'Indent',
    },
    {
        id: 'indian-rupee-sign',
        label: 'Indian Rupee Sign',
    },
    {
        id: 'industry',
        label: 'Industry',
    },
    {
        id: 'infinity',
        label: 'Infinity',
    },
    {
        id: 'info',
        label: 'Info',
    },
    {
        id: 'italic',
        label: 'Italic',
    },
    {
        id: 'j',
        label: 'J',
    },
    {
        id: 'jar',
        label: 'Jar',
    },
    {
        id: 'jar-wheat',
        label: 'Jar Wheat',
    },
    {
        id: 'jedi',
        label: 'Jedi',
    },
    {
        id: 'jet-fighter',
        label: 'Jet Fighter',
    },
    {
        id: 'jet-fighter-up',
        label: 'Jet Fighter Up',
    },
    {
        id: 'joint',
        label: 'Joint',
    },
    {
        id: 'jug-detergent',
        label: 'Jug Detergent',
    },
    {
        id: 'k',
        label: 'K',
    },
    {
        id: 'kaaba',
        label: 'Kaaba',
    },
    {
        id: 'key',
        label: 'Key',
    },
    {
        id: 'keyboard',
        label: 'Keyboard',
    },
    {
        id: 'khanda',
        label: 'Khanda',
    },
    {
        id: 'kip-sign',
        label: 'Kip Sign',
    },
    {
        id: 'kitchen-set',
        label: 'Kitchen Set',
    },
    {
        id: 'kit-medical',
        label: 'Kit Medical',
    },
    {
        id: 'kiwi-bird',
        label: 'Kiwi Bird',
    },
    {
        id: 'l',
        label: 'L',
    },
    {
        id: 'landmark',
        label: 'Landmark',
    },
    {
        id: 'landmark-dome',
        label: 'Landmark Dome',
    },
    {
        id: 'landmark-flag',
        label: 'Landmark Flag',
    },
    {
        id: 'land-mine-on',
        label: 'Land Mine On',
    },
    {
        id: 'language',
        label: 'Language',
    },
    {
        id: 'laptop',
        label: 'Laptop',
    },
    {
        id: 'laptop-code',
        label: 'Laptop Code',
    },
    {
        id: 'laptop-file',
        label: 'Laptop File',
    },
    {
        id: 'laptop-medical',
        label: 'Laptop Medical',
    },
    {
        id: 'lari-sign',
        label: 'Lari Sign',
    },
    {
        id: 'layer-group',
        label: 'Layer Group',
    },
    {
        id: 'leaf',
        label: 'Leaf',
    },
    {
        id: 'left-long',
        label: 'Left Long',
    },
    {
        id: 'left-right',
        label: 'Left Right',
    },
    {
        id: 'lemon',
        label: 'Lemon',
    },
    {
        id: 'less-than',
        label: 'Less Than',
    },
    {
        id: 'less-than-equal',
        label: 'Less Than Equal',
    },
    {
        id: 'life-ring',
        label: 'Life Ring',
    },
    {
        id: 'lightbulb',
        label: 'Lightbulb',
    },
    {
        id: 'lines-leaning',
        label: 'Lines Leaning',
    },
    {
        id: 'link',
        label: 'Link',
    },
    {
        id: 'link-slash',
        label: 'Link Slash',
    },
    {
        id: 'lira-sign',
        label: 'Lira Sign',
    },
    {
        id: 'list',
        label: 'List',
    },
    {
        id: 'list-check',
        label: 'List Check',
    },
    {
        id: 'list-ol',
        label: 'List Ol',
    },
    {
        id: 'list-ul',
        label: 'List Ul',
    },
    {
        id: 'litecoin-sign',
        label: 'Litecoin Sign',
    },
    {
        id: 'location-arrow',
        label: 'Location Arrow',
    },
    {
        id: 'location-crosshairs',
        label: 'Location Crosshairs',
    },
    {
        id: 'location-dot',
        label: 'Location Dot',
    },
    {
        id: 'location-pin',
        label: 'Location Pin',
    },
    {
        id: 'location-pin-lock',
        label: 'Location Pin Lock',
    },
    {
        id: 'lock',
        label: 'Lock',
    },
    {
        id: 'lock-open',
        label: 'Lock Open',
    },
    {
        id: 'locust',
        label: 'Locust',
    },
    {
        id: 'lungs',
        label: 'Lungs',
    },
    {
        id: 'lungs-virus',
        label: 'Lungs Virus',
    },
    {
        id: 'm',
        label: 'M',
    },
    {
        id: 'magnet',
        label: 'Magnet',
    },
    {
        id: 'magnifying-glass',
        label: 'Magnifying Glass',
    },
    {
        id: 'magnifying-glass-arrow-right',
        label: 'Magnifying Glass Arrow Right',
    },
    {
        id: 'magnifying-glass-chart',
        label: 'Magnifying Glass Chart',
    },
    {
        id: 'magnifying-glass-dollar',
        label: 'Magnifying Glass Dollar',
    },
    {
        id: 'magnifying-glass-location',
        label: 'Magnifying Glass Location',
    },
    {
        id: 'magnifying-glass-minus',
        label: 'Magnifying Glass Minus',
    },
    {
        id: 'magnifying-glass-plus',
        label: 'Magnifying Glass Plus',
    },
    {
        id: 'manat-sign',
        label: 'Manat Sign',
    },
    {
        id: 'map',
        label: 'Map',
    },
    {
        id: 'map-location',
        label: 'Map Location',
    },
    {
        id: 'map-location-dot',
        label: 'Map Location Dot',
    },
    {
        id: 'map-pin',
        label: 'Map Pin',
    },
    {
        id: 'marker',
        label: 'Marker',
    },
    {
        id: 'mars',
        label: 'Mars',
    },
    {
        id: 'mars-and-venus',
        label: 'Mars And Venus',
    },
    {
        id: 'mars-and-venus-burst',
        label: 'Mars And Venus Burst',
    },
    {
        id: 'mars-double',
        label: 'Mars Double',
    },
    {
        id: 'mars-stroke',
        label: 'Mars Stroke',
    },
    {
        id: 'mars-stroke-right',
        label: 'Mars Stroke Right',
    },
    {
        id: 'mars-stroke-up',
        label: 'Mars Stroke Up',
    },
    {
        id: 'martini-glass',
        label: 'Martini Glass',
    },
    {
        id: 'martini-glass-citrus',
        label: 'Martini Glass Citrus',
    },
    {
        id: 'martini-glass-empty',
        label: 'Martini Glass Empty',
    },
    {
        id: 'mask',
        label: 'Mask',
    },
    {
        id: 'mask-face',
        label: 'Mask Face',
    },
    {
        id: 'masks-theater',
        label: 'Masks Theater',
    },
    {
        id: 'mask-ventilator',
        label: 'Mask Ventilator',
    },
    {
        id: 'mattress-pillow',
        label: 'Mattress Pillow',
    },
    {
        id: 'maximize',
        label: 'Maximize',
    },
    {
        id: 'medal',
        label: 'Medal',
    },
    {
        id: 'memory',
        label: 'Memory',
    },
    {
        id: 'menorah',
        label: 'Menorah',
    },
    {
        id: 'mercury',
        label: 'Mercury',
    },
    {
        id: 'message',
        label: 'Message',
    },
    {
        id: 'meteor',
        label: 'Meteor',
    },
    {
        id: 'microchip',
        label: 'Microchip',
    },
    {
        id: 'microphone',
        label: 'Microphone',
    },
    {
        id: 'microphone-lines',
        label: 'Microphone Lines',
    },
    {
        id: 'microphone-lines-slash',
        label: 'Microphone Lines Slash',
    },
    {
        id: 'microphone-slash',
        label: 'Microphone Slash',
    },
    {
        id: 'microscope',
        label: 'Microscope',
    },
    {
        id: 'mill-sign',
        label: 'Mill Sign',
    },
    {
        id: 'minimize',
        label: 'Minimize',
    },
    {
        id: 'minus',
        label: 'Minus',
    },
    {
        id: 'mitten',
        label: 'Mitten',
    },
    {
        id: 'mobile',
        label: 'Mobile',
    },
    {
        id: 'mobile-button',
        label: 'Mobile Button',
    },
    {
        id: 'mobile-retro',
        label: 'Mobile Retro',
    },
    {
        id: 'mobile-screen',
        label: 'Mobile Screen',
    },
    {
        id: 'mobile-screen-button',
        label: 'Mobile Screen Button',
    },
    {
        id: 'money-bill',
        label: 'Money Bill',
    },
    {
        id: 'money-bill-1',
        label: 'Money Bill 1',
    },
    {
        id: 'money-bill-1-wave',
        label: 'Money Bill 1 Wave',
    },
    {
        id: 'money-bills',
        label: 'Money Bills',
    },
    {
        id: 'money-bill-transfer',
        label: 'Money Bill Transfer',
    },
    {
        id: 'money-bill-trend-up',
        label: 'Money Bill Trend Up',
    },
    {
        id: 'money-bill-wave',
        label: 'Money Bill Wave',
    },
    {
        id: 'money-bill-wheat',
        label: 'Money Bill Wheat',
    },
    {
        id: 'money-check',
        label: 'Money Check',
    },
    {
        id: 'money-check-dollar',
        label: 'Money Check Dollar',
    },
    {
        id: 'monument',
        label: 'Monument',
    },
    {
        id: 'moon',
        label: 'Moon',
    },
    {
        id: 'mortar-pestle',
        label: 'Mortar Pestle',
    },
    {
        id: 'mosque',
        label: 'Mosque',
    },
    {
        id: 'mosquito',
        label: 'Mosquito',
    },
    {
        id: 'mosquito-net',
        label: 'Mosquito Net',
    },
    {
        id: 'motorcycle',
        label: 'Motorcycle',
    },
    {
        id: 'mound',
        label: 'Mound',
    },
    {
        id: 'mountain',
        label: 'Mountain',
    },
    {
        id: 'mountain-city',
        label: 'Mountain City',
    },
    {
        id: 'mountain-sun',
        label: 'Mountain Sun',
    },
    {
        id: 'mug-hot',
        label: 'Mug Hot',
    },
    {
        id: 'mug-saucer',
        label: 'Mug Saucer',
    },
    {
        id: 'music',
        label: 'Music',
    },
    {
        id: 'n',
        label: 'N',
    },
    {
        id: 'naira-sign',
        label: 'Naira Sign',
    },
    {
        id: 'network-wired',
        label: 'Network Wired',
    },
    {
        id: 'neuter',
        label: 'Neuter',
    },
    {
        id: 'newspaper',
        label: 'Newspaper',
    },
    {
        id: 'notdef',
        label: 'Notdef',
    },
    {
        id: 'not-equal',
        label: 'Not Equal',
    },
    {
        id: 'notes-medical',
        label: 'Notes Medical',
    },
    {
        id: 'note-sticky',
        label: 'Note Sticky',
    },
    {
        id: 'o',
        label: 'O',
    },
    {
        id: 'object-group',
        label: 'Object Group',
    },
    {
        id: 'object-ungroup',
        label: 'Object Ungroup',
    },
    {
        id: 'oil-can',
        label: 'Oil Can',
    },
    {
        id: 'oil-well',
        label: 'Oil Well',
    },
    {
        id: 'om',
        label: 'Om',
    },
    {
        id: 'otter',
        label: 'Otter',
    },
    {
        id: 'outdent',
        label: 'Outdent',
    },
    {
        id: 'p',
        label: 'P',
    },
    {
        id: 'pager',
        label: 'Pager',
    },
    {
        id: 'paintbrush',
        label: 'Paintbrush',
    },
    {
        id: 'paint-roller',
        label: 'Paint Roller',
    },
    {
        id: 'palette',
        label: 'Palette',
    },
    {
        id: 'pallet',
        label: 'Pallet',
    },
    {
        id: 'panorama',
        label: 'Panorama',
    },
    {
        id: 'paperclip',
        label: 'Paperclip',
    },
    {
        id: 'paper-plane',
        label: 'Paper Plane',
    },
    {
        id: 'parachute-box',
        label: 'Parachute Box',
    },
    {
        id: 'paragraph',
        label: 'Paragraph',
    },
    {
        id: 'passport',
        label: 'Passport',
    },
    {
        id: 'paste',
        label: 'Paste',
    },
    {
        id: 'pause',
        label: 'Pause',
    },
    {
        id: 'paw',
        label: 'Paw',
    },
    {
        id: 'peace',
        label: 'Peace',
    },
    {
        id: 'pen',
        label: 'Pen',
    },
    {
        id: 'pencil',
        label: 'Pencil',
    },
    {
        id: 'pen-clip',
        label: 'Pen Clip',
    },
    {
        id: 'pen-fancy',
        label: 'Pen Fancy',
    },
    {
        id: 'pen-nib',
        label: 'Pen Nib',
    },
    {
        id: 'pen-ruler',
        label: 'Pen Ruler',
    },
    {
        id: 'pen-to-square',
        label: 'Pen To Square',
    },
    {
        id: 'people-arrows',
        label: 'People Arrows',
    },
    {
        id: 'people-carry-box',
        label: 'People Carry Box',
    },
    {
        id: 'people-group',
        label: 'People Group',
    },
    {
        id: 'people-line',
        label: 'People Line',
    },
    {
        id: 'people-pulling',
        label: 'People Pulling',
    },
    {
        id: 'people-robbery',
        label: 'People Robbery',
    },
    {
        id: 'people-roof',
        label: 'People Roof',
    },
    {
        id: 'pepper-hot',
        label: 'Pepper Hot',
    },
    {
        id: 'percent',
        label: 'Percent',
    },
    {
        id: 'person',
        label: 'Person',
    },
    {
        id: 'person-arrow-down-to-line',
        label: 'Person Arrow Down To Line',
    },
    {
        id: 'person-arrow-up-from-line',
        label: 'Person Arrow Up From Line',
    },
    {
        id: 'person-biking',
        label: 'Person Biking',
    },
    {
        id: 'person-booth',
        label: 'Person Booth',
    },
    {
        id: 'person-breastfeeding',
        label: 'Person Breastfeeding',
    },
    {
        id: 'person-burst',
        label: 'Person Burst',
    },
    {
        id: 'person-cane',
        label: 'Person Cane',
    },
    {
        id: 'person-chalkboard',
        label: 'Person Chalkboard',
    },
    {
        id: 'person-circle-check',
        label: 'Person Circle Check',
    },
    {
        id: 'person-circle-exclamation',
        label: 'Person Circle Exclamation',
    },
    {
        id: 'person-circle-minus',
        label: 'Person Circle Minus',
    },
    {
        id: 'person-circle-plus',
        label: 'Person Circle Plus',
    },
    {
        id: 'person-circle-question',
        label: 'Person Circle Question',
    },
    {
        id: 'person-circle-xmark',
        label: 'Person Circle Xmark',
    },
    {
        id: 'person-digging',
        label: 'Person Digging',
    },
    {
        id: 'person-dots-from-line',
        label: 'Person Dots From Line',
    },
    {
        id: 'person-dress',
        label: 'Person Dress',
    },
    {
        id: 'person-dress-burst',
        label: 'Person Dress Burst',
    },
    {
        id: 'person-drowning',
        label: 'Person Drowning',
    },
    {
        id: 'person-falling',
        label: 'Person Falling',
    },
    {
        id: 'person-falling-burst',
        label: 'Person Falling Burst',
    },
    {
        id: 'person-half-dress',
        label: 'Person Half Dress',
    },
    {
        id: 'person-harassing',
        label: 'Person Harassing',
    },
    {
        id: 'person-hiking',
        label: 'Person Hiking',
    },
    {
        id: 'person-military-pointing',
        label: 'Person Military Pointing',
    },
    {
        id: 'person-military-rifle',
        label: 'Person Military Rifle',
    },
    {
        id: 'person-military-to-person',
        label: 'Person Military To Person',
    },
    {
        id: 'person-praying',
        label: 'Person Praying',
    },
    {
        id: 'person-pregnant',
        label: 'Person Pregnant',
    },
    {
        id: 'person-rays',
        label: 'Person Rays',
    },
    {
        id: 'person-rifle',
        label: 'Person Rifle',
    },
    {
        id: 'person-running',
        label: 'Person Running',
    },
    {
        id: 'person-shelter',
        label: 'Person Shelter',
    },
    {
        id: 'person-skating',
        label: 'Person Skating',
    },
    {
        id: 'person-skiing',
        label: 'Person Skiing',
    },
    {
        id: 'person-skiing-nordic',
        label: 'Person Skiing Nordic',
    },
    {
        id: 'person-snowboarding',
        label: 'Person Snowboarding',
    },
    {
        id: 'person-swimming',
        label: 'Person Swimming',
    },
    {
        id: 'person-through-window',
        label: 'Person Through Window',
    },
    {
        id: 'person-walking',
        label: 'Person Walking',
    },
    {
        id: 'person-walking-arrow-loop-left',
        label: 'Person Walking Arrow Loop Left',
    },
    {
        id: 'person-walking-arrow-right',
        label: 'Person Walking Arrow Right',
    },
    {
        id: 'person-walking-dashed-line-arrow-right',
        label: 'Person Walking Dashed Line Arrow Right',
    },
    {
        id: 'person-walking-luggage',
        label: 'Person Walking Luggage',
    },
    {
        id: 'person-walking-with-cane',
        label: 'Person Walking With Cane',
    },
    {
        id: 'peseta-sign',
        label: 'Peseta Sign',
    },
    {
        id: 'peso-sign',
        label: 'Peso Sign',
    },
    {
        id: 'phone',
        label: 'Phone',
    },
    {
        id: 'phone-flip',
        label: 'Phone Flip',
    },
    {
        id: 'phone-slash',
        label: 'Phone Slash',
    },
    {
        id: 'phone-volume',
        label: 'Phone Volume',
    },
    {
        id: 'photo-film',
        label: 'Photo Film',
    },
    {
        id: 'piggy-bank',
        label: 'Piggy Bank',
    },
    {
        id: 'pills',
        label: 'Pills',
    },
    {
        id: 'pizza-slice',
        label: 'Pizza Slice',
    },
    {
        id: 'place-of-worship',
        label: 'Place Of Worship',
    },
    {
        id: 'plane',
        label: 'Plane',
    },
    {
        id: 'plane-arrival',
        label: 'Plane Arrival',
    },
    {
        id: 'plane-circle-check',
        label: 'Plane Circle Check',
    },
    {
        id: 'plane-circle-exclamation',
        label: 'Plane Circle Exclamation',
    },
    {
        id: 'plane-circle-xmark',
        label: 'Plane Circle Xmark',
    },
    {
        id: 'plane-departure',
        label: 'Plane Departure',
    },
    {
        id: 'plane-lock',
        label: 'Plane Lock',
    },
    {
        id: 'plane-slash',
        label: 'Plane Slash',
    },
    {
        id: 'plane-up',
        label: 'Plane Up',
    },
    {
        id: 'plant-wilt',
        label: 'Plant Wilt',
    },
    {
        id: 'plate-wheat',
        label: 'Plate Wheat',
    },
    {
        id: 'play',
        label: 'Play',
    },
    {
        id: 'plug',
        label: 'Plug',
    },
    {
        id: 'plug-circle-bolt',
        label: 'Plug Circle Bolt',
    },
    {
        id: 'plug-circle-check',
        label: 'Plug Circle Check',
    },
    {
        id: 'plug-circle-exclamation',
        label: 'Plug Circle Exclamation',
    },
    {
        id: 'plug-circle-minus',
        label: 'Plug Circle Minus',
    },
    {
        id: 'plug-circle-plus',
        label: 'Plug Circle Plus',
    },
    {
        id: 'plug-circle-xmark',
        label: 'Plug Circle Xmark',
    },
    {
        id: 'plus',
        label: 'Plus',
    },
    {
        id: 'plus-minus',
        label: 'Plus Minus',
    },
    {
        id: 'podcast',
        label: 'Podcast',
    },
    {
        id: 'poo',
        label: 'Poo',
    },
    {
        id: 'poop',
        label: 'Poop',
    },
    {
        id: 'poo-storm',
        label: 'Poo Storm',
    },
    {
        id: 'power-off',
        label: 'Power Off',
    },
    {
        id: 'prescription',
        label: 'Prescription',
    },
    {
        id: 'prescription-bottle',
        label: 'Prescription Bottle',
    },
    {
        id: 'prescription-bottle-medical',
        label: 'Prescription Bottle Medical',
    },
    {
        id: 'print',
        label: 'Print',
    },
    {
        id: 'pump-medical',
        label: 'Pump Medical',
    },
    {
        id: 'pump-soap',
        label: 'Pump Soap',
    },
    {
        id: 'puzzle-piece',
        label: 'Puzzle Piece',
    },
    {
        id: 'q',
        label: 'Q',
    },
    {
        id: 'qrcode',
        label: 'Qrcode',
    },
    {
        id: 'question',
        label: 'Question',
    },
    {
        id: 'quote-left',
        label: 'Quote Left',
    },
    {
        id: 'quote-right',
        label: 'Quote Right',
    },
    {
        id: 'r',
        label: 'R',
    },
    {
        id: 'radiation',
        label: 'Radiation',
    },
    {
        id: 'radio',
        label: 'Radio',
    },
    {
        id: 'rainbow',
        label: 'Rainbow',
    },
    {
        id: 'ranking-star',
        label: 'Ranking Star',
    },
    {
        id: 'receipt',
        label: 'Receipt',
    },
    {
        id: 'record-vinyl',
        label: 'Record Vinyl',
    },
    {
        id: 'rectangle-ad',
        label: 'Rectangle Ad',
    },
    {
        id: 'rectangle-list',
        label: 'Rectangle List',
    },
    {
        id: 'rectangle-xmark',
        label: 'Rectangle Xmark',
    },
    {
        id: 'recycle',
        label: 'Recycle',
    },
    {
        id: 'registered',
        label: 'Registered',
    },
    {
        id: 'repeat',
        label: 'Repeat',
    },
    {
        id: 'reply',
        label: 'Reply',
    },
    {
        id: 'reply-all',
        label: 'Reply All',
    },
    {
        id: 'republican',
        label: 'Republican',
    },
    {
        id: 'restroom',
        label: 'Restroom',
    },
    {
        id: 'retweet',
        label: 'Retweet',
    },
    {
        id: 'ribbon',
        label: 'Ribbon',
    },
    {
        id: 'right-from-bracket',
        label: 'Right From Bracket',
    },
    {
        id: 'right-left',
        label: 'Right Left',
    },
    {
        id: 'right-long',
        label: 'Right Long',
    },
    {
        id: 'right-to-bracket',
        label: 'Right To Bracket',
    },
    {
        id: 'ring',
        label: 'Ring',
    },
    {
        id: 'road',
        label: 'Road',
    },
    {
        id: 'road-barrier',
        label: 'Road Barrier',
    },
    {
        id: 'road-bridge',
        label: 'Road Bridge',
    },
    {
        id: 'road-circle-check',
        label: 'Road Circle Check',
    },
    {
        id: 'road-circle-exclamation',
        label: 'Road Circle Exclamation',
    },
    {
        id: 'road-circle-xmark',
        label: 'Road Circle Xmark',
    },
    {
        id: 'road-lock',
        label: 'Road Lock',
    },
    {
        id: 'road-spikes',
        label: 'Road Spikes',
    },
    {
        id: 'robot',
        label: 'Robot',
    },
    {
        id: 'rocket',
        label: 'Rocket',
    },
    {
        id: 'rotate',
        label: 'Rotate',
    },
    {
        id: 'rotate-left',
        label: 'Rotate Left',
    },
    {
        id: 'rotate-right',
        label: 'Rotate Right',
    },
    {
        id: 'route',
        label: 'Route',
    },
    {
        id: 'rss',
        label: 'Rss',
    },
    {
        id: 'ruble-sign',
        label: 'Ruble Sign',
    },
    {
        id: 'rug',
        label: 'Rug',
    },
    {
        id: 'ruler',
        label: 'Ruler',
    },
    {
        id: 'ruler-combined',
        label: 'Ruler Combined',
    },
    {
        id: 'ruler-horizontal',
        label: 'Ruler Horizontal',
    },
    {
        id: 'ruler-vertical',
        label: 'Ruler Vertical',
    },
    {
        id: 'rupee-sign',
        label: 'Rupee Sign',
    },
    {
        id: 'rupiah-sign',
        label: 'Rupiah Sign',
    },
    {
        id: 's',
        label: 'S',
    },
    {
        id: 'sack-dollar',
        label: 'Sack Dollar',
    },
    {
        id: 'sack-xmark',
        label: 'Sack Xmark',
    },
    {
        id: 'sailboat',
        label: 'Sailboat',
    },
    {
        id: 'satellite',
        label: 'Satellite',
    },
    {
        id: 'satellite-dish',
        label: 'Satellite Dish',
    },
    {
        id: 'scale-balanced',
        label: 'Scale Balanced',
    },
    {
        id: 'scale-unbalanced',
        label: 'Scale Unbalanced',
    },
    {
        id: 'scale-unbalanced-flip',
        label: 'Scale Unbalanced Flip',
    },
    {
        id: 'school',
        label: 'School',
    },
    {
        id: 'school-circle-check',
        label: 'School Circle Check',
    },
    {
        id: 'school-circle-exclamation',
        label: 'School Circle Exclamation',
    },
    {
        id: 'school-circle-xmark',
        label: 'School Circle Xmark',
    },
    {
        id: 'school-flag',
        label: 'School Flag',
    },
    {
        id: 'school-lock',
        label: 'School Lock',
    },
    {
        id: 'scissors',
        label: 'Scissors',
    },
    {
        id: 'screwdriver',
        label: 'Screwdriver',
    },
    {
        id: 'screwdriver-wrench',
        label: 'Screwdriver Wrench',
    },
    {
        id: 'scroll',
        label: 'Scroll',
    },
    {
        id: 'scroll-torah',
        label: 'Scroll Torah',
    },
    {
        id: 'sd-card',
        label: 'Sd Card',
    },
    {
        id: 'section',
        label: 'Section',
    },
    {
        id: 'seedling',
        label: 'Seedling',
    },
    {
        id: 'server',
        label: 'Server',
    },
    {
        id: 'shapes',
        label: 'Shapes',
    },
    {
        id: 'share',
        label: 'Share',
    },
    {
        id: 'share-from-square',
        label: 'Share From Square',
    },
    {
        id: 'share-nodes',
        label: 'Share Nodes',
    },
    {
        id: 'sheet-plastic',
        label: 'Sheet Plastic',
    },
    {
        id: 'shekel-sign',
        label: 'Shekel Sign',
    },
    {
        id: 'shield',
        label: 'Shield',
    },
    {
        id: 'shield-cat',
        label: 'Shield Cat',
    },
    {
        id: 'shield-dog',
        label: 'Shield Dog',
    },
    {
        id: 'shield-halved',
        label: 'Shield Halved',
    },
    {
        id: 'shield-heart',
        label: 'Shield Heart',
    },
    {
        id: 'shield-virus',
        label: 'Shield Virus',
    },
    {
        id: 'ship',
        label: 'Ship',
    },
    {
        id: 'shirt',
        label: 'Shirt',
    },
    {
        id: 'shoe-prints',
        label: 'Shoe Prints',
    },
    {
        id: 'shop',
        label: 'Shop',
    },
    {
        id: 'shop-lock',
        label: 'Shop Lock',
    },
    {
        id: 'shop-slash',
        label: 'Shop Slash',
    },
    {
        id: 'shower',
        label: 'Shower',
    },
    {
        id: 'shrimp',
        label: 'Shrimp',
    },
    {
        id: 'shuffle',
        label: 'Shuffle',
    },
    {
        id: 'shuttle-space',
        label: 'Shuttle Space',
    },
    {
        id: 'signal',
        label: 'Signal',
    },
    {
        id: 'signature',
        label: 'Signature',
    },
    {
        id: 'sign-hanging',
        label: 'Sign Hanging',
    },
    {
        id: 'signs-post',
        label: 'Signs Post',
    },
    {
        id: 'sim-card',
        label: 'Sim Card',
    },
    {
        id: 'sink',
        label: 'Sink',
    },
    {
        id: 'sitemap',
        label: 'Sitemap',
    },
    {
        id: 'skull',
        label: 'Skull',
    },
    {
        id: 'skull-crossbones',
        label: 'Skull Crossbones',
    },
    {
        id: 'slash',
        label: 'Slash',
    },
    {
        id: 'sleigh',
        label: 'Sleigh',
    },
    {
        id: 'sliders',
        label: 'Sliders',
    },
    {
        id: 'smog',
        label: 'Smog',
    },
    {
        id: 'smoking',
        label: 'Smoking',
    },
    {
        id: 'snowflake',
        label: 'Snowflake',
    },
    {
        id: 'snowman',
        label: 'Snowman',
    },
    {
        id: 'snowplow',
        label: 'Snowplow',
    },
    {
        id: 'soap',
        label: 'Soap',
    },
    {
        id: 'socks',
        label: 'Socks',
    },
    {
        id: 'solar-panel',
        label: 'Solar Panel',
    },
    {
        id: 'sort',
        label: 'Sort',
    },
    {
        id: 'sort-down',
        label: 'Sort Down',
    },
    {
        id: 'sort-up',
        label: 'Sort Up',
    },
    {
        id: 'spa',
        label: 'Spa',
    },
    {
        id: 'spaghetti-monster-flying',
        label: 'Spaghetti Monster Flying',
    },
    {
        id: 'spell-check',
        label: 'Spell Check',
    },
    {
        id: 'spider',
        label: 'Spider',
    },
    {
        id: 'spinner',
        label: 'Spinner',
    },
    {
        id: 'splotch',
        label: 'Splotch',
    },
    {
        id: 'spoon',
        label: 'Spoon',
    },
    {
        id: 'spray-can',
        label: 'Spray Can',
    },
    {
        id: 'spray-can-sparkles',
        label: 'Spray Can Sparkles',
    },
    {
        id: 'square',
        label: 'Square',
    },
    {
        id: 'square-arrow-up-right',
        label: 'Square Arrow Up Right',
    },
    {
        id: 'square-caret-down',
        label: 'Square Caret Down',
    },
    {
        id: 'square-caret-left',
        label: 'Square Caret Left',
    },
    {
        id: 'square-caret-right',
        label: 'Square Caret Right',
    },
    {
        id: 'square-caret-up',
        label: 'Square Caret Up',
    },
    {
        id: 'square-check',
        label: 'Square Check',
    },
    {
        id: 'square-envelope',
        label: 'Square Envelope',
    },
    {
        id: 'square-full',
        label: 'Square Full',
    },
    {
        id: 'square-h',
        label: 'Square H',
    },
    {
        id: 'square-minus',
        label: 'Square Minus',
    },
    {
        id: 'square-nfi',
        label: 'Square Nfi',
    },
    {
        id: 'square-parking',
        label: 'Square Parking',
    },
    {
        id: 'square-pen',
        label: 'Square Pen',
    },
    {
        id: 'square-person-confined',
        label: 'Square Person Confined',
    },
    {
        id: 'square-phone',
        label: 'Square Phone',
    },
    {
        id: 'square-phone-flip',
        label: 'Square Phone Flip',
    },
    {
        id: 'square-plus',
        label: 'Square Plus',
    },
    {
        id: 'square-poll-horizontal',
        label: 'Square Poll Horizontal',
    },
    {
        id: 'square-poll-vertical',
        label: 'Square Poll Vertical',
    },
    {
        id: 'square-root-variable',
        label: 'Square Root Variable',
    },
    {
        id: 'square-rss',
        label: 'Square Rss',
    },
    {
        id: 'square-share-nodes',
        label: 'Square Share Nodes',
    },
    {
        id: 'square-up-right',
        label: 'Square Up Right',
    },
    {
        id: 'square-virus',
        label: 'Square Virus',
    },
    {
        id: 'square-xmark',
        label: 'Square Xmark',
    },
    {
        id: 'staff-snake',
        label: 'Staff Snake',
    },
    {
        id: 'stairs',
        label: 'Stairs',
    },
    {
        id: 'stamp',
        label: 'Stamp',
    },
    {
        id: 'stapler',
        label: 'Stapler',
    },
    {
        id: 'star',
        label: 'Star',
    },
    {
        id: 'star-and-crescent',
        label: 'Star And Crescent',
    },
    {
        id: 'star-half',
        label: 'Star Half',
    },
    {
        id: 'star-half-stroke',
        label: 'Star Half Stroke',
    },
    {
        id: 'star-of-david',
        label: 'Star Of David',
    },
    {
        id: 'star-of-life',
        label: 'Star Of Life',
    },
    {
        id: 'sterling-sign',
        label: 'Sterling Sign',
    },
    {
        id: 'stethoscope',
        label: 'Stethoscope',
    },
    {
        id: 'stop',
        label: 'Stop',
    },
    {
        id: 'stopwatch',
        label: 'Stopwatch',
    },
    {
        id: 'stopwatch-20',
        label: 'Stopwatch 20',
    },
    {
        id: 'store',
        label: 'Store',
    },
    {
        id: 'store-slash',
        label: 'Store Slash',
    },
    {
        id: 'street-view',
        label: 'Street View',
    },
    {
        id: 'strikethrough',
        label: 'Strikethrough',
    },
    {
        id: 'stroopwafel',
        label: 'Stroopwafel',
    },
    {
        id: 'subscript',
        label: 'Subscript',
    },
    {
        id: 'suitcase',
        label: 'Suitcase',
    },
    {
        id: 'suitcase-medical',
        label: 'Suitcase Medical',
    },
    {
        id: 'suitcase-rolling',
        label: 'Suitcase Rolling',
    },
    {
        id: 'sun',
        label: 'Sun',
    },
    {
        id: 'sun-plant-wilt',
        label: 'Sun Plant Wilt',
    },
    {
        id: 'superscript',
        label: 'Superscript',
    },
    {
        id: 'swatchbook',
        label: 'Swatchbook',
    },
    {
        id: 'synagogue',
        label: 'Synagogue',
    },
    {
        id: 'syringe',
        label: 'Syringe',
    },
    {
        id: 't',
        label: 'T',
    },
    {
        id: 'table',
        label: 'Table',
    },
    {
        id: 'table-cells',
        label: 'Table Cells',
    },
    {
        id: 'table-cells-large',
        label: 'Table Cells Large',
    },
    {
        id: 'table-columns',
        label: 'Table Columns',
    },
    {
        id: 'table-list',
        label: 'Table List',
    },
    {
        id: 'tablet',
        label: 'Tablet',
    },
    {
        id: 'tablet-button',
        label: 'Tablet Button',
    },
    {
        id: 'table-tennis-paddle-ball',
        label: 'Table Tennis Paddle Ball',
    },
    {
        id: 'tablets',
        label: 'Tablets',
    },
    {
        id: 'tablet-screen-button',
        label: 'Tablet Screen Button',
    },
    {
        id: 'tachograph-digital',
        label: 'Tachograph Digital',
    },
    {
        id: 'tag',
        label: 'Tag',
    },
    {
        id: 'tags',
        label: 'Tags',
    },
    {
        id: 'tape',
        label: 'Tape',
    },
    {
        id: 'tarp',
        label: 'Tarp',
    },
    {
        id: 'tarp-droplet',
        label: 'Tarp Droplet',
    },
    {
        id: 'taxi',
        label: 'Taxi',
    },
    {
        id: 'teeth',
        label: 'Teeth',
    },
    {
        id: 'teeth-open',
        label: 'Teeth Open',
    },
    {
        id: 'temperature-arrow-down',
        label: 'Temperature Arrow Down',
    },
    {
        id: 'temperature-arrow-up',
        label: 'Temperature Arrow Up',
    },
    {
        id: 'temperature-empty',
        label: 'Temperature Empty',
    },
    {
        id: 'temperature-full',
        label: 'Temperature Full',
    },
    {
        id: 'temperature-half',
        label: 'Temperature Half',
    },
    {
        id: 'temperature-high',
        label: 'Temperature High',
    },
    {
        id: 'temperature-low',
        label: 'Temperature Low',
    },
    {
        id: 'temperature-quarter',
        label: 'Temperature Quarter',
    },
    {
        id: 'temperature-three-quarters',
        label: 'Temperature Three Quarters',
    },
    {
        id: 'tenge-sign',
        label: 'Tenge Sign',
    },
    {
        id: 'tent',
        label: 'Tent',
    },
    {
        id: 'tent-arrow-down-to-line',
        label: 'Tent Arrow Down To Line',
    },
    {
        id: 'tent-arrow-left-right',
        label: 'Tent Arrow Left Right',
    },
    {
        id: 'tent-arrows-down',
        label: 'Tent Arrows Down',
    },
    {
        id: 'tent-arrow-turn-left',
        label: 'Tent Arrow Turn Left',
    },
    {
        id: 'tents',
        label: 'Tents',
    },
    {
        id: 'terminal',
        label: 'Terminal',
    },
    {
        id: 'text-height',
        label: 'Text Height',
    },
    {
        id: 'text-slash',
        label: 'Text Slash',
    },
    {
        id: 'text-width',
        label: 'Text Width',
    },
    {
        id: 'thermometer',
        label: 'Thermometer',
    },
    {
        id: 'thumbs-down',
        label: 'Thumbs Down',
    },
    {
        id: 'thumbs-up',
        label: 'Thumbs Up',
    },
    {
        id: 'thumbtack',
        label: 'Thumbtack',
    },
    {
        id: 'ticket',
        label: 'Ticket',
    },
    {
        id: 'ticket-simple',
        label: 'Ticket Simple',
    },
    {
        id: 'timeline',
        label: 'Timeline',
    },
    {
        id: 'toggle-off',
        label: 'Toggle Off',
    },
    {
        id: 'toggle-on',
        label: 'Toggle On',
    },
    {
        id: 'toilet',
        label: 'Toilet',
    },
    {
        id: 'toilet-paper',
        label: 'Toilet Paper',
    },
    {
        id: 'toilet-paper-slash',
        label: 'Toilet Paper Slash',
    },
    {
        id: 'toilet-portable',
        label: 'Toilet Portable',
    },
    {
        id: 'toilets-portable',
        label: 'Toilets Portable',
    },
    {
        id: 'toolbox',
        label: 'Toolbox',
    },
    {
        id: 'tooth',
        label: 'Tooth',
    },
    {
        id: 'torii-gate',
        label: 'Torii Gate',
    },
    {
        id: 'tornado',
        label: 'Tornado',
    },
    {
        id: 'tower-broadcast',
        label: 'Tower Broadcast',
    },
    {
        id: 'tower-cell',
        label: 'Tower Cell',
    },
    {
        id: 'tower-observation',
        label: 'Tower Observation',
    },
    {
        id: 'tractor',
        label: 'Tractor',
    },
    {
        id: 'trademark',
        label: 'Trademark',
    },
    {
        id: 'traffic-light',
        label: 'Traffic Light',
    },
    {
        id: 'trailer',
        label: 'Trailer',
    },
    {
        id: 'train',
        label: 'Train',
    },
    {
        id: 'train-subway',
        label: 'Train Subway',
    },
    {
        id: 'train-tram',
        label: 'Train Tram',
    },
    {
        id: 'transgender',
        label: 'Transgender',
    },
    {
        id: 'trash',
        label: 'Trash',
    },
    {
        id: 'trash-arrow-up',
        label: 'Trash Arrow Up',
    },
    {
        id: 'trash-can',
        label: 'Trash Can',
    },
    {
        id: 'trash-can-arrow-up',
        label: 'Trash Can Arrow Up',
    },
    {
        id: 'tree',
        label: 'Tree',
    },
    {
        id: 'tree-city',
        label: 'Tree City',
    },
    {
        id: 'triangle-exclamation',
        label: 'Triangle Exclamation',
    },
    {
        id: 'trophy',
        label: 'Trophy',
    },
    {
        id: 'trowel',
        label: 'Trowel',
    },
    {
        id: 'trowel-bricks',
        label: 'Trowel Bricks',
    },
    {
        id: 'truck',
        label: 'Truck',
    },
    {
        id: 'truck-arrow-right',
        label: 'Truck Arrow Right',
    },
    {
        id: 'truck-droplet',
        label: 'Truck Droplet',
    },
    {
        id: 'truck-fast',
        label: 'Truck Fast',
    },
    {
        id: 'truck-field',
        label: 'Truck Field',
    },
    {
        id: 'truck-field-un',
        label: 'Truck Field Un',
    },
    {
        id: 'truck-front',
        label: 'Truck Front',
    },
    {
        id: 'truck-medical',
        label: 'Truck Medical',
    },
    {
        id: 'truck-monster',
        label: 'Truck Monster',
    },
    {
        id: 'truck-moving',
        label: 'Truck Moving',
    },
    {
        id: 'truck-pickup',
        label: 'Truck Pickup',
    },
    {
        id: 'truck-plane',
        label: 'Truck Plane',
    },
    {
        id: 'truck-ramp-box',
        label: 'Truck Ramp Box',
    },
    {
        id: 'tty',
        label: 'Tty',
    },
    {
        id: 'turkish-lira-sign',
        label: 'Turkish Lira Sign',
    },
    {
        id: 'turn-down',
        label: 'Turn Down',
    },
    {
        id: 'turn-up',
        label: 'Turn Up',
    },
    {
        id: 'tv',
        label: 'Tv',
    },
    {
        id: 'u',
        label: 'U',
    },
    {
        id: 'umbrella',
        label: 'Umbrella',
    },
    {
        id: 'umbrella-beach',
        label: 'Umbrella Beach',
    },
    {
        id: 'underline',
        label: 'Underline',
    },
    {
        id: 'universal-access',
        label: 'Universal Access',
    },
    {
        id: 'unlock',
        label: 'Unlock',
    },
    {
        id: 'unlock-keyhole',
        label: 'Unlock Keyhole',
    },
    {
        id: 'up-down',
        label: 'Up Down',
    },
    {
        id: 'up-down-left-right',
        label: 'Up Down Left Right',
    },
    {
        id: 'upload',
        label: 'Upload',
    },
    {
        id: 'up-long',
        label: 'Up Long',
    },
    {
        id: 'up-right-and-down-left-from-center',
        label: 'Up Right And Down Left From Center',
    },
    {
        id: 'up-right-from-square',
        label: 'Up Right From Square',
    },
    {
        id: 'user',
        label: 'User',
    },
    {
        id: 'user-astronaut',
        label: 'User Astronaut',
    },
    {
        id: 'user-check',
        label: 'User Check',
    },
    {
        id: 'user-clock',
        label: 'User Clock',
    },
    {
        id: 'user-doctor',
        label: 'User Doctor',
    },
    {
        id: 'user-gear',
        label: 'User Gear',
    },
    {
        id: 'user-graduate',
        label: 'User Graduate',
    },
    {
        id: 'user-group',
        label: 'User Group',
    },
    {
        id: 'user-injured',
        label: 'User Injured',
    },
    {
        id: 'user-large',
        label: 'User Large',
    },
    {
        id: 'user-large-slash',
        label: 'User Large Slash',
    },
    {
        id: 'user-lock',
        label: 'User Lock',
    },
    {
        id: 'user-minus',
        label: 'User Minus',
    },
    {
        id: 'user-ninja',
        label: 'User Ninja',
    },
    {
        id: 'user-nurse',
        label: 'User Nurse',
    },
    {
        id: 'user-pen',
        label: 'User Pen',
    },
    {
        id: 'user-plus',
        label: 'User Plus',
    },
    {
        id: 'users',
        label: 'Users',
    },
    {
        id: 'users-between-lines',
        label: 'Users Between Lines',
    },
    {
        id: 'user-secret',
        label: 'User Secret',
    },
    {
        id: 'users-gear',
        label: 'Users Gear',
    },
    {
        id: 'user-shield',
        label: 'User Shield',
    },
    {
        id: 'user-slash',
        label: 'User Slash',
    },
    {
        id: 'users-line',
        label: 'Users Line',
    },
    {
        id: 'users-rays',
        label: 'Users Rays',
    },
    {
        id: 'users-rectangle',
        label: 'Users Rectangle',
    },
    {
        id: 'users-slash',
        label: 'Users Slash',
    },
    {
        id: 'users-viewfinder',
        label: 'Users Viewfinder',
    },
    {
        id: 'user-tag',
        label: 'User Tag',
    },
    {
        id: 'user-tie',
        label: 'User Tie',
    },
    {
        id: 'user-xmark',
        label: 'User Xmark',
    },
    {
        id: 'utensils',
        label: 'Utensils',
    },
    {
        id: 'v',
        label: 'V',
    },
    {
        id: 'van-shuttle',
        label: 'Van Shuttle',
    },
    {
        id: 'vault',
        label: 'Vault',
    },
    {
        id: 'vector-square',
        label: 'Vector Square',
    },
    {
        id: 'venus',
        label: 'Venus',
    },
    {
        id: 'venus-double',
        label: 'Venus Double',
    },
    {
        id: 'venus-mars',
        label: 'Venus Mars',
    },
    {
        id: 'vest',
        label: 'Vest',
    },
    {
        id: 'vest-patches',
        label: 'Vest Patches',
    },
    {
        id: 'vial',
        label: 'Vial',
    },
    {
        id: 'vial-circle-check',
        label: 'Vial Circle Check',
    },
    {
        id: 'vials',
        label: 'Vials',
    },
    {
        id: 'vial-virus',
        label: 'Vial Virus',
    },
    {
        id: 'video',
        label: 'Video',
    },
    {
        id: 'video-slash',
        label: 'Video Slash',
    },
    {
        id: 'vihara',
        label: 'Vihara',
    },
    {
        id: 'virus',
        label: 'Virus',
    },
    {
        id: 'virus-covid',
        label: 'Virus Covid',
    },
    {
        id: 'virus-covid-slash',
        label: 'Virus Covid Slash',
    },
    {
        id: 'viruses',
        label: 'Viruses',
    },
    {
        id: 'virus-slash',
        label: 'Virus Slash',
    },
    {
        id: 'voicemail',
        label: 'Voicemail',
    },
    {
        id: 'volcano',
        label: 'Volcano',
    },
    {
        id: 'volleyball',
        label: 'Volleyball',
    },
    {
        id: 'volume-high',
        label: 'Volume High',
    },
    {
        id: 'volume-low',
        label: 'Volume Low',
    },
    {
        id: 'volume-off',
        label: 'Volume Off',
    },
    {
        id: 'volume-xmark',
        label: 'Volume Xmark',
    },
    {
        id: 'vr-cardboard',
        label: 'Vr Cardboard',
    },
    {
        id: 'w',
        label: 'W',
    },
    {
        id: 'walkie-talkie',
        label: 'Walkie Talkie',
    },
    {
        id: 'wallet',
        label: 'Wallet',
    },
    {
        id: 'wand-magic',
        label: 'Wand Magic',
    },
    {
        id: 'wand-magic-sparkles',
        label: 'Wand Magic Sparkles',
    },
    {
        id: 'wand-sparkles',
        label: 'Wand Sparkles',
    },
    {
        id: 'warehouse',
        label: 'Warehouse',
    },
    {
        id: 'water',
        label: 'Water',
    },
    {
        id: 'water-ladder',
        label: 'Water Ladder',
    },
    {
        id: 'wave-square',
        label: 'Wave Square',
    },
    {
        id: 'weight-hanging',
        label: 'Weight Hanging',
    },
    {
        id: 'weight-scale',
        label: 'Weight Scale',
    },
    {
        id: 'wheat-awn',
        label: 'Wheat Awn',
    },
    {
        id: 'wheat-awn-circle-exclamation',
        label: 'Wheat Awn Circle Exclamation',
    },
    {
        id: 'wheelchair',
        label: 'Wheelchair',
    },
    {
        id: 'wheelchair-move',
        label: 'Wheelchair Move',
    },
    {
        id: 'whiskey-glass',
        label: 'Whiskey Glass',
    },
    {
        id: 'wifi',
        label: 'Wifi',
    },
    {
        id: 'wind',
        label: 'Wind',
    },
    {
        id: 'window-maximize',
        label: 'Window Maximize',
    },
    {
        id: 'window-minimize',
        label: 'Window Minimize',
    },
    {
        id: 'window-restore',
        label: 'Window Restore',
    },
    {
        id: 'wine-bottle',
        label: 'Wine Bottle',
    },
    {
        id: 'wine-glass',
        label: 'Wine Glass',
    },
    {
        id: 'wine-glass-empty',
        label: 'Wine Glass Empty',
    },
    {
        id: 'won-sign',
        label: 'Won Sign',
    },
    {
        id: 'worm',
        label: 'Worm',
    },
    {
        id: 'wrench',
        label: 'Wrench',
    },
    {
        id: 'x',
        label: 'X',
    },
    {
        id: 'xmark',
        label: 'Xmark',
    },
    {
        id: 'xmarks-lines',
        label: 'Xmarks Lines',
    },
    {
        id: 'x-ray',
        label: 'X Ray',
    },
    {
        id: 'y',
        label: 'Y',
    },
    {
        id: 'yen-sign',
        label: 'Yen Sign',
    },
    {
        id: 'yin-yang',
        label: 'Yin Yang',
    },
    {
        id: 'z',
        label: 'Z',
    },
];
