"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferencesListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("@neo4j-cypher/antlr4");
var CypherTypes = _interopRequireWildcard(require("../lang/CypherTypes"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class Index {
  constructor() {
    (0, _defineProperty2.default)(this, "names", {});
    (0, _defineProperty2.default)(this, "namesByQuery", []);
    (0, _defineProperty2.default)(this, "referencesByName", {});
    (0, _defineProperty2.default)(this, "referencesByQueryAndName", []);
  }
  addQuery() {
    this.namesByQuery.push([]);
    this.referencesByQueryAndName.push({});
  }
  add(ctx, addName = true) {
    const queryIndex = this.namesByQuery.length - 1;
    const text = ctx.getText();
    if (addName) {
      this.names[text] = true;
      this.namesByQuery[queryIndex][text] = true;
    }
    this.referencesByName[text] = [...(this.referencesByName[text] || []), ctx];
    const index = this.referencesByQueryAndName[queryIndex];
    index[text] = [...(index[text] || []), ctx];
  }

  /**
   * Variables have specific rules, because they participate in autocompletion.
   * We should not add to the names list variables that are in expression.
   */
  addVariable(ctx) {
    let addName = true;

    // If variable is inside atom, then variable is inside expression.
    // Therefore, variables is node defined here.
    const parent = ctx.parentCtx;
    if (parent && parent instanceof CypherTypes.ATOM_CONTEXT) {
      addName = false;
    }
    this.add(ctx, addName);
  }
}
class ReferencesListener extends _antlr.CypherListener {
  constructor() {
    super();
    (0, _defineProperty2.default)(this, "queries", []);
    (0, _defineProperty2.default)(this, "queriesAndCommands", []);
    (0, _defineProperty2.default)(this, "statements", []);
    (0, _defineProperty2.default)(this, "raw", []);
    (0, _defineProperty2.default)(this, "indexes", new Map());
    (0, _defineProperty2.default)(this, "inConsoleCommand", false);
    CypherTypes.SYMBOLIC_CONTEXTS.forEach(sc => {
      this.indexes.set(sc, new Index(sc));
    });
  }
  enterRaw(ctx) {
    this.raw.push(ctx);
  }
  exitRaw(ctx) {
    if (this.raw.length === 0) {
      this.raw.push(ctx);
    }
  }
  enterCypherPart(ctx) {
    this.statements.push(ctx);
  }
  exitCypher(ctx) {
    if (this.statements.length === 0) {
      this.statements.push(ctx);
    }
  }
  enterCypherConsoleCommand(ctx) {
    this.queriesAndCommands.push(ctx);
    this.indexes.forEach(index => index.addQuery());
    this.inConsoleCommand = true;
  }
  exitCypherConsoleCommand() {
    this.inConsoleCommand = false;
  }
  enterCypherQuery(ctx) {
    this.queries.push(ctx);
    this.queriesAndCommands.push(ctx);
    this.indexes.forEach(index => index.addQuery());
  }
  exitVariable(ctx) {
    if (this.inConsoleCommand) {
      return;
    }
    this.indexes.get(CypherTypes.VARIABLE_CONTEXT).addVariable(ctx);
  }
  exitLabelName(ctx) {
    if (this.inConsoleCommand) {
      return;
    }
    this.indexes.get(CypherTypes.LABEL_NAME_CONTEXT).add(ctx);
  }
  exitRelTypeName(ctx) {
    if (this.inConsoleCommand) {
      return;
    }
    this.indexes.get(CypherTypes.RELATIONSHIP_TYPE_NAME_CONTEXT).add(ctx);
  }
  exitPropertyKeyName(ctx) {
    if (this.inConsoleCommand) {
      return;
    }
    this.indexes.get(CypherTypes.PROPERTY_KEY_NAME_CONTEXT).add(ctx);
  }
  exitParameterName(ctx) {
    if (this.inConsoleCommand) {
      return;
    }
    this.indexes.get(CypherTypes.PARAMETER_NAME_CONTEXT).add(ctx);
  }
}
exports.ReferencesListener = ReferencesListener;