"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SigmaContainer = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const lodash_1 = require("lodash");
const graphology_1 = tslib_1.__importDefault(require("graphology"));
const sigma_1 = require("sigma");
const context_1 = require("../hooks/context");
const SigmaContainerComponent = ({ graph, id, className, style, settings, children }, ref) => {
    const rootRef = (0, react_1.useRef)(null);
    const containerRef = (0, react_1.useRef)(null);
    const props = { className: `react-sigma ${className ? className : ""}`, id, style };
    const [sigma, setSigma] = (0, react_1.useState)(null);
    const sigmaSettings = (0, react_1.useRef)({});
    if (!(0, lodash_1.isEqual)(sigmaSettings.current, settings))
        sigmaSettings.current = settings || {};
    (0, react_1.useEffect)(() => {
        let instance = null;
        if (containerRef.current !== null) {
            const sigGraph = graph ? (typeof graph === "function" ? new graph() : graph) : new graphology_1.default();
            instance = new sigma_1.Sigma(sigGraph, containerRef.current, Object.assign({ allowInvalidContainer: true }, sigmaSettings.current));
            if (sigma)
                instance.getCamera().setState(sigma.getCamera().getState());
        }
        setSigma(instance);
        return () => {
            if (instance) {
                instance.kill();
            }
            setSigma(null);
        };
    }, [containerRef, graph, sigmaSettings]);
    (0, react_1.useImperativeHandle)(ref, () => sigma, [sigma]);
    const context = (0, react_1.useMemo)(() => (sigma && rootRef.current ? { sigma, container: rootRef.current } : null), [sigma, rootRef.current]);
    const contents = context !== null ? react_1.default.createElement(context_1.SigmaProvider, { value: context }, children) : null;
    return (react_1.default.createElement("div", Object.assign({}, props, { ref: rootRef }),
        react_1.default.createElement("div", { className: "sigma-container", ref: containerRef }),
        contents));
};
exports.SigmaContainer = (0, react_1.forwardRef)(SigmaContainerComponent);
//# sourceMappingURL=SigmaContainer.js.map