# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DESCRIPTION="Default rtlib configuration for clang"
HOMEPAGE="https://clang.llvm.org/"
S=${WORKDIR}

LICENSE="public-domain"
SLOT="${PV}"
KEYWORDS="amd64 arm arm64 ~loong ppc ppc64 ~riscv ~sparc x86 ~arm64-macos ~x64-macos"
IUSE="default-compiler-rt +abi_x86_32 abi_x86_64"

RDEPEND="
	default-compiler-rt? ( llvm-runtimes/compiler-rt:${SLOT}[abi_x86_32(+)?,abi_x86_64(+)?] )
	!default-compiler-rt? ( sys-devel/gcc )
"

src_install() {
	insinto "/etc/clang/${SLOT}"
	newins - gentoo-rtlib.cfg <<-EOF
		# This file is initially generated by ${CATEGORY}/${PN}.
		# It is used to control the default rtlib used by clang.

		--rtlib=$(usex default-compiler-rt compiler-rt libgcc)
	EOF
}
