# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.3.0

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="A modern, easy to use, well-documented, extensible pretty-printer"
HOMEPAGE="https://github.com/quchen/prettyprinter"

LICENSE="BSD-2"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="buildreadme +text"

RDEPEND=">=dev-lang/ghc-8.4.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.2.0.1
	test? ( >=dev-haskell/doctest-0.9
		>=dev-haskell/quickcheck-2.5
		text? ( >=dev-haskell/pgp-wordlist-0.1
			>=dev-haskell/quickcheck-instances-0.3
			>=dev-haskell/tasty-0.10
			>=dev-haskell/tasty-hunit-0.9
			>=dev-haskell/tasty-quickcheck-0.8 ) )
"

pkg_pretend() {
	if use test; then
		ewarn "The \"test\" USE flag for this package creates cycles within the"
		ewarn "dependency graph. This may give you problems during 'haskell-updater' runs."
		ewarn "It is recommended to leave it disabled unless explicitly testing the package."
	fi
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag buildreadme buildreadme) \
		$(cabal_flag text text)
}
