/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLTStaticContext;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContext
implements XSLTStaticContext {
    private StyleElement element;
    private NamePool namePool;
    private NamespaceResolver namespaceResolver = null;
    private static StructuredQName[] errorVariables = new StructuredQName[]{new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "code"), new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "description"), new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "value"), new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "module"), new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "line-number"), new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "column-number")};

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getNamePool();
    }

    @Override
    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    public Executable getExecutable() {
        return this.element.getExecutable();
    }

    @Override
    public boolean isSchemaAware() {
        return this.getExecutable().isSchemaAware();
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.element.getPrincipalStylesheetModule().getCollationMap());
    }

    @Override
    public LocationMap getLocationMap() {
        return this.getExecutable().getLocationMap();
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        this.element.issueWarning(s, locator);
    }

    @Override
    public NamePool getNamePool() {
        return this.namePool;
    }

    @Override
    public String getSystemId() {
        return this.element.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    @Override
    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.element.getURIForPrefix(prefix, false);
        if (uri == null) {
            XPathException err = new XPathException("Undeclared namespace prefix " + Err.wrap(prefix));
            err.setErrorCode("XPST0081");
            err.setIsStaticError(true);
            throw err;
        }
        return uri;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = this.element.makeNamespaceContext();
        }
        return this.namespaceResolver;
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return this.element.getPreparedStylesheet().getDecimalFormatManager();
    }

    public int getFingerprint(String qname, boolean useDefault) throws XPathException {
        String[] parts;
        try {
            parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
        }
        catch (QNameException err) {
            throw new XPathException(err.getMessage());
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            String uri = "";
            if (useDefault) {
                uri = this.getURIForPrefix(prefix);
            }
            return this.namePool.getFingerprint(uri, qname);
        }
        String uri = this.getURIForPrefix(prefix);
        return this.namePool.getFingerprint(uri, parts[1]);
    }

    public StructuredQName getStructuredQName(String qname, boolean useDefault) throws XPathException {
        String[] parts;
        try {
            parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
        }
        catch (QNameException err) {
            throw new XPathException(err.getMessage());
        }
        String prefix = parts[0];
        if (prefix.length() == 0) {
            String uri = "";
            if (useDefault) {
                uri = this.getURIForPrefix(prefix);
            }
            return new StructuredQName("", uri, qname);
        }
        String uri = this.getURIForPrefix(prefix);
        return new StructuredQName(prefix, uri, parts[1]);
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        XSLVariableDeclaration xslVariableDeclaration = this.element.bindVariable(qName);
        if (xslVariableDeclaration == null) {
            AxisIterator catchers;
            StyleElement catcher;
            if ("http://www.w3.org/2005/xqt-errors".equals(qName.getNamespaceURI()) && (catcher = (StyleElement)(catchers = this.element.iterateAxis((byte)1, new NameTest(1, 135, this.getNamePool()))).next()) != null) {
                for (int i = 0; i < errorVariables.length; ++i) {
                    if (!errorVariables[i].getLocalName().equals(qName.getLocalName())) continue;
                    VendorFunctionLibrary lib = this.getConfiguration().getVendorFunctionLibrary();
                    StructuredQName functionName = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    Expression[] args = new Expression[]{new StringLiteral(qName.getLocalName())};
                    return lib.bind(functionName, args, this, this.element);
                }
            }
            XPathException err = new XPathException("Variable " + qName.getDisplayName() + " has not been declared");
            err.setErrorCode("XPST0008");
            err.setIsStaticError(true);
            throw err;
        }
        VariableReference var = xslVariableDeclaration.isGlobal() ? new VariableReference() : new LocalVariableReference();
        xslVariableDeclaration.registerReference(var);
        return var;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.element.getPrincipalStylesheetModule().getFunctionLibrary();
    }

    @Override
    public boolean isElementAvailable(String qname) throws XPathException {
        try {
            String[] parts = this.getConfiguration().getNameChecker().getQNameParts(qname);
            String uri = parts[0].length() == 0 ? this.getDefaultElementNamespace() : this.getURIForPrefix(parts[0]);
            return this.element.getPreparedStylesheet().getStyleNodeFactory().isElementAvailable(uri, parts[1]);
        }
        catch (QNameException e) {
            XPathException err = new XPathException("Invalid element name. " + e.getMessage());
            err.setErrorCode("XTDE1440");
            throw err;
        }
    }

    @Override
    public StringCollator getCollation(String name) {
        if (name == null) {
            return this.getCollation(this.getDefaultCollationName());
        }
        return this.element.getPrincipalStylesheetModule().findCollation(name, this.element.getBaseURI());
    }

    @Override
    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return "http://www.w3.org/2005/xpath-functions";
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.element.xPath10ModeIsEnabled();
    }

    @Override
    public DecimalValue getXPathLanguageLevel() {
        return this.element.getPreparedStylesheet().getStyleNodeFactory().getXsltProcessorVersion();
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.element.getPrincipalStylesheetModule().isImportedSchema(namespace);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.element.getPrincipalStylesheetModule().getImportedSchemaTable();
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        Configuration config = this.getConfiguration();
        if (type.getFingerprint() == 565) {
            return config.getXsdVersion() == 11;
        }
        return type.isAllowedInBasicXSLT() || config.isLicensedFeature(64);
    }

    public StyleElement getStyleElement() {
        return this.element;
    }
}

