// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -target-feature +sve-f16f32mm -verify=guard

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve-f16f32mm" streaming_guard="" flags=""

void test(void) {
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;

  svmmla(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
  svmmla_f32_f16(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
}

void test_streaming(void) __arm_streaming{
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_f32_f16(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svfloat16_t svfloat16_t_val;
  svfloat32_t svfloat32_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svmmla_f32_f16(svfloat32_t_val, svfloat16_t_val, svfloat16_t_val);
}
