// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medialive

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInputDeviceTransfer = "AcceptInputDeviceTransfer"

// AcceptInputDeviceTransferRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInputDeviceTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInputDeviceTransfer for more information on using the AcceptInputDeviceTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptInputDeviceTransferRequest method.
//	req, resp := client.AcceptInputDeviceTransferRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer
func (c *MediaLive) AcceptInputDeviceTransferRequest(input *AcceptInputDeviceTransferInput) (req *request.Request, output *AcceptInputDeviceTransferOutput) {
	op := &request.Operation{
		Name:       opAcceptInputDeviceTransfer,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/accept",
	}

	if input == nil {
		input = &AcceptInputDeviceTransferInput{}
	}

	output = &AcceptInputDeviceTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInputDeviceTransfer API operation for AWS Elemental MediaLive.
//
// Accept an incoming input device transfer. The ownership of the device will
// transfer to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation AcceptInputDeviceTransfer for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer
func (c *MediaLive) AcceptInputDeviceTransfer(input *AcceptInputDeviceTransferInput) (*AcceptInputDeviceTransferOutput, error) {
	req, out := c.AcceptInputDeviceTransferRequest(input)
	return out, req.Send()
}

// AcceptInputDeviceTransferWithContext is the same as AcceptInputDeviceTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInputDeviceTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) AcceptInputDeviceTransferWithContext(ctx aws.Context, input *AcceptInputDeviceTransferInput, opts ...request.Option) (*AcceptInputDeviceTransferOutput, error) {
	req, out := c.AcceptInputDeviceTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDelete = "BatchDelete"

// BatchDeleteRequest generates a "aws/request.Request" representing the
// client's request for the BatchDelete operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDelete for more information on using the BatchDelete
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDeleteRequest method.
//	req, resp := client.BatchDeleteRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete
func (c *MediaLive) BatchDeleteRequest(input *BatchDeleteInput) (req *request.Request, output *BatchDeleteOutput) {
	op := &request.Operation{
		Name:       opBatchDelete,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/batch/delete",
	}

	if input == nil {
		input = &BatchDeleteInput{}
	}

	output = &BatchDeleteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDelete API operation for AWS Elemental MediaLive.
//
// Starts delete of resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation BatchDelete for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete
func (c *MediaLive) BatchDelete(input *BatchDeleteInput) (*BatchDeleteOutput, error) {
	req, out := c.BatchDeleteRequest(input)
	return out, req.Send()
}

// BatchDeleteWithContext is the same as BatchDelete with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDelete for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) BatchDeleteWithContext(ctx aws.Context, input *BatchDeleteInput, opts ...request.Option) (*BatchDeleteOutput, error) {
	req, out := c.BatchDeleteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStart = "BatchStart"

// BatchStartRequest generates a "aws/request.Request" representing the
// client's request for the BatchStart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStart for more information on using the BatchStart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchStartRequest method.
//	req, resp := client.BatchStartRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart
func (c *MediaLive) BatchStartRequest(input *BatchStartInput) (req *request.Request, output *BatchStartOutput) {
	op := &request.Operation{
		Name:       opBatchStart,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/batch/start",
	}

	if input == nil {
		input = &BatchStartInput{}
	}

	output = &BatchStartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStart API operation for AWS Elemental MediaLive.
//
// # Starts existing resources
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation BatchStart for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart
func (c *MediaLive) BatchStart(input *BatchStartInput) (*BatchStartOutput, error) {
	req, out := c.BatchStartRequest(input)
	return out, req.Send()
}

// BatchStartWithContext is the same as BatchStart with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) BatchStartWithContext(ctx aws.Context, input *BatchStartInput, opts ...request.Option) (*BatchStartOutput, error) {
	req, out := c.BatchStartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStop = "BatchStop"

// BatchStopRequest generates a "aws/request.Request" representing the
// client's request for the BatchStop operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStop for more information on using the BatchStop
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchStopRequest method.
//	req, resp := client.BatchStopRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop
func (c *MediaLive) BatchStopRequest(input *BatchStopInput) (req *request.Request, output *BatchStopOutput) {
	op := &request.Operation{
		Name:       opBatchStop,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/batch/stop",
	}

	if input == nil {
		input = &BatchStopInput{}
	}

	output = &BatchStopOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStop API operation for AWS Elemental MediaLive.
//
// # Stops running resources
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation BatchStop for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop
func (c *MediaLive) BatchStop(input *BatchStopInput) (*BatchStopOutput, error) {
	req, out := c.BatchStopRequest(input)
	return out, req.Send()
}

// BatchStopWithContext is the same as BatchStop with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStop for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) BatchStopWithContext(ctx aws.Context, input *BatchStopInput, opts ...request.Option) (*BatchStopOutput, error) {
	req, out := c.BatchStopRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateSchedule = "BatchUpdateSchedule"

// BatchUpdateScheduleRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateSchedule for more information on using the BatchUpdateSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateScheduleRequest method.
//	req, resp := client.BatchUpdateScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule
func (c *MediaLive) BatchUpdateScheduleRequest(input *BatchUpdateScheduleInput) (req *request.Request, output *BatchUpdateScheduleOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateSchedule,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
	}

	if input == nil {
		input = &BatchUpdateScheduleInput{}
	}

	output = &BatchUpdateScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateSchedule API operation for AWS Elemental MediaLive.
//
// # Update a channel schedule
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation BatchUpdateSchedule for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule
func (c *MediaLive) BatchUpdateSchedule(input *BatchUpdateScheduleInput) (*BatchUpdateScheduleOutput, error) {
	req, out := c.BatchUpdateScheduleRequest(input)
	return out, req.Send()
}

// BatchUpdateScheduleWithContext is the same as BatchUpdateSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) BatchUpdateScheduleWithContext(ctx aws.Context, input *BatchUpdateScheduleInput, opts ...request.Option) (*BatchUpdateScheduleOutput, error) {
	req, out := c.BatchUpdateScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelInputDeviceTransfer = "CancelInputDeviceTransfer"

// CancelInputDeviceTransferRequest generates a "aws/request.Request" representing the
// client's request for the CancelInputDeviceTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelInputDeviceTransfer for more information on using the CancelInputDeviceTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelInputDeviceTransferRequest method.
//	req, resp := client.CancelInputDeviceTransferRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer
func (c *MediaLive) CancelInputDeviceTransferRequest(input *CancelInputDeviceTransferInput) (req *request.Request, output *CancelInputDeviceTransferOutput) {
	op := &request.Operation{
		Name:       opCancelInputDeviceTransfer,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/cancel",
	}

	if input == nil {
		input = &CancelInputDeviceTransferInput{}
	}

	output = &CancelInputDeviceTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelInputDeviceTransfer API operation for AWS Elemental MediaLive.
//
// Cancel an input device transfer that you have requested.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CancelInputDeviceTransfer for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer
func (c *MediaLive) CancelInputDeviceTransfer(input *CancelInputDeviceTransferInput) (*CancelInputDeviceTransferOutput, error) {
	req, out := c.CancelInputDeviceTransferRequest(input)
	return out, req.Send()
}

// CancelInputDeviceTransferWithContext is the same as CancelInputDeviceTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See CancelInputDeviceTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CancelInputDeviceTransferWithContext(ctx aws.Context, input *CancelInputDeviceTransferInput, opts ...request.Option) (*CancelInputDeviceTransferOutput, error) {
	req, out := c.CancelInputDeviceTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClaimDevice = "ClaimDevice"

// ClaimDeviceRequest generates a "aws/request.Request" representing the
// client's request for the ClaimDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClaimDevice for more information on using the ClaimDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ClaimDeviceRequest method.
//	req, resp := client.ClaimDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice
func (c *MediaLive) ClaimDeviceRequest(input *ClaimDeviceInput) (req *request.Request, output *ClaimDeviceOutput) {
	op := &request.Operation{
		Name:       opClaimDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/claimDevice",
	}

	if input == nil {
		input = &ClaimDeviceInput{}
	}

	output = &ClaimDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ClaimDevice API operation for AWS Elemental MediaLive.
//
// Send a request to claim an AWS Elemental device that you have purchased from
// a third-party vendor. After the request succeeds, you will own the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ClaimDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice
func (c *MediaLive) ClaimDevice(input *ClaimDeviceInput) (*ClaimDeviceOutput, error) {
	req, out := c.ClaimDeviceRequest(input)
	return out, req.Send()
}

// ClaimDeviceWithContext is the same as ClaimDevice with the addition of
// the ability to pass a context and additional request options.
//
// See ClaimDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ClaimDeviceWithContext(ctx aws.Context, input *ClaimDeviceInput, opts ...request.Option) (*ClaimDeviceOutput, error) {
	req, out := c.ClaimDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS Elemental MediaLive.
//
// # Creates a new channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel
func (c *MediaLive) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudWatchAlarmTemplate = "CreateCloudWatchAlarmTemplate"

// CreateCloudWatchAlarmTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudWatchAlarmTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudWatchAlarmTemplate for more information on using the CreateCloudWatchAlarmTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCloudWatchAlarmTemplateRequest method.
//	req, resp := client.CreateCloudWatchAlarmTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate
func (c *MediaLive) CreateCloudWatchAlarmTemplateRequest(input *CreateCloudWatchAlarmTemplateInput) (req *request.Request, output *CreateCloudWatchAlarmTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateCloudWatchAlarmTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/cloudwatch-alarm-templates",
	}

	if input == nil {
		input = &CreateCloudWatchAlarmTemplateInput{}
	}

	output = &CreateCloudWatchAlarmTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudWatchAlarmTemplate API operation for AWS Elemental MediaLive.
//
// Creates a cloudwatch alarm template to dynamically generate cloudwatch metric
// alarms on targeted resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateCloudWatchAlarmTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate
func (c *MediaLive) CreateCloudWatchAlarmTemplate(input *CreateCloudWatchAlarmTemplateInput) (*CreateCloudWatchAlarmTemplateOutput, error) {
	req, out := c.CreateCloudWatchAlarmTemplateRequest(input)
	return out, req.Send()
}

// CreateCloudWatchAlarmTemplateWithContext is the same as CreateCloudWatchAlarmTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudWatchAlarmTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateCloudWatchAlarmTemplateWithContext(ctx aws.Context, input *CreateCloudWatchAlarmTemplateInput, opts ...request.Option) (*CreateCloudWatchAlarmTemplateOutput, error) {
	req, out := c.CreateCloudWatchAlarmTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCloudWatchAlarmTemplateGroup = "CreateCloudWatchAlarmTemplateGroup"

// CreateCloudWatchAlarmTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateCloudWatchAlarmTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCloudWatchAlarmTemplateGroup for more information on using the CreateCloudWatchAlarmTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCloudWatchAlarmTemplateGroupRequest method.
//	req, resp := client.CreateCloudWatchAlarmTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup
func (c *MediaLive) CreateCloudWatchAlarmTemplateGroupRequest(input *CreateCloudWatchAlarmTemplateGroupInput) (req *request.Request, output *CreateCloudWatchAlarmTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateCloudWatchAlarmTemplateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/cloudwatch-alarm-template-groups",
	}

	if input == nil {
		input = &CreateCloudWatchAlarmTemplateGroupInput{}
	}

	output = &CreateCloudWatchAlarmTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCloudWatchAlarmTemplateGroup API operation for AWS Elemental MediaLive.
//
// Creates a cloudwatch alarm template group to group your cloudwatch alarm
// templates and to attach to signal maps for dynamically creating alarms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateCloudWatchAlarmTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup
func (c *MediaLive) CreateCloudWatchAlarmTemplateGroup(input *CreateCloudWatchAlarmTemplateGroupInput) (*CreateCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.CreateCloudWatchAlarmTemplateGroupRequest(input)
	return out, req.Send()
}

// CreateCloudWatchAlarmTemplateGroupWithContext is the same as CreateCloudWatchAlarmTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCloudWatchAlarmTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateCloudWatchAlarmTemplateGroupWithContext(ctx aws.Context, input *CreateCloudWatchAlarmTemplateGroupInput, opts ...request.Option) (*CreateCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.CreateCloudWatchAlarmTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventBridgeRuleTemplate = "CreateEventBridgeRuleTemplate"

// CreateEventBridgeRuleTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventBridgeRuleTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventBridgeRuleTemplate for more information on using the CreateEventBridgeRuleTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventBridgeRuleTemplateRequest method.
//	req, resp := client.CreateEventBridgeRuleTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate
func (c *MediaLive) CreateEventBridgeRuleTemplateRequest(input *CreateEventBridgeRuleTemplateInput) (req *request.Request, output *CreateEventBridgeRuleTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateEventBridgeRuleTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/eventbridge-rule-templates",
	}

	if input == nil {
		input = &CreateEventBridgeRuleTemplateInput{}
	}

	output = &CreateEventBridgeRuleTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventBridgeRuleTemplate API operation for AWS Elemental MediaLive.
//
// Creates an eventbridge rule template to monitor events and send notifications
// to your targeted resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateEventBridgeRuleTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate
func (c *MediaLive) CreateEventBridgeRuleTemplate(input *CreateEventBridgeRuleTemplateInput) (*CreateEventBridgeRuleTemplateOutput, error) {
	req, out := c.CreateEventBridgeRuleTemplateRequest(input)
	return out, req.Send()
}

// CreateEventBridgeRuleTemplateWithContext is the same as CreateEventBridgeRuleTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventBridgeRuleTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateEventBridgeRuleTemplateWithContext(ctx aws.Context, input *CreateEventBridgeRuleTemplateInput, opts ...request.Option) (*CreateEventBridgeRuleTemplateOutput, error) {
	req, out := c.CreateEventBridgeRuleTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventBridgeRuleTemplateGroup = "CreateEventBridgeRuleTemplateGroup"

// CreateEventBridgeRuleTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventBridgeRuleTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventBridgeRuleTemplateGroup for more information on using the CreateEventBridgeRuleTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventBridgeRuleTemplateGroupRequest method.
//	req, resp := client.CreateEventBridgeRuleTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup
func (c *MediaLive) CreateEventBridgeRuleTemplateGroupRequest(input *CreateEventBridgeRuleTemplateGroupInput) (req *request.Request, output *CreateEventBridgeRuleTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateEventBridgeRuleTemplateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/eventbridge-rule-template-groups",
	}

	if input == nil {
		input = &CreateEventBridgeRuleTemplateGroupInput{}
	}

	output = &CreateEventBridgeRuleTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventBridgeRuleTemplateGroup API operation for AWS Elemental MediaLive.
//
// Creates an eventbridge rule template group to group your eventbridge rule
// templates and to attach to signal maps for dynamically creating notification
// rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateEventBridgeRuleTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup
func (c *MediaLive) CreateEventBridgeRuleTemplateGroup(input *CreateEventBridgeRuleTemplateGroupInput) (*CreateEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.CreateEventBridgeRuleTemplateGroupRequest(input)
	return out, req.Send()
}

// CreateEventBridgeRuleTemplateGroupWithContext is the same as CreateEventBridgeRuleTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventBridgeRuleTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateEventBridgeRuleTemplateGroupWithContext(ctx aws.Context, input *CreateEventBridgeRuleTemplateGroupInput, opts ...request.Option) (*CreateEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.CreateEventBridgeRuleTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInput = "CreateInput"

// CreateInputRequest generates a "aws/request.Request" representing the
// client's request for the CreateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInput for more information on using the CreateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInputRequest method.
//	req, resp := client.CreateInputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInputRequest(input *CreateInputInput) (req *request.Request, output *CreateInputOutput) {
	op := &request.Operation{
		Name:       opCreateInput,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputs",
	}

	if input == nil {
		input = &CreateInputInput{}
	}

	output = &CreateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInput API operation for AWS Elemental MediaLive.
//
// # Create an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput
func (c *MediaLive) CreateInput(input *CreateInputInput) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	return out, req.Send()
}

// CreateInputWithContext is the same as CreateInput with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputWithContext(ctx aws.Context, input *CreateInputInput, opts ...request.Option) (*CreateInputOutput, error) {
	req, out := c.CreateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInputSecurityGroup = "CreateInputSecurityGroup"

// CreateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInputSecurityGroup for more information on using the CreateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInputSecurityGroupRequest method.
//	req, resp := client.CreateInputSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroupRequest(input *CreateInputSecurityGroupInput) (req *request.Request, output *CreateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opCreateInputSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputSecurityGroups",
	}

	if input == nil {
		input = &CreateInputSecurityGroupInput{}
	}

	output = &CreateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// # Creates a Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup
func (c *MediaLive) CreateInputSecurityGroup(input *CreateInputSecurityGroupInput) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// CreateInputSecurityGroupWithContext is the same as CreateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateInputSecurityGroupWithContext(ctx aws.Context, input *CreateInputSecurityGroupInput, opts ...request.Option) (*CreateInputSecurityGroupOutput, error) {
	req, out := c.CreateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultiplex = "CreateMultiplex"

// CreateMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultiplex for more information on using the CreateMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMultiplexRequest method.
//	req, resp := client.CreateMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex
func (c *MediaLive) CreateMultiplexRequest(input *CreateMultiplexInput) (req *request.Request, output *CreateMultiplexOutput) {
	op := &request.Operation{
		Name:       opCreateMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes",
	}

	if input == nil {
		input = &CreateMultiplexInput{}
	}

	output = &CreateMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultiplex API operation for AWS Elemental MediaLive.
//
// Create a new multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex
func (c *MediaLive) CreateMultiplex(input *CreateMultiplexInput) (*CreateMultiplexOutput, error) {
	req, out := c.CreateMultiplexRequest(input)
	return out, req.Send()
}

// CreateMultiplexWithContext is the same as CreateMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateMultiplexWithContext(ctx aws.Context, input *CreateMultiplexInput, opts ...request.Option) (*CreateMultiplexOutput, error) {
	req, out := c.CreateMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultiplexProgram = "CreateMultiplexProgram"

// CreateMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultiplexProgram for more information on using the CreateMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMultiplexProgramRequest method.
//	req, resp := client.CreateMultiplexProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram
func (c *MediaLive) CreateMultiplexProgramRequest(input *CreateMultiplexProgramInput) (req *request.Request, output *CreateMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opCreateMultiplexProgram,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs",
	}

	if input == nil {
		input = &CreateMultiplexProgramInput{}
	}

	output = &CreateMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Create a new program in the multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateMultiplexProgram for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram
func (c *MediaLive) CreateMultiplexProgram(input *CreateMultiplexProgramInput) (*CreateMultiplexProgramOutput, error) {
	req, out := c.CreateMultiplexProgramRequest(input)
	return out, req.Send()
}

// CreateMultiplexProgramWithContext is the same as CreateMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateMultiplexProgramWithContext(ctx aws.Context, input *CreateMultiplexProgramInput, opts ...request.Option) (*CreateMultiplexProgramOutput, error) {
	req, out := c.CreateMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartnerInput = "CreatePartnerInput"

// CreatePartnerInputRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartnerInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartnerInput for more information on using the CreatePartnerInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePartnerInputRequest method.
//	req, resp := client.CreatePartnerInputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput
func (c *MediaLive) CreatePartnerInputRequest(input *CreatePartnerInputInput) (req *request.Request, output *CreatePartnerInputOutput) {
	op := &request.Operation{
		Name:       opCreatePartnerInput,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputs/{inputId}/partners",
	}

	if input == nil {
		input = &CreatePartnerInputInput{}
	}

	output = &CreatePartnerInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePartnerInput API operation for AWS Elemental MediaLive.
//
// # Create a partner input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreatePartnerInput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput
func (c *MediaLive) CreatePartnerInput(input *CreatePartnerInputInput) (*CreatePartnerInputOutput, error) {
	req, out := c.CreatePartnerInputRequest(input)
	return out, req.Send()
}

// CreatePartnerInputWithContext is the same as CreatePartnerInput with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartnerInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreatePartnerInputWithContext(ctx aws.Context, input *CreatePartnerInputInput, opts ...request.Option) (*CreatePartnerInputOutput, error) {
	req, out := c.CreatePartnerInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSignalMap = "CreateSignalMap"

// CreateSignalMapRequest generates a "aws/request.Request" representing the
// client's request for the CreateSignalMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSignalMap for more information on using the CreateSignalMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSignalMapRequest method.
//	req, resp := client.CreateSignalMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap
func (c *MediaLive) CreateSignalMapRequest(input *CreateSignalMapInput) (req *request.Request, output *CreateSignalMapOutput) {
	op := &request.Operation{
		Name:       opCreateSignalMap,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/signal-maps",
	}

	if input == nil {
		input = &CreateSignalMapInput{}
	}

	output = &CreateSignalMapOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSignalMap API operation for AWS Elemental MediaLive.
//
// Initiates the creation of a new signal map. Will discover a new mediaResourceMap
// based on the provided discoveryEntryPointArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateSignalMap for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap
func (c *MediaLive) CreateSignalMap(input *CreateSignalMapInput) (*CreateSignalMapOutput, error) {
	req, out := c.CreateSignalMapRequest(input)
	return out, req.Send()
}

// CreateSignalMapWithContext is the same as CreateSignalMap with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSignalMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateSignalMapWithContext(ctx aws.Context, input *CreateSignalMapInput, opts ...request.Option) (*CreateSignalMapOutput, error) {
	req, out := c.CreateSignalMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTagsRequest method.
//	req, resp := client.CreateTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags
func (c *MediaLive) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for AWS Elemental MediaLive.
//
// # Create tags for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags
func (c *MediaLive) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChannel API operation for AWS Elemental MediaLive.
//
// Starts deletion of channel. The associated outputs are also deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel
func (c *MediaLive) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCloudWatchAlarmTemplate = "DeleteCloudWatchAlarmTemplate"

// DeleteCloudWatchAlarmTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCloudWatchAlarmTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCloudWatchAlarmTemplate for more information on using the DeleteCloudWatchAlarmTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCloudWatchAlarmTemplateRequest method.
//	req, resp := client.DeleteCloudWatchAlarmTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate
func (c *MediaLive) DeleteCloudWatchAlarmTemplateRequest(input *DeleteCloudWatchAlarmTemplateInput) (req *request.Request, output *DeleteCloudWatchAlarmTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteCloudWatchAlarmTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/cloudwatch-alarm-templates/{identifier}",
	}

	if input == nil {
		input = &DeleteCloudWatchAlarmTemplateInput{}
	}

	output = &DeleteCloudWatchAlarmTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCloudWatchAlarmTemplate API operation for AWS Elemental MediaLive.
//
// Deletes a cloudwatch alarm template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteCloudWatchAlarmTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate
func (c *MediaLive) DeleteCloudWatchAlarmTemplate(input *DeleteCloudWatchAlarmTemplateInput) (*DeleteCloudWatchAlarmTemplateOutput, error) {
	req, out := c.DeleteCloudWatchAlarmTemplateRequest(input)
	return out, req.Send()
}

// DeleteCloudWatchAlarmTemplateWithContext is the same as DeleteCloudWatchAlarmTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCloudWatchAlarmTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteCloudWatchAlarmTemplateWithContext(ctx aws.Context, input *DeleteCloudWatchAlarmTemplateInput, opts ...request.Option) (*DeleteCloudWatchAlarmTemplateOutput, error) {
	req, out := c.DeleteCloudWatchAlarmTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCloudWatchAlarmTemplateGroup = "DeleteCloudWatchAlarmTemplateGroup"

// DeleteCloudWatchAlarmTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCloudWatchAlarmTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCloudWatchAlarmTemplateGroup for more information on using the DeleteCloudWatchAlarmTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCloudWatchAlarmTemplateGroupRequest method.
//	req, resp := client.DeleteCloudWatchAlarmTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup
func (c *MediaLive) DeleteCloudWatchAlarmTemplateGroupRequest(input *DeleteCloudWatchAlarmTemplateGroupInput) (req *request.Request, output *DeleteCloudWatchAlarmTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteCloudWatchAlarmTemplateGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/cloudwatch-alarm-template-groups/{identifier}",
	}

	if input == nil {
		input = &DeleteCloudWatchAlarmTemplateGroupInput{}
	}

	output = &DeleteCloudWatchAlarmTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCloudWatchAlarmTemplateGroup API operation for AWS Elemental MediaLive.
//
// Deletes a cloudwatch alarm template group. You must detach this group from
// all signal maps and ensure its existing templates are moved to another group
// or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteCloudWatchAlarmTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup
func (c *MediaLive) DeleteCloudWatchAlarmTemplateGroup(input *DeleteCloudWatchAlarmTemplateGroupInput) (*DeleteCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.DeleteCloudWatchAlarmTemplateGroupRequest(input)
	return out, req.Send()
}

// DeleteCloudWatchAlarmTemplateGroupWithContext is the same as DeleteCloudWatchAlarmTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCloudWatchAlarmTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteCloudWatchAlarmTemplateGroupWithContext(ctx aws.Context, input *DeleteCloudWatchAlarmTemplateGroupInput, opts ...request.Option) (*DeleteCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.DeleteCloudWatchAlarmTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventBridgeRuleTemplate = "DeleteEventBridgeRuleTemplate"

// DeleteEventBridgeRuleTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventBridgeRuleTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventBridgeRuleTemplate for more information on using the DeleteEventBridgeRuleTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventBridgeRuleTemplateRequest method.
//	req, resp := client.DeleteEventBridgeRuleTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate
func (c *MediaLive) DeleteEventBridgeRuleTemplateRequest(input *DeleteEventBridgeRuleTemplateInput) (req *request.Request, output *DeleteEventBridgeRuleTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteEventBridgeRuleTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/eventbridge-rule-templates/{identifier}",
	}

	if input == nil {
		input = &DeleteEventBridgeRuleTemplateInput{}
	}

	output = &DeleteEventBridgeRuleTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventBridgeRuleTemplate API operation for AWS Elemental MediaLive.
//
// Deletes an eventbridge rule template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteEventBridgeRuleTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate
func (c *MediaLive) DeleteEventBridgeRuleTemplate(input *DeleteEventBridgeRuleTemplateInput) (*DeleteEventBridgeRuleTemplateOutput, error) {
	req, out := c.DeleteEventBridgeRuleTemplateRequest(input)
	return out, req.Send()
}

// DeleteEventBridgeRuleTemplateWithContext is the same as DeleteEventBridgeRuleTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventBridgeRuleTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteEventBridgeRuleTemplateWithContext(ctx aws.Context, input *DeleteEventBridgeRuleTemplateInput, opts ...request.Option) (*DeleteEventBridgeRuleTemplateOutput, error) {
	req, out := c.DeleteEventBridgeRuleTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventBridgeRuleTemplateGroup = "DeleteEventBridgeRuleTemplateGroup"

// DeleteEventBridgeRuleTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventBridgeRuleTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventBridgeRuleTemplateGroup for more information on using the DeleteEventBridgeRuleTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventBridgeRuleTemplateGroupRequest method.
//	req, resp := client.DeleteEventBridgeRuleTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup
func (c *MediaLive) DeleteEventBridgeRuleTemplateGroupRequest(input *DeleteEventBridgeRuleTemplateGroupInput) (req *request.Request, output *DeleteEventBridgeRuleTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteEventBridgeRuleTemplateGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/eventbridge-rule-template-groups/{identifier}",
	}

	if input == nil {
		input = &DeleteEventBridgeRuleTemplateGroupInput{}
	}

	output = &DeleteEventBridgeRuleTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventBridgeRuleTemplateGroup API operation for AWS Elemental MediaLive.
//
// Deletes an eventbridge rule template group. You must detach this group from
// all signal maps and ensure its existing templates are moved to another group
// or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteEventBridgeRuleTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup
func (c *MediaLive) DeleteEventBridgeRuleTemplateGroup(input *DeleteEventBridgeRuleTemplateGroupInput) (*DeleteEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.DeleteEventBridgeRuleTemplateGroupRequest(input)
	return out, req.Send()
}

// DeleteEventBridgeRuleTemplateGroupWithContext is the same as DeleteEventBridgeRuleTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventBridgeRuleTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteEventBridgeRuleTemplateGroupWithContext(ctx aws.Context, input *DeleteEventBridgeRuleTemplateGroupInput, opts ...request.Option) (*DeleteEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.DeleteEventBridgeRuleTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInput = "DeleteInput"

// DeleteInputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInput for more information on using the DeleteInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInputRequest method.
//	req, resp := client.DeleteInputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInputRequest(input *DeleteInputInput) (req *request.Request, output *DeleteInputOutput) {
	op := &request.Operation{
		Name:       opDeleteInput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DeleteInputInput{}
	}

	output = &DeleteInputOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInput API operation for AWS Elemental MediaLive.
//
// # Deletes the input end point
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput
func (c *MediaLive) DeleteInput(input *DeleteInputInput) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	return out, req.Send()
}

// DeleteInputWithContext is the same as DeleteInput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputWithContext(ctx aws.Context, input *DeleteInputInput, opts ...request.Option) (*DeleteInputOutput, error) {
	req, out := c.DeleteInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInputSecurityGroup = "DeleteInputSecurityGroup"

// DeleteInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInputSecurityGroup for more information on using the DeleteInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInputSecurityGroupRequest method.
//	req, resp := client.DeleteInputSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroupRequest(input *DeleteInputSecurityGroupInput) (req *request.Request, output *DeleteInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteInputSecurityGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DeleteInputSecurityGroupInput{}
	}

	output = &DeleteInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// # Deletes an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup
func (c *MediaLive) DeleteInputSecurityGroup(input *DeleteInputSecurityGroupInput) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DeleteInputSecurityGroupWithContext is the same as DeleteInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteInputSecurityGroupWithContext(ctx aws.Context, input *DeleteInputSecurityGroupInput, opts ...request.Option) (*DeleteInputSecurityGroupOutput, error) {
	req, out := c.DeleteInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMultiplex = "DeleteMultiplex"

// DeleteMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMultiplex for more information on using the DeleteMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMultiplexRequest method.
//	req, resp := client.DeleteMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex
func (c *MediaLive) DeleteMultiplexRequest(input *DeleteMultiplexInput) (req *request.Request, output *DeleteMultiplexOutput) {
	op := &request.Operation{
		Name:       opDeleteMultiplex,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &DeleteMultiplexInput{}
	}

	output = &DeleteMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMultiplex API operation for AWS Elemental MediaLive.
//
// Delete a multiplex. The multiplex must be idle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex
func (c *MediaLive) DeleteMultiplex(input *DeleteMultiplexInput) (*DeleteMultiplexOutput, error) {
	req, out := c.DeleteMultiplexRequest(input)
	return out, req.Send()
}

// DeleteMultiplexWithContext is the same as DeleteMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteMultiplexWithContext(ctx aws.Context, input *DeleteMultiplexInput, opts ...request.Option) (*DeleteMultiplexOutput, error) {
	req, out := c.DeleteMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMultiplexProgram = "DeleteMultiplexProgram"

// DeleteMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMultiplexProgram for more information on using the DeleteMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMultiplexProgramRequest method.
//	req, resp := client.DeleteMultiplexProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram
func (c *MediaLive) DeleteMultiplexProgramRequest(input *DeleteMultiplexProgramInput) (req *request.Request, output *DeleteMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opDeleteMultiplexProgram,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &DeleteMultiplexProgramInput{}
	}

	output = &DeleteMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Delete a program from a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteMultiplexProgram for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram
func (c *MediaLive) DeleteMultiplexProgram(input *DeleteMultiplexProgramInput) (*DeleteMultiplexProgramOutput, error) {
	req, out := c.DeleteMultiplexProgramRequest(input)
	return out, req.Send()
}

// DeleteMultiplexProgramWithContext is the same as DeleteMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteMultiplexProgramWithContext(ctx aws.Context, input *DeleteMultiplexProgramInput, opts ...request.Option) (*DeleteMultiplexProgramOutput, error) {
	req, out := c.DeleteMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReservation = "DeleteReservation"

// DeleteReservationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReservation for more information on using the DeleteReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReservationRequest method.
//	req, resp := client.DeleteReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation
func (c *MediaLive) DeleteReservationRequest(input *DeleteReservationInput) (req *request.Request, output *DeleteReservationOutput) {
	op := &request.Operation{
		Name:       opDeleteReservation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &DeleteReservationInput{}
	}

	output = &DeleteReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReservation API operation for AWS Elemental MediaLive.
//
// Delete an expired reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteReservation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation
func (c *MediaLive) DeleteReservation(input *DeleteReservationInput) (*DeleteReservationOutput, error) {
	req, out := c.DeleteReservationRequest(input)
	return out, req.Send()
}

// DeleteReservationWithContext is the same as DeleteReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteReservationWithContext(ctx aws.Context, input *DeleteReservationInput, opts ...request.Option) (*DeleteReservationOutput, error) {
	req, out := c.DeleteReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSchedule = "DeleteSchedule"

// DeleteScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSchedule for more information on using the DeleteSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScheduleRequest method.
//	req, resp := client.DeleteScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule
func (c *MediaLive) DeleteScheduleRequest(input *DeleteScheduleInput) (req *request.Request, output *DeleteScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSchedule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
	}

	if input == nil {
		input = &DeleteScheduleInput{}
	}

	output = &DeleteScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSchedule API operation for AWS Elemental MediaLive.
//
// Delete all schedule actions on a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteSchedule for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule
func (c *MediaLive) DeleteSchedule(input *DeleteScheduleInput) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	return out, req.Send()
}

// DeleteScheduleWithContext is the same as DeleteSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteScheduleWithContext(ctx aws.Context, input *DeleteScheduleInput, opts ...request.Option) (*DeleteScheduleOutput, error) {
	req, out := c.DeleteScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSignalMap = "DeleteSignalMap"

// DeleteSignalMapRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSignalMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSignalMap for more information on using the DeleteSignalMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSignalMapRequest method.
//	req, resp := client.DeleteSignalMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap
func (c *MediaLive) DeleteSignalMapRequest(input *DeleteSignalMapInput) (req *request.Request, output *DeleteSignalMapOutput) {
	op := &request.Operation{
		Name:       opDeleteSignalMap,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/signal-maps/{identifier}",
	}

	if input == nil {
		input = &DeleteSignalMapInput{}
	}

	output = &DeleteSignalMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSignalMap API operation for AWS Elemental MediaLive.
//
// Deletes the specified signal map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteSignalMap for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap
func (c *MediaLive) DeleteSignalMap(input *DeleteSignalMapInput) (*DeleteSignalMapOutput, error) {
	req, out := c.DeleteSignalMapRequest(input)
	return out, req.Send()
}

// DeleteSignalMapWithContext is the same as DeleteSignalMap with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSignalMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteSignalMapWithContext(ctx aws.Context, input *DeleteSignalMapInput, opts ...request.Option) (*DeleteSignalMapOutput, error) {
	req, out := c.DeleteSignalMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTagsRequest method.
//	req, resp := client.DeleteTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags
func (c *MediaLive) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for AWS Elemental MediaLive.
//
// # Removes tags for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags
func (c *MediaLive) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountConfiguration = "DescribeAccountConfiguration"

// DescribeAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountConfiguration for more information on using the DescribeAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountConfigurationRequest method.
//	req, resp := client.DescribeAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration
func (c *MediaLive) DescribeAccountConfigurationRequest(input *DescribeAccountConfigurationInput) (req *request.Request, output *DescribeAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/accountConfiguration",
	}

	if input == nil {
		input = &DescribeAccountConfigurationInput{}
	}

	output = &DescribeAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountConfiguration API operation for AWS Elemental MediaLive.
//
// # Describe account configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration
func (c *MediaLive) DescribeAccountConfiguration(input *DescribeAccountConfigurationInput) (*DescribeAccountConfigurationOutput, error) {
	req, out := c.DescribeAccountConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAccountConfigurationWithContext is the same as DescribeAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeAccountConfigurationWithContext(ctx aws.Context, input *DescribeAccountConfigurationInput, opts ...request.Option) (*DescribeAccountConfigurationOutput, error) {
	req, out := c.DescribeAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChannel = "DescribeChannel"

// DescribeChannelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeChannel for more information on using the DescribeChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeChannelRequest method.
//	req, resp := client.DescribeChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannelRequest(input *DescribeChannelInput) (req *request.Request, output *DescribeChannelOutput) {
	op := &request.Operation{
		Name:       opDescribeChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &DescribeChannelInput{}
	}

	output = &DescribeChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChannel API operation for AWS Elemental MediaLive.
//
// # Gets details about a channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel
func (c *MediaLive) DescribeChannel(input *DescribeChannelInput) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	return out, req.Send()
}

// DescribeChannelWithContext is the same as DescribeChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeChannelWithContext(ctx aws.Context, input *DescribeChannelInput, opts ...request.Option) (*DescribeChannelOutput, error) {
	req, out := c.DescribeChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInput = "DescribeInput"

// DescribeInputRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInput for more information on using the DescribeInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInputRequest method.
//	req, resp := client.DescribeInputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInputRequest(input *DescribeInputInput) (req *request.Request, output *DescribeInputOutput) {
	op := &request.Operation{
		Name:       opDescribeInput,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &DescribeInputInput{}
	}

	output = &DescribeInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInput API operation for AWS Elemental MediaLive.
//
// # Produces details about an input
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput
func (c *MediaLive) DescribeInput(input *DescribeInputInput) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	return out, req.Send()
}

// DescribeInputWithContext is the same as DescribeInput with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputWithContext(ctx aws.Context, input *DescribeInputInput, opts ...request.Option) (*DescribeInputOutput, error) {
	req, out := c.DescribeInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputDevice = "DescribeInputDevice"

// DescribeInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputDevice for more information on using the DescribeInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInputDeviceRequest method.
//	req, resp := client.DescribeInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice
func (c *MediaLive) DescribeInputDeviceRequest(input *DescribeInputDeviceInput) (req *request.Request, output *DescribeInputDeviceOutput) {
	op := &request.Operation{
		Name:       opDescribeInputDevice,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}",
	}

	if input == nil {
		input = &DescribeInputDeviceInput{}
	}

	output = &DescribeInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputDevice API operation for AWS Elemental MediaLive.
//
// # Gets the details for the input device
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice
func (c *MediaLive) DescribeInputDevice(input *DescribeInputDeviceInput) (*DescribeInputDeviceOutput, error) {
	req, out := c.DescribeInputDeviceRequest(input)
	return out, req.Send()
}

// DescribeInputDeviceWithContext is the same as DescribeInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputDeviceWithContext(ctx aws.Context, input *DescribeInputDeviceInput, opts ...request.Option) (*DescribeInputDeviceOutput, error) {
	req, out := c.DescribeInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputDeviceThumbnail = "DescribeInputDeviceThumbnail"

// DescribeInputDeviceThumbnailRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputDeviceThumbnail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputDeviceThumbnail for more information on using the DescribeInputDeviceThumbnail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInputDeviceThumbnailRequest method.
//	req, resp := client.DescribeInputDeviceThumbnailRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail
func (c *MediaLive) DescribeInputDeviceThumbnailRequest(input *DescribeInputDeviceThumbnailInput) (req *request.Request, output *DescribeInputDeviceThumbnailOutput) {
	op := &request.Operation{
		Name:       opDescribeInputDeviceThumbnail,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/thumbnailData",
	}

	if input == nil {
		input = &DescribeInputDeviceThumbnailInput{}
	}

	output = &DescribeInputDeviceThumbnailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputDeviceThumbnail API operation for AWS Elemental MediaLive.
//
// Get the latest thumbnail data for the input device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputDeviceThumbnail for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail
func (c *MediaLive) DescribeInputDeviceThumbnail(input *DescribeInputDeviceThumbnailInput) (*DescribeInputDeviceThumbnailOutput, error) {
	req, out := c.DescribeInputDeviceThumbnailRequest(input)
	return out, req.Send()
}

// DescribeInputDeviceThumbnailWithContext is the same as DescribeInputDeviceThumbnail with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputDeviceThumbnail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputDeviceThumbnailWithContext(ctx aws.Context, input *DescribeInputDeviceThumbnailInput, opts ...request.Option) (*DescribeInputDeviceThumbnailOutput, error) {
	req, out := c.DescribeInputDeviceThumbnailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInputSecurityGroup = "DescribeInputSecurityGroup"

// DescribeInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInputSecurityGroup for more information on using the DescribeInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInputSecurityGroupRequest method.
//	req, resp := client.DescribeInputSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroupRequest(input *DescribeInputSecurityGroupInput) (req *request.Request, output *DescribeInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeInputSecurityGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &DescribeInputSecurityGroupInput{}
	}

	output = &DescribeInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// # Produces a summary of an Input Security Group
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup
func (c *MediaLive) DescribeInputSecurityGroup(input *DescribeInputSecurityGroupInput) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	return out, req.Send()
}

// DescribeInputSecurityGroupWithContext is the same as DescribeInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeInputSecurityGroupWithContext(ctx aws.Context, input *DescribeInputSecurityGroupInput, opts ...request.Option) (*DescribeInputSecurityGroupOutput, error) {
	req, out := c.DescribeInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMultiplex = "DescribeMultiplex"

// DescribeMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMultiplex for more information on using the DescribeMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMultiplexRequest method.
//	req, resp := client.DescribeMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex
func (c *MediaLive) DescribeMultiplexRequest(input *DescribeMultiplexInput) (req *request.Request, output *DescribeMultiplexOutput) {
	op := &request.Operation{
		Name:       opDescribeMultiplex,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &DescribeMultiplexInput{}
	}

	output = &DescribeMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMultiplex API operation for AWS Elemental MediaLive.
//
// Gets details about a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex
func (c *MediaLive) DescribeMultiplex(input *DescribeMultiplexInput) (*DescribeMultiplexOutput, error) {
	req, out := c.DescribeMultiplexRequest(input)
	return out, req.Send()
}

// DescribeMultiplexWithContext is the same as DescribeMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeMultiplexWithContext(ctx aws.Context, input *DescribeMultiplexInput, opts ...request.Option) (*DescribeMultiplexOutput, error) {
	req, out := c.DescribeMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMultiplexProgram = "DescribeMultiplexProgram"

// DescribeMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMultiplexProgram for more information on using the DescribeMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMultiplexProgramRequest method.
//	req, resp := client.DescribeMultiplexProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram
func (c *MediaLive) DescribeMultiplexProgramRequest(input *DescribeMultiplexProgramInput) (req *request.Request, output *DescribeMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opDescribeMultiplexProgram,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &DescribeMultiplexProgramInput{}
	}

	output = &DescribeMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Get the details for a program in a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeMultiplexProgram for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram
func (c *MediaLive) DescribeMultiplexProgram(input *DescribeMultiplexProgramInput) (*DescribeMultiplexProgramOutput, error) {
	req, out := c.DescribeMultiplexProgramRequest(input)
	return out, req.Send()
}

// DescribeMultiplexProgramWithContext is the same as DescribeMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeMultiplexProgramWithContext(ctx aws.Context, input *DescribeMultiplexProgramInput, opts ...request.Option) (*DescribeMultiplexProgramOutput, error) {
	req, out := c.DescribeMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOffering = "DescribeOffering"

// DescribeOfferingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOffering for more information on using the DescribeOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeOfferingRequest method.
//	req, resp := client.DescribeOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering
func (c *MediaLive) DescribeOfferingRequest(input *DescribeOfferingInput) (req *request.Request, output *DescribeOfferingOutput) {
	op := &request.Operation{
		Name:       opDescribeOffering,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/offerings/{offeringId}",
	}

	if input == nil {
		input = &DescribeOfferingInput{}
	}

	output = &DescribeOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOffering API operation for AWS Elemental MediaLive.
//
// Get details for an offering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeOffering for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering
func (c *MediaLive) DescribeOffering(input *DescribeOfferingInput) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	return out, req.Send()
}

// DescribeOfferingWithContext is the same as DescribeOffering with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeOfferingWithContext(ctx aws.Context, input *DescribeOfferingInput, opts ...request.Option) (*DescribeOfferingOutput, error) {
	req, out := c.DescribeOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReservation = "DescribeReservation"

// DescribeReservationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReservation for more information on using the DescribeReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReservationRequest method.
//	req, resp := client.DescribeReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation
func (c *MediaLive) DescribeReservationRequest(input *DescribeReservationInput) (req *request.Request, output *DescribeReservationOutput) {
	op := &request.Operation{
		Name:       opDescribeReservation,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &DescribeReservationInput{}
	}

	output = &DescribeReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReservation API operation for AWS Elemental MediaLive.
//
// Get details for a reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeReservation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation
func (c *MediaLive) DescribeReservation(input *DescribeReservationInput) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	return out, req.Send()
}

// DescribeReservationWithContext is the same as DescribeReservation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeReservationWithContext(ctx aws.Context, input *DescribeReservationInput, opts ...request.Option) (*DescribeReservationOutput, error) {
	req, out := c.DescribeReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSchedule = "DescribeSchedule"

// DescribeScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchedule for more information on using the DescribeSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScheduleRequest method.
//	req, resp := client.DescribeScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule
func (c *MediaLive) DescribeScheduleRequest(input *DescribeScheduleInput) (req *request.Request, output *DescribeScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSchedule,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}/schedule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduleInput{}
	}

	output = &DescribeScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchedule API operation for AWS Elemental MediaLive.
//
// # Get a channel schedule
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeSchedule for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule
func (c *MediaLive) DescribeSchedule(input *DescribeScheduleInput) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	return out, req.Send()
}

// DescribeScheduleWithContext is the same as DescribeSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeScheduleWithContext(ctx aws.Context, input *DescribeScheduleInput, opts ...request.Option) (*DescribeScheduleOutput, error) {
	req, out := c.DescribeScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSchedulePages iterates over the pages of a DescribeSchedule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSchedule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeSchedule operation.
//	pageNum := 0
//	err := client.DescribeSchedulePages(params,
//	    func(page *medialive.DescribeScheduleOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) DescribeSchedulePages(input *DescribeScheduleInput, fn func(*DescribeScheduleOutput, bool) bool) error {
	return c.DescribeSchedulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSchedulePagesWithContext same as DescribeSchedulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeSchedulePagesWithContext(ctx aws.Context, input *DescribeScheduleInput, fn func(*DescribeScheduleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScheduleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScheduleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScheduleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeThumbnails = "DescribeThumbnails"

// DescribeThumbnailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeThumbnails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeThumbnails for more information on using the DescribeThumbnails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeThumbnailsRequest method.
//	req, resp := client.DescribeThumbnailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails
func (c *MediaLive) DescribeThumbnailsRequest(input *DescribeThumbnailsInput) (req *request.Request, output *DescribeThumbnailsOutput) {
	op := &request.Operation{
		Name:       opDescribeThumbnails,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels/{channelId}/thumbnails",
	}

	if input == nil {
		input = &DescribeThumbnailsInput{}
	}

	output = &DescribeThumbnailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeThumbnails API operation for AWS Elemental MediaLive.
//
// Describe the latest thumbnails data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation DescribeThumbnails for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails
func (c *MediaLive) DescribeThumbnails(input *DescribeThumbnailsInput) (*DescribeThumbnailsOutput, error) {
	req, out := c.DescribeThumbnailsRequest(input)
	return out, req.Send()
}

// DescribeThumbnailsWithContext is the same as DescribeThumbnails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeThumbnails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) DescribeThumbnailsWithContext(ctx aws.Context, input *DescribeThumbnailsInput, opts ...request.Option) (*DescribeThumbnailsOutput, error) {
	req, out := c.DescribeThumbnailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudWatchAlarmTemplate = "GetCloudWatchAlarmTemplate"

// GetCloudWatchAlarmTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudWatchAlarmTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudWatchAlarmTemplate for more information on using the GetCloudWatchAlarmTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCloudWatchAlarmTemplateRequest method.
//	req, resp := client.GetCloudWatchAlarmTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate
func (c *MediaLive) GetCloudWatchAlarmTemplateRequest(input *GetCloudWatchAlarmTemplateInput) (req *request.Request, output *GetCloudWatchAlarmTemplateOutput) {
	op := &request.Operation{
		Name:       opGetCloudWatchAlarmTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/cloudwatch-alarm-templates/{identifier}",
	}

	if input == nil {
		input = &GetCloudWatchAlarmTemplateInput{}
	}

	output = &GetCloudWatchAlarmTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudWatchAlarmTemplate API operation for AWS Elemental MediaLive.
//
// Retrieves the specified cloudwatch alarm template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation GetCloudWatchAlarmTemplate for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate
func (c *MediaLive) GetCloudWatchAlarmTemplate(input *GetCloudWatchAlarmTemplateInput) (*GetCloudWatchAlarmTemplateOutput, error) {
	req, out := c.GetCloudWatchAlarmTemplateRequest(input)
	return out, req.Send()
}

// GetCloudWatchAlarmTemplateWithContext is the same as GetCloudWatchAlarmTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudWatchAlarmTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) GetCloudWatchAlarmTemplateWithContext(ctx aws.Context, input *GetCloudWatchAlarmTemplateInput, opts ...request.Option) (*GetCloudWatchAlarmTemplateOutput, error) {
	req, out := c.GetCloudWatchAlarmTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCloudWatchAlarmTemplateGroup = "GetCloudWatchAlarmTemplateGroup"

// GetCloudWatchAlarmTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetCloudWatchAlarmTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCloudWatchAlarmTemplateGroup for more information on using the GetCloudWatchAlarmTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCloudWatchAlarmTemplateGroupRequest method.
//	req, resp := client.GetCloudWatchAlarmTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup
func (c *MediaLive) GetCloudWatchAlarmTemplateGroupRequest(input *GetCloudWatchAlarmTemplateGroupInput) (req *request.Request, output *GetCloudWatchAlarmTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opGetCloudWatchAlarmTemplateGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/cloudwatch-alarm-template-groups/{identifier}",
	}

	if input == nil {
		input = &GetCloudWatchAlarmTemplateGroupInput{}
	}

	output = &GetCloudWatchAlarmTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCloudWatchAlarmTemplateGroup API operation for AWS Elemental MediaLive.
//
// Retrieves the specified cloudwatch alarm template group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation GetCloudWatchAlarmTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup
func (c *MediaLive) GetCloudWatchAlarmTemplateGroup(input *GetCloudWatchAlarmTemplateGroupInput) (*GetCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.GetCloudWatchAlarmTemplateGroupRequest(input)
	return out, req.Send()
}

// GetCloudWatchAlarmTemplateGroupWithContext is the same as GetCloudWatchAlarmTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetCloudWatchAlarmTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) GetCloudWatchAlarmTemplateGroupWithContext(ctx aws.Context, input *GetCloudWatchAlarmTemplateGroupInput, opts ...request.Option) (*GetCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.GetCloudWatchAlarmTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventBridgeRuleTemplate = "GetEventBridgeRuleTemplate"

// GetEventBridgeRuleTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetEventBridgeRuleTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventBridgeRuleTemplate for more information on using the GetEventBridgeRuleTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventBridgeRuleTemplateRequest method.
//	req, resp := client.GetEventBridgeRuleTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate
func (c *MediaLive) GetEventBridgeRuleTemplateRequest(input *GetEventBridgeRuleTemplateInput) (req *request.Request, output *GetEventBridgeRuleTemplateOutput) {
	op := &request.Operation{
		Name:       opGetEventBridgeRuleTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/eventbridge-rule-templates/{identifier}",
	}

	if input == nil {
		input = &GetEventBridgeRuleTemplateInput{}
	}

	output = &GetEventBridgeRuleTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventBridgeRuleTemplate API operation for AWS Elemental MediaLive.
//
// Retrieves the specified eventbridge rule template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation GetEventBridgeRuleTemplate for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate
func (c *MediaLive) GetEventBridgeRuleTemplate(input *GetEventBridgeRuleTemplateInput) (*GetEventBridgeRuleTemplateOutput, error) {
	req, out := c.GetEventBridgeRuleTemplateRequest(input)
	return out, req.Send()
}

// GetEventBridgeRuleTemplateWithContext is the same as GetEventBridgeRuleTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventBridgeRuleTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) GetEventBridgeRuleTemplateWithContext(ctx aws.Context, input *GetEventBridgeRuleTemplateInput, opts ...request.Option) (*GetEventBridgeRuleTemplateOutput, error) {
	req, out := c.GetEventBridgeRuleTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventBridgeRuleTemplateGroup = "GetEventBridgeRuleTemplateGroup"

// GetEventBridgeRuleTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetEventBridgeRuleTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventBridgeRuleTemplateGroup for more information on using the GetEventBridgeRuleTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventBridgeRuleTemplateGroupRequest method.
//	req, resp := client.GetEventBridgeRuleTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup
func (c *MediaLive) GetEventBridgeRuleTemplateGroupRequest(input *GetEventBridgeRuleTemplateGroupInput) (req *request.Request, output *GetEventBridgeRuleTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opGetEventBridgeRuleTemplateGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/eventbridge-rule-template-groups/{identifier}",
	}

	if input == nil {
		input = &GetEventBridgeRuleTemplateGroupInput{}
	}

	output = &GetEventBridgeRuleTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventBridgeRuleTemplateGroup API operation for AWS Elemental MediaLive.
//
// Retrieves the specified eventbridge rule template group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation GetEventBridgeRuleTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup
func (c *MediaLive) GetEventBridgeRuleTemplateGroup(input *GetEventBridgeRuleTemplateGroupInput) (*GetEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.GetEventBridgeRuleTemplateGroupRequest(input)
	return out, req.Send()
}

// GetEventBridgeRuleTemplateGroupWithContext is the same as GetEventBridgeRuleTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventBridgeRuleTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) GetEventBridgeRuleTemplateGroupWithContext(ctx aws.Context, input *GetEventBridgeRuleTemplateGroupInput, opts ...request.Option) (*GetEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.GetEventBridgeRuleTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSignalMap = "GetSignalMap"

// GetSignalMapRequest generates a "aws/request.Request" representing the
// client's request for the GetSignalMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSignalMap for more information on using the GetSignalMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSignalMapRequest method.
//	req, resp := client.GetSignalMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap
func (c *MediaLive) GetSignalMapRequest(input *GetSignalMapInput) (req *request.Request, output *GetSignalMapOutput) {
	op := &request.Operation{
		Name:       opGetSignalMap,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/signal-maps/{identifier}",
	}

	if input == nil {
		input = &GetSignalMapInput{}
	}

	output = &GetSignalMapOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSignalMap API operation for AWS Elemental MediaLive.
//
// Retrieves the specified signal map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation GetSignalMap for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap
func (c *MediaLive) GetSignalMap(input *GetSignalMapInput) (*GetSignalMapOutput, error) {
	req, out := c.GetSignalMapRequest(input)
	return out, req.Send()
}

// GetSignalMapWithContext is the same as GetSignalMap with the addition of
// the ability to pass a context and additional request options.
//
// See GetSignalMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) GetSignalMapWithContext(ctx aws.Context, input *GetSignalMapInput, opts ...request.Option) (*GetSignalMapOutput, error) {
	req, out := c.GetSignalMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS Elemental MediaLive.
//
// # Produces list of channels that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels
func (c *MediaLive) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *medialive.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCloudWatchAlarmTemplateGroups = "ListCloudWatchAlarmTemplateGroups"

// ListCloudWatchAlarmTemplateGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListCloudWatchAlarmTemplateGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCloudWatchAlarmTemplateGroups for more information on using the ListCloudWatchAlarmTemplateGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCloudWatchAlarmTemplateGroupsRequest method.
//	req, resp := client.ListCloudWatchAlarmTemplateGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups
func (c *MediaLive) ListCloudWatchAlarmTemplateGroupsRequest(input *ListCloudWatchAlarmTemplateGroupsInput) (req *request.Request, output *ListCloudWatchAlarmTemplateGroupsOutput) {
	op := &request.Operation{
		Name:       opListCloudWatchAlarmTemplateGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/cloudwatch-alarm-template-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCloudWatchAlarmTemplateGroupsInput{}
	}

	output = &ListCloudWatchAlarmTemplateGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCloudWatchAlarmTemplateGroups API operation for AWS Elemental MediaLive.
//
// Lists cloudwatch alarm template groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListCloudWatchAlarmTemplateGroups for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups
func (c *MediaLive) ListCloudWatchAlarmTemplateGroups(input *ListCloudWatchAlarmTemplateGroupsInput) (*ListCloudWatchAlarmTemplateGroupsOutput, error) {
	req, out := c.ListCloudWatchAlarmTemplateGroupsRequest(input)
	return out, req.Send()
}

// ListCloudWatchAlarmTemplateGroupsWithContext is the same as ListCloudWatchAlarmTemplateGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListCloudWatchAlarmTemplateGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListCloudWatchAlarmTemplateGroupsWithContext(ctx aws.Context, input *ListCloudWatchAlarmTemplateGroupsInput, opts ...request.Option) (*ListCloudWatchAlarmTemplateGroupsOutput, error) {
	req, out := c.ListCloudWatchAlarmTemplateGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCloudWatchAlarmTemplateGroupsPages iterates over the pages of a ListCloudWatchAlarmTemplateGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCloudWatchAlarmTemplateGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCloudWatchAlarmTemplateGroups operation.
//	pageNum := 0
//	err := client.ListCloudWatchAlarmTemplateGroupsPages(params,
//	    func(page *medialive.ListCloudWatchAlarmTemplateGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListCloudWatchAlarmTemplateGroupsPages(input *ListCloudWatchAlarmTemplateGroupsInput, fn func(*ListCloudWatchAlarmTemplateGroupsOutput, bool) bool) error {
	return c.ListCloudWatchAlarmTemplateGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCloudWatchAlarmTemplateGroupsPagesWithContext same as ListCloudWatchAlarmTemplateGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListCloudWatchAlarmTemplateGroupsPagesWithContext(ctx aws.Context, input *ListCloudWatchAlarmTemplateGroupsInput, fn func(*ListCloudWatchAlarmTemplateGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCloudWatchAlarmTemplateGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCloudWatchAlarmTemplateGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCloudWatchAlarmTemplateGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCloudWatchAlarmTemplates = "ListCloudWatchAlarmTemplates"

// ListCloudWatchAlarmTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCloudWatchAlarmTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCloudWatchAlarmTemplates for more information on using the ListCloudWatchAlarmTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCloudWatchAlarmTemplatesRequest method.
//	req, resp := client.ListCloudWatchAlarmTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates
func (c *MediaLive) ListCloudWatchAlarmTemplatesRequest(input *ListCloudWatchAlarmTemplatesInput) (req *request.Request, output *ListCloudWatchAlarmTemplatesOutput) {
	op := &request.Operation{
		Name:       opListCloudWatchAlarmTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/cloudwatch-alarm-templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCloudWatchAlarmTemplatesInput{}
	}

	output = &ListCloudWatchAlarmTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCloudWatchAlarmTemplates API operation for AWS Elemental MediaLive.
//
// Lists cloudwatch alarm templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListCloudWatchAlarmTemplates for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates
func (c *MediaLive) ListCloudWatchAlarmTemplates(input *ListCloudWatchAlarmTemplatesInput) (*ListCloudWatchAlarmTemplatesOutput, error) {
	req, out := c.ListCloudWatchAlarmTemplatesRequest(input)
	return out, req.Send()
}

// ListCloudWatchAlarmTemplatesWithContext is the same as ListCloudWatchAlarmTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCloudWatchAlarmTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListCloudWatchAlarmTemplatesWithContext(ctx aws.Context, input *ListCloudWatchAlarmTemplatesInput, opts ...request.Option) (*ListCloudWatchAlarmTemplatesOutput, error) {
	req, out := c.ListCloudWatchAlarmTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCloudWatchAlarmTemplatesPages iterates over the pages of a ListCloudWatchAlarmTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCloudWatchAlarmTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCloudWatchAlarmTemplates operation.
//	pageNum := 0
//	err := client.ListCloudWatchAlarmTemplatesPages(params,
//	    func(page *medialive.ListCloudWatchAlarmTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListCloudWatchAlarmTemplatesPages(input *ListCloudWatchAlarmTemplatesInput, fn func(*ListCloudWatchAlarmTemplatesOutput, bool) bool) error {
	return c.ListCloudWatchAlarmTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCloudWatchAlarmTemplatesPagesWithContext same as ListCloudWatchAlarmTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListCloudWatchAlarmTemplatesPagesWithContext(ctx aws.Context, input *ListCloudWatchAlarmTemplatesInput, fn func(*ListCloudWatchAlarmTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCloudWatchAlarmTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCloudWatchAlarmTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCloudWatchAlarmTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventBridgeRuleTemplateGroups = "ListEventBridgeRuleTemplateGroups"

// ListEventBridgeRuleTemplateGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventBridgeRuleTemplateGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventBridgeRuleTemplateGroups for more information on using the ListEventBridgeRuleTemplateGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventBridgeRuleTemplateGroupsRequest method.
//	req, resp := client.ListEventBridgeRuleTemplateGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups
func (c *MediaLive) ListEventBridgeRuleTemplateGroupsRequest(input *ListEventBridgeRuleTemplateGroupsInput) (req *request.Request, output *ListEventBridgeRuleTemplateGroupsOutput) {
	op := &request.Operation{
		Name:       opListEventBridgeRuleTemplateGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/eventbridge-rule-template-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventBridgeRuleTemplateGroupsInput{}
	}

	output = &ListEventBridgeRuleTemplateGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventBridgeRuleTemplateGroups API operation for AWS Elemental MediaLive.
//
// Lists eventbridge rule template groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListEventBridgeRuleTemplateGroups for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups
func (c *MediaLive) ListEventBridgeRuleTemplateGroups(input *ListEventBridgeRuleTemplateGroupsInput) (*ListEventBridgeRuleTemplateGroupsOutput, error) {
	req, out := c.ListEventBridgeRuleTemplateGroupsRequest(input)
	return out, req.Send()
}

// ListEventBridgeRuleTemplateGroupsWithContext is the same as ListEventBridgeRuleTemplateGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventBridgeRuleTemplateGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListEventBridgeRuleTemplateGroupsWithContext(ctx aws.Context, input *ListEventBridgeRuleTemplateGroupsInput, opts ...request.Option) (*ListEventBridgeRuleTemplateGroupsOutput, error) {
	req, out := c.ListEventBridgeRuleTemplateGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventBridgeRuleTemplateGroupsPages iterates over the pages of a ListEventBridgeRuleTemplateGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventBridgeRuleTemplateGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventBridgeRuleTemplateGroups operation.
//	pageNum := 0
//	err := client.ListEventBridgeRuleTemplateGroupsPages(params,
//	    func(page *medialive.ListEventBridgeRuleTemplateGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListEventBridgeRuleTemplateGroupsPages(input *ListEventBridgeRuleTemplateGroupsInput, fn func(*ListEventBridgeRuleTemplateGroupsOutput, bool) bool) error {
	return c.ListEventBridgeRuleTemplateGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventBridgeRuleTemplateGroupsPagesWithContext same as ListEventBridgeRuleTemplateGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListEventBridgeRuleTemplateGroupsPagesWithContext(ctx aws.Context, input *ListEventBridgeRuleTemplateGroupsInput, fn func(*ListEventBridgeRuleTemplateGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventBridgeRuleTemplateGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventBridgeRuleTemplateGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventBridgeRuleTemplateGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventBridgeRuleTemplates = "ListEventBridgeRuleTemplates"

// ListEventBridgeRuleTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListEventBridgeRuleTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventBridgeRuleTemplates for more information on using the ListEventBridgeRuleTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventBridgeRuleTemplatesRequest method.
//	req, resp := client.ListEventBridgeRuleTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates
func (c *MediaLive) ListEventBridgeRuleTemplatesRequest(input *ListEventBridgeRuleTemplatesInput) (req *request.Request, output *ListEventBridgeRuleTemplatesOutput) {
	op := &request.Operation{
		Name:       opListEventBridgeRuleTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/eventbridge-rule-templates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventBridgeRuleTemplatesInput{}
	}

	output = &ListEventBridgeRuleTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventBridgeRuleTemplates API operation for AWS Elemental MediaLive.
//
// Lists eventbridge rule templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListEventBridgeRuleTemplates for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates
func (c *MediaLive) ListEventBridgeRuleTemplates(input *ListEventBridgeRuleTemplatesInput) (*ListEventBridgeRuleTemplatesOutput, error) {
	req, out := c.ListEventBridgeRuleTemplatesRequest(input)
	return out, req.Send()
}

// ListEventBridgeRuleTemplatesWithContext is the same as ListEventBridgeRuleTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventBridgeRuleTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListEventBridgeRuleTemplatesWithContext(ctx aws.Context, input *ListEventBridgeRuleTemplatesInput, opts ...request.Option) (*ListEventBridgeRuleTemplatesOutput, error) {
	req, out := c.ListEventBridgeRuleTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventBridgeRuleTemplatesPages iterates over the pages of a ListEventBridgeRuleTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventBridgeRuleTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventBridgeRuleTemplates operation.
//	pageNum := 0
//	err := client.ListEventBridgeRuleTemplatesPages(params,
//	    func(page *medialive.ListEventBridgeRuleTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListEventBridgeRuleTemplatesPages(input *ListEventBridgeRuleTemplatesInput, fn func(*ListEventBridgeRuleTemplatesOutput, bool) bool) error {
	return c.ListEventBridgeRuleTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventBridgeRuleTemplatesPagesWithContext same as ListEventBridgeRuleTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListEventBridgeRuleTemplatesPagesWithContext(ctx aws.Context, input *ListEventBridgeRuleTemplatesInput, fn func(*ListEventBridgeRuleTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventBridgeRuleTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventBridgeRuleTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventBridgeRuleTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputDeviceTransfers = "ListInputDeviceTransfers"

// ListInputDeviceTransfersRequest generates a "aws/request.Request" representing the
// client's request for the ListInputDeviceTransfers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputDeviceTransfers for more information on using the ListInputDeviceTransfers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInputDeviceTransfersRequest method.
//	req, resp := client.ListInputDeviceTransfersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers
func (c *MediaLive) ListInputDeviceTransfersRequest(input *ListInputDeviceTransfersInput) (req *request.Request, output *ListInputDeviceTransfersOutput) {
	op := &request.Operation{
		Name:       opListInputDeviceTransfers,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDeviceTransfers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputDeviceTransfersInput{}
	}

	output = &ListInputDeviceTransfersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputDeviceTransfers API operation for AWS Elemental MediaLive.
//
// List input devices that are currently being transferred. List input devices
// that you are transferring from your AWS account or input devices that another
// AWS account is transferring to you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputDeviceTransfers for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers
func (c *MediaLive) ListInputDeviceTransfers(input *ListInputDeviceTransfersInput) (*ListInputDeviceTransfersOutput, error) {
	req, out := c.ListInputDeviceTransfersRequest(input)
	return out, req.Send()
}

// ListInputDeviceTransfersWithContext is the same as ListInputDeviceTransfers with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputDeviceTransfers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDeviceTransfersWithContext(ctx aws.Context, input *ListInputDeviceTransfersInput, opts ...request.Option) (*ListInputDeviceTransfersOutput, error) {
	req, out := c.ListInputDeviceTransfersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputDeviceTransfersPages iterates over the pages of a ListInputDeviceTransfers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputDeviceTransfers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInputDeviceTransfers operation.
//	pageNum := 0
//	err := client.ListInputDeviceTransfersPages(params,
//	    func(page *medialive.ListInputDeviceTransfersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListInputDeviceTransfersPages(input *ListInputDeviceTransfersInput, fn func(*ListInputDeviceTransfersOutput, bool) bool) error {
	return c.ListInputDeviceTransfersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputDeviceTransfersPagesWithContext same as ListInputDeviceTransfersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDeviceTransfersPagesWithContext(ctx aws.Context, input *ListInputDeviceTransfersInput, fn func(*ListInputDeviceTransfersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputDeviceTransfersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputDeviceTransfersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputDeviceTransfersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputDevices = "ListInputDevices"

// ListInputDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListInputDevices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputDevices for more information on using the ListInputDevices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInputDevicesRequest method.
//	req, resp := client.ListInputDevicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices
func (c *MediaLive) ListInputDevicesRequest(input *ListInputDevicesInput) (req *request.Request, output *ListInputDevicesOutput) {
	op := &request.Operation{
		Name:       opListInputDevices,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputDevices",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputDevicesInput{}
	}

	output = &ListInputDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputDevices API operation for AWS Elemental MediaLive.
//
// # List input devices
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputDevices for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices
func (c *MediaLive) ListInputDevices(input *ListInputDevicesInput) (*ListInputDevicesOutput, error) {
	req, out := c.ListInputDevicesRequest(input)
	return out, req.Send()
}

// ListInputDevicesWithContext is the same as ListInputDevices with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDevicesWithContext(ctx aws.Context, input *ListInputDevicesInput, opts ...request.Option) (*ListInputDevicesOutput, error) {
	req, out := c.ListInputDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputDevicesPages iterates over the pages of a ListInputDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInputDevices operation.
//	pageNum := 0
//	err := client.ListInputDevicesPages(params,
//	    func(page *medialive.ListInputDevicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListInputDevicesPages(input *ListInputDevicesInput, fn func(*ListInputDevicesOutput, bool) bool) error {
	return c.ListInputDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputDevicesPagesWithContext same as ListInputDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputDevicesPagesWithContext(ctx aws.Context, input *ListInputDevicesInput, fn func(*ListInputDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputDevicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputDevicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputDevicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputSecurityGroups = "ListInputSecurityGroups"

// ListInputSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputSecurityGroups for more information on using the ListInputSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInputSecurityGroupsRequest method.
//	req, resp := client.ListInputSecurityGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroupsRequest(input *ListInputSecurityGroupsInput) (req *request.Request, output *ListInputSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opListInputSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputSecurityGroups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputSecurityGroupsInput{}
	}

	output = &ListInputSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputSecurityGroups API operation for AWS Elemental MediaLive.
//
// # Produces a list of Input Security Groups for an account
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputSecurityGroups for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups
func (c *MediaLive) ListInputSecurityGroups(input *ListInputSecurityGroupsInput) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	return out, req.Send()
}

// ListInputSecurityGroupsWithContext is the same as ListInputSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, opts ...request.Option) (*ListInputSecurityGroupsOutput, error) {
	req, out := c.ListInputSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputSecurityGroupsPages iterates over the pages of a ListInputSecurityGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputSecurityGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInputSecurityGroups operation.
//	pageNum := 0
//	err := client.ListInputSecurityGroupsPages(params,
//	    func(page *medialive.ListInputSecurityGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListInputSecurityGroupsPages(input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool) error {
	return c.ListInputSecurityGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputSecurityGroupsPagesWithContext same as ListInputSecurityGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputSecurityGroupsPagesWithContext(ctx aws.Context, input *ListInputSecurityGroupsInput, fn func(*ListInputSecurityGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputSecurityGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputSecurityGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputSecurityGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInputs = "ListInputs"

// ListInputsRequest generates a "aws/request.Request" representing the
// client's request for the ListInputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInputs for more information on using the ListInputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInputsRequest method.
//	req, resp := client.ListInputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputsRequest(input *ListInputsInput) (req *request.Request, output *ListInputsOutput) {
	op := &request.Operation{
		Name:       opListInputs,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/inputs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInputsInput{}
	}

	output = &ListInputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInputs API operation for AWS Elemental MediaLive.
//
// # Produces list of inputs that have been created
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListInputs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs
func (c *MediaLive) ListInputs(input *ListInputsInput) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	return out, req.Send()
}

// ListInputsWithContext is the same as ListInputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListInputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsWithContext(ctx aws.Context, input *ListInputsInput, opts ...request.Option) (*ListInputsOutput, error) {
	req, out := c.ListInputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInputsPages iterates over the pages of a ListInputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInputs operation.
//	pageNum := 0
//	err := client.ListInputsPages(params,
//	    func(page *medialive.ListInputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListInputsPages(input *ListInputsInput, fn func(*ListInputsOutput, bool) bool) error {
	return c.ListInputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInputsPagesWithContext same as ListInputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListInputsPagesWithContext(ctx aws.Context, input *ListInputsInput, fn func(*ListInputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultiplexPrograms = "ListMultiplexPrograms"

// ListMultiplexProgramsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultiplexPrograms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultiplexPrograms for more information on using the ListMultiplexPrograms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMultiplexProgramsRequest method.
//	req, resp := client.ListMultiplexProgramsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms
func (c *MediaLive) ListMultiplexProgramsRequest(input *ListMultiplexProgramsInput) (req *request.Request, output *ListMultiplexProgramsOutput) {
	op := &request.Operation{
		Name:       opListMultiplexPrograms,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiplexProgramsInput{}
	}

	output = &ListMultiplexProgramsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultiplexPrograms API operation for AWS Elemental MediaLive.
//
// List the programs that currently exist for a specific multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListMultiplexPrograms for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms
func (c *MediaLive) ListMultiplexPrograms(input *ListMultiplexProgramsInput) (*ListMultiplexProgramsOutput, error) {
	req, out := c.ListMultiplexProgramsRequest(input)
	return out, req.Send()
}

// ListMultiplexProgramsWithContext is the same as ListMultiplexPrograms with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultiplexPrograms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexProgramsWithContext(ctx aws.Context, input *ListMultiplexProgramsInput, opts ...request.Option) (*ListMultiplexProgramsOutput, error) {
	req, out := c.ListMultiplexProgramsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultiplexProgramsPages iterates over the pages of a ListMultiplexPrograms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultiplexPrograms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMultiplexPrograms operation.
//	pageNum := 0
//	err := client.ListMultiplexProgramsPages(params,
//	    func(page *medialive.ListMultiplexProgramsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListMultiplexProgramsPages(input *ListMultiplexProgramsInput, fn func(*ListMultiplexProgramsOutput, bool) bool) error {
	return c.ListMultiplexProgramsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultiplexProgramsPagesWithContext same as ListMultiplexProgramsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexProgramsPagesWithContext(ctx aws.Context, input *ListMultiplexProgramsInput, fn func(*ListMultiplexProgramsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultiplexProgramsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultiplexProgramsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultiplexProgramsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMultiplexes = "ListMultiplexes"

// ListMultiplexesRequest generates a "aws/request.Request" representing the
// client's request for the ListMultiplexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultiplexes for more information on using the ListMultiplexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMultiplexesRequest method.
//	req, resp := client.ListMultiplexesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes
func (c *MediaLive) ListMultiplexesRequest(input *ListMultiplexesInput) (req *request.Request, output *ListMultiplexesOutput) {
	op := &request.Operation{
		Name:       opListMultiplexes,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/multiplexes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultiplexesInput{}
	}

	output = &ListMultiplexesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultiplexes API operation for AWS Elemental MediaLive.
//
// Retrieve a list of the existing multiplexes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListMultiplexes for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes
func (c *MediaLive) ListMultiplexes(input *ListMultiplexesInput) (*ListMultiplexesOutput, error) {
	req, out := c.ListMultiplexesRequest(input)
	return out, req.Send()
}

// ListMultiplexesWithContext is the same as ListMultiplexes with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultiplexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexesWithContext(ctx aws.Context, input *ListMultiplexesInput, opts ...request.Option) (*ListMultiplexesOutput, error) {
	req, out := c.ListMultiplexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultiplexesPages iterates over the pages of a ListMultiplexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultiplexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMultiplexes operation.
//	pageNum := 0
//	err := client.ListMultiplexesPages(params,
//	    func(page *medialive.ListMultiplexesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListMultiplexesPages(input *ListMultiplexesInput, fn func(*ListMultiplexesOutput, bool) bool) error {
	return c.ListMultiplexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultiplexesPagesWithContext same as ListMultiplexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListMultiplexesPagesWithContext(ctx aws.Context, input *ListMultiplexesInput, fn func(*ListMultiplexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultiplexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultiplexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMultiplexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOfferings = "ListOfferings"

// ListOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOfferings for more information on using the ListOfferings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOfferingsRequest method.
//	req, resp := client.ListOfferingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings
func (c *MediaLive) ListOfferingsRequest(input *ListOfferingsInput) (req *request.Request, output *ListOfferingsOutput) {
	op := &request.Operation{
		Name:       opListOfferings,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/offerings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingsInput{}
	}

	output = &ListOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferings API operation for AWS Elemental MediaLive.
//
// List offerings available for purchase.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListOfferings for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings
func (c *MediaLive) ListOfferings(input *ListOfferingsInput) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	return out, req.Send()
}

// ListOfferingsWithContext is the same as ListOfferings with the addition of
// the ability to pass a context and additional request options.
//
// See ListOfferings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListOfferingsWithContext(ctx aws.Context, input *ListOfferingsInput, opts ...request.Option) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOfferingsPages iterates over the pages of a ListOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOfferings operation.
//	pageNum := 0
//	err := client.ListOfferingsPages(params,
//	    func(page *medialive.ListOfferingsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListOfferingsPages(input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool) error {
	return c.ListOfferingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOfferingsPagesWithContext same as ListOfferingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListOfferingsPagesWithContext(ctx aws.Context, input *ListOfferingsInput, fn func(*ListOfferingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOfferingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOfferingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOfferingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReservations = "ListReservations"

// ListReservationsRequest generates a "aws/request.Request" representing the
// client's request for the ListReservations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReservations for more information on using the ListReservations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReservationsRequest method.
//	req, resp := client.ListReservationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations
func (c *MediaLive) ListReservationsRequest(input *ListReservationsInput) (req *request.Request, output *ListReservationsOutput) {
	op := &request.Operation{
		Name:       opListReservations,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/reservations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReservationsInput{}
	}

	output = &ListReservationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReservations API operation for AWS Elemental MediaLive.
//
// List purchased reservations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListReservations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations
func (c *MediaLive) ListReservations(input *ListReservationsInput) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	return out, req.Send()
}

// ListReservationsWithContext is the same as ListReservations with the addition of
// the ability to pass a context and additional request options.
//
// See ListReservations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListReservationsWithContext(ctx aws.Context, input *ListReservationsInput, opts ...request.Option) (*ListReservationsOutput, error) {
	req, out := c.ListReservationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReservationsPages iterates over the pages of a ListReservations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReservations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReservations operation.
//	pageNum := 0
//	err := client.ListReservationsPages(params,
//	    func(page *medialive.ListReservationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListReservationsPages(input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool) error {
	return c.ListReservationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReservationsPagesWithContext same as ListReservationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListReservationsPagesWithContext(ctx aws.Context, input *ListReservationsInput, fn func(*ListReservationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReservationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReservationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReservationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSignalMaps = "ListSignalMaps"

// ListSignalMapsRequest generates a "aws/request.Request" representing the
// client's request for the ListSignalMaps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSignalMaps for more information on using the ListSignalMaps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSignalMapsRequest method.
//	req, resp := client.ListSignalMapsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps
func (c *MediaLive) ListSignalMapsRequest(input *ListSignalMapsInput) (req *request.Request, output *ListSignalMapsOutput) {
	op := &request.Operation{
		Name:       opListSignalMaps,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/signal-maps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSignalMapsInput{}
	}

	output = &ListSignalMapsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSignalMaps API operation for AWS Elemental MediaLive.
//
// Lists signal maps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListSignalMaps for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps
func (c *MediaLive) ListSignalMaps(input *ListSignalMapsInput) (*ListSignalMapsOutput, error) {
	req, out := c.ListSignalMapsRequest(input)
	return out, req.Send()
}

// ListSignalMapsWithContext is the same as ListSignalMaps with the addition of
// the ability to pass a context and additional request options.
//
// See ListSignalMaps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListSignalMapsWithContext(ctx aws.Context, input *ListSignalMapsInput, opts ...request.Option) (*ListSignalMapsOutput, error) {
	req, out := c.ListSignalMapsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSignalMapsPages iterates over the pages of a ListSignalMaps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSignalMaps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSignalMaps operation.
//	pageNum := 0
//	err := client.ListSignalMapsPages(params,
//	    func(page *medialive.ListSignalMapsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaLive) ListSignalMapsPages(input *ListSignalMapsInput, fn func(*ListSignalMapsOutput, bool) bool) error {
	return c.ListSignalMapsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSignalMapsPagesWithContext same as ListSignalMapsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListSignalMapsPagesWithContext(ctx aws.Context, input *ListSignalMapsInput, fn func(*ListSignalMapsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSignalMapsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSignalMapsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSignalMapsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource
func (c *MediaLive) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/prod/tags/{resource-arn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaLive.
//
// # Produces list of tags that have been created for a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource
func (c *MediaLive) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseOffering operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PurchaseOffering for more information on using the PurchaseOffering
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PurchaseOfferingRequest method.
//	req, resp := client.PurchaseOfferingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering
func (c *MediaLive) PurchaseOfferingRequest(input *PurchaseOfferingInput) (req *request.Request, output *PurchaseOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/offerings/{offeringId}/purchase",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	output = &PurchaseOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseOffering API operation for AWS Elemental MediaLive.
//
// Purchase an offering and create a reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation PurchaseOffering for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering
func (c *MediaLive) PurchaseOffering(input *PurchaseOfferingInput) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	return out, req.Send()
}

// PurchaseOfferingWithContext is the same as PurchaseOffering with the addition of
// the ability to pass a context and additional request options.
//
// See PurchaseOffering for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) PurchaseOfferingWithContext(ctx aws.Context, input *PurchaseOfferingInput, opts ...request.Option) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootInputDevice = "RebootInputDevice"

// RebootInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the RebootInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootInputDevice for more information on using the RebootInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RebootInputDeviceRequest method.
//	req, resp := client.RebootInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice
func (c *MediaLive) RebootInputDeviceRequest(input *RebootInputDeviceInput) (req *request.Request, output *RebootInputDeviceOutput) {
	op := &request.Operation{
		Name:       opRebootInputDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/reboot",
	}

	if input == nil {
		input = &RebootInputDeviceInput{}
	}

	output = &RebootInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RebootInputDevice API operation for AWS Elemental MediaLive.
//
// Send a reboot command to the specified input device. The device will begin
// rebooting within a few seconds of sending the command. When the reboot is
// complete, the device’s connection status will change to connected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation RebootInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice
func (c *MediaLive) RebootInputDevice(input *RebootInputDeviceInput) (*RebootInputDeviceOutput, error) {
	req, out := c.RebootInputDeviceRequest(input)
	return out, req.Send()
}

// RebootInputDeviceWithContext is the same as RebootInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See RebootInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) RebootInputDeviceWithContext(ctx aws.Context, input *RebootInputDeviceInput, opts ...request.Option) (*RebootInputDeviceOutput, error) {
	req, out := c.RebootInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectInputDeviceTransfer = "RejectInputDeviceTransfer"

// RejectInputDeviceTransferRequest generates a "aws/request.Request" representing the
// client's request for the RejectInputDeviceTransfer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInputDeviceTransfer for more information on using the RejectInputDeviceTransfer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectInputDeviceTransferRequest method.
//	req, resp := client.RejectInputDeviceTransferRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer
func (c *MediaLive) RejectInputDeviceTransferRequest(input *RejectInputDeviceTransferInput) (req *request.Request, output *RejectInputDeviceTransferOutput) {
	op := &request.Operation{
		Name:       opRejectInputDeviceTransfer,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/reject",
	}

	if input == nil {
		input = &RejectInputDeviceTransferInput{}
	}

	output = &RejectInputDeviceTransferOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectInputDeviceTransfer API operation for AWS Elemental MediaLive.
//
// Reject the transfer of the specified input device to your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation RejectInputDeviceTransfer for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer
func (c *MediaLive) RejectInputDeviceTransfer(input *RejectInputDeviceTransferInput) (*RejectInputDeviceTransferOutput, error) {
	req, out := c.RejectInputDeviceTransferRequest(input)
	return out, req.Send()
}

// RejectInputDeviceTransferWithContext is the same as RejectInputDeviceTransfer with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInputDeviceTransfer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) RejectInputDeviceTransferWithContext(ctx aws.Context, input *RejectInputDeviceTransferInput, opts ...request.Option) (*RejectInputDeviceTransferOutput, error) {
	req, out := c.RejectInputDeviceTransferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestartChannelPipelines = "RestartChannelPipelines"

// RestartChannelPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the RestartChannelPipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestartChannelPipelines for more information on using the RestartChannelPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestartChannelPipelinesRequest method.
//	req, resp := client.RestartChannelPipelinesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines
func (c *MediaLive) RestartChannelPipelinesRequest(input *RestartChannelPipelinesInput) (req *request.Request, output *RestartChannelPipelinesOutput) {
	op := &request.Operation{
		Name:       opRestartChannelPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/restartChannelPipelines",
	}

	if input == nil {
		input = &RestartChannelPipelinesInput{}
	}

	output = &RestartChannelPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestartChannelPipelines API operation for AWS Elemental MediaLive.
//
// Restart pipelines in one channel that is currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation RestartChannelPipelines for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines
func (c *MediaLive) RestartChannelPipelines(input *RestartChannelPipelinesInput) (*RestartChannelPipelinesOutput, error) {
	req, out := c.RestartChannelPipelinesRequest(input)
	return out, req.Send()
}

// RestartChannelPipelinesWithContext is the same as RestartChannelPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See RestartChannelPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) RestartChannelPipelinesWithContext(ctx aws.Context, input *RestartChannelPipelinesInput, opts ...request.Option) (*RestartChannelPipelinesOutput, error) {
	req, out := c.RestartChannelPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartChannel = "StartChannel"

// StartChannelRequest generates a "aws/request.Request" representing the
// client's request for the StartChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChannel for more information on using the StartChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartChannelRequest method.
//	req, resp := client.StartChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannelRequest(input *StartChannelInput) (req *request.Request, output *StartChannelOutput) {
	op := &request.Operation{
		Name:       opStartChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/start",
	}

	if input == nil {
		input = &StartChannelInput{}
	}

	output = &StartChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChannel API operation for AWS Elemental MediaLive.
//
// # Starts an existing channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel
func (c *MediaLive) StartChannel(input *StartChannelInput) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	return out, req.Send()
}

// StartChannelWithContext is the same as StartChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StartChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartChannelWithContext(ctx aws.Context, input *StartChannelInput, opts ...request.Option) (*StartChannelOutput, error) {
	req, out := c.StartChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeleteMonitorDeployment = "StartDeleteMonitorDeployment"

// StartDeleteMonitorDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartDeleteMonitorDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeleteMonitorDeployment for more information on using the StartDeleteMonitorDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDeleteMonitorDeploymentRequest method.
//	req, resp := client.StartDeleteMonitorDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment
func (c *MediaLive) StartDeleteMonitorDeploymentRequest(input *StartDeleteMonitorDeploymentInput) (req *request.Request, output *StartDeleteMonitorDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartDeleteMonitorDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prod/signal-maps/{identifier}/monitor-deployment",
	}

	if input == nil {
		input = &StartDeleteMonitorDeploymentInput{}
	}

	output = &StartDeleteMonitorDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDeleteMonitorDeployment API operation for AWS Elemental MediaLive.
//
// Initiates a deployment to delete the monitor of the specified signal map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartDeleteMonitorDeployment for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment
func (c *MediaLive) StartDeleteMonitorDeployment(input *StartDeleteMonitorDeploymentInput) (*StartDeleteMonitorDeploymentOutput, error) {
	req, out := c.StartDeleteMonitorDeploymentRequest(input)
	return out, req.Send()
}

// StartDeleteMonitorDeploymentWithContext is the same as StartDeleteMonitorDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeleteMonitorDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartDeleteMonitorDeploymentWithContext(ctx aws.Context, input *StartDeleteMonitorDeploymentInput, opts ...request.Option) (*StartDeleteMonitorDeploymentOutput, error) {
	req, out := c.StartDeleteMonitorDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInputDevice = "StartInputDevice"

// StartInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the StartInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInputDevice for more information on using the StartInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartInputDeviceRequest method.
//	req, resp := client.StartInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice
func (c *MediaLive) StartInputDeviceRequest(input *StartInputDeviceInput) (req *request.Request, output *StartInputDeviceOutput) {
	op := &request.Operation{
		Name:       opStartInputDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/start",
	}

	if input == nil {
		input = &StartInputDeviceInput{}
	}

	output = &StartInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartInputDevice API operation for AWS Elemental MediaLive.
//
// Start an input device that is attached to a MediaConnect flow. (There is
// no need to start a device that is attached to a MediaLive input; MediaLive
// starts the device when the channel starts.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice
func (c *MediaLive) StartInputDevice(input *StartInputDeviceInput) (*StartInputDeviceOutput, error) {
	req, out := c.StartInputDeviceRequest(input)
	return out, req.Send()
}

// StartInputDeviceWithContext is the same as StartInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See StartInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartInputDeviceWithContext(ctx aws.Context, input *StartInputDeviceInput, opts ...request.Option) (*StartInputDeviceOutput, error) {
	req, out := c.StartInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInputDeviceMaintenanceWindow = "StartInputDeviceMaintenanceWindow"

// StartInputDeviceMaintenanceWindowRequest generates a "aws/request.Request" representing the
// client's request for the StartInputDeviceMaintenanceWindow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInputDeviceMaintenanceWindow for more information on using the StartInputDeviceMaintenanceWindow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartInputDeviceMaintenanceWindowRequest method.
//	req, resp := client.StartInputDeviceMaintenanceWindowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow
func (c *MediaLive) StartInputDeviceMaintenanceWindowRequest(input *StartInputDeviceMaintenanceWindowInput) (req *request.Request, output *StartInputDeviceMaintenanceWindowOutput) {
	op := &request.Operation{
		Name:       opStartInputDeviceMaintenanceWindow,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/startInputDeviceMaintenanceWindow",
	}

	if input == nil {
		input = &StartInputDeviceMaintenanceWindowInput{}
	}

	output = &StartInputDeviceMaintenanceWindowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartInputDeviceMaintenanceWindow API operation for AWS Elemental MediaLive.
//
// Start a maintenance window for the specified input device. Starting a maintenance
// window will give the device up to two hours to install software. If the device
// was streaming prior to the maintenance, it will resume streaming when the
// software is fully installed. Devices automatically install updates while
// they are powered on and their MediaLive channels are stopped. A maintenance
// window allows you to update a device without having to stop MediaLive channels
// that use the device. The device must remain powered on and connected to the
// internet for the duration of the maintenance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartInputDeviceMaintenanceWindow for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow
func (c *MediaLive) StartInputDeviceMaintenanceWindow(input *StartInputDeviceMaintenanceWindowInput) (*StartInputDeviceMaintenanceWindowOutput, error) {
	req, out := c.StartInputDeviceMaintenanceWindowRequest(input)
	return out, req.Send()
}

// StartInputDeviceMaintenanceWindowWithContext is the same as StartInputDeviceMaintenanceWindow with the addition of
// the ability to pass a context and additional request options.
//
// See StartInputDeviceMaintenanceWindow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartInputDeviceMaintenanceWindowWithContext(ctx aws.Context, input *StartInputDeviceMaintenanceWindowInput, opts ...request.Option) (*StartInputDeviceMaintenanceWindowOutput, error) {
	req, out := c.StartInputDeviceMaintenanceWindowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMonitorDeployment = "StartMonitorDeployment"

// StartMonitorDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitorDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitorDeployment for more information on using the StartMonitorDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMonitorDeploymentRequest method.
//	req, resp := client.StartMonitorDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment
func (c *MediaLive) StartMonitorDeploymentRequest(input *StartMonitorDeploymentInput) (req *request.Request, output *StartMonitorDeploymentOutput) {
	op := &request.Operation{
		Name:       opStartMonitorDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/signal-maps/{identifier}/monitor-deployment",
	}

	if input == nil {
		input = &StartMonitorDeploymentInput{}
	}

	output = &StartMonitorDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMonitorDeployment API operation for AWS Elemental MediaLive.
//
// Initiates a deployment to deploy the latest monitor of the specified signal
// map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartMonitorDeployment for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment
func (c *MediaLive) StartMonitorDeployment(input *StartMonitorDeploymentInput) (*StartMonitorDeploymentOutput, error) {
	req, out := c.StartMonitorDeploymentRequest(input)
	return out, req.Send()
}

// StartMonitorDeploymentWithContext is the same as StartMonitorDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitorDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartMonitorDeploymentWithContext(ctx aws.Context, input *StartMonitorDeploymentInput, opts ...request.Option) (*StartMonitorDeploymentOutput, error) {
	req, out := c.StartMonitorDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMultiplex = "StartMultiplex"

// StartMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the StartMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMultiplex for more information on using the StartMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMultiplexRequest method.
//	req, resp := client.StartMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex
func (c *MediaLive) StartMultiplexRequest(input *StartMultiplexInput) (req *request.Request, output *StartMultiplexOutput) {
	op := &request.Operation{
		Name:       opStartMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/start",
	}

	if input == nil {
		input = &StartMultiplexInput{}
	}

	output = &StartMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMultiplex API operation for AWS Elemental MediaLive.
//
// Start (run) the multiplex. Starting the multiplex does not start the channels.
// You must explicitly start each channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex
func (c *MediaLive) StartMultiplex(input *StartMultiplexInput) (*StartMultiplexOutput, error) {
	req, out := c.StartMultiplexRequest(input)
	return out, req.Send()
}

// StartMultiplexWithContext is the same as StartMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See StartMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartMultiplexWithContext(ctx aws.Context, input *StartMultiplexInput, opts ...request.Option) (*StartMultiplexOutput, error) {
	req, out := c.StartMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartUpdateSignalMap = "StartUpdateSignalMap"

// StartUpdateSignalMapRequest generates a "aws/request.Request" representing the
// client's request for the StartUpdateSignalMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartUpdateSignalMap for more information on using the StartUpdateSignalMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartUpdateSignalMapRequest method.
//	req, resp := client.StartUpdateSignalMapRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap
func (c *MediaLive) StartUpdateSignalMapRequest(input *StartUpdateSignalMapInput) (req *request.Request, output *StartUpdateSignalMapOutput) {
	op := &request.Operation{
		Name:       opStartUpdateSignalMap,
		HTTPMethod: "PATCH",
		HTTPPath:   "/prod/signal-maps/{identifier}",
	}

	if input == nil {
		input = &StartUpdateSignalMapInput{}
	}

	output = &StartUpdateSignalMapOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartUpdateSignalMap API operation for AWS Elemental MediaLive.
//
// Initiates an update for the specified signal map. Will discover a new signal
// map if a changed discoveryEntryPointArn is provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StartUpdateSignalMap for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap
func (c *MediaLive) StartUpdateSignalMap(input *StartUpdateSignalMapInput) (*StartUpdateSignalMapOutput, error) {
	req, out := c.StartUpdateSignalMapRequest(input)
	return out, req.Send()
}

// StartUpdateSignalMapWithContext is the same as StartUpdateSignalMap with the addition of
// the ability to pass a context and additional request options.
//
// See StartUpdateSignalMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StartUpdateSignalMapWithContext(ctx aws.Context, input *StartUpdateSignalMapInput, opts ...request.Option) (*StartUpdateSignalMapOutput, error) {
	req, out := c.StartUpdateSignalMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopChannel = "StopChannel"

// StopChannelRequest generates a "aws/request.Request" representing the
// client's request for the StopChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopChannel for more information on using the StopChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopChannelRequest method.
//	req, resp := client.StopChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannelRequest(input *StopChannelInput) (req *request.Request, output *StopChannelOutput) {
	op := &request.Operation{
		Name:       opStopChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/channels/{channelId}/stop",
	}

	if input == nil {
		input = &StopChannelInput{}
	}

	output = &StopChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopChannel API operation for AWS Elemental MediaLive.
//
// # Stops a running channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel
func (c *MediaLive) StopChannel(input *StopChannelInput) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	return out, req.Send()
}

// StopChannelWithContext is the same as StopChannel with the addition of
// the ability to pass a context and additional request options.
//
// See StopChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopChannelWithContext(ctx aws.Context, input *StopChannelInput, opts ...request.Option) (*StopChannelOutput, error) {
	req, out := c.StopChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInputDevice = "StopInputDevice"

// StopInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the StopInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInputDevice for more information on using the StopInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopInputDeviceRequest method.
//	req, resp := client.StopInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice
func (c *MediaLive) StopInputDeviceRequest(input *StopInputDeviceInput) (req *request.Request, output *StopInputDeviceOutput) {
	op := &request.Operation{
		Name:       opStopInputDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/stop",
	}

	if input == nil {
		input = &StopInputDeviceInput{}
	}

	output = &StopInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopInputDevice API operation for AWS Elemental MediaLive.
//
// Stop an input device that is attached to a MediaConnect flow. (There is no
// need to stop a device that is attached to a MediaLive input; MediaLive automatically
// stops the device when the channel stops.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice
func (c *MediaLive) StopInputDevice(input *StopInputDeviceInput) (*StopInputDeviceOutput, error) {
	req, out := c.StopInputDeviceRequest(input)
	return out, req.Send()
}

// StopInputDeviceWithContext is the same as StopInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See StopInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopInputDeviceWithContext(ctx aws.Context, input *StopInputDeviceInput, opts ...request.Option) (*StopInputDeviceOutput, error) {
	req, out := c.StopInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMultiplex = "StopMultiplex"

// StopMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the StopMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMultiplex for more information on using the StopMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopMultiplexRequest method.
//	req, resp := client.StopMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex
func (c *MediaLive) StopMultiplexRequest(input *StopMultiplexInput) (req *request.Request, output *StopMultiplexOutput) {
	op := &request.Operation{
		Name:       opStopMultiplex,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/stop",
	}

	if input == nil {
		input = &StopMultiplexInput{}
	}

	output = &StopMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopMultiplex API operation for AWS Elemental MediaLive.
//
// Stops a running multiplex. If the multiplex isn't running, this action has
// no effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation StopMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex
func (c *MediaLive) StopMultiplex(input *StopMultiplexInput) (*StopMultiplexOutput, error) {
	req, out := c.StopMultiplexRequest(input)
	return out, req.Send()
}

// StopMultiplexWithContext is the same as StopMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See StopMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) StopMultiplexWithContext(ctx aws.Context, input *StopMultiplexInput, opts ...request.Option) (*StopMultiplexOutput, error) {
	req, out := c.StopMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransferInputDevice = "TransferInputDevice"

// TransferInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the TransferInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransferInputDevice for more information on using the TransferInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TransferInputDeviceRequest method.
//	req, resp := client.TransferInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice
func (c *MediaLive) TransferInputDeviceRequest(input *TransferInputDeviceInput) (req *request.Request, output *TransferInputDeviceOutput) {
	op := &request.Operation{
		Name:       opTransferInputDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}/transfer",
	}

	if input == nil {
		input = &TransferInputDeviceInput{}
	}

	output = &TransferInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TransferInputDevice API operation for AWS Elemental MediaLive.
//
// Start an input device transfer to another AWS account. After you make the
// request, the other account must accept or reject the transfer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation TransferInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice
func (c *MediaLive) TransferInputDevice(input *TransferInputDeviceInput) (*TransferInputDeviceOutput, error) {
	req, out := c.TransferInputDeviceRequest(input)
	return out, req.Send()
}

// TransferInputDeviceWithContext is the same as TransferInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See TransferInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) TransferInputDeviceWithContext(ctx aws.Context, input *TransferInputDeviceInput, opts ...request.Option) (*TransferInputDeviceOutput, error) {
	req, out := c.TransferInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountConfiguration = "UpdateAccountConfiguration"

// UpdateAccountConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountConfiguration for more information on using the UpdateAccountConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountConfigurationRequest method.
//	req, resp := client.UpdateAccountConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration
func (c *MediaLive) UpdateAccountConfigurationRequest(input *UpdateAccountConfigurationInput) (req *request.Request, output *UpdateAccountConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/accountConfiguration",
	}

	if input == nil {
		input = &UpdateAccountConfigurationInput{}
	}

	output = &UpdateAccountConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountConfiguration API operation for AWS Elemental MediaLive.
//
// # Update account configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateAccountConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration
func (c *MediaLive) UpdateAccountConfiguration(input *UpdateAccountConfigurationInput) (*UpdateAccountConfigurationOutput, error) {
	req, out := c.UpdateAccountConfigurationRequest(input)
	return out, req.Send()
}

// UpdateAccountConfigurationWithContext is the same as UpdateAccountConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateAccountConfigurationWithContext(ctx aws.Context, input *UpdateAccountConfigurationInput, opts ...request.Option) (*UpdateAccountConfigurationOutput, error) {
	req, out := c.UpdateAccountConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS Elemental MediaLive.
//
// Updates a channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - GatewayTimeoutException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel
func (c *MediaLive) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelClass = "UpdateChannelClass"

// UpdateChannelClassRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelClass operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelClass for more information on using the UpdateChannelClass
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelClassRequest method.
//	req, resp := client.UpdateChannelClassRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass
func (c *MediaLive) UpdateChannelClassRequest(input *UpdateChannelClassInput) (req *request.Request, output *UpdateChannelClassOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelClass,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/channels/{channelId}/channelClass",
	}

	if input == nil {
		input = &UpdateChannelClassInput{}
	}

	output = &UpdateChannelClassOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelClass API operation for AWS Elemental MediaLive.
//
// Changes the class of the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateChannelClass for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass
func (c *MediaLive) UpdateChannelClass(input *UpdateChannelClassInput) (*UpdateChannelClassOutput, error) {
	req, out := c.UpdateChannelClassRequest(input)
	return out, req.Send()
}

// UpdateChannelClassWithContext is the same as UpdateChannelClass with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelClass for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateChannelClassWithContext(ctx aws.Context, input *UpdateChannelClassInput, opts ...request.Option) (*UpdateChannelClassOutput, error) {
	req, out := c.UpdateChannelClassRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCloudWatchAlarmTemplate = "UpdateCloudWatchAlarmTemplate"

// UpdateCloudWatchAlarmTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCloudWatchAlarmTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCloudWatchAlarmTemplate for more information on using the UpdateCloudWatchAlarmTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCloudWatchAlarmTemplateRequest method.
//	req, resp := client.UpdateCloudWatchAlarmTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate
func (c *MediaLive) UpdateCloudWatchAlarmTemplateRequest(input *UpdateCloudWatchAlarmTemplateInput) (req *request.Request, output *UpdateCloudWatchAlarmTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateCloudWatchAlarmTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/prod/cloudwatch-alarm-templates/{identifier}",
	}

	if input == nil {
		input = &UpdateCloudWatchAlarmTemplateInput{}
	}

	output = &UpdateCloudWatchAlarmTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCloudWatchAlarmTemplate API operation for AWS Elemental MediaLive.
//
// Updates the specified cloudwatch alarm template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateCloudWatchAlarmTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate
func (c *MediaLive) UpdateCloudWatchAlarmTemplate(input *UpdateCloudWatchAlarmTemplateInput) (*UpdateCloudWatchAlarmTemplateOutput, error) {
	req, out := c.UpdateCloudWatchAlarmTemplateRequest(input)
	return out, req.Send()
}

// UpdateCloudWatchAlarmTemplateWithContext is the same as UpdateCloudWatchAlarmTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCloudWatchAlarmTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateCloudWatchAlarmTemplateWithContext(ctx aws.Context, input *UpdateCloudWatchAlarmTemplateInput, opts ...request.Option) (*UpdateCloudWatchAlarmTemplateOutput, error) {
	req, out := c.UpdateCloudWatchAlarmTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCloudWatchAlarmTemplateGroup = "UpdateCloudWatchAlarmTemplateGroup"

// UpdateCloudWatchAlarmTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCloudWatchAlarmTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCloudWatchAlarmTemplateGroup for more information on using the UpdateCloudWatchAlarmTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCloudWatchAlarmTemplateGroupRequest method.
//	req, resp := client.UpdateCloudWatchAlarmTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup
func (c *MediaLive) UpdateCloudWatchAlarmTemplateGroupRequest(input *UpdateCloudWatchAlarmTemplateGroupInput) (req *request.Request, output *UpdateCloudWatchAlarmTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateCloudWatchAlarmTemplateGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/prod/cloudwatch-alarm-template-groups/{identifier}",
	}

	if input == nil {
		input = &UpdateCloudWatchAlarmTemplateGroupInput{}
	}

	output = &UpdateCloudWatchAlarmTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCloudWatchAlarmTemplateGroup API operation for AWS Elemental MediaLive.
//
// Updates the specified cloudwatch alarm template group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateCloudWatchAlarmTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup
func (c *MediaLive) UpdateCloudWatchAlarmTemplateGroup(input *UpdateCloudWatchAlarmTemplateGroupInput) (*UpdateCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.UpdateCloudWatchAlarmTemplateGroupRequest(input)
	return out, req.Send()
}

// UpdateCloudWatchAlarmTemplateGroupWithContext is the same as UpdateCloudWatchAlarmTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCloudWatchAlarmTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateCloudWatchAlarmTemplateGroupWithContext(ctx aws.Context, input *UpdateCloudWatchAlarmTemplateGroupInput, opts ...request.Option) (*UpdateCloudWatchAlarmTemplateGroupOutput, error) {
	req, out := c.UpdateCloudWatchAlarmTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventBridgeRuleTemplate = "UpdateEventBridgeRuleTemplate"

// UpdateEventBridgeRuleTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventBridgeRuleTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventBridgeRuleTemplate for more information on using the UpdateEventBridgeRuleTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEventBridgeRuleTemplateRequest method.
//	req, resp := client.UpdateEventBridgeRuleTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate
func (c *MediaLive) UpdateEventBridgeRuleTemplateRequest(input *UpdateEventBridgeRuleTemplateInput) (req *request.Request, output *UpdateEventBridgeRuleTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateEventBridgeRuleTemplate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/prod/eventbridge-rule-templates/{identifier}",
	}

	if input == nil {
		input = &UpdateEventBridgeRuleTemplateInput{}
	}

	output = &UpdateEventBridgeRuleTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventBridgeRuleTemplate API operation for AWS Elemental MediaLive.
//
// Updates the specified eventbridge rule template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateEventBridgeRuleTemplate for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate
func (c *MediaLive) UpdateEventBridgeRuleTemplate(input *UpdateEventBridgeRuleTemplateInput) (*UpdateEventBridgeRuleTemplateOutput, error) {
	req, out := c.UpdateEventBridgeRuleTemplateRequest(input)
	return out, req.Send()
}

// UpdateEventBridgeRuleTemplateWithContext is the same as UpdateEventBridgeRuleTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventBridgeRuleTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateEventBridgeRuleTemplateWithContext(ctx aws.Context, input *UpdateEventBridgeRuleTemplateInput, opts ...request.Option) (*UpdateEventBridgeRuleTemplateOutput, error) {
	req, out := c.UpdateEventBridgeRuleTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventBridgeRuleTemplateGroup = "UpdateEventBridgeRuleTemplateGroup"

// UpdateEventBridgeRuleTemplateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventBridgeRuleTemplateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventBridgeRuleTemplateGroup for more information on using the UpdateEventBridgeRuleTemplateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEventBridgeRuleTemplateGroupRequest method.
//	req, resp := client.UpdateEventBridgeRuleTemplateGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup
func (c *MediaLive) UpdateEventBridgeRuleTemplateGroupRequest(input *UpdateEventBridgeRuleTemplateGroupInput) (req *request.Request, output *UpdateEventBridgeRuleTemplateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateEventBridgeRuleTemplateGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/prod/eventbridge-rule-template-groups/{identifier}",
	}

	if input == nil {
		input = &UpdateEventBridgeRuleTemplateGroupInput{}
	}

	output = &UpdateEventBridgeRuleTemplateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventBridgeRuleTemplateGroup API operation for AWS Elemental MediaLive.
//
// Updates the specified eventbridge rule template group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateEventBridgeRuleTemplateGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - NotFoundException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup
func (c *MediaLive) UpdateEventBridgeRuleTemplateGroup(input *UpdateEventBridgeRuleTemplateGroupInput) (*UpdateEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.UpdateEventBridgeRuleTemplateGroupRequest(input)
	return out, req.Send()
}

// UpdateEventBridgeRuleTemplateGroupWithContext is the same as UpdateEventBridgeRuleTemplateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventBridgeRuleTemplateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateEventBridgeRuleTemplateGroupWithContext(ctx aws.Context, input *UpdateEventBridgeRuleTemplateGroupInput, opts ...request.Option) (*UpdateEventBridgeRuleTemplateGroupOutput, error) {
	req, out := c.UpdateEventBridgeRuleTemplateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInput = "UpdateInput"

// UpdateInputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInput for more information on using the UpdateInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInputRequest method.
//	req, resp := client.UpdateInputRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInputRequest(input *UpdateInputInput) (req *request.Request, output *UpdateInputOutput) {
	op := &request.Operation{
		Name:       opUpdateInput,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputs/{inputId}",
	}

	if input == nil {
		input = &UpdateInputInput{}
	}

	output = &UpdateInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInput API operation for AWS Elemental MediaLive.
//
// Updates an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInput for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput
func (c *MediaLive) UpdateInput(input *UpdateInputInput) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	return out, req.Send()
}

// UpdateInputWithContext is the same as UpdateInput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputWithContext(ctx aws.Context, input *UpdateInputInput, opts ...request.Option) (*UpdateInputOutput, error) {
	req, out := c.UpdateInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInputDevice = "UpdateInputDevice"

// UpdateInputDeviceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInputDevice operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInputDevice for more information on using the UpdateInputDevice
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInputDeviceRequest method.
//	req, resp := client.UpdateInputDeviceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice
func (c *MediaLive) UpdateInputDeviceRequest(input *UpdateInputDeviceInput) (req *request.Request, output *UpdateInputDeviceOutput) {
	op := &request.Operation{
		Name:       opUpdateInputDevice,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputDevices/{inputDeviceId}",
	}

	if input == nil {
		input = &UpdateInputDeviceInput{}
	}

	output = &UpdateInputDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInputDevice API operation for AWS Elemental MediaLive.
//
// Updates the parameters for the input device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInputDevice for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice
func (c *MediaLive) UpdateInputDevice(input *UpdateInputDeviceInput) (*UpdateInputDeviceOutput, error) {
	req, out := c.UpdateInputDeviceRequest(input)
	return out, req.Send()
}

// UpdateInputDeviceWithContext is the same as UpdateInputDevice with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInputDevice for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputDeviceWithContext(ctx aws.Context, input *UpdateInputDeviceInput, opts ...request.Option) (*UpdateInputDeviceOutput, error) {
	req, out := c.UpdateInputDeviceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInputSecurityGroup = "UpdateInputSecurityGroup"

// UpdateInputSecurityGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInputSecurityGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInputSecurityGroup for more information on using the UpdateInputSecurityGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInputSecurityGroupRequest method.
//	req, resp := client.UpdateInputSecurityGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroupRequest(input *UpdateInputSecurityGroupInput) (req *request.Request, output *UpdateInputSecurityGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateInputSecurityGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/inputSecurityGroups/{inputSecurityGroupId}",
	}

	if input == nil {
		input = &UpdateInputSecurityGroupInput{}
	}

	output = &UpdateInputSecurityGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateInputSecurityGroup API operation for AWS Elemental MediaLive.
//
// Update an Input Security Group's Whilelists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateInputSecurityGroup for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup
func (c *MediaLive) UpdateInputSecurityGroup(input *UpdateInputSecurityGroupInput) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	return out, req.Send()
}

// UpdateInputSecurityGroupWithContext is the same as UpdateInputSecurityGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInputSecurityGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateInputSecurityGroupWithContext(ctx aws.Context, input *UpdateInputSecurityGroupInput, opts ...request.Option) (*UpdateInputSecurityGroupOutput, error) {
	req, out := c.UpdateInputSecurityGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMultiplex = "UpdateMultiplex"

// UpdateMultiplexRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMultiplex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMultiplex for more information on using the UpdateMultiplex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMultiplexRequest method.
//	req, resp := client.UpdateMultiplexRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex
func (c *MediaLive) UpdateMultiplexRequest(input *UpdateMultiplexInput) (req *request.Request, output *UpdateMultiplexOutput) {
	op := &request.Operation{
		Name:       opUpdateMultiplex,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}",
	}

	if input == nil {
		input = &UpdateMultiplexInput{}
	}

	output = &UpdateMultiplexOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMultiplex API operation for AWS Elemental MediaLive.
//
// Updates a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateMultiplex for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex
func (c *MediaLive) UpdateMultiplex(input *UpdateMultiplexInput) (*UpdateMultiplexOutput, error) {
	req, out := c.UpdateMultiplexRequest(input)
	return out, req.Send()
}

// UpdateMultiplexWithContext is the same as UpdateMultiplex with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMultiplex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateMultiplexWithContext(ctx aws.Context, input *UpdateMultiplexInput, opts ...request.Option) (*UpdateMultiplexOutput, error) {
	req, out := c.UpdateMultiplexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMultiplexProgram = "UpdateMultiplexProgram"

// UpdateMultiplexProgramRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMultiplexProgram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMultiplexProgram for more information on using the UpdateMultiplexProgram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMultiplexProgramRequest method.
//	req, resp := client.UpdateMultiplexProgramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram
func (c *MediaLive) UpdateMultiplexProgramRequest(input *UpdateMultiplexProgramInput) (req *request.Request, output *UpdateMultiplexProgramOutput) {
	op := &request.Operation{
		Name:       opUpdateMultiplexProgram,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/multiplexes/{multiplexId}/programs/{programName}",
	}

	if input == nil {
		input = &UpdateMultiplexProgramInput{}
	}

	output = &UpdateMultiplexProgramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMultiplexProgram API operation for AWS Elemental MediaLive.
//
// Update a program in a multiplex.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateMultiplexProgram for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - UnprocessableEntityException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram
func (c *MediaLive) UpdateMultiplexProgram(input *UpdateMultiplexProgramInput) (*UpdateMultiplexProgramOutput, error) {
	req, out := c.UpdateMultiplexProgramRequest(input)
	return out, req.Send()
}

// UpdateMultiplexProgramWithContext is the same as UpdateMultiplexProgram with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMultiplexProgram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateMultiplexProgramWithContext(ctx aws.Context, input *UpdateMultiplexProgramInput, opts ...request.Option) (*UpdateMultiplexProgramOutput, error) {
	req, out := c.UpdateMultiplexProgramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReservation = "UpdateReservation"

// UpdateReservationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReservation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReservation for more information on using the UpdateReservation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReservationRequest method.
//	req, resp := client.UpdateReservationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation
func (c *MediaLive) UpdateReservationRequest(input *UpdateReservationInput) (req *request.Request, output *UpdateReservationOutput) {
	op := &request.Operation{
		Name:       opUpdateReservation,
		HTTPMethod: "PUT",
		HTTPPath:   "/prod/reservations/{reservationId}",
	}

	if input == nil {
		input = &UpdateReservationInput{}
	}

	output = &UpdateReservationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReservation API operation for AWS Elemental MediaLive.
//
// Update reservation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaLive's
// API operation UpdateReservation for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//
//   - InternalServerErrorException
//
//   - ForbiddenException
//
//   - BadGatewayException
//
//   - NotFoundException
//
//   - GatewayTimeoutException
//
//   - TooManyRequestsException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation
func (c *MediaLive) UpdateReservation(input *UpdateReservationInput) (*UpdateReservationOutput, error) {
	req, out := c.UpdateReservationRequest(input)
	return out, req.Send()
}

// UpdateReservationWithContext is the same as UpdateReservation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReservation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaLive) UpdateReservationWithContext(ctx aws.Context, input *UpdateReservationInput, opts ...request.Option) (*UpdateReservationOutput, error) {
	req, out := c.UpdateReservationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Aac Settings
type AacSettings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid values depend on rate control mode
	// and profile.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
	// mode and profile. The adReceiverMix setting receives a stereo description
	// plus control track and emits a mono AAC encode of the description track,
	// with control data emitted in the PES header as per ETSI TS 101 154 Annex
	// E.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"AacCodingMode"`

	// Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD
	// (narration) as a stereo pair. The Audio Type field (audioType) will be set
	// to 3, which signals to downstream systems that this stream contains "broadcaster
	// mixed AD". Note that the input received by the encoder must contain pre-mixed
	// audio; the encoder does not perform the mixing. The values in audioTypeControl
	// and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.Leave
	// set to "normal" when input does not contain pre-mixed audio + AD.
	InputType *string `locationName:"inputType" type:"string" enum:"AacInputType"`

	// AAC Profile.
	Profile *string `locationName:"profile" type:"string" enum:"AacProfile"`

	// Rate Control Mode.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"AacRateControlMode"`

	// Sets LATM / LOAS AAC output for raw containers.
	RawFormat *string `locationName:"rawFormat" type:"string" enum:"AacRawFormat"`

	// Sample rate in Hz. Valid values depend on rate control mode and profile.
	SampleRate *float64 `locationName:"sampleRate" type:"double"`

	// Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport
	// Stream containers.
	Spec *string `locationName:"spec" type:"string" enum:"AacSpec"`

	// VBR Quality Level - Only used if rateControlMode is VBR.
	VbrQuality *string `locationName:"vbrQuality" type:"string" enum:"AacVbrQuality"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AacSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AacSettings) GoString() string {
	return s.String()
}

// SetBitrate sets the Bitrate field's value.
func (s *AacSettings) SetBitrate(v float64) *AacSettings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *AacSettings) SetCodingMode(v string) *AacSettings {
	s.CodingMode = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *AacSettings) SetInputType(v string) *AacSettings {
	s.InputType = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *AacSettings) SetProfile(v string) *AacSettings {
	s.Profile = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *AacSettings) SetRateControlMode(v string) *AacSettings {
	s.RateControlMode = &v
	return s
}

// SetRawFormat sets the RawFormat field's value.
func (s *AacSettings) SetRawFormat(v string) *AacSettings {
	s.RawFormat = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AacSettings) SetSampleRate(v float64) *AacSettings {
	s.SampleRate = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *AacSettings) SetSpec(v string) *AacSettings {
	s.Spec = &v
	return s
}

// SetVbrQuality sets the VbrQuality field's value.
func (s *AacSettings) SetVbrQuality(v string) *AacSettings {
	s.VbrQuality = &v
	return s
}

// Ac3 Settings
type Ac3Settings struct {
	_ struct{} `type:"structure"`

	// Applies a 3 dB attenuation to the surround channels. Applies only when the
	// coding mode parameter is CODING_MODE_3_2_LFE.
	AttenuationControl *string `locationName:"attenuationControl" type:"string" enum:"Ac3AttenuationControl"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC
	// A/52-2012 for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Ac3BitstreamMode"`

	// Dolby Digital coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Ac3CodingMode"`

	// Sets the dialnorm for the output. If excluded and input audio is Dolby Digital,
	// dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// If set to filmStandard, adds dynamic range compression signaling to the output
	// bitstream as defined in the Dolby Digital specification.
	DrcProfile *string `locationName:"drcProfile" type:"string" enum:"Ac3DrcProfile"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid in codingMode32Lfe mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Ac3LfeFilter"`

	// When set to "followInput", encoder metadata will be sourced from the DD,
	// DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Ac3MetadataControl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttenuationControl sets the AttenuationControl field's value.
func (s *Ac3Settings) SetAttenuationControl(v string) *Ac3Settings {
	s.AttenuationControl = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *Ac3Settings) SetBitrate(v float64) *Ac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Ac3Settings) SetBitstreamMode(v string) *Ac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Ac3Settings) SetCodingMode(v string) *Ac3Settings {
	s.CodingMode = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Ac3Settings) SetDialnorm(v int64) *Ac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcProfile sets the DrcProfile field's value.
func (s *Ac3Settings) SetDrcProfile(v string) *Ac3Settings {
	s.DrcProfile = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Ac3Settings) SetLfeFilter(v string) *Ac3Settings {
	s.LfeFilter = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Ac3Settings) SetMetadataControl(v string) *Ac3Settings {
	s.MetadataControl = &v
	return s
}

type AcceptInputDeviceTransferInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInputDeviceTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInputDeviceTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInputDeviceTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInputDeviceTransferInput"}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *AcceptInputDeviceTransferInput) SetInputDeviceId(v string) *AcceptInputDeviceTransferInput {
	s.InputDeviceId = &v
	return s
}

type AcceptInputDeviceTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInputDeviceTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptInputDeviceTransferOutput) GoString() string {
	return s.String()
}

type AccountConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the KMS key to use for all features that use key encryption. Specify
	// the ARN of a KMS key that you have created. Or leave blank to use the key
	// that MediaLive creates and manages for you.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountConfiguration) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *AccountConfiguration) SetKmsKeyId(v string) *AccountConfiguration {
	s.KmsKeyId = &v
	return s
}

// Ancillary Source Settings
type AncillarySourceSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the number (1 to 4) of the captions channel you want to extract
	// from the ancillary captions. If you plan to convert the ancillary captions
	// to another format, complete this field. If you plan to choose Embedded as
	// the captions destination in the output (to pass through all the channels
	// in the ancillary captions), leave this field blank because MediaLive ignores
	// the field.
	SourceAncillaryChannelNumber *int64 `locationName:"sourceAncillaryChannelNumber" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AncillarySourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AncillarySourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AncillarySourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AncillarySourceSettings"}
	if s.SourceAncillaryChannelNumber != nil && *s.SourceAncillaryChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SourceAncillaryChannelNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceAncillaryChannelNumber sets the SourceAncillaryChannelNumber field's value.
func (s *AncillarySourceSettings) SetSourceAncillaryChannelNumber(v int64) *AncillarySourceSettings {
	s.SourceAncillaryChannelNumber = &v
	return s
}

// Archive Cdn Settings
type ArchiveCdnSettings struct {
	_ struct{} `type:"structure"`

	// Archive S3 Settings
	ArchiveS3Settings *ArchiveS3Settings `locationName:"archiveS3Settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveCdnSettings) GoString() string {
	return s.String()
}

// SetArchiveS3Settings sets the ArchiveS3Settings field's value.
func (s *ArchiveCdnSettings) SetArchiveS3Settings(v *ArchiveS3Settings) *ArchiveCdnSettings {
	s.ArchiveS3Settings = v
	return s
}

// Archive Container Settings
type ArchiveContainerSettings struct {
	_ struct{} `type:"structure"`

	// M2ts Settings
	M2tsSettings *M2tsSettings `locationName:"m2tsSettings" type:"structure"`

	// Raw Settings
	RawSettings *RawSettings `locationName:"rawSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveContainerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveContainerSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveContainerSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveContainerSettings"}
	if s.M2tsSettings != nil {
		if err := s.M2tsSettings.Validate(); err != nil {
			invalidParams.AddNested("M2tsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetM2tsSettings sets the M2tsSettings field's value.
func (s *ArchiveContainerSettings) SetM2tsSettings(v *M2tsSettings) *ArchiveContainerSettings {
	s.M2tsSettings = v
	return s
}

// SetRawSettings sets the RawSettings field's value.
func (s *ArchiveContainerSettings) SetRawSettings(v *RawSettings) *ArchiveContainerSettings {
	s.RawSettings = v
	return s
}

// Archive Group Settings
type ArchiveGroupSettings struct {
	_ struct{} `type:"structure"`

	// Parameters that control interactions with the CDN.
	ArchiveCdnSettings *ArchiveCdnSettings `locationName:"archiveCdnSettings" type:"structure"`

	// A directory and base filename where archive files should be written.
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Number of seconds to write to archive file before closing and starting a
	// new one.
	RolloverInterval *int64 `locationName:"rolloverInterval" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.RolloverInterval != nil && *s.RolloverInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RolloverInterval", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchiveCdnSettings sets the ArchiveCdnSettings field's value.
func (s *ArchiveGroupSettings) SetArchiveCdnSettings(v *ArchiveCdnSettings) *ArchiveGroupSettings {
	s.ArchiveCdnSettings = v
	return s
}

// SetDestination sets the Destination field's value.
func (s *ArchiveGroupSettings) SetDestination(v *OutputLocationRef) *ArchiveGroupSettings {
	s.Destination = v
	return s
}

// SetRolloverInterval sets the RolloverInterval field's value.
func (s *ArchiveGroupSettings) SetRolloverInterval(v int64) *ArchiveGroupSettings {
	s.RolloverInterval = &v
	return s
}

// Archive Output Settings
type ArchiveOutputSettings struct {
	_ struct{} `type:"structure"`

	// Settings specific to the container type of the file.
	//
	// ContainerSettings is a required field
	ContainerSettings *ArchiveContainerSettings `locationName:"containerSettings" type:"structure" required:"true"`

	// Output file extension. If excluded, this will be auto-selected from the container
	// type.
	Extension *string `locationName:"extension" type:"string"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArchiveOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArchiveOutputSettings"}
	if s.ContainerSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerSettings"))
	}
	if s.ContainerSettings != nil {
		if err := s.ContainerSettings.Validate(); err != nil {
			invalidParams.AddNested("ContainerSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerSettings sets the ContainerSettings field's value.
func (s *ArchiveOutputSettings) SetContainerSettings(v *ArchiveContainerSettings) *ArchiveOutputSettings {
	s.ContainerSettings = v
	return s
}

// SetExtension sets the Extension field's value.
func (s *ArchiveOutputSettings) SetExtension(v string) *ArchiveOutputSettings {
	s.Extension = &v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *ArchiveOutputSettings) SetNameModifier(v string) *ArchiveOutputSettings {
	s.NameModifier = &v
	return s
}

// Archive S3 Settings
type ArchiveS3Settings struct {
	_ struct{} `type:"structure"`

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl *string `locationName:"cannedAcl" type:"string" enum:"S3CannedAcl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveS3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArchiveS3Settings) GoString() string {
	return s.String()
}

// SetCannedAcl sets the CannedAcl field's value.
func (s *ArchiveS3Settings) SetCannedAcl(v string) *ArchiveS3Settings {
	s.CannedAcl = &v
	return s
}

// Arib Destination Settings
type AribDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AribDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AribDestinationSettings) GoString() string {
	return s.String()
}

// Arib Source Settings
type AribSourceSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AribSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AribSourceSettings) GoString() string {
	return s.String()
}

// Audio Channel Mapping
type AudioChannelMapping struct {
	_ struct{} `type:"structure"`

	// Indices and gain values for each input channel that should be remixed into
	// this output channel.
	//
	// InputChannelLevels is a required field
	InputChannelLevels []*InputChannelLevel `locationName:"inputChannelLevels" type:"list" required:"true"`

	// The index of the output channel being produced.
	//
	// OutputChannel is a required field
	OutputChannel *int64 `locationName:"outputChannel" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioChannelMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioChannelMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioChannelMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioChannelMapping"}
	if s.InputChannelLevels == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannelLevels"))
	}
	if s.OutputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputChannel"))
	}
	if s.InputChannelLevels != nil {
		for i, v := range s.InputChannelLevels {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputChannelLevels", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputChannelLevels sets the InputChannelLevels field's value.
func (s *AudioChannelMapping) SetInputChannelLevels(v []*InputChannelLevel) *AudioChannelMapping {
	s.InputChannelLevels = v
	return s
}

// SetOutputChannel sets the OutputChannel field's value.
func (s *AudioChannelMapping) SetOutputChannel(v int64) *AudioChannelMapping {
	s.OutputChannel = &v
	return s
}

// Audio Codec Settings
type AudioCodecSettings struct {
	_ struct{} `type:"structure"`

	// Aac Settings
	AacSettings *AacSettings `locationName:"aacSettings" type:"structure"`

	// Ac3 Settings
	Ac3Settings *Ac3Settings `locationName:"ac3Settings" type:"structure"`

	// Eac3 Atmos Settings
	Eac3AtmosSettings *Eac3AtmosSettings `locationName:"eac3AtmosSettings" type:"structure"`

	// Eac3 Settings
	Eac3Settings *Eac3Settings `locationName:"eac3Settings" type:"structure"`

	// Mp2 Settings
	Mp2Settings *Mp2Settings `locationName:"mp2Settings" type:"structure"`

	// Pass Through Settings
	PassThroughSettings *PassThroughSettings `locationName:"passThroughSettings" type:"structure"`

	// Wav Settings
	WavSettings *WavSettings `locationName:"wavSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioCodecSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioCodecSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioCodecSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioCodecSettings"}
	if s.Ac3Settings != nil {
		if err := s.Ac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Ac3Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Eac3AtmosSettings != nil {
		if err := s.Eac3AtmosSettings.Validate(); err != nil {
			invalidParams.AddNested("Eac3AtmosSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Eac3Settings != nil {
		if err := s.Eac3Settings.Validate(); err != nil {
			invalidParams.AddNested("Eac3Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAacSettings sets the AacSettings field's value.
func (s *AudioCodecSettings) SetAacSettings(v *AacSettings) *AudioCodecSettings {
	s.AacSettings = v
	return s
}

// SetAc3Settings sets the Ac3Settings field's value.
func (s *AudioCodecSettings) SetAc3Settings(v *Ac3Settings) *AudioCodecSettings {
	s.Ac3Settings = v
	return s
}

// SetEac3AtmosSettings sets the Eac3AtmosSettings field's value.
func (s *AudioCodecSettings) SetEac3AtmosSettings(v *Eac3AtmosSettings) *AudioCodecSettings {
	s.Eac3AtmosSettings = v
	return s
}

// SetEac3Settings sets the Eac3Settings field's value.
func (s *AudioCodecSettings) SetEac3Settings(v *Eac3Settings) *AudioCodecSettings {
	s.Eac3Settings = v
	return s
}

// SetMp2Settings sets the Mp2Settings field's value.
func (s *AudioCodecSettings) SetMp2Settings(v *Mp2Settings) *AudioCodecSettings {
	s.Mp2Settings = v
	return s
}

// SetPassThroughSettings sets the PassThroughSettings field's value.
func (s *AudioCodecSettings) SetPassThroughSettings(v *PassThroughSettings) *AudioCodecSettings {
	s.PassThroughSettings = v
	return s
}

// SetWavSettings sets the WavSettings field's value.
func (s *AudioCodecSettings) SetWavSettings(v *WavSettings) *AudioCodecSettings {
	s.WavSettings = v
	return s
}

// Audio Description
type AudioDescription struct {
	_ struct{} `type:"structure"`

	// Identifies the DASH roles to assign to this audio output. Applies only when
	// the audio output is configured for DVB DASH accessibility signaling.
	AudioDashRoles []*string `locationName:"audioDashRoles" type:"list" enum:"DashRoleAudio"`

	// Advanced audio normalization settings.
	AudioNormalizationSettings *AudioNormalizationSettings `locationName:"audioNormalizationSettings" type:"structure"`

	// The name of the AudioSelector used as the source for this AudioDescription.
	//
	// AudioSelectorName is a required field
	AudioSelectorName *string `locationName:"audioSelectorName" type:"string" required:"true"`

	// Applies only if audioTypeControl is useConfigured. The values for audioType
	// are defined in ISO-IEC 13818-1.
	AudioType *string `locationName:"audioType" type:"string" enum:"AudioType"`

	// Determines how audio type is determined. followInput: If the input contains
	// an ISO 639 audioType, then that value is passed through to the output. If
	// the input contains no ISO 639 audioType, the value in Audio Type is included
	// in the output. useConfigured: The value in Audio Type is included in the
	// output.Note that this field and audioType are both ignored if inputType is
	// broadcasterMixedAd.
	AudioTypeControl *string `locationName:"audioTypeControl" type:"string" enum:"AudioDescriptionAudioTypeControl"`

	// Settings to configure one or more solutions that insert audio watermarks
	// in the audio encode
	AudioWatermarkingSettings *AudioWatermarkSettings `locationName:"audioWatermarkingSettings" type:"structure"`

	// Audio codec settings.
	CodecSettings *AudioCodecSettings `locationName:"codecSettings" type:"structure"`

	// Identifies DVB DASH accessibility signaling in this audio output. Used in
	// Microsoft Smooth Streaming outputs to signal accessibility information to
	// packagers.
	DvbDashAccessibility *string `locationName:"dvbDashAccessibility" type:"string" enum:"DvbDashAccessibility"`

	// RFC 5646 language code representing the language of the audio output track.
	// Only used if languageControlMode is useConfigured, or there is no ISO 639
	// language code specified in the input.
	LanguageCode *string `locationName:"languageCode" min:"1" type:"string"`

	// Choosing followInput will cause the ISO 639 language code of the output to
	// follow the ISO 639 language code of the input. The languageCode will be used
	// when useConfigured is set, or when followInput is selected but there is no
	// ISO 639 language code specified by the input.
	LanguageCodeControl *string `locationName:"languageCodeControl" type:"string" enum:"AudioDescriptionLanguageCodeControl"`

	// The name of this AudioDescription. Outputs will use this name to uniquely
	// identify this AudioDescription. Description names should be unique within
	// this Live Event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Settings that control how input audio channels are remixed into the output
	// audio channels.
	RemixSettings *RemixSettings `locationName:"remixSettings" type:"structure"`

	// Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by
	// the player (eg. English, or Director Commentary).
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioDescription"}
	if s.AudioSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioSelectorName"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.AudioWatermarkingSettings != nil {
		if err := s.AudioWatermarkingSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioWatermarkingSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.CodecSettings != nil {
		if err := s.CodecSettings.Validate(); err != nil {
			invalidParams.AddNested("CodecSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.RemixSettings != nil {
		if err := s.RemixSettings.Validate(); err != nil {
			invalidParams.AddNested("RemixSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDashRoles sets the AudioDashRoles field's value.
func (s *AudioDescription) SetAudioDashRoles(v []*string) *AudioDescription {
	s.AudioDashRoles = v
	return s
}

// SetAudioNormalizationSettings sets the AudioNormalizationSettings field's value.
func (s *AudioDescription) SetAudioNormalizationSettings(v *AudioNormalizationSettings) *AudioDescription {
	s.AudioNormalizationSettings = v
	return s
}

// SetAudioSelectorName sets the AudioSelectorName field's value.
func (s *AudioDescription) SetAudioSelectorName(v string) *AudioDescription {
	s.AudioSelectorName = &v
	return s
}

// SetAudioType sets the AudioType field's value.
func (s *AudioDescription) SetAudioType(v string) *AudioDescription {
	s.AudioType = &v
	return s
}

// SetAudioTypeControl sets the AudioTypeControl field's value.
func (s *AudioDescription) SetAudioTypeControl(v string) *AudioDescription {
	s.AudioTypeControl = &v
	return s
}

// SetAudioWatermarkingSettings sets the AudioWatermarkingSettings field's value.
func (s *AudioDescription) SetAudioWatermarkingSettings(v *AudioWatermarkSettings) *AudioDescription {
	s.AudioWatermarkingSettings = v
	return s
}

// SetCodecSettings sets the CodecSettings field's value.
func (s *AudioDescription) SetCodecSettings(v *AudioCodecSettings) *AudioDescription {
	s.CodecSettings = v
	return s
}

// SetDvbDashAccessibility sets the DvbDashAccessibility field's value.
func (s *AudioDescription) SetDvbDashAccessibility(v string) *AudioDescription {
	s.DvbDashAccessibility = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioDescription) SetLanguageCode(v string) *AudioDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageCodeControl sets the LanguageCodeControl field's value.
func (s *AudioDescription) SetLanguageCodeControl(v string) *AudioDescription {
	s.LanguageCodeControl = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudioDescription) SetName(v string) *AudioDescription {
	s.Name = &v
	return s
}

// SetRemixSettings sets the RemixSettings field's value.
func (s *AudioDescription) SetRemixSettings(v *RemixSettings) *AudioDescription {
	s.RemixSettings = v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *AudioDescription) SetStreamName(v string) *AudioDescription {
	s.StreamName = &v
	return s
}

// Audio Dolby EDecode
type AudioDolbyEDecode struct {
	_ struct{} `type:"structure"`

	// Applies only to Dolby E. Enter the program ID (according to the metadata
	// in the audio) of the Dolby E program to extract from the specified track.
	// One program extracted per audio selector. To select multiple programs, create
	// multiple selectors with the same Track and different Program numbers. “All
	// channels” means to ignore the program IDs and include all the channels
	// in this selector; useful if metadata is known to be incorrect.
	//
	// ProgramSelection is a required field
	ProgramSelection *string `locationName:"programSelection" type:"string" required:"true" enum:"DolbyEProgramSelection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioDolbyEDecode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioDolbyEDecode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioDolbyEDecode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioDolbyEDecode"}
	if s.ProgramSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramSelection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProgramSelection sets the ProgramSelection field's value.
func (s *AudioDolbyEDecode) SetProgramSelection(v string) *AudioDolbyEDecode {
	s.ProgramSelection = &v
	return s
}

// Audio Hls Rendition Selection
type AudioHlsRenditionSelection struct {
	_ struct{} `type:"structure"`

	// Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" min:"1" type:"string" required:"true"`

	// Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioHlsRenditionSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioHlsRenditionSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioHlsRenditionSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioHlsRenditionSelection"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AudioHlsRenditionSelection) SetGroupId(v string) *AudioHlsRenditionSelection {
	s.GroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudioHlsRenditionSelection) SetName(v string) *AudioHlsRenditionSelection {
	s.Name = &v
	return s
}

// Audio Language Selection
type AudioLanguageSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific three-letter language code from within an audio source.
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" type:"string" required:"true"`

	// When set to "strict", the transport stream demux strictly identifies audio
	// streams by their language descriptor. If a PMT update occurs such that an
	// audio stream matching the initially selected language is no longer present
	// then mute will be encoded until the language returns. If "loose", then on
	// a PMT update the demux will choose another audio stream in the program with
	// the same stream type if it can't find one with the same language.
	LanguageSelectionPolicy *string `locationName:"languageSelectionPolicy" type:"string" enum:"AudioLanguageSelectionPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLanguageSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioLanguageSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioLanguageSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioLanguageSelection"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AudioLanguageSelection) SetLanguageCode(v string) *AudioLanguageSelection {
	s.LanguageCode = &v
	return s
}

// SetLanguageSelectionPolicy sets the LanguageSelectionPolicy field's value.
func (s *AudioLanguageSelection) SetLanguageSelectionPolicy(v string) *AudioLanguageSelection {
	s.LanguageSelectionPolicy = &v
	return s
}

// Audio Normalization Settings
type AudioNormalizationSettings struct {
	_ struct{} `type:"structure"`

	// Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification,
	// itu17702 conforms to the EBU R-128 specification.
	Algorithm *string `locationName:"algorithm" type:"string" enum:"AudioNormalizationAlgorithm"`

	// When set to correctAudio the output audio is corrected using the chosen algorithm.
	// If set to measureOnly, the audio will be measured but not adjusted.
	AlgorithmControl *string `locationName:"algorithmControl" type:"string" enum:"AudioNormalizationAlgorithmControl"`

	// Target LKFS(loudness) to adjust volume to. If no value is entered, a default
	// value will be used according to the chosen algorithm. The CALM Act (1770-1)
	// recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends
	// a target of -23 LKFS.
	TargetLkfs *float64 `locationName:"targetLkfs" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioNormalizationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioNormalizationSettings) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AudioNormalizationSettings) SetAlgorithm(v string) *AudioNormalizationSettings {
	s.Algorithm = &v
	return s
}

// SetAlgorithmControl sets the AlgorithmControl field's value.
func (s *AudioNormalizationSettings) SetAlgorithmControl(v string) *AudioNormalizationSettings {
	s.AlgorithmControl = &v
	return s
}

// SetTargetLkfs sets the TargetLkfs field's value.
func (s *AudioNormalizationSettings) SetTargetLkfs(v float64) *AudioNormalizationSettings {
	s.TargetLkfs = &v
	return s
}

// Audio Only Hls Settings
type AudioOnlyHlsSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the group to which the audio Rendition belongs.
	AudioGroupId *string `locationName:"audioGroupId" type:"string"`

	// Optional. Specifies the .jpg or .png image to use as the cover art for an
	// audio-only output. We recommend a low bit-size file because the image increases
	// the output audio bandwidth.The image is attached to the audio as an ID3 tag,
	// frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native
	// Frames" standard.
	AudioOnlyImage *InputLocation `locationName:"audioOnlyImage" type:"structure"`

	// Four types of audio-only tracks are supported:Audio-Only Variant StreamThe
	// client can play back this audio-only stream instead of video in low-bandwidth
	// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.Alternate
	// Audio, Auto Select, DefaultAlternate rendition that the client should try
	// to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest
	// with DEFAULT=YES, AUTOSELECT=YESAlternate Audio, Auto Select, Not DefaultAlternate
	// rendition that the client may try to play back by default. Represented as
	// an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YESAlternate
	// Audio, not Auto SelectAlternate rendition that the client will not try to
	// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
	// DEFAULT=NO, AUTOSELECT=NO
	AudioTrackType *string `locationName:"audioTrackType" type:"string" enum:"AudioOnlyHlsTrackType"`

	// Specifies the segment type.
	SegmentType *string `locationName:"segmentType" type:"string" enum:"AudioOnlyHlsSegmentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioOnlyHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioOnlyHlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioOnlyHlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioOnlyHlsSettings"}
	if s.AudioOnlyImage != nil {
		if err := s.AudioOnlyImage.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioGroupId sets the AudioGroupId field's value.
func (s *AudioOnlyHlsSettings) SetAudioGroupId(v string) *AudioOnlyHlsSettings {
	s.AudioGroupId = &v
	return s
}

// SetAudioOnlyImage sets the AudioOnlyImage field's value.
func (s *AudioOnlyHlsSettings) SetAudioOnlyImage(v *InputLocation) *AudioOnlyHlsSettings {
	s.AudioOnlyImage = v
	return s
}

// SetAudioTrackType sets the AudioTrackType field's value.
func (s *AudioOnlyHlsSettings) SetAudioTrackType(v string) *AudioOnlyHlsSettings {
	s.AudioTrackType = &v
	return s
}

// SetSegmentType sets the SegmentType field's value.
func (s *AudioOnlyHlsSettings) SetSegmentType(v string) *AudioOnlyHlsSettings {
	s.SegmentType = &v
	return s
}

// Audio Pid Selection
type AudioPidSelection struct {
	_ struct{} `type:"structure"`

	// Selects a specific PID from within a source.
	//
	// Pid is a required field
	Pid *int64 `locationName:"pid" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioPidSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioPidSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioPidSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioPidSelection"}
	if s.Pid == nil {
		invalidParams.Add(request.NewErrParamRequired("Pid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPid sets the Pid field's value.
func (s *AudioPidSelection) SetPid(v int64) *AudioPidSelection {
	s.Pid = &v
	return s
}

// Audio Selector
type AudioSelector struct {
	_ struct{} `type:"structure"`

	// The name of this AudioSelector. AudioDescriptions will use this name to uniquely
	// identify this Selector. Selector names should be unique per input.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The audio selector settings.
	SelectorSettings *AudioSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AudioSelector) SetName(v string) *AudioSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *AudioSelector) SetSelectorSettings(v *AudioSelectorSettings) *AudioSelector {
	s.SelectorSettings = v
	return s
}

// Audio Selector Settings
type AudioSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Audio Hls Rendition Selection
	AudioHlsRenditionSelection *AudioHlsRenditionSelection `locationName:"audioHlsRenditionSelection" type:"structure"`

	// Audio Language Selection
	AudioLanguageSelection *AudioLanguageSelection `locationName:"audioLanguageSelection" type:"structure"`

	// Audio Pid Selection
	AudioPidSelection *AudioPidSelection `locationName:"audioPidSelection" type:"structure"`

	// Audio Track Selection
	AudioTrackSelection *AudioTrackSelection `locationName:"audioTrackSelection" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSelectorSettings"}
	if s.AudioHlsRenditionSelection != nil {
		if err := s.AudioHlsRenditionSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioHlsRenditionSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioLanguageSelection != nil {
		if err := s.AudioLanguageSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioLanguageSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioPidSelection != nil {
		if err := s.AudioPidSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioPidSelection", err.(request.ErrInvalidParams))
		}
	}
	if s.AudioTrackSelection != nil {
		if err := s.AudioTrackSelection.Validate(); err != nil {
			invalidParams.AddNested("AudioTrackSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioHlsRenditionSelection sets the AudioHlsRenditionSelection field's value.
func (s *AudioSelectorSettings) SetAudioHlsRenditionSelection(v *AudioHlsRenditionSelection) *AudioSelectorSettings {
	s.AudioHlsRenditionSelection = v
	return s
}

// SetAudioLanguageSelection sets the AudioLanguageSelection field's value.
func (s *AudioSelectorSettings) SetAudioLanguageSelection(v *AudioLanguageSelection) *AudioSelectorSettings {
	s.AudioLanguageSelection = v
	return s
}

// SetAudioPidSelection sets the AudioPidSelection field's value.
func (s *AudioSelectorSettings) SetAudioPidSelection(v *AudioPidSelection) *AudioSelectorSettings {
	s.AudioPidSelection = v
	return s
}

// SetAudioTrackSelection sets the AudioTrackSelection field's value.
func (s *AudioSelectorSettings) SetAudioTrackSelection(v *AudioTrackSelection) *AudioSelectorSettings {
	s.AudioTrackSelection = v
	return s
}

type AudioSilenceFailoverSettings struct {
	_ struct{} `type:"structure"`

	// The name of the audio selector in the input that MediaLive should monitor
	// to detect silence. Select your most important rendition. If you didn't create
	// an audio selector in this input, leave blank.
	//
	// AudioSelectorName is a required field
	AudioSelectorName *string `locationName:"audioSelectorName" type:"string" required:"true"`

	// The amount of time (in milliseconds) that the active input must be silent
	// before automatic input failover occurs. Silence is defined as audio loss
	// or audio quieter than -50 dBFS.
	AudioSilenceThresholdMsec *int64 `locationName:"audioSilenceThresholdMsec" min:"1000" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSilenceFailoverSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioSilenceFailoverSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioSilenceFailoverSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioSilenceFailoverSettings"}
	if s.AudioSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioSelectorName"))
	}
	if s.AudioSilenceThresholdMsec != nil && *s.AudioSilenceThresholdMsec < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("AudioSilenceThresholdMsec", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSelectorName sets the AudioSelectorName field's value.
func (s *AudioSilenceFailoverSettings) SetAudioSelectorName(v string) *AudioSilenceFailoverSettings {
	s.AudioSelectorName = &v
	return s
}

// SetAudioSilenceThresholdMsec sets the AudioSilenceThresholdMsec field's value.
func (s *AudioSilenceFailoverSettings) SetAudioSilenceThresholdMsec(v int64) *AudioSilenceFailoverSettings {
	s.AudioSilenceThresholdMsec = &v
	return s
}

// Audio Track
type AudioTrack struct {
	_ struct{} `type:"structure"`

	// 1-based integer value that maps to a specific audio track
	//
	// Track is a required field
	Track *int64 `locationName:"track" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioTrack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioTrack) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioTrack) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioTrack"}
	if s.Track == nil {
		invalidParams.Add(request.NewErrParamRequired("Track"))
	}
	if s.Track != nil && *s.Track < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Track", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrack sets the Track field's value.
func (s *AudioTrack) SetTrack(v int64) *AudioTrack {
	s.Track = &v
	return s
}

// Audio Track Selection
type AudioTrackSelection struct {
	_ struct{} `type:"structure"`

	// Configure decoding options for Dolby E streams - these should be Dolby E
	// frames carried in PCM streams tagged with SMPTE-337
	DolbyEDecode *AudioDolbyEDecode `locationName:"dolbyEDecode" type:"structure"`

	// Selects one or more unique audio tracks from within a source.
	//
	// Tracks is a required field
	Tracks []*AudioTrack `locationName:"tracks" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioTrackSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioTrackSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioTrackSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioTrackSelection"}
	if s.Tracks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tracks"))
	}
	if s.DolbyEDecode != nil {
		if err := s.DolbyEDecode.Validate(); err != nil {
			invalidParams.AddNested("DolbyEDecode", err.(request.ErrInvalidParams))
		}
	}
	if s.Tracks != nil {
		for i, v := range s.Tracks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tracks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDolbyEDecode sets the DolbyEDecode field's value.
func (s *AudioTrackSelection) SetDolbyEDecode(v *AudioDolbyEDecode) *AudioTrackSelection {
	s.DolbyEDecode = v
	return s
}

// SetTracks sets the Tracks field's value.
func (s *AudioTrackSelection) SetTracks(v []*AudioTrack) *AudioTrackSelection {
	s.Tracks = v
	return s
}

// Audio Watermark Settings
type AudioWatermarkSettings struct {
	_ struct{} `type:"structure"`

	// Settings to configure Nielsen Watermarks in the audio encode
	NielsenWatermarksSettings *NielsenWatermarksSettings `locationName:"nielsenWatermarksSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioWatermarkSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioWatermarkSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioWatermarkSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioWatermarkSettings"}
	if s.NielsenWatermarksSettings != nil {
		if err := s.NielsenWatermarksSettings.Validate(); err != nil {
			invalidParams.AddNested("NielsenWatermarksSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNielsenWatermarksSettings sets the NielsenWatermarksSettings field's value.
func (s *AudioWatermarkSettings) SetNielsenWatermarksSettings(v *NielsenWatermarksSettings) *AudioWatermarkSettings {
	s.NielsenWatermarksSettings = v
	return s
}

// The settings for Automatic Input Failover.
type AutomaticInputFailoverSettings struct {
	_ struct{} `type:"structure"`

	// This clear time defines the requirement a recovered input must meet to be
	// considered healthy. The input must have no failover conditions for this length
	// of time. Enter a time in milliseconds. This value is particularly important
	// if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED,
	// because after this time, MediaLive will switch back to the primary input.
	ErrorClearTimeMsec *int64 `locationName:"errorClearTimeMsec" min:"1" type:"integer"`

	// A list of failover conditions. If any of these conditions occur, MediaLive
	// will perform a failover to the other input.
	FailoverConditions []*FailoverCondition `locationName:"failoverConditions" type:"list"`

	// Input preference when deciding which input to make active when a previously
	// failed input has recovered.
	InputPreference *string `locationName:"inputPreference" type:"string" enum:"InputPreference"`

	// The input ID of the secondary input in the automatic input failover pair.
	//
	// SecondaryInputId is a required field
	SecondaryInputId *string `locationName:"secondaryInputId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomaticInputFailoverSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutomaticInputFailoverSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutomaticInputFailoverSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutomaticInputFailoverSettings"}
	if s.ErrorClearTimeMsec != nil && *s.ErrorClearTimeMsec < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ErrorClearTimeMsec", 1))
	}
	if s.SecondaryInputId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecondaryInputId"))
	}
	if s.FailoverConditions != nil {
		for i, v := range s.FailoverConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FailoverConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorClearTimeMsec sets the ErrorClearTimeMsec field's value.
func (s *AutomaticInputFailoverSettings) SetErrorClearTimeMsec(v int64) *AutomaticInputFailoverSettings {
	s.ErrorClearTimeMsec = &v
	return s
}

// SetFailoverConditions sets the FailoverConditions field's value.
func (s *AutomaticInputFailoverSettings) SetFailoverConditions(v []*FailoverCondition) *AutomaticInputFailoverSettings {
	s.FailoverConditions = v
	return s
}

// SetInputPreference sets the InputPreference field's value.
func (s *AutomaticInputFailoverSettings) SetInputPreference(v string) *AutomaticInputFailoverSettings {
	s.InputPreference = &v
	return s
}

// SetSecondaryInputId sets the SecondaryInputId field's value.
func (s *AutomaticInputFailoverSettings) SetSecondaryInputId(v string) *AutomaticInputFailoverSettings {
	s.SecondaryInputId = &v
	return s
}

// Avail Blanking
type AvailBlanking struct {
	_ struct{} `type:"structure"`

	// Blanking image to be used. Leave empty for solid black. Only bmp and png
	// images are supported.
	AvailBlankingImage *InputLocation `locationName:"availBlankingImage" type:"structure"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// insertion metadata is added.
	State *string `locationName:"state" type:"string" enum:"AvailBlankingState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailBlanking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailBlanking) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailBlanking) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailBlanking"}
	if s.AvailBlankingImage != nil {
		if err := s.AvailBlankingImage.Validate(); err != nil {
			invalidParams.AddNested("AvailBlankingImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailBlankingImage sets the AvailBlankingImage field's value.
func (s *AvailBlanking) SetAvailBlankingImage(v *InputLocation) *AvailBlanking {
	s.AvailBlankingImage = v
	return s
}

// SetState sets the State field's value.
func (s *AvailBlanking) SetState(v string) *AvailBlanking {
	s.State = &v
	return s
}

// Avail Configuration
type AvailConfiguration struct {
	_ struct{} `type:"structure"`

	// Controls how SCTE-35 messages create cues. Splice Insert mode treats all
	// segmentation signals traditionally. With Time Signal APOS mode only Time
	// Signal Placement Opportunity and Break messages create segment breaks. With
	// ESAM mode, signals are forwarded to an ESAM server for possible update.
	AvailSettings *AvailSettings `locationName:"availSettings" type:"structure"`

	// Configures whether SCTE 35 passthrough triggers segment breaks in all output
	// groups that use segmented outputs. Insertion of a SCTE 35 message typically
	// results in a segment break, in addition to the regular cadence of breaks.
	// The segment breaks appear in video outputs, audio outputs, and captions outputs
	// (if any).ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output
	// groups that have segmented outputs. This is the legacy behavior.SCTE35_ENABLED_OUTPUT_GROUPS:
	// Insert the segment break only in output groups that have SCTE 35 passthrough
	// enabled. This is the recommended value, because it reduces unnecessary segment
	// breaks.
	Scte35SegmentationScope *string `locationName:"scte35SegmentationScope" type:"string" enum:"Scte35SegmentationScope"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailConfiguration"}
	if s.AvailSettings != nil {
		if err := s.AvailSettings.Validate(); err != nil {
			invalidParams.AddNested("AvailSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailSettings sets the AvailSettings field's value.
func (s *AvailConfiguration) SetAvailSettings(v *AvailSettings) *AvailConfiguration {
	s.AvailSettings = v
	return s
}

// SetScte35SegmentationScope sets the Scte35SegmentationScope field's value.
func (s *AvailConfiguration) SetScte35SegmentationScope(v string) *AvailConfiguration {
	s.Scte35SegmentationScope = &v
	return s
}

// Avail Settings
type AvailSettings struct {
	_ struct{} `type:"structure"`

	// Esam
	Esam *Esam `locationName:"esam" type:"structure"`

	// Typical configuration that applies breaks on splice inserts in addition to
	// time signal placement opportunities, breaks, and advertisements.
	Scte35SpliceInsert *Scte35SpliceInsert `locationName:"scte35SpliceInsert" type:"structure"`

	// Atypical configuration that applies segment breaks only on SCTE-35 time signal
	// placement opportunities and breaks.
	Scte35TimeSignalApos *Scte35TimeSignalApos `locationName:"scte35TimeSignalApos" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AvailSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AvailSettings"}
	if s.Esam != nil {
		if err := s.Esam.Validate(); err != nil {
			invalidParams.AddNested("Esam", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35SpliceInsert != nil {
		if err := s.Scte35SpliceInsert.Validate(); err != nil {
			invalidParams.AddNested("Scte35SpliceInsert", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte35TimeSignalApos != nil {
		if err := s.Scte35TimeSignalApos.Validate(); err != nil {
			invalidParams.AddNested("Scte35TimeSignalApos", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEsam sets the Esam field's value.
func (s *AvailSettings) SetEsam(v *Esam) *AvailSettings {
	s.Esam = v
	return s
}

// SetScte35SpliceInsert sets the Scte35SpliceInsert field's value.
func (s *AvailSettings) SetScte35SpliceInsert(v *Scte35SpliceInsert) *AvailSettings {
	s.Scte35SpliceInsert = v
	return s
}

// SetScte35TimeSignalApos sets the Scte35TimeSignalApos field's value.
func (s *AvailSettings) SetScte35TimeSignalApos(v *Scte35TimeSignalApos) *AvailSettings {
	s.Scte35TimeSignalApos = v
	return s
}

type BadGatewayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadGatewayException) GoString() string {
	return s.String()
}

func newErrorBadGatewayException(v protocol.ResponseMetadata) error {
	return &BadGatewayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadGatewayException) Code() string {
	return "BadGatewayException"
}

// Message returns the exception's message.
func (s *BadGatewayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadGatewayException) OrigErr() error {
	return nil
}

func (s *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadGatewayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadGatewayException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchDeleteInput struct {
	_ struct{} `type:"structure"`

	ChannelIds []*string `locationName:"channelIds" type:"list"`

	InputIds []*string `locationName:"inputIds" type:"list"`

	InputSecurityGroupIds []*string `locationName:"inputSecurityGroupIds" type:"list"`

	MultiplexIds []*string `locationName:"multiplexIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteInput) GoString() string {
	return s.String()
}

// SetChannelIds sets the ChannelIds field's value.
func (s *BatchDeleteInput) SetChannelIds(v []*string) *BatchDeleteInput {
	s.ChannelIds = v
	return s
}

// SetInputIds sets the InputIds field's value.
func (s *BatchDeleteInput) SetInputIds(v []*string) *BatchDeleteInput {
	s.InputIds = v
	return s
}

// SetInputSecurityGroupIds sets the InputSecurityGroupIds field's value.
func (s *BatchDeleteInput) SetInputSecurityGroupIds(v []*string) *BatchDeleteInput {
	s.InputSecurityGroupIds = v
	return s
}

// SetMultiplexIds sets the MultiplexIds field's value.
func (s *BatchDeleteInput) SetMultiplexIds(v []*string) *BatchDeleteInput {
	s.MultiplexIds = v
	return s
}

type BatchDeleteOutput struct {
	_ struct{} `type:"structure"`

	Failed []*BatchFailedResultModel `locationName:"failed" type:"list"`

	Successful []*BatchSuccessfulResultModel `locationName:"successful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDeleteOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *BatchDeleteOutput) SetFailed(v []*BatchFailedResultModel) *BatchDeleteOutput {
	s.Failed = v
	return s
}

// SetSuccessful sets the Successful field's value.
func (s *BatchDeleteOutput) SetSuccessful(v []*BatchSuccessfulResultModel) *BatchDeleteOutput {
	s.Successful = v
	return s
}

// Details from a failed operation
type BatchFailedResultModel struct {
	_ struct{} `type:"structure"`

	// ARN of the resource
	Arn *string `locationName:"arn" type:"string"`

	// Error code for the failed operation
	Code *string `locationName:"code" type:"string"`

	// ID of the resource
	Id *string `locationName:"id" type:"string"`

	// Error message for the failed operation
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchFailedResultModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchFailedResultModel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchFailedResultModel) SetArn(v string) *BatchFailedResultModel {
	s.Arn = &v
	return s
}

// SetCode sets the Code field's value.
func (s *BatchFailedResultModel) SetCode(v string) *BatchFailedResultModel {
	s.Code = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchFailedResultModel) SetId(v string) *BatchFailedResultModel {
	s.Id = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchFailedResultModel) SetMessage(v string) *BatchFailedResultModel {
	s.Message = &v
	return s
}

// A list of schedule actions to create (in a request) or that have been created
// (in a response).
type BatchScheduleActionCreateRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to create.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionCreateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionCreateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionCreateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchScheduleActionCreateRequest"}
	if s.ScheduleActions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleActions"))
	}
	if s.ScheduleActions != nil {
		for i, v := range s.ScheduleActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScheduleActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionCreateRequest) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionCreateRequest {
	s.ScheduleActions = v
	return s
}

// List of actions that have been created in the schedule.
type BatchScheduleActionCreateResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been created in the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionCreateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionCreateResult) GoString() string {
	return s.String()
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionCreateResult) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionCreateResult {
	s.ScheduleActions = v
	return s
}

// A list of schedule actions to delete.
type BatchScheduleActionDeleteRequest struct {
	_ struct{} `type:"structure"`

	// A list of schedule actions to delete.
	//
	// ActionNames is a required field
	ActionNames []*string `locationName:"actionNames" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionDeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionDeleteRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchScheduleActionDeleteRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchScheduleActionDeleteRequest"}
	if s.ActionNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionNames sets the ActionNames field's value.
func (s *BatchScheduleActionDeleteRequest) SetActionNames(v []*string) *BatchScheduleActionDeleteRequest {
	s.ActionNames = v
	return s
}

// List of actions that have been deleted from the schedule.
type BatchScheduleActionDeleteResult struct {
	_ struct{} `type:"structure"`

	// List of actions that have been deleted from the schedule.
	//
	// ScheduleActions is a required field
	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionDeleteResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchScheduleActionDeleteResult) GoString() string {
	return s.String()
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *BatchScheduleActionDeleteResult) SetScheduleActions(v []*ScheduleAction) *BatchScheduleActionDeleteResult {
	s.ScheduleActions = v
	return s
}

type BatchStartInput struct {
	_ struct{} `type:"structure"`

	ChannelIds []*string `locationName:"channelIds" type:"list"`

	MultiplexIds []*string `locationName:"multiplexIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartInput) GoString() string {
	return s.String()
}

// SetChannelIds sets the ChannelIds field's value.
func (s *BatchStartInput) SetChannelIds(v []*string) *BatchStartInput {
	s.ChannelIds = v
	return s
}

// SetMultiplexIds sets the MultiplexIds field's value.
func (s *BatchStartInput) SetMultiplexIds(v []*string) *BatchStartInput {
	s.MultiplexIds = v
	return s
}

type BatchStartOutput struct {
	_ struct{} `type:"structure"`

	Failed []*BatchFailedResultModel `locationName:"failed" type:"list"`

	Successful []*BatchSuccessfulResultModel `locationName:"successful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStartOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *BatchStartOutput) SetFailed(v []*BatchFailedResultModel) *BatchStartOutput {
	s.Failed = v
	return s
}

// SetSuccessful sets the Successful field's value.
func (s *BatchStartOutput) SetSuccessful(v []*BatchSuccessfulResultModel) *BatchStartOutput {
	s.Successful = v
	return s
}

type BatchStopInput struct {
	_ struct{} `type:"structure"`

	ChannelIds []*string `locationName:"channelIds" type:"list"`

	MultiplexIds []*string `locationName:"multiplexIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopInput) GoString() string {
	return s.String()
}

// SetChannelIds sets the ChannelIds field's value.
func (s *BatchStopInput) SetChannelIds(v []*string) *BatchStopInput {
	s.ChannelIds = v
	return s
}

// SetMultiplexIds sets the MultiplexIds field's value.
func (s *BatchStopInput) SetMultiplexIds(v []*string) *BatchStopInput {
	s.MultiplexIds = v
	return s
}

type BatchStopOutput struct {
	_ struct{} `type:"structure"`

	Failed []*BatchFailedResultModel `locationName:"failed" type:"list"`

	Successful []*BatchSuccessfulResultModel `locationName:"successful" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchStopOutput) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *BatchStopOutput) SetFailed(v []*BatchFailedResultModel) *BatchStopOutput {
	s.Failed = v
	return s
}

// SetSuccessful sets the Successful field's value.
func (s *BatchStopOutput) SetSuccessful(v []*BatchSuccessfulResultModel) *BatchStopOutput {
	s.Successful = v
	return s
}

// Details from a successful operation
type BatchSuccessfulResultModel struct {
	_ struct{} `type:"structure"`

	// ARN of the resource
	Arn *string `locationName:"arn" type:"string"`

	// ID of the resource
	Id *string `locationName:"id" type:"string"`

	// Current state of the resource
	State *string `locationName:"state" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSuccessfulResultModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchSuccessfulResultModel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *BatchSuccessfulResultModel) SetArn(v string) *BatchSuccessfulResultModel {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *BatchSuccessfulResultModel) SetId(v string) *BatchSuccessfulResultModel {
	s.Id = &v
	return s
}

// SetState sets the State field's value.
func (s *BatchSuccessfulResultModel) SetState(v string) *BatchSuccessfulResultModel {
	s.State = &v
	return s
}

// A request to create actions (add actions to the schedule), delete actions
// (remove actions from the schedule), or both create and delete actions.
type BatchUpdateScheduleInput struct {
	_ struct{} `type:"structure"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	// Schedule actions to create in the schedule.
	Creates *BatchScheduleActionCreateRequest `locationName:"creates" type:"structure"`

	// Schedule actions to delete from the schedule.
	Deletes *BatchScheduleActionDeleteRequest `locationName:"deletes" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.Creates != nil {
		if err := s.Creates.Validate(); err != nil {
			invalidParams.AddNested("Creates", err.(request.ErrInvalidParams))
		}
	}
	if s.Deletes != nil {
		if err := s.Deletes.Validate(); err != nil {
			invalidParams.AddNested("Deletes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *BatchUpdateScheduleInput) SetChannelId(v string) *BatchUpdateScheduleInput {
	s.ChannelId = &v
	return s
}

// SetCreates sets the Creates field's value.
func (s *BatchUpdateScheduleInput) SetCreates(v *BatchScheduleActionCreateRequest) *BatchUpdateScheduleInput {
	s.Creates = v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *BatchUpdateScheduleInput) SetDeletes(v *BatchScheduleActionDeleteRequest) *BatchUpdateScheduleInput {
	s.Deletes = v
	return s
}

type BatchUpdateScheduleOutput struct {
	_ struct{} `type:"structure"`

	// List of actions that have been created in the schedule.
	Creates *BatchScheduleActionCreateResult `locationName:"creates" type:"structure"`

	// List of actions that have been deleted from the schedule.
	Deletes *BatchScheduleActionDeleteResult `locationName:"deletes" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateScheduleOutput) GoString() string {
	return s.String()
}

// SetCreates sets the Creates field's value.
func (s *BatchUpdateScheduleOutput) SetCreates(v *BatchScheduleActionCreateResult) *BatchUpdateScheduleOutput {
	s.Creates = v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *BatchUpdateScheduleOutput) SetDeletes(v *BatchScheduleActionDeleteResult) *BatchUpdateScheduleOutput {
	s.Deletes = v
	return s
}

// Blackout Slate
type BlackoutSlate struct {
	_ struct{} `type:"structure"`

	// Blackout slate image to be used. Leave empty for solid black. Only bmp and
	// png images are supported.
	BlackoutSlateImage *InputLocation `locationName:"blackoutSlateImage" type:"structure"`

	// Setting to enabled causes the encoder to blackout the video, audio, and captions,
	// and raise the "Network Blackout Image" slate when an SCTE104/35 Network End
	// Segmentation Descriptor is encountered. The blackout will be lifted when
	// the Network Start Segmentation Descriptor is encountered. The Network End
	// and Network Start descriptors must contain a network ID that matches the
	// value entered in "Network ID".
	NetworkEndBlackout *string `locationName:"networkEndBlackout" type:"string" enum:"BlackoutSlateNetworkEndBlackout"`

	// Path to local file to use as Network End Blackout image. Image will be scaled
	// to fill the entire output raster.
	NetworkEndBlackoutImage *InputLocation `locationName:"networkEndBlackoutImage" type:"structure"`

	// Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
	NetworkId *string `locationName:"networkId" min:"34" type:"string"`

	// When set to enabled, causes video, audio and captions to be blanked when
	// indicated by program metadata.
	State *string `locationName:"state" type:"string" enum:"BlackoutSlateState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlackoutSlate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlackoutSlate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlackoutSlate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlackoutSlate"}
	if s.NetworkId != nil && len(*s.NetworkId) < 34 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkId", 34))
	}
	if s.BlackoutSlateImage != nil {
		if err := s.BlackoutSlateImage.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlateImage", err.(request.ErrInvalidParams))
		}
	}
	if s.NetworkEndBlackoutImage != nil {
		if err := s.NetworkEndBlackoutImage.Validate(); err != nil {
			invalidParams.AddNested("NetworkEndBlackoutImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackoutSlateImage sets the BlackoutSlateImage field's value.
func (s *BlackoutSlate) SetBlackoutSlateImage(v *InputLocation) *BlackoutSlate {
	s.BlackoutSlateImage = v
	return s
}

// SetNetworkEndBlackout sets the NetworkEndBlackout field's value.
func (s *BlackoutSlate) SetNetworkEndBlackout(v string) *BlackoutSlate {
	s.NetworkEndBlackout = &v
	return s
}

// SetNetworkEndBlackoutImage sets the NetworkEndBlackoutImage field's value.
func (s *BlackoutSlate) SetNetworkEndBlackoutImage(v *InputLocation) *BlackoutSlate {
	s.NetworkEndBlackoutImage = v
	return s
}

// SetNetworkId sets the NetworkId field's value.
func (s *BlackoutSlate) SetNetworkId(v string) *BlackoutSlate {
	s.NetworkId = &v
	return s
}

// SetState sets the State field's value.
func (s *BlackoutSlate) SetState(v string) *BlackoutSlate {
	s.State = &v
	return s
}

// Burn In Destination Settings
type BurnInDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"BurnInAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"BurnInBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter out is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"BurnInFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to 'auto' fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"BurnInOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"BurnInShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter out is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"BurnInTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. All burn-in
	// and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BurnInDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BurnInDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BurnInDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BurnInDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *BurnInDestinationSettings) SetAlignment(v string) *BurnInDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *BurnInDestinationSettings) SetBackgroundColor(v string) *BurnInDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *BurnInDestinationSettings) SetBackgroundOpacity(v int64) *BurnInDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *BurnInDestinationSettings) SetFont(v *InputLocation) *BurnInDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *BurnInDestinationSettings) SetFontColor(v string) *BurnInDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *BurnInDestinationSettings) SetFontOpacity(v int64) *BurnInDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *BurnInDestinationSettings) SetFontResolution(v int64) *BurnInDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *BurnInDestinationSettings) SetFontSize(v string) *BurnInDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *BurnInDestinationSettings) SetOutlineColor(v string) *BurnInDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *BurnInDestinationSettings) SetOutlineSize(v int64) *BurnInDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *BurnInDestinationSettings) SetShadowColor(v string) *BurnInDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *BurnInDestinationSettings) SetShadowOpacity(v int64) *BurnInDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *BurnInDestinationSettings) SetShadowXOffset(v int64) *BurnInDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *BurnInDestinationSettings) SetShadowYOffset(v int64) *BurnInDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *BurnInDestinationSettings) SetTeletextGridControl(v string) *BurnInDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *BurnInDestinationSettings) SetXPosition(v int64) *BurnInDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *BurnInDestinationSettings) SetYPosition(v int64) *BurnInDestinationSettings {
	s.YPosition = &v
	return s
}

type CancelInputDeviceTransferInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInputDeviceTransferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInputDeviceTransferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelInputDeviceTransferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelInputDeviceTransferInput"}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *CancelInputDeviceTransferInput) SetInputDeviceId(v string) *CancelInputDeviceTransferInput {
	s.InputDeviceId = &v
	return s
}

type CancelInputDeviceTransferOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInputDeviceTransferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelInputDeviceTransferOutput) GoString() string {
	return s.String()
}

// Caption Description
type CaptionDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether the caption track implements accessibility features such
	// as written descriptions of spoken dialog, music, and sounds. This signaling
	// is added to HLS output group and MediaPackage output group.
	Accessibility *string `locationName:"accessibility" type:"string" enum:"AccessibilityType"`

	// Identifies the DASH roles to assign to this captions output. Applies only
	// when the captions output is configured for DVB DASH accessibility signaling.
	CaptionDashRoles []*string `locationName:"captionDashRoles" type:"list" enum:"DashRoleCaption"`

	// Specifies which input caption selector to use as a caption source when generating
	// output captions. This field should match a captionSelector name.
	//
	// CaptionSelectorName is a required field
	CaptionSelectorName *string `locationName:"captionSelectorName" type:"string" required:"true"`

	// Additional settings for captions destination that depend on the destination
	// type.
	DestinationSettings *CaptionDestinationSettings `locationName:"destinationSettings" type:"structure"`

	// Identifies DVB DASH accessibility signaling in this captions output. Used
	// in Microsoft Smooth Streaming outputs to signal accessibility information
	// to packagers.
	DvbDashAccessibility *string `locationName:"dvbDashAccessibility" type:"string" enum:"DvbDashAccessibility"`

	// ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Human readable information to indicate captions available for players (eg.
	// English, or Spanish).
	LanguageDescription *string `locationName:"languageDescription" type:"string"`

	// Name of the caption description. Used to associate a caption description
	// with an output. Names must be unique within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDescription"}
	if s.CaptionSelectorName == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionSelectorName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DestinationSettings != nil {
		if err := s.DestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessibility sets the Accessibility field's value.
func (s *CaptionDescription) SetAccessibility(v string) *CaptionDescription {
	s.Accessibility = &v
	return s
}

// SetCaptionDashRoles sets the CaptionDashRoles field's value.
func (s *CaptionDescription) SetCaptionDashRoles(v []*string) *CaptionDescription {
	s.CaptionDashRoles = v
	return s
}

// SetCaptionSelectorName sets the CaptionSelectorName field's value.
func (s *CaptionDescription) SetCaptionSelectorName(v string) *CaptionDescription {
	s.CaptionSelectorName = &v
	return s
}

// SetDestinationSettings sets the DestinationSettings field's value.
func (s *CaptionDescription) SetDestinationSettings(v *CaptionDestinationSettings) *CaptionDescription {
	s.DestinationSettings = v
	return s
}

// SetDvbDashAccessibility sets the DvbDashAccessibility field's value.
func (s *CaptionDescription) SetDvbDashAccessibility(v string) *CaptionDescription {
	s.DvbDashAccessibility = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionDescription) SetLanguageCode(v string) *CaptionDescription {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionDescription) SetLanguageDescription(v string) *CaptionDescription {
	s.LanguageDescription = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionDescription) SetName(v string) *CaptionDescription {
	s.Name = &v
	return s
}

// Caption Destination Settings
type CaptionDestinationSettings struct {
	_ struct{} `type:"structure"`

	// Arib Destination Settings
	AribDestinationSettings *AribDestinationSettings `locationName:"aribDestinationSettings" type:"structure"`

	// Burn In Destination Settings
	BurnInDestinationSettings *BurnInDestinationSettings `locationName:"burnInDestinationSettings" type:"structure"`

	// Dvb Sub Destination Settings
	DvbSubDestinationSettings *DvbSubDestinationSettings `locationName:"dvbSubDestinationSettings" type:"structure"`

	// Ebu Tt DDestination Settings
	EbuTtDDestinationSettings *EbuTtDDestinationSettings `locationName:"ebuTtDDestinationSettings" type:"structure"`

	// Embedded Destination Settings
	EmbeddedDestinationSettings *EmbeddedDestinationSettings `locationName:"embeddedDestinationSettings" type:"structure"`

	// Embedded Plus Scte20 Destination Settings
	EmbeddedPlusScte20DestinationSettings *EmbeddedPlusScte20DestinationSettings `locationName:"embeddedPlusScte20DestinationSettings" type:"structure"`

	// Rtmp Caption Info Destination Settings
	RtmpCaptionInfoDestinationSettings *RtmpCaptionInfoDestinationSettings `locationName:"rtmpCaptionInfoDestinationSettings" type:"structure"`

	// Scte20 Plus Embedded Destination Settings
	Scte20PlusEmbeddedDestinationSettings *Scte20PlusEmbeddedDestinationSettings `locationName:"scte20PlusEmbeddedDestinationSettings" type:"structure"`

	// Scte27 Destination Settings
	Scte27DestinationSettings *Scte27DestinationSettings `locationName:"scte27DestinationSettings" type:"structure"`

	// Smpte Tt Destination Settings
	SmpteTtDestinationSettings *SmpteTtDestinationSettings `locationName:"smpteTtDestinationSettings" type:"structure"`

	// Teletext Destination Settings
	TeletextDestinationSettings *TeletextDestinationSettings `locationName:"teletextDestinationSettings" type:"structure"`

	// Ttml Destination Settings
	TtmlDestinationSettings *TtmlDestinationSettings `locationName:"ttmlDestinationSettings" type:"structure"`

	// Webvtt Destination Settings
	WebvttDestinationSettings *WebvttDestinationSettings `locationName:"webvttDestinationSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionDestinationSettings"}
	if s.BurnInDestinationSettings != nil {
		if err := s.BurnInDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("BurnInDestinationSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSubDestinationSettings != nil {
		if err := s.DvbSubDestinationSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubDestinationSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAribDestinationSettings sets the AribDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetAribDestinationSettings(v *AribDestinationSettings) *CaptionDestinationSettings {
	s.AribDestinationSettings = v
	return s
}

// SetBurnInDestinationSettings sets the BurnInDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetBurnInDestinationSettings(v *BurnInDestinationSettings) *CaptionDestinationSettings {
	s.BurnInDestinationSettings = v
	return s
}

// SetDvbSubDestinationSettings sets the DvbSubDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetDvbSubDestinationSettings(v *DvbSubDestinationSettings) *CaptionDestinationSettings {
	s.DvbSubDestinationSettings = v
	return s
}

// SetEbuTtDDestinationSettings sets the EbuTtDDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEbuTtDDestinationSettings(v *EbuTtDDestinationSettings) *CaptionDestinationSettings {
	s.EbuTtDDestinationSettings = v
	return s
}

// SetEmbeddedDestinationSettings sets the EmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedDestinationSettings(v *EmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedDestinationSettings = v
	return s
}

// SetEmbeddedPlusScte20DestinationSettings sets the EmbeddedPlusScte20DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetEmbeddedPlusScte20DestinationSettings(v *EmbeddedPlusScte20DestinationSettings) *CaptionDestinationSettings {
	s.EmbeddedPlusScte20DestinationSettings = v
	return s
}

// SetRtmpCaptionInfoDestinationSettings sets the RtmpCaptionInfoDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetRtmpCaptionInfoDestinationSettings(v *RtmpCaptionInfoDestinationSettings) *CaptionDestinationSettings {
	s.RtmpCaptionInfoDestinationSettings = v
	return s
}

// SetScte20PlusEmbeddedDestinationSettings sets the Scte20PlusEmbeddedDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte20PlusEmbeddedDestinationSettings(v *Scte20PlusEmbeddedDestinationSettings) *CaptionDestinationSettings {
	s.Scte20PlusEmbeddedDestinationSettings = v
	return s
}

// SetScte27DestinationSettings sets the Scte27DestinationSettings field's value.
func (s *CaptionDestinationSettings) SetScte27DestinationSettings(v *Scte27DestinationSettings) *CaptionDestinationSettings {
	s.Scte27DestinationSettings = v
	return s
}

// SetSmpteTtDestinationSettings sets the SmpteTtDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetSmpteTtDestinationSettings(v *SmpteTtDestinationSettings) *CaptionDestinationSettings {
	s.SmpteTtDestinationSettings = v
	return s
}

// SetTeletextDestinationSettings sets the TeletextDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTeletextDestinationSettings(v *TeletextDestinationSettings) *CaptionDestinationSettings {
	s.TeletextDestinationSettings = v
	return s
}

// SetTtmlDestinationSettings sets the TtmlDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetTtmlDestinationSettings(v *TtmlDestinationSettings) *CaptionDestinationSettings {
	s.TtmlDestinationSettings = v
	return s
}

// SetWebvttDestinationSettings sets the WebvttDestinationSettings field's value.
func (s *CaptionDestinationSettings) SetWebvttDestinationSettings(v *WebvttDestinationSettings) *CaptionDestinationSettings {
	s.WebvttDestinationSettings = v
	return s
}

// Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2),
// with an optional description.
type CaptionLanguageMapping struct {
	_ struct{} `type:"structure"`

	// The closed caption channel being described by this CaptionLanguageMapping.
	// Each channel mapping must have a unique channel number (maximum of 4)
	//
	// CaptionChannel is a required field
	CaptionChannel *int64 `locationName:"captionChannel" min:"1" type:"integer" required:"true"`

	// Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)
	//
	// LanguageCode is a required field
	LanguageCode *string `locationName:"languageCode" min:"3" type:"string" required:"true"`

	// Textual description of language
	//
	// LanguageDescription is a required field
	LanguageDescription *string `locationName:"languageDescription" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionLanguageMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionLanguageMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionLanguageMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionLanguageMapping"}
	if s.CaptionChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("CaptionChannel"))
	}
	if s.CaptionChannel != nil && *s.CaptionChannel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CaptionChannel", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 3))
	}
	if s.LanguageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageDescription"))
	}
	if s.LanguageDescription != nil && len(*s.LanguageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageDescription", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionChannel sets the CaptionChannel field's value.
func (s *CaptionLanguageMapping) SetCaptionChannel(v int64) *CaptionLanguageMapping {
	s.CaptionChannel = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionLanguageMapping) SetLanguageCode(v string) *CaptionLanguageMapping {
	s.LanguageCode = &v
	return s
}

// SetLanguageDescription sets the LanguageDescription field's value.
func (s *CaptionLanguageMapping) SetLanguageDescription(v string) *CaptionLanguageMapping {
	s.LanguageDescription = &v
	return s
}

// Caption Rectangle
type CaptionRectangle struct {
	_ struct{} `type:"structure"`

	// See the description in leftOffset.For height, specify the entire height of
	// the rectangle as a percentage of the underlying frame height. For example,
	// \"80\" means the rectangle height is 80% of the underlying frame height.
	// The topOffset and rectangleHeight must add up to 100% or less.This field
	// corresponds to tts:extent - Y in the TTML standard.
	//
	// Height is a required field
	Height *float64 `locationName:"height" type:"double" required:"true"`

	// Applies only if you plan to convert these source captions to EBU-TT-D or
	// TTML in an output. (Make sure to leave the default if you don't have either
	// of these formats in the output.) You can define a display rectangle for the
	// captions that is smaller than the underlying video frame. You define the
	// rectangle by specifying the position of the left edge, top edge, bottom edge,
	// and right edge of the rectangle, all within the underlying video frame. The
	// units for the measurements are percentages.If you specify a value for one
	// of these fields, you must specify a value for all of them.For leftOffset,
	// specify the position of the left edge of the rectangle, as a percentage of
	// the underlying frame width, and relative to the left edge of the frame. For
	// example, \"10\" means the measurement is 10% of the underlying frame width.
	// The rectangle left edge starts at that position from the left edge of the
	// frame.This field corresponds to tts:origin - X in the TTML standard.
	//
	// LeftOffset is a required field
	LeftOffset *float64 `locationName:"leftOffset" type:"double" required:"true"`

	// See the description in leftOffset.For topOffset, specify the position of
	// the top edge of the rectangle, as a percentage of the underlying frame height,
	// and relative to the top edge of the frame. For example, \"10\" means the
	// measurement is 10% of the underlying frame height. The rectangle top edge
	// starts at that position from the top edge of the frame.This field corresponds
	// to tts:origin - Y in the TTML standard.
	//
	// TopOffset is a required field
	TopOffset *float64 `locationName:"topOffset" type:"double" required:"true"`

	// See the description in leftOffset.For width, specify the entire width of
	// the rectangle as a percentage of the underlying frame width. For example,
	// \"80\" means the rectangle width is 80% of the underlying frame width. The
	// leftOffset and rectangleWidth must add up to 100% or less.This field corresponds
	// to tts:extent - X in the TTML standard.
	//
	// Width is a required field
	Width *float64 `locationName:"width" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionRectangle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionRectangle) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionRectangle) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionRectangle"}
	if s.Height == nil {
		invalidParams.Add(request.NewErrParamRequired("Height"))
	}
	if s.LeftOffset == nil {
		invalidParams.Add(request.NewErrParamRequired("LeftOffset"))
	}
	if s.TopOffset == nil {
		invalidParams.Add(request.NewErrParamRequired("TopOffset"))
	}
	if s.Width == nil {
		invalidParams.Add(request.NewErrParamRequired("Width"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeight sets the Height field's value.
func (s *CaptionRectangle) SetHeight(v float64) *CaptionRectangle {
	s.Height = &v
	return s
}

// SetLeftOffset sets the LeftOffset field's value.
func (s *CaptionRectangle) SetLeftOffset(v float64) *CaptionRectangle {
	s.LeftOffset = &v
	return s
}

// SetTopOffset sets the TopOffset field's value.
func (s *CaptionRectangle) SetTopOffset(v float64) *CaptionRectangle {
	s.TopOffset = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *CaptionRectangle) SetWidth(v float64) *CaptionRectangle {
	s.Width = &v
	return s
}

// Caption Selector
type CaptionSelector struct {
	_ struct{} `type:"structure"`

	// When specified this field indicates the three letter language code of the
	// caption track to extract from the source.
	LanguageCode *string `locationName:"languageCode" type:"string"`

	// Name identifier for a caption selector. This name is used to associate this
	// caption selector with one or more caption descriptions. Names must be unique
	// within an event.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Caption selector settings.
	SelectorSettings *CaptionSelectorSettings `locationName:"selectorSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelector"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SelectorSettings != nil {
		if err := s.SelectorSettings.Validate(); err != nil {
			invalidParams.AddNested("SelectorSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CaptionSelector) SetLanguageCode(v string) *CaptionSelector {
	s.LanguageCode = &v
	return s
}

// SetName sets the Name field's value.
func (s *CaptionSelector) SetName(v string) *CaptionSelector {
	s.Name = &v
	return s
}

// SetSelectorSettings sets the SelectorSettings field's value.
func (s *CaptionSelector) SetSelectorSettings(v *CaptionSelectorSettings) *CaptionSelector {
	s.SelectorSettings = v
	return s
}

// Caption Selector Settings
type CaptionSelectorSettings struct {
	_ struct{} `type:"structure"`

	// Ancillary Source Settings
	AncillarySourceSettings *AncillarySourceSettings `locationName:"ancillarySourceSettings" type:"structure"`

	// Arib Source Settings
	AribSourceSettings *AribSourceSettings `locationName:"aribSourceSettings" type:"structure"`

	// Dvb Sub Source Settings
	DvbSubSourceSettings *DvbSubSourceSettings `locationName:"dvbSubSourceSettings" type:"structure"`

	// Embedded Source Settings
	EmbeddedSourceSettings *EmbeddedSourceSettings `locationName:"embeddedSourceSettings" type:"structure"`

	// Scte20 Source Settings
	Scte20SourceSettings *Scte20SourceSettings `locationName:"scte20SourceSettings" type:"structure"`

	// Scte27 Source Settings
	Scte27SourceSettings *Scte27SourceSettings `locationName:"scte27SourceSettings" type:"structure"`

	// Teletext Source Settings
	TeletextSourceSettings *TeletextSourceSettings `locationName:"teletextSourceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionSelectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CaptionSelectorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSelectorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSelectorSettings"}
	if s.AncillarySourceSettings != nil {
		if err := s.AncillarySourceSettings.Validate(); err != nil {
			invalidParams.AddNested("AncillarySourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.DvbSubSourceSettings != nil {
		if err := s.DvbSubSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("DvbSubSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.EmbeddedSourceSettings != nil {
		if err := s.EmbeddedSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("EmbeddedSourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte20SourceSettings != nil {
		if err := s.Scte20SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte20SourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Scte27SourceSettings != nil {
		if err := s.Scte27SourceSettings.Validate(); err != nil {
			invalidParams.AddNested("Scte27SourceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.TeletextSourceSettings != nil {
		if err := s.TeletextSourceSettings.Validate(); err != nil {
			invalidParams.AddNested("TeletextSourceSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAncillarySourceSettings sets the AncillarySourceSettings field's value.
func (s *CaptionSelectorSettings) SetAncillarySourceSettings(v *AncillarySourceSettings) *CaptionSelectorSettings {
	s.AncillarySourceSettings = v
	return s
}

// SetAribSourceSettings sets the AribSourceSettings field's value.
func (s *CaptionSelectorSettings) SetAribSourceSettings(v *AribSourceSettings) *CaptionSelectorSettings {
	s.AribSourceSettings = v
	return s
}

// SetDvbSubSourceSettings sets the DvbSubSourceSettings field's value.
func (s *CaptionSelectorSettings) SetDvbSubSourceSettings(v *DvbSubSourceSettings) *CaptionSelectorSettings {
	s.DvbSubSourceSettings = v
	return s
}

// SetEmbeddedSourceSettings sets the EmbeddedSourceSettings field's value.
func (s *CaptionSelectorSettings) SetEmbeddedSourceSettings(v *EmbeddedSourceSettings) *CaptionSelectorSettings {
	s.EmbeddedSourceSettings = v
	return s
}

// SetScte20SourceSettings sets the Scte20SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte20SourceSettings(v *Scte20SourceSettings) *CaptionSelectorSettings {
	s.Scte20SourceSettings = v
	return s
}

// SetScte27SourceSettings sets the Scte27SourceSettings field's value.
func (s *CaptionSelectorSettings) SetScte27SourceSettings(v *Scte27SourceSettings) *CaptionSelectorSettings {
	s.Scte27SourceSettings = v
	return s
}

// SetTeletextSourceSettings sets the TeletextSourceSettings field's value.
func (s *CaptionSelectorSettings) SetTeletextSourceSettings(v *TeletextSourceSettings) *CaptionSelectorSettings {
	s.TeletextSourceSettings = v
	return s
}

type CdiInputSpecification struct {
	_ struct{} `type:"structure"`

	// Maximum CDI input resolution
	Resolution *string `locationName:"resolution" type:"string" enum:"CdiInputResolution"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CdiInputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CdiInputSpecification) GoString() string {
	return s.String()
}

// SetResolution sets the Resolution field's value.
func (s *CdiInputSpecification) SetResolution(v string) *CdiInputSpecification {
	s.Resolution = &v
	return s
}

type Channel struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// Specification of CDI inputs for this channel
	CdiInputSpecification *CdiInputSpecification `locationName:"cdiInputSpecification" type:"structure"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	// Specification of network and file inputs for this channel
	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// Maintenance settings for this channel.
	Maintenance *MaintenanceStatus `locationName:"maintenance" type:"structure"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// Runtime details for the pipelines of a running channel.
	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Settings for VPC output
	Vpc *VpcOutputSettingsDescription `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Channel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Channel) SetArn(v string) *Channel {
	s.Arn = &v
	return s
}

// SetCdiInputSpecification sets the CdiInputSpecification field's value.
func (s *Channel) SetCdiInputSpecification(v *CdiInputSpecification) *Channel {
	s.CdiInputSpecification = v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *Channel) SetChannelClass(v string) *Channel {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Channel) SetDestinations(v []*OutputDestination) *Channel {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *Channel) SetEgressEndpoints(v []*ChannelEgressEndpoint) *Channel {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *Channel) SetEncoderSettings(v *EncoderSettings) *Channel {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *Channel) SetId(v string) *Channel {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *Channel) SetInputAttachments(v []*InputAttachment) *Channel {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *Channel) SetInputSpecification(v *InputSpecification) *Channel {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *Channel) SetLogLevel(v string) *Channel {
	s.LogLevel = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *Channel) SetMaintenance(v *MaintenanceStatus) *Channel {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *Channel) SetName(v string) *Channel {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *Channel) SetPipelineDetails(v []*PipelineDetail) *Channel {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *Channel) SetPipelinesRunningCount(v int64) *Channel {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Channel) SetRoleArn(v string) *Channel {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *Channel) SetState(v string) *Channel {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Channel) SetTags(v map[string]*string) *Channel {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *Channel) SetVpc(v *VpcOutputSettingsDescription) *Channel {
	s.Vpc = v
	return s
}

type ChannelEgressEndpoint struct {
	_ struct{} `type:"structure"`

	// Public IP of where a channel's output comes from
	SourceIp *string `locationName:"sourceIp" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelEgressEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelEgressEndpoint) GoString() string {
	return s.String()
}

// SetSourceIp sets the SourceIp field's value.
func (s *ChannelEgressEndpoint) SetSourceIp(v string) *ChannelEgressEndpoint {
	s.SourceIp = &v
	return s
}

type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The unique arn of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// Specification of CDI inputs for this channel
	CdiInputSpecification *CdiInputSpecification `locationName:"cdiInputSpecification" type:"structure"`

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	// A list of destinations of the channel. For UDP outputs, there is onedestination
	// per output. For other types (HLS, for example), there isone destination per
	// packager.
	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// The unique id of the channel.
	Id *string `locationName:"id" type:"string"`

	// List of input attachments for channel.
	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	// Specification of network and file inputs for this channel
	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level being written to CloudWatch Logs.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	// Maintenance settings for this channel.
	Maintenance *MaintenanceStatus `locationName:"maintenance" type:"structure"`

	// The name of the channel. (user-mutable)
	Name *string `locationName:"name" type:"string"`

	// The number of currently healthy pipelines.
	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Settings for any VPC outputs.
	Vpc *VpcOutputSettingsDescription `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelSummary) SetArn(v string) *ChannelSummary {
	s.Arn = &v
	return s
}

// SetCdiInputSpecification sets the CdiInputSpecification field's value.
func (s *ChannelSummary) SetCdiInputSpecification(v *CdiInputSpecification) *ChannelSummary {
	s.CdiInputSpecification = v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *ChannelSummary) SetChannelClass(v string) *ChannelSummary {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *ChannelSummary) SetDestinations(v []*OutputDestination) *ChannelSummary {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *ChannelSummary) SetEgressEndpoints(v []*ChannelEgressEndpoint) *ChannelSummary {
	s.EgressEndpoints = v
	return s
}

// SetId sets the Id field's value.
func (s *ChannelSummary) SetId(v string) *ChannelSummary {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *ChannelSummary) SetInputAttachments(v []*InputAttachment) *ChannelSummary {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *ChannelSummary) SetInputSpecification(v *InputSpecification) *ChannelSummary {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *ChannelSummary) SetLogLevel(v string) *ChannelSummary {
	s.LogLevel = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *ChannelSummary) SetMaintenance(v *MaintenanceStatus) *ChannelSummary {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *ChannelSummary) SetName(v string) *ChannelSummary {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *ChannelSummary) SetPipelinesRunningCount(v int64) *ChannelSummary {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ChannelSummary) SetRoleArn(v string) *ChannelSummary {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *ChannelSummary) SetState(v string) *ChannelSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ChannelSummary) SetTags(v map[string]*string) *ChannelSummary {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *ChannelSummary) SetVpc(v *VpcOutputSettingsDescription) *ChannelSummary {
	s.Vpc = v
	return s
}

// Request to claim an AWS Elemental device that you have purchased from a third-party
// vendor.
type ClaimDeviceInput struct {
	_ struct{} `type:"structure"`

	// The id of the device you want to claim.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimDeviceInput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ClaimDeviceInput) SetId(v string) *ClaimDeviceInput {
	s.Id = &v
	return s
}

type ClaimDeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimDeviceOutput) GoString() string {
	return s.String()
}

type CloudWatchAlarmTemplateGroupSummary struct {
	_ struct{} `type:"structure"`

	// A cloudwatch alarm template group's ARN (Amazon Resource Name)
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A resource's optional description.
	Description *string `locationName:"description" type:"string"`

	// A cloudwatch alarm template group's id. AWS provided template groups have
	// ids that start with `aws-`
	//
	// Id is a required field
	Id *string `locationName:"id" min:"7" type:"string" required:"true"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// A resource's name. Names must be unique within the scope of a resource type
	// in a specific region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The number of templates in a group.
	//
	// TemplateCount is a required field
	TemplateCount *int64 `locationName:"templateCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchAlarmTemplateGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchAlarmTemplateGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetArn(v string) *CloudWatchAlarmTemplateGroupSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetCreatedAt(v time.Time) *CloudWatchAlarmTemplateGroupSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetDescription(v string) *CloudWatchAlarmTemplateGroupSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetId(v string) *CloudWatchAlarmTemplateGroupSummary {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetModifiedAt(v time.Time) *CloudWatchAlarmTemplateGroupSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetName(v string) *CloudWatchAlarmTemplateGroupSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetTags(v map[string]*string) *CloudWatchAlarmTemplateGroupSummary {
	s.Tags = v
	return s
}

// SetTemplateCount sets the TemplateCount field's value.
func (s *CloudWatchAlarmTemplateGroupSummary) SetTemplateCount(v int64) *CloudWatchAlarmTemplateGroupSummary {
	s.TemplateCount = &v
	return s
}

type CloudWatchAlarmTemplateSummary struct {
	_ struct{} `type:"structure"`

	// A cloudwatch alarm template's ARN (Amazon Resource Name)
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The comparison operator used to compare the specified statistic and the threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" required:"true" enum:"CloudWatchAlarmTemplateComparisonOperator"`

	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The number of datapoints within the evaluation period that must be breaching
	// to trigger the alarm.
	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" min:"1" type:"integer"`

	// A resource's optional description.
	Description *string `locationName:"description" type:"string"`

	// The number of periods over which data is compared to the specified threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `locationName:"evaluationPeriods" min:"1" type:"integer" required:"true"`

	// A cloudwatch alarm template group's id. AWS provided template groups have
	// ids that start with `aws-`
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" min:"7" type:"string" required:"true"`

	// A cloudwatch alarm template's id. AWS provided templates have ids that start
	// with `aws-`
	//
	// Id is a required field
	Id *string `locationName:"id" min:"7" type:"string" required:"true"`

	// The name of the metric associated with the alarm. Must be compatible with
	// targetResourceType.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// A resource's name. Names must be unique within the scope of a resource type
	// in a specific region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The period, in seconds, over which the specified statistic is applied.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"10" type:"integer" required:"true"`

	// The statistic to apply to the alarm's metric data.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"CloudWatchAlarmTemplateStatistic"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The resource type this template should dynamically generate cloudwatch metric
	// alarms for.
	//
	// TargetResourceType is a required field
	TargetResourceType *string `locationName:"targetResourceType" type:"string" required:"true" enum:"CloudWatchAlarmTemplateTargetResourceType"`

	// The threshold value to compare with the specified statistic.
	//
	// Threshold is a required field
	Threshold *float64 `locationName:"threshold" type:"double" required:"true"`

	// Specifies how missing data points are treated when evaluating the alarm's
	// condition.
	//
	// TreatMissingData is a required field
	TreatMissingData *string `locationName:"treatMissingData" type:"string" required:"true" enum:"CloudWatchAlarmTemplateTreatMissingData"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchAlarmTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchAlarmTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CloudWatchAlarmTemplateSummary) SetArn(v string) *CloudWatchAlarmTemplateSummary {
	s.Arn = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *CloudWatchAlarmTemplateSummary) SetComparisonOperator(v string) *CloudWatchAlarmTemplateSummary {
	s.ComparisonOperator = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CloudWatchAlarmTemplateSummary) SetCreatedAt(v time.Time) *CloudWatchAlarmTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *CloudWatchAlarmTemplateSummary) SetDatapointsToAlarm(v int64) *CloudWatchAlarmTemplateSummary {
	s.DatapointsToAlarm = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CloudWatchAlarmTemplateSummary) SetDescription(v string) *CloudWatchAlarmTemplateSummary {
	s.Description = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *CloudWatchAlarmTemplateSummary) SetEvaluationPeriods(v int64) *CloudWatchAlarmTemplateSummary {
	s.EvaluationPeriods = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CloudWatchAlarmTemplateSummary) SetGroupId(v string) *CloudWatchAlarmTemplateSummary {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CloudWatchAlarmTemplateSummary) SetId(v string) *CloudWatchAlarmTemplateSummary {
	s.Id = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchAlarmTemplateSummary) SetMetricName(v string) *CloudWatchAlarmTemplateSummary {
	s.MetricName = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CloudWatchAlarmTemplateSummary) SetModifiedAt(v time.Time) *CloudWatchAlarmTemplateSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CloudWatchAlarmTemplateSummary) SetName(v string) *CloudWatchAlarmTemplateSummary {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchAlarmTemplateSummary) SetPeriod(v int64) *CloudWatchAlarmTemplateSummary {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CloudWatchAlarmTemplateSummary) SetStatistic(v string) *CloudWatchAlarmTemplateSummary {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CloudWatchAlarmTemplateSummary) SetTags(v map[string]*string) *CloudWatchAlarmTemplateSummary {
	s.Tags = v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *CloudWatchAlarmTemplateSummary) SetTargetResourceType(v string) *CloudWatchAlarmTemplateSummary {
	s.TargetResourceType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *CloudWatchAlarmTemplateSummary) SetThreshold(v float64) *CloudWatchAlarmTemplateSummary {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *CloudWatchAlarmTemplateSummary) SetTreatMissingData(v string) *CloudWatchAlarmTemplateSummary {
	s.TreatMissingData = &v
	return s
}

// Cmaf Ingest Group Settings
type CmafIngestGroupSettings struct {
	_ struct{} `type:"structure"`

	// A HTTP destination for the tracks
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in
	// the output.
	NielsenId3Behavior *string `locationName:"nielsenId3Behavior" type:"string" enum:"CmafNielsenId3Behavior"`

	// Type of scte35 track to add. none or scte35WithoutSegmentation
	Scte35Type *string `locationName:"scte35Type" type:"string" enum:"Scte35Type"`

	// The nominal duration of segments. The units are specified in SegmentLengthUnits.
	// The segments will end on the next keyframe after the specified duration,
	// so the actual segment length might be longer, and it might be a fraction
	// of the units.
	SegmentLength *int64 `locationName:"segmentLength" min:"1" type:"integer"`

	// Time unit for segment length parameter.
	SegmentLengthUnits *string `locationName:"segmentLengthUnits" type:"string" enum:"CmafIngestSegmentLengthUnits"`

	// Number of milliseconds to delay the output from the second pipeline.
	SendDelayMs *int64 `locationName:"sendDelayMs" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafIngestGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafIngestGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CmafIngestGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CmafIngestGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.SegmentLength != nil && *s.SegmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *CmafIngestGroupSettings) SetDestination(v *OutputLocationRef) *CmafIngestGroupSettings {
	s.Destination = v
	return s
}

// SetNielsenId3Behavior sets the NielsenId3Behavior field's value.
func (s *CmafIngestGroupSettings) SetNielsenId3Behavior(v string) *CmafIngestGroupSettings {
	s.NielsenId3Behavior = &v
	return s
}

// SetScte35Type sets the Scte35Type field's value.
func (s *CmafIngestGroupSettings) SetScte35Type(v string) *CmafIngestGroupSettings {
	s.Scte35Type = &v
	return s
}

// SetSegmentLength sets the SegmentLength field's value.
func (s *CmafIngestGroupSettings) SetSegmentLength(v int64) *CmafIngestGroupSettings {
	s.SegmentLength = &v
	return s
}

// SetSegmentLengthUnits sets the SegmentLengthUnits field's value.
func (s *CmafIngestGroupSettings) SetSegmentLengthUnits(v string) *CmafIngestGroupSettings {
	s.SegmentLengthUnits = &v
	return s
}

// SetSendDelayMs sets the SendDelayMs field's value.
func (s *CmafIngestGroupSettings) SetSendDelayMs(v int64) *CmafIngestGroupSettings {
	s.SendDelayMs = &v
	return s
}

// Cmaf Ingest Output Settings
type CmafIngestOutputSettings struct {
	_ struct{} `type:"structure"`

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafIngestOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CmafIngestOutputSettings) GoString() string {
	return s.String()
}

// SetNameModifier sets the NameModifier field's value.
func (s *CmafIngestOutputSettings) SetNameModifier(v string) *CmafIngestOutputSettings {
	s.NameModifier = &v
	return s
}

// Property of ColorCorrectionSettings. Used for custom color space conversion.
// The object identifies one 3D LUT file and specifies the input/output color
// space combination that the file will be used for.
type ColorCorrection struct {
	_ struct{} `type:"structure"`

	// The color space of the input.
	//
	// InputColorSpace is a required field
	InputColorSpace *string `locationName:"inputColorSpace" type:"string" required:"true" enum:"ColorSpace"`

	// The color space of the output.
	//
	// OutputColorSpace is a required field
	OutputColorSpace *string `locationName:"outputColorSpace" type:"string" required:"true" enum:"ColorSpace"`

	// The URI of the 3D LUT file. The protocol must be 's3:' or 's3ssl:':.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorCorrection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorCorrection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColorCorrection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColorCorrection"}
	if s.InputColorSpace == nil {
		invalidParams.Add(request.NewErrParamRequired("InputColorSpace"))
	}
	if s.OutputColorSpace == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputColorSpace"))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputColorSpace sets the InputColorSpace field's value.
func (s *ColorCorrection) SetInputColorSpace(v string) *ColorCorrection {
	s.InputColorSpace = &v
	return s
}

// SetOutputColorSpace sets the OutputColorSpace field's value.
func (s *ColorCorrection) SetOutputColorSpace(v string) *ColorCorrection {
	s.OutputColorSpace = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ColorCorrection) SetUri(v string) *ColorCorrection {
	s.Uri = &v
	return s
}

// Property of encoderSettings. Controls color conversion when you are using
// 3D LUT files to perform color conversion on video.
type ColorCorrectionSettings struct {
	_ struct{} `type:"structure"`

	// An array of colorCorrections that applies when you are using 3D LUT files
	// to perform color conversion on video. Each colorCorrection contains one 3D
	// LUT file (that defines the color mapping for converting an input color space
	// to an output color space), and the input/output combination that this 3D
	// LUT file applies to. MediaLive reads the color space in the input metadata,
	// determines the color space that you have specified for the output, and finds
	// and uses the LUT file that applies to this combination.
	//
	// GlobalColorCorrections is a required field
	GlobalColorCorrections []*ColorCorrection `locationName:"globalColorCorrections" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorCorrectionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorCorrectionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColorCorrectionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColorCorrectionSettings"}
	if s.GlobalColorCorrections == nil {
		invalidParams.Add(request.NewErrParamRequired("GlobalColorCorrections"))
	}
	if s.GlobalColorCorrections != nil {
		for i, v := range s.GlobalColorCorrections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalColorCorrections", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlobalColorCorrections sets the GlobalColorCorrections field's value.
func (s *ColorCorrectionSettings) SetGlobalColorCorrections(v []*ColorCorrection) *ColorCorrectionSettings {
	s.GlobalColorCorrections = v
	return s
}

// Passthrough applies no color space conversion to the output
type ColorSpacePassthroughSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorSpacePassthroughSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColorSpacePassthroughSettings) GoString() string {
	return s.String()
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	CdiInputSpecification *CdiInputSpecification `locationName:"cdiInputSpecification" type:"structure"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Maintenance *MaintenanceCreateSettings `locationName:"maintenance" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Reserved *string `locationName:"reserved" deprecated:"true" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The properties for a private VPC OutputWhen this property is specified, the
	// output egress addresses will be created in a user specified VPC
	Vpc *VpcOutputSettings `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EncoderSettings != nil {
		if err := s.EncoderSettings.Validate(); err != nil {
			invalidParams.AddNested("EncoderSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputAttachments != nil {
		for i, v := range s.InputAttachments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputAttachments", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Vpc != nil {
		if err := s.Vpc.Validate(); err != nil {
			invalidParams.AddNested("Vpc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdiInputSpecification sets the CdiInputSpecification field's value.
func (s *CreateChannelInput) SetCdiInputSpecification(v *CdiInputSpecification) *CreateChannelInput {
	s.CdiInputSpecification = v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *CreateChannelInput) SetChannelClass(v string) *CreateChannelInput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *CreateChannelInput) SetDestinations(v []*OutputDestination) *CreateChannelInput {
	s.Destinations = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *CreateChannelInput) SetEncoderSettings(v *EncoderSettings) *CreateChannelInput {
	s.EncoderSettings = v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *CreateChannelInput) SetInputAttachments(v []*InputAttachment) *CreateChannelInput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *CreateChannelInput) SetInputSpecification(v *InputSpecification) *CreateChannelInput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *CreateChannelInput) SetLogLevel(v string) *CreateChannelInput {
	s.LogLevel = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *CreateChannelInput) SetMaintenance(v *MaintenanceCreateSettings) *CreateChannelInput {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateChannelInput) SetName(v string) *CreateChannelInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateChannelInput) SetRequestId(v string) *CreateChannelInput {
	s.RequestId = &v
	return s
}

// SetReserved sets the Reserved field's value.
func (s *CreateChannelInput) SetReserved(v string) *CreateChannelInput {
	s.Reserved = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateChannelInput) SetRoleArn(v string) *CreateChannelInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *CreateChannelInput) SetVpc(v *VpcOutputSettings) *CreateChannelInput {
	s.Vpc = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	Channel *Channel `locationName:"channel" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *CreateChannelOutput) SetChannel(v *Channel) *CreateChannelOutput {
	s.Channel = v
	return s
}

type CreateCloudWatchAlarmTemplateGroupInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudWatchAlarmTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudWatchAlarmTemplateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateCloudWatchAlarmTemplateGroupInput) SetDescription(v string) *CreateCloudWatchAlarmTemplateGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCloudWatchAlarmTemplateGroupInput) SetName(v string) *CreateCloudWatchAlarmTemplateGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCloudWatchAlarmTemplateGroupInput) SetTags(v map[string]*string) *CreateCloudWatchAlarmTemplateGroupInput {
	s.Tags = v
	return s
}

type CreateCloudWatchAlarmTemplateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetArn(v string) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetCreatedAt(v time.Time) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetDescription(v string) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetId(v string) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetModifiedAt(v time.Time) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetName(v string) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCloudWatchAlarmTemplateGroupOutput) SetTags(v map[string]*string) *CreateCloudWatchAlarmTemplateGroupOutput {
	s.Tags = v
	return s
}

type CreateCloudWatchAlarmTemplateInput struct {
	_ struct{} `type:"structure"`

	// The comparison operator used to compare the specified statistic and the threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" required:"true" enum:"CloudWatchAlarmTemplateComparisonOperator"`

	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" min:"1" type:"integer"`

	Description *string `locationName:"description" type:"string"`

	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `locationName:"evaluationPeriods" min:"1" type:"integer" required:"true"`

	// GroupIdentifier is a required field
	GroupIdentifier *string `locationName:"groupIdentifier" type:"string" required:"true"`

	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Period is a required field
	Period *int64 `locationName:"period" min:"10" type:"integer" required:"true"`

	// The statistic to apply to the alarm's metric data.
	//
	// Statistic is a required field
	Statistic *string `locationName:"statistic" type:"string" required:"true" enum:"CloudWatchAlarmTemplateStatistic"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The resource type this template should dynamically generate cloudwatch metric
	// alarms for.
	//
	// TargetResourceType is a required field
	TargetResourceType *string `locationName:"targetResourceType" type:"string" required:"true" enum:"CloudWatchAlarmTemplateTargetResourceType"`

	// Threshold is a required field
	Threshold *float64 `locationName:"threshold" type:"double" required:"true"`

	// Specifies how missing data points are treated when evaluating the alarm's
	// condition.
	//
	// TreatMissingData is a required field
	TreatMissingData *string `locationName:"treatMissingData" type:"string" required:"true" enum:"CloudWatchAlarmTemplateTreatMissingData"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCloudWatchAlarmTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCloudWatchAlarmTemplateInput"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.DatapointsToAlarm != nil && *s.DatapointsToAlarm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DatapointsToAlarm", 1))
	}
	if s.EvaluationPeriods == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationPeriods"))
	}
	if s.EvaluationPeriods != nil && *s.EvaluationPeriods < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationPeriods", 1))
	}
	if s.GroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIdentifier"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 10 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 10))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.TargetResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetResourceType"))
	}
	if s.Threshold == nil {
		invalidParams.Add(request.NewErrParamRequired("Threshold"))
	}
	if s.TreatMissingData == nil {
		invalidParams.Add(request.NewErrParamRequired("TreatMissingData"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetComparisonOperator(v string) *CreateCloudWatchAlarmTemplateInput {
	s.ComparisonOperator = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetDatapointsToAlarm(v int64) *CreateCloudWatchAlarmTemplateInput {
	s.DatapointsToAlarm = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetDescription(v string) *CreateCloudWatchAlarmTemplateInput {
	s.Description = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetEvaluationPeriods(v int64) *CreateCloudWatchAlarmTemplateInput {
	s.EvaluationPeriods = &v
	return s
}

// SetGroupIdentifier sets the GroupIdentifier field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetGroupIdentifier(v string) *CreateCloudWatchAlarmTemplateInput {
	s.GroupIdentifier = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetMetricName(v string) *CreateCloudWatchAlarmTemplateInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetName(v string) *CreateCloudWatchAlarmTemplateInput {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetPeriod(v int64) *CreateCloudWatchAlarmTemplateInput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetStatistic(v string) *CreateCloudWatchAlarmTemplateInput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetTags(v map[string]*string) *CreateCloudWatchAlarmTemplateInput {
	s.Tags = v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetTargetResourceType(v string) *CreateCloudWatchAlarmTemplateInput {
	s.TargetResourceType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetThreshold(v float64) *CreateCloudWatchAlarmTemplateInput {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *CreateCloudWatchAlarmTemplateInput) SetTreatMissingData(v string) *CreateCloudWatchAlarmTemplateInput {
	s.TreatMissingData = &v
	return s
}

type CreateCloudWatchAlarmTemplateOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// The comparison operator used to compare the specified statistic and the threshold.
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" enum:"CloudWatchAlarmTemplateComparisonOperator"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" min:"1" type:"integer"`

	Description *string `locationName:"description" type:"string"`

	EvaluationPeriods *int64 `locationName:"evaluationPeriods" min:"1" type:"integer"`

	GroupId *string `locationName:"groupId" min:"7" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	MetricName *string `locationName:"metricName" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	Period *int64 `locationName:"period" min:"10" type:"integer"`

	// The statistic to apply to the alarm's metric data.
	Statistic *string `locationName:"statistic" type:"string" enum:"CloudWatchAlarmTemplateStatistic"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The resource type this template should dynamically generate cloudwatch metric
	// alarms for.
	TargetResourceType *string `locationName:"targetResourceType" type:"string" enum:"CloudWatchAlarmTemplateTargetResourceType"`

	Threshold *float64 `locationName:"threshold" type:"double"`

	// Specifies how missing data points are treated when evaluating the alarm's
	// condition.
	TreatMissingData *string `locationName:"treatMissingData" type:"string" enum:"CloudWatchAlarmTemplateTreatMissingData"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCloudWatchAlarmTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetArn(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.Arn = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetComparisonOperator(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.ComparisonOperator = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetCreatedAt(v time.Time) *CreateCloudWatchAlarmTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetDatapointsToAlarm(v int64) *CreateCloudWatchAlarmTemplateOutput {
	s.DatapointsToAlarm = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetDescription(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.Description = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetEvaluationPeriods(v int64) *CreateCloudWatchAlarmTemplateOutput {
	s.EvaluationPeriods = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetGroupId(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetId(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.Id = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetMetricName(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.MetricName = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetModifiedAt(v time.Time) *CreateCloudWatchAlarmTemplateOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetName(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetPeriod(v int64) *CreateCloudWatchAlarmTemplateOutput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetStatistic(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetTags(v map[string]*string) *CreateCloudWatchAlarmTemplateOutput {
	s.Tags = v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetTargetResourceType(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.TargetResourceType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetThreshold(v float64) *CreateCloudWatchAlarmTemplateOutput {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *CreateCloudWatchAlarmTemplateOutput) SetTreatMissingData(v string) *CreateCloudWatchAlarmTemplateOutput {
	s.TreatMissingData = &v
	return s
}

type CreateEventBridgeRuleTemplateGroupInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventBridgeRuleTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventBridgeRuleTemplateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEventBridgeRuleTemplateGroupInput) SetDescription(v string) *CreateEventBridgeRuleTemplateGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventBridgeRuleTemplateGroupInput) SetName(v string) *CreateEventBridgeRuleTemplateGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventBridgeRuleTemplateGroupInput) SetTags(v map[string]*string) *CreateEventBridgeRuleTemplateGroupInput {
	s.Tags = v
	return s
}

type CreateEventBridgeRuleTemplateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetArn(v string) *CreateEventBridgeRuleTemplateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetCreatedAt(v time.Time) *CreateEventBridgeRuleTemplateGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetDescription(v string) *CreateEventBridgeRuleTemplateGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetId(v string) *CreateEventBridgeRuleTemplateGroupOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetModifiedAt(v time.Time) *CreateEventBridgeRuleTemplateGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetName(v string) *CreateEventBridgeRuleTemplateGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventBridgeRuleTemplateGroupOutput) SetTags(v map[string]*string) *CreateEventBridgeRuleTemplateGroupOutput {
	s.Tags = v
	return s
}

type CreateEventBridgeRuleTemplateInput struct {
	_ struct{} `type:"structure"`

	Description *string `locationName:"description" type:"string"`

	EventTargets []*EventBridgeRuleTemplateTarget `locationName:"eventTargets" type:"list"`

	// The type of event to match with the rule.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventBridgeRuleTemplateEventType"`

	// GroupIdentifier is a required field
	GroupIdentifier *string `locationName:"groupIdentifier" type:"string" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventBridgeRuleTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventBridgeRuleTemplateInput"}
	if s.EventType == nil {
		invalidParams.Add(request.NewErrParamRequired("EventType"))
	}
	if s.GroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIdentifier"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.EventTargets != nil {
		for i, v := range s.EventTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EventTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetDescription(v string) *CreateEventBridgeRuleTemplateInput {
	s.Description = &v
	return s
}

// SetEventTargets sets the EventTargets field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetEventTargets(v []*EventBridgeRuleTemplateTarget) *CreateEventBridgeRuleTemplateInput {
	s.EventTargets = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetEventType(v string) *CreateEventBridgeRuleTemplateInput {
	s.EventType = &v
	return s
}

// SetGroupIdentifier sets the GroupIdentifier field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetGroupIdentifier(v string) *CreateEventBridgeRuleTemplateInput {
	s.GroupIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetName(v string) *CreateEventBridgeRuleTemplateInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventBridgeRuleTemplateInput) SetTags(v map[string]*string) *CreateEventBridgeRuleTemplateInput {
	s.Tags = v
	return s
}

type CreateEventBridgeRuleTemplateOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	EventTargets []*EventBridgeRuleTemplateTarget `locationName:"eventTargets" type:"list"`

	// The type of event to match with the rule.
	EventType *string `locationName:"eventType" type:"string" enum:"EventBridgeRuleTemplateEventType"`

	GroupId *string `locationName:"groupId" min:"7" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventBridgeRuleTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetArn(v string) *CreateEventBridgeRuleTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetCreatedAt(v time.Time) *CreateEventBridgeRuleTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetDescription(v string) *CreateEventBridgeRuleTemplateOutput {
	s.Description = &v
	return s
}

// SetEventTargets sets the EventTargets field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetEventTargets(v []*EventBridgeRuleTemplateTarget) *CreateEventBridgeRuleTemplateOutput {
	s.EventTargets = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetEventType(v string) *CreateEventBridgeRuleTemplateOutput {
	s.EventType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetGroupId(v string) *CreateEventBridgeRuleTemplateOutput {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetId(v string) *CreateEventBridgeRuleTemplateOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetModifiedAt(v time.Time) *CreateEventBridgeRuleTemplateOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetName(v string) *CreateEventBridgeRuleTemplateOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventBridgeRuleTemplateOutput) SetTags(v map[string]*string) *CreateEventBridgeRuleTemplateOutput {
	s.Tags = v
	return s
}

type CreateInputInput struct {
	_ struct{} `type:"structure"`

	Destinations []*InputDestinationRequest `locationName:"destinations" type:"list"`

	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	InputSecurityGroups []*string `locationName:"inputSecurityGroups" type:"list"`

	MediaConnectFlows []*MediaConnectFlowRequest `locationName:"mediaConnectFlows" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	Sources []*InputSourceRequest `locationName:"sources" type:"list"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The different types of inputs that AWS Elemental MediaLive supports.
	Type *string `locationName:"type" type:"string" enum:"InputType"`

	// Settings for a private VPC Input.When this property is specified, the input
	// destination addresses will be created in a VPC rather than with public Internet
	// addresses.This property requires setting the roleArn property on Input creation.Not
	// compatible with the inputSecurityGroups property.
	Vpc *InputVpcRequest `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInputInput"}
	if s.Vpc != nil {
		if err := s.Vpc.Validate(); err != nil {
			invalidParams.AddNested("Vpc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateInputInput) SetDestinations(v []*InputDestinationRequest) *CreateInputInput {
	s.Destinations = v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *CreateInputInput) SetInputDevices(v []*InputDeviceSettings) *CreateInputInput {
	s.InputDevices = v
	return s
}

// SetInputSecurityGroups sets the InputSecurityGroups field's value.
func (s *CreateInputInput) SetInputSecurityGroups(v []*string) *CreateInputInput {
	s.InputSecurityGroups = v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *CreateInputInput) SetMediaConnectFlows(v []*MediaConnectFlowRequest) *CreateInputInput {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInputInput) SetName(v string) *CreateInputInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateInputInput) SetRequestId(v string) *CreateInputInput {
	s.RequestId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateInputInput) SetRoleArn(v string) *CreateInputInput {
	s.RoleArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateInputInput) SetSources(v []*InputSourceRequest) *CreateInputInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInputInput) SetTags(v map[string]*string) *CreateInputInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateInputInput) SetType(v string) *CreateInputInput {
	s.Type = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *CreateInputInput) SetVpc(v *InputVpcRequest) *CreateInputInput {
	s.Vpc = v
	return s
}

type CreateInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *CreateInputOutput) SetInput(v *Input) *CreateInputOutput {
	s.Input = v
	return s
}

type CreateInputSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	WhitelistRules []*InputWhitelistRuleCidr `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputSecurityGroupInput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *CreateInputSecurityGroupInput) SetTags(v map[string]*string) *CreateInputSecurityGroupInput {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *CreateInputSecurityGroupInput) SetWhitelistRules(v []*InputWhitelistRuleCidr) *CreateInputSecurityGroupInput {
	s.WhitelistRules = v
	return s
}

type CreateInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// An Input Security Group
	SecurityGroup *InputSecurityGroup `locationName:"securityGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *CreateInputSecurityGroupOutput) SetSecurityGroup(v *InputSecurityGroup) *CreateInputSecurityGroupOutput {
	s.SecurityGroup = v
	return s
}

type CreateMultiplexInput struct {
	_ struct{} `type:"structure"`

	// AvailabilityZones is a required field
	AvailabilityZones []*string `locationName:"availabilityZones" type:"list" required:"true"`

	// Contains configuration for a Multiplex event
	//
	// MultiplexSettings is a required field
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure" required:"true"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiplexInput"}
	if s.AvailabilityZones == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZones"))
	}
	if s.MultiplexSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexSettings"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.MultiplexSettings != nil {
		if err := s.MultiplexSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateMultiplexInput) SetAvailabilityZones(v []*string) *CreateMultiplexInput {
	s.AvailabilityZones = v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *CreateMultiplexInput) SetMultiplexSettings(v *MultiplexSettings) *CreateMultiplexInput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMultiplexInput) SetName(v string) *CreateMultiplexInput {
	s.Name = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateMultiplexInput) SetRequestId(v string) *CreateMultiplexInput {
	s.RequestId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMultiplexInput) SetTags(v map[string]*string) *CreateMultiplexInput {
	s.Tags = v
	return s
}

type CreateMultiplexOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex object.
	Multiplex *Multiplex `locationName:"multiplex" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexOutput) GoString() string {
	return s.String()
}

// SetMultiplex sets the Multiplex field's value.
func (s *CreateMultiplexOutput) SetMultiplex(v *Multiplex) *CreateMultiplexOutput {
	s.Multiplex = v
	return s
}

type CreateMultiplexProgramInput struct {
	_ struct{} `type:"structure"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// Multiplex Program settings configuration.
	//
	// MultiplexProgramSettings is a required field
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure" required:"true"`

	// ProgramName is a required field
	ProgramName *string `locationName:"programName" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.MultiplexProgramSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexProgramSettings"))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.MultiplexProgramSettings != nil {
		if err := s.MultiplexProgramSettings.Validate(); err != nil {
			invalidParams.AddNested("MultiplexProgramSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *CreateMultiplexProgramInput) SetMultiplexId(v string) *CreateMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *CreateMultiplexProgramInput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *CreateMultiplexProgramInput {
	s.MultiplexProgramSettings = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *CreateMultiplexProgramInput) SetProgramName(v string) *CreateMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateMultiplexProgramInput) SetRequestId(v string) *CreateMultiplexProgramInput {
	s.RequestId = &v
	return s
}

type CreateMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	// The multiplex program object.
	MultiplexProgram *MultiplexProgram `locationName:"multiplexProgram" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetMultiplexProgram sets the MultiplexProgram field's value.
func (s *CreateMultiplexProgramOutput) SetMultiplexProgram(v *MultiplexProgram) *CreateMultiplexProgramOutput {
	s.MultiplexProgram = v
	return s
}

type CreatePartnerInputInput struct {
	_ struct{} `type:"structure"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`

	RequestId *string `locationName:"requestId" type:"string" idempotencyToken:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartnerInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartnerInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *CreatePartnerInputInput) SetInputId(v string) *CreatePartnerInputInput {
	s.InputId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreatePartnerInputInput) SetRequestId(v string) *CreatePartnerInputInput {
	s.RequestId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePartnerInputInput) SetTags(v map[string]*string) *CreatePartnerInputInput {
	s.Tags = v
	return s
}

type CreatePartnerInputOutput struct {
	_ struct{} `type:"structure"`

	Input *Input `locationName:"input" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePartnerInputOutput) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *CreatePartnerInputOutput) SetInput(v *Input) *CreatePartnerInputOutput {
	s.Input = v
	return s
}

type CreateSignalMapInput struct {
	_ struct{} `type:"structure"`

	CloudWatchAlarmTemplateGroupIdentifiers []*string `locationName:"cloudWatchAlarmTemplateGroupIdentifiers" type:"list"`

	Description *string `locationName:"description" type:"string"`

	// DiscoveryEntryPointArn is a required field
	DiscoveryEntryPointArn *string `locationName:"discoveryEntryPointArn" min:"1" type:"string" required:"true"`

	EventBridgeRuleTemplateGroupIdentifiers []*string `locationName:"eventBridgeRuleTemplateGroupIdentifiers" type:"list"`

	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSignalMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSignalMapInput"}
	if s.DiscoveryEntryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DiscoveryEntryPointArn"))
	}
	if s.DiscoveryEntryPointArn != nil && len(*s.DiscoveryEntryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiscoveryEntryPointArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchAlarmTemplateGroupIdentifiers sets the CloudWatchAlarmTemplateGroupIdentifiers field's value.
func (s *CreateSignalMapInput) SetCloudWatchAlarmTemplateGroupIdentifiers(v []*string) *CreateSignalMapInput {
	s.CloudWatchAlarmTemplateGroupIdentifiers = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSignalMapInput) SetDescription(v string) *CreateSignalMapInput {
	s.Description = &v
	return s
}

// SetDiscoveryEntryPointArn sets the DiscoveryEntryPointArn field's value.
func (s *CreateSignalMapInput) SetDiscoveryEntryPointArn(v string) *CreateSignalMapInput {
	s.DiscoveryEntryPointArn = &v
	return s
}

// SetEventBridgeRuleTemplateGroupIdentifiers sets the EventBridgeRuleTemplateGroupIdentifiers field's value.
func (s *CreateSignalMapInput) SetEventBridgeRuleTemplateGroupIdentifiers(v []*string) *CreateSignalMapInput {
	s.EventBridgeRuleTemplateGroupIdentifiers = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSignalMapInput) SetName(v string) *CreateSignalMapInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSignalMapInput) SetTags(v map[string]*string) *CreateSignalMapInput {
	s.Tags = v
	return s
}

type CreateSignalMapOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CloudWatchAlarmTemplateGroupIds []*string `locationName:"cloudWatchAlarmTemplateGroupIds" type:"list"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	DiscoveryEntryPointArn *string `locationName:"discoveryEntryPointArn" min:"1" type:"string"`

	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	EventBridgeRuleTemplateGroupIds []*string `locationName:"eventBridgeRuleTemplateGroupIds" type:"list"`

	// A map representing an incomplete AWS media workflow as a graph.
	FailedMediaResourceMap map[string]*MediaResource `locationName:"failedMediaResourceMap" type:"map"`

	Id *string `locationName:"id" min:"7" type:"string"`

	LastDiscoveredAt *time.Time `locationName:"lastDiscoveredAt" type:"timestamp" timestampFormat:"iso8601"`

	// Represents the latest successful monitor deployment of a signal map.
	LastSuccessfulMonitorDeployment *SuccessfulMonitorDeployment `locationName:"lastSuccessfulMonitorDeployment" type:"structure"`

	// A map representing an AWS media workflow as a graph.
	MediaResourceMap map[string]*MediaResource `locationName:"mediaResourceMap" type:"map"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	MonitorChangesPendingDeployment *bool `locationName:"monitorChangesPendingDeployment" type:"boolean"`

	// Represents the latest monitor deployment of a signal map.
	MonitorDeployment *MonitorDeployment `locationName:"monitorDeployment" type:"structure"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// A signal map's current status which is dependent on its lifecycle actions
	// or associated jobs.
	Status *string `locationName:"status" type:"string" enum:"SignalMapStatus"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSignalMapOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSignalMapOutput) SetArn(v string) *CreateSignalMapOutput {
	s.Arn = &v
	return s
}

// SetCloudWatchAlarmTemplateGroupIds sets the CloudWatchAlarmTemplateGroupIds field's value.
func (s *CreateSignalMapOutput) SetCloudWatchAlarmTemplateGroupIds(v []*string) *CreateSignalMapOutput {
	s.CloudWatchAlarmTemplateGroupIds = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSignalMapOutput) SetCreatedAt(v time.Time) *CreateSignalMapOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSignalMapOutput) SetDescription(v string) *CreateSignalMapOutput {
	s.Description = &v
	return s
}

// SetDiscoveryEntryPointArn sets the DiscoveryEntryPointArn field's value.
func (s *CreateSignalMapOutput) SetDiscoveryEntryPointArn(v string) *CreateSignalMapOutput {
	s.DiscoveryEntryPointArn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateSignalMapOutput) SetErrorMessage(v string) *CreateSignalMapOutput {
	s.ErrorMessage = &v
	return s
}

// SetEventBridgeRuleTemplateGroupIds sets the EventBridgeRuleTemplateGroupIds field's value.
func (s *CreateSignalMapOutput) SetEventBridgeRuleTemplateGroupIds(v []*string) *CreateSignalMapOutput {
	s.EventBridgeRuleTemplateGroupIds = v
	return s
}

// SetFailedMediaResourceMap sets the FailedMediaResourceMap field's value.
func (s *CreateSignalMapOutput) SetFailedMediaResourceMap(v map[string]*MediaResource) *CreateSignalMapOutput {
	s.FailedMediaResourceMap = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateSignalMapOutput) SetId(v string) *CreateSignalMapOutput {
	s.Id = &v
	return s
}

// SetLastDiscoveredAt sets the LastDiscoveredAt field's value.
func (s *CreateSignalMapOutput) SetLastDiscoveredAt(v time.Time) *CreateSignalMapOutput {
	s.LastDiscoveredAt = &v
	return s
}

// SetLastSuccessfulMonitorDeployment sets the LastSuccessfulMonitorDeployment field's value.
func (s *CreateSignalMapOutput) SetLastSuccessfulMonitorDeployment(v *SuccessfulMonitorDeployment) *CreateSignalMapOutput {
	s.LastSuccessfulMonitorDeployment = v
	return s
}

// SetMediaResourceMap sets the MediaResourceMap field's value.
func (s *CreateSignalMapOutput) SetMediaResourceMap(v map[string]*MediaResource) *CreateSignalMapOutput {
	s.MediaResourceMap = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateSignalMapOutput) SetModifiedAt(v time.Time) *CreateSignalMapOutput {
	s.ModifiedAt = &v
	return s
}

// SetMonitorChangesPendingDeployment sets the MonitorChangesPendingDeployment field's value.
func (s *CreateSignalMapOutput) SetMonitorChangesPendingDeployment(v bool) *CreateSignalMapOutput {
	s.MonitorChangesPendingDeployment = &v
	return s
}

// SetMonitorDeployment sets the MonitorDeployment field's value.
func (s *CreateSignalMapOutput) SetMonitorDeployment(v *MonitorDeployment) *CreateSignalMapOutput {
	s.MonitorDeployment = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSignalMapOutput) SetName(v string) *CreateSignalMapOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateSignalMapOutput) SetStatus(v string) *CreateSignalMapOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSignalMapOutput) SetTags(v map[string]*string) *CreateSignalMapOutput {
	s.Tags = v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateTagsInput) SetResourceArn(v string) *CreateTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v map[string]*string) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteChannelInput) SetChannelId(v string) *DeleteChannelInput {
	s.ChannelId = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CdiInputSpecification *CdiInputSpecification `locationName:"cdiInputSpecification" type:"structure"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Maintenance *MaintenanceStatus `locationName:"maintenance" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The properties for a private VPC Output
	Vpc *VpcOutputSettingsDescription `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteChannelOutput) SetArn(v string) *DeleteChannelOutput {
	s.Arn = &v
	return s
}

// SetCdiInputSpecification sets the CdiInputSpecification field's value.
func (s *DeleteChannelOutput) SetCdiInputSpecification(v *CdiInputSpecification) *DeleteChannelOutput {
	s.CdiInputSpecification = v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *DeleteChannelOutput) SetChannelClass(v string) *DeleteChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeleteChannelOutput) SetDestinations(v []*OutputDestination) *DeleteChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DeleteChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DeleteChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DeleteChannelOutput) SetEncoderSettings(v *EncoderSettings) *DeleteChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteChannelOutput) SetId(v string) *DeleteChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DeleteChannelOutput) SetInputAttachments(v []*InputAttachment) *DeleteChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DeleteChannelOutput) SetInputSpecification(v *InputSpecification) *DeleteChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *DeleteChannelOutput) SetLogLevel(v string) *DeleteChannelOutput {
	s.LogLevel = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *DeleteChannelOutput) SetMaintenance(v *MaintenanceStatus) *DeleteChannelOutput {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteChannelOutput) SetName(v string) *DeleteChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DeleteChannelOutput) SetPipelineDetails(v []*PipelineDetail) *DeleteChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DeleteChannelOutput) SetPipelinesRunningCount(v int64) *DeleteChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DeleteChannelOutput) SetRoleArn(v string) *DeleteChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteChannelOutput) SetState(v string) *DeleteChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteChannelOutput) SetTags(v map[string]*string) *DeleteChannelOutput {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *DeleteChannelOutput) SetVpc(v *VpcOutputSettingsDescription) *DeleteChannelOutput {
	s.Vpc = v
	return s
}

type DeleteCloudWatchAlarmTemplateGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCloudWatchAlarmTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCloudWatchAlarmTemplateGroupInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteCloudWatchAlarmTemplateGroupInput) SetIdentifier(v string) *DeleteCloudWatchAlarmTemplateGroupInput {
	s.Identifier = &v
	return s
}

type DeleteCloudWatchAlarmTemplateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateGroupOutput) GoString() string {
	return s.String()
}

type DeleteCloudWatchAlarmTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCloudWatchAlarmTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCloudWatchAlarmTemplateInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteCloudWatchAlarmTemplateInput) SetIdentifier(v string) *DeleteCloudWatchAlarmTemplateInput {
	s.Identifier = &v
	return s
}

type DeleteCloudWatchAlarmTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCloudWatchAlarmTemplateOutput) GoString() string {
	return s.String()
}

type DeleteEventBridgeRuleTemplateGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventBridgeRuleTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventBridgeRuleTemplateGroupInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteEventBridgeRuleTemplateGroupInput) SetIdentifier(v string) *DeleteEventBridgeRuleTemplateGroupInput {
	s.Identifier = &v
	return s
}

type DeleteEventBridgeRuleTemplateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateGroupOutput) GoString() string {
	return s.String()
}

type DeleteEventBridgeRuleTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventBridgeRuleTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventBridgeRuleTemplateInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteEventBridgeRuleTemplateInput) SetIdentifier(v string) *DeleteEventBridgeRuleTemplateInput {
	s.Identifier = &v
	return s
}

type DeleteEventBridgeRuleTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventBridgeRuleTemplateOutput) GoString() string {
	return s.String()
}

type DeleteInputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DeleteInputInput) SetInputId(v string) *DeleteInputInput {
	s.InputId = &v
	return s
}

type DeleteInputOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputOutput) GoString() string {
	return s.String()
}

type DeleteInputSecurityGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}
	if s.InputSecurityGroupId != nil && len(*s.InputSecurityGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSecurityGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DeleteInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DeleteInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DeleteInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInputSecurityGroupOutput) GoString() string {
	return s.String()
}

type DeleteMultiplexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DeleteMultiplexInput) SetMultiplexId(v string) *DeleteMultiplexInput {
	s.MultiplexId = &v
	return s
}

type DeleteMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteMultiplexOutput) SetArn(v string) *DeleteMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DeleteMultiplexOutput) SetAvailabilityZones(v []*string) *DeleteMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeleteMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *DeleteMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteMultiplexOutput) SetId(v string) *DeleteMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *DeleteMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *DeleteMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteMultiplexOutput) SetName(v string) *DeleteMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DeleteMultiplexOutput) SetPipelinesRunningCount(v int64) *DeleteMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *DeleteMultiplexOutput) SetProgramCount(v int64) *DeleteMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteMultiplexOutput) SetState(v string) *DeleteMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteMultiplexOutput) SetTags(v map[string]*string) *DeleteMultiplexOutput {
	s.Tags = v
	return s
}

type DeleteMultiplexProgramInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DeleteMultiplexProgramInput) SetMultiplexId(v string) *DeleteMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DeleteMultiplexProgramInput) SetProgramName(v string) *DeleteMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

type DeleteMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// Packet identifiers map for a given Multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	PipelineDetails []*MultiplexProgramPipelineDetail `locationName:"pipelineDetails" type:"list"`

	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteMultiplexProgramOutput) SetChannelId(v string) *DeleteMultiplexProgramOutput {
	s.ChannelId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *DeleteMultiplexProgramOutput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *DeleteMultiplexProgramOutput {
	s.MultiplexProgramSettings = v
	return s
}

// SetPacketIdentifiersMap sets the PacketIdentifiersMap field's value.
func (s *DeleteMultiplexProgramOutput) SetPacketIdentifiersMap(v *MultiplexProgramPacketIdentifiersMap) *DeleteMultiplexProgramOutput {
	s.PacketIdentifiersMap = v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DeleteMultiplexProgramOutput) SetPipelineDetails(v []*MultiplexProgramPipelineDetail) *DeleteMultiplexProgramOutput {
	s.PipelineDetails = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DeleteMultiplexProgramOutput) SetProgramName(v string) *DeleteMultiplexProgramOutput {
	s.ProgramName = &v
	return s
}

type DeleteReservationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ReservationId is a required field
	ReservationId *string `location:"uri" locationName:"reservationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReservationInput"}
	if s.ReservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationId"))
	}
	if s.ReservationId != nil && len(*s.ReservationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservationId sets the ReservationId field's value.
func (s *DeleteReservationInput) SetReservationId(v string) *DeleteReservationInput {
	s.ReservationId = &v
	return s
}

type DeleteReservationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"integer"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	End *string `locationName:"end" type:"string"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	Name *string `locationName:"name" type:"string"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	// The Renewal settings for Reservations
	RenewalSettings *RenewalSettings `locationName:"renewalSettings" type:"structure"`

	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	Start *string `locationName:"start" type:"string"`

	// Current reservation state
	State *string `locationName:"state" type:"string" enum:"ReservationState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReservationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteReservationOutput) SetArn(v string) *DeleteReservationOutput {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *DeleteReservationOutput) SetCount(v int64) *DeleteReservationOutput {
	s.Count = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DeleteReservationOutput) SetCurrencyCode(v string) *DeleteReservationOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DeleteReservationOutput) SetDuration(v int64) *DeleteReservationOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DeleteReservationOutput) SetDurationUnits(v string) *DeleteReservationOutput {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *DeleteReservationOutput) SetEnd(v string) *DeleteReservationOutput {
	s.End = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DeleteReservationOutput) SetFixedPrice(v float64) *DeleteReservationOutput {
	s.FixedPrice = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteReservationOutput) SetName(v string) *DeleteReservationOutput {
	s.Name = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DeleteReservationOutput) SetOfferingDescription(v string) *DeleteReservationOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DeleteReservationOutput) SetOfferingId(v string) *DeleteReservationOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DeleteReservationOutput) SetOfferingType(v string) *DeleteReservationOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DeleteReservationOutput) SetRegion(v string) *DeleteReservationOutput {
	s.Region = &v
	return s
}

// SetRenewalSettings sets the RenewalSettings field's value.
func (s *DeleteReservationOutput) SetRenewalSettings(v *RenewalSettings) *DeleteReservationOutput {
	s.RenewalSettings = v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *DeleteReservationOutput) SetReservationId(v string) *DeleteReservationOutput {
	s.ReservationId = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DeleteReservationOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DeleteReservationOutput {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *DeleteReservationOutput) SetStart(v string) *DeleteReservationOutput {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *DeleteReservationOutput) SetState(v string) *DeleteReservationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DeleteReservationOutput) SetTags(v map[string]*string) *DeleteReservationOutput {
	s.Tags = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DeleteReservationOutput) SetUsagePrice(v float64) *DeleteReservationOutput {
	s.UsagePrice = &v
	return s
}

type DeleteScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DeleteScheduleInput) SetChannelId(v string) *DeleteScheduleInput {
	s.ChannelId = &v
	return s
}

type DeleteScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduleOutput) GoString() string {
	return s.String()
}

type DeleteSignalMapInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSignalMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSignalMapInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteSignalMapInput) SetIdentifier(v string) *DeleteSignalMapInput {
	s.Identifier = &v
	return s
}

type DeleteSignalMapOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSignalMapOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource-arn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteTagsInput) SetResourceArn(v string) *DeleteTagsInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAccountConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountConfigurationInput) GoString() string {
	return s.String()
}

type DescribeAccountConfigurationOutput struct {
	_ struct{} `type:"structure"`

	AccountConfiguration *AccountConfiguration `locationName:"accountConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountConfigurationOutput) GoString() string {
	return s.String()
}

// SetAccountConfiguration sets the AccountConfiguration field's value.
func (s *DescribeAccountConfigurationOutput) SetAccountConfiguration(v *AccountConfiguration) *DescribeAccountConfigurationOutput {
	s.AccountConfiguration = v
	return s
}

type DescribeChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChannelInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeChannelInput) SetChannelId(v string) *DescribeChannelInput {
	s.ChannelId = &v
	return s
}

type DescribeChannelOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CdiInputSpecification *CdiInputSpecification `locationName:"cdiInputSpecification" type:"structure"`

	// A standard channel has two encoding pipelines and a single pipeline channel
	// only has one.
	ChannelClass *string `locationName:"channelClass" type:"string" enum:"ChannelClass"`

	Destinations []*OutputDestination `locationName:"destinations" type:"list"`

	EgressEndpoints []*ChannelEgressEndpoint `locationName:"egressEndpoints" type:"list"`

	// Encoder Settings
	EncoderSettings *EncoderSettings `locationName:"encoderSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	InputAttachments []*InputAttachment `locationName:"inputAttachments" type:"list"`

	InputSpecification *InputSpecification `locationName:"inputSpecification" type:"structure"`

	// The log level the user wants for their channel.
	LogLevel *string `locationName:"logLevel" type:"string" enum:"LogLevel"`

	Maintenance *MaintenanceStatus `locationName:"maintenance" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelineDetails []*PipelineDetail `locationName:"pipelineDetails" type:"list"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	State *string `locationName:"state" type:"string" enum:"ChannelState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The properties for a private VPC Output
	Vpc *VpcOutputSettingsDescription `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeChannelOutput) SetArn(v string) *DescribeChannelOutput {
	s.Arn = &v
	return s
}

// SetCdiInputSpecification sets the CdiInputSpecification field's value.
func (s *DescribeChannelOutput) SetCdiInputSpecification(v *CdiInputSpecification) *DescribeChannelOutput {
	s.CdiInputSpecification = v
	return s
}

// SetChannelClass sets the ChannelClass field's value.
func (s *DescribeChannelOutput) SetChannelClass(v string) *DescribeChannelOutput {
	s.ChannelClass = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeChannelOutput) SetDestinations(v []*OutputDestination) *DescribeChannelOutput {
	s.Destinations = v
	return s
}

// SetEgressEndpoints sets the EgressEndpoints field's value.
func (s *DescribeChannelOutput) SetEgressEndpoints(v []*ChannelEgressEndpoint) *DescribeChannelOutput {
	s.EgressEndpoints = v
	return s
}

// SetEncoderSettings sets the EncoderSettings field's value.
func (s *DescribeChannelOutput) SetEncoderSettings(v *EncoderSettings) *DescribeChannelOutput {
	s.EncoderSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeChannelOutput) SetId(v string) *DescribeChannelOutput {
	s.Id = &v
	return s
}

// SetInputAttachments sets the InputAttachments field's value.
func (s *DescribeChannelOutput) SetInputAttachments(v []*InputAttachment) *DescribeChannelOutput {
	s.InputAttachments = v
	return s
}

// SetInputSpecification sets the InputSpecification field's value.
func (s *DescribeChannelOutput) SetInputSpecification(v *InputSpecification) *DescribeChannelOutput {
	s.InputSpecification = v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *DescribeChannelOutput) SetLogLevel(v string) *DescribeChannelOutput {
	s.LogLevel = &v
	return s
}

// SetMaintenance sets the Maintenance field's value.
func (s *DescribeChannelOutput) SetMaintenance(v *MaintenanceStatus) *DescribeChannelOutput {
	s.Maintenance = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeChannelOutput) SetName(v string) *DescribeChannelOutput {
	s.Name = &v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DescribeChannelOutput) SetPipelineDetails(v []*PipelineDetail) *DescribeChannelOutput {
	s.PipelineDetails = v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DescribeChannelOutput) SetPipelinesRunningCount(v int64) *DescribeChannelOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeChannelOutput) SetRoleArn(v string) *DescribeChannelOutput {
	s.RoleArn = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeChannelOutput) SetState(v string) *DescribeChannelOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeChannelOutput) SetTags(v map[string]*string) *DescribeChannelOutput {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *DescribeChannelOutput) SetVpc(v *VpcOutputSettingsDescription) *DescribeChannelOutput {
	s.Vpc = v
	return s
}

type DescribeInputDeviceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputDeviceInput"}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *DescribeInputDeviceInput) SetInputDeviceId(v string) *DescribeInputDeviceInput {
	s.InputDeviceId = &v
	return s
}

type DescribeInputDeviceOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The state of the connection between the input device and AWS.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"InputDeviceConnectionState"`

	// The status of the action to synchronize the device configuration. If you
	// change the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState *string `locationName:"deviceSettingsSyncState" type:"string" enum:"DeviceSettingsSyncState"`

	// The status of software on the input device.
	DeviceUpdateStatus *string `locationName:"deviceUpdateStatus" type:"string" enum:"DeviceUpdateStatus"`

	// Settings that describe the active source from the input device, and the video
	// characteristics of that source.
	HdDeviceSettings *InputDeviceHdSettings `locationName:"hdDeviceSettings" type:"structure"`

	Id *string `locationName:"id" type:"string"`

	MacAddress *string `locationName:"macAddress" type:"string"`

	MedialiveInputArns []*string `locationName:"medialiveInputArns" type:"list"`

	Name *string `locationName:"name" type:"string"`

	// The network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings `locationName:"networkSettings" type:"structure"`

	// The output attachment type of the input device.
	OutputType *string `locationName:"outputType" type:"string" enum:"InputDeviceOutputType"`

	SerialNumber *string `locationName:"serialNumber" type:"string"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the input device. For an AWS Elemental Link device that outputs
	// resolutions up to 1080, choose "HD".
	Type *string `locationName:"type" type:"string" enum:"InputDeviceType"`

	// Settings that describe the active source from the input device, and the video
	// characteristics of that source.
	UhdDeviceSettings *InputDeviceUhdSettings `locationName:"uhdDeviceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputDeviceOutput) SetArn(v string) *DescribeInputDeviceOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DescribeInputDeviceOutput) SetAvailabilityZone(v string) *DescribeInputDeviceOutput {
	s.AvailabilityZone = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *DescribeInputDeviceOutput) SetConnectionState(v string) *DescribeInputDeviceOutput {
	s.ConnectionState = &v
	return s
}

// SetDeviceSettingsSyncState sets the DeviceSettingsSyncState field's value.
func (s *DescribeInputDeviceOutput) SetDeviceSettingsSyncState(v string) *DescribeInputDeviceOutput {
	s.DeviceSettingsSyncState = &v
	return s
}

// SetDeviceUpdateStatus sets the DeviceUpdateStatus field's value.
func (s *DescribeInputDeviceOutput) SetDeviceUpdateStatus(v string) *DescribeInputDeviceOutput {
	s.DeviceUpdateStatus = &v
	return s
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *DescribeInputDeviceOutput) SetHdDeviceSettings(v *InputDeviceHdSettings) *DescribeInputDeviceOutput {
	s.HdDeviceSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputDeviceOutput) SetId(v string) *DescribeInputDeviceOutput {
	s.Id = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *DescribeInputDeviceOutput) SetMacAddress(v string) *DescribeInputDeviceOutput {
	s.MacAddress = &v
	return s
}

// SetMedialiveInputArns sets the MedialiveInputArns field's value.
func (s *DescribeInputDeviceOutput) SetMedialiveInputArns(v []*string) *DescribeInputDeviceOutput {
	s.MedialiveInputArns = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInputDeviceOutput) SetName(v string) *DescribeInputDeviceOutput {
	s.Name = &v
	return s
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *DescribeInputDeviceOutput) SetNetworkSettings(v *InputDeviceNetworkSettings) *DescribeInputDeviceOutput {
	s.NetworkSettings = v
	return s
}

// SetOutputType sets the OutputType field's value.
func (s *DescribeInputDeviceOutput) SetOutputType(v string) *DescribeInputDeviceOutput {
	s.OutputType = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DescribeInputDeviceOutput) SetSerialNumber(v string) *DescribeInputDeviceOutput {
	s.SerialNumber = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeInputDeviceOutput) SetTags(v map[string]*string) *DescribeInputDeviceOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeInputDeviceOutput) SetType(v string) *DescribeInputDeviceOutput {
	s.Type = &v
	return s
}

// SetUhdDeviceSettings sets the UhdDeviceSettings field's value.
func (s *DescribeInputDeviceOutput) SetUhdDeviceSettings(v *InputDeviceUhdSettings) *DescribeInputDeviceOutput {
	s.UhdDeviceSettings = v
	return s
}

type DescribeInputDeviceThumbnailInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Accept is a required field
	Accept *string `location:"header" locationName:"accept" type:"string" required:"true" enum:"AcceptHeader"`

	// InputDeviceId is a required field
	InputDeviceId *string `location:"uri" locationName:"inputDeviceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceThumbnailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceThumbnailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputDeviceThumbnailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputDeviceThumbnailInput"}
	if s.Accept == nil {
		invalidParams.Add(request.NewErrParamRequired("Accept"))
	}
	if s.InputDeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDeviceId"))
	}
	if s.InputDeviceId != nil && len(*s.InputDeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputDeviceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccept sets the Accept field's value.
func (s *DescribeInputDeviceThumbnailInput) SetAccept(v string) *DescribeInputDeviceThumbnailInput {
	s.Accept = &v
	return s
}

// SetInputDeviceId sets the InputDeviceId field's value.
func (s *DescribeInputDeviceThumbnailInput) SetInputDeviceId(v string) *DescribeInputDeviceThumbnailInput {
	s.InputDeviceId = &v
	return s
}

type DescribeInputDeviceThumbnailOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadCloser `locationName:"body" type:"blob"`

	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	ContentType *string `location:"header" locationName:"Content-Type" type:"string" enum:"ContentType"`

	ETag *string `location:"header" locationName:"ETag" type:"string"`

	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceThumbnailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputDeviceThumbnailOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetBody(v io.ReadCloser) *DescribeInputDeviceThumbnailOutput {
	s.Body = v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetContentLength(v int64) *DescribeInputDeviceThumbnailOutput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetContentType(v string) *DescribeInputDeviceThumbnailOutput {
	s.ContentType = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetETag(v string) *DescribeInputDeviceThumbnailOutput {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DescribeInputDeviceThumbnailOutput) SetLastModified(v time.Time) *DescribeInputDeviceThumbnailOutput {
	s.LastModified = &v
	return s
}

type DescribeInputInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputId is a required field
	InputId *string `location:"uri" locationName:"inputId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputInput"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *DescribeInputInput) SetInputId(v string) *DescribeInputInput {
	s.InputId = &v
	return s
}

type DescribeInputOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// A standard input has two sources and a single pipeline input only has one.
	InputClass *string `locationName:"inputClass" type:"string" enum:"InputClass"`

	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	InputPartnerIds []*string `locationName:"inputPartnerIds" type:"list"`

	// There are two types of input sources, static and dynamic. If an input source
	// is dynamic you canchange the source url of the input dynamically using an
	// input switch action. Currently, two input typessupport a dynamic url at this
	// time, MP4_FILE and TS_FILE. By default all input sources are static.
	InputSourceType *string `locationName:"inputSourceType" type:"string" enum:"InputSourceType"`

	MediaConnectFlows []*MediaConnectFlow `locationName:"mediaConnectFlows" type:"list"`

	Name *string `locationName:"name" type:"string"`

	RoleArn *string `locationName:"roleArn" type:"string"`

	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	// The different types of inputs that AWS Elemental MediaLive supports.
	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputOutput) SetArn(v string) *DescribeInputOutput {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *DescribeInputOutput) SetAttachedChannels(v []*string) *DescribeInputOutput {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeInputOutput) SetDestinations(v []*InputDestination) *DescribeInputOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputOutput) SetId(v string) *DescribeInputOutput {
	s.Id = &v
	return s
}

// SetInputClass sets the InputClass field's value.
func (s *DescribeInputOutput) SetInputClass(v string) *DescribeInputOutput {
	s.InputClass = &v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *DescribeInputOutput) SetInputDevices(v []*InputDeviceSettings) *DescribeInputOutput {
	s.InputDevices = v
	return s
}

// SetInputPartnerIds sets the InputPartnerIds field's value.
func (s *DescribeInputOutput) SetInputPartnerIds(v []*string) *DescribeInputOutput {
	s.InputPartnerIds = v
	return s
}

// SetInputSourceType sets the InputSourceType field's value.
func (s *DescribeInputOutput) SetInputSourceType(v string) *DescribeInputOutput {
	s.InputSourceType = &v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *DescribeInputOutput) SetMediaConnectFlows(v []*MediaConnectFlow) *DescribeInputOutput {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInputOutput) SetName(v string) *DescribeInputOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeInputOutput) SetRoleArn(v string) *DescribeInputOutput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeInputOutput) SetSecurityGroups(v []*string) *DescribeInputOutput {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *DescribeInputOutput) SetSources(v []*InputSource) *DescribeInputOutput {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputOutput) SetState(v string) *DescribeInputOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeInputOutput) SetTags(v map[string]*string) *DescribeInputOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeInputOutput) SetType(v string) *DescribeInputOutput {
	s.Type = &v
	return s
}

type DescribeInputSecurityGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// InputSecurityGroupId is a required field
	InputSecurityGroupId *string `location:"uri" locationName:"inputSecurityGroupId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputSecurityGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInputSecurityGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInputSecurityGroupInput"}
	if s.InputSecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSecurityGroupId"))
	}
	if s.InputSecurityGroupId != nil && len(*s.InputSecurityGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputSecurityGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputSecurityGroupId sets the InputSecurityGroupId field's value.
func (s *DescribeInputSecurityGroupInput) SetInputSecurityGroupId(v string) *DescribeInputSecurityGroupInput {
	s.InputSecurityGroupId = &v
	return s
}

type DescribeInputSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Id *string `locationName:"id" type:"string"`

	Inputs []*string `locationName:"inputs" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInputSecurityGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeInputSecurityGroupOutput) SetArn(v string) *DescribeInputSecurityGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInputSecurityGroupOutput) SetId(v string) *DescribeInputSecurityGroupOutput {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *DescribeInputSecurityGroupOutput) SetInputs(v []*string) *DescribeInputSecurityGroupOutput {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *DescribeInputSecurityGroupOutput) SetState(v string) *DescribeInputSecurityGroupOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeInputSecurityGroupOutput) SetTags(v map[string]*string) *DescribeInputSecurityGroupOutput {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *DescribeInputSecurityGroupOutput) SetWhitelistRules(v []*InputWhitelistRule) *DescribeInputSecurityGroupOutput {
	s.WhitelistRules = v
	return s
}

type DescribeMultiplexInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiplexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMultiplexInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DescribeMultiplexInput) SetMultiplexId(v string) *DescribeMultiplexInput {
	s.MultiplexId = &v
	return s
}

type DescribeMultiplexOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	AvailabilityZones []*string `locationName:"availabilityZones" type:"list"`

	Destinations []*MultiplexOutputDestination `locationName:"destinations" type:"list"`

	Id *string `locationName:"id" type:"string"`

	// Contains configuration for a Multiplex event
	MultiplexSettings *MultiplexSettings `locationName:"multiplexSettings" type:"structure"`

	Name *string `locationName:"name" type:"string"`

	PipelinesRunningCount *int64 `locationName:"pipelinesRunningCount" type:"integer"`

	ProgramCount *int64 `locationName:"programCount" type:"integer"`

	// The current state of the multiplex.
	State *string `locationName:"state" type:"string" enum:"MultiplexState"`

	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeMultiplexOutput) SetArn(v string) *DescribeMultiplexOutput {
	s.Arn = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DescribeMultiplexOutput) SetAvailabilityZones(v []*string) *DescribeMultiplexOutput {
	s.AvailabilityZones = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DescribeMultiplexOutput) SetDestinations(v []*MultiplexOutputDestination) *DescribeMultiplexOutput {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeMultiplexOutput) SetId(v string) *DescribeMultiplexOutput {
	s.Id = &v
	return s
}

// SetMultiplexSettings sets the MultiplexSettings field's value.
func (s *DescribeMultiplexOutput) SetMultiplexSettings(v *MultiplexSettings) *DescribeMultiplexOutput {
	s.MultiplexSettings = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeMultiplexOutput) SetName(v string) *DescribeMultiplexOutput {
	s.Name = &v
	return s
}

// SetPipelinesRunningCount sets the PipelinesRunningCount field's value.
func (s *DescribeMultiplexOutput) SetPipelinesRunningCount(v int64) *DescribeMultiplexOutput {
	s.PipelinesRunningCount = &v
	return s
}

// SetProgramCount sets the ProgramCount field's value.
func (s *DescribeMultiplexOutput) SetProgramCount(v int64) *DescribeMultiplexOutput {
	s.ProgramCount = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeMultiplexOutput) SetState(v string) *DescribeMultiplexOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeMultiplexOutput) SetTags(v map[string]*string) *DescribeMultiplexOutput {
	s.Tags = v
	return s
}

type DescribeMultiplexProgramInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// MultiplexId is a required field
	MultiplexId *string `location:"uri" locationName:"multiplexId" type:"string" required:"true"`

	// ProgramName is a required field
	ProgramName *string `location:"uri" locationName:"programName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexProgramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexProgramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMultiplexProgramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMultiplexProgramInput"}
	if s.MultiplexId == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiplexId"))
	}
	if s.MultiplexId != nil && len(*s.MultiplexId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiplexId", 1))
	}
	if s.ProgramName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProgramName"))
	}
	if s.ProgramName != nil && len(*s.ProgramName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProgramName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiplexId sets the MultiplexId field's value.
func (s *DescribeMultiplexProgramInput) SetMultiplexId(v string) *DescribeMultiplexProgramInput {
	s.MultiplexId = &v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeMultiplexProgramInput) SetProgramName(v string) *DescribeMultiplexProgramInput {
	s.ProgramName = &v
	return s
}

type DescribeMultiplexProgramOutput struct {
	_ struct{} `type:"structure"`

	ChannelId *string `locationName:"channelId" type:"string"`

	// Multiplex Program settings configuration.
	MultiplexProgramSettings *MultiplexProgramSettings `locationName:"multiplexProgramSettings" type:"structure"`

	// Packet identifiers map for a given Multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap `locationName:"packetIdentifiersMap" type:"structure"`

	PipelineDetails []*MultiplexProgramPipelineDetail `locationName:"pipelineDetails" type:"list"`

	ProgramName *string `locationName:"programName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexProgramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMultiplexProgramOutput) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeMultiplexProgramOutput) SetChannelId(v string) *DescribeMultiplexProgramOutput {
	s.ChannelId = &v
	return s
}

// SetMultiplexProgramSettings sets the MultiplexProgramSettings field's value.
func (s *DescribeMultiplexProgramOutput) SetMultiplexProgramSettings(v *MultiplexProgramSettings) *DescribeMultiplexProgramOutput {
	s.MultiplexProgramSettings = v
	return s
}

// SetPacketIdentifiersMap sets the PacketIdentifiersMap field's value.
func (s *DescribeMultiplexProgramOutput) SetPacketIdentifiersMap(v *MultiplexProgramPacketIdentifiersMap) *DescribeMultiplexProgramOutput {
	s.PacketIdentifiersMap = v
	return s
}

// SetPipelineDetails sets the PipelineDetails field's value.
func (s *DescribeMultiplexProgramOutput) SetPipelineDetails(v []*MultiplexProgramPipelineDetail) *DescribeMultiplexProgramOutput {
	s.PipelineDetails = v
	return s
}

// SetProgramName sets the ProgramName field's value.
func (s *DescribeMultiplexProgramOutput) SetProgramName(v string) *DescribeMultiplexProgramOutput {
	s.ProgramName = &v
	return s
}

type DescribeOfferingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// OfferingId is a required field
	OfferingId *string `location:"uri" locationName:"offeringId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOfferingInput"}
	if s.OfferingId == nil {
		invalidParams.Add(request.NewErrParamRequired("OfferingId"))
	}
	if s.OfferingId != nil && len(*s.OfferingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeOfferingInput) SetOfferingId(v string) *DescribeOfferingInput {
	s.OfferingId = &v
	return s
}

type DescribeOfferingOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeOfferingOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeOfferingOutput) SetArn(v string) *DescribeOfferingOutput {
	s.Arn = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DescribeOfferingOutput) SetCurrencyCode(v string) *DescribeOfferingOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeOfferingOutput) SetDuration(v int64) *DescribeOfferingOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DescribeOfferingOutput) SetDurationUnits(v string) *DescribeOfferingOutput {
	s.DurationUnits = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DescribeOfferingOutput) SetFixedPrice(v float64) *DescribeOfferingOutput {
	s.FixedPrice = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DescribeOfferingOutput) SetOfferingDescription(v string) *DescribeOfferingOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeOfferingOutput) SetOfferingId(v string) *DescribeOfferingOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeOfferingOutput) SetOfferingType(v string) *DescribeOfferingOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DescribeOfferingOutput) SetRegion(v string) *DescribeOfferingOutput {
	s.Region = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeOfferingOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DescribeOfferingOutput {
	s.ResourceSpecification = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DescribeOfferingOutput) SetUsagePrice(v float64) *DescribeOfferingOutput {
	s.UsagePrice = &v
	return s
}

type DescribeReservationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ReservationId is a required field
	ReservationId *string `location:"uri" locationName:"reservationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReservationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReservationInput"}
	if s.ReservationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservationId"))
	}
	if s.ReservationId != nil && len(*s.ReservationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReservationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReservationId sets the ReservationId field's value.
func (s *DescribeReservationInput) SetReservationId(v string) *DescribeReservationInput {
	s.ReservationId = &v
	return s
}

type DescribeReservationOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	Count *int64 `locationName:"count" type:"integer"`

	CurrencyCode *string `locationName:"currencyCode" type:"string"`

	Duration *int64 `locationName:"duration" type:"integer"`

	// Units for duration, e.g. 'MONTHS'
	DurationUnits *string `locationName:"durationUnits" type:"string" enum:"OfferingDurationUnits"`

	End *string `locationName:"end" type:"string"`

	FixedPrice *float64 `locationName:"fixedPrice" type:"double"`

	Name *string `locationName:"name" type:"string"`

	OfferingDescription *string `locationName:"offeringDescription" type:"string"`

	OfferingId *string `locationName:"offeringId" type:"string"`

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType *string `locationName:"offeringType" type:"string" enum:"OfferingType"`

	Region *string `locationName:"region" type:"string"`

	// The Renewal settings for Reservations
	RenewalSettings *RenewalSettings `locationName:"renewalSettings" type:"structure"`

	ReservationId *string `locationName:"reservationId" type:"string"`

	// Resource configuration (codec, resolution, bitrate, ...)
	ResourceSpecification *ReservationResourceSpecification `locationName:"resourceSpecification" type:"structure"`

	Start *string `locationName:"start" type:"string"`

	// Current reservation state
	State *string `locationName:"state" type:"string" enum:"ReservationState"`

	Tags map[string]*string `locationName:"tags" type:"map"`

	UsagePrice *float64 `locationName:"usagePrice" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReservationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeReservationOutput) SetArn(v string) *DescribeReservationOutput {
	s.Arn = &v
	return s
}

// SetCount sets the Count field's value.
func (s *DescribeReservationOutput) SetCount(v int64) *DescribeReservationOutput {
	s.Count = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *DescribeReservationOutput) SetCurrencyCode(v string) *DescribeReservationOutput {
	s.CurrencyCode = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *DescribeReservationOutput) SetDuration(v int64) *DescribeReservationOutput {
	s.Duration = &v
	return s
}

// SetDurationUnits sets the DurationUnits field's value.
func (s *DescribeReservationOutput) SetDurationUnits(v string) *DescribeReservationOutput {
	s.DurationUnits = &v
	return s
}

// SetEnd sets the End field's value.
func (s *DescribeReservationOutput) SetEnd(v string) *DescribeReservationOutput {
	s.End = &v
	return s
}

// SetFixedPrice sets the FixedPrice field's value.
func (s *DescribeReservationOutput) SetFixedPrice(v float64) *DescribeReservationOutput {
	s.FixedPrice = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeReservationOutput) SetName(v string) *DescribeReservationOutput {
	s.Name = &v
	return s
}

// SetOfferingDescription sets the OfferingDescription field's value.
func (s *DescribeReservationOutput) SetOfferingDescription(v string) *DescribeReservationOutput {
	s.OfferingDescription = &v
	return s
}

// SetOfferingId sets the OfferingId field's value.
func (s *DescribeReservationOutput) SetOfferingId(v string) *DescribeReservationOutput {
	s.OfferingId = &v
	return s
}

// SetOfferingType sets the OfferingType field's value.
func (s *DescribeReservationOutput) SetOfferingType(v string) *DescribeReservationOutput {
	s.OfferingType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DescribeReservationOutput) SetRegion(v string) *DescribeReservationOutput {
	s.Region = &v
	return s
}

// SetRenewalSettings sets the RenewalSettings field's value.
func (s *DescribeReservationOutput) SetRenewalSettings(v *RenewalSettings) *DescribeReservationOutput {
	s.RenewalSettings = v
	return s
}

// SetReservationId sets the ReservationId field's value.
func (s *DescribeReservationOutput) SetReservationId(v string) *DescribeReservationOutput {
	s.ReservationId = &v
	return s
}

// SetResourceSpecification sets the ResourceSpecification field's value.
func (s *DescribeReservationOutput) SetResourceSpecification(v *ReservationResourceSpecification) *DescribeReservationOutput {
	s.ResourceSpecification = v
	return s
}

// SetStart sets the Start field's value.
func (s *DescribeReservationOutput) SetStart(v string) *DescribeReservationOutput {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeReservationOutput) SetState(v string) *DescribeReservationOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeReservationOutput) SetTags(v map[string]*string) *DescribeReservationOutput {
	s.Tags = v
	return s
}

// SetUsagePrice sets the UsagePrice field's value.
func (s *DescribeReservationOutput) SetUsagePrice(v float64) *DescribeReservationOutput {
	s.UsagePrice = &v
	return s
}

type DescribeScheduleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduleInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeScheduleInput) SetChannelId(v string) *DescribeScheduleInput {
	s.ChannelId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScheduleInput) SetMaxResults(v int64) *DescribeScheduleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduleInput) SetNextToken(v string) *DescribeScheduleInput {
	s.NextToken = &v
	return s
}

type DescribeScheduleOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`

	ScheduleActions []*ScheduleAction `locationName:"scheduleActions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScheduleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScheduleOutput) SetNextToken(v string) *DescribeScheduleOutput {
	s.NextToken = &v
	return s
}

// SetScheduleActions sets the ScheduleActions field's value.
func (s *DescribeScheduleOutput) SetScheduleActions(v []*ScheduleAction) *DescribeScheduleOutput {
	s.ScheduleActions = v
	return s
}

type DescribeThumbnailsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ChannelId is a required field
	ChannelId *string `location:"uri" locationName:"channelId" type:"string" required:"true"`

	// PipelineId is a required field
	PipelineId *string `location:"querystring" locationName:"pipelineId" type:"string" required:"true"`

	// ThumbnailType is a required field
	ThumbnailType *string `location:"querystring" locationName:"thumbnailType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThumbnailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThumbnailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeThumbnailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeThumbnailsInput"}
	if s.ChannelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelId"))
	}
	if s.ChannelId != nil && len(*s.ChannelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelId", 1))
	}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.ThumbnailType == nil {
		invalidParams.Add(request.NewErrParamRequired("ThumbnailType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelId sets the ChannelId field's value.
func (s *DescribeThumbnailsInput) SetChannelId(v string) *DescribeThumbnailsInput {
	s.ChannelId = &v
	return s
}

// SetPipelineId sets the PipelineId field's value.
func (s *DescribeThumbnailsInput) SetPipelineId(v string) *DescribeThumbnailsInput {
	s.PipelineId = &v
	return s
}

// SetThumbnailType sets the ThumbnailType field's value.
func (s *DescribeThumbnailsInput) SetThumbnailType(v string) *DescribeThumbnailsInput {
	s.ThumbnailType = &v
	return s
}

type DescribeThumbnailsOutput struct {
	_ struct{} `type:"structure"`

	ThumbnailDetails []*ThumbnailDetail `locationName:"thumbnailDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThumbnailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeThumbnailsOutput) GoString() string {
	return s.String()
}

// SetThumbnailDetails sets the ThumbnailDetails field's value.
func (s *DescribeThumbnailsOutput) SetThumbnailDetails(v []*ThumbnailDetail) *DescribeThumbnailsOutput {
	s.ThumbnailDetails = v
	return s
}

// Dolby Vision81 Settings
type DolbyVision81Settings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DolbyVision81Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DolbyVision81Settings) GoString() string {
	return s.String()
}

// DVB Network Information Table (NIT)
type DvbNitSettings struct {
	_ struct{} `type:"structure"`

	// The numeric value placed in the Network Information Table (NIT).
	//
	// NetworkId is a required field
	NetworkId *int64 `locationName:"networkId" type:"integer" required:"true"`

	// The network name text placed in the networkNameDescriptor inside the Network
	// Information Table. Maximum length is 256 characters.
	//
	// NetworkName is a required field
	NetworkName *string `locationName:"networkName" min:"1" type:"string" required:"true"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbNitSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbNitSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbNitSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbNitSettings"}
	if s.NetworkId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkName"))
	}
	if s.NetworkName != nil && len(*s.NetworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkName", 1))
	}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetworkId sets the NetworkId field's value.
func (s *DvbNitSettings) SetNetworkId(v int64) *DvbNitSettings {
	s.NetworkId = &v
	return s
}

// SetNetworkName sets the NetworkName field's value.
func (s *DvbNitSettings) SetNetworkName(v string) *DvbNitSettings {
	s.NetworkName = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbNitSettings) SetRepInterval(v int64) *DvbNitSettings {
	s.RepInterval = &v
	return s
}

// DVB Service Description Table (SDT)
type DvbSdtSettings struct {
	_ struct{} `type:"structure"`

	// Selects method of inserting SDT information into output stream. The sdtFollow
	// setting copies SDT information from input stream to output stream. The sdtFollowIfPresent
	// setting copies SDT information from input stream to output stream if SDT
	// information is present in the input, otherwise it will fall back on the user-defined
	// values. The sdtManual setting means user will enter the SDT information.
	// The sdtNone setting means output stream will not contain SDT information.
	OutputSdt *string `locationName:"outputSdt" type:"string" enum:"DvbSdtOutputSdt"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"25" type:"integer"`

	// The service name placed in the serviceDescriptor in the Service Description
	// Table. Maximum length is 256 characters.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service provider name placed in the serviceDescriptor in the Service
	// Description Table. Maximum length is 256 characters.
	ServiceProviderName *string `locationName:"serviceProviderName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 25 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 25))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.ServiceProviderName != nil && len(*s.ServiceProviderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutputSdt sets the OutputSdt field's value.
func (s *DvbSdtSettings) SetOutputSdt(v string) *DvbSdtSettings {
	s.OutputSdt = &v
	return s
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbSdtSettings) SetRepInterval(v int64) *DvbSdtSettings {
	s.RepInterval = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DvbSdtSettings) SetServiceName(v string) *DvbSdtSettings {
	s.ServiceName = &v
	return s
}

// SetServiceProviderName sets the ServiceProviderName field's value.
func (s *DvbSdtSettings) SetServiceProviderName(v string) *DvbSdtSettings {
	s.ServiceProviderName = &v
	return s
}

// Dvb Sub Destination Settings
type DvbSubDestinationSettings struct {
	_ struct{} `type:"structure"`

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting
	// a left alignment will align captions to the bottom left of the output. If
	// x and y positions are given in conjunction with the alignment parameter,
	// the font will be justified (either left or centered) relative to those coordinates.
	// Selecting "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. This option is not valid for source captions that
	// are STL or 608/embedded. These source settings are already pre-defined by
	// the caption stream. All burn-in and DVB-Sub font settings must match.
	Alignment *string `locationName:"alignment" type:"string" enum:"DvbSubDestinationAlignment"`

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor *string `locationName:"backgroundColor" type:"string" enum:"DvbSubDestinationBackgroundColor"`

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent.
	// Leaving this parameter blank is equivalent to setting it to 0 (transparent).
	// All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity *int64 `locationName:"backgroundOpacity" type:"integer"`

	// External font file used for caption burn-in. File extension must be 'ttf'
	// or 'tte'. Although the user can select output fonts for many different types
	// of input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation `locationName:"font" type:"structure"`

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor *string `locationName:"fontColor" type:"string" enum:"DvbSubDestinationFontColor"`

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent.
	// All burn-in and DVB-Sub font settings must match.
	FontOpacity *int64 `locationName:"fontOpacity" type:"integer"`

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution *int64 `locationName:"fontResolution" min:"96" type:"integer"`

	// When set to auto fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string `locationName:"fontSize" type:"string"`

	// Specifies font outline color. This option is not valid for source captions
	// that are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineColor *string `locationName:"outlineColor" type:"string" enum:"DvbSubDestinationOutlineColor"`

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	OutlineSize *int64 `locationName:"outlineSize" type:"integer"`

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor *string `locationName:"shadowColor" type:"string" enum:"DvbSubDestinationShadowColor"`

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter blank is equivalent to setting it to 0 (transparent). All
	// burn-in and DVB-Sub font settings must match.
	ShadowOpacity *int64 `locationName:"shadowOpacity" type:"integer"`

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left.
	// All burn-in and DVB-Sub font settings must match.
	ShadowXOffset *int64 `locationName:"shadowXOffset" type:"integer"`

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset *int64 `locationName:"shadowYOffset" type:"integer"`

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl *string `locationName:"teletextGridControl" type:"string" enum:"DvbSubDestinationTeletextGridControl"`

	// Specifies the horizontal position of the caption relative to the left side
	// of the output in pixels. A value of 10 would result in the captions starting
	// 10 pixels from the left of the output. If no explicit xPosition is provided,
	// the horizontal caption position will be determined by the alignment parameter.
	// This option is not valid for source captions that are STL, 608/embedded or
	// teletext. These source settings are already pre-defined by the caption stream.
	// All burn-in and DVB-Sub font settings must match.
	XPosition *int64 `locationName:"xPosition" type:"integer"`

	// Specifies the vertical position of the caption relative to the top of the
	// output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the top of the output. If no explicit yPosition is provided,
	// the caption will be positioned towards the bottom of the output. This option
	// is not valid for source captions that are STL, 608/embedded or teletext.
	// These source settings are already pre-defined by the caption stream. All
	// burn-in and DVB-Sub font settings must match.
	YPosition *int64 `locationName:"yPosition" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSubDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSubDestinationSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubDestinationSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubDestinationSettings"}
	if s.FontResolution != nil && *s.FontResolution < 96 {
		invalidParams.Add(request.NewErrParamMinValue("FontResolution", 96))
	}
	if s.Font != nil {
		if err := s.Font.Validate(); err != nil {
			invalidParams.AddNested("Font", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlignment sets the Alignment field's value.
func (s *DvbSubDestinationSettings) SetAlignment(v string) *DvbSubDestinationSettings {
	s.Alignment = &v
	return s
}

// SetBackgroundColor sets the BackgroundColor field's value.
func (s *DvbSubDestinationSettings) SetBackgroundColor(v string) *DvbSubDestinationSettings {
	s.BackgroundColor = &v
	return s
}

// SetBackgroundOpacity sets the BackgroundOpacity field's value.
func (s *DvbSubDestinationSettings) SetBackgroundOpacity(v int64) *DvbSubDestinationSettings {
	s.BackgroundOpacity = &v
	return s
}

// SetFont sets the Font field's value.
func (s *DvbSubDestinationSettings) SetFont(v *InputLocation) *DvbSubDestinationSettings {
	s.Font = v
	return s
}

// SetFontColor sets the FontColor field's value.
func (s *DvbSubDestinationSettings) SetFontColor(v string) *DvbSubDestinationSettings {
	s.FontColor = &v
	return s
}

// SetFontOpacity sets the FontOpacity field's value.
func (s *DvbSubDestinationSettings) SetFontOpacity(v int64) *DvbSubDestinationSettings {
	s.FontOpacity = &v
	return s
}

// SetFontResolution sets the FontResolution field's value.
func (s *DvbSubDestinationSettings) SetFontResolution(v int64) *DvbSubDestinationSettings {
	s.FontResolution = &v
	return s
}

// SetFontSize sets the FontSize field's value.
func (s *DvbSubDestinationSettings) SetFontSize(v string) *DvbSubDestinationSettings {
	s.FontSize = &v
	return s
}

// SetOutlineColor sets the OutlineColor field's value.
func (s *DvbSubDestinationSettings) SetOutlineColor(v string) *DvbSubDestinationSettings {
	s.OutlineColor = &v
	return s
}

// SetOutlineSize sets the OutlineSize field's value.
func (s *DvbSubDestinationSettings) SetOutlineSize(v int64) *DvbSubDestinationSettings {
	s.OutlineSize = &v
	return s
}

// SetShadowColor sets the ShadowColor field's value.
func (s *DvbSubDestinationSettings) SetShadowColor(v string) *DvbSubDestinationSettings {
	s.ShadowColor = &v
	return s
}

// SetShadowOpacity sets the ShadowOpacity field's value.
func (s *DvbSubDestinationSettings) SetShadowOpacity(v int64) *DvbSubDestinationSettings {
	s.ShadowOpacity = &v
	return s
}

// SetShadowXOffset sets the ShadowXOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowXOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowXOffset = &v
	return s
}

// SetShadowYOffset sets the ShadowYOffset field's value.
func (s *DvbSubDestinationSettings) SetShadowYOffset(v int64) *DvbSubDestinationSettings {
	s.ShadowYOffset = &v
	return s
}

// SetTeletextGridControl sets the TeletextGridControl field's value.
func (s *DvbSubDestinationSettings) SetTeletextGridControl(v string) *DvbSubDestinationSettings {
	s.TeletextGridControl = &v
	return s
}

// SetXPosition sets the XPosition field's value.
func (s *DvbSubDestinationSettings) SetXPosition(v int64) *DvbSubDestinationSettings {
	s.XPosition = &v
	return s
}

// SetYPosition sets the YPosition field's value.
func (s *DvbSubDestinationSettings) SetYPosition(v int64) *DvbSubDestinationSettings {
	s.YPosition = &v
	return s
}

// Dvb Sub Source Settings
type DvbSubSourceSettings struct {
	_ struct{} `type:"structure"`

	// If you will configure a WebVTT caption description that references this caption
	// selector, use this field toprovide the language to consider when translating
	// the image-based source to text.
	OcrLanguage *string `locationName:"ocrLanguage" type:"string" enum:"DvbSubOcrLanguage"`

	// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source
	// content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through,
	// regardless of selectors.
	Pid *int64 `locationName:"pid" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSubSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbSubSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbSubSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbSubSourceSettings"}
	if s.Pid != nil && *s.Pid < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Pid", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOcrLanguage sets the OcrLanguage field's value.
func (s *DvbSubSourceSettings) SetOcrLanguage(v string) *DvbSubSourceSettings {
	s.OcrLanguage = &v
	return s
}

// SetPid sets the Pid field's value.
func (s *DvbSubSourceSettings) SetPid(v int64) *DvbSubSourceSettings {
	s.Pid = &v
	return s
}

// DVB Time and Date Table (SDT)
type DvbTdtSettings struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval *int64 `locationName:"repInterval" min:"1000" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbTdtSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DvbTdtSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DvbTdtSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DvbTdtSettings"}
	if s.RepInterval != nil && *s.RepInterval < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("RepInterval", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepInterval sets the RepInterval field's value.
func (s *DvbTdtSettings) SetRepInterval(v int64) *DvbTdtSettings {
	s.RepInterval = &v
	return s
}

// Eac3 Atmos Settings
type Eac3AtmosSettings struct {
	_ struct{} `type:"structure"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.//
	// * @affectsRightSizing true
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Eac3AtmosCodingMode"`

	// Sets the dialnorm for the output. Default 23.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// Sets the Dolby dynamic range compression profile.
	DrcLine *string `locationName:"drcLine" type:"string" enum:"Eac3AtmosDrcLine"`

	// Sets the profile for heavy Dolby dynamic range compression, ensures that
	// the instantaneous signal peaks do not exceed specified levels.
	DrcRf *string `locationName:"drcRf" type:"string" enum:"Eac3AtmosDrcRf"`

	// Height dimensional trim. Sets the maximum amount to attenuate the height
	// channels when the downstream player isn??t configured to handle Dolby Digital
	// Plus with Dolby Atmos and must remix the channels.
	HeightTrim *float64 `locationName:"heightTrim" type:"double"`

	// Surround dimensional trim. Sets the maximum amount to attenuate the surround
	// channels when the downstream player isn't configured to handle Dolby Digital
	// Plus with Dolby Atmos and must remix the channels.
	SurroundTrim *float64 `locationName:"surroundTrim" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eac3AtmosSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eac3AtmosSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eac3AtmosSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Eac3AtmosSettings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBitrate sets the Bitrate field's value.
func (s *Eac3AtmosSettings) SetBitrate(v float64) *Eac3AtmosSettings {
	s.Bitrate = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Eac3AtmosSettings) SetCodingMode(v string) *Eac3AtmosSettings {
	s.CodingMode = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Eac3AtmosSettings) SetDialnorm(v int64) *Eac3AtmosSettings {
	s.Dialnorm = &v
	return s
}

// SetDrcLine sets the DrcLine field's value.
func (s *Eac3AtmosSettings) SetDrcLine(v string) *Eac3AtmosSettings {
	s.DrcLine = &v
	return s
}

// SetDrcRf sets the DrcRf field's value.
func (s *Eac3AtmosSettings) SetDrcRf(v string) *Eac3AtmosSettings {
	s.DrcRf = &v
	return s
}

// SetHeightTrim sets the HeightTrim field's value.
func (s *Eac3AtmosSettings) SetHeightTrim(v float64) *Eac3AtmosSettings {
	s.HeightTrim = &v
	return s
}

// SetSurroundTrim sets the SurroundTrim field's value.
func (s *Eac3AtmosSettings) SetSurroundTrim(v float64) *Eac3AtmosSettings {
	s.SurroundTrim = &v
	return s
}

// Eac3 Settings
type Eac3Settings struct {
	_ struct{} `type:"structure"`

	// When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
	// Only used for 3/2 coding mode.
	AttenuationControl *string `locationName:"attenuationControl" type:"string" enum:"Eac3AttenuationControl"`

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate *float64 `locationName:"bitrate" type:"double"`

	// Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC
	// A/52-2012 (Annex E) for background on these values.
	BitstreamMode *string `locationName:"bitstreamMode" type:"string" enum:"Eac3BitstreamMode"`

	// Dolby Digital Plus coding mode. Determines number of channels.
	CodingMode *string `locationName:"codingMode" type:"string" enum:"Eac3CodingMode"`

	// When set to enabled, activates a DC highpass filter for all input channels.
	DcFilter *string `locationName:"dcFilter" type:"string" enum:"Eac3DcFilter"`

	// Sets the dialnorm for the output. If blank and input audio is Dolby Digital
	// Plus, dialnorm will be passed through.
	Dialnorm *int64 `locationName:"dialnorm" min:"1" type:"integer"`

	// Sets the Dolby dynamic range compression profile.
	DrcLine *string `locationName:"drcLine" type:"string" enum:"Eac3DrcLine"`

	// Sets the profile for heavy Dolby dynamic range compression, ensures that
	// the instantaneous signal peaks do not exceed specified levels.
	DrcRf *string `locationName:"drcRf" type:"string" enum:"Eac3DrcRf"`

	// When encoding 3/2 audio, setting to lfe enables the LFE channel
	LfeControl *string `locationName:"lfeControl" type:"string" enum:"Eac3LfeControl"`

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior
	// to encoding. Only valid with codingMode32 coding mode.
	LfeFilter *string `locationName:"lfeFilter" type:"string" enum:"Eac3LfeFilter"`

	// Left only/Right only center mix level. Only used for 3/2 coding mode.
	LoRoCenterMixLevel *float64 `locationName:"loRoCenterMixLevel" type:"double"`

	// Left only/Right only surround mix level. Only used for 3/2 coding mode.
	LoRoSurroundMixLevel *float64 `locationName:"loRoSurroundMixLevel" type:"double"`

	// Left total/Right total center mix level. Only used for 3/2 coding mode.
	LtRtCenterMixLevel *float64 `locationName:"ltRtCenterMixLevel" type:"double"`

	// Left total/Right total surround mix level. Only used for 3/2 coding mode.
	LtRtSurroundMixLevel *float64 `locationName:"ltRtSurroundMixLevel" type:"double"`

	// When set to followInput, encoder metadata will be sourced from the DD, DD+,
	// or DolbyE decoder that supplied this audio data. If audio was not supplied
	// from one of these streams, then the static metadata settings will be used.
	MetadataControl *string `locationName:"metadataControl" type:"string" enum:"Eac3MetadataControl"`

	// When set to whenPossible, input DD+ audio will be passed through if it is
	// present on the input. This detection is dynamic over the life of the transcode.
	// Inputs that alternate between DD+ and non-DD+ content will have a consistent
	// DD+ output as the system alternates between passthrough and encoding.
	PassthroughControl *string `locationName:"passthroughControl" type:"string" enum:"Eac3PassthroughControl"`

	// When set to shift90Degrees, applies a 90-degree phase shift to the surround
	// channels. Only used for 3/2 coding mode.
	PhaseControl *string `locationName:"phaseControl" type:"string" enum:"Eac3PhaseControl"`

	// Stereo downmix preference. Only used for 3/2 coding mode.
	StereoDownmix *string `locationName:"stereoDownmix" type:"string" enum:"Eac3StereoDownmix"`

	// When encoding 3/2 audio, sets whether an extra center back surround channel
	// is matrix encoded into the left and right surround channels.
	SurroundExMode *string `locationName:"surroundExMode" type:"string" enum:"Eac3SurroundExMode"`

	// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into
	// the two channels.
	SurroundMode *string `locationName:"surroundMode" type:"string" enum:"Eac3SurroundMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eac3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eac3Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eac3Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Eac3Settings"}
	if s.Dialnorm != nil && *s.Dialnorm < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Dialnorm", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttenuationControl sets the AttenuationControl field's value.
func (s *Eac3Settings) SetAttenuationControl(v string) *Eac3Settings {
	s.AttenuationControl = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *Eac3Settings) SetBitrate(v float64) *Eac3Settings {
	s.Bitrate = &v
	return s
}

// SetBitstreamMode sets the BitstreamMode field's value.
func (s *Eac3Settings) SetBitstreamMode(v string) *Eac3Settings {
	s.BitstreamMode = &v
	return s
}

// SetCodingMode sets the CodingMode field's value.
func (s *Eac3Settings) SetCodingMode(v string) *Eac3Settings {
	s.CodingMode = &v
	return s
}

// SetDcFilter sets the DcFilter field's value.
func (s *Eac3Settings) SetDcFilter(v string) *Eac3Settings {
	s.DcFilter = &v
	return s
}

// SetDialnorm sets the Dialnorm field's value.
func (s *Eac3Settings) SetDialnorm(v int64) *Eac3Settings {
	s.Dialnorm = &v
	return s
}

// SetDrcLine sets the DrcLine field's value.
func (s *Eac3Settings) SetDrcLine(v string) *Eac3Settings {
	s.DrcLine = &v
	return s
}

// SetDrcRf sets the DrcRf field's value.
func (s *Eac3Settings) SetDrcRf(v string) *Eac3Settings {
	s.DrcRf = &v
	return s
}

// SetLfeControl sets the LfeControl field's value.
func (s *Eac3Settings) SetLfeControl(v string) *Eac3Settings {
	s.LfeControl = &v
	return s
}

// SetLfeFilter sets the LfeFilter field's value.
func (s *Eac3Settings) SetLfeFilter(v string) *Eac3Settings {
	s.LfeFilter = &v
	return s
}

// SetLoRoCenterMixLevel sets the LoRoCenterMixLevel field's value.
func (s *Eac3Settings) SetLoRoCenterMixLevel(v float64) *Eac3Settings {
	s.LoRoCenterMixLevel = &v
	return s
}

// SetLoRoSurroundMixLevel sets the LoRoSurroundMixLevel field's value.
func (s *Eac3Settings) SetLoRoSurroundMixLevel(v float64) *Eac3Settings {
	s.LoRoSurroundMixLevel = &v
	return s
}

// SetLtRtCenterMixLevel sets the LtRtCenterMixLevel field's value.
func (s *Eac3Settings) SetLtRtCenterMixLevel(v float64) *Eac3Settings {
	s.LtRtCenterMixLevel = &v
	return s
}

// SetLtRtSurroundMixLevel sets the LtRtSurroundMixLevel field's value.
func (s *Eac3Settings) SetLtRtSurroundMixLevel(v float64) *Eac3Settings {
	s.LtRtSurroundMixLevel = &v
	return s
}

// SetMetadataControl sets the MetadataControl field's value.
func (s *Eac3Settings) SetMetadataControl(v string) *Eac3Settings {
	s.MetadataControl = &v
	return s
}

// SetPassthroughControl sets the PassthroughControl field's value.
func (s *Eac3Settings) SetPassthroughControl(v string) *Eac3Settings {
	s.PassthroughControl = &v
	return s
}

// SetPhaseControl sets the PhaseControl field's value.
func (s *Eac3Settings) SetPhaseControl(v string) *Eac3Settings {
	s.PhaseControl = &v
	return s
}

// SetStereoDownmix sets the StereoDownmix field's value.
func (s *Eac3Settings) SetStereoDownmix(v string) *Eac3Settings {
	s.StereoDownmix = &v
	return s
}

// SetSurroundExMode sets the SurroundExMode field's value.
func (s *Eac3Settings) SetSurroundExMode(v string) *Eac3Settings {
	s.SurroundExMode = &v
	return s
}

// SetSurroundMode sets the SurroundMode field's value.
func (s *Eac3Settings) SetSurroundMode(v string) *Eac3Settings {
	s.SurroundMode = &v
	return s
}

// Ebu Tt DDestination Settings
type EbuTtDDestinationSettings struct {
	_ struct{} `type:"structure"`

	// Complete this field if you want to include the name of the copyright holder
	// in the copyright tag in the captions metadata.
	CopyrightHolder *string `locationName:"copyrightHolder" type:"string"`

	// Specifies how to handle the gap between the lines (in multi-line captions).-
	// enabled: Fill with the captions background color (as specified in the input
	// captions).- disabled: Leave the gap unfilled.
	FillLineGap *string `locationName:"fillLineGap" type:"string" enum:"EbuTtDFillLineGapControl"`

	// Specifies the font family to include in the font data attached to the EBU-TT
	// captions. Valid only if styleControl is set to include. If you leave this
	// field empty, the font family is set to "monospaced". (If styleControl is
	// set to exclude, the font family is always set to "monospaced".)You specify
	// only the font family. All other style information (color, bold, position
	// and so on) is copied from the input captions. The size is always set to 100%
	// to allow the downstream player to choose the size.- Enter a list of font
	// families, as a comma-separated list of font names, in order of preference.
	// The name can be a font family (such as “Arial”), or a generic font family
	// (such as “serif”), or “default” (to let the downstream player choose
	// the font).- Leave blank to set the family to “monospace”.
	FontFamily *string `locationName:"fontFamily" type:"string"`

	// Specifies the style information (font color, font position, and so on) to
	// include in the font data that is attached to the EBU-TT captions.- include:
	// Take the style information (font color, font position, and so on) from the
	// source captions and include that information in the font data attached to
	// the EBU-TT captions. This option is valid only if the source captions are
	// Embedded or Teletext.- exclude: In the font data attached to the EBU-TT captions,
	// set the font family to "monospaced". Do not include any other style information.
	StyleControl *string `locationName:"styleControl" type:"string" enum:"EbuTtDDestinationStyleControl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbuTtDDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EbuTtDDestinationSettings) GoString() string {
	return s.String()
}

// SetCopyrightHolder sets the CopyrightHolder field's value.
func (s *EbuTtDDestinationSettings) SetCopyrightHolder(v string) *EbuTtDDestinationSettings {
	s.CopyrightHolder = &v
	return s
}

// SetFillLineGap sets the FillLineGap field's value.
func (s *EbuTtDDestinationSettings) SetFillLineGap(v string) *EbuTtDDestinationSettings {
	s.FillLineGap = &v
	return s
}

// SetFontFamily sets the FontFamily field's value.
func (s *EbuTtDDestinationSettings) SetFontFamily(v string) *EbuTtDDestinationSettings {
	s.FontFamily = &v
	return s
}

// SetStyleControl sets the StyleControl field's value.
func (s *EbuTtDDestinationSettings) SetStyleControl(v string) *EbuTtDDestinationSettings {
	s.StyleControl = &v
	return s
}

// Embedded Destination Settings
type EmbeddedDestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedDestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedDestinationSettings) GoString() string {
	return s.String()
}

// Embedded Plus Scte20 Destination Settings
type EmbeddedPlusScte20DestinationSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedPlusScte20DestinationSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedPlusScte20DestinationSettings) GoString() string {
	return s.String()
}

// Embedded Source Settings
type EmbeddedSourceSettings struct {
	_ struct{} `type:"structure"`

	// If upconvert, 608 data is both passed through via the "608 compatibility
	// bytes" fields of the 708 wrapper as well as translated into 708. 708 data
	// present in the source content will be discarded.
	Convert608To708 *string `locationName:"convert608To708" type:"string" enum:"EmbeddedConvert608To708"`

	// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20
	// and Embedded captions.
	Scte20Detection *string `locationName:"scte20Detection" type:"string" enum:"EmbeddedScte20Detection"`

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber *int64 `locationName:"source608ChannelNumber" min:"1" type:"integer"`

	// This field is unused and deprecated.
	Source608TrackNumber *int64 `locationName:"source608TrackNumber" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedSourceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddedSourceSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmbeddedSourceSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmbeddedSourceSettings"}
	if s.Source608ChannelNumber != nil && *s.Source608ChannelNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608ChannelNumber", 1))
	}
	if s.Source608TrackNumber != nil && *s.Source608TrackNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Source608TrackNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConvert608To708 sets the Convert608To708 field's value.
func (s *EmbeddedSourceSettings) SetConvert608To708(v string) *EmbeddedSourceSettings {
	s.Convert608To708 = &v
	return s
}

// SetScte20Detection sets the Scte20Detection field's value.
func (s *EmbeddedSourceSettings) SetScte20Detection(v string) *EmbeddedSourceSettings {
	s.Scte20Detection = &v
	return s
}

// SetSource608ChannelNumber sets the Source608ChannelNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608ChannelNumber(v int64) *EmbeddedSourceSettings {
	s.Source608ChannelNumber = &v
	return s
}

// SetSource608TrackNumber sets the Source608TrackNumber field's value.
func (s *EmbeddedSourceSettings) SetSource608TrackNumber(v int64) *EmbeddedSourceSettings {
	s.Source608TrackNumber = &v
	return s
}

// Encoder Settings
type EncoderSettings struct {
	_ struct{} `type:"structure"`

	// AudioDescriptions is a required field
	AudioDescriptions []*AudioDescription `locationName:"audioDescriptions" type:"list" required:"true"`

	// Settings for ad avail blanking.
	AvailBlanking *AvailBlanking `locationName:"availBlanking" type:"structure"`

	// Event-wide configuration settings for ad avail insertion.
	AvailConfiguration *AvailConfiguration `locationName:"availConfiguration" type:"structure"`

	// Settings for blackout slate.
	BlackoutSlate *BlackoutSlate `locationName:"blackoutSlate" type:"structure"`

	// Settings for caption decriptions
	CaptionDescriptions []*CaptionDescription `locationName:"captionDescriptions" type:"list"`

	// Color Correction Settings
	ColorCorrectionSettings *ColorCorrectionSettings `locationName:"colorCorrectionSettings" type:"structure"`

	// Feature Activations
	FeatureActivations *FeatureActivations `locationName:"featureActivations" type:"structure"`

	// Configuration settings that apply to the event as a whole.
	GlobalConfiguration *GlobalConfiguration `locationName:"globalConfiguration" type:"structure"`

	// Settings for motion graphics.
	MotionGraphicsConfiguration *MotionGraphicsConfiguration `locationName:"motionGraphicsConfiguration" type:"structure"`

	// Nielsen configuration settings.
	NielsenConfiguration *NielsenConfiguration `locationName:"nielsenConfiguration" type:"structure"`

	// OutputGroups is a required field
	OutputGroups []*OutputGroup `locationName:"outputGroups" type:"list" required:"true"`

	// Thumbnail configuration settings.
	ThumbnailConfiguration *ThumbnailConfiguration `locationName:"thumbnailConfiguration" type:"structure"`

	// Contains settings used to acquire and adjust timecode information from inputs.
	//
	// TimecodeConfig is a required field
	TimecodeConfig *TimecodeConfig `locationName:"timecodeConfig" type:"structure" required:"true"`

	// VideoDescriptions is a required field
	VideoDescriptions []*VideoDescription `locationName:"videoDescriptions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncoderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncoderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncoderSettings"}
	if s.AudioDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("AudioDescriptions"))
	}
	if s.OutputGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputGroups"))
	}
	if s.TimecodeConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TimecodeConfig"))
	}
	if s.VideoDescriptions == nil {
		invalidParams.Add(request.NewErrParamRequired("VideoDescriptions"))
	}
	if s.AudioDescriptions != nil {
		for i, v := range s.AudioDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.AvailBlanking != nil {
		if err := s.AvailBlanking.Validate(); err != nil {
			invalidParams.AddNested("AvailBlanking", err.(request.ErrInvalidParams))
		}
	}
	if s.AvailConfiguration != nil {
		if err := s.AvailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AvailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.BlackoutSlate != nil {
		if err := s.BlackoutSlate.Validate(); err != nil {
			invalidParams.AddNested("BlackoutSlate", err.(request.ErrInvalidParams))
		}
	}
	if s.CaptionDescriptions != nil {
		for i, v := range s.CaptionDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ColorCorrectionSettings != nil {
		if err := s.ColorCorrectionSettings.Validate(); err != nil {
			invalidParams.AddNested("ColorCorrectionSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.GlobalConfiguration != nil {
		if err := s.GlobalConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlobalConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.MotionGraphicsConfiguration != nil {
		if err := s.MotionGraphicsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MotionGraphicsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputGroups != nil {
		for i, v := range s.OutputGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ThumbnailConfiguration != nil {
		if err := s.ThumbnailConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ThumbnailConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.TimecodeConfig != nil {
		if err := s.TimecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("TimecodeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VideoDescriptions != nil {
		for i, v := range s.VideoDescriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VideoDescriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioDescriptions sets the AudioDescriptions field's value.
func (s *EncoderSettings) SetAudioDescriptions(v []*AudioDescription) *EncoderSettings {
	s.AudioDescriptions = v
	return s
}

// SetAvailBlanking sets the AvailBlanking field's value.
func (s *EncoderSettings) SetAvailBlanking(v *AvailBlanking) *EncoderSettings {
	s.AvailBlanking = v
	return s
}

// SetAvailConfiguration sets the AvailConfiguration field's value.
func (s *EncoderSettings) SetAvailConfiguration(v *AvailConfiguration) *EncoderSettings {
	s.AvailConfiguration = v
	return s
}

// SetBlackoutSlate sets the BlackoutSlate field's value.
func (s *EncoderSettings) SetBlackoutSlate(v *BlackoutSlate) *EncoderSettings {
	s.BlackoutSlate = v
	return s
}

// SetCaptionDescriptions sets the CaptionDescriptions field's value.
func (s *EncoderSettings) SetCaptionDescriptions(v []*CaptionDescription) *EncoderSettings {
	s.CaptionDescriptions = v
	return s
}

// SetColorCorrectionSettings sets the ColorCorrectionSettings field's value.
func (s *EncoderSettings) SetColorCorrectionSettings(v *ColorCorrectionSettings) *EncoderSettings {
	s.ColorCorrectionSettings = v
	return s
}

// SetFeatureActivations sets the FeatureActivations field's value.
func (s *EncoderSettings) SetFeatureActivations(v *FeatureActivations) *EncoderSettings {
	s.FeatureActivations = v
	return s
}

// SetGlobalConfiguration sets the GlobalConfiguration field's value.
func (s *EncoderSettings) SetGlobalConfiguration(v *GlobalConfiguration) *EncoderSettings {
	s.GlobalConfiguration = v
	return s
}

// SetMotionGraphicsConfiguration sets the MotionGraphicsConfiguration field's value.
func (s *EncoderSettings) SetMotionGraphicsConfiguration(v *MotionGraphicsConfiguration) *EncoderSettings {
	s.MotionGraphicsConfiguration = v
	return s
}

// SetNielsenConfiguration sets the NielsenConfiguration field's value.
func (s *EncoderSettings) SetNielsenConfiguration(v *NielsenConfiguration) *EncoderSettings {
	s.NielsenConfiguration = v
	return s
}

// SetOutputGroups sets the OutputGroups field's value.
func (s *EncoderSettings) SetOutputGroups(v []*OutputGroup) *EncoderSettings {
	s.OutputGroups = v
	return s
}

// SetThumbnailConfiguration sets the ThumbnailConfiguration field's value.
func (s *EncoderSettings) SetThumbnailConfiguration(v *ThumbnailConfiguration) *EncoderSettings {
	s.ThumbnailConfiguration = v
	return s
}

// SetTimecodeConfig sets the TimecodeConfig field's value.
func (s *EncoderSettings) SetTimecodeConfig(v *TimecodeConfig) *EncoderSettings {
	s.TimecodeConfig = v
	return s
}

// SetVideoDescriptions sets the VideoDescriptions field's value.
func (s *EncoderSettings) SetVideoDescriptions(v []*VideoDescription) *EncoderSettings {
	s.VideoDescriptions = v
	return s
}

// Epoch Locking Settings
type EpochLockingSettings struct {
	_ struct{} `type:"structure"`

	// Optional. Enter a value here to use a custom epoch, instead of the standard
	// epoch (which started at 1970-01-01T00:00:00 UTC). Specify the start time
	// of the custom epoch, in YYYY-MM-DDTHH:MM:SS in UTC. The time must be 2000-01-01T00:00:00
	// or later. Always set the MM:SS portion to 00:00.
	CustomEpoch *string `locationName:"customEpoch" type:"string"`

	// Optional. Enter a time for the jam sync. The default is midnight UTC. When
	// epoch locking is enabled, MediaLive performs a daily jam sync on every output
	// encode to ensure timecodes don’t diverge from the wall clock. The jam sync
	// applies only to encodes with frame rate of 29.97 or 59.94 FPS. To override,
	// enter a time in HH:MM:SS in UTC. Always set the MM:SS portion to 00:00.
	JamSyncTime *string `locationName:"jamSyncTime" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EpochLockingSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EpochLockingSettings) GoString() string {
	return s.String()
}

// SetCustomEpoch sets the CustomEpoch field's value.
func (s *EpochLockingSettings) SetCustomEpoch(v string) *EpochLockingSettings {
	s.CustomEpoch = &v
	return s
}

// SetJamSyncTime sets the JamSyncTime field's value.
func (s *EpochLockingSettings) SetJamSyncTime(v string) *EpochLockingSettings {
	s.JamSyncTime = &v
	return s
}

// Esam
type Esam struct {
	_ struct{} `type:"structure"`

	// Sent as acquisitionPointIdentity to identify the MediaLive channel to the
	// POIS.
	//
	// AcquisitionPointId is a required field
	AcquisitionPointId *string `locationName:"acquisitionPointId" type:"string" required:"true"`

	// When specified, this offset (in milliseconds) is added to the input Ad Avail
	// PTS time. This only applies to embedded SCTE 104/35 messages and does not
	// apply to OOB messages.
	AdAvailOffset *int64 `locationName:"adAvailOffset" type:"integer"`

	// Reference to an AWS parameter store name from which the password can be retrieved
	// if credentials are required to access the POIS endpoint. AWS Parameter store
	// format: "ssm://"
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// The URL of the signal conditioner endpoint on the Placement Opportunity Information
	// System (POIS). MediaLive sends SignalProcessingEvents here when SCTE-35 messages
	// are read.
	//
	// PoisEndpoint is a required field
	PoisEndpoint *string `locationName:"poisEndpoint" type:"string" required:"true"`

	// Username if credentials are required to access the POIS endpoint. This can
	// be either a plaintext username, or a reference to an AWS parameter store
	// name from which the username can be retrieved. AWS Parameter store format:
	// "ssm://"
	Username *string `locationName:"username" type:"string"`

	// Optional data sent as zoneIdentity to identify the MediaLive channel to the
	// POIS.
	ZoneIdentity *string `locationName:"zoneIdentity" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Esam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Esam) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Esam) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Esam"}
	if s.AcquisitionPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("AcquisitionPointId"))
	}
	if s.AdAvailOffset != nil && *s.AdAvailOffset < -1000 {
		invalidParams.Add(request.NewErrParamMinValue("AdAvailOffset", -1000))
	}
	if s.PoisEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("PoisEndpoint"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcquisitionPointId sets the AcquisitionPointId field's value.
func (s *Esam) SetAcquisitionPointId(v string) *Esam {
	s.AcquisitionPointId = &v
	return s
}

// SetAdAvailOffset sets the AdAvailOffset field's value.
func (s *Esam) SetAdAvailOffset(v int64) *Esam {
	s.AdAvailOffset = &v
	return s
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *Esam) SetPasswordParam(v string) *Esam {
	s.PasswordParam = &v
	return s
}

// SetPoisEndpoint sets the PoisEndpoint field's value.
func (s *Esam) SetPoisEndpoint(v string) *Esam {
	s.PoisEndpoint = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Esam) SetUsername(v string) *Esam {
	s.Username = &v
	return s
}

// SetZoneIdentity sets the ZoneIdentity field's value.
func (s *Esam) SetZoneIdentity(v string) *Esam {
	s.ZoneIdentity = &v
	return s
}

type EventBridgeRuleTemplateGroupSummary struct {
	_ struct{} `type:"structure"`

	// An eventbridge rule template group's ARN (Amazon Resource Name)
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A resource's optional description.
	Description *string `locationName:"description" type:"string"`

	// An eventbridge rule template group's id. AWS provided template groups have
	// ids that start with `aws-`
	//
	// Id is a required field
	Id *string `locationName:"id" min:"7" type:"string" required:"true"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// A resource's name. Names must be unique within the scope of a resource type
	// in a specific region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The number of templates in a group.
	//
	// TemplateCount is a required field
	TemplateCount *int64 `locationName:"templateCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetArn(v string) *EventBridgeRuleTemplateGroupSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetCreatedAt(v time.Time) *EventBridgeRuleTemplateGroupSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetDescription(v string) *EventBridgeRuleTemplateGroupSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetId(v string) *EventBridgeRuleTemplateGroupSummary {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetModifiedAt(v time.Time) *EventBridgeRuleTemplateGroupSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetName(v string) *EventBridgeRuleTemplateGroupSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetTags(v map[string]*string) *EventBridgeRuleTemplateGroupSummary {
	s.Tags = v
	return s
}

// SetTemplateCount sets the TemplateCount field's value.
func (s *EventBridgeRuleTemplateGroupSummary) SetTemplateCount(v int64) *EventBridgeRuleTemplateGroupSummary {
	s.TemplateCount = &v
	return s
}

type EventBridgeRuleTemplateSummary struct {
	_ struct{} `type:"structure"`

	// An eventbridge rule template's ARN (Amazon Resource Name)
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A resource's optional description.
	Description *string `locationName:"description" type:"string"`

	// The number of targets configured to send matching events.
	//
	// EventTargetCount is a required field
	EventTargetCount *int64 `locationName:"eventTargetCount" type:"integer" required:"true"`

	// The type of event to match with the rule.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventBridgeRuleTemplateEventType"`

	// An eventbridge rule template group's id. AWS provided template groups have
	// ids that start with `aws-`
	//
	// GroupId is a required field
	GroupId *string `locationName:"groupId" min:"7" type:"string" required:"true"`

	// An eventbridge rule template's id. AWS provided templates have ids that start
	// with `aws-`
	//
	// Id is a required field
	Id *string `locationName:"id" min:"7" type:"string" required:"true"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	// A resource's name. Names must be unique within the scope of a resource type
	// in a specific region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventBridgeRuleTemplateSummary) SetArn(v string) *EventBridgeRuleTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EventBridgeRuleTemplateSummary) SetCreatedAt(v time.Time) *EventBridgeRuleTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EventBridgeRuleTemplateSummary) SetDescription(v string) *EventBridgeRuleTemplateSummary {
	s.Description = &v
	return s
}

// SetEventTargetCount sets the EventTargetCount field's value.
func (s *EventBridgeRuleTemplateSummary) SetEventTargetCount(v int64) *EventBridgeRuleTemplateSummary {
	s.EventTargetCount = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *EventBridgeRuleTemplateSummary) SetEventType(v string) *EventBridgeRuleTemplateSummary {
	s.EventType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *EventBridgeRuleTemplateSummary) SetGroupId(v string) *EventBridgeRuleTemplateSummary {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *EventBridgeRuleTemplateSummary) SetId(v string) *EventBridgeRuleTemplateSummary {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *EventBridgeRuleTemplateSummary) SetModifiedAt(v time.Time) *EventBridgeRuleTemplateSummary {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventBridgeRuleTemplateSummary) SetName(v string) *EventBridgeRuleTemplateSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventBridgeRuleTemplateSummary) SetTags(v map[string]*string) *EventBridgeRuleTemplateSummary {
	s.Tags = v
	return s
}

// The target to which to send matching events.
type EventBridgeRuleTemplateTarget struct {
	_ struct{} `type:"structure"`

	// Target ARNs must be either an SNS topic or CloudWatch log group.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventBridgeRuleTemplateTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventBridgeRuleTemplateTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventBridgeRuleTemplateTarget"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *EventBridgeRuleTemplateTarget) SetArn(v string) *EventBridgeRuleTemplateTarget {
	s.Arn = &v
	return s
}

// Failover Condition settings. There can be multiple failover conditions inside
// AutomaticInputFailoverSettings.
type FailoverCondition struct {
	_ struct{} `type:"structure"`

	// Failover condition type-specific settings.
	FailoverConditionSettings *FailoverConditionSettings `locationName:"failoverConditionSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailoverCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailoverCondition"}
	if s.FailoverConditionSettings != nil {
		if err := s.FailoverConditionSettings.Validate(); err != nil {
			invalidParams.AddNested("FailoverConditionSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailoverConditionSettings sets the FailoverConditionSettings field's value.
func (s *FailoverCondition) SetFailoverConditionSettings(v *FailoverConditionSettings) *FailoverCondition {
	s.FailoverConditionSettings = v
	return s
}

// Settings for one failover condition.
type FailoverConditionSettings struct {
	_ struct{} `type:"structure"`

	// MediaLive will perform a failover if the specified audio selector is silent
	// for the specified period.
	AudioSilenceSettings *AudioSilenceFailoverSettings `locationName:"audioSilenceSettings" type:"structure"`

	// MediaLive will perform a failover if content is not detected in this input
	// for the specified period.
	InputLossSettings *InputLossFailoverSettings `locationName:"inputLossSettings" type:"structure"`

	// MediaLive will perform a failover if content is considered black for the
	// specified period.
	VideoBlackSettings *VideoBlackFailoverSettings `locationName:"videoBlackSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConditionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverConditionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailoverConditionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailoverConditionSettings"}
	if s.AudioSilenceSettings != nil {
		if err := s.AudioSilenceSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioSilenceSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputLossSettings != nil {
		if err := s.InputLossSettings.Validate(); err != nil {
			invalidParams.AddNested("InputLossSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.VideoBlackSettings != nil {
		if err := s.VideoBlackSettings.Validate(); err != nil {
			invalidParams.AddNested("VideoBlackSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSilenceSettings sets the AudioSilenceSettings field's value.
func (s *FailoverConditionSettings) SetAudioSilenceSettings(v *AudioSilenceFailoverSettings) *FailoverConditionSettings {
	s.AudioSilenceSettings = v
	return s
}

// SetInputLossSettings sets the InputLossSettings field's value.
func (s *FailoverConditionSettings) SetInputLossSettings(v *InputLossFailoverSettings) *FailoverConditionSettings {
	s.InputLossSettings = v
	return s
}

// SetVideoBlackSettings sets the VideoBlackSettings field's value.
func (s *FailoverConditionSettings) SetVideoBlackSettings(v *VideoBlackFailoverSettings) *FailoverConditionSettings {
	s.VideoBlackSettings = v
	return s
}

// Feature Activations
type FeatureActivations struct {
	_ struct{} `type:"structure"`

	// Enables the Input Prepare feature. You can create Input Prepare actions in
	// the schedule only if this feature is enabled.If you disable the feature on
	// an existing schedule, make sure that you first delete all input prepare actions
	// from the schedule.
	InputPrepareScheduleActions *string `locationName:"inputPrepareScheduleActions" type:"string" enum:"FeatureActivationsInputPrepareScheduleActions"`

	// Enables the output static image overlay feature. Enabling this feature allows
	// you to send channel schedule updatesto display/clear/modify image overlays
	// on an output-by-output bases.
	OutputStaticImageOverlayScheduleActions *string `locationName:"outputStaticImageOverlayScheduleActions" type:"string" enum:"FeatureActivationsOutputStaticImageOverlayScheduleActions"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureActivations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureActivations) GoString() string {
	return s.String()
}

// SetInputPrepareScheduleActions sets the InputPrepareScheduleActions field's value.
func (s *FeatureActivations) SetInputPrepareScheduleActions(v string) *FeatureActivations {
	s.InputPrepareScheduleActions = &v
	return s
}

// SetOutputStaticImageOverlayScheduleActions sets the OutputStaticImageOverlayScheduleActions field's value.
func (s *FeatureActivations) SetOutputStaticImageOverlayScheduleActions(v string) *FeatureActivations {
	s.OutputStaticImageOverlayScheduleActions = &v
	return s
}

// Fec Output Settings
type FecOutputSettings struct {
	_ struct{} `type:"structure"`

	// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The
	// number of transport stream packets per column error correction packet. Must
	// be between 4 and 20, inclusive.
	ColumnDepth *int64 `locationName:"columnDepth" min:"4" type:"integer"`

	// Enables column only or column and row based FEC
	IncludeFec *string `locationName:"includeFec" type:"string" enum:"FecOutputIncludeFec"`

	// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must
	// be between 1 and 20, inclusive. If only Column FEC is used, then larger values
	// increase robustness. If Row FEC is used, then this is the number of transport
	// stream packets per row error correction packet, and the value must be between
	// 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column,
	// this value must be 1 to 20, inclusive.
	RowLength *int64 `locationName:"rowLength" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FecOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FecOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FecOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FecOutputSettings"}
	if s.ColumnDepth != nil && *s.ColumnDepth < 4 {
		invalidParams.Add(request.NewErrParamMinValue("ColumnDepth", 4))
	}
	if s.RowLength != nil && *s.RowLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RowLength", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnDepth sets the ColumnDepth field's value.
func (s *FecOutputSettings) SetColumnDepth(v int64) *FecOutputSettings {
	s.ColumnDepth = &v
	return s
}

// SetIncludeFec sets the IncludeFec field's value.
func (s *FecOutputSettings) SetIncludeFec(v string) *FecOutputSettings {
	s.IncludeFec = &v
	return s
}

// SetRowLength sets the RowLength field's value.
func (s *FecOutputSettings) SetRowLength(v int64) *FecOutputSettings {
	s.RowLength = &v
	return s
}

// Start time for the action.
type FixedModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Start time for the action to start in the channel. (Not the time for the
	// action to be added to the schedule: actions are always added to the schedule
	// immediately.) UTC format: yyyy-mm-ddThh:mm:ss.nnnZ. All the letters are digits
	// (for example, mm might be 01) except for the two constants "T" for time and
	// "Z" for "UTC format".
	//
	// Time is a required field
	Time *string `locationName:"time" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedModeScheduleActionStartSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedModeScheduleActionStartSettings"}
	if s.Time == nil {
		invalidParams.Add(request.NewErrParamRequired("Time"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTime sets the Time field's value.
func (s *FixedModeScheduleActionStartSettings) SetTime(v string) *FixedModeScheduleActionStartSettings {
	s.Time = &v
	return s
}

// Fmp4 Hls Settings
type Fmp4HlsSettings struct {
	_ struct{} `type:"structure"`

	// List all the audio groups that are used with the video output stream. Input
	// all the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string `locationName:"audioRenditionSets" type:"string"`

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in
	// the output.
	NielsenId3Behavior *string `locationName:"nielsenId3Behavior" type:"string" enum:"Fmp4NielsenId3Behavior"`

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior *string `locationName:"timedMetadataBehavior" type:"string" enum:"Fmp4TimedMetadataBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fmp4HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Fmp4HlsSettings) GoString() string {
	return s.String()
}

// SetAudioRenditionSets sets the AudioRenditionSets field's value.
func (s *Fmp4HlsSettings) SetAudioRenditionSets(v string) *Fmp4HlsSettings {
	s.AudioRenditionSets = &v
	return s
}

// SetNielsenId3Behavior sets the NielsenId3Behavior field's value.
func (s *Fmp4HlsSettings) SetNielsenId3Behavior(v string) *Fmp4HlsSettings {
	s.NielsenId3Behavior = &v
	return s
}

// SetTimedMetadataBehavior sets the TimedMetadataBehavior field's value.
func (s *Fmp4HlsSettings) SetTimedMetadataBehavior(v string) *Fmp4HlsSettings {
	s.TimedMetadataBehavior = &v
	return s
}

// Settings to specify if an action follows another.
type FollowModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`

	// Identifies whether this action starts relative to the start or relative to
	// the end of the reference action.
	//
	// FollowPoint is a required field
	FollowPoint *string `locationName:"followPoint" type:"string" required:"true" enum:"FollowPoint"`

	// The action name of another action that this one refers to.
	//
	// ReferenceActionName is a required field
	ReferenceActionName *string `locationName:"referenceActionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FollowModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FollowModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FollowModeScheduleActionStartSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FollowModeScheduleActionStartSettings"}
	if s.FollowPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("FollowPoint"))
	}
	if s.ReferenceActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceActionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFollowPoint sets the FollowPoint field's value.
func (s *FollowModeScheduleActionStartSettings) SetFollowPoint(v string) *FollowModeScheduleActionStartSettings {
	s.FollowPoint = &v
	return s
}

// SetReferenceActionName sets the ReferenceActionName field's value.
func (s *FollowModeScheduleActionStartSettings) SetReferenceActionName(v string) *FollowModeScheduleActionStartSettings {
	s.ReferenceActionName = &v
	return s
}

type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Frame Capture Cdn Settings
type FrameCaptureCdnSettings struct {
	_ struct{} `type:"structure"`

	// Frame Capture S3 Settings
	FrameCaptureS3Settings *FrameCaptureS3Settings `locationName:"frameCaptureS3Settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureCdnSettings) GoString() string {
	return s.String()
}

// SetFrameCaptureS3Settings sets the FrameCaptureS3Settings field's value.
func (s *FrameCaptureCdnSettings) SetFrameCaptureS3Settings(v *FrameCaptureS3Settings) *FrameCaptureCdnSettings {
	s.FrameCaptureS3Settings = v
	return s
}

// Frame Capture Group Settings
type FrameCaptureGroupSettings struct {
	_ struct{} `type:"structure"`

	// The destination for the frame capture files. Either the URI for an Amazon
	// S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-)
	// or the URI for a MediaStore container, plus a file name prefix (for example,
	// mediastoressl://sportsDelivery/20180820/curling-). The final file names consist
	// of the prefix from the destination field (for example, "curling-") + name
	// modifier + the counter (5 digits, starting from 00001) + extension (which
	// is always .jpg). For example, curling-low.00001.jpg
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Parameters that control interactions with the CDN.
	FrameCaptureCdnSettings *FrameCaptureCdnSettings `locationName:"frameCaptureCdnSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrameCaptureGroupSettings"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *FrameCaptureGroupSettings) SetDestination(v *OutputLocationRef) *FrameCaptureGroupSettings {
	s.Destination = v
	return s
}

// SetFrameCaptureCdnSettings sets the FrameCaptureCdnSettings field's value.
func (s *FrameCaptureGroupSettings) SetFrameCaptureCdnSettings(v *FrameCaptureCdnSettings) *FrameCaptureGroupSettings {
	s.FrameCaptureCdnSettings = v
	return s
}

// Frame Capture Hls Settings
type FrameCaptureHlsSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureHlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureHlsSettings) GoString() string {
	return s.String()
}

// Frame Capture Output Settings
type FrameCaptureOutputSettings struct {
	_ struct{} `type:"structure"`

	// Required if the output group contains more than one output. This modifier
	// forms part of the output file name.
	NameModifier *string `locationName:"nameModifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureOutputSettings) GoString() string {
	return s.String()
}

// SetNameModifier sets the NameModifier field's value.
func (s *FrameCaptureOutputSettings) SetNameModifier(v string) *FrameCaptureOutputSettings {
	s.NameModifier = &v
	return s
}

// Frame Capture S3 Settings
type FrameCaptureS3Settings struct {
	_ struct{} `type:"structure"`

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl *string `locationName:"cannedAcl" type:"string" enum:"S3CannedAcl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureS3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureS3Settings) GoString() string {
	return s.String()
}

// SetCannedAcl sets the CannedAcl field's value.
func (s *FrameCaptureS3Settings) SetCannedAcl(v string) *FrameCaptureS3Settings {
	s.CannedAcl = &v
	return s
}

// Frame Capture Settings
type FrameCaptureSettings struct {
	_ struct{} `type:"structure"`

	// The frequency at which to capture frames for inclusion in the output. May
	// be specified in either seconds or milliseconds, as specified by captureIntervalUnits.
	CaptureInterval *int64 `locationName:"captureInterval" min:"1" type:"integer"`

	// Unit for the frame capture interval.
	CaptureIntervalUnits *string `locationName:"captureIntervalUnits" type:"string" enum:"FrameCaptureIntervalUnit"`

	// Timecode burn-in settings
	TimecodeBurninSettings *TimecodeBurninSettings `locationName:"timecodeBurninSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameCaptureSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameCaptureSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrameCaptureSettings"}
	if s.CaptureInterval != nil && *s.CaptureInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CaptureInterval", 1))
	}
	if s.TimecodeBurninSettings != nil {
		if err := s.TimecodeBurninSettings.Validate(); err != nil {
			invalidParams.AddNested("TimecodeBurninSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptureInterval sets the CaptureInterval field's value.
func (s *FrameCaptureSettings) SetCaptureInterval(v int64) *FrameCaptureSettings {
	s.CaptureInterval = &v
	return s
}

// SetCaptureIntervalUnits sets the CaptureIntervalUnits field's value.
func (s *FrameCaptureSettings) SetCaptureIntervalUnits(v string) *FrameCaptureSettings {
	s.CaptureIntervalUnits = &v
	return s
}

// SetTimecodeBurninSettings sets the TimecodeBurninSettings field's value.
func (s *FrameCaptureSettings) SetTimecodeBurninSettings(v *TimecodeBurninSettings) *FrameCaptureSettings {
	s.TimecodeBurninSettings = v
	return s
}

type GatewayTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayTimeoutException) GoString() string {
	return s.String()
}

func newErrorGatewayTimeoutException(v protocol.ResponseMetadata) error {
	return &GatewayTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GatewayTimeoutException) Code() string {
	return "GatewayTimeoutException"
}

// Message returns the exception's message.
func (s *GatewayTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GatewayTimeoutException) OrigErr() error {
	return nil
}

func (s *GatewayTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GatewayTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GatewayTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetCloudWatchAlarmTemplateGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudWatchAlarmTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudWatchAlarmTemplateGroupInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetCloudWatchAlarmTemplateGroupInput) SetIdentifier(v string) *GetCloudWatchAlarmTemplateGroupInput {
	s.Identifier = &v
	return s
}

type GetCloudWatchAlarmTemplateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetArn(v string) *GetCloudWatchAlarmTemplateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetCreatedAt(v time.Time) *GetCloudWatchAlarmTemplateGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetDescription(v string) *GetCloudWatchAlarmTemplateGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetId(v string) *GetCloudWatchAlarmTemplateGroupOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetModifiedAt(v time.Time) *GetCloudWatchAlarmTemplateGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetName(v string) *GetCloudWatchAlarmTemplateGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCloudWatchAlarmTemplateGroupOutput) SetTags(v map[string]*string) *GetCloudWatchAlarmTemplateGroupOutput {
	s.Tags = v
	return s
}

type GetCloudWatchAlarmTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudWatchAlarmTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCloudWatchAlarmTemplateInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetCloudWatchAlarmTemplateInput) SetIdentifier(v string) *GetCloudWatchAlarmTemplateInput {
	s.Identifier = &v
	return s
}

type GetCloudWatchAlarmTemplateOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	// The comparison operator used to compare the specified statistic and the threshold.
	ComparisonOperator *string `locationName:"comparisonOperator" type:"string" enum:"CloudWatchAlarmTemplateComparisonOperator"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	DatapointsToAlarm *int64 `locationName:"datapointsToAlarm" min:"1" type:"integer"`

	Description *string `locationName:"description" type:"string"`

	EvaluationPeriods *int64 `locationName:"evaluationPeriods" min:"1" type:"integer"`

	GroupId *string `locationName:"groupId" min:"7" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	MetricName *string `locationName:"metricName" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	Period *int64 `locationName:"period" min:"10" type:"integer"`

	// The statistic to apply to the alarm's metric data.
	Statistic *string `locationName:"statistic" type:"string" enum:"CloudWatchAlarmTemplateStatistic"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The resource type this template should dynamically generate cloudwatch metric
	// alarms for.
	TargetResourceType *string `locationName:"targetResourceType" type:"string" enum:"CloudWatchAlarmTemplateTargetResourceType"`

	Threshold *float64 `locationName:"threshold" type:"double"`

	// Specifies how missing data points are treated when evaluating the alarm's
	// condition.
	TreatMissingData *string `locationName:"treatMissingData" type:"string" enum:"CloudWatchAlarmTemplateTreatMissingData"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCloudWatchAlarmTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetArn(v string) *GetCloudWatchAlarmTemplateOutput {
	s.Arn = &v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetComparisonOperator(v string) *GetCloudWatchAlarmTemplateOutput {
	s.ComparisonOperator = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetCreatedAt(v time.Time) *GetCloudWatchAlarmTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetDatapointsToAlarm sets the DatapointsToAlarm field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetDatapointsToAlarm(v int64) *GetCloudWatchAlarmTemplateOutput {
	s.DatapointsToAlarm = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetDescription(v string) *GetCloudWatchAlarmTemplateOutput {
	s.Description = &v
	return s
}

// SetEvaluationPeriods sets the EvaluationPeriods field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetEvaluationPeriods(v int64) *GetCloudWatchAlarmTemplateOutput {
	s.EvaluationPeriods = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetGroupId(v string) *GetCloudWatchAlarmTemplateOutput {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetId(v string) *GetCloudWatchAlarmTemplateOutput {
	s.Id = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetMetricName(v string) *GetCloudWatchAlarmTemplateOutput {
	s.MetricName = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetModifiedAt(v time.Time) *GetCloudWatchAlarmTemplateOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetName(v string) *GetCloudWatchAlarmTemplateOutput {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetPeriod(v int64) *GetCloudWatchAlarmTemplateOutput {
	s.Period = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetStatistic(v string) *GetCloudWatchAlarmTemplateOutput {
	s.Statistic = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetTags(v map[string]*string) *GetCloudWatchAlarmTemplateOutput {
	s.Tags = v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetTargetResourceType(v string) *GetCloudWatchAlarmTemplateOutput {
	s.TargetResourceType = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetThreshold(v float64) *GetCloudWatchAlarmTemplateOutput {
	s.Threshold = &v
	return s
}

// SetTreatMissingData sets the TreatMissingData field's value.
func (s *GetCloudWatchAlarmTemplateOutput) SetTreatMissingData(v string) *GetCloudWatchAlarmTemplateOutput {
	s.TreatMissingData = &v
	return s
}

type GetEventBridgeRuleTemplateGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventBridgeRuleTemplateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventBridgeRuleTemplateGroupInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetEventBridgeRuleTemplateGroupInput) SetIdentifier(v string) *GetEventBridgeRuleTemplateGroupInput {
	s.Identifier = &v
	return s
}

type GetEventBridgeRuleTemplateGroupOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetArn(v string) *GetEventBridgeRuleTemplateGroupOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetCreatedAt(v time.Time) *GetEventBridgeRuleTemplateGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetDescription(v string) *GetEventBridgeRuleTemplateGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetId(v string) *GetEventBridgeRuleTemplateGroupOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetModifiedAt(v time.Time) *GetEventBridgeRuleTemplateGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetName(v string) *GetEventBridgeRuleTemplateGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEventBridgeRuleTemplateGroupOutput) SetTags(v map[string]*string) *GetEventBridgeRuleTemplateGroupOutput {
	s.Tags = v
	return s
}

type GetEventBridgeRuleTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventBridgeRuleTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventBridgeRuleTemplateInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetEventBridgeRuleTemplateInput) SetIdentifier(v string) *GetEventBridgeRuleTemplateInput {
	s.Identifier = &v
	return s
}

type GetEventBridgeRuleTemplateOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	EventTargets []*EventBridgeRuleTemplateTarget `locationName:"eventTargets" type:"list"`

	// The type of event to match with the rule.
	EventType *string `locationName:"eventType" type:"string" enum:"EventBridgeRuleTemplateEventType"`

	GroupId *string `locationName:"groupId" min:"7" type:"string"`

	Id *string `locationName:"id" min:"7" type:"string"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventBridgeRuleTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetArn(v string) *GetEventBridgeRuleTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetCreatedAt(v time.Time) *GetEventBridgeRuleTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetDescription(v string) *GetEventBridgeRuleTemplateOutput {
	s.Description = &v
	return s
}

// SetEventTargets sets the EventTargets field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetEventTargets(v []*EventBridgeRuleTemplateTarget) *GetEventBridgeRuleTemplateOutput {
	s.EventTargets = v
	return s
}

// SetEventType sets the EventType field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetEventType(v string) *GetEventBridgeRuleTemplateOutput {
	s.EventType = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetGroupId(v string) *GetEventBridgeRuleTemplateOutput {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetId(v string) *GetEventBridgeRuleTemplateOutput {
	s.Id = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetModifiedAt(v time.Time) *GetEventBridgeRuleTemplateOutput {
	s.ModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetName(v string) *GetEventBridgeRuleTemplateOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEventBridgeRuleTemplateOutput) SetTags(v map[string]*string) *GetEventBridgeRuleTemplateOutput {
	s.Tags = v
	return s
}

type GetSignalMapInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSignalMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSignalMapInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetSignalMapInput) SetIdentifier(v string) *GetSignalMapInput {
	s.Identifier = &v
	return s
}

type GetSignalMapOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `locationName:"arn" type:"string"`

	CloudWatchAlarmTemplateGroupIds []*string `locationName:"cloudWatchAlarmTemplateGroupIds" type:"list"`

	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	Description *string `locationName:"description" type:"string"`

	DiscoveryEntryPointArn *string `locationName:"discoveryEntryPointArn" min:"1" type:"string"`

	ErrorMessage *string `locationName:"errorMessage" min:"1" type:"string"`

	EventBridgeRuleTemplateGroupIds []*string `locationName:"eventBridgeRuleTemplateGroupIds" type:"list"`

	// A map representing an incomplete AWS media workflow as a graph.
	FailedMediaResourceMap map[string]*MediaResource `locationName:"failedMediaResourceMap" type:"map"`

	Id *string `locationName:"id" min:"7" type:"string"`

	LastDiscoveredAt *time.Time `locationName:"lastDiscoveredAt" type:"timestamp" timestampFormat:"iso8601"`

	// Represents the latest successful monitor deployment of a signal map.
	LastSuccessfulMonitorDeployment *SuccessfulMonitorDeployment `locationName:"lastSuccessfulMonitorDeployment" type:"structure"`

	// A map representing an AWS media workflow as a graph.
	MediaResourceMap map[string]*MediaResource `locationName:"mediaResourceMap" type:"map"`

	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" timestampFormat:"iso8601"`

	MonitorChangesPendingDeployment *bool `locationName:"monitorChangesPendingDeployment" type:"boolean"`

	// Represents the latest monitor deployment of a signal map.
	MonitorDeployment *MonitorDeployment `locationName:"monitorDeployment" type:"structure"`

	Name *string `locationName:"name" min:"1" type:"string"`

	// A signal map's current status which is dependent on its lifecycle actions
	// or associated jobs.
	Status *string `locationName:"status" type:"string" enum:"SignalMapStatus"`

	// Represents the tags associated with a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSignalMapOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetSignalMapOutput) SetArn(v string) *GetSignalMapOutput {
	s.Arn = &v
	return s
}

// SetCloudWatchAlarmTemplateGroupIds sets the CloudWatchAlarmTemplateGroupIds field's value.
func (s *GetSignalMapOutput) SetCloudWatchAlarmTemplateGroupIds(v []*string) *GetSignalMapOutput {
	s.CloudWatchAlarmTemplateGroupIds = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSignalMapOutput) SetCreatedAt(v time.Time) *GetSignalMapOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetSignalMapOutput) SetDescription(v string) *GetSignalMapOutput {
	s.Description = &v
	return s
}

// SetDiscoveryEntryPointArn sets the DiscoveryEntryPointArn field's value.
func (s *GetSignalMapOutput) SetDiscoveryEntryPointArn(v string) *GetSignalMapOutput {
	s.DiscoveryEntryPointArn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetSignalMapOutput) SetErrorMessage(v string) *GetSignalMapOutput {
	s.ErrorMessage = &v
	return s
}

// SetEventBridgeRuleTemplateGroupIds sets the EventBridgeRuleTemplateGroupIds field's value.
func (s *GetSignalMapOutput) SetEventBridgeRuleTemplateGroupIds(v []*string) *GetSignalMapOutput {
	s.EventBridgeRuleTemplateGroupIds = v
	return s
}

// SetFailedMediaResourceMap sets the FailedMediaResourceMap field's value.
func (s *GetSignalMapOutput) SetFailedMediaResourceMap(v map[string]*MediaResource) *GetSignalMapOutput {
	s.FailedMediaResourceMap = v
	return s
}

// SetId sets the Id field's value.
func (s *GetSignalMapOutput) SetId(v string) *GetSignalMapOutput {
	s.Id = &v
	return s
}

// SetLastDiscoveredAt sets the LastDiscoveredAt field's value.
func (s *GetSignalMapOutput) SetLastDiscoveredAt(v time.Time) *GetSignalMapOutput {
	s.LastDiscoveredAt = &v
	return s
}

// SetLastSuccessfulMonitorDeployment sets the LastSuccessfulMonitorDeployment field's value.
func (s *GetSignalMapOutput) SetLastSuccessfulMonitorDeployment(v *SuccessfulMonitorDeployment) *GetSignalMapOutput {
	s.LastSuccessfulMonitorDeployment = v
	return s
}

// SetMediaResourceMap sets the MediaResourceMap field's value.
func (s *GetSignalMapOutput) SetMediaResourceMap(v map[string]*MediaResource) *GetSignalMapOutput {
	s.MediaResourceMap = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetSignalMapOutput) SetModifiedAt(v time.Time) *GetSignalMapOutput {
	s.ModifiedAt = &v
	return s
}

// SetMonitorChangesPendingDeployment sets the MonitorChangesPendingDeployment field's value.
func (s *GetSignalMapOutput) SetMonitorChangesPendingDeployment(v bool) *GetSignalMapOutput {
	s.MonitorChangesPendingDeployment = &v
	return s
}

// SetMonitorDeployment sets the MonitorDeployment field's value.
func (s *GetSignalMapOutput) SetMonitorDeployment(v *MonitorDeployment) *GetSignalMapOutput {
	s.MonitorDeployment = v
	return s
}

// SetName sets the Name field's value.
func (s *GetSignalMapOutput) SetName(v string) *GetSignalMapOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSignalMapOutput) SetStatus(v string) *GetSignalMapOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSignalMapOutput) SetTags(v map[string]*string) *GetSignalMapOutput {
	s.Tags = v
	return s
}

// Global Configuration
type GlobalConfiguration struct {
	_ struct{} `type:"structure"`

	// Value to set the initial audio gain for the Live Event.
	InitialAudioGain *int64 `locationName:"initialAudioGain" type:"integer"`

	// Indicates the action to take when the current input completes (e.g. end-of-file).
	// When switchAndLoopInputs is configured the encoder will restart at the beginning
	// of the first input. When "none" is configured the encoder will transcode
	// either black, a solid color, or a user specified slate images per the "Input
	// Loss Behavior" configuration until the next input switch occurs (which is
	// controlled through the Channel Schedule API).
	InputEndAction *string `locationName:"inputEndAction" type:"string" enum:"GlobalConfigurationInputEndAction"`

	// Settings for system actions when input is lost.
	InputLossBehavior *InputLossBehavior `locationName:"inputLossBehavior" type:"structure"`

	// Indicates how MediaLive pipelines are synchronized.PIPELINE_LOCKING - MediaLive
	// will attempt to synchronize the output of each pipeline to the other.EPOCH_LOCKING
	// - MediaLive will attempt to synchronize the output of each pipeline to the
	// Unix epoch.
	OutputLockingMode *string `locationName:"outputLockingMode" type:"string" enum:"GlobalConfigurationOutputLockingMode"`

	// Advanced output locking settings
	OutputLockingSettings *OutputLockingSettings `locationName:"outputLockingSettings" type:"structure"`

	// Indicates whether the rate of frames emitted by the Live encoder should be
	// paced by its system clock (which optionally may be locked to another source
	// via NTP) or should be locked to the clock of the source that is providing
	// the input stream.
	OutputTimingSource *string `locationName:"outputTimingSource" type:"string" enum:"GlobalConfigurationOutputTimingSource"`

	// Adjusts video input buffer for streams with very low video framerates. This
	// is commonly set to enabled for music channels with less than one video frame
	// per second.
	SupportLowFramerateInputs *string `locationName:"supportLowFramerateInputs" type:"string" enum:"GlobalConfigurationLowFramerateInputs"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlobalConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalConfiguration"}
	if s.InitialAudioGain != nil && *s.InitialAudioGain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("InitialAudioGain", -60))
	}
	if s.InputLossBehavior != nil {
		if err := s.InputLossBehavior.Validate(); err != nil {
			invalidParams.AddNested("InputLossBehavior", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitialAudioGain sets the InitialAudioGain field's value.
func (s *GlobalConfiguration) SetInitialAudioGain(v int64) *GlobalConfiguration {
	s.InitialAudioGain = &v
	return s
}

// SetInputEndAction sets the InputEndAction field's value.
func (s *GlobalConfiguration) SetInputEndAction(v string) *GlobalConfiguration {
	s.InputEndAction = &v
	return s
}

// SetInputLossBehavior sets the InputLossBehavior field's value.
func (s *GlobalConfiguration) SetInputLossBehavior(v *InputLossBehavior) *GlobalConfiguration {
	s.InputLossBehavior = v
	return s
}

// SetOutputLockingMode sets the OutputLockingMode field's value.
func (s *GlobalConfiguration) SetOutputLockingMode(v string) *GlobalConfiguration {
	s.OutputLockingMode = &v
	return s
}

// SetOutputLockingSettings sets the OutputLockingSettings field's value.
func (s *GlobalConfiguration) SetOutputLockingSettings(v *OutputLockingSettings) *GlobalConfiguration {
	s.OutputLockingSettings = v
	return s
}

// SetOutputTimingSource sets the OutputTimingSource field's value.
func (s *GlobalConfiguration) SetOutputTimingSource(v string) *GlobalConfiguration {
	s.OutputTimingSource = &v
	return s
}

// SetSupportLowFramerateInputs sets the SupportLowFramerateInputs field's value.
func (s *GlobalConfiguration) SetSupportLowFramerateInputs(v string) *GlobalConfiguration {
	s.SupportLowFramerateInputs = &v
	return s
}

// H264 Color Space Settings
type H264ColorSpaceSettings struct {
	_ struct{} `type:"structure"`

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings `locationName:"colorSpacePassthroughSettings" type:"structure"`

	// Rec601 Settings
	Rec601Settings *Rec601Settings `locationName:"rec601Settings" type:"structure"`

	// Rec709 Settings
	Rec709Settings *Rec709Settings `locationName:"rec709Settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264ColorSpaceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264ColorSpaceSettings) GoString() string {
	return s.String()
}

// SetColorSpacePassthroughSettings sets the ColorSpacePassthroughSettings field's value.
func (s *H264ColorSpaceSettings) SetColorSpacePassthroughSettings(v *ColorSpacePassthroughSettings) *H264ColorSpaceSettings {
	s.ColorSpacePassthroughSettings = v
	return s
}

// SetRec601Settings sets the Rec601Settings field's value.
func (s *H264ColorSpaceSettings) SetRec601Settings(v *Rec601Settings) *H264ColorSpaceSettings {
	s.Rec601Settings = v
	return s
}

// SetRec709Settings sets the Rec709Settings field's value.
func (s *H264ColorSpaceSettings) SetRec709Settings(v *Rec709Settings) *H264ColorSpaceSettings {
	s.Rec709Settings = v
	return s
}

// H264 Filter Settings
type H264FilterSettings struct {
	_ struct{} `type:"structure"`

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings `locationName:"temporalFilterSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264FilterSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264FilterSettings) GoString() string {
	return s.String()
}

// SetTemporalFilterSettings sets the TemporalFilterSettings field's value.
func (s *H264FilterSettings) SetTemporalFilterSettings(v *TemporalFilterSettings) *H264FilterSettings {
	s.TemporalFilterSettings = v
	return s
}

// H264 Settings
type H264Settings struct {
	_ struct{} `type:"structure"`

	// Enables or disables adaptive quantization, which is a technique MediaLive
	// can apply to video on a frame-by-frame basis to produce more compression
	// without losing quality. There are three types of adaptive quantization: flicker,
	// spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended.
	// For each type of AQ, MediaLive will determine if AQ is needed, and if so,
	// the appropriate strength. Set a strength (a value other than Auto or Disable).
	// This strength will apply to any of the AQ fields that you choose to enable.
	// Set to Disabled to disable all types of adaptive quantization.
	AdaptiveQuantization *string `locationName:"adaptiveQuantization" type:"string" enum:"H264AdaptiveQuantization"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling *string `locationName:"afdSignaling" type:"string" enum:"AfdSignaling"`

	// Average bitrate in bits/second. Required when the rate control mode is VBR
	// or CBR. Not used for QVBR. In an MS Smooth output group, each output must
	// have a unique value when its bitrate is rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"1000" type:"integer"`

	// Percentage of the buffer that should initially be filled (HRD buffer model).
	BufFillPct *int64 `locationName:"bufFillPct" type:"integer"`

	// Size of buffer (HRD buffer model) in bits.
	BufSize *int64 `locationName:"bufSize" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata *string `locationName:"colorMetadata" type:"string" enum:"H264ColorMetadata"`

	// Color Space settings
	ColorSpaceSettings *H264ColorSpaceSettings `locationName:"colorSpaceSettings" type:"structure"`

	// Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
	EntropyEncoding *string `locationName:"entropyEncoding" type:"string" enum:"H264EntropyEncoding"`

	// Optional filters that you can apply to an encode.
	FilterSettings *H264FilterSettings `locationName:"filterSettings" type:"structure"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd *string `locationName:"fixedAfd" type:"string" enum:"FixedAfd"`

	// Flicker AQ makes adjustments within each frame to reduce flicker or 'pop'
	// on I-frames. The value to enter in this field depends on the value in the
	// Adaptive quantization field: If you have set the Adaptive quantization field
	// to Auto, MediaLive ignores any value in this field. MediaLive will determine
	// if flicker AQ is appropriate and will apply the appropriate strength. If
	// you have set the Adaptive quantization field to a strength, you can set this
	// field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using
	// the specified strength. Disabled: MediaLive won't apply flicker AQ. If you
	// have set the Adaptive quantization to Disabled, MediaLive ignores any value
	// in this field and doesn't apply flicker AQ.
	FlickerAq *string `locationName:"flickerAq" type:"string" enum:"H264FlickerAq"`

	// This setting applies only when scan type is "interlaced." It controls whether
	// coding is performed on a field basis or on a frame basis. (When the video
	// is progressive, the coding is always performed on a frame basis.)enabled:
	// Force MediaLive to code on a field basis, so that odd and even sets of fields
	// are coded separately.disabled: Code the two sets of fields separately (on
	// a field basis) or together (on a frame basis using PAFF), depending on what
	// is most appropriate for the content.
	ForceFieldPictures *string `locationName:"forceFieldPictures" type:"string" enum:"H264ForceFieldPictures"`

	// This field indicates how the output video frame rate is specified. If "specified"
	// is selected then the output video frame rate is determined by framerateNumerator
	// and framerateDenominator, else if "initializeFromSource" is selected then
	// the output video frame rate will be set equal to the input video frame rate
	// of the first input.
	FramerateControl *string `locationName:"framerateControl" type:"string" enum:"H264FramerateControl"`

	// Framerate denominator.
	FramerateDenominator *int64 `locationName:"framerateDenominator" min:"1" type:"integer"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	FramerateNumerator *int64 `locationName:"framerateNumerator" min:"1" type:"integer"`

	// If enabled, use reference B frames for GOP structures that have B frames
	// > 1.
	GopBReference *string `locationName:"gopBReference" type:"string" enum:"H264GopBReference"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// Number of B-frames between reference frames.
	GopNumBFrames *int64 `locationName:"gopNumBFrames" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If
	// gopSizeUnits is frames, gopSize must be an integer and must be greater than
	// or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0,
	// but need not be an integer.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits *string `locationName:"gopSizeUnits" type:"string" enum:"H264GopSizeUnits"`

	// H.264 Level.
	Level *string `locationName:"level" type:"string" enum:"H264Level"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl *string `locationName:"lookAheadRateControl" type:"string" enum:"H264LookAheadRateControl"`

	// For QVBR: See the tooltip for Quality levelFor VBR: Set the maximum bitrate
	// in order to accommodate expected spikes in the complexity of the video.
	MaxBitrate *int64 `locationName:"maxBitrate" min:"1000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the
	// next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// Number of reference frames to use. The encoder may use more than requested
	// if using B-frames and/or interlaced encoding.
	NumRefFrames *int64 `locationName:"numRefFrames" min:"1" type:"integer"`

	// This field indicates how the output pixel aspect ratio is specified. If "specified"
	// is selected then the output video pixel aspect ratio is determined by parNumerator
	// and parDenominator, else if "initializeFromSource" is selected then the output
	// pixsel aspect ratio will be set equal to the input video pixel aspect ratio
	// of the first input.
	ParControl *string `locationName:"parControl" type:"string" enum:"H264ParControl"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" min:"1" type:"integer"`

	// H.264 Profile.
	Profile *string `locationName:"profile" type:"string" enum:"H264Profile"`

	// Leave as STANDARD_QUALITY or choose a different value (which might result
	// in additional costs to run the channel).- ENHANCED_QUALITY: Produces a slightly
	// better video quality without an increase in the bitrate. Has an effect only
	// when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive
	// multiplex, the value must be ENHANCED_QUALITY.- STANDARD_QUALITY: Valid for
	// any Rate control mode.
	QualityLevel *string `locationName:"qualityLevel" type:"string" enum:"H264QualityLevel"`

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. You can set a target quality or you can let MediaLive
	// determine the best quality. To set a target quality, enter values in the
	// QVBR quality level field and the Max bitrate field. Enter values that suit
	// your most important viewing devices. Recommended values are:- Primary screen:
	// Quality level: 8 to 10. Max bitrate: 4M- PC or tablet: Quality level: 7.
	// Max bitrate: 1.5M to 3M- Smartphone: Quality level: 6. Max bitrate: 1M to
	// 1.5MTo let MediaLive decide, leave the QVBR quality level field empty, and
	// in Max bitrate enter the maximum rate you want in the video. For more information,
	// see the section called "Video - rate control mode" in the MediaLive user
	// guide
	QvbrQualityLevel *int64 `locationName:"qvbrQualityLevel" min:"1" type:"integer"`

	// Rate control mode.QVBR: Quality will match the specified quality level except
	// when it is constrained by themaximum bitrate. Recommended if you or your
	// viewers pay for bandwidth.VBR: Quality and bitrate vary, depending on the
	// video complexity. Recommended instead of QVBRif you want to maintain a specific
	// average bitrate over the duration of the channel.CBR: Quality varies, depending
	// on the video complexity. Recommended only if you distributeyour assets to
	// devices that cannot handle variable bitrates.Multiplex: This rate control
	// mode is only supported (and is required) when the video is beingdelivered
	// to a MediaLive Multiplex in which case the rate control configuration is
	// controlledby the properties within the Multiplex Program.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"H264RateControlMode"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType *string `locationName:"scanType" type:"string" enum:"H264ScanType"`

	// Scene change detection.- On: inserts I-frames when scene change is detected.-
	// Off: does not force an I-frame when scene change is detected.
	SceneChangeDetect *string `locationName:"sceneChangeDetect" type:"string" enum:"H264SceneChangeDetect"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// Softness. Selects quantizer matrix, larger values reduce high-frequency content
	// in the encoded image. If not set to zero, must be greater than 15.
	Softness *int64 `locationName:"softness" type:"integer"`

	// Spatial AQ makes adjustments within each frame based on spatial variation
	// of content complexity. The value to enter in this field depends on the value
	// in the Adaptive quantization field: If you have set the Adaptive quantization
	// field to Auto, MediaLive ignores any value in this field. MediaLive will
	// determine if spatial AQ is appropriate and will apply the appropriate strength.
	// If you have set the Adaptive quantization field to a strength, you can set
	// this field to Enabled or Disabled. Enabled: MediaLive will apply spatial
	// AQ using the specified strength. Disabled: MediaLive won't apply spatial
	// AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores
	// any value in this field and doesn't apply spatial AQ.
	SpatialAq *string `locationName:"spatialAq" type:"string" enum:"H264SpatialAq"`

	// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic,
	// optimize the number of B-frames used for each sub-GOP to improve visual quality.
	SubgopLength *string `locationName:"subgopLength" type:"string" enum:"H264SubGopLength"`

	// Produces a bitstream compliant with SMPTE RP-2027.
	Syntax *string `locationName:"syntax" type:"string" enum:"H264Syntax"`

	// Temporal makes adjustments within each frame based on temporal variation
	// of content complexity. The value to enter in this field depends on the value
	// in the Adaptive quantization field: If you have set the Adaptive quantization
	// field to Auto, MediaLive ignores any value in this field. MediaLive will
	// determine if temporal AQ is appropriate and will apply the appropriate strength.
	// If you have set the Adaptive quantization field to a strength, you can set
	// this field to Enabled or Disabled. Enabled: MediaLive will apply temporal
	// AQ using the specified strength. Disabled: MediaLive won't apply temporal
	// AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores
	// any value in this field and doesn't apply temporal AQ.
	TemporalAq *string `locationName:"temporalAq" type:"string" enum:"H264TemporalAq"`

	// Timecode burn-in settings
	TimecodeBurninSettings *TimecodeBurninSettings `locationName:"timecodeBurninSettings" type:"structure"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion *string `locationName:"timecodeInsertion" type:"string" enum:"H264TimecodeInsertionBehavior"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H264Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H264Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "H264Settings"}
	if s.Bitrate != nil && *s.Bitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 1000))
	}
	if s.FramerateDenominator != nil && *s.FramerateDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateDenominator", 1))
	}
	if s.FramerateNumerator != nil && *s.FramerateNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateNumerator", 1))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBitrate", 1000))
	}
	if s.NumRefFrames != nil && *s.NumRefFrames < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumRefFrames", 1))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.ParNumerator != nil && *s.ParNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParNumerator", 1))
	}
	if s.QvbrQualityLevel != nil && *s.QvbrQualityLevel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("QvbrQualityLevel", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Slices", 1))
	}
	if s.TimecodeBurninSettings != nil {
		if err := s.TimecodeBurninSettings.Validate(); err != nil {
			invalidParams.AddNested("TimecodeBurninSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdaptiveQuantization sets the AdaptiveQuantization field's value.
func (s *H264Settings) SetAdaptiveQuantization(v string) *H264Settings {
	s.AdaptiveQuantization = &v
	return s
}

// SetAfdSignaling sets the AfdSignaling field's value.
func (s *H264Settings) SetAfdSignaling(v string) *H264Settings {
	s.AfdSignaling = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *H264Settings) SetBitrate(v int64) *H264Settings {
	s.Bitrate = &v
	return s
}

// SetBufFillPct sets the BufFillPct field's value.
func (s *H264Settings) SetBufFillPct(v int64) *H264Settings {
	s.BufFillPct = &v
	return s
}

// SetBufSize sets the BufSize field's value.
func (s *H264Settings) SetBufSize(v int64) *H264Settings {
	s.BufSize = &v
	return s
}

// SetColorMetadata sets the ColorMetadata field's value.
func (s *H264Settings) SetColorMetadata(v string) *H264Settings {
	s.ColorMetadata = &v
	return s
}

// SetColorSpaceSettings sets the ColorSpaceSettings field's value.
func (s *H264Settings) SetColorSpaceSettings(v *H264ColorSpaceSettings) *H264Settings {
	s.ColorSpaceSettings = v
	return s
}

// SetEntropyEncoding sets the EntropyEncoding field's value.
func (s *H264Settings) SetEntropyEncoding(v string) *H264Settings {
	s.EntropyEncoding = &v
	return s
}

// SetFilterSettings sets the FilterSettings field's value.
func (s *H264Settings) SetFilterSettings(v *H264FilterSettings) *H264Settings {
	s.FilterSettings = v
	return s
}

// SetFixedAfd sets the FixedAfd field's value.
func (s *H264Settings) SetFixedAfd(v string) *H264Settings {
	s.FixedAfd = &v
	return s
}

// SetFlickerAq sets the FlickerAq field's value.
func (s *H264Settings) SetFlickerAq(v string) *H264Settings {
	s.FlickerAq = &v
	return s
}

// SetForceFieldPictures sets the ForceFieldPictures field's value.
func (s *H264Settings) SetForceFieldPictures(v string) *H264Settings {
	s.ForceFieldPictures = &v
	return s
}

// SetFramerateControl sets the FramerateControl field's value.
func (s *H264Settings) SetFramerateControl(v string) *H264Settings {
	s.FramerateControl = &v
	return s
}

// SetFramerateDenominator sets the FramerateDenominator field's value.
func (s *H264Settings) SetFramerateDenominator(v int64) *H264Settings {
	s.FramerateDenominator = &v
	return s
}

// SetFramerateNumerator sets the FramerateNumerator field's value.
func (s *H264Settings) SetFramerateNumerator(v int64) *H264Settings {
	s.FramerateNumerator = &v
	return s
}

// SetGopBReference sets the GopBReference field's value.
func (s *H264Settings) SetGopBReference(v string) *H264Settings {
	s.GopBReference = &v
	return s
}

// SetGopClosedCadence sets the GopClosedCadence field's value.
func (s *H264Settings) SetGopClosedCadence(v int64) *H264Settings {
	s.GopClosedCadence = &v
	return s
}

// SetGopNumBFrames sets the GopNumBFrames field's value.
func (s *H264Settings) SetGopNumBFrames(v int64) *H264Settings {
	s.GopNumBFrames = &v
	return s
}

// SetGopSize sets the GopSize field's value.
func (s *H264Settings) SetGopSize(v float64) *H264Settings {
	s.GopSize = &v
	return s
}

// SetGopSizeUnits sets the GopSizeUnits field's value.
func (s *H264Settings) SetGopSizeUnits(v string) *H264Settings {
	s.GopSizeUnits = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *H264Settings) SetLevel(v string) *H264Settings {
	s.Level = &v
	return s
}

// SetLookAheadRateControl sets the LookAheadRateControl field's value.
func (s *H264Settings) SetLookAheadRateControl(v string) *H264Settings {
	s.LookAheadRateControl = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *H264Settings) SetMaxBitrate(v int64) *H264Settings {
	s.MaxBitrate = &v
	return s
}

// SetMinIInterval sets the MinIInterval field's value.
func (s *H264Settings) SetMinIInterval(v int64) *H264Settings {
	s.MinIInterval = &v
	return s
}

// SetNumRefFrames sets the NumRefFrames field's value.
func (s *H264Settings) SetNumRefFrames(v int64) *H264Settings {
	s.NumRefFrames = &v
	return s
}

// SetParControl sets the ParControl field's value.
func (s *H264Settings) SetParControl(v string) *H264Settings {
	s.ParControl = &v
	return s
}

// SetParDenominator sets the ParDenominator field's value.
func (s *H264Settings) SetParDenominator(v int64) *H264Settings {
	s.ParDenominator = &v
	return s
}

// SetParNumerator sets the ParNumerator field's value.
func (s *H264Settings) SetParNumerator(v int64) *H264Settings {
	s.ParNumerator = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *H264Settings) SetProfile(v string) *H264Settings {
	s.Profile = &v
	return s
}

// SetQualityLevel sets the QualityLevel field's value.
func (s *H264Settings) SetQualityLevel(v string) *H264Settings {
	s.QualityLevel = &v
	return s
}

// SetQvbrQualityLevel sets the QvbrQualityLevel field's value.
func (s *H264Settings) SetQvbrQualityLevel(v int64) *H264Settings {
	s.QvbrQualityLevel = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *H264Settings) SetRateControlMode(v string) *H264Settings {
	s.RateControlMode = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *H264Settings) SetScanType(v string) *H264Settings {
	s.ScanType = &v
	return s
}

// SetSceneChangeDetect sets the SceneChangeDetect field's value.
func (s *H264Settings) SetSceneChangeDetect(v string) *H264Settings {
	s.SceneChangeDetect = &v
	return s
}

// SetSlices sets the Slices field's value.
func (s *H264Settings) SetSlices(v int64) *H264Settings {
	s.Slices = &v
	return s
}

// SetSoftness sets the Softness field's value.
func (s *H264Settings) SetSoftness(v int64) *H264Settings {
	s.Softness = &v
	return s
}

// SetSpatialAq sets the SpatialAq field's value.
func (s *H264Settings) SetSpatialAq(v string) *H264Settings {
	s.SpatialAq = &v
	return s
}

// SetSubgopLength sets the SubgopLength field's value.
func (s *H264Settings) SetSubgopLength(v string) *H264Settings {
	s.SubgopLength = &v
	return s
}

// SetSyntax sets the Syntax field's value.
func (s *H264Settings) SetSyntax(v string) *H264Settings {
	s.Syntax = &v
	return s
}

// SetTemporalAq sets the TemporalAq field's value.
func (s *H264Settings) SetTemporalAq(v string) *H264Settings {
	s.TemporalAq = &v
	return s
}

// SetTimecodeBurninSettings sets the TimecodeBurninSettings field's value.
func (s *H264Settings) SetTimecodeBurninSettings(v *TimecodeBurninSettings) *H264Settings {
	s.TimecodeBurninSettings = v
	return s
}

// SetTimecodeInsertion sets the TimecodeInsertion field's value.
func (s *H264Settings) SetTimecodeInsertion(v string) *H264Settings {
	s.TimecodeInsertion = &v
	return s
}

// H265 Color Space Settings
type H265ColorSpaceSettings struct {
	_ struct{} `type:"structure"`

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings `locationName:"colorSpacePassthroughSettings" type:"structure"`

	// Dolby Vision81 Settings
	DolbyVision81Settings *DolbyVision81Settings `locationName:"dolbyVision81Settings" type:"structure"`

	// Hdr10 Settings
	Hdr10Settings *Hdr10Settings `locationName:"hdr10Settings" type:"structure"`

	// Rec601 Settings
	Rec601Settings *Rec601Settings `locationName:"rec601Settings" type:"structure"`

	// Rec709 Settings
	Rec709Settings *Rec709Settings `locationName:"rec709Settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265ColorSpaceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265ColorSpaceSettings) GoString() string {
	return s.String()
}

// SetColorSpacePassthroughSettings sets the ColorSpacePassthroughSettings field's value.
func (s *H265ColorSpaceSettings) SetColorSpacePassthroughSettings(v *ColorSpacePassthroughSettings) *H265ColorSpaceSettings {
	s.ColorSpacePassthroughSettings = v
	return s
}

// SetDolbyVision81Settings sets the DolbyVision81Settings field's value.
func (s *H265ColorSpaceSettings) SetDolbyVision81Settings(v *DolbyVision81Settings) *H265ColorSpaceSettings {
	s.DolbyVision81Settings = v
	return s
}

// SetHdr10Settings sets the Hdr10Settings field's value.
func (s *H265ColorSpaceSettings) SetHdr10Settings(v *Hdr10Settings) *H265ColorSpaceSettings {
	s.Hdr10Settings = v
	return s
}

// SetRec601Settings sets the Rec601Settings field's value.
func (s *H265ColorSpaceSettings) SetRec601Settings(v *Rec601Settings) *H265ColorSpaceSettings {
	s.Rec601Settings = v
	return s
}

// SetRec709Settings sets the Rec709Settings field's value.
func (s *H265ColorSpaceSettings) SetRec709Settings(v *Rec709Settings) *H265ColorSpaceSettings {
	s.Rec709Settings = v
	return s
}

// H265 Filter Settings
type H265FilterSettings struct {
	_ struct{} `type:"structure"`

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings `locationName:"temporalFilterSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265FilterSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265FilterSettings) GoString() string {
	return s.String()
}

// SetTemporalFilterSettings sets the TemporalFilterSettings field's value.
func (s *H265FilterSettings) SetTemporalFilterSettings(v *TemporalFilterSettings) *H265FilterSettings {
	s.TemporalFilterSettings = v
	return s
}

// H265 Settings
type H265Settings struct {
	_ struct{} `type:"structure"`

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization *string `locationName:"adaptiveQuantization" type:"string" enum:"H265AdaptiveQuantization"`

	// Indicates that AFD values will be written into the output stream. If afdSignaling
	// is "auto", the system will try to preserve the input AFD value (in cases
	// where multiple AFD values are valid). If set to "fixed", the AFD value will
	// be the value configured in the fixedAfd parameter.
	AfdSignaling *string `locationName:"afdSignaling" type:"string" enum:"AfdSignaling"`

	// Whether or not EML should insert an Alternative Transfer Function SEI message
	// to support backwards compatibility with non-HDR decoders and displays.
	AlternativeTransferFunction *string `locationName:"alternativeTransferFunction" type:"string" enum:"H265AlternativeTransferFunction"`

	// Average bitrate in bits/second. Required when the rate control mode is VBR
	// or CBR. Not used for QVBR. In an MS Smooth output group, each output must
	// have a unique value when its bitrate is rounded down to the nearest multiple
	// of 1000.
	Bitrate *int64 `locationName:"bitrate" min:"100000" type:"integer"`

	// Size of buffer (HRD buffer model) in bits.
	BufSize *int64 `locationName:"bufSize" min:"100000" type:"integer"`

	// Includes colorspace metadata in the output.
	ColorMetadata *string `locationName:"colorMetadata" type:"string" enum:"H265ColorMetadata"`

	// Color Space settings
	ColorSpaceSettings *H265ColorSpaceSettings `locationName:"colorSpaceSettings" type:"structure"`

	// Optional filters that you can apply to an encode.
	FilterSettings *H265FilterSettings `locationName:"filterSettings" type:"structure"`

	// Four bit AFD value to write on all frames of video in the output stream.
	// Only valid when afdSignaling is set to 'Fixed'.
	FixedAfd *string `locationName:"fixedAfd" type:"string" enum:"FixedAfd"`

	// If set to enabled, adjust quantization within each frame to reduce flicker
	// or 'pop' on I-frames.
	FlickerAq *string `locationName:"flickerAq" type:"string" enum:"H265FlickerAq"`

	// Framerate denominator.
	//
	// FramerateDenominator is a required field
	FramerateDenominator *int64 `locationName:"framerateDenominator" min:"1" type:"integer" required:"true"`

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976
	// fps.
	//
	// FramerateNumerator is a required field
	FramerateNumerator *int64 `locationName:"framerateNumerator" min:"1" type:"integer" required:"true"`

	// Frequency of closed GOPs. In streaming applications, it is recommended that
	// this be set to 1 so a decoder joining mid-stream will receive an IDR frame
	// as quickly as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence *int64 `locationName:"gopClosedCadence" type:"integer"`

	// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If
	// gopSizeUnits is frames, gopSize must be an integer and must be greater than
	// or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0,
	// but need not be an integer.
	GopSize *float64 `locationName:"gopSize" type:"double"`

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits *string `locationName:"gopSizeUnits" type:"string" enum:"H265GopSizeUnits"`

	// H.265 Level.
	Level *string `locationName:"level" type:"string" enum:"H265Level"`

	// Amount of lookahead. A value of low can decrease latency and memory usage,
	// while high can produce better quality for certain content.
	LookAheadRateControl *string `locationName:"lookAheadRateControl" type:"string" enum:"H265LookAheadRateControl"`

	// For QVBR: See the tooltip for Quality level
	MaxBitrate *int64 `locationName:"maxBitrate" min:"100000" type:"integer"`

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the
	// next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval *int64 `locationName:"minIInterval" type:"integer"`

	// If you are setting up the picture as a tile, you must set this to "disabled".
	// In all other configurations, you typically enter "enabled".
	MvOverPictureBoundaries *string `locationName:"mvOverPictureBoundaries" type:"string" enum:"H265MvOverPictureBoundaries"`

	// If you are setting up the picture as a tile, you must set this to "disabled".
	// In other configurations, you typically enter "enabled".
	MvTemporalPredictor *string `locationName:"mvTemporalPredictor" type:"string" enum:"H265MvTemporalPredictor"`

	// Pixel Aspect Ratio denominator.
	ParDenominator *int64 `locationName:"parDenominator" min:"1" type:"integer"`

	// Pixel Aspect Ratio numerator.
	ParNumerator *int64 `locationName:"parNumerator" min:"1" type:"integer"`

	// H.265 Profile.
	Profile *string `locationName:"profile" type:"string" enum:"H265Profile"`

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. Set values for the QVBR quality level field and Max
	// bitrate field that suit your most important viewing devices. Recommended
	// values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC
	// or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality
	// level: 6. Max bitrate: 1M to 1.5M
	QvbrQualityLevel *int64 `locationName:"qvbrQualityLevel" min:"1" type:"integer"`

	// Rate control mode.QVBR: Quality will match the specified quality level except
	// when it is constrained by themaximum bitrate. Recommended if you or your
	// viewers pay for bandwidth.CBR: Quality varies, depending on the video complexity.
	// Recommended only if you distributeyour assets to devices that cannot handle
	// variable bitrates.Multiplex: This rate control mode is only supported (and
	// is required) when the video is beingdelivered to a MediaLive Multiplex in
	// which case the rate control configuration is controlledby the properties
	// within the Multiplex Program.
	RateControlMode *string `locationName:"rateControlMode" type:"string" enum:"H265RateControlMode"`

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType *string `locationName:"scanType" type:"string" enum:"H265ScanType"`

	// Scene change detection.
	SceneChangeDetect *string `locationName:"sceneChangeDetect" type:"string" enum:"H265SceneChangeDetect"`

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half
	// the number of macroblock rows for interlaced pictures.This field is optional;
	// when no value is specified the encoder will choose the number of slices based
	// on encode resolution.
	Slices *int64 `locationName:"slices" min:"1" type:"integer"`

	// H.265 Tier.
	Tier *string `locationName:"tier" type:"string" enum:"H265Tier"`

	// Set this field to set up the picture as a tile. You must also set tileWidth.The
	// tile height must result in 22 or fewer rows in the frame. The tile widthmust
	// result in 20 or fewer columns in the frame. And finally, the product of thecolumn
	// count and row count must be 64 of less.If the tile width and height are specified,
	// MediaLive will override the videocodec slices field with a value that MediaLive
	// calculates
	TileHeight *int64 `locationName:"tileHeight" min:"64" type:"integer"`

	// Set to "padded" to force MediaLive to add padding to the frame, to obtain
	// a frame that is a whole multiple of the tile size.If you are setting up the
	// picture as a tile, you must enter "padded".In all other configurations, you
	// typically enter "none".
	TilePadding *string `locationName:"tilePadding" type:"string" enum:"H265TilePadding"`

	// Set this field to set up the picture as a tile. See tileHeight for more information.
	TileWidth *int64 `locationName:"tileWidth" min:"256" type:"integer"`

	// Timecode burn-in settings
	TimecodeBurninSettings *TimecodeBurninSettings `locationName:"timecodeBurninSettings" type:"structure"`

	// Determines how timecodes should be inserted into the video elementary stream.-
	// 'disabled': Do not include timecodes- 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion *string `locationName:"timecodeInsertion" type:"string" enum:"H265TimecodeInsertionBehavior"`

	// Select the tree block size used for encoding. If you enter "auto", the encoder
	// will pick the best size. If you are setting up the picture as a tile, you
	// must set this to 32x32. In all other configurations, you typically enter
	// "auto".
	TreeblockSize *string `locationName:"treeblockSize" type:"string" enum:"H265TreeblockSize"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s H265Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *H265Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "H265Settings"}
	if s.Bitrate != nil && *s.Bitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("Bitrate", 100000))
	}
	if s.BufSize != nil && *s.BufSize < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("BufSize", 100000))
	}
	if s.FramerateDenominator == nil {
		invalidParams.Add(request.NewErrParamRequired("FramerateDenominator"))
	}
	if s.FramerateDenominator != nil && *s.FramerateDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateDenominator", 1))
	}
	if s.FramerateNumerator == nil {
		invalidParams.Add(request.NewErrParamRequired("FramerateNumerator"))
	}
	if s.FramerateNumerator != nil && *s.FramerateNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FramerateNumerator", 1))
	}
	if s.MaxBitrate != nil && *s.MaxBitrate < 100000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBitrate", 100000))
	}
	if s.ParDenominator != nil && *s.ParDenominator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParDenominator", 1))
	}
	if s.ParNumerator != nil && *s.ParNumerator < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParNumerator", 1))
	}
	if s.QvbrQualityLevel != nil && *s.QvbrQualityLevel < 1 {
		invalidParams.Add(request.NewErrParamMinValue("QvbrQualityLevel", 1))
	}
	if s.Slices != nil && *s.Slices < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Slices", 1))
	}
	if s.TileHeight != nil && *s.TileHeight < 64 {
		invalidParams.Add(request.NewErrParamMinValue("TileHeight", 64))
	}
	if s.TileWidth != nil && *s.TileWidth < 256 {
		invalidParams.Add(request.NewErrParamMinValue("TileWidth", 256))
	}
	if s.TimecodeBurninSettings != nil {
		if err := s.TimecodeBurninSettings.Validate(); err != nil {
			invalidParams.AddNested("TimecodeBurninSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdaptiveQuantization sets the AdaptiveQuantization field's value.
func (s *H265Settings) SetAdaptiveQuantization(v string) *H265Settings {
	s.AdaptiveQuantization = &v
	return s
}

// SetAfdSignaling sets the AfdSignaling field's value.
func (s *H265Settings) SetAfdSignaling(v string) *H265Settings {
	s.AfdSignaling = &v
	return s
}

// SetAlternativeTransferFunction sets the AlternativeTransferFunction field's value.
func (s *H265Settings) SetAlternativeTransferFunction(v string) *H265Settings {
	s.AlternativeTransferFunction = &v
	return s
}

// SetBitrate sets the Bitrate field's value.
func (s *H265Settings) SetBitrate(v int64) *H265Settings {
	s.Bitrate = &v
	return s
}

// SetBufSize sets the BufSize field's value.
func (s *H265Settings) SetBufSize(v int64) *H265Settings {
	s.BufSize = &v
	return s
}

// SetColorMetadata sets the ColorMetadata field's value.
func (s *H265Settings) SetColorMetadata(v string) *H265Settings {
	s.ColorMetadata = &v
	return s
}

// SetColorSpaceSettings sets the ColorSpaceSettings field's value.
func (s *H265Settings) SetColorSpaceSettings(v *H265ColorSpaceSettings) *H265Settings {
	s.ColorSpaceSettings = v
	return s
}

// SetFilterSettings sets the FilterSettings field's value.
func (s *H265Settings) SetFilterSettings(v *H265FilterSettings) *H265Settings {
	s.FilterSettings = v
	return s
}

// SetFixedAfd sets the FixedAfd field's value.
func (s *H265Settings) SetFixedAfd(v string) *H265Settings {
	s.FixedAfd = &v
	return s
}

// SetFlickerAq sets the FlickerAq field's value.
func (s *H265Settings) SetFlickerAq(v string) *H265Settings {
	s.FlickerAq = &v
	return s
}

// SetFramerateDenominator sets the FramerateDenominator field's value.
func (s *H265Settings) SetFramerateDenominator(v int64) *H265Settings {
	s.FramerateDenominator = &v
	return s
}

// SetFramerateNumerator sets the FramerateNumerator field's value.
func (s *H265Settings) SetFramerateNumerator(v int64) *H265Settings {
	s.FramerateNumerator = &v
	return s
}

// SetGopClosedCadence sets the GopClosedCadence field's value.
func (s *H265Settings) SetGopClosedCadence(v int64) *H265Settings {
	s.GopClosedCadence = &v
	return s
}

// SetGopSize sets the GopSize field's value.
func (s *H265Settings) SetGopSize(v float64) *H265Settings {
	s.GopSize = &v
	return s
}

// SetGopSizeUnits sets the GopSizeUnits field's value.
func (s *H265Settings) SetGopSizeUnits(v string) *H265Settings {
	s.GopSizeUnits = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *H265Settings) SetLevel(v string) *H265Settings {
	s.Level = &v
	return s
}

// SetLookAheadRateControl sets the LookAheadRateControl field's value.
func (s *H265Settings) SetLookAheadRateControl(v string) *H265Settings {
	s.LookAheadRateControl = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *H265Settings) SetMaxBitrate(v int64) *H265Settings {
	s.MaxBitrate = &v
	return s
}

// SetMinIInterval sets the MinIInterval field's value.
func (s *H265Settings) SetMinIInterval(v int64) *H265Settings {
	s.MinIInterval = &v
	return s
}

// SetMvOverPictureBoundaries sets the MvOverPictureBoundaries field's value.
func (s *H265Settings) SetMvOverPictureBoundaries(v string) *H265Settings {
	s.MvOverPictureBoundaries = &v
	return s
}

// SetMvTemporalPredictor sets the MvTemporalPredictor field's value.
func (s *H265Settings) SetMvTemporalPredictor(v string) *H265Settings {
	s.MvTemporalPredictor = &v
	return s
}

// SetParDenominator sets the ParDenominator field's value.
func (s *H265Settings) SetParDenominator(v int64) *H265Settings {
	s.ParDenominator = &v
	return s
}

// SetParNumerator sets the ParNumerator field's value.
func (s *H265Settings) SetParNumerator(v int64) *H265Settings {
	s.ParNumerator = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *H265Settings) SetProfile(v string) *H265Settings {
	s.Profile = &v
	return s
}

// SetQvbrQualityLevel sets the QvbrQualityLevel field's value.
func (s *H265Settings) SetQvbrQualityLevel(v int64) *H265Settings {
	s.QvbrQualityLevel = &v
	return s
}

// SetRateControlMode sets the RateControlMode field's value.
func (s *H265Settings) SetRateControlMode(v string) *H265Settings {
	s.RateControlMode = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *H265Settings) SetScanType(v string) *H265Settings {
	s.ScanType = &v
	return s
}

// SetSceneChangeDetect sets the SceneChangeDetect field's value.
func (s *H265Settings) SetSceneChangeDetect(v string) *H265Settings {
	s.SceneChangeDetect = &v
	return s
}

// SetSlices sets the Slices field's value.
func (s *H265Settings) SetSlices(v int64) *H265Settings {
	s.Slices = &v
	return s
}

// SetTier sets the Tier field's value.
func (s *H265Settings) SetTier(v string) *H265Settings {
	s.Tier = &v
	return s
}

// SetTileHeight sets the TileHeight field's value.
func (s *H265Settings) SetTileHeight(v int64) *H265Settings {
	s.TileHeight = &v
	return s
}

// SetTilePadding sets the TilePadding field's value.
func (s *H265Settings) SetTilePadding(v string) *H265Settings {
	s.TilePadding = &v
	return s
}

// SetTileWidth sets the TileWidth field's value.
func (s *H265Settings) SetTileWidth(v int64) *H265Settings {
	s.TileWidth = &v
	return s
}

// SetTimecodeBurninSettings sets the TimecodeBurninSettings field's value.
func (s *H265Settings) SetTimecodeBurninSettings(v *TimecodeBurninSettings) *H265Settings {
	s.TimecodeBurninSettings = v
	return s
}

// SetTimecodeInsertion sets the TimecodeInsertion field's value.
func (s *H265Settings) SetTimecodeInsertion(v string) *H265Settings {
	s.TimecodeInsertion = &v
	return s
}

// SetTreeblockSize sets the TreeblockSize field's value.
func (s *H265Settings) SetTreeblockSize(v string) *H265Settings {
	s.TreeblockSize = &v
	return s
}

// Hdr10 Settings
type Hdr10Settings struct {
	_ struct{} `type:"structure"`

	// Maximum Content Light LevelAn integer metadata value defining the maximum
	// light level, in nits,of any single pixel within an encoded HDR video stream
	// or file.
	MaxCll *int64 `locationName:"maxCll" type:"integer"`

	// Maximum Frame Average Light LevelAn integer metadata value defining the maximum
	// average light level, in nits,for any single frame within an encoded HDR video
	// stream or file.
	MaxFall *int64 `locationName:"maxFall" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hdr10Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Hdr10Settings) GoString() string {
	return s.String()
}

// SetMaxCll sets the MaxCll field's value.
func (s *Hdr10Settings) SetMaxCll(v int64) *Hdr10Settings {
	s.MaxCll = &v
	return s
}

// SetMaxFall sets the MaxFall field's value.
func (s *Hdr10Settings) SetMaxFall(v int64) *Hdr10Settings {
	s.MaxFall = &v
	return s
}

// Hls Akamai Settings
type HlsAkamaiSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to Akamai. User should
	// contact Akamai to enable this feature.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsAkamaiHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state. Applies only if the CDN destination URI begins with "s3"
	// or "mediastore". For other URIs, the value is always 3.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`

	// Salt for authenticated Akamai.
	Salt *string `locationName:"salt" type:"string"`

	// Token parameter for authenticated akamai. If not specified, _gda_ is used.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsAkamaiSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsAkamaiSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsAkamaiSettings) SetConnectionRetryInterval(v int64) *HlsAkamaiSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsAkamaiSettings) SetFilecacheDuration(v int64) *HlsAkamaiSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsAkamaiSettings) SetHttpTransferMode(v string) *HlsAkamaiSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsAkamaiSettings) SetNumRetries(v int64) *HlsAkamaiSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsAkamaiSettings) SetRestartDelay(v int64) *HlsAkamaiSettings {
	s.RestartDelay = &v
	return s
}

// SetSalt sets the Salt field's value.
func (s *HlsAkamaiSettings) SetSalt(v string) *HlsAkamaiSettings {
	s.Salt = &v
	return s
}

// SetToken sets the Token field's value.
func (s *HlsAkamaiSettings) SetToken(v string) *HlsAkamaiSettings {
	s.Token = &v
	return s
}

// Hls Basic Put Settings
type HlsBasicPutSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state. Applies only if the CDN destination URI begins with "s3"
	// or "mediastore". For other URIs, the value is always 3.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsBasicPutSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsBasicPutSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsBasicPutSettings) SetConnectionRetryInterval(v int64) *HlsBasicPutSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsBasicPutSettings) SetFilecacheDuration(v int64) *HlsBasicPutSettings {
	s.FilecacheDuration = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsBasicPutSettings) SetNumRetries(v int64) *HlsBasicPutSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsBasicPutSettings) SetRestartDelay(v int64) *HlsBasicPutSettings {
	s.RestartDelay = &v
	return s
}

// Hls Cdn Settings
type HlsCdnSettings struct {
	_ struct{} `type:"structure"`

	// Hls Akamai Settings
	HlsAkamaiSettings *HlsAkamaiSettings `locationName:"hlsAkamaiSettings" type:"structure"`

	// Hls Basic Put Settings
	HlsBasicPutSettings *HlsBasicPutSettings `locationName:"hlsBasicPutSettings" type:"structure"`

	// Hls Media Store Settings
	HlsMediaStoreSettings *HlsMediaStoreSettings `locationName:"hlsMediaStoreSettings" type:"structure"`

	// Hls S3 Settings
	HlsS3Settings *HlsS3Settings `locationName:"hlsS3Settings" type:"structure"`

	// Hls Webdav Settings
	HlsWebdavSettings *HlsWebdavSettings `locationName:"hlsWebdavSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsCdnSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsCdnSettings) GoString() string {
	return s.String()
}

// SetHlsAkamaiSettings sets the HlsAkamaiSettings field's value.
func (s *HlsCdnSettings) SetHlsAkamaiSettings(v *HlsAkamaiSettings) *HlsCdnSettings {
	s.HlsAkamaiSettings = v
	return s
}

// SetHlsBasicPutSettings sets the HlsBasicPutSettings field's value.
func (s *HlsCdnSettings) SetHlsBasicPutSettings(v *HlsBasicPutSettings) *HlsCdnSettings {
	s.HlsBasicPutSettings = v
	return s
}

// SetHlsMediaStoreSettings sets the HlsMediaStoreSettings field's value.
func (s *HlsCdnSettings) SetHlsMediaStoreSettings(v *HlsMediaStoreSettings) *HlsCdnSettings {
	s.HlsMediaStoreSettings = v
	return s
}

// SetHlsS3Settings sets the HlsS3Settings field's value.
func (s *HlsCdnSettings) SetHlsS3Settings(v *HlsS3Settings) *HlsCdnSettings {
	s.HlsS3Settings = v
	return s
}

// SetHlsWebdavSettings sets the HlsWebdavSettings field's value.
func (s *HlsCdnSettings) SetHlsWebdavSettings(v *HlsWebdavSettings) *HlsCdnSettings {
	s.HlsWebdavSettings = v
	return s
}

// Hls Group Settings
type HlsGroupSettings struct {
	_ struct{} `type:"structure"`

	// Choose one or more ad marker types to pass SCTE35 signals through to this
	// group of Apple HLS outputs.
	AdMarkers []*string `locationName:"adMarkers" type:"list" enum:"HlsAdMarkers"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlContent *string `locationName:"baseUrlContent" type:"string"`

	// Optional. One value per output group.This field is required only if you are
	// completing Base URL content A, and the downstream system has notified you
	// that the media files for pipeline 1 of all outputs are in a location different
	// from the media files for pipeline 0.
	BaseUrlContent1 *string `locationName:"baseUrlContent1" type:"string"`

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than
	// the main .m3u8 file.
	BaseUrlManifest *string `locationName:"baseUrlManifest" type:"string"`

	// Optional. One value per output group.Complete this field only if you are
	// completing Base URL manifest A, and the downstream system has notified you
	// that the child manifest files for pipeline 1 of all outputs are in a location
	// different from the child manifest files for pipeline 0.
	BaseUrlManifest1 *string `locationName:"baseUrlManifest1" type:"string"`

	// Mapping of up to 4 caption channels to caption languages. Is only meaningful
	// if captionLanguageSetting is set to "insert".
	CaptionLanguageMappings []*CaptionLanguageMapping `locationName:"captionLanguageMappings" type:"list"`

	// Applies only to 608 Embedded output captions.insert: Include CLOSED-CAPTIONS
	// lines in the manifest. Specify at least one language in the CC1 Language
	// Code field. One CLOSED-CAPTION line is added for each Language Code you specify.
	// Make sure to specify the languages in the order in which they appear in the
	// original source (if the source is embedded format) or the order of the caption
	// selectors (if the source is other than embedded). Otherwise, languages in
	// the manifest will not match up properly with the output captions.none: Include
	// CLOSED-CAPTIONS=NONE line in the manifest.omit: Omit any CLOSED-CAPTIONS
	// line from the manifest.
	CaptionLanguageSetting *string `locationName:"captionLanguageSetting" type:"string" enum:"HlsCaptionLanguageSetting"`

	// When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest,
	// which prevents clients from saving media segments for later replay.
	ClientCache *string `locationName:"clientCache" type:"string" enum:"HlsClientCache"`

	// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
	// generation.
	CodecSpecification *string `locationName:"codecSpecification" type:"string" enum:"HlsCodecSpecification"`

	// For use with encryptionType. This is a 128-bit, 16-byte hex value represented
	// by a 32-character text string. If ivSource is set to "explicit" then this
	// parameter is required and is used as the IV for encryption.
	ConstantIv *string `locationName:"constantIv" min:"32" type:"string"`

	// A directory or HTTP destination for the HLS segments, manifest files, and
	// encryption keys (if enabled).
	//
	// Destination is a required field
	Destination *OutputLocationRef `locationName:"destination" type:"structure" required:"true"`

	// Place segments in subdirectories.
	DirectoryStructure *string `locationName:"directoryStructure" type:"string" enum:"HlsDirectoryStructure"`

	// Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests
	// for this output group.Typically, choose Insert because these tags are required
	// in the manifest (according to the HLS specification) and serve an important
	// purpose.Choose Never Insert only if the downstream system is doing real-time
	// failover (without using the MediaLive automatic failover feature) and only
	// if that downstream system has advised you to exclude the tags.
	DiscontinuityTags *string `locationName:"discontinuityTags" type:"string" enum:"HlsDiscontinuityTags"`

	// Encrypts the segments with the given encryption scheme. Exclude this parameter
	// if no encryption is desired.
	EncryptionType *string `locationName:"encryptionType" type:"string" enum:"HlsEncryptionType"`

	// Parameters that control interactions with the CDN.
	HlsCdnSettings *HlsCdnSettings `locationName:"hlsCdnSettings" type:"structure"`

	// State of HLS ID3 Segment Tagging
	HlsId3SegmentTagging *string `locationName:"hlsId3SegmentTagging" type:"string" enum:"HlsId3SegmentTaggingState"`

	// DISABLED: Do not create an I-frame-only manifest, but do create the master
	// and media manifests (according to the Output Selection field).STANDARD: Create
	// an I-frame-only manifest for each output that contains video, as well as
	// the other manifests (according to the Output Selection field). The I-frame
	// manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only,
	// and one or more #EXT-X-BYTERANGE entries identifying the I-frame position.
	// For example, #EXT-X-BYTERANGE:160364@1461888"
	IFrameOnlyPlaylists *string `locationName:"iFrameOnlyPlaylists" type:"string" enum:"IFrameOnlyPlaylistType"`

	// Specifies whether to include the final (incomplete) segment in the media
	// output when the pipeline stops producing output because of a channel stop,
	// a channel pause or a loss of input to the pipeline.Auto means that MediaLive
	// decides whether to include the final segment, depending on the channel class
	// and the types of output groups.Suppress means to never include the incomplete
	// segment. We recommend you choose Auto and let MediaLive control the behavior.
	IncompleteSegmentBehavior *string `locationName:"incompleteSegmentBehavior" type:"string" enum:"HlsIncompleteSegmentBehavior"`

	// Applies only if Mode field is LIVE.Specifies the maximum number of segments
	// in the media manifest file. After this maximum, older segments are removed
	// from the media manifest. This number must be smaller than the number in the
	// Keep Segments field.
	IndexNSegments *int64 `locationName:"indexNSegments" min:"3" type:"integer"`

	// Parameter that control output group behavior on input loss.
	InputLossAction *string `locationName:"inputLossAction" type:"string" enum:"InputLossActionForHlsOut"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If set to
	// "include", IV is listed in the manifest, otherwise the IV is not in the manifest.
	IvInManifest *string `locationName:"ivInManifest" type:"string" enum:"HlsIvInManifest"`

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit
	// number used in conjunction with the key for encrypting blocks. If this setting
	// is "followsSegmentNumber", it will cause the IV to change every segment (to
	// match the segment number). If this is set to "explicit", you must enter a
	// constantIv value.
	IvSource *string `locationName:"ivSource" type:"string" enum:"HlsIvSource"`

	// Applies only if Mode field is LIVE.Specifies the number of media segments
	// to retain in the destination directory. This number should be bigger than
	// indexNSegments (Num segments). We recommend (value = (2 x indexNsegments)
	// + 1).If this "keep segments" number is too low, the following might happen:
	// the player is still reading a media manifest file that lists this segment,
	// but that segment has been removed from the destination directory (as directed
	// by indexNSegments). This situation would result in a 404 HTTP error on the
	// player.
	KeepSegments *int64 `locationName:"keepSegments" min:"1" type:"integer"`

	// The value specifies how the key is represented in the resource identified
	// by the URI. If parameter is absent, an implicit value of "identity" is used.
	// A reverse DNS string can also be given.
	KeyFormat *string `locationName:"keyFormat" type:"string"`

	// Either a single positive integer version value or a slash delimited list
	// of version values (1/2/3).
	KeyFormatVersions *string `locationName:"keyFormatVersions" type:"string"`

	// The key provider settings.
	KeyProviderSettings *KeyProviderSettings `locationName:"keyProviderSettings" type:"structure"`

	// When set to gzip, compresses HLS playlist.
	ManifestCompression *string `locationName:"manifestCompression" type:"string" enum:"HlsManifestCompression"`

	// Indicates whether the output manifest should use floating point or integer
	// values for segment duration.
	ManifestDurationFormat *string `locationName:"manifestDurationFormat" type:"string" enum:"HlsManifestDurationFormat"`

	// Minimum length of MPEG-2 Transport Stream segments in seconds. When set,
	// minimum segment length is enforced by looking ahead and back within the specified
	// range for a nearby avail and extending the segment size if needed.
	MinSegmentLength *int64 `locationName:"minSegmentLength" type:"integer"`

	// If "vod", all segments are indexed and kept permanently in the destination
	// and manifest. If "live", only the number segments specified in keepSegments
	// and indexNSegments are kept; newer segments replace older segments, which
	// may prevent players from rewinding all the way to the beginning of the event.VOD
	// mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running,
	// converting it to a "VOD" type manifest on completion of the stream.
	Mode *string `locationName:"mode" type:"string" enum:"HlsMode"`

	// MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable,
	// and media manifests) for this output group.VARIANT_MANIFESTS_AND_SEGMENTS:
	// Generates media manifests for this output group, but not a master manifest.SEGMENTS_ONLY:
	// Does not generate any manifests for this output group.
	OutputSelection *string `locationName:"outputSelection" type:"string" enum:"HlsOutputSelection"`

	// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files.
	// The value is calculated using the program date time clock.
	ProgramDateTime *string `locationName:"programDateTime" type:"string" enum:"HlsProgramDateTime"`

	// Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock.
	// Options include:INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized
	// as a function of the first output timecode, then incremented by the EXTINF
	// duration of each encoded segment.SYSTEM_CLOCK: The PDT clock is initialized
	// as a function of the UTC wall clock, then incremented by the EXTINF duration
	// of each encoded segment. If the PDT clock diverges from the wall clock by
	// more than 500ms, it is resynchronized to the wall clock.
	ProgramDateTimeClock *string `locationName:"programDateTimeClock" type:"string" enum:"HlsProgramDateTimeClock"`

	// Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
	ProgramDateTimePeriod *int64 `locationName:"programDateTimePeriod" type:"integer"`

	// ENABLED: The master manifest (.m3u8 file) for each pipeline includes information
	// about both pipelines: first its own media files, then the media files of
	// the other pipeline. This feature allows playout device that support stale
	// manifest detection to switch from one manifest to the other, when the current
	// manifest seems to be stale. There are still two destinations and two master
	// manifests, but both master manifests reference the media files from both
	// pipelines.DISABLED: The master manifest (.m3u8 file) for each pipeline includes
	// information about its own pipeline only.For an HLS output group with MediaPackage
	// as the destination, the DISABLED behavior is always followed. MediaPackage
	// regenerates the manifests it serves to players so a redundant manifest from
	// MediaLive is irrelevant.
	RedundantManifest *string `locationName:"redundantManifest" type:"string" enum:"HlsRedundantManifest"`

	// Length of MPEG-2 Transport Stream segments to create in seconds. Note that
	// segments will end on the next keyframe after this duration, so actual segment
	// length may be longer.
	SegmentLength *int64 `locationName:"segmentLength" min:"1" type:"integer"`

	// useInputSegmentation has been deprecated. The configured segment size is
	// always used.
	SegmentationMode *string `locationName:"segmentationMode" type:"string" enum:"HlsSegmentationMode"`

	// Number of segments to write to a subdirectory before starting a new one.
	// directoryStructure must be subdirectoryPerStream for this setting to have
	// an effect.
	SegmentsPerSubdirectory *int64 `locationName:"segmentsPerSubdirectory" min:"1" type:"integer"`

	// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag
	// of variant manifest.
	StreamInfResolution *string `locationName:"streamInfResolution" type:"string" enum:"HlsStreamInfResolution"`

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame *string `locationName:"timedMetadataId3Frame" type:"string" enum:"HlsTimedMetadataId3Frame"`

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period *int64 `locationName:"timedMetadataId3Period" type:"integer"`

	// Provides an extra millisecond delta offset to fine tune the timestamps.
	TimestampDeltaMilliseconds *int64 `locationName:"timestampDeltaMilliseconds" type:"integer"`

	// SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.SINGLE_FILE:
	// Applies only if Mode field is VOD. Emit the program as a single .ts media
	// file. The media manifest includes #EXT-X-BYTERANGE tags to index segments
	// for playback. A typical use for this value is when sending the output to
	// AWS Elemental MediaConvert, which can accept only a single media file. Playback
	// while the channel is running is not guaranteed due to HTTP server caching.
	TsFileMode *string `locationName:"tsFileMode" type:"string" enum:"HlsTsFileMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsGroupSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsGroupSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsGroupSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsGroupSettings"}
	if s.ConstantIv != nil && len(*s.ConstantIv) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ConstantIv", 32))
	}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.IndexNSegments != nil && *s.IndexNSegments < 3 {
		invalidParams.Add(request.NewErrParamMinValue("IndexNSegments", 3))
	}
	if s.KeepSegments != nil && *s.KeepSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("KeepSegments", 1))
	}
	if s.SegmentLength != nil && *s.SegmentLength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentLength", 1))
	}
	if s.SegmentsPerSubdirectory != nil && *s.SegmentsPerSubdirectory < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentsPerSubdirectory", 1))
	}
	if s.CaptionLanguageMappings != nil {
		for i, v := range s.CaptionLanguageMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionLanguageMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.KeyProviderSettings != nil {
		if err := s.KeyProviderSettings.Validate(); err != nil {
			invalidParams.AddNested("KeyProviderSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdMarkers sets the AdMarkers field's value.
func (s *HlsGroupSettings) SetAdMarkers(v []*string) *HlsGroupSettings {
	s.AdMarkers = v
	return s
}

// SetBaseUrlContent sets the BaseUrlContent field's value.
func (s *HlsGroupSettings) SetBaseUrlContent(v string) *HlsGroupSettings {
	s.BaseUrlContent = &v
	return s
}

// SetBaseUrlContent1 sets the BaseUrlContent1 field's value.
func (s *HlsGroupSettings) SetBaseUrlContent1(v string) *HlsGroupSettings {
	s.BaseUrlContent1 = &v
	return s
}

// SetBaseUrlManifest sets the BaseUrlManifest field's value.
func (s *HlsGroupSettings) SetBaseUrlManifest(v string) *HlsGroupSettings {
	s.BaseUrlManifest = &v
	return s
}

// SetBaseUrlManifest1 sets the BaseUrlManifest1 field's value.
func (s *HlsGroupSettings) SetBaseUrlManifest1(v string) *HlsGroupSettings {
	s.BaseUrlManifest1 = &v
	return s
}

// SetCaptionLanguageMappings sets the CaptionLanguageMappings field's value.
func (s *HlsGroupSettings) SetCaptionLanguageMappings(v []*CaptionLanguageMapping) *HlsGroupSettings {
	s.CaptionLanguageMappings = v
	return s
}

// SetCaptionLanguageSetting sets the CaptionLanguageSetting field's value.
func (s *HlsGroupSettings) SetCaptionLanguageSetting(v string) *HlsGroupSettings {
	s.CaptionLanguageSetting = &v
	return s
}

// SetClientCache sets the ClientCache field's value.
func (s *HlsGroupSettings) SetClientCache(v string) *HlsGroupSettings {
	s.ClientCache = &v
	return s
}

// SetCodecSpecification sets the CodecSpecification field's value.
func (s *HlsGroupSettings) SetCodecSpecification(v string) *HlsGroupSettings {
	s.CodecSpecification = &v
	return s
}

// SetConstantIv sets the ConstantIv field's value.
func (s *HlsGroupSettings) SetConstantIv(v string) *HlsGroupSettings {
	s.ConstantIv = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *HlsGroupSettings) SetDestination(v *OutputLocationRef) *HlsGroupSettings {
	s.Destination = v
	return s
}

// SetDirectoryStructure sets the DirectoryStructure field's value.
func (s *HlsGroupSettings) SetDirectoryStructure(v string) *HlsGroupSettings {
	s.DirectoryStructure = &v
	return s
}

// SetDiscontinuityTags sets the DiscontinuityTags field's value.
func (s *HlsGroupSettings) SetDiscontinuityTags(v string) *HlsGroupSettings {
	s.DiscontinuityTags = &v
	return s
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *HlsGroupSettings) SetEncryptionType(v string) *HlsGroupSettings {
	s.EncryptionType = &v
	return s
}

// SetHlsCdnSettings sets the HlsCdnSettings field's value.
func (s *HlsGroupSettings) SetHlsCdnSettings(v *HlsCdnSettings) *HlsGroupSettings {
	s.HlsCdnSettings = v
	return s
}

// SetHlsId3SegmentTagging sets the HlsId3SegmentTagging field's value.
func (s *HlsGroupSettings) SetHlsId3SegmentTagging(v string) *HlsGroupSettings {
	s.HlsId3SegmentTagging = &v
	return s
}

// SetIFrameOnlyPlaylists sets the IFrameOnlyPlaylists field's value.
func (s *HlsGroupSettings) SetIFrameOnlyPlaylists(v string) *HlsGroupSettings {
	s.IFrameOnlyPlaylists = &v
	return s
}

// SetIncompleteSegmentBehavior sets the IncompleteSegmentBehavior field's value.
func (s *HlsGroupSettings) SetIncompleteSegmentBehavior(v string) *HlsGroupSettings {
	s.IncompleteSegmentBehavior = &v
	return s
}

// SetIndexNSegments sets the IndexNSegments field's value.
func (s *HlsGroupSettings) SetIndexNSegments(v int64) *HlsGroupSettings {
	s.IndexNSegments = &v
	return s
}

// SetInputLossAction sets the InputLossAction field's value.
func (s *HlsGroupSettings) SetInputLossAction(v string) *HlsGroupSettings {
	s.InputLossAction = &v
	return s
}

// SetIvInManifest sets the IvInManifest field's value.
func (s *HlsGroupSettings) SetIvInManifest(v string) *HlsGroupSettings {
	s.IvInManifest = &v
	return s
}

// SetIvSource sets the IvSource field's value.
func (s *HlsGroupSettings) SetIvSource(v string) *HlsGroupSettings {
	s.IvSource = &v
	return s
}

// SetKeepSegments sets the KeepSegments field's value.
func (s *HlsGroupSettings) SetKeepSegments(v int64) *HlsGroupSettings {
	s.KeepSegments = &v
	return s
}

// SetKeyFormat sets the KeyFormat field's value.
func (s *HlsGroupSettings) SetKeyFormat(v string) *HlsGroupSettings {
	s.KeyFormat = &v
	return s
}

// SetKeyFormatVersions sets the KeyFormatVersions field's value.
func (s *HlsGroupSettings) SetKeyFormatVersions(v string) *HlsGroupSettings {
	s.KeyFormatVersions = &v
	return s
}

// SetKeyProviderSettings sets the KeyProviderSettings field's value.
func (s *HlsGroupSettings) SetKeyProviderSettings(v *KeyProviderSettings) *HlsGroupSettings {
	s.KeyProviderSettings = v
	return s
}

// SetManifestCompression sets the ManifestCompression field's value.
func (s *HlsGroupSettings) SetManifestCompression(v string) *HlsGroupSettings {
	s.ManifestCompression = &v
	return s
}

// SetManifestDurationFormat sets the ManifestDurationFormat field's value.
func (s *HlsGroupSettings) SetManifestDurationFormat(v string) *HlsGroupSettings {
	s.ManifestDurationFormat = &v
	return s
}

// SetMinSegmentLength sets the MinSegmentLength field's value.
func (s *HlsGroupSettings) SetMinSegmentLength(v int64) *HlsGroupSettings {
	s.MinSegmentLength = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *HlsGroupSettings) SetMode(v string) *HlsGroupSettings {
	s.Mode = &v
	return s
}

// SetOutputSelection sets the OutputSelection field's value.
func (s *HlsGroupSettings) SetOutputSelection(v string) *HlsGroupSettings {
	s.OutputSelection = &v
	return s
}

// SetProgramDateTime sets the ProgramDateTime field's value.
func (s *HlsGroupSettings) SetProgramDateTime(v string) *HlsGroupSettings {
	s.ProgramDateTime = &v
	return s
}

// SetProgramDateTimeClock sets the ProgramDateTimeClock field's value.
func (s *HlsGroupSettings) SetProgramDateTimeClock(v string) *HlsGroupSettings {
	s.ProgramDateTimeClock = &v
	return s
}

// SetProgramDateTimePeriod sets the ProgramDateTimePeriod field's value.
func (s *HlsGroupSettings) SetProgramDateTimePeriod(v int64) *HlsGroupSettings {
	s.ProgramDateTimePeriod = &v
	return s
}

// SetRedundantManifest sets the RedundantManifest field's value.
func (s *HlsGroupSettings) SetRedundantManifest(v string) *HlsGroupSettings {
	s.RedundantManifest = &v
	return s
}

// SetSegmentLength sets the SegmentLength field's value.
func (s *HlsGroupSettings) SetSegmentLength(v int64) *HlsGroupSettings {
	s.SegmentLength = &v
	return s
}

// SetSegmentationMode sets the SegmentationMode field's value.
func (s *HlsGroupSettings) SetSegmentationMode(v string) *HlsGroupSettings {
	s.SegmentationMode = &v
	return s
}

// SetSegmentsPerSubdirectory sets the SegmentsPerSubdirectory field's value.
func (s *HlsGroupSettings) SetSegmentsPerSubdirectory(v int64) *HlsGroupSettings {
	s.SegmentsPerSubdirectory = &v
	return s
}

// SetStreamInfResolution sets the StreamInfResolution field's value.
func (s *HlsGroupSettings) SetStreamInfResolution(v string) *HlsGroupSettings {
	s.StreamInfResolution = &v
	return s
}

// SetTimedMetadataId3Frame sets the TimedMetadataId3Frame field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Frame(v string) *HlsGroupSettings {
	s.TimedMetadataId3Frame = &v
	return s
}

// SetTimedMetadataId3Period sets the TimedMetadataId3Period field's value.
func (s *HlsGroupSettings) SetTimedMetadataId3Period(v int64) *HlsGroupSettings {
	s.TimedMetadataId3Period = &v
	return s
}

// SetTimestampDeltaMilliseconds sets the TimestampDeltaMilliseconds field's value.
func (s *HlsGroupSettings) SetTimestampDeltaMilliseconds(v int64) *HlsGroupSettings {
	s.TimestampDeltaMilliseconds = &v
	return s
}

// SetTsFileMode sets the TsFileMode field's value.
func (s *HlsGroupSettings) SetTsFileMode(v string) *HlsGroupSettings {
	s.TsFileMode = &v
	return s
}

// Settings for the action to insert a user-defined ID3 tag in each HLS segment
type HlsId3SegmentTaggingScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
	Id3 *string `locationName:"id3" type:"string"`

	// ID3 tag to insert into each segment. Supports special keyword identifiers
	// to substitute in segment-related values.\nSupported keyword identifiers:
	// https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
	Tag *string `locationName:"tag" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsId3SegmentTaggingScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsId3SegmentTaggingScheduleActionSettings) GoString() string {
	return s.String()
}

// SetId3 sets the Id3 field's value.
func (s *HlsId3SegmentTaggingScheduleActionSettings) SetId3(v string) *HlsId3SegmentTaggingScheduleActionSettings {
	s.Id3 = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *HlsId3SegmentTaggingScheduleActionSettings) SetTag(v string) *HlsId3SegmentTaggingScheduleActionSettings {
	s.Tag = &v
	return s
}

// Hls Input Settings
type HlsInputSettings struct {
	_ struct{} `type:"structure"`

	// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches
	// this value will be chosen, otherwise the highest bandwidth stream in the
	// m3u8 will be chosen. The bitrate is specified in bits per second, as in an
	// HLS manifest.
	Bandwidth *int64 `locationName:"bandwidth" type:"integer"`

	// When specified, reading of the HLS input will begin this many buffer segments
	// from the end (most recently written segment). When not specified, the HLS
	// input will begin with the first segment specified in the m3u8.
	BufferSegments *int64 `locationName:"bufferSegments" type:"integer"`

	// The number of consecutive times that attempts to read a manifest or segment
	// must fail before the input is considered unavailable.
	Retries *int64 `locationName:"retries" type:"integer"`

	// The number of seconds between retries when an attempt to read a manifest
	// or segment fails.
	RetryInterval *int64 `locationName:"retryInterval" type:"integer"`

	// Identifies the source for the SCTE-35 messages that MediaLive will ingest.
	// Messages can be ingested from the content segments (in the stream) or from
	// tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information
	// in the source that is not selected.
	Scte35Source *string `locationName:"scte35Source" type:"string" enum:"HlsScte35SourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsInputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsInputSettings) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *HlsInputSettings) SetBandwidth(v int64) *HlsInputSettings {
	s.Bandwidth = &v
	return s
}

// SetBufferSegments sets the BufferSegments field's value.
func (s *HlsInputSettings) SetBufferSegments(v int64) *HlsInputSettings {
	s.BufferSegments = &v
	return s
}

// SetRetries sets the Retries field's value.
func (s *HlsInputSettings) SetRetries(v int64) *HlsInputSettings {
	s.Retries = &v
	return s
}

// SetRetryInterval sets the RetryInterval field's value.
func (s *HlsInputSettings) SetRetryInterval(v int64) *HlsInputSettings {
	s.RetryInterval = &v
	return s
}

// SetScte35Source sets the Scte35Source field's value.
func (s *HlsInputSettings) SetScte35Source(v string) *HlsInputSettings {
	s.Scte35Source = &v
	return s
}

// Hls Media Store Settings
type HlsMediaStoreSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// When set to temporal, output files are stored in non-persistent memory for
	// faster reading and writing.
	MediaStoreStorageClass *string `locationName:"mediaStoreStorageClass" type:"string" enum:"HlsMediaStoreStorageClass"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state. Applies only if the CDN destination URI begins with "s3"
	// or "mediastore". For other URIs, the value is always 3.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsMediaStoreSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsMediaStoreSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsMediaStoreSettings) SetConnectionRetryInterval(v int64) *HlsMediaStoreSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsMediaStoreSettings) SetFilecacheDuration(v int64) *HlsMediaStoreSettings {
	s.FilecacheDuration = &v
	return s
}

// SetMediaStoreStorageClass sets the MediaStoreStorageClass field's value.
func (s *HlsMediaStoreSettings) SetMediaStoreStorageClass(v string) *HlsMediaStoreSettings {
	s.MediaStoreStorageClass = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsMediaStoreSettings) SetNumRetries(v int64) *HlsMediaStoreSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsMediaStoreSettings) SetRestartDelay(v int64) *HlsMediaStoreSettings {
	s.RestartDelay = &v
	return s
}

// Hls Output Settings
type HlsOutputSettings struct {
	_ struct{} `type:"structure"`

	// Only applicable when this output is referencing an H.265 video description.Specifies
	// whether MP4 segments should be packaged as HEV1 or HVC1.
	H265PackagingType *string `locationName:"h265PackagingType" type:"string" enum:"HlsH265PackagingType"`

	// Settings regarding the underlying stream. These settings are different for
	// audio-only outputs.
	//
	// HlsSettings is a required field
	HlsSettings *HlsSettings `locationName:"hlsSettings" type:"structure" required:"true"`

	// String concatenated to the end of the destination filename. Accepts \"Format
	// Identifiers\":#formatIdentifierParameters.
	NameModifier *string `locationName:"nameModifier" min:"1" type:"string"`

	// String concatenated to end of segment filenames.
	SegmentModifier *string `locationName:"segmentModifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsOutputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsOutputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsOutputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsOutputSettings"}
	if s.HlsSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("HlsSettings"))
	}
	if s.NameModifier != nil && len(*s.NameModifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameModifier", 1))
	}
	if s.HlsSettings != nil {
		if err := s.HlsSettings.Validate(); err != nil {
			invalidParams.AddNested("HlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetH265PackagingType sets the H265PackagingType field's value.
func (s *HlsOutputSettings) SetH265PackagingType(v string) *HlsOutputSettings {
	s.H265PackagingType = &v
	return s
}

// SetHlsSettings sets the HlsSettings field's value.
func (s *HlsOutputSettings) SetHlsSettings(v *HlsSettings) *HlsOutputSettings {
	s.HlsSettings = v
	return s
}

// SetNameModifier sets the NameModifier field's value.
func (s *HlsOutputSettings) SetNameModifier(v string) *HlsOutputSettings {
	s.NameModifier = &v
	return s
}

// SetSegmentModifier sets the SegmentModifier field's value.
func (s *HlsOutputSettings) SetSegmentModifier(v string) *HlsOutputSettings {
	s.SegmentModifier = &v
	return s
}

// Hls S3 Settings
type HlsS3Settings struct {
	_ struct{} `type:"structure"`

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl *string `locationName:"cannedAcl" type:"string" enum:"S3CannedAcl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsS3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsS3Settings) GoString() string {
	return s.String()
}

// SetCannedAcl sets the CannedAcl field's value.
func (s *HlsS3Settings) SetCannedAcl(v string) *HlsS3Settings {
	s.CannedAcl = &v
	return s
}

// Hls Settings
type HlsSettings struct {
	_ struct{} `type:"structure"`

	// Audio Only Hls Settings
	AudioOnlyHlsSettings *AudioOnlyHlsSettings `locationName:"audioOnlyHlsSettings" type:"structure"`

	// Fmp4 Hls Settings
	Fmp4HlsSettings *Fmp4HlsSettings `locationName:"fmp4HlsSettings" type:"structure"`

	// Frame Capture Hls Settings
	FrameCaptureHlsSettings *FrameCaptureHlsSettings `locationName:"frameCaptureHlsSettings" type:"structure"`

	// Standard Hls Settings
	StandardHlsSettings *StandardHlsSettings `locationName:"standardHlsSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsSettings"}
	if s.AudioOnlyHlsSettings != nil {
		if err := s.AudioOnlyHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("AudioOnlyHlsSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.StandardHlsSettings != nil {
		if err := s.StandardHlsSettings.Validate(); err != nil {
			invalidParams.AddNested("StandardHlsSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioOnlyHlsSettings sets the AudioOnlyHlsSettings field's value.
func (s *HlsSettings) SetAudioOnlyHlsSettings(v *AudioOnlyHlsSettings) *HlsSettings {
	s.AudioOnlyHlsSettings = v
	return s
}

// SetFmp4HlsSettings sets the Fmp4HlsSettings field's value.
func (s *HlsSettings) SetFmp4HlsSettings(v *Fmp4HlsSettings) *HlsSettings {
	s.Fmp4HlsSettings = v
	return s
}

// SetFrameCaptureHlsSettings sets the FrameCaptureHlsSettings field's value.
func (s *HlsSettings) SetFrameCaptureHlsSettings(v *FrameCaptureHlsSettings) *HlsSettings {
	s.FrameCaptureHlsSettings = v
	return s
}

// SetStandardHlsSettings sets the StandardHlsSettings field's value.
func (s *HlsSettings) SetStandardHlsSettings(v *StandardHlsSettings) *HlsSettings {
	s.StandardHlsSettings = v
	return s
}

// Settings for the action to emit HLS metadata
type HlsTimedMetadataScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure
	//
	// Id3 is a required field
	Id3 *string `locationName:"id3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsTimedMetadataScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsTimedMetadataScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HlsTimedMetadataScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HlsTimedMetadataScheduleActionSettings"}
	if s.Id3 == nil {
		invalidParams.Add(request.NewErrParamRequired("Id3"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId3 sets the Id3 field's value.
func (s *HlsTimedMetadataScheduleActionSettings) SetId3(v string) *HlsTimedMetadataScheduleActionSettings {
	s.Id3 = &v
	return s
}

// Hls Webdav Settings
type HlsWebdavSettings struct {
	_ struct{} `type:"structure"`

	// Number of seconds to wait before retrying connection to the CDN if the connection
	// is lost.
	ConnectionRetryInterval *int64 `locationName:"connectionRetryInterval" type:"integer"`

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration *int64 `locationName:"filecacheDuration" type:"integer"`

	// Specify whether or not to use chunked transfer encoding to WebDAV.
	HttpTransferMode *string `locationName:"httpTransferMode" type:"string" enum:"HlsWebdavHttpTransferMode"`

	// Number of retry attempts that will be made before the Live Event is put into
	// an error state. Applies only if the CDN destination URI begins with "s3"
	// or "mediastore". For other URIs, the value is always 3.
	NumRetries *int64 `locationName:"numRetries" type:"integer"`

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay *int64 `locationName:"restartDelay" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsWebdavSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HlsWebdavSettings) GoString() string {
	return s.String()
}

// SetConnectionRetryInterval sets the ConnectionRetryInterval field's value.
func (s *HlsWebdavSettings) SetConnectionRetryInterval(v int64) *HlsWebdavSettings {
	s.ConnectionRetryInterval = &v
	return s
}

// SetFilecacheDuration sets the FilecacheDuration field's value.
func (s *HlsWebdavSettings) SetFilecacheDuration(v int64) *HlsWebdavSettings {
	s.FilecacheDuration = &v
	return s
}

// SetHttpTransferMode sets the HttpTransferMode field's value.
func (s *HlsWebdavSettings) SetHttpTransferMode(v string) *HlsWebdavSettings {
	s.HttpTransferMode = &v
	return s
}

// SetNumRetries sets the NumRetries field's value.
func (s *HlsWebdavSettings) SetNumRetries(v int64) *HlsWebdavSettings {
	s.NumRetries = &v
	return s
}

// SetRestartDelay sets the RestartDelay field's value.
func (s *HlsWebdavSettings) SetRestartDelay(v int64) *HlsWebdavSettings {
	s.RestartDelay = &v
	return s
}

// Html Motion Graphics Settings
type HtmlMotionGraphicsSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HtmlMotionGraphicsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HtmlMotionGraphicsSettings) GoString() string {
	return s.String()
}

// Settings to configure an action so that it occurs as soon as possible.
type ImmediateModeScheduleActionStartSettings struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImmediateModeScheduleActionStartSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImmediateModeScheduleActionStartSettings) GoString() string {
	return s.String()
}

type Input struct {
	_ struct{} `type:"structure"`

	// The Unique ARN of the input (generated, immutable).
	Arn *string `locationName:"arn" type:"string"`

	// A list of channel IDs that that input is attached to (currently an input
	// can only be attached to one channel).
	AttachedChannels []*string `locationName:"attachedChannels" type:"list"`

	// A list of the destinations of the input (PUSH-type).
	Destinations []*InputDestination `locationName:"destinations" type:"list"`

	// The generated ID of the input (unique for user account, immutable).
	Id *string `locationName:"id" type:"string"`

	// STANDARD - MediaLive expects two sources to be connected to this input. If
	// the channel is also STANDARD, both sources will be ingested. If the channel
	// is SINGLE_PIPELINE, only the first source will be ingested; the second source
	// will always be ignored, even if the first source fails.SINGLE_PIPELINE -
	// You can connect only one source to this input. If the ChannelClass is also
	// SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this
	// value is not valid because the channel requires two sources in the input.
	InputClass *string `locationName:"inputClass" type:"string" enum:"InputClass"`

	// Settings for the input devices.
	InputDevices []*InputDeviceSettings `locationName:"inputDevices" type:"list"`

	// A list of IDs for all Inputs which are partners of this one.
	InputPartnerIds []*string `locationName:"inputPartnerIds" type:"list"`

	// Certain pull input sources can be dynamic, meaning that they can have their
	// URL's dynamically changesduring input switch actions. Presently, this functionality
	// only works with MP4_FILE and TS_FILE inputs.
	InputSourceType *string `locationName:"inputSourceType" type:"string" enum:"InputSourceType"`

	// A list of MediaConnect Flows for this input.
	MediaConnectFlows []*MediaConnectFlow `locationName:"mediaConnectFlows" type:"list"`

	// The user-assigned name (This is a mutable value).
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the role this input assumes during and
	// after creation.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A list of IDs for all the Input Security Groups attached to the input.
	SecurityGroups []*string `locationName:"securityGroups" type:"list"`

	// A list of the sources of the input (PULL-type).
	Sources []*InputSource `locationName:"sources" type:"list"`

	State *string `locationName:"state" type:"string" enum:"InputState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The different types of inputs that AWS Elemental MediaLive supports.
	Type *string `locationName:"type" type:"string" enum:"InputType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Input) SetArn(v string) *Input {
	s.Arn = &v
	return s
}

// SetAttachedChannels sets the AttachedChannels field's value.
func (s *Input) SetAttachedChannels(v []*string) *Input {
	s.AttachedChannels = v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *Input) SetDestinations(v []*InputDestination) *Input {
	s.Destinations = v
	return s
}

// SetId sets the Id field's value.
func (s *Input) SetId(v string) *Input {
	s.Id = &v
	return s
}

// SetInputClass sets the InputClass field's value.
func (s *Input) SetInputClass(v string) *Input {
	s.InputClass = &v
	return s
}

// SetInputDevices sets the InputDevices field's value.
func (s *Input) SetInputDevices(v []*InputDeviceSettings) *Input {
	s.InputDevices = v
	return s
}

// SetInputPartnerIds sets the InputPartnerIds field's value.
func (s *Input) SetInputPartnerIds(v []*string) *Input {
	s.InputPartnerIds = v
	return s
}

// SetInputSourceType sets the InputSourceType field's value.
func (s *Input) SetInputSourceType(v string) *Input {
	s.InputSourceType = &v
	return s
}

// SetMediaConnectFlows sets the MediaConnectFlows field's value.
func (s *Input) SetMediaConnectFlows(v []*MediaConnectFlow) *Input {
	s.MediaConnectFlows = v
	return s
}

// SetName sets the Name field's value.
func (s *Input) SetName(v string) *Input {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Input) SetRoleArn(v string) *Input {
	s.RoleArn = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Input) SetSecurityGroups(v []*string) *Input {
	s.SecurityGroups = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Input) SetSources(v []*InputSource) *Input {
	s.Sources = v
	return s
}

// SetState sets the State field's value.
func (s *Input) SetState(v string) *Input {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Input) SetTags(v map[string]*string) *Input {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *Input) SetType(v string) *Input {
	s.Type = &v
	return s
}

type InputAttachment struct {
	_ struct{} `type:"structure"`

	// User-specified settings for defining what the conditions are for declaring
	// the input unhealthy and failing over to a different input.
	AutomaticInputFailoverSettings *AutomaticInputFailoverSettings `locationName:"automaticInputFailoverSettings" type:"structure"`

	// User-specified name for the attachment. This is required if the user wants
	// to use this input in an input switch action.
	InputAttachmentName *string `locationName:"inputAttachmentName" type:"string"`

	// The ID of the input
	InputId *string `locationName:"inputId" type:"string"`

	// Settings of an input (caption selector, etc.)
	InputSettings *InputSettings `locationName:"inputSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputAttachment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputAttachment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputAttachment"}
	if s.AutomaticInputFailoverSettings != nil {
		if err := s.AutomaticInputFailoverSettings.Validate(); err != nil {
			invalidParams.AddNested("AutomaticInputFailoverSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSettings != nil {
		if err := s.InputSettings.Validate(); err != nil {
			invalidParams.AddNested("InputSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticInputFailoverSettings sets the AutomaticInputFailoverSettings field's value.
func (s *InputAttachment) SetAutomaticInputFailoverSettings(v *AutomaticInputFailoverSettings) *InputAttachment {
	s.AutomaticInputFailoverSettings = v
	return s
}

// SetInputAttachmentName sets the InputAttachmentName field's value.
func (s *InputAttachment) SetInputAttachmentName(v string) *InputAttachment {
	s.InputAttachmentName = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *InputAttachment) SetInputId(v string) *InputAttachment {
	s.InputId = &v
	return s
}

// SetInputSettings sets the InputSettings field's value.
func (s *InputAttachment) SetInputSettings(v *InputSettings) *InputAttachment {
	s.InputSettings = v
	return s
}

// Input Channel Level
type InputChannelLevel struct {
	_ struct{} `type:"structure"`

	// Remixing value. Units are in dB and acceptable values are within the range
	// from -60 (mute) and 6 dB.
	//
	// Gain is a required field
	Gain *int64 `locationName:"gain" type:"integer" required:"true"`

	// The index of the input channel used as a source.
	//
	// InputChannel is a required field
	InputChannel *int64 `locationName:"inputChannel" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputChannelLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputChannelLevel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputChannelLevel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputChannelLevel"}
	if s.Gain == nil {
		invalidParams.Add(request.NewErrParamRequired("Gain"))
	}
	if s.Gain != nil && *s.Gain < -60 {
		invalidParams.Add(request.NewErrParamMinValue("Gain", -60))
	}
	if s.InputChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("InputChannel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGain sets the Gain field's value.
func (s *InputChannelLevel) SetGain(v int64) *InputChannelLevel {
	s.Gain = &v
	return s
}

// SetInputChannel sets the InputChannel field's value.
func (s *InputChannelLevel) SetInputChannel(v int64) *InputChannelLevel {
	s.InputChannel = &v
	return s
}

// Settings to let you create a clip of the file input, in order to set up the
// input to ingest only a portion of the file.
type InputClippingSettings struct {
	_ struct{} `type:"structure"`

	// The source of the timecodes in the source being clipped.
	//
	// InputTimecodeSource is a required field
	InputTimecodeSource *string `locationName:"inputTimecodeSource" type:"string" required:"true" enum:"InputTimecodeSource"`

	// Settings to identify the start of the clip.
	StartTimecode *StartTimecode `locationName:"startTimecode" type:"structure"`

	// Settings to identify the end of the clip.
	StopTimecode *StopTimecode `locationName:"stopTimecode" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputClippingSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputClippingSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputClippingSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputClippingSettings"}
	if s.InputTimecodeSource == nil {
		invalidParams.Add(request.NewErrParamRequired("InputTimecodeSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputTimecodeSource sets the InputTimecodeSource field's value.
func (s *InputClippingSettings) SetInputTimecodeSource(v string) *InputClippingSettings {
	s.InputTimecodeSource = &v
	return s
}

// SetStartTimecode sets the StartTimecode field's value.
func (s *InputClippingSettings) SetStartTimecode(v *StartTimecode) *InputClippingSettings {
	s.StartTimecode = v
	return s
}

// SetStopTimecode sets the StopTimecode field's value.
func (s *InputClippingSettings) SetStopTimecode(v *StopTimecode) *InputClippingSettings {
	s.StopTimecode = v
	return s
}

// The settings for a PUSH type input.
type InputDestination struct {
	_ struct{} `type:"structure"`

	// The system-generated static IP address of endpoint.It remains fixed for the
	// lifetime of the input.
	Ip *string `locationName:"ip" type:"string"`

	// The port number for the input.
	Port *string `locationName:"port" type:"string"`

	// This represents the endpoint that the customer stream will bepushed to.
	Url *string `locationName:"url" type:"string"`

	// The properties for a VPC type input destination.
	Vpc *InputDestinationVpc `locationName:"vpc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestination) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *InputDestination) SetIp(v string) *InputDestination {
	s.Ip = &v
	return s
}

// SetPort sets the Port field's value.
func (s *InputDestination) SetPort(v string) *InputDestination {
	s.Port = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputDestination) SetUrl(v string) *InputDestination {
	s.Url = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *InputDestination) SetVpc(v *InputDestinationVpc) *InputDestination {
	s.Vpc = v
	return s
}

// Endpoint settings for a PUSH type input.
type InputDestinationRequest struct {
	_ struct{} `type:"structure"`

	// A unique name for the location the RTMP stream is being pushedto.
	StreamName *string `locationName:"streamName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestinationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestinationRequest) GoString() string {
	return s.String()
}

// SetStreamName sets the StreamName field's value.
func (s *InputDestinationRequest) SetStreamName(v string) *InputDestinationRequest {
	s.StreamName = &v
	return s
}

// The properties for a VPC type input destination.
type InputDestinationVpc struct {
	_ struct{} `type:"structure"`

	// The availability zone of the Input destination.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The network interface ID of the Input destination in the VPC.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestinationVpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDestinationVpc) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InputDestinationVpc) SetAvailabilityZone(v string) *InputDestinationVpc {
	s.AvailabilityZone = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *InputDestinationVpc) SetNetworkInterfaceId(v string) *InputDestinationVpc {
	s.NetworkInterfaceId = &v
	return s
}

// One audio configuration that specifies the format for one audio pair that
// the device produces as output.
type InputDeviceConfigurableAudioChannelPairConfig struct {
	_ struct{} `type:"structure"`

	// The ID for one audio pair configuration, a value from 1 to 8.
	Id *int64 `locationName:"id" type:"integer"`

	// The profile to set for one audio pair configuration. Choose an enumeration
	// value. Each value describes one audio configuration using the format (rate
	// control algorithm)-(codec)_(quality)-(bitrate in bytes). For example, CBR-AAC_HQ-192000.
	// Or choose DISABLED, in which case the device won't produce audio for this
	// pair.
	Profile *string `locationName:"profile" type:"string" enum:"InputDeviceConfigurableAudioChannelPairProfile"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceConfigurableAudioChannelPairConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceConfigurableAudioChannelPairConfig) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceConfigurableAudioChannelPairConfig) SetId(v int64) *InputDeviceConfigurableAudioChannelPairConfig {
	s.Id = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *InputDeviceConfigurableAudioChannelPairConfig) SetProfile(v string) *InputDeviceConfigurableAudioChannelPairConfig {
	s.Profile = &v
	return s
}

// Configurable settings for the input device.
type InputDeviceConfigurableSettings struct {
	_ struct{} `type:"structure"`

	// An array of eight audio configurations, one for each audio pair in the source.
	// Set up each audio configuration either to exclude the pair, or to format
	// it and include it in the output from the device. This parameter applies only
	// to UHD devices, and only when the device is configured as the source for
	// a MediaConnect flow. For an HD device, you configure the audio by setting
	// up audio selectors in the channel configuration.
	AudioChannelPairs []*InputDeviceConfigurableAudioChannelPairConfig `locationName:"audioChannelPairs" type:"list"`

	// Choose the codec for the video that the device produces. Only UHD devices
	// can specify this parameter.
	Codec *string `locationName:"codec" type:"string" enum:"InputDeviceCodec"`

	// The input source that you want to use. If the device has a source connected
	// to only one of its input ports, or if you don't care which source the device
	// sends, specify Auto. If the device has sources connected to both its input
	// ports, and you want to use a specific source, specify the source.
	ConfiguredInput *string `locationName:"configuredInput" type:"string" enum:"InputDeviceConfiguredInput"`

	// The Link device's buffer size (latency) in milliseconds (ms).
	LatencyMs *int64 `locationName:"latencyMs" type:"integer"`

	// The maximum bitrate in bits per second. Set a value here to throttle the
	// bitrate of the source video.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// To attach this device to a MediaConnect flow, specify these parameters. To
	// detach an existing flow, enter {} for the value of mediaconnectSettings.
	// Only UHD devices can specify this parameter.
	MediaconnectSettings *InputDeviceMediaConnectConfigurableSettings `locationName:"mediaconnectSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceConfigurableSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceConfigurableSettings) GoString() string {
	return s.String()
}

// SetAudioChannelPairs sets the AudioChannelPairs field's value.
func (s *InputDeviceConfigurableSettings) SetAudioChannelPairs(v []*InputDeviceConfigurableAudioChannelPairConfig) *InputDeviceConfigurableSettings {
	s.AudioChannelPairs = v
	return s
}

// SetCodec sets the Codec field's value.
func (s *InputDeviceConfigurableSettings) SetCodec(v string) *InputDeviceConfigurableSettings {
	s.Codec = &v
	return s
}

// SetConfiguredInput sets the ConfiguredInput field's value.
func (s *InputDeviceConfigurableSettings) SetConfiguredInput(v string) *InputDeviceConfigurableSettings {
	s.ConfiguredInput = &v
	return s
}

// SetLatencyMs sets the LatencyMs field's value.
func (s *InputDeviceConfigurableSettings) SetLatencyMs(v int64) *InputDeviceConfigurableSettings {
	s.LatencyMs = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *InputDeviceConfigurableSettings) SetMaxBitrate(v int64) *InputDeviceConfigurableSettings {
	s.MaxBitrate = &v
	return s
}

// SetMediaconnectSettings sets the MediaconnectSettings field's value.
func (s *InputDeviceConfigurableSettings) SetMediaconnectSettings(v *InputDeviceMediaConnectConfigurableSettings) *InputDeviceConfigurableSettings {
	s.MediaconnectSettings = v
	return s
}

// Settings that describe the active source from the input device, and the video
// characteristics of that source.
type InputDeviceHdSettings struct {
	_ struct{} `type:"structure"`

	// If you specified Auto as the configured input, specifies which of the sources
	// is currently active (SDI or HDMI).
	ActiveInput *string `locationName:"activeInput" type:"string" enum:"InputDeviceActiveInput"`

	// The source at the input device that is currently active. You can specify
	// this source.
	ConfiguredInput *string `locationName:"configuredInput" type:"string" enum:"InputDeviceConfiguredInput"`

	// The state of the input device.
	DeviceState *string `locationName:"deviceState" type:"string" enum:"InputDeviceState"`

	// The frame rate of the video source.
	Framerate *float64 `locationName:"framerate" type:"double"`

	// The height of the video source, in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The Link device's buffer size (latency) in milliseconds (ms). You can specify
	// this value.
	LatencyMs *int64 `locationName:"latencyMs" type:"integer"`

	// The current maximum bitrate for ingesting this source, in bits per second.
	// You can specify this maximum.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The scan type of the video source.
	ScanType *string `locationName:"scanType" type:"string" enum:"InputDeviceScanType"`

	// The width of the video source, in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceHdSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceHdSettings) GoString() string {
	return s.String()
}

// SetActiveInput sets the ActiveInput field's value.
func (s *InputDeviceHdSettings) SetActiveInput(v string) *InputDeviceHdSettings {
	s.ActiveInput = &v
	return s
}

// SetConfiguredInput sets the ConfiguredInput field's value.
func (s *InputDeviceHdSettings) SetConfiguredInput(v string) *InputDeviceHdSettings {
	s.ConfiguredInput = &v
	return s
}

// SetDeviceState sets the DeviceState field's value.
func (s *InputDeviceHdSettings) SetDeviceState(v string) *InputDeviceHdSettings {
	s.DeviceState = &v
	return s
}

// SetFramerate sets the Framerate field's value.
func (s *InputDeviceHdSettings) SetFramerate(v float64) *InputDeviceHdSettings {
	s.Framerate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *InputDeviceHdSettings) SetHeight(v int64) *InputDeviceHdSettings {
	s.Height = &v
	return s
}

// SetLatencyMs sets the LatencyMs field's value.
func (s *InputDeviceHdSettings) SetLatencyMs(v int64) *InputDeviceHdSettings {
	s.LatencyMs = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *InputDeviceHdSettings) SetMaxBitrate(v int64) *InputDeviceHdSettings {
	s.MaxBitrate = &v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *InputDeviceHdSettings) SetScanType(v string) *InputDeviceHdSettings {
	s.ScanType = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *InputDeviceHdSettings) SetWidth(v int64) *InputDeviceHdSettings {
	s.Width = &v
	return s
}

// Parameters required to attach a MediaConnect flow to the device.
type InputDeviceMediaConnectConfigurableSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the MediaConnect flow to attach this device to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN for the role that MediaLive assumes to access the attached flow and
	// secret. For more information about how to create this role, see the MediaLive
	// user guide.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN for the secret that holds the encryption key to encrypt the content
	// output by the device.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The name of the MediaConnect Flow source to stream to.
	SourceName *string `locationName:"sourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceMediaConnectConfigurableSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceMediaConnectConfigurableSettings) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *InputDeviceMediaConnectConfigurableSettings) SetFlowArn(v string) *InputDeviceMediaConnectConfigurableSettings {
	s.FlowArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *InputDeviceMediaConnectConfigurableSettings) SetRoleArn(v string) *InputDeviceMediaConnectConfigurableSettings {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *InputDeviceMediaConnectConfigurableSettings) SetSecretArn(v string) *InputDeviceMediaConnectConfigurableSettings {
	s.SecretArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *InputDeviceMediaConnectConfigurableSettings) SetSourceName(v string) *InputDeviceMediaConnectConfigurableSettings {
	s.SourceName = &v
	return s
}

// Information about the MediaConnect flow attached to the device.
type InputDeviceMediaConnectSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the MediaConnect flow.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN for the role that MediaLive assumes to access the attached flow and
	// secret.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN of the secret used to encrypt the stream.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The name of the MediaConnect flow source.
	SourceName *string `locationName:"sourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceMediaConnectSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceMediaConnectSettings) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *InputDeviceMediaConnectSettings) SetFlowArn(v string) *InputDeviceMediaConnectSettings {
	s.FlowArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *InputDeviceMediaConnectSettings) SetRoleArn(v string) *InputDeviceMediaConnectSettings {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *InputDeviceMediaConnectSettings) SetSecretArn(v string) *InputDeviceMediaConnectSettings {
	s.SecretArn = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *InputDeviceMediaConnectSettings) SetSourceName(v string) *InputDeviceMediaConnectSettings {
	s.SourceName = &v
	return s
}

// The network settings for the input device.
type InputDeviceNetworkSettings struct {
	_ struct{} `type:"structure"`

	// The DNS addresses of the input device.
	DnsAddresses []*string `locationName:"dnsAddresses" type:"list"`

	// The network gateway IP address.
	Gateway *string `locationName:"gateway" type:"string"`

	// The IP address of the input device.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// Specifies whether the input device has been configured (outside of MediaLive)
	// to use a dynamic IP address assignment (DHCP) or a static IP address.
	IpScheme *string `locationName:"ipScheme" type:"string" enum:"InputDeviceIpScheme"`

	// The subnet mask of the input device.
	SubnetMask *string `locationName:"subnetMask" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceNetworkSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceNetworkSettings) GoString() string {
	return s.String()
}

// SetDnsAddresses sets the DnsAddresses field's value.
func (s *InputDeviceNetworkSettings) SetDnsAddresses(v []*string) *InputDeviceNetworkSettings {
	s.DnsAddresses = v
	return s
}

// SetGateway sets the Gateway field's value.
func (s *InputDeviceNetworkSettings) SetGateway(v string) *InputDeviceNetworkSettings {
	s.Gateway = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InputDeviceNetworkSettings) SetIpAddress(v string) *InputDeviceNetworkSettings {
	s.IpAddress = &v
	return s
}

// SetIpScheme sets the IpScheme field's value.
func (s *InputDeviceNetworkSettings) SetIpScheme(v string) *InputDeviceNetworkSettings {
	s.IpScheme = &v
	return s
}

// SetSubnetMask sets the SubnetMask field's value.
func (s *InputDeviceNetworkSettings) SetSubnetMask(v string) *InputDeviceNetworkSettings {
	s.SubnetMask = &v
	return s
}

// Settings for an input device.
type InputDeviceRequest struct {
	_ struct{} `type:"structure"`

	// The unique ID for the device.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceRequest) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceRequest) SetId(v string) *InputDeviceRequest {
	s.Id = &v
	return s
}

// Settings for an input device.
type InputDeviceSettings struct {
	_ struct{} `type:"structure"`

	// The unique ID for the device.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceSettings) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceSettings) SetId(v string) *InputDeviceSettings {
	s.Id = &v
	return s
}

// Details of the input device.
type InputDeviceSummary struct {
	_ struct{} `type:"structure"`

	// The unique ARN of the input device.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with this input device.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The state of the connection between the input device and AWS.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"InputDeviceConnectionState"`

	// The status of the action to synchronize the device configuration. If you
	// change the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState *string `locationName:"deviceSettingsSyncState" type:"string" enum:"DeviceSettingsSyncState"`

	// The status of software on the input device.
	DeviceUpdateStatus *string `locationName:"deviceUpdateStatus" type:"string" enum:"DeviceUpdateStatus"`

	// Settings that describe an input device that is type HD.
	HdDeviceSettings *InputDeviceHdSettings `locationName:"hdDeviceSettings" type:"structure"`

	// The unique ID of the input device.
	Id *string `locationName:"id" type:"string"`

	// The network MAC address of the input device.
	MacAddress *string `locationName:"macAddress" type:"string"`

	// An array of the ARNs for the MediaLive inputs attached to the device. Returned
	// only if the outputType is MEDIALIVE_INPUT.
	MedialiveInputArns []*string `locationName:"medialiveInputArns" type:"list"`

	// A name that you specify for the input device.
	Name *string `locationName:"name" type:"string"`

	// Network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings `locationName:"networkSettings" type:"structure"`

	// The output attachment type of the input device. Specifies MEDIACONNECT_FLOW
	// if this device is the source for a MediaConnect flow. Specifies MEDIALIVE_INPUT
	// if this device is the source for a MediaLive input.
	OutputType *string `locationName:"outputType" type:"string" enum:"InputDeviceOutputType"`

	// The unique serial number of the input device.
	SerialNumber *string `locationName:"serialNumber" type:"string"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the input device.
	Type *string `locationName:"type" type:"string" enum:"InputDeviceType"`

	// Settings that describe an input device that is type UHD.
	UhdDeviceSettings *InputDeviceUhdSettings `locationName:"uhdDeviceSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InputDeviceSummary) SetArn(v string) *InputDeviceSummary {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *InputDeviceSummary) SetAvailabilityZone(v string) *InputDeviceSummary {
	s.AvailabilityZone = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *InputDeviceSummary) SetConnectionState(v string) *InputDeviceSummary {
	s.ConnectionState = &v
	return s
}

// SetDeviceSettingsSyncState sets the DeviceSettingsSyncState field's value.
func (s *InputDeviceSummary) SetDeviceSettingsSyncState(v string) *InputDeviceSummary {
	s.DeviceSettingsSyncState = &v
	return s
}

// SetDeviceUpdateStatus sets the DeviceUpdateStatus field's value.
func (s *InputDeviceSummary) SetDeviceUpdateStatus(v string) *InputDeviceSummary {
	s.DeviceUpdateStatus = &v
	return s
}

// SetHdDeviceSettings sets the HdDeviceSettings field's value.
func (s *InputDeviceSummary) SetHdDeviceSettings(v *InputDeviceHdSettings) *InputDeviceSummary {
	s.HdDeviceSettings = v
	return s
}

// SetId sets the Id field's value.
func (s *InputDeviceSummary) SetId(v string) *InputDeviceSummary {
	s.Id = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *InputDeviceSummary) SetMacAddress(v string) *InputDeviceSummary {
	s.MacAddress = &v
	return s
}

// SetMedialiveInputArns sets the MedialiveInputArns field's value.
func (s *InputDeviceSummary) SetMedialiveInputArns(v []*string) *InputDeviceSummary {
	s.MedialiveInputArns = v
	return s
}

// SetName sets the Name field's value.
func (s *InputDeviceSummary) SetName(v string) *InputDeviceSummary {
	s.Name = &v
	return s
}

// SetNetworkSettings sets the NetworkSettings field's value.
func (s *InputDeviceSummary) SetNetworkSettings(v *InputDeviceNetworkSettings) *InputDeviceSummary {
	s.NetworkSettings = v
	return s
}

// SetOutputType sets the OutputType field's value.
func (s *InputDeviceSummary) SetOutputType(v string) *InputDeviceSummary {
	s.OutputType = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *InputDeviceSummary) SetSerialNumber(v string) *InputDeviceSummary {
	s.SerialNumber = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InputDeviceSummary) SetTags(v map[string]*string) *InputDeviceSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *InputDeviceSummary) SetType(v string) *InputDeviceSummary {
	s.Type = &v
	return s
}

// SetUhdDeviceSettings sets the UhdDeviceSettings field's value.
func (s *InputDeviceSummary) SetUhdDeviceSettings(v *InputDeviceUhdSettings) *InputDeviceSummary {
	s.UhdDeviceSettings = v
	return s
}

// One audio configuration that specifies the format for one audio pair that
// the device produces as output.
type InputDeviceUhdAudioChannelPairConfig struct {
	_ struct{} `type:"structure"`

	// The ID for one audio pair configuration, a value from 1 to 8.
	Id *int64 `locationName:"id" type:"integer"`

	// The profile for one audio pair configuration. This property describes one
	// audio configuration in the format (rate control algorithm)-(codec)_(quality)-(bitrate
	// in bytes). For example, CBR-AAC_HQ-192000. Or DISABLED, in which case the
	// device won't produce audio for this pair.
	Profile *string `locationName:"profile" type:"string" enum:"InputDeviceUhdAudioChannelPairProfile"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceUhdAudioChannelPairConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceUhdAudioChannelPairConfig) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *InputDeviceUhdAudioChannelPairConfig) SetId(v int64) *InputDeviceUhdAudioChannelPairConfig {
	s.Id = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *InputDeviceUhdAudioChannelPairConfig) SetProfile(v string) *InputDeviceUhdAudioChannelPairConfig {
	s.Profile = &v
	return s
}

// Settings that describe the active source from the input device, and the video
// characteristics of that source.
type InputDeviceUhdSettings struct {
	_ struct{} `type:"structure"`

	// If you specified Auto as the configured input, specifies which of the sources
	// is currently active (SDI or HDMI).
	ActiveInput *string `locationName:"activeInput" type:"string" enum:"InputDeviceActiveInput"`

	// An array of eight audio configurations, one for each audio pair in the source.
	// Each audio configuration specifies either to exclude the pair, or to format
	// it and include it in the output from the UHD device. Applies only when the
	// device is configured as the source for a MediaConnect flow.
	AudioChannelPairs []*InputDeviceUhdAudioChannelPairConfig `locationName:"audioChannelPairs" type:"list"`

	// The codec for the video that the device produces.
	Codec *string `locationName:"codec" type:"string" enum:"InputDeviceCodec"`

	// The source at the input device that is currently active. You can specify
	// this source.
	ConfiguredInput *string `locationName:"configuredInput" type:"string" enum:"InputDeviceConfiguredInput"`

	// The state of the input device.
	DeviceState *string `locationName:"deviceState" type:"string" enum:"InputDeviceState"`

	// The frame rate of the video source.
	Framerate *float64 `locationName:"framerate" type:"double"`

	// The height of the video source, in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The Link device's buffer size (latency) in milliseconds (ms). You can specify
	// this value.
	LatencyMs *int64 `locationName:"latencyMs" type:"integer"`

	// The current maximum bitrate for ingesting this source, in bits per second.
	// You can specify this maximum.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// Information about the MediaConnect flow attached to the device. Returned
	// only if the outputType is MEDIACONNECT_FLOW.
	MediaconnectSettings *InputDeviceMediaConnectSettings `locationName:"mediaconnectSettings" type:"structure"`

	// The scan type of the video source.
	ScanType *string `locationName:"scanType" type:"string" enum:"InputDeviceScanType"`

	// The width of the video source, in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceUhdSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDeviceUhdSettings) GoString() string {
	return s.String()
}

// SetActiveInput sets the ActiveInput field's value.
func (s *InputDeviceUhdSettings) SetActiveInput(v string) *InputDeviceUhdSettings {
	s.ActiveInput = &v
	return s
}

// SetAudioChannelPairs sets the AudioChannelPairs field's value.
func (s *InputDeviceUhdSettings) SetAudioChannelPairs(v []*InputDeviceUhdAudioChannelPairConfig) *InputDeviceUhdSettings {
	s.AudioChannelPairs = v
	return s
}

// SetCodec sets the Codec field's value.
func (s *InputDeviceUhdSettings) SetCodec(v string) *InputDeviceUhdSettings {
	s.Codec = &v
	return s
}

// SetConfiguredInput sets the ConfiguredInput field's value.
func (s *InputDeviceUhdSettings) SetConfiguredInput(v string) *InputDeviceUhdSettings {
	s.ConfiguredInput = &v
	return s
}

// SetDeviceState sets the DeviceState field's value.
func (s *InputDeviceUhdSettings) SetDeviceState(v string) *InputDeviceUhdSettings {
	s.DeviceState = &v
	return s
}

// SetFramerate sets the Framerate field's value.
func (s *InputDeviceUhdSettings) SetFramerate(v float64) *InputDeviceUhdSettings {
	s.Framerate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *InputDeviceUhdSettings) SetHeight(v int64) *InputDeviceUhdSettings {
	s.Height = &v
	return s
}

// SetLatencyMs sets the LatencyMs field's value.
func (s *InputDeviceUhdSettings) SetLatencyMs(v int64) *InputDeviceUhdSettings {
	s.LatencyMs = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *InputDeviceUhdSettings) SetMaxBitrate(v int64) *InputDeviceUhdSettings {
	s.MaxBitrate = &v
	return s
}

// SetMediaconnectSettings sets the MediaconnectSettings field's value.
func (s *InputDeviceUhdSettings) SetMediaconnectSettings(v *InputDeviceMediaConnectSettings) *InputDeviceUhdSettings {
	s.MediaconnectSettings = v
	return s
}

// SetScanType sets the ScanType field's value.
func (s *InputDeviceUhdSettings) SetScanType(v string) *InputDeviceUhdSettings {
	s.ScanType = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *InputDeviceUhdSettings) SetWidth(v int64) *InputDeviceUhdSettings {
	s.Width = &v
	return s
}

// Input Location
type InputLocation struct {
	_ struct{} `type:"structure"`

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// Uniform Resource Identifier - This should be a path to a file accessible
	// to the Live system (eg. a http:// URI) depending on the output type. For
	// example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
	//
	// Uri is a required field
	Uri *string `locationName:"uri" type:"string" required:"true"`

	// Username if credentials are required to access a file or publishing point.
	// This can be either a plaintext username, or a reference to an AWS parameter
	// store name from which the username can be retrieved. AWS Parameter store
	// format: "ssm://"
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLocation"}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputLocation) SetPasswordParam(v string) *InputLocation {
	s.PasswordParam = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *InputLocation) SetUri(v string) *InputLocation {
	s.Uri = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputLocation) SetUsername(v string) *InputLocation {
	s.Username = &v
	return s
}

// Input Loss Behavior
type InputLossBehavior struct {
	_ struct{} `type:"structure"`

	// On input loss, the number of milliseconds to substitute black into the output
	// before switching to the frame specified by inputLossImageType. A value x,
	// where 0
	BlackFrameMsec *int64 `locationName:"blackFrameMsec" type:"integer"`

	// When input loss image type is "color" this field specifies the color to use.
	// Value: 6 hex characters representing the values of RGB.
	InputLossImageColor *string `locationName:"inputLossImageColor" min:"6" type:"string"`

	// When input loss image type is "slate" these fields specify the parameters
	// for accessing the slate.
	InputLossImageSlate *InputLocation `locationName:"inputLossImageSlate" type:"structure"`

	// Indicates whether to substitute a solid color or a slate into the output
	// after input loss exceeds blackFrameMsec.
	InputLossImageType *string `locationName:"inputLossImageType" type:"string" enum:"InputLossImageType"`

	// On input loss, the number of milliseconds to repeat the previous picture
	// before substituting black into the output. A value x, where 0
	RepeatFrameMsec *int64 `locationName:"repeatFrameMsec" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLossBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLossBehavior) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLossBehavior) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLossBehavior"}
	if s.InputLossImageColor != nil && len(*s.InputLossImageColor) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("InputLossImageColor", 6))
	}
	if s.InputLossImageSlate != nil {
		if err := s.InputLossImageSlate.Validate(); err != nil {
			invalidParams.AddNested("InputLossImageSlate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackFrameMsec sets the BlackFrameMsec field's value.
func (s *InputLossBehavior) SetBlackFrameMsec(v int64) *InputLossBehavior {
	s.BlackFrameMsec = &v
	return s
}

// SetInputLossImageColor sets the InputLossImageColor field's value.
func (s *InputLossBehavior) SetInputLossImageColor(v string) *InputLossBehavior {
	s.InputLossImageColor = &v
	return s
}

// SetInputLossImageSlate sets the InputLossImageSlate field's value.
func (s *InputLossBehavior) SetInputLossImageSlate(v *InputLocation) *InputLossBehavior {
	s.InputLossImageSlate = v
	return s
}

// SetInputLossImageType sets the InputLossImageType field's value.
func (s *InputLossBehavior) SetInputLossImageType(v string) *InputLossBehavior {
	s.InputLossImageType = &v
	return s
}

// SetRepeatFrameMsec sets the RepeatFrameMsec field's value.
func (s *InputLossBehavior) SetRepeatFrameMsec(v int64) *InputLossBehavior {
	s.RepeatFrameMsec = &v
	return s
}

// MediaLive will perform a failover if content is not detected in this input
// for the specified period.
type InputLossFailoverSettings struct {
	_ struct{} `type:"structure"`

	// The amount of time (in milliseconds) that no input is detected. After that
	// time, an input failover will occur.
	InputLossThresholdMsec *int64 `locationName:"inputLossThresholdMsec" min:"100" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLossFailoverSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLossFailoverSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLossFailoverSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLossFailoverSettings"}
	if s.InputLossThresholdMsec != nil && *s.InputLossThresholdMsec < 100 {
		invalidParams.Add(request.NewErrParamMinValue("InputLossThresholdMsec", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLossThresholdMsec sets the InputLossThresholdMsec field's value.
func (s *InputLossFailoverSettings) SetInputLossThresholdMsec(v int64) *InputLossFailoverSettings {
	s.InputLossThresholdMsec = &v
	return s
}

// Action to prepare an input for a future immediate input switch.
type InputPrepareScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The name of the input attachment that should be prepared by this action.
	// If no name is provided, the action will stop the most recent prepare (if
	// any) when activated.
	InputAttachmentNameReference *string `locationName:"inputAttachmentNameReference" type:"string"`

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings `locationName:"inputClippingSettings" type:"structure"`

	// The value for the variable portion of the URL for the dynamic input, for
	// this instance of the input. Each time you use the same dynamic input in an
	// input switch action, you can provide a different value, in order to connect
	// the input to a different content source.
	UrlPath []*string `locationName:"urlPath" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputPrepareScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputPrepareScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputPrepareScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputPrepareScheduleActionSettings"}
	if s.InputClippingSettings != nil {
		if err := s.InputClippingSettings.Validate(); err != nil {
			invalidParams.AddNested("InputClippingSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputAttachmentNameReference sets the InputAttachmentNameReference field's value.
func (s *InputPrepareScheduleActionSettings) SetInputAttachmentNameReference(v string) *InputPrepareScheduleActionSettings {
	s.InputAttachmentNameReference = &v
	return s
}

// SetInputClippingSettings sets the InputClippingSettings field's value.
func (s *InputPrepareScheduleActionSettings) SetInputClippingSettings(v *InputClippingSettings) *InputPrepareScheduleActionSettings {
	s.InputClippingSettings = v
	return s
}

// SetUrlPath sets the UrlPath field's value.
func (s *InputPrepareScheduleActionSettings) SetUrlPath(v []*string) *InputPrepareScheduleActionSettings {
	s.UrlPath = v
	return s
}

// An Input Security Group
type InputSecurityGroup struct {
	_ struct{} `type:"structure"`

	// Unique ARN of Input Security Group
	Arn *string `locationName:"arn" type:"string"`

	// The Id of the Input Security Group
	Id *string `locationName:"id" type:"string"`

	// The list of inputs currently using this Input Security Group.
	Inputs []*string `locationName:"inputs" type:"list"`

	// The current state of the Input Security Group.
	State *string `locationName:"state" type:"string" enum:"InputSecurityGroupState"`

	// A collection of key-value pairs.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Whitelist rules and their sync status
	WhitelistRules []*InputWhitelistRule `locationName:"whitelistRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSecurityGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InputSecurityGroup) SetArn(v string) *InputSecurityGroup {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *InputSecurityGroup) SetId(v string) *InputSecurityGroup {
	s.Id = &v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *InputSecurityGroup) SetInputs(v []*string) *InputSecurityGroup {
	s.Inputs = v
	return s
}

// SetState sets the State field's value.
func (s *InputSecurityGroup) SetState(v string) *InputSecurityGroup {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InputSecurityGroup) SetTags(v map[string]*string) *InputSecurityGroup {
	s.Tags = v
	return s
}

// SetWhitelistRules sets the WhitelistRules field's value.
func (s *InputSecurityGroup) SetWhitelistRules(v []*InputWhitelistRule) *InputSecurityGroup {
	s.WhitelistRules = v
	return s
}

// Live Event input parameters. There can be multiple inputs in a single Live
// Event.
type InputSettings struct {
	_ struct{} `type:"structure"`

	// Used to select the audio stream to decode for inputs that have multiple available.
	AudioSelectors []*AudioSelector `locationName:"audioSelectors" type:"list"`

	// Used to select the caption input to use for inputs that have multiple available.
	CaptionSelectors []*CaptionSelector `locationName:"captionSelectors" type:"list"`

	// Enable or disable the deblock filter when filtering.
	DeblockFilter *string `locationName:"deblockFilter" type:"string" enum:"InputDeblockFilter"`

	// Enable or disable the denoise filter when filtering.
	DenoiseFilter *string `locationName:"denoiseFilter" type:"string" enum:"InputDenoiseFilter"`

	// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
	FilterStrength *int64 `locationName:"filterStrength" min:"1" type:"integer"`

	// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter
	// enabled by default.1) auto - filtering will be applied depending on input
	// type/quality2) disabled - no filtering will be applied to the input3) forced
	// - filtering will be applied regardless of input type
	InputFilter *string `locationName:"inputFilter" type:"string" enum:"InputFilter"`

	// Input settings.
	NetworkInputSettings *NetworkInputSettings `locationName:"networkInputSettings" type:"structure"`

	// PID from which to read SCTE-35 messages. If left undefined, EML will select
	// the first SCTE-35 PID found in the input.
	Scte35Pid *int64 `locationName:"scte35Pid" min:"32" type:"integer"`

	// Specifies whether to extract applicable ancillary data from a SMPTE-2038
	// source in this input. Applicable data types are captions, timecode, AFD,
	// and SCTE-104 messages.- PREFER: Extract from SMPTE-2038 if present in this
	// input, otherwise extract from another source (if any).- IGNORE: Never extract
	// any ancillary data from SMPTE-2038.
	Smpte2038DataPreference *string `locationName:"smpte2038DataPreference" type:"string" enum:"Smpte2038DataPreference"`

	// Loop input if it is a file. This allows a file input to be streamed indefinitely.
	SourceEndBehavior *string `locationName:"sourceEndBehavior" type:"string" enum:"InputSourceEndBehavior"`

	// Informs which video elementary stream to decode for input types that have
	// multiple available.
	VideoSelector *VideoSelector `locationName:"videoSelector" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSettings"}
	if s.FilterStrength != nil && *s.FilterStrength < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FilterStrength", 1))
	}
	if s.Scte35Pid != nil && *s.Scte35Pid < 32 {
		invalidParams.Add(request.NewErrParamMinValue("Scte35Pid", 32))
	}
	if s.AudioSelectors != nil {
		for i, v := range s.AudioSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AudioSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CaptionSelectors != nil {
		for i, v := range s.CaptionSelectors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSelectors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioSelectors sets the AudioSelectors field's value.
func (s *InputSettings) SetAudioSelectors(v []*AudioSelector) *InputSettings {
	s.AudioSelectors = v
	return s
}

// SetCaptionSelectors sets the CaptionSelectors field's value.
func (s *InputSettings) SetCaptionSelectors(v []*CaptionSelector) *InputSettings {
	s.CaptionSelectors = v
	return s
}

// SetDeblockFilter sets the DeblockFilter field's value.
func (s *InputSettings) SetDeblockFilter(v string) *InputSettings {
	s.DeblockFilter = &v
	return s
}

// SetDenoiseFilter sets the DenoiseFilter field's value.
func (s *InputSettings) SetDenoiseFilter(v string) *InputSettings {
	s.DenoiseFilter = &v
	return s
}

// SetFilterStrength sets the FilterStrength field's value.
func (s *InputSettings) SetFilterStrength(v int64) *InputSettings {
	s.FilterStrength = &v
	return s
}

// SetInputFilter sets the InputFilter field's value.
func (s *InputSettings) SetInputFilter(v string) *InputSettings {
	s.InputFilter = &v
	return s
}

// SetNetworkInputSettings sets the NetworkInputSettings field's value.
func (s *InputSettings) SetNetworkInputSettings(v *NetworkInputSettings) *InputSettings {
	s.NetworkInputSettings = v
	return s
}

// SetScte35Pid sets the Scte35Pid field's value.
func (s *InputSettings) SetScte35Pid(v int64) *InputSettings {
	s.Scte35Pid = &v
	return s
}

// SetSmpte2038DataPreference sets the Smpte2038DataPreference field's value.
func (s *InputSettings) SetSmpte2038DataPreference(v string) *InputSettings {
	s.Smpte2038DataPreference = &v
	return s
}

// SetSourceEndBehavior sets the SourceEndBehavior field's value.
func (s *InputSettings) SetSourceEndBehavior(v string) *InputSettings {
	s.SourceEndBehavior = &v
	return s
}

// SetVideoSelector sets the VideoSelector field's value.
func (s *InputSettings) SetVideoSelector(v *VideoSelector) *InputSettings {
	s.VideoSelector = v
	return s
}

// The settings for a PULL type input.
type InputSource struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSource) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSource) SetPasswordParam(v string) *InputSource {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSource) SetUrl(v string) *InputSource {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSource) SetUsername(v string) *InputSource {
	s.Username = &v
	return s
}

// Settings for for a PULL type input.
type InputSourceRequest struct {
	_ struct{} `type:"structure"`

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string `locationName:"passwordParam" type:"string"`

	// This represents the customer's source URL where stream ispulled from.
	Url *string `locationName:"url" type:"string"`

	// The username for the input source.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSourceRequest) GoString() string {
	return s.String()
}

// SetPasswordParam sets the PasswordParam field's value.
func (s *InputSourceRequest) SetPasswordParam(v string) *InputSourceRequest {
	s.PasswordParam = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *InputSourceRequest) SetUrl(v string) *InputSourceRequest {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InputSourceRequest) SetUsername(v string) *InputSourceRequest {
	s.Username = &v
	return s
}

type InputSpecification struct {
	_ struct{} `type:"structure"`

	// Input codec
	Codec *string `locationName:"codec" type:"string" enum:"InputCodec"`

	// Maximum input bitrate, categorized coarsely
	MaximumBitrate *string `locationName:"maximumBitrate" type:"string" enum:"InputMaximumBitrate"`

	// Input resolution, categorized coarsely
	Resolution *string `locationName:"resolution" type:"string" enum:"InputResolution"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSpecification) GoString() string {
	return s.String()
}

// SetCodec sets the Codec field's value.
func (s *InputSpecification) SetCodec(v string) *InputSpecification {
	s.Codec = &v
	return s
}

// SetMaximumBitrate sets the MaximumBitrate field's value.
func (s *InputSpecification) SetMaximumBitrate(v string) *InputSpecification {
	s.MaximumBitrate = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *InputSpecification) SetResolution(v string) *InputSpecification {
	s.Resolution = &v
	return s
}

// Settings for the "switch input" action: to switch from ingesting one input
// to ingesting another input.
type InputSwitchScheduleActionSettings struct {
	_ struct{} `type:"structure"`

	// The name of the input attachment (not the name of the input!) to switch to.
	// The name is specified in the channel configuration.
	//
	// InputAttachmentNameReference is a required field
	InputAttachmentNameReference *string `locationName:"inputAttachmentNameReference" type:"string" required:"true"`

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings `locationName:"inputClippingSettings" type:"structure"`

	// The value for the variable portion of the URL for the dynamic input, for
	// this instance of the input. Each time you use the same dynamic input in an
	// input switch action, you can provide a different value, in order to connect
	// the input to a different content source.
	UrlPath []*string `locationName:"urlPath" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSwitchScheduleActionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSwitchScheduleActionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSwitchScheduleActionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSwitchScheduleActionSettings"}
	if s.InputAttachmentNameReference == nil {
		invalidParams.Add(request.NewErrParamRequired("InputAttachmentNameReference"))
	}
	if s.InputClippingSettings != nil {
		if err := s.InputClippingSettings.Validate(); err != nil {
			invalidParams.AddNested("InputClippingSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputAttachmentNameReference sets the InputAttachmentNameReference field's value.
func (s *InputSwitchScheduleActionSettings) SetInputAttachmentNameReference(v string) *InputSwitchScheduleActionSettings {
	s.InputAttachmentNameReference = &v
	return s
}

// SetInputClippingSettings sets the InputClippingSettings field's value.
func (s *InputSwitchScheduleActionSettings) SetInputClippingSettings(v *InputClippingSettings) *InputSwitchScheduleActionSettings {
	s.InputClippingSettings = v
	return s
}

// SetUrlPath sets the UrlPath field's value.
func (s *InputSwitchScheduleActionSettings) SetUrlPath(v []*string) *InputSwitchScheduleActionSettings {
	s.UrlPath = v
	return s
}

// Settings for a private VPC Input.When this property is specified, the input
// destination addresses will be created in a VPC rather than with public Internet
// addresses.This property requires setting the roleArn property on Input creation.Not
// compatible with the inputSecurityGroups property.
type InputVpcRequest struct {
	_ struct{} `type:"structure"`

	// A list of up to 5 EC2 VPC security group IDs to attach to the Input VPC network
	// interfaces.Requires subnetIds. If none are specified then the VPC default
	// security group will be used.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// A list of 2 VPC subnet IDs from the same VPC.Subnet IDs must be mapped to
	// two unique availability zones (AZ).
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputVpcRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputVpcRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputVpcRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputVpcRequest"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *InputVpcRequest) SetSecurityGroupIds(v []*string) *InputVpcRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *InputVpcRequest) SetSubnetIds(v []*string) *InputVpcRequest {
	s.SubnetIds = v
	return s
}

// Whitelist rule
type InputWhitelistRule struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR that's whitelisted.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputWhitelistRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputWhitelistRule) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRule) SetCidr(v string) *InputWhitelistRule {
	s.Cidr = &v
	return s
}

// An IPv4 CIDR to whitelist.
type InputWhitelistRuleCidr struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR to whitelist.
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputWhitelistRuleCidr) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputWhitelistRuleCidr) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *InputWhitelistRuleCidr) SetCidr(v string) *InputWhitelistRuleCidr {
	s.Cidr = &v
	return s
}

type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Key Provider Settings
type KeyProviderSettings struct {
	_ struct{} `type:"structure"`

	// Static Key Settings
	StaticKeySettings *StaticKeySettings `locationName:"staticKeySettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyProviderSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyProviderSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyProviderSettings"}
	if s.StaticKeySettings != nil {
		if err := s.StaticKeySettings.Validate(); err != nil {
			invalidParams.AddNested("StaticKeySettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticKeySettings sets the StaticKeySettings field's value.
func (s *KeyProviderSettings) SetStaticKeySettings(v *StaticKeySettings) *KeyProviderSettings {
	s.StaticKeySettings = v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	Channels []*ChannelSummary `locationName:"channels" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListChannelsOutput) SetChannels(v []*ChannelSummary) *ListChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

type ListCloudWatchAlarmTemplateGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	Scope *string `location:"querystring" locationName:"scope" type:"string"`

	SignalMapIdentifier *string `location:"querystring" locationName:"signalMapIdentifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCloudWatchAlarmTemplateGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCloudWatchAlarmTemplateGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCloudWatchAlarmTemplateGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCloudWatchAlarmTemplateGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCloudWatchAlarmTemplateGroupsInput) SetMaxResults(v int64) *ListCloudWatchAlarmTemplateGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCloudWatchAlarmTemplateGroupsInput) SetNextToken(v string) *ListCloudWatchAlarmTemplateGroupsInput {
	s.NextToken = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListCloudWatchAlarmTemplateGroupsInput) SetScope(v string) *ListCloudWatchAlarmTemplateGroupsInput {
	s.Scope = &v
	return s
}

// SetSignalMapIdentifier sets the SignalMapIdentifier field's value.
func (s *ListCloudWatchAlarmTemplateGroupsInput) SetSignalMapIdentifier(v string) *ListCloudWatchAlarmTemplateGroupsInput {
	s.SignalMapIdentifier = &v
	return s
}

type ListCloudWatchAlarmTemplateGroupsOutput struct {
	_ struct{} `type:"structure"`

	CloudWatchAlarmTemplateGroups []*CloudWatchAlarmTemplateGroupSummary `locationName:"cloudWatchAlarmTemplateGroups" type:"list"`

	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCloudWatchAlarmTemplateGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCloudWatchAlarmTemplateGroupsOutput) GoString() string {
	return s.String()
}

// SetCloudWatchAlarmTemplateGroups sets the CloudWatchAlarmTemplateGroups field's value.
func (s *ListCloudWatchAlarmTemplateGroupsOutput) SetCloudWatchAlarmTemplateGroups(v []*CloudWatchAlarmTemplateGroupSummary) *ListCloudWatchAlarmTemplateGroupsOutput {
	s.CloudWatchAlarmTemplateGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCloudWatchAlarmTemplateG