// Source: https://github.com/atlassian/react-beautiful-dnd

export var origin = {
  x: 0,
  y: 0
};

// used to apply any function to both values of a point
// eg: const floor = apply(Math.floor)(point);
export var apply = function apply(fn) {
  return function (point) {
    return {
      x: fn(point.x),
      y: fn(point.y)
    };
  };
};
export var isEqual = function isEqual(point1, point2) {
  return point1.x === point2.x && point1.y === point2.y;
};
export var add = function add(point1, point2) {
  return {
    x: point1.x + point2.x,
    y: point1.y + point2.y
  };
};
export var subtract = function subtract(point1, point2) {
  return {
    x: point1.x - point2.x,
    y: point1.y - point2.y
  };
};