"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClosestScrollableElement = void 0;
// Source: https://github.com/atlassian/react-beautiful-dnd

var isEqual = function isEqual(base) {
  return function (value) {
    return base === value;
  };
};
var isScroll = isEqual('scroll');
var isAuto = isEqual('auto');
var isEither = function isEither(overflow, fn) {
  return fn(overflow.overflowX) || fn(overflow.overflowY);
};
var isElementScrollable = function isElementScrollable(el) {
  var style = window.getComputedStyle(el);
  var overflow = {
    overflowX: style.overflowX,
    overflowY: style.overflowY
  };
  return isEither(overflow, isScroll) || isEither(overflow, isAuto);
};
var _getClosestScrollableElement = exports.getClosestScrollableElement = function getClosestScrollableElement(el) {
  // cannot do anything else!
  if (!el) {
    return null;
  }

  // not allowing us to go higher then body
  if (el === document.body || el === document.documentElement) {
    return null;
  }
  if (!isElementScrollable(el)) {
    // keep recursing
    return _getClosestScrollableElement(el.parentElement);
  }

  // success!
  return el;
};