/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KDCReq {
    public KDCReqBody reqBody;
    public PAData[] pAData = null;
    private int pvno;
    private int msgType;

    public KDCReq(PAData[] pADataArray, KDCReqBody kDCReqBody, int n) throws IOException {
        this.pvno = 5;
        this.msgType = n;
        if (pADataArray != null) {
            this.pAData = new PAData[pADataArray.length];
            for (int i = 0; i < pADataArray.length; ++i) {
                if (pADataArray[i] == null) {
                    throw new IOException("Cannot create a KDCRep");
                }
                this.pAData[i] = (PAData)pADataArray[i].clone();
            }
        }
        this.reqBody = kDCReqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] byArray, int n) throws Asn1Exception, IOException, KrbException {
        this.init(new DerValue(byArray), n);
    }

    public KDCReq(DerValue derValue, int n) throws Asn1Exception, IOException, KrbException {
        this.init(derValue, n);
    }

    protected void init(DerValue derValue, int n) throws Asn1Exception, IOException, KrbException {
        BigInteger bigInteger;
        if ((derValue.getTag() & 0x1F) != n) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            bigInteger = derValue3.getData().getBigInteger();
            this.pvno = bigInteger.intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 2) {
            bigInteger = derValue3.getData().getBigInteger();
            this.msgType = bigInteger.intValue();
            if (this.msgType != n) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.pAData = PAData.parseSequence(derValue2.getData(), (byte)3, true);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        DerValue derValue4 = derValue3.getData().getDerValue();
        this.reqBody = new KDCReqBody(derValue4, this.msgType);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        if (this.pAData != null && this.pAData.length > 0) {
            derOutputStream2 = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                derOutputStream2.write(this.pAData[i].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream);
        }
        derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)4), this.reqBody.asn1Encode(this.msgType));
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream3);
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, true, (byte)this.msgType), derOutputStream);
        return derOutputStream3.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.reqBody.asn1Encode(this.msgType);
    }
}

