/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.PackageLibrary;
import net.sf.saxon.value.DecimalValue;

public class CompilerInfo {
    private transient URIResolver uriResolver;
    private transient OutputURIResolver outputURIResolver = StandardOutputResolver.getInstance();
    private transient ErrorListener errorListener;
    private CodeInjector codeInjector;
    private int recoveryPolicy = 1;
    private boolean schemaAware;
    private boolean versionWarning;
    private String messageReceiverClassName = "net.sf.saxon.serialize.MessageEmitter";
    private StructuredQName defaultInitialMode;
    private StructuredQName defaultInitialTemplate;
    private DecimalValue xsltVersion = DecimalValue.ZERO;
    private FunctionLibrary extensionFunctionLibrary;
    private GlobalParameterSet variableList = new GlobalParameterSet();
    private String defaultCollation;
    private Map<String, Object> options = new HashMap<String, Object>();
    private PackageLibrary packageLibrary = new PackageLibrary();
    private boolean generateByteCode = false;
    private ErrorGatherer errorGatherer;

    public CompilerInfo() {
    }

    public CompilerInfo(CompilerInfo info) {
        this.copyFrom(info);
    }

    public void copyFrom(CompilerInfo info) {
        this.uriResolver = info.uriResolver;
        this.outputURIResolver = info.outputURIResolver;
        this.errorListener = info.errorListener;
        this.codeInjector = info.codeInjector;
        this.recoveryPolicy = info.recoveryPolicy;
        this.schemaAware = info.schemaAware;
        this.versionWarning = info.versionWarning;
        this.messageReceiverClassName = info.messageReceiverClassName;
        this.defaultInitialMode = info.defaultInitialMode;
        this.defaultInitialTemplate = info.defaultInitialTemplate;
        this.xsltVersion = info.xsltVersion;
        this.packageLibrary = info.packageLibrary;
        this.generateByteCode = info.generateByteCode;
        this.extensionFunctionLibrary = info.extensionFunctionLibrary;
        this.defaultCollation = info.defaultCollation;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public void setParameter(StructuredQName name, Sequence seq) {
        this.variableList.put(name, seq);
    }

    public GlobalParameterSet getParameters() {
        return this.variableList;
    }

    public void setPackageLibrary(PackageLibrary library) {
        this.packageLibrary = library;
    }

    public PackageLibrary getPackageLibrary() {
        return this.packageLibrary;
    }

    public void setGenerateByteCode(boolean option) {
        this.generateByteCode = option;
    }

    public boolean isGenerateByteCode() {
        return this.generateByteCode;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public String getMessageReceiverClassName() {
        return this.messageReceiverClassName;
    }

    public void setMessageReceiverClassName(String messageReceiverClassName) {
        this.messageReceiverClassName = messageReceiverClassName;
    }

    public void setDefaultCollation(String collation) {
        this.defaultCollation = collation;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public void setCodeInjector(CodeInjector injector) {
        this.codeInjector = injector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public boolean isCompileWithTracing() {
        return this.codeInjector != null;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public boolean isVersionWarning() {
        return this.versionWarning;
    }

    public void setVersionWarning(boolean warn) {
        this.versionWarning = warn;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setDefaultInitialTemplate(StructuredQName initialTemplate) {
        this.defaultInitialTemplate = initialTemplate;
    }

    public StructuredQName getDefaultInitialTemplate() {
        return this.defaultInitialTemplate;
    }

    public void setDefaultInitialMode(StructuredQName initialMode) {
        this.defaultInitialMode = initialMode;
    }

    public StructuredQName getDefaultInitialMode() {
        return this.defaultInitialMode;
    }

    public void setXsltVersion(DecimalValue version) {
        if (version.equals(DecimalValue.ONE)) {
            this.xsltVersion = DecimalValue.TWO;
        } else {
            if (!(version.equals(DecimalValue.TWO) || version.equals(DecimalValue.THREE) || version.equals(DecimalValue.ZERO))) {
                throw new IllegalArgumentException("XSLT version must be 0.0, 2.0 or 3.0");
            }
            this.xsltVersion = version;
        }
    }

    public DecimalValue getXsltVersion() {
        return this.xsltVersion;
    }

    public void setExtensionFunctionLibrary(FunctionLibrary library) {
        this.extensionFunctionLibrary = library;
    }

    public FunctionLibrary getExtensionFunctionLibrary() {
        return this.extensionFunctionLibrary;
    }
}

