#!/usr/bin/env python
# coding: utf-8

from re import compile, DOTALL
from functools import reduce
from sys import exit, stdin, stdout

RE_REP = (
    (
        compile(r"^\s*\\begin{longtable}\[\]{@{}[lcrX]{3}@{}}.*", DOTALL),
        r"\\begin{xltabular}[l]{\\linewidth}{@{} lX X @{}}",
    ),
    (
        compile(r"^\s*\\begin{longtable}.*", DOTALL),
        r"\\begin{xltabular}[l]{\\linewidth}{@{} lX @{}}",
    ),
    (compile(r"^\s*\\end{longtable}", DOTALL), r"\\end{xltabular}"),
    (compile(r"^\s*\\begin{verbatim}", DOTALL), r"{\\scriptsize \\begin{verbatim}"),
    (compile(r"^\s*\\end{verbatim}", DOTALL), r"\\end{verbatim}}"),
)
RE_DEL = (compile(r"^\s*>{\\raggedright\\arraybackslash}.*", DOTALL),)

sub_rep = lambda line: reduce(lambda acc, r: r[0].sub(r[1], acc), RE_REP, line)
sub_del = lambda line: reduce(lambda acc, r: r.sub("", acc), RE_DEL, line)
sub = lambda line: sub_rep(sub_del(line))


def main():
    for line in stdin:
        stdout.write(sub(line))
    return 0


if __name__ == "__main__":
    exit(main())
