/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kk_Arab extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گرينۆيچ ۋاقىتى",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "اپيا ستاندارتتى ۋاقىتى",
               "",
               "اپيا جازعى ۋاقىتى",
               "",
               "اپيا ۋاقىتى",
               "",
            };
        final String[] Cook = new String[] {
               "كۋك ارالدارىنىڭ ستاندارتتى ۋاقىتى",
               "",
               "كۋك ارالدارىنىڭ جازعى ۋاقىتى",
               "",
               "كۋك ارالدارىنىڭ ۋاقىتى",
               "",
            };
        final String[] Cuba = new String[] {
               "كۋبا ستاندارتتى ۋاقىتى",
               "CST",
               "كۋبا جازعى ۋاقىتى",
               "CDT",
               "كۋبا ۋاقىتى",
               "CT",
            };
        final String[] Fiji = new String[] {
               "فيجي ستاندارتتى ۋاقىتى",
               "",
               "فيجي جازعى ۋاقىتى",
               "",
               "فيجي ۋاقىتى",
               "",
            };
        final String[] Gulf = new String[] {
               "پارسى شىعاناعى ستاندارتتى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "حوۆد ستاندارتتى ۋاقىتى",
               "",
               "حوۆد جازعى ۋاقىتى",
               "",
               "حوۆد ۋاقىتى",
               "",
            };
        final String[] Iran = new String[] {
               "يران ستاندارتتى ۋاقىتى",
               "",
               "يران جازعى ۋاقىتى",
               "",
               "يران ۋاقىتى",
               "",
            };
        final String[] Niue = new String[] {
               "نيۋە ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ومبى ستاندارتتى ۋاقىتى",
               "",
               "ومبى جازعى ۋاقىتى",
               "",
               "ومبى ۋاقىتى",
               "",
            };
        final String[] Peru = new String[] {
               "پەرۋ ستاندارتتى ۋاقىتى",
               "",
               "پەرۋ جازعى ۋاقىتى",
               "",
               "پەرۋ ۋاقىتى",
               "",
            };
        final String[] Truk = new String[] {
               "ترۋك ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ۋەيك ارالى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "چيلي ستاندارتتى ۋاقىتى",
               "",
               "چيلي جازعى ۋاقىتى",
               "",
               "چيلي ۋاقىتى",
               "",
            };
        final String[] China = new String[] {
               "قىتاي ستاندارتتى ۋاقىتى",
               "CST",
               "قىتاي جازعى ۋاقىتى",
               "CDT",
               "قىتاي ۋاقىتى",
               "CT",
            };
        final String[] Cocos = new String[] {
               "كوكوس ارالدارىنىڭ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "دەيۆيس ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ءۇندىستان ستاندارتتى ۋاقىتى",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "جاپونيا ستاندارتتى ۋاقىتى",
               "JST",
               "جاپونيا جازعى ۋاقىتى",
               "JDT",
               "جاپونيا ۋاقىتى",
               "JT",
            };
        final String[] Korea = new String[] {
               "كورەيا ستاندارتتى ۋاقىتى",
               "KST",
               "كورەيا جازعى ۋاقىتى",
               "KST",
               "كورەيا ۋاقىتى",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ناۋرۋ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "نەپال ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "پالاۋ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ساموا ستاندارتتى ۋاقىتى",
               "SST",
               "ساموا جازعى ۋاقىتى",
               "SST",
               "ساموا ۋاقىتى",
               "SST",
            };
        final String[] Syowa = new String[] {
               "سەۆا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "تونگا ستاندارتتى ۋاقىتى",
               "",
               "تونگا كازعى ۋاقىتى",
               "",
               "تونگا ۋاقىتى",
               "",
            };
        final String[] Yukon = new String[] {
               "يۋكون ۋاقىتى",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "الاسكا ستاندارتتى ۋاقىتى",
               "AKST",
               "الاسكا جازعى ۋاقىتى",
               "AKDT",
               "الاسكا ۋاقىتى",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "امازون ستاندارتتى ۋاقىتى",
               "",
               "امازون جازعى ۋاقىتى",
               "",
               "امازون ۋاقىتى",
               "",
            };
        final String[] Azores = new String[] {
               "ازور ارالدارى ستاندارتتى ۋاقىتى",
               "",
               "ازور ارالدارى جازعى ۋاقىتى",
               "",
               "ازور ارالدارى ۋاقىتى",
               "",
            };
        final String[] Bhutan = new String[] {
               "بۋتان ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "برۋنەي-دارۋسسالام ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "پاسحا ارالى ستاندارتتى ۋاقىتى",
               "",
               "پاسحا ارالى جازعى ۋاقىتى",
               "",
               "پاسحا ارالى ۋاقىتى",
               "",
            };
        final String[] Guyana = new String[] {
               "گايانا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "گاۆاي جانە الەۋت ارالدارى ستاندارتتى ۋاقىتى",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "يزرايل ستاندارتتى ۋاقىتى",
               "IST",
               "يزرايل جازعى ۋاقىتى",
               "IDT",
               "يزرايل ۋاقىتى",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "كۋسايە ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "موۋسون ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ماسكەۋ ستاندارتتى ۋاقىتى",
               "MSK",
               "ماسكەۋ جازعى ۋاقىتى",
               "MSK",
               "ماسكەۋ ۋاقىتى",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "پونپەي ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "تايتي ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "تايبەي ستاندارتتى ۋاقىتى",
               "CST",
               "تايبەي جازعى ۋاقىتى",
               "CDT",
               "تايبەي ۋاقىتى",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "تۋۆالۋ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ۆوستوك ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ۋولليس جانە فۋتۋنا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ساۋد ارابياسى ستاندارتتى ۋاقىتى",
               "",
               "ساۋد ارابياسى جازعى ۋاقىتى",
               "",
               "ساۋد ارابياسى ۋاقىتى",
               "",
            };
        final String[] Armenia = new String[] {
               "ارمەنيا ستاندارتتى ۋاقىتى",
               "",
               "ارمەنيا جازعى ۋاقىتى",
               "",
               "ارمەنيا ۋاقىتى",
               "",
            };
        final String[] Bolivia = new String[] {
               "بوليۆيا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "چاتەم ستاندارتتى ۋاقىتى",
               "",
               "چاتەم جازعى ۋاقىتى",
               "",
               "چاتەم ۋاقىتى",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ەكۆادور ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "گامبە ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "گرۋزيا ستاندارتتى ۋاقىتى",
               "",
               "گرۋزيا جازعى ۋاقىتى",
               "",
               "گرۋزيا ۋاقىتى",
               "",
            };
        final String[] Irkutsk = new String[] {
               "يركۋتسك ستاندارتتى ۋاقىتى",
               "",
               "يركۋتسك جازعى ۋاقىتى",
               "",
               "يركۋتسك ۋاقىتى",
               "",
            };
        final String[] Magadan = new String[] {
               "ماگادان ستاندارتتى ۋاقىتى",
               "",
               "ماگادان جازعى ۋاقىتى",
               "",
               "ماگادان ۋاقىتى",
               "",
            };
        final String[] Myanmar = new String[] {
               "ميانما ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "نورفولك ارالى ستاندارتتى ۋاقىتى",
               "",
               "نورفولك ارالى جازعى ۋاقىتى",
               "",
               "نورفولك ارالى ۋاقىتى",
               "",
            };
        final String[] Noronha = new String[] {
               "فەرناندۋ-دي-نورونيا ستاندارتتى ۋاقىتى",
               "",
               "فەرناندۋ-دي-نورونيا جازعى ۋاقىتى",
               "",
               "فەرناندۋ-دي-نورونيا ۋاقىتى",
               "",
            };
        final String[] Reunion = new String[] {
               "رەيۋنون ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "روتەرا ۋقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "سولومون ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "توكەلاۋ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ۋرۋگۆاي ستاندارتتى ۋاقىتى",
               "",
               "ۋرۋگۆاي جازعى ۋاقىتى",
               "",
               "ۋرۋگۆاي ۋاقىتى",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ۆانۋاتۋ ستاندارتتى ۋاقىتى",
               "",
               "ۆانۋاتۋ جازعى ۋاقىتى",
               "",
               "ۆانۋاتۋ ۋاقىتى",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ياكۋتسك ستاندارتتى ۋاقىتى",
               "",
               "ياكۋتسك جازعى ۋاقىتى",
               "",
               "ياكۋتسك ۋاقىتى",
               "",
            };
        final String[] Atlantic = new String[] {
               "اتلانتيكا ستاندارتتى ۋاقىتى",
               "AST",
               "اتلانتيكا جازعى ۋاقىتى",
               "AST",
               "اتلانتيكا ۋاقىتى",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "برازيليا ستاندارتتى ۋاقىتى",
               "",
               "برازيليا جازعى ۋاقىتى",
               "",
               "برازيليا ۋاقىتى",
               "",
            };
        final String[] Chamorro = new String[] {
               "چاموررو ستاندارتتى ۋاقىتى",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "كولۋمبيا ستاندارتتى ۋاقىتى",
               "",
               "كولۋمبيا جازعى ۋاقىتى",
               "",
               "كولۋمبيا ۋاقىتى",
               "",
            };
        final String[] Falkland = new String[] {
               "فولكلەند ارالدارى ستاندارتتى ۋاقىتى",
               "",
               "فولكلەند ارالدارى جازعى ۋاقىتى",
               "",
               "فولكلەند ارالدارى ۋاقىتى",
               "",
            };
        final String[] Malaysia = new String[] {
               "مالايزيا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "مالديۆ ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ۇلانباتىر ستاندارتتى ۋاقىتى",
               "",
               "ۇلانباتىر جازعى ۋاقىتى",
               "",
               "ۇلانباتىر ۋاقىتى",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاكىستان ستاندارتتى ۋاقىتى",
               "PKT",
               "پاكىستان جازعى ۋاقىتى",
               "PKST",
               "پاكىستان ۋاقىتى",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پاراگۆاي ستاندارتتى ۋاقىتى",
               "",
               "پاراگۆاي جازعى ۋاقىتى",
               "",
               "پاراگۆاي ۋاقىتى",
               "",
            };
        final String[] Pitcairn = new String[] {
               "پيتكەرن ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "سۋرينام ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ارگەنتينا ستاندارتتى ۋاقىتى",
               "",
               "ارگەنتينا جازعى ۋاقىتى",
               "",
               "ارگەنتينا ۋاقىتى",
               "",
            };
        final String[] Christmas = new String[] {
               "كريستماس ارالىنىڭ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گالاپاگوس ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "حوڭكوڭ ستاندارتتى ۋاقىتى",
               "HKT",
               "حوڭكوڭ جازعى ۋاقىتى",
               "HKST",
               "حوڭكوڭ ۋاقىتى",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ءۇندى-قىتاي ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "قىرعىزستان ۋاقىتى",
               "قىرعىزستان",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "لورد-حاۋ ستاندارتتى ۋاقىتى",
               "",
               "لورد-حاۋ جازعى ۋاقىتى",
               "",
               "لورد-حاۋ ۋاقىتى",
               "",
            };
        final String[] Marquesas = new String[] {
               "ماركيز ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ماۆريكيي ستاندارتتى ۋاقىتى",
               "",
               "ماۆريكيي جازعى ۋاقىتى",
               "",
               "ماۆريكيي ۋاقىتى",
               "",
            };
        final String[] Singapore = new String[] {
               "سينگاپۋر ستاندارتتى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ۆەنەسۋەلا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ءازىربايجان ستاندارتتى ۋاقىتى",
               "",
               "ءازىربايجان جازعى ۋاقىتى",
               "",
               "ءازىربايجان ۋاقىتى",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بانگلادەش ستاندارتتى ۋاقىتى",
               "",
               "بانگلادەش جازعى ۋاقىتى",
               "",
               "بانگلادەش ۋاقىتى",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "كابو-ۆەردە ستاندارتتى ۋاقىتى",
               "",
               "كابو-ۆەردە جازعى ۋاقىتى",
               "",
               "كابو-ۆەردە ۋاقىتى",
               "",
            };
        final String[] East_Timor = new String[] {
               "شىعىس تيمور ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "قازاق ەلى ۋاقىتى",
               "قازاق ەلى",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "سەيشەل ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجىكستان ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "وزبەكستان ستاندارتتى ۋاقىتى",
               "",
               "وزبەكستان جازعى ۋاقىتى",
               "",
               "وزبەكستان ۋاقىتى",
               "",
            };
        final String[] Afghanistan = new String[] {
               "اۋعانستان ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "كراسنويارسك ستاندارتتى ۋاقىتى",
               "",
               "كراسنويارسك جازعى ۋاقىتى",
               "",
               "كراسنويارسك ۋاقىتى",
               "",
            };
        final String[] New_Zealand = new String[] {
               "جاڭا زەلانديا ستاندارتتى ۋاقىتى",
               "NZST",
               "جاڭا زەلانديا جازعى ۋاقىتى",
               "NZDT",
               "جاڭا زەلانديا ۋاقىتى",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "فيليپين ارالدارى ستاندارتتى ۋاقىتى",
               "PST",
               "فيليپين ارالدارى جازعى ۋاقىتى",
               "PDT",
               "فيليپين ارالدارى ۋاقىتى",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ۆلاديۆوستوك ستاندارتتى ۋاقىتى",
               "",
               "ۆلاديۆوستوك جازعى ۋاقىتى",
               "",
               "ۆلاديۆوستوك ۋاقىتى",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ءۇندى مۇحيتى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "لاين ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "نيۋفاۋندلەند ستاندارتتى ۋاقىتى",
               "NST",
               "نيۋفاۋندلەند جازعى ۋاقىتى",
               "NDT",
               "نيۋفاۋندلەند ۋاقىتى",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "تۇرىكمەنستان ستاندارتتى ۋاقىتى",
               "",
               "تۇرىكمەنستان جازعى ۋاقىتى",
               "",
               "تۇرىكمەنستان ۋاقىتى",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فرانتسۋز گۆياناسى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "جاڭا كالەدونيا ستاندارتتى ۋاقىتى",
               "",
               "جاڭا كالەدونيا جازعى ۋاقىتى",
               "",
               "جاڭا كالەدونيا ۋاقىتى",
               "",
            };
        final String[] South_Georgia = new String[] {
               "وڭتۇستىك گەورگيا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ەكاتەرينبۋرگ ستاندارتتى ۋاقىتى",
               "",
               "ەكاتەرينبۋرگ جازعى ۋاقىتى",
               "",
               "ەكاتەرينبۋرگ ۋاقىتى",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ورتالىق افريكا ۋاقىتى",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "شىعىس افريكا ۋاقىتى",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "باتىس افريكا ۋاقىتى",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ديۋمون-ديۋرۆيل ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ورتالىق ەۋروپا ستاندارتتى ۋاقىتى",
               "CET",
               "ورتالىق ەۋروپا جازعى ۋاقىتى",
               "CEST",
               "ورتالىق ەۋروپا ۋاقىتى",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "شىعىس ەۋروپا ستاندارتتى ۋاقىتى",
               "EET",
               "شىعىس ەۋروپا جازعى ۋاقىتى",
               "EEST",
               "شىعىس ەۋروپا ۋاقىتى",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "باتىس ەۋروپا ستاندارتتى ۋاقىتى",
               "WET",
               "باتىس ەۋروپا جازعى ۋاقىتى",
               "WEST",
               "باتىس ەۋروپا ۋاقىتى",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "مەكسيكا ستاندارتتى تىنىق مۇحيت ۋاقىتى",
               "MST",
               "مەكسيكا جازعى تىنىق مۇحيت ۋاقىتى",
               "MDT",
               "مەكسيكا تىنىق مۇحيت ۋاقىتى",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "وڭتۇستىك افريكا ستاندارتتى ۋاقىتى",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "سولتۇستىك امەريكا ستاندارتتى ورتالىق ۋاقىتى",
               "CST",
               "ولتۇستىك امەريكا جازعى ورتالىق ۋاقىتى",
               "CDT",
               "سولتۇستىك امەريكا ورتالىق ۋاقىتى",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "سولتۇستىك امەريكا ستاندارتتى شىعىس ۋاقىتى",
               "EST",
               "سولتۇستىك امەريكا جازعى شىعىس ۋاقىتى",
               "EST",
               "سولتۇستىك امەريكا شىعىس ۋاقىتى",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "سولتۇستىك امەريكا ستاندارتتى تىنىق مۇحيتى ۋاقىتى",
               "PST",
               "سولتۇستىك امەريكا جازعى تىنىق مۇحيتى ۋاقىتى",
               "PDT",
               "سولتۇستىك امەريكا تىنىق مۇحيتى ۋاقىتى",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "فرانتسيانىڭ وڭتۇستىك ايماعى جانە انتاركتيكا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "گيلبەرت ارالدارىنىڭ ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "گاۆاي جانە الەۋت ارالدارى ستاندارتتى ۋاقىتى",
               "HST",
               "گاۆاي جانە الەۋت ارالدارى جازعى ۋاقىتى",
               "HDT",
               "گاۆاي جانە الەۋت ارالدارى ۋاقىتى",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "فەنيكس ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "سەن-پەر جانە ميكەلون ستاندارتتى ۋاقىتى",
               "",
               "سەن-پەر جانە ميكەلون جازعى ۋاقىتى",
               "",
               "سەن-پەر جانە ميكەلون ۋاقىتى",
               "",
            };
        final String[] America_Mountain = new String[] {
               "سولتۇستىك امەريكا ستاندارتتى تاۋ ۋاقىتى",
               "MST",
               "سولتۇستىك امەريكا جازعى تاۋ ۋاقىتى",
               "MST",
               "سولتۇستىك امەريكا تاۋ ۋاقىتى",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "مارشال ارالدارى ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "پاپۋا – جاڭا گۆينەيا ۋاقىتى",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "اۋستراليا ستاندارتتى ورتالىق ۋاقىتى",
               "ACST",
               "اۋستراليا جازعى ورتالىق ۋاقىتى",
               "ACDT",
               "ورتالىق اۋستراليا ۋاقىتى",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "اۋستراليا ستاندارتتى شىعىس ۋاقىتى",
               "AEST",
               "اۋستراليا جازعى شىعىس ۋاقىتى",
               "AEDT",
               "شىعىس اۋستراليا ۋاقىتى",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "اۋستراليا ستاندارتتى باتىس ۋاقىتى",
               "AWST",
               "اۋستراليا جازعى باتىس ۋاقىتى",
               "AWDT",
               "باتىس اۋستراليا ۋاقىتى",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ورتالىق يندونەزيا ۋاقىتى",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "شىعىس يندونەزيا ۋاقىتى",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "باتىس يندونەزيا ۋاقىتى",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "اۋستراليا ستاندارتتى ورتالىق-باتىس ۋاقىتى",
               "",
               "اۋستراليا جازعى ورتالىق-باتىس ۋاقىتى",
               "",
               "اۋستراليا ورتالىق-باتىس ۋاقىتى",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "يرلانديا ستاندارتتى ۋاقىتى",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "دۇنيەجۇزىلىك ۇيلەستىرىلگەن ۋاقىت",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "يرلانديا ستاندارتتى ۋاقىتى",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "گرينۆيچ ۋاقىتى",
                    "GMT",
                    "ۇلىبريتانيا جازعى ۋاقىتى",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ادەن" },
            { "timezone.excity.Asia/Baku", "باكۋ" },
            { "timezone.excity.Asia/Dili", "ديلي" },
            { "timezone.excity.Asia/Gaza", "گازا" },
            { "timezone.excity.Asia/Hovd", "حوۆد" },
            { "timezone.excity.Asia/Omsk", "ومبى" },
            { "timezone.excity.Asia/Oral", "ورال" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "اممان" },
            { "timezone.excity.Asia/Aqtau", "اقتاۋ" },
            { "timezone.excity.Asia/Chita", "چيتا" },
            { "timezone.excity.Asia/Dhaka", "داككا" },
            { "timezone.excity.Asia/Dubai", "دۋباي" },
            { "timezone.excity.Asia/Kabul", "كابۋل" },
            { "timezone.excity.Asia/Macau", "ماكاو" },
            { "timezone.excity.Asia/Qatar", "كاتار" },
            { "timezone.excity.Asia/Seoul", "سەۋل" },
            { "timezone.excity.Asia/Tokyo", "توكيو" },
            { "timezone.excity.Asia/Tomsk", "تۋمەن" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "جۋبا" },
            { "timezone.excity.Africa/Lome", "لومە" },
            { "timezone.excity.Asia/Almaty", "الماتى" },
            { "timezone.excity.Asia/Anadyr", "انادىر" },
            { "timezone.excity.Asia/Aqtobe", "اقتوبە" },
            { "timezone.excity.Asia/Atyrau", "اتىراۋ" },
            { "timezone.excity.Asia/Beirut", "بەيرۋت" },
            { "timezone.excity.Asia/Brunei", "برۋنەي" },
            { "timezone.excity.Asia/Hebron", "حەۆرون" },
            { "timezone.excity.Asia/Kuwait", "كۋۆەيت" },
            { "timezone.excity.Asia/Manila", "مانيلا" },
            { "timezone.excity.Asia/Muscat", "ماسكات" },
            { "timezone.excity.Asia/Riyadh", "ەر-رياد" },
            { "timezone.excity.Asia/Saigon", "حوشيمين" },
            { "timezone.excity.Asia/Taipei", "تايبەي" },
            { "timezone.excity.Asia/Tehran", "تەگەران" },
            { "timezone.excity.Asia/Urumqi", "ءۇرىمشى" },
            { "timezone.excity.Etc/Unknown", "بەلگىسىز قالا" },
            { "timezone.excity.Europe/Kiev", "كيەۆ" },
            { "timezone.excity.Europe/Oslo", "وسلو" },
            { "timezone.excity.Europe/Riga", "ريگا" },
            { "timezone.excity.Europe/Rome", "ريم" },
            { "timezone.excity.Indian/Mahe", "ماە" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "اككرا" },
            { "timezone.excity.Africa/Cairo", "كاير" },
            { "timezone.excity.Africa/Ceuta", "سەۋتا" },
            { "timezone.excity.Africa/Dakar", "داكار" },
            { "timezone.excity.Africa/Lagos", "لاگوس" },
            { "timezone.excity.Africa/Tunis", "تۋنيس" },
            { "timezone.excity.America/Adak", "اداك" },
            { "timezone.excity.America/Lima", "ليما" },
            { "timezone.excity.America/Nome", "نوم" },
            { "timezone.excity.Asia/Baghdad", "باگدات" },
            { "timezone.excity.Asia/Bahrain", "باحرەين" },
            { "timezone.excity.Asia/Bangkok", "باڭكوك" },
            { "timezone.excity.Asia/Barnaul", "بارناۋىل" },
            { "timezone.excity.Asia/Bishkek", "بىشكەك" },
            { "timezone.excity.Asia/Colombo", "كولومبو" },
            { "timezone.excity.Asia/Irkutsk", "يركۋتسك" },
            { "timezone.excity.Asia/Jakarta", "جاكارتا" },
            { "timezone.excity.Asia/Karachi", "كاراچا" },
            { "timezone.excity.Asia/Kuching", "كۋچيڭ" },
            { "timezone.excity.Asia/Magadan", "ماگادان" },
            { "timezone.excity.Asia/Nicosia", "نيكوسيا" },
            { "timezone.excity.Asia/Rangoon", "يانگون" },
            { "timezone.excity.Asia/Tbilisi", "تبيليسي" },
            { "timezone.excity.Asia/Thimphu", "تحيمپحۋ" },
            { "timezone.excity.Asia/Yakutsk", "ياكۋتسك" },
            { "timezone.excity.Asia/Yerevan", "يەرەۆان" },
            { "timezone.excity.Europe/Kirov", "كيروۆ" },
            { "timezone.excity.Europe/Malta", "مالتا" },
            { "timezone.excity.Europe/Minsk", "مينسك" },
            { "timezone.excity.Europe/Paris", "پاريج" },
            { "timezone.excity.Europe/Sofia", "سوفيا" },
            { "timezone.excity.Europe/Vaduz", "ۆادۋس" },
            { "timezone.excity.Indian/Cocos", "كوكوس ارالدارى" },
            { "timezone.excity.Pacific/Apia", "اپيا" },
            { "timezone.excity.Pacific/Fiji", "فيجي" },
            { "timezone.excity.Pacific/Guam", "گۋام" },
            { "timezone.excity.Pacific/Niue", "نيۋە" },
            { "timezone.excity.Pacific/Truk", "ترۋك" },
            { "timezone.excity.Pacific/Wake", "ۋەيك" },
            { "timezone.excity.Africa/Asmera", "اسمارا" },
            { "timezone.excity.Africa/Bamako", "باماكو" },
            { "timezone.excity.Africa/Bangui", "بانگي" },
            { "timezone.excity.Africa/Banjul", "بانجۋل" },
            { "timezone.excity.Africa/Bissau", "بيساۋ" },
            { "timezone.excity.Africa/Douala", "دۋالا" },
            { "timezone.excity.Africa/Harare", "حارارە" },
            { "timezone.excity.Africa/Kigali", "كيگالي" },
            { "timezone.excity.Africa/Luanda", "لۋاندا" },
            { "timezone.excity.Africa/Lusaka", "لۋساكا" },
            { "timezone.excity.Africa/Malabo", "مالابو" },
            { "timezone.excity.Africa/Maputo", "ماپۋتۋ" },
            { "timezone.excity.Africa/Maseru", "ماسەرۋ" },
            { "timezone.excity.Africa/Niamey", "نيامەي" },
            { "timezone.excity.America/Aruba", "ارۋبا" },
            { "timezone.excity.America/Bahia", "بايا" },
            { "timezone.excity.America/Belem", "بەلەم" },
            { "timezone.excity.America/Boise", "بويسە" },
            { "timezone.excity.America/Jujuy", "جۋجۋي" },
            { "timezone.excity.America/Sitka", "سيتكا" },
            { "timezone.excity.America/Thule", "تۋلە" },
            { "timezone.excity.Asia/Ashgabat", "اشحابات" },
            { "timezone.excity.Asia/Calcutta", "كالكۋتا" },
            { "timezone.excity.Asia/Damascus", "داماسك" },
            { "timezone.excity.Asia/Dushanbe", "دۋشانبە" },
            { "timezone.excity.Asia/Jayapura", "جاياپۋرا" },
            { "timezone.excity.Asia/Katmandu", "كاتماندۋ" },
            { "timezone.excity.Asia/Khandyga", "حاندىگا" },
            { "timezone.excity.Asia/Makassar", "ماكاسار" },
            { "timezone.excity.Asia/Qostanay", "قوستاناي" },
            { "timezone.excity.Asia/Sakhalin", "ساحالين" },
            { "timezone.excity.Asia/Shanghai", "شانحاي" },
            { "timezone.excity.Asia/Tashkent", "تاشكەنت" },
            { "timezone.excity.Asia/Ust-Nera", "ۋست-نەرا" },
            { "timezone.excity.Europe/Athens", "افينا" },
            { "timezone.excity.Europe/Berlin", "بەرلين" },
            { "timezone.excity.Europe/Dublin", "دۋبلين" },
            { "timezone.excity.Europe/Jersey", "جەرسەي" },
            { "timezone.excity.Europe/Lisbon", "ليسابون" },
            { "timezone.excity.Europe/London", "لوندون" },
            { "timezone.excity.Europe/Madrid", "مادريد" },
            { "timezone.excity.Europe/Monaco", "موناكو" },
            { "timezone.excity.Europe/Moscow", "ماسكەۋ" },
            { "timezone.excity.Europe/Prague", "پراگا" },
            { "timezone.excity.Europe/Samara", "سامارا" },
            { "timezone.excity.Europe/Skopje", "سكوپيە" },
            { "timezone.excity.Europe/Tirane", "تيرانا" },
            { "timezone.excity.Europe/Vienna", "ۆەنا" },
            { "timezone.excity.Europe/Warsaw", "ۆارشاۆا" },
            { "timezone.excity.Europe/Zagreb", "زاگرەب" },
            { "timezone.excity.Europe/Zurich", "سيۋريح" },
            { "timezone.excity.Indian/Chagos", "چاگوس" },
            { "timezone.excity.Indian/Comoro", "كومور ارالدارى" },
            { "timezone.excity.Pacific/Efate", "ەفاتە" },
            { "timezone.excity.Pacific/Nauru", "ناۋرۋ" },
            { "timezone.excity.Pacific/Palau", "پالاۋ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ابيدجان" },
            { "timezone.excity.Africa/Algiers", "الجير" },
            { "timezone.excity.Africa/Conakry", "كوناكري" },
            { "timezone.excity.Africa/Kampala", "كامپالا" },
            { "timezone.excity.Africa/Mbabane", "مبابەنە" },
            { "timezone.excity.Africa/Nairobi", "نايروبي" },
            { "timezone.excity.Africa/Tripoli", "تريپولي" },
            { "timezone.excity.America/Belize", "بەليز" },
            { "timezone.excity.America/Bogota", "بوگوتا" },
            { "timezone.excity.America/Cancun", "كانكۋن" },
            { "timezone.excity.America/Cayman", "كايمان ارالدارى" },
            { "timezone.excity.America/Cuiaba", "كۋيابا" },
            { "timezone.excity.America/Dawson", "دوۋسون" },
            { "timezone.excity.America/Denver", "دەنۆەر" },
            { "timezone.excity.America/Guyana", "گايانا" },
            { "timezone.excity.America/Havana", "گاۆانا" },
            { "timezone.excity.America/Inuvik", "ينۋۆيك" },
            { "timezone.excity.America/Juneau", "جۋنو" },
            { "timezone.excity.America/La_Paz", "لا-پاس" },
            { "timezone.excity.America/Maceio", "ماسەيو" },
            { "timezone.excity.America/Manaus", "ماناۋس" },
            { "timezone.excity.America/Merida", "مەريدا" },
            { "timezone.excity.America/Nassau", "ناسساۋ" },
            { "timezone.excity.America/Panama", "پاناما" },
            { "timezone.excity.America/Recife", "رەسيفي" },
            { "timezone.excity.America/Regina", "رەجاينا" },
            { "timezone.excity.Asia/Famagusta", "فاماگۋستا" },
            { "timezone.excity.Asia/Hong_Kong", "حوڭكوڭ" },
            { "timezone.excity.Asia/Jerusalem", "يەرۋساليم" },
            { "timezone.excity.Asia/Kamchatka", "كامچاتكا" },
            { "timezone.excity.Asia/Pontianak", "پونتياناك" },
            { "timezone.excity.Asia/Pyongyang", "پحەنيان" },
            { "timezone.excity.Asia/Qyzylorda", "قىزىلوردا" },
            { "timezone.excity.Asia/Samarkand", "سامارقاند" },
            { "timezone.excity.Asia/Singapore", "سينگاپۋر" },
            { "timezone.excity.Asia/Vientiane", "ۆەنتيان" },
            { "timezone.excity.Europe/Andorra", "اندوررا" },
            { "timezone.excity.Europe/Saratov", "سارىتاۋ" },
            { "timezone.excity.Europe/Tallinn", "تاللين" },
            { "timezone.excity.Europe/Vatican", "ۆاتيكان" },
            { "timezone.excity.Europe/Vilnius", "ۆينيۋس" },
            { "timezone.excity.Indian/Mayotte", "مايوتتا" },
            { "timezone.excity.Indian/Reunion", "رەيۋنيون" },
            { "timezone.excity.Pacific/Easter", "پاسحا ارالى" },
            { "timezone.excity.Pacific/Kosrae", "كۋسايە" },
            { "timezone.excity.Pacific/Majuro", "ماجۋرو" },
            { "timezone.excity.Pacific/Midway", "ميدۋەي" },
            { "timezone.excity.Pacific/Noumea", "نۋمەا" },
            { "timezone.excity.Pacific/Ponape", "پوناپە" },
            { "timezone.excity.Pacific/Saipan", "سايپان" },
            { "timezone.excity.Pacific/Tahiti", "تايتي" },
            { "timezone.excity.Pacific/Tarawa", "تاراۋا" },
            { "timezone.excity.Pacific/Wallis", "ۋولليس" },
            { "timezone.excity.Africa/Blantyre", "بلانتاير" },
            { "timezone.excity.Africa/Djibouti", "جيبۋتي" },
            { "timezone.excity.Africa/El_Aaiun", "ەل-ايۋن" },
            { "timezone.excity.Africa/Freetown", "فريتاۋن" },
            { "timezone.excity.Africa/Gaborone", "گابورونە" },
            { "timezone.excity.Africa/Khartoum", "حارتۋم" },
            { "timezone.excity.Africa/Kinshasa", "كينشاسا" },
            { "timezone.excity.Africa/Monrovia", "مونروۆيا" },
            { "timezone.excity.Africa/Ndjamena", "ندجامەنا" },
            { "timezone.excity.Africa/Sao_Tome", "سان-تومە" },
            { "timezone.excity.Africa/Windhoek", "ۆيندحۋك" },
            { "timezone.excity.America/Antigua", "انتيگۋا" },
            { "timezone.excity.America/Caracas", "كاراكاس" },
            { "timezone.excity.America/Cayenne", "كايەننا" },
            { "timezone.excity.America/Chicago", "چيكاگو" },
            { "timezone.excity.America/Cordoba", "كوردوبا" },
            { "timezone.excity.America/Creston", "كرەستون" },
            { "timezone.excity.America/Curacao", "كيۋراساو" },
            { "timezone.excity.America/Detroit", "دەترويد" },
            { "timezone.excity.America/Godthab", "نۋۋك" },
            { "timezone.excity.America/Grenada", "گرەنادا" },
            { "timezone.excity.America/Halifax", "گاليفاكس" },
            { "timezone.excity.America/Iqaluit", "يكالۋيت" },
            { "timezone.excity.America/Jamaica", "يامايكا" },
            { "timezone.excity.America/Managua", "ماناگۋا" },
            { "timezone.excity.America/Marigot", "ماريگو" },
            { "timezone.excity.America/Mendoza", "مەندوزا" },
            { "timezone.excity.America/Moncton", "مونكتون" },
            { "timezone.excity.America/Noronha", "نورونيا" },
            { "timezone.excity.America/Ojinaga", "وحيناگا" },
            { "timezone.excity.America/Phoenix", "فينيكس" },
            { "timezone.excity.America/Tijuana", "تيحۋانا" },
            { "timezone.excity.America/Toronto", "تورونتو" },
            { "timezone.excity.America/Tortola", "تورتولا" },
            { "timezone.excity.America/Yakutat", "ياكۋتات" },
            { "timezone.excity.Asia/Phnom_Penh", "پنومپەن" },
            { "timezone.excity.Atlantic/Azores", "ازور ارالدارى" },
            { "timezone.excity.Atlantic/Canary", "كانار ارالدارى" },
            { "timezone.excity.Atlantic/Faeroe", "فارەر ارالدارى" },
            { "timezone.excity.Australia/Eucla", "يۋكلا" },
            { "timezone.excity.Australia/Perth", "پەرت" },
            { "timezone.excity.Europe/Belgrade", "بەلگراد" },
            { "timezone.excity.Europe/Brussels", "بريۋسەل" },
            { "timezone.excity.Europe/Budapest", "بۋداپەشت" },
            { "timezone.excity.Europe/Busingen", "بيۋزينگەن" },
            { "timezone.excity.Europe/Chisinau", "كيشينەۆ" },
            { "timezone.excity.Europe/Guernsey", "گەرنسي" },
            { "timezone.excity.Europe/Helsinki", "حەلسينكي" },
            { "timezone.excity.Europe/Istanbul", "ستامبۇل" },
            { "timezone.excity.Europe/Sarajevo", "ساراەۆو" },
            { "timezone.excity.Indian/Maldives", "مالديۆ ارالدارى" },
            { "timezone.excity.Pacific/Chatham", "چاتەم" },
            { "timezone.excity.Pacific/Fakaofo", "فاكاوفو" },
            { "timezone.excity.Pacific/Gambier", "گامبيە" },
            { "timezone.excity.Pacific/Norfolk", "نورفولك" },
            { "timezone.excity.Africa/Bujumbura", "بۋجۋمبۋرا" },
            { "timezone.excity.Africa/Mogadishu", "موگاديشۋ" },
            { "timezone.excity.America/Anguilla", "انگيليا" },
            { "timezone.excity.America/Asuncion", "اسۋنسيون" },
            { "timezone.excity.America/Barbados", "باربادوس" },
            { "timezone.excity.America/Dominica", "دومينيكا" },
            { "timezone.excity.America/Edmonton", "ەدمونتون" },
            { "timezone.excity.America/Eirunepe", "ەيرۋنەپە" },
            { "timezone.excity.America/Mazatlan", "ماساتلان" },
            { "timezone.excity.America/Miquelon", "ميكەلون" },
            { "timezone.excity.America/New_York", "نيۋ-يورك" },
            { "timezone.excity.America/Resolute", "رەزوليۋت" },
            { "timezone.excity.America/Santarem", "سانتارەن" },
            { "timezone.excity.America/Santiago", "سانتياگو" },
            { "timezone.excity.America/St_Johns", "سەنت-جونس" },
            { "timezone.excity.America/St_Kitts", "سەنت-كيتس" },
            { "timezone.excity.America/St_Lucia", "سەنت-ليۋسيا" },
            { "timezone.excity.America/Winnipeg", "ۆيننيپەگ" },
            { "timezone.excity.Antarctica/Casey", "كەيسي" },
            { "timezone.excity.Antarctica/Davis", "دەيۆيس" },
            { "timezone.excity.Antarctica/Syowa", "سەۆا" },
            { "timezone.excity.Antarctica/Troll", "ترول" },
            { "timezone.excity.Asia/Krasnoyarsk", "كراسنويارسك" },
            { "timezone.excity.Asia/Novosibirsk", "جاڭاسىبىر" },
            { "timezone.excity.Asia/Ulaanbaatar", "ۇلانباتىر" },
            { "timezone.excity.Asia/Vladivostok", "ۆلاديۆاستوك" },
            { "timezone.excity.Atlantic/Bermuda", "بەرمۋد ارالدارى" },
            { "timezone.excity.Atlantic/Madeira", "مادەيرا" },
            { "timezone.excity.Atlantic/Stanley", "ستەنلي" },
            { "timezone.excity.Australia/Darwin", "دارۆين" },
            { "timezone.excity.Australia/Hobart", "حوبارت" },
            { "timezone.excity.Australia/Sydney", "سيدنەي" },
            { "timezone.excity.Europe/Amsterdam", "امستەردام" },
            { "timezone.excity.Europe/Astrakhan", "استراحان" },
            { "timezone.excity.Europe/Bucharest", "بۋحارەست" },
            { "timezone.excity.Europe/Gibraltar", "گيبرالتال" },
            { "timezone.excity.Europe/Ljubljana", "ليۋبليانا" },
            { "timezone.excity.Europe/Mariehamn", "ماريەحامن" },
            { "timezone.excity.Europe/Podgorica", "پودگوريسا" },
            { "timezone.excity.Europe/Stockholm", "ستوكگولىم" },
            { "timezone.excity.Europe/Ulyanovsk", "ۋليانوۆسك" },
            { "timezone.excity.Europe/Volgograd", "ۆولگوگراد" },
            { "timezone.excity.Indian/Christmas", "كريستماس ارالدارى" },
            { "timezone.excity.Indian/Kerguelen", "كەرگەلەن" },
            { "timezone.excity.Indian/Mauritius", "ماۆريكي" },
            { "timezone.excity.Pacific/Auckland", "وكلەند" },
            { "timezone.excity.Pacific/Funafuti", "فۋنافۋتي" },
            { "timezone.excity.Pacific/Pitcairn", "پيتكەرن" },
            { "timezone.excity.Africa/Casablanca", "كاسابلانكا" },
            { "timezone.excity.Africa/Libreville", "ليبرەۆيل" },
            { "timezone.excity.Africa/Lubumbashi", "لۋبۋمباشي" },
            { "timezone.excity.Africa/Nouakchott", "نۋاكشوت" },
            { "timezone.excity.Africa/Porto-Novo", "پورتو-نوۆو" },
            { "timezone.excity.America/Anchorage", "انكوريج" },
            { "timezone.excity.America/Araguaina", "اراگۋاينا" },
            { "timezone.excity.America/Boa_Vista", "باو-ۆيستا" },
            { "timezone.excity.America/Catamarca", "كاتاماركا" },
            { "timezone.excity.America/Chihuahua", "چيۋاۋا" },
            { "timezone.excity.America/Coyhaique", "كويايكە" },
            { "timezone.excity.America/Fortaleza", "فورتالەزا" },
            { "timezone.excity.America/Glace_Bay", "گلەيس-بەي" },
            { "timezone.excity.America/Goose_Bay", "گۋس-بەي" },
            { "timezone.excity.America/Guatemala", "گۆاتەمالا" },
            { "timezone.excity.America/Guayaquil", "گۋاياكيل" },
            { "timezone.excity.America/Matamoros", "ماتاموروس" },
            { "timezone.excity.America/Menominee", "مەنوميني" },
            { "timezone.excity.America/Monterrey", "مونتەررەي" },
            { "timezone.excity.America/Sao_Paulo", "سان-پۋالۋ" },
            { "timezone.excity.America/St_Thomas", "سەنت-توماس" },
            { "timezone.excity.America/Vancouver", "ۆانكۋۆەر" },
            { "timezone.excity.Antarctica/Mawson", "موۋسون" },
            { "timezone.excity.Antarctica/Palmer", "پالمەر" },
            { "timezone.excity.Antarctica/Vostok", "ۆوستوك" },
            { "timezone.excity.Asia/Kuala_Lumpur", "كۋالا-لۋمپۋر" },
            { "timezone.excity.Asia/Novokuznetsk", "نوۆوكۋزنەتسك" },
            { "timezone.excity.Europe/Bratislava", "براتيسلاۆا" },
            { "timezone.excity.Europe/Copenhagen", "كوپەنگاگەن" },
            { "timezone.excity.Europe/Luxembourg", "ليۋكسەمبۋرگ" },
            { "timezone.excity.Europe/San_Marino", "سان-مارينو" },
            { "timezone.excity.Europe/Simferopol", "سيمفەرول" },
            { "timezone.excity.Pacific/Enderbury", "كانتون" },
            { "timezone.excity.Pacific/Galapagos", "گالاپاگوس" },
            { "timezone.excity.Pacific/Kwajalein", "كۆاجالەيىن" },
            { "timezone.excity.Pacific/Marquesas", "ماركيز ارالدارى" },
            { "timezone.excity.Pacific/Pago_Pago", "پاگو-پاگو" },
            { "timezone.excity.Pacific/Rarotonga", "راروتونگا" },
            { "timezone.excity.Pacific/Tongatapu", "تونگاتاپۋ" },
            { "timezone.excity.Africa/Addis_Ababa", "ادديس-ابەبا" },
            { "timezone.excity.Africa/Brazzaville", "براززاۆيل" },
            { "timezone.excity.Africa/Ouagadougou", "ۋاگادۋگۋ" },
            { "timezone.excity.America/Costa_Rica", "كوستا-ريكا" },
            { "timezone.excity.America/Grand_Turk", "گراند-تەرك" },
            { "timezone.excity.America/Guadeloupe", "گۆادەلۇپا" },
            { "timezone.excity.America/Hermosillo", "ەرموسيلو" },
            { "timezone.excity.America/Kralendijk", "كرالەندەيك" },
            { "timezone.excity.America/Louisville", "لۋيسۆيل" },
            { "timezone.excity.America/Martinique", "مارتينيكا" },
            { "timezone.excity.America/Metlakatla", "مەتلاكاتلا" },
            { "timezone.excity.America/Montevideo", "مونتەۆيدەو" },
            { "timezone.excity.America/Montserrat", "مونتسەررات" },
            { "timezone.excity.America/Paramaribo", "پاراماريبو" },
            { "timezone.excity.America/Rio_Branco", "ريۋ-برانكۋ" },
            { "timezone.excity.America/St_Vincent", "سەنت-ۆينسەنت" },
            { "timezone.excity.America/Whitehorse", "ۋايتحورس" },
            { "timezone.excity.Antarctica/McMurdo", "ماك-مەردو" },
            { "timezone.excity.Antarctica/Rothera", "روتەرا" },
            { "timezone.excity.Asia/Srednekolymsk", "سرەدنەكولىمسك" },
            { "timezone.excity.Asia/Yekaterinburg", "ەكاتەرينبۋرگ" },
            { "timezone.excity.Atlantic/Reykjavik", "رەيكياۆيك" },
            { "timezone.excity.Atlantic/St_Helena", "اۋليە ەلەنا ارالى" },
            { "timezone.excity.Australia/Adelaide", "ادەلايدا" },
            { "timezone.excity.Australia/Brisbane", "بريسبەن" },
            { "timezone.excity.Australia/Lindeman", "ليندەمان" },
            { "timezone.excity.Europe/Isle_of_Man", "مەن ارالى" },
            { "timezone.excity.Europe/Kaliningrad", "كالينينگراد" },
            { "timezone.excity.Pacific/Kiritimati", "كيريتيماتي" },
            { "timezone.excity.Africa/Johannesburg", "يوحاننەسبۋرگ" },
            { "timezone.excity.America/El_Salvador", "سالۆادور" },
            { "timezone.excity.America/Fort_Nelson", "فورت-نەلسون" },
            { "timezone.excity.America/Los_Angeles", "لوس-انجەلەس" },
            { "timezone.excity.America/Mexico_City", "مەحيكو" },
            { "timezone.excity.America/Porto_Velho", "پورتو-ۆەليۋ" },
            { "timezone.excity.America/Puerto_Rico", "پۋەرتو-ريكو" },
            { "timezone.excity.America/Tegucigalpa", "تەگۋسيگالپا" },
            { "timezone.excity.Arctic/Longyearbyen", "لونگير" },
            { "timezone.excity.Atlantic/Cape_Verde", "كابو-ۆەردە" },
            { "timezone.excity.Australia/Lord_Howe", "لورد-حاۋ" },
            { "timezone.excity.Australia/Melbourne", "مەلبۋرن" },
            { "timezone.excity.Indian/Antananarivo", "انتاناناريۆۋ" },
            { "timezone.excity.Pacific/Guadalcanal", "گۋادالكانال" },
            { "timezone.excity.Africa/Dar_es_Salaam", "دار-ەس-سالام" },
            { "timezone.excity.America/Blanc-Sablon", "بلانك-سابلون" },
            { "timezone.excity.America/Buenos_Aires", "بۋەنوس-ايروس" },
            { "timezone.excity.America/Campo_Grande", "كامپۋ-گراندە" },
            { "timezone.excity.America/Danmarkshavn", "دانماركسحاۆن" },
            { "timezone.excity.America/Dawson_Creek", "دوۋسون-كريك" },
            { "timezone.excity.America/Indiana/Knox", "نوكس، ينديانا" },
            { "timezone.excity.America/Indianapolis", "يندياناپوليس" },
            { "timezone.excity.America/Punta_Arenas", "پۋنتا-ارەناس" },
            { "timezone.excity.America/Rankin_Inlet", "رانكين-ينلەت" },
            { "timezone.excity.America/Scoresbysund", "يللوككورتوورميۋت" },
            { "timezone.excity.Antarctica/Macquarie", "ماككۋوري" },
            { "timezone.excity.Pacific/Bougainville", "بۋگەنۆيل" },
            { "timezone.excity.Pacific/Port_Moresby", "پورت-مورسبي" },
            { "timezone.excity.America/Cambridge_Bay", "كەمبريج-بەي" },
            { "timezone.excity.America/Ciudad_Juarez", "سيۋداد-حۋارەس" },
            { "timezone.excity.America/Coral_Harbour", "اتيكوكان" },
            { "timezone.excity.America/Indiana/Vevay", "ۆيۆەي، ينديانا" },
            { "timezone.excity.America/Lower_Princes", "لوۋەر-پرينس-كۋوتەر" },
            { "timezone.excity.America/Port_of_Spain", "پورت-وف-سپاين" },
            { "timezone.excity.America/Santo_Domingo", "سانتو-دومينگو" },
            { "timezone.excity.America/St_Barthelemy", "سەن-بارتەلەمي" },
            { "timezone.excity.America/Swift_Current", "سۋيات-كاررەنت" },
            { "timezone.excity.Australia/Broken_Hill", "بروكەن-حيل" },
            { "timezone.excity.America/Bahia_Banderas", "بايا-دە-باندەراس" },
            { "timezone.excity.America/Port-au-Prince", "پورت-وف-پرەنس" },
            { "timezone.excity.Atlantic/South_Georgia", "وڭتۇستىك گەورگيا" },
            { "timezone.excity.America/Argentina/Salta", "سالتا" },
            { "timezone.excity.America/Indiana/Marengo", "مارەنگو، ينديانا" },
            { "timezone.excity.America/Indiana/Winamac", "ۋيناماك، ينديانا" },
            { "timezone.excity.America/Argentina/Tucuman", "تۋكۋمان" },
            { "timezone.excity.America/Argentina/Ushuaia", "ۋشۋايا" },
            { "timezone.excity.America/Indiana/Tell_City", "تەلل-سيتي، ينديانا" },
            { "timezone.excity.America/Indiana/Vincennes", "ۆينسەننەس، ينديانا" },
            { "timezone.excity.Antarctica/DumontDUrville", "ديۋمون-ديۋرۆيل" },
            { "timezone.excity.America/Argentina/La_Rioja", "لا-ريوحا" },
            { "timezone.excity.America/Argentina/San_Juan", "سان-حۋان" },
            { "timezone.excity.America/Argentina/San_Luis", "سان-لۋيس" },
            { "timezone.excity.America/Indiana/Petersburg", "پيتەرسبەرگ، ينديانا" },
            { "timezone.excity.America/Kentucky/Monticello", "مونتيسەللو، كەنتۋككي" },
            { "timezone.excity.America/North_Dakota/Beulah", "بويلا، سولتۇستىك داكوتا" },
            { "timezone.excity.America/North_Dakota/Center", "سەنتەر، سولتۇستىك داكوتا" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ريو-گالەگوس" },
            { "timezone.excity.America/North_Dakota/New_Salem", "نيۋ-سەيلەم، سولتۇستىك داكوتا" },
        };
        return data;
    }
}
