/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.whiteboard.internal.tracker;

import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.servlet.Filter;
import javax.servlet.GenericFilter;
import javax.servlet.http.HttpFilter;
import org.ops4j.pax.web.extender.whiteboard.internal.WhiteboardExtenderContext;
import org.ops4j.pax.web.extender.whiteboard.internal.tracker.AbstractElementTracker;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.events.FilterEventData;
import org.ops4j.pax.web.service.spi.util.FilterAnnotationScanner;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.whiteboard.Preprocessor;
import org.osgi.util.tracker.ServiceTracker;

public class FilterTracker
extends AbstractElementTracker<Filter, Filter, FilterEventData, FilterModel> {
    private FilterTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        super(whiteboardExtenderContext, bundleContext);
    }

    public static ServiceTracker<Filter, FilterModel> createTracker(WhiteboardExtenderContext whiteboardExtenderContext, BundleContext bundleContext) {
        return new FilterTracker(whiteboardExtenderContext, bundleContext).create(Filter.class, GenericFilter.class, HttpFilter.class, Preprocessor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FilterModel createElementModel(ServiceReference<Filter> serviceReference, Integer rank, Long serviceId) {
        String[] stringArray;
        String[] classes = Utils.getObjectClasses(serviceReference);
        boolean preprocessor = Arrays.stream(classes).anyMatch(s -> Preprocessor.class.getName().equals(s));
        if (!preprocessor) {
            this.log.debug("Creating fiiter model from R7 whiteboard service {} (id={})", serviceReference, (Object)serviceId);
        } else {
            this.log.debug("Creating preprocessor model from R7 whiteboard service {} (id={})", serviceReference, (Object)serviceId);
        }
        String name = (String)Utils.getPaxWebProperty(serviceReference, (String)"filter-name", (String)"osgi.http.whiteboard.filter.name", Utils::asString);
        if (preprocessor) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "/*";
        } else {
            stringArray = (String[])Utils.getPaxWebProperty(serviceReference, (String)"urlPatterns", (String)"osgi.http.whiteboard.filter.pattern", Utils::asStringArray);
        }
        String[] urlPatterns = stringArray;
        Object propertyValue = preprocessor ? new String[]{} : serviceReference.getProperty("osgi.http.whiteboard.filter.regex");
        String[] regexUrlPatterns = Utils.asStringArray((String)"osgi.http.whiteboard.filter.regex", (Object)propertyValue);
        String[] servletNames = preprocessor ? new String[]{} : (String[])Utils.getPaxWebProperty(serviceReference, (String)"servletNames", (String)"osgi.http.whiteboard.filter.servlet", Utils::asStringArray);
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        if (!preprocessor) {
            String legacyInitPrefix = Utils.getStringProperty(serviceReference, (String)"init-prefix");
            if (legacyInitPrefix != null) {
                this.log.warn("Legacy {} property found, filter init parameters should be prefixed with {} instead", (Object)"init-prefix", (Object)"filter.init.");
            }
            String[] prefix = new String[]{legacyInitPrefix == null ? "init." : legacyInitPrefix};
            int hasLegacyInitProperty = Arrays.stream(serviceReference.getPropertyKeys()).anyMatch(p -> p.startsWith(prefix[0])) ? 1 : 0;
            if (hasLegacyInitProperty != 0) {
                this.log.warn("Legacy filter init parameters found (with prefix: {}), init parameters should be prefixed with {} instead", (Object)prefix[0], (Object)"filter.init.");
            } else {
                prefix[0] = "filter.init.";
            }
            for (String key : serviceReference.getPropertyKeys()) {
                String value;
                if (!key.startsWith(prefix[0]) || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
                initParams.put(key.substring(prefix[0].length()), value);
            }
        } else {
            String prefix = "preprocessor.init.";
            for (String key : serviceReference.getPropertyKeys()) {
                String value;
                if (!key.startsWith(prefix) || (value = Utils.getStringProperty(serviceReference, (String)key)) == null) continue;
                initParams.put(key.substring(prefix.length()), value);
            }
        }
        Boolean asyncSupported = (Boolean)Utils.getPaxWebProperty(serviceReference, (String)"async-supported", (String)"osgi.http.whiteboard.filter.asyncSupported", Utils::asBoolean);
        if (preprocessor) {
            asyncSupported = Boolean.TRUE;
        }
        propertyValue = serviceReference.getProperty("osgi.http.whiteboard.filter.dispatcher");
        String[] dispatcherTypeNames = Utils.asStringArray((String)"osgi.http.whiteboard.filter.dispatcher", (Object)propertyValue);
        Filter service = null;
        try {
            service = (Filter)serviceReference.getBundle().getBundleContext().getService(serviceReference);
            if (service != null) {
                FilterAnnotationScanner scanner = new FilterAnnotationScanner(service.getClass());
                if (scanner.scanned.booleanValue()) {
                    if (scanner.filterName != null) {
                        if (name != null) {
                            this.log.warn("Filter name specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{name, scanner.filterName, name});
                        } else {
                            name = scanner.filterName;
                        }
                    }
                    if (scanner.urlPatterns != null && scanner.urlPatterns.length > 0) {
                        if (urlPatterns != null && urlPatterns.length > 0) {
                            this.log.warn("Filter URL patterns specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{Arrays.asList(urlPatterns), Arrays.asList(scanner.urlPatterns), Arrays.asList(urlPatterns)});
                        } else {
                            urlPatterns = scanner.urlPatterns;
                        }
                    }
                    if (scanner.servletNames != null && scanner.servletNames.length > 0) {
                        if (servletNames != null && servletNames.length > 0) {
                            this.log.warn("Filter servlet names specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{Arrays.asList(servletNames), Arrays.asList(scanner.servletNames), Arrays.asList(servletNames)});
                        } else {
                            servletNames = scanner.servletNames;
                        }
                    }
                    if (scanner.webInitParams != null) {
                        if (!initParams.isEmpty()) {
                            this.log.warn("Filter init parameters specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{initParams, scanner.webInitParams, initParams});
                        } else {
                            initParams.putAll(scanner.webInitParams);
                        }
                    }
                    if (scanner.asyncSupported != null && asyncSupported != null && asyncSupported != scanner.asyncSupported) {
                        this.log.warn("Filter async flag specified using both service property ({}) and annotation ({}). Choosing {}.", new Object[]{asyncSupported, scanner.asyncSupported, asyncSupported});
                    }
                }
            }
        }
        finally {
            if (service != null) {
                serviceReference.getBundle().getBundleContext().ungetService(serviceReference);
            }
        }
        FilterModel.Builder builder = new FilterModel.Builder().withServiceRankAndId(rank.intValue(), serviceId.longValue()).withFilterReference(serviceReference.getBundle(), serviceReference).withUrlPatterns(urlPatterns).withServletNames(servletNames).withRegexMapping(regexUrlPatterns).withFilterName(name).withInitParams(initParams).withAsyncSupported(asyncSupported).isPreprocessor(preprocessor).withDispatcherTypes(dispatcherTypeNames);
        return builder.build();
    }

    @Override
    protected String determineSelector(boolean legacyMapping, String legacyId, String selector, ServiceReference<Filter> serviceReference) {
        boolean preprocessor = Arrays.stream(Utils.getObjectClasses(serviceReference)).anyMatch(s -> Preprocessor.class.getName().equals(s));
        if (!preprocessor) {
            return super.determineSelector(legacyMapping, legacyId, selector, serviceReference);
        }
        return "(osgi.http.whiteboard.context.name=*)";
    }
}

