# Installation

The Desktop client only works on Linux. It is recommended to use a Deb
or RPM package to install the eduVPN client. You can also install
using Pip from PyPi. We distribute RPM
packages for Fedora, and Deb packages for Debian and Ubuntu.

> **Note**
> If your target is not supported you can make an issue on the
> [Codeberg repository](https://codeberg.org/eduVPN/linux-app) and we will see
> if we can provide it. Right now, for RPM and DEB, we only provide x86_64 packages (we use a compiled dependency).
> If you want to install the client on ARM64, use the [Pip installation](#pip-installation) method.
>
> For pre-release instructions see [Pre-releases](./prerelease.md)

## Installation using a script

> **Note**
> This needs Curl installed, `sudo apt update && sudo apt install curl` on Debian/Ubuntu systems.
> Fedora systems automatically have Curl installed

We provide a script to ease the installation. This script works on the platforms we have official packages for: Debian/Ubuntu/Fedora/CentOS

```console
$ curl --proto '=https' --tlsv1.2 https://docs.eduvpn.org/client/linux/install.sh -O
$ bash ./install.sh
```

## Manual installation

For manual installation without using the script, pick the right section for
the Linux distribution that you are using. Note that these instructions assume
you are using Bash as your shell.

### Debian 12

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ bookworm main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Debian 13

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ trixie main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Ubuntu 22.04

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ jammy main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Ubuntu 24.04

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ noble main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Ubuntu 25.04

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ plucky main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Linux Mint 21.x

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ jammy main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Linux Mint 22.x

``` console
$ sudo apt update
$ sudo apt install apt-transport-https wget
$ wget -O- https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --dearmor | sudo tee /usr/share/keyrings/eduvpn-v4.gpg >/dev/null
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/eduvpn-v4.gpg] https://app.eduvpn.org/linux/v4/deb/ noble main" | sudo tee /etc/apt/sources.list.d/eduvpn-v4.list
$ sudo apt update
$ sudo apt install eduvpn-client
```

### Fedora (41 & 42)

``` console
$ curl -O https://app.eduvpn.org/linux/v4/rpm/app+linux@eduvpn.org.asc
$ sudo rpm --import app+linux@eduvpn.org.asc
$ cat << 'EOF' | sudo tee /etc/yum.repos.d/python-eduvpn-client_v4.repo
[python-eduvpn-client_v4]
name=eduVPN for Linux 4.x (Fedora $releasever)
baseurl=https://app.eduvpn.org/linux/v4/rpm/fedora-$releasever-$basearch
gpgcheck=1
EOF
$ sudo dnf install eduvpn-client
```

### CentOS (Stream 9)

``` console
$ curl -O https://app.eduvpn.org/linux/v4/rpm/app+linux@eduvpn.org.asc
$ sudo rpm --import app+linux@eduvpn.org.asc
$ cat << 'EOF' | sudo tee /etc/yum.repos.d/python-eduvpn-client_v4.repo
[python-eduvpn-client_v4]
name=eduVPN for Linux 4.x (CentOS Stream 9)
baseurl=https://app.eduvpn.org/linux/v4/rpm/centos-stream+epel-next-9-$basearch
gpgcheck=1
EOF
$ sudo dnf install eduvpn-client
```

### AlmaLinux (AlmaLinux 9)

``` console
$ curl -O https://app.eduvpn.org/linux/v4/rpm/app+linux@eduvpn.org.asc
$ sudo rpm --import app+linux@eduvpn.org.asc
$ cat << 'EOF' | sudo tee /etc/yum.repos.d/python-eduvpn-client_v4.repo
[python-eduvpn-client_v4]
name=eduVPN for Linux 4.x (AlmaLinux 9)
baseurl=https://app.eduvpn.org/linux/v4/rpm/alma+epel-9-$basearch
gpgcheck=1
EOF
$ sudo dnf install epel-release
$ sudo dnf install eduvpn-client
```

### Rocky Linux (RockyLinux 9)

``` console
$ curl -O https://app.eduvpn.org/linux/v4/rpm/app+linux@eduvpn.org.asc
$ sudo rpm --import app+linux@eduvpn.org.asc
$ cat << 'EOF' | sudo tee /etc/yum.repos.d/python-eduvpn-client_v4.repo
[python-eduvpn-client_v4]
name=eduVPN for Linux 4.x (Rocky Linux 9)
baseurl=https://app.eduvpn.org/linux/v4/rpm/rocky+epel-9-$basearch
gpgcheck=1
EOF
$ sudo dnf install epel-release
$ sudo dnf install eduvpn-client
```

### NixOS

The Linux client is in the NixOS channels.

The package name is `eduvpn-client` so you can just do:

```
nix-env -iA nixpkgs.eduvpn-client
```

or using the new Nix command (if you have it enabled with flakes)
```
nix run nixpkgs#eduvpn-client
```

The client needs NetworkManager, so make sure `networking.networkmanager.enable = true;` is set in your `configuration.nix`.

Of course, you can also just add the `eduvpn-client` package to your `configuration.nix` or `home.nix` (in case you're using [home-manager](https://github.com/nix-community/home-manager)).

Note that on NixOS the firewall can be pretty strict, see [The NixOS Wiki](https://wiki.nixos.org/wiki/WireGuard#Setting_up_WireGuard_with_NetworkManager) on how to allow WireGuard connections. OpenVPN should work out of the box.

### Arch (Unofficial)

There is an unofficial package in the [Arch User Repository
(AUR)](https://aur.archlinux.org/packages/python-eduvpn-client/). Make sure to first import the gpg signing key:

```console
$ curl https://app.eduvpn.org/linux/v4/deb/app+linux@eduvpn.org.asc | gpg --import -
```

Then build and install using your preferred AUR helper, e.g. `pamac`:

```console
$ pamac build python-eduvpn-client
```

or `yay`:

```console
$ yay -S python-eduvpn-client
```
### openSUSE

The Linux client is in the default repositories for Tumbleweed, so you can just do
```
$ sudo zypper install eduvpn-client
```


For Leap 15.6, the package is not present in the official repo but there is a development project which makes it available.

```
$ sudo zypper addrepo https://download.opensuse.org/repositories/network:vpn/openSUSE_Leap_15.6/network:vpn.repo
$ sudo zypper refresh
$ sudo zypper install eduvpn-client
```

### Pip installation

We also provide Pip packages. These are useful if your distro is not
officially supported in our packaging (yet).

#### Dependencies

To manually install the eduVPN package via Pip you first need to satisfy
the dependencies.

For Debian or Ubuntu:

``` console
$ sudo apt update
$ sudo apt install \
    gir1.2-nm-1.0 \
    gir1.2-secret-1 \
    gir1.2-gtk-3.0 \
    gir1.2-notify-0.7 \
    libcairo2-dev \
    libgirepository1.0-dev \
    python3-dev \
    python3-gi \
    python3-setuptools \
    python3-pytest \
    python3-wheel \
    network-manager-openvpn-gnome
```

For Fedora:

``` console
$ sudo dnf install \
    libnotify \
    libsecret \
    gtk3 \
    python3-gobject \
    python3-pytest \
    python3-cairo-devel \
    gobject-introspection-devel \
    cairo-gobject-devel
```

For openSUSE Tumbleweed:
```console
$ sudo zypper install \
    libnotify \
    libsecret \
    gtk3 \
    python3-gobject \
    python3-pytest \
    python3-cairo-devel \
    gobject-introspection-devel \
	typelib-1_0-Notify-0_7 \
    typelib-1_0-Secret-1 \
    typelib-1_0-Gtk-3_0
```

#### Pip commands

> **Note**
> If the Pip installation fails due to "error: externally-managed-environment",
> we recommend you to try to install the package with [Pipx](https://github.com/pypa/pipx) instead

You can then continue with installing via Pip:

``` console
$ pip install "eduvpn-client[gui]"
```

Make sure to reboot after installing
