#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AGG_TX_STATE_TRANSMITTED = 0,
	AGG_TX_STATE_UNDERRUN_MSK = 1,
	AGG_TX_STATE_BT_PRIO_MSK = 2,
	AGG_TX_STATE_FEW_BYTES_MSK = 4,
	AGG_TX_STATE_ABORT_MSK = 8,
	AGG_TX_STATE_LAST_SENT_TTL_MSK = 16,
	AGG_TX_STATE_LAST_SENT_TRY_CNT_MSK = 32,
	AGG_TX_STATE_LAST_SENT_BT_KILL_MSK = 64,
	AGG_TX_STATE_SCD_QUERY_MSK = 128,
	AGG_TX_STATE_TEST_BAD_CRC32_MSK = 256,
	AGG_TX_STATE_RESPONSE_MSK = 511,
	AGG_TX_STATE_DUMP_TX_MSK = 512,
	AGG_TX_STATE_DELAY_TX_MSK = 1024,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ARCH_LBR_BR_TYPE_JCC = 0,
	ARCH_LBR_BR_TYPE_NEAR_IND_JMP = 1,
	ARCH_LBR_BR_TYPE_NEAR_REL_JMP = 2,
	ARCH_LBR_BR_TYPE_NEAR_IND_CALL = 3,
	ARCH_LBR_BR_TYPE_NEAR_REL_CALL = 4,
	ARCH_LBR_BR_TYPE_NEAR_RET = 5,
	ARCH_LBR_BR_TYPE_KNOWN_MAX = 5,
	ARCH_LBR_BR_TYPE_MAP_MAX = 16,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_PLUGGING = 12,
	BIO_EMULATES_ZONE_APPEND = 13,
	BIO_FLAG_LAST = 14,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BRIDGE_QUERIER_UNSPEC = 0,
	BRIDGE_QUERIER_IP_ADDRESS = 1,
	BRIDGE_QUERIER_IP_PORT = 2,
	BRIDGE_QUERIER_IP_OTHER_TIMER = 3,
	BRIDGE_QUERIER_PAD = 4,
	BRIDGE_QUERIER_IPV6_ADDRESS = 5,
	BRIDGE_QUERIER_IPV6_PORT = 6,
	BRIDGE_QUERIER_IPV6_OTHER_TIMER = 7,
	__BRIDGE_QUERIER_MAX = 8,
};

enum {
	BRIDGE_XSTATS_UNSPEC = 0,
	BRIDGE_XSTATS_VLAN = 1,
	BRIDGE_XSTATS_MCAST = 2,
	BRIDGE_XSTATS_PAD = 3,
	BRIDGE_XSTATS_STP = 4,
	__BRIDGE_XSTATS_MAX = 5,
};

enum {
	BR_FDB_LOCAL = 0,
	BR_FDB_STATIC = 1,
	BR_FDB_STICKY = 2,
	BR_FDB_ADDED_BY_USER = 3,
	BR_FDB_ADDED_BY_EXT_LEARN = 4,
	BR_FDB_OFFLOADED = 5,
	BR_FDB_NOTIFY = 6,
	BR_FDB_NOTIFY_INACTIVE = 7,
	BR_FDB_LOCKED = 8,
	BR_FDB_DYNAMIC_LEARNED = 9,
};

enum {
	BR_GROUPFWD_STP = 1,
	BR_GROUPFWD_MACPAUSE = 2,
	BR_GROUPFWD_LACP = 4,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BR_VLFLAG_PER_PORT_STATS = 1,
	BR_VLFLAG_ADDED_BY_SWITCHDEV = 2,
	BR_VLFLAG_MCAST_ENABLED = 4,
	BR_VLFLAG_GLOBAL_MCAST_ENABLED = 8,
	BR_VLFLAG_NEIGH_SUPPRESS_ENABLED = 16,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTRFS_FILE_EXTENT_INLINE = 0,
	BTRFS_FILE_EXTENT_REG = 1,
	BTRFS_FILE_EXTENT_PREALLOC = 2,
	BTRFS_NR_FILE_EXTENT_TYPES = 3,
};

enum {
	BTRFS_FS_CLOSING_START = 0,
	BTRFS_FS_CLOSING_DONE = 1,
	BTRFS_FS_LOG_RECOVERING = 2,
	BTRFS_FS_OPEN = 3,
	BTRFS_FS_QUOTA_ENABLED = 4,
	BTRFS_FS_UPDATE_UUID_TREE_GEN = 5,
	BTRFS_FS_CREATING_FREE_SPACE_TREE = 6,
	BTRFS_FS_BTREE_ERR = 7,
	BTRFS_FS_LOG1_ERR = 8,
	BTRFS_FS_LOG2_ERR = 9,
	BTRFS_FS_QUOTA_OVERRIDE = 10,
	BTRFS_FS_FROZEN = 11,
	BTRFS_FS_BALANCE_RUNNING = 12,
	BTRFS_FS_RELOC_RUNNING = 13,
	BTRFS_FS_CLEANER_RUNNING = 14,
	BTRFS_FS_CSUM_IMPL_FAST = 15,
	BTRFS_FS_DISCARD_RUNNING = 16,
	BTRFS_FS_CLEANUP_SPACE_CACHE_V1 = 17,
	BTRFS_FS_FREE_SPACE_TREE_UNTRUSTED = 18,
	BTRFS_FS_TREE_MOD_LOG_USERS = 19,
	BTRFS_FS_COMMIT_TRANS = 20,
	BTRFS_FS_UNFINISHED_DROPS = 21,
	BTRFS_FS_NEED_ZONE_FINISH = 22,
	BTRFS_FS_NEED_TRANS_COMMIT = 23,
	BTRFS_FS_ACTIVE_ZONE_TRACKING = 24,
	BTRFS_FS_FEATURE_CHANGED = 25,
	BTRFS_FS_UNALIGNED_TREE_BLOCK = 26,
};

enum {
	BTRFS_FS_STATE_REMOUNTING = 0,
	BTRFS_FS_STATE_RO = 1,
	BTRFS_FS_STATE_TRANS_ABORTED = 2,
	BTRFS_FS_STATE_DEV_REPLACING = 3,
	BTRFS_FS_STATE_DUMMY_FS_INFO = 4,
	BTRFS_FS_STATE_NO_DATA_CSUMS = 5,
	BTRFS_FS_STATE_SKIP_META_CSUMS = 6,
	BTRFS_FS_STATE_LOG_CLEANUP_ERROR = 7,
	BTRFS_FS_STATE_COUNT = 8,
};

enum {
	BTRFS_INODE_FLUSH_ON_CLOSE = 0,
	BTRFS_INODE_DUMMY = 1,
	BTRFS_INODE_IN_DEFRAG = 2,
	BTRFS_INODE_HAS_ASYNC_EXTENT = 3,
	BTRFS_INODE_NEEDS_FULL_SYNC = 4,
	BTRFS_INODE_COPY_EVERYTHING = 5,
	BTRFS_INODE_HAS_PROPS = 6,
	BTRFS_INODE_SNAPSHOT_FLUSH = 7,
	BTRFS_INODE_NO_XATTRS = 8,
	BTRFS_INODE_NO_DELALLOC_FLUSH = 9,
	BTRFS_INODE_VERITY_IN_PROGRESS = 10,
	BTRFS_INODE_FREE_SPACE_INODE = 11,
	BTRFS_INODE_NO_CAP_XATTR = 12,
	BTRFS_INODE_COW_WRITE_ERROR = 13,
	BTRFS_INODE_ROOT_STUB = 14,
};

enum {
	BTRFS_MOUNT_NODATASUM = 1ULL,
	BTRFS_MOUNT_NODATACOW = 2ULL,
	BTRFS_MOUNT_NOBARRIER = 4ULL,
	BTRFS_MOUNT_SSD = 8ULL,
	BTRFS_MOUNT_DEGRADED = 16ULL,
	BTRFS_MOUNT_COMPRESS = 32ULL,
	BTRFS_MOUNT_NOTREELOG = 64ULL,
	BTRFS_MOUNT_FLUSHONCOMMIT = 128ULL,
	BTRFS_MOUNT_SSD_SPREAD = 256ULL,
	BTRFS_MOUNT_NOSSD = 512ULL,
	BTRFS_MOUNT_DISCARD_SYNC = 1024ULL,
	BTRFS_MOUNT_FORCE_COMPRESS = 2048ULL,
	BTRFS_MOUNT_SPACE_CACHE = 4096ULL,
	BTRFS_MOUNT_CLEAR_CACHE = 8192ULL,
	BTRFS_MOUNT_USER_SUBVOL_RM_ALLOWED = 16384ULL,
	BTRFS_MOUNT_ENOSPC_DEBUG = 32768ULL,
	BTRFS_MOUNT_AUTO_DEFRAG = 65536ULL,
	BTRFS_MOUNT_USEBACKUPROOT = 131072ULL,
	BTRFS_MOUNT_SKIP_BALANCE = 262144ULL,
	BTRFS_MOUNT_PANIC_ON_FATAL_ERROR = 524288ULL,
	BTRFS_MOUNT_RESCAN_UUID_TREE = 1048576ULL,
	BTRFS_MOUNT_FRAGMENT_DATA = 2097152ULL,
	BTRFS_MOUNT_FRAGMENT_METADATA = 4194304ULL,
	BTRFS_MOUNT_FREE_SPACE_TREE = 8388608ULL,
	BTRFS_MOUNT_NOLOGREPLAY = 16777216ULL,
	BTRFS_MOUNT_REF_VERIFY = 33554432ULL,
	BTRFS_MOUNT_DISCARD_ASYNC = 67108864ULL,
	BTRFS_MOUNT_IGNOREBADROOTS = 134217728ULL,
	BTRFS_MOUNT_IGNOREDATACSUMS = 268435456ULL,
	BTRFS_MOUNT_NODISCARD = 536870912ULL,
	BTRFS_MOUNT_NOSPACECACHE = 1073741824ULL,
	BTRFS_MOUNT_IGNOREMETACSUMS = 2147483648ULL,
	BTRFS_MOUNT_IGNORESUPERFLAGS = 4294967296ULL,
};

enum {
	BTRFS_ORDERED_REGULAR = 0,
	BTRFS_ORDERED_NOCOW = 1,
	BTRFS_ORDERED_PREALLOC = 2,
	BTRFS_ORDERED_COMPRESSED = 3,
	BTRFS_ORDERED_DIRECT = 4,
	BTRFS_ORDERED_IO_DONE = 5,
	BTRFS_ORDERED_COMPLETE = 6,
	BTRFS_ORDERED_IOERR = 7,
	BTRFS_ORDERED_TRUNCATED = 8,
	BTRFS_ORDERED_LOGGED = 9,
	BTRFS_ORDERED_LOGGED_CSUM = 10,
	BTRFS_ORDERED_PENDING = 11,
	BTRFS_ORDERED_ENCODED = 12,
};

enum {
	BTRFS_ROOT_IN_TRANS_SETUP = 0,
	BTRFS_ROOT_SHAREABLE = 1,
	BTRFS_ROOT_TRACK_DIRTY = 2,
	BTRFS_ROOT_IN_RADIX = 3,
	BTRFS_ROOT_ORPHAN_ITEM_INSERTED = 4,
	BTRFS_ROOT_DEFRAG_RUNNING = 5,
	BTRFS_ROOT_FORCE_COW = 6,
	BTRFS_ROOT_MULTI_LOG_TASKS = 7,
	BTRFS_ROOT_DIRTY = 8,
	BTRFS_ROOT_DELETING = 9,
	BTRFS_ROOT_DEAD_RELOC_TREE = 10,
	BTRFS_ROOT_DEAD_TREE = 11,
	BTRFS_ROOT_HAS_LOG_TREE = 12,
	BTRFS_ROOT_QGROUP_FLUSHING = 13,
	BTRFS_ROOT_ORPHAN_CLEANUP = 14,
	BTRFS_ROOT_UNFINISHED_DROP = 15,
	BTRFS_ROOT_RESET_LOCKDEP_CLASS = 16,
};

enum {
	BTRFS_SEND_A_UNSPEC = 0,
	BTRFS_SEND_A_UUID = 1,
	BTRFS_SEND_A_CTRANSID = 2,
	BTRFS_SEND_A_INO = 3,
	BTRFS_SEND_A_SIZE = 4,
	BTRFS_SEND_A_MODE = 5,
	BTRFS_SEND_A_UID = 6,
	BTRFS_SEND_A_GID = 7,
	BTRFS_SEND_A_RDEV = 8,
	BTRFS_SEND_A_CTIME = 9,
	BTRFS_SEND_A_MTIME = 10,
	BTRFS_SEND_A_ATIME = 11,
	BTRFS_SEND_A_OTIME = 12,
	BTRFS_SEND_A_XATTR_NAME = 13,
	BTRFS_SEND_A_XATTR_DATA = 14,
	BTRFS_SEND_A_PATH = 15,
	BTRFS_SEND_A_PATH_TO = 16,
	BTRFS_SEND_A_PATH_LINK = 17,
	BTRFS_SEND_A_FILE_OFFSET = 18,
	BTRFS_SEND_A_DATA = 19,
	BTRFS_SEND_A_CLONE_UUID = 20,
	BTRFS_SEND_A_CLONE_CTRANSID = 21,
	BTRFS_SEND_A_CLONE_PATH = 22,
	BTRFS_SEND_A_CLONE_OFFSET = 23,
	BTRFS_SEND_A_CLONE_LEN = 24,
	BTRFS_SEND_A_MAX_V1 = 24,
	BTRFS_SEND_A_FALLOCATE_MODE = 25,
	BTRFS_SEND_A_FILEATTR = 26,
	BTRFS_SEND_A_UNENCODED_FILE_LEN = 27,
	BTRFS_SEND_A_UNENCODED_LEN = 28,
	BTRFS_SEND_A_UNENCODED_OFFSET = 29,
	BTRFS_SEND_A_COMPRESSION = 30,
	BTRFS_SEND_A_ENCRYPTION = 31,
	BTRFS_SEND_A_MAX_V2 = 31,
	BTRFS_SEND_A_VERITY_ALGORITHM = 32,
	BTRFS_SEND_A_VERITY_BLOCK_SIZE = 33,
	BTRFS_SEND_A_VERITY_SALT_DATA = 34,
	BTRFS_SEND_A_VERITY_SIG_DATA = 35,
	BTRFS_SEND_A_MAX_V3 = 35,
	__BTRFS_SEND_A_MAX = 35,
};

enum {
	BTRFS_STAT_CURR = 0,
	BTRFS_STAT_PREV = 1,
	BTRFS_STAT_NR_ENTRIES = 2,
};

enum {
	BTS_STATE_STOPPED = 0,
	BTS_STATE_INACTIVE = 1,
	BTS_STATE_ACTIVE = 2,
};

enum {
	Blktrace_setup = 1,
	Blktrace_running = 2,
	Blktrace_stopped = 3,
};

enum {
	CCUT_IDX_1R_2G = 0,
	CCUT_IDX_2R_2G = 1,
	CCUT_IDX_1R_5G = 2,
	CCUT_IDX_2R_5G = 3,
	CCUT_IDX_NR = 4,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
	CGRP_KILL = 4,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CHANNEL_MODE_LEGACY = 0,
	CHANNEL_MODE_PURE_40 = 1,
	CHANNEL_MODE_MIXED = 2,
	CHANNEL_MODE_RESERVED = 3,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 1000,
	CRNG_RESEED_INTERVAL = 60000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_AUTHENC_KEYA_UNSPEC = 0,
	CRYPTO_AUTHENC_KEYA_PARAM = 1,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DCCPO_PADDING = 0,
	DCCPO_MANDATORY = 1,
	DCCPO_MIN_RESERVED = 3,
	DCCPO_MAX_RESERVED = 31,
	DCCPO_CHANGE_L = 32,
	DCCPO_CONFIRM_L = 33,
	DCCPO_CHANGE_R = 34,
	DCCPO_CONFIRM_R = 35,
	DCCPO_NDP_COUNT = 37,
	DCCPO_ACK_VECTOR_0 = 38,
	DCCPO_ACK_VECTOR_1 = 39,
	DCCPO_TIMESTAMP = 41,
	DCCPO_TIMESTAMP_ECHO = 42,
	DCCPO_ELAPSED_TIME = 43,
	DCCPO_MAX = 45,
	DCCPO_MIN_RX_CCID_SPECIFIC = 128,
	DCCPO_MAX_RX_CCID_SPECIFIC = 191,
	DCCPO_MIN_TX_CCID_SPECIFIC = 192,
	DCCPO_MAX_TX_CCID_SPECIFIC = 255,
};

enum {
	DESC_TSS = 9,
	DESC_LDT = 2,
	DESCTYPE_S = 16,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DMA_DSCR_HOST = 0,
	DMA_DSCR_DEVICE = 1,
	DMA_DSCR_CTRL = 2,
	DMA_DSCR_NUM = 3,
};

enum {
	DM_IO_ACCOUNTED = 0,
	DM_IO_WAS_SPLIT = 1,
	DM_IO_BLK_STAT = 2,
};

enum {
	DM_TIO_INSIDE_DM_IO = 0,
	DM_TIO_IS_DUPLICATE_BIO = 1,
};

enum {
	DM_VERSION_CMD = 0,
	DM_REMOVE_ALL_CMD = 1,
	DM_LIST_DEVICES_CMD = 2,
	DM_DEV_CREATE_CMD = 3,
	DM_DEV_REMOVE_CMD = 4,
	DM_DEV_RENAME_CMD = 5,
	DM_DEV_SUSPEND_CMD = 6,
	DM_DEV_STATUS_CMD = 7,
	DM_DEV_WAIT_CMD = 8,
	DM_TABLE_LOAD_CMD = 9,
	DM_TABLE_CLEAR_CMD = 10,
	DM_TABLE_DEPS_CMD = 11,
	DM_TABLE_STATUS_CMD = 12,
	DM_LIST_VERSIONS_CMD = 13,
	DM_TARGET_MSG_CMD = 14,
	DM_DEV_SET_GEOMETRY_CMD = 15,
	DM_DEV_ARM_POLL_CMD = 16,
	DM_GET_TARGET_VERSION_CMD = 17,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	DVM_OP_MODE = 0,
	MVM_OP_MODE = 1,
};

enum {
	EC_FLAGS_QUERY_ENABLED = 0,
	EC_FLAGS_EVENT_HANDLER_INSTALLED = 1,
	EC_FLAGS_EC_HANDLER_INSTALLED = 2,
	EC_FLAGS_EC_REG_CALLED = 3,
	EC_FLAGS_QUERY_METHODS_INSTALLED = 4,
	EC_FLAGS_STARTED = 5,
	EC_FLAGS_STOPPED = 6,
	EC_FLAGS_EVENTS_MASKED = 7,
};

enum {
	EI_ETYPE_NULL = 0,
	EI_ETYPE_ERRNO = 1,
	EI_ETYPE_ERRNO_NULL = 2,
	EI_ETYPE_TRUE = 3,
};

enum {
	EMULATE = 0,
	XONLY = 1,
	NONE = 2,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	__ETHTOOL_A_TSINFO_CNT = 8,
	ETHTOOL_A_TSINFO_MAX = 7,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

enum {
	EXTENT_BUFFER_UPTODATE = 0,
	EXTENT_BUFFER_DIRTY = 1,
	EXTENT_BUFFER_CORRUPT = 2,
	EXTENT_BUFFER_READAHEAD = 3,
	EXTENT_BUFFER_TREE_REF = 4,
	EXTENT_BUFFER_STALE = 5,
	EXTENT_BUFFER_WRITEBACK = 6,
	EXTENT_BUFFER_READ_ERR = 7,
	EXTENT_BUFFER_UNMAPPED = 8,
	EXTENT_BUFFER_IN_TREE = 9,
	EXTENT_BUFFER_WRITE_ERR = 10,
	EXTENT_BUFFER_ZONED_ZEROOUT = 11,
	EXTENT_BUFFER_READING = 12,
};

enum {
	EXTRA_REG_NHMEX_M_FILTER = 0,
	EXTRA_REG_NHMEX_M_DSP = 1,
	EXTRA_REG_NHMEX_M_ISS = 2,
	EXTRA_REG_NHMEX_M_MAP = 3,
	EXTRA_REG_NHMEX_M_MSC_THR = 4,
	EXTRA_REG_NHMEX_M_PGT = 5,
	EXTRA_REG_NHMEX_M_PLD = 6,
	EXTRA_REG_NHMEX_M_ZDP_CTL_FVC = 7,
};

enum {
	Enabled = 0,
	Magic = 1,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FDB_NOTIFY_BIT = 1,
	FDB_NOTIFY_INACTIVE_BIT = 2,
};

enum {
	FGRAPH_TYPE_RESERVED = 0,
	FGRAPH_TYPE_BITMAP = 1,
	FGRAPH_TYPE_DATA = 2,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FLAGS_FILL_FULL = 268435456,
	FLAGS_FILL_START = 536870912,
	FLAGS_FILL_END = 805306368,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FTRACE_FL_ENABLED = 2147483648,
	FTRACE_FL_REGS = 1073741824,
	FTRACE_FL_REGS_EN = 536870912,
	FTRACE_FL_TRAMP = 268435456,
	FTRACE_FL_TRAMP_EN = 134217728,
	FTRACE_FL_IPMODIFY = 67108864,
	FTRACE_FL_DISABLED = 33554432,
	FTRACE_FL_DIRECT = 16777216,
	FTRACE_FL_DIRECT_EN = 8388608,
	FTRACE_FL_CALL_OPS = 4194304,
	FTRACE_FL_CALL_OPS_EN = 2097152,
	FTRACE_FL_TOUCHED = 1048576,
	FTRACE_FL_MODIFIED = 524288,
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum {
	FTRACE_ITER_FILTER = 1,
	FTRACE_ITER_NOTRACE = 2,
	FTRACE_ITER_PRINTALL = 4,
	FTRACE_ITER_DO_PROBES = 8,
	FTRACE_ITER_PROBE = 16,
	FTRACE_ITER_MOD = 32,
	FTRACE_ITER_ENABLED = 64,
	FTRACE_ITER_TOUCHED = 128,
	FTRACE_ITER_ADDRS = 256,
};

enum {
	FTRACE_MODIFY_ENABLE_FL = 1,
	FTRACE_MODIFY_MAY_SLEEP_FL = 2,
};

enum {
	FTRACE_OPS_FL_ENABLED = 1,
	FTRACE_OPS_FL_DYNAMIC = 2,
	FTRACE_OPS_FL_SAVE_REGS = 4,
	FTRACE_OPS_FL_SAVE_REGS_IF_SUPPORTED = 8,
	FTRACE_OPS_FL_RECURSION = 16,
	FTRACE_OPS_FL_STUB = 32,
	FTRACE_OPS_FL_INITIALIZED = 64,
	FTRACE_OPS_FL_DELETED = 128,
	FTRACE_OPS_FL_ADDING = 256,
	FTRACE_OPS_FL_REMOVING = 512,
	FTRACE_OPS_FL_MODIFYING = 1024,
	FTRACE_OPS_FL_ALLOC_TRAMP = 2048,
	FTRACE_OPS_FL_IPMODIFY = 4096,
	FTRACE_OPS_FL_PID = 8192,
	FTRACE_OPS_FL_RCU = 16384,
	FTRACE_OPS_FL_TRACE_ARRAY = 32768,
	FTRACE_OPS_FL_PERMANENT = 65536,
	FTRACE_OPS_FL_DIRECT = 131072,
	FTRACE_OPS_FL_SUBOP = 262144,
};

enum {
	FTRACE_UPDATE_CALLS = 1,
	FTRACE_DISABLE_CALLS = 2,
	FTRACE_UPDATE_TRACE_FUNC = 4,
	FTRACE_START_FUNC_RET = 8,
	FTRACE_STOP_FUNC_RET = 16,
	FTRACE_MAY_SLEEP = 32,
};

enum {
	FTRACE_UPDATE_IGNORE = 0,
	FTRACE_UPDATE_MAKE_CALL = 1,
	FTRACE_UPDATE_MODIFY_CALL = 2,
	FTRACE_UPDATE_MAKE_NOP = 3,
};

enum {
	FUSE_I_ADVISE_RDPLUS = 0,
	FUSE_I_INIT_RDPLUS = 1,
	FUSE_I_SIZE_UNSTABLE = 2,
	FUSE_I_BAD = 3,
	FUSE_I_BTIME = 4,
	FUSE_I_CACHE_IO_MODE = 5,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	GATE_INTERRUPT = 14,
	GATE_TRAP = 15,
	GATE_CALL = 12,
	GATE_TASK = 5,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HIST_ERR_NONE = 0,
	HIST_ERR_DUPLICATE_VAR = 1,
	HIST_ERR_VAR_NOT_UNIQUE = 2,
	HIST_ERR_TOO_MANY_VARS = 3,
	HIST_ERR_MALFORMED_ASSIGNMENT = 4,
	HIST_ERR_NAMED_MISMATCH = 5,
	HIST_ERR_TRIGGER_EEXIST = 6,
	HIST_ERR_TRIGGER_ENOENT_CLEAR = 7,
	HIST_ERR_SET_CLOCK_FAIL = 8,
	HIST_ERR_BAD_FIELD_MODIFIER = 9,
	HIST_ERR_TOO_MANY_SUBEXPR = 10,
	HIST_ERR_TIMESTAMP_MISMATCH = 11,
	HIST_ERR_TOO_MANY_FIELD_VARS = 12,
	HIST_ERR_EVENT_FILE_NOT_FOUND = 13,
	HIST_ERR_HIST_NOT_FOUND = 14,
	HIST_ERR_HIST_CREATE_FAIL = 15,
	HIST_ERR_SYNTH_VAR_NOT_FOUND = 16,
	HIST_ERR_SYNTH_EVENT_NOT_FOUND = 17,
	HIST_ERR_SYNTH_TYPE_MISMATCH = 18,
	HIST_ERR_SYNTH_COUNT_MISMATCH = 19,
	HIST_ERR_FIELD_VAR_PARSE_FAIL = 20,
	HIST_ERR_VAR_CREATE_FIND_FAIL = 21,
	HIST_ERR_ONX_NOT_VAR = 22,
	HIST_ERR_ONX_VAR_NOT_FOUND = 23,
	HIST_ERR_ONX_VAR_CREATE_FAIL = 24,
	HIST_ERR_FIELD_VAR_CREATE_FAIL = 25,
	HIST_ERR_TOO_MANY_PARAMS = 26,
	HIST_ERR_PARAM_NOT_FOUND = 27,
	HIST_ERR_INVALID_PARAM = 28,
	HIST_ERR_ACTION_NOT_FOUND = 29,
	HIST_ERR_NO_SAVE_PARAMS = 30,
	HIST_ERR_TOO_MANY_SAVE_ACTIONS = 31,
	HIST_ERR_ACTION_MISMATCH = 32,
	HIST_ERR_NO_CLOSING_PAREN = 33,
	HIST_ERR_SUBSYS_NOT_FOUND = 34,
	HIST_ERR_INVALID_SUBSYS_EVENT = 35,
	HIST_ERR_INVALID_REF_KEY = 36,
	HIST_ERR_VAR_NOT_FOUND = 37,
	HIST_ERR_FIELD_NOT_FOUND = 38,
	HIST_ERR_EMPTY_ASSIGNMENT = 39,
	HIST_ERR_INVALID_SORT_MODIFIER = 40,
	HIST_ERR_EMPTY_SORT_FIELD = 41,
	HIST_ERR_TOO_MANY_SORT_FIELDS = 42,
	HIST_ERR_INVALID_SORT_FIELD = 43,
	HIST_ERR_INVALID_STR_OPERAND = 44,
	HIST_ERR_EXPECT_NUMBER = 45,
	HIST_ERR_UNARY_MINUS_SUBEXPR = 46,
	HIST_ERR_DIVISION_BY_ZERO = 47,
	HIST_ERR_NEED_NOHC_VAL = 48,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IEEE80211_PROBE_FLAG_DIRECTED = 1,
	IEEE80211_PROBE_FLAG_MIN_CONTENT = 2,
	IEEE80211_PROBE_FLAG_RANDOM_SN = 4,
};

enum {
	IEEE80211_RX_MSG = 1,
	IEEE80211_TX_STATUS_MSG = 2,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRIDGE_VLAN_TUNNEL_UNSPEC = 0,
	IFLA_BRIDGE_VLAN_TUNNEL_ID = 1,
	IFLA_BRIDGE_VLAN_TUNNEL_VID = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_FLAGS = 3,
	__IFLA_BRIDGE_VLAN_TUNNEL_MAX = 4,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_BR_UNSPEC = 0,
	IFLA_BR_FORWARD_DELAY = 1,
	IFLA_BR_HELLO_TIME = 2,
	IFLA_BR_MAX_AGE = 3,
	IFLA_BR_AGEING_TIME = 4,
	IFLA_BR_STP_STATE = 5,
	IFLA_BR_PRIORITY = 6,
	IFLA_BR_VLAN_FILTERING = 7,
	IFLA_BR_VLAN_PROTOCOL = 8,
	IFLA_BR_GROUP_FWD_MASK = 9,
	IFLA_BR_ROOT_ID = 10,
	IFLA_BR_BRIDGE_ID = 11,
	IFLA_BR_ROOT_PORT = 12,
	IFLA_BR_ROOT_PATH_COST = 13,
	IFLA_BR_TOPOLOGY_CHANGE = 14,
	IFLA_BR_TOPOLOGY_CHANGE_DETECTED = 15,
	IFLA_BR_HELLO_TIMER = 16,
	IFLA_BR_TCN_TIMER = 17,
	IFLA_BR_TOPOLOGY_CHANGE_TIMER = 18,
	IFLA_BR_GC_TIMER = 19,
	IFLA_BR_GROUP_ADDR = 20,
	IFLA_BR_FDB_FLUSH = 21,
	IFLA_BR_MCAST_ROUTER = 22,
	IFLA_BR_MCAST_SNOOPING = 23,
	IFLA_BR_MCAST_QUERY_USE_IFADDR = 24,
	IFLA_BR_MCAST_QUERIER = 25,
	IFLA_BR_MCAST_HASH_ELASTICITY = 26,
	IFLA_BR_MCAST_HASH_MAX = 27,
	IFLA_BR_MCAST_LAST_MEMBER_CNT = 28,
	IFLA_BR_MCAST_STARTUP_QUERY_CNT = 29,
	IFLA_BR_MCAST_LAST_MEMBER_INTVL = 30,
	IFLA_BR_MCAST_MEMBERSHIP_INTVL = 31,
	IFLA_BR_MCAST_QUERIER_INTVL = 32,
	IFLA_BR_MCAST_QUERY_INTVL = 33,
	IFLA_BR_MCAST_QUERY_RESPONSE_INTVL = 34,
	IFLA_BR_MCAST_STARTUP_QUERY_INTVL = 35,
	IFLA_BR_NF_CALL_IPTABLES = 36,
	IFLA_BR_NF_CALL_IP6TABLES = 37,
	IFLA_BR_NF_CALL_ARPTABLES = 38,
	IFLA_BR_VLAN_DEFAULT_PVID = 39,
	IFLA_BR_PAD = 40,
	IFLA_BR_VLAN_STATS_ENABLED = 41,
	IFLA_BR_MCAST_STATS_ENABLED = 42,
	IFLA_BR_MCAST_IGMP_VERSION = 43,
	IFLA_BR_MCAST_MLD_VERSION = 44,
	IFLA_BR_VLAN_STATS_PER_PORT = 45,
	IFLA_BR_MULTI_BOOLOPT = 46,
	IFLA_BR_MCAST_QUERIER_STATE = 47,
	IFLA_BR_FDB_N_LEARNED = 48,
	IFLA_BR_FDB_MAX_LEARNED = 49,
	__IFLA_BR_MAX = 50,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	__IFLA_MAX = 67,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_COMB_AP = 0,
	NUM_IF_COMB = 1,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	IIO_TOPOLOGY_TYPE = 0,
	UPI_TOPOLOGY_TYPE = 1,
	TOPOLOGY_MAX = 2,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORES_MAP_SYSTEM_RAM = 1,
	IORES_MAP_ENCRYPTED = 2,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_REQUEUE = -3072,
	IOU_STOP_MULTISHOT = -125,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_TREE_FS_PINNED_EXTENTS = 0,
	IO_TREE_FS_EXCLUDED_EXTENTS = 1,
	IO_TREE_BTREE_INODE_IO = 2,
	IO_TREE_INODE_IO = 3,
	IO_TREE_RELOC_BLOCKS = 4,
	IO_TREE_TRANS_DIRTY_PAGES = 5,
	IO_TREE_ROOT_DIRTY_LOG_PAGES = 6,
	IO_TREE_INODE_FILE_EXTENT = 7,
	IO_TREE_LOG_CSUM_RANGE = 8,
	IO_TREE_SELFTEST = 9,
	IO_TREE_DEVICE_ALLOC_STATE = 10,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
	IO_WORKER_F_BOUND = 3,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6T_HL_EQ = 0,
	IP6T_HL_NE = 1,
	IP6T_HL_LT = 2,
	IP6T_HL_GT = 3,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPT_TTL_EQ = 0,
	IPT_TTL_NE = 1,
	IPT_TTL_LT = 2,
	IPT_TTL_GT = 3,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_OIF = 4,
	IPV6_SADDR_RULE_LABEL = 5,
	IPV6_SADDR_RULE_PRIVACY = 6,
	IPV6_SADDR_RULE_ORCHID = 7,
	IPV6_SADDR_RULE_PREFIX = 8,
	IPV6_SADDR_RULE_MAX = 9,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	IWL_CALIB_ENABLE_ALL = 0,
	IWL_SENSITIVITY_CALIB_DISABLED = 1,
	IWL_CHAIN_NOISE_CALIB_DISABLED = 2,
	IWL_TX_POWER_CALIB_DISABLED = 4,
	IWL_CALIB_DISABLE_ALL = 4294967295,
};

enum {
	IWL_FIRST_OFDM_RATE = 4,
	IWL_LAST_OFDM_RATE = 12,
	IWL_FIRST_CCK_RATE = 0,
	IWL_LAST_CCK_RATE = 3,
};

enum {
	IWL_PHY_CALIBRATE_DC_CMD = 8,
	IWL_PHY_CALIBRATE_LO_CMD = 9,
	IWL_PHY_CALIBRATE_TX_IQ_CMD = 11,
	IWL_PHY_CALIBRATE_CRYSTAL_FRQ_CMD = 15,
	IWL_PHY_CALIBRATE_BASE_BAND_CMD = 16,
	IWL_PHY_CALIBRATE_TX_IQ_PERD_CMD = 17,
	IWL_PHY_CALIBRATE_TEMP_OFFSET_CMD = 18,
};

enum {
	IWL_RATE_1M_INDEX = 0,
	IWL_RATE_2M_INDEX = 1,
	IWL_RATE_5M_INDEX = 2,
	IWL_RATE_11M_INDEX = 3,
	IWL_RATE_6M_INDEX = 4,
	IWL_RATE_9M_INDEX = 5,
	IWL_RATE_12M_INDEX = 6,
	IWL_RATE_18M_INDEX = 7,
	IWL_RATE_24M_INDEX = 8,
	IWL_RATE_36M_INDEX = 9,
	IWL_RATE_48M_INDEX = 10,
	IWL_RATE_54M_INDEX = 11,
	IWL_RATE_60M_INDEX = 12,
	IWL_RATE_COUNT = 13,
	IWL_RATE_COUNT_LEGACY = 12,
	IWL_RATE_INVM_INDEX = 13,
	IWL_RATE_INVALID = 13,
};

enum {
	IWL_RATE_1M_INDEX___2 = 0,
	IWL_FIRST_CCK_RATE___2 = 0,
	IWL_RATE_2M_INDEX___2 = 1,
	IWL_RATE_5M_INDEX___2 = 2,
	IWL_RATE_11M_INDEX___2 = 3,
	IWL_LAST_CCK_RATE___2 = 3,
	IWL_RATE_6M_INDEX___2 = 4,
	IWL_FIRST_OFDM_RATE___2 = 4,
	IWL_RATE_MCS_0_INDEX = 4,
	IWL_FIRST_HT_RATE = 4,
	IWL_FIRST_VHT_RATE = 4,
	IWL_RATE_9M_INDEX___2 = 5,
	IWL_RATE_12M_INDEX___2 = 6,
	IWL_RATE_MCS_1_INDEX = 6,
	IWL_RATE_18M_INDEX___2 = 7,
	IWL_RATE_MCS_2_INDEX = 7,
	IWL_RATE_24M_INDEX___2 = 8,
	IWL_RATE_MCS_3_INDEX = 8,
	IWL_RATE_36M_INDEX___2 = 9,
	IWL_RATE_MCS_4_INDEX = 9,
	IWL_RATE_48M_INDEX___2 = 10,
	IWL_RATE_MCS_5_INDEX = 10,
	IWL_RATE_54M_INDEX___2 = 11,
	IWL_RATE_MCS_6_INDEX = 11,
	IWL_LAST_NON_HT_RATE = 11,
	IWL_RATE_60M_INDEX___2 = 12,
	IWL_RATE_MCS_7_INDEX = 12,
	IWL_LAST_HT_RATE = 12,
	IWL_RATE_MCS_8_INDEX = 13,
	IWL_RATE_MCS_9_INDEX = 14,
	IWL_LAST_VHT_RATE = 14,
	IWL_RATE_MCS_10_INDEX = 15,
	IWL_RATE_MCS_11_INDEX = 16,
	IWL_LAST_HE_RATE = 16,
	IWL_RATE_COUNT_LEGACY___2 = 12,
	IWL_RATE_COUNT___2 = 17,
	IWL_RATE_INVM_INDEX___2 = 17,
	IWL_RATE_INVALID___2 = 17,
};

enum {
	IWL_RATE_6M_PLCP = 13,
	IWL_RATE_9M_PLCP = 15,
	IWL_RATE_12M_PLCP = 5,
	IWL_RATE_18M_PLCP = 7,
	IWL_RATE_24M_PLCP = 9,
	IWL_RATE_36M_PLCP = 11,
	IWL_RATE_48M_PLCP = 1,
	IWL_RATE_54M_PLCP = 3,
	IWL_RATE_1M_PLCP = 10,
	IWL_RATE_2M_PLCP = 20,
	IWL_RATE_5M_PLCP = 55,
	IWL_RATE_11M_PLCP = 110,
	IWL_RATE_INVM_PLCP = -1,
};

enum {
	IWL_RATE_6M_PLCP___2 = 13,
	IWL_RATE_9M_PLCP___2 = 15,
	IWL_RATE_12M_PLCP___2 = 5,
	IWL_RATE_18M_PLCP___2 = 7,
	IWL_RATE_24M_PLCP___2 = 9,
	IWL_RATE_36M_PLCP___2 = 11,
	IWL_RATE_48M_PLCP___2 = 1,
	IWL_RATE_54M_PLCP___2 = 3,
	IWL_RATE_60M_PLCP = 3,
	IWL_RATE_1M_PLCP___2 = 10,
	IWL_RATE_2M_PLCP___2 = 20,
	IWL_RATE_5M_PLCP___2 = 55,
	IWL_RATE_11M_PLCP___2 = 110,
};

enum {
	IWL_RATE_SISO_6M_PLCP = 0,
	IWL_RATE_SISO_12M_PLCP = 1,
	IWL_RATE_SISO_18M_PLCP = 2,
	IWL_RATE_SISO_24M_PLCP = 3,
	IWL_RATE_SISO_36M_PLCP = 4,
	IWL_RATE_SISO_48M_PLCP = 5,
	IWL_RATE_SISO_54M_PLCP = 6,
	IWL_RATE_SISO_60M_PLCP = 7,
	IWL_RATE_MIMO2_6M_PLCP = 8,
	IWL_RATE_MIMO2_12M_PLCP = 9,
	IWL_RATE_MIMO2_18M_PLCP = 10,
	IWL_RATE_MIMO2_24M_PLCP = 11,
	IWL_RATE_MIMO2_36M_PLCP = 12,
	IWL_RATE_MIMO2_48M_PLCP = 13,
	IWL_RATE_MIMO2_54M_PLCP = 14,
	IWL_RATE_MIMO2_60M_PLCP = 15,
	IWL_RATE_MIMO3_6M_PLCP = 16,
	IWL_RATE_MIMO3_12M_PLCP = 17,
	IWL_RATE_MIMO3_18M_PLCP = 18,
	IWL_RATE_MIMO3_24M_PLCP = 19,
	IWL_RATE_MIMO3_36M_PLCP = 20,
	IWL_RATE_MIMO3_48M_PLCP = 21,
	IWL_RATE_MIMO3_54M_PLCP = 22,
	IWL_RATE_MIMO3_60M_PLCP = 23,
	IWL_RATE_SISO_INVM_PLCP = 24,
	IWL_RATE_MIMO2_INVM_PLCP = 24,
	IWL_RATE_MIMO3_INVM_PLCP = 24,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	K2_FLAG_SATA_8_PORTS = 16777216,
	K2_FLAG_NO_ATAPI_DMA = 33554432,
	K2_FLAG_BAR_POS_3 = 67108864,
	K2_SATA_TF_CMD_OFFSET = 0,
	K2_SATA_TF_DATA_OFFSET = 0,
	K2_SATA_TF_ERROR_OFFSET = 4,
	K2_SATA_TF_NSECT_OFFSET = 8,
	K2_SATA_TF_LBAL_OFFSET = 12,
	K2_SATA_TF_LBAM_OFFSET = 16,
	K2_SATA_TF_LBAH_OFFSET = 20,
	K2_SATA_TF_DEVICE_OFFSET = 24,
	K2_SATA_TF_CMDSTAT_OFFSET = 28,
	K2_SATA_TF_CTL_OFFSET = 32,
	K2_SATA_DMA_CMD_OFFSET = 48,
	K2_SATA_SCR_STATUS_OFFSET = 64,
	K2_SATA_SCR_ERROR_OFFSET = 68,
	K2_SATA_SCR_CONTROL_OFFSET = 72,
	K2_SATA_SICR1_OFFSET = 128,
	K2_SATA_SICR2_OFFSET = 132,
	K2_SATA_SIM_OFFSET = 136,
	K2_SATA_PORT_OFFSET = 256,
	chip_svw4 = 0,
	chip_svw8 = 1,
	chip_svw42 = 2,
	chip_svw43 = 3,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LBR_FORMAT_32 = 0,
	LBR_FORMAT_LIP = 1,
	LBR_FORMAT_EIP = 2,
	LBR_FORMAT_EIP_FLAGS = 3,
	LBR_FORMAT_EIP_FLAGS2 = 4,
	LBR_FORMAT_INFO = 5,
	LBR_FORMAT_TIME = 6,
	LBR_FORMAT_INFO2 = 7,
	LBR_FORMAT_MAX_KNOWN = 7,
};

enum {
	LBR_NONE = 0,
	LBR_VALID = 1,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_ID_DEV_LOG = 134217728,
	ATA_QUIRK_NO_LOG_DIR = 268435456,
	ATA_QUIRK_NO_FUA = 536870912,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINK_XSTATS_TYPE_UNSPEC = 0,
	LINK_XSTATS_TYPE_BRIDGE = 1,
	LINK_XSTATS_TYPE_BOND = 2,
	__LINK_XSTATS_TYPE_MAX = 3,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_PAWS_OLD_ACK = 16,
	LINUX_MIB_DELAYEDACKS = 17,
	LINUX_MIB_DELAYEDACKLOCKED = 18,
	LINUX_MIB_DELAYEDACKLOST = 19,
	LINUX_MIB_LISTENOVERFLOWS = 20,
	LINUX_MIB_LISTENDROPS = 21,
	LINUX_MIB_TCPHPHITS = 22,
	LINUX_MIB_TCPPUREACKS = 23,
	LINUX_MIB_TCPHPACKS = 24,
	LINUX_MIB_TCPRENORECOVERY = 25,
	LINUX_MIB_TCPSACKRECOVERY = 26,
	LINUX_MIB_TCPSACKRENEGING = 27,
	LINUX_MIB_TCPSACKREORDER = 28,
	LINUX_MIB_TCPRENOREORDER = 29,
	LINUX_MIB_TCPTSREORDER = 30,
	LINUX_MIB_TCPFULLUNDO = 31,
	LINUX_MIB_TCPPARTIALUNDO = 32,
	LINUX_MIB_TCPDSACKUNDO = 33,
	LINUX_MIB_TCPLOSSUNDO = 34,
	LINUX_MIB_TCPLOSTRETRANSMIT = 35,
	LINUX_MIB_TCPRENOFAILURES = 36,
	LINUX_MIB_TCPSACKFAILURES = 37,
	LINUX_MIB_TCPLOSSFAILURES = 38,
	LINUX_MIB_TCPFASTRETRANS = 39,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 40,
	LINUX_MIB_TCPTIMEOUTS = 41,
	LINUX_MIB_TCPLOSSPROBES = 42,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 43,
	LINUX_MIB_TCPRENORECOVERYFAIL = 44,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 45,
	LINUX_MIB_TCPRCVCOLLAPSED = 46,
	LINUX_MIB_TCPDSACKOLDSENT = 47,
	LINUX_MIB_TCPDSACKOFOSENT = 48,
	LINUX_MIB_TCPDSACKRECV = 49,
	LINUX_MIB_TCPDSACKOFORECV = 50,
	LINUX_MIB_TCPABORTONDATA = 51,
	LINUX_MIB_TCPABORTONCLOSE = 52,
	LINUX_MIB_TCPABORTONMEMORY = 53,
	LINUX_MIB_TCPABORTONTIMEOUT = 54,
	LINUX_MIB_TCPABORTONLINGER = 55,
	LINUX_MIB_TCPABORTFAILED = 56,
	LINUX_MIB_TCPMEMORYPRESSURES = 57,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 58,
	LINUX_MIB_TCPSACKDISCARD = 59,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 60,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 61,
	LINUX_MIB_TCPSPURIOUSRTOS = 62,
	LINUX_MIB_TCPMD5NOTFOUND = 63,
	LINUX_MIB_TCPMD5UNEXPECTED = 64,
	LINUX_MIB_TCPMD5FAILURE = 65,
	LINUX_MIB_SACKSHIFTED = 66,
	LINUX_MIB_SACKMERGED = 67,
	LINUX_MIB_SACKSHIFTFALLBACK = 68,
	LINUX_MIB_TCPBACKLOGDROP = 69,
	LINUX_MIB_PFMEMALLOCDROP = 70,
	LINUX_MIB_TCPMINTTLDROP = 71,
	LINUX_MIB_TCPDEFERACCEPTDROP = 72,
	LINUX_MIB_IPRPFILTER = 73,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 74,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 75,
	LINUX_MIB_TCPREQQFULLDROP = 76,
	LINUX_MIB_TCPRETRANSFAIL = 77,
	LINUX_MIB_TCPRCVCOALESCE = 78,
	LINUX_MIB_TCPBACKLOGCOALESCE = 79,
	LINUX_MIB_TCPOFOQUEUE = 80,
	LINUX_MIB_TCPOFODROP = 81,
	LINUX_MIB_TCPOFOMERGE = 82,
	LINUX_MIB_TCPCHALLENGEACK = 83,
	LINUX_MIB_TCPSYNCHALLENGE = 84,
	LINUX_MIB_TCPFASTOPENACTIVE = 85,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 86,
	LINUX_MIB_TCPFASTOPENPASSIVE = 87,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 89,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 90,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 91,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 92,
	LINUX_MIB_BUSYPOLLRXPACKETS = 93,
	LINUX_MIB_TCPAUTOCORKING = 94,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 95,
	LINUX_MIB_TCPTOZEROWINDOWADV = 96,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 97,
	LINUX_MIB_TCPSYNRETRANS = 98,
	LINUX_MIB_TCPORIGDATASENT = 99,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 100,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 101,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 102,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 103,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 104,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 105,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 106,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 107,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 108,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 109,
	LINUX_MIB_TCPWINPROBE = 110,
	LINUX_MIB_TCPKEEPALIVE = 111,
	LINUX_MIB_TCPMTUPFAIL = 112,
	LINUX_MIB_TCPMTUPSUCCESS = 113,
	LINUX_MIB_TCPDELIVERED = 114,
	LINUX_MIB_TCPDELIVEREDCE = 115,
	LINUX_MIB_TCPACKCOMPRESSED = 116,
	LINUX_MIB_TCPZEROWINDOWDROP = 117,
	LINUX_MIB_TCPRCVQDROP = 118,
	LINUX_MIB_TCPWQUEUETOOBIG = 119,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 120,
	LINUX_MIB_TCPTIMEOUTREHASH = 121,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 122,
	LINUX_MIB_TCPDSACKRECVSEGS = 123,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 124,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 125,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 126,
	LINUX_MIB_TCPPLBREHASH = 127,
	LINUX_MIB_TCPAOREQUIRED = 128,
	LINUX_MIB_TCPAOBAD = 129,
	LINUX_MIB_TCPAOKEYNOTFOUND = 130,
	LINUX_MIB_TCPAOGOOD = 131,
	LINUX_MIB_TCPAODROPPEDICMPS = 132,
	__LINUX_MIB_MAX = 133,
};

enum {
	LMPM_CHICK_EXTENDED_ADDR_SPACE = 1,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LOG_INODE_ALL = 0,
	LOG_INODE_EXISTS = 1,
};

enum {
	LOG_WALK_PIN_ONLY = 0,
	LOG_WALK_REPLAY_INODES = 1,
	LOG_WALK_REPLAY_DIR_INDEX = 2,
	LOG_WALK_REPLAY_ALL = 3,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_MDB_EATTR_UNSPEC = 0,
	MDBA_MDB_EATTR_TIMER = 1,
	MDBA_MDB_EATTR_SRC_LIST = 2,
	MDBA_MDB_EATTR_GROUP_MODE = 3,
	MDBA_MDB_EATTR_SOURCE = 4,
	MDBA_MDB_EATTR_RTPROT = 5,
	MDBA_MDB_EATTR_DST = 6,
	MDBA_MDB_EATTR_DST_PORT = 7,
	MDBA_MDB_EATTR_VNI = 8,
	MDBA_MDB_EATTR_IFINDEX = 9,
	MDBA_MDB_EATTR_SRC_VNI = 10,
	__MDBA_MDB_EATTR_MAX = 11,
};

enum {
	MDBA_MDB_ENTRY_UNSPEC = 0,
	MDBA_MDB_ENTRY_INFO = 1,
	__MDBA_MDB_ENTRY_MAX = 2,
};

enum {
	MDBA_MDB_SRCATTR_UNSPEC = 0,
	MDBA_MDB_SRCATTR_ADDRESS = 1,
	MDBA_MDB_SRCATTR_TIMER = 2,
	__MDBA_MDB_SRCATTR_MAX = 3,
};

enum {
	MDBA_MDB_SRCLIST_UNSPEC = 0,
	MDBA_MDB_SRCLIST_ENTRY = 1,
	__MDBA_MDB_SRCLIST_MAX = 2,
};

enum {
	MDBA_MDB_UNSPEC = 0,
	MDBA_MDB_ENTRY = 1,
	__MDBA_MDB_MAX = 2,
};

enum {
	MDBA_ROUTER_PATTR_UNSPEC = 0,
	MDBA_ROUTER_PATTR_TIMER = 1,
	MDBA_ROUTER_PATTR_TYPE = 2,
	MDBA_ROUTER_PATTR_INET_TIMER = 3,
	MDBA_ROUTER_PATTR_INET6_TIMER = 4,
	MDBA_ROUTER_PATTR_VID = 5,
	__MDBA_ROUTER_PATTR_MAX = 6,
};

enum {
	MDBA_ROUTER_UNSPEC = 0,
	MDBA_ROUTER_PORT = 1,
	__MDBA_ROUTER_MAX = 2,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MDBA_UNSPEC = 0,
	MDBA_MDB = 1,
	MDBA_ROUTER = 2,
	__MDBA_MAX = 3,
};

enum {
	MDBE_ATTR_UNSPEC = 0,
	MDBE_ATTR_SOURCE = 1,
	MDBE_ATTR_SRC_LIST = 2,
	MDBE_ATTR_GROUP_MODE = 3,
	MDBE_ATTR_RTPROT = 4,
	MDBE_ATTR_DST = 5,
	MDBE_ATTR_DST_PORT = 6,
	MDBE_ATTR_VNI = 7,
	MDBE_ATTR_IFINDEX = 8,
	MDBE_ATTR_SRC_VNI = 9,
	MDBE_ATTR_STATE_MASK = 10,
	__MDBE_ATTR_MAX = 11,
};

enum {
	MDBE_SRCATTR_UNSPEC = 0,
	MDBE_SRCATTR_ADDRESS = 1,
	__MDBE_SRCATTR_MAX = 2,
};

enum {
	MDB_RTR_TYPE_DISABLED = 0,
	MDB_RTR_TYPE_TEMP_QUERY = 1,
	MDB_RTR_TYPE_PERM = 2,
	MDB_RTR_TYPE_TEMP = 3,
};

enum {
	MD_RESYNC_NONE = 0,
	MD_RESYNC_YIELDED = 1,
	MD_RESYNC_DELAYED = 2,
	MD_RESYNC_ACTIVE = 3,
};

enum {
	MEASUREMENT_READY = 1,
	MEASUREMENT_ACTIVE = 2,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_NULL = 1,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MEMTYPE_EXACT_MATCH = 0,
	MEMTYPE_END_MATCH = 1,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
};

enum {
	MTTG_TRAV_INIT = 0,
	MTTG_TRAV_NFP_UNSPEC = 1,
	MTTG_TRAV_NFP_SPEC = 2,
	MTTG_TRAV_DONE = 3,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	__NETDEV_A_PAGE_POOL_MAX = 8,
	NETDEV_A_PAGE_POOL_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	__NETDEV_A_QUEUE_MAX = 6,
	NETDEV_A_QUEUE_MAX = 5,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	__NETDEV_CMD_MAX = 15,
	NETDEV_CMD_MAX = 14,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETDEV_STATS = 0,
	E1000_STATS = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	__UNUSED_NETIF_F_37 = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFACCT_NO_QUOTA = -1,
	NFACCT_UNDERQUOTA = 0,
	NFACCT_OVERQUOTA = 1,
};

enum {
	NFEA_UNSPEC = 0,
	NFEA_ACTIVITY_NOTIFY = 1,
	NFEA_DONT_REFRESH = 2,
	__NFEA_MAX = 3,
};

enum {
	NFNL_BATCH_FAILURE = 1,
	NFNL_BATCH_DONE = 2,
	NFNL_BATCH_REPLAY = 4,
};

enum {
	NFNL_MSG_COMPAT_GET = 0,
	NFNL_MSG_COMPAT_MAX = 1,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFTA_COMPAT_UNSPEC = 0,
	NFTA_COMPAT_NAME = 1,
	NFTA_COMPAT_REV = 2,
	NFTA_COMPAT_TYPE = 3,
	__NFTA_COMPAT_MAX = 4,
};

enum {
	NFT_INNER_EXPR_PAYLOAD = 0,
	NFT_INNER_EXPR_META = 1,
};

enum {
	NFT_PAYLOAD_CTX_INNER_TUN = 1,
	NFT_PAYLOAD_CTX_INNER_LL = 2,
	NFT_PAYLOAD_CTX_INNER_NH = 4,
	NFT_PAYLOAD_CTX_INNER_TH = 8,
};

enum {
	NFT_PKTINFO_L4PROTO = 1,
	NFT_PKTINFO_INNER = 2,
	NFT_PKTINFO_INNER_FULL = 4,
};

enum {
	NFT_VALIDATE_SKIP = 0,
	NFT_VALIDATE_NEED = 1,
	NFT_VALIDATE_DO = 2,
};

enum {
	NF_BPF_CT_OPTS_SZ = 16,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NMI_LOCAL = 0,
	NMI_UNKNOWN = 1,
	NMI_SERR = 2,
	NMI_IO_CHECK = 3,
	NMI_MAX = 4,
};

enum {
	NONE___2 = 0,
	ADD = 1,
	REMOVE = 2,
	HT_RATE_INIT = 3,
	ADD_RATE_INIT = 4,
};

enum {
	NONE_FORCE_HPET_RESUME = 0,
	OLD_ICH_FORCE_HPET_RESUME = 1,
	ICH_FORCE_HPET_RESUME = 2,
	VT8237_FORCE_HPET_RESUME = 3,
	NVIDIA_FORCE_HPET_RESUME = 4,
	ATI_FORCE_HPET_RESUME = 5,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 66,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_CFG_NS_ATTR = 256,
	NVME_AEN_CFG_FW_ACT = 512,
	NVME_AEN_CFG_ANA_CHANGE = 2048,
	NVME_AEN_CFG_DISC_CHANGE = -2147483648,
};

enum {
	NVME_AER_ERROR = 0,
	NVME_AER_SMART = 1,
	NVME_AER_NOTICE = 2,
	NVME_AER_CSS = 6,
	NVME_AER_VS = 7,
};

enum {
	NVME_AER_ERROR_PERSIST_INT_ERR = 3,
};

enum {
	NVME_AER_NOTICE_NS_CHANGED = 0,
	NVME_AER_NOTICE_FW_ACT_STARTING = 1,
	NVME_AER_NOTICE_ANA = 3,
	NVME_AER_NOTICE_DISC_CHANGED = 240,
};

enum {
	NVME_CAP_CRMS_CRWMS = 576460752303423488ULL,
	NVME_CAP_CRMS_CRIMS = 1152921504606846976ULL,
};

enum {
	NVME_CAP_CSS_NVM = 1,
	NVME_CAP_CSS_CSI = 64,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CMBMSC_CRE = 1,
	NVME_CMBMSC_CMSE = 2,
};

enum {
	NVME_CMBSZ_SQS = 1,
	NVME_CMBSZ_CQS = 2,
	NVME_CMBSZ_LISTS = 4,
	NVME_CMBSZ_RDS = 8,
	NVME_CMBSZ_WDS = 16,
	NVME_CMBSZ_SZ_SHIFT = 12,
	NVME_CMBSZ_SZ_MASK = 1048575,
	NVME_CMBSZ_SZU_SHIFT = 8,
	NVME_CMBSZ_SZU_MASK = 15,
};

enum {
	NVME_CMD_EFFECTS_CSUPP = 1,
	NVME_CMD_EFFECTS_LBCC = 2,
	NVME_CMD_EFFECTS_NCC = 4,
	NVME_CMD_EFFECTS_NIC = 8,
	NVME_CMD_EFFECTS_CCC = 16,
	NVME_CMD_EFFECTS_CSER_MASK = 49152,
	NVME_CMD_EFFECTS_CSE_MASK = 458752,
	NVME_CMD_EFFECTS_UUID_SEL = 524288,
	NVME_CMD_EFFECTS_SCOPE_MASK = 4293918720,
};

enum {
	NVME_CMD_FUSE_FIRST = 1,
	NVME_CMD_FUSE_SECOND = 2,
	NVME_CMD_SGL_METABUF = 64,
	NVME_CMD_SGL_METASEG = 128,
	NVME_CMD_SGL_ALL = 192,
};

enum {
	NVME_CSI_NVM = 0,
	NVME_CSI_ZNS = 2,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_CTRL_CMIC_MULTI_PORT = 1,
	NVME_CTRL_CMIC_MULTI_CTRL = 2,
	NVME_CTRL_CMIC_ANA = 8,
	NVME_CTRL_ONCS_COMPARE = 1,
	NVME_CTRL_ONCS_WRITE_UNCORRECTABLE = 2,
	NVME_CTRL_ONCS_DSM = 4,
	NVME_CTRL_ONCS_WRITE_ZEROES = 8,
	NVME_CTRL_ONCS_RESERVATIONS = 32,
	NVME_CTRL_ONCS_TIMESTAMP = 64,
	NVME_CTRL_VWC_PRESENT = 1,
	NVME_CTRL_OACS_SEC_SUPP = 1,
	NVME_CTRL_OACS_NS_MNGT_SUPP = 8,
	NVME_CTRL_OACS_DIRECTIVES = 32,
	NVME_CTRL_OACS_DBBUF_SUPP = 256,
	NVME_CTRL_LPA_CMD_EFFECTS_LOG = 2,
	NVME_CTRL_CTRATT_128_ID = 1,
	NVME_CTRL_CTRATT_NON_OP_PSP = 2,
	NVME_CTRL_CTRATT_NVM_SETS = 4,
	NVME_CTRL_CTRATT_READ_RECV_LVLS = 8,
	NVME_CTRL_CTRATT_ENDURANCE_GROUPS = 16,
	NVME_CTRL_CTRATT_PREDICTABLE_LAT = 32,
	NVME_CTRL_CTRATT_NAMESPACE_GRANULARITY = 128,
	NVME_CTRL_CTRATT_UUID_LIST = 512,
	NVME_CTRL_SGLS_BYTE_ALIGNED = 1,
	NVME_CTRL_SGLS_DWORD_ALIGNED = 2,
	NVME_CTRL_SGLS_KSDBDS = 4,
	NVME_CTRL_SGLS_MSDS = 524288,
	NVME_CTRL_SGLS_SAOS = 1048576,
};

enum {
	NVME_DSMGMT_IDR = 1,
	NVME_DSMGMT_IDW = 2,
	NVME_DSMGMT_AD = 4,
};

enum {
	NVME_ENABLE_ACRE = 1,
	NVME_ENABLE_LBAFEE = 1,
};

enum {
	NVME_HOST_MEM_ENABLE = 1,
	NVME_HOST_MEM_RETURN = 2,
};

enum {
	NVME_ID_CNS_NS = 0,
	NVME_ID_CNS_CTRL = 1,
	NVME_ID_CNS_NS_ACTIVE_LIST = 2,
	NVME_ID_CNS_NS_DESC_LIST = 3,
	NVME_ID_CNS_CS_NS = 5,
	NVME_ID_CNS_CS_CTRL = 6,
	NVME_ID_CNS_NS_ACTIVE_LIST_CS = 7,
	NVME_ID_CNS_NS_CS_INDEP = 8,
	NVME_ID_CNS_NS_PRESENT_LIST = 16,
	NVME_ID_CNS_NS_PRESENT = 17,
	NVME_ID_CNS_CTRL_NS_LIST = 18,
	NVME_ID_CNS_CTRL_LIST = 19,
	NVME_ID_CNS_SCNDRY_CTRL_LIST = 21,
	NVME_ID_CNS_NS_GRANULARITY = 22,
	NVME_ID_CNS_UUID_LIST = 23,
	NVME_ID_CNS_ENDGRP_LIST = 25,
};

enum {
	NVME_ID_NS_NVM_STS_MASK = 127,
	NVME_ID_NS_NVM_GUARD_SHIFT = 7,
	NVME_ID_NS_NVM_GUARD_MASK = 3,
	NVME_ID_NS_NVM_QPIF_SHIFT = 9,
	NVME_ID_NS_NVM_QPIF_MASK = 15,
	NVME_ID_NS_NVM_QPIFS = 8,
};

enum {
	NVME_IOCTL_VEC = 1,
	NVME_IOCTL_PARTITION = 2,
};

enum {
	NVME_NIDT_EUI64 = 1,
	NVME_NIDT_NGUID = 2,
	NVME_NIDT_UUID = 3,
	NVME_NIDT_CSI = 4,
};

enum {
	NVME_NSTAT_NRDY = 1,
};

enum {
	NVME_NS_FEAT_THIN = 1,
	NVME_NS_FEAT_ATOMICS = 2,
	NVME_NS_FEAT_IO_OPT = 16,
	NVME_NS_ATTR_RO = 1,
	NVME_NS_FLBAS_LBA_MASK = 15,
	NVME_NS_FLBAS_LBA_UMASK = 96,
	NVME_NS_FLBAS_LBA_SHIFT = 1,
	NVME_NS_FLBAS_META_EXT = 16,
	NVME_NS_NMIC_SHARED = 1,
	NVME_NS_ROTATIONAL = 16,
	NVME_NS_VWC_NOT_PRESENT = 32,
	NVME_LBAF_RP_BEST = 0,
	NVME_LBAF_RP_BETTER = 1,
	NVME_LBAF_RP_GOOD = 2,
	NVME_LBAF_RP_DEGRADED = 3,
	NVME_NS_DPC_PI_LAST = 16,
	NVME_NS_DPC_PI_FIRST = 8,
	NVME_NS_DPC_PI_TYPE3 = 4,
	NVME_NS_DPC_PI_TYPE2 = 2,
	NVME_NS_DPC_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_FIRST = 8,
	NVME_NS_DPS_PI_MASK = 7,
	NVME_NS_DPS_PI_TYPE1 = 1,
	NVME_NS_DPS_PI_TYPE2 = 2,
	NVME_NS_DPS_PI_TYPE3 = 3,
};

enum {
	NVME_NVM_NS_16B_GUARD = 0,
	NVME_NVM_NS_32B_GUARD = 1,
	NVME_NVM_NS_64B_GUARD = 2,
	NVME_NVM_NS_QTYPE_GUARD = 3,
};

enum {
	NVME_PS_FLAGS_MAX_POWER_SCALE = 1,
	NVME_PS_FLAGS_NON_OP_STATE = 2,
};

enum {
	NVME_QUEUE_PHYS_CONTIG = 1,
	NVME_CQ_IRQ_ENABLED = 2,
	NVME_SQ_PRIO_URGENT = 0,
	NVME_SQ_PRIO_HIGH = 2,
	NVME_SQ_PRIO_MEDIUM = 4,
	NVME_SQ_PRIO_LOW = 6,
	NVME_FEAT_ARBITRATION = 1,
	NVME_FEAT_POWER_MGMT = 2,
	NVME_FEAT_LBA_RANGE = 3,
	NVME_FEAT_TEMP_THRESH = 4,
	NVME_FEAT_ERR_RECOVERY = 5,
	NVME_FEAT_VOLATILE_WC = 6,
	NVME_FEAT_NUM_QUEUES = 7,
	NVME_FEAT_IRQ_COALESCE = 8,
	NVME_FEAT_IRQ_CONFIG = 9,
	NVME_FEAT_WRITE_ATOMIC = 10,
	NVME_FEAT_ASYNC_EVENT = 11,
	NVME_FEAT_AUTO_PST = 12,
	NVME_FEAT_HOST_MEM_BUF = 13,
	NVME_FEAT_TIMESTAMP = 14,
	NVME_FEAT_KATO = 15,
	NVME_FEAT_HCTM = 16,
	NVME_FEAT_NOPSC = 17,
	NVME_FEAT_RRL = 18,
	NVME_FEAT_PLM_CONFIG = 19,
	NVME_FEAT_PLM_WINDOW = 20,
	NVME_FEAT_HOST_BEHAVIOR = 22,
	NVME_FEAT_SANITIZE = 23,
	NVME_FEAT_SW_PROGRESS = 128,
	NVME_FEAT_HOST_ID = 129,
	NVME_FEAT_RESV_MASK = 130,
	NVME_FEAT_RESV_PERSIST = 131,
	NVME_FEAT_WRITE_PROTECT = 132,
	NVME_FEAT_VENDOR_START = 192,
	NVME_FEAT_VENDOR_END = 255,
	NVME_LOG_SUPPORTED = 0,
	NVME_LOG_ERROR = 1,
	NVME_LOG_SMART = 2,
	NVME_LOG_FW_SLOT = 3,
	NVME_LOG_CHANGED_NS = 4,
	NVME_LOG_CMD_EFFECTS = 5,
	NVME_LOG_DEVICE_SELF_TEST = 6,
	NVME_LOG_TELEMETRY_HOST = 7,
	NVME_LOG_TELEMETRY_CTRL = 8,
	NVME_LOG_ENDURANCE_GROUP = 9,
	NVME_LOG_ANA = 12,
	NVME_LOG_FEATURES = 18,
	NVME_LOG_RMI = 22,
	NVME_LOG_DISC = 112,
	NVME_LOG_RESERVATION = 128,
	NVME_FWACT_REPL = 0,
	NVME_FWACT_REPL_ACTV = 8,
	NVME_FWACT_ACTV = 16,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	NVME_REQ_CANCELLED = 1,
	NVME_REQ_USERCMD = 2,
	NVME_MPATH_IO_STATS = 4,
	NVME_MPATH_CNT_ACTIVE = 8,
};

enum {
	NVME_RW_LR = 32768,
	NVME_RW_FUA = 16384,
	NVME_RW_APPEND_PIREMAP = 512,
	NVME_RW_DSM_FREQ_UNSPEC = 0,
	NVME_RW_DSM_FREQ_TYPICAL = 1,
	NVME_RW_DSM_FREQ_RARE = 2,
	NVME_RW_DSM_FREQ_READS = 3,
	NVME_RW_DSM_FREQ_WRITES = 4,
	NVME_RW_DSM_FREQ_RW = 5,
	NVME_RW_DSM_FREQ_ONCE = 6,
	NVME_RW_DSM_FREQ_PREFETCH = 7,
	NVME_RW_DSM_FREQ_TEMP = 8,
	NVME_RW_DSM_LATENCY_NONE = 0,
	NVME_RW_DSM_LATENCY_IDLE = 16,
	NVME_RW_DSM_LATENCY_NORM = 32,
	NVME_RW_DSM_LATENCY_LOW = 48,
	NVME_RW_DSM_SEQ_REQ = 64,
	NVME_RW_DSM_COMPRESSED = 128,
	NVME_RW_PRINFO_PRCHK_REF = 1024,
	NVME_RW_PRINFO_PRCHK_APP = 2048,
	NVME_RW_PRINFO_PRCHK_GUARD = 4096,
	NVME_RW_PRINFO_PRACT = 8192,
	NVME_RW_DTYPE_STREAMS = 16,
	NVME_WZ_DEAC = 512,
};

enum {
	NVME_SCT_GENERIC = 0,
	NVME_SC_SUCCESS = 0,
	NVME_SC_INVALID_OPCODE = 1,
	NVME_SC_INVALID_FIELD = 2,
	NVME_SC_CMDID_CONFLICT = 3,
	NVME_SC_DATA_XFER_ERROR = 4,
	NVME_SC_POWER_LOSS = 5,
	NVME_SC_INTERNAL = 6,
	NVME_SC_ABORT_REQ = 7,
	NVME_SC_ABORT_QUEUE = 8,
	NVME_SC_FUSED_FAIL = 9,
	NVME_SC_FUSED_MISSING = 10,
	NVME_SC_INVALID_NS = 11,
	NVME_SC_CMD_SEQ_ERROR = 12,
	NVME_SC_SGL_INVALID_LAST = 13,
	NVME_SC_SGL_INVALID_COUNT = 14,
	NVME_SC_SGL_INVALID_DATA = 15,
	NVME_SC_SGL_INVALID_METADATA = 16,
	NVME_SC_SGL_INVALID_TYPE = 17,
	NVME_SC_CMB_INVALID_USE = 18,
	NVME_SC_PRP_INVALID_OFFSET = 19,
	NVME_SC_ATOMIC_WU_EXCEEDED = 20,
	NVME_SC_OP_DENIED = 21,
	NVME_SC_SGL_INVALID_OFFSET = 22,
	NVME_SC_RESERVED = 23,
	NVME_SC_HOST_ID_INCONSIST = 24,
	NVME_SC_KA_TIMEOUT_EXPIRED = 25,
	NVME_SC_KA_TIMEOUT_INVALID = 26,
	NVME_SC_ABORTED_PREEMPT_ABORT = 27,
	NVME_SC_SANITIZE_FAILED = 28,
	NVME_SC_SANITIZE_IN_PROGRESS = 29,
	NVME_SC_SGL_INVALID_GRANULARITY = 30,
	NVME_SC_CMD_NOT_SUP_CMB_QUEUE = 31,
	NVME_SC_NS_WRITE_PROTECTED = 32,
	NVME_SC_CMD_INTERRUPTED = 33,
	NVME_SC_TRANSIENT_TR_ERR = 34,
	NVME_SC_ADMIN_COMMAND_MEDIA_NOT_READY = 36,
	NVME_SC_INVALID_IO_CMD_SET = 44,
	NVME_SC_LBA_RANGE = 128,
	NVME_SC_CAP_EXCEEDED = 129,
	NVME_SC_NS_NOT_READY = 130,
	NVME_SC_RESERVATION_CONFLICT = 131,
	NVME_SC_FORMAT_IN_PROGRESS = 132,
	NVME_SCT_COMMAND_SPECIFIC = 256,
	NVME_SC_CQ_INVALID = 256,
	NVME_SC_QID_INVALID = 257,
	NVME_SC_QUEUE_SIZE = 258,
	NVME_SC_ABORT_LIMIT = 259,
	NVME_SC_ABORT_MISSING = 260,
	NVME_SC_ASYNC_LIMIT = 261,
	NVME_SC_FIRMWARE_SLOT = 262,
	NVME_SC_FIRMWARE_IMAGE = 263,
	NVME_SC_INVALID_VECTOR = 264,
	NVME_SC_INVALID_LOG_PAGE = 265,
	NVME_SC_INVALID_FORMAT = 266,
	NVME_SC_FW_NEEDS_CONV_RESET = 267,
	NVME_SC_INVALID_QUEUE = 268,
	NVME_SC_FEATURE_NOT_SAVEABLE = 269,
	NVME_SC_FEATURE_NOT_CHANGEABLE = 270,
	NVME_SC_FEATURE_NOT_PER_NS = 271,
	NVME_SC_FW_NEEDS_SUBSYS_RESET = 272,
	NVME_SC_FW_NEEDS_RESET = 273,
	NVME_SC_FW_NEEDS_MAX_TIME = 274,
	NVME_SC_FW_ACTIVATE_PROHIBITED = 275,
	NVME_SC_OVERLAPPING_RANGE = 276,
	NVME_SC_NS_INSUFFICIENT_CAP = 277,
	NVME_SC_NS_ID_UNAVAILABLE = 278,
	NVME_SC_NS_ALREADY_ATTACHED = 280,
	NVME_SC_NS_IS_PRIVATE = 281,
	NVME_SC_NS_NOT_ATTACHED = 282,
	NVME_SC_THIN_PROV_NOT_SUPP = 283,
	NVME_SC_CTRL_LIST_INVALID = 284,
	NVME_SC_SELT_TEST_IN_PROGRESS = 285,
	NVME_SC_BP_WRITE_PROHIBITED = 286,
	NVME_SC_CTRL_ID_INVALID = 287,
	NVME_SC_SEC_CTRL_STATE_INVALID = 288,
	NVME_SC_CTRL_RES_NUM_INVALID = 289,
	NVME_SC_RES_ID_INVALID = 290,
	NVME_SC_PMR_SAN_PROHIBITED = 291,
	NVME_SC_ANA_GROUP_ID_INVALID = 292,
	NVME_SC_ANA_ATTACH_FAILED = 293,
	NVME_SC_BAD_ATTRIBUTES = 384,
	NVME_SC_INVALID_PI = 385,
	NVME_SC_READ_ONLY = 386,
	NVME_SC_ONCS_NOT_SUPPORTED = 387,
	NVME_SC_CONNECT_FORMAT = 384,
	NVME_SC_CONNECT_CTRL_BUSY = 385,
	NVME_SC_CONNECT_INVALID_PARAM = 386,
	NVME_SC_CONNECT_RESTART_DISC = 387,
	NVME_SC_CONNECT_INVALID_HOST = 388,
	NVME_SC_DISCOVERY_RESTART = 400,
	NVME_SC_AUTH_REQUIRED = 401,
	NVME_SC_ZONE_BOUNDARY_ERROR = 440,
	NVME_SC_ZONE_FULL = 441,
	NVME_SC_ZONE_READ_ONLY = 442,
	NVME_SC_ZONE_OFFLINE = 443,
	NVME_SC_ZONE_INVALID_WRITE = 444,
	NVME_SC_ZONE_TOO_MANY_ACTIVE = 445,
	NVME_SC_ZONE_TOO_MANY_OPEN = 446,
	NVME_SC_ZONE_INVALID_TRANSITION = 447,
	NVME_SCT_MEDIA_ERROR = 512,
	NVME_SC_WRITE_FAULT = 640,
	NVME_SC_READ_ERROR = 641,
	NVME_SC_GUARD_CHECK = 642,
	NVME_SC_APPTAG_CHECK = 643,
	NVME_SC_REFTAG_CHECK = 644,
	NVME_SC_COMPARE_FAILED = 645,
	NVME_SC_ACCESS_DENIED = 646,
	NVME_SC_UNWRITTEN_BLOCK = 647,
	NVME_SCT_PATH = 768,
	NVME_SC_INTERNAL_PATH_ERROR = 768,
	NVME_SC_ANA_PERSISTENT_LOSS = 769,
	NVME_SC_ANA_INACCESSIBLE = 770,
	NVME_SC_ANA_TRANSITION = 771,
	NVME_SC_CTRL_PATH_ERROR = 864,
	NVME_SC_HOST_PATH_ERROR = 880,
	NVME_SC_HOST_ABORTED_CMD = 881,
	NVME_SC_MASK = 255,
	NVME_SCT_MASK = 1792,
	NVME_SCT_SC_MASK = 2047,
	NVME_STATUS_CRD = 6144,
	NVME_STATUS_MORE = 8192,
	NVME_STATUS_DNR = 16384,
};

enum {
	NVME_SGL_FMT_DATA_DESC = 0,
	NVME_SGL_FMT_SEG_DESC = 2,
	NVME_SGL_FMT_LAST_SEG_DESC = 3,
	NVME_KEY_SGL_FMT_DATA_DESC = 4,
	NVME_TRANSPORT_SGL_DATA_DESC = 5,
};

enum {
	NVME_SUBMIT_AT_HEAD = 1,
	NVME_SUBMIT_NOWAIT = 2,
	NVME_SUBMIT_RESERVED = 4,
	NVME_SUBMIT_RETRY = 8,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OPT_SOURCE = 0,
	OPT_SUBTYPE = 1,
	OPT_FD = 2,
	OPT_ROOTMODE = 3,
	OPT_USER_ID = 4,
	OPT_GROUP_ID = 5,
	OPT_DEFAULT_PERMISSIONS = 6,
	OPT_ALLOW_OTHER = 7,
	OPT_MAX_READ = 8,
	OPT_BLKSIZE = 9,
	OPT_ERR = 10,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_acl = 0,
	Opt_clear_cache = 1,
	Opt_commit_interval = 2,
	Opt_compress = 3,
	Opt_compress_force = 4,
	Opt_compress_force_type = 5,
	Opt_compress_type = 6,
	Opt_degraded = 7,
	Opt_device = 8,
	Opt_fatal_errors = 9,
	Opt_flushoncommit = 10,
	Opt_max_inline = 11,
	Opt_barrier = 12,
	Opt_datacow = 13,
	Opt_datasum = 14,
	Opt_defrag = 15,
	Opt_discard = 16,
	Opt_discard_mode = 17,
	Opt_ratio = 18,
	Opt_rescan_uuid_tree = 19,
	Opt_skip_balance = 20,
	Opt_space_cache = 21,
	Opt_space_cache_version = 22,
	Opt_ssd = 23,
	Opt_ssd_spread = 24,
	Opt_subvol = 25,
	Opt_subvol_empty = 26,
	Opt_subvolid = 27,
	Opt_thread_pool = 28,
	Opt_treelog = 29,
	Opt_user_subvol_rm_allowed = 30,
	Opt_norecovery = 31,
	Opt_rescue = 32,
	Opt_usebackuproot = 33,
	Opt_nologreplay = 34,
	Opt_enospc_debug = 35,
	Opt_err = 36,
};

enum {
	Opt_block = 0,
	Opt_check = 1,
	Opt_cruft = 2,
	Opt_gid = 3,
	Opt_ignore = 4,
	Opt_iocharset = 5,
	Opt_map = 6,
	Opt_mode = 7,
	Opt_nojoliet = 8,
	Opt_norock = 9,
	Opt_sb = 10,
	Opt_session = 11,
	Opt_uid = 12,
	Opt_unhide = 13,
	Opt_utf8 = 14,
	Opt_err___2 = 15,
	Opt_nocompress = 16,
	Opt_hide = 17,
	Opt_showassoc = 18,
	Opt_dmode = 19,
	Opt_overriderockperm = 20,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb___2 = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl___2 = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier___2 = 34,
	Opt_nobarrier = 35,
	Opt_err___3 = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard___2 = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check___2 = 0,
	Opt_uid___2 = 1,
	Opt_gid___2 = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8___2 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___3 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___3 = 2,
	Opt_ignore___2 = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___3 = 10,
};

enum {
	Opt_discard_sync = 0,
	Opt_discard_async = 1,
};

enum {
	Opt_err___4 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_fatal_errors_panic = 0,
	Opt_fatal_errors_bug = 1,
};

enum {
	Opt_rescue_usebackuproot = 0,
	Opt_rescue_nologreplay = 1,
	Opt_rescue_ignorebadroots = 2,
	Opt_rescue_ignoredatacsums = 3,
	Opt_rescue_ignoremetacsums = 4,
	Opt_rescue_ignoresuperflags = 5,
	Opt_rescue_parameter_all = 6,
};

enum {
	Opt_space_cache_v1 = 0,
	Opt_space_cache_v2 = 1,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___2 = 2,
};

enum {
	Opt_uid___6 = 0,
	Opt_gid___6 = 1,
	Opt_mode___3 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___7 = 0,
	Opt_gid___7 = 1,
	Opt_mode___4 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___5 = 6,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PARITY_DISABLE_RMW = 0,
	PARITY_ENABLE_RMW = 1,
	PARITY_PREFER_RMW = 2,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_BRIDGE_RESOURCES = 7,
	PCI_BRIDGE_RESOURCE_END = 10,
	PCI_NUM_RESOURCES = 11,
	DEVICE_COUNT_RESOURCE = 11,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_BR_SPEC_NA = 0,
	PERF_BR_SPEC_WRONG_PATH = 1,
	PERF_BR_NON_SPEC_CORRECT_PATH = 2,
	PERF_BR_SPEC_CORRECT_PATH = 3,
	PERF_BR_SPEC_MAX = 4,
};

enum {
	PERF_BR_UNKNOWN = 0,
	PERF_BR_COND = 1,
	PERF_BR_UNCOND = 2,
	PERF_BR_IND = 3,
	PERF_BR_CALL = 4,
	PERF_BR_IND_CALL = 5,
	PERF_BR_RET = 6,
	PERF_BR_SYSCALL = 7,
	PERF_BR_SYSRET = 8,
	PERF_BR_COND_CALL = 9,
	PERF_BR_COND_RET = 10,
	PERF_BR_ERET = 11,
	PERF_BR_IRQ = 12,
	PERF_BR_SERROR = 13,
	PERF_BR_NO_TX = 14,
	PERF_BR_EXTEND_ABI = 15,
	PERF_BR_MAX = 16,
};

enum {
	PERF_TXN_ELISION = 1ULL,
	PERF_TXN_TRANSACTION = 2ULL,
	PERF_TXN_SYNC = 4ULL,
	PERF_TXN_ASYNC = 8ULL,
	PERF_TXN_RETRY = 16ULL,
	PERF_TXN_CONFLICT = 32ULL,
	PERF_TXN_CAPACITY_WRITE = 64ULL,
	PERF_TXN_CAPACITY_READ = 128ULL,
	PERF_TXN_MAX = 256ULL,
	PERF_TXN_ABORT_MASK = 18446744069414584320ULL,
	PERF_TXN_ABORT_SHIFT = 32ULL,
};

enum {
	PERF_X86_EVENT_PEBS_LDLAT = 1,
	PERF_X86_EVENT_PEBS_ST = 2,
	PERF_X86_EVENT_PEBS_ST_HSW = 4,
	PERF_X86_EVENT_PEBS_LD_HSW = 8,
	PERF_X86_EVENT_PEBS_NA_HSW = 16,
	PERF_X86_EVENT_EXCL = 32,
	PERF_X86_EVENT_DYNAMIC = 64,
	PERF_X86_EVENT_EXCL_ACCT = 256,
	PERF_X86_EVENT_AUTO_RELOAD = 512,
	PERF_X86_EVENT_LARGE_PEBS = 1024,
	PERF_X86_EVENT_PEBS_VIA_PT = 2048,
	PERF_X86_EVENT_PAIR = 4096,
	PERF_X86_EVENT_LBR_SELECT = 8192,
	PERF_X86_EVENT_TOPDOWN = 16384,
	PERF_X86_EVENT_PEBS_STLAT = 32768,
	PERF_X86_EVENT_AMD_BRS = 65536,
	PERF_X86_EVENT_PEBS_LAT_HYBRID = 131072,
	PERF_X86_EVENT_NEEDS_BRANCH_STACK = 262144,
	PERF_X86_EVENT_BRANCH_COUNTERS = 524288,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PIIX_IOCFG = 84,
	ICH5_PMR = 144,
	ICH5_PCS = 146,
	PIIX_SIDPR_BAR = 5,
	PIIX_SIDPR_LEN = 16,
	PIIX_SIDPR_IDX = 0,
	PIIX_SIDPR_DATA = 4,
	PIIX_FLAG_CHECKINTR = 268435456,
	PIIX_FLAG_SIDPR = 536870912,
	PIIX_PATA_FLAGS = 1,
	PIIX_SATA_FLAGS = 268435458,
	PIIX_FLAG_PIO16 = 1073741824,
	PIIX_80C_PRI = 48,
	PIIX_80C_SEC = 192,
	P0 = 0,
	P1 = 1,
	P2 = 2,
	P3 = 3,
	IDE = -1,
	NA = -2,
	RV = -3,
	PIIX_AHCI_DEVICE = 6,
	PIIX_HOST_BROKEN_SUSPEND = 16777216,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

enum {
	PSS = 0,
	PPC = 1,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_MAX = 13,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RANGE_BOUNDARY_WRITTEN_EXTENT = 0,
	RANGE_BOUNDARY_PREALLOC_EXTENT = 1,
	RANGE_BOUNDARY_HOLE = 2,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	READA_NONE = 0,
	READA_BACK = 1,
	READA_FORWARD = 2,
	READA_FORWARD_ALWAYS = 3,
};

enum {
	READ_NVM_CHUNK_SUCCEED = 0,
	READ_NVM_CHUNK_NOT_VALID_ADDRESS = 1,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REPLY_ALIVE = 1,
	REPLY_ERROR = 2,
	REPLY_ECHO = 3,
	REPLY_RXON = 16,
	REPLY_RXON_ASSOC = 17,
	REPLY_QOS_PARAM = 19,
	REPLY_RXON_TIMING = 20,
	REPLY_ADD_STA = 24,
	REPLY_REMOVE_STA = 25,
	REPLY_REMOVE_ALL_STA = 26,
	REPLY_TXFIFO_FLUSH = 30,
	REPLY_WEPKEY = 32,
	REPLY_TX = 28,
	REPLY_LEDS_CMD = 72,
	REPLY_TX_LINK_QUALITY_CMD = 78,
	COEX_PRIORITY_TABLE_CMD = 90,
	COEX_MEDIUM_NOTIFICATION = 91,
	COEX_EVENT_CMD = 92,
	TEMPERATURE_NOTIFICATION = 98,
	CALIBRATION_CFG_CMD = 101,
	CALIBRATION_RES_NOTIFICATION = 102,
	CALIBRATION_COMPLETE_NOTIFICATION = 103,
	REPLY_QUIET_CMD = 113,
	REPLY_CHANNEL_SWITCH = 114,
	CHANNEL_SWITCH_NOTIFICATION = 115,
	REPLY_SPECTRUM_MEASUREMENT_CMD = 116,
	SPECTRUM_MEASURE_NOTIFICATION = 117,
	POWER_TABLE_CMD = 119,
	PM_SLEEP_NOTIFICATION = 122,
	PM_DEBUG_STATISTIC_NOTIFIC = 123,
	REPLY_SCAN_CMD = 128,
	REPLY_SCAN_ABORT_CMD = 129,
	SCAN_START_NOTIFICATION = 130,
	SCAN_RESULTS_NOTIFICATION = 131,
	SCAN_COMPLETE_NOTIFICATION = 132,
	BEACON_NOTIFICATION = 144,
	REPLY_TX_BEACON = 145,
	WHO_IS_AWAKE_NOTIFICATION = 148,
	REPLY_TX_POWER_DBM_CMD = 149,
	QUIET_NOTIFICATION = 150,
	REPLY_TX_PWR_TABLE_CMD = 151,
	REPLY_TX_POWER_DBM_CMD_V1 = 152,
	TX_ANT_CONFIGURATION_CMD = 152,
	MEASURE_ABORT_NOTIFICATION = 153,
	REPLY_BT_CONFIG = 155,
	REPLY_STATISTICS_CMD = 156,
	STATISTICS_NOTIFICATION = 157,
	REPLY_CARD_STATE_CMD = 160,
	CARD_STATE_NOTIFICATION = 161,
	MISSED_BEACONS_NOTIFICATION = 162,
	REPLY_CT_KILL_CONFIG_CMD = 164,
	SENSITIVITY_CMD = 168,
	REPLY_PHY_CALIBRATION_CMD = 176,
	REPLY_RX_PHY_CMD = 192,
	REPLY_RX_MPDU_CMD = 193,
	REPLY_RX = 195,
	REPLY_COMPRESSED_BA = 197,
	REPLY_BT_COEX_PRIO_TABLE = 204,
	REPLY_BT_COEX_PROT_ENV = 205,
	REPLY_BT_COEX_PROFILE_NOTIF = 206,
	REPLY_WIPAN_PARAMS = 178,
	REPLY_WIPAN_RXON = 179,
	REPLY_WIPAN_RXON_TIMING = 180,
	REPLY_WIPAN_RXON_ASSOC = 182,
	REPLY_WIPAN_QOS_PARAM = 183,
	REPLY_WIPAN_WEPKEY = 184,
	REPLY_WIPAN_P2P_CHANNEL_SWITCH = 185,
	REPLY_WIPAN_NOA_NOTIFICATION = 188,
	REPLY_WIPAN_DEACTIVATION_COMPLETE = 189,
	REPLY_WOWLAN_PATTERNS = 224,
	REPLY_WOWLAN_WAKEUP_FILTER = 225,
	REPLY_WOWLAN_TSC_RSC_PARAMS = 226,
	REPLY_WOWLAN_TKIP_PARAMS = 227,
	REPLY_WOWLAN_KEK_KCK_MATERIAL = 228,
	REPLY_WOWLAN_GET_STATUS = 229,
	REPLY_D3_CONFIG = 211,
	REPLY_MAX = 255,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 5000,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 268435456ULL,
	REQ_F_ISREG = 536870912ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_APOLL_MULTISHOT = 67108864ULL,
	REQ_F_CLEAR_POLLIN = 134217728ULL,
	REQ_F_POLL_NO_LAZY = 1073741824ULL,
	REQ_F_CAN_POLL = 2147483648ULL,
	REQ_F_BL_EMPTY = 4294967296ULL,
	REQ_F_BL_NO_RECYCLE = 8589934592ULL,
	REQ_F_BUFFERS_COMMIT = 17179869184ULL,
	REQ_F_BUF_NODE = 34359738368ULL,
	REQ_F_HAS_METADATA = 68719476736ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_APOLL_MULTISHOT_BIT = 26,
	REQ_F_CLEAR_POLLIN_BIT = 27,
	REQ_F_SUPPORT_NOWAIT_BIT = 28,
	REQ_F_ISREG_BIT = 29,
	REQ_F_POLL_NO_LAZY_BIT = 30,
	REQ_F_CAN_POLL_BIT = 31,
	REQ_F_BL_EMPTY_BIT = 32,
	REQ_F_BL_NO_RECYCLE_BIT = 33,
	REQ_F_BUFFERS_COMMIT_BIT = 34,
	REQ_F_BUF_NODE_BIT = 35,
	REQ_F_HAS_METADATA_BIT = 36,
	__REQ_F_LAST_BIT = 37,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RS_STATE_SEARCH_CYCLE_STARTED = 0,
	RS_STATE_SEARCH_CYCLE_ENDED = 1,
	RS_STATE_STAY_IN_COLUMN = 2,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	RXON_DEV_TYPE_AP = 1,
	RXON_DEV_TYPE_ESS = 3,
	RXON_DEV_TYPE_IBSS = 4,
	RXON_DEV_TYPE_SNIFFER = 6,
	RXON_DEV_TYPE_CP = 7,
	RXON_DEV_TYPE_2STA = 8,
	RXON_DEV_TYPE_P2P = 9,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	SAMPLES = 8,
	MIN_CHANGE = 5,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_MAP_LAST_BIT = 4,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SILICON_A_STEP = 0,
	SILICON_B_STEP = 1,
	SILICON_C_STEP = 2,
	SILICON_D_STEP = 3,
	SILICON_E_STEP = 4,
	SILICON_TC_STEP = 14,
	SILICON_Z_STEP = 15,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SNBEP_PCI_QPI_PORT0_FILTER = 0,
	SNBEP_PCI_QPI_PORT1_FILTER = 1,
	BDX_PCI_QPI_PORT2_FILTER = 2,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_LAST = 131072,
	SOF_TIMESTAMPING_MASK = 262143,
};

enum {
	SPI_BLIST_NOIUS = 1,
};

enum {
	STRIPE_ACTIVE = 0,
	STRIPE_HANDLE = 1,
	STRIPE_SYNC_REQUESTED = 2,
	STRIPE_SYNCING = 3,
	STRIPE_INSYNC = 4,
	STRIPE_REPLACED = 5,
	STRIPE_PREREAD_ACTIVE = 6,
	STRIPE_DELAYED = 7,
	STRIPE_BIT_DELAY = 8,
	STRIPE_EXPANDING = 9,
	STRIPE_EXPAND_SOURCE = 10,
	STRIPE_EXPAND_READY = 11,
	STRIPE_IO_STARTED = 12,
	STRIPE_FULL_WRITE = 13,
	STRIPE_BIOFILL_RUN = 14,
	STRIPE_COMPUTE_RUN = 15,
	STRIPE_ON_UNPLUG_LIST = 16,
	STRIPE_DISCARD = 17,
	STRIPE_ON_RELEASE_LIST = 18,
	STRIPE_BATCH_READY = 19,
	STRIPE_BATCH_ERR = 20,
	STRIPE_LOG_TRAPPED = 21,
	STRIPE_R5C_CACHING = 22,
	STRIPE_R5C_PARTIAL_STRIPE = 23,
	STRIPE_R5C_FULL_STRIPE = 24,
	STRIPE_R5C_PREFLUSH = 25,
};

enum {
	STRIPE_OP_BIOFILL = 0,
	STRIPE_OP_COMPUTE_BLK = 1,
	STRIPE_OP_PREXOR = 2,
	STRIPE_OP_BIODRAIN = 3,
	STRIPE_OP_RECONSTRUCT = 4,
	STRIPE_OP_CHECK = 5,
	STRIPE_OP_PARTIAL_PARITY = 6,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
	SWP_SCANNING = 16384,
};

enum {
	SYNDROME_SRC_ALL = 0,
	SYNDROME_SRC_WANT_DRAIN = 1,
	SYNDROME_SRC_WRITTEN = 2,
};

enum {
	SYNTH_ERR_BAD_NAME = 0,
	SYNTH_ERR_INVALID_CMD = 1,
	SYNTH_ERR_INVALID_DYN_CMD = 2,
	SYNTH_ERR_EVENT_EXISTS = 3,
	SYNTH_ERR_TOO_MANY_FIELDS = 4,
	SYNTH_ERR_INCOMPLETE_TYPE = 5,
	SYNTH_ERR_INVALID_TYPE = 6,
	SYNTH_ERR_INVALID_FIELD = 7,
	SYNTH_ERR_INVALID_ARRAY_SPEC = 8,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 15,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	TE_V2_FRAG_NONE = 0,
	TE_V2_FRAG_SINGLE = 1,
	TE_V2_FRAG_DUAL = 2,
	TE_V2_FRAG_MAX = 254,
	TE_V2_FRAG_ENDLESS = 255,
};

enum {
	TKIP_DECRYPT_OK = 0,
	TKIP_DECRYPT_NO_EXT_IV = -1,
	TKIP_DECRYPT_INVALID_KEYIDX = -2,
	TKIP_DECRYPT_REPLAY = -3,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_ADDR_SUFFIX = 13,
	TP_ERR_NO_GROUP_NAME = 14,
	TP_ERR_GROUP_TOO_LONG = 15,
	TP_ERR_BAD_GROUP_NAME = 16,
	TP_ERR_NO_EVENT_NAME = 17,
	TP_ERR_EVENT_TOO_LONG = 18,
	TP_ERR_BAD_EVENT_NAME = 19,
	TP_ERR_EVENT_EXIST = 20,
	TP_ERR_RETVAL_ON_PROBE = 21,
	TP_ERR_NO_RETVAL = 22,
	TP_ERR_BAD_STACK_NUM = 23,
	TP_ERR_BAD_ARG_NUM = 24,
	TP_ERR_BAD_VAR = 25,
	TP_ERR_BAD_REG_NAME = 26,
	TP_ERR_BAD_MEM_ADDR = 27,
	TP_ERR_BAD_IMM = 28,
	TP_ERR_IMMSTR_NO_CLOSE = 29,
	TP_ERR_FILE_ON_KPROBE = 30,
	TP_ERR_BAD_FILE_OFFS = 31,
	TP_ERR_SYM_ON_UPROBE = 32,
	TP_ERR_TOO_MANY_OPS = 33,
	TP_ERR_DEREF_NEED_BRACE = 34,
	TP_ERR_BAD_DEREF_OFFS = 35,
	TP_ERR_DEREF_OPEN_BRACE = 36,
	TP_ERR_COMM_CANT_DEREF = 37,
	TP_ERR_BAD_FETCH_ARG = 38,
	TP_ERR_ARRAY_NO_CLOSE = 39,
	TP_ERR_BAD_ARRAY_SUFFIX = 40,
	TP_ERR_BAD_ARRAY_NUM = 41,
	TP_ERR_ARRAY_TOO_BIG = 42,
	TP_ERR_BAD_TYPE = 43,
	TP_ERR_BAD_STRING = 44,
	TP_ERR_BAD_SYMSTRING = 45,
	TP_ERR_BAD_BITFIELD = 46,
	TP_ERR_ARG_NAME_TOO_LONG = 47,
	TP_ERR_NO_ARG_NAME = 48,
	TP_ERR_BAD_ARG_NAME = 49,
	TP_ERR_USED_ARG_NAME = 50,
	TP_ERR_ARG_TOO_LONG = 51,
	TP_ERR_NO_ARG_BODY = 52,
	TP_ERR_BAD_INSN_BNDRY = 53,
	TP_ERR_FAIL_REG_PROBE = 54,
	TP_ERR_DIFF_PROBE_TYPE = 55,
	TP_ERR_DIFF_ARG_TYPE = 56,
	TP_ERR_SAME_PROBE = 57,
	TP_ERR_NO_EVENT_INFO = 58,
	TP_ERR_BAD_ATTACH_EVENT = 59,
	TP_ERR_BAD_ATTACH_ARG = 60,
	TP_ERR_NO_EP_FILTER = 61,
	TP_ERR_NOSUP_BTFARG = 62,
	TP_ERR_NO_BTFARG = 63,
	TP_ERR_NO_BTF_ENTRY = 64,
	TP_ERR_BAD_VAR_ARGS = 65,
	TP_ERR_NOFENTRY_ARGS = 66,
	TP_ERR_DOUBLE_ARGS = 67,
	TP_ERR_ARGS_2LONG = 68,
	TP_ERR_ARGIDX_2BIG = 69,
	TP_ERR_NO_PTR_STRCT = 70,
	TP_ERR_NOSUP_DAT_ARG = 71,
	TP_ERR_BAD_HYPHEN = 72,
	TP_ERR_NO_BTF_FIELD = 73,
	TP_ERR_BAD_BTF_TID = 74,
	TP_ERR_BAD_TYPE4STR = 75,
	TP_ERR_NEED_STRING_TYPE = 76,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
	TRACE_ARRAY_FL_MOD_INIT = 4,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
	TRACE_EVENT_FL_TEST_STR = 1024,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_RECORD_RECURSION_BIT = 12,
};

enum {
	TRACE_FUNC_NO_OPTS = 0,
	TRACE_FUNC_OPT_STACK = 1,
	TRACE_FUNC_OPT_NO_REPEATS = 2,
	TRACE_FUNC_OPT_HIGHEST_BIT = 4,
};

enum {
	TRACE_GRAPH_FL = 1,
	TRACE_GRAPH_DEPTH_START_BIT = 2,
	TRACE_GRAPH_DEPTH_END_BIT = 3,
	TRACE_GRAPH_NOTRACE_BIT = 4,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TX_PWR_CFG_0_IDX = 0,
	TX_PWR_CFG_1_IDX = 1,
	TX_PWR_CFG_2_IDX = 2,
	TX_PWR_CFG_3_IDX = 3,
	TX_PWR_CFG_4_IDX = 4,
	TX_PWR_CFG_5_IDX = 5,
	TX_PWR_CFG_6_IDX = 6,
	TX_PWR_CFG_7_IDX = 7,
	TX_PWR_CFG_8_IDX = 8,
	TX_PWR_CFG_9_IDX = 9,
	TX_PWR_CFG_0_EXT_IDX = 10,
	TX_PWR_CFG_1_EXT_IDX = 11,
	TX_PWR_CFG_2_EXT_IDX = 12,
	TX_PWR_CFG_3_EXT_IDX = 13,
	TX_PWR_CFG_4_EXT_IDX = 14,
	TX_PWR_CFG_IDX_COUNT = 15,
};

enum {
	TX_STATUS_MSK = 255,
	TX_STATUS_DELAY_MSK = 64,
	TX_STATUS_ABORT_MSK = 128,
	TX_PACKET_MODE_MSK = 65280,
	TX_FIFO_NUMBER_MSK = 458752,
	TX_RESERVED = 7864320,
	TX_POWER_PA_DETECT_MSK = 2139095040,
	TX_ABORT_REQUIRED_MSK = 2147483648,
};

enum {
	TX_STATUS_SUCCESS = 1,
	TX_STATUS_DIRECT_DONE = 2,
	TX_STATUS_POSTPONE_DELAY = 64,
	TX_STATUS_POSTPONE_FEW_BYTES = 65,
	TX_STATUS_POSTPONE_BT_PRIO = 66,
	TX_STATUS_POSTPONE_QUIET_PERIOD = 67,
	TX_STATUS_POSTPONE_CALC_TTAK = 68,
	TX_STATUS_FAIL_INTERNAL_CROSSED_RETRY = 129,
	TX_STATUS_FAIL_SHORT_LIMIT = 130,
	TX_STATUS_FAIL_LONG_LIMIT = 131,
	TX_STATUS_FAIL_FIFO_UNDERRUN = 132,
	TX_STATUS_FAIL_DRAIN_FLOW = 133,
	TX_STATUS_FAIL_RFKILL_FLUSH = 134,
	TX_STATUS_FAIL_LIFE_EXPIRE = 135,
	TX_STATUS_FAIL_DEST_PS = 136,
	TX_STATUS_FAIL_HOST_ABORTED = 137,
	TX_STATUS_FAIL_BT_RETRY = 138,
	TX_STATUS_FAIL_STA_INVALID = 139,
	TX_STATUS_FAIL_FRAG_DROPPED = 140,
	TX_STATUS_FAIL_TID_DISABLE = 141,
	TX_STATUS_FAIL_FIFO_FLUSHED = 142,
	TX_STATUS_FAIL_INSUFFICIENT_CF_POLL = 143,
	TX_STATUS_FAIL_PASSIVE_NO_RX = 144,
	TX_STATUS_FAIL_NO_BEACON_ON_RADAR = 145,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNCORE_TYPE_DF = 0,
	UNCORE_TYPE_L3 = 1,
	UNCORE_TYPE_UMC = 2,
	UNCORE_TYPE_MAX = 3,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	VETH_INFO_UNSPEC = 0,
	VETH_INFO_PEER = 1,
	__VETH_INFO_MAX = 2,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	WFPM_AUX_CTL_AUX_IF_MAC_OWNER_MSK = 2147483648,
};

enum {
	WORK_DONE_BIT = 0,
	WORK_ORDER_DONE_BIT = 1,
};

enum {
	X86_BR_NONE = 0,
	X86_BR_USER = 1,
	X86_BR_KERNEL = 2,
	X86_BR_CALL = 4,
	X86_BR_RET = 8,
	X86_BR_SYSCALL = 16,
	X86_BR_SYSRET = 32,
	X86_BR_INT = 64,
	X86_BR_IRET = 128,
	X86_BR_JCC = 256,
	X86_BR_JMP = 512,
	X86_BR_IRQ = 1024,
	X86_BR_IND_CALL = 2048,
	X86_BR_ABORT = 4096,
	X86_BR_IN_TX = 8192,
	X86_BR_NO_TX = 16384,
	X86_BR_ZERO_CALL = 32768,
	X86_BR_CALL_STACK = 65536,
	X86_BR_IND_JMP = 131072,
	X86_BR_TYPE_SAVE = 262144,
};

enum {
	X86_IRQ_ALLOC_LEGACY = 1,
};

enum {
	X86_PERF_KFREE_SHARED = 0,
	X86_PERF_KFREE_EXCL = 1,
	X86_PERF_KFREE_MAX = 2,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__EXTENT_DIRTY_BIT = 0,
	EXTENT_DIRTY = 1,
	__EXTENT_DIRTY_SEQ = 0,
	__EXTENT_UPTODATE_BIT = 1,
	EXTENT_UPTODATE = 2,
	__EXTENT_UPTODATE_SEQ = 1,
	__EXTENT_LOCKED_BIT = 2,
	EXTENT_LOCKED = 4,
	__EXTENT_LOCKED_SEQ = 2,
	__EXTENT_DIO_LOCKED_BIT = 3,
	EXTENT_DIO_LOCKED = 8,
	__EXTENT_DIO_LOCKED_SEQ = 3,
	__EXTENT_NEW_BIT = 4,
	EXTENT_NEW = 16,
	__EXTENT_NEW_SEQ = 4,
	__EXTENT_DELALLOC_BIT = 5,
	EXTENT_DELALLOC = 32,
	__EXTENT_DELALLOC_SEQ = 5,
	__EXTENT_DEFRAG_BIT = 6,
	EXTENT_DEFRAG = 64,
	__EXTENT_DEFRAG_SEQ = 6,
	__EXTENT_BOUNDARY_BIT = 7,
	EXTENT_BOUNDARY = 128,
	__EXTENT_BOUNDARY_SEQ = 7,
	__EXTENT_NODATASUM_BIT = 8,
	EXTENT_NODATASUM = 256,
	__EXTENT_NODATASUM_SEQ = 8,
	__EXTENT_CLEAR_META_RESV_BIT = 9,
	EXTENT_CLEAR_META_RESV = 512,
	__EXTENT_CLEAR_META_RESV_SEQ = 9,
	__EXTENT_NEED_WAIT_BIT = 10,
	EXTENT_NEED_WAIT = 1024,
	__EXTENT_NEED_WAIT_SEQ = 10,
	__EXTENT_NORESERVE_BIT = 11,
	EXTENT_NORESERVE = 2048,
	__EXTENT_NORESERVE_SEQ = 11,
	__EXTENT_QGROUP_RESERVED_BIT = 12,
	EXTENT_QGROUP_RESERVED = 4096,
	__EXTENT_QGROUP_RESERVED_SEQ = 12,
	__EXTENT_CLEAR_DATA_RESV_BIT = 13,
	EXTENT_CLEAR_DATA_RESV = 8192,
	__EXTENT_CLEAR_DATA_RESV_SEQ = 13,
	__EXTENT_DELALLOC_NEW_BIT = 14,
	EXTENT_DELALLOC_NEW = 16384,
	__EXTENT_DELALLOC_NEW_SEQ = 14,
	__EXTENT_ADD_INODE_BYTES_BIT = 15,
	EXTENT_ADD_INODE_BYTES = 32768,
	__EXTENT_ADD_INODE_BYTES_SEQ = 15,
	__EXTENT_CLEAR_ALL_BITS_BIT = 16,
	EXTENT_CLEAR_ALL_BITS = 65536,
	__EXTENT_CLEAR_ALL_BITS_SEQ = 16,
	__EXTENT_NOWAIT_BIT = 17,
	EXTENT_NOWAIT = 131072,
	__EXTENT_NOWAIT_SEQ = 17,
};

enum {
	__EXTENT_FLAG_PINNED_BIT = 0,
	EXTENT_FLAG_PINNED = 1,
	__EXTENT_FLAG_PINNED_SEQ = 0,
	__EXTENT_FLAG_COMPRESS_ZLIB_BIT = 1,
	EXTENT_FLAG_COMPRESS_ZLIB = 2,
	__EXTENT_FLAG_COMPRESS_ZLIB_SEQ = 1,
	__EXTENT_FLAG_COMPRESS_LZO_BIT = 2,
	EXTENT_FLAG_COMPRESS_LZO = 4,
	__EXTENT_FLAG_COMPRESS_LZO_SEQ = 2,
	__EXTENT_FLAG_COMPRESS_ZSTD_BIT = 3,
	EXTENT_FLAG_COMPRESS_ZSTD = 8,
	__EXTENT_FLAG_COMPRESS_ZSTD_SEQ = 3,
	__EXTENT_FLAG_PREALLOC_BIT = 4,
	EXTENT_FLAG_PREALLOC = 16,
	__EXTENT_FLAG_PREALLOC_SEQ = 4,
	__EXTENT_FLAG_LOGGING_BIT = 5,
	EXTENT_FLAG_LOGGING = 32,
	__EXTENT_FLAG_LOGGING_SEQ = 5,
	__EXTENT_FLAG_MERGED_BIT = 6,
	EXTENT_FLAG_MERGED = 64,
	__EXTENT_FLAG_MERGED_SEQ = 6,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PAGE_UNLOCK_BIT = 0,
	PAGE_UNLOCK = 1,
	__PAGE_UNLOCK_SEQ = 0,
	__PAGE_START_WRITEBACK_BIT = 1,
	PAGE_START_WRITEBACK = 2,
	__PAGE_START_WRITEBACK_SEQ = 1,
	__PAGE_END_WRITEBACK_BIT = 2,
	PAGE_END_WRITEBACK = 4,
	__PAGE_END_WRITEBACK_SEQ = 2,
	__PAGE_SET_ORDERED_BIT = 3,
	PAGE_SET_ORDERED = 8,
	__PAGE_SET_ORDERED_SEQ = 3,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__QGROUP_RESERVE_BIT = 0,
	QGROUP_RESERVE = 1,
	__QGROUP_RESERVE_SEQ = 0,
	__QGROUP_RELEASE_BIT = 1,
	QGROUP_RELEASE = 2,
	__QGROUP_RELEASE_SEQ = 1,
	__QGROUP_FREE_BIT = 2,
	QGROUP_FREE = 4,
	__QGROUP_FREE_SEQ = 2,
};

enum {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	____TRANS_FREEZABLE_BIT = 0,
	__TRANS_FREEZABLE = 1,
	____TRANS_FREEZABLE_SEQ = 0,
	____TRANS_START_BIT = 1,
	__TRANS_START = 2,
	____TRANS_START_SEQ = 1,
	____TRANS_ATTACH_BIT = 2,
	__TRANS_ATTACH = 4,
	____TRANS_ATTACH_SEQ = 2,
	____TRANS_JOIN_BIT = 3,
	__TRANS_JOIN = 8,
	____TRANS_JOIN_SEQ = 3,
	____TRANS_JOIN_NOLOCK_BIT = 4,
	__TRANS_JOIN_NOLOCK = 16,
	____TRANS_JOIN_NOLOCK_SEQ = 4,
	____TRANS_DUMMY_BIT = 5,
	__TRANS_DUMMY = 32,
	____TRANS_DUMMY_SEQ = 5,
	____TRANS_JOIN_NOSTART_BIT = 6,
	__TRANS_JOIN_NOSTART = 64,
	____TRANS_JOIN_NOSTART_SEQ = 6,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	btrfs_bitmap_nr_uptodate = 0,
	btrfs_bitmap_nr_dirty = 1,
	btrfs_bitmap_nr_writeback = 2,
	btrfs_bitmap_nr_ordered = 3,
	btrfs_bitmap_nr_checked = 4,
	btrfs_bitmap_nr_locked = 5,
	btrfs_bitmap_nr_max = 6,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	e1000_10_half = 0,
	e1000_10_full = 1,
	e1000_100_half = 2,
	e1000_100_full = 3,
};

enum {
	e1000_igp_cable_length_10 = 10,
	e1000_igp_cable_length_20 = 20,
	e1000_igp_cable_length_30 = 30,
	e1000_igp_cable_length_40 = 40,
	e1000_igp_cable_length_50 = 50,
	e1000_igp_cable_length_60 = 60,
	e1000_igp_cable_length_70 = 70,
	e1000_igp_cable_length_80 = 80,
	e1000_igp_cable_length_90 = 90,
	e1000_igp_cable_length_100 = 100,
	e1000_igp_cable_length_110 = 110,
	e1000_igp_cable_length_115 = 115,
	e1000_igp_cable_length_120 = 120,
	e1000_igp_cable_length_130 = 130,
	e1000_igp_cable_length_140 = 140,
	e1000_igp_cable_length_150 = 150,
	e1000_igp_cable_length_160 = 160,
	e1000_igp_cable_length_170 = 170,
	e1000_igp_cable_length_180 = 180,
};

enum {
	false = 0,
	true = 1,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	preempt_dynamic_undefined = -1,
	preempt_dynamic_none = 0,
	preempt_dynamic_voluntary = 1,
	preempt_dynamic_full = 2,
	preempt_dynamic_lazy = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	st_wordstart = 0,
	st_wordcmp = 1,
	st_wordskip = 2,
	st_bufcpy = 3,
};

enum {
	st_wordstart___2 = 0,
	st_wordcmp___2 = 1,
	st_wordskip___2 = 2,
};

enum {
	x86_lbr_exclusive_lbr = 0,
	x86_lbr_exclusive_bts = 1,
	x86_lbr_exclusive_pt = 2,
	x86_lbr_exclusive_max = 3,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_cParamMode_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam6 = 1003,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_buffers = 1,
	ZSTD_cwksp_alloc_aligned = 2,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_defaultPolicy_e;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_paramSwitch_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_sequenceFormat_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	e1000_1000t_rx_status_not_ok = 0,
	e1000_1000t_rx_status_ok = 1,
	e1000_1000t_rx_status_undefined = 255,
} e1000_1000t_rx_status;

typedef enum {
	e1000_10bt_ext_dist_enable_normal = 0,
	e1000_10bt_ext_dist_enable_lower = 1,
	e1000_10bt_ext_dist_enable_undefined = 255,
} e1000_10bt_ext_dist_enable;

typedef enum {
	e1000_auto_x_mode_manual_mdi = 0,
	e1000_auto_x_mode_manual_mdix = 1,
	e1000_auto_x_mode_auto1 = 2,
	e1000_auto_x_mode_auto2 = 3,
	e1000_auto_x_mode_undefined = 255,
} e1000_auto_x_mode;

typedef enum {
	e1000_bus_speed_unknown = 0,
	e1000_bus_speed_33 = 1,
	e1000_bus_speed_66 = 2,
	e1000_bus_speed_100 = 3,
	e1000_bus_speed_120 = 4,
	e1000_bus_speed_133 = 5,
	e1000_bus_speed_reserved = 6,
} e1000_bus_speed;

typedef enum {
	e1000_bus_type_unknown = 0,
	e1000_bus_type_pci = 1,
	e1000_bus_type_pcix = 2,
	e1000_bus_type_reserved = 3,
} e1000_bus_type;

typedef enum {
	e1000_bus_width_unknown = 0,
	e1000_bus_width_32 = 1,
	e1000_bus_width_64 = 2,
	e1000_bus_width_reserved = 3,
} e1000_bus_width;

typedef enum {
	e1000_cable_length_50 = 0,
	e1000_cable_length_50_80 = 1,
	e1000_cable_length_80_110 = 2,
	e1000_cable_length_110_140 = 3,
	e1000_cable_length_140 = 4,
	e1000_cable_length_undefined = 255,
} e1000_cable_length;

typedef enum {
	e1000_downshift_normal = 0,
	e1000_downshift_activated = 1,
	e1000_downshift_undefined = 255,
} e1000_downshift;

typedef enum {
	e1000_dsp_config_disabled = 0,
	e1000_dsp_config_enabled = 1,
	e1000_dsp_config_activated = 2,
	e1000_dsp_config_undefined = 255,
} e1000_dsp_config;

typedef enum {
	e1000_eeprom_uninitialized = 0,
	e1000_eeprom_spi = 1,
	e1000_eeprom_microwire = 2,
	e1000_eeprom_flash = 3,
	e1000_eeprom_none = 4,
	e1000_num_eeprom_types = 5,
} e1000_eeprom_type;

typedef enum {
	E1000_FC_NONE = 0,
	E1000_FC_RX_PAUSE = 1,
	E1000_FC_TX_PAUSE = 2,
	E1000_FC_FULL = 3,
	E1000_FC_DEFAULT = 255,
} e1000_fc_type;

typedef enum {
	e1000_ffe_config_enabled = 0,
	e1000_ffe_config_active = 1,
	e1000_ffe_config_blocked = 2,
} e1000_ffe_config;

typedef enum {
	e1000_undefined = 0,
	e1000_82542_rev2_0 = 1,
	e1000_82542_rev2_1 = 2,
	e1000_82543 = 3,
	e1000_82544 = 4,
	e1000_82540 = 5,
	e1000_82545 = 6,
	e1000_82545_rev_3 = 7,
	e1000_82546 = 8,
	e1000_ce4100 = 9,
	e1000_82546_rev_3 = 10,
	e1000_82541 = 11,
	e1000_82541_rev_2 = 12,
	e1000_82547 = 13,
	e1000_82547_rev_2 = 14,
	e1000_num_macs = 15,
} e1000_mac_type;

typedef enum {
	e1000_media_type_copper = 0,
	e1000_media_type_fiber = 1,
	e1000_media_type_internal_serdes = 2,
	e1000_num_media_types = 3,
} e1000_media_type;

typedef enum {
	e1000_ms_hw_default = 0,
	e1000_ms_force_master = 1,
	e1000_ms_force_slave = 2,
	e1000_ms_auto = 3,
} e1000_ms_type;

typedef enum {
	e1000_phy_m88 = 0,
	e1000_phy_igp = 1,
	e1000_phy_8211 = 2,
	e1000_phy_8201 = 3,
	e1000_phy_undefined = 255,
} e1000_phy_type;

typedef enum {
	e1000_polarity_reversal_enabled = 0,
	e1000_polarity_reversal_disabled = 1,
	e1000_polarity_reversal_undefined = 255,
} e1000_polarity_reversal;

typedef enum {
	e1000_rev_polarity_normal = 0,
	e1000_rev_polarity_reversed = 1,
	e1000_rev_polarity_undefined = 255,
} e1000_rev_polarity;

typedef enum {
	e1000_smart_speed_default = 0,
	e1000_smart_speed_on = 1,
	e1000_smart_speed_off = 2,
} e1000_smart_speed;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	STATUSTYPE_INFO = 0,
	STATUSTYPE_TABLE = 1,
	STATUSTYPE_IMA = 2,
} status_type_t;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} symbolEncodingType_e;

typedef ZSTD_ErrorCode zstd_error_code;

enum CMD_MODE {
	CMD_ASYNC = 1,
	CMD_WANT_SKB = 2,
	CMD_SEND_IN_RFKILL = 4,
	CMD_BLOCK_TXQS = 8,
	CMD_SEND_IN_D3 = 16,
};

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum E1000_INVM_STRUCTURE_TYPE {
	E1000_INVM_UNINITIALIZED_STRUCTURE = 0,
	E1000_INVM_WORD_AUTOLOAD_STRUCTURE = 1,
	E1000_INVM_CSR_AUTOLOAD_STRUCTURE = 2,
	E1000_INVM_PHY_REGISTER_AUTOLOAD_STRUCTURE = 3,
	E1000_INVM_RSA_KEY_SHA256_STRUCTURE = 4,
	E1000_INVM_INVALIDATED_STRUCTURE = 15,
};

enum IWL_TLC_MCS_PER_BW {
	IWL_TLC_MCS_PER_BW_80 = 0,
	IWL_TLC_MCS_PER_BW_160 = 1,
	IWL_TLC_MCS_PER_BW_320 = 2,
	IWL_TLC_MCS_PER_BW_NUM_V3 = 2,
	IWL_TLC_MCS_PER_BW_NUM_V4 = 3,
};

enum IWL_TLC_MNG_NSS {
	IWL_TLC_NSS_1 = 0,
	IWL_TLC_NSS_2 = 1,
	IWL_TLC_NSS_MAX = 2,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum P4_EVENTS {
	P4_EVENT_TC_DELIVER_MODE = 0,
	P4_EVENT_BPU_FETCH_REQUEST = 1,
	P4_EVENT_ITLB_REFERENCE = 2,
	P4_EVENT_MEMORY_CANCEL = 3,
	P4_EVENT_MEMORY_COMPLETE = 4,
	P4_EVENT_LOAD_PORT_REPLAY = 5,
	P4_EVENT_STORE_PORT_REPLAY = 6,
	P4_EVENT_MOB_LOAD_REPLAY = 7,
	P4_EVENT_PAGE_WALK_TYPE = 8,
	P4_EVENT_BSQ_CACHE_REFERENCE = 9,
	P4_EVENT_IOQ_ALLOCATION = 10,
	P4_EVENT_IOQ_ACTIVE_ENTRIES = 11,
	P4_EVENT_FSB_DATA_ACTIVITY = 12,
	P4_EVENT_BSQ_ALLOCATION = 13,
	P4_EVENT_BSQ_ACTIVE_ENTRIES = 14,
	P4_EVENT_SSE_INPUT_ASSIST = 15,
	P4_EVENT_PACKED_SP_UOP = 16,
	P4_EVENT_PACKED_DP_UOP = 17,
	P4_EVENT_SCALAR_SP_UOP = 18,
	P4_EVENT_SCALAR_DP_UOP = 19,
	P4_EVENT_64BIT_MMX_UOP = 20,
	P4_EVENT_128BIT_MMX_UOP = 21,
	P4_EVENT_X87_FP_UOP = 22,
	P4_EVENT_TC_MISC = 23,
	P4_EVENT_GLOBAL_POWER_EVENTS = 24,
	P4_EVENT_TC_MS_XFER = 25,
	P4_EVENT_UOP_QUEUE_WRITES = 26,
	P4_EVENT_RETIRED_MISPRED_BRANCH_TYPE = 27,
	P4_EVENT_RETIRED_BRANCH_TYPE = 28,
	P4_EVENT_RESOURCE_STALL = 29,
	P4_EVENT_WC_BUFFER = 30,
	P4_EVENT_B2B_CYCLES = 31,
	P4_EVENT_BNR = 32,
	P4_EVENT_SNOOP = 33,
	P4_EVENT_RESPONSE = 34,
	P4_EVENT_FRONT_END_EVENT = 35,
	P4_EVENT_EXECUTION_EVENT = 36,
	P4_EVENT_REPLAY_EVENT = 37,
	P4_EVENT_INSTR_RETIRED = 38,
	P4_EVENT_UOPS_RETIRED = 39,
	P4_EVENT_UOP_TYPE = 40,
	P4_EVENT_BRANCH_RETIRED = 41,
	P4_EVENT_MISPRED_BRANCH_RETIRED = 42,
	P4_EVENT_X87_ASSIST = 43,
	P4_EVENT_MACHINE_CLEAR = 44,
	P4_EVENT_INSTR_COMPLETED = 45,
};

enum P4_PEBS_METRIC {
	P4_PEBS_METRIC__none = 0,
	P4_PEBS_METRIC__1stl_cache_load_miss_retired = 1,
	P4_PEBS_METRIC__2ndl_cache_load_miss_retired = 2,
	P4_PEBS_METRIC__dtlb_load_miss_retired = 3,
	P4_PEBS_METRIC__dtlb_store_miss_retired = 4,
	P4_PEBS_METRIC__dtlb_all_miss_retired = 5,
	P4_PEBS_METRIC__tagged_mispred_branch = 6,
	P4_PEBS_METRIC__mob_load_replay_retired = 7,
	P4_PEBS_METRIC__split_load_retired = 8,
	P4_PEBS_METRIC__split_store_retired = 9,
	P4_PEBS_METRIC__max = 10,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum ___mac80211_drop_reason {
	___RX_CONTINUE = 1,
	___RX_QUEUED = 0,
	___RX_DROP_MONITOR = 131072,
	___RX_DROP_M_UNEXPECTED_4ADDR_FRAME = 131073,
	___RX_DROP_M_BAD_BCN_KEYIDX = 131074,
	___RX_DROP_M_BAD_MGMT_KEYIDX = 131075,
	___RX_DROP_UNUSABLE = 65536,
	___RX_DROP_U_MIC_FAIL = 65537,
	___RX_DROP_U_REPLAY = 65538,
	___RX_DROP_U_BAD_MMIE = 65539,
	___RX_DROP_U_DUP = 65540,
	___RX_DROP_U_SPURIOUS = 65541,
	___RX_DROP_U_DECRYPT_FAIL = 65542,
	___RX_DROP_U_NO_KEY_ID = 65543,
	___RX_DROP_U_BAD_CIPHER = 65544,
	___RX_DROP_U_OOM = 65545,
	___RX_DROP_U_NONSEQ_PN = 65546,
	___RX_DROP_U_BAD_KEY_COLOR = 65547,
	___RX_DROP_U_BAD_4ADDR = 65548,
	___RX_DROP_U_BAD_AMSDU = 65549,
	___RX_DROP_U_BAD_AMSDU_CIPHER = 65550,
	___RX_DROP_U_INVALID_8023 = 65551,
	___RX_DROP_U_RUNT_ACTION = 65552,
	___RX_DROP_U_UNPROT_ACTION = 65553,
	___RX_DROP_U_UNPROT_DUAL = 65554,
	___RX_DROP_U_UNPROT_UCAST_MGMT = 65555,
	___RX_DROP_U_UNPROT_MCAST_MGMT = 65556,
	___RX_DROP_U_UNPROT_BEACON = 65557,
	___RX_DROP_U_UNPROT_UNICAST_PUB_ACTION = 65558,
	___RX_DROP_U_UNPROT_ROBUST_ACTION = 65559,
	___RX_DROP_U_ACTION_UNKNOWN_SRC = 65560,
	___RX_DROP_U_REJECTED_ACTION_RESPONSE = 65561,
	___RX_DROP_U_EXPECT_DEFRAG_PROT = 65562,
	___RX_DROP_U_WEP_DEC_FAIL = 65563,
	___RX_DROP_U_NO_IV = 65564,
	___RX_DROP_U_NO_ICV = 65565,
	___RX_DROP_U_AP_RX_GROUPCAST = 65566,
	___RX_DROP_U_SHORT_MMIC = 65567,
	___RX_DROP_U_MMIC_FAIL = 65568,
	___RX_DROP_U_SHORT_TKIP = 65569,
	___RX_DROP_U_TKIP_FAIL = 65570,
	___RX_DROP_U_SHORT_CCMP = 65571,
	___RX_DROP_U_SHORT_CCMP_MIC = 65572,
	___RX_DROP_U_SHORT_GCMP = 65573,
	___RX_DROP_U_SHORT_GCMP_MIC = 65574,
	___RX_DROP_U_SHORT_CMAC = 65575,
	___RX_DROP_U_SHORT_CMAC256 = 65576,
	___RX_DROP_U_SHORT_GMAC = 65577,
	___RX_DROP_U_UNEXPECTED_VLAN_4ADDR = 65578,
	___RX_DROP_U_UNEXPECTED_STA_4ADDR = 65579,
	___RX_DROP_U_UNEXPECTED_VLAN_MCAST = 65580,
	___RX_DROP_U_NOT_PORT_CONTROL = 65581,
	___RX_DROP_U_UNKNOWN_ACTION_REJECTED = 65582,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _cache_type {
	CTYPE_NULL = 0,
	CTYPE_DATA = 1,
	CTYPE_INST = 2,
	CTYPE_UNIFIED = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_KASAN = 14,
	_SLAB_NO_USER_FLAGS = 15,
	_SLAB_RECLAIM_ACCOUNT = 16,
	_SLAB_OBJECT_POISON = 17,
	_SLAB_CMPXCHG_DOUBLE = 18,
	_SLAB_NO_OBJ_EXT = 19,
	_SLAB_FLAGS_LAST_BIT = 20,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_ec_event_state {
	EC_EVENT_READY = 0,
	EC_EVENT_IN_PROGRESS = 1,
	EC_EVENT_COMPLETE = 2,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_preferred_pm_profiles {
	PM_UNSPECIFIED = 0,
	PM_DESKTOP = 1,
	PM_MOBILE = 2,
	PM_WORKSTATION = 3,
	PM_ENTERPRISE_SERVER = 4,
	PM_SOHO_SERVER = 5,
	PM_APPLIANCE_PC = 6,
	PM_PERFORMANCE_SERVER = 7,
	PM_TABLET = 8,
	NR_PM_PROFILES = 9,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum action_id {
	ACTION_SAVE = 1,
	ACTION_TRACE = 2,
	ACTION_SNAPSHOT = 3,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum align_flags {
	ALIGN_VA_32 = 1,
	ALIGN_VA_64 = 2,
};

enum amd_chipset_gen {
	NOT_AMD_CHIPSET = 0,
	AMD_CHIPSET_SB600 = 1,
	AMD_CHIPSET_SB700 = 2,
	AMD_CHIPSET_SB800 = 3,
	AMD_CHIPSET_HUDSON2 = 4,
	AMD_CHIPSET_BOLTON = 5,
	AMD_CHIPSET_YANGTZE = 6,
	AMD_CHIPSET_TAISHAN = 7,
	AMD_CHIPSET_UNKNOWN = 8,
};

enum amd_pref_core {
	AMD_PREF_CORE_UNKNOWN = 0,
	AMD_PREF_CORE_SUPPORTED = 1,
	AMD_PREF_CORE_UNSUPPORTED = 2,
};

enum amd_pstate_mode {
	AMD_PSTATE_UNDEFINED = 0,
	AMD_PSTATE_DISABLE = 1,
	AMD_PSTATE_PASSIVE = 2,
	AMD_PSTATE_ACTIVE = 3,
	AMD_PSTATE_GUIDED = 4,
	AMD_PSTATE_MAX = 5,
};

enum antenna {
	ANTENNA_SW_DIVERSITY = 0,
	ANTENNA_A = 1,
	ANTENNA_B = 2,
	ANTENNA_HW_DIVERSITY = 3,
};

enum apic_intr_mode_id {
	APIC_PIC = 0,
	APIC_VIRTUAL_WIRE = 1,
	APIC_VIRTUAL_WIRE_NO_CONFIG = 2,
	APIC_SYMMETRIC_IO = 3,
	APIC_SYMMETRIC_IO_NO_ROUTING = 4,
};

enum array_state {
	clear = 0,
	inactive = 1,
	suspended = 2,
	readonly = 3,
	read_auto = 4,
	clean = 5,
	active = 6,
	write_pending = 7,
	active_idle = 8,
	broken = 9,
	bad_word = 10,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum assoc_status {
	ASSOC_SUCCESS = 0,
	ASSOC_REJECTED = 1,
	ASSOC_TIMEOUT = 2,
	ASSOC_ABANDON = 3,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum async_tx_flags {
	ASYNC_TX_XOR_ZERO_DST = 1,
	ASYNC_TX_XOR_DROP_DST = 2,
	ASYNC_TX_ACK = 4,
	ASYNC_TX_FENCE = 8,
	ASYNC_TX_PQ_XOR_DST = 16,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum atom_native_id {
	cmt_native_id = 2,
	skt_native_id = 3,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum backlight_update_reason {
	BACKLIGHT_UPDATE_HOTKEY = 0,
	BACKLIGHT_UPDATE_SYSFS = 1,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

enum bhi_mitigations {
	BHI_MITIGATION_OFF = 0,
	BHI_MITIGATION_ON = 1,
	BHI_MITIGATION_VMEXIT_ONLY = 2,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bios_source {
	BIOS_SOURCE_NONE = 0,
	BIOS_SOURCE_ACPI = 1,
	BIOS_SOURCE_UEFI = 2,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum bitmap_page_attr {
	BITMAP_PAGE_DIRTY = 0,
	BITMAP_PAGE_PENDING = 1,
	BITMAP_PAGE_NEEDWRITE = 2,
};

enum bitmap_state {
	BITMAP_STALE = 1,
	BITMAP_WRITE_ERROR = 2,
	BITMAP_HOSTENDIAN = 15,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2b_iv {
	BLAKE2B_IV0 = 7640891576956012808ULL,
	BLAKE2B_IV1 = 13503953896175478587ULL,
	BLAKE2B_IV2 = 4354685564936845355ULL,
	BLAKE2B_IV3 = 11912009170470909681ULL,
	BLAKE2B_IV4 = 5840696475078001361ULL,
	BLAKE2B_IV5 = 11170449401992604703ULL,
	BLAKE2B_IV6 = 2270897969802886507ULL,
	BLAKE2B_IV7 = 6620516959819538809ULL,
};

enum blake2b_lengths {
	BLAKE2B_BLOCK_SIZE = 128,
	BLAKE2B_HASH_SIZE = 64,
	BLAKE2B_KEY_SIZE = 64,
	BLAKE2B_160_HASH_SIZE = 20,
	BLAKE2B_256_HASH_SIZE = 32,
	BLAKE2B_384_HASH_SIZE = 48,
	BLAKE2B_512_HASH_SIZE = 64,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum blktrace_cat {
	BLK_TC_READ = 1,
	BLK_TC_WRITE = 2,
	BLK_TC_FLUSH = 4,
	BLK_TC_SYNC = 8,
	BLK_TC_SYNCIO = 8,
	BLK_TC_QUEUE = 16,
	BLK_TC_REQUEUE = 32,
	BLK_TC_ISSUE = 64,
	BLK_TC_COMPLETE = 128,
	BLK_TC_FS = 256,
	BLK_TC_PC = 512,
	BLK_TC_NOTIFY = 1024,
	BLK_TC_AHEAD = 2048,
	BLK_TC_META = 4096,
	BLK_TC_DISCARD = 8192,
	BLK_TC_DRV_DATA = 16384,
	BLK_TC_FUA = 32768,
	BLK_TC_END = 32768,
};

enum blktrace_notify {
	__BLK_TN_PROCESS = 0,
	__BLK_TN_TIMESTAMP = 1,
	__BLK_TN_MESSAGE = 2,
	__BLK_TN_CGROUP = 256,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_al = 9,
	board_ahci_avn = 10,
	board_ahci_mcp65 = 11,
	board_ahci_mcp77 = 12,
	board_ahci_mcp89 = 13,
	board_ahci_mv = 14,
	board_ahci_sb600 = 15,
	board_ahci_sb700 = 16,
	board_ahci_vt8251 = 17,
	board_ahci_mcp_linux = 11,
	board_ahci_mcp67 = 11,
	board_ahci_mcp73 = 11,
	board_ahci_mcp79 = 12,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 0,
	TYPE_MAX = 1,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum br_boolopt_id {
	BR_BOOLOPT_NO_LL_LEARN = 0,
	BR_BOOLOPT_MCAST_VLAN_SNOOPING = 1,
	BR_BOOLOPT_MST_ENABLE = 2,
	BR_BOOLOPT_MAX = 3,
};

enum br_pkt_type {
	BR_PKT_UNICAST = 0,
	BR_PKT_MULTICAST = 1,
	BR_PKT_BROADCAST = 2,
};

enum bss_compare_mode {
	BSS_CMP_REGULAR = 0,
	BSS_CMP_HIDE_ZLEN = 1,
	BSS_CMP_HIDE_NUL = 2,
};

enum bss_param_flags {
	BSS_PARAM_FLAGS_CTS_PROT = 1,
	BSS_PARAM_FLAGS_SHORT_PREAMBLE = 2,
	BSS_PARAM_FLAGS_SHORT_SLOT_TIME = 4,
};

enum bss_source_type {
	BSS_SOURCE_DIRECT = 0,
	BSS_SOURCE_MBSSID = 1,
	BSS_SOURCE_STA_PROFILE = 2,
};

enum bt_coex_prio_table_events {
	BT_COEX_PRIO_TBL_EVT_INIT_CALIB1 = 0,
	BT_COEX_PRIO_TBL_EVT_INIT_CALIB2 = 1,
	BT_COEX_PRIO_TBL_EVT_PERIODIC_CALIB_LOW1 = 2,
	BT_COEX_PRIO_TBL_EVT_PERIODIC_CALIB_LOW2 = 3,
	BT_COEX_PRIO_TBL_EVT_PERIODIC_CALIB_HIGH1 = 4,
	BT_COEX_PRIO_TBL_EVT_PERIODIC_CALIB_HIGH2 = 5,
	BT_COEX_PRIO_TBL_EVT_DTIM = 6,
	BT_COEX_PRIO_TBL_EVT_SCAN52 = 7,
	BT_COEX_PRIO_TBL_EVT_SCAN24 = 8,
	BT_COEX_PRIO_TBL_EVT_RESERVED0 = 9,
	BT_COEX_PRIO_TBL_EVT_RESERVED1 = 10,
	BT_COEX_PRIO_TBL_EVT_RESERVED2 = 11,
	BT_COEX_PRIO_TBL_EVT_RESERVED3 = 12,
	BT_COEX_PRIO_TBL_EVT_RESERVED4 = 13,
	BT_COEX_PRIO_TBL_EVT_RESERVED5 = 14,
	BT_COEX_PRIO_TBL_EVT_RESERVED6 = 15,
	BT_COEX_PRIO_TBL_EVT_MAX = 16,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum btrfs_block_group_flags {
	BLOCK_GROUP_FLAG_IREF = 0,
	BLOCK_GROUP_FLAG_REMOVED = 1,
	BLOCK_GROUP_FLAG_TO_COPY = 2,
	BLOCK_GROUP_FLAG_RELOCATING_REPAIR = 3,
	BLOCK_GROUP_FLAG_CHUNK_ITEM_INSERTED = 4,
	BLOCK_GROUP_FLAG_ZONE_IS_ACTIVE = 5,
	BLOCK_GROUP_FLAG_ZONED_DATA_RELOC = 6,
	BLOCK_GROUP_FLAG_NEEDS_FREE_SPACE = 7,
	BLOCK_GROUP_FLAG_SEQUENTIAL_ZONE = 8,
	BLOCK_GROUP_FLAG_NEW = 9,
};

enum btrfs_block_group_size_class {
	BTRFS_BG_SZ_NONE = 0,
	BTRFS_BG_SZ_SMALL = 1,
	BTRFS_BG_SZ_MEDIUM = 2,
	BTRFS_BG_SZ_LARGE = 3,
};

enum btrfs_caching_type {
	BTRFS_CACHE_NO = 0,
	BTRFS_CACHE_STARTED = 1,
	BTRFS_CACHE_FINISHED = 2,
	BTRFS_CACHE_ERROR = 3,
};

enum btrfs_chunk_alloc_enum {
	CHUNK_ALLOC_NO_FORCE = 0,
	CHUNK_ALLOC_LIMITED = 1,
	CHUNK_ALLOC_FORCE = 2,
	CHUNK_ALLOC_FORCE_FOR_EXTENT = 3,
};

enum btrfs_chunk_allocation_policy {
	BTRFS_CHUNK_ALLOC_REGULAR = 0,
	BTRFS_CHUNK_ALLOC_ZONED = 1,
};

enum btrfs_compare_tree_result {
	BTRFS_COMPARE_TREE_NEW = 0,
	BTRFS_COMPARE_TREE_DELETED = 1,
	BTRFS_COMPARE_TREE_CHANGED = 2,
	BTRFS_COMPARE_TREE_SAME = 3,
};

enum btrfs_compression_type {
	BTRFS_COMPRESS_NONE = 0,
	BTRFS_COMPRESS_ZLIB = 1,
	BTRFS_COMPRESS_LZO = 2,
	BTRFS_COMPRESS_ZSTD = 3,
	BTRFS_NR_COMPRESS_TYPES = 4,
};

enum btrfs_csum_type {
	BTRFS_CSUM_TYPE_CRC32 = 0,
	BTRFS_CSUM_TYPE_XXHASH = 1,
	BTRFS_CSUM_TYPE_SHA256 = 2,
	BTRFS_CSUM_TYPE_BLAKE2 = 3,
};

enum btrfs_delayed_item_type {
	BTRFS_DELAYED_INSERTION_ITEM = 0,
	BTRFS_DELAYED_DELETION_ITEM = 1,
};

enum btrfs_delayed_ref_action {
	BTRFS_ADD_DELAYED_REF = 1,
	BTRFS_DROP_DELAYED_REF = 2,
	BTRFS_ADD_DELAYED_EXTENT = 3,
	BTRFS_UPDATE_DELAYED_HEAD = 4,
} __attribute__((mode(byte)));

enum btrfs_delayed_ref_flags {
	BTRFS_DELAYED_REFS_FLUSHING = 0,
};

enum btrfs_dev_stat_values {
	BTRFS_DEV_STAT_WRITE_ERRS = 0,
	BTRFS_DEV_STAT_READ_ERRS = 1,
	BTRFS_DEV_STAT_FLUSH_ERRS = 2,
	BTRFS_DEV_STAT_CORRUPTION_ERRS = 3,
	BTRFS_DEV_STAT_GENERATION_ERRS = 4,
	BTRFS_DEV_STAT_VALUES_MAX = 5,
};

enum btrfs_discard_state {
	BTRFS_DISCARD_EXTENTS = 0,
	BTRFS_DISCARD_BITMAPS = 1,
	BTRFS_DISCARD_RESET_CURSOR = 2,
};

enum btrfs_disk_cache_state {
	BTRFS_DC_WRITTEN = 0,
	BTRFS_DC_ERROR = 1,
	BTRFS_DC_CLEAR = 2,
	BTRFS_DC_SETUP = 3,
};

enum btrfs_err_code {
	BTRFS_ERROR_DEV_RAID1_MIN_NOT_MET = 1,
	BTRFS_ERROR_DEV_RAID10_MIN_NOT_MET = 2,
	BTRFS_ERROR_DEV_RAID5_MIN_NOT_MET = 3,
	BTRFS_ERROR_DEV_RAID6_MIN_NOT_MET = 4,
	BTRFS_ERROR_DEV_TGT_REPLACE = 5,
	BTRFS_ERROR_DEV_MISSING_NOT_FOUND = 6,
	BTRFS_ERROR_DEV_ONLY_WRITABLE = 7,
	BTRFS_ERROR_DEV_EXCL_RUN_IN_PROGRESS = 8,
	BTRFS_ERROR_DEV_RAID1C3_MIN_NOT_MET = 9,
	BTRFS_ERROR_DEV_RAID1C4_MIN_NOT_MET = 10,
};

enum btrfs_exclusive_operation {
	BTRFS_EXCLOP_NONE = 0,
	BTRFS_EXCLOP_BALANCE_PAUSED = 1,
	BTRFS_EXCLOP_BALANCE = 2,
	BTRFS_EXCLOP_DEV_ADD = 3,
	BTRFS_EXCLOP_DEV_REMOVE = 4,
	BTRFS_EXCLOP_DEV_REPLACE = 5,
	BTRFS_EXCLOP_RESIZE = 6,
	BTRFS_EXCLOP_SWAP_ACTIVATE = 7,
};

enum btrfs_extent_allocation_policy {
	BTRFS_EXTENT_ALLOC_CLUSTERED = 0,
	BTRFS_EXTENT_ALLOC_ZONED = 1,
};

enum btrfs_feature_set {
	FEAT_COMPAT = 0,
	FEAT_COMPAT_RO = 1,
	FEAT_INCOMPAT = 2,
	FEAT_MAX = 3,
};

enum btrfs_flush_state {
	FLUSH_DELAYED_ITEMS_NR = 1,
	FLUSH_DELAYED_ITEMS = 2,
	FLUSH_DELAYED_REFS_NR = 3,
	FLUSH_DELAYED_REFS = 4,
	FLUSH_DELALLOC = 5,
	FLUSH_DELALLOC_WAIT = 6,
	FLUSH_DELALLOC_FULL = 7,
	ALLOC_CHUNK = 8,
	ALLOC_CHUNK_FORCE = 9,
	RUN_DELAYED_IPUTS = 10,
	COMMIT_TRANS = 11,
	RESET_ZONES = 12,
};

enum btrfs_ilock_type {
	__BTRFS_ILOCK_SHARED_BIT = 0,
	BTRFS_ILOCK_SHARED = 1,
	__BTRFS_ILOCK_SHARED_SEQ = 0,
	__BTRFS_ILOCK_TRY_BIT = 1,
	BTRFS_ILOCK_TRY = 2,
	__BTRFS_ILOCK_TRY_SEQ = 1,
	__BTRFS_ILOCK_MMAP_BIT = 2,
	BTRFS_ILOCK_MMAP = 4,
	__BTRFS_ILOCK_MMAP_SEQ = 2,
};

enum btrfs_inline_ref_type {
	BTRFS_REF_TYPE_INVALID = 0,
	BTRFS_REF_TYPE_BLOCK = 1,
	BTRFS_REF_TYPE_DATA = 2,
	BTRFS_REF_TYPE_ANY = 3,
};

enum btrfs_lock_nesting {
	BTRFS_NESTING_NORMAL = 0,
	BTRFS_NESTING_COW = 1,
	BTRFS_NESTING_LEFT = 2,
	BTRFS_NESTING_RIGHT = 3,
	BTRFS_NESTING_LEFT_COW = 4,
	BTRFS_NESTING_RIGHT_COW = 5,
	BTRFS_NESTING_SPLIT = 6,
	BTRFS_NESTING_NEW_ROOT = 7,
	BTRFS_NESTING_MAX = 8,
};

enum btrfs_loop_type {
	LOOP_CACHING_NOWAIT = 0,
	LOOP_CACHING_WAIT = 1,
	LOOP_UNSET_SIZE_CLASS = 2,
	LOOP_ALLOC_CHUNK = 3,
	LOOP_WRONG_SIZE_CLASS = 4,
	LOOP_NO_EMPTY_SIZE = 5,
};

enum btrfs_map_op {
	BTRFS_MAP_READ = 0,
	BTRFS_MAP_WRITE = 1,
	BTRFS_MAP_GET_READ_MIRRORS = 2,
};

enum btrfs_mod_log_op {
	BTRFS_MOD_LOG_KEY_REPLACE = 0,
	BTRFS_MOD_LOG_KEY_ADD = 1,
	BTRFS_MOD_LOG_KEY_REMOVE = 2,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_FREEING = 3,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_MOVING = 4,
	BTRFS_MOD_LOG_MOVE_KEYS = 5,
	BTRFS_MOD_LOG_ROOT_REPLACE = 6,
};

enum btrfs_qgroup_mode {
	BTRFS_QGROUP_MODE_DISABLED = 0,
	BTRFS_QGROUP_MODE_FULL = 1,
	BTRFS_QGROUP_MODE_SIMPLE = 2,
};

enum btrfs_qgroup_rsv_type {
	BTRFS_QGROUP_RSV_DATA = 0,
	BTRFS_QGROUP_RSV_META_PERTRANS = 1,
	BTRFS_QGROUP_RSV_META_PREALLOC = 2,
	BTRFS_QGROUP_RSV_LAST = 3,
};

enum btrfs_raid_types {
	BTRFS_RAID_SINGLE = 0,
	BTRFS_RAID_RAID0 = 1,
	BTRFS_RAID_RAID1 = 2,
	BTRFS_RAID_DUP = 3,
	BTRFS_RAID_RAID10 = 4,
	BTRFS_RAID_RAID5 = 5,
	BTRFS_RAID_RAID6 = 6,
	BTRFS_RAID_RAID1C3 = 7,
	BTRFS_RAID_RAID1C4 = 8,
	BTRFS_NR_RAID_TYPES = 9,
};

enum btrfs_rbio_ops {
	BTRFS_RBIO_WRITE = 0,
	BTRFS_RBIO_READ_REBUILD = 1,
	BTRFS_RBIO_PARITY_SCRUB = 2,
};

enum btrfs_read_policy {
	BTRFS_READ_POLICY_PID = 0,
	BTRFS_NR_READ_POLICY = 1,
};

enum btrfs_ref_type {
	BTRFS_REF_NOT_SET = 0,
	BTRFS_REF_DATA = 1,
	BTRFS_REF_METADATA = 2,
	BTRFS_REF_LAST = 3,
} __attribute__((mode(byte)));

enum btrfs_reserve_flush_enum {
	BTRFS_RESERVE_NO_FLUSH = 0,
	BTRFS_RESERVE_FLUSH_LIMIT = 1,
	BTRFS_RESERVE_FLUSH_EVICT = 2,
	BTRFS_RESERVE_FLUSH_DATA = 3,
	BTRFS_RESERVE_FLUSH_FREE_SPACE_INODE = 4,
	BTRFS_RESERVE_FLUSH_ALL = 5,
	BTRFS_RESERVE_FLUSH_ALL_STEAL = 6,
	BTRFS_RESERVE_FLUSH_EMERGENCY = 7,
};

enum btrfs_rsv_type {
	BTRFS_BLOCK_RSV_GLOBAL = 0,
	BTRFS_BLOCK_RSV_DELALLOC = 1,
	BTRFS_BLOCK_RSV_TRANS = 2,
	BTRFS_BLOCK_RSV_CHUNK = 3,
	BTRFS_BLOCK_RSV_DELOPS = 4,
	BTRFS_BLOCK_RSV_DELREFS = 5,
	BTRFS_BLOCK_RSV_EMPTY = 6,
	BTRFS_BLOCK_RSV_TEMP = 7,
};

enum btrfs_send_cmd {
	BTRFS_SEND_C_UNSPEC = 0,
	BTRFS_SEND_C_SUBVOL = 1,
	BTRFS_SEND_C_SNAPSHOT = 2,
	BTRFS_SEND_C_MKFILE = 3,
	BTRFS_SEND_C_MKDIR = 4,
	BTRFS_SEND_C_MKNOD = 5,
	BTRFS_SEND_C_MKFIFO = 6,
	BTRFS_SEND_C_MKSOCK = 7,
	BTRFS_SEND_C_SYMLINK = 8,
	BTRFS_SEND_C_RENAME = 9,
	BTRFS_SEND_C_LINK = 10,
	BTRFS_SEND_C_UNLINK = 11,
	BTRFS_SEND_C_RMDIR = 12,
	BTRFS_SEND_C_SET_XATTR = 13,
	BTRFS_SEND_C_REMOVE_XATTR = 14,
	BTRFS_SEND_C_WRITE = 15,
	BTRFS_SEND_C_CLONE = 16,
	BTRFS_SEND_C_TRUNCATE = 17,
	BTRFS_SEND_C_CHMOD = 18,
	BTRFS_SEND_C_CHOWN = 19,
	BTRFS_SEND_C_UTIMES = 20,
	BTRFS_SEND_C_END = 21,
	BTRFS_SEND_C_UPDATE_EXTENT = 22,
	BTRFS_SEND_C_MAX_V1 = 22,
	BTRFS_SEND_C_FALLOCATE = 23,
	BTRFS_SEND_C_FILEATTR = 24,
	BTRFS_SEND_C_ENCODED_WRITE = 25,
	BTRFS_SEND_C_MAX_V2 = 25,
	BTRFS_SEND_C_ENABLE_VERITY = 26,
	BTRFS_SEND_C_MAX_V3 = 26,
	BTRFS_SEND_C_MAX = 26,
};

enum btrfs_subpage_type {
	BTRFS_SUBPAGE_METADATA = 0,
	BTRFS_SUBPAGE_DATA = 1,
};

enum btrfs_trans_state {
	TRANS_STATE_RUNNING = 0,
	TRANS_STATE_COMMIT_PREP = 1,
	TRANS_STATE_COMMIT_START = 2,
	TRANS_STATE_COMMIT_DOING = 3,
	TRANS_STATE_UNBLOCKED = 4,
	TRANS_STATE_SUPER_COMMITTED = 5,
	TRANS_STATE_COMPLETED = 6,
	TRANS_STATE_MAX = 7,
};

enum btrfs_tree_block_status {
	BTRFS_TREE_BLOCK_CLEAN = 0,
	BTRFS_TREE_BLOCK_INVALID_NRITEMS = 1,
	BTRFS_TREE_BLOCK_INVALID_PARENT_KEY = 2,
	BTRFS_TREE_BLOCK_BAD_KEY_ORDER = 3,
	BTRFS_TREE_BLOCK_INVALID_LEVEL = 4,
	BTRFS_TREE_BLOCK_INVALID_FREE_SPACE = 5,
	BTRFS_TREE_BLOCK_INVALID_OFFSETS = 6,
	BTRFS_TREE_BLOCK_INVALID_BLOCKPTR = 7,
	BTRFS_TREE_BLOCK_INVALID_ITEM = 8,
	BTRFS_TREE_BLOCK_INVALID_OWNER = 9,
	BTRFS_TREE_BLOCK_WRITTEN_NOT_SET = 10,
};

enum btrfs_trim_state {
	BTRFS_TRIM_STATE_UNTRIMMED = 0,
	BTRFS_TRIM_STATE_TRIMMED = 1,
	BTRFS_TRIM_STATE_TRIMMING = 2,
};

enum buddy {
	FIRST = 0,
	LAST = 1,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cb_command {
	cb_nop = 0,
	cb_iaaddr = 1,
	cb_config = 2,
	cb_multi = 3,
	cb_tx = 4,
	cb_ucode = 5,
	cb_dump = 6,
	cb_tx_sf = 8,
	cb_tx_nc = 16,
	cb_cid = 7936,
	cb_i = 8192,
	cb_s = 16384,
	cb_el = 32768,
};

enum cb_status {
	cb_complete = 32768,
	cb_ok = 8192,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cfg80211_assoc_req_flags {
	ASSOC_REQ_DISABLE_HT = 1,
	ASSOC_REQ_DISABLE_VHT = 2,
	ASSOC_REQ_USE_RRM = 4,
	CONNECT_REQ_EXTERNAL_AUTH_SUPPORT = 8,
	ASSOC_REQ_DISABLE_HE = 16,
	ASSOC_REQ_DISABLE_EHT = 32,
	CONNECT_REQ_MLO_SUPPORT = 64,
	ASSOC_REQ_SPP_AMSDU = 128,
};

enum cfg80211_bss_frame_type {
	CFG80211_BSS_FTYPE_UNKNOWN = 0,
	CFG80211_BSS_FTYPE_BEACON = 1,
	CFG80211_BSS_FTYPE_PRESP = 2,
	CFG80211_BSS_FTYPE_S1G_BEACON = 3,
};

enum cfg80211_connect_params_changed {
	UPDATE_ASSOC_IES = 1,
	UPDATE_FILS_ERP_INFO = 2,
	UPDATE_AUTH_TYPE = 4,
};

enum cfg80211_event_type {
	EVENT_CONNECT_RESULT = 0,
	EVENT_ROAMED = 1,
	EVENT_DISCONNECTED = 2,
	EVENT_IBSS_JOINED = 3,
	EVENT_STOPPED = 4,
	EVENT_PORT_AUTHORIZED = 5,
};

enum cfg80211_nan_conf_changes {
	CFG80211_NAN_CONF_CHANGED_PREF = 1,
	CFG80211_NAN_CONF_CHANGED_BANDS = 2,
};

enum cfg80211_rnr_iter_ret {
	RNR_ITER_CONTINUE = 0,
	RNR_ITER_BREAK = 1,
	RNR_ITER_ERROR = 2,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cfg80211_station_type {
	CFG80211_STA_AP_CLIENT = 0,
	CFG80211_STA_AP_CLIENT_UNASSOC = 1,
	CFG80211_STA_AP_MLME_CLIENT = 2,
	CFG80211_STA_AP_STA = 3,
	CFG80211_STA_IBSS = 4,
	CFG80211_STA_TDLS_PEER_SETUP = 5,
	CFG80211_STA_TDLS_PEER_ACTIVE = 6,
	CFG80211_STA_MESH_PEER_KERNEL = 7,
	CFG80211_STA_MESH_PEER_USER = 8,
};

enum cfi_mode {
	CFI_AUTO = 0,
	CFI_OFF = 1,
	CFI_KCFI = 2,
	CFI_FINEIBT = 3,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	pids_cgrp_id = 9,
	rdma_cgrp_id = 10,
	misc_cgrp_id = 11,
	debug_cgrp_id = 12,
	CGROUP_SUBSYS_COUNT = 13,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum check_states {
	check_state_idle = 0,
	check_state_run = 1,
	check_state_run_q = 2,
	check_state_run_pq = 3,
	check_state_check_result = 4,
	check_state_compute_run = 5,
	check_state_compute_result = 6,
};

enum cipher {
	CIPHER_NONE = 0,
	CIPHER_WEP64 = 1,
	CIPHER_WEP128 = 2,
	CIPHER_TKIP = 3,
	CIPHER_AES = 4,
	CIPHER_CKIP64 = 5,
	CIPHER_CKIP128 = 6,
	CIPHER_TKIP_NO_MIC = 7,
	CIPHER_MAX = 4,
};

enum cipher_flags {
	CRYPT_MODE_INTEGRITY_AEAD = 0,
	CRYPT_IV_LARGE_SECTORS = 1,
	CRYPT_ENCRYPT_PREPROCESS = 2,
	CRYPT_KEY_MAC_SIZE_SET = 3,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum cntl_msg_types {
	IPCTNL_MSG_CT_NEW = 0,
	IPCTNL_MSG_CT_GET = 1,
	IPCTNL_MSG_CT_DELETE = 2,
	IPCTNL_MSG_CT_GET_CTRZERO = 3,
	IPCTNL_MSG_CT_GET_STATS_CPU = 4,
	IPCTNL_MSG_CT_GET_STATS = 5,
	IPCTNL_MSG_CT_GET_DYING = 6,
	IPCTNL_MSG_CT_GET_UNCONFIRMED = 7,
	IPCTNL_MSG_MAX = 8,
};

enum coex_algorithm {
	COEX_ALGO_NOPROFILE = 0,
	COEX_ALGO_HFP = 1,
	COEX_ALGO_HID = 2,
	COEX_ALGO_A2DP = 3,
	COEX_ALGO_PAN = 4,
	COEX_ALGO_A2DP_HID = 5,
	COEX_ALGO_A2DP_PAN = 6,
	COEX_ALGO_PAN_HID = 7,
	COEX_ALGO_A2DP_PAN_HID = 8,
	COEX_ALGO_MAX = 9,
};

enum coex_bt_profile {
	BPM_NOPROFILE = 0,
	BPM_HFP = 1,
	BPM_HID = 2,
	BPM_A2DP = 4,
	BPM_PAN = 8,
	BPM_HID_HFP = 3,
	BPM_A2DP_HFP = 5,
	BPM_A2DP_HID = 6,
	BPM_A2DP_HID_HFP = 7,
	BPM_PAN_HFP = 9,
	BPM_PAN_HID = 10,
	BPM_PAN_HID_HFP = 11,
	BPM_PAN_A2DP = 12,
	BPM_PAN_A2DP_HFP = 13,
	BPM_PAN_A2DP_HID = 14,
	BPM_PAN_A2DP_HID_HFP = 15,
};

enum coex_bt_status {
	COEX_BTSTATUS_NCON_IDLE = 0,
	COEX_BTSTATUS_CON_IDLE = 1,
	COEX_BTSTATUS_INQ_PAGE = 2,
	COEX_BTSTATUS_ACL_BUSY = 3,
	COEX_BTSTATUS_SCO_BUSY = 4,
	COEX_BTSTATUS_ACL_SCO_BUSY = 5,
	COEX_BTSTATUS_MAX = 6,
};

enum coex_btrssi_type {
	COEX_BTRSSI_RATIO = 0,
	COEX_BTRSSI_DBM = 1,
	COEX_BTRSSI_MAX = 2,
};

enum coex_ext_ant_switch_ctrl_type {
	COEX_SWITCH_CTRL_BY_BBSW = 0,
	COEX_SWITCH_CTRL_BY_PTA = 1,
	COEX_SWITCH_CTRL_BY_ANTDIV = 2,
	COEX_SWITCH_CTRL_BY_MAC = 3,
	COEX_SWITCH_CTRL_BY_BT = 4,
	COEX_SWITCH_CTRL_BY_FW = 5,
	COEX_SWITCH_CTRL_MAX = 6,
};

enum coex_ext_ant_switch_pos_type {
	COEX_SWITCH_TO_BT = 0,
	COEX_SWITCH_TO_WLG = 1,
	COEX_SWITCH_TO_WLA = 2,
	COEX_SWITCH_TO_NOCARE = 3,
	COEX_SWITCH_TO_WLG_BT = 4,
	COEX_SWITCH_TO_MAX = 5,
};

enum coex_gnt_setup_state {
	COEX_GNT_SET_HW_PTA = 0,
	COEX_GNT_SET_SW_LOW = 1,
	COEX_GNT_SET_SW_HIGH = 3,
};

enum coex_mp_info_op {
	BT_MP_INFO_OP_PATCH_VER = 0,
	BT_MP_INFO_OP_READ_REG = 17,
	BT_MP_INFO_OP_SUPP_FEAT = 42,
	BT_MP_INFO_OP_SUPP_VER = 43,
	BT_MP_INFO_OP_SCAN_TYPE = 45,
	BT_MP_INFO_OP_LNA_CONSTRAINT = 50,
};

enum coex_notify_type_associate {
	COEX_ASSOCIATE_FINISH = 0,
	COEX_ASSOCIATE_START = 1,
	COEX_ASSOCIATE_5G_FINISH = 2,
	COEX_ASSOCIATE_5G_START = 3,
};

enum coex_notify_type_ips {
	COEX_IPS_LEAVE = 0,
	COEX_IPS_ENTER = 1,
};

enum coex_notify_type_lps {
	COEX_LPS_DISABLE = 0,
	COEX_LPS_ENABLE = 1,
};

enum coex_notify_type_media_status {
	COEX_MEDIA_DISCONNECT = 0,
	COEX_MEDIA_CONNECT = 1,
	COEX_MEDIA_CONNECT_5G = 2,
};

enum coex_notify_type_scan {
	COEX_SCAN_FINISH = 0,
	COEX_SCAN_START = 1,
	COEX_SCAN_START_2G = 2,
	COEX_SCAN_START_5G = 3,
};

enum coex_notify_type_switchband {
	COEX_NOT_SWITCH = 0,
	COEX_SWITCH_TO_24G = 1,
	COEX_SWITCH_TO_5G = 2,
	COEX_SWITCH_TO_24G_NOFORSCAN = 3,
};

enum coex_power_save_type {
	COEX_PS_WIFI_NATIVE = 0,
	COEX_PS_LPS_ON = 1,
	COEX_PS_LPS_OFF = 2,
};

enum coex_pstdma_type {
	COEX_PSTDMA_FORCE_LPSOFF = 0,
	COEX_PSTDMA_FORCE_LPSON = 1,
	COEX_PSTDMA_MAX = 2,
};

enum coex_rssi_state {
	COEX_RSSI_STATE_HIGH = 0,
	COEX_RSSI_STATE_MEDIUM = 1,
	COEX_RSSI_STATE_LOW = 2,
	COEX_RSSI_STATE_STAY_HIGH = 3,
	COEX_RSSI_STATE_STAY_MEDIUM = 4,
	COEX_RSSI_STATE_STAY_LOW = 5,
};

enum coex_runreason {
	COEX_RSN_2GSCANSTART = 0,
	COEX_RSN_5GSCANSTART = 1,
	COEX_RSN_SCANFINISH = 2,
	COEX_RSN_2GSWITCHBAND = 3,
	COEX_RSN_5GSWITCHBAND = 4,
	COEX_RSN_2GCONSTART = 5,
	COEX_RSN_5GCONSTART = 6,
	COEX_RSN_2GCONFINISH = 7,
	COEX_RSN_5GCONFINISH = 8,
	COEX_RSN_2GMEDIA = 9,
	COEX_RSN_5GMEDIA = 10,
	COEX_RSN_MEDIADISCON = 11,
	COEX_RSN_BTINFO = 12,
	COEX_RSN_LPS = 13,
	COEX_RSN_WLSTATUS = 14,
	COEX_RSN_BTSTATUS = 15,
	COEX_RSN_MAX = 16,
};

enum coex_set_ant_phase {
	COEX_SET_ANT_INIT = 0,
	COEX_SET_ANT_WONLY = 1,
	COEX_SET_ANT_WOFF = 2,
	COEX_SET_ANT_2G = 3,
	COEX_SET_ANT_5G = 4,
	COEX_SET_ANT_POWERON = 5,
	COEX_SET_ANT_2G_WLBT = 6,
	COEX_SET_ANT_2G_FREERUN = 7,
	COEX_SET_ANT_MAX = 8,
};

enum coex_wl2bt_scoreboard {
	COEX_SCBD_ACTIVE = 1,
	COEX_SCBD_ONOFF = 2,
	COEX_SCBD_SCAN = 4,
	COEX_SCBD_UNDERTEST = 8,
	COEX_SCBD_RXGAIN = 16,
	COEX_SCBD_BT_RFK = 32,
	COEX_SCBD_WLBUSY = 64,
	COEX_SCBD_EXTFEM = 256,
	COEX_SCBD_TDMA = 512,
	COEX_SCBD_FIX2M = 1024,
	COEX_SCBD_ALL = 65535,
};

enum coex_wl_link_mode {
	COEX_WLINK_2G1PORT = 0,
	COEX_WLINK_5G = 3,
	COEX_WLINK_2GFREE = 7,
	COEX_WLINK_MAX = 8,
};

enum coex_wl_priority_mask {
	COEX_WLPRI_RX_RSP = 2,
	COEX_WLPRI_TX_RSP = 3,
	COEX_WLPRI_TX_BEACON = 4,
	COEX_WLPRI_TX_OFDM = 11,
	COEX_WLPRI_TX_CCK = 12,
	COEX_WLPRI_TX_BEACONQ = 27,
	COEX_WLPRI_RX_CCK = 28,
	COEX_WLPRI_RX_OFDM = 29,
	COEX_WLPRI_MAX = 30,
};

enum coex_wl_tput_dir {
	COEX_WL_TPUT_TX = 0,
	COEX_WL_TPUT_RX = 1,
	COEX_WL_TPUT_MAX = 2,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum context {
	IN_KERNEL = 1,
	IN_USER = 2,
	IN_KERNEL_RECOV = 3,
};

enum cp_error_code {
	CP_EC = 32767,
	CP_RET = 1,
	CP_IRET = 2,
	CP_ENDBR = 3,
	CP_RSTRORSSP = 4,
	CP_SETSSBSY = 5,
	CP_ENCL = 32768,
};

enum cpa_warn {
	CPA_CONFLICT = 0,
	CPA_PROTECT = 1,
	CPA_DETECT = 2,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_MCE_DEAD = 8,
	CPUHP_VIRT_NET_DEAD = 9,
	CPUHP_IBMVNIC_DEAD = 10,
	CPUHP_SLUB_DEAD = 11,
	CPUHP_DEBUG_OBJ_DEAD = 12,
	CPUHP_MM_WRITEBACK_DEAD = 13,
	CPUHP_MM_VMSTAT_DEAD = 14,
	CPUHP_SOFTIRQ_DEAD = 15,
	CPUHP_NET_MVNETA_DEAD = 16,
	CPUHP_CPUIDLE_DEAD = 17,
	CPUHP_ARM64_FPSIMD_DEAD = 18,
	CPUHP_ARM_OMAP_WAKE_DEAD = 19,
	CPUHP_IRQ_POLL_DEAD = 20,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 21,
	CPUHP_BIO_DEAD = 22,
	CPUHP_ACPI_CPUDRV_DEAD = 23,
	CPUHP_S390_PFAULT_DEAD = 24,
	CPUHP_BLK_MQ_DEAD = 25,
	CPUHP_FS_BUFF_DEAD = 26,
	CPUHP_PRINTK_DEAD = 27,
	CPUHP_MM_MEMCQ_DEAD = 28,
	CPUHP_PERCPU_CNT_DEAD = 29,
	CPUHP_RADIX_DEAD = 30,
	CPUHP_PAGE_ALLOC = 31,
	CPUHP_NET_DEV_DEAD = 32,
	CPUHP_PCI_XGENE_DEAD = 33,
	CPUHP_IOMMU_IOVA_DEAD = 34,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 35,
	CPUHP_PADATA_DEAD = 36,
	CPUHP_AP_DTPM_CPU_DEAD = 37,
	CPUHP_RANDOM_PREPARE = 38,
	CPUHP_WORKQUEUE_PREP = 39,
	CPUHP_POWER_NUMA_PREPARE = 40,
	CPUHP_HRTIMERS_PREPARE = 41,
	CPUHP_X2APIC_PREPARE = 42,
	CPUHP_SMPCFD_PREPARE = 43,
	CPUHP_RELAY_PREPARE = 44,
	CPUHP_MD_RAID5_PREPARE = 45,
	CPUHP_RCUTREE_PREP = 46,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 47,
	CPUHP_POWERPC_PMAC_PREPARE = 48,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 49,
	CPUHP_XEN_PREPARE = 50,
	CPUHP_XEN_EVTCHN_PREPARE = 51,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 52,
	CPUHP_SH_SH3X_PREPARE = 53,
	CPUHP_TOPOLOGY_PREPARE = 54,
	CPUHP_NET_IUCV_PREPARE = 55,
	CPUHP_ARM_BL_PREPARE = 56,
	CPUHP_TRACE_RB_PREPARE = 57,
	CPUHP_MM_ZS_PREPARE = 58,
	CPUHP_MM_ZSWP_POOL_PREPARE = 59,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 60,
	CPUHP_ZCOMP_PREPARE = 61,
	CPUHP_TIMERS_PREPARE = 62,
	CPUHP_TMIGR_PREPARE = 63,
	CPUHP_MIPS_SOC_PREPARE = 64,
	CPUHP_BP_PREPARE_DYN = 65,
	CPUHP_BP_PREPARE_DYN_END = 85,
	CPUHP_BP_KICK_AP = 86,
	CPUHP_BRINGUP_CPU = 87,
	CPUHP_AP_IDLE_DEAD = 88,
	CPUHP_AP_OFFLINE = 89,
	CPUHP_AP_CACHECTRL_STARTING = 90,
	CPUHP_AP_SCHED_STARTING = 91,
	CPUHP_AP_RCUTREE_DYING = 92,
	CPUHP_AP_CPU_PM_STARTING = 93,
	CPUHP_AP_IRQ_GIC_STARTING = 94,
	CPUHP_AP_IRQ_HIP04_STARTING = 95,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 96,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 97,
	CPUHP_AP_IRQ_BCM2836_STARTING = 98,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 99,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 100,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 101,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 102,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 103,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 104,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 105,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 106,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 107,
	CPUHP_AP_PERF_X86_STARTING = 108,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 109,
	CPUHP_AP_PERF_XTENSA_STARTING = 110,
	CPUHP_AP_ARM_VFP_STARTING = 111,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 112,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 113,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 114,
	CPUHP_AP_PERF_ARM_STARTING = 115,
	CPUHP_AP_PERF_RISCV_STARTING = 116,
	CPUHP_AP_ARM_L2X0_STARTING = 117,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 118,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 119,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 120,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 121,
	CPUHP_AP_JCORE_TIMER_STARTING = 122,
	CPUHP_AP_ARM_TWD_STARTING = 123,
	CPUHP_AP_QCOM_TIMER_STARTING = 124,
	CPUHP_AP_TEGRA_TIMER_STARTING = 125,
	CPUHP_AP_ARMADA_TIMER_STARTING = 126,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 127,
	CPUHP_AP_ARC_TIMER_STARTING = 128,
	CPUHP_AP_REALTEK_TIMER_STARTING = 129,
	CPUHP_AP_RISCV_TIMER_STARTING = 130,
	CPUHP_AP_CLINT_TIMER_STARTING = 131,
	CPUHP_AP_CSKY_TIMER_STARTING = 132,
	CPUHP_AP_TI_GP_TIMER_STARTING = 133,
	CPUHP_AP_HYPERV_TIMER_STARTING = 134,
	CPUHP_AP_DUMMY_TIMER_STARTING = 135,
	CPUHP_AP_ARM_XEN_STARTING = 136,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 137,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 138,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 139,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 140,
	CPUHP_AP_SMPCFD_DYING = 141,
	CPUHP_AP_HRTIMERS_DYING = 142,
	CPUHP_AP_TICK_DYING = 143,
	CPUHP_AP_X86_TBOOT_DYING = 144,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 145,
	CPUHP_AP_ONLINE = 146,
	CPUHP_TEARDOWN_CPU = 147,
	CPUHP_AP_ONLINE_IDLE = 148,
	CPUHP_AP_HYPERV_ONLINE = 149,
	CPUHP_AP_KVM_ONLINE = 150,
	CPUHP_AP_SCHED_WAIT_EMPTY = 151,
	CPUHP_AP_SMPBOOT_THREADS = 152,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 153,
	CPUHP_AP_BLK_MQ_ONLINE = 154,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 155,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 156,
	CPUHP_AP_PERF_ONLINE = 157,
	CPUHP_AP_PERF_X86_ONLINE = 158,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 159,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 160,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 161,
	CPUHP_AP_PERF_S390_CF_ONLINE = 162,
	CPUHP_AP_PERF_S390_SF_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 164,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 173,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 175,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 176,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 179,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 185,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 186,
	CPUHP_AP_PERF_CSKY_ONLINE = 187,
	CPUHP_AP_TMIGR_ONLINE = 188,
	CPUHP_AP_WATCHDOG_ONLINE = 189,
	CPUHP_AP_WORKQUEUE_ONLINE = 190,
	CPUHP_AP_RANDOM_ONLINE = 191,
	CPUHP_AP_RCUTREE_ONLINE = 192,
	CPUHP_AP_KTHREADS_ONLINE = 193,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 194,
	CPUHP_AP_ONLINE_DYN = 195,
	CPUHP_AP_ONLINE_DYN_END = 235,
	CPUHP_AP_X86_HPET_ONLINE = 236,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 237,
	CPUHP_AP_ACTIVE = 238,
	CPUHP_ONLINE = 239,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum cpuid_leafs {
	CPUID_1_EDX = 0,
	CPUID_8000_0001_EDX = 1,
	CPUID_8086_0001_EDX = 2,
	CPUID_LNX_1 = 3,
	CPUID_1_ECX = 4,
	CPUID_C000_0001_EDX = 5,
	CPUID_8000_0001_ECX = 6,
	CPUID_LNX_2 = 7,
	CPUID_LNX_3 = 8,
	CPUID_7_0_EBX = 9,
	CPUID_D_1_EAX = 10,
	CPUID_LNX_4 = 11,
	CPUID_7_1_EAX = 12,
	CPUID_8000_0008_EBX = 13,
	CPUID_6_EAX = 14,
	CPUID_8000_000A_EDX = 15,
	CPUID_7_ECX = 16,
	CPUID_8000_0007_EBX = 17,
	CPUID_7_EDX = 18,
	CPUID_8000_001F_EAX = 19,
	CPUID_8000_0021_EAX = 20,
	CPUID_LNX_5 = 21,
	NR_CPUID_WORDS = 22,
};

enum cpuid_regs_idx {
	CPUID_EAX = 0,
	CPUID_EBX = 1,
	CPUID_ECX = 2,
	CPUID_EDX = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum csi_seg_len {
	HAL_CSI_SEG_4K = 0,
	HAL_CSI_SEG_8K = 1,
	HAL_CSI_SEG_11K = 2,
};

enum ctattr_counters {
	CTA_COUNTERS_UNSPEC = 0,
	CTA_COUNTERS_PACKETS = 1,
	CTA_COUNTERS_BYTES = 2,
	CTA_COUNTERS32_PACKETS = 3,
	CTA_COUNTERS32_BYTES = 4,
	CTA_COUNTERS_PAD = 5,
	__CTA_COUNTERS_MAX = 6,
};

enum ctattr_expect {
	CTA_EXPECT_UNSPEC = 0,
	CTA_EXPECT_MASTER = 1,
	CTA_EXPECT_TUPLE = 2,
	CTA_EXPECT_MASK = 3,
	CTA_EXPECT_TIMEOUT = 4,
	CTA_EXPECT_ID = 5,
	CTA_EXPECT_HELP_NAME = 6,
	CTA_EXPECT_ZONE = 7,
	CTA_EXPECT_FLAGS = 8,
	CTA_EXPECT_CLASS = 9,
	CTA_EXPECT_NAT = 10,
	CTA_EXPECT_FN = 11,
	__CTA_EXPECT_MAX = 12,
};

enum ctattr_expect_nat {
	CTA_EXPECT_NAT_UNSPEC = 0,
	CTA_EXPECT_NAT_DIR = 1,
	CTA_EXPECT_NAT_TUPLE = 2,
	__CTA_EXPECT_NAT_MAX = 3,
};

enum ctattr_expect_stats {
	CTA_STATS_EXP_UNSPEC = 0,
	CTA_STATS_EXP_NEW = 1,
	CTA_STATS_EXP_CREATE = 2,
	CTA_STATS_EXP_DELETE = 3,
	__CTA_STATS_EXP_MAX = 4,
};

enum ctattr_filter {
	CTA_FILTER_UNSPEC = 0,
	CTA_FILTER_ORIG_FLAGS = 1,
	CTA_FILTER_REPLY_FLAGS = 2,
	__CTA_FILTER_MAX = 3,
};

enum ctattr_help {
	CTA_HELP_UNSPEC = 0,
	CTA_HELP_NAME = 1,
	CTA_HELP_INFO = 2,
	__CTA_HELP_MAX = 3,
};

enum ctattr_ip {
	CTA_IP_UNSPEC = 0,
	CTA_IP_V4_SRC = 1,
	CTA_IP_V4_DST = 2,
	CTA_IP_V6_SRC = 3,
	CTA_IP_V6_DST = 4,
	__CTA_IP_MAX = 5,
};

enum ctattr_l4proto {
	CTA_PROTO_UNSPEC = 0,
	CTA_PROTO_NUM = 1,
	CTA_PROTO_SRC_PORT = 2,
	CTA_PROTO_DST_PORT = 3,
	CTA_PROTO_ICMP_ID = 4,
	CTA_PROTO_ICMP_TYPE = 5,
	CTA_PROTO_ICMP_CODE = 6,
	CTA_PROTO_ICMPV6_ID = 7,
	CTA_PROTO_ICMPV6_TYPE = 8,
	CTA_PROTO_ICMPV6_CODE = 9,
	__CTA_PROTO_MAX = 10,
};

enum ctattr_nat {
	CTA_NAT_UNSPEC = 0,
	CTA_NAT_V4_MINIP = 1,
	CTA_NAT_V4_MAXIP = 2,
	CTA_NAT_PROTO = 3,
	CTA_NAT_V6_MINIP = 4,
	CTA_NAT_V6_MAXIP = 5,
	__CTA_NAT_MAX = 6,
};

enum ctattr_protoinfo {
	CTA_PROTOINFO_UNSPEC = 0,
	CTA_PROTOINFO_TCP = 1,
	CTA_PROTOINFO_DCCP = 2,
	CTA_PROTOINFO_SCTP = 3,
	__CTA_PROTOINFO_MAX = 4,
};

enum ctattr_protoinfo_tcp {
	CTA_PROTOINFO_TCP_UNSPEC = 0,
	CTA_PROTOINFO_TCP_STATE = 1,
	CTA_PROTOINFO_TCP_WSCALE_ORIGINAL = 2,
	CTA_PROTOINFO_TCP_WSCALE_REPLY = 3,
	CTA_PROTOINFO_TCP_FLAGS_ORIGINAL = 4,
	CTA_PROTOINFO_TCP_FLAGS_REPLY = 5,
	__CTA_PROTOINFO_TCP_MAX = 6,
};

enum ctattr_protonat {
	CTA_PROTONAT_UNSPEC = 0,
	CTA_PROTONAT_PORT_MIN = 1,
	CTA_PROTONAT_PORT_MAX = 2,
	__CTA_PROTONAT_MAX = 3,
};

enum ctattr_seqadj {
	CTA_SEQADJ_UNSPEC = 0,
	CTA_SEQADJ_CORRECTION_POS = 1,
	CTA_SEQADJ_OFFSET_BEFORE = 2,
	CTA_SEQADJ_OFFSET_AFTER = 3,
	__CTA_SEQADJ_MAX = 4,
};

enum ctattr_stats_cpu {
	CTA_STATS_UNSPEC = 0,
	CTA_STATS_SEARCHED = 1,
	CTA_STATS_FOUND = 2,
	CTA_STATS_NEW = 3,
	CTA_STATS_INVALID = 4,
	CTA_STATS_IGNORE = 5,
	CTA_STATS_DELETE = 6,
	CTA_STATS_DELETE_LIST = 7,
	CTA_STATS_INSERT = 8,
	CTA_STATS_INSERT_FAILED = 9,
	CTA_STATS_DROP = 10,
	CTA_STATS_EARLY_DROP = 11,
	CTA_STATS_ERROR = 12,
	CTA_STATS_SEARCH_RESTART = 13,
	CTA_STATS_CLASH_RESOLVE = 14,
	CTA_STATS_CHAIN_TOOLONG = 15,
	__CTA_STATS_MAX = 16,
};

enum ctattr_stats_global {
	CTA_STATS_GLOBAL_UNSPEC = 0,
	CTA_STATS_GLOBAL_ENTRIES = 1,
	CTA_STATS_GLOBAL_MAX_ENTRIES = 2,
	__CTA_STATS_GLOBAL_MAX = 3,
};

enum ctattr_synproxy {
	CTA_SYNPROXY_UNSPEC = 0,
	CTA_SYNPROXY_ISN = 1,
	CTA_SYNPROXY_ITS = 2,
	CTA_SYNPROXY_TSOFF = 3,
	__CTA_SYNPROXY_MAX = 4,
};

enum ctattr_tstamp {
	CTA_TIMESTAMP_UNSPEC = 0,
	CTA_TIMESTAMP_START = 1,
	CTA_TIMESTAMP_STOP = 2,
	CTA_TIMESTAMP_PAD = 3,
	__CTA_TIMESTAMP_MAX = 4,
};

enum ctattr_tuple {
	CTA_TUPLE_UNSPEC = 0,
	CTA_TUPLE_IP = 1,
	CTA_TUPLE_PROTO = 2,
	CTA_TUPLE_ZONE = 3,
	__CTA_TUPLE_MAX = 4,
};

enum ctattr_type {
	CTA_UNSPEC = 0,
	CTA_TUPLE_ORIG = 1,
	CTA_TUPLE_REPLY = 2,
	CTA_STATUS = 3,
	CTA_PROTOINFO = 4,
	CTA_HELP = 5,
	CTA_NAT_SRC = 6,
	CTA_TIMEOUT = 7,
	CTA_MARK = 8,
	CTA_COUNTERS_ORIG = 9,
	CTA_COUNTERS_REPLY = 10,
	CTA_USE = 11,
	CTA_ID = 12,
	CTA_NAT_DST = 13,
	CTA_TUPLE_MASTER = 14,
	CTA_SEQ_ADJ_ORIG = 15,
	CTA_NAT_SEQ_ADJ_ORIG = 15,
	CTA_SEQ_ADJ_REPLY = 16,
	CTA_NAT_SEQ_ADJ_REPLY = 16,
	CTA_SECMARK = 17,
	CTA_ZONE = 18,
	CTA_SECCTX = 19,
	CTA_TIMESTAMP = 20,
	CTA_MARK_MASK = 21,
	CTA_LABELS = 22,
	CTA_LABELS_MASK = 23,
	CTA_SYNPROXY = 24,
	CTA_FILTER = 25,
	CTA_STATUS_MASK = 26,
	CTA_TIMESTAMP_EVENT = 27,
	__CTA_MAX = 28,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctnl_exp_msg_types {
	IPCTNL_MSG_EXP_NEW = 0,
	IPCTNL_MSG_EXP_GET = 1,
	IPCTNL_MSG_EXP_DELETE = 2,
	IPCTNL_MSG_EXP_GET_STATS_CPU = 3,
	IPCTNL_MSG_EXP_MAX = 4,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cuc_dump {
	cuc_dump_complete = 40965,
	cuc_dump_reset_complete = 40967,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum data_queue_flags {
	QUEUE_STARTED = 0,
	QUEUE_PAUSED = 1,
};

enum data_queue_qid {
	QID_AC_VO = 0,
	QID_AC_VI = 1,
	QID_AC_BE = 2,
	QID_AC_BK = 3,
	QID_HCCA = 4,
	QID_MGMT = 13,
	QID_RX = 14,
	QID_OTHER = 15,
	QID_BEACON = 16,
	QID_ATIM = 17,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dccp_pkt_type {
	DCCP_PKT_REQUEST = 0,
	DCCP_PKT_RESPONSE = 1,
	DCCP_PKT_DATA = 2,
	DCCP_PKT_ACK = 3,
	DCCP_PKT_DATAACK = 4,
	DCCP_PKT_CLOSEREQ = 5,
	DCCP_PKT_CLOSE = 6,
	DCCP_PKT_RESET = 7,
	DCCP_PKT_SYNC = 8,
	DCCP_PKT_SYNCACK = 9,
	DCCP_PKT_INVALID = 10,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_state {
	STATE_DEEP_SLEEP = 0,
	STATE_SLEEP = 1,
	STATE_STANDBY = 2,
	STATE_AWAKE = 3,
	STATE_RADIO_ON = 4,
	STATE_RADIO_OFF = 5,
	STATE_RADIO_IRQ_ON = 6,
	STATE_RADIO_IRQ_OFF = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum die_val {
	DIE_OOPS = 1,
	DIE_INT3 = 2,
	DIE_DEBUG = 3,
	DIE_PANIC = 4,
	DIE_NMI = 5,
	DIE_DIE = 6,
	DIE_KERNELDEBUG = 7,
	DIE_TRAP = 8,
	DIE_GPF = 9,
	DIE_CALL = 10,
	DIE_PAGE_FAULT = 11,
	DIE_NMIUNKNOWN = 12,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dm_io_mem_type {
	DM_IO_PAGE_LIST = 0,
	DM_IO_BIO = 1,
	DM_IO_VMA = 2,
	DM_IO_KMEM = 3,
};

enum dm_queue_mode {
	DM_TYPE_NONE = 0,
	DM_TYPE_BIO_BASED = 1,
	DM_TYPE_REQUEST_BASED = 2,
	DM_TYPE_DAX_BIO_BASED = 3,
};

enum dm_uevent_type {
	DM_UEVENT_PATH_FAILED = 0,
	DM_UEVENT_PATH_REINSTATED = 1,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum e1000_1000t_rx_status {
	e1000_1000t_rx_status_not_ok___2 = 0,
	e1000_1000t_rx_status_ok___2 = 1,
	e1000_1000t_rx_status_undefined___2 = 255,
};

enum e1000_bus_speed {
	e1000_bus_speed_unknown___2 = 0,
	e1000_bus_speed_33___2 = 1,
	e1000_bus_speed_66___2 = 2,
	e1000_bus_speed_100___2 = 3,
	e1000_bus_speed_120___2 = 4,
	e1000_bus_speed_133___2 = 5,
	e1000_bus_speed_2500 = 6,
	e1000_bus_speed_5000 = 7,
	e1000_bus_speed_reserved___2 = 8,
};

enum e1000_bus_type {
	e1000_bus_type_unknown___2 = 0,
	e1000_bus_type_pci___2 = 1,
	e1000_bus_type_pcix___2 = 2,
	e1000_bus_type_pci_express = 3,
	e1000_bus_type_reserved___2 = 4,
};

enum e1000_bus_width {
	e1000_bus_width_unknown___2 = 0,
	e1000_bus_width_pcie_x1 = 1,
	e1000_bus_width_pcie_x2 = 2,
	e1000_bus_width_pcie_x4 = 4,
	e1000_bus_width_pcie_x8 = 8,
	e1000_bus_width_32___2 = 9,
	e1000_bus_width_64___2 = 10,
	e1000_bus_width_reserved___2 = 11,
};

enum e1000_fc_mode {
	e1000_fc_none = 0,
	e1000_fc_rx_pause = 1,
	e1000_fc_tx_pause = 2,
	e1000_fc_full = 3,
	e1000_fc_default = 255,
};

enum e1000_mac_type {
	e1000_82571 = 0,
	e1000_82572 = 1,
	e1000_82573 = 2,
	e1000_82574 = 3,
	e1000_82583 = 4,
	e1000_80003es2lan = 5,
	e1000_ich8lan = 6,
	e1000_ich9lan = 7,
	e1000_ich10lan = 8,
	e1000_pchlan = 9,
	e1000_pch2lan = 10,
	e1000_pch_lpt = 11,
	e1000_pch_spt = 12,
	e1000_pch_cnp = 13,
	e1000_pch_tgp = 14,
	e1000_pch_adp = 15,
	e1000_pch_mtp = 16,
	e1000_pch_lnp = 17,
	e1000_pch_ptp = 18,
	e1000_pch_nvp = 19,
};

enum e1000_mac_type___2 {
	e1000_undefined___2 = 0,
	e1000_82575 = 1,
	e1000_82576 = 2,
	e1000_82580 = 3,
	e1000_i350 = 4,
	e1000_i354 = 5,
	e1000_i210 = 6,
	e1000_i211 = 7,
	e1000_num_macs___2 = 8,
};

enum e1000_media_type {
	e1000_media_type_unknown = 0,
	e1000_media_type_copper___2 = 1,
	e1000_media_type_fiber___2 = 2,
	e1000_media_type_internal_serdes___2 = 3,
	e1000_num_media_types___2 = 4,
};

enum e1000_mng_mode {
	e1000_mng_mode_none = 0,
	e1000_mng_mode_asf = 1,
	e1000_mng_mode_pt = 2,
	e1000_mng_mode_ipmi = 3,
	e1000_mng_mode_host_if_only = 4,
};

enum e1000_ms_type {
	e1000_ms_hw_default___2 = 0,
	e1000_ms_force_master___2 = 1,
	e1000_ms_force_slave___2 = 2,
	e1000_ms_auto___2 = 3,
};

enum e1000_nvm_override {
	e1000_nvm_override_none = 0,
	e1000_nvm_override_spi_small = 1,
	e1000_nvm_override_spi_large = 2,
};

enum e1000_nvm_type {
	e1000_nvm_unknown = 0,
	e1000_nvm_none = 1,
	e1000_nvm_eeprom_spi = 2,
	e1000_nvm_flash_hw = 3,
	e1000_nvm_invm = 4,
	e1000_nvm_flash_sw = 5,
};

enum e1000_nvm_type___2 {
	e1000_nvm_unknown___2 = 0,
	e1000_nvm_none___2 = 1,
	e1000_nvm_eeprom_spi___2 = 2,
	e1000_nvm_flash_hw___2 = 3,
	e1000_nvm_flash_sw___2 = 4,
};

enum e1000_phy_type {
	e1000_phy_unknown = 0,
	e1000_phy_none = 1,
	e1000_phy_m88___2 = 2,
	e1000_phy_igp___2 = 3,
	e1000_phy_igp_2 = 4,
	e1000_phy_gg82563 = 5,
	e1000_phy_igp_3 = 6,
	e1000_phy_ife = 7,
	e1000_phy_bm = 8,
	e1000_phy_82578 = 9,
	e1000_phy_82577 = 10,
	e1000_phy_82579 = 11,
	e1000_phy_i217 = 12,
};

enum e1000_phy_type___2 {
	e1000_phy_unknown___2 = 0,
	e1000_phy_none___2 = 1,
	e1000_phy_m88___3 = 2,
	e1000_phy_igp___3 = 3,
	e1000_phy_igp_2___2 = 4,
	e1000_phy_gg82563___2 = 5,
	e1000_phy_igp_3___2 = 6,
	e1000_phy_ife___2 = 7,
	e1000_phy_82580 = 8,
	e1000_phy_i210 = 9,
	e1000_phy_bcm54616 = 10,
};

enum e1000_rev_polarity {
	e1000_rev_polarity_normal___2 = 0,
	e1000_rev_polarity_reversed___2 = 1,
	e1000_rev_polarity_undefined___2 = 255,
};

enum e1000_ring_flags_t {
	IGB_RING_FLAG_RX_3K_BUFFER = 0,
	IGB_RING_FLAG_RX_BUILD_SKB_ENABLED = 1,
	IGB_RING_FLAG_RX_SCTP_CSUM = 2,
	IGB_RING_FLAG_RX_LB_VLAN_BSWAP = 3,
	IGB_RING_FLAG_TX_CTX_IDX = 4,
	IGB_RING_FLAG_TX_DETECT_HANG = 5,
	IGB_RING_FLAG_TX_DISABLED = 6,
};

enum e1000_serdes_link_state {
	e1000_serdes_link_down = 0,
	e1000_serdes_link_autoneg_progress = 1,
	e1000_serdes_link_autoneg_complete = 2,
	e1000_serdes_link_forced_up = 3,
};

enum e1000_smart_speed {
	e1000_smart_speed_default___2 = 0,
	e1000_smart_speed_on___2 = 1,
	e1000_smart_speed_off___2 = 2,
};

enum e1000_state_t {
	__E1000_TESTING = 0,
	__E1000_RESETTING = 1,
	__E1000_ACCESS_SHARED_RESOURCE = 2,
	__E1000_DOWN = 3,
};

enum e1000_state_t___2 {
	__E1000_TESTING___2 = 0,
	__E1000_RESETTING___2 = 1,
	__E1000_DOWN___2 = 2,
	__E1000_DISABLED = 3,
};

enum e1000_state_t___3 {
	__IGB_TESTING = 0,
	__IGB_RESETTING = 1,
	__IGB_DOWN = 2,
	__IGB_PTP_TX_IN_PROGRESS = 3,
};

enum e1000_ulp_state {
	e1000_ulp_state_unknown = 0,
	e1000_ulp_state_off = 1,
	e1000_ulp_state_on = 2,
};

enum e820_type {
	E820_TYPE_RAM = 1,
	E820_TYPE_RESERVED = 2,
	E820_TYPE_ACPI = 3,
	E820_TYPE_NVS = 4,
	E820_TYPE_UNUSABLE = 5,
	E820_TYPE_PMEM = 7,
	E820_TYPE_PRAM = 12,
	E820_TYPE_SOFT_RESERVED = 4026531839,
	E820_TYPE_RESERVED_KERN = 128,
};

enum ec_command {
	ACPI_EC_COMMAND_READ = 128,
	ACPI_EC_COMMAND_WRITE = 129,
	ACPI_EC_BURST_ENABLE = 130,
	ACPI_EC_BURST_DISABLE = 131,
	ACPI_EC_COMMAND_QUERY = 132,
};

enum eeprom_cnfg_mdix {
	eeprom_mdix_enabled = 128,
};

enum eeprom_config_asf {
	eeprom_asf = 32768,
	eeprom_gcl = 16384,
};

enum eeprom_ctrl_lo {
	eesk = 1,
	eecs = 2,
	eedi = 4,
	eedo = 8,
};

enum eeprom_id {
	eeprom_id_wol = 32,
};

enum eeprom_offsets {
	eeprom_cnfg_mdix = 3,
	eeprom_phy_iface = 6,
	eeprom_id = 10,
	eeprom_config_asf = 13,
	eeprom_smbus_addr = 144,
};

enum eeprom_op {
	op_write = 5,
	op_read = 6,
	op_ewds = 16,
	op_ewen = 19,
};

enum eeprom_phy_iface {
	NoSuchPhy = 0,
	I82553AB = 1,
	I82553C = 2,
	I82503 = 3,
	DP83840 = 4,
	S80C240 = 5,
	S80C24 = 6,
	I82555 = 7,
	DP83840A = 10,
};

enum eeprom_sku_bits {
	EEPROM_SKU_CAP_BAND_24GHZ = 16,
	EEPROM_SKU_CAP_BAND_52GHZ = 32,
	EEPROM_SKU_CAP_11N_ENABLE = 64,
	EEPROM_SKU_CAP_AMT_ENABLE = 128,
	EEPROM_SKU_CAP_IPAN_ENABLE = 256,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum energy_perf_value_index {
	EPB_INDEX_PERFORMANCE = 0,
	EPB_INDEX_BALANCE_PERFORMANCE = 1,
	EPB_INDEX_NORMAL = 2,
	EPB_INDEX_BALANCE_POWERSAVE = 3,
	EPB_INDEX_POWERSAVE = 4,
};

enum energy_perf_value_index___2 {
	EPP_INDEX_DEFAULT = 0,
	EPP_INDEX_PERFORMANCE = 1,
	EPP_INDEX_BALANCE_PERFORMANCE = 2,
	EPP_INDEX_BALANCE_POWERSAVE = 3,
	EPP_INDEX_POWERSAVE = 4,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 103,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_COUNT = 22,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception {
	EXCP_CONTEXT = 1,
	NO_EXCP = 2,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum ext_nvm_offsets {
	MAC_ADDRESS_OVERRIDE_EXT_NVM = 1,
	NVM_VERSION_EXT_NVM = 0,
	N_HW_ADDRS_FAMILY_8000 = 3,
	RADIO_CFG_FAMILY_EXT_NVM = 0,
	SKU_FAMILY_8000 = 2,
	NVM_CHANNELS_EXTENDED = 0,
	NVM_LAR_OFFSET_OLD = 1223,
	NVM_LAR_OFFSET = 1287,
	NVM_LAR_ENABLED = 7,
};

enum extra_reg_type {
	EXTRA_REG_NONE = -1,
	EXTRA_REG_RSP_0 = 0,
	EXTRA_REG_RSP_1 = 1,
	EXTRA_REG_LBR = 2,
	EXTRA_REG_LDLAT = 3,
	EXTRA_REG_FE = 4,
	EXTRA_REG_SNOOP_0 = 5,
	EXTRA_REG_SNOOP_1 = 6,
	EXTRA_REG_MAX = 7,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fib6_walk_state {
	FWS_L = 0,
	FWS_R = 1,
	FWS_C = 2,
	FWS_U = 3,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum field_op_id {
	FIELD_OP_NONE = 0,
	FIELD_OP_PLUS = 1,
	FIELD_OP_MINUS = 2,
	FIELD_OP_UNARY_MINUS = 3,
	FIELD_OP_DIV = 4,
	FIELD_OP_MULT = 5,
};

enum file_state {
	MEI_FILE_UNINITIALIZED = 0,
	MEI_FILE_INITIALIZING = 1,
	MEI_FILE_CONNECTING = 2,
	MEI_FILE_CONNECTED = 3,
	MEI_FILE_DISCONNECTING = 4,
	MEI_FILE_DISCONNECT_REPLY = 5,
	MEI_FILE_DISCONNECT_REQUIRED = 6,
	MEI_FILE_DISCONNECTED = 7,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum firmware_errors {
	FW_OK = 0,
	FW_BAD_CRC = 1,
	FW_BAD_LENGTH = 2,
	FW_BAD_VERSION = 3,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	VSYSCALL_PAGE = 511,
	FIX_DBGP_BASE = 512,
	FIX_EARLYCON_MEM_BASE = 513,
	FIX_APIC_BASE = 514,
	FIX_IO_APIC_BASE_0 = 515,
	FIX_IO_APIC_BASE_END = 642,
	__end_of_permanent_fixed_addresses = 643,
	FIX_BTMAP_END = 1024,
	FIX_BTMAP_BEGIN = 1535,
	__end_of_fixed_addresses = 1536,
};

enum flag_bits {
	Faulty = 0,
	In_sync = 1,
	Bitmap_sync = 2,
	WriteMostly = 3,
	AutoDetected = 4,
	Blocked = 5,
	WriteErrorSeen = 6,
	FaultRecorded = 7,
	BlockedBadBlocks = 8,
	WantReplacement = 9,
	Replacement = 10,
	Candidate = 11,
	Journal = 12,
	ClusterRemove = 13,
	ExternalBbl = 14,
	FailFast = 15,
	LastDev = 16,
	CollisionCheck = 17,
	Nonrot = 18,
};

enum flags {
	DM_CRYPT_SUSPENDED = 0,
	DM_CRYPT_KEY_VALID = 1,
	DM_CRYPT_SAME_CPU = 2,
	DM_CRYPT_HIGH_PRIORITY = 3,
	DM_CRYPT_NO_OFFLOAD = 4,
	DM_CRYPT_NO_READ_WORKQUEUE = 5,
	DM_CRYPT_NO_WRITE_WORKQUEUE = 6,
	DM_CRYPT_WRITE_INLINE = 7,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flow_offload_tuple_dir {
	FLOW_OFFLOAD_DIR_ORIGINAL = 0,
	FLOW_OFFLOAD_DIR_REPLY = 1,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_ERROR = 5,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

enum ftm_responder_stats_flags {
	FTM_RESP_STAT_NON_ASAP_STARTED = 1,
	FTM_RESP_STAT_NON_ASAP_IN_WIN = 2,
	FTM_RESP_STAT_NON_ASAP_OUT_WIN = 4,
	FTM_RESP_STAT_TRIGGER_DUP = 8,
	FTM_RESP_STAT_DUP = 16,
	FTM_RESP_STAT_DUP_IN_WIN = 32,
	FTM_RESP_STAT_DUP_OUT_WIN = 64,
	FTM_RESP_STAT_SCHED_SUCCESS = 128,
	FTM_RESP_STAT_ASAP_REQ = 256,
	FTM_RESP_STAT_NON_ASAP_REQ = 512,
	FTM_RESP_STAT_ASAP_RESP = 1024,
	FTM_RESP_STAT_NON_ASAP_RESP = 2048,
	FTM_RESP_STAT_FAIL_INITIATOR_INACTIVE = 4096,
	FTM_RESP_STAT_FAIL_INITIATOR_OUT_WIN = 8192,
	FTM_RESP_STAT_FAIL_INITIATOR_RETRY_LIM = 16384,
	FTM_RESP_STAT_FAIL_NEXT_SERVED = 32768,
	FTM_RESP_STAT_FAIL_TRIGGER_ERR = 65536,
	FTM_RESP_STAT_FAIL_GC = 131072,
	FTM_RESP_STAT_SUCCESS = 262144,
	FTM_RESP_STAT_INTEL_IE = 524288,
	FTM_RESP_STAT_INITIATOR_ACTIVE = 1048576,
	FTM_RESP_STAT_MEASUREMENTS_AVAILABLE = 2097152,
	FTM_RESP_STAT_TRIGGER_UNKNOWN = 4194304,
	FTM_RESP_STAT_PROCESS_FAIL = 8388608,
	FTM_RESP_STAT_ACK = 16777216,
	FTM_RESP_STAT_NACK = 33554432,
	FTM_RESP_STAT_INVALID_INITIATOR_ID = 67108864,
	FTM_RESP_STAT_TIMER_MIN_DELTA = 134217728,
	FTM_RESP_STAT_INITIATOR_REMOVED = 268435456,
	FTM_RESP_STAT_INITIATOR_ADDED = 536870912,
	FTM_RESP_STAT_ERR_LIST_FULL = 1073741824,
	FTM_RESP_STAT_INITIATOR_SCHED_NOW = 2147483648,
};

enum ftrace_bug_type {
	FTRACE_BUG_UNKNOWN = 0,
	FTRACE_BUG_INIT = 1,
	FTRACE_BUG_NOP = 2,
	FTRACE_BUG_CALL = 3,
	FTRACE_BUG_UPDATE = 4,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

enum fuse_dax_mode {
	FUSE_DAX_INODE_DEFAULT = 0,
	FUSE_DAX_ALWAYS = 1,
	FUSE_DAX_NEVER = 2,
	FUSE_DAX_INODE_USER = 3,
};

enum fuse_ext_type {
	FUSE_MAX_NR_SECCTX = 31,
	FUSE_EXT_GROUPS = 32,
};

enum fuse_notify_code {
	FUSE_NOTIFY_POLL = 1,
	FUSE_NOTIFY_INVAL_INODE = 2,
	FUSE_NOTIFY_INVAL_ENTRY = 3,
	FUSE_NOTIFY_STORE = 4,
	FUSE_NOTIFY_RETRIEVE = 5,
	FUSE_NOTIFY_DELETE = 6,
	FUSE_NOTIFY_RESEND = 7,
	FUSE_NOTIFY_CODE_MAX = 8,
};

enum fuse_opcode {
	FUSE_LOOKUP = 1,
	FUSE_FORGET = 2,
	FUSE_GETATTR = 3,
	FUSE_SETATTR = 4,
	FUSE_READLINK = 5,
	FUSE_SYMLINK = 6,
	FUSE_MKNOD = 8,
	FUSE_MKDIR = 9,
	FUSE_UNLINK = 10,
	FUSE_RMDIR = 11,
	FUSE_RENAME = 12,
	FUSE_LINK = 13,
	FUSE_OPEN = 14,
	FUSE_READ = 15,
	FUSE_WRITE = 16,
	FUSE_STATFS = 17,
	FUSE_RELEASE = 18,
	FUSE_FSYNC = 20,
	FUSE_SETXATTR = 21,
	FUSE_GETXATTR = 22,
	FUSE_LISTXATTR = 23,
	FUSE_REMOVEXATTR = 24,
	FUSE_FLUSH = 25,
	FUSE_INIT = 26,
	FUSE_OPENDIR = 27,
	FUSE_READDIR = 28,
	FUSE_RELEASEDIR = 29,
	FUSE_FSYNCDIR = 30,
	FUSE_GETLK = 31,
	FUSE_SETLK = 32,
	FUSE_SETLKW = 33,
	FUSE_ACCESS = 34,
	FUSE_CREATE = 35,
	FUSE_INTERRUPT = 36,
	FUSE_BMAP = 37,
	FUSE_DESTROY = 38,
	FUSE_IOCTL = 39,
	FUSE_POLL = 40,
	FUSE_NOTIFY_REPLY = 41,
	FUSE_BATCH_FORGET = 42,
	FUSE_FALLOCATE = 43,
	FUSE_READDIRPLUS = 44,
	FUSE_RENAME2 = 45,
	FUSE_LSEEK = 46,
	FUSE_COPY_FILE_RANGE = 47,
	FUSE_SETUPMAPPING = 48,
	FUSE_REMOVEMAPPING = 49,
	FUSE_SYNCFS = 50,
	FUSE_TMPFILE = 51,
	FUSE_STATX = 52,
	CUSE_INIT = 4096,
	CUSE_INIT_BSWAP_RESERVED = 1048576,
	FUSE_INIT_BSWAP_RESERVED = 436207616,
};

enum fuse_parse_result {
	FOUND_ERR = -1,
	FOUND_NONE = 0,
	FOUND_SOME = 1,
	FOUND_ALL = 2,
};

enum fuse_req_flag {
	FR_ISREPLY = 0,
	FR_FORCE = 1,
	FR_BACKGROUND = 2,
	FR_WAITING = 3,
	FR_ABORTED = 4,
	FR_INTERRUPTED = 5,
	FR_LOCKED = 6,
	FR_PENDING = 7,
	FR_SENT = 8,
	FR_FINISHED = 9,
	FR_PRIVATE = 10,
	FR_ASYNC = 11,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fwdb_flags {
	FWDB_FLAG_NO_OFDM = 1,
	FWDB_FLAG_NO_OUTDOOR = 2,
	FWDB_FLAG_DFS = 4,
	FWDB_FLAG_NO_IR = 8,
	FWDB_FLAG_AUTO_BW = 16,
};

enum gds_mitigations {
	GDS_MITIGATION_OFF = 0,
	GDS_MITIGATION_UCODE_NEEDED = 1,
	GDS_MITIGATION_FORCE = 2,
	GDS_MITIGATION_FULL = 3,
	GDS_MITIGATION_FULL_LOCKED = 4,
	GDS_MITIGATION_HYPERVISOR = 5,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum geo_type {
	geo_new = 0,
	geo_old = 1,
	geo_start = 2,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum graph_filter_type {
	GRAPH_FILTER_NOTRACE = 0,
	GRAPH_FILTER_FUNCTION = 1,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handler_id {
	HANDLER_ONMATCH = 1,
	HANDLER_ONMAX = 2,
	HANDLER_ONCHANGE = 3,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hbm_host_enum_flags {
	MEI_HBM_ENUM_F_ALLOW_ADD = 1,
	MEI_HBM_ENUM_F_IMMEDIATE_ENUM = 2,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hist_field_flags {
	HIST_FIELD_FL_HITCOUNT = 1,
	HIST_FIELD_FL_KEY = 2,
	HIST_FIELD_FL_STRING = 4,
	HIST_FIELD_FL_HEX = 8,
	HIST_FIELD_FL_SYM = 16,
	HIST_FIELD_FL_SYM_OFFSET = 32,
	HIST_FIELD_FL_EXECNAME = 64,
	HIST_FIELD_FL_SYSCALL = 128,
	HIST_FIELD_FL_STACKTRACE = 256,
	HIST_FIELD_FL_LOG2 = 512,
	HIST_FIELD_FL_TIMESTAMP = 1024,
	HIST_FIELD_FL_TIMESTAMP_USECS = 2048,
	HIST_FIELD_FL_VAR = 4096,
	HIST_FIELD_FL_EXPR = 8192,
	HIST_FIELD_FL_VAR_REF = 16384,
	HIST_FIELD_FL_CPU = 32768,
	HIST_FIELD_FL_ALIAS = 65536,
	HIST_FIELD_FL_BUCKET = 131072,
	HIST_FIELD_FL_CONST = 262144,
	HIST_FIELD_FL_PERCENT = 524288,
	HIST_FIELD_FL_GRAPH = 1048576,
};

enum hist_field_fn {
	HIST_FIELD_FN_NOP = 0,
	HIST_FIELD_FN_VAR_REF = 1,
	HIST_FIELD_FN_COUNTER = 2,
	HIST_FIELD_FN_CONST = 3,
	HIST_FIELD_FN_LOG2 = 4,
	HIST_FIELD_FN_BUCKET = 5,
	HIST_FIELD_FN_TIMESTAMP = 6,
	HIST_FIELD_FN_CPU = 7,
	HIST_FIELD_FN_STRING = 8,
	HIST_FIELD_FN_DYNSTRING = 9,
	HIST_FIELD_FN_RELDYNSTRING = 10,
	HIST_FIELD_FN_PSTRING = 11,
	HIST_FIELD_FN_S64 = 12,
	HIST_FIELD_FN_U64 = 13,
	HIST_FIELD_FN_S32 = 14,
	HIST_FIELD_FN_U32 = 15,
	HIST_FIELD_FN_S16 = 16,
	HIST_FIELD_FN_U16 = 17,
	HIST_FIELD_FN_S8 = 18,
	HIST_FIELD_FN_U8 = 19,
	HIST_FIELD_FN_UMINUS = 20,
	HIST_FIELD_FN_MINUS = 21,
	HIST_FIELD_FN_PLUS = 22,
	HIST_FIELD_FN_DIV = 23,
	HIST_FIELD_FN_MULT = 24,
	HIST_FIELD_FN_DIV_POWER2 = 25,
	HIST_FIELD_FN_DIV_NOT_POWER2 = 26,
	HIST_FIELD_FN_DIV_MULT_SHIFT = 27,
	HIST_FIELD_FN_EXECNAME = 28,
	HIST_FIELD_FN_STACK = 29,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hpet_mode {
	HPET_MODE_UNUSED = 0,
	HPET_MODE_LEGACY = 1,
	HPET_MODE_CLOCKEVT = 2,
	HPET_MODE_DEVICE = 3,
};

enum hprobe_state {
	HPROBE_LEASED = 0,
	HPROBE_STABLE = 1,
	HPROBE_GONE = 2,
	HPROBE_CONSUMED = 3,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_UNSPEC = 0,
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum hybrid_cpu_type {
	HYBRID_INTEL_NONE = 0,
	HYBRID_INTEL_ATOM = 32,
	HYBRID_INTEL_CORE = 64,
};

enum hybrid_pmu_type {
	not_hybrid = 0,
	hybrid_small = 1,
	hybrid_big = 2,
	hybrid_tiny = 4,
	hybrid_big_small = 3,
	hybrid_small_tiny = 5,
	hybrid_big_small_tiny = 7,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i8042_controller_reset_mode {
	I8042_RESET_NEVER = 0,
	I8042_RESET_ALWAYS = 1,
	I8042_RESET_ON_S2RAM = 2,
};

enum ibs_states {
	IBS_ENABLED = 0,
	IBS_STARTED = 1,
	IBS_STOPPING = 2,
	IBS_STOPPED = 3,
	IBS_MAX_STATES = 4,
};

enum idle_boot_override {
	IDLE_NO_OVERRIDE = 0,
	IDLE_HALT = 1,
	IDLE_NOMWAIT = 2,
	IDLE_POLL = 3,
};

enum ieee80211_ac_numbers {
	IEEE80211_AC_VO = 0,
	IEEE80211_AC_VI = 1,
	IEEE80211_AC_BE = 2,
	IEEE80211_AC_BK = 3,
};

enum ieee80211_agg_stop_reason {
	AGG_STOP_DECLINED = 0,
	AGG_STOP_LOCAL_REQUEST = 1,
	AGG_STOP_PEER_REQUEST = 2,
	AGG_STOP_DESTROY_STA = 3,
};

enum ieee80211_ampdu_mlme_action {
	IEEE80211_AMPDU_RX_START = 0,
	IEEE80211_AMPDU_RX_STOP = 1,
	IEEE80211_AMPDU_TX_START = 2,
	IEEE80211_AMPDU_TX_STOP_CONT = 3,
	IEEE80211_AMPDU_TX_STOP_FLUSH = 4,
	IEEE80211_AMPDU_TX_STOP_FLUSH_CONT = 5,
	IEEE80211_AMPDU_TX_OPERATIONAL = 6,
};

enum ieee80211_ap_reg_power {
	IEEE80211_REG_UNSET_AP = 0,
	IEEE80211_REG_LPI_AP = 1,
	IEEE80211_REG_SP_AP = 2,
	IEEE80211_REG_VLP_AP = 3,
};

enum ieee80211_back_actioncode {
	WLAN_ACTION_ADDBA_REQ = 0,
	WLAN_ACTION_ADDBA_RESP = 1,
	WLAN_ACTION_DELBA = 2,
};

enum ieee80211_back_parties {
	WLAN_BACK_RECIPIENT = 0,
	WLAN_BACK_INITIATOR = 1,
};

enum ieee80211_bss_change {
	BSS_CHANGED_ASSOC = 1ULL,
	BSS_CHANGED_ERP_CTS_PROT = 2ULL,
	BSS_CHANGED_ERP_PREAMBLE = 4ULL,
	BSS_CHANGED_ERP_SLOT = 8ULL,
	BSS_CHANGED_HT = 16ULL,
	BSS_CHANGED_BASIC_RATES = 32ULL,
	BSS_CHANGED_BEACON_INT = 64ULL,
	BSS_CHANGED_BSSID = 128ULL,
	BSS_CHANGED_BEACON = 256ULL,
	BSS_CHANGED_BEACON_ENABLED = 512ULL,
	BSS_CHANGED_CQM = 1024ULL,
	BSS_CHANGED_IBSS = 2048ULL,
	BSS_CHANGED_ARP_FILTER = 4096ULL,
	BSS_CHANGED_QOS = 8192ULL,
	BSS_CHANGED_IDLE = 16384ULL,
	BSS_CHANGED_SSID = 32768ULL,
	BSS_CHANGED_AP_PROBE_RESP = 65536ULL,
	BSS_CHANGED_PS = 131072ULL,
	BSS_CHANGED_TXPOWER = 262144ULL,
	BSS_CHANGED_P2P_PS = 524288ULL,
	BSS_CHANGED_BEACON_INFO = 1048576ULL,
	BSS_CHANGED_BANDWIDTH = 2097152ULL,
	BSS_CHANGED_OCB = 4194304ULL,
	BSS_CHANGED_MU_GROUPS = 8388608ULL,
	BSS_CHANGED_KEEP_ALIVE = 16777216ULL,
	BSS_CHANGED_MCAST_RATE = 33554432ULL,
	BSS_CHANGED_FTM_RESPONDER = 67108864ULL,
	BSS_CHANGED_TWT = 134217728ULL,
	BSS_CHANGED_HE_OBSS_PD = 268435456ULL,
	BSS_CHANGED_HE_BSS_COLOR = 536870912ULL,
	BSS_CHANGED_FILS_DISCOVERY = 1073741824ULL,
	BSS_CHANGED_UNSOL_BCAST_PROBE_RESP = 2147483648ULL,
	BSS_CHANGED_MLD_VALID_LINKS = 8589934592ULL,
	BSS_CHANGED_MLD_TTLM = 17179869184ULL,
	BSS_CHANGED_TPE = 34359738368ULL,
};

enum ieee80211_bss_corrupt_data_flags {
	IEEE80211_BSS_CORRUPT_BEACON = 1,
	IEEE80211_BSS_CORRUPT_PROBE_RESP = 2,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_bss_valid_data_flags {
	IEEE80211_BSS_VALID_WMM = 2,
	IEEE80211_BSS_VALID_RATES = 4,
	IEEE80211_BSS_VALID_ERP = 8,
};

enum ieee80211_category {
	WLAN_CATEGORY_SPECTRUM_MGMT = 0,
	WLAN_CATEGORY_QOS = 1,
	WLAN_CATEGORY_DLS = 2,
	WLAN_CATEGORY_BACK = 3,
	WLAN_CATEGORY_PUBLIC = 4,
	WLAN_CATEGORY_RADIO_MEASUREMENT = 5,
	WLAN_CATEGORY_FAST_BBS_TRANSITION = 6,
	WLAN_CATEGORY_HT = 7,
	WLAN_CATEGORY_SA_QUERY = 8,
	WLAN_CATEGORY_PROTECTED_DUAL_OF_ACTION = 9,
	WLAN_CATEGORY_WNM = 10,
	WLAN_CATEGORY_WNM_UNPROTECTED = 11,
	WLAN_CATEGORY_TDLS = 12,
	WLAN_CATEGORY_MESH_ACTION = 13,
	WLAN_CATEGORY_MULTIHOP_ACTION = 14,
	WLAN_CATEGORY_SELF_PROTECTED = 15,
	WLAN_CATEGORY_DMG = 16,
	WLAN_CATEGORY_WMM = 17,
	WLAN_CATEGORY_FST = 18,
	WLAN_CATEGORY_UNPROT_DMG = 20,
	WLAN_CATEGORY_VHT = 21,
	WLAN_CATEGORY_S1G = 22,
	WLAN_CATEGORY_PROTECTED_EHT = 37,
	WLAN_CATEGORY_VENDOR_SPECIFIC_PROTECTED = 126,
	WLAN_CATEGORY_VENDOR_SPECIFIC = 127,
};

enum ieee80211_chanctx_change {
	IEEE80211_CHANCTX_CHANGE_WIDTH = 1,
	IEEE80211_CHANCTX_CHANGE_RX_CHAINS = 2,
	IEEE80211_CHANCTX_CHANGE_RADAR = 4,
	IEEE80211_CHANCTX_CHANGE_CHANNEL = 8,
	IEEE80211_CHANCTX_CHANGE_MIN_DEF = 16,
	IEEE80211_CHANCTX_CHANGE_AP = 32,
	IEEE80211_CHANCTX_CHANGE_PUNCTURING = 64,
};

enum ieee80211_chanctx_mode {
	IEEE80211_CHANCTX_SHARED = 0,
	IEEE80211_CHANCTX_EXCLUSIVE = 1,
};

enum ieee80211_chanctx_replace_state {
	IEEE80211_CHANCTX_REPLACE_NONE = 0,
	IEEE80211_CHANCTX_WILL_BE_REPLACED = 1,
	IEEE80211_CHANCTX_REPLACES_OTHER = 2,
};

enum ieee80211_chanctx_switch_mode {
	CHANCTX_SWMODE_REASSIGN_VIF = 0,
	CHANCTX_SWMODE_SWAP_CONTEXTS = 1,
};

enum ieee80211_channel_flags {
	IEEE80211_CHAN_DISABLED = 1,
	IEEE80211_CHAN_NO_IR = 2,
	IEEE80211_CHAN_PSD = 4,
	IEEE80211_CHAN_RADAR = 8,
	IEEE80211_CHAN_NO_HT40PLUS = 16,
	IEEE80211_CHAN_NO_HT40MINUS = 32,
	IEEE80211_CHAN_NO_OFDM = 64,
	IEEE80211_CHAN_NO_80MHZ = 128,
	IEEE80211_CHAN_NO_160MHZ = 256,
	IEEE80211_CHAN_INDOOR_ONLY = 512,
	IEEE80211_CHAN_IR_CONCURRENT = 1024,
	IEEE80211_CHAN_NO_20MHZ = 2048,
	IEEE80211_CHAN_NO_10MHZ = 4096,
	IEEE80211_CHAN_NO_HE = 8192,
	IEEE80211_CHAN_1MHZ = 16384,
	IEEE80211_CHAN_2MHZ = 32768,
	IEEE80211_CHAN_4MHZ = 65536,
	IEEE80211_CHAN_8MHZ = 131072,
	IEEE80211_CHAN_16MHZ = 262144,
	IEEE80211_CHAN_NO_320MHZ = 524288,
	IEEE80211_CHAN_NO_EHT = 1048576,
	IEEE80211_CHAN_DFS_CONCURRENT = 2097152,
	IEEE80211_CHAN_NO_6GHZ_VLP_CLIENT = 4194304,
	IEEE80211_CHAN_NO_6GHZ_AFC_CLIENT = 8388608,
	IEEE80211_CHAN_CAN_MONITOR = 16777216,
	IEEE80211_CHAN_ALLOW_6GHZ_VLP_AP = 33554432,
};

enum ieee80211_conf_changed {
	IEEE80211_CONF_CHANGE_SMPS = 2,
	IEEE80211_CONF_CHANGE_LISTEN_INTERVAL = 4,
	IEEE80211_CONF_CHANGE_MONITOR = 8,
	IEEE80211_CONF_CHANGE_PS = 16,
	IEEE80211_CONF_CHANGE_POWER = 32,
	IEEE80211_CONF_CHANGE_CHANNEL = 64,
	IEEE80211_CONF_CHANGE_RETRY_LIMITS = 128,
	IEEE80211_CONF_CHANGE_IDLE = 256,
};

enum ieee80211_conf_flags {
	IEEE80211_CONF_MONITOR = 1,
	IEEE80211_CONF_PS = 2,
	IEEE80211_CONF_IDLE = 4,
	IEEE80211_CONF_OFFCHANNEL = 8,
};

enum ieee80211_conn_bw_limit {
	IEEE80211_CONN_BW_LIMIT_20 = 0,
	IEEE80211_CONN_BW_LIMIT_40 = 1,
	IEEE80211_CONN_BW_LIMIT_80 = 2,
	IEEE80211_CONN_BW_LIMIT_160 = 3,
	IEEE80211_CONN_BW_LIMIT_320 = 4,
};

enum ieee80211_conn_mode {
	IEEE80211_CONN_MODE_S1G = 0,
	IEEE80211_CONN_MODE_LEGACY = 1,
	IEEE80211_CONN_MODE_HT = 2,
	IEEE80211_CONN_MODE_VHT = 3,
	IEEE80211_CONN_MODE_HE = 4,
	IEEE80211_CONN_MODE_EHT = 5,
};

enum ieee80211_csa_source {
	IEEE80211_CSA_SOURCE_BEACON = 0,
	IEEE80211_CSA_SOURCE_OTHER_LINK = 1,
	IEEE80211_CSA_SOURCE_PROT_ACTION = 2,
	IEEE80211_CSA_SOURCE_UNPROT_ACTION = 3,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee80211_eid {
	WLAN_EID_SSID = 0,
	WLAN_EID_SUPP_RATES = 1,
	WLAN_EID_FH_PARAMS = 2,
	WLAN_EID_DS_PARAMS = 3,
	WLAN_EID_CF_PARAMS = 4,
	WLAN_EID_TIM = 5,
	WLAN_EID_IBSS_PARAMS = 6,
	WLAN_EID_COUNTRY = 7,
	WLAN_EID_REQUEST = 10,
	WLAN_EID_QBSS_LOAD = 11,
	WLAN_EID_EDCA_PARAM_SET = 12,
	WLAN_EID_TSPEC = 13,
	WLAN_EID_TCLAS = 14,
	WLAN_EID_SCHEDULE = 15,
	WLAN_EID_CHALLENGE = 16,
	WLAN_EID_PWR_CONSTRAINT = 32,
	WLAN_EID_PWR_CAPABILITY = 33,
	WLAN_EID_TPC_REQUEST = 34,
	WLAN_EID_TPC_REPORT = 35,
	WLAN_EID_SUPPORTED_CHANNELS = 36,
	WLAN_EID_CHANNEL_SWITCH = 37,
	WLAN_EID_MEASURE_REQUEST = 38,
	WLAN_EID_MEASURE_REPORT = 39,
	WLAN_EID_QUIET = 40,
	WLAN_EID_IBSS_DFS = 41,
	WLAN_EID_ERP_INFO = 42,
	WLAN_EID_TS_DELAY = 43,
	WLAN_EID_TCLAS_PROCESSING = 44,
	WLAN_EID_HT_CAPABILITY = 45,
	WLAN_EID_QOS_CAPA = 46,
	WLAN_EID_RSN = 48,
	WLAN_EID_802_15_COEX = 49,
	WLAN_EID_EXT_SUPP_RATES = 50,
	WLAN_EID_AP_CHAN_REPORT = 51,
	WLAN_EID_NEIGHBOR_REPORT = 52,
	WLAN_EID_RCPI = 53,
	WLAN_EID_MOBILITY_DOMAIN = 54,
	WLAN_EID_FAST_BSS_TRANSITION = 55,
	WLAN_EID_TIMEOUT_INTERVAL = 56,
	WLAN_EID_RIC_DATA = 57,
	WLAN_EID_DSE_REGISTERED_LOCATION = 58,
	WLAN_EID_SUPPORTED_REGULATORY_CLASSES = 59,
	WLAN_EID_EXT_CHANSWITCH_ANN = 60,
	WLAN_EID_HT_OPERATION = 61,
	WLAN_EID_SECONDARY_CHANNEL_OFFSET = 62,
	WLAN_EID_BSS_AVG_ACCESS_DELAY = 63,
	WLAN_EID_ANTENNA_INFO = 64,
	WLAN_EID_RSNI = 65,
	WLAN_EID_MEASUREMENT_PILOT_TX_INFO = 66,
	WLAN_EID_BSS_AVAILABLE_CAPACITY = 67,
	WLAN_EID_BSS_AC_ACCESS_DELAY = 68,
	WLAN_EID_TIME_ADVERTISEMENT = 69,
	WLAN_EID_RRM_ENABLED_CAPABILITIES = 70,
	WLAN_EID_MULTIPLE_BSSID = 71,
	WLAN_EID_BSS_COEX_2040 = 72,
	WLAN_EID_BSS_INTOLERANT_CHL_REPORT = 73,
	WLAN_EID_OVERLAP_BSS_SCAN_PARAM = 74,
	WLAN_EID_RIC_DESCRIPTOR = 75,
	WLAN_EID_MMIE = 76,
	WLAN_EID_ASSOC_COMEBACK_TIME = 77,
	WLAN_EID_EVENT_REQUEST = 78,
	WLAN_EID_EVENT_REPORT = 79,
	WLAN_EID_DIAGNOSTIC_REQUEST = 80,
	WLAN_EID_DIAGNOSTIC_REPORT = 81,
	WLAN_EID_LOCATION_PARAMS = 82,
	WLAN_EID_NON_TX_BSSID_CAP = 83,
	WLAN_EID_SSID_LIST = 84,
	WLAN_EID_MULTI_BSSID_IDX = 85,
	WLAN_EID_FMS_DESCRIPTOR = 86,
	WLAN_EID_FMS_REQUEST = 87,
	WLAN_EID_FMS_RESPONSE = 88,
	WLAN_EID_QOS_TRAFFIC_CAPA = 89,
	WLAN_EID_BSS_MAX_IDLE_PERIOD = 90,
	WLAN_EID_TSF_REQUEST = 91,
	WLAN_EID_TSF_RESPOSNE = 92,
	WLAN_EID_WNM_SLEEP_MODE = 93,
	WLAN_EID_TIM_BCAST_REQ = 94,
	WLAN_EID_TIM_BCAST_RESP = 95,
	WLAN_EID_COLL_IF_REPORT = 96,
	WLAN_EID_CHANNEL_USAGE = 97,
	WLAN_EID_TIME_ZONE = 98,
	WLAN_EID_DMS_REQUEST = 99,
	WLAN_EID_DMS_RESPONSE = 100,
	WLAN_EID_LINK_ID = 101,
	WLAN_EID_WAKEUP_SCHEDUL = 102,
	WLAN_EID_CHAN_SWITCH_TIMING = 104,
	WLAN_EID_PTI_CONTROL = 105,
	WLAN_EID_PU_BUFFER_STATUS = 106,
	WLAN_EID_INTERWORKING = 107,
	WLAN_EID_ADVERTISEMENT_PROTOCOL = 108,
	WLAN_EID_EXPEDITED_BW_REQ = 109,
	WLAN_EID_QOS_MAP_SET = 110,
	WLAN_EID_ROAMING_CONSORTIUM = 111,
	WLAN_EID_EMERGENCY_ALERT = 112,
	WLAN_EID_MESH_CONFIG = 113,
	WLAN_EID_MESH_ID = 114,
	WLAN_EID_LINK_METRIC_REPORT = 115,
	WLAN_EID_CONGESTION_NOTIFICATION = 116,
	WLAN_EID_PEER_MGMT = 117,
	WLAN_EID_CHAN_SWITCH_PARAM = 118,
	WLAN_EID_MESH_AWAKE_WINDOW = 119,
	WLAN_EID_BEACON_TIMING = 120,
	WLAN_EID_MCCAOP_SETUP_REQ = 121,
	WLAN_EID_MCCAOP_SETUP_RESP = 122,
	WLAN_EID_MCCAOP_ADVERT = 123,
	WLAN_EID_MCCAOP_TEARDOWN = 124,
	WLAN_EID_GANN = 125,
	WLAN_EID_RANN = 126,
	WLAN_EID_EXT_CAPABILITY = 127,
	WLAN_EID_PREQ = 130,
	WLAN_EID_PREP = 131,
	WLAN_EID_PERR = 132,
	WLAN_EID_PXU = 137,
	WLAN_EID_PXUC = 138,
	WLAN_EID_AUTH_MESH_PEER_EXCH = 139,
	WLAN_EID_MIC = 140,
	WLAN_EID_DESTINATION_URI = 141,
	WLAN_EID_UAPSD_COEX = 142,
	WLAN_EID_WAKEUP_SCHEDULE = 143,
	WLAN_EID_EXT_SCHEDULE = 144,
	WLAN_EID_STA_AVAILABILITY = 145,
	WLAN_EID_DMG_TSPEC = 146,
	WLAN_EID_DMG_AT = 147,
	WLAN_EID_DMG_CAP = 148,
	WLAN_EID_CISCO_VENDOR_SPECIFIC = 150,
	WLAN_EID_DMG_OPERATION = 151,
	WLAN_EID_DMG_BSS_PARAM_CHANGE = 152,
	WLAN_EID_DMG_BEAM_REFINEMENT = 153,
	WLAN_EID_CHANNEL_MEASURE_FEEDBACK = 154,
	WLAN_EID_AWAKE_WINDOW = 157,
	WLAN_EID_MULTI_BAND = 158,
	WLAN_EID_ADDBA_EXT = 159,
	WLAN_EID_NEXT_PCP_LIST = 160,
	WLAN_EID_PCP_HANDOVER = 161,
	WLAN_EID_DMG_LINK_MARGIN = 162,
	WLAN_EID_SWITCHING_STREAM = 163,
	WLAN_EID_SESSION_TRANSITION = 164,
	WLAN_EID_DYN_TONE_PAIRING_REPORT = 165,
	WLAN_EID_CLUSTER_REPORT = 166,
	WLAN_EID_RELAY_CAP = 167,
	WLAN_EID_RELAY_XFER_PARAM_SET = 168,
	WLAN_EID_BEAM_LINK_MAINT = 169,
	WLAN_EID_MULTIPLE_MAC_ADDR = 170,
	WLAN_EID_U_PID = 171,
	WLAN_EID_DMG_LINK_ADAPT_ACK = 172,
	WLAN_EID_MCCAOP_ADV_OVERVIEW = 174,
	WLAN_EID_QUIET_PERIOD_REQ = 175,
	WLAN_EID_QUIET_PERIOD_RESP = 177,
	WLAN_EID_EPAC_POLICY = 182,
	WLAN_EID_CLISTER_TIME_OFF = 183,
	WLAN_EID_INTER_AC_PRIO = 184,
	WLAN_EID_SCS_DESCRIPTOR = 185,
	WLAN_EID_QLOAD_REPORT = 186,
	WLAN_EID_HCCA_TXOP_UPDATE_COUNT = 187,
	WLAN_EID_HL_STREAM_ID = 188,
	WLAN_EID_GCR_GROUP_ADDR = 189,
	WLAN_EID_ANTENNA_SECTOR_ID_PATTERN = 190,
	WLAN_EID_VHT_CAPABILITY = 191,
	WLAN_EID_VHT_OPERATION = 192,
	WLAN_EID_EXTENDED_BSS_LOAD = 193,
	WLAN_EID_WIDE_BW_CHANNEL_SWITCH = 194,
	WLAN_EID_TX_POWER_ENVELOPE = 195,
	WLAN_EID_CHANNEL_SWITCH_WRAPPER = 196,
	WLAN_EID_AID = 197,
	WLAN_EID_QUIET_CHANNEL = 198,
	WLAN_EID_OPMODE_NOTIF = 199,
	WLAN_EID_REDUCED_NEIGHBOR_REPORT = 201,
	WLAN_EID_AID_REQUEST = 210,
	WLAN_EID_AID_RESPONSE = 211,
	WLAN_EID_S1G_BCN_COMPAT = 213,
	WLAN_EID_S1G_SHORT_BCN_INTERVAL = 214,
	WLAN_EID_S1G_TWT = 216,
	WLAN_EID_S1G_CAPABILITIES = 217,
	WLAN_EID_VENDOR_SPECIFIC = 221,
	WLAN_EID_QOS_PARAMETER = 222,
	WLAN_EID_S1G_OPERATION = 232,
	WLAN_EID_CAG_NUMBER = 237,
	WLAN_EID_AP_CSN = 239,
	WLAN_EID_FILS_INDICATION = 240,
	WLAN_EID_DILS = 241,
	WLAN_EID_FRAGMENT = 242,
	WLAN_EID_RSNX = 244,
	WLAN_EID_EXTENSION = 255,
};

enum ieee80211_eid_ext {
	WLAN_EID_EXT_ASSOC_DELAY_INFO = 1,
	WLAN_EID_EXT_FILS_REQ_PARAMS = 2,
	WLAN_EID_EXT_FILS_KEY_CONFIRM = 3,
	WLAN_EID_EXT_FILS_SESSION = 4,
	WLAN_EID_EXT_FILS_HLP_CONTAINER = 5,
	WLAN_EID_EXT_FILS_IP_ADDR_ASSIGN = 6,
	WLAN_EID_EXT_KEY_DELIVERY = 7,
	WLAN_EID_EXT_FILS_WRAPPED_DATA = 8,
	WLAN_EID_EXT_FILS_PUBLIC_KEY = 12,
	WLAN_EID_EXT_FILS_NONCE = 13,
	WLAN_EID_EXT_FUTURE_CHAN_GUIDANCE = 14,
	WLAN_EID_EXT_HE_CAPABILITY = 35,
	WLAN_EID_EXT_HE_OPERATION = 36,
	WLAN_EID_EXT_UORA = 37,
	WLAN_EID_EXT_HE_MU_EDCA = 38,
	WLAN_EID_EXT_HE_SPR = 39,
	WLAN_EID_EXT_NDP_FEEDBACK_REPORT_PARAMSET = 41,
	WLAN_EID_EXT_BSS_COLOR_CHG_ANN = 42,
	WLAN_EID_EXT_QUIET_TIME_PERIOD_SETUP = 43,
	WLAN_EID_EXT_ESS_REPORT = 45,
	WLAN_EID_EXT_OPS = 46,
	WLAN_EID_EXT_HE_BSS_LOAD = 47,
	WLAN_EID_EXT_MAX_CHANNEL_SWITCH_TIME = 52,
	WLAN_EID_EXT_MULTIPLE_BSSID_CONFIGURATION = 55,
	WLAN_EID_EXT_NON_INHERITANCE = 56,
	WLAN_EID_EXT_KNOWN_BSSID = 57,
	WLAN_EID_EXT_SHORT_SSID_LIST = 58,
	WLAN_EID_EXT_HE_6GHZ_CAPA = 59,
	WLAN_EID_EXT_UL_MU_POWER_CAPA = 60,
	WLAN_EID_EXT_EHT_OPERATION = 106,
	WLAN_EID_EXT_EHT_MULTI_LINK = 107,
	WLAN_EID_EXT_EHT_CAPABILITY = 108,
	WLAN_EID_EXT_TID_TO_LINK_MAPPING = 109,
	WLAN_EID_EXT_BANDWIDTH_INDICATION = 135,
};

enum ieee80211_elems_parse_error {
	IEEE80211_PARSE_ERR_INVALID_END = 1,
	IEEE80211_PARSE_ERR_DUP_ELEM = 2,
	IEEE80211_PARSE_ERR_BAD_ELEM_SIZE = 4,
	IEEE80211_PARSE_ERR_UNEXPECTED_ELEM = 8,
	IEEE80211_PARSE_ERR_DUP_NEST_ML_BASIC = 16,
};

enum ieee80211_encrypt {
	ENCRYPT_NO = 0,
	ENCRYPT_MGMT = 1,
	ENCRYPT_DATA = 2,
};

enum ieee80211_event_type {
	RSSI_EVENT = 0,
	MLME_EVENT = 1,
	BAR_RX_EVENT = 2,
	BA_FRAME_TIMEOUT = 3,
};

enum ieee80211_filter_flags {
	FIF_ALLMULTI = 2,
	FIF_FCSFAIL = 4,
	FIF_PLCPFAIL = 8,
	FIF_BCN_PRBRESP_PROMISC = 16,
	FIF_CONTROL = 32,
	FIF_OTHER_BSS = 64,
	FIF_PSPOLL = 128,
	FIF_PROBE_REQ = 256,
	FIF_MCAST_ACTION = 512,
};

enum ieee80211_frame_release_type {
	IEEE80211_FRAME_RELEASE_PSPOLL = 0,
	IEEE80211_FRAME_RELEASE_UAPSD = 1,
};

enum ieee80211_he_mcs_support {
	IEEE80211_HE_MCS_SUPPORT_0_7 = 0,
	IEEE80211_HE_MCS_SUPPORT_0_9 = 1,
	IEEE80211_HE_MCS_SUPPORT_0_11 = 2,
	IEEE80211_HE_MCS_NOT_SUPPORTED = 3,
};

enum ieee80211_ht_actioncode {
	WLAN_HT_ACTION_NOTIFY_CHANWIDTH = 0,
	WLAN_HT_ACTION_SMPS = 1,
	WLAN_HT_ACTION_PSMP = 2,
	WLAN_HT_ACTION_PCO_PHASE = 3,
	WLAN_HT_ACTION_CSI = 4,
	WLAN_HT_ACTION_NONCOMPRESSED_BF = 5,
	WLAN_HT_ACTION_COMPRESSED_BF = 6,
	WLAN_HT_ACTION_ASEL_IDX_FEEDBACK = 7,
};

enum ieee80211_ht_chanwidth_values {
	IEEE80211_HT_CHANWIDTH_20MHZ = 0,
	IEEE80211_HT_CHANWIDTH_ANY = 1,
};

enum ieee80211_hw_flags {
	IEEE80211_HW_HAS_RATE_CONTROL = 0,
	IEEE80211_HW_RX_INCLUDES_FCS = 1,
	IEEE80211_HW_HOST_BROADCAST_PS_BUFFERING = 2,
	IEEE80211_HW_SIGNAL_UNSPEC = 3,
	IEEE80211_HW_SIGNAL_DBM = 4,
	IEEE80211_HW_NEED_DTIM_BEFORE_ASSOC = 5,
	IEEE80211_HW_SPECTRUM_MGMT = 6,
	IEEE80211_HW_AMPDU_AGGREGATION = 7,
	IEEE80211_HW_SUPPORTS_PS = 8,
	IEEE80211_HW_PS_NULLFUNC_STACK = 9,
	IEEE80211_HW_SUPPORTS_DYNAMIC_PS = 10,
	IEEE80211_HW_MFP_CAPABLE = 11,
	IEEE80211_HW_WANT_MONITOR_VIF = 12,
	IEEE80211_HW_NO_VIRTUAL_MONITOR = 13,
	IEEE80211_HW_NO_AUTO_VIF = 14,
	IEEE80211_HW_SW_CRYPTO_CONTROL = 15,
	IEEE80211_HW_SUPPORT_FAST_XMIT = 16,
	IEEE80211_HW_REPORTS_TX_ACK_STATUS = 17,
	IEEE80211_HW_CONNECTION_MONITOR = 18,
	IEEE80211_HW_QUEUE_CONTROL = 19,
	IEEE80211_HW_SUPPORTS_PER_STA_GTK = 20,
	IEEE80211_HW_AP_LINK_PS = 21,
	IEEE80211_HW_TX_AMPDU_SETUP_IN_HW = 22,
	IEEE80211_HW_SUPPORTS_RC_TABLE = 23,
	IEEE80211_HW_P2P_DEV_ADDR_FOR_INTF = 24,
	IEEE80211_HW_TIMING_BEACON_ONLY = 25,
	IEEE80211_HW_SUPPORTS_HT_CCK_RATES = 26,
	IEEE80211_HW_CHANCTX_STA_CSA = 27,
	IEEE80211_HW_SUPPORTS_CLONED_SKBS = 28,
	IEEE80211_HW_SINGLE_SCAN_ON_ALL_BANDS = 29,
	IEEE80211_HW_TDLS_WIDER_BW = 30,
	IEEE80211_HW_SUPPORTS_AMSDU_IN_AMPDU = 31,
	IEEE80211_HW_BEACON_TX_STATUS = 32,
	IEEE80211_HW_NEEDS_UNIQUE_STA_ADDR = 33,
	IEEE80211_HW_SUPPORTS_REORDERING_BUFFER = 34,
	IEEE80211_HW_USES_RSS = 35,
	IEEE80211_HW_TX_AMSDU = 36,
	IEEE80211_HW_TX_FRAG_LIST = 37,
	IEEE80211_HW_REPORTS_LOW_ACK = 38,
	IEEE80211_HW_SUPPORTS_TX_FRAG = 39,
	IEEE80211_HW_SUPPORTS_TDLS_BUFFER_STA = 40,
	IEEE80211_HW_DOESNT_SUPPORT_QOS_NDP = 41,
	IEEE80211_HW_BUFF_MMPDU_TXQ = 42,
	IEEE80211_HW_SUPPORTS_VHT_EXT_NSS_BW = 43,
	IEEE80211_HW_STA_MMPDU_TXQ = 44,
	IEEE80211_HW_TX_STATUS_NO_AMPDU_LEN = 45,
	IEEE80211_HW_SUPPORTS_MULTI_BSSID = 46,
	IEEE80211_HW_SUPPORTS_ONLY_HE_MULTI_BSSID = 47,
	IEEE80211_HW_AMPDU_KEYBORDER_SUPPORT = 48,
	IEEE80211_HW_SUPPORTS_TX_ENCAP_OFFLOAD = 49,
	IEEE80211_HW_SUPPORTS_RX_DECAP_OFFLOAD = 50,
	IEEE80211_HW_SUPPORTS_CONC_MON_RX_DECAP = 51,
	IEEE80211_HW_DETECTS_COLOR_COLLISION = 52,
	IEEE80211_HW_MLO_MCAST_MULTI_LINK_TX = 53,
	IEEE80211_HW_DISALLOW_PUNCTURING = 54,
	IEEE80211_HW_DISALLOW_PUNCTURING_5GHZ = 55,
	IEEE80211_HW_HANDLES_QUIET_CSA = 56,
	NUM_IEEE80211_HW_FLAGS = 57,
};

enum ieee80211_idle_options {
	WLAN_IDLE_OPTIONS_PROTECTED_KEEP_ALIVE = 1,
};

enum ieee80211_interface_iteration_flags {
	IEEE80211_IFACE_ITER_NORMAL = 0,
	IEEE80211_IFACE_ITER_RESUME_ALL = 1,
	IEEE80211_IFACE_ITER_ACTIVE = 2,
	IEEE80211_IFACE_SKIP_SDATA_NOT_IN_DRIVER = 4,
};

enum ieee80211_internal_key_flags {
	KEY_FLAG_UPLOADED_TO_HARDWARE = 1,
	KEY_FLAG_TAINTED = 2,
};

enum ieee80211_internal_tkip_state {
	TKIP_STATE_NOT_INIT = 0,
	TKIP_STATE_PHASE1_DONE = 1,
	TKIP_STATE_PHASE1_HW_UPLOADED = 2,
};

enum ieee80211_key_flags {
	IEEE80211_KEY_FLAG_GENERATE_IV_MGMT = 1,
	IEEE80211_KEY_FLAG_GENERATE_IV = 2,
	IEEE80211_KEY_FLAG_GENERATE_MMIC = 4,
	IEEE80211_KEY_FLAG_PAIRWISE = 8,
	IEEE80211_KEY_FLAG_SW_MGMT_TX = 16,
	IEEE80211_KEY_FLAG_PUT_IV_SPACE = 32,
	IEEE80211_KEY_FLAG_RX_MGMT = 64,
	IEEE80211_KEY_FLAG_RESERVE_TAILROOM = 128,
	IEEE80211_KEY_FLAG_PUT_MIC_SPACE = 256,
	IEEE80211_KEY_FLAG_NO_AUTO_TX = 512,
	IEEE80211_KEY_FLAG_GENERATE_MMIE = 1024,
	IEEE80211_KEY_FLAG_SPP_AMSDU = 2048,
};

enum ieee80211_key_len {
	WLAN_KEY_LEN_WEP40 = 5,
	WLAN_KEY_LEN_WEP104 = 13,
	WLAN_KEY_LEN_CCMP = 16,
	WLAN_KEY_LEN_CCMP_256 = 32,
	WLAN_KEY_LEN_TKIP = 32,
	WLAN_KEY_LEN_AES_CMAC = 16,
	WLAN_KEY_LEN_SMS4 = 32,
	WLAN_KEY_LEN_GCMP = 16,
	WLAN_KEY_LEN_GCMP_256 = 32,
	WLAN_KEY_LEN_BIP_CMAC_256 = 32,
	WLAN_KEY_LEN_BIP_GMAC_128 = 16,
	WLAN_KEY_LEN_BIP_GMAC_256 = 32,
};

enum ieee80211_max_ampdu_length_exp {
	IEEE80211_HT_MAX_AMPDU_8K = 0,
	IEEE80211_HT_MAX_AMPDU_16K = 1,
	IEEE80211_HT_MAX_AMPDU_32K = 2,
	IEEE80211_HT_MAX_AMPDU_64K = 3,
};

enum ieee80211_max_queues {
	IEEE80211_MAX_QUEUES = 16,
	IEEE80211_MAX_QUEUE_MAP = 65535,
};

enum ieee80211_mesh_path_metric {
	IEEE80211_PATH_METRIC_AIRTIME = 1,
	IEEE80211_PATH_METRIC_VENDOR = 255,
};

enum ieee80211_mesh_path_protocol {
	IEEE80211_PATH_PROTOCOL_HWMP = 1,
	IEEE80211_PATH_PROTOCOL_VENDOR = 255,
};

enum ieee80211_mesh_sync_method {
	IEEE80211_SYNC_METHOD_NEIGHBOR_OFFSET = 1,
	IEEE80211_SYNC_METHOD_VENDOR = 255,
};

enum ieee80211_min_mpdu_spacing {
	IEEE80211_HT_MPDU_DENSITY_NONE = 0,
	IEEE80211_HT_MPDU_DENSITY_0_25 = 1,
	IEEE80211_HT_MPDU_DENSITY_0_5 = 2,
	IEEE80211_HT_MPDU_DENSITY_1 = 3,
	IEEE80211_HT_MPDU_DENSITY_2 = 4,
	IEEE80211_HT_MPDU_DENSITY_4 = 5,
	IEEE80211_HT_MPDU_DENSITY_8 = 6,
	IEEE80211_HT_MPDU_DENSITY_16 = 7,
};

enum ieee80211_mle_subelems {
	IEEE80211_MLE_SUBELEM_PER_STA_PROFILE = 0,
	IEEE80211_MLE_SUBELEM_FRAGMENT = 254,
};

enum ieee80211_mlme_event_data {
	AUTH_EVENT = 0,
	ASSOC_EVENT = 1,
	DEAUTH_RX_EVENT = 2,
	DEAUTH_TX_EVENT = 3,
};

enum ieee80211_mlme_event_status {
	MLME_SUCCESS = 0,
	MLME_DENIED = 1,
	MLME_TIMEOUT = 2,
};

enum ieee80211_neg_ttlm_res {
	NEG_TTLM_RES_ACCEPT = 0,
	NEG_TTLM_RES_REJECT = 1,
	NEG_TTLM_RES_SUGGEST_PREFERRED = 2,
};

enum ieee80211_offload_flags {
	IEEE80211_OFFLOAD_ENCAP_ENABLED = 1,
	IEEE80211_OFFLOAD_ENCAP_4ADDR = 2,
	IEEE80211_OFFLOAD_DECAP_ENABLED = 4,
};

enum ieee80211_p2p_attr_id {
	IEEE80211_P2P_ATTR_STATUS = 0,
	IEEE80211_P2P_ATTR_MINOR_REASON = 1,
	IEEE80211_P2P_ATTR_CAPABILITY = 2,
	IEEE80211_P2P_ATTR_DEVICE_ID = 3,
	IEEE80211_P2P_ATTR_GO_INTENT = 4,
	IEEE80211_P2P_ATTR_GO_CONFIG_TIMEOUT = 5,
	IEEE80211_P2P_ATTR_LISTEN_CHANNEL = 6,
	IEEE80211_P2P_ATTR_GROUP_BSSID = 7,
	IEEE80211_P2P_ATTR_EXT_LISTEN_TIMING = 8,
	IEEE80211_P2P_ATTR_INTENDED_IFACE_ADDR = 9,
	IEEE80211_P2P_ATTR_MANAGABILITY = 10,
	IEEE80211_P2P_ATTR_CHANNEL_LIST = 11,
	IEEE80211_P2P_ATTR_ABSENCE_NOTICE = 12,
	IEEE80211_P2P_ATTR_DEVICE_INFO = 13,
	IEEE80211_P2P_ATTR_GROUP_INFO = 14,
	IEEE80211_P2P_ATTR_GROUP_ID = 15,
	IEEE80211_P2P_ATTR_INTERFACE = 16,
	IEEE80211_P2P_ATTR_OPER_CHANNEL = 17,
	IEEE80211_P2P_ATTR_INVITE_FLAGS = 18,
	IEEE80211_P2P_ATTR_VENDOR_SPECIFIC = 221,
	IEEE80211_P2P_ATTR_MAX = 222,
};

enum ieee80211_packet_rx_flags {
	IEEE80211_RX_AMSDU = 8,
	IEEE80211_RX_MALFORMED_ACTION_FRM = 16,
	IEEE80211_RX_DEFERRED_RELEASE = 32,
};

enum ieee80211_privacy {
	IEEE80211_PRIVACY_ON = 0,
	IEEE80211_PRIVACY_OFF = 1,
	IEEE80211_PRIVACY_ANY = 2,
};

enum ieee80211_protected_eht_actioncode {
	WLAN_PROTECTED_EHT_ACTION_TTLM_REQ = 0,
	WLAN_PROTECTED_EHT_ACTION_TTLM_RES = 1,
	WLAN_PROTECTED_EHT_ACTION_TTLM_TEARDOWN = 2,
	WLAN_PROTECTED_EHT_ACTION_EPCS_ENABLE_REQ = 3,
	WLAN_PROTECTED_EHT_ACTION_EPCS_ENABLE_RESP = 4,
	WLAN_PROTECTED_EHT_ACTION_EPCS_ENABLE_TEARDOWN = 5,
	WLAN_PROTECTED_EHT_ACTION_EML_OP_MODE_NOTIF = 6,
	WLAN_PROTECTED_EHT_ACTION_LINK_RECOMMEND = 7,
	WLAN_PROTECTED_EHT_ACTION_ML_OP_UPDATE_REQ = 8,
	WLAN_PROTECTED_EHT_ACTION_ML_OP_UPDATE_RESP = 9,
	WLAN_PROTECTED_EHT_ACTION_LINK_RECONFIG_NOTIF = 10,
	WLAN_PROTECTED_EHT_ACTION_LINK_RECONFIG_REQ = 11,
	WLAN_PROTECTED_EHT_ACTION_LINK_RECONFIG_RESP = 12,
};

enum ieee80211_pub_actioncode {
	WLAN_PUB_ACTION_20_40_BSS_COEX = 0,
	WLAN_PUB_ACTION_DSE_ENABLEMENT = 1,
	WLAN_PUB_ACTION_DSE_DEENABLEMENT = 2,
	WLAN_PUB_ACTION_DSE_REG_LOC_ANN = 3,
	WLAN_PUB_ACTION_EXT_CHANSW_ANN = 4,
	WLAN_PUB_ACTION_DSE_MSMT_REQ = 5,
	WLAN_PUB_ACTION_DSE_MSMT_RESP = 6,
	WLAN_PUB_ACTION_MSMT_PILOT = 7,
	WLAN_PUB_ACTION_DSE_PC = 8,
	WLAN_PUB_ACTION_VENDOR_SPECIFIC = 9,
	WLAN_PUB_ACTION_GAS_INITIAL_REQ = 10,
	WLAN_PUB_ACTION_GAS_INITIAL_RESP = 11,
	WLAN_PUB_ACTION_GAS_COMEBACK_REQ = 12,
	WLAN_PUB_ACTION_GAS_COMEBACK_RESP = 13,
	WLAN_PUB_ACTION_TDLS_DISCOVER_RES = 14,
	WLAN_PUB_ACTION_LOC_TRACK_NOTI = 15,
	WLAN_PUB_ACTION_QAB_REQUEST_FRAME = 16,
	WLAN_PUB_ACTION_QAB_RESPONSE_FRAME = 17,
	WLAN_PUB_ACTION_QMF_POLICY = 18,
	WLAN_PUB_ACTION_QMF_POLICY_CHANGE = 19,
	WLAN_PUB_ACTION_QLOAD_REQUEST = 20,
	WLAN_PUB_ACTION_QLOAD_REPORT = 21,
	WLAN_PUB_ACTION_HCCA_TXOP_ADVERT = 22,
	WLAN_PUB_ACTION_HCCA_TXOP_RESPONSE = 23,
	WLAN_PUB_ACTION_PUBLIC_KEY = 24,
	WLAN_PUB_ACTION_CHANNEL_AVAIL_QUERY = 25,
	WLAN_PUB_ACTION_CHANNEL_SCHEDULE_MGMT = 26,
	WLAN_PUB_ACTION_CONTACT_VERI_SIGNAL = 27,
	WLAN_PUB_ACTION_GDD_ENABLEMENT_REQ = 28,
	WLAN_PUB_ACTION_GDD_ENABLEMENT_RESP = 29,
	WLAN_PUB_ACTION_NETWORK_CHANNEL_CONTROL = 30,
	WLAN_PUB_ACTION_WHITE_SPACE_MAP_ANN = 31,
	WLAN_PUB_ACTION_FTM_REQUEST = 32,
	WLAN_PUB_ACTION_FTM_RESPONSE = 33,
	WLAN_PUB_ACTION_FILS_DISCOVERY = 34,
};

enum ieee80211_radiotap_ampdu_flags {
	IEEE80211_RADIOTAP_AMPDU_REPORT_ZEROLEN = 1,
	IEEE80211_RADIOTAP_AMPDU_IS_ZEROLEN = 2,
	IEEE80211_RADIOTAP_AMPDU_LAST_KNOWN = 4,
	IEEE80211_RADIOTAP_AMPDU_IS_LAST = 8,
	IEEE80211_RADIOTAP_AMPDU_DELIM_CRC_ERR = 16,
	IEEE80211_RADIOTAP_AMPDU_DELIM_CRC_KNOWN = 32,
	IEEE80211_RADIOTAP_AMPDU_EOF = 64,
	IEEE80211_RADIOTAP_AMPDU_EOF_KNOWN = 128,
};

enum ieee80211_radiotap_channel_flags {
	IEEE80211_CHAN_CCK = 32,
	IEEE80211_CHAN_OFDM = 64,
	IEEE80211_CHAN_2GHZ = 128,
	IEEE80211_CHAN_5GHZ = 256,
	IEEE80211_CHAN_DYN = 1024,
	IEEE80211_CHAN_HALF = 16384,
	IEEE80211_CHAN_QUARTER = 32768,
};

enum ieee80211_radiotap_eht_data {
	IEEE80211_RADIOTAP_EHT_DATA0_SPATIAL_REUSE = 120,
	IEEE80211_RADIOTAP_EHT_DATA0_GI = 384,
	IEEE80211_RADIOTAP_EHT_DATA0_LTF = 1536,
	IEEE80211_RADIOTAP_EHT_DATA0_EHT_LTF = 14336,
	IEEE80211_RADIOTAP_EHT_DATA0_LDPC_EXTRA_SYM_OM = 16384,
	IEEE80211_RADIOTAP_EHT_DATA0_PRE_PADD_FACOR_OM = 98304,
	IEEE80211_RADIOTAP_EHT_DATA0_PE_DISAMBIGUITY_OM = 131072,
	IEEE80211_RADIOTAP_EHT_DATA0_DISREGARD_S = 786432,
	IEEE80211_RADIOTAP_EHT_DATA0_DISREGARD_O = 3932160,
	IEEE80211_RADIOTAP_EHT_DATA0_CRC1_O = 62914560,
	IEEE80211_RADIOTAP_EHT_DATA0_TAIL1_O = 4227858432,
	IEEE80211_RADIOTAP_EHT_DATA1_RU_SIZE = 31,
	IEEE80211_RADIOTAP_EHT_DATA1_RU_INDEX = 8160,
	IEEE80211_RADIOTAP_EHT_DATA1_RU_ALLOC_CC_1_1_1 = 4186112,
	IEEE80211_RADIOTAP_EHT_DATA1_RU_ALLOC_CC_1_1_1_KNOWN = 4194304,
	IEEE80211_RADIOTAP_EHT_DATA1_PRIMARY_80 = 3221225472,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_2_1_1 = 511,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_2_1_1_KNOWN = 512,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_1_1_2 = 523264,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_1_1_2_KNOWN = 524288,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_2_1_2 = 535822336,
	IEEE80211_RADIOTAP_EHT_DATA2_RU_ALLOC_CC_2_1_2_KNOWN = 536870912,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_1_2_1 = 511,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_1_2_1_KNOWN = 512,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_2_2_1 = 523264,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_2_2_1_KNOWN = 524288,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_1_2_2 = 535822336,
	IEEE80211_RADIOTAP_EHT_DATA3_RU_ALLOC_CC_1_2_2_KNOWN = 536870912,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_2_2_2 = 511,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_2_2_2_KNOWN = 512,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_1_2_3 = 523264,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_1_2_3_KNOWN = 524288,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_2_2_3 = 535822336,
	IEEE80211_RADIOTAP_EHT_DATA4_RU_ALLOC_CC_2_2_3_KNOWN = 536870912,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_1_2_4 = 511,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_1_2_4_KNOWN = 512,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_2_2_4 = 523264,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_2_2_4_KNOWN = 524288,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_1_2_5 = 535822336,
	IEEE80211_RADIOTAP_EHT_DATA5_RU_ALLOC_CC_1_2_5_KNOWN = 536870912,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_2_2_5 = 511,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_2_2_5_KNOWN = 512,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_1_2_6 = 523264,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_1_2_6_KNOWN = 524288,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_2_2_6 = 535822336,
	IEEE80211_RADIOTAP_EHT_DATA6_RU_ALLOC_CC_2_2_6_KNOWN = 536870912,
	IEEE80211_RADIOTAP_EHT_DATA7_CRC2_O = 15,
	IEEE80211_RADIOTAP_EHT_DATA7_TAIL_2_O = 1008,
	IEEE80211_RADIOTAP_EHT_DATA7_NSS_S = 61440,
	IEEE80211_RADIOTAP_EHT_DATA7_BEAMFORMED_S = 65536,
	IEEE80211_RADIOTAP_EHT_DATA7_NUM_OF_NON_OFDMA_USERS = 917504,
	IEEE80211_RADIOTAP_EHT_DATA7_USER_ENCODING_BLOCK_CRC = 15728640,
	IEEE80211_RADIOTAP_EHT_DATA7_USER_ENCODING_BLOCK_TAIL = 1056964608,
	IEEE80211_RADIOTAP_EHT_DATA8_RU_ALLOC_TB_FMT_PS_160 = 1,
	IEEE80211_RADIOTAP_EHT_DATA8_RU_ALLOC_TB_FMT_B0 = 2,
	IEEE80211_RADIOTAP_EHT_DATA8_RU_ALLOC_TB_FMT_B7_B1 = 508,
};

enum ieee80211_radiotap_eht_known {
	IEEE80211_RADIOTAP_EHT_KNOWN_SPATIAL_REUSE = 2,
	IEEE80211_RADIOTAP_EHT_KNOWN_GI = 4,
	IEEE80211_RADIOTAP_EHT_KNOWN_EHT_LTF = 16,
	IEEE80211_RADIOTAP_EHT_KNOWN_LDPC_EXTRA_SYM_OM = 32,
	IEEE80211_RADIOTAP_EHT_KNOWN_PRE_PADD_FACOR_OM = 64,
	IEEE80211_RADIOTAP_EHT_KNOWN_PE_DISAMBIGUITY_OM = 128,
	IEEE80211_RADIOTAP_EHT_KNOWN_DISREGARD_O = 256,
	IEEE80211_RADIOTAP_EHT_KNOWN_DISREGARD_S = 512,
	IEEE80211_RADIOTAP_EHT_KNOWN_CRC1 = 8192,
	IEEE80211_RADIOTAP_EHT_KNOWN_TAIL1 = 16384,
	IEEE80211_RADIOTAP_EHT_KNOWN_CRC2_O = 32768,
	IEEE80211_RADIOTAP_EHT_KNOWN_TAIL2_O = 65536,
	IEEE80211_RADIOTAP_EHT_KNOWN_NSS_S = 131072,
	IEEE80211_RADIOTAP_EHT_KNOWN_BEAMFORMED_S = 262144,
	IEEE80211_RADIOTAP_EHT_KNOWN_NR_NON_OFDMA_USERS_M = 524288,
	IEEE80211_RADIOTAP_EHT_KNOWN_ENCODING_BLOCK_CRC_M = 1048576,
	IEEE80211_RADIOTAP_EHT_KNOWN_ENCODING_BLOCK_TAIL_M = 2097152,
	IEEE80211_RADIOTAP_EHT_KNOWN_RU_MRU_SIZE_OM = 4194304,
	IEEE80211_RADIOTAP_EHT_KNOWN_RU_MRU_INDEX_OM = 8388608,
	IEEE80211_RADIOTAP_EHT_KNOWN_RU_ALLOC_TB_FMT = 16777216,
	IEEE80211_RADIOTAP_EHT_KNOWN_PRIMARY_80 = 33554432,
};

enum ieee80211_radiotap_eht_user_info {
	IEEE80211_RADIOTAP_EHT_USER_INFO_STA_ID_KNOWN = 1,
	IEEE80211_RADIOTAP_EHT_USER_INFO_MCS_KNOWN = 2,
	IEEE80211_RADIOTAP_EHT_USER_INFO_CODING_KNOWN = 4,
	IEEE80211_RADIOTAP_EHT_USER_INFO_NSS_KNOWN_O = 16,
	IEEE80211_RADIOTAP_EHT_USER_INFO_BEAMFORMING_KNOWN_O = 32,
	IEEE80211_RADIOTAP_EHT_USER_INFO_SPATIAL_CONFIG_KNOWN_M = 64,
	IEEE80211_RADIOTAP_EHT_USER_INFO_DATA_FOR_USER = 128,
	IEEE80211_RADIOTAP_EHT_USER_INFO_STA_ID = 524032,
	IEEE80211_RADIOTAP_EHT_USER_INFO_CODING = 524288,
	IEEE80211_RADIOTAP_EHT_USER_INFO_MCS = 15728640,
	IEEE80211_RADIOTAP_EHT_USER_INFO_NSS_O = 251658240,
	IEEE80211_RADIOTAP_EHT_USER_INFO_BEAMFORMING_O = 536870912,
	IEEE80211_RADIOTAP_EHT_USER_INFO_SPATIAL_CONFIG_M = 1056964608,
	IEEE80211_RADIOTAP_EHT_USER_INFO_RESEVED_c0000000 = 3221225472,
};

enum ieee80211_radiotap_eht_usig_common {
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_PHY_VER_KNOWN = 1,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_KNOWN = 2,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_UL_DL_KNOWN = 4,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BSS_COLOR_KNOWN = 8,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_TXOP_KNOWN = 16,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BAD_USIG_CRC = 32,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_VALIDATE_BITS_CHECKED = 64,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_VALIDATE_BITS_OK = 128,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_PHY_VER = 28672,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW = 229376,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_20MHZ = 0,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_40MHZ = 1,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_80MHZ = 2,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_160MHZ = 3,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_320MHZ_1 = 4,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BW_320MHZ_2 = 5,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_UL_DL = 262144,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_BSS_COLOR = 33030144,
	IEEE80211_RADIOTAP_EHT_USIG_COMMON_TXOP = 4261412864,
};

enum ieee80211_radiotap_eht_usig_mu {
	IEEE80211_RADIOTAP_EHT_USIG1_MU_B20_B24_DISREGARD = 31,
	IEEE80211_RADIOTAP_EHT_USIG1_MU_B25_VALIDATE = 32,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B0_B1_PPDU_TYPE = 192,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B2_VALIDATE = 256,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B3_B7_PUNCTURED_INFO = 15872,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B8_VALIDATE = 16384,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B9_B10_SIG_MCS = 98304,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B11_B15_EHT_SIG_SYMBOLS = 4063232,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B16_B19_CRC = 62914560,
	IEEE80211_RADIOTAP_EHT_USIG2_MU_B20_B25_TAIL = 4227858432,
};

enum ieee80211_radiotap_eht_usig_tb {
	IEEE80211_RADIOTAP_EHT_USIG1_TB_B20_B25_DISREGARD = 31,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B0_B1_PPDU_TYPE = 192,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B2_VALIDATE = 256,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B3_B6_SPATIAL_REUSE_1 = 7680,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B7_B10_SPATIAL_REUSE_2 = 122880,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B11_B15_DISREGARD = 4063232,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B16_B19_CRC = 62914560,
	IEEE80211_RADIOTAP_EHT_USIG2_TB_B20_B25_TAIL = 4227858432,
};

enum ieee80211_radiotap_flags {
	IEEE80211_RADIOTAP_F_CFP = 1,
	IEEE80211_RADIOTAP_F_SHORTPRE = 2,
	IEEE80211_RADIOTAP_F_WEP = 4,
	IEEE80211_RADIOTAP_F_FRAG = 8,
	IEEE80211_RADIOTAP_F_FCS = 16,
	IEEE80211_RADIOTAP_F_DATAPAD = 32,
	IEEE80211_RADIOTAP_F_BADFCS = 64,
};

enum ieee80211_radiotap_he_bits {
	IEEE80211_RADIOTAP_HE_DATA1_FORMAT_MASK = 3,
	IEEE80211_RADIOTAP_HE_DATA1_FORMAT_SU = 0,
	IEEE80211_RADIOTAP_HE_DATA1_FORMAT_EXT_SU = 1,
	IEEE80211_RADIOTAP_HE_DATA1_FORMAT_MU = 2,
	IEEE80211_RADIOTAP_HE_DATA1_FORMAT_TRIG = 3,
	IEEE80211_RADIOTAP_HE_DATA1_BSS_COLOR_KNOWN = 4,
	IEEE80211_RADIOTAP_HE_DATA1_BEAM_CHANGE_KNOWN = 8,
	IEEE80211_RADIOTAP_HE_DATA1_UL_DL_KNOWN = 16,
	IEEE80211_RADIOTAP_HE_DATA1_DATA_MCS_KNOWN = 32,
	IEEE80211_RADIOTAP_HE_DATA1_DATA_DCM_KNOWN = 64,
	IEEE80211_RADIOTAP_HE_DATA1_CODING_KNOWN = 128,
	IEEE80211_RADIOTAP_HE_DATA1_LDPC_XSYMSEG_KNOWN = 256,
	IEEE80211_RADIOTAP_HE_DATA1_STBC_KNOWN = 512,
	IEEE80211_RADIOTAP_HE_DATA1_SPTL_REUSE_KNOWN = 1024,
	IEEE80211_RADIOTAP_HE_DATA1_SPTL_REUSE2_KNOWN = 2048,
	IEEE80211_RADIOTAP_HE_DATA1_SPTL_REUSE3_KNOWN = 4096,
	IEEE80211_RADIOTAP_HE_DATA1_SPTL_REUSE4_KNOWN = 8192,
	IEEE80211_RADIOTAP_HE_DATA1_BW_RU_ALLOC_KNOWN = 16384,
	IEEE80211_RADIOTAP_HE_DATA1_DOPPLER_KNOWN = 32768,
	IEEE80211_RADIOTAP_HE_DATA2_PRISEC_80_KNOWN = 1,
	IEEE80211_RADIOTAP_HE_DATA2_GI_KNOWN = 2,
	IEEE80211_RADIOTAP_HE_DATA2_NUM_LTF_SYMS_KNOWN = 4,
	IEEE80211_RADIOTAP_HE_DATA2_PRE_FEC_PAD_KNOWN = 8,
	IEEE80211_RADIOTAP_HE_DATA2_TXBF_KNOWN = 16,
	IEEE80211_RADIOTAP_HE_DATA2_PE_DISAMBIG_KNOWN = 32,
	IEEE80211_RADIOTAP_HE_DATA2_TXOP_KNOWN = 64,
	IEEE80211_RADIOTAP_HE_DATA2_MIDAMBLE_KNOWN = 128,
	IEEE80211_RADIOTAP_HE_DATA2_RU_OFFSET = 16128,
	IEEE80211_RADIOTAP_HE_DATA2_RU_OFFSET_KNOWN = 16384,
	IEEE80211_RADIOTAP_HE_DATA2_PRISEC_80_SEC = 32768,
	IEEE80211_RADIOTAP_HE_DATA3_BSS_COLOR = 63,
	IEEE80211_RADIOTAP_HE_DATA3_BEAM_CHANGE = 64,
	IEEE80211_RADIOTAP_HE_DATA3_UL_DL = 128,
	IEEE80211_RADIOTAP_HE_DATA3_DATA_MCS = 3840,
	IEEE80211_RADIOTAP_HE_DATA3_DATA_DCM = 4096,
	IEEE80211_RADIOTAP_HE_DATA3_CODING = 8192,
	IEEE80211_RADIOTAP_HE_DATA3_LDPC_XSYMSEG = 16384,
	IEEE80211_RADIOTAP_HE_DATA3_STBC = 32768,
	IEEE80211_RADIOTAP_HE_DATA4_SU_MU_SPTL_REUSE = 15,
	IEEE80211_RADIOTAP_HE_DATA4_MU_STA_ID = 32752,
	IEEE80211_RADIOTAP_HE_DATA4_TB_SPTL_REUSE1 = 15,
	IEEE80211_RADIOTAP_HE_DATA4_TB_SPTL_REUSE2 = 240,
	IEEE80211_RADIOTAP_HE_DATA4_TB_SPTL_REUSE3 = 3840,
	IEEE80211_RADIOTAP_HE_DATA4_TB_SPTL_REUSE4 = 61440,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC = 15,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_20MHZ = 0,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_40MHZ = 1,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_80MHZ = 2,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_160MHZ = 3,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_26T = 4,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_52T = 5,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_106T = 6,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_242T = 7,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_484T = 8,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_996T = 9,
	IEEE80211_RADIOTAP_HE_DATA5_DATA_BW_RU_ALLOC_2x996T = 10,
	IEEE80211_RADIOTAP_HE_DATA5_GI = 48,
	IEEE80211_RADIOTAP_HE_DATA5_GI_0_8 = 0,
	IEEE80211_RADIOTAP_HE_DATA5_GI_1_6 = 1,
	IEEE80211_RADIOTAP_HE_DATA5_GI_3_2 = 2,
	IEEE80211_RADIOTAP_HE_DATA5_LTF_SIZE = 192,
	IEEE80211_RADIOTAP_HE_DATA5_LTF_SIZE_UNKNOWN = 0,
	IEEE80211_RADIOTAP_HE_DATA5_LTF_SIZE_1X = 1,
	IEEE80211_RADIOTAP_HE_DATA5_LTF_SIZE_2X = 2,
	IEEE80211_RADIOTAP_HE_DATA5_LTF_SIZE_4X = 3,
	IEEE80211_RADIOTAP_HE_DATA5_NUM_LTF_SYMS = 1792,
	IEEE80211_RADIOTAP_HE_DATA5_PRE_FEC_PAD = 12288,
	IEEE80211_RADIOTAP_HE_DATA5_TXBF = 16384,
	IEEE80211_RADIOTAP_HE_DATA5_PE_DISAMBIG = 32768,
	IEEE80211_RADIOTAP_HE_DATA6_NSTS = 15,
	IEEE80211_RADIOTAP_HE_DATA6_DOPPLER = 16,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW_KNOWN = 32,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW = 192,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW_20MHZ = 0,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW_40MHZ = 1,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW_80MHZ = 2,
	IEEE80211_RADIOTAP_HE_DATA6_TB_PPDU_BW_160MHZ = 3,
	IEEE80211_RADIOTAP_HE_DATA6_TXOP = 32512,
	IEEE80211_RADIOTAP_HE_DATA6_MIDAMBLE_PDCTY = 32768,
};

enum ieee80211_radiotap_he_mu_bits {
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_MCS = 15,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_MCS_KNOWN = 16,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_DCM = 32,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_DCM_KNOWN = 64,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_CH2_CTR_26T_RU_KNOWN = 128,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_CH1_RU_KNOWN = 256,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_CH2_RU_KNOWN = 512,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_CH1_CTR_26T_RU_KNOWN = 4096,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_CH1_CTR_26T_RU = 8192,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_COMP_KNOWN = 16384,
	IEEE80211_RADIOTAP_HE_MU_FLAGS1_SIG_B_SYMS_USERS_KNOWN = 32768,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW = 3,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW_20MHZ = 0,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW_40MHZ = 1,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW_80MHZ = 2,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW_160MHZ = 3,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_BW_FROM_SIG_A_BW_KNOWN = 4,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_SIG_B_COMP = 8,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_SIG_B_SYMS_USERS = 240,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_PUNC_FROM_SIG_A_BW = 768,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_PUNC_FROM_SIG_A_BW_KNOWN = 1024,
	IEEE80211_RADIOTAP_HE_MU_FLAGS2_CH2_CTR_26T_RU = 2048,
};

enum ieee80211_radiotap_lsig_data1 {
	IEEE80211_RADIOTAP_LSIG_DATA1_RATE_KNOWN = 1,
	IEEE80211_RADIOTAP_LSIG_DATA1_LENGTH_KNOWN = 2,
};

enum ieee80211_radiotap_lsig_data2 {
	IEEE80211_RADIOTAP_LSIG_DATA2_RATE = 15,
	IEEE80211_RADIOTAP_LSIG_DATA2_LENGTH = 65520,
};

enum ieee80211_radiotap_mcs_flags {
	IEEE80211_RADIOTAP_MCS_BW_MASK = 3,
	IEEE80211_RADIOTAP_MCS_BW_20 = 0,
	IEEE80211_RADIOTAP_MCS_BW_40 = 1,
	IEEE80211_RADIOTAP_MCS_BW_20L = 2,
	IEEE80211_RADIOTAP_MCS_BW_20U = 3,
	IEEE80211_RADIOTAP_MCS_SGI = 4,
	IEEE80211_RADIOTAP_MCS_FMT_GF = 8,
	IEEE80211_RADIOTAP_MCS_FEC_LDPC = 16,
	IEEE80211_RADIOTAP_MCS_STBC_MASK = 96,
	IEEE80211_RADIOTAP_MCS_STBC_1 = 1,
	IEEE80211_RADIOTAP_MCS_STBC_2 = 2,
	IEEE80211_RADIOTAP_MCS_STBC_3 = 3,
	IEEE80211_RADIOTAP_MCS_STBC_SHIFT = 5,
};

enum ieee80211_radiotap_mcs_have {
	IEEE80211_RADIOTAP_MCS_HAVE_BW = 1,
	IEEE80211_RADIOTAP_MCS_HAVE_MCS = 2,
	IEEE80211_RADIOTAP_MCS_HAVE_GI = 4,
	IEEE80211_RADIOTAP_MCS_HAVE_FMT = 8,
	IEEE80211_RADIOTAP_MCS_HAVE_FEC = 16,
	IEEE80211_RADIOTAP_MCS_HAVE_STBC = 32,
};

enum ieee80211_radiotap_presence {
	IEEE80211_RADIOTAP_TSFT = 0,
	IEEE80211_RADIOTAP_FLAGS = 1,
	IEEE80211_RADIOTAP_RATE = 2,
	IEEE80211_RADIOTAP_CHANNEL = 3,
	IEEE80211_RADIOTAP_FHSS = 4,
	IEEE80211_RADIOTAP_DBM_ANTSIGNAL = 5,
	IEEE80211_RADIOTAP_DBM_ANTNOISE = 6,
	IEEE80211_RADIOTAP_LOCK_QUALITY = 7,
	IEEE80211_RADIOTAP_TX_ATTENUATION = 8,
	IEEE80211_RADIOTAP_DB_TX_ATTENUATION = 9,
	IEEE80211_RADIOTAP_DBM_TX_POWER = 10,
	IEEE80211_RADIOTAP_ANTENNA = 11,
	IEEE80211_RADIOTAP_DB_ANTSIGNAL = 12,
	IEEE80211_RADIOTAP_DB_ANTNOISE = 13,
	IEEE80211_RADIOTAP_RX_FLAGS = 14,
	IEEE80211_RADIOTAP_TX_FLAGS = 15,
	IEEE80211_RADIOTAP_RTS_RETRIES = 16,
	IEEE80211_RADIOTAP_DATA_RETRIES = 17,
	IEEE80211_RADIOTAP_MCS = 19,
	IEEE80211_RADIOTAP_AMPDU_STATUS = 20,
	IEEE80211_RADIOTAP_VHT = 21,
	IEEE80211_RADIOTAP_TIMESTAMP = 22,
	IEEE80211_RADIOTAP_HE = 23,
	IEEE80211_RADIOTAP_HE_MU = 24,
	IEEE80211_RADIOTAP_ZERO_LEN_PSDU = 26,
	IEEE80211_RADIOTAP_LSIG = 27,
	IEEE80211_RADIOTAP_TLV = 28,
	IEEE80211_RADIOTAP_RADIOTAP_NAMESPACE = 29,
	IEEE80211_RADIOTAP_VENDOR_NAMESPACE = 30,
	IEEE80211_RADIOTAP_EXT = 31,
	IEEE80211_RADIOTAP_EHT_USIG = 33,
	IEEE80211_RADIOTAP_EHT = 34,
};

enum ieee80211_radiotap_rx_flags {
	IEEE80211_RADIOTAP_F_RX_BADPLCP = 2,
};

enum ieee80211_radiotap_timestamp_flags {
	IEEE80211_RADIOTAP_TIMESTAMP_FLAG_64BIT = 0,
	IEEE80211_RADIOTAP_TIMESTAMP_FLAG_32BIT = 1,
	IEEE80211_RADIOTAP_TIMESTAMP_FLAG_ACCURACY = 2,
};

enum ieee80211_radiotap_timestamp_unit_spos {
	IEEE80211_RADIOTAP_TIMESTAMP_UNIT_MASK = 15,
	IEEE80211_RADIOTAP_TIMESTAMP_UNIT_MS = 0,
	IEEE80211_RADIOTAP_TIMESTAMP_UNIT_US = 1,
	IEEE80211_RADIOTAP_TIMESTAMP_UNIT_NS = 3,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_MASK = 240,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_BEGIN_MDPU = 0,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_PLCP_SIG_ACQ = 16,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_EO_PPDU = 32,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_EO_MPDU = 48,
	IEEE80211_RADIOTAP_TIMESTAMP_SPOS_UNKNOWN = 240,
};

enum ieee80211_radiotap_tx_flags {
	IEEE80211_RADIOTAP_F_TX_FAIL = 1,
	IEEE80211_RADIOTAP_F_TX_CTS = 2,
	IEEE80211_RADIOTAP_F_TX_RTS = 4,
	IEEE80211_RADIOTAP_F_TX_NOACK = 8,
	IEEE80211_RADIOTAP_F_TX_NOSEQNO = 16,
	IEEE80211_RADIOTAP_F_TX_ORDER = 32,
};

enum ieee80211_radiotap_vht_coding {
	IEEE80211_RADIOTAP_CODING_LDPC_USER0 = 1,
	IEEE80211_RADIOTAP_CODING_LDPC_USER1 = 2,
	IEEE80211_RADIOTAP_CODING_LDPC_USER2 = 4,
	IEEE80211_RADIOTAP_CODING_LDPC_USER3 = 8,
};

enum ieee80211_radiotap_vht_flags {
	IEEE80211_RADIOTAP_VHT_FLAG_STBC = 1,
	IEEE80211_RADIOTAP_VHT_FLAG_TXOP_PS_NA = 2,
	IEEE80211_RADIOTAP_VHT_FLAG_SGI = 4,
	IEEE80211_RADIOTAP_VHT_FLAG_SGI_NSYM_M10_9 = 8,
	IEEE80211_RADIOTAP_VHT_FLAG_LDPC_EXTRA_OFDM_SYM = 16,
	IEEE80211_RADIOTAP_VHT_FLAG_BEAMFORMED = 32,
};

enum ieee80211_radiotap_vht_known {
	IEEE80211_RADIOTAP_VHT_KNOWN_STBC = 1,
	IEEE80211_RADIOTAP_VHT_KNOWN_TXOP_PS_NA = 2,
	IEEE80211_RADIOTAP_VHT_KNOWN_GI = 4,
	IEEE80211_RADIOTAP_VHT_KNOWN_SGI_NSYM_DIS = 8,
	IEEE80211_RADIOTAP_VHT_KNOWN_LDPC_EXTRA_OFDM_SYM = 16,
	IEEE80211_RADIOTAP_VHT_KNOWN_BEAMFORMED = 32,
	IEEE80211_RADIOTAP_VHT_KNOWN_BANDWIDTH = 64,
	IEEE80211_RADIOTAP_VHT_KNOWN_GROUP_ID = 128,
	IEEE80211_RADIOTAP_VHT_KNOWN_PARTIAL_AID = 256,
};

enum ieee80211_radiotap_zero_len_psdu_type {
	IEEE80211_RADIOTAP_ZERO_LEN_PSDU_SOUNDING = 0,
	IEEE80211_RADIOTAP_ZERO_LEN_PSDU_NOT_CAPTURED = 1,
	IEEE80211_RADIOTAP_ZERO_LEN_PSDU_VENDOR = 255,
};

enum ieee80211_rate_control_changed {
	IEEE80211_RC_BW_CHANGED = 1,
	IEEE80211_RC_SMPS_CHANGED = 2,
	IEEE80211_RC_SUPP_RATES_CHANGED = 4,
	IEEE80211_RC_NSS_CHANGED = 8,
};

enum ieee80211_rate_flags {
	IEEE80211_RATE_SHORT_PREAMBLE = 1,
	IEEE80211_RATE_MANDATORY_A = 2,
	IEEE80211_RATE_MANDATORY_B = 4,
	IEEE80211_RATE_MANDATORY_G = 8,
	IEEE80211_RATE_ERP_G = 16,
	IEEE80211_RATE_SUPPORTS_5MHZ = 32,
	IEEE80211_RATE_SUPPORTS_10MHZ = 64,
};

enum ieee80211_reasoncode {
	WLAN_REASON_UNSPECIFIED = 1,
	WLAN_REASON_PREV_AUTH_NOT_VALID = 2,
	WLAN_REASON_DEAUTH_LEAVING = 3,
	WLAN_REASON_DISASSOC_DUE_TO_INACTIVITY = 4,
	WLAN_REASON_DISASSOC_AP_BUSY = 5,
	WLAN_REASON_CLASS2_FRAME_FROM_NONAUTH_STA = 6,
	WLAN_REASON_CLASS3_FRAME_FROM_NONASSOC_STA = 7,
	WLAN_REASON_DISASSOC_STA_HAS_LEFT = 8,
	WLAN_REASON_STA_REQ_ASSOC_WITHOUT_AUTH = 9,
	WLAN_REASON_DISASSOC_BAD_POWER = 10,
	WLAN_REASON_DISASSOC_BAD_SUPP_CHAN = 11,
	WLAN_REASON_INVALID_IE = 13,
	WLAN_REASON_MIC_FAILURE = 14,
	WLAN_REASON_4WAY_HANDSHAKE_TIMEOUT = 15,
	WLAN_REASON_GROUP_KEY_HANDSHAKE_TIMEOUT = 16,
	WLAN_REASON_IE_DIFFERENT = 17,
	WLAN_REASON_INVALID_GROUP_CIPHER = 18,
	WLAN_REASON_INVALID_PAIRWISE_CIPHER = 19,
	WLAN_REASON_INVALID_AKMP = 20,
	WLAN_REASON_UNSUPP_RSN_VERSION = 21,
	WLAN_REASON_INVALID_RSN_IE_CAP = 22,
	WLAN_REASON_IEEE8021X_FAILED = 23,
	WLAN_REASON_CIPHER_SUITE_REJECTED = 24,
	WLAN_REASON_TDLS_TEARDOWN_UNREACHABLE = 25,
	WLAN_REASON_TDLS_TEARDOWN_UNSPECIFIED = 26,
	WLAN_REASON_DISASSOC_UNSPECIFIED_QOS = 32,
	WLAN_REASON_DISASSOC_QAP_NO_BANDWIDTH = 33,
	WLAN_REASON_DISASSOC_LOW_ACK = 34,
	WLAN_REASON_DISASSOC_QAP_EXCEED_TXOP = 35,
	WLAN_REASON_QSTA_LEAVE_QBSS = 36,
	WLAN_REASON_QSTA_NOT_USE = 37,
	WLAN_REASON_QSTA_REQUIRE_SETUP = 38,
	WLAN_REASON_QSTA_TIMEOUT = 39,
	WLAN_REASON_QSTA_CIPHER_NOT_SUPP = 45,
	WLAN_REASON_MESH_PEER_CANCELED = 52,
	WLAN_REASON_MESH_MAX_PEERS = 53,
	WLAN_REASON_MESH_CONFIG = 54,
	WLAN_REASON_MESH_CLOSE = 55,
	WLAN_REASON_MESH_MAX_RETRIES = 56,
	WLAN_REASON_MESH_CONFIRM_TIMEOUT = 57,
	WLAN_REASON_MESH_INVALID_GTK = 58,
	WLAN_REASON_MESH_INCONSISTENT_PARAM = 59,
	WLAN_REASON_MESH_INVALID_SECURITY = 60,
	WLAN_REASON_MESH_PATH_ERROR = 61,
	WLAN_REASON_MESH_PATH_NOFORWARD = 62,
	WLAN_REASON_MESH_PATH_DEST_UNREACHABLE = 63,
	WLAN_REASON_MAC_EXISTS_IN_MBSS = 64,
	WLAN_REASON_MESH_CHAN_REGULATORY = 65,
	WLAN_REASON_MESH_CHAN = 66,
};

enum ieee80211_reconfig_type {
	IEEE80211_RECONFIG_TYPE_RESTART = 0,
	IEEE80211_RECONFIG_TYPE_SUSPEND = 1,
};

enum ieee80211_regd_source {
	REGD_SOURCE_INTERNAL_DB = 0,
	REGD_SOURCE_CRDA = 1,
	REGD_SOURCE_CACHED = 2,
};

enum ieee80211_regulatory_flags {
	REGULATORY_CUSTOM_REG = 1,
	REGULATORY_STRICT_REG = 2,
	REGULATORY_DISABLE_BEACON_HINTS = 4,
	REGULATORY_COUNTRY_IE_FOLLOW_POWER = 8,
	REGULATORY_COUNTRY_IE_IGNORE = 16,
	REGULATORY_ENABLE_RELAX_NO_IR = 32,
	REGULATORY_WIPHY_SELF_MANAGED = 128,
};

enum ieee80211_roc_type {
	IEEE80211_ROC_TYPE_NORMAL = 0,
	IEEE80211_ROC_TYPE_MGMT_TX = 1,
};

enum ieee80211_rssi_event_data {
	RSSI_EVENT_HIGH = 0,
	RSSI_EVENT_LOW = 1,
};

enum ieee80211_rx_flags {
	IEEE80211_RX_CMNTR = 1,
	IEEE80211_RX_BEACON_REPORTED = 2,
};

enum ieee80211_s1g_actioncode {
	WLAN_S1G_AID_SWITCH_REQUEST = 0,
	WLAN_S1G_AID_SWITCH_RESPONSE = 1,
	WLAN_S1G_SYNC_CONTROL = 2,
	WLAN_S1G_STA_INFO_ANNOUNCE = 3,
	WLAN_S1G_EDCA_PARAM_SET = 4,
	WLAN_S1G_EL_OPERATION = 5,
	WLAN_S1G_TWT_SETUP = 6,
	WLAN_S1G_TWT_TEARDOWN = 7,
	WLAN_S1G_SECT_GROUP_ID_LIST = 8,
	WLAN_S1G_SECT_ID_FEEDBACK = 9,
	WLAN_S1G_TWT_INFORMATION = 11,
};

enum ieee80211_s1g_chanwidth {
	IEEE80211_S1G_CHANWIDTH_1MHZ = 0,
	IEEE80211_S1G_CHANWIDTH_2MHZ = 1,
	IEEE80211_S1G_CHANWIDTH_4MHZ = 3,
	IEEE80211_S1G_CHANWIDTH_8MHZ = 7,
	IEEE80211_S1G_CHANWIDTH_16MHZ = 15,
};

enum ieee80211_sa_query_action {
	WLAN_ACTION_SA_QUERY_REQUEST = 0,
	WLAN_ACTION_SA_QUERY_RESPONSE = 1,
};

enum ieee80211_sdata_state_bits {
	SDATA_STATE_RUNNING = 0,
	SDATA_STATE_OFFCHANNEL = 1,
	SDATA_STATE_OFFCHANNEL_BEACON_STOPPED = 2,
};

enum ieee80211_self_protected_actioncode {
	WLAN_SP_RESERVED = 0,
	WLAN_SP_MESH_PEERING_OPEN = 1,
	WLAN_SP_MESH_PEERING_CONFIRM = 2,
	WLAN_SP_MESH_PEERING_CLOSE = 3,
	WLAN_SP_MGK_INFORM = 4,
	WLAN_SP_MGK_ACK = 5,
};

enum ieee80211_smps_mode {
	IEEE80211_SMPS_AUTOMATIC = 0,
	IEEE80211_SMPS_OFF = 1,
	IEEE80211_SMPS_STATIC = 2,
	IEEE80211_SMPS_DYNAMIC = 3,
	IEEE80211_SMPS_NUM_MODES = 4,
};

enum ieee80211_spectrum_mgmt_actioncode {
	WLAN_ACTION_SPCT_MSR_REQ = 0,
	WLAN_ACTION_SPCT_MSR_RPRT = 1,
	WLAN_ACTION_SPCT_TPC_REQ = 2,
	WLAN_ACTION_SPCT_TPC_RPRT = 3,
	WLAN_ACTION_SPCT_CHL_SWITCH = 4,
};

enum ieee80211_sta_flags {
	IEEE80211_STA_CONNECTION_POLL = 2,
	IEEE80211_STA_CONTROL_PORT = 4,
	IEEE80211_STA_MFP_ENABLED = 64,
	IEEE80211_STA_UAPSD_ENABLED = 128,
	IEEE80211_STA_NULLFUNC_ACKED = 256,
	IEEE80211_STA_ENABLE_RRM = 32768,
};

enum ieee80211_sta_info_flags {
	WLAN_STA_AUTH = 0,
	WLAN_STA_ASSOC = 1,
	WLAN_STA_PS_STA = 2,
	WLAN_STA_AUTHORIZED = 3,
	WLAN_STA_SHORT_PREAMBLE = 4,
	WLAN_STA_WDS = 5,
	WLAN_STA_CLEAR_PS_FILT = 6,
	WLAN_STA_MFP = 7,
	WLAN_STA_BLOCK_BA = 8,
	WLAN_STA_PS_DRIVER = 9,
	WLAN_STA_PSPOLL = 10,
	WLAN_STA_TDLS_PEER = 11,
	WLAN_STA_TDLS_PEER_AUTH = 12,
	WLAN_STA_TDLS_INITIATOR = 13,
	WLAN_STA_TDLS_CHAN_SWITCH = 14,
	WLAN_STA_TDLS_OFF_CHANNEL = 15,
	WLAN_STA_TDLS_WIDER_BW = 16,
	WLAN_STA_UAPSD = 17,
	WLAN_STA_SP = 18,
	WLAN_STA_4ADDR_EVENT = 19,
	WLAN_STA_INSERTED = 20,
	WLAN_STA_RATE_CONTROL = 21,
	WLAN_STA_TOFFSET_KNOWN = 22,
	WLAN_STA_MPSP_OWNER = 23,
	WLAN_STA_MPSP_RECIPIENT = 24,
	WLAN_STA_PS_DELIVER = 25,
	WLAN_STA_USES_ENCRYPTION = 26,
	WLAN_STA_DECAP_OFFLOAD = 27,
	NUM_WLAN_STA_FLAGS = 28,
};

enum ieee80211_sta_rx_bandwidth {
	IEEE80211_STA_RX_BW_20 = 0,
	IEEE80211_STA_RX_BW_40 = 1,
	IEEE80211_STA_RX_BW_80 = 2,
	IEEE80211_STA_RX_BW_160 = 3,
	IEEE80211_STA_RX_BW_320 = 4,
};

enum ieee80211_sta_state {
	IEEE80211_STA_NOTEXIST = 0,
	IEEE80211_STA_NONE = 1,
	IEEE80211_STA_AUTH = 2,
	IEEE80211_STA_ASSOC = 3,
	IEEE80211_STA_AUTHORIZED = 4,
};

enum ieee80211_status_data {
	IEEE80211_STATUS_TYPE_MASK = 15,
	IEEE80211_STATUS_TYPE_INVALID = 0,
	IEEE80211_STATUS_TYPE_SMPS = 1,
	IEEE80211_STATUS_TYPE_NEG_TTLM = 2,
	IEEE80211_STATUS_SUBDATA_MASK = 8176,
};

enum ieee80211_statuscode {
	WLAN_STATUS_SUCCESS = 0,
	WLAN_STATUS_UNSPECIFIED_FAILURE = 1,
	WLAN_STATUS_CAPS_UNSUPPORTED = 10,
	WLAN_STATUS_REASSOC_NO_ASSOC = 11,
	WLAN_STATUS_ASSOC_DENIED_UNSPEC = 12,
	WLAN_STATUS_NOT_SUPPORTED_AUTH_ALG = 13,
	WLAN_STATUS_UNKNOWN_AUTH_TRANSACTION = 14,
	WLAN_STATUS_CHALLENGE_FAIL = 15,
	WLAN_STATUS_AUTH_TIMEOUT = 16,
	WLAN_STATUS_AP_UNABLE_TO_HANDLE_NEW_STA = 17,
	WLAN_STATUS_ASSOC_DENIED_RATES = 18,
	WLAN_STATUS_ASSOC_DENIED_NOSHORTPREAMBLE = 19,
	WLAN_STATUS_ASSOC_DENIED_NOPBCC = 20,
	WLAN_STATUS_ASSOC_DENIED_NOAGILITY = 21,
	WLAN_STATUS_ASSOC_DENIED_NOSPECTRUM = 22,
	WLAN_STATUS_ASSOC_REJECTED_BAD_POWER = 23,
	WLAN_STATUS_ASSOC_REJECTED_BAD_SUPP_CHAN = 24,
	WLAN_STATUS_ASSOC_DENIED_NOSHORTTIME = 25,
	WLAN_STATUS_ASSOC_DENIED_NODSSSOFDM = 26,
	WLAN_STATUS_ASSOC_REJECTED_TEMPORARILY = 30,
	WLAN_STATUS_ROBUST_MGMT_FRAME_POLICY_VIOLATION = 31,
	WLAN_STATUS_INVALID_IE = 40,
	WLAN_STATUS_INVALID_GROUP_CIPHER = 41,
	WLAN_STATUS_INVALID_PAIRWISE_CIPHER = 42,
	WLAN_STATUS_INVALID_AKMP = 43,
	WLAN_STATUS_UNSUPP_RSN_VERSION = 44,
	WLAN_STATUS_INVALID_RSN_IE_CAP = 45,
	WLAN_STATUS_CIPHER_SUITE_REJECTED = 46,
	WLAN_STATUS_UNSPECIFIED_QOS = 32,
	WLAN_STATUS_ASSOC_DENIED_NOBANDWIDTH = 33,
	WLAN_STATUS_ASSOC_DENIED_LOWACK = 34,
	WLAN_STATUS_ASSOC_DENIED_UNSUPP_QOS = 35,
	WLAN_STATUS_REQUEST_DECLINED = 37,
	WLAN_STATUS_INVALID_QOS_PARAM = 38,
	WLAN_STATUS_CHANGE_TSPEC = 39,
	WLAN_STATUS_WAIT_TS_DELAY = 47,
	WLAN_STATUS_NO_DIRECT_LINK = 48,
	WLAN_STATUS_STA_NOT_PRESENT = 49,
	WLAN_STATUS_STA_NOT_QSTA = 50,
	WLAN_STATUS_ANTI_CLOG_REQUIRED = 76,
	WLAN_STATUS_FCG_NOT_SUPP = 78,
	WLAN_STATUS_STA_NO_TBTT = 78,
	WLAN_STATUS_REJECTED_WITH_SUGGESTED_CHANGES = 39,
	WLAN_STATUS_REJECTED_FOR_DELAY_PERIOD = 47,
	WLAN_STATUS_REJECT_WITH_SCHEDULE = 83,
	WLAN_STATUS_PENDING_ADMITTING_FST_SESSION = 86,
	WLAN_STATUS_PERFORMING_FST_NOW = 87,
	WLAN_STATUS_PENDING_GAP_IN_BA_WINDOW = 88,
	WLAN_STATUS_REJECT_U_PID_SETTING = 89,
	WLAN_STATUS_REJECT_DSE_BAND = 96,
	WLAN_STATUS_DENIED_WITH_SUGGESTED_BAND_AND_CHANNEL = 99,
	WLAN_STATUS_DENIED_DUE_TO_SPECTRUM_MANAGEMENT = 103,
	WLAN_STATUS_FILS_AUTHENTICATION_FAILURE = 108,
	WLAN_STATUS_UNKNOWN_AUTHENTICATION_SERVER = 109,
	WLAN_STATUS_SAE_HASH_TO_ELEMENT = 126,
	WLAN_STATUS_SAE_PK = 127,
	WLAN_STATUS_DENIED_TID_TO_LINK_MAPPING = 133,
	WLAN_STATUS_PREF_TID_TO_LINK_MAPPING_SUGGESTED = 134,
};

enum ieee80211_sub_if_data_flags {
	IEEE80211_SDATA_ALLMULTI = 1,
	IEEE80211_SDATA_DONT_BRIDGE_PACKETS = 8,
	IEEE80211_SDATA_DISCONNECT_RESUME = 16,
	IEEE80211_SDATA_IN_DRIVER = 32,
	IEEE80211_SDATA_DISCONNECT_HW_RESTART = 64,
};

enum ieee80211_tdls_actioncode {
	WLAN_TDLS_SETUP_REQUEST = 0,
	WLAN_TDLS_SETUP_RESPONSE = 1,
	WLAN_TDLS_SETUP_CONFIRM = 2,
	WLAN_TDLS_TEARDOWN = 3,
	WLAN_TDLS_PEER_TRAFFIC_INDICATION = 4,
	WLAN_TDLS_CHANNEL_SWITCH_REQUEST = 5,
	WLAN_TDLS_CHANNEL_SWITCH_RESPONSE = 6,
	WLAN_TDLS_PEER_PSM_REQUEST = 7,
	WLAN_TDLS_PEER_PSM_RESPONSE = 8,
	WLAN_TDLS_PEER_TRAFFIC_RESPONSE = 9,
	WLAN_TDLS_DISCOVERY_REQUEST = 10,
};

enum ieee80211_timeout_interval_type {
	WLAN_TIMEOUT_REASSOC_DEADLINE = 1,
	WLAN_TIMEOUT_KEY_LIFETIME = 2,
	WLAN_TIMEOUT_ASSOC_COMEBACK = 3,
};

enum ieee80211_tpt_led_trigger_flags {
	IEEE80211_TPT_LEDTRIG_FL_RADIO = 1,
	IEEE80211_TPT_LEDTRIG_FL_WORK = 2,
	IEEE80211_TPT_LEDTRIG_FL_CONNECTED = 4,
};

enum ieee80211_twt_setup_cmd {
	TWT_SETUP_CMD_REQUEST = 0,
	TWT_SETUP_CMD_SUGGEST = 1,
	TWT_SETUP_CMD_DEMAND = 2,
	TWT_SETUP_CMD_GROUPING = 3,
	TWT_SETUP_CMD_ACCEPT = 4,
	TWT_SETUP_CMD_ALTERNATE = 5,
	TWT_SETUP_CMD_DICTATE = 6,
	TWT_SETUP_CMD_REJECT = 7,
};

enum ieee80211_tx_power_category_6ghz {
	IEEE80211_TPE_CAT_6GHZ_DEFAULT = 0,
	IEEE80211_TPE_CAT_6GHZ_SUBORDINATE = 1,
};

enum ieee80211_tx_power_intrpt_type {
	IEEE80211_TPE_LOCAL_EIRP = 0,
	IEEE80211_TPE_LOCAL_EIRP_PSD = 1,
	IEEE80211_TPE_REG_CLIENT_EIRP = 2,
	IEEE80211_TPE_REG_CLIENT_EIRP_PSD = 3,
};

enum ieee80211_unprotected_wnm_actioncode {
	WLAN_UNPROTECTED_WNM_ACTION_TIM = 0,
	WLAN_UNPROTECTED_WNM_ACTION_TIMING_MEASUREMENT_RESPONSE = 1,
};

enum ieee80211_vht_actioncode {
	WLAN_VHT_ACTION_COMPRESSED_BF = 0,
	WLAN_VHT_ACTION_GROUPID_MGMT = 1,
	WLAN_VHT_ACTION_OPMODE_NOTIF = 2,
};

enum ieee80211_vht_chanwidth {
	IEEE80211_VHT_CHANWIDTH_USE_HT = 0,
	IEEE80211_VHT_CHANWIDTH_80MHZ = 1,
	IEEE80211_VHT_CHANWIDTH_160MHZ = 2,
	IEEE80211_VHT_CHANWIDTH_80P80MHZ = 3,
};

enum ieee80211_vht_max_ampdu_length_exp {
	IEEE80211_VHT_MAX_AMPDU_8K = 0,
	IEEE80211_VHT_MAX_AMPDU_16K = 1,
	IEEE80211_VHT_MAX_AMPDU_32K = 2,
	IEEE80211_VHT_MAX_AMPDU_64K = 3,
	IEEE80211_VHT_MAX_AMPDU_128K = 4,
	IEEE80211_VHT_MAX_AMPDU_256K = 5,
	IEEE80211_VHT_MAX_AMPDU_512K = 6,
	IEEE80211_VHT_MAX_AMPDU_1024K = 7,
};

enum ieee80211_vht_mcs_support {
	IEEE80211_VHT_MCS_SUPPORT_0_7 = 0,
	IEEE80211_VHT_MCS_SUPPORT_0_8 = 1,
	IEEE80211_VHT_MCS_SUPPORT_0_9 = 2,
	IEEE80211_VHT_MCS_NOT_SUPPORTED = 3,
};

enum ieee80211_vht_opmode_bits {
	IEEE80211_OPMODE_NOTIF_CHANWIDTH_MASK = 3,
	IEEE80211_OPMODE_NOTIF_CHANWIDTH_20MHZ = 0,
	IEEE80211_OPMODE_NOTIF_CHANWIDTH_40MHZ = 1,
	IEEE80211_OPMODE_NOTIF_CHANWIDTH_80MHZ = 2,
	IEEE80211_OPMODE_NOTIF_CHANWIDTH_160MHZ = 3,
	IEEE80211_OPMODE_NOTIF_BW_160_80P80 = 4,
	IEEE80211_OPMODE_NOTIF_RX_NSS_MASK = 112,
	IEEE80211_OPMODE_NOTIF_RX_NSS_SHIFT = 4,
	IEEE80211_OPMODE_NOTIF_RX_NSS_TYPE_BF = 128,
};

enum ieee80211_vif_flags {
	IEEE80211_VIF_BEACON_FILTER = 1,
	IEEE80211_VIF_SUPPORTS_CQM_RSSI = 2,
	IEEE80211_VIF_SUPPORTS_UAPSD = 4,
	IEEE80211_VIF_GET_NOA_UPDATE = 8,
	IEEE80211_VIF_EML_ACTIVE = 16,
	IEEE80211_VIF_IGNORE_OFDMA_WIDER_BW = 32,
	IEEE80211_VIF_REMOVE_AP_AFTER_DISASSOC = 64,
};

enum ifs {
	IFS_BACKOFF = 0,
	IFS_SIFS = 1,
	IFS_NEW_BACKOFF = 2,
	IFS_NONE = 3,
};

enum igb_diagnostics_results {
	TEST_REG = 0,
	TEST_EEP = 1,
	TEST_IRQ = 2,
	TEST_LOOP = 3,
	TEST_LINK = 4,
};

enum igb_filter_match_flags {
	IGB_FILTER_FLAG_ETHER_TYPE = 1,
	IGB_FILTER_FLAG_VLAN_TCI = 2,
	IGB_FILTER_FLAG_SRC_MAC_ADDR = 4,
	IGB_FILTER_FLAG_DST_MAC_ADDR = 8,
};

enum igb_tx_buf_type {
	IGB_TYPE_SKB = 0,
	IGB_TYPE_XDP = 1,
	IGB_TYPE_XSK = 2,
};

enum igb_tx_flags {
	IGB_TX_FLAGS_VLAN = 1,
	IGB_TX_FLAGS_TSO = 2,
	IGB_TX_FLAGS_TSTAMP = 4,
	IGB_TX_FLAGS_IPV4 = 16,
	IGB_TX_FLAGS_CSUM = 32,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inode_state {
	inode_state_no_change = 0,
	inode_state_will_create = 1,
	inode_state_did_create = 2,
	inode_state_will_delete = 3,
	inode_state_did_delete = 4,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum insn_mmio_type {
	INSN_MMIO_DECODE_FAILED = 0,
	INSN_MMIO_WRITE = 1,
	INSN_MMIO_WRITE_IMM = 2,
	INSN_MMIO_READ = 3,
	INSN_MMIO_READ_ZERO_EXTEND = 4,
	INSN_MMIO_READ_SIGN_EXTEND = 5,
	INSN_MMIO_MOVS = 6,
};

enum insn_mode {
	INSN_MODE_32 = 0,
	INSN_MODE_64 = 1,
	INSN_MODE_KERN = 2,
	INSN_NUM_MODES = 3,
};

enum insn_type {
	CALL = 0,
	NOP = 1,
	JMP = 2,
	RET = 3,
	JCC = 4,
};

enum intel_cpu_type {
	INTEL_CPU_TYPE_ATOM = 32,
	INTEL_CPU_TYPE_CORE = 64,
};

enum intel_excl_state_type {
	INTEL_EXCL_UNUSED = 0,
	INTEL_EXCL_SHARED = 1,
	INTEL_EXCL_EXCLUSIVE = 2,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_LAST = 58,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioapic_domain_type {
	IOAPIC_DOMAIN_INVALID = 0,
	IOAPIC_DOMAIN_LEGACY = 1,
	IOAPIC_DOMAIN_STRICT = 2,
	IOAPIC_DOMAIN_DYNAMIC = 3,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_events {
	IPCT_NEW = 0,
	IPCT_RELATED = 1,
	IPCT_DESTROY = 2,
	IPCT_REPLY = 3,
	IPCT_ASSURED = 4,
	IPCT_PROTOINFO = 5,
	IPCT_HELPER = 6,
	IPCT_MARK = 7,
	IPCT_SEQADJ = 8,
	IPCT_NATSEQADJ = 8,
	IPCT_SECMARK = 9,
	IPCT_LABEL = 10,
	IPCT_SYNPROXY = 11,
	__IPCT_MAX = 12,
};

enum ip_conntrack_expect_events {
	IPEXP_NEW = 0,
	IPEXP_DESTROY = 1,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipt_reject_with {
	IPT_ICMP_NET_UNREACHABLE = 0,
	IPT_ICMP_HOST_UNREACHABLE = 1,
	IPT_ICMP_PROT_UNREACHABLE = 2,
	IPT_ICMP_PORT_UNREACHABLE = 3,
	IPT_ICMP_ECHOREPLY = 4,
	IPT_ICMP_NET_PROHIBITED = 5,
	IPT_ICMP_HOST_PROHIBITED = 6,
	IPT_TCP_RESET = 7,
	IPT_ICMP_ADMIN_PROHIBITED = 8,
};

enum irq_alloc_type {
	X86_IRQ_ALLOC_TYPE_IOAPIC = 1,
	X86_IRQ_ALLOC_TYPE_HPET = 2,
	X86_IRQ_ALLOC_TYPE_PCI_MSI = 3,
	X86_IRQ_ALLOC_TYPE_PCI_MSIX = 4,
	X86_IRQ_ALLOC_TYPE_DMAR = 5,
	X86_IRQ_ALLOC_TYPE_AMDVI = 6,
	X86_IRQ_ALLOC_TYPE_UV = 7,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum isofs_file_format {
	isofs_file_normal = 0,
	isofs_file_sparse = 1,
	isofs_file_compressed = 2,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum iwl_6ghz_ap_type {
	IWL_6GHZ_AP_TYPE_LPI = 0,
	IWL_6GHZ_AP_TYPE_SP = 1,
	IWL_6GHZ_AP_TYPE_VLP = 2,
};

enum iwl_ac {
	AC_BK = 0,
	AC_BE = 1,
	AC_VI = 2,
	AC_VO = 3,
	AC_NUM = 4,
};

enum iwl_agg_state {
	IWL_AGG_OFF = 0,
	IWL_AGG_STARTING = 1,
	IWL_AGG_ON = 2,
	IWL_EMPTYING_HW_QUEUE_ADDBA = 3,
	IWL_EMPTYING_HW_QUEUE_DELBA = 4,
};

enum iwl_amsdu_size {
	IWL_AMSDU_DEF = 0,
	IWL_AMSDU_4K = 1,
	IWL_AMSDU_8K = 2,
	IWL_AMSDU_12K = 3,
	IWL_AMSDU_2K = 4,
};

enum iwl_antenna_ok {
	IWL_ANT_OK_NONE = 0,
	IWL_ANT_OK_SINGLE = 1,
	IWL_ANT_OK_MULTI = 2,
};

enum iwl_bar_frame_release_ba_info {
	IWL_BAR_FRAME_RELEASE_NSSN_MASK = 4095,
	IWL_BAR_FRAME_RELEASE_SN_MASK = 16773120,
	IWL_BAR_FRAME_RELEASE_BAID_MASK = 1056964608,
};

enum iwl_bar_frame_release_sta_tid {
	IWL_BAR_FRAME_RELEASE_TID_MASK = 15,
	IWL_BAR_FRAME_RELEASE_STA_MASK = 496,
};

enum iwl_bt_activity_grading {
	BT_OFF = 0,
	BT_ON_NO_CONNECTION = 1,
	BT_LOW_TRAFFIC = 2,
	BT_HIGH_TRAFFIC = 3,
	BT_VERY_HIGH_TRAFFIC = 4,
	BT_MAX_AG = 5,
};

enum iwl_bt_coex_enabled_modules {
	BT_COEX_MPLUT_ENABLED = 1,
	BT_COEX_MPLUT_BOOST_ENABLED = 2,
	BT_COEX_SYNC2SCO_ENABLED = 4,
	BT_COEX_CORUN_ENABLED = 8,
	BT_COEX_HIGH_BAND_RET = 16,
};

enum iwl_bt_coex_lut_type {
	BT_COEX_TIGHT_LUT = 0,
	BT_COEX_LOOSE_LUT = 1,
	BT_COEX_TX_DIS_LUT = 2,
	BT_COEX_MAX_LUT = 3,
	BT_COEX_INVALID_LUT = 255,
};

enum iwl_bt_coex_mode {
	BT_COEX_DISABLE = 0,
	BT_COEX_NW = 1,
	BT_COEX_BT = 2,
	BT_COEX_WIFI = 3,
};

enum iwl_bt_coex_profile_traffic_load {
	IWL_BT_COEX_TRAFFIC_LOAD_NONE = 0,
	IWL_BT_COEX_TRAFFIC_LOAD_LOW = 1,
	IWL_BT_COEX_TRAFFIC_LOAD_HIGH = 2,
	IWL_BT_COEX_TRAFFIC_LOAD_CONTINUOUS = 3,
};

enum iwl_bt_coex_subcmd_ids {
	PROFILE_NOTIF = 255,
};

enum iwl_bt_force_ant_mode {
	BT_FORCE_ANT_DIS = 0,
	BT_FORCE_ANT_AUTO = 1,
	BT_FORCE_ANT_BT = 2,
	BT_FORCE_ANT_WIFI = 3,
	BT_FORCE_ANT_MAX = 4,
};

enum iwl_bt_kill_idx {
	IWL_BT_KILL_DEFAULT = 0,
	IWL_BT_KILL_OVERRIDE = 1,
	IWL_BT_KILL_REDUCE = 2,
};

enum iwl_cfg_trans_ltr_delay {
	IWL_CFG_TRANS_LTR_DELAY_NONE = 0,
	IWL_CFG_TRANS_LTR_DELAY_200US = 1,
	IWL_CFG_TRANS_LTR_DELAY_2500US = 2,
	IWL_CFG_TRANS_LTR_DELAY_1820US = 3,
};

enum iwl_channel_flags {
	IWL_CHANNEL_FLAG_EBS = 1,
	IWL_CHANNEL_FLAG_ACCURATE_EBS = 2,
	IWL_CHANNEL_FLAG_EBS_ADD = 4,
	IWL_CHANNEL_FLAG_PRE_SCAN_PASSIVE2ACTIVE = 8,
};

enum iwl_context_info_flags {
	IWL_CTXT_INFO_AUTO_FUNC_INIT = 1,
	IWL_CTXT_INFO_EARLY_DEBUG = 2,
	IWL_CTXT_INFO_ENABLE_CDMP = 4,
	IWL_CTXT_INFO_RB_CB_SIZE = 240,
	IWL_CTXT_INFO_TFD_FORMAT_LONG = 256,
	IWL_CTXT_INFO_RB_SIZE = 7680,
	IWL_CTXT_INFO_RB_SIZE_1K = 1,
	IWL_CTXT_INFO_RB_SIZE_2K = 2,
	IWL_CTXT_INFO_RB_SIZE_4K = 4,
	IWL_CTXT_INFO_RB_SIZE_8K = 8,
	IWL_CTXT_INFO_RB_SIZE_12K = 9,
	IWL_CTXT_INFO_RB_SIZE_16K = 10,
	IWL_CTXT_INFO_RB_SIZE_20K = 11,
	IWL_CTXT_INFO_RB_SIZE_24K = 12,
	IWL_CTXT_INFO_RB_SIZE_28K = 13,
	IWL_CTXT_INFO_RB_SIZE_32K = 14,
};

enum iwl_ctxt_action {
	FW_CTXT_ACTION_INVALID = 0,
	FW_CTXT_ACTION_ADD = 1,
	FW_CTXT_ACTION_MODIFY = 2,
	FW_CTXT_ACTION_REMOVE = 3,
};

enum iwl_ctxt_id_and_color {
	FW_CTXT_ID_POS = 0,
	FW_CTXT_ID_MSK = 255,
	FW_CTXT_COLOR_POS = 8,
	FW_CTXT_COLOR_MSK = 65280,
	FW_CTXT_INVALID = 4294967295,
};

enum iwl_d0i3_flags {
	IWL_D0I3_RESET_REQUIRE = 1,
};

enum iwl_d3_notif {
	IWL_D3_NOTIF_WOWLAN_INFO = 1,
	IWL_D3_NOTIF_WOWLAN_WAKE_PKT = 2,
	IWL_D3_NOTIF_PROT_OFFLOAD = 4,
	IWL_D3_ND_MATCH_INFO = 8,
	IWL_D3_NOTIF_D3_END_NOTIF = 16,
};

enum iwl_d3_status {
	IWL_D3_STATUS_ALIVE = 0,
	IWL_D3_STATUS_RESET = 1,
};

enum iwl_data_path_subcmd_ids {
	DQA_ENABLE_CMD = 0,
	UPDATE_MU_GROUPS_CMD = 1,
	TRIGGER_RX_QUEUES_NOTIF_CMD = 2,
	WNM_PLATFORM_PTM_REQUEST_CMD = 3,
	WNM_80211V_TIMING_MEASUREMENT_CONFIG_CMD = 4,
	STA_HE_CTXT_CMD = 7,
	RLC_CONFIG_CMD = 8,
	RFH_QUEUE_CONFIG_CMD = 13,
	TLC_MNG_CONFIG_CMD = 15,
	HE_AIR_SNIFFER_CONFIG_CMD = 19,
	CHEST_COLLECTOR_FILTER_CONFIG_CMD = 20,
	RX_BAID_ALLOCATION_CONFIG_CMD = 22,
	SCD_QUEUE_CONFIG_CMD = 23,
	SEC_KEY_CMD = 24,
	ESR_MODE_NOTIF = 243,
	MONITOR_NOTIF = 244,
	RX_NO_DATA_NOTIF = 245,
	THERMAL_DUAL_CHAIN_REQUEST = 246,
	TLC_MNG_UPDATE_NOTIF = 247,
	STA_PM_NOTIF = 253,
	MU_GROUP_MGMT_NOTIF = 254,
	RX_QUEUES_NOTIFICATION = 255,
};

enum iwl_datapath_monitor_notif_type {
	IWL_DP_MON_NOTIF_TYPE_EXT_CCA = 0,
};

enum iwl_dbg_suspend_resume_cmds {
	DBGC_RESUME_CMD = 0,
	DBGC_SUSPEND_CMD = 1,
};

enum iwl_debug_cmds {
	LMAC_RD_WR = 0,
	UMAC_RD_WR = 1,
	HOST_EVENT_CFG = 3,
	INVALID_WR_PTR_CMD = 6,
	DBGC_SUSPEND_RESUME = 7,
	BUFFER_ALLOCATION = 8,
	GET_TAS_STATUS = 10,
	FW_DUMP_COMPLETE_CMD = 11,
	FW_CLEAR_BUFFER = 13,
	MFU_ASSERT_DUMP_NTF = 254,
};

enum iwl_dev_tx_power_cmd_mode {
	IWL_TX_POWER_MODE_SET_LINK = 0,
	IWL_TX_POWER_MODE_SET_DEVICE = 1,
	IWL_TX_POWER_MODE_SET_CHAINS = 2,
	IWL_TX_POWER_MODE_SET_ACK = 3,
	IWL_TX_POWER_MODE_SET_SAR_TIMER = 4,
	IWL_TX_POWER_MODE_SET_SAR_TIMER_DEFAULT_TABLE = 5,
};

enum iwl_device_family {
	IWL_DEVICE_FAMILY_UNDEFINED = 0,
	IWL_DEVICE_FAMILY_1000 = 1,
	IWL_DEVICE_FAMILY_100 = 2,
	IWL_DEVICE_FAMILY_2000 = 3,
	IWL_DEVICE_FAMILY_2030 = 4,
	IWL_DEVICE_FAMILY_105 = 5,
	IWL_DEVICE_FAMILY_135 = 6,
	IWL_DEVICE_FAMILY_5000 = 7,
	IWL_DEVICE_FAMILY_5150 = 8,
	IWL_DEVICE_FAMILY_6000 = 9,
	IWL_DEVICE_FAMILY_6000i = 10,
	IWL_DEVICE_FAMILY_6005 = 11,
	IWL_DEVICE_FAMILY_6030 = 12,
	IWL_DEVICE_FAMILY_6050 = 13,
	IWL_DEVICE_FAMILY_6150 = 14,
	IWL_DEVICE_FAMILY_7000 = 15,
	IWL_DEVICE_FAMILY_8000 = 16,
	IWL_DEVICE_FAMILY_9000 = 17,
	IWL_DEVICE_FAMILY_22000 = 18,
	IWL_DEVICE_FAMILY_AX210 = 19,
	IWL_DEVICE_FAMILY_BZ = 20,
	IWL_DEVICE_FAMILY_SC = 21,
	IWL_DEVICE_FAMILY_DR = 22,
};

enum iwl_device_power_flags {
	DEVICE_POWER_FLAGS_POWER_SAVE_ENA_MSK = 1,
	DEVICE_POWER_FLAGS_ALLOW_MEM_RETENTION_MSK = 2,
	DEVICE_POWER_FLAGS_NO_SLEEP_TILL_D3_MSK = 128,
	DEVICE_POWER_FLAGS_32K_CLK_VALID_MSK = 4096,
};

enum iwl_disable_11n {
	IWL_DISABLE_HT_ALL = 1,
	IWL_DISABLE_HT_TXAGG = 2,
	IWL_DISABLE_HT_RXAGG = 4,
	IWL_ENABLE_HT_TXAGG = 8,
};

enum iwl_dsm_funcs {
	DSM_FUNC_QUERY = 0,
	DSM_FUNC_DISABLE_SRD = 1,
	DSM_FUNC_ENABLE_INDONESIA_5G2 = 2,
	DSM_FUNC_ENABLE_6E = 3,
	DSM_FUNC_REGULATORY_CONFIG = 4,
	DSM_FUNC_11AX_ENABLEMENT = 6,
	DSM_FUNC_ENABLE_UNII4_CHAN = 7,
	DSM_FUNC_ACTIVATE_CHANNEL = 8,
	DSM_FUNC_FORCE_DISABLE_CHANNELS = 9,
	DSM_FUNC_ENERGY_DETECTION_THRESHOLD = 10,
	DSM_FUNC_RFI_CONFIG = 11,
	DSM_FUNC_ENABLE_11BE = 12,
	DSM_FUNC_NUM_FUNCS = 13,
};

enum iwl_dsm_internal_product_reset_cmds {
	DSM_INTERNAL_PLDR_CMD_GET_MODE = 1,
	DSM_INTERNAL_PLDR_CMD_SET_MODE = 2,
	DSM_INTERNAL_PLDR_CMD_GET_STATUS = 3,
};

enum iwl_dsm_internal_product_reset_mode {
	DSM_INTERNAL_PLDR_MODE_EN_PROD_RESET = 1,
	DSM_INTERNAL_PLDR_MODE_EN_WIFI_FLR = 2,
	DSM_INTERNAL_PLDR_MODE_EN_BT_OFF_ON = 4,
};

enum iwl_dsm_masks_reg {
	DSM_MASK_CHINA_22_REG = 4,
};

enum iwl_dsm_unii4_bitmap {
	DSM_VALUE_UNII4_US_OVERRIDE_MSK = 1,
	DSM_VALUE_UNII4_US_EN_MSK = 2,
	DSM_VALUE_UNII4_ETSI_OVERRIDE_MSK = 4,
	DSM_VALUE_UNII4_ETSI_EN_MSK = 8,
	DSM_VALUE_UNII4_CANADA_OVERRIDE_MSK = 16,
	DSM_VALUE_UNII4_CANADA_EN_MSK = 32,
};

enum iwl_dsm_values_indonesia {
	DSM_VALUE_INDONESIA_DISABLE = 0,
	DSM_VALUE_INDONESIA_ENABLE = 1,
	DSM_VALUE_INDONESIA_RESERVED = 2,
	DSM_VALUE_INDONESIA_MAX = 3,
};

enum iwl_dsm_values_rfi {
	DSM_VALUE_RFI_DLVR_DISABLE = 1,
	DSM_VALUE_RFI_DDR_DISABLE = 2,
};

enum iwl_dsm_values_srd {
	DSM_VALUE_SRD_ACTIVE = 0,
	DSM_VALUE_SRD_PASSIVE = 1,
	DSM_VALUE_SRD_DISABLE = 2,
	DSM_VALUE_SRD_MAX = 3,
};

enum iwl_dump_control {
	DUMP_TX_FIFO_FLUSH = 2,
};

enum iwl_eeprom_channel_flags {
	EEPROM_CHANNEL_VALID = 1,
	EEPROM_CHANNEL_IBSS = 2,
	EEPROM_CHANNEL_ACTIVE = 8,
	EEPROM_CHANNEL_RADAR = 16,
	EEPROM_CHANNEL_WIDE = 32,
	EEPROM_CHANNEL_DFS = 128,
};

enum iwl_eeprom_enhanced_txpwr_flags {
	IWL_EEPROM_ENH_TXP_FL_VALID = 1,
	IWL_EEPROM_ENH_TXP_FL_BAND_52G = 2,
	IWL_EEPROM_ENH_TXP_FL_OFDM = 4,
	IWL_EEPROM_ENH_TXP_FL_40MHZ = 8,
	IWL_EEPROM_ENH_TXP_FL_HT_AP = 16,
	IWL_EEPROM_ENH_TXP_FL_RES1 = 32,
	IWL_EEPROM_ENH_TXP_FL_RES2 = 64,
	IWL_EEPROM_ENH_TXP_FL_COMMON_TYPE = 128,
};

enum iwl_err_mode {
	IWL_ERR_MODE_REGULAR = 0,
	IWL_ERR_MODE_RFKILL = 1,
	IWL_ERR_MODE_TRACE_ONLY = 2,
	IWL_ERR_MODE_RATELIMIT = 3,
};

enum iwl_error_event_table_status {
	IWL_ERROR_EVENT_TABLE_LMAC1 = 1,
	IWL_ERROR_EVENT_TABLE_LMAC2 = 2,
	IWL_ERROR_EVENT_TABLE_UMAC = 4,
	IWL_ERROR_EVENT_TABLE_TCM1 = 8,
	IWL_ERROR_EVENT_TABLE_TCM2 = 16,
	IWL_ERROR_EVENT_TABLE_RCM1 = 32,
	IWL_ERROR_EVENT_TABLE_RCM2 = 64,
};

enum iwl_error_recovery_flags {
	ERROR_RECOVERY_UPDATE_DB = 1,
	ERROR_RECOVERY_END_OF_RECOVERY = 2,
};

enum iwl_extended_cfg_flags {
	IWL_INIT_DEBUG_CFG = 0,
	IWL_INIT_NVM = 1,
	IWL_INIT_PHY = 2,
};

enum iwl_fw_dbg_monitor_mode {
	SMEM_MODE = 0,
	EXTERNAL_MODE = 1,
	MARBH_MODE = 2,
	MIPI_MODE = 3,
};

enum iwl_fw_dbg_reg_operator {
	CSR_ASSIGN = 0,
	CSR_SETBIT = 1,
	CSR_CLEARBIT = 2,
	PRPH_ASSIGN = 3,
	PRPH_SETBIT = 4,
	PRPH_CLEARBIT = 5,
	INDIRECT_ASSIGN = 6,
	INDIRECT_SETBIT = 7,
	INDIRECT_CLEARBIT = 8,
	PRPH_BLOCKBIT = 9,
};

enum iwl_fw_dbg_trigger {
	FW_DBG_TRIGGER_INVALID = 0,
	FW_DBG_TRIGGER_USER = 1,
	FW_DBG_TRIGGER_FW_ASSERT = 2,
	FW_DBG_TRIGGER_MISSED_BEACONS = 3,
	FW_DBG_TRIGGER_CHANNEL_SWITCH = 4,
	FW_DBG_TRIGGER_FW_NOTIF = 5,
	FW_DBG_TRIGGER_MLME = 6,
	FW_DBG_TRIGGER_STATS = 7,
	FW_DBG_TRIGGER_RSSI = 8,
	FW_DBG_TRIGGER_TXQ_TIMERS = 9,
	FW_DBG_TRIGGER_TIME_EVENT = 10,
	FW_DBG_TRIGGER_BA = 11,
	FW_DBG_TRIGGER_TX_LATENCY = 12,
	FW_DBG_TRIGGER_TDLS = 13,
	FW_DBG_TRIGGER_TX_STATUS = 14,
	FW_DBG_TRIGGER_ALIVE_TIMEOUT = 15,
	FW_DBG_TRIGGER_DRIVER = 16,
	FW_DBG_TRIGGER_MAX = 17,
};

enum iwl_fw_dbg_trigger_flags {
	IWL_FW_DBG_FORCE_RESTART = 1,
};

enum iwl_fw_dbg_trigger_mode {
	IWL_FW_DBG_TRIGGER_START = 1,
	IWL_FW_DBG_TRIGGER_STOP = 2,
	IWL_FW_DBG_TRIGGER_MONITOR_ONLY = 4,
};

enum iwl_fw_dbg_trigger_vif_type {
	IWL_FW_DBG_CONF_VIF_ANY = 0,
	IWL_FW_DBG_CONF_VIF_IBSS = 1,
	IWL_FW_DBG_CONF_VIF_STATION = 2,
	IWL_FW_DBG_CONF_VIF_AP = 3,
	IWL_FW_DBG_CONF_VIF_P2P_CLIENT = 8,
	IWL_FW_DBG_CONF_VIF_P2P_GO = 9,
	IWL_FW_DBG_CONF_VIF_P2P_DEVICE = 10,
};

enum iwl_fw_error_context {
	IWL_ERR_CONTEXT_WORKER = 0,
	IWL_ERR_CONTEXT_FROM_OPMODE = 1,
	IWL_ERR_CONTEXT_ABORT = 2,
};

enum iwl_fw_error_dump_mem_type {
	IWL_FW_ERROR_DUMP_MEM_SRAM = 0,
	IWL_FW_ERROR_DUMP_MEM_SMEM = 1,
	IWL_FW_ERROR_DUMP_MEM_NAMED_MEM = 10,
};

enum iwl_fw_error_dump_type {
	IWL_FW_ERROR_DUMP_CSR = 1,
	IWL_FW_ERROR_DUMP_RXF = 2,
	IWL_FW_ERROR_DUMP_TXCMD = 3,
	IWL_FW_ERROR_DUMP_DEV_FW_INFO = 4,
	IWL_FW_ERROR_DUMP_FW_MONITOR = 5,
	IWL_FW_ERROR_DUMP_PRPH = 6,
	IWL_FW_ERROR_DUMP_TXF = 7,
	IWL_FW_ERROR_DUMP_FH_REGS = 8,
	IWL_FW_ERROR_DUMP_MEM = 9,
	IWL_FW_ERROR_DUMP_ERROR_INFO = 10,
	IWL_FW_ERROR_DUMP_RB = 11,
	IWL_FW_ERROR_DUMP_PAGING = 12,
	IWL_FW_ERROR_DUMP_RADIO_REG = 13,
	IWL_FW_ERROR_DUMP_INTERNAL_TXF = 14,
	IWL_FW_ERROR_DUMP_EXTERNAL = 15,
	IWL_FW_ERROR_DUMP_MEM_CFG = 16,
	IWL_FW_ERROR_DUMP_D3_DEBUG_DATA = 17,
};

enum iwl_fw_error_type {
	IWL_ERR_TYPE_IRQ = 0,
	IWL_ERR_TYPE_NMI_FORCED = 1,
	IWL_ERR_TYPE_RESET_HS_TIMEOUT = 2,
	IWL_ERR_TYPE_CMD_QUEUE_FULL = 3,
};

enum iwl_fw_ini_allocation_id {
	IWL_FW_INI_ALLOCATION_INVALID = 0,
	IWL_FW_INI_ALLOCATION_ID_DBGC1 = 1,
	IWL_FW_INI_ALLOCATION_ID_DBGC2 = 2,
	IWL_FW_INI_ALLOCATION_ID_DBGC3 = 3,
	IWL_FW_INI_ALLOCATION_ID_DBGC4 = 4,
	IWL_FW_INI_ALLOCATION_NUM = 5,
};

enum iwl_fw_ini_buffer_location {
	IWL_FW_INI_LOCATION_INVALID = 0,
	IWL_FW_INI_LOCATION_SRAM_PATH = 1,
	IWL_FW_INI_LOCATION_DRAM_PATH = 2,
	IWL_FW_INI_LOCATION_NPK_PATH = 3,
	IWL_FW_INI_LOCATION_NUM = 4,
};

enum iwl_fw_ini_config_set_type {
	IWL_FW_INI_CONFIG_SET_TYPE_INVALID = 0,
	IWL_FW_INI_CONFIG_SET_TYPE_DEVICE_PERIPHERY_MAC = 1,
	IWL_FW_INI_CONFIG_SET_TYPE_DEVICE_PERIPHERY_PHY = 2,
	IWL_FW_INI_CONFIG_SET_TYPE_DEVICE_PERIPHERY_AUX = 3,
	IWL_FW_INI_CONFIG_SET_TYPE_DEVICE_MEMORY = 4,
	IWL_FW_INI_CONFIG_SET_TYPE_CSR = 5,
	IWL_FW_INI_CONFIG_SET_TYPE_DBGC_DRAM_ADDR = 6,
	IWL_FW_INI_CONFIG_SET_TYPE_PERIPH_SCRATCH_HWM = 7,
	IWL_FW_INI_CONFIG_SET_TYPE_MAX_NUM = 8,
} __attribute__((mode(byte)));

enum iwl_fw_ini_dump_policy {
	IWL_FW_INI_DEBUG_DUMP_POLICY_NO_LIMIT = 1,
	IWL_FW_INI_DEBUG_DUMP_POLICY_MAX_LIMIT_600KB = 2,
	IWL_FW_IWL_DEBUG_DUMP_POLICY_MAX_LIMIT_5MB = 4,
};

enum iwl_fw_ini_dump_type {
	IWL_FW_INI_DUMP_BRIEF = 0,
	IWL_FW_INI_DUMP_MEDIUM = 1,
	IWL_FW_INI_DUMP_VERBOSE = 2,
};

enum iwl_fw_ini_region_device_memory_subtype {
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_HW_SMEM = 1,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_UMAC_ERROR_TABLE = 5,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_LMAC_1_ERROR_TABLE = 7,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_LMAC_2_ERROR_TABLE = 10,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_TCM_1_ERROR_TABLE = 14,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_TCM_2_ERROR_TABLE = 16,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_RCM_1_ERROR_TABLE = 18,
	IWL_FW_INI_REGION_DEVICE_MEMORY_SUBTYPE_RCM_2_ERROR_TABLE = 20,
};

enum iwl_fw_ini_region_type {
	IWL_FW_INI_REGION_INVALID = 0,
	IWL_FW_INI_REGION_TLV = 1,
	IWL_FW_INI_REGION_INTERNAL_BUFFER = 2,
	IWL_FW_INI_REGION_DRAM_BUFFER = 3,
	IWL_FW_INI_REGION_TXF = 4,
	IWL_FW_INI_REGION_RXF = 5,
	IWL_FW_INI_REGION_LMAC_ERROR_TABLE = 6,
	IWL_FW_INI_REGION_UMAC_ERROR_TABLE = 7,
	IWL_FW_INI_REGION_RSP_OR_NOTIF = 8,
	IWL_FW_INI_REGION_DEVICE_MEMORY = 9,
	IWL_FW_INI_REGION_PERIPHERY_MAC = 10,
	IWL_FW_INI_REGION_PERIPHERY_PHY = 11,
	IWL_FW_INI_REGION_PERIPHERY_AUX = 12,
	IWL_FW_INI_REGION_PAGING = 13,
	IWL_FW_INI_REGION_CSR = 14,
	IWL_FW_INI_REGION_DRAM_IMR = 15,
	IWL_FW_INI_REGION_PCI_IOSF_CONFIG = 16,
	IWL_FW_INI_REGION_SPECIAL_DEVICE_MEMORY = 17,
	IWL_FW_INI_REGION_DBGI_SRAM = 18,
	IWL_FW_INI_REGION_PERIPHERY_MAC_RANGE = 19,
	IWL_FW_INI_REGION_PERIPHERY_PHY_RANGE = 20,
	IWL_FW_INI_REGION_PERIPHERY_SNPS_DPHYIP = 21,
	IWL_FW_INI_REGION_NUM = 22,
};

enum iwl_fw_ini_time_point {
	IWL_FW_INI_TIME_POINT_INVALID = 0,
	IWL_FW_INI_TIME_POINT_EARLY = 1,
	IWL_FW_INI_TIME_POINT_AFTER_ALIVE = 2,
	IWL_FW_INI_TIME_POINT_POST_INIT = 3,
	IWL_FW_INI_TIME_POINT_FW_ASSERT = 4,
	IWL_FW_INI_TIME_POINT_FW_HW_ERROR = 5,
	IWL_FW_INI_TIME_POINT_FW_TFD_Q_HANG = 6,
	IWL_FW_INI_TIME_POINT_FW_DHC_NOTIFICATION = 7,
	IWL_FW_INI_TIME_POINT_FW_RSP_OR_NOTIF = 8,
	IWL_FW_INI_TIME_POINT_USER_TRIGGER = 9,
	IWL_FW_INI_TIME_POINT_PERIODIC = 10,
	IWL_FW_INI_TIME_POINT_RESERVED = 11,
	IWL_FW_INI_TIME_POINT_HOST_ASSERT = 12,
	IWL_FW_INI_TIME_POINT_HOST_ALIVE_TIMEOUT = 13,
	IWL_FW_INI_TIME_POINT_HOST_DEVICE_ENABLE = 14,
	IWL_FW_INI_TIME_POINT_HOST_DEVICE_DISABLE = 15,
	IWL_FW_INI_TIME_POINT_HOST_D3_START = 16,
	IWL_FW_INI_TIME_POINT_HOST_D3_END = 17,
	IWL_FW_INI_TIME_POINT_MISSED_BEACONS = 18,
	IWL_FW_INI_TIME_POINT_ASSOC_FAILED = 19,
	IWL_FW_INI_TIME_POINT_TX_FAILED = 20,
	IWL_FW_INI_TIME_POINT_TX_WFD_ACTION_FRAME_FAILED = 21,
	IWL_FW_INI_TIME_POINT_TX_LATENCY_THRESHOLD = 22,
	IWL_FW_INI_TIME_POINT_HANG_OCCURRED = 23,
	IWL_FW_INI_TIME_POINT_EAPOL_FAILED = 24,
	IWL_FW_INI_TIME_POINT_FAKE_TX = 25,
	IWL_FW_INI_TIME_POINT_DEASSOC = 26,
	IWL_FW_INI_TIME_POINT_PRESET_OVERRIDE_EXT_REQ = 27,
	IWL_FW_INI_TIME_POINT_PRESET_OVERRIDE_START = 28,
	IWL_FW_INI_TIME_SCAN_FAILURE = 29,
	IWL_FW_INI_TIME_ESR_LINK_UP = 30,
	IWL_FW_INI_TIME_ESR_LINK_DOWN = 31,
	IWL_FW_INI_TIME_POINT_NUM = 32,
};

enum iwl_fw_ini_trigger_apply_policy {
	IWL_FW_INI_APPLY_POLICY_MATCH_TIME_POINT = 1,
	IWL_FW_INI_APPLY_POLICY_MATCH_DATA = 2,
	IWL_FW_INI_APPLY_POLICY_OVERRIDE_REGIONS = 256,
	IWL_FW_INI_APPLY_POLICY_OVERRIDE_CFG = 512,
	IWL_FW_INI_APPLY_POLICY_OVERRIDE_DATA = 1024,
	IWL_FW_INI_APPLY_POLICY_DUMP_COMPLETE_CMD = 65536,
};

enum iwl_fw_ini_trigger_reset_fw_policy {
	IWL_FW_INI_RESET_FW_MODE_NOTHING = 0,
	IWL_FW_INI_RESET_FW_MODE_STOP_FW_ONLY = 1,
	IWL_FW_INI_RESET_FW_MODE_STOP_AND_RELOAD_FW = 2,
};

enum iwl_fw_phy_cfg {
	FW_PHY_CFG_RADIO_TYPE_POS = 0,
	FW_PHY_CFG_RADIO_TYPE = 3,
	FW_PHY_CFG_RADIO_STEP_POS = 2,
	FW_PHY_CFG_RADIO_STEP = 12,
	FW_PHY_CFG_RADIO_DASH_POS = 4,
	FW_PHY_CFG_RADIO_DASH = 48,
	FW_PHY_CFG_TX_CHAIN_POS = 16,
	FW_PHY_CFG_TX_CHAIN = 983040,
	FW_PHY_CFG_RX_CHAIN_POS = 20,
	FW_PHY_CFG_RX_CHAIN = 15728640,
	FW_PHY_CFG_CHAIN_SAD_POS = 23,
	FW_PHY_CFG_CHAIN_SAD_ENABLED = 8388608,
	FW_PHY_CFG_CHAIN_SAD_ANT_A = 16777216,
	FW_PHY_CFG_CHAIN_SAD_ANT_B = 33554432,
	FW_PHY_CFG_SHARED_CLK = 2147483648,
};

enum iwl_fw_sta_type {
	STATION_TYPE_PEER = 0,
	STATION_TYPE_BCAST_MGMT = 1,
	STATION_TYPE_MCAST = 2,
	STATION_TYPE_AUX = 3,
};

enum iwl_fw_statistics_type {
	FW_STATISTICS_OPERATIONAL = 0,
	FW_STATISTICS_PHY = 1,
	FW_STATISTICS_MAC = 2,
	FW_STATISTICS_RX = 3,
	FW_STATISTICS_TX = 4,
	FW_STATISTICS_DURATION = 5,
	FW_STATISTICS_HE = 6,
};

enum iwl_fw_type {
	IWL_FW_DVM = 0,
	IWL_FW_MVM = 1,
};

enum iwl_geo_information {
	GEO_NO_INFO = 0,
	GEO_WMM_ETSI_5GHZ_INFO = 1,
};

enum iwl_geo_per_chain_offset_operation {
	IWL_PER_CHAIN_OFFSET_SET_TABLES = 0,
	IWL_PER_CHAIN_OFFSET_GET_CURRENT_TABLE = 1,
};

enum iwl_hcmd_dataflag {
	IWL_HCMD_DFL_NOCOPY = 1,
	IWL_HCMD_DFL_DUP = 2,
};

enum iwl_he_htc_flags {
	IWL_HE_HTC_SUPPORT = 1,
	IWL_HE_HTC_UL_MU_RESP_SCHED = 8,
	IWL_HE_HTC_BSR_SUPP = 16,
	IWL_HE_HTC_OMI_SUPP = 32,
	IWL_HE_HTC_BQR_SUPP = 64,
};

enum iwl_he_pkt_ext_constellations {
	IWL_HE_PKT_EXT_BPSK = 0,
	IWL_HE_PKT_EXT_QPSK = 1,
	IWL_HE_PKT_EXT_16QAM = 2,
	IWL_HE_PKT_EXT_64QAM = 3,
	IWL_HE_PKT_EXT_256QAM = 4,
	IWL_HE_PKT_EXT_1024QAM = 5,
	IWL_HE_PKT_EXT_4096QAM = 6,
	IWL_HE_PKT_EXT_NONE = 7,
};

enum iwl_he_sta_ctxt_flags {
	STA_CTXT_HE_REF_BSSID_VALID = 16,
	STA_CTXT_HE_BSS_COLOR_DIS = 32,
	STA_CTXT_HE_PARTIAL_BSS_COLOR = 64,
	STA_CTXT_HE_32BIT_BA_BITMAP = 128,
	STA_CTXT_HE_PACKET_EXT = 256,
	STA_CTXT_HE_TRIG_RND_ALLOC = 512,
	STA_CTXT_HE_CONST_TRIG_RND_ALLOC = 1024,
	STA_CTXT_HE_ACK_ENABLED = 2048,
	STA_CTXT_HE_MU_EDCA_CW = 4096,
	STA_CTXT_HE_NIC_NOT_ACK_ENABLED = 8192,
	STA_CTXT_HE_RU_2MHZ_BLOCK = 16384,
	STA_CTXT_HE_NDP_FEEDBACK_ENABLED = 32768,
	STA_CTXT_EHT_PUNCTURE_MASK_VALID = 65536,
	STA_CTXT_EHT_LONG_PPE_ENABLED = 131072,
};

enum iwl_ibss_manager {
	IWL_NOT_IBSS_MANAGER = 0,
	IWL_IBSS_MANAGER = 1,
};

enum iwl_ini_cfg_state {
	IWL_INI_CFG_STATE_NOT_LOADED = 0,
	IWL_INI_CFG_STATE_LOADED = 1,
	IWL_INI_CFG_STATE_CORRUPTED = 2,
};

enum iwl_initiator_ap_flags {
	IWL_INITIATOR_AP_FLAGS_ASAP = 2,
	IWL_INITIATOR_AP_FLAGS_LCI_REQUEST = 4,
	IWL_INITIATOR_AP_FLAGS_CIVIC_REQUEST = 8,
	IWL_INITIATOR_AP_FLAGS_DYN_ACK = 16,
	IWL_INITIATOR_AP_FLAGS_ALGO_LR = 32,
	IWL_INITIATOR_AP_FLAGS_ALGO_FFT = 64,
	IWL_INITIATOR_AP_FLAGS_MCSI_REPORT = 256,
	IWL_INITIATOR_AP_FLAGS_NON_TB = 512,
	IWL_INITIATOR_AP_FLAGS_TB = 1024,
	IWL_INITIATOR_AP_FLAGS_SECURED = 2048,
	IWL_INITIATOR_AP_FLAGS_LMR_FEEDBACK = 4096,
	IWL_INITIATOR_AP_FLAGS_USE_CALIB = 8192,
	IWL_INITIATOR_AP_FLAGS_PMF = 16384,
	IWL_INITIATOR_AP_FLAGS_TERMINATE_ON_LMR_FEEDBACK = 32768,
	IWL_INITIATOR_AP_FLAGS_TEST_INCORRECT_SAC = 65536,
	IWL_INITIATOR_AP_FLAGS_TEST_BAD_SLTF = 131072,
};

enum iwl_lari_config_masks {
	LARI_CONFIG_DISABLE_11AC_UKRAINE_MSK = 1,
	LARI_CONFIG_CHANGE_ETSI_TO_PASSIVE_MSK = 2,
	LARI_CONFIG_CHANGE_ETSI_TO_DISABLED_MSK = 4,
	LARI_CONFIG_ENABLE_5G2_IN_INDONESIA_MSK = 8,
	LARI_CONFIG_ENABLE_CHINA_22_REG_SUPPORT_MSK = 128,
};

enum iwl_led_mode {
	IWL_LED_DEFAULT = 0,
	IWL_LED_RF_STATE = 1,
	IWL_LED_BLINK = 2,
	IWL_LED_DISABLE = 3,
};

enum iwl_legacy_cmds {
	UCODE_ALIVE_NTFY = 1,
	REPLY_ERROR___2 = 2,
	ECHO_CMD = 3,
	INIT_COMPLETE_NOTIF = 4,
	PHY_CONTEXT_CMD = 8,
	DBG_CFG = 9,
	SCAN_ITERATION_COMPLETE_UMAC = 181,
	SCAN_CFG_CMD = 12,
	SCAN_REQ_UMAC = 13,
	SCAN_ABORT_UMAC = 14,
	SCAN_COMPLETE_UMAC = 15,
	BA_WINDOW_STATUS_NOTIFICATION_ID = 19,
	ADD_STA_KEY = 23,
	ADD_STA = 24,
	REMOVE_STA = 25,
	TX_CMD = 28,
	TXPATH_FLUSH = 30,
	MGMT_MCAST_KEY = 31,
	SCD_QUEUE_CFG = 29,
	WEP_KEY = 32,
	SHARED_MEM_CFG = 37,
	TDLS_CHANNEL_SWITCH_CMD = 39,
	TDLS_CHANNEL_SWITCH_NOTIFICATION = 170,
	TDLS_CONFIG_CMD = 167,
	MAC_CONTEXT_CMD = 40,
	TIME_EVENT_CMD = 41,
	TIME_EVENT_NOTIFICATION = 42,
	BINDING_CONTEXT_CMD = 43,
	TIME_QUOTA_CMD = 44,
	NON_QOS_TX_COUNTER_CMD = 45,
	LEDS_CMD = 72,
	LQ_CMD = 78,
	FW_PAGING_BLOCK_CMD = 79,
	SCAN_OFFLOAD_REQUEST_CMD = 81,
	SCAN_OFFLOAD_ABORT_CMD = 82,
	HOT_SPOT_CMD = 83,
	WNM_80211V_TIMING_MEASUREMENT_NOTIFICATION = 103,
	WNM_80211V_TIMING_MEASUREMENT_CONFIRM_NOTIFICATION = 104,
	SCAN_OFFLOAD_COMPLETE = 109,
	SCAN_OFFLOAD_UPDATE_PROFILES_CMD = 110,
	MATCH_FOUND_NOTIFICATION = 217,
	SCAN_ITERATION_COMPLETE = 231,
	PHY_CONFIGURATION_CMD = 106,
	CALIB_RES_NOTIF_PHY_DB = 107,
	PHY_DB_CMD = 108,
	POWER_TABLE_CMD___2 = 119,
	PSM_UAPSD_AP_MISBEHAVING_NOTIFICATION = 120,
	LTR_CONFIG = 238,
	REPLY_THERMAL_MNG_BACKOFF = 126,
	NVM_ACCESS_CMD = 136,
	BEACON_NOTIFICATION___2 = 144,
	BEACON_TEMPLATE_CMD = 145,
	TX_ANT_CONFIGURATION_CMD___2 = 152,
	STATISTICS_CMD = 156,
	STATISTICS_NOTIFICATION___2 = 157,
	EOSP_NOTIFICATION = 158,
	REDUCE_TX_POWER_CMD = 159,
	MISSED_BEACONS_NOTIFICATION___2 = 162,
	MAC_PM_POWER_TABLE = 169,
	MFUART_LOAD_NOTIFICATION = 177,
	RSS_CONFIG_CMD = 179,
	REPLY_RX_PHY_CMD___2 = 192,
	REPLY_RX_MPDU_CMD___2 = 193,
	BAR_FRAME_RELEASE = 194,
	FRAME_RELEASE = 195,
	BA_NOTIF = 197,
	MCC_UPDATE_CMD = 200,
	MCC_CHUB_UPDATE_CMD = 201,
	MARKER_CMD = 203,
	BT_PROFILE_NOTIFICATION = 206,
	BT_CONFIG = 155,
	BT_COEX_UPDATE_REDUCED_TXP = 92,
	BT_COEX_CI = 93,
	REPLY_SF_CFG_CMD = 209,
	REPLY_BEACON_FILTERING_CMD = 210,
	DTS_MEASUREMENT_NOTIFICATION = 221,
	LDBG_CONFIG_CMD = 246,
	DEBUG_LOG_MSG = 247,
	MCAST_FILTER_CMD = 208,
	D3_CONFIG_CMD = 211,
	PROT_OFFLOAD_CONFIG_CMD = 212,
	D0I3_END_CMD = 237,
	WOWLAN_PATTERNS = 224,
	WOWLAN_CONFIGURATION = 225,
	WOWLAN_TSC_RSC_PARAM = 226,
	WOWLAN_TKIP_PARAM = 227,
	WOWLAN_KEK_KCK_MATERIAL = 228,
	WOWLAN_GET_STATUSES = 229,
	SCAN_OFFLOAD_PROFILES_QUERY_CMD = 86,
};

enum iwl_link_ctx_flags {
	LINK_FLG_BSS_COLOR_DIS = 1,
	LINK_FLG_MU_EDCA_CW = 2,
	LINK_FLG_RU_2MHZ_BLOCK = 4,
	LINK_FLG_NDP_FEEDBACK_ENABLED = 8,
};

enum iwl_link_ctx_modify_flags {
	LINK_CONTEXT_MODIFY_ACTIVE = 1,
	LINK_CONTEXT_MODIFY_RATES_INFO = 2,
	LINK_CONTEXT_MODIFY_PROTECT_FLAGS = 4,
	LINK_CONTEXT_MODIFY_QOS_PARAMS = 8,
	LINK_CONTEXT_MODIFY_BEACON_TIMING = 16,
	LINK_CONTEXT_MODIFY_HE_PARAMS = 32,
	LINK_CONTEXT_MODIFY_BSS_COLOR_DISABLE = 64,
	LINK_CONTEXT_MODIFY_EHT_PARAMS = 128,
	LINK_CONTEXT_MODIFY_BANDWIDTH = 256,
	LINK_CONTEXT_MODIFY_ALL = 255,
};

enum iwl_link_ctx_protection_flags {
	LINK_PROT_FLG_TGG_PROTECT = 1,
	LINK_PROT_FLG_HT_PROT = 2,
	LINK_PROT_FLG_FAT_PROT = 4,
	LINK_PROT_FLG_SELF_CTS_EN = 8,
};

enum iwl_location_bw {
	IWL_LOCATION_BW_20MHZ = 0,
	IWL_LOCATION_BW_40MHZ = 1,
	IWL_LOCATION_BW_80MHZ = 2,
	IWL_LOCATION_BW_160MHZ = 3,
};

enum iwl_location_cipher {
	IWL_LOCATION_CIPHER_CCMP_128 = 0,
	IWL_LOCATION_CIPHER_GCMP_128 = 1,
	IWL_LOCATION_CIPHER_GCMP_256 = 2,
	IWL_LOCATION_CIPHER_INVALID = 3,
	IWL_LOCATION_CIPHER_MAX = 4,
};

enum iwl_location_frame_format {
	IWL_LOCATION_FRAME_FORMAT_LEGACY = 0,
	IWL_LOCATION_FRAME_FORMAT_HT = 1,
	IWL_LOCATION_FRAME_FORMAT_VHT = 2,
	IWL_LOCATION_FRAME_FORMAT_HE = 3,
};

enum iwl_location_subcmd_ids {
	TOF_RANGE_REQ_CMD = 0,
	TOF_CONFIG_CMD = 1,
	TOF_RANGE_ABORT_CMD = 2,
	TOF_RANGE_REQ_EXT_CMD = 3,
	TOF_RESPONDER_CONFIG_CMD = 4,
	TOF_RESPONDER_DYN_CONFIG_CMD = 5,
	CSI_HEADER_NOTIFICATION = 250,
	CSI_CHUNKS_NOTIFICATION = 251,
	TOF_LC_NOTIF = 252,
	TOF_RESPONDER_STATS = 253,
	TOF_MCSI_DEBUG_NOTIF = 254,
	TOF_RANGE_RESPONSE_NOTIF = 255,
};

enum iwl_mac_beacon_flags {
	IWL_MAC_BEACON_CCK = 32,
	IWL_MAC_BEACON_ANT_A = 64,
	IWL_MAC_BEACON_ANT_B = 128,
	IWL_MAC_BEACON_FILS = 256,
};

enum iwl_mac_beacon_flags_v1 {
	IWL_MAC_BEACON_CCK_V1 = 256,
	IWL_MAC_BEACON_ANT_A_V1 = 512,
	IWL_MAC_BEACON_ANT_B_V1 = 1024,
	IWL_MAC_BEACON_FILS_V1 = 4096,
};

enum iwl_mac_conf_subcmd_ids {
	LOW_LATENCY_CMD = 3,
	CHANNEL_SWITCH_TIME_EVENT_CMD = 4,
	MISSED_VAP_NOTIF = 250,
	SESSION_PROTECTION_CMD = 5,
	CANCEL_CHANNEL_SWITCH_CMD = 6,
	MAC_CONFIG_CMD = 8,
	LINK_CONFIG_CMD = 9,
	STA_CONFIG_CMD = 10,
	AUX_STA_CMD = 11,
	STA_REMOVE_CMD = 12,
	STA_DISABLE_TX_CMD = 13,
	ROC_CMD = 14,
	MISSED_BEACONS_NOTIF = 246,
	EMLSR_TRANS_FAIL_NOTIF = 247,
	ROC_NOTIF = 248,
	SESSION_PROTECTION_NOTIF = 251,
	PROBE_RESPONSE_DATA_NOTIF = 252,
	CHANNEL_SWITCH_START_NOTIF = 255,
	CHANNEL_SWITCH_ERROR_NOTIF = 249,
};

enum iwl_mac_config_filter_flags {
	MAC_CFG_FILTER_PROMISC = 1,
	MAC_CFG_FILTER_ACCEPT_CONTROL_AND_MGMT = 2,
	MAC_CFG_FILTER_ACCEPT_GRP = 4,
	MAC_CFG_FILTER_ACCEPT_BEACON = 8,
	MAC_CFG_FILTER_ACCEPT_BCAST_PROBE_RESP = 16,
	MAC_CFG_FILTER_ACCEPT_PROBE_REQ = 32,
};

enum iwl_mac_data_policy {
	TWT_SUPPORTED = 1,
	MORE_DATA_ACK_SUPPORTED = 2,
	FLEXIBLE_TWT_SUPPORTED = 4,
	PROTECTED_TWT_SUPPORTED = 8,
	BROADCAST_TWT_SUPPORTED = 16,
	COEX_HIGH_PRIORITY_ENABLE = 32,
};

enum iwl_mac_filter_flags {
	MAC_FILTER_IN_PROMISC = 1,
	MAC_FILTER_IN_CONTROL_AND_MGMT = 2,
	MAC_FILTER_ACCEPT_GRP = 4,
	MAC_FILTER_DIS_DECRYPT = 8,
	MAC_FILTER_DIS_GRP_DECRYPT = 16,
	MAC_FILTER_IN_BEACON = 64,
	MAC_FILTER_OUT_BCAST = 256,
	MAC_FILTER_IN_CRC32 = 2048,
	MAC_FILTER_IN_PROBE_REQUEST = 4096,
	MAC_FILTER_IN_11AX = 16384,
};

enum iwl_mac_protection_flags {
	MAC_PROT_FLG_TGG_PROTECT = 8,
	MAC_PROT_FLG_HT_PROT = 8388608,
	MAC_PROT_FLG_FAT_PROT = 16777216,
	MAC_PROT_FLG_SELF_CTS_EN = 1073741824,
};

enum iwl_mac_qos_flags {
	MAC_QOS_FLG_UPDATE_EDCA = 1,
	MAC_QOS_FLG_TGN = 2,
	MAC_QOS_FLG_TXOP_TYPE = 16,
};

enum iwl_mac_types {
	FW_MAC_TYPE_FIRST = 1,
	FW_MAC_TYPE_AUX = 1,
	FW_MAC_TYPE_LISTENER = 2,
	FW_MAC_TYPE_PIBSS = 3,
	FW_MAC_TYPE_IBSS = 4,
	FW_MAC_TYPE_BSS_STA = 5,
	FW_MAC_TYPE_P2P_DEVICE = 6,
	FW_MAC_TYPE_P2P_STA = 7,
	FW_MAC_TYPE_GO = 8,
	FW_MAC_TYPE_TEST = 9,
	FW_MAC_TYPE_MAX = 9,
};

enum iwl_mcc_source {
	MCC_SOURCE_OLD_FW = 0,
	MCC_SOURCE_ME = 1,
	MCC_SOURCE_BIOS = 2,
	MCC_SOURCE_3G_LTE_HOST = 3,
	MCC_SOURCE_3G_LTE_DEVICE = 4,
	MCC_SOURCE_WIFI = 5,
	MCC_SOURCE_RESERVED = 6,
	MCC_SOURCE_DEFAULT = 7,
	MCC_SOURCE_UNINITIALIZED = 8,
	MCC_SOURCE_MCC_API = 9,
	MCC_SOURCE_GET_CURRENT = 16,
	MCC_SOURCE_GETTING_MCC_TEST_MODE = 17,
};

enum iwl_mcc_update_status {
	MCC_RESP_NEW_CHAN_PROFILE = 0,
	MCC_RESP_SAME_CHAN_PROFILE = 1,
	MCC_RESP_INVALID = 2,
	MCC_RESP_NVM_DISABLED = 3,
	MCC_RESP_ILLEGAL = 4,
	MCC_RESP_LOW_PRIORITY = 5,
	MCC_RESP_TEST_MODE_ACTIVE = 6,
	MCC_RESP_TEST_MODE_NOT_ACTIVE = 7,
	MCC_RESP_TEST_MODE_DENIAL_OF_SERVICE = 8,
};

enum iwl_mei_nvm_caps {
	MEI_NVM_CAPS_LARI_SUPPORT = 1,
	MEI_NVM_CAPS_11AX_SUPPORT = 2,
};

enum iwl_mvm_add_sta_rsp_status {
	ADD_STA_SUCCESS = 1,
	ADD_STA_STATIONS_OVERLOAD = 2,
	ADD_STA_IMMEDIATE_BA_FAILURE = 4,
	ADD_STA_MODIFY_NON_EXISTING_STA = 8,
};

enum iwl_mvm_agg_state {
	IWL_AGG_OFF___2 = 0,
	IWL_AGG_QUEUED = 1,
	IWL_AGG_STARTING___2 = 2,
	IWL_AGG_ON___2 = 3,
	IWL_EMPTYING_HW_QUEUE_ADDBA___2 = 4,
	IWL_EMPTYING_HW_QUEUE_DELBA___2 = 5,
};

enum iwl_mvm_command_groups {
	LEGACY_GROUP = 0,
	LONG_GROUP = 1,
	SYSTEM_GROUP = 2,
	MAC_CONF_GROUP = 3,
	PHY_OPS_GROUP = 4,
	DATA_PATH_GROUP = 5,
	SCAN_GROUP = 6,
	NAN_GROUP = 7,
	LOCATION_GROUP = 8,
	BT_COEX_GROUP = 9,
	PROT_OFFLOAD_GROUP = 11,
	REGULATORY_AND_NVM_GROUP = 12,
	DEBUG_GROUP = 15,
	STATISTICS_GROUP = 16,
};

enum iwl_mvm_ctdp_cmd_operation {
	CTDP_CMD_OPERATION_START = 1,
	CTDP_CMD_OPERATION_STOP = 2,
	CTDP_CMD_OPERATION_REPORT = 4,
};

enum iwl_mvm_dqa_txq {
	IWL_MVM_DQA_CMD_QUEUE = 0,
	IWL_MVM_DQA_AUX_QUEUE = 1,
	IWL_MVM_DQA_P2P_DEVICE_QUEUE = 2,
	IWL_MVM_DQA_INJECT_MONITOR_QUEUE = 2,
	IWL_MVM_DQA_GCAST_QUEUE = 3,
	IWL_MVM_DQA_BSS_CLIENT_QUEUE = 4,
	IWL_MVM_DQA_MIN_MGMT_QUEUE = 5,
	IWL_MVM_DQA_MAX_MGMT_QUEUE = 8,
	IWL_MVM_DQA_AP_PROBE_RESP_QUEUE = 9,
	IWL_MVM_DQA_MIN_DATA_QUEUE = 10,
	IWL_MVM_DQA_MAX_DATA_QUEUE = 30,
};

enum iwl_mvm_esr_state {
	IWL_MVM_ESR_BLOCKED_PREVENTION = 1,
	IWL_MVM_ESR_BLOCKED_WOWLAN = 2,
	IWL_MVM_ESR_BLOCKED_TPT = 4,
	IWL_MVM_ESR_BLOCKED_FW = 8,
	IWL_MVM_ESR_BLOCKED_NON_BSS = 16,
	IWL_MVM_ESR_BLOCKED_ROC = 32,
	IWL_MVM_ESR_BLOCKED_TMP_NON_BSS = 64,
	IWL_MVM_ESR_EXIT_MISSED_BEACON = 65536,
	IWL_MVM_ESR_EXIT_LOW_RSSI = 131072,
	IWL_MVM_ESR_EXIT_COEX = 262144,
	IWL_MVM_ESR_EXIT_BANDWIDTH = 524288,
	IWL_MVM_ESR_EXIT_CSA = 1048576,
	IWL_MVM_ESR_EXIT_LINK_USAGE = 2097152,
	IWL_MVM_ESR_EXIT_FAIL_ENTRY = 4194304,
};

enum iwl_mvm_fw_esr_recommendation {
	ESR_RECOMMEND_LEAVE = 0,
	ESR_FORCE_LEAVE = 1,
	ESR_RECOMMEND_ENTER = 2,
};

enum iwl_mvm_init_status {
	IWL_MVM_INIT_STATUS_THERMAL_INIT_COMPLETE = 1,
	IWL_MVM_INIT_STATUS_LEDS_INIT_COMPLETE = 2,
};

enum iwl_mvm_lmac_scan_flags {
	IWL_MVM_LMAC_SCAN_FLAG_PASS_ALL = 1,
	IWL_MVM_LMAC_SCAN_FLAG_PASSIVE = 2,
	IWL_MVM_LMAC_SCAN_FLAG_PRE_CONNECTION = 4,
	IWL_MVM_LMAC_SCAN_FLAG_ITER_COMPLETE = 8,
	IWL_MVM_LMAC_SCAN_FLAG_MULTIPLE_SSIDS = 16,
	IWL_MVM_LMAC_SCAN_FLAG_FRAGMENTED = 32,
	IWL_MVM_LMAC_SCAN_FLAGS_RRM_ENABLED = 64,
	IWL_MVM_LMAC_SCAN_FLAG_EXTENDED_DWELL = 128,
	IWL_MVM_LMAC_SCAN_FLAG_MATCH = 512,
};

enum iwl_mvm_low_latency_cause {
	LOW_LATENCY_TRAFFIC = 1,
	LOW_LATENCY_DEBUGFS = 2,
	LOW_LATENCY_VCMD = 4,
	LOW_LATENCY_VIF_TYPE = 8,
	LOW_LATENCY_DEBUGFS_FORCE_ENABLE = 16,
	LOW_LATENCY_DEBUGFS_FORCE = 32,
};

enum iwl_mvm_pasn_flags {
	IWL_MVM_PASN_FLAG_HAS_HLTK = 1,
};

enum iwl_mvm_pm_event {
	IWL_MVM_PM_EVENT_AWAKE = 0,
	IWL_MVM_PM_EVENT_ASLEEP = 1,
	IWL_MVM_PM_EVENT_UAPSD = 2,
	IWL_MVM_PM_EVENT_PS_POLL = 3,
};

enum iwl_mvm_queue_status {
	IWL_MVM_QUEUE_FREE = 0,
	IWL_MVM_QUEUE_RESERVED = 1,
	IWL_MVM_QUEUE_READY = 2,
	IWL_MVM_QUEUE_SHARED = 3,
};

enum iwl_mvm_rx_status {
	RX_MPDU_RES_STATUS_CRC_OK = 1,
	RX_MPDU_RES_STATUS_OVERRUN_OK = 2,
	RX_MPDU_RES_STATUS_SRC_STA_FOUND = 4,
	RX_MPDU_RES_STATUS_KEY_VALID = 8,
	RX_MPDU_RES_STATUS_ICV_OK = 32,
	RX_MPDU_RES_STATUS_MIC_OK = 64,
	RX_MPDU_RES_STATUS_TTAK_OK = 128,
	RX_MPDU_RES_STATUS_MNG_FRAME_REPLAY_ERR = 128,
	RX_MPDU_RES_STATUS_SEC_NO_ENC = 0,
	RX_MPDU_RES_STATUS_SEC_WEP_ENC = 256,
	RX_MPDU_RES_STATUS_SEC_CCM_ENC = 512,
	RX_MPDU_RES_STATUS_SEC_TKIP_ENC = 768,
	RX_MPDU_RES_STATUS_SEC_EXT_ENC = 1024,
	RX_MPDU_RES_STATUS_SEC_CMAC_GMAC_ENC = 1536,
	RX_MPDU_RES_STATUS_SEC_ENC_ERR = 1792,
	RX_MPDU_RES_STATUS_SEC_ENC_MSK = 1792,
	RX_MPDU_RES_STATUS_DEC_DONE = 2048,
	RX_MPDU_RES_STATUS_CSUM_DONE = 65536,
	RX_MPDU_RES_STATUS_CSUM_OK = 131072,
	RX_MDPU_RES_STATUS_STA_ID_SHIFT = 24,
	RX_MPDU_RES_STATUS_STA_ID_MSK = 520093696,
};

enum iwl_mvm_rxq_notif_type {
	IWL_MVM_RXQ_EMPTY = 0,
	IWL_MVM_RXQ_NOTIF_DEL_BA = 1,
};

enum iwl_mvm_scan_type {
	IWL_SCAN_TYPE_NOT_SET = 0,
	IWL_SCAN_TYPE_UNASSOC = 1,
	IWL_SCAN_TYPE_WILD = 2,
	IWL_SCAN_TYPE_MILD = 3,
	IWL_SCAN_TYPE_FRAGMENTED = 4,
	IWL_SCAN_TYPE_FAST_BALANCE = 5,
};

enum iwl_mvm_sched_scan_pass_all_states {
	SCHED_SCAN_PASS_ALL_DISABLED = 0,
	SCHED_SCAN_PASS_ALL_ENABLED = 1,
	SCHED_SCAN_PASS_ALL_FOUND = 2,
};

enum iwl_mvm_smps_type_request {
	IWL_MVM_SMPS_REQ_BT_COEX = 0,
	IWL_MVM_SMPS_REQ_TT = 1,
	IWL_MVM_SMPS_REQ_PROT = 2,
	IWL_MVM_SMPS_REQ_FW = 3,
	NUM_IWL_MVM_SMPS_REQ = 4,
};

enum iwl_mvm_status {
	IWL_MVM_STATUS_HW_RFKILL = 0,
	IWL_MVM_STATUS_HW_CTKILL = 1,
	IWL_MVM_STATUS_ROC_P2P_RUNNING = 2,
	IWL_MVM_STATUS_HW_RESTART_REQUESTED = 3,
	IWL_MVM_STATUS_IN_HW_RESTART = 4,
	IWL_MVM_STATUS_ROC_AUX_RUNNING = 5,
	IWL_MVM_STATUS_FIRMWARE_RUNNING = 6,
	IWL_MVM_STATUS_IN_D3 = 7,
	IWL_MVM_STATUS_SUPPRESS_ERROR_LOG_ONCE = 8,
};

enum iwl_mvm_tdls_cs_state {
	IWL_MVM_TDLS_SW_IDLE = 0,
	IWL_MVM_TDLS_SW_REQ_SENT = 1,
	IWL_MVM_TDLS_SW_RESP_RCVD = 2,
	IWL_MVM_TDLS_SW_REQ_RCVD = 3,
	IWL_MVM_TDLS_SW_ACTIVE = 4,
};

enum iwl_mvm_traffic_load {
	IWL_MVM_TRAFFIC_LOW = 0,
	IWL_MVM_TRAFFIC_MEDIUM = 1,
	IWL_MVM_TRAFFIC_HIGH = 2,
};

enum iwl_mvm_tx_fifo {
	IWL_MVM_TX_FIFO_BK = 0,
	IWL_MVM_TX_FIFO_BE = 1,
	IWL_MVM_TX_FIFO_VI = 2,
	IWL_MVM_TX_FIFO_VO = 3,
	IWL_MVM_TX_FIFO_MCAST = 5,
	IWL_MVM_TX_FIFO_CMD = 7,
};

enum iwl_nvm_channel_flags {
	NVM_CHANNEL_VALID = 1,
	NVM_CHANNEL_IBSS = 2,
	NVM_CHANNEL_ACTIVE = 8,
	NVM_CHANNEL_RADAR = 16,
	NVM_CHANNEL_INDOOR_ONLY = 32,
	NVM_CHANNEL_GO_CONCURRENT = 64,
	NVM_CHANNEL_UNIFORM = 128,
	NVM_CHANNEL_20MHZ = 256,
	NVM_CHANNEL_40MHZ = 512,
	NVM_CHANNEL_80MHZ = 1024,
	NVM_CHANNEL_160MHZ = 2048,
	NVM_CHANNEL_DC_HIGH = 4096,
	NVM_CHANNEL_VLP = 8192,
	NVM_CHANNEL_AFC = 16384,
};

enum iwl_nvm_info_general_flags {
	NVM_GENERAL_FLAGS_EMPTY_OTP = 1,
};

enum iwl_nvm_mac_sku_flags {
	NVM_MAC_SKU_FLAGS_BAND_2_4_ENABLED = 1,
	NVM_MAC_SKU_FLAGS_BAND_5_2_ENABLED = 2,
	NVM_MAC_SKU_FLAGS_802_11N_ENABLED = 4,
	NVM_MAC_SKU_FLAGS_802_11AC_ENABLED = 8,
	NVM_MAC_SKU_FLAGS_802_11AX_ENABLED = 16,
	NVM_MAC_SKU_FLAGS_MIMO_DISABLED = 32,
	NVM_MAC_SKU_FLAGS_WAPI_ENABLED = 256,
	NVM_MAC_SKU_FLAGS_REG_CHECK_ENABLED = 16384,
	NVM_MAC_SKU_FLAGS_API_LOCK_ENABLED = 32768,
};

enum iwl_nvm_sbands_flags {
	IWL_NVM_SBANDS_FLAGS_LAR = 1,
	IWL_NVM_SBANDS_FLAGS_NO_WIDE_IN_5GHZ = 2,
};

enum iwl_nvm_section_type {
	NVM_SECTION_TYPE_SW = 1,
	NVM_SECTION_TYPE_REGULATORY = 3,
	NVM_SECTION_TYPE_CALIBRATION = 4,
	NVM_SECTION_TYPE_PRODUCTION = 5,
	NVM_SECTION_TYPE_REGULATORY_SDP = 8,
	NVM_SECTION_TYPE_MAC_OVERRIDE = 11,
	NVM_SECTION_TYPE_PHY_SKU = 12,
	NVM_MAX_NUM_SECTIONS = 13,
};

enum iwl_nvm_type {
	IWL_NVM = 0,
	IWL_NVM_EXT = 1,
	IWL_NVM_SDP = 2,
};

enum iwl_pcie_fw_reset_state {
	FW_RESET_IDLE = 0,
	FW_RESET_REQUESTED = 1,
	FW_RESET_OK = 2,
	FW_RESET_ERROR = 3,
};

enum iwl_pcie_imr_status {
	IMR_D2S_IDLE = 0,
	IMR_D2S_REQUESTED = 1,
	IMR_D2S_COMPLETED = 2,
	IMR_D2S_ERROR = 3,
};

enum iwl_phy_db_section_type {
	IWL_PHY_DB_CFG = 1,
	IWL_PHY_DB_CALIB_NCH = 2,
	IWL_PHY_DB_UNUSED = 3,
	IWL_PHY_DB_CALIB_CHG_PAPD = 4,
	IWL_PHY_DB_CALIB_CHG_TXP = 5,
	IWL_PHY_DB_MAX = 6,
};

enum iwl_phy_ops_subcmd_ids {
	CMD_DTS_MEASUREMENT_TRIGGER_WIDE = 0,
	CTDP_CONFIG_CMD = 3,
	TEMP_REPORTING_THRESHOLDS_CMD = 4,
	PER_CHAIN_LIMIT_OFFSET_CMD = 5,
	PER_PLATFORM_ANT_GAIN_CMD = 7,
	AP_TX_POWER_CONSTRAINTS_CMD = 12,
	CT_KILL_NOTIFICATION = 254,
	DTS_MEASUREMENT_NOTIF_WIDE = 255,
};

enum iwl_plat_pm_mode {
	IWL_PLAT_PM_MODE_DISABLED = 0,
	IWL_PLAT_PM_MODE_D3 = 1,
};

enum iwl_power_flags {
	POWER_FLAGS_POWER_SAVE_ENA_MSK = 1,
	POWER_FLAGS_POWER_MANAGEMENT_ENA_MSK = 2,
	POWER_FLAGS_SKIP_OVER_DTIM_MSK = 4,
	POWER_FLAGS_SNOOZE_ENA_MSK = 32,
	POWER_FLAGS_BT_SCO_ENA = 256,
	POWER_FLAGS_ADVANCE_PM_ENA_MSK = 512,
	POWER_FLAGS_LPRX_ENA_MSK = 2048,
	POWER_FLAGS_UAPSD_MISBEHAVING_ENA_MSK = 4096,
};

enum iwl_power_level {
	IWL_POWER_INDEX_1 = 0,
	IWL_POWER_INDEX_2 = 1,
	IWL_POWER_INDEX_3 = 2,
	IWL_POWER_INDEX_4 = 3,
	IWL_POWER_INDEX_5 = 4,
	IWL_POWER_NUM = 5,
};

enum iwl_power_scheme {
	IWL_POWER_SCHEME_CAM = 1,
	IWL_POWER_SCHEME_BPS = 2,
	IWL_POWER_SCHEME_LP = 3,
};

enum iwl_ppag_flags {
	IWL_PPAG_ETSI_MASK = 1,
	IWL_PPAG_CHINA_MASK = 2,
	IWL_PPAG_ETSI_LPI_UHB_MASK = 4,
	IWL_PPAG_ETSI_VLP_UHB_MASK = 8,
	IWL_PPAG_ETSI_SP_UHB_MASK = 16,
	IWL_PPAG_USA_LPI_UHB_MASK = 32,
	IWL_PPAG_USA_VLP_UHB_MASK = 64,
	IWL_PPAG_USA_SP_UHB_MASK = 128,
	IWL_PPAG_CANADA_LPI_UHB_MASK = 256,
	IWL_PPAG_CANADA_VLP_UHB_MASK = 512,
	IWL_PPAG_CANADA_SP_UHB_MASK = 1024,
};

enum iwl_prot_offload_subcmd_ids {
	WOWLAN_WAKE_PKT_NOTIFICATION = 252,
	WOWLAN_INFO_NOTIFICATION = 253,
	D3_END_NOTIFICATION = 254,
	STORED_BEACON_NTF = 255,
};

enum iwl_proto_offloads {
	IWL_D3_PROTO_OFFLOAD_ARP = 1,
	IWL_D3_PROTO_OFFLOAD_NS = 2,
	IWL_D3_PROTO_IPV4_VALID = 4,
	IWL_D3_PROTO_IPV6_VALID = 8,
	IWL_D3_PROTO_OFFLOAD_BTM = 16,
};

enum iwl_prph_scratch_ext_flags {
	IWL_PRPH_SCRATCH_EXT_URM_FW = 16,
	IWL_PRPH_SCRATCH_EXT_URM_PERM = 32,
};

enum iwl_prph_scratch_flags {
	IWL_PRPH_SCRATCH_IMR_DEBUG_EN = 2,
	IWL_PRPH_SCRATCH_EARLY_DEBUG_EN = 16,
	IWL_PRPH_SCRATCH_EDBG_DEST_DRAM = 256,
	IWL_PRPH_SCRATCH_EDBG_DEST_INTERNAL = 512,
	IWL_PRPH_SCRATCH_EDBG_DEST_ST_ARBITER = 1024,
	IWL_PRPH_SCRATCH_EDBG_DEST_TB22DTF = 2048,
	IWL_PRPH_SCRATCH_RB_SIZE_4K = 65536,
	IWL_PRPH_SCRATCH_MTR_MODE = 131072,
	IWL_PRPH_SCRATCH_MTR_FORMAT = 786432,
	IWL_PRPH_SCRATCH_RB_SIZE_EXT_MASK = 15728640,
	IWL_PRPH_SCRATCH_RB_SIZE_EXT_8K = 8388608,
	IWL_PRPH_SCRATCH_RB_SIZE_EXT_12K = 9437184,
	IWL_PRPH_SCRATCH_RB_SIZE_EXT_16K = 10485760,
	IWL_PRPH_SCRATCH_SCU_FORCE_ACTIVE = 536870912,
};

enum iwl_prph_scratch_mtr_format {
	IWL_PRPH_MTR_FORMAT_16B = 0,
	IWL_PRPH_MTR_FORMAT_32B = 262144,
	IWL_PRPH_MTR_FORMAT_64B = 524288,
	IWL_PRPH_MTR_FORMAT_256B = 786432,
};

enum iwl_reg_capa_flags_v1 {
	REG_CAPA_V1_BF_CCD_LOW_BAND = 1,
	REG_CAPA_V1_BF_CCD_HIGH_BAND = 2,
	REG_CAPA_V1_160MHZ_ALLOWED = 4,
	REG_CAPA_V1_80MHZ_ALLOWED = 8,
	REG_CAPA_V1_MCS_8_ALLOWED = 16,
	REG_CAPA_V1_MCS_9_ALLOWED = 32,
	REG_CAPA_V1_40MHZ_FORBIDDEN = 128,
	REG_CAPA_V1_DC_HIGH_ENABLED = 512,
	REG_CAPA_V1_11AX_DISABLED = 1024,
};

enum iwl_reg_capa_flags_v2 {
	REG_CAPA_V2_STRADDLE_DISABLED = 1,
	REG_CAPA_V2_BF_CCD_LOW_BAND = 2,
	REG_CAPA_V2_BF_CCD_HIGH_BAND = 4,
	REG_CAPA_V2_160MHZ_ALLOWED = 8,
	REG_CAPA_V2_80MHZ_ALLOWED = 16,
	REG_CAPA_V2_MCS_8_ALLOWED = 32,
	REG_CAPA_V2_MCS_9_ALLOWED = 64,
	REG_CAPA_V2_WEATHER_DISABLED = 128,
	REG_CAPA_V2_40MHZ_ALLOWED = 256,
	REG_CAPA_V2_11AX_DISABLED = 1024,
};

enum iwl_reg_capa_flags_v4 {
	REG_CAPA_V4_160MHZ_ALLOWED = 8,
	REG_CAPA_V4_80MHZ_ALLOWED = 16,
	REG_CAPA_V4_MCS_12_ALLOWED = 32,
	REG_CAPA_V4_MCS_13_ALLOWED = 64,
	REG_CAPA_V4_11BE_DISABLED = 256,
	REG_CAPA_V4_11AX_DISABLED = 8192,
	REG_CAPA_V4_320MHZ_ALLOWED = 65536,
};

enum iwl_regulatory_and_nvm_subcmd_ids {
	NVM_ACCESS_COMPLETE = 0,
	LARI_CONFIG_CHANGE = 1,
	NVM_GET_INFO = 2,
	TAS_CONFIG = 3,
	SAR_OFFSET_MAPPING_TABLE_CMD = 4,
	MCC_ALLOWED_AP_TYPE_CMD = 5,
	PNVM_INIT_COMPLETE_NTFY = 254,
};

enum iwl_reset_mode {
	IWL_RESET_MODE_SW_RESET = 0,
	IWL_RESET_MODE_REPROBE = 1,
	IWL_RESET_MODE_REMOVE_ONLY = 2,
	IWL_RESET_MODE_RESCAN = 3,
	IWL_RESET_MODE_FUNC_RESET = 4,
	IWL_RESET_MODE_PROD_RESET = 5,
};

enum iwl_responder_dyn_cfg_valid_flags {
	IWL_RESPONDER_DYN_CFG_VALID_LCI = 1,
	IWL_RESPONDER_DYN_CFG_VALID_CIVIC = 2,
	IWL_RESPONDER_DYN_CFG_VALID_PASN_STA = 4,
};

enum iwl_roc_activity {
	ROC_ACTIVITY_HOTSPOT = 0,
	ROC_ACTIVITY_P2P_DISC = 1,
	ROC_ACTIVITY_P2P_TXRX = 2,
	ROC_ACTIVITY_P2P_NEG = 3,
	ROC_NUM_ACTIVITIES = 4,
};

enum iwl_rx_baid_action {
	IWL_RX_BAID_ACTION_ADD = 0,
	IWL_RX_BAID_ACTION_MODIFY = 1,
	IWL_RX_BAID_ACTION_REMOVE = 2,
};

enum iwl_rx_handler_context {
	RX_HANDLER_SYNC = 0,
	RX_HANDLER_ASYNC_LOCKED = 1,
	RX_HANDLER_ASYNC_UNLOCKED = 2,
	RX_HANDLER_ASYNC_LOCKED_WIPHY = 3,
};

enum iwl_rx_l3_proto_values {
	IWL_RX_L3_TYPE_NONE = 0,
	IWL_RX_L3_TYPE_IPV4 = 1,
	IWL_RX_L3_TYPE_IPV4_FRAG = 2,
	IWL_RX_L3_TYPE_IPV6_FRAG = 3,
	IWL_RX_L3_TYPE_IPV6 = 4,
	IWL_RX_L3_TYPE_IPV6_IN_IPV4 = 5,
	IWL_RX_L3_TYPE_ARP = 6,
	IWL_RX_L3_TYPE_EAPOL = 7,
};

enum iwl_rx_l3l4_flags {
	IWL_RX_L3L4_IP_HDR_CSUM_OK = 1,
	IWL_RX_L3L4_TCP_UDP_CSUM_OK = 2,
	IWL_RX_L3L4_TCP_FIN_SYN_RST_PSH = 4,
	IWL_RX_L3L4_TCP_ACK = 8,
	IWL_RX_L3L4_L3_PROTO_MASK = 240,
	IWL_RX_L3L4_L4_PROTO_MASK = 3840,
	IWL_RX_L3L4_RSS_HASH_MASK = 61440,
};

enum iwl_rx_mpdu_amsdu_info {
	IWL_RX_MPDU_AMSDU_SUBFRAME_IDX_MASK = 127,
	IWL_RX_MPDU_AMSDU_LAST_SUBFRAME = 128,
};

enum iwl_rx_mpdu_mac_flags1 {
	IWL_RX_MDPU_MFLG1_ADDRTYPE_MASK = 3,
	IWL_RX_MPDU_MFLG1_MIC_CRC_LEN_MASK = 240,
	IWL_RX_MPDU_MFLG1_MIC_CRC_LEN_SHIFT = 3,
};

enum iwl_rx_mpdu_mac_flags2 {
	IWL_RX_MPDU_MFLG2_HDR_LEN_MASK = 31,
	IWL_RX_MPDU_MFLG2_PAD = 32,
	IWL_RX_MPDU_MFLG2_AMSDU = 64,
};

enum iwl_rx_mpdu_phy_info {
	IWL_RX_MPDU_PHY_AMPDU = 32,
	IWL_RX_MPDU_PHY_AMPDU_TOGGLE = 64,
	IWL_RX_MPDU_PHY_SHORT_PREAMBLE = 128,
	IWL_RX_MPDU_PHY_NCCK_ADDTL_NTFY = 128,
	IWL_RX_MPDU_PHY_TSF_OVERLOAD = 256,
};

enum iwl_rx_mpdu_reorder_data {
	IWL_RX_MPDU_REORDER_NSSN_MASK = 4095,
	IWL_RX_MPDU_REORDER_SN_MASK = 16773120,
	IWL_RX_MPDU_REORDER_SN_SHIFT = 12,
	IWL_RX_MPDU_REORDER_BAID_MASK = 2130706432,
	IWL_RX_MPDU_REORDER_BAID_SHIFT = 24,
	IWL_RX_MPDU_REORDER_BA_OLD_SN = 2147483648,
};

enum iwl_rx_mpdu_status {
	IWL_RX_MPDU_STATUS_CRC_OK = 1,
	IWL_RX_MPDU_STATUS_OVERRUN_OK = 2,
	IWL_RX_MPDU_STATUS_SRC_STA_FOUND = 4,
	IWL_RX_MPDU_STATUS_KEY_VALID = 8,
	IWL_RX_MPDU_STATUS_ICV_OK = 32,
	IWL_RX_MPDU_STATUS_MIC_OK = 64,
	IWL_RX_MPDU_RES_STATUS_TTAK_OK = 128,
	IWL_RX_MPDU_STATUS_REPLAY_ERROR = 128,
	IWL_RX_MPDU_STATUS_SEC_MASK = 1792,
	IWL_RX_MPDU_STATUS_SEC_UNKNOWN = 1792,
	IWL_RX_MPDU_STATUS_SEC_NONE = 0,
	IWL_RX_MPDU_STATUS_SEC_WEP = 256,
	IWL_RX_MPDU_STATUS_SEC_CCM = 512,
	IWL_RX_MPDU_STATUS_SEC_TKIP = 768,
	IWL_RX_MPDU_STATUS_SEC_EXT_ENC = 1024,
	IWL_RX_MPDU_STATUS_SEC_GCM = 1280,
	IWL_RX_MPDU_STATUS_DECRYPTED = 2048,
	IWL_RX_MPDU_STATUS_ROBUST_MNG_FRAME = 32768,
	IWL_RX_MPDU_STATUS_DUPLICATE = 4194304,
	IWL_RX_MPDU_STATUS_STA_ID = 520093696,
};

enum iwl_rx_phy_common_data1 {
	IWL_RX_PHY_DATA1_INFO_TYPE_MASK = 4026531840,
	IWL_RX_PHY_DATA1_LSIG_LEN_MASK = 268369920,
};

enum iwl_rx_phy_data5 {
	IWL_RX_PHY_DATA5_EHT_TYPE_AND_COMP = 3,
	IWL_RX_PHY_DATA5_EHT_TB_SPATIAL_REUSE1 = 60,
	IWL_RX_PHY_DATA5_EHT_TB_SPATIAL_REUSE2 = 960,
	IWL_RX_PHY_DATA5_EHT_MU_PUNC_CH_CODE = 124,
	IWL_RX_PHY_DATA5_EHT_MU_STA_ID_USR = 262016,
	IWL_RX_PHY_DATA5_EHT_MU_NUM_USR_NON_OFDMA = 1835008,
	IWL_RX_PHY_DATA5_EHT_MU_SPATIAL_CONF_USR_FIELD = 266338304,
};

enum iwl_rx_phy_eht_data0 {
	IWL_RX_PHY_DATA0_EHT_VALIDATE = 1,
	IWL_RX_PHY_DATA0_EHT_UPLINK = 2,
	IWL_RX_PHY_DATA0_EHT_BSS_COLOR_MASK = 252,
	IWL_RX_PHY_DATA0_ETH_SPATIAL_REUSE_MASK = 3840,
	IWL_RX_PHY_DATA0_EHT_PS160 = 4096,
	IWL_RX_PHY_DATA0_EHT_TXOP_DUR_MASK = 1040384,
	IWL_RX_PHY_DATA0_EHT_LDPC_EXT_SYM = 1048576,
	IWL_RX_PHY_DATA0_EHT_PRE_FEC_PAD_MASK = 6291456,
	IWL_RX_PHY_DATA0_EHT_PE_DISAMBIG = 8388608,
	IWL_RX_PHY_DATA0_EHT_BW320_SLOT = 16777216,
	IWL_RX_PHY_DATA0_EHT_SIGA_CRC_OK = 33554432,
	IWL_RX_PHY_DATA0_EHT_PHY_VER = 469762048,
	IWL_RX_PHY_DATA0_EHT_DELIM_EOF = 2147483648,
};

enum iwl_rx_phy_eht_data1 {
	IWL_RX_PHY_DATA1_EHT_MU_NUM_SIG_SYM_USIGA2 = 31,
	IWL_RX_PHY_DATA1_EHT_TB_PILOT_TYPE = 1,
	IWL_RX_PHY_DATA1_EHT_TB_LOW_SS = 30,
	IWL_RX_PHY_DATA1_EHT_SIG_LTF_NUM = 224,
	IWL_RX_PHY_DATA1_EHT_RU_ALLOC_B0 = 256,
	IWL_RX_PHY_DATA1_EHT_RU_ALLOC_B1_B7 = 65024,
};

enum iwl_rx_phy_eht_data2 {
	IWL_RX_PHY_DATA2_EHT_MU_EXT_RU_ALLOC_A1 = 511,
	IWL_RX_PHY_DATA2_EHT_MU_EXT_RU_ALLOC_A2 = 261632,
	IWL_RX_PHY_DATA2_EHT_MU_EXT_RU_ALLOC_B1 = 133955584,
	IWL_RX_PHY_DATA2_EHT_TB_EXT_TRIG_SIGA1 = 4294967295,
};

enum iwl_rx_phy_eht_data3 {
	IWL_RX_PHY_DATA3_EHT_MU_EXT_RU_ALLOC_C1 = 261632,
	IWL_RX_PHY_DATA3_EHT_MU_EXT_RU_ALLOC_C2 = 133955584,
};

enum iwl_rx_phy_eht_data4 {
	IWL_RX_PHY_DATA4_EHT_MU_EXT_RU_ALLOC_D1 = 511,
	IWL_RX_PHY_DATA4_EHT_MU_EXT_RU_ALLOC_D2 = 261632,
	IWL_RX_PHY_DATA4_EHT_MU_EXT_SIGB_MCS = 786432,
	IWL_RX_PHY_DATA4_EHT_MU_EXT_RU_ALLOC_B2 = 535822336,
};

enum iwl_rx_phy_flags {
	RX_RES_PHY_FLAGS_BAND_24 = 1,
	RX_RES_PHY_FLAGS_MOD_CCK = 2,
	RX_RES_PHY_FLAGS_SHORT_PREAMBLE = 4,
	RX_RES_PHY_FLAGS_NARROW_BAND = 8,
	RX_RES_PHY_FLAGS_ANTENNA = 112,
	RX_RES_PHY_FLAGS_ANTENNA_POS = 4,
	RX_RES_PHY_FLAGS_AGG = 128,
	RX_RES_PHY_FLAGS_OFDM_HT = 256,
	RX_RES_PHY_FLAGS_OFDM_GF = 512,
	RX_RES_PHY_FLAGS_OFDM_VHT = 1024,
};

enum iwl_rx_phy_he_data0 {
	IWL_RX_PHY_DATA0_HE_BEAM_CHNG = 1,
	IWL_RX_PHY_DATA0_HE_UPLINK = 2,
	IWL_RX_PHY_DATA0_HE_BSS_COLOR_MASK = 252,
	IWL_RX_PHY_DATA0_HE_SPATIAL_REUSE_MASK = 3840,
	IWL_RX_PHY_DATA0_HE_TXOP_DUR_MASK = 1040384,
	IWL_RX_PHY_DATA0_HE_LDPC_EXT_SYM = 1048576,
	IWL_RX_PHY_DATA0_HE_PRE_FEC_PAD_MASK = 6291456,
	IWL_RX_PHY_DATA0_HE_PE_DISAMBIG = 8388608,
	IWL_RX_PHY_DATA0_HE_DOPPLER = 16777216,
	IWL_RX_PHY_DATA0_HE_DELIM_EOF = 2147483648,
};

enum iwl_rx_phy_he_data1 {
	IWL_RX_PHY_DATA1_HE_MU_SIGB_COMPRESSION = 1,
	IWL_RX_PHY_DATA1_HE_MU_SIBG_SYM_OR_USER_NUM_MASK = 30,
	IWL_RX_PHY_DATA1_HE_LTF_NUM_MASK = 224,
	IWL_RX_PHY_DATA1_HE_RU_ALLOC_SEC80 = 256,
	IWL_RX_PHY_DATA1_HE_RU_ALLOC_MASK = 65024,
	IWL_RX_PHY_DATA1_HE_TB_PILOT_TYPE = 1,
	IWL_RX_PHY_DATA1_HE_TB_LOW_SS_MASK = 14,
};

enum iwl_rx_phy_he_data2 {
	IWL_RX_PHY_DATA2_HE_MU_EXT_CH1_RU0 = 255,
	IWL_RX_PHY_DATA2_HE_MU_EXT_CH1_RU2 = 65280,
	IWL_RX_PHY_DATA2_HE_MU_EXT_CH2_RU0 = 16711680,
	IWL_RX_PHY_DATA2_HE_MU_EXT_CH2_RU2 = 4278190080,
	IWL_RX_PHY_DATA2_HE_TB_EXT_SPTL_REUSE1 = 15,
	IWL_RX_PHY_DATA2_HE_TB_EXT_SPTL_REUSE2 = 240,
	IWL_RX_PHY_DATA2_HE_TB_EXT_SPTL_REUSE3 = 3840,
	IWL_RX_PHY_DATA2_HE_TB_EXT_SPTL_REUSE4 = 61440,
};

enum iwl_rx_phy_he_data3 {
	IWL_RX_PHY_DATA3_HE_MU_EXT_CH1_RU1 = 255,
	IWL_RX_PHY_DATA3_HE_MU_EXT_CH1_RU3 = 65280,
	IWL_RX_PHY_DATA3_HE_MU_EXT_CH2_RU1 = 16711680,
	IWL_RX_PHY_DATA3_HE_MU_EXT_CH2_RU3 = 4278190080,
};

enum iwl_rx_phy_he_he_data4 {
	IWL_RX_PHY_DATA4_HE_MU_EXT_CH1_CTR_RU = 1,
	IWL_RX_PHY_DATA4_HE_MU_EXT_CH2_CTR_RU = 2,
	IWL_RX_PHY_DATA4_HE_MU_EXT_CH1_CRC_OK = 4,
	IWL_RX_PHY_DATA4_HE_MU_EXT_CH2_CRC_OK = 8,
	IWL_RX_PHY_DATA4_HE_MU_EXT_SIGB_MCS_MASK = 240,
	IWL_RX_PHY_DATA4_HE_MU_EXT_SIGB_DCM = 256,
	IWL_RX_PHY_DATA4_HE_MU_EXT_PREAMBLE_PUNC_TYPE_MASK = 1536,
};

enum iwl_rx_phy_info_type {
	IWL_RX_PHY_INFO_TYPE_NONE = 0,
	IWL_RX_PHY_INFO_TYPE_CCK = 1,
	IWL_RX_PHY_INFO_TYPE_OFDM_LGCY = 2,
	IWL_RX_PHY_INFO_TYPE_HT = 3,
	IWL_RX_PHY_INFO_TYPE_VHT_SU = 4,
	IWL_RX_PHY_INFO_TYPE_VHT_MU = 5,
	IWL_RX_PHY_INFO_TYPE_HE_SU = 6,
	IWL_RX_PHY_INFO_TYPE_HE_MU = 7,
	IWL_RX_PHY_INFO_TYPE_HE_TB = 8,
	IWL_RX_PHY_INFO_TYPE_HE_MU_EXT = 9,
	IWL_RX_PHY_INFO_TYPE_HE_TB_EXT = 10,
	IWL_RX_PHY_INFO_TYPE_EHT_MU = 11,
	IWL_RX_PHY_INFO_TYPE_EHT_TB = 12,
	IWL_RX_PHY_INFO_TYPE_EHT_MU_EXT = 13,
	IWL_RX_PHY_INFO_TYPE_EHT_TB_EXT = 14,
};

enum iwl_rx_usig_a1 {
	IWL_RX_USIG_A1_ENHANCED_WIFI_VER_ID = 7,
	IWL_RX_USIG_A1_BANDWIDTH = 56,
	IWL_RX_USIG_A1_UL_FLAG = 64,
	IWL_RX_USIG_A1_BSS_COLOR = 8064,
	IWL_RX_USIG_A1_TXOP_DURATION = 1040384,
	IWL_RX_USIG_A1_DISREGARD = 32505856,
	IWL_RX_USIG_A1_VALIDATE = 33554432,
	IWL_RX_USIG_A1_EHT_BW320_SLOT = 67108864,
	IWL_RX_USIG_A1_EHT_TYPE = 402653184,
	IWL_RX_USIG_A1_RDY = 2147483648,
};

enum iwl_rx_usig_a2_eht {
	IWL_RX_USIG_A2_EHT_PPDU_TYPE = 3,
	IWL_RX_USIG_A2_EHT_USIG2_VALIDATE_B2 = 4,
	IWL_RX_USIG_A2_EHT_PUNC_CHANNEL = 248,
	IWL_RX_USIG_A2_EHT_USIG2_VALIDATE_B8 = 256,
	IWL_RX_USIG_A2_EHT_SIG_MCS = 1536,
	IWL_RX_USIG_A2_EHT_SIG_SYM_NUM = 63488,
	IWL_RX_USIG_A2_EHT_TRIG_SPATIAL_REUSE_1 = 983040,
	IWL_RX_USIG_A2_EHT_TRIG_SPATIAL_REUSE_2 = 15728640,
	IWL_RX_USIG_A2_EHT_TRIG_USIG2_DISREGARD = 520093696,
	IWL_RX_USIG_A2_EHT_CRC_OK = 1073741824,
	IWL_RX_USIG_A2_EHT_RDY = 2147483648,
};

enum iwl_rxon_context_id {
	IWL_RXON_CTX_BSS = 0,
	IWL_RXON_CTX_PAN = 1,
	NUM_IWL_RXON_CTX = 2,
};

enum iwl_scan_channel_flags {
	IWL_SCAN_CHANNEL_FLAG_EBS = 1,
	IWL_SCAN_CHANNEL_FLAG_EBS_ACCURATE = 2,
	IWL_SCAN_CHANNEL_FLAG_CACHE_ADD = 4,
	IWL_SCAN_CHANNEL_FLAG_EBS_FRAG = 8,
	IWL_SCAN_CHANNEL_FLAG_FORCE_EBS = 16,
	IWL_SCAN_CHANNEL_FLAG_ENABLE_CHAN_ORDER = 32,
	IWL_SCAN_CHANNEL_FLAG_6G_PSC_NO_FILTER = 64,
};

enum iwl_scan_channel_flags_lmac {
	IWL_UNIFIED_SCAN_CHANNEL_FULL = 134217728,
	IWL_UNIFIED_SCAN_CHANNEL_PARTIAL = 268435456,
};

enum iwl_scan_ebs_status {
	IWL_SCAN_EBS_SUCCESS = 0,
	IWL_SCAN_EBS_FAILED = 1,
	IWL_SCAN_EBS_CHAN_NOT_FOUND = 2,
	IWL_SCAN_EBS_INACTIVE = 3,
};

enum iwl_scan_offload_auth_alg {
	IWL_AUTH_ALGO_UNSUPPORTED = 0,
	IWL_AUTH_ALGO_NONE = 1,
	IWL_AUTH_ALGO_PSK = 2,
	IWL_AUTH_ALGO_8021X = 4,
	IWL_AUTH_ALGO_SAE = 8,
	IWL_AUTH_ALGO_8021X_SHA384 = 16,
	IWL_AUTH_ALGO_OWE = 32,
};

enum iwl_scan_offload_band_selection {
	IWL_SCAN_OFFLOAD_SELECT_2_4 = 4,
	IWL_SCAN_OFFLOAD_SELECT_5_2 = 8,
	IWL_SCAN_OFFLOAD_SELECT_ANY = 12,
};

enum iwl_scan_offload_complete_status {
	IWL_SCAN_OFFLOAD_COMPLETED = 1,
	IWL_SCAN_OFFLOAD_ABORTED = 2,
};

enum iwl_scan_offload_network_type {
	IWL_NETWORK_TYPE_BSS = 1,
	IWL_NETWORK_TYPE_IBSS = 2,
	IWL_NETWORK_TYPE_ANY = 3,
};

enum iwl_scan_priority_ext {
	IWL_SCAN_PRIORITY_EXT_0_LOWEST = 0,
	IWL_SCAN_PRIORITY_EXT_1 = 1,
	IWL_SCAN_PRIORITY_EXT_2 = 2,
	IWL_SCAN_PRIORITY_EXT_3 = 3,
	IWL_SCAN_PRIORITY_EXT_4 = 4,
	IWL_SCAN_PRIORITY_EXT_5 = 5,
	IWL_SCAN_PRIORITY_EXT_6 = 6,
	IWL_SCAN_PRIORITY_EXT_7_HIGHEST = 7,
};

enum iwl_scan_status {
	IWL_MVM_SCAN_REGULAR = 1,
	IWL_MVM_SCAN_SCHED = 2,
	IWL_MVM_SCAN_NETDETECT = 4,
	IWL_MVM_SCAN_INT_MLO = 8,
	IWL_MVM_SCAN_STOPPING_REGULAR = 256,
	IWL_MVM_SCAN_STOPPING_SCHED = 512,
	IWL_MVM_SCAN_STOPPING_NETDETECT = 1024,
	IWL_MVM_SCAN_STOPPING_INT_MLO = 2048,
	IWL_MVM_SCAN_REGULAR_MASK = 257,
	IWL_MVM_SCAN_SCHED_MASK = 514,
	IWL_MVM_SCAN_NETDETECT_MASK = 1028,
	IWL_MVM_SCAN_INT_MLO_MASK = 2056,
	IWL_MVM_SCAN_STOPPING_MASK = 65280,
	IWL_MVM_SCAN_MASK = 255,
};

enum iwl_scan_subcmd_ids {
	CHANNEL_SURVEY_NOTIF = 251,
	OFFLOAD_MATCH_INFO_NOTIF = 252,
};

enum iwl_scan_type {
	IWL_SCAN_NORMAL = 0,
	IWL_SCAN_RADIO_RESET = 1,
};

enum iwl_scd_cfg_actions {
	SCD_CFG_DISABLE_QUEUE = 0,
	SCD_CFG_ENABLE_QUEUE = 1,
	SCD_CFG_UPDATE_QUEUE_TID = 2,
};

enum iwl_scd_queue_cfg_operation {
	IWL_SCD_QUEUE_ADD = 0,
	IWL_SCD_QUEUE_REMOVE = 1,
	IWL_SCD_QUEUE_MODIFY = 2,
};

enum iwl_sec_key_flags {
	IWL_SEC_KEY_FLAG_CIPHER_MASK = 7,
	IWL_SEC_KEY_FLAG_CIPHER_WEP = 1,
	IWL_SEC_KEY_FLAG_CIPHER_CCMP = 2,
	IWL_SEC_KEY_FLAG_CIPHER_TKIP = 3,
	IWL_SEC_KEY_FLAG_CIPHER_GCMP = 5,
	IWL_SEC_KEY_FLAG_NO_TX = 8,
	IWL_SEC_KEY_FLAG_KEY_SIZE = 16,
	IWL_SEC_KEY_FLAG_MFP = 32,
	IWL_SEC_KEY_FLAG_MCAST_KEY = 64,
	IWL_SEC_KEY_FLAG_SPP_AMSDU = 128,
};

enum iwl_session_prot_conf_id {
	SESSION_PROTECT_CONF_ASSOC = 0,
	SESSION_PROTECT_CONF_GO_CLIENT_ASSOC = 1,
	SESSION_PROTECT_CONF_P2P_DEVICE_DISCOV = 2,
	SESSION_PROTECT_CONF_P2P_GO_NEGOTIATION = 3,
	SESSION_PROTECT_CONF_MAX_ID = 4,
};

enum iwl_sf_scenario {
	SF_SCENARIO_SINGLE_UNICAST = 0,
	SF_SCENARIO_AGG_UNICAST = 1,
	SF_SCENARIO_MULTICAST = 2,
	SF_SCENARIO_BA_RESP = 3,
	SF_SCENARIO_TX_RESP = 4,
	SF_NUM_SCENARIO = 5,
};

enum iwl_sf_state {
	SF_LONG_DELAY_ON = 0,
	SF_FULL_ON = 1,
	SF_UNINIT = 2,
	SF_INIT_OFF = 3,
	SF_HW_NUM_STATES = 4,
};

enum iwl_shared_irq_flags {
	IWL_SHARED_IRQ_NON_RX = 1,
	IWL_SHARED_IRQ_FIRST_RSS = 2,
};

enum iwl_sta_flags {
	STA_FLG_REDUCED_TX_PWR_CTRL = 8,
	STA_FLG_REDUCED_TX_PWR_DATA = 64,
	STA_FLG_DISABLE_TX = 16,
	STA_FLG_PS = 256,
	STA_FLG_DRAIN_FLOW = 4096,
	STA_FLG_PAN = 8192,
	STA_FLG_CLASS_AUTH = 16384,
	STA_FLG_CLASS_ASSOC = 32768,
	STA_FLG_RTS_MIMO_PROT = 131072,
	STA_FLG_MAX_AGG_SIZE_SHIFT = 19,
	STA_FLG_MAX_AGG_SIZE_8K = 0,
	STA_FLG_MAX_AGG_SIZE_16K = 524288,
	STA_FLG_MAX_AGG_SIZE_32K = 1048576,
	STA_FLG_MAX_AGG_SIZE_64K = 1572864,
	STA_FLG_MAX_AGG_SIZE_128K = 2097152,
	STA_FLG_MAX_AGG_SIZE_256K = 2621440,
	STA_FLG_MAX_AGG_SIZE_512K = 3145728,
	STA_FLG_MAX_AGG_SIZE_1024K = 3670016,
	STA_FLG_MAX_AGG_SIZE_2M = 4194304,
	STA_FLG_MAX_AGG_SIZE_4M = 4718592,
	STA_FLG_MAX_AGG_SIZE_MSK = 7864320,
	STA_FLG_AGG_MPDU_DENS_SHIFT = 23,
	STA_FLG_AGG_MPDU_DENS_2US = 33554432,
	STA_FLG_AGG_MPDU_DENS_4US = 41943040,
	STA_FLG_AGG_MPDU_DENS_8US = 50331648,
	STA_FLG_AGG_MPDU_DENS_16US = 58720256,
	STA_FLG_AGG_MPDU_DENS_MSK = 58720256,
	STA_FLG_FAT_EN_20MHZ = 0,
	STA_FLG_FAT_EN_40MHZ = 67108864,
	STA_FLG_FAT_EN_80MHZ = 134217728,
	STA_FLG_FAT_EN_160MHZ = 201326592,
	STA_FLG_FAT_EN_MSK = 201326592,
	STA_FLG_MIMO_EN_SISO = 0,
	STA_FLG_MIMO_EN_MIMO2 = 268435456,
	STA_FLG_MIMO_EN_MIMO3 = 536870912,
	STA_FLG_MIMO_EN_MSK = 805306368,
};

enum iwl_sta_key_flag {
	STA_KEY_FLG_NO_ENC = 0,
	STA_KEY_FLG_WEP = 1,
	STA_KEY_FLG_CCM = 2,
	STA_KEY_FLG_TKIP = 3,
	STA_KEY_FLG_EXT = 4,
	STA_KEY_FLG_GCMP = 5,
	STA_KEY_FLG_CMAC = 6,
	STA_KEY_FLG_ENC_UNKNOWN = 7,
	STA_KEY_FLG_EN_MSK = 7,
	STA_KEY_FLG_WEP_KEY_MAP = 8,
	STA_KEY_FLG_AMSDU_SPP = 128,
	STA_KEY_FLG_KEYID_POS = 8,
	STA_KEY_FLG_KEYID_MSK = 768,
	STA_KEY_NOT_VALID = 2048,
	STA_KEY_FLG_WEP_13BYTES = 4096,
	STA_KEY_FLG_KEY_32BYTES = 4096,
	STA_KEY_MULTICAST = 16384,
	STA_KEY_MFP = 32768,
};

enum iwl_sta_mode {
	STA_MODE_ADD = 0,
	STA_MODE_MODIFY = 1,
};

enum iwl_sta_modify_flag {
	STA_MODIFY_QUEUE_REMOVAL = 1,
	STA_MODIFY_TID_DISABLE_TX = 2,
	STA_MODIFY_UAPSD_ACS = 4,
	STA_MODIFY_ADD_BA_TID = 8,
	STA_MODIFY_REMOVE_BA_TID = 16,
	STA_MODIFY_SLEEPING_STA_TX_COUNT = 32,
	STA_MODIFY_PROT_TH = 64,
	STA_MODIFY_QUEUES = 128,
};

enum iwl_sta_sleep_flag {
	STA_SLEEP_STATE_AWAKE = 0,
	STA_SLEEP_STATE_PS_POLL = 1,
	STA_SLEEP_STATE_UAPSD = 2,
	STA_SLEEP_STATE_MOREDATA = 4,
};

enum iwl_sta_type {
	IWL_STA_LINK = 0,
	IWL_STA_GENERAL_PURPOSE = 1,
	IWL_STA_MULTICAST = 2,
	IWL_STA_TDLS_LINK = 3,
	IWL_STA_AUX_ACTIVITY = 4,
};

enum iwl_statistics_cfg_flags {
	IWL_STATS_CFG_FLG_DISABLE_NTFY_MSK = 1,
	IWL_STATS_CFG_FLG_ON_DEMAND_NTFY_MSK = 2,
	IWL_STATS_CFG_FLG_RESET_MSK = 4,
};

enum iwl_statistics_cmd_flags {
	IWL_STATISTICS_FLG_CLEAR = 1,
	IWL_STATISTICS_FLG_DISABLE_NOTIF = 2,
};

enum iwl_statistics_notif_flags {
	IWL_STATISTICS_REPLY_FLG_CLEAR = 1,
};

enum iwl_statistics_notify_type_id {
	IWL_STATS_NTFY_TYPE_ID_OPER = 1,
	IWL_STATS_NTFY_TYPE_ID_OPER_PART1 = 2,
	IWL_STATS_NTFY_TYPE_ID_OPER_PART2 = 4,
	IWL_STATS_NTFY_TYPE_ID_OPER_PART3 = 8,
	IWL_STATS_NTFY_TYPE_ID_OPER_PART4 = 16,
};

enum iwl_statistics_subcmd_ids {
	STATISTICS_OPER_NOTIF = 0,
	STATISTICS_OPER_PART1_NOTIF = 1,
};

enum iwl_system_subcmd_ids {
	SHARED_MEM_CFG_CMD = 0,
	SOC_CONFIGURATION_CMD = 1,
	INIT_EXTENDED_CFG_CMD = 3,
	FW_ERROR_RECOVERY_CMD = 7,
	RFI_CONFIG_CMD = 11,
	RFI_GET_FREQ_TABLE_CMD = 12,
	SYSTEM_FEATURES_CONTROL_CMD = 13,
	SYSTEM_STATISTICS_CMD = 15,
	SYSTEM_STATISTICS_END_NOTIF = 253,
	RFI_DEACTIVATE_NOTIF = 255,
};

enum iwl_table_type {
	LQ_NONE = 0,
	LQ_G = 1,
	LQ_A = 2,
	LQ_SISO = 3,
	LQ_MIMO2 = 4,
	LQ_MIMO3 = 5,
	LQ_MAX = 6,
};

enum iwl_table_type___2 {
	LQ_NONE___2 = 0,
	LQ_LEGACY_G = 1,
	LQ_LEGACY_A = 2,
	LQ_HT_SISO = 3,
	LQ_HT_MIMO2 = 4,
	LQ_VHT_SISO = 5,
	LQ_VHT_MIMO2 = 6,
	LQ_HE_SISO = 7,
	LQ_HE_MIMO2 = 8,
	LQ_MAX___2 = 9,
};

enum iwl_tas_uhb_allowed_flags {
	TAS_UHB_ALLOWED_CANADA = 1,
};

enum iwl_tdls_channel_switch_type {
	TDLS_SEND_CHAN_SW_REQ = 0,
	TDLS_SEND_CHAN_SW_RESP_AND_MOVE_CH = 1,
	TDLS_MOVE_CH = 2,
};

enum iwl_thermal_dual_chain_req_events {
	THERMAL_DUAL_CHAIN_REQ_ENABLE = 0,
	THERMAL_DUAL_CHAIN_REQ_DISABLE = 1,
};

enum iwl_time_event_policy {
	TE_V2_DEFAULT_POLICY = 0,
	TE_V2_NOTIF_HOST_EVENT_START = 1,
	TE_V2_NOTIF_HOST_EVENT_END = 2,
	TE_V2_NOTIF_INTERNAL_EVENT_START = 4,
	TE_V2_NOTIF_INTERNAL_EVENT_END = 8,
	TE_V2_NOTIF_HOST_FRAG_START = 16,
	TE_V2_NOTIF_HOST_FRAG_END = 32,
	TE_V2_NOTIF_INTERNAL_FRAG_START = 64,
	TE_V2_NOTIF_INTERNAL_FRAG_END = 128,
	TE_V2_START_IMMEDIATELY = 2048,
	TE_V2_DEP_OTHER = 4096,
	TE_V2_DEP_TSF = 8192,
	TE_V2_EVENT_SOCIOPATHIC = 16384,
	TE_V2_ABSENCE = 32768,
};

enum iwl_time_event_type {
	TE_BSS_STA_AGGRESSIVE_ASSOC = 0,
	TE_BSS_STA_ASSOC = 1,
	TE_BSS_EAP_DHCP_PROT = 2,
	TE_BSS_QUIET_PERIOD = 3,
	TE_P2P_DEVICE_DISCOVERABLE = 4,
	TE_P2P_DEVICE_LISTEN = 5,
	TE_P2P_DEVICE_ACTION_SCAN = 6,
	TE_P2P_DEVICE_FULL_SCAN = 7,
	TE_P2P_CLIENT_AGGRESSIVE_ASSOC = 8,
	TE_P2P_CLIENT_ASSOC = 9,
	TE_P2P_CLIENT_QUIET_PERIOD = 10,
	TE_P2P_GO_ASSOC_PROT = 11,
	TE_P2P_GO_REPETITIVET_NOA = 12,
	TE_P2P_GO_CT_WINDOW = 13,
	TE_WIDI_TX_SYNC = 14,
	TE_CHANNEL_SWITCH_PERIOD = 15,
	TE_MAX = 16,
};

enum iwl_time_sync_protocol_type {
	IWL_TIME_SYNC_PROTOCOL_TM = 1,
	IWL_TIME_SYNC_PROTOCOL_FTM = 2,
};

enum iwl_tlc_mng_cfg_chains {
	IWL_TLC_MNG_CHAIN_A_MSK = 1,
	IWL_TLC_MNG_CHAIN_B_MSK = 2,
};

enum iwl_tlc_mng_cfg_cw {
	IWL_TLC_MNG_CH_WIDTH_20MHZ = 0,
	IWL_TLC_MNG_CH_WIDTH_40MHZ = 1,
	IWL_TLC_MNG_CH_WIDTH_80MHZ = 2,
	IWL_TLC_MNG_CH_WIDTH_160MHZ = 3,
	IWL_TLC_MNG_CH_WIDTH_320MHZ = 4,
};

enum iwl_tlc_mng_cfg_flags {
	IWL_TLC_MNG_CFG_FLAGS_STBC_MSK = 1,
	IWL_TLC_MNG_CFG_FLAGS_LDPC_MSK = 2,
	IWL_TLC_MNG_CFG_FLAGS_HE_STBC_160MHZ_MSK = 4,
	IWL_TLC_MNG_CFG_FLAGS_HE_DCM_NSS_1_MSK = 8,
	IWL_TLC_MNG_CFG_FLAGS_HE_DCM_NSS_2_MSK = 16,
	IWL_TLC_MNG_CFG_FLAGS_EHT_EXTRA_LTF_MSK = 64,
};

enum iwl_tlc_mng_cfg_mode {
	IWL_TLC_MNG_MODE_CCK = 0,
	IWL_TLC_MNG_MODE_OFDM_NON_HT = 0,
	IWL_TLC_MNG_MODE_NON_HT = 0,
	IWL_TLC_MNG_MODE_HT = 1,
	IWL_TLC_MNG_MODE_VHT = 2,
	IWL_TLC_MNG_MODE_HE = 3,
	IWL_TLC_MNG_MODE_EHT = 4,
};

enum iwl_tlc_mng_ht_rates {
	IWL_TLC_MNG_HT_RATE_MCS0 = 0,
	IWL_TLC_MNG_HT_RATE_MCS1 = 1,
	IWL_TLC_MNG_HT_RATE_MCS2 = 2,
	IWL_TLC_MNG_HT_RATE_MCS3 = 3,
	IWL_TLC_MNG_HT_RATE_MCS4 = 4,
	IWL_TLC_MNG_HT_RATE_MCS5 = 5,
	IWL_TLC_MNG_HT_RATE_MCS6 = 6,
	IWL_TLC_MNG_HT_RATE_MCS7 = 7,
	IWL_TLC_MNG_HT_RATE_MCS8 = 8,
	IWL_TLC_MNG_HT_RATE_MCS9 = 9,
	IWL_TLC_MNG_HT_RATE_MCS10 = 10,
	IWL_TLC_MNG_HT_RATE_MCS11 = 11,
	IWL_TLC_MNG_HT_RATE_MAX = 11,
};

enum iwl_tlc_update_flags {
	IWL_TLC_NOTIF_FLAG_RATE = 1,
	IWL_TLC_NOTIF_FLAG_AMSDU = 2,
};

enum iwl_tof_algo_type {
	IWL_TOF_ALGO_TYPE_MAX_LIKE = 0,
	IWL_TOF_ALGO_TYPE_LINEAR_REG = 1,
	IWL_TOF_ALGO_TYPE_FFT = 2,
	IWL_TOF_ALGO_TYPE_INVALID = 3,
};

enum iwl_tof_bandwidth {
	IWL_TOF_BW_20_LEGACY = 0,
	IWL_TOF_BW_20_HT = 1,
	IWL_TOF_BW_40 = 2,
	IWL_TOF_BW_80 = 3,
	IWL_TOF_BW_160 = 4,
	IWL_TOF_BW_NUM = 5,
};

enum iwl_tof_entry_status {
	IWL_TOF_ENTRY_SUCCESS = 0,
	IWL_TOF_ENTRY_GENERAL_FAILURE = 1,
	IWL_TOF_ENTRY_NO_RESPONSE = 2,
	IWL_TOF_ENTRY_REQUEST_REJECTED = 3,
	IWL_TOF_ENTRY_NOT_SCHEDULED = 4,
	IWL_TOF_ENTRY_TIMING_MEASURE_TIMEOUT = 5,
	IWL_TOF_ENTRY_TARGET_DIFF_CH_CANNOT_CHANGE = 6,
	IWL_TOF_ENTRY_RANGE_NOT_SUPPORTED = 7,
	IWL_TOF_ENTRY_REQUEST_ABORT_UNKNOWN_REASON = 8,
	IWL_TOF_ENTRY_LOCATION_INVALID_T1_T4_TIME_STAMP = 9,
	IWL_TOF_ENTRY_11MC_PROTOCOL_FAILURE = 10,
	IWL_TOF_ENTRY_REQUEST_CANNOT_SCHED = 11,
	IWL_TOF_ENTRY_RESPONDER_CANNOT_COLABORATE = 12,
	IWL_TOF_ENTRY_BAD_REQUEST_ARGS = 13,
	IWL_TOF_ENTRY_WIFI_NOT_ENABLED = 14,
	IWL_TOF_ENTRY_RESPONDER_OVERRIDE_PARAMS = 15,
};

enum iwl_tof_initiator_flags {
	IWL_TOF_INITIATOR_FLAGS_FAST_ALGO_DISABLED = 1,
	IWL_TOF_INITIATOR_FLAGS_RX_CHAIN_SEL_A = 2,
	IWL_TOF_INITIATOR_FLAGS_RX_CHAIN_SEL_B = 4,
	IWL_TOF_INITIATOR_FLAGS_RX_CHAIN_SEL_C = 8,
	IWL_TOF_INITIATOR_FLAGS_TX_CHAIN_SEL_A = 16,
	IWL_TOF_INITIATOR_FLAGS_TX_CHAIN_SEL_B = 32,
	IWL_TOF_INITIATOR_FLAGS_TX_CHAIN_SEL_C = 64,
	IWL_TOF_INITIATOR_FLAGS_MACADDR_RANDOM = 128,
	IWL_TOF_INITIATOR_FLAGS_SPECIFIC_CALIB = 32768,
	IWL_TOF_INITIATOR_FLAGS_COMMON_CALIB = 65536,
	IWL_TOF_INITIATOR_FLAGS_NON_ASAP_SUPPORT = 1048576,
};

enum iwl_tof_location_query {
	IWL_TOF_LOC_LCI = 1,
	IWL_TOF_LOC_CIVIC = 2,
};

enum iwl_tof_range_request_status {
	IWL_TOF_RANGE_REQUEST_STATUS_SUCCESS = 0,
	IWL_TOF_RANGE_REQUEST_STATUS_BUSY = 1,
};

enum iwl_tof_responder_cmd_valid_field {
	IWL_TOF_RESPONDER_CMD_VALID_CHAN_INFO = 1,
	IWL_TOF_RESPONDER_CMD_VALID_TOA_OFFSET = 2,
	IWL_TOF_RESPONDER_CMD_VALID_COMMON_CALIB = 4,
	IWL_TOF_RESPONDER_CMD_VALID_SPECIFIC_CALIB = 8,
	IWL_TOF_RESPONDER_CMD_VALID_BSSID = 16,
	IWL_TOF_RESPONDER_CMD_VALID_TX_ANT = 32,
	IWL_TOF_RESPONDER_CMD_VALID_ALGO_TYPE = 64,
	IWL_TOF_RESPONDER_CMD_VALID_NON_ASAP_SUPPORT = 128,
	IWL_TOF_RESPONDER_CMD_VALID_STATISTICS_REPORT_SUPPORT = 256,
	IWL_TOF_RESPONDER_CMD_VALID_MCSI_NOTIF_SUPPORT = 512,
	IWL_TOF_RESPONDER_CMD_VALID_FAST_ALGO_SUPPORT = 1024,
	IWL_TOF_RESPONDER_CMD_VALID_RETRY_ON_ALGO_FAIL = 2048,
	IWL_TOF_RESPONDER_CMD_VALID_STA_ID = 4096,
	IWL_TOF_RESPONDER_CMD_VALID_NDP_SUPPORT = 4194304,
	IWL_TOF_RESPONDER_CMD_VALID_NDP_PARAMS = 8388608,
	IWL_TOF_RESPONDER_CMD_VALID_LMR_FEEDBACK = 16777216,
	IWL_TOF_RESPONDER_CMD_VALID_SESSION_ID = 33554432,
	IWL_TOF_RESPONDER_CMD_VALID_BSS_COLOR = 67108864,
	IWL_TOF_RESPONDER_CMD_VALID_MIN_MAX_TIME_BETWEEN_MSR = 134217728,
};

enum iwl_trans_state {
	IWL_TRANS_NO_FW = 0,
	IWL_TRANS_FW_STARTED = 1,
	IWL_TRANS_FW_ALIVE = 2,
};

enum iwl_trans_status {
	STATUS_SYNC_HCMD_ACTIVE = 0,
	STATUS_DEVICE_ENABLED = 1,
	STATUS_TPOWER_PMI = 2,
	STATUS_INT_ENABLED = 3,
	STATUS_RFKILL_HW = 4,
	STATUS_RFKILL_OPMODE = 5,
	STATUS_FW_ERROR = 6,
	STATUS_TRANS_DEAD = 7,
	STATUS_SUPPRESS_CMD_ERROR_ONCE = 8,
	STATUS_IN_SW_RESET = 9,
	STATUS_RESET_PENDING = 10,
};

enum iwl_tsf_id {
	TSF_ID_A = 0,
	TSF_ID_B = 1,
	TSF_ID_C = 2,
	TSF_ID_D = 3,
	NUM_TSF_IDS = 4,
};

enum iwl_tt_state {
	IWL_TI_0 = 0,
	IWL_TI_1 = 1,
	IWL_TI_2 = 2,
	IWL_TI_CT_KILL = 3,
	IWL_TI_STATE_MAX = 4,
};

enum iwl_tx_cmd_flags {
	IWL_TX_FLAGS_CMD_RATE = 1,
	IWL_TX_FLAGS_ENCRYPT_DIS = 2,
	IWL_TX_FLAGS_HIGH_PRI = 4,
	IWL_TX_FLAGS_RTS = 8,
	IWL_TX_FLAGS_CTS = 16,
};

enum iwl_tx_cmd_sec_ctrl {
	TX_CMD_SEC_WEP = 1,
	TX_CMD_SEC_CCM = 2,
	TX_CMD_SEC_TKIP = 3,
	TX_CMD_SEC_EXT = 4,
	TX_CMD_SEC_GCMP = 5,
	TX_CMD_SEC_KEY128 = 8,
	TX_CMD_SEC_KEY_FROM_TABLE = 16,
};

enum iwl_tx_flags {
	TX_CMD_FLG_PROT_REQUIRE = 1,
	TX_CMD_FLG_WRITE_TX_POWER = 2,
	TX_CMD_FLG_ACK = 8,
	TX_CMD_FLG_STA_RATE = 16,
	TX_CMD_FLG_BAR = 64,
	TX_CMD_FLG_TXOP_PROT = 128,
	TX_CMD_FLG_VHT_NDPA = 256,
	TX_CMD_FLG_HT_NDPA = 512,
	TX_CMD_FLG_CSI_FDBK2HOST = 1024,
	TX_CMD_FLG_BT_PRIO_POS = 11,
	TX_CMD_FLG_BT_PRIO_MASK = 6144,
	TX_CMD_FLG_BT_DIS = 4096,
	TX_CMD_FLG_SEQ_CTL = 8192,
	TX_CMD_FLG_MORE_FRAG = 16384,
	TX_CMD_FLG_TSF = 65536,
	TX_CMD_FLG_CALIB = 131072,
	TX_CMD_FLG_KEEP_SEQ_CTL = 262144,
	TX_CMD_FLG_MH_PAD = 1048576,
	TX_CMD_FLG_RESP_TO_DRV = 2097152,
	TX_CMD_FLG_TKIP_MIC_DONE = 8388608,
	TX_CMD_FLG_DUR = 33554432,
	TX_CMD_FLG_FW_DROP = 67108864,
	TX_CMD_FLG_EXEC_PAPD = 134217728,
	TX_CMD_FLG_PAPD_TYPE = 268435456,
	TX_CMD_FLG_HCCA_CHUNK = 2147483648,
};

enum iwl_tx_offload_assist_flags_pos {
	TX_CMD_OFFLD_IP_HDR = 0,
	TX_CMD_OFFLD_L4_EN = 6,
	TX_CMD_OFFLD_L3_EN = 7,
	TX_CMD_OFFLD_MH_SIZE = 8,
	TX_CMD_OFFLD_PAD = 13,
	TX_CMD_OFFLD_AMSDU = 14,
};

enum iwl_tx_pm_timeouts {
	PM_FRAME_NONE = 0,
	PM_FRAME_MGMT = 2,
	PM_FRAME_ASSOC = 3,
};

enum iwl_tx_queue_cfg_actions {
	TX_QUEUE_CFG_ENABLE_QUEUE = 1,
	TX_QUEUE_CFG_TFD_SHORT_FORMAT = 2,
};

enum iwl_tx_status {
	TX_STATUS_MSK___2 = 255,
	TX_STATUS_SUCCESS___2 = 1,
	TX_STATUS_DIRECT_DONE___2 = 2,
	TX_STATUS_POSTPONE_DELAY___2 = 64,
	TX_STATUS_POSTPONE_FEW_BYTES___2 = 65,
	TX_STATUS_POSTPONE_BT_PRIO___2 = 66,
	TX_STATUS_POSTPONE_QUIET_PERIOD___2 = 67,
	TX_STATUS_POSTPONE_CALC_TTAK___2 = 68,
	TX_STATUS_FAIL_INTERNAL_CROSSED_RETRY___2 = 129,
	TX_STATUS_FAIL_SHORT_LIMIT___2 = 130,
	TX_STATUS_FAIL_LONG_LIMIT___2 = 131,
	TX_STATUS_FAIL_UNDERRUN = 132,
	TX_STATUS_FAIL_DRAIN_FLOW___2 = 133,
	TX_STATUS_FAIL_RFKILL_FLUSH___2 = 134,
	TX_STATUS_FAIL_LIFE_EXPIRE___2 = 135,
	TX_STATUS_FAIL_DEST_PS___2 = 136,
	TX_STATUS_FAIL_HOST_ABORTED___2 = 137,
	TX_STATUS_FAIL_BT_RETRY___2 = 138,
	TX_STATUS_FAIL_STA_INVALID___2 = 139,
	TX_STATUS_FAIL_FRAG_DROPPED___2 = 140,
	TX_STATUS_FAIL_TID_DISABLE___2 = 141,
	TX_STATUS_FAIL_FIFO_FLUSHED___2 = 142,
	TX_STATUS_FAIL_SMALL_CF_POLL = 143,
	TX_STATUS_FAIL_FW_DROP = 144,
	TX_STATUS_FAIL_STA_COLOR_MISMATCH = 145,
	TX_STATUS_INTERNAL_ABORT = 146,
	TX_MODE_MSK = 3840,
	TX_MODE_NO_BURST = 0,
	TX_MODE_IN_BURST_SEQ = 256,
	TX_MODE_FIRST_IN_BURST = 512,
	TX_QUEUE_NUM_MSK = 126976,
	TX_NARROW_BW_MSK = 393216,
	TX_NARROW_BW_1DIV2 = 131072,
	TX_NARROW_BW_1DIV4 = 262144,
	TX_NARROW_BW_1DIV8 = 393216,
};

enum iwl_uapsd_disable {
	IWL_DISABLE_UAPSD_BSS = 1,
	IWL_DISABLE_UAPSD_P2P_CLIENT = 2,
};

enum iwl_ucode_calib_cfg {
	IWL_CALIB_CFG_RX_BB_IDX = 1,
	IWL_CALIB_CFG_DC_IDX = 2,
	IWL_CALIB_CFG_LO_IDX = 4,
	IWL_CALIB_CFG_TX_IQ_IDX = 8,
	IWL_CALIB_CFG_RX_IQ_IDX = 16,
	IWL_CALIB_CFG_NOISE_IDX = 32,
	IWL_CALIB_CFG_CRYSTAL_IDX = 64,
	IWL_CALIB_CFG_TEMPERATURE_IDX = 128,
	IWL_CALIB_CFG_PAPD_IDX = 256,
	IWL_CALIB_CFG_SENSITIVITY_IDX = 512,
	IWL_CALIB_CFG_TX_PWR_IDX = 1024,
};

enum iwl_ucode_sec {
	IWL_UCODE_SECTION_DATA = 0,
	IWL_UCODE_SECTION_INST = 1,
};

enum iwl_ucode_tlv_api {
	IWL_UCODE_TLV_API_FRAGMENTED_SCAN = 8,
	IWL_UCODE_TLV_API_WIFI_MCC_UPDATE = 9,
	IWL_UCODE_TLV_API_LQ_SS_PARAMS = 18,
	IWL_UCODE_TLV_API_NEW_VERSION = 20,
	IWL_UCODE_TLV_API_SCAN_TSF_REPORT = 28,
	IWL_UCODE_TLV_API_TKIP_MIC_KEYS = 29,
	IWL_UCODE_TLV_API_STA_TYPE = 30,
	IWL_UCODE_TLV_API_NAN2_VER2 = 31,
	IWL_UCODE_TLV_API_ADAPTIVE_DWELL = 32,
	IWL_UCODE_TLV_API_OCE = 33,
	IWL_UCODE_TLV_API_NEW_BEACON_TEMPLATE = 34,
	IWL_UCODE_TLV_API_NEW_RX_STATS = 35,
	IWL_UCODE_TLV_API_WOWLAN_KEY_MATERIAL = 36,
	IWL_UCODE_TLV_API_QUOTA_LOW_LATENCY = 38,
	IWL_UCODE_TLV_API_DEPRECATE_TTAK = 41,
	IWL_UCODE_TLV_API_ADAPTIVE_DWELL_V2 = 42,
	IWL_UCODE_TLV_API_FRAG_EBS = 44,
	IWL_UCODE_TLV_API_REDUCE_TX_POWER = 45,
	IWL_UCODE_TLV_API_SHORT_BEACON_NOTIF = 46,
	IWL_UCODE_TLV_API_BEACON_FILTER_V4 = 47,
	IWL_UCODE_TLV_API_REGULATORY_NVM_INFO = 48,
	IWL_UCODE_TLV_API_FTM_NEW_RANGE_REQ = 49,
	IWL_UCODE_TLV_API_SCAN_OFFLOAD_CHANS = 50,
	IWL_UCODE_TLV_API_MBSSID_HE = 52,
	IWL_UCODE_TLV_API_WOWLAN_TCP_SYN_WAKE = 53,
	IWL_UCODE_TLV_API_FTM_RTT_ACCURACY = 54,
	IWL_UCODE_TLV_API_SAR_TABLE_VER = 55,
	IWL_UCODE_TLV_API_REDUCED_SCAN_CONFIG = 56,
	IWL_UCODE_TLV_API_ADWELL_HB_DEF_N_AP = 57,
	IWL_UCODE_TLV_API_SCAN_EXT_CHAN_VER = 58,
	IWL_UCODE_TLV_API_BAND_IN_RX_DATA = 59,
	IWL_UCODE_TLV_API_NO_HOST_DISABLE_TX = 66,
	IWL_UCODE_TLV_API_INT_DBG_BUF_CLEAR = 67,
	IWL_UCODE_TLV_API_SMART_FIFO_OFFLOAD = 68,
	NUM_IWL_UCODE_TLV_API = 69,
};

enum iwl_ucode_tlv_capa {
	IWL_UCODE_TLV_CAPA_D0I3_SUPPORT = 0,
	IWL_UCODE_TLV_CAPA_LAR_SUPPORT = 1,
	IWL_UCODE_TLV_CAPA_UMAC_SCAN = 2,
	IWL_UCODE_TLV_CAPA_BEAMFORMER = 3,
	IWL_UCODE_TLV_CAPA_TDLS_SUPPORT = 6,
	IWL_UCODE_TLV_CAPA_TXPOWER_INSERTION_SUPPORT = 8,
	IWL_UCODE_TLV_CAPA_DS_PARAM_SET_IE_SUPPORT = 9,
	IWL_UCODE_TLV_CAPA_WFA_TPC_REP_IE_SUPPORT = 10,
	IWL_UCODE_TLV_CAPA_QUIET_PERIOD_SUPPORT = 11,
	IWL_UCODE_TLV_CAPA_DQA_SUPPORT = 12,
	IWL_UCODE_TLV_CAPA_TDLS_CHANNEL_SWITCH = 13,
	IWL_UCODE_TLV_CAPA_CNSLDTD_D3_D0_IMG = 17,
	IWL_UCODE_TLV_CAPA_HOTSPOT_SUPPORT = 18,
	IWL_UCODE_TLV_CAPA_CSUM_SUPPORT = 21,
	IWL_UCODE_TLV_CAPA_RADIO_BEACON_STATS = 22,
	IWL_UCODE_TLV_CAPA_P2P_SCM_UAPSD = 26,
	IWL_UCODE_TLV_CAPA_BT_COEX_PLCR = 28,
	IWL_UCODE_TLV_CAPA_LAR_MULTI_MCC = 29,
	IWL_UCODE_TLV_CAPA_BT_COEX_RRC = 30,
	IWL_UCODE_TLV_CAPA_GSCAN_SUPPORT = 31,
	IWL_UCODE_TLV_CAPA_FRAGMENTED_PNVM_IMG = 32,
	IWL_UCODE_TLV_CAPA_SOC_LATENCY_SUPPORT = 37,
	IWL_UCODE_TLV_CAPA_STA_PM_NOTIF = 38,
	IWL_UCODE_TLV_CAPA_BINDING_CDB_SUPPORT = 39,
	IWL_UCODE_TLV_CAPA_CDB_SUPPORT = 40,
	IWL_UCODE_TLV_CAPA_D0I3_END_FIRST = 41,
	IWL_UCODE_TLV_CAPA_TLC_OFFLOAD = 43,
	IWL_UCODE_TLV_CAPA_DYNAMIC_QUOTA = 44,
	IWL_UCODE_TLV_CAPA_COEX_SCHEMA_2 = 45,
	IWL_UCODE_TLV_CAPA_CHANNEL_SWITCH_CMD = 46,
	IWL_UCODE_TLV_CAPA_FTM_CALIBRATED = 47,
	IWL_UCODE_TLV_CAPA_ULTRA_HB_CHANNELS = 48,
	IWL_UCODE_TLV_CAPA_CS_MODIFY = 49,
	IWL_UCODE_TLV_CAPA_SET_LTR_GEN2 = 50,
	IWL_UCODE_TLV_CAPA_SET_PPAG = 52,
	IWL_UCODE_TLV_CAPA_TAS_CFG = 53,
	IWL_UCODE_TLV_CAPA_SESSION_PROT_CMD = 54,
	IWL_UCODE_TLV_CAPA_PROTECTED_TWT = 56,
	IWL_UCODE_TLV_CAPA_FW_RESET_HANDSHAKE = 57,
	IWL_UCODE_TLV_CAPA_PASSIVE_6GHZ_SCAN = 58,
	IWL_UCODE_TLV_CAPA_HIDDEN_6GHZ_SCAN = 59,
	IWL_UCODE_TLV_CAPA_BROADCAST_TWT = 60,
	IWL_UCODE_TLV_CAPA_COEX_HIGH_PRIO = 61,
	IWL_UCODE_TLV_CAPA_RFIM_SUPPORT = 62,
	IWL_UCODE_TLV_CAPA_BAID_ML_SUPPORT = 63,
	IWL_UCODE_TLV_CAPA_EXTENDED_DTS_MEASURE = 64,
	IWL_UCODE_TLV_CAPA_SHORT_PM_TIMEOUTS = 65,
	IWL_UCODE_TLV_CAPA_BT_MPLUT_SUPPORT = 67,
	IWL_UCODE_TLV_CAPA_MULTI_QUEUE_RX_SUPPORT = 68,
	IWL_UCODE_TLV_CAPA_CSA_AND_TBTT_OFFLOAD = 70,
	IWL_UCODE_TLV_CAPA_BEACON_ANT_SELECTION = 71,
	IWL_UCODE_TLV_CAPA_BEACON_STORING = 72,
	IWL_UCODE_TLV_CAPA_LAR_SUPPORT_V3 = 73,
	IWL_UCODE_TLV_CAPA_CT_KILL_BY_FW = 74,
	IWL_UCODE_TLV_CAPA_TEMP_THS_REPORT_SUPPORT = 75,
	IWL_UCODE_TLV_CAPA_CTDP_SUPPORT = 76,
	IWL_UCODE_TLV_CAPA_USNIFFER_UNIFIED = 77,
	IWL_UCODE_TLV_CAPA_EXTEND_SHARED_MEM_CFG = 80,
	IWL_UCODE_TLV_CAPA_LQM_SUPPORT = 81,
	IWL_UCODE_TLV_CAPA_TX_POWER_ACK = 84,
	IWL_UCODE_TLV_CAPA_D3_DEBUG = 87,
	IWL_UCODE_TLV_CAPA_LED_CMD_SUPPORT = 88,
	IWL_UCODE_TLV_CAPA_MCC_UPDATE_11AX_SUPPORT = 89,
	IWL_UCODE_TLV_CAPA_CSI_REPORTING = 90,
	IWL_UCODE_TLV_CAPA_DBG_SUSPEND_RESUME_CMD_SUPP = 92,
	IWL_UCODE_TLV_CAPA_DBG_BUF_ALLOC_CMD_SUPP = 93,
	IWL_UCODE_TLV_CAPA_BIOS_OVERRIDE_UNII4_US_CA = 96,
	IWL_UCODE_TLV_CAPA_PSC_CHAN_SUPPORT = 98,
	IWL_UCODE_TLV_CAPA_BIGTK_SUPPORT = 100,
	IWL_UCODE_TLV_CAPA_SPP_AMSDU_SUPPORT = 103,
	IWL_UCODE_TLV_CAPA_DRAM_FRAG_SUPPORT = 104,
	IWL_UCODE_TLV_CAPA_DUMP_COMPLETE_SUPPORT = 105,
	IWL_UCODE_TLV_CAPA_SYNCED_TIME = 106,
	IWL_UCODE_TLV_CAPA_TIME_SYNC_BOTH_FTM_TM = 108,
	IWL_UCODE_TLV_CAPA_BIGTK_TX_SUPPORT = 109,
	IWL_UCODE_TLV_CAPA_MLD_API_SUPPORT = 110,
	IWL_UCODE_TLV_CAPA_SCAN_DONT_TOGGLE_ANT = 111,
	IWL_UCODE_TLV_CAPA_PPAG_CHINA_BIOS_SUPPORT = 112,
	IWL_UCODE_TLV_CAPA_OFFLOAD_BTM_SUPPORT = 113,
	IWL_UCODE_TLV_CAPA_STA_EXP_MFP_SUPPORT = 114,
	IWL_UCODE_TLV_CAPA_SNIFF_VALIDATE_SUPPORT = 116,
	IWL_UCODE_TLV_CAPA_CHINA_22_REG_SUPPORT = 117,
	IWL_UCODE_TLV_CAPA_SECURE_LTF_SUPPORT = 121,
	IWL_UCODE_TLV_CAPA_MONITOR_PASSIVE_CHANS = 122,
	IWL_UCODE_TLV_CAPA_BIOS_OVERRIDE_5G9_FOR_CA = 123,
	IWL_UCODE_TLV_CAPA_UHB_CANADA_TAS_SUPPORT = 124,
	NUM_IWL_UCODE_TLV_CAPA = 125,
};

enum iwl_ucode_tlv_flag {
	IWL_UCODE_TLV_FLAGS_PAN = 1,
	IWL_UCODE_TLV_FLAGS_NEWSCAN = 2,
	IWL_UCODE_TLV_FLAGS_MFP = 4,
	IWL_UCODE_TLV_FLAGS_SHORT_BL = 128,
	IWL_UCODE_TLV_FLAGS_D3_6_IPV6_ADDRS = 1024,
	IWL_UCODE_TLV_FLAGS_NO_BASIC_SSID = 4096,
	IWL_UCODE_TLV_FLAGS_NEW_NSOFFL_SMALL = 32768,
	IWL_UCODE_TLV_FLAGS_NEW_NSOFFL_LARGE = 65536,
	IWL_UCODE_TLV_FLAGS_UAPSD_SUPPORT = 16777216,
	IWL_UCODE_TLV_FLAGS_EBS_SUPPORT = 33554432,
	IWL_UCODE_TLV_FLAGS_P2P_PS_UAPSD = 67108864,
};

enum iwl_ucode_tlv_type {
	IWL_UCODE_TLV_INVALID = 0,
	IWL_UCODE_TLV_INST = 1,
	IWL_UCODE_TLV_DATA = 2,
	IWL_UCODE_TLV_INIT = 3,
	IWL_UCODE_TLV_INIT_DATA = 4,
	IWL_UCODE_TLV_BOOT = 5,
	IWL_UCODE_TLV_PROBE_MAX_LEN = 6,
	IWL_UCODE_TLV_PAN = 7,
	IWL_UCODE_TLV_MEM_DESC = 7,
	IWL_UCODE_TLV_RUNT_EVTLOG_PTR = 8,
	IWL_UCODE_TLV_RUNT_EVTLOG_SIZE = 9,
	IWL_UCODE_TLV_RUNT_ERRLOG_PTR = 10,
	IWL_UCODE_TLV_INIT_EVTLOG_PTR = 11,
	IWL_UCODE_TLV_INIT_EVTLOG_SIZE = 12,
	IWL_UCODE_TLV_INIT_ERRLOG_PTR = 13,
	IWL_UCODE_TLV_ENHANCE_SENS_TBL = 14,
	IWL_UCODE_TLV_PHY_CALIBRATION_SIZE = 15,
	IWL_UCODE_TLV_WOWLAN_INST = 16,
	IWL_UCODE_TLV_WOWLAN_DATA = 17,
	IWL_UCODE_TLV_FLAGS = 18,
	IWL_UCODE_TLV_SEC_RT = 19,
	IWL_UCODE_TLV_SEC_INIT = 20,
	IWL_UCODE_TLV_SEC_WOWLAN = 21,
	IWL_UCODE_TLV_DEF_CALIB = 22,
	IWL_UCODE_TLV_PHY_SKU = 23,
	IWL_UCODE_TLV_SECURE_SEC_RT = 24,
	IWL_UCODE_TLV_SECURE_SEC_INIT = 25,
	IWL_UCODE_TLV_SECURE_SEC_WOWLAN = 26,
	IWL_UCODE_TLV_NUM_OF_CPU = 27,
	IWL_UCODE_TLV_CSCHEME = 28,
	IWL_UCODE_TLV_API_CHANGES_SET = 29,
	IWL_UCODE_TLV_ENABLED_CAPABILITIES = 30,
	IWL_UCODE_TLV_N_SCAN_CHANNELS = 31,
	IWL_UCODE_TLV_PAGING = 32,
	IWL_UCODE_TLV_SEC_RT_USNIFFER = 34,
	IWL_UCODE_TLV_FW_VERSION = 36,
	IWL_UCODE_TLV_FW_DBG_DEST = 38,
	IWL_UCODE_TLV_FW_DBG_CONF = 39,
	IWL_UCODE_TLV_FW_DBG_TRIGGER = 40,
	IWL_UCODE_TLV_CMD_VERSIONS = 48,
	IWL_UCODE_TLV_FW_GSCAN_CAPA = 50,
	IWL_UCODE_TLV_FW_MEM_SEG = 51,
	IWL_UCODE_TLV_IML = 52,
	IWL_UCODE_TLV_UMAC_DEBUG_ADDRS = 54,
	IWL_UCODE_TLV_LMAC_DEBUG_ADDRS = 55,
	IWL_UCODE_TLV_FW_RECOVERY_INFO = 57,
	IWL_UCODE_TLV_HW_TYPE = 58,
	IWL_UCODE_TLV_FW_FSEQ_VERSION = 60,
	IWL_UCODE_TLV_PHY_INTEGRATION_VERSION = 61,
	IWL_UCODE_TLV_PNVM_VERSION = 62,
	IWL_UCODE_TLV_PNVM_SKU = 64,
	IWL_UCODE_TLV_SEC_TABLE_ADDR = 66,
	IWL_UCODE_TLV_D3_KEK_KCK_ADDR = 67,
	IWL_UCODE_TLV_CURRENT_PC = 68,
	IWL_UCODE_TLV_FW_NUM_STATIONS = 256,
	IWL_UCODE_TLV_FW_NUM_LINKS = 257,
	IWL_UCODE_TLV_FW_NUM_BEACONS = 258,
	IWL_UCODE_TLV_TYPE_DEBUG_INFO = 16777221,
	IWL_UCODE_TLV_TYPE_BUFFER_ALLOCATION = 16777222,
	IWL_UCODE_TLV_TYPE_HCMD = 16777223,
	IWL_UCODE_TLV_TYPE_REGIONS = 16777224,
	IWL_UCODE_TLV_TYPE_TRIGGERS = 16777225,
	IWL_UCODE_TLV_TYPE_CONF_SET = 16777226,
	IWL_UCODE_TLV_DEBUG_MAX = 16777225,
	IWL_UCODE_TLV_FW_DBG_DUMP_LST = 4096,
};

enum iwl_ucode_type {
	IWL_UCODE_REGULAR = 0,
	IWL_UCODE_INIT = 1,
	IWL_UCODE_WOWLAN = 2,
	IWL_UCODE_REGULAR_USNIFFER = 3,
	IWL_UCODE_TYPE_MAX = 4,
};

enum iwl_uefi_cnv_puncturing_flags {
	IWL_UEFI_CNV_PUNCTURING_USA_EN_MSK = 1,
	IWL_UEFI_CNV_PUNCTURING_CANADA_EN_MSK = 2,
};

enum iwl_uhb_chan_cfg_flags {
	IWL_UHB_CHAN_CFG_FLAG_UNSOLICITED_PROBE_RES = 16777216,
	IWL_UHB_CHAN_CFG_FLAG_PSC_CHAN_NO_LISTEN = 33554432,
	IWL_UHB_CHAN_CFG_FLAG_FORCE_PASSIVE = 67108864,
};

enum iwl_umac_scan_abort_status {
	IWL_UMAC_SCAN_ABORT_STATUS_SUCCESS = 0,
	IWL_UMAC_SCAN_ABORT_STATUS_IN_PROGRESS = 1,
	IWL_UMAC_SCAN_ABORT_STATUS_NOT_FOUND = 2,
};

enum iwl_umac_scan_flags {
	IWL_UMAC_SCAN_FLAG_PREEMPTIVE = 1,
	IWL_UMAC_SCAN_FLAG_START_NOTIF = 2,
};

enum iwl_umac_scan_general_flags {
	IWL_UMAC_SCAN_GEN_FLAGS_PERIODIC = 1,
	IWL_UMAC_SCAN_GEN_FLAGS_OVER_BT = 2,
	IWL_UMAC_SCAN_GEN_FLAGS_PASS_ALL = 4,
	IWL_UMAC_SCAN_GEN_FLAGS_PASSIVE = 8,
	IWL_UMAC_SCAN_GEN_FLAGS_PRE_CONNECT = 16,
	IWL_UMAC_SCAN_GEN_FLAGS_ITER_COMPLETE = 32,
	IWL_UMAC_SCAN_GEN_FLAGS_MULTIPLE_SSID = 64,
	IWL_UMAC_SCAN_GEN_FLAGS_FRAGMENTED = 128,
	IWL_UMAC_SCAN_GEN_FLAGS_RRM_ENABLED = 256,
	IWL_UMAC_SCAN_GEN_FLAGS_MATCH = 512,
	IWL_UMAC_SCAN_GEN_FLAGS_EXTENDED_DWELL = 1024,
	IWL_UMAC_SCAN_GEN_FLAGS_PROB_REQ_DEFER_SUPP = 1024,
	IWL_UMAC_SCAN_GEN_FLAGS_LMAC2_FRAGMENTED = 2048,
	IWL_UMAC_SCAN_GEN_FLAGS_ADAPTIVE_DWELL = 8192,
	IWL_UMAC_SCAN_GEN_FLAGS_MAX_CHNL_TIME = 16384,
	IWL_UMAC_SCAN_GEN_FLAGS_PROB_REQ_HIGH_TX_RATE = 32768,
};

enum iwl_umac_scan_general_flags2 {
	IWL_UMAC_SCAN_GEN_FLAGS2_NOTIF_PER_CHNL = 1,
	IWL_UMAC_SCAN_GEN_FLAGS2_ALLOW_CHNL_REORDER = 2,
	IWL_UMAC_SCAN_GEN_FLAGS2_COLLECT_CHANNEL_STATS = 8,
};

enum iwl_umac_scan_general_flags_v2 {
	IWL_UMAC_SCAN_GEN_FLAGS_V2_PERIODIC = 1,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_PASS_ALL = 2,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_NTFY_ITER_COMPLETE = 4,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_FRAGMENTED_LMAC1 = 8,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_FRAGMENTED_LMAC2 = 16,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_MATCH = 32,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_USE_ALL_RX_CHAINS = 64,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_ADAPTIVE_DWELL = 128,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_PREEMPTIVE = 256,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_NTF_START = 512,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_MULTI_SSID = 1024,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_FORCE_PASSIVE = 2048,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_TRIGGER_UHB_SCAN = 4096,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_6GHZ_PASSIVE_SCAN = 8192,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_6GHZ_PASSIVE_SCAN_FILTER_IN = 16384,
	IWL_UMAC_SCAN_GEN_FLAGS_V2_OCE = 32768,
};

enum iwl_umac_scan_general_params_flags2 {
	IWL_UMAC_SCAN_GEN_PARAMS_FLAGS2_RESPECT_P2P_GO_LB = 1,
	IWL_UMAC_SCAN_GEN_PARAMS_FLAGS2_RESPECT_P2P_GO_HB = 2,
	IWL_UMAC_SCAN_GEN_PARAMS_FLAGS2_DONT_TOGGLE_ANT = 4,
};

enum iwl_wowlan_flags {
	IS_11W_ASSOC = 1,
	ENABLE_L3_FILTERING = 2,
	ENABLE_NBNS_FILTERING = 4,
	ENABLE_DHCP_FILTERING = 8,
	ENABLE_STORE_BEACON = 16,
};

enum iwl_wowlan_mlo_gtk_flag {
	WOWLAN_MLO_GTK_FLAG_KEY_LEN_MSK = 1,
	WOWLAN_MLO_GTK_FLAG_KEY_ID_MSK = 14,
	WOWLAN_MLO_GTK_FLAG_LINK_ID_MSK = 240,
	WOWLAN_MLO_GTK_FLAG_KEY_TYPE_MSK = 768,
	WOWLAN_MLO_GTK_FLAG_LAST_KEY_MSK = 1024,
};

enum iwl_wowlan_mlo_gtk_type {
	WOWLAN_MLO_GTK_KEY_TYPE_GTK = 0,
	WOWLAN_MLO_GTK_KEY_TYPE_IGTK = 1,
	WOWLAN_MLO_GTK_KEY_TYPE_BIGTK = 2,
	WOWLAN_MLO_GTK_KEY_NUM_TYPES = 3,
};

enum iwl_wowlan_pattern_type {
	WOWLAN_PATTERN_TYPE_BITMASK = 0,
	WOWLAN_PATTERN_TYPE_IPV4_TCP_SYN = 1,
	WOWLAN_PATTERN_TYPE_IPV6_TCP_SYN = 2,
	WOWLAN_PATTERN_TYPE_IPV4_TCP_SYN_WILDCARD = 3,
	WOWLAN_PATTERN_TYPE_IPV6_TCP_SYN_WILDCARD = 4,
};

enum iwl_wowlan_wakeup_filters {
	IWL_WOWLAN_WAKEUP_MAGIC_PACKET = 1,
	IWL_WOWLAN_WAKEUP_PATTERN_MATCH = 2,
	IWL_WOWLAN_WAKEUP_BEACON_MISS = 4,
	IWL_WOWLAN_WAKEUP_LINK_CHANGE = 8,
	IWL_WOWLAN_WAKEUP_GTK_REKEY_FAIL = 16,
	IWL_WOWLAN_WAKEUP_EAP_IDENT_REQ = 32,
	IWL_WOWLAN_WAKEUP_4WAY_HANDSHAKE = 64,
	IWL_WOWLAN_WAKEUP_ENABLE_NET_DETECT = 128,
	IWL_WOWLAN_WAKEUP_RF_KILL_DEASSERT = 256,
	IWL_WOWLAN_WAKEUP_REMOTE_LINK_LOSS = 512,
	IWL_WOWLAN_WAKEUP_REMOTE_SIGNATURE_TABLE = 1024,
	IWL_WOWLAN_WAKEUP_REMOTE_TCP_EXTERNAL = 2048,
	IWL_WOWLAN_WAKEUP_REMOTE_WAKEUP_PACKET = 4096,
	IWL_WOWLAN_WAKEUP_IOAC_MAGIC_PACKET = 8192,
	IWL_WOWLAN_WAKEUP_HOST_TIMER = 16384,
	IWL_WOWLAN_WAKEUP_RX_FRAME = 32768,
	IWL_WOWLAN_WAKEUP_BCN_FILTERING = 65536,
};

enum iwl_wowlan_wakeup_reason {
	IWL_WOWLAN_WAKEUP_BY_NON_WIRELESS = 0,
	IWL_WOWLAN_WAKEUP_BY_MAGIC_PACKET = 1,
	IWL_WOWLAN_WAKEUP_BY_PATTERN = 2,
	IWL_WOWLAN_WAKEUP_BY_DISCONNECTION_ON_MISSED_BEACON = 4,
	IWL_WOWLAN_WAKEUP_BY_DISCONNECTION_ON_DEAUTH = 8,
	IWL_WOWLAN_WAKEUP_BY_GTK_REKEY_FAILURE = 16,
	IWL_WOWLAN_WAKEUP_BY_RFKILL_DEASSERTED = 32,
	IWL_WOWLAN_WAKEUP_BY_UCODE_ERROR = 64,
	IWL_WOWLAN_WAKEUP_BY_EAPOL_REQUEST = 128,
	IWL_WOWLAN_WAKEUP_BY_FOUR_WAY_HANDSHAKE = 256,
	IWL_WOWLAN_WAKEUP_BY_REM_WAKE_LINK_LOSS = 512,
	IWL_WOWLAN_WAKEUP_BY_REM_WAKE_SIGNATURE_TABLE = 1024,
	IWL_WOWLAN_WAKEUP_BY_REM_WAKE_TCP_EXTERNAL = 2048,
	IWL_WOWLAN_WAKEUP_BY_REM_WAKE_WAKEUP_PACKET = 4096,
	IWL_WOWLAN_WAKEUP_BY_IOAC_MAGIC_PACKET = 8192,
	IWL_WOWLAN_WAKEUP_BY_D3_WAKEUP_HOST_TIMER = 16384,
	IWL_WOWLAN_WAKEUP_BY_RXFRAME_FILTERED_IN = 32768,
	IWL_WOWLAN_WAKEUP_BY_BEACON_FILTERED_IN = 65536,
	IWL_WAKEUP_BY_11W_UNPROTECTED_DEAUTH_OR_DISASSOC = 131072,
	IWL_WAKEUP_BY_PATTERN_IPV4_TCP_SYN = 262144,
	IWL_WAKEUP_BY_PATTERN_IPV4_TCP_SYN_WILDCARD = 524288,
	IWL_WAKEUP_BY_PATTERN_IPV6_TCP_SYN = 1048576,
	IWL_WAKEUP_BY_PATTERN_IPV6_TCP_SYN_WILDCARD = 2097152,
};

enum iwlagn_chain_noise_state {
	IWL_CHAIN_NOISE_ALIVE = 0,
	IWL_CHAIN_NOISE_ACCUMULATE = 1,
	IWL_CHAIN_NOISE_CALIBRATED = 2,
	IWL_CHAIN_NOISE_DONE = 3,
};

enum iwlagn_d3_wakeup_filters {
	IWLAGN_D3_WAKEUP_RFKILL = 1,
	IWLAGN_D3_WAKEUP_SYSASSERT = 2,
};

enum iwlagn_false_alarm_state {
	IWL_FA_TOO_MANY = 0,
	IWL_FA_TOO_FEW = 1,
	IWL_FA_GOOD_RANGE = 2,
};

enum iwlagn_wowlan_wakeup_filters {
	IWLAGN_WOWLAN_WAKEUP_MAGIC_PACKET = 1,
	IWLAGN_WOWLAN_WAKEUP_PATTERN_MATCH = 2,
	IWLAGN_WOWLAN_WAKEUP_BEACON_MISS = 4,
	IWLAGN_WOWLAN_WAKEUP_LINK_CHANGE = 8,
	IWLAGN_WOWLAN_WAKEUP_GTK_REKEY_FAIL = 16,
	IWLAGN_WOWLAN_WAKEUP_EAP_IDENT_REQ = 32,
	IWLAGN_WOWLAN_WAKEUP_4WAY_HANDSHAKE = 64,
	IWLAGN_WOWLAN_WAKEUP_ALWAYS = 128,
	IWLAGN_WOWLAN_WAKEUP_ENABLE_NET_DETECT = 256,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum jvc_state {
	STATE_INACTIVE = 0,
	STATE_HEADER_SPACE = 1,
	STATE_BIT_PULSE = 2,
	STATE_BIT_SPACE = 3,
	STATE_TRAILER_PULSE = 4,
	STATE_TRAILER_SPACE = 5,
	STATE_CHECK_REPEAT = 6,
};

enum kasan_arg_fault {
	KASAN_ARG_FAULT_DEFAULT = 0,
	KASAN_ARG_FAULT_REPORT = 1,
	KASAN_ARG_FAULT_PANIC = 2,
	KASAN_ARG_FAULT_PANIC_ON_WRITE = 3,
};

enum kasan_report_type {
	KASAN_REPORT_ACCESS = 0,
	KASAN_REPORT_INVALID_FREE = 1,
	KASAN_REPORT_DOUBLE_FREE = 2,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_gp_hint {
	GP_NO_HINT = 0,
	GP_NON_CANONICAL = 1,
	GP_CANONICAL = 2,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_DMA = 2,
	KMALLOC_CGROUP = 3,
	NR_KMALLOC_TYPES = 4,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum kvm_apic_logical_mode {
	KVM_APIC_MODE_SW_DISABLED = 0,
	KVM_APIC_MODE_XAPIC_CLUSTER = 1,
	KVM_APIC_MODE_XAPIC_FLAT = 2,
	KVM_APIC_MODE_X2APIC = 3,
	KVM_APIC_MODE_MAP_DISABLED = 4,
};

enum kvm_irqchip_mode {
	KVM_IRQCHIP_NONE = 0,
	KVM_IRQCHIP_KERNEL = 1,
	KVM_IRQCHIP_SPLIT = 2,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum l1d_flush_mitigations {
	L1D_FLUSH_OFF = 0,
	L1D_FLUSH_ON = 1,
};

enum l1tf_mitigations {
	L1TF_MITIGATION_OFF = 0,
	L1TF_MITIGATION_FLUSH_NOWARN = 1,
	L1TF_MITIGATION_FLUSH = 2,
	L1TF_MITIGATION_FLUSH_NOSMT = 3,
	L1TF_MITIGATION_FULL = 4,
	L1TF_MITIGATION_FULL_FORCE = 5,
};

enum latency_range {
	lowest_latency = 0,
	low_latency = 1,
	bulk_latency = 2,
	latency_invalid = 255,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_mode {
	LED_MODE_DEFAULT = 0,
	LED_MODE_TXRX_ACTIVITY = 1,
	LED_MODE_SIGNAL_STRENGTH = 2,
	LED_MODE_ASUS = 3,
	LED_MODE_ALPHA = 4,
};

enum led_state {
	led_on = 1,
	led_off = 4,
	led_on_559 = 5,
	led_on_557 = 7,
};

enum led_trigger_netdev_modes {
	TRIGGER_NETDEV_LINK = 0,
	TRIGGER_NETDEV_LINK_10 = 1,
	TRIGGER_NETDEV_LINK_100 = 2,
	TRIGGER_NETDEV_LINK_1000 = 3,
	TRIGGER_NETDEV_LINK_2500 = 4,
	TRIGGER_NETDEV_LINK_5000 = 5,
	TRIGGER_NETDEV_LINK_10000 = 6,
	TRIGGER_NETDEV_HALF_DUPLEX = 7,
	TRIGGER_NETDEV_FULL_DUPLEX = 8,
	TRIGGER_NETDEV_TX = 9,
	TRIGGER_NETDEV_RX = 10,
	TRIGGER_NETDEV_TX_ERR = 11,
	TRIGGER_NETDEV_RX_ERR = 12,
	__TRIGGER_NETDEV_MAX = 13,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum link_inband_signalling {
	LINK_INBAND_DISABLE = 1,
	LINK_INBAND_ENABLE = 2,
	LINK_INBAND_BYPASS = 4,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum loopback {
	lb_none = 0,
	lb_mac = 1,
	lb_phy = 3,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum mac {
	mac_82557_D100_A = 0,
	mac_82557_D100_B = 1,
	mac_82557_D100_C = 2,
	mac_82558_D101_A4 = 4,
	mac_82558_D101_B0 = 5,
	mac_82559_D101M = 8,
	mac_82559_D101S = 9,
	mac_82550_D102 = 12,
	mac_82550_D102_C = 13,
	mac_82551_E = 14,
	mac_82551_F = 15,
	mac_82551_10 = 16,
	mac_unknown = 255,
};

enum mac80211_drop_reason {
	RX_CONTINUE = 1,
	RX_QUEUED = 0,
	RX_DROP_MONITOR = 131072,
	RX_DROP_M_UNEXPECTED_4ADDR_FRAME = 131073,
	RX_DROP_M_BAD_BCN_KEYIDX = 131074,
	RX_DROP_M_BAD_MGMT_KEYIDX = 131075,
	RX_DROP_U_MIC_FAIL = 65537,
	RX_DROP_U_REPLAY = 65538,
	RX_DROP_U_BAD_MMIE = 65539,
	RX_DROP_U_DUP = 65540,
	RX_DROP_U_SPURIOUS = 65541,
	RX_DROP_U_DECRYPT_FAIL = 65542,
	RX_DROP_U_NO_KEY_ID = 65543,
	RX_DROP_U_BAD_CIPHER = 65544,
	RX_DROP_U_OOM = 65545,
	RX_DROP_U_NONSEQ_PN = 65546,
	RX_DROP_U_BAD_KEY_COLOR = 65547,
	RX_DROP_U_BAD_4ADDR = 65548,
	RX_DROP_U_BAD_AMSDU = 65549,
	RX_DROP_U_BAD_AMSDU_CIPHER = 65550,
	RX_DROP_U_INVALID_8023 = 65551,
	RX_DROP_U_RUNT_ACTION = 65552,
	RX_DROP_U_UNPROT_ACTION = 65553,
	RX_DROP_U_UNPROT_DUAL = 65554,
	RX_DROP_U_UNPROT_UCAST_MGMT = 65555,
	RX_DROP_U_UNPROT_MCAST_MGMT = 65556,
	RX_DROP_U_UNPROT_BEACON = 65557,
	RX_DROP_U_UNPROT_UNICAST_PUB_ACTION = 65558,
	RX_DROP_U_UNPROT_ROBUST_ACTION = 65559,
	RX_DROP_U_ACTION_UNKNOWN_SRC = 65560,
	RX_DROP_U_REJECTED_ACTION_RESPONSE = 65561,
	RX_DROP_U_EXPECT_DEFRAG_PROT = 65562,
	RX_DROP_U_WEP_DEC_FAIL = 65563,
	RX_DROP_U_NO_IV = 65564,
	RX_DROP_U_NO_ICV = 65565,
	RX_DROP_U_AP_RX_GROUPCAST = 65566,
	RX_DROP_U_SHORT_MMIC = 65567,
	RX_DROP_U_MMIC_FAIL = 65568,
	RX_DROP_U_SHORT_TKIP = 65569,
	RX_DROP_U_TKIP_FAIL = 65570,
	RX_DROP_U_SHORT_CCMP = 65571,
	RX_DROP_U_SHORT_CCMP_MIC = 65572,
	RX_DROP_U_SHORT_GCMP = 65573,
	RX_DROP_U_SHORT_GCMP_MIC = 65574,
	RX_DROP_U_SHORT_CMAC = 65575,
	RX_DROP_U_SHORT_CMAC256 = 65576,
	RX_DROP_U_SHORT_GMAC = 65577,
	RX_DROP_U_UNEXPECTED_VLAN_4ADDR = 65578,
	RX_DROP_U_UNEXPECTED_STA_4ADDR = 65579,
	RX_DROP_U_UNEXPECTED_VLAN_MCAST = 65580,
	RX_DROP_U_NOT_PORT_CONTROL = 65581,
	RX_DROP_U_UNKNOWN_ACTION_REJECTED = 65582,
};

enum mac80211_rate_control_flags {
	IEEE80211_TX_RC_USE_RTS_CTS = 1,
	IEEE80211_TX_RC_USE_CTS_PROTECT = 2,
	IEEE80211_TX_RC_USE_SHORT_PREAMBLE = 4,
	IEEE80211_TX_RC_MCS = 8,
	IEEE80211_TX_RC_GREEN_FIELD = 16,
	IEEE80211_TX_RC_40_MHZ_WIDTH = 32,
	IEEE80211_TX_RC_DUP_DATA = 64,
	IEEE80211_TX_RC_SHORT_GI = 128,
	IEEE80211_TX_RC_VHT_MCS = 256,
	IEEE80211_TX_RC_80_MHZ_WIDTH = 512,
	IEEE80211_TX_RC_160_MHZ_WIDTH = 1024,
};

enum mac80211_rx_encoding {
	RX_ENC_LEGACY = 0,
	RX_ENC_HT = 1,
	RX_ENC_VHT = 2,
	RX_ENC_HE = 3,
	RX_ENC_EHT = 4,
};

enum mac80211_rx_encoding_flags {
	RX_ENC_FLAG_SHORTPRE = 1,
	RX_ENC_FLAG_SHORT_GI = 4,
	RX_ENC_FLAG_HT_GF = 8,
	RX_ENC_FLAG_STBC_MASK = 48,
	RX_ENC_FLAG_LDPC = 64,
	RX_ENC_FLAG_BF = 128,
};

enum mac80211_rx_flags {
	RX_FLAG_MMIC_ERROR = 1,
	RX_FLAG_DECRYPTED = 2,
	RX_FLAG_ONLY_MONITOR = 4,
	RX_FLAG_MMIC_STRIPPED = 8,
	RX_FLAG_IV_STRIPPED = 16,
	RX_FLAG_FAILED_FCS_CRC = 32,
	RX_FLAG_FAILED_PLCP_CRC = 64,
	RX_FLAG_MACTIME_IS_RTAP_TS64 = 128,
	RX_FLAG_NO_SIGNAL_VAL = 256,
	RX_FLAG_AMPDU_DETAILS = 512,
	RX_FLAG_PN_VALIDATED = 1024,
	RX_FLAG_DUP_VALIDATED = 2048,
	RX_FLAG_AMPDU_LAST_KNOWN = 4096,
	RX_FLAG_AMPDU_IS_LAST = 8192,
	RX_FLAG_AMPDU_DELIM_CRC_ERROR = 16384,
	RX_FLAG_MACTIME = 196608,
	RX_FLAG_MACTIME_PLCP_START = 65536,
	RX_FLAG_MACTIME_START = 131072,
	RX_FLAG_MACTIME_END = 196608,
	RX_FLAG_SKIP_MONITOR = 262144,
	RX_FLAG_AMSDU_MORE = 524288,
	RX_FLAG_RADIOTAP_TLV_AT_END = 1048576,
	RX_FLAG_MIC_STRIPPED = 2097152,
	RX_FLAG_ALLOW_SAME_PN = 4194304,
	RX_FLAG_ICV_STRIPPED = 8388608,
	RX_FLAG_AMPDU_EOF_BIT = 16777216,
	RX_FLAG_AMPDU_EOF_BIT_KNOWN = 33554432,
	RX_FLAG_RADIOTAP_HE = 67108864,
	RX_FLAG_RADIOTAP_HE_MU = 134217728,
	RX_FLAG_RADIOTAP_LSIG = 268435456,
	RX_FLAG_NO_PSDU = 536870912,
	RX_FLAG_8023 = 1073741824,
};

enum mac80211_scan_flags {
	SCAN_SW_SCANNING = 0,
	SCAN_HW_SCANNING = 1,
	SCAN_ONCHANNEL_SCANNING = 2,
	SCAN_COMPLETED = 3,
	SCAN_ABORTED = 4,
	SCAN_HW_CANCELLED = 5,
	SCAN_BEACON_WAIT = 6,
	SCAN_BEACON_DONE = 7,
};

enum mac80211_scan_state {
	SCAN_DECISION = 0,
	SCAN_SET_CHANNEL = 1,
	SCAN_SEND_PROBE = 2,
	SCAN_SUSPEND = 3,
	SCAN_RESUME = 4,
	SCAN_ABORT = 5,
};

enum mac80211_tx_control_flags {
	IEEE80211_TX_CTRL_PORT_CTRL_PROTO = 1,
	IEEE80211_TX_CTRL_PS_RESPONSE = 2,
	IEEE80211_TX_CTRL_RATE_INJECT = 4,
	IEEE80211_TX_CTRL_AMSDU = 8,
	IEEE80211_TX_CTRL_FAST_XMIT = 16,
	IEEE80211_TX_CTRL_SKIP_MPATH_LOOKUP = 32,
	IEEE80211_TX_INTCFL_NEED_TXPROCESSING = 64,
	IEEE80211_TX_CTRL_NO_SEQNO = 128,
	IEEE80211_TX_CTRL_DONT_REORDER = 256,
	IEEE80211_TX_CTRL_MCAST_MLO_FIRST_TX = 512,
	IEEE80211_TX_CTRL_DONT_USE_RATE_MASK = 1024,
	IEEE80211_TX_CTRL_MLO_LINK = 4026531840,
};

enum mac80211_tx_info_flags {
	IEEE80211_TX_CTL_REQ_TX_STATUS = 1,
	IEEE80211_TX_CTL_ASSIGN_SEQ = 2,
	IEEE80211_TX_CTL_NO_ACK = 4,
	IEEE80211_TX_CTL_CLEAR_PS_FILT = 8,
	IEEE80211_TX_CTL_FIRST_FRAGMENT = 16,
	IEEE80211_TX_CTL_SEND_AFTER_DTIM = 32,
	IEEE80211_TX_CTL_AMPDU = 64,
	IEEE80211_TX_CTL_INJECTED = 128,
	IEEE80211_TX_STAT_TX_FILTERED = 256,
	IEEE80211_TX_STAT_ACK = 512,
	IEEE80211_TX_STAT_AMPDU = 1024,
	IEEE80211_TX_STAT_AMPDU_NO_BACK = 2048,
	IEEE80211_TX_CTL_RATE_CTRL_PROBE = 4096,
	IEEE80211_TX_INTFL_OFFCHAN_TX_OK = 8192,
	IEEE80211_TX_CTL_HW_80211_ENCAP = 16384,
	IEEE80211_TX_INTFL_RETRIED = 32768,
	IEEE80211_TX_INTFL_DONT_ENCRYPT = 65536,
	IEEE80211_TX_CTL_NO_PS_BUFFER = 131072,
	IEEE80211_TX_CTL_MORE_FRAMES = 262144,
	IEEE80211_TX_INTFL_RETRANSMISSION = 524288,
	IEEE80211_TX_INTFL_MLME_CONN_TX = 1048576,
	IEEE80211_TX_INTFL_NL80211_FRAME_TX = 2097152,
	IEEE80211_TX_CTL_LDPC = 4194304,
	IEEE80211_TX_CTL_STBC = 25165824,
	IEEE80211_TX_CTL_TX_OFFCHAN = 33554432,
	IEEE80211_TX_INTFL_TKIP_MIC_FAILURE = 67108864,
	IEEE80211_TX_CTL_NO_CCK_RATE = 134217728,
	IEEE80211_TX_STATUS_EOSP = 268435456,
	IEEE80211_TX_CTL_USE_MINRATE = 536870912,
	IEEE80211_TX_CTL_DONTFRAG = 1073741824,
	IEEE80211_TX_STAT_NOACK_TRANSMITTED = 2147483648,
};

enum mac80211_tx_status_flags {
	IEEE80211_TX_STATUS_ACK_SIGNAL_VALID = 1,
};

enum mac_version {
	RTL_GIGA_MAC_VER_02 = 0,
	RTL_GIGA_MAC_VER_03 = 1,
	RTL_GIGA_MAC_VER_04 = 2,
	RTL_GIGA_MAC_VER_05 = 3,
	RTL_GIGA_MAC_VER_06 = 4,
	RTL_GIGA_MAC_VER_07 = 5,
	RTL_GIGA_MAC_VER_08 = 6,
	RTL_GIGA_MAC_VER_09 = 7,
	RTL_GIGA_MAC_VER_10 = 8,
	RTL_GIGA_MAC_VER_14 = 9,
	RTL_GIGA_MAC_VER_17 = 10,
	RTL_GIGA_MAC_VER_18 = 11,
	RTL_GIGA_MAC_VER_19 = 12,
	RTL_GIGA_MAC_VER_20 = 13,
	RTL_GIGA_MAC_VER_21 = 14,
	RTL_GIGA_MAC_VER_22 = 15,
	RTL_GIGA_MAC_VER_23 = 16,
	RTL_GIGA_MAC_VER_24 = 17,
	RTL_GIGA_MAC_VER_25 = 18,
	RTL_GIGA_MAC_VER_26 = 19,
	RTL_GIGA_MAC_VER_28 = 20,
	RTL_GIGA_MAC_VER_29 = 21,
	RTL_GIGA_MAC_VER_30 = 22,
	RTL_GIGA_MAC_VER_31 = 23,
	RTL_GIGA_MAC_VER_32 = 24,
	RTL_GIGA_MAC_VER_33 = 25,
	RTL_GIGA_MAC_VER_34 = 26,
	RTL_GIGA_MAC_VER_35 = 27,
	RTL_GIGA_MAC_VER_36 = 28,
	RTL_GIGA_MAC_VER_37 = 29,
	RTL_GIGA_MAC_VER_38 = 30,
	RTL_GIGA_MAC_VER_39 = 31,
	RTL_GIGA_MAC_VER_40 = 32,
	RTL_GIGA_MAC_VER_42 = 33,
	RTL_GIGA_MAC_VER_43 = 34,
	RTL_GIGA_MAC_VER_44 = 35,
	RTL_GIGA_MAC_VER_46 = 36,
	RTL_GIGA_MAC_VER_48 = 37,
	RTL_GIGA_MAC_VER_51 = 38,
	RTL_GIGA_MAC_VER_52 = 39,
	RTL_GIGA_MAC_VER_53 = 40,
	RTL_GIGA_MAC_VER_61 = 41,
	RTL_GIGA_MAC_VER_63 = 42,
	RTL_GIGA_MAC_VER_64 = 43,
	RTL_GIGA_MAC_VER_65 = 44,
	RTL_GIGA_MAC_VER_66 = 45,
	RTL_GIGA_MAC_VER_70 = 46,
	RTL_GIGA_MAC_VER_71 = 47,
	RTL_GIGA_MAC_NONE = 48,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mca_msr {
	MCA_CTL = 0,
	MCA_STATUS = 1,
	MCA_ADDR = 2,
	MCA_MISC = 3,
};

enum mce_kbd_mode {
	MCIR2_MODE_KEYBOARD = 0,
	MCIR2_MODE_MOUSE = 1,
	MCIR2_MODE_UNKNOWN = 2,
};

enum mce_kbd_state {
	STATE_INACTIVE___2 = 0,
	STATE_HEADER_BIT_START = 1,
	STATE_HEADER_BIT_END = 2,
	STATE_BODY_BIT_START = 3,
	STATE_BODY_BIT_END = 4,
	STATE_FINISHED = 5,
};

enum mce_notifier_prios {
	MCE_PRIO_LOWEST = 0,
	MCE_PRIO_MCELOG = 1,
	MCE_PRIO_EDAC = 2,
	MCE_PRIO_NFIT = 3,
	MCE_PRIO_EXTLOG = 4,
	MCE_PRIO_UC = 5,
	MCE_PRIO_EARLY = 6,
	MCE_PRIO_CEC = 7,
	MCE_PRIO_HIGHEST = 7,
};

enum mcp_flags {
	MCP_TIMESTAMP = 1,
	MCP_UC = 2,
	MCP_DONTLOG = 4,
	MCP_QUEUE_LOG = 8,
};

enum md_ro_state {
	MD_RDWR = 0,
	MD_RDONLY = 1,
	MD_AUTO_READ = 2,
	MD_MAX_STATE = 3,
};

enum mddev_flags {
	MD_ARRAY_FIRST_USE = 0,
	MD_CLOSING = 1,
	MD_JOURNAL_CLEAN = 2,
	MD_HAS_JOURNAL = 3,
	MD_CLUSTER_RESYNC_LOCKED = 4,
	MD_FAILFAST_SUPPORTED = 5,
	MD_HAS_PPL = 6,
	MD_HAS_MULTIPLE_PPLS = 7,
	MD_NOT_READY = 8,
	MD_BROKEN = 9,
	MD_DELETED = 10,
};

enum mddev_sb_flags {
	MD_SB_CHANGE_DEVS = 0,
	MD_SB_CHANGE_CLEAN = 1,
	MD_SB_CHANGE_PENDING = 2,
	MD_SB_NEED_REWRITE = 3,
};

enum mdi_ctrl {
	mdi_write = 67108864,
	mdi_read = 134217728,
	mdi_ready = 268435456,
};

enum mds_mitigations {
	MDS_MITIGATION_OFF = 0,
	MDS_MITIGATION_FULL = 1,
	MDS_MITIGATION_VMWERV = 2,
};

enum mei_cb_file_ops {
	MEI_FOP_READ = 0,
	MEI_FOP_WRITE = 1,
	MEI_FOP_CONNECT = 2,
	MEI_FOP_DISCONNECT = 3,
	MEI_FOP_DISCONNECT_RSP = 4,
	MEI_FOP_NOTIFY_START = 5,
	MEI_FOP_NOTIFY_STOP = 6,
	MEI_FOP_DMA_MAP = 7,
	MEI_FOP_DMA_UNMAP = 8,
};

enum mei_cfg_idx {
	MEI_ME_UNDEF_CFG = 0,
	MEI_ME_ICH_CFG = 1,
	MEI_ME_ICH10_CFG = 2,
	MEI_ME_PCH6_CFG = 3,
	MEI_ME_PCH7_CFG = 4,
	MEI_ME_PCH_CPT_PBG_CFG = 5,
	MEI_ME_PCH8_CFG = 6,
	MEI_ME_PCH8_ITOUCH_CFG = 7,
	MEI_ME_PCH8_SPS_4_CFG = 8,
	MEI_ME_PCH12_CFG = 9,
	MEI_ME_PCH12_SPS_4_CFG = 10,
	MEI_ME_PCH12_SPS_CFG = 11,
	MEI_ME_PCH12_SPS_ITOUCH_CFG = 12,
	MEI_ME_PCH15_CFG = 13,
	MEI_ME_PCH15_SPS_CFG = 14,
	MEI_ME_GSC_CFG = 15,
	MEI_ME_GSCFI_CFG = 16,
	MEI_ME_NUM_CFG = 17,
};

enum mei_cl_connect_status {
	MEI_CL_CONN_SUCCESS = 0,
	MEI_CL_CONN_NOT_FOUND = 1,
	MEI_CL_CONN_ALREADY_STARTED = 2,
	MEI_CL_CONN_OUT_OF_RESOURCES = 3,
	MEI_CL_CONN_MESSAGE_SMALL = 4,
	MEI_CL_CONN_NOT_ALLOWED = 5,
};

enum mei_cl_disconnect_status {
	MEI_CL_DISCONN_SUCCESS = 0,
};

enum mei_cl_io_mode {
	MEI_CL_IO_TX_BLOCKING = 1,
	MEI_CL_IO_TX_INTERNAL = 2,
	MEI_CL_IO_RX_NONBLOCK = 4,
	MEI_CL_IO_SGL = 8,
};

enum mei_dev_pxp_mode {
	MEI_DEV_PXP_DEFAULT = 0,
	MEI_DEV_PXP_INIT = 1,
	MEI_DEV_PXP_SETUP = 2,
	MEI_DEV_PXP_READY = 3,
};

enum mei_dev_reset_to_pxp {
	MEI_DEV_RESET_TO_PXP_DEFAULT = 0,
	MEI_DEV_RESET_TO_PXP_PERFORMED = 1,
	MEI_DEV_RESET_TO_PXP_DONE = 2,
};

enum mei_dev_state {
	MEI_DEV_INITIALIZING = 0,
	MEI_DEV_INIT_CLIENTS = 1,
	MEI_DEV_ENABLED = 2,
	MEI_DEV_RESETTING = 3,
	MEI_DEV_DISABLED = 4,
	MEI_DEV_POWERING_DOWN = 5,
	MEI_DEV_POWER_DOWN = 6,
	MEI_DEV_POWER_UP = 7,
};

enum mei_ext_hdr_type {
	MEI_EXT_HDR_NONE = 0,
	MEI_EXT_HDR_VTAG = 1,
	MEI_EXT_HDR_GSC = 2,
};

enum mei_file_transaction_states {
	MEI_IDLE = 0,
	MEI_WRITING = 1,
	MEI_WRITE_COMPLETE = 2,
};

enum mei_hbm_state {
	MEI_HBM_IDLE = 0,
	MEI_HBM_STARTING = 1,
	MEI_HBM_CAP_SETUP = 2,
	MEI_HBM_DR_SETUP = 3,
	MEI_HBM_ENUM_CLIENTS = 4,
	MEI_HBM_CLIENT_PROPERTIES = 5,
	MEI_HBM_STARTED = 6,
	MEI_HBM_STOPPED = 7,
};

enum mei_hbm_status {
	MEI_HBMS_SUCCESS = 0,
	MEI_HBMS_CLIENT_NOT_FOUND = 1,
	MEI_HBMS_ALREADY_EXISTS = 2,
	MEI_HBMS_REJECTED = 3,
	MEI_HBMS_INVALID_PARAMETER = 4,
	MEI_HBMS_NOT_ALLOWED = 5,
	MEI_HBMS_ALREADY_STARTED = 6,
	MEI_HBMS_NOT_STARTED = 7,
	MEI_HBMS_MAX = 8,
};

enum mei_pg_event {
	MEI_PG_EVENT_IDLE = 0,
	MEI_PG_EVENT_WAIT = 1,
	MEI_PG_EVENT_RECEIVED = 2,
	MEI_PG_EVENT_INTR_WAIT = 3,
	MEI_PG_EVENT_INTR_RECEIVED = 4,
};

enum mei_pg_state {
	MEI_PG_OFF = 0,
	MEI_PG_ON = 1,
};

enum mei_stop_reason_types {
	DRIVER_STOP_REQUEST = 0,
	DEVICE_D1_ENTRY = 1,
	DEVICE_D2_ENTRY = 2,
	DEVICE_D3_ENTRY = 3,
	SYSTEM_S1_ENTRY = 4,
	SYSTEM_S2_ENTRY = 5,
	SYSTEM_S3_ENTRY = 6,
	SYSTEM_S4_ENTRY = 7,
	SYSTEM_S5_ENTRY = 8,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 44,
	MEMCG_SOCK = 45,
	MEMCG_PERCPU_B = 46,
	MEMCG_VMALLOC = 47,
	MEMCG_KMEM = 48,
	MEMCG_ZSWAP_B = 49,
	MEMCG_ZSWAPPED = 50,
	MEMCG_NR_STAT = 51,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum mesh_path_flags {
	MESH_PATH_ACTIVE = 1,
	MESH_PATH_RESOLVING = 2,
	MESH_PATH_SN_VALID = 4,
	MESH_PATH_FIXED = 8,
	MESH_PATH_RESOLVED = 16,
	MESH_PATH_REQ_QUEUED = 32,
	MESH_PATH_DELETED = 64,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_TYPES = 4,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum minstrel_sample_type {
	MINSTREL_SAMPLE_TYPE_INC = 0,
	MINSTREL_SAMPLE_TYPE_JUMP = 1,
	MINSTREL_SAMPLE_TYPE_SLOW = 2,
	__MINSTREL_SAMPLE_TYPE_MAX = 3,
};

enum misc_res_type {
	MISC_CG_RES_TYPES = 0,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmio_mitigations {
	MMIO_MITIGATION_OFF = 0,
	MMIO_MITIGATION_UCODE_NEEDED = 1,
	MMIO_MITIGATION_VERW = 2,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum monitor_flags {
	MONITOR_FLAG_CHANGED = 1,
	MONITOR_FLAG_FCSFAIL = 2,
	MONITOR_FLAG_PLCPFAIL = 4,
	MONITOR_FLAG_CONTROL = 8,
	MONITOR_FLAG_OTHER_BSS = 16,
	MONITOR_FLAG_COOK_FRAMES = 32,
	MONITOR_FLAG_ACTIVE = 64,
	MONITOR_FLAG_SKIP_TX = 128,
};

enum mp_irq_source_types {
	mp_INT = 0,
	mp_NMI = 1,
	mp_SMI = 2,
	mp_ExtINT = 3,
};

enum mpath_info_flags {
	MPATH_INFO_FRAME_QLEN = 1,
	MPATH_INFO_SN = 2,
	MPATH_INFO_METRIC = 4,
	MPATH_INFO_EXPTIME = 8,
	MPATH_INFO_DISCOVERY_TIMEOUT = 16,
	MPATH_INFO_DISCOVERY_RETRIES = 32,
	MPATH_INFO_FLAGS = 64,
	MPATH_INFO_HOP_COUNT = 128,
	MPATH_INFO_PATH_CHANGE = 256,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum msix_fh_int_causes {
	MSIX_FH_INT_CAUSES_Q0 = 1,
	MSIX_FH_INT_CAUSES_Q1 = 2,
	MSIX_FH_INT_CAUSES_D2S_CH0_NUM = 65536,
	MSIX_FH_INT_CAUSES_D2S_CH1_NUM = 131072,
	MSIX_FH_INT_CAUSES_S2D = 524288,
	MSIX_FH_INT_CAUSES_FH_ERR = 2097152,
};

enum msix_hw_int_causes {
	MSIX_HW_INT_CAUSES_REG_ALIVE = 1,
	MSIX_HW_INT_CAUSES_REG_WAKEUP = 2,
	MSIX_HW_INT_CAUSES_REG_IML = 2,
	MSIX_HW_INT_CAUSES_REG_RESET_DONE = 4,
	MSIX_HW_INT_CAUSES_REG_TOP_FATAL_ERR = 8,
	MSIX_HW_INT_CAUSES_REG_SW_ERR_BZ = 32,
	MSIX_HW_INT_CAUSES_REG_CT_KILL = 64,
	MSIX_HW_INT_CAUSES_REG_RF_KILL = 128,
	MSIX_HW_INT_CAUSES_REG_PERIODIC = 256,
	MSIX_HW_INT_CAUSES_REG_SW_ERR = 33554432,
	MSIX_HW_INT_CAUSES_REG_SCD = 67108864,
	MSIX_HW_INT_CAUSES_REG_FH_TX = 134217728,
	MSIX_HW_INT_CAUSES_REG_HW_ERR = 536870912,
	MSIX_HW_INT_CAUSES_REG_HAP = 1073741824,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPOUT = 5,
	MTHP_STAT_SWPOUT_FALLBACK = 6,
	MTHP_STAT_SHMEM_ALLOC = 7,
	MTHP_STAT_SHMEM_FALLBACK = 8,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 9,
	MTHP_STAT_SPLIT = 10,
	MTHP_STAT_SPLIT_FAILED = 11,
	MTHP_STAT_SPLIT_DEFERRED = 12,
	MTHP_STAT_NR_ANON = 13,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 14,
	__MTHP_STAT_COUNT = 15,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum nec_state {
	STATE_INACTIVE___3 = 0,
	STATE_HEADER_SPACE___2 = 1,
	STATE_BIT_PULSE___2 = 2,
	STATE_BIT_SPACE___2 = 3,
	STATE_TRAILER_PULSE___2 = 4,
	STATE_TRAILER_SPACE___2 = 5,
};

enum net_bridge_opts {
	BROPT_VLAN_ENABLED = 0,
	BROPT_VLAN_STATS_ENABLED = 1,
	BROPT_NF_CALL_IPTABLES = 2,
	BROPT_NF_CALL_IP6TABLES = 3,
	BROPT_NF_CALL_ARPTABLES = 4,
	BROPT_GROUP_ADDR_SET = 5,
	BROPT_MULTICAST_ENABLED = 6,
	BROPT_MULTICAST_QUERY_USE_IFADDR = 7,
	BROPT_MULTICAST_STATS_ENABLED = 8,
	BROPT_HAS_IPV6_ADDR = 9,
	BROPT_NEIGH_SUPPRESS_ENABLED = 10,
	BROPT_MTU_SET_BY_USER = 11,
	BROPT_VLAN_STATS_PER_PORT = 12,
	BROPT_NO_LL_LEARN = 13,
	BROPT_VLAN_BRIDGE_BINDING = 14,
	BROPT_MCAST_VLAN_SNOOPING_ENABLED = 15,
	BROPT_MST_ENABLED = 16,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_br_hook_priorities {
	NF_BR_PRI_FIRST = -2147483648,
	NF_BR_PRI_NAT_DST_BRIDGED = -300,
	NF_BR_PRI_FILTER_BRIDGED = -200,
	NF_BR_PRI_BRNF = 0,
	NF_BR_PRI_NAT_DST_OTHER = 100,
	NF_BR_PRI_FILTER_OTHER = 200,
	NF_BR_PRI_NAT_SRC = 300,
	NF_BR_PRI_LAST = 2147483647,
};

enum nf_ct_ecache_state {
	NFCT_ECACHE_DESTROY_FAIL = 0,
	NFCT_ECACHE_DESTROY_SENT = 1,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_NUM = 4,
};

enum nf_ct_helper_flags {
	NF_CT_HELPER_F_USERSPACE = 1,
	NF_CT_HELPER_F_CONFIGURED = 2,
};

enum nf_ct_sysctl_index {
	NF_SYSCTL_CT_MAX = 0,
	NF_SYSCTL_CT_COUNT = 1,
	NF_SYSCTL_CT_BUCKETS = 2,
	NF_SYSCTL_CT_CHECKSUM = 3,
	NF_SYSCTL_CT_LOG_INVALID = 4,
	NF_SYSCTL_CT_EXPECT_MAX = 5,
	NF_SYSCTL_CT_ACCT = 6,
	NF_SYSCTL_CT_PROTO_TIMEOUT_GENERIC = 7,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_SYN_SENT = 8,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_SYN_RECV = 9,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_ESTABLISHED = 10,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_FIN_WAIT = 11,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_CLOSE_WAIT = 12,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_LAST_ACK = 13,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_TIME_WAIT = 14,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_CLOSE = 15,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_RETRANS = 16,
	NF_SYSCTL_CT_PROTO_TIMEOUT_TCP_UNACK = 17,
	NF_SYSCTL_CT_PROTO_TCP_LOOSE = 18,
	NF_SYSCTL_CT_PROTO_TCP_LIBERAL = 19,
	NF_SYSCTL_CT_PROTO_TCP_IGNORE_INVALID_RST = 20,
	NF_SYSCTL_CT_PROTO_TCP_MAX_RETRANS = 21,
	NF_SYSCTL_CT_PROTO_TIMEOUT_UDP = 22,
	NF_SYSCTL_CT_PROTO_TIMEOUT_UDP_STREAM = 23,
	NF_SYSCTL_CT_PROTO_TIMEOUT_ICMP = 24,
	NF_SYSCTL_CT_PROTO_TIMEOUT_ICMPV6 = 25,
	NF_SYSCTL_CT_LAST_SYSCTL = 26,
};

enum nf_ct_tcp_action {
	NFCT_TCP_IGNORE = 0,
	NFCT_TCP_INVALID = 1,
	NFCT_TCP_ACCEPT = 2,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type {
	NF_NAT_MANIP_SRC = 0,
	NF_NAT_MANIP_DST = 1,
};

enum nf_tables_msg_types {
	NFT_MSG_NEWTABLE = 0,
	NFT_MSG_GETTABLE = 1,
	NFT_MSG_DELTABLE = 2,
	NFT_MSG_NEWCHAIN = 3,
	NFT_MSG_GETCHAIN = 4,
	NFT_MSG_DELCHAIN = 5,
	NFT_MSG_NEWRULE = 6,
	NFT_MSG_GETRULE = 7,
	NFT_MSG_DELRULE = 8,
	NFT_MSG_NEWSET = 9,
	NFT_MSG_GETSET = 10,
	NFT_MSG_DELSET = 11,
	NFT_MSG_NEWSETELEM = 12,
	NFT_MSG_GETSETELEM = 13,
	NFT_MSG_DELSETELEM = 14,
	NFT_MSG_NEWGEN = 15,
	NFT_MSG_GETGEN = 16,
	NFT_MSG_TRACE = 17,
	NFT_MSG_NEWOBJ = 18,
	NFT_MSG_GETOBJ = 19,
	NFT_MSG_DELOBJ = 20,
	NFT_MSG_GETOBJ_RESET = 21,
	NFT_MSG_NEWFLOWTABLE = 22,
	NFT_MSG_GETFLOWTABLE = 23,
	NFT_MSG_DELFLOWTABLE = 24,
	NFT_MSG_GETRULE_RESET = 25,
	NFT_MSG_DESTROYTABLE = 26,
	NFT_MSG_DESTROYCHAIN = 27,
	NFT_MSG_DESTROYRULE = 28,
	NFT_MSG_DESTROYSET = 29,
	NFT_MSG_DESTROYSETELEM = 30,
	NFT_MSG_DESTROYOBJ = 31,
	NFT_MSG_DESTROYFLOWTABLE = 32,
	NFT_MSG_GETSETELEM_RESET = 33,
	NFT_MSG_MAX = 34,
};

enum nfnetlink_groups {
	NFNLGRP_NONE = 0,
	NFNLGRP_CONNTRACK_NEW = 1,
	NFNLGRP_CONNTRACK_UPDATE = 2,
	NFNLGRP_CONNTRACK_DESTROY = 3,
	NFNLGRP_CONNTRACK_EXP_NEW = 4,
	NFNLGRP_CONNTRACK_EXP_UPDATE = 5,
	NFNLGRP_CONNTRACK_EXP_DESTROY = 6,
	NFNLGRP_NFTABLES = 7,
	NFNLGRP_ACCT_QUOTA = 8,
	NFNLGRP_NFTRACE = 9,
	__NFNLGRP_MAX = 10,
};

enum nfnl_abort_action {
	NFNL_ABORT_NONE = 0,
	NFNL_ABORT_AUTOLOAD = 1,
	NFNL_ABORT_VALIDATE = 2,
};

enum nfnl_acct_flags {
	NFACCT_F_QUOTA_PKTS = 1,
	NFACCT_F_QUOTA_BYTES = 2,
	NFACCT_F_OVERQUOTA = 4,
};

enum nfnl_acct_msg_types {
	NFNL_MSG_ACCT_NEW = 0,
	NFNL_MSG_ACCT_GET = 1,
	NFNL_MSG_ACCT_GET_CTRZERO = 2,
	NFNL_MSG_ACCT_DEL = 3,
	NFNL_MSG_ACCT_OVERQUOTA = 4,
	NFNL_MSG_ACCT_MAX = 5,
};

enum nfnl_acct_type {
	NFACCT_UNSPEC = 0,
	NFACCT_NAME = 1,
	NFACCT_PKTS = 2,
	NFACCT_BYTES = 3,
	NFACCT_USE = 4,
	NFACCT_FLAGS = 5,
	NFACCT_QUOTA = 6,
	NFACCT_FILTER = 7,
	NFACCT_PAD = 8,
	__NFACCT_MAX = 9,
};

enum nfnl_attr_filter_type {
	NFACCT_FILTER_UNSPEC = 0,
	NFACCT_FILTER_MASK = 1,
	NFACCT_FILTER_VALUE = 2,
	__NFACCT_FILTER_MAX = 3,
};

enum nfnl_batch_attributes {
	NFNL_BATCH_UNSPEC = 0,
	NFNL_BATCH_GENID = 1,
	__NFNL_BATCH_MAX = 2,
};

enum nfnl_callback_type {
	NFNL_CB_UNSPEC = 0,
	NFNL_CB_MUTEX = 1,
	NFNL_CB_RCU = 2,
	NFNL_CB_BATCH = 3,
};

enum nfnl_cthelper_msg_types {
	NFNL_MSG_CTHELPER_NEW = 0,
	NFNL_MSG_CTHELPER_GET = 1,
	NFNL_MSG_CTHELPER_DEL = 2,
	NFNL_MSG_CTHELPER_MAX = 3,
};

enum nfnl_cthelper_pol_type {
	NFCTH_POLICY_UNSPEC = 0,
	NFCTH_POLICY_NAME = 1,
	NFCTH_POLICY_EXPECT_MAX = 2,
	NFCTH_POLICY_EXPECT_TIMEOUT = 3,
	__NFCTH_POLICY_MAX = 4,
};

enum nfnl_cthelper_policy_type {
	NFCTH_POLICY_SET_UNSPEC = 0,
	NFCTH_POLICY_SET_NUM = 1,
	NFCTH_POLICY_SET = 2,
	NFCTH_POLICY_SET1 = 2,
	NFCTH_POLICY_SET2 = 3,
	NFCTH_POLICY_SET3 = 4,
	NFCTH_POLICY_SET4 = 5,
	__NFCTH_POLICY_SET_MAX = 6,
};

enum nfnl_cthelper_tuple_type {
	NFCTH_TUPLE_UNSPEC = 0,
	NFCTH_TUPLE_L3PROTONUM = 1,
	NFCTH_TUPLE_L4PROTONUM = 2,
	__NFCTH_TUPLE_MAX = 3,
};

enum nfnl_cthelper_type {
	NFCTH_UNSPEC = 0,
	NFCTH_NAME = 1,
	NFCTH_TUPLE = 2,
	NFCTH_QUEUE_NUM = 3,
	NFCTH_POLICY = 4,
	NFCTH_PRIV_DATA_LEN = 5,
	NFCTH_STATUS = 6,
	__NFCTH_MAX = 7,
};

enum nfqnl_attr_config {
	NFQA_CFG_UNSPEC = 0,
	NFQA_CFG_CMD = 1,
	NFQA_CFG_PARAMS = 2,
	NFQA_CFG_QUEUE_MAXLEN = 3,
	NFQA_CFG_MASK = 4,
	NFQA_CFG_FLAGS = 5,
	__NFQA_CFG_MAX = 6,
};

enum nfqnl_attr_type {
	NFQA_UNSPEC = 0,
	NFQA_PACKET_HDR = 1,
	NFQA_VERDICT_HDR = 2,
	NFQA_MARK = 3,
	NFQA_TIMESTAMP = 4,
	NFQA_IFINDEX_INDEV = 5,
	NFQA_IFINDEX_OUTDEV = 6,
	NFQA_IFINDEX_PHYSINDEV = 7,
	NFQA_IFINDEX_PHYSOUTDEV = 8,
	NFQA_HWADDR = 9,
	NFQA_PAYLOAD = 10,
	NFQA_CT = 11,
	NFQA_CT_INFO = 12,
	NFQA_CAP_LEN = 13,
	NFQA_SKB_INFO = 14,
	NFQA_EXP = 15,
	NFQA_UID = 16,
	NFQA_GID = 17,
	NFQA_SECCTX = 18,
	NFQA_VLAN = 19,
	NFQA_L2HDR = 20,
	NFQA_PRIORITY = 21,
	NFQA_CGROUP_CLASSID = 22,
	__NFQA_MAX = 23,
};

enum nfqnl_config_mode {
	NFQNL_COPY_NONE = 0,
	NFQNL_COPY_META = 1,
	NFQNL_COPY_PACKET = 2,
};

enum nfqnl_msg_config_cmds {
	NFQNL_CFG_CMD_NONE = 0,
	NFQNL_CFG_CMD_BIND = 1,
	NFQNL_CFG_CMD_UNBIND = 2,
	NFQNL_CFG_CMD_PF_BIND = 3,
	NFQNL_CFG_CMD_PF_UNBIND = 4,
};

enum nfqnl_msg_types {
	NFQNL_MSG_PACKET = 0,
	NFQNL_MSG_VERDICT = 1,
	NFQNL_MSG_CONFIG = 2,
	NFQNL_MSG_VERDICT_BATCH = 3,
	NFQNL_MSG_MAX = 4,
};

enum nfqnl_vlan_attr {
	NFQA_VLAN_UNSPEC = 0,
	NFQA_VLAN_PROTO = 1,
	NFQA_VLAN_TCI = 2,
	__NFQA_VLAN_MAX = 3,
};

enum nft_bitwise_attributes {
	NFTA_BITWISE_UNSPEC = 0,
	NFTA_BITWISE_SREG = 1,
	NFTA_BITWISE_DREG = 2,
	NFTA_BITWISE_LEN = 3,
	NFTA_BITWISE_MASK = 4,
	NFTA_BITWISE_XOR = 5,
	NFTA_BITWISE_OP = 6,
	NFTA_BITWISE_DATA = 7,
	NFTA_BITWISE_SREG2 = 8,
	__NFTA_BITWISE_MAX = 9,
};

enum nft_bitwise_ops {
	NFT_BITWISE_MASK_XOR = 0,
	NFT_BITWISE_LSHIFT = 1,
	NFT_BITWISE_RSHIFT = 2,
	NFT_BITWISE_AND = 3,
	NFT_BITWISE_OR = 4,
	NFT_BITWISE_XOR = 5,
};

enum nft_byteorder_attributes {
	NFTA_BYTEORDER_UNSPEC = 0,
	NFTA_BYTEORDER_SREG = 1,
	NFTA_BYTEORDER_DREG = 2,
	NFTA_BYTEORDER_OP = 3,
	NFTA_BYTEORDER_LEN = 4,
	NFTA_BYTEORDER_SIZE = 5,
	__NFTA_BYTEORDER_MAX = 6,
};

enum nft_byteorder_ops {
	NFT_BYTEORDER_NTOH = 0,
	NFT_BYTEORDER_HTON = 1,
};

enum nft_chain_attributes {
	NFTA_CHAIN_UNSPEC = 0,
	NFTA_CHAIN_TABLE = 1,
	NFTA_CHAIN_HANDLE = 2,
	NFTA_CHAIN_NAME = 3,
	NFTA_CHAIN_HOOK = 4,
	NFTA_CHAIN_POLICY = 5,
	NFTA_CHAIN_USE = 6,
	NFTA_CHAIN_TYPE = 7,
	NFTA_CHAIN_COUNTERS = 8,
	NFTA_CHAIN_PAD = 9,
	NFTA_CHAIN_FLAGS = 10,
	NFTA_CHAIN_ID = 11,
	NFTA_CHAIN_USERDATA = 12,
	__NFTA_CHAIN_MAX = 13,
};

enum nft_chain_flags {
	NFT_CHAIN_BASE = 1,
	NFT_CHAIN_HW_OFFLOAD = 2,
	NFT_CHAIN_BINDING = 4,
};

enum nft_chain_types {
	NFT_CHAIN_T_DEFAULT = 0,
	NFT_CHAIN_T_ROUTE = 1,
	NFT_CHAIN_T_NAT = 2,
	NFT_CHAIN_T_MAX = 3,
};

enum nft_cmp_attributes {
	NFTA_CMP_UNSPEC = 0,
	NFTA_CMP_SREG = 1,
	NFTA_CMP_OP = 2,
	NFTA_CMP_DATA = 3,
	__NFTA_CMP_MAX = 4,
};

enum nft_cmp_ops {
	NFT_CMP_EQ = 0,
	NFT_CMP_NEQ = 1,
	NFT_CMP_LT = 2,
	NFT_CMP_LTE = 3,
	NFT_CMP_GT = 4,
	NFT_CMP_GTE = 5,
};

enum nft_counter_attributes {
	NFTA_COUNTER_UNSPEC = 0,
	NFTA_COUNTER_BYTES = 1,
	NFTA_COUNTER_PACKETS = 2,
	NFTA_COUNTER_PAD = 3,
	__NFTA_COUNTER_MAX = 4,
};

enum nft_ct_attributes {
	NFTA_CT_UNSPEC = 0,
	NFTA_CT_DREG = 1,
	NFTA_CT_KEY = 2,
	NFTA_CT_DIRECTION = 3,
	NFTA_CT_SREG = 4,
	__NFTA_CT_MAX = 5,
};

enum nft_ct_expectation_attributes {
	NFTA_CT_EXPECT_UNSPEC = 0,
	NFTA_CT_EXPECT_L3PROTO = 1,
	NFTA_CT_EXPECT_L4PROTO = 2,
	NFTA_CT_EXPECT_DPORT = 3,
	NFTA_CT_EXPECT_TIMEOUT = 4,
	NFTA_CT_EXPECT_SIZE = 5,
	__NFTA_CT_EXPECT_MAX = 6,
};

enum nft_ct_helper_attributes {
	NFTA_CT_HELPER_UNSPEC = 0,
	NFTA_CT_HELPER_NAME = 1,
	NFTA_CT_HELPER_L3PROTO = 2,
	NFTA_CT_HELPER_L4PROTO = 3,
	__NFTA_CT_HELPER_MAX = 4,
};

enum nft_ct_keys {
	NFT_CT_STATE = 0,
	NFT_CT_DIRECTION = 1,
	NFT_CT_STATUS = 2,
	NFT_CT_MARK = 3,
	NFT_CT_SECMARK = 4,
	NFT_CT_EXPIRATION = 5,
	NFT_CT_HELPER = 6,
	NFT_CT_L3PROTOCOL = 7,
	NFT_CT_SRC = 8,
	NFT_CT_DST = 9,
	NFT_CT_PROTOCOL = 10,
	NFT_CT_PROTO_SRC = 11,
	NFT_CT_PROTO_DST = 12,
	NFT_CT_LABELS = 13,
	NFT_CT_PKTS = 14,
	NFT_CT_BYTES = 15,
	NFT_CT_AVGPKT = 16,
	NFT_CT_ZONE = 17,
	NFT_CT_EVENTMASK = 18,
	NFT_CT_SRC_IP = 19,
	NFT_CT_DST_IP = 20,
	NFT_CT_SRC_IP6 = 21,
	NFT_CT_DST_IP6 = 22,
	NFT_CT_ID = 23,
	__NFT_CT_MAX = 24,
};

enum nft_data_attributes {
	NFTA_DATA_UNSPEC = 0,
	NFTA_DATA_VALUE = 1,
	NFTA_DATA_VERDICT = 2,
	__NFTA_DATA_MAX = 3,
};

enum nft_data_desc_flags {
	NFT_DATA_DESC_SETELEM = 1,
};

enum nft_data_types {
	NFT_DATA_VALUE = 0,
	NFT_DATA_VERDICT = 4294967040,
};

enum nft_devices_attributes {
	NFTA_DEVICE_UNSPEC = 0,
	NFTA_DEVICE_NAME = 1,
	__NFTA_DEVICE_MAX = 2,
};

enum nft_dynset_attributes {
	NFTA_DYNSET_UNSPEC = 0,
	NFTA_DYNSET_SET_NAME = 1,
	NFTA_DYNSET_SET_ID = 2,
	NFTA_DYNSET_OP = 3,
	NFTA_DYNSET_SREG_KEY = 4,
	NFTA_DYNSET_SREG_DATA = 5,
	NFTA_DYNSET_TIMEOUT = 6,
	NFTA_DYNSET_EXPR = 7,
	NFTA_DYNSET_PAD = 8,
	NFTA_DYNSET_FLAGS = 9,
	NFTA_DYNSET_EXPRESSIONS = 10,
	__NFTA_DYNSET_MAX = 11,
};

enum nft_dynset_flags {
	NFT_DYNSET_F_INV = 1,
	NFT_DYNSET_F_EXPR = 2,
};

enum nft_dynset_ops {
	NFT_DYNSET_OP_ADD = 0,
	NFT_DYNSET_OP_UPDATE = 1,
	NFT_DYNSET_OP_DELETE = 2,
};

enum nft_expr_attributes {
	NFTA_EXPR_UNSPEC = 0,
	NFTA_EXPR_NAME = 1,
	NFTA_EXPR_DATA = 2,
	__NFTA_EXPR_MAX = 3,
};

enum nft_exthdr_attributes {
	NFTA_EXTHDR_UNSPEC = 0,
	NFTA_EXTHDR_DREG = 1,
	NFTA_EXTHDR_TYPE = 2,
	NFTA_EXTHDR_OFFSET = 3,
	NFTA_EXTHDR_LEN = 4,
	NFTA_EXTHDR_FLAGS = 5,
	NFTA_EXTHDR_OP = 6,
	NFTA_EXTHDR_SREG = 7,
	__NFTA_EXTHDR_MAX = 8,
};

enum nft_exthdr_flags {
	NFT_EXTHDR_F_PRESENT = 1,
};

enum nft_exthdr_op {
	NFT_EXTHDR_OP_IPV6 = 0,
	NFT_EXTHDR_OP_TCPOPT = 1,
	NFT_EXTHDR_OP_IPV4 = 2,
	NFT_EXTHDR_OP_SCTP = 3,
	NFT_EXTHDR_OP_DCCP = 4,
	__NFT_EXTHDR_OP_MAX = 5,
};

enum nft_flowtable_attributes {
	NFTA_FLOWTABLE_UNSPEC = 0,
	NFTA_FLOWTABLE_TABLE = 1,
	NFTA_FLOWTABLE_NAME = 2,
	NFTA_FLOWTABLE_HOOK = 3,
	NFTA_FLOWTABLE_USE = 4,
	NFTA_FLOWTABLE_HANDLE = 5,
	NFTA_FLOWTABLE_PAD = 6,
	NFTA_FLOWTABLE_FLAGS = 7,
	__NFTA_FLOWTABLE_MAX = 8,
};

enum nft_flowtable_flags {
	NFT_FLOWTABLE_HW_OFFLOAD = 1,
	NFT_FLOWTABLE_COUNTER = 2,
	NFT_FLOWTABLE_MASK = 3,
};

enum nft_flowtable_hook_attributes {
	NFTA_FLOWTABLE_HOOK_UNSPEC = 0,
	NFTA_FLOWTABLE_HOOK_NUM = 1,
	NFTA_FLOWTABLE_HOOK_PRIORITY = 2,
	NFTA_FLOWTABLE_HOOK_DEVS = 3,
	__NFTA_FLOWTABLE_HOOK_MAX = 4,
};

enum nft_gen_attributes {
	NFTA_GEN_UNSPEC = 0,
	NFTA_GEN_ID = 1,
	NFTA_GEN_PROC_PID = 2,
	NFTA_GEN_PROC_NAME = 3,
	__NFTA_GEN_MAX = 4,
};

enum nft_hook_attributes {
	NFTA_HOOK_UNSPEC = 0,
	NFTA_HOOK_HOOKNUM = 1,
	NFTA_HOOK_PRIORITY = 2,
	NFTA_HOOK_DEV = 3,
	NFTA_HOOK_DEVS = 4,
	__NFTA_HOOK_MAX = 5,
};

enum nft_immediate_attributes {
	NFTA_IMMEDIATE_UNSPEC = 0,
	NFTA_IMMEDIATE_DREG = 1,
	NFTA_IMMEDIATE_DATA = 2,
	__NFTA_IMMEDIATE_MAX = 3,
};

enum nft_inner_attributes {
	NFTA_INNER_UNSPEC = 0,
	NFTA_INNER_NUM = 1,
	NFTA_INNER_TYPE = 2,
	NFTA_INNER_FLAGS = 3,
	NFTA_INNER_HDRSIZE = 4,
	NFTA_INNER_EXPR = 5,
	__NFTA_INNER_MAX = 6,
};

enum nft_inner_flags {
	NFT_INNER_HDRSIZE = 1,
	NFT_INNER_LL = 2,
	NFT_INNER_NH = 4,
	NFT_INNER_TH = 8,
};

enum nft_inner_type {
	NFT_INNER_UNSPEC = 0,
	NFT_INNER_VXLAN = 1,
	NFT_INNER_GENEVE = 2,
};

enum nft_iter_type {
	NFT_ITER_UNSPEC = 0,
	NFT_ITER_READ = 1,
	NFT_ITER_UPDATE = 2,
};

enum nft_last_attributes {
	NFTA_LAST_UNSPEC = 0,
	NFTA_LAST_SET = 1,
	NFTA_LAST_MSECS = 2,
	NFTA_LAST_PAD = 3,
	__NFTA_LAST_MAX = 4,
};

enum nft_list_attributes {
	NFTA_LIST_UNSPEC = 0,
	NFTA_LIST_ELEM = 1,
	__NFTA_LIST_MAX = 2,
};

enum nft_lookup_attributes {
	NFTA_LOOKUP_UNSPEC = 0,
	NFTA_LOOKUP_SET = 1,
	NFTA_LOOKUP_SREG = 2,
	NFTA_LOOKUP_DREG = 3,
	NFTA_LOOKUP_SET_ID = 4,
	NFTA_LOOKUP_FLAGS = 5,
	__NFTA_LOOKUP_MAX = 6,
};

enum nft_lookup_flags {
	NFT_LOOKUP_F_INV = 1,
};

enum nft_match_attributes {
	NFTA_MATCH_UNSPEC = 0,
	NFTA_MATCH_NAME = 1,
	NFTA_MATCH_REV = 2,
	NFTA_MATCH_INFO = 3,
	__NFTA_MATCH_MAX = 4,
};

enum nft_meta_attributes {
	NFTA_META_UNSPEC = 0,
	NFTA_META_DREG = 1,
	NFTA_META_KEY = 2,
	NFTA_META_SREG = 3,
	__NFTA_META_MAX = 4,
};

enum nft_meta_keys {
	NFT_META_LEN = 0,
	NFT_META_PROTOCOL = 1,
	NFT_META_PRIORITY = 2,
	NFT_META_MARK = 3,
	NFT_META_IIF = 4,
	NFT_META_OIF = 5,
	NFT_META_IIFNAME = 6,
	NFT_META_OIFNAME = 7,
	NFT_META_IFTYPE = 8,
	NFT_META_OIFTYPE = 9,
	NFT_META_SKUID = 10,
	NFT_META_SKGID = 11,
	NFT_META_NFTRACE = 12,
	NFT_META_RTCLASSID = 13,
	NFT_META_SECMARK = 14,
	NFT_META_NFPROTO = 15,
	NFT_META_L4PROTO = 16,
	NFT_META_BRI_IIFNAME = 17,
	NFT_META_BRI_OIFNAME = 18,
	NFT_META_PKTTYPE = 19,
	NFT_META_CPU = 20,
	NFT_META_IIFGROUP = 21,
	NFT_META_OIFGROUP = 22,
	NFT_META_CGROUP = 23,
	NFT_META_PRANDOM = 24,
	NFT_META_SECPATH = 25,
	NFT_META_IIFKIND = 26,
	NFT_META_OIFKIND = 27,
	NFT_META_BRI_IIFPVID = 28,
	NFT_META_BRI_IIFVPROTO = 29,
	NFT_META_TIME_NS = 30,
	NFT_META_TIME_DAY = 31,
	NFT_META_TIME_HOUR = 32,
	NFT_META_SDIF = 33,
	NFT_META_SDIFNAME = 34,
	NFT_META_BRI_BROUTE = 35,
	__NFT_META_IIFTYPE = 36,
};

enum nft_nat_attributes {
	NFTA_NAT_UNSPEC = 0,
	NFTA_NAT_TYPE = 1,
	NFTA_NAT_FAMILY = 2,
	NFTA_NAT_REG_ADDR_MIN = 3,
	NFTA_NAT_REG_ADDR_MAX = 4,
	NFTA_NAT_REG_PROTO_MIN = 5,
	NFTA_NAT_REG_PROTO_MAX = 6,
	NFTA_NAT_FLAGS = 7,
	__NFTA_NAT_MAX = 8,
};

enum nft_nat_types {
	NFT_NAT_SNAT = 0,
	NFT_NAT_DNAT = 1,
};

enum nft_object_attributes {
	NFTA_OBJ_UNSPEC = 0,
	NFTA_OBJ_TABLE = 1,
	NFTA_OBJ_NAME = 2,
	NFTA_OBJ_TYPE = 3,
	NFTA_OBJ_DATA = 4,
	NFTA_OBJ_USE = 5,
	NFTA_OBJ_HANDLE = 6,
	NFTA_OBJ_PAD = 7,
	NFTA_OBJ_USERDATA = 8,
	__NFTA_OBJ_MAX = 9,
};

enum nft_objref_attributes {
	NFTA_OBJREF_UNSPEC = 0,
	NFTA_OBJREF_IMM_TYPE = 1,
	NFTA_OBJREF_IMM_NAME = 2,
	NFTA_OBJREF_SET_SREG = 3,
	NFTA_OBJREF_SET_NAME = 4,
	NFTA_OBJREF_SET_ID = 5,
	__NFTA_OBJREF_MAX = 6,
};

enum nft_offload_dep_type {
	NFT_OFFLOAD_DEP_UNSPEC = 0,
	NFT_OFFLOAD_DEP_NETWORK = 1,
	NFT_OFFLOAD_DEP_TRANSPORT = 2,
};

enum nft_offload_reg_flags {
	NFT_OFFLOAD_F_NETWORK2HOST = 1,
};

enum nft_payload_attributes {
	NFTA_PAYLOAD_UNSPEC = 0,
	NFTA_PAYLOAD_DREG = 1,
	NFTA_PAYLOAD_BASE = 2,
	NFTA_PAYLOAD_OFFSET = 3,
	NFTA_PAYLOAD_LEN = 4,
	NFTA_PAYLOAD_SREG = 5,
	NFTA_PAYLOAD_CSUM_TYPE = 6,
	NFTA_PAYLOAD_CSUM_OFFSET = 7,
	NFTA_PAYLOAD_CSUM_FLAGS = 8,
	__NFTA_PAYLOAD_MAX = 9,
};

enum nft_payload_bases {
	NFT_PAYLOAD_LL_HEADER = 0,
	NFT_PAYLOAD_NETWORK_HEADER = 1,
	NFT_PAYLOAD_TRANSPORT_HEADER = 2,
	NFT_PAYLOAD_INNER_HEADER = 3,
	NFT_PAYLOAD_TUN_HEADER = 4,
};

enum nft_payload_csum_flags {
	NFT_PAYLOAD_L4CSUM_PSEUDOHDR = 1,
};

enum nft_payload_csum_types {
	NFT_PAYLOAD_CSUM_NONE = 0,
	NFT_PAYLOAD_CSUM_INET = 1,
	NFT_PAYLOAD_CSUM_SCTP = 2,
};

enum nft_range_attributes {
	NFTA_RANGE_UNSPEC = 0,
	NFTA_RANGE_SREG = 1,
	NFTA_RANGE_OP = 2,
	NFTA_RANGE_FROM_DATA = 3,
	NFTA_RANGE_TO_DATA = 4,
	__NFTA_RANGE_MAX = 5,
};

enum nft_range_ops {
	NFT_RANGE_EQ = 0,
	NFT_RANGE_NEQ = 1,
};

enum nft_registers {
	NFT_REG_VERDICT = 0,
	NFT_REG_1 = 1,
	NFT_REG_2 = 2,
	NFT_REG_3 = 3,
	NFT_REG_4 = 4,
	__NFT_REG_MAX = 5,
	NFT_REG32_00 = 8,
	NFT_REG32_01 = 9,
	NFT_REG32_02 = 10,
	NFT_REG32_03 = 11,
	NFT_REG32_04 = 12,
	NFT_REG32_05 = 13,
	NFT_REG32_06 = 14,
	NFT_REG32_07 = 15,
	NFT_REG32_08 = 16,
	NFT_REG32_09 = 17,
	NFT_REG32_10 = 18,
	NFT_REG32_11 = 19,
	NFT_REG32_12 = 20,
	NFT_REG32_13 = 21,
	NFT_REG32_14 = 22,
	NFT_REG32_15 = 23,
};

enum nft_rt_attributes {
	NFTA_RT_UNSPEC = 0,
	NFTA_RT_DREG = 1,
	NFTA_RT_KEY = 2,
	__NFTA_RT_MAX = 3,
};

enum nft_rt_keys {
	NFT_RT_CLASSID = 0,
	NFT_RT_NEXTHOP4 = 1,
	NFT_RT_NEXTHOP6 = 2,
	NFT_RT_TCPMSS = 3,
	NFT_RT_XFRM = 4,
	__NFT_RT_MAX = 5,
};

enum nft_rule_attributes {
	NFTA_RULE_UNSPEC = 0,
	NFTA_RULE_TABLE = 1,
	NFTA_RULE_CHAIN = 2,
	NFTA_RULE_HANDLE = 3,
	NFTA_RULE_EXPRESSIONS = 4,
	NFTA_RULE_COMPAT = 5,
	NFTA_RULE_POSITION = 6,
	NFTA_RULE_USERDATA = 7,
	NFTA_RULE_PAD = 8,
	NFTA_RULE_ID = 9,
	NFTA_RULE_POSITION_ID = 10,
	NFTA_RULE_CHAIN_ID = 11,
	__NFTA_RULE_MAX = 12,
};

enum nft_rule_compat_attributes {
	NFTA_RULE_COMPAT_UNSPEC = 0,
	NFTA_RULE_COMPAT_PROTO = 1,
	NFTA_RULE_COMPAT_FLAGS = 2,
	__NFTA_RULE_COMPAT_MAX = 3,
};

enum nft_rule_compat_flags {
	NFT_RULE_COMPAT_F_UNUSED = 1,
	NFT_RULE_COMPAT_F_INV = 2,
	NFT_RULE_COMPAT_F_MASK = 2,
};

enum nft_set_attributes {
	NFTA_SET_UNSPEC = 0,
	NFTA_SET_TABLE = 1,
	NFTA_SET_NAME = 2,
	NFTA_SET_FLAGS = 3,
	NFTA_SET_KEY_TYPE = 4,
	NFTA_SET_KEY_LEN = 5,
	NFTA_SET_DATA_TYPE = 6,
	NFTA_SET_DATA_LEN = 7,
	NFTA_SET_POLICY = 8,
	NFTA_SET_DESC = 9,
	NFTA_SET_ID = 10,
	NFTA_SET_TIMEOUT = 11,
	NFTA_SET_GC_INTERVAL = 12,
	NFTA_SET_USERDATA = 13,
	NFTA_SET_PAD = 14,
	NFTA_SET_OBJ_TYPE = 15,
	NFTA_SET_HANDLE = 16,
	NFTA_SET_EXPR = 17,
	NFTA_SET_EXPRESSIONS = 18,
	__NFTA_SET_MAX = 19,
};

enum nft_set_class {
	NFT_SET_CLASS_O_1 = 0,
	NFT_SET_CLASS_O_LOG_N = 1,
	NFT_SET_CLASS_O_N = 2,
};

enum nft_set_desc_attributes {
	NFTA_SET_DESC_UNSPEC = 0,
	NFTA_SET_DESC_SIZE = 1,
	NFTA_SET_DESC_CONCAT = 2,
	__NFTA_SET_DESC_MAX = 3,
};

enum nft_set_elem_attributes {
	NFTA_SET_ELEM_UNSPEC = 0,
	NFTA_SET_ELEM_KEY = 1,
	NFTA_SET_ELEM_DATA = 2,
	NFTA_SET_ELEM_FLAGS = 3,
	NFTA_SET_ELEM_TIMEOUT = 4,
	NFTA_SET_ELEM_EXPIRATION = 5,
	NFTA_SET_ELEM_USERDATA = 6,
	NFTA_SET_ELEM_EXPR = 7,
	NFTA_SET_ELEM_PAD = 8,
	NFTA_SET_ELEM_OBJREF = 9,
	NFTA_SET_ELEM_KEY_END = 10,
	NFTA_SET_ELEM_EXPRESSIONS = 11,
	__NFTA_SET_ELEM_MAX = 12,
};

enum nft_set_elem_flags {
	NFT_SET_ELEM_INTERVAL_END = 1,
	NFT_SET_ELEM_CATCHALL = 2,
};

enum nft_set_elem_list_attributes {
	NFTA_SET_ELEM_LIST_UNSPEC = 0,
	NFTA_SET_ELEM_LIST_TABLE = 1,
	NFTA_SET_ELEM_LIST_SET = 2,
	NFTA_SET_ELEM_LIST_ELEMENTS = 3,
	NFTA_SET_ELEM_LIST_SET_ID = 4,
	__NFTA_SET_ELEM_LIST_MAX = 5,
};

enum nft_set_extensions {
	NFT_SET_EXT_KEY = 0,
	NFT_SET_EXT_KEY_END = 1,
	NFT_SET_EXT_DATA = 2,
	NFT_SET_EXT_FLAGS = 3,
	NFT_SET_EXT_TIMEOUT = 4,
	NFT_SET_EXT_USERDATA = 5,
	NFT_SET_EXT_EXPRESSIONS = 6,
	NFT_SET_EXT_OBJREF = 7,
	NFT_SET_EXT_NUM = 8,
};

enum nft_set_field_attributes {
	NFTA_SET_FIELD_UNSPEC = 0,
	NFTA_SET_FIELD_LEN = 1,
	__NFTA_SET_FIELD_MAX = 2,
};

enum nft_set_flags {
	NFT_SET_ANONYMOUS = 1,
	NFT_SET_CONSTANT = 2,
	NFT_SET_INTERVAL = 4,
	NFT_SET_MAP = 8,
	NFT_SET_TIMEOUT = 16,
	NFT_SET_EVAL = 32,
	NFT_SET_OBJECT = 64,
	NFT_SET_CONCAT = 128,
	NFT_SET_EXPR = 256,
};

enum nft_set_policies {
	NFT_SET_POL_PERFORMANCE = 0,
	NFT_SET_POL_MEMORY = 1,
};

enum nft_table_attributes {
	NFTA_TABLE_UNSPEC = 0,
	NFTA_TABLE_NAME = 1,
	NFTA_TABLE_FLAGS = 2,
	NFTA_TABLE_USE = 3,
	NFTA_TABLE_HANDLE = 4,
	NFTA_TABLE_PAD = 5,
	NFTA_TABLE_USERDATA = 6,
	NFTA_TABLE_OWNER = 7,
	__NFTA_TABLE_MAX = 8,
};

enum nft_table_flags {
	NFT_TABLE_F_DORMANT = 1,
	NFT_TABLE_F_OWNER = 2,
	NFT_TABLE_F_PERSIST = 4,
};

enum nft_target_attributes {
	NFTA_TARGET_UNSPEC = 0,
	NFTA_TARGET_NAME = 1,
	NFTA_TARGET_REV = 2,
	NFTA_TARGET_INFO = 3,
	__NFTA_TARGET_MAX = 4,
};

enum nft_trace_attributes {
	NFTA_TRACE_UNSPEC = 0,
	NFTA_TRACE_TABLE = 1,
	NFTA_TRACE_CHAIN = 2,
	NFTA_TRACE_RULE_HANDLE = 3,
	NFTA_TRACE_TYPE = 4,
	NFTA_TRACE_VERDICT = 5,
	NFTA_TRACE_ID = 6,
	NFTA_TRACE_LL_HEADER = 7,
	NFTA_TRACE_NETWORK_HEADER = 8,
	NFTA_TRACE_TRANSPORT_HEADER = 9,
	NFTA_TRACE_IIF = 10,
	NFTA_TRACE_IIFTYPE = 11,
	NFTA_TRACE_OIF = 12,
	NFTA_TRACE_OIFTYPE = 13,
	NFTA_TRACE_MARK = 14,
	NFTA_TRACE_NFPROTO = 15,
	NFTA_TRACE_POLICY = 16,
	NFTA_TRACE_PAD = 17,
	__NFTA_TRACE_MAX = 18,
};

enum nft_trace_types {
	NFT_TRACETYPE_UNSPEC = 0,
	NFT_TRACETYPE_POLICY = 1,
	NFT_TRACETYPE_RETURN = 2,
	NFT_TRACETYPE_RULE = 3,
	__NFT_TRACETYPE_MAX = 4,
};

enum nft_trans_elem_flags {
	NFT_TRANS_UPD_TIMEOUT = 1,
	NFT_TRANS_UPD_EXPIRATION = 2,
};

enum nft_trans_phase {
	NFT_TRANS_PREPARE = 0,
	NFT_TRANS_PREPARE_ERROR = 1,
	NFT_TRANS_ABORT = 2,
	NFT_TRANS_COMMIT = 3,
	NFT_TRANS_RELEASE = 4,
};

enum nft_verdict_attributes {
	NFTA_VERDICT_UNSPEC = 0,
	NFTA_VERDICT_CODE = 1,
	NFTA_VERDICT_CHAIN = 2,
	NFTA_VERDICT_CHAIN_ID = 3,
	__NFTA_VERDICT_MAX = 4,
};

enum nft_verdicts {
	NFT_CONTINUE = -1,
	NFT_BREAK = -2,
	NFT_JUMP = -3,
	NFT_GOTO = -4,
	NFT_RETURN = -5,
};

enum nfulnl_attr_config {
	NFULA_CFG_UNSPEC = 0,
	NFULA_CFG_CMD = 1,
	NFULA_CFG_MODE = 2,
	NFULA_CFG_NLBUFSIZ = 3,
	NFULA_CFG_TIMEOUT = 4,
	NFULA_CFG_QTHRESH = 5,
	NFULA_CFG_FLAGS = 6,
	__NFULA_CFG_MAX = 7,
};

enum nfulnl_attr_type {
	NFULA_UNSPEC = 0,
	NFULA_PACKET_HDR = 1,
	NFULA_MARK = 2,
	NFULA_TIMESTAMP = 3,
	NFULA_IFINDEX_INDEV = 4,
	NFULA_IFINDEX_OUTDEV = 5,
	NFULA_IFINDEX_PHYSINDEV = 6,
	NFULA_IFINDEX_PHYSOUTDEV = 7,
	NFULA_HWADDR = 8,
	NFULA_PAYLOAD = 9,
	NFULA_PREFIX = 10,
	NFULA_UID = 11,
	NFULA_SEQ = 12,
	NFULA_SEQ_GLOBAL = 13,
	NFULA_GID = 14,
	NFULA_HWTYPE = 15,
	NFULA_HWHEADER = 16,
	NFULA_HWLEN = 17,
	NFULA_CT = 18,
	NFULA_CT_INFO = 19,
	NFULA_VLAN = 20,
	NFULA_L2HDR = 21,
	__NFULA_MAX = 22,
};

enum nfulnl_msg_config_cmds {
	NFULNL_CFG_CMD_NONE = 0,
	NFULNL_CFG_CMD_BIND = 1,
	NFULNL_CFG_CMD_UNBIND = 2,
	NFULNL_CFG_CMD_PF_BIND = 3,
	NFULNL_CFG_CMD_PF_UNBIND = 4,
};

enum nfulnl_msg_types {
	NFULNL_MSG_PACKET = 0,
	NFULNL_MSG_CONFIG = 1,
	NFULNL_MSG_MAX = 2,
};

enum nfulnl_vlan_attr {
	NFULA_VLAN_UNSPEC = 0,
	NFULA_VLAN_PROTO = 1,
	NFULA_VLAN_TCI = 2,
	__NFULA_VLAN_MAX = 3,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nl80211_ac {
	NL80211_AC_VO = 0,
	NL80211_AC_VI = 1,
	NL80211_AC_BE = 2,
	NL80211_AC_BK = 3,
	NL80211_NUM_ACS = 4,
};

enum nl80211_acl_policy {
	NL80211_ACL_POLICY_ACCEPT_UNLESS_LISTED = 0,
	NL80211_ACL_POLICY_DENY_UNLESS_LISTED = 1,
};

enum nl80211_ap_settings_flags {
	NL80211_AP_SETTINGS_EXTERNAL_AUTH_SUPPORT = 1,
	NL80211_AP_SETTINGS_SA_QUERY_OFFLOAD_SUPPORT = 2,
};

enum nl80211_attr_coalesce_rule {
	__NL80211_COALESCE_RULE_INVALID = 0,
	NL80211_ATTR_COALESCE_RULE_DELAY = 1,
	NL80211_ATTR_COALESCE_RULE_CONDITION = 2,
	NL80211_ATTR_COALESCE_RULE_PKT_PATTERN = 3,
	NUM_NL80211_ATTR_COALESCE_RULE = 4,
	NL80211_ATTR_COALESCE_RULE_MAX = 3,
};

enum nl80211_attr_cqm {
	__NL80211_ATTR_CQM_INVALID = 0,
	NL80211_ATTR_CQM_RSSI_THOLD = 1,
	NL80211_ATTR_CQM_RSSI_HYST = 2,
	NL80211_ATTR_CQM_RSSI_THRESHOLD_EVENT = 3,
	NL80211_ATTR_CQM_PKT_LOSS_EVENT = 4,
	NL80211_ATTR_CQM_TXE_RATE = 5,
	NL80211_ATTR_CQM_TXE_PKTS = 6,
	NL80211_ATTR_CQM_TXE_INTVL = 7,
	NL80211_ATTR_CQM_BEACON_LOSS_EVENT = 8,
	NL80211_ATTR_CQM_RSSI_LEVEL = 9,
	__NL80211_ATTR_CQM_AFTER_LAST = 10,
	NL80211_ATTR_CQM_MAX = 9,
};

enum nl80211_attrs {
	NL80211_ATTR_UNSPEC = 0,
	NL80211_ATTR_WIPHY = 1,
	NL80211_ATTR_WIPHY_NAME = 2,
	NL80211_ATTR_IFINDEX = 3,
	NL80211_ATTR_IFNAME = 4,
	NL80211_ATTR_IFTYPE = 5,
	NL80211_ATTR_MAC = 6,
	NL80211_ATTR_KEY_DATA = 7,
	NL80211_ATTR_KEY_IDX = 8,
	NL80211_ATTR_KEY_CIPHER = 9,
	NL80211_ATTR_KEY_SEQ = 10,
	NL80211_ATTR_KEY_DEFAULT = 11,
	NL80211_ATTR_BEACON_INTERVAL = 12,
	NL80211_ATTR_DTIM_PERIOD = 13,
	NL80211_ATTR_BEACON_HEAD = 14,
	NL80211_ATTR_BEACON_TAIL = 15,
	NL80211_ATTR_STA_AID = 16,
	NL80211_ATTR_STA_FLAGS = 17,
	NL80211_ATTR_STA_LISTEN_INTERVAL = 18,
	NL80211_ATTR_STA_SUPPORTED_RATES = 19,
	NL80211_ATTR_STA_VLAN = 20,
	NL80211_ATTR_STA_INFO = 21,
	NL80211_ATTR_WIPHY_BANDS = 22,
	NL80211_ATTR_MNTR_FLAGS = 23,
	NL80211_ATTR_MESH_ID = 24,
	NL80211_ATTR_STA_PLINK_ACTION = 25,
	NL80211_ATTR_MPATH_NEXT_HOP = 26,
	NL80211_ATTR_MPATH_INFO = 27,
	NL80211_ATTR_BSS_CTS_PROT = 28,
	NL80211_ATTR_BSS_SHORT_PREAMBLE = 29,
	NL80211_ATTR_BSS_SHORT_SLOT_TIME = 30,
	NL80211_ATTR_HT_CAPABILITY = 31,
	NL80211_ATTR_SUPPORTED_IFTYPES = 32,
	NL80211_ATTR_REG_ALPHA2 = 33,
	NL80211_ATTR_REG_RULES = 34,
	NL80211_ATTR_MESH_CONFIG = 35,
	NL80211_ATTR_BSS_BASIC_RATES = 36,
	NL80211_ATTR_WIPHY_TXQ_PARAMS = 37,
	NL80211_ATTR_WIPHY_FREQ = 38,
	NL80211_ATTR_WIPHY_CHANNEL_TYPE = 39,
	NL80211_ATTR_KEY_DEFAULT_MGMT = 40,
	NL80211_ATTR_MGMT_SUBTYPE = 41,
	NL80211_ATTR_IE = 42,
	NL80211_ATTR_MAX_NUM_SCAN_SSIDS = 43,
	NL80211_ATTR_SCAN_FREQUENCIES = 44,
	NL80211_ATTR_SCAN_SSIDS = 45,
	NL80211_ATTR_GENERATION = 46,
	NL80211_ATTR_BSS = 47,
	NL80211_ATTR_REG_INITIATOR = 48,
	NL80211_ATTR_REG_TYPE = 49,
	NL80211_ATTR_SUPPORTED_COMMANDS = 50,
	NL80211_ATTR_FRAME = 51,
	NL80211_ATTR_SSID = 52,
	NL80211_ATTR_AUTH_TYPE = 53,
	NL80211_ATTR_REASON_CODE = 54,
	NL80211_ATTR_KEY_TYPE = 55,
	NL80211_ATTR_MAX_SCAN_IE_LEN = 56,
	NL80211_ATTR_CIPHER_SUITES = 57,
	NL80211_ATTR_FREQ_BEFORE = 58,
	NL80211_ATTR_FREQ_AFTER = 59,
	NL80211_ATTR_FREQ_FIXED = 60,
	NL80211_ATTR_WIPHY_RETRY_SHORT = 61,
	NL80211_ATTR_WIPHY_RETRY_LONG = 62,
	NL80211_ATTR_WIPHY_FRAG_THRESHOLD = 63,
	NL80211_ATTR_WIPHY_RTS_THRESHOLD = 64,
	NL80211_ATTR_TIMED_OUT = 65,
	NL80211_ATTR_USE_MFP = 66,
	NL80211_ATTR_STA_FLAGS2 = 67,
	NL80211_ATTR_CONTROL_PORT = 68,
	NL80211_ATTR_TESTDATA = 69,
	NL80211_ATTR_PRIVACY = 70,
	NL80211_ATTR_DISCONNECTED_BY_AP = 71,
	NL80211_ATTR_STATUS_CODE = 72,
	NL80211_ATTR_CIPHER_SUITES_PAIRWISE = 73,
	NL80211_ATTR_CIPHER_SUITE_GROUP = 74,
	NL80211_ATTR_WPA_VERSIONS = 75,
	NL80211_ATTR_AKM_SUITES = 76,
	NL80211_ATTR_REQ_IE = 77,
	NL80211_ATTR_RESP_IE = 78,
	NL80211_ATTR_PREV_BSSID = 79,
	NL80211_ATTR_KEY = 80,
	NL80211_ATTR_KEYS = 81,
	NL80211_ATTR_PID = 82,
	NL80211_ATTR_4ADDR = 83,
	NL80211_ATTR_SURVEY_INFO = 84,
	NL80211_ATTR_PMKID = 85,
	NL80211_ATTR_MAX_NUM_PMKIDS = 86,
	NL80211_ATTR_DURATION = 87,
	NL80211_ATTR_COOKIE = 88,
	NL80211_ATTR_WIPHY_COVERAGE_CLASS = 89,
	NL80211_ATTR_TX_RATES = 90,
	NL80211_ATTR_FRAME_MATCH = 91,
	NL80211_ATTR_ACK = 92,
	NL80211_ATTR_PS_STATE = 93,
	NL80211_ATTR_CQM = 94,
	NL80211_ATTR_LOCAL_STATE_CHANGE = 95,
	NL80211_ATTR_AP_ISOLATE = 96,
	NL80211_ATTR_WIPHY_TX_POWER_SETTING = 97,
	NL80211_ATTR_WIPHY_TX_POWER_LEVEL = 98,
	NL80211_ATTR_TX_FRAME_TYPES = 99,
	NL80211_ATTR_RX_FRAME_TYPES = 100,
	NL80211_ATTR_FRAME_TYPE = 101,
	NL80211_ATTR_CONTROL_PORT_ETHERTYPE = 102,
	NL80211_ATTR_CONTROL_PORT_NO_ENCRYPT = 103,
	NL80211_ATTR_SUPPORT_IBSS_RSN = 104,
	NL80211_ATTR_WIPHY_ANTENNA_TX = 105,
	NL80211_ATTR_WIPHY_ANTENNA_RX = 106,
	NL80211_ATTR_MCAST_RATE = 107,
	NL80211_ATTR_OFFCHANNEL_TX_OK = 108,
	NL80211_ATTR_BSS_HT_OPMODE = 109,
	NL80211_ATTR_KEY_DEFAULT_TYPES = 110,
	NL80211_ATTR_MAX_REMAIN_ON_CHANNEL_DURATION = 111,
	NL80211_ATTR_MESH_SETUP = 112,
	NL80211_ATTR_WIPHY_ANTENNA_AVAIL_TX = 113,
	NL80211_ATTR_WIPHY_ANTENNA_AVAIL_RX = 114,
	NL80211_ATTR_SUPPORT_MESH_AUTH = 115,
	NL80211_ATTR_STA_PLINK_STATE = 116,
	NL80211_ATTR_WOWLAN_TRIGGERS = 117,
	NL80211_ATTR_WOWLAN_TRIGGERS_SUPPORTED = 118,
	NL80211_ATTR_SCHED_SCAN_INTERVAL = 119,
	NL80211_ATTR_INTERFACE_COMBINATIONS = 120,
	NL80211_ATTR_SOFTWARE_IFTYPES = 121,
	NL80211_ATTR_REKEY_DATA = 122,
	NL80211_ATTR_MAX_NUM_SCHED_SCAN_SSIDS = 123,
	NL80211_ATTR_MAX_SCHED_SCAN_IE_LEN = 124,
	NL80211_ATTR_SCAN_SUPP_RATES = 125,
	NL80211_ATTR_HIDDEN_SSID = 126,
	NL80211_ATTR_IE_PROBE_RESP = 127,
	NL80211_ATTR_IE_ASSOC_RESP = 128,
	NL80211_ATTR_STA_WME = 129,
	NL80211_ATTR_SUPPORT_AP_UAPSD = 130,
	NL80211_ATTR_ROAM_SUPPORT = 131,
	NL80211_ATTR_SCHED_SCAN_MATCH = 132,
	NL80211_ATTR_MAX_MATCH_SETS = 133,
	NL80211_ATTR_PMKSA_CANDIDATE = 134,
	NL80211_ATTR_TX_NO_CCK_RATE = 135,
	NL80211_ATTR_TDLS_ACTION = 136,
	NL80211_ATTR_TDLS_DIALOG_TOKEN = 137,
	NL80211_ATTR_TDLS_OPERATION = 138,
	NL80211_ATTR_TDLS_SUPPORT = 139,
	NL80211_ATTR_TDLS_EXTERNAL_SETUP = 140,
	NL80211_ATTR_DEVICE_AP_SME = 141,
	NL80211_ATTR_DONT_WAIT_FOR_ACK = 142,
	NL80211_ATTR_FEATURE_FLAGS = 143,
	NL80211_ATTR_PROBE_RESP_OFFLOAD = 144,
	NL80211_ATTR_PROBE_RESP = 145,
	NL80211_ATTR_DFS_REGION = 146,
	NL80211_ATTR_DISABLE_HT = 147,
	NL80211_ATTR_HT_CAPABILITY_MASK = 148,
	NL80211_ATTR_NOACK_MAP = 149,
	NL80211_ATTR_INACTIVITY_TIMEOUT = 150,
	NL80211_ATTR_RX_SIGNAL_DBM = 151,
	NL80211_ATTR_BG_SCAN_PERIOD = 152,
	NL80211_ATTR_WDEV = 153,
	NL80211_ATTR_USER_REG_HINT_TYPE = 154,
	NL80211_ATTR_CONN_FAILED_REASON = 155,
	NL80211_ATTR_AUTH_DATA = 156,
	NL80211_ATTR_VHT_CAPABILITY = 157,
	NL80211_ATTR_SCAN_FLAGS = 158,
	NL80211_ATTR_CHANNEL_WIDTH = 159,
	NL80211_ATTR_CENTER_FREQ1 = 160,
	NL80211_ATTR_CENTER_FREQ2 = 161,
	NL80211_ATTR_P2P_CTWINDOW = 162,
	NL80211_ATTR_P2P_OPPPS = 163,
	NL80211_ATTR_LOCAL_MESH_POWER_MODE = 164,
	NL80211_ATTR_ACL_POLICY = 165,
	NL80211_ATTR_MAC_ADDRS = 166,
	NL80211_ATTR_MAC_ACL_MAX = 167,
	NL80211_ATTR_RADAR_EVENT = 168,
	NL80211_ATTR_EXT_CAPA = 169,
	NL80211_ATTR_EXT_CAPA_MASK = 170,
	NL80211_ATTR_STA_CAPABILITY = 171,
	NL80211_ATTR_STA_EXT_CAPABILITY = 172,
	NL80211_ATTR_PROTOCOL_FEATURES = 173,
	NL80211_ATTR_SPLIT_WIPHY_DUMP = 174,
	NL80211_ATTR_DISABLE_VHT = 175,
	NL80211_ATTR_VHT_CAPABILITY_MASK = 176,
	NL80211_ATTR_MDID = 177,
	NL80211_ATTR_IE_RIC = 178,
	NL80211_ATTR_CRIT_PROT_ID = 179,
	NL80211_ATTR_MAX_CRIT_PROT_DURATION = 180,
	NL80211_ATTR_PEER_AID = 181,
	NL80211_ATTR_COALESCE_RULE = 182,
	NL80211_ATTR_CH_SWITCH_COUNT = 183,
	NL80211_ATTR_CH_SWITCH_BLOCK_TX = 184,
	NL80211_ATTR_CSA_IES = 185,
	NL80211_ATTR_CNTDWN_OFFS_BEACON = 186,
	NL80211_ATTR_CNTDWN_OFFS_PRESP = 187,
	NL80211_ATTR_RXMGMT_FLAGS = 188,
	NL80211_ATTR_STA_SUPPORTED_CHANNELS = 189,
	NL80211_ATTR_STA_SUPPORTED_OPER_CLASSES = 190,
	NL80211_ATTR_HANDLE_DFS = 191,
	NL80211_ATTR_SUPPORT_5_MHZ = 192,
	NL80211_ATTR_SUPPORT_10_MHZ = 193,
	NL80211_ATTR_OPMODE_NOTIF = 194,
	NL80211_ATTR_VENDOR_ID = 195,
	NL80211_ATTR_VENDOR_SUBCMD = 196,
	NL80211_ATTR_VENDOR_DATA = 197,
	NL80211_ATTR_VENDOR_EVENTS = 198,
	NL80211_ATTR_QOS_MAP = 199,
	NL80211_ATTR_MAC_HINT = 200,
	NL80211_ATTR_WIPHY_FREQ_HINT = 201,
	NL80211_ATTR_MAX_AP_ASSOC_STA = 202,
	NL80211_ATTR_TDLS_PEER_CAPABILITY = 203,
	NL80211_ATTR_SOCKET_OWNER = 204,
	NL80211_ATTR_CSA_C_OFFSETS_TX = 205,
	NL80211_ATTR_MAX_CSA_COUNTERS = 206,
	NL80211_ATTR_TDLS_INITIATOR = 207,
	NL80211_ATTR_USE_RRM = 208,
	NL80211_ATTR_WIPHY_DYN_ACK = 209,
	NL80211_ATTR_TSID = 210,
	NL80211_ATTR_USER_PRIO = 211,
	NL80211_ATTR_ADMITTED_TIME = 212,
	NL80211_ATTR_SMPS_MODE = 213,
	NL80211_ATTR_OPER_CLASS = 214,
	NL80211_ATTR_MAC_MASK = 215,
	NL80211_ATTR_WIPHY_SELF_MANAGED_REG = 216,
	NL80211_ATTR_EXT_FEATURES = 217,
	NL80211_ATTR_SURVEY_RADIO_STATS = 218,
	NL80211_ATTR_NETNS_FD = 219,
	NL80211_ATTR_SCHED_SCAN_DELAY = 220,
	NL80211_ATTR_REG_INDOOR = 221,
	NL80211_ATTR_MAX_NUM_SCHED_SCAN_PLANS = 222,
	NL80211_ATTR_MAX_SCAN_PLAN_INTERVAL = 223,
	NL80211_ATTR_MAX_SCAN_PLAN_ITERATIONS = 224,
	NL80211_ATTR_SCHED_SCAN_PLANS = 225,
	NL80211_ATTR_PBSS = 226,
	NL80211_ATTR_BSS_SELECT = 227,
	NL80211_ATTR_STA_SUPPORT_P2P_PS = 228,
	NL80211_ATTR_PAD = 229,
	NL80211_ATTR_IFTYPE_EXT_CAPA = 230,
	NL80211_ATTR_MU_MIMO_GROUP_DATA = 231,
	NL80211_ATTR_MU_MIMO_FOLLOW_MAC_ADDR = 232,
	NL80211_ATTR_SCAN_START_TIME_TSF = 233,
	NL80211_ATTR_SCAN_START_TIME_TSF_BSSID = 234,
	NL80211_ATTR_MEASUREMENT_DURATION = 235,
	NL80211_ATTR_MEASUREMENT_DURATION_MANDATORY = 236,
	NL80211_ATTR_MESH_PEER_AID = 237,
	NL80211_ATTR_NAN_MASTER_PREF = 238,
	NL80211_ATTR_BANDS = 239,
	NL80211_ATTR_NAN_FUNC = 240,
	NL80211_ATTR_NAN_MATCH = 241,
	NL80211_ATTR_FILS_KEK = 242,
	NL80211_ATTR_FILS_NONCES = 243,
	NL80211_ATTR_MULTICAST_TO_UNICAST_ENABLED = 244,
	NL80211_ATTR_BSSID = 245,
	NL80211_ATTR_SCHED_SCAN_RELATIVE_RSSI = 246,
	NL80211_ATTR_SCHED_SCAN_RSSI_ADJUST = 247,
	NL80211_ATTR_TIMEOUT_REASON = 248,
	NL80211_ATTR_FILS_ERP_USERNAME = 249,
	NL80211_ATTR_FILS_ERP_REALM = 250,
	NL80211_ATTR_FILS_ERP_NEXT_SEQ_NUM = 251,
	NL80211_ATTR_FILS_ERP_RRK = 252,
	NL80211_ATTR_FILS_CACHE_ID = 253,
	NL80211_ATTR_PMK = 254,
	NL80211_ATTR_SCHED_SCAN_MULTI = 255,
	NL80211_ATTR_SCHED_SCAN_MAX_REQS = 256,
	NL80211_ATTR_WANT_1X_4WAY_HS = 257,
	NL80211_ATTR_PMKR0_NAME = 258,
	NL80211_ATTR_PORT_AUTHORIZED = 259,
	NL80211_ATTR_EXTERNAL_AUTH_ACTION = 260,
	NL80211_ATTR_EXTERNAL_AUTH_SUPPORT = 261,
	NL80211_ATTR_NSS = 262,
	NL80211_ATTR_ACK_SIGNAL = 263,
	NL80211_ATTR_CONTROL_PORT_OVER_NL80211 = 264,
	NL80211_ATTR_TXQ_STATS = 265,
	NL80211_ATTR_TXQ_LIMIT = 266,
	NL80211_ATTR_TXQ_MEMORY_LIMIT = 267,
	NL80211_ATTR_TXQ_QUANTUM = 268,
	NL80211_ATTR_HE_CAPABILITY = 269,
	NL80211_ATTR_FTM_RESPONDER = 270,
	NL80211_ATTR_FTM_RESPONDER_STATS = 271,
	NL80211_ATTR_TIMEOUT = 272,
	NL80211_ATTR_PEER_MEASUREMENTS = 273,
	NL80211_ATTR_AIRTIME_WEIGHT = 274,
	NL80211_ATTR_STA_TX_POWER_SETTING = 275,
	NL80211_ATTR_STA_TX_POWER = 276,
	NL80211_ATTR_SAE_PASSWORD = 277,
	NL80211_ATTR_TWT_RESPONDER = 278,
	NL80211_ATTR_HE_OBSS_PD = 279,
	NL80211_ATTR_WIPHY_EDMG_CHANNELS = 280,
	NL80211_ATTR_WIPHY_EDMG_BW_CONFIG = 281,
	NL80211_ATTR_VLAN_ID = 282,
	NL80211_ATTR_HE_BSS_COLOR = 283,
	NL80211_ATTR_IFTYPE_AKM_SUITES = 284,
	NL80211_ATTR_TID_CONFIG = 285,
	NL80211_ATTR_CONTROL_PORT_NO_PREAUTH = 286,
	NL80211_ATTR_PMK_LIFETIME = 287,
	NL80211_ATTR_PMK_REAUTH_THRESHOLD = 288,
	NL80211_ATTR_RECEIVE_MULTICAST = 289,
	NL80211_ATTR_WIPHY_FREQ_OFFSET = 290,
	NL80211_ATTR_CENTER_FREQ1_OFFSET = 291,
	NL80211_ATTR_SCAN_FREQ_KHZ = 292,
	NL80211_ATTR_HE_6GHZ_CAPABILITY = 293,
	NL80211_ATTR_FILS_DISCOVERY = 294,
	NL80211_ATTR_UNSOL_BCAST_PROBE_RESP = 295,
	NL80211_ATTR_S1G_CAPABILITY = 296,
	NL80211_ATTR_S1G_CAPABILITY_MASK = 297,
	NL80211_ATTR_SAE_PWE = 298,
	NL80211_ATTR_RECONNECT_REQUESTED = 299,
	NL80211_ATTR_SAR_SPEC = 300,
	NL80211_ATTR_DISABLE_HE = 301,
	NL80211_ATTR_OBSS_COLOR_BITMAP = 302,
	NL80211_ATTR_COLOR_CHANGE_COUNT = 303,
	NL80211_ATTR_COLOR_CHANGE_COLOR = 304,
	NL80211_ATTR_COLOR_CHANGE_ELEMS = 305,
	NL80211_ATTR_MBSSID_CONFIG = 306,
	NL80211_ATTR_MBSSID_ELEMS = 307,
	NL80211_ATTR_RADAR_BACKGROUND = 308,
	NL80211_ATTR_AP_SETTINGS_FLAGS = 309,
	NL80211_ATTR_EHT_CAPABILITY = 310,
	NL80211_ATTR_DISABLE_EHT = 311,
	NL80211_ATTR_MLO_LINKS = 312,
	NL80211_ATTR_MLO_LINK_ID = 313,
	NL80211_ATTR_MLD_ADDR = 314,
	NL80211_ATTR_MLO_SUPPORT = 315,
	NL80211_ATTR_MAX_NUM_AKM_SUITES = 316,
	NL80211_ATTR_EML_CAPABILITY = 317,
	NL80211_ATTR_MLD_CAPA_AND_OPS = 318,
	NL80211_ATTR_TX_HW_TIMESTAMP = 319,
	NL80211_ATTR_RX_HW_TIMESTAMP = 320,
	NL80211_ATTR_TD_BITMAP = 321,
	NL80211_ATTR_PUNCT_BITMAP = 322,
	NL80211_ATTR_MAX_HW_TIMESTAMP_PEERS = 323,
	NL80211_ATTR_HW_TIMESTAMP_ENABLED = 324,
	NL80211_ATTR_EMA_RNR_ELEMS = 325,
	NL80211_ATTR_MLO_LINK_DISABLED = 326,
	NL80211_ATTR_BSS_DUMP_INCLUDE_USE_DATA = 327,
	NL80211_ATTR_MLO_TTLM_DLINK = 328,
	NL80211_ATTR_MLO_TTLM_ULINK = 329,
	NL80211_ATTR_ASSOC_SPP_AMSDU = 330,
	NL80211_ATTR_WIPHY_RADIOS = 331,
	NL80211_ATTR_WIPHY_INTERFACE_COMBINATIONS = 332,
	NL80211_ATTR_VIF_RADIO_MASK = 333,
	NL80211_ATTR_SUPPORTED_SELECTORS = 334,
	NL80211_ATTR_MLO_RECONF_REM_LINKS = 335,
	NL80211_ATTR_EPCS = 336,
	__NL80211_ATTR_AFTER_LAST = 337,
	NUM_NL80211_ATTR = 337,
	NL80211_ATTR_MAX = 336,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_band_attr {
	__NL80211_BAND_ATTR_INVALID = 0,
	NL80211_BAND_ATTR_FREQS = 1,
	NL80211_BAND_ATTR_RATES = 2,
	NL80211_BAND_ATTR_HT_MCS_SET = 3,
	NL80211_BAND_ATTR_HT_CAPA = 4,
	NL80211_BAND_ATTR_HT_AMPDU_FACTOR = 5,
	NL80211_BAND_ATTR_HT_AMPDU_DENSITY = 6,
	NL80211_BAND_ATTR_VHT_MCS_SET = 7,
	NL80211_BAND_ATTR_VHT_CAPA = 8,
	NL80211_BAND_ATTR_IFTYPE_DATA = 9,
	NL80211_BAND_ATTR_EDMG_CHANNELS = 10,
	NL80211_BAND_ATTR_EDMG_BW_CONFIG = 11,
	NL80211_BAND_ATTR_S1G_MCS_NSS_SET = 12,
	NL80211_BAND_ATTR_S1G_CAPA = 13,
	__NL80211_BAND_ATTR_AFTER_LAST = 14,
	NL80211_BAND_ATTR_MAX = 13,
};

enum nl80211_band_iftype_attr {
	__NL80211_BAND_IFTYPE_ATTR_INVALID = 0,
	NL80211_BAND_IFTYPE_ATTR_IFTYPES = 1,
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_MAC = 2,
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_PHY = 3,
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_MCS_SET = 4,
	NL80211_BAND_IFTYPE_ATTR_HE_CAP_PPE = 5,
	NL80211_BAND_IFTYPE_ATTR_HE_6GHZ_CAPA = 6,
	NL80211_BAND_IFTYPE_ATTR_VENDOR_ELEMS = 7,
	NL80211_BAND_IFTYPE_ATTR_EHT_CAP_MAC = 8,
	NL80211_BAND_IFTYPE_ATTR_EHT_CAP_PHY = 9,
	NL80211_BAND_IFTYPE_ATTR_EHT_CAP_MCS_SET = 10,
	NL80211_BAND_IFTYPE_ATTR_EHT_CAP_PPE = 11,
	__NL80211_BAND_IFTYPE_ATTR_AFTER_LAST = 12,
	NL80211_BAND_IFTYPE_ATTR_MAX = 11,
};

enum nl80211_bitrate_attr {
	__NL80211_BITRATE_ATTR_INVALID = 0,
	NL80211_BITRATE_ATTR_RATE = 1,
	NL80211_BITRATE_ATTR_2GHZ_SHORTPREAMBLE = 2,
	__NL80211_BITRATE_ATTR_AFTER_LAST = 3,
	NL80211_BITRATE_ATTR_MAX = 2,
};

enum nl80211_bss {
	__NL80211_BSS_INVALID = 0,
	NL80211_BSS_BSSID = 1,
	NL80211_BSS_FREQUENCY = 2,
	NL80211_BSS_TSF = 3,
	NL80211_BSS_BEACON_INTERVAL = 4,
	NL80211_BSS_CAPABILITY = 5,
	NL80211_BSS_INFORMATION_ELEMENTS = 6,
	NL80211_BSS_SIGNAL_MBM = 7,
	NL80211_BSS_SIGNAL_UNSPEC = 8,
	NL80211_BSS_STATUS = 9,
	NL80211_BSS_SEEN_MS_AGO = 10,
	NL80211_BSS_BEACON_IES = 11,
	NL80211_BSS_CHAN_WIDTH = 12,
	NL80211_BSS_BEACON_TSF = 13,
	NL80211_BSS_PRESP_DATA = 14,
	NL80211_BSS_LAST_SEEN_BOOTTIME = 15,
	NL80211_BSS_PAD = 16,
	NL80211_BSS_PARENT_TSF = 17,
	NL80211_BSS_PARENT_BSSID = 18,
	NL80211_BSS_CHAIN_SIGNAL = 19,
	NL80211_BSS_FREQUENCY_OFFSET = 20,
	NL80211_BSS_MLO_LINK_ID = 21,
	NL80211_BSS_MLD_ADDR = 22,
	NL80211_BSS_USE_FOR = 23,
	NL80211_BSS_CANNOT_USE_REASONS = 24,
	__NL80211_BSS_AFTER_LAST = 25,
	NL80211_BSS_MAX = 24,
};

enum nl80211_bss_cannot_use_reasons {
	NL80211_BSS_CANNOT_USE_NSTR_NONPRIMARY = 1,
	NL80211_BSS_CANNOT_USE_6GHZ_PWR_MISMATCH = 2,
};

enum nl80211_bss_color_attributes {
	__NL80211_HE_BSS_COLOR_ATTR_INVALID = 0,
	NL80211_HE_BSS_COLOR_ATTR_COLOR = 1,
	NL80211_HE_BSS_COLOR_ATTR_DISABLED = 2,
	NL80211_HE_BSS_COLOR_ATTR_PARTIAL = 3,
	__NL80211_HE_BSS_COLOR_ATTR_LAST = 4,
	NL80211_HE_BSS_COLOR_ATTR_MAX = 3,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_bss_status {
	NL80211_BSS_STATUS_AUTHENTICATED = 0,
	NL80211_BSS_STATUS_ASSOCIATED = 1,
	NL80211_BSS_STATUS_IBSS_JOINED = 2,
};

enum nl80211_bss_use_for {
	NL80211_BSS_USE_FOR_NORMAL = 1,
	NL80211_BSS_USE_FOR_MLD_LINK = 2,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_channel_type {
	NL80211_CHAN_NO_HT = 0,
	NL80211_CHAN_HT20 = 1,
	NL80211_CHAN_HT40MINUS = 2,
	NL80211_CHAN_HT40PLUS = 3,
};

enum nl80211_coalesce_condition {
	NL80211_COALESCE_CONDITION_MATCH = 0,
	NL80211_COALESCE_CONDITION_NO_MATCH = 1,
};

enum nl80211_commands {
	NL80211_CMD_UNSPEC = 0,
	NL80211_CMD_GET_WIPHY = 1,
	NL80211_CMD_SET_WIPHY = 2,
	NL80211_CMD_NEW_WIPHY = 3,
	NL80211_CMD_DEL_WIPHY = 4,
	NL80211_CMD_GET_INTERFACE = 5,
	NL80211_CMD_SET_INTERFACE = 6,
	NL80211_CMD_NEW_INTERFACE = 7,
	NL80211_CMD_DEL_INTERFACE = 8,
	NL80211_CMD_GET_KEY = 9,
	NL80211_CMD_SET_KEY = 10,
	NL80211_CMD_NEW_KEY = 11,
	NL80211_CMD_DEL_KEY = 12,
	NL80211_CMD_GET_BEACON = 13,
	NL80211_CMD_SET_BEACON = 14,
	NL80211_CMD_START_AP = 15,
	NL80211_CMD_NEW_BEACON = 15,
	NL80211_CMD_STOP_AP = 16,
	NL80211_CMD_DEL_BEACON = 16,
	NL80211_CMD_GET_STATION = 17,
	NL80211_CMD_SET_STATION = 18,
	NL80211_CMD_NEW_STATION = 19,
	NL80211_CMD_DEL_STATION = 20,
	NL80211_CMD_GET_MPATH = 21,
	NL80211_CMD_SET_MPATH = 22,
	NL80211_CMD_NEW_MPATH = 23,
	NL80211_CMD_DEL_MPATH = 24,
	NL80211_CMD_SET_BSS = 25,
	NL80211_CMD_SET_REG = 26,
	NL80211_CMD_REQ_SET_REG = 27,
	NL80211_CMD_GET_MESH_CONFIG = 28,
	NL80211_CMD_SET_MESH_CONFIG = 29,
	NL80211_CMD_SET_MGMT_EXTRA_IE = 30,
	NL80211_CMD_GET_REG = 31,
	NL80211_CMD_GET_SCAN = 32,
	NL80211_CMD_TRIGGER_SCAN = 33,
	NL80211_CMD_NEW_SCAN_RESULTS = 34,
	NL80211_CMD_SCAN_ABORTED = 35,
	NL80211_CMD_REG_CHANGE = 36,
	NL80211_CMD_AUTHENTICATE = 37,
	NL80211_CMD_ASSOCIATE = 38,
	NL80211_CMD_DEAUTHENTICATE = 39,
	NL80211_CMD_DISASSOCIATE = 40,
	NL80211_CMD_MICHAEL_MIC_FAILURE = 41,
	NL80211_CMD_REG_BEACON_HINT = 42,
	NL80211_CMD_JOIN_IBSS = 43,
	NL80211_CMD_LEAVE_IBSS = 44,
	NL80211_CMD_TESTMODE = 45,
	NL80211_CMD_CONNECT = 46,
	NL80211_CMD_ROAM = 47,
	NL80211_CMD_DISCONNECT = 48,
	NL80211_CMD_SET_WIPHY_NETNS = 49,
	NL80211_CMD_GET_SURVEY = 50,
	NL80211_CMD_NEW_SURVEY_RESULTS = 51,
	NL80211_CMD_SET_PMKSA = 52,
	NL80211_CMD_DEL_PMKSA = 53,
	NL80211_CMD_FLUSH_PMKSA = 54,
	NL80211_CMD_REMAIN_ON_CHANNEL = 55,
	NL80211_CMD_CANCEL_REMAIN_ON_CHANNEL = 56,
	NL80211_CMD_SET_TX_BITRATE_MASK = 57,
	NL80211_CMD_REGISTER_FRAME = 58,
	NL80211_CMD_REGISTER_ACTION = 58,
	NL80211_CMD_FRAME = 59,
	NL80211_CMD_ACTION = 59,
	NL80211_CMD_FRAME_TX_STATUS = 60,
	NL80211_CMD_ACTION_TX_STATUS = 60,
	NL80211_CMD_SET_POWER_SAVE = 61,
	NL80211_CMD_GET_POWER_SAVE = 62,
	NL80211_CMD_SET_CQM = 63,
	NL80211_CMD_NOTIFY_CQM = 64,
	NL80211_CMD_SET_CHANNEL = 65,
	NL80211_CMD_SET_WDS_PEER = 66,
	NL80211_CMD_FRAME_WAIT_CANCEL = 67,
	NL80211_CMD_JOIN_MESH = 68,
	NL80211_CMD_LEAVE_MESH = 69,
	NL80211_CMD_UNPROT_DEAUTHENTICATE = 70,
	NL80211_CMD_UNPROT_DISASSOCIATE = 71,
	NL80211_CMD_NEW_PEER_CANDIDATE = 72,
	NL80211_CMD_GET_WOWLAN = 73,
	NL80211_CMD_SET_WOWLAN = 74,
	NL80211_CMD_START_SCHED_SCAN = 75,
	NL80211_CMD_STOP_SCHED_SCAN = 76,
	NL80211_CMD_SCHED_SCAN_RESULTS = 77,
	NL80211_CMD_SCHED_SCAN_STOPPED = 78,
	NL80211_CMD_SET_REKEY_OFFLOAD = 79,
	NL80211_CMD_PMKSA_CANDIDATE = 80,
	NL80211_CMD_TDLS_OPER = 81,
	NL80211_CMD_TDLS_MGMT = 82,
	NL80211_CMD_UNEXPECTED_FRAME = 83,
	NL80211_CMD_PROBE_CLIENT = 84,
	NL80211_CMD_REGISTER_BEACONS = 85,
	NL80211_CMD_UNEXPECTED_4ADDR_FRAME = 86,
	NL80211_CMD_SET_NOACK_MAP = 87,
	NL80211_CMD_CH_SWITCH_NOTIFY = 88,
	NL80211_CMD_START_P2P_DEVICE = 89,
	NL80211_CMD_STOP_P2P_DEVICE = 90,
	NL80211_CMD_CONN_FAILED = 91,
	NL80211_CMD_SET_MCAST_RATE = 92,
	NL80211_CMD_SET_MAC_ACL = 93,
	NL80211_CMD_RADAR_DETECT = 94,
	NL80211_CMD_GET_PROTOCOL_FEATURES = 95,
	NL80211_CMD_UPDATE_FT_IES = 96,
	NL80211_CMD_FT_EVENT = 97,
	NL80211_CMD_CRIT_PROTOCOL_START = 98,
	NL80211_CMD_CRIT_PROTOCOL_STOP = 99,
	NL80211_CMD_GET_COALESCE = 100,
	NL80211_CMD_SET_COALESCE = 101,
	NL80211_CMD_CHANNEL_SWITCH = 102,
	NL80211_CMD_VENDOR = 103,
	NL80211_CMD_SET_QOS_MAP = 104,
	NL80211_CMD_ADD_TX_TS = 105,
	NL80211_CMD_DEL_TX_TS = 106,
	NL80211_CMD_GET_MPP = 107,
	NL80211_CMD_JOIN_OCB = 108,
	NL80211_CMD_LEAVE_OCB = 109,
	NL80211_CMD_CH_SWITCH_STARTED_NOTIFY = 110,
	NL80211_CMD_TDLS_CHANNEL_SWITCH = 111,
	NL80211_CMD_TDLS_CANCEL_CHANNEL_SWITCH = 112,
	NL80211_CMD_WIPHY_REG_CHANGE = 113,
	NL80211_CMD_ABORT_SCAN = 114,
	NL80211_CMD_START_NAN = 115,
	NL80211_CMD_STOP_NAN = 116,
	NL80211_CMD_ADD_NAN_FUNCTION = 117,
	NL80211_CMD_DEL_NAN_FUNCTION = 118,
	NL80211_CMD_CHANGE_NAN_CONFIG = 119,
	NL80211_CMD_NAN_MATCH = 120,
	NL80211_CMD_SET_MULTICAST_TO_UNICAST = 121,
	NL80211_CMD_UPDATE_CONNECT_PARAMS = 122,
	NL80211_CMD_SET_PMK = 123,
	NL80211_CMD_DEL_PMK = 124,
	NL80211_CMD_PORT_AUTHORIZED = 125,
	NL80211_CMD_RELOAD_REGDB = 126,
	NL80211_CMD_EXTERNAL_AUTH = 127,
	NL80211_CMD_STA_OPMODE_CHANGED = 128,
	NL80211_CMD_CONTROL_PORT_FRAME = 129,
	NL80211_CMD_GET_FTM_RESPONDER_STATS = 130,
	NL80211_CMD_PEER_MEASUREMENT_START = 131,
	NL80211_CMD_PEER_MEASUREMENT_RESULT = 132,
	NL80211_CMD_PEER_MEASUREMENT_COMPLETE = 133,
	NL80211_CMD_NOTIFY_RADAR = 134,
	NL80211_CMD_UPDATE_OWE_INFO = 135,
	NL80211_CMD_PROBE_MESH_LINK = 136,
	NL80211_CMD_SET_TID_CONFIG = 137,
	NL80211_CMD_UNPROT_BEACON = 138,
	NL80211_CMD_CONTROL_PORT_FRAME_TX_STATUS = 139,
	NL80211_CMD_SET_SAR_SPECS = 140,
	NL80211_CMD_OBSS_COLOR_COLLISION = 141,
	NL80211_CMD_COLOR_CHANGE_REQUEST = 142,
	NL80211_CMD_COLOR_CHANGE_STARTED = 143,
	NL80211_CMD_COLOR_CHANGE_ABORTED = 144,
	NL80211_CMD_COLOR_CHANGE_COMPLETED = 145,
	NL80211_CMD_SET_FILS_AAD = 146,
	NL80211_CMD_ASSOC_COMEBACK = 147,
	NL80211_CMD_ADD_LINK = 148,
	NL80211_CMD_REMOVE_LINK = 149,
	NL80211_CMD_ADD_LINK_STA = 150,
	NL80211_CMD_MODIFY_LINK_STA = 151,
	NL80211_CMD_REMOVE_LINK_STA = 152,
	NL80211_CMD_SET_HW_TIMESTAMP = 153,
	NL80211_CMD_LINKS_REMOVED = 154,
	NL80211_CMD_SET_TID_TO_LINK_MAPPING = 155,
	NL80211_CMD_ASSOC_MLO_RECONF = 156,
	NL80211_CMD_EPCS_CFG = 157,
	__NL80211_CMD_AFTER_LAST = 158,
	NL80211_CMD_MAX = 157,
};

enum nl80211_connect_failed_reason {
	NL80211_CONN_FAIL_MAX_CLIENTS = 0,
	NL80211_CONN_FAIL_BLOCKED_CLIENT = 1,
};

enum nl80211_cqm_rssi_threshold_event {
	NL80211_CQM_RSSI_THRESHOLD_EVENT_LOW = 0,
	NL80211_CQM_RSSI_THRESHOLD_EVENT_HIGH = 1,
	NL80211_CQM_RSSI_BEACON_LOSS_EVENT = 2,
};

enum nl80211_crit_proto_id {
	NL80211_CRIT_PROTO_UNSPEC = 0,
	NL80211_CRIT_PROTO_DHCP = 1,
	NL80211_CRIT_PROTO_EAPOL = 2,
	NL80211_CRIT_PROTO_APIPA = 3,
	NUM_NL80211_CRIT_PROTO = 4,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_eht_gi {
	NL80211_RATE_INFO_EHT_GI_0_8 = 0,
	NL80211_RATE_INFO_EHT_GI_1_6 = 1,
	NL80211_RATE_INFO_EHT_GI_3_2 = 2,
};

enum nl80211_eht_ru_alloc {
	NL80211_RATE_INFO_EHT_RU_ALLOC_26 = 0,
	NL80211_RATE_INFO_EHT_RU_ALLOC_52 = 1,
	NL80211_RATE_INFO_EHT_RU_ALLOC_52P26 = 2,
	NL80211_RATE_INFO_EHT_RU_ALLOC_106 = 3,
	NL80211_RATE_INFO_EHT_RU_ALLOC_106P26 = 4,
	NL80211_RATE_INFO_EHT_RU_ALLOC_242 = 5,
	NL80211_RATE_INFO_EHT_RU_ALLOC_484 = 6,
	NL80211_RATE_INFO_EHT_RU_ALLOC_484P242 = 7,
	NL80211_RATE_INFO_EHT_RU_ALLOC_996 = 8,
	NL80211_RATE_INFO_EHT_RU_ALLOC_996P484 = 9,
	NL80211_RATE_INFO_EHT_RU_ALLOC_996P484P242 = 10,
	NL80211_RATE_INFO_EHT_RU_ALLOC_2x996 = 11,
	NL80211_RATE_INFO_EHT_RU_ALLOC_2x996P484 = 12,
	NL80211_RATE_INFO_EHT_RU_ALLOC_3x996 = 13,
	NL80211_RATE_INFO_EHT_RU_ALLOC_3x996P484 = 14,
	NL80211_RATE_INFO_EHT_RU_ALLOC_4x996 = 15,
};

enum nl80211_ext_feature_index {
	NL80211_EXT_FEATURE_VHT_IBSS = 0,
	NL80211_EXT_FEATURE_RRM = 1,
	NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER = 2,
	NL80211_EXT_FEATURE_SCAN_START_TIME = 3,
	NL80211_EXT_FEATURE_BSS_PARENT_TSF = 4,
	NL80211_EXT_FEATURE_SET_SCAN_DWELL = 5,
	NL80211_EXT_FEATURE_BEACON_RATE_LEGACY = 6,
	NL80211_EXT_FEATURE_BEACON_RATE_HT = 7,
	NL80211_EXT_FEATURE_BEACON_RATE_VHT = 8,
	NL80211_EXT_FEATURE_FILS_STA = 9,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA = 10,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED = 11,
	NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI = 12,
	NL80211_EXT_FEATURE_CQM_RSSI_LIST = 13,
	NL80211_EXT_FEATURE_FILS_SK_OFFLOAD = 14,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK = 15,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X = 16,
	NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME = 17,
	NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP = 18,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE = 19,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 20,
	NL80211_EXT_FEATURE_MFP_OPTIONAL = 21,
	NL80211_EXT_FEATURE_LOW_SPAN_SCAN = 22,
	NL80211_EXT_FEATURE_LOW_POWER_SCAN = 23,
	NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN = 24,
	NL80211_EXT_FEATURE_DFS_OFFLOAD = 25,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211 = 26,
	NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_TXQS = 28,
	NL80211_EXT_FEATURE_SCAN_RANDOM_SN = 29,
	NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT = 30,
	NL80211_EXT_FEATURE_CAN_REPLACE_PTK0 = 31,
	NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER = 32,
	NL80211_EXT_FEATURE_AIRTIME_FAIRNESS = 33,
	NL80211_EXT_FEATURE_AP_PMKSA_CACHING = 34,
	NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD = 35,
	NL80211_EXT_FEATURE_EXT_KEY_ID = 36,
	NL80211_EXT_FEATURE_STA_TX_PWR = 37,
	NL80211_EXT_FEATURE_SAE_OFFLOAD = 38,
	NL80211_EXT_FEATURE_VLAN_OFFLOAD = 39,
	NL80211_EXT_FEATURE_AQL = 40,
	NL80211_EXT_FEATURE_BEACON_PROTECTION = 41,
	NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH = 42,
	NL80211_EXT_FEATURE_PROTECTED_TWT = 43,
	NL80211_EXT_FEATURE_DEL_IBSS_STA = 44,
	NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS = 45,
	NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT = 46,
	NL80211_EXT_FEATURE_SCAN_FREQ_KHZ = 47,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS = 48,
	NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION = 49,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK = 50,
	NL80211_EXT_FEATURE_SAE_OFFLOAD_AP = 51,
	NL80211_EXT_FEATURE_FILS_DISCOVERY = 52,
	NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP = 53,
	NL80211_EXT_FEATURE_BEACON_RATE_HE = 54,
	NL80211_EXT_FEATURE_SECURE_LTF = 55,
	NL80211_EXT_FEATURE_SECURE_RTT = 56,
	NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE = 57,
	NL80211_EXT_FEATURE_BSS_COLOR = 58,
	NL80211_EXT_FEATURE_FILS_CRYPTO_OFFLOAD = 59,
	NL80211_EXT_FEATURE_RADAR_BACKGROUND = 60,
	NL80211_EXT_FEATURE_POWERED_ADDR_CHANGE = 61,
	NL80211_EXT_FEATURE_PUNCT = 62,
	NL80211_EXT_FEATURE_SECURE_NAN = 63,
	NL80211_EXT_FEATURE_AUTH_AND_DEAUTH_RANDOM_TA = 64,
	NL80211_EXT_FEATURE_OWE_OFFLOAD = 65,
	NL80211_EXT_FEATURE_OWE_OFFLOAD_AP = 66,
	NL80211_EXT_FEATURE_DFS_CONCURRENT = 67,
	NL80211_EXT_FEATURE_SPP_AMSDU_SUPPORT = 68,
	NUM_NL80211_EXT_FEATURES = 69,
	MAX_NL80211_EXT_FEATURES = 68,
};

enum nl80211_external_auth_action {
	NL80211_EXTERNAL_AUTH_START = 0,
	NL80211_EXTERNAL_AUTH_ABORT = 1,
};

enum nl80211_feature_flags {
	NL80211_FEATURE_SK_TX_STATUS = 1,
	NL80211_FEATURE_HT_IBSS = 2,
	NL80211_FEATURE_INACTIVITY_TIMER = 4,
	NL80211_FEATURE_CELL_BASE_REG_HINTS = 8,
	NL80211_FEATURE_P2P_DEVICE_NEEDS_CHANNEL = 16,
	NL80211_FEATURE_SAE = 32,
	NL80211_FEATURE_LOW_PRIORITY_SCAN = 64,
	NL80211_FEATURE_SCAN_FLUSH = 128,
	NL80211_FEATURE_AP_SCAN = 256,
	NL80211_FEATURE_VIF_TXPOWER = 512,
	NL80211_FEATURE_NEED_OBSS_SCAN = 1024,
	NL80211_FEATURE_P2P_GO_CTWIN = 2048,
	NL80211_FEATURE_P2P_GO_OPPPS = 4096,
	NL80211_FEATURE_ADVERTISE_CHAN_LIMITS = 16384,
	NL80211_FEATURE_FULL_AP_CLIENT_STATE = 32768,
	NL80211_FEATURE_USERSPACE_MPM = 65536,
	NL80211_FEATURE_ACTIVE_MONITOR = 131072,
	NL80211_FEATURE_AP_MODE_CHAN_WIDTH_CHANGE = 262144,
	NL80211_FEATURE_DS_PARAM_SET_IE_IN_PROBES = 524288,
	NL80211_FEATURE_WFA_TPC_IE_IN_PROBES = 1048576,
	NL80211_FEATURE_QUIET = 2097152,
	NL80211_FEATURE_TX_POWER_INSERTION = 4194304,
	NL80211_FEATURE_ACKTO_ESTIMATION = 8388608,
	NL80211_FEATURE_STATIC_SMPS = 16777216,
	NL80211_FEATURE_DYNAMIC_SMPS = 33554432,
	NL80211_FEATURE_SUPPORTS_WMM_ADMISSION = 67108864,
	NL80211_FEATURE_MAC_ON_CREATE = 134217728,
	NL80211_FEATURE_TDLS_CHANNEL_SWITCH = 268435456,
	NL80211_FEATURE_SCAN_RANDOM_MAC_ADDR = 536870912,
	NL80211_FEATURE_SCHED_SCAN_RANDOM_MAC_ADDR = 1073741824,
	NL80211_FEATURE_ND_RANDOM_MAC_ADDR = 2147483648,
};

enum nl80211_fils_discovery_attributes {
	__NL80211_FILS_DISCOVERY_ATTR_INVALID = 0,
	NL80211_FILS_DISCOVERY_ATTR_INT_MIN = 1,
	NL80211_FILS_DISCOVERY_ATTR_INT_MAX = 2,
	NL80211_FILS_DISCOVERY_ATTR_TMPL = 3,
	__NL80211_FILS_DISCOVERY_ATTR_LAST = 4,
	NL80211_FILS_DISCOVERY_ATTR_MAX = 3,
};

enum nl80211_frequency_attr {
	__NL80211_FREQUENCY_ATTR_INVALID = 0,
	NL80211_FREQUENCY_ATTR_FREQ = 1,
	NL80211_FREQUENCY_ATTR_DISABLED = 2,
	NL80211_FREQUENCY_ATTR_NO_IR = 3,
	__NL80211_FREQUENCY_ATTR_NO_IBSS = 4,
	NL80211_FREQUENCY_ATTR_RADAR = 5,
	NL80211_FREQUENCY_ATTR_MAX_TX_POWER = 6,
	NL80211_FREQUENCY_ATTR_DFS_STATE = 7,
	NL80211_FREQUENCY_ATTR_DFS_TIME = 8,
	NL80211_FREQUENCY_ATTR_NO_HT40_MINUS = 9,
	NL80211_FREQUENCY_ATTR_NO_HT40_PLUS = 10,
	NL80211_FREQUENCY_ATTR_NO_80MHZ = 11,
	NL80211_FREQUENCY_ATTR_NO_160MHZ = 12,
	NL80211_FREQUENCY_ATTR_DFS_CAC_TIME = 13,
	NL80211_FREQUENCY_ATTR_INDOOR_ONLY = 14,
	NL80211_FREQUENCY_ATTR_IR_CONCURRENT = 15,
	NL80211_FREQUENCY_ATTR_NO_20MHZ = 16,
	NL80211_FREQUENCY_ATTR_NO_10MHZ = 17,
	NL80211_FREQUENCY_ATTR_WMM = 18,
	NL80211_FREQUENCY_ATTR_NO_HE = 19,
	NL80211_FREQUENCY_ATTR_OFFSET = 20,
	NL80211_FREQUENCY_ATTR_1MHZ = 21,
	NL80211_FREQUENCY_ATTR_2MHZ = 22,
	NL80211_FREQUENCY_ATTR_4MHZ = 23,
	NL80211_FREQUENCY_ATTR_8MHZ = 24,
	NL80211_FREQUENCY_ATTR_16MHZ = 25,
	NL80211_FREQUENCY_ATTR_NO_320MHZ = 26,
	NL80211_FREQUENCY_ATTR_NO_EHT = 27,
	NL80211_FREQUENCY_ATTR_PSD = 28,
	NL80211_FREQUENCY_ATTR_DFS_CONCURRENT = 29,
	NL80211_FREQUENCY_ATTR_NO_6GHZ_VLP_CLIENT = 30,
	NL80211_FREQUENCY_ATTR_NO_6GHZ_AFC_CLIENT = 31,
	NL80211_FREQUENCY_ATTR_CAN_MONITOR = 32,
	NL80211_FREQUENCY_ATTR_ALLOW_6GHZ_VLP_AP = 33,
	__NL80211_FREQUENCY_ATTR_AFTER_LAST = 34,
	NL80211_FREQUENCY_ATTR_MAX = 33,
};

enum nl80211_ftm_responder_attributes {
	__NL80211_FTM_RESP_ATTR_INVALID = 0,
	NL80211_FTM_RESP_ATTR_ENABLED = 1,
	NL80211_FTM_RESP_ATTR_LCI = 2,
	NL80211_FTM_RESP_ATTR_CIVICLOC = 3,
	__NL80211_FTM_RESP_ATTR_LAST = 4,
	NL80211_FTM_RESP_ATTR_MAX = 3,
};

enum nl80211_ftm_responder_stats {
	__NL80211_FTM_STATS_INVALID = 0,
	NL80211_FTM_STATS_SUCCESS_NUM = 1,
	NL80211_FTM_STATS_PARTIAL_NUM = 2,
	NL80211_FTM_STATS_FAILED_NUM = 3,
	NL80211_FTM_STATS_ASAP_NUM = 4,
	NL80211_FTM_STATS_NON_ASAP_NUM = 5,
	NL80211_FTM_STATS_TOTAL_DURATION_MSEC = 6,
	NL80211_FTM_STATS_UNKNOWN_TRIGGERS_NUM = 7,
	NL80211_FTM_STATS_RESCHEDULE_REQUESTS_NUM = 8,
	NL80211_FTM_STATS_OUT_OF_WINDOW_TRIGGERS_NUM = 9,
	NL80211_FTM_STATS_PAD = 10,
	__NL80211_FTM_STATS_AFTER_LAST = 11,
	NL80211_FTM_STATS_MAX = 10,
};

enum nl80211_he_gi {
	NL80211_RATE_INFO_HE_GI_0_8 = 0,
	NL80211_RATE_INFO_HE_GI_1_6 = 1,
	NL80211_RATE_INFO_HE_GI_3_2 = 2,
};

enum nl80211_he_ltf {
	NL80211_RATE_INFO_HE_1XLTF = 0,
	NL80211_RATE_INFO_HE_2XLTF = 1,
	NL80211_RATE_INFO_HE_4XLTF = 2,
};

enum nl80211_he_ru_alloc {
	NL80211_RATE_INFO_HE_RU_ALLOC_26 = 0,
	NL80211_RATE_INFO_HE_RU_ALLOC_52 = 1,
	NL80211_RATE_INFO_HE_RU_ALLOC_106 = 2,
	NL80211_RATE_INFO_HE_RU_ALLOC_242 = 3,
	NL80211_RATE_INFO_HE_RU_ALLOC_484 = 4,
	NL80211_RATE_INFO_HE_RU_ALLOC_996 = 5,
	NL80211_RATE_INFO_HE_RU_ALLOC_2x996 = 6,
};

enum nl80211_hidden_ssid {
	NL80211_HIDDEN_SSID_NOT_IN_USE = 0,
	NL80211_HIDDEN_SSID_ZERO_LEN = 1,
	NL80211_HIDDEN_SSID_ZERO_CONTENTS = 2,
};

enum nl80211_if_combination_attrs {
	NL80211_IFACE_COMB_UNSPEC = 0,
	NL80211_IFACE_COMB_LIMITS = 1,
	NL80211_IFACE_COMB_MAXNUM = 2,
	NL80211_IFACE_COMB_STA_AP_BI_MATCH = 3,
	NL80211_IFACE_COMB_NUM_CHANNELS = 4,
	NL80211_IFACE_COMB_RADAR_DETECT_WIDTHS = 5,
	NL80211_IFACE_COMB_RADAR_DETECT_REGIONS = 6,
	NL80211_IFACE_COMB_BI_MIN_GCD = 7,
	NUM_NL80211_IFACE_COMB = 8,
	MAX_NL80211_IFACE_COMB = 7,
};

enum nl80211_iface_limit_attrs {
	NL80211_IFACE_LIMIT_UNSPEC = 0,
	NL80211_IFACE_LIMIT_MAX = 1,
	NL80211_IFACE_LIMIT_TYPES = 2,
	NUM_NL80211_IFACE_LIMIT = 3,
	MAX_NL80211_IFACE_LIMIT = 2,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_iftype_akm_attributes {
	__NL80211_IFTYPE_AKM_ATTR_INVALID = 0,
	NL80211_IFTYPE_AKM_ATTR_IFTYPES = 1,
	NL80211_IFTYPE_AKM_ATTR_SUITES = 2,
	__NL80211_IFTYPE_AKM_ATTR_LAST = 3,
	NL80211_IFTYPE_AKM_ATTR_MAX = 2,
};

enum nl80211_key_attributes {
	__NL80211_KEY_INVALID = 0,
	NL80211_KEY_DATA = 1,
	NL80211_KEY_IDX = 2,
	NL80211_KEY_CIPHER = 3,
	NL80211_KEY_SEQ = 4,
	NL80211_KEY_DEFAULT = 5,
	NL80211_KEY_DEFAULT_MGMT = 6,
	NL80211_KEY_TYPE = 7,
	NL80211_KEY_DEFAULT_TYPES = 8,
	NL80211_KEY_MODE = 9,
	NL80211_KEY_DEFAULT_BEACON = 10,
	__NL80211_KEY_AFTER_LAST = 11,
	NL80211_KEY_MAX = 10,
};

enum nl80211_key_default_types {
	__NL80211_KEY_DEFAULT_TYPE_INVALID = 0,
	NL80211_KEY_DEFAULT_TYPE_UNICAST = 1,
	NL80211_KEY_DEFAULT_TYPE_MULTICAST = 2,
	NUM_NL80211_KEY_DEFAULT_TYPES = 3,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_key_type {
	NL80211_KEYTYPE_GROUP = 0,
	NL80211_KEYTYPE_PAIRWISE = 1,
	NL80211_KEYTYPE_PEERKEY = 2,
	NUM_NL80211_KEYTYPES = 3,
};

enum nl80211_mbssid_config_attributes {
	__NL80211_MBSSID_CONFIG_ATTR_INVALID = 0,
	NL80211_MBSSID_CONFIG_ATTR_MAX_INTERFACES = 1,
	NL80211_MBSSID_CONFIG_ATTR_MAX_EMA_PROFILE_PERIODICITY = 2,
	NL80211_MBSSID_CONFIG_ATTR_INDEX = 3,
	NL80211_MBSSID_CONFIG_ATTR_TX_IFINDEX = 4,
	NL80211_MBSSID_CONFIG_ATTR_EMA = 5,
	__NL80211_MBSSID_CONFIG_ATTR_LAST = 6,
	NL80211_MBSSID_CONFIG_ATTR_MAX = 5,
};

enum nl80211_mesh_power_mode {
	NL80211_MESH_POWER_UNKNOWN = 0,
	NL80211_MESH_POWER_ACTIVE = 1,
	NL80211_MESH_POWER_LIGHT_SLEEP = 2,
	NL80211_MESH_POWER_DEEP_SLEEP = 3,
	__NL80211_MESH_POWER_AFTER_LAST = 4,
	NL80211_MESH_POWER_MAX = 3,
};

enum nl80211_mesh_setup_params {
	__NL80211_MESH_SETUP_INVALID = 0,
	NL80211_MESH_SETUP_ENABLE_VENDOR_PATH_SEL = 1,
	NL80211_MESH_SETUP_ENABLE_VENDOR_METRIC = 2,
	NL80211_MESH_SETUP_IE = 3,
	NL80211_MESH_SETUP_USERSPACE_AUTH = 4,
	NL80211_MESH_SETUP_USERSPACE_AMPE = 5,
	NL80211_MESH_SETUP_ENABLE_VENDOR_SYNC = 6,
	NL80211_MESH_SETUP_USERSPACE_MPM = 7,
	NL80211_MESH_SETUP_AUTH_PROTOCOL = 8,
	__NL80211_MESH_SETUP_ATTR_AFTER_LAST = 9,
	NL80211_MESH_SETUP_ATTR_MAX = 8,
};

enum nl80211_meshconf_params {
	__NL80211_MESHCONF_INVALID = 0,
	NL80211_MESHCONF_RETRY_TIMEOUT = 1,
	NL80211_MESHCONF_CONFIRM_TIMEOUT = 2,
	NL80211_MESHCONF_HOLDING_TIMEOUT = 3,
	NL80211_MESHCONF_MAX_PEER_LINKS = 4,
	NL80211_MESHCONF_MAX_RETRIES = 5,
	NL80211_MESHCONF_TTL = 6,
	NL80211_MESHCONF_AUTO_OPEN_PLINKS = 7,
	NL80211_MESHCONF_HWMP_MAX_PREQ_RETRIES = 8,
	NL80211_MESHCONF_PATH_REFRESH_TIME = 9,
	NL80211_MESHCONF_MIN_DISCOVERY_TIMEOUT = 10,
	NL80211_MESHCONF_HWMP_ACTIVE_PATH_TIMEOUT = 11,
	NL80211_MESHCONF_HWMP_PREQ_MIN_INTERVAL = 12,
	NL80211_MESHCONF_HWMP_NET_DIAM_TRVS_TIME = 13,
	NL80211_MESHCONF_HWMP_ROOTMODE = 14,
	NL80211_MESHCONF_ELEMENT_TTL = 15,
	NL80211_MESHCONF_HWMP_RANN_INTERVAL = 16,
	NL80211_MESHCONF_GATE_ANNOUNCEMENTS = 17,
	NL80211_MESHCONF_HWMP_PERR_MIN_INTERVAL = 18,
	NL80211_MESHCONF_FORWARDING = 19,
	NL80211_MESHCONF_RSSI_THRESHOLD = 20,
	NL80211_MESHCONF_SYNC_OFFSET_MAX_NEIGHBOR = 21,
	NL80211_MESHCONF_HT_OPMODE = 22,
	NL80211_MESHCONF_HWMP_PATH_TO_ROOT_TIMEOUT = 23,
	NL80211_MESHCONF_HWMP_ROOT_INTERVAL = 24,
	NL80211_MESHCONF_HWMP_CONFIRMATION_INTERVAL = 25,
	NL80211_MESHCONF_POWER_MODE = 26,
	NL80211_MESHCONF_AWAKE_WINDOW = 27,
	NL80211_MESHCONF_PLINK_TIMEOUT = 28,
	NL80211_MESHCONF_CONNECTED_TO_GATE = 29,
	NL80211_MESHCONF_NOLEARN = 30,
	NL80211_MESHCONF_CONNECTED_TO_AS = 31,
	__NL80211_MESHCONF_ATTR_AFTER_LAST = 32,
	NL80211_MESHCONF_ATTR_MAX = 31,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_mntr_flags {
	__NL80211_MNTR_FLAG_INVALID = 0,
	NL80211_MNTR_FLAG_FCSFAIL = 1,
	NL80211_MNTR_FLAG_PLCPFAIL = 2,
	NL80211_MNTR_FLAG_CONTROL = 3,
	NL80211_MNTR_FLAG_OTHER_BSS = 4,
	NL80211_MNTR_FLAG_COOK_FRAMES = 5,
	NL80211_MNTR_FLAG_ACTIVE = 6,
	NL80211_MNTR_FLAG_SKIP_TX = 7,
	__NL80211_MNTR_FLAG_AFTER_LAST = 8,
	NL80211_MNTR_FLAG_MAX = 7,
};

enum nl80211_mpath_info {
	__NL80211_MPATH_INFO_INVALID = 0,
	NL80211_MPATH_INFO_FRAME_QLEN = 1,
	NL80211_MPATH_INFO_SN = 2,
	NL80211_MPATH_INFO_METRIC = 3,
	NL80211_MPATH_INFO_EXPTIME = 4,
	NL80211_MPATH_INFO_FLAGS = 5,
	NL80211_MPATH_INFO_DISCOVERY_TIMEOUT = 6,
	NL80211_MPATH_INFO_DISCOVERY_RETRIES = 7,
	NL80211_MPATH_INFO_HOP_COUNT = 8,
	NL80211_MPATH_INFO_PATH_CHANGE = 9,
	__NL80211_MPATH_INFO_AFTER_LAST = 10,
	NL80211_MPATH_INFO_MAX = 9,
};

enum nl80211_multicast_groups {
	NL80211_MCGRP_CONFIG = 0,
	NL80211_MCGRP_SCAN = 1,
	NL80211_MCGRP_REGULATORY = 2,
	NL80211_MCGRP_MLME = 3,
	NL80211_MCGRP_VENDOR = 4,
	NL80211_MCGRP_NAN = 5,
	NL80211_MCGRP_TESTMODE = 6,
};

enum nl80211_nan_func_attributes {
	__NL80211_NAN_FUNC_INVALID = 0,
	NL80211_NAN_FUNC_TYPE = 1,
	NL80211_NAN_FUNC_SERVICE_ID = 2,
	NL80211_NAN_FUNC_PUBLISH_TYPE = 3,
	NL80211_NAN_FUNC_PUBLISH_BCAST = 4,
	NL80211_NAN_FUNC_SUBSCRIBE_ACTIVE = 5,
	NL80211_NAN_FUNC_FOLLOW_UP_ID = 6,
	NL80211_NAN_FUNC_FOLLOW_UP_REQ_ID = 7,
	NL80211_NAN_FUNC_FOLLOW_UP_DEST = 8,
	NL80211_NAN_FUNC_CLOSE_RANGE = 9,
	NL80211_NAN_FUNC_TTL = 10,
	NL80211_NAN_FUNC_SERVICE_INFO = 11,
	NL80211_NAN_FUNC_SRF = 12,
	NL80211_NAN_FUNC_RX_MATCH_FILTER = 13,
	NL80211_NAN_FUNC_TX_MATCH_FILTER = 14,
	NL80211_NAN_FUNC_INSTANCE_ID = 15,
	NL80211_NAN_FUNC_TERM_REASON = 16,
	NUM_NL80211_NAN_FUNC_ATTR = 17,
	NL80211_NAN_FUNC_ATTR_MAX = 16,
};

enum nl80211_nan_func_term_reason {
	NL80211_NAN_FUNC_TERM_REASON_USER_REQUEST = 0,
	NL80211_NAN_FUNC_TERM_REASON_TTL_EXPIRED = 1,
	NL80211_NAN_FUNC_TERM_REASON_ERROR = 2,
};

enum nl80211_nan_function_type {
	NL80211_NAN_FUNC_PUBLISH = 0,
	NL80211_NAN_FUNC_SUBSCRIBE = 1,
	NL80211_NAN_FUNC_FOLLOW_UP = 2,
	__NL80211_NAN_FUNC_TYPE_AFTER_LAST = 3,
	NL80211_NAN_FUNC_MAX_TYPE = 2,
};

enum nl80211_nan_match_attributes {
	__NL80211_NAN_MATCH_INVALID = 0,
	NL80211_NAN_MATCH_FUNC_LOCAL = 1,
	NL80211_NAN_MATCH_FUNC_PEER = 2,
	NUM_NL80211_NAN_MATCH_ATTR = 3,
	NL80211_NAN_MATCH_ATTR_MAX = 2,
};

enum nl80211_nan_publish_type {
	NL80211_NAN_SOLICITED_PUBLISH = 1,
	NL80211_NAN_UNSOLICITED_PUBLISH = 2,
};

enum nl80211_nan_srf_attributes {
	__NL80211_NAN_SRF_INVALID = 0,
	NL80211_NAN_SRF_INCLUDE = 1,
	NL80211_NAN_SRF_BF = 2,
	NL80211_NAN_SRF_BF_IDX = 3,
	NL80211_NAN_SRF_MAC_ADDRS = 4,
	NUM_NL80211_NAN_SRF_ATTR = 5,
	NL80211_NAN_SRF_ATTR_MAX = 4,
};

enum nl80211_obss_pd_attributes {
	__NL80211_HE_OBSS_PD_ATTR_INVALID = 0,
	NL80211_HE_OBSS_PD_ATTR_MIN_OFFSET = 1,
	NL80211_HE_OBSS_PD_ATTR_MAX_OFFSET = 2,
	NL80211_HE_OBSS_PD_ATTR_NON_SRG_MAX_OFFSET = 3,
	NL80211_HE_OBSS_PD_ATTR_BSS_COLOR_BITMAP = 4,
	NL80211_HE_OBSS_PD_ATTR_PARTIAL_BSSID_BITMAP = 5,
	NL80211_HE_OBSS_PD_ATTR_SR_CTRL = 6,
	__NL80211_HE_OBSS_PD_ATTR_LAST = 7,
	NL80211_HE_OBSS_PD_ATTR_MAX = 6,
};

enum nl80211_packet_pattern_attr {
	__NL80211_PKTPAT_INVALID = 0,
	NL80211_PKTPAT_MASK = 1,
	NL80211_PKTPAT_PATTERN = 2,
	NL80211_PKTPAT_OFFSET = 3,
	NUM_NL80211_PKTPAT = 4,
	MAX_NL80211_PKTPAT = 3,
};

enum nl80211_peer_measurement_attrs {
	__NL80211_PMSR_ATTR_INVALID = 0,
	NL80211_PMSR_ATTR_MAX_PEERS = 1,
	NL80211_PMSR_ATTR_REPORT_AP_TSF = 2,
	NL80211_PMSR_ATTR_RANDOMIZE_MAC_ADDR = 3,
	NL80211_PMSR_ATTR_TYPE_CAPA = 4,
	NL80211_PMSR_ATTR_PEERS = 5,
	NUM_NL80211_PMSR_ATTR = 6,
	NL80211_PMSR_ATTR_MAX = 5,
};

enum nl80211_peer_measurement_ftm_capa {
	__NL80211_PMSR_FTM_CAPA_ATTR_INVALID = 0,
	NL80211_PMSR_FTM_CAPA_ATTR_ASAP = 1,
	NL80211_PMSR_FTM_CAPA_ATTR_NON_ASAP = 2,
	NL80211_PMSR_FTM_CAPA_ATTR_REQ_LCI = 3,
	NL80211_PMSR_FTM_CAPA_ATTR_REQ_CIVICLOC = 4,
	NL80211_PMSR_FTM_CAPA_ATTR_PREAMBLES = 5,
	NL80211_PMSR_FTM_CAPA_ATTR_BANDWIDTHS = 6,
	NL80211_PMSR_FTM_CAPA_ATTR_MAX_BURSTS_EXPONENT = 7,
	NL80211_PMSR_FTM_CAPA_ATTR_MAX_FTMS_PER_BURST = 8,
	NL80211_PMSR_FTM_CAPA_ATTR_TRIGGER_BASED = 9,
	NL80211_PMSR_FTM_CAPA_ATTR_NON_TRIGGER_BASED = 10,
	NUM_NL80211_PMSR_FTM_CAPA_ATTR = 11,
	NL80211_PMSR_FTM_CAPA_ATTR_MAX = 10,
};

enum nl80211_peer_measurement_ftm_failure_reasons {
	NL80211_PMSR_FTM_FAILURE_UNSPECIFIED = 0,
	NL80211_PMSR_FTM_FAILURE_NO_RESPONSE = 1,
	NL80211_PMSR_FTM_FAILURE_REJECTED = 2,
	NL80211_PMSR_FTM_FAILURE_WRONG_CHANNEL = 3,
	NL80211_PMSR_FTM_FAILURE_PEER_NOT_CAPABLE = 4,
	NL80211_PMSR_FTM_FAILURE_INVALID_TIMESTAMP = 5,
	NL80211_PMSR_FTM_FAILURE_PEER_BUSY = 6,
	NL80211_PMSR_FTM_FAILURE_BAD_CHANGED_PARAMS = 7,
};

enum nl80211_peer_measurement_ftm_req {
	__NL80211_PMSR_FTM_REQ_ATTR_INVALID = 0,
	NL80211_PMSR_FTM_REQ_ATTR_ASAP = 1,
	NL80211_PMSR_FTM_REQ_ATTR_PREAMBLE = 2,
	NL80211_PMSR_FTM_REQ_ATTR_NUM_BURSTS_EXP = 3,
	NL80211_PMSR_FTM_REQ_ATTR_BURST_PERIOD = 4,
	NL80211_PMSR_FTM_REQ_ATTR_BURST_DURATION = 5,
	NL80211_PMSR_FTM_REQ_ATTR_FTMS_PER_BURST = 6,
	NL80211_PMSR_FTM_REQ_ATTR_NUM_FTMR_RETRIES = 7,
	NL80211_PMSR_FTM_REQ_ATTR_REQUEST_LCI = 8,
	NL80211_PMSR_FTM_REQ_ATTR_REQUEST_CIVICLOC = 9,
	NL80211_PMSR_FTM_REQ_ATTR_TRIGGER_BASED = 10,
	NL80211_PMSR_FTM_REQ_ATTR_NON_TRIGGER_BASED = 11,
	NL80211_PMSR_FTM_REQ_ATTR_LMR_FEEDBACK = 12,
	NL80211_PMSR_FTM_REQ_ATTR_BSS_COLOR = 13,
	NUM_NL80211_PMSR_FTM_REQ_ATTR = 14,
	NL80211_PMSR_FTM_REQ_ATTR_MAX = 13,
};

enum nl80211_peer_measurement_ftm_resp {
	__NL80211_PMSR_FTM_RESP_ATTR_INVALID = 0,
	NL80211_PMSR_FTM_RESP_ATTR_FAIL_REASON = 1,
	NL80211_PMSR_FTM_RESP_ATTR_BURST_INDEX = 2,
	NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_ATTEMPTS = 3,
	NL80211_PMSR_FTM_RESP_ATTR_NUM_FTMR_SUCCESSES = 4,
	NL80211_PMSR_FTM_RESP_ATTR_BUSY_RETRY_TIME = 5,
	NL80211_PMSR_FTM_RESP_ATTR_NUM_BURSTS_EXP = 6,
	NL80211_PMSR_FTM_RESP_ATTR_BURST_DURATION = 7,
	NL80211_PMSR_FTM_RESP_ATTR_FTMS_PER_BURST = 8,
	NL80211_PMSR_FTM_RESP_ATTR_RSSI_AVG = 9,
	NL80211_PMSR_FTM_RESP_ATTR_RSSI_SPREAD = 10,
	NL80211_PMSR_FTM_RESP_ATTR_TX_RATE = 11,
	NL80211_PMSR_FTM_RESP_ATTR_RX_RATE = 12,
	NL80211_PMSR_FTM_RESP_ATTR_RTT_AVG = 13,
	NL80211_PMSR_FTM_RESP_ATTR_RTT_VARIANCE = 14,
	NL80211_PMSR_FTM_RESP_ATTR_RTT_SPREAD = 15,
	NL80211_PMSR_FTM_RESP_ATTR_DIST_AVG = 16,
	NL80211_PMSR_FTM_RESP_ATTR_DIST_VARIANCE = 17,
	NL80211_PMSR_FTM_RESP_ATTR_DIST_SPREAD = 18,
	NL80211_PMSR_FTM_RESP_ATTR_LCI = 19,
	NL80211_PMSR_FTM_RESP_ATTR_CIVICLOC = 20,
	NL80211_PMSR_FTM_RESP_ATTR_PAD = 21,
	NUM_NL80211_PMSR_FTM_RESP_ATTR = 22,
	NL80211_PMSR_FTM_RESP_ATTR_MAX = 21,
};

enum nl80211_peer_measurement_peer_attrs {
	__NL80211_PMSR_PEER_ATTR_INVALID = 0,
	NL80211_PMSR_PEER_ATTR_ADDR = 1,
	NL80211_PMSR_PEER_ATTR_CHAN = 2,
	NL80211_PMSR_PEER_ATTR_REQ = 3,
	NL80211_PMSR_PEER_ATTR_RESP = 4,
	NUM_NL80211_PMSR_PEER_ATTRS = 5,
	NL80211_PMSR_PEER_ATTR_MAX = 4,
};

enum nl80211_peer_measurement_req {
	__NL80211_PMSR_REQ_ATTR_INVALID = 0,
	NL80211_PMSR_REQ_ATTR_DATA = 1,
	NL80211_PMSR_REQ_ATTR_GET_AP_TSF = 2,
	NUM_NL80211_PMSR_REQ_ATTRS = 3,
	NL80211_PMSR_REQ_ATTR_MAX = 2,
};

enum nl80211_peer_measurement_resp {
	__NL80211_PMSR_RESP_ATTR_INVALID = 0,
	NL80211_PMSR_RESP_ATTR_DATA = 1,
	NL80211_PMSR_RESP_ATTR_STATUS = 2,
	NL80211_PMSR_RESP_ATTR_HOST_TIME = 3,
	NL80211_PMSR_RESP_ATTR_AP_TSF = 4,
	NL80211_PMSR_RESP_ATTR_FINAL = 5,
	NL80211_PMSR_RESP_ATTR_PAD = 6,
	NUM_NL80211_PMSR_RESP_ATTRS = 7,
	NL80211_PMSR_RESP_ATTR_MAX = 6,
};

enum nl80211_peer_measurement_status {
	NL80211_PMSR_STATUS_SUCCESS = 0,
	NL80211_PMSR_STATUS_REFUSED = 1,
	NL80211_PMSR_STATUS_TIMEOUT = 2,
	NL80211_PMSR_STATUS_FAILURE = 3,
};

enum nl80211_peer_measurement_type {
	NL80211_PMSR_TYPE_INVALID = 0,
	NL80211_PMSR_TYPE_FTM = 1,
	NUM_NL80211_PMSR_TYPES = 2,
	NL80211_PMSR_TYPE_MAX = 1,
};

enum nl80211_plink_action {
	NL80211_PLINK_ACTION_NO_ACTION = 0,
	NL80211_PLINK_ACTION_OPEN = 1,
	NL80211_PLINK_ACTION_BLOCK = 2,
	NUM_NL80211_PLINK_ACTIONS = 3,
};

enum nl80211_plink_state {
	NL80211_PLINK_LISTEN = 0,
	NL80211_PLINK_OPN_SNT = 1,
	NL80211_PLINK_OPN_RCVD = 2,
	NL80211_PLINK_CNF_RCVD = 3,
	NL80211_PLINK_ESTAB = 4,
	NL80211_PLINK_HOLDING = 5,
	NL80211_PLINK_BLOCKED = 6,
	NUM_NL80211_PLINK_STATES = 7,
	MAX_NL80211_PLINK_STATES = 6,
};

enum nl80211_pmksa_candidate_attr {
	__NL80211_PMKSA_CANDIDATE_INVALID = 0,
	NL80211_PMKSA_CANDIDATE_INDEX = 1,
	NL80211_PMKSA_CANDIDATE_BSSID = 2,
	NL80211_PMKSA_CANDIDATE_PREAUTH = 3,
	NUM_NL80211_PMKSA_CANDIDATE = 4,
	MAX_NL80211_PMKSA_CANDIDATE = 3,
};

enum nl80211_preamble {
	NL80211_PREAMBLE_LEGACY = 0,
	NL80211_PREAMBLE_HT = 1,
	NL80211_PREAMBLE_VHT = 2,
	NL80211_PREAMBLE_DMG = 3,
	NL80211_PREAMBLE_HE = 4,
};

enum nl80211_protocol_features {
	NL80211_PROTOCOL_FEATURE_SPLIT_WIPHY_DUMP = 1,
};

enum nl80211_ps_state {
	NL80211_PS_DISABLED = 0,
	NL80211_PS_ENABLED = 1,
};

enum nl80211_radar_event {
	NL80211_RADAR_DETECTED = 0,
	NL80211_RADAR_CAC_FINISHED = 1,
	NL80211_RADAR_CAC_ABORTED = 2,
	NL80211_RADAR_NOP_FINISHED = 3,
	NL80211_RADAR_PRE_CAC_EXPIRED = 4,
	NL80211_RADAR_CAC_STARTED = 5,
};

enum nl80211_rate_info {
	__NL80211_RATE_INFO_INVALID = 0,
	NL80211_RATE_INFO_BITRATE = 1,
	NL80211_RATE_INFO_MCS = 2,
	NL80211_RATE_INFO_40_MHZ_WIDTH = 3,
	NL80211_RATE_INFO_SHORT_GI = 4,
	NL80211_RATE_INFO_BITRATE32 = 5,
	NL80211_RATE_INFO_VHT_MCS = 6,
	NL80211_RATE_INFO_VHT_NSS = 7,
	NL80211_RATE_INFO_80_MHZ_WIDTH = 8,
	NL80211_RATE_INFO_80P80_MHZ_WIDTH = 9,
	NL80211_RATE_INFO_160_MHZ_WIDTH = 10,
	NL80211_RATE_INFO_10_MHZ_WIDTH = 11,
	NL80211_RATE_INFO_5_MHZ_WIDTH = 12,
	NL80211_RATE_INFO_HE_MCS = 13,
	NL80211_RATE_INFO_HE_NSS = 14,
	NL80211_RATE_INFO_HE_GI = 15,
	NL80211_RATE_INFO_HE_DCM = 16,
	NL80211_RATE_INFO_HE_RU_ALLOC = 17,
	NL80211_RATE_INFO_320_MHZ_WIDTH = 18,
	NL80211_RATE_INFO_EHT_MCS = 19,
	NL80211_RATE_INFO_EHT_NSS = 20,
	NL80211_RATE_INFO_EHT_GI = 21,
	NL80211_RATE_INFO_EHT_RU_ALLOC = 22,
	NL80211_RATE_INFO_S1G_MCS = 23,
	NL80211_RATE_INFO_S1G_NSS = 24,
	NL80211_RATE_INFO_1_MHZ_WIDTH = 25,
	NL80211_RATE_INFO_2_MHZ_WIDTH = 26,
	NL80211_RATE_INFO_4_MHZ_WIDTH = 27,
	NL80211_RATE_INFO_8_MHZ_WIDTH = 28,
	NL80211_RATE_INFO_16_MHZ_WIDTH = 29,
	__NL80211_RATE_INFO_AFTER_LAST = 30,
	NL80211_RATE_INFO_MAX = 29,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_reg_rule_attr {
	__NL80211_REG_RULE_ATTR_INVALID = 0,
	NL80211_ATTR_REG_RULE_FLAGS = 1,
	NL80211_ATTR_FREQ_RANGE_START = 2,
	NL80211_ATTR_FREQ_RANGE_END = 3,
	NL80211_ATTR_FREQ_RANGE_MAX_BW = 4,
	NL80211_ATTR_POWER_RULE_MAX_ANT_GAIN = 5,
	NL80211_ATTR_POWER_RULE_MAX_EIRP = 6,
	NL80211_ATTR_DFS_CAC_TIME = 7,
	NL80211_ATTR_POWER_RULE_PSD = 8,
	__NL80211_REG_RULE_ATTR_AFTER_LAST = 9,
	NL80211_REG_RULE_ATTR_MAX = 8,
};

enum nl80211_reg_rule_flags {
	NL80211_RRF_NO_OFDM = 1,
	NL80211_RRF_NO_CCK = 2,
	NL80211_RRF_NO_INDOOR = 4,
	NL80211_RRF_NO_OUTDOOR = 8,
	NL80211_RRF_DFS = 16,
	NL80211_RRF_PTP_ONLY = 32,
	NL80211_RRF_PTMP_ONLY = 64,
	NL80211_RRF_NO_IR = 128,
	__NL80211_RRF_NO_IBSS = 256,
	NL80211_RRF_AUTO_BW = 2048,
	NL80211_RRF_IR_CONCURRENT = 4096,
	NL80211_RRF_NO_HT40MINUS = 8192,
	NL80211_RRF_NO_HT40PLUS = 16384,
	NL80211_RRF_NO_80MHZ = 32768,
	NL80211_RRF_NO_160MHZ = 65536,
	NL80211_RRF_NO_HE = 131072,
	NL80211_RRF_NO_320MHZ = 262144,
	NL80211_RRF_NO_EHT = 524288,
	NL80211_RRF_PSD = 1048576,
	NL80211_RRF_DFS_CONCURRENT = 2097152,
	NL80211_RRF_NO_6GHZ_VLP_CLIENT = 4194304,
	NL80211_RRF_NO_6GHZ_AFC_CLIENT = 8388608,
	NL80211_RRF_ALLOW_6GHZ_VLP_AP = 16777216,
};

enum nl80211_reg_type {
	NL80211_REGDOM_TYPE_COUNTRY = 0,
	NL80211_REGDOM_TYPE_WORLD = 1,
	NL80211_REGDOM_TYPE_CUSTOM_WORLD = 2,
	NL80211_REGDOM_TYPE_INTERSECTION = 3,
};

enum nl80211_rekey_data {
	__NL80211_REKEY_DATA_INVALID = 0,
	NL80211_REKEY_DATA_KEK = 1,
	NL80211_REKEY_DATA_KCK = 2,
	NL80211_REKEY_DATA_REPLAY_CTR = 3,
	NL80211_REKEY_DATA_AKM = 4,
	NUM_NL80211_REKEY_DATA = 5,
	MAX_NL80211_REKEY_DATA = 4,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_attrs {
	__NL80211_SAR_ATTR_INVALID = 0,
	NL80211_SAR_ATTR_TYPE = 1,
	NL80211_SAR_ATTR_SPECS = 2,
	__NL80211_SAR_ATTR_LAST = 3,
	NL80211_SAR_ATTR_MAX = 2,
};

enum nl80211_sar_specs_attrs {
	__NL80211_SAR_ATTR_SPECS_INVALID = 0,
	NL80211_SAR_ATTR_SPECS_POWER = 1,
	NL80211_SAR_ATTR_SPECS_RANGE_INDEX = 2,
	NL80211_SAR_ATTR_SPECS_START_FREQ = 3,
	NL80211_SAR_ATTR_SPECS_END_FREQ = 4,
	__NL80211_SAR_ATTR_SPECS_LAST = 5,
	NL80211_SAR_ATTR_SPECS_MAX = 4,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_scan_flags {
	NL80211_SCAN_FLAG_LOW_PRIORITY = 1,
	NL80211_SCAN_FLAG_FLUSH = 2,
	NL80211_SCAN_FLAG_AP = 4,
	NL80211_SCAN_FLAG_RANDOM_ADDR = 8,
	NL80211_SCAN_FLAG_FILS_MAX_CHANNEL_TIME = 16,
	NL80211_SCAN_FLAG_ACCEPT_BCAST_PROBE_RESP = 32,
	NL80211_SCAN_FLAG_OCE_PROBE_REQ_HIGH_TX_RATE = 64,
	NL80211_SCAN_FLAG_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 128,
	NL80211_SCAN_FLAG_LOW_SPAN = 256,
	NL80211_SCAN_FLAG_LOW_POWER = 512,
	NL80211_SCAN_FLAG_HIGH_ACCURACY = 1024,
	NL80211_SCAN_FLAG_RANDOM_SN = 2048,
	NL80211_SCAN_FLAG_MIN_PREQ_CONTENT = 4096,
	NL80211_SCAN_FLAG_FREQ_KHZ = 8192,
	NL80211_SCAN_FLAG_COLOCATED_6GHZ = 16384,
};

enum nl80211_sched_scan_match_attr {
	__NL80211_SCHED_SCAN_MATCH_ATTR_INVALID = 0,
	NL80211_SCHED_SCAN_MATCH_ATTR_SSID = 1,
	NL80211_SCHED_SCAN_MATCH_ATTR_RSSI = 2,
	NL80211_SCHED_SCAN_MATCH_ATTR_RELATIVE_RSSI = 3,
	NL80211_SCHED_SCAN_MATCH_ATTR_RSSI_ADJUST = 4,
	NL80211_SCHED_SCAN_MATCH_ATTR_BSSID = 5,
	NL80211_SCHED_SCAN_MATCH_PER_BAND_RSSI = 6,
	__NL80211_SCHED_SCAN_MATCH_ATTR_AFTER_LAST = 7,
	NL80211_SCHED_SCAN_MATCH_ATTR_MAX = 6,
};

enum nl80211_sched_scan_plan {
	__NL80211_SCHED_SCAN_PLAN_INVALID = 0,
	NL80211_SCHED_SCAN_PLAN_INTERVAL = 1,
	NL80211_SCHED_SCAN_PLAN_ITERATIONS = 2,
	__NL80211_SCHED_SCAN_PLAN_AFTER_LAST = 3,
	NL80211_SCHED_SCAN_PLAN_MAX = 2,
};

enum nl80211_smps_mode {
	NL80211_SMPS_OFF = 0,
	NL80211_SMPS_STATIC = 1,
	NL80211_SMPS_DYNAMIC = 2,
	__NL80211_SMPS_AFTER_LAST = 3,
	NL80211_SMPS_MAX = 2,
};

enum nl80211_sta_bss_param {
	__NL80211_STA_BSS_PARAM_INVALID = 0,
	NL80211_STA_BSS_PARAM_CTS_PROT = 1,
	NL80211_STA_BSS_PARAM_SHORT_PREAMBLE = 2,
	NL80211_STA_BSS_PARAM_SHORT_SLOT_TIME = 3,
	NL80211_STA_BSS_PARAM_DTIM_PERIOD = 4,
	NL80211_STA_BSS_PARAM_BEACON_INTERVAL = 5,
	__NL80211_STA_BSS_PARAM_AFTER_LAST = 6,
	NL80211_STA_BSS_PARAM_MAX = 5,
};

enum nl80211_sta_flags {
	__NL80211_STA_FLAG_INVALID = 0,
	NL80211_STA_FLAG_AUTHORIZED = 1,
	NL80211_STA_FLAG_SHORT_PREAMBLE = 2,
	NL80211_STA_FLAG_WME = 3,
	NL80211_STA_FLAG_MFP = 4,
	NL80211_STA_FLAG_AUTHENTICATED = 5,
	NL80211_STA_FLAG_TDLS_PEER = 6,
	NL80211_STA_FLAG_ASSOCIATED = 7,
	NL80211_STA_FLAG_SPP_AMSDU = 8,
	__NL80211_STA_FLAG_AFTER_LAST = 9,
	NL80211_STA_FLAG_MAX = 8,
};

enum nl80211_sta_info {
	__NL80211_STA_INFO_INVALID = 0,
	NL80211_STA_INFO_INACTIVE_TIME = 1,
	NL80211_STA_INFO_RX_BYTES = 2,
	NL80211_STA_INFO_TX_BYTES = 3,
	NL80211_STA_INFO_LLID = 4,
	NL80211_STA_INFO_PLID = 5,
	NL80211_STA_INFO_PLINK_STATE = 6,
	NL80211_STA_INFO_SIGNAL = 7,
	NL80211_STA_INFO_TX_BITRATE = 8,
	NL80211_STA_INFO_RX_PACKETS = 9,
	NL80211_STA_INFO_TX_PACKETS = 10,
	NL80211_STA_INFO_TX_RETRIES = 11,
	NL80211_STA_INFO_TX_FAILED = 12,
	NL80211_STA_INFO_SIGNAL_AVG = 13,
	NL80211_STA_INFO_RX_BITRATE = 14,
	NL80211_STA_INFO_BSS_PARAM = 15,
	NL80211_STA_INFO_CONNECTED_TIME = 16,
	NL80211_STA_INFO_STA_FLAGS = 17,
	NL80211_STA_INFO_BEACON_LOSS = 18,
	NL80211_STA_INFO_T_OFFSET = 19,
	NL80211_STA_INFO_LOCAL_PM = 20,
	NL80211_STA_INFO_PEER_PM = 21,
	NL80211_STA_INFO_NONPEER_PM = 22,
	NL80211_STA_INFO_RX_BYTES64 = 23,
	NL80211_STA_INFO_TX_BYTES64 = 24,
	NL80211_STA_INFO_CHAIN_SIGNAL = 25,
	NL80211_STA_INFO_CHAIN_SIGNAL_AVG = 26,
	NL80211_STA_INFO_EXPECTED_THROUGHPUT = 27,
	NL80211_STA_INFO_RX_DROP_MISC = 28,
	NL80211_STA_INFO_BEACON_RX = 29,
	NL80211_STA_INFO_BEACON_SIGNAL_AVG = 30,
	NL80211_STA_INFO_TID_STATS = 31,
	NL80211_STA_INFO_RX_DURATION = 32,
	NL80211_STA_INFO_PAD = 33,
	NL80211_STA_INFO_ACK_SIGNAL = 34,
	NL80211_STA_INFO_ACK_SIGNAL_AVG = 35,
	NL80211_STA_INFO_RX_MPDUS = 36,
	NL80211_STA_INFO_FCS_ERROR_COUNT = 37,
	NL80211_STA_INFO_CONNECTED_TO_GATE = 38,
	NL80211_STA_INFO_TX_DURATION = 39,
	NL80211_STA_INFO_AIRTIME_WEIGHT = 40,
	NL80211_STA_INFO_AIRTIME_LINK_METRIC = 41,
	NL80211_STA_INFO_ASSOC_AT_BOOTTIME = 42,
	NL80211_STA_INFO_CONNECTED_TO_AS = 43,
	__NL80211_STA_INFO_AFTER_LAST = 44,
	NL80211_STA_INFO_MAX = 43,
};

enum nl80211_sta_wme_attr {
	__NL80211_STA_WME_INVALID = 0,
	NL80211_STA_WME_UAPSD_QUEUES = 1,
	NL80211_STA_WME_MAX_SP = 2,
	__NL80211_STA_WME_AFTER_LAST = 3,
	NL80211_STA_WME_MAX = 2,
};

enum nl80211_survey_info {
	__NL80211_SURVEY_INFO_INVALID = 0,
	NL80211_SURVEY_INFO_FREQUENCY = 1,
	NL80211_SURVEY_INFO_NOISE = 2,
	NL80211_SURVEY_INFO_IN_USE = 3,
	NL80211_SURVEY_INFO_TIME = 4,
	NL80211_SURVEY_INFO_TIME_BUSY = 5,
	NL80211_SURVEY_INFO_TIME_EXT_BUSY = 6,
	NL80211_SURVEY_INFO_TIME_RX = 7,
	NL80211_SURVEY_INFO_TIME_TX = 8,
	NL80211_SURVEY_INFO_TIME_SCAN = 9,
	NL80211_SURVEY_INFO_PAD = 10,
	NL80211_SURVEY_INFO_TIME_BSS_RX = 11,
	NL80211_SURVEY_INFO_FREQUENCY_OFFSET = 12,
	__NL80211_SURVEY_INFO_AFTER_LAST = 13,
	NL80211_SURVEY_INFO_MAX = 12,
};

enum nl80211_tdls_operation {
	NL80211_TDLS_DISCOVERY_REQ = 0,
	NL80211_TDLS_SETUP = 1,
	NL80211_TDLS_TEARDOWN = 2,
	NL80211_TDLS_ENABLE_LINK = 3,
	NL80211_TDLS_DISABLE_LINK = 4,
};

enum nl80211_tid_config {
	NL80211_TID_CONFIG_ENABLE = 0,
	NL80211_TID_CONFIG_DISABLE = 1,
};

enum nl80211_tid_config_attr {
	__NL80211_TID_CONFIG_ATTR_INVALID = 0,
	NL80211_TID_CONFIG_ATTR_PAD = 1,
	NL80211_TID_CONFIG_ATTR_VIF_SUPP = 2,
	NL80211_TID_CONFIG_ATTR_PEER_SUPP = 3,
	NL80211_TID_CONFIG_ATTR_OVERRIDE = 4,
	NL80211_TID_CONFIG_ATTR_TIDS = 5,
	NL80211_TID_CONFIG_ATTR_NOACK = 6,
	NL80211_TID_CONFIG_ATTR_RETRY_SHORT = 7,
	NL80211_TID_CONFIG_ATTR_RETRY_LONG = 8,
	NL80211_TID_CONFIG_ATTR_AMPDU_CTRL = 9,
	NL80211_TID_CONFIG_ATTR_RTSCTS_CTRL = 10,
	NL80211_TID_CONFIG_ATTR_AMSDU_CTRL = 11,
	NL80211_TID_CONFIG_ATTR_TX_RATE_TYPE = 12,
	NL80211_TID_CONFIG_ATTR_TX_RATE = 13,
	__NL80211_TID_CONFIG_ATTR_AFTER_LAST = 14,
	NL80211_TID_CONFIG_ATTR_MAX = 13,
};

enum nl80211_tid_stats {
	__NL80211_TID_STATS_INVALID = 0,
	NL80211_TID_STATS_RX_MSDU = 1,
	NL80211_TID_STATS_TX_MSDU = 2,
	NL80211_TID_STATS_TX_MSDU_RETRIES = 3,
	NL80211_TID_STATS_TX_MSDU_FAILED = 4,
	NL80211_TID_STATS_PAD = 5,
	NL80211_TID_STATS_TXQ_STATS = 6,
	NUM_NL80211_TID_STATS = 7,
	NL80211_TID_STATS_MAX = 6,
};

enum nl80211_timeout_reason {
	NL80211_TIMEOUT_UNSPECIFIED = 0,
	NL80211_TIMEOUT_SCAN = 1,
	NL80211_TIMEOUT_AUTH = 2,
	NL80211_TIMEOUT_ASSOC = 3,
};

enum nl80211_tx_power_setting {
	NL80211_TX_POWER_AUTOMATIC = 0,
	NL80211_TX_POWER_LIMITED = 1,
	NL80211_TX_POWER_FIXED = 2,
};

enum nl80211_tx_rate_attributes {
	__NL80211_TXRATE_INVALID = 0,
	NL80211_TXRATE_LEGACY = 1,
	NL80211_TXRATE_HT = 2,
	NL80211_TXRATE_VHT = 3,
	NL80211_TXRATE_GI = 4,
	NL80211_TXRATE_HE = 5,
	NL80211_TXRATE_HE_GI = 6,
	NL80211_TXRATE_HE_LTF = 7,
	__NL80211_TXRATE_AFTER_LAST = 8,
	NL80211_TXRATE_MAX = 7,
};

enum nl80211_tx_rate_setting {
	NL80211_TX_RATE_AUTOMATIC = 0,
	NL80211_TX_RATE_LIMITED = 1,
	NL80211_TX_RATE_FIXED = 2,
};

enum nl80211_txq_attr {
	__NL80211_TXQ_ATTR_INVALID = 0,
	NL80211_TXQ_ATTR_AC = 1,
	NL80211_TXQ_ATTR_TXOP = 2,
	NL80211_TXQ_ATTR_CWMIN = 3,
	NL80211_TXQ_ATTR_CWMAX = 4,
	NL80211_TXQ_ATTR_AIFS = 5,
	__NL80211_TXQ_ATTR_AFTER_LAST = 6,
	NL80211_TXQ_ATTR_MAX = 5,
};

enum nl80211_txq_stats {
	__NL80211_TXQ_STATS_INVALID = 0,
	NL80211_TXQ_STATS_BACKLOG_BYTES = 1,
	NL80211_TXQ_STATS_BACKLOG_PACKETS = 2,
	NL80211_TXQ_STATS_FLOWS = 3,
	NL80211_TXQ_STATS_DROPS = 4,
	NL80211_TXQ_STATS_ECN_MARKS = 5,
	NL80211_TXQ_STATS_OVERLIMIT = 6,
	NL80211_TXQ_STATS_OVERMEMORY = 7,
	NL80211_TXQ_STATS_COLLISIONS = 8,
	NL80211_TXQ_STATS_TX_BYTES = 9,
	NL80211_TXQ_STATS_TX_PACKETS = 10,
	NL80211_TXQ_STATS_MAX_FLOWS = 11,
	NUM_NL80211_TXQ_STATS = 12,
	NL80211_TXQ_STATS_MAX = 11,
};

enum nl80211_txrate_gi {
	NL80211_TXRATE_DEFAULT_GI = 0,
	NL80211_TXRATE_FORCE_SGI = 1,
	NL80211_TXRATE_FORCE_LGI = 2,
};

enum nl80211_unsol_bcast_probe_resp_attributes {
	__NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INVALID = 0,
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_INT = 1,
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_TMPL = 2,
	__NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_LAST = 3,
	NL80211_UNSOL_BCAST_PROBE_RESP_ATTR_MAX = 2,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl80211_wiphy_radio_attrs {
	__NL80211_WIPHY_RADIO_ATTR_INVALID = 0,
	NL80211_WIPHY_RADIO_ATTR_INDEX = 1,
	NL80211_WIPHY_RADIO_ATTR_FREQ_RANGE = 2,
	NL80211_WIPHY_RADIO_ATTR_INTERFACE_COMBINATION = 3,
	NL80211_WIPHY_RADIO_ATTR_ANTENNA_MASK = 4,
	__NL80211_WIPHY_RADIO_ATTR_LAST = 5,
	NL80211_WIPHY_RADIO_ATTR_MAX = 4,
};

enum nl80211_wiphy_radio_freq_range {
	__NL80211_WIPHY_RADIO_FREQ_ATTR_INVALID = 0,
	NL80211_WIPHY_RADIO_FREQ_ATTR_START = 1,
	NL80211_WIPHY_RADIO_FREQ_ATTR_END = 2,
	__NL80211_WIPHY_RADIO_FREQ_ATTR_LAST = 3,
	NL80211_WIPHY_RADIO_FREQ_ATTR_MAX = 2,
};

enum nl80211_wmm_rule {
	__NL80211_WMMR_INVALID = 0,
	NL80211_WMMR_CW_MIN = 1,
	NL80211_WMMR_CW_MAX = 2,
	NL80211_WMMR_AIFSN = 3,
	NL80211_WMMR_TXOP = 4,
	__NL80211_WMMR_LAST = 5,
	NL80211_WMMR_MAX = 4,
};

enum nl80211_wowlan_tcp_attrs {
	__NL80211_WOWLAN_TCP_INVALID = 0,
	NL80211_WOWLAN_TCP_SRC_IPV4 = 1,
	NL80211_WOWLAN_TCP_DST_IPV4 = 2,
	NL80211_WOWLAN_TCP_DST_MAC = 3,
	NL80211_WOWLAN_TCP_SRC_PORT = 4,
	NL80211_WOWLAN_TCP_DST_PORT = 5,
	NL80211_WOWLAN_TCP_DATA_PAYLOAD = 6,
	NL80211_WOWLAN_TCP_DATA_PAYLOAD_SEQ = 7,
	NL80211_WOWLAN_TCP_DATA_PAYLOAD_TOKEN = 8,
	NL80211_WOWLAN_TCP_DATA_INTERVAL = 9,
	NL80211_WOWLAN_TCP_WAKE_PAYLOAD = 10,
	NL80211_WOWLAN_TCP_WAKE_MASK = 11,
	NUM_NL80211_WOWLAN_TCP = 12,
	MAX_NL80211_WOWLAN_TCP = 11,
};

enum nl80211_wowlan_triggers {
	__NL80211_WOWLAN_TRIG_INVALID = 0,
	NL80211_WOWLAN_TRIG_ANY = 1,
	NL80211_WOWLAN_TRIG_DISCONNECT = 2,
	NL80211_WOWLAN_TRIG_MAGIC_PKT = 3,
	NL80211_WOWLAN_TRIG_PKT_PATTERN = 4,
	NL80211_WOWLAN_TRIG_GTK_REKEY_SUPPORTED = 5,
	NL80211_WOWLAN_TRIG_GTK_REKEY_FAILURE = 6,
	NL80211_WOWLAN_TRIG_EAP_IDENT_REQUEST = 7,
	NL80211_WOWLAN_TRIG_4WAY_HANDSHAKE = 8,
	NL80211_WOWLAN_TRIG_RFKILL_RELEASE = 9,
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211 = 10,
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_80211_LEN = 11,
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023 = 12,
	NL80211_WOWLAN_TRIG_WAKEUP_PKT_8023_LEN = 13,
	NL80211_WOWLAN_TRIG_TCP_CONNECTION = 14,
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_MATCH = 15,
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_CONNLOST = 16,
	NL80211_WOWLAN_TRIG_WAKEUP_TCP_NOMORETOKENS = 17,
	NL80211_WOWLAN_TRIG_NET_DETECT = 18,
	NL80211_WOWLAN_TRIG_NET_DETECT_RESULTS = 19,
	NL80211_WOWLAN_TRIG_UNPROTECTED_DEAUTH_DISASSOC = 20,
	NUM_NL80211_WOWLAN_TRIG = 21,
	MAX_NL80211_WOWLAN_TRIG = 20,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum nmi_states {
	NMI_NOT_RUNNING = 0,
	NMI_EXECUTING = 1,
	NMI_LATCHED = 2,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_SWAPCACHE = 40,
	PGDEMOTE_KSWAPD = 41,
	PGDEMOTE_DIRECT = 42,
	PGDEMOTE_KHUGEPAGED = 43,
	NR_VM_NODE_STAT_ITEMS = 44,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum nvm_offsets {
	SUBSYSTEM_ID = 10,
	HW_ADDR = 21,
	NVM_SW_SECTION = 448,
	NVM_VERSION = 0,
	RADIO_CFG = 1,
	SKU = 2,
	N_HW_ADDRS = 3,
	NVM_CHANNELS = 32,
	NVM_CHANNELS_SDP = 0,
};

enum nvm_sku_bits {
	NVM_SKU_CAP_BAND_24GHZ = 1,
	NVM_SKU_CAP_BAND_52GHZ = 2,
	NVM_SKU_CAP_11N_ENABLE = 4,
	NVM_SKU_CAP_11AC_ENABLE = 8,
	NVM_SKU_CAP_MIMO_DISABLE = 32,
};

enum nvme_admin_opcode {
	nvme_admin_delete_sq = 0,
	nvme_admin_create_sq = 1,
	nvme_admin_get_log_page = 2,
	nvme_admin_delete_cq = 4,
	nvme_admin_create_cq = 5,
	nvme_admin_identify = 6,
	nvme_admin_abort_cmd = 8,
	nvme_admin_set_features = 9,
	nvme_admin_get_features = 10,
	nvme_admin_async_event = 12,
	nvme_admin_ns_mgmt = 13,
	nvme_admin_activate_fw = 16,
	nvme_admin_download_fw = 17,
	nvme_admin_dev_self_test = 20,
	nvme_admin_ns_attach = 21,
	nvme_admin_keep_alive = 24,
	nvme_admin_directive_send = 25,
	nvme_admin_directive_recv = 26,
	nvme_admin_virtual_mgmt = 28,
	nvme_admin_nvme_mi_send = 29,
	nvme_admin_nvme_mi_recv = 30,
	nvme_admin_dbbuf = 124,
	nvme_admin_format_nvm = 128,
	nvme_admin_security_send = 129,
	nvme_admin_security_recv = 130,
	nvme_admin_sanitize_nvm = 132,
	nvme_admin_get_lba_status = 134,
	nvme_admin_vendor_start = 192,
};

enum nvme_ctrl_attr {
	NVME_CTRL_ATTR_HID_128_BIT = 1,
	NVME_CTRL_ATTR_TBKAS = 64,
	NVME_CTRL_ATTR_ELBAS = 32768,
	NVME_CTRL_ATTR_RHII = 262144,
};

enum nvme_ctrl_flags {
	NVME_CTRL_FAILFAST_EXPIRED = 0,
	NVME_CTRL_ADMIN_Q_STOPPED = 1,
	NVME_CTRL_STARTED_ONCE = 2,
	NVME_CTRL_STOPPED = 3,
	NVME_CTRL_SKIP_ID_CNS_CS = 4,
	NVME_CTRL_DIRTY_CAPABILITY = 5,
	NVME_CTRL_FROZEN = 6,
};

enum nvme_ctrl_state {
	NVME_CTRL_NEW = 0,
	NVME_CTRL_LIVE = 1,
	NVME_CTRL_RESETTING = 2,
	NVME_CTRL_CONNECTING = 3,
	NVME_CTRL_DELETING = 4,
	NVME_CTRL_DELETING_NOIO = 5,
	NVME_CTRL_DEAD = 6,
};

enum nvme_ctrl_type {
	NVME_CTRL_IO = 1,
	NVME_CTRL_DISC = 2,
	NVME_CTRL_ADMIN = 3,
};

enum nvme_dctype {
	NVME_DCTYPE_NOT_REPORTED = 0,
	NVME_DCTYPE_DDC = 1,
	NVME_DCTYPE_CDC = 2,
};

enum nvme_disposition {
	COMPLETE = 0,
	RETRY = 1,
	FAILOVER = 2,
	AUTHENTICATE = 3,
};

enum nvme_eds {
	NVME_EXTENDED_DATA_STRUCT = 1,
};

enum nvme_ns_features {
	NVME_NS_EXT_LBAS = 1,
	NVME_NS_METADATA_SUPPORTED = 2,
	NVME_NS_DEAC = 4,
};

enum nvme_opcode {
	nvme_cmd_flush = 0,
	nvme_cmd_write = 1,
	nvme_cmd_read = 2,
	nvme_cmd_write_uncor = 4,
	nvme_cmd_compare = 5,
	nvme_cmd_write_zeroes = 8,
	nvme_cmd_dsm = 9,
	nvme_cmd_verify = 12,
	nvme_cmd_resv_register = 13,
	nvme_cmd_resv_report = 14,
	nvme_cmd_resv_acquire = 17,
	nvme_cmd_resv_release = 21,
	nvme_cmd_zone_mgmt_send = 121,
	nvme_cmd_zone_mgmt_recv = 122,
	nvme_cmd_zone_append = 125,
	nvme_cmd_vendor_start = 128,
};

enum nvme_pr_acquire_action {
	NVME_PR_ACQUIRE_ACT_ACQUIRE = 0,
	NVME_PR_ACQUIRE_ACT_PREEMPT = 1,
	NVME_PR_ACQUIRE_ACT_PREEMPT_AND_ABORT = 2,
};

enum nvme_pr_change_ptpl {
	NVME_PR_CPTPL_NO_CHANGE = 0,
	NVME_PR_CPTPL_RESV = 1073741824,
	NVME_PR_CPTPL_CLEARED = -2147483648,
	NVME_PR_CPTPL_PERSIST = -1073741824,
};

enum nvme_pr_register_action {
	NVME_PR_REGISTER_ACT_REG = 0,
	NVME_PR_REGISTER_ACT_UNREG = 1,
	NVME_PR_REGISTER_ACT_REPLACE = 2,
};

enum nvme_pr_release_action {
	NVME_PR_RELEASE_ACT_RELEASE = 0,
	NVME_PR_RELEASE_ACT_CLEAR = 1,
};

enum nvme_pr_type {
	NVME_PR_WRITE_EXCLUSIVE = 1,
	NVME_PR_EXCLUSIVE_ACCESS = 2,
	NVME_PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	NVME_PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	NVME_PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	NVME_PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum nvme_quirks {
	NVME_QUIRK_STRIPE_SIZE = 1,
	NVME_QUIRK_IDENTIFY_CNS = 2,
	NVME_QUIRK_DEALLOCATE_ZEROES = 4,
	NVME_QUIRK_DELAY_BEFORE_CHK_RDY = 8,
	NVME_QUIRK_NO_APST = 16,
	NVME_QUIRK_NO_DEEPEST_PS = 32,
	NVME_QUIRK_QDEPTH_ONE = 64,
	NVME_QUIRK_MEDIUM_PRIO_SQ = 128,
	NVME_QUIRK_IGNORE_DEV_SUBNQN = 256,
	NVME_QUIRK_DISABLE_WRITE_ZEROES = 512,
	NVME_QUIRK_SIMPLE_SUSPEND = 1024,
	NVME_QUIRK_SINGLE_VECTOR = 2048,
	NVME_QUIRK_128_BYTES_SQES = 4096,
	NVME_QUIRK_SHARED_TAGS = 8192,
	NVME_QUIRK_NO_TEMP_THRESH_CHANGE = 16384,
	NVME_QUIRK_NO_NS_DESC_LIST = 32768,
	NVME_QUIRK_DMA_ADDRESS_BITS_48 = 65536,
	NVME_QUIRK_SKIP_CID_GEN = 131072,
	NVME_QUIRK_BOGUS_NID = 262144,
	NVME_QUIRK_NO_SECONDARY_TEMP_THRESH = 524288,
	NVME_QUIRK_FORCE_NO_SIMPLE_SUSPEND = 1048576,
	NVME_QUIRK_BROKEN_MSI = 2097152,
	NVME_QUIRK_DMAPOOL_ALIGN_512 = 4194304,
};

enum nvme_subsys_type {
	NVME_NQN_DISC = 1,
	NVME_NQN_NVME = 2,
	NVME_NQN_CURR = 3,
};

enum nvme_zone_mgmt_action {
	NVME_ZONE_CLOSE = 1,
	NVME_ZONE_FINISH = 2,
	NVME_ZONE_OPEN = 3,
	NVME_ZONE_RESET = 4,
	NVME_ZONE_OFFLINE = 5,
	NVME_ZONE_SET_DESC_EXT = 16,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum nvmf_capsule_command {
	nvme_fabrics_type_property_set = 0,
	nvme_fabrics_type_connect = 1,
	nvme_fabrics_type_property_get = 4,
	nvme_fabrics_type_auth_send = 5,
	nvme_fabrics_type_auth_receive = 6,
};

enum nvmf_fabrics_opcode {
	nvme_fabrics_command = 127,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum ocb_deferred_task_flags {
	OCB_WORK_HOUSEKEEPING = 0,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum page_cache_mode {
	_PAGE_CACHE_MODE_WB = 0,
	_PAGE_CACHE_MODE_WC = 1,
	_PAGE_CACHE_MODE_UC_MINUS = 2,
	_PAGE_CACHE_MODE_UC = 3,
	_PAGE_CACHE_MODE_WT = 4,
	_PAGE_CACHE_MODE_WP = 5,
	_PAGE_CACHE_MODE_NUM = 8,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_mlocked = 19,
	PG_arch_2 = 20,
	__NR_PAGEFLAGS = 21,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_bf_sort_state {
	pci_bf_sort_default = 0,
	pci_force_nobf = 1,
	pci_force_bf = 2,
	pci_dmi_bf = 3,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_irq_reroute_variant {
	INTEL_IRQ_REROUTE_VARIANT = 1,
	MAX_IRQ_REROUTE_VARIANTS = 3,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 1,
	PCI_P2PDMA_MAP_BUS_ADDR = 2,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 3,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_cstate_core_events {
	PERF_CSTATE_CORE_C1_RES = 0,
	PERF_CSTATE_CORE_C3_RES = 1,
	PERF_CSTATE_CORE_C6_RES = 2,
	PERF_CSTATE_CORE_C7_RES = 3,
	PERF_CSTATE_CORE_EVENT_MAX = 4,
};

enum perf_cstate_module_events {
	PERF_CSTATE_MODULE_C6_RES = 0,
	PERF_CSTATE_MODULE_EVENT_MAX = 1,
};

enum perf_cstate_pkg_events {
	PERF_CSTATE_PKG_C2_RES = 0,
	PERF_CSTATE_PKG_C3_RES = 1,
	PERF_CSTATE_PKG_C6_RES = 2,
	PERF_CSTATE_PKG_C7_RES = 3,
	PERF_CSTATE_PKG_C8_RES = 4,
	PERF_CSTATE_PKG_C9_RES = 5,
	PERF_CSTATE_PKG_C10_RES = 6,
	PERF_CSTATE_PKG_EVENT_MAX = 7,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_event_x86_regs {
	PERF_REG_X86_AX = 0,
	PERF_REG_X86_BX = 1,
	PERF_REG_X86_CX = 2,
	PERF_REG_X86_DX = 3,
	PERF_REG_X86_SI = 4,
	PERF_REG_X86_DI = 5,
	PERF_REG_X86_BP = 6,
	PERF_REG_X86_SP = 7,
	PERF_REG_X86_IP = 8,
	PERF_REG_X86_FLAGS = 9,
	PERF_REG_X86_CS = 10,
	PERF_REG_X86_SS = 11,
	PERF_REG_X86_DS = 12,
	PERF_REG_X86_ES = 13,
	PERF_REG_X86_FS = 14,
	PERF_REG_X86_GS = 15,
	PERF_REG_X86_R8 = 16,
	PERF_REG_X86_R9 = 17,
	PERF_REG_X86_R10 = 18,
	PERF_REG_X86_R11 = 19,
	PERF_REG_X86_R12 = 20,
	PERF_REG_X86_R13 = 21,
	PERF_REG_X86_R14 = 22,
	PERF_REG_X86_R15 = 23,
	PERF_REG_X86_32_MAX = 16,
	PERF_REG_X86_64_MAX = 24,
	PERF_REG_X86_XMM0 = 32,
	PERF_REG_X86_XMM1 = 34,
	PERF_REG_X86_XMM2 = 36,
	PERF_REG_X86_XMM3 = 38,
	PERF_REG_X86_XMM4 = 40,
	PERF_REG_X86_XMM5 = 42,
	PERF_REG_X86_XMM6 = 44,
	PERF_REG_X86_XMM7 = 46,
	PERF_REG_X86_XMM8 = 48,
	PERF_REG_X86_XMM9 = 50,
	PERF_REG_X86_XMM10 = 52,
	PERF_REG_X86_XMM11 = 54,
	PERF_REG_X86_XMM12 = 56,
	PERF_REG_X86_XMM13 = 58,
	PERF_REG_X86_XMM14 = 60,
	PERF_REG_X86_XMM15 = 62,
	PERF_REG_X86_XMM_MAX = 64,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_msr_id {
	PERF_MSR_TSC = 0,
	PERF_MSR_APERF = 1,
	PERF_MSR_MPERF = 2,
	PERF_MSR_PPERF = 3,
	PERF_MSR_SMI = 4,
	PERF_MSR_PTSC = 5,
	PERF_MSR_IRPERF = 6,
	PERF_MSR_THERM = 7,
	PERF_MSR_EVENT_MAX = 8,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_rapl_pkg_events {
	PERF_RAPL_PP0 = 0,
	PERF_RAPL_PKG = 1,
	PERF_RAPL_RAM = 2,
	PERF_RAPL_PP1 = 3,
	PERF_RAPL_PSYS = 4,
	PERF_RAPL_PKG_EVENTS_MAX = 5,
	NR_RAPL_PKG_DOMAINS = 5,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pg_level {
	PG_LEVEL_NONE = 0,
	PG_LEVEL_4K = 1,
	PG_LEVEL_2M = 2,
	PG_LEVEL_1G = 3,
	PG_LEVEL_512G = 4,
	PG_LEVEL_256T = 5,
	PG_LEVEL_NUM = 6,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy {
	phy_100a = 992,
	phy_100c = 55575208,
	phy_82555_tx = 22020776,
	phy_nsc_tx = 1543512064,
	phy_82562_et = 53478056,
	phy_82562_em = 52429480,
	phy_82562_ek = 51380904,
	phy_82562_eh = 24117928,
	phy_82552_v = 3496017997,
	phy_unknown = 4294967295,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum piix_controller_ids {
	piix_pata_mwdma = 0,
	piix_pata_33 = 1,
	ich_pata_33 = 2,
	ich_pata_66 = 3,
	ich_pata_100 = 4,
	ich_pata_100_nomwdma1 = 5,
	ich5_sata = 6,
	ich6_sata = 7,
	ich6m_sata = 8,
	ich8_sata = 9,
	ich8_2port_sata = 10,
	ich8m_apple_sata = 11,
	tolapai_sata = 12,
	piix_pata_vmw = 13,
	ich8_sata_snb = 14,
	ich8_2port_sata_snb = 15,
	ich8_2port_sata_byt = 16,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pmc_type {
	KVM_PMC_GP = 0,
	KVM_PMC_FIXED = 1,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port {
	software_reset = 0,
	selftest = 1,
	selective_reset = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 2,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_HEALTH = 2,
	POWER_SUPPLY_PROP_PRESENT = 3,
	POWER_SUPPLY_PROP_ONLINE = 4,
	POWER_SUPPLY_PROP_AUTHENTIC = 5,
	POWER_SUPPLY_PROP_TECHNOLOGY = 6,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 7,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 12,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 13,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 14,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 15,
	POWER_SUPPLY_PROP_CURRENT_MAX = 16,
	POWER_SUPPLY_PROP_CURRENT_NOW = 17,
	POWER_SUPPLY_PROP_CURRENT_AVG = 18,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 19,
	POWER_SUPPLY_PROP_POWER_NOW = 20,
	POWER_SUPPLY_PROP_POWER_AVG = 21,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 22,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_FULL = 24,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 25,
	POWER_SUPPLY_PROP_CHARGE_NOW = 26,
	POWER_SUPPLY_PROP_CHARGE_AVG = 27,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 28,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 32,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 37,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 38,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 40,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 41,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_FULL = 43,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 44,
	POWER_SUPPLY_PROP_ENERGY_NOW = 45,
	POWER_SUPPLY_PROP_ENERGY_AVG = 46,
	POWER_SUPPLY_PROP_CAPACITY = 47,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 49,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 50,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 51,
	POWER_SUPPLY_PROP_TEMP = 52,
	POWER_SUPPLY_PROP_TEMP_MAX = 53,
	POWER_SUPPLY_PROP_TEMP_MIN = 54,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 56,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 59,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 61,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 63,
	POWER_SUPPLY_PROP_TYPE = 64,
	POWER_SUPPLY_PROP_USB_TYPE = 65,
	POWER_SUPPLY_PROP_SCOPE = 66,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 67,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 68,
	POWER_SUPPLY_PROP_CALIBRATE = 69,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 72,
	POWER_SUPPLY_PROP_MODEL_NAME = 73,
	POWER_SUPPLY_PROP_MANUFACTURER = 74,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 75,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___8 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	NR_PSI_RESOURCES = 3,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_NONIDLE = 6,
	NR_PSI_STATES = 7,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum pt_capabilities {
	PT_CAP_max_subleaf = 0,
	PT_CAP_cr3_filtering = 1,
	PT_CAP_psb_cyc = 2,
	PT_CAP_ip_filtering = 3,
	PT_CAP_mtc = 4,
	PT_CAP_ptwrite = 5,
	PT_CAP_power_event_trace = 6,
	PT_CAP_event_trace = 7,
	PT_CAP_tnt_disable = 8,
	PT_CAP_topa_output = 9,
	PT_CAP_topa_multiple_entries = 10,
	PT_CAP_single_range_output = 11,
	PT_CAP_output_subsys = 12,
	PT_CAP_payloads_lip = 13,
	PT_CAP_num_address_ranges = 14,
	PT_CAP_mtc_periods = 15,
	PT_CAP_cycle_thresholds = 16,
	PT_CAP_psb_periods = 17,
};

enum pti_clone_level {
	PTI_CLONE_PMD = 0,
	PTI_CLONE_PTE = 1,
};

enum pti_mode {
	PTI_AUTO = 0,
	PTI_FORCE_OFF = 1,
	PTI_FORCE_ON = 2,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum queue_entry_flags {
	ENTRY_BCN_ASSIGNED = 0,
	ENTRY_BCN_ENABLED = 1,
	ENTRY_OWNER_DEVICE_DATA = 2,
	ENTRY_DATA_PENDING = 3,
	ENTRY_DATA_IO_FAILED = 4,
	ENTRY_DATA_STATUS_PENDING = 5,
};

enum queue_index {
	Q_INDEX = 0,
	Q_INDEX_DMA_DONE = 1,
	Q_INDEX_DONE = 2,
	Q_INDEX_MAX = 3,
};

enum queue_mode {
	QUEUE_MODE_STRICT_PRIORITY = 0,
	QUEUE_MODE_STREAM_RESERVATION = 1,
};

enum queue_stop_reason {
	IEEE80211_QUEUE_STOP_REASON_DRIVER = 0,
	IEEE80211_QUEUE_STOP_REASON_PS = 1,
	IEEE80211_QUEUE_STOP_REASON_CSA = 2,
	IEEE80211_QUEUE_STOP_REASON_AGGREGATION = 3,
	IEEE80211_QUEUE_STOP_REASON_SUSPEND = 4,
	IEEE80211_QUEUE_STOP_REASON_SKB_ADD = 5,
	IEEE80211_QUEUE_STOP_REASON_OFFCHANNEL = 6,
	IEEE80211_QUEUE_STOP_REASON_FLUSH = 7,
	IEEE80211_QUEUE_STOP_REASON_TDLS_TEARDOWN = 8,
	IEEE80211_QUEUE_STOP_REASON_RESERVE_TID = 9,
	IEEE80211_QUEUE_STOP_REASON_IFTYPE_CHANGE = 10,
	IEEE80211_QUEUE_STOP_REASONS = 11,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum r0layout {
	RAID0_ORIG_LAYOUT = 1,
	RAID0_ALT_MULTIZONE_LAYOUT = 2,
};

enum r10bio_state {
	R10BIO_Uptodate = 0,
	R10BIO_IsSync = 1,
	R10BIO_IsRecover = 2,
	R10BIO_IsReshape = 3,
	R10BIO_ReadError = 4,
	R10BIO_MadeGood = 5,
	R10BIO_WriteError = 6,
	R10BIO_Previous = 7,
	R10BIO_FailFast = 8,
	R10BIO_Discard = 9,
};

enum r1bio_state {
	R1BIO_Uptodate = 0,
	R1BIO_IsSync = 1,
	R1BIO_BehindIO = 2,
	R1BIO_ReadError = 3,
	R1BIO_Returned = 4,
	R1BIO_MadeGood = 5,
	R1BIO_WriteError = 6,
	R1BIO_FailFast = 7,
};

enum r5_cache_state {
	R5_INACTIVE_BLOCKED = 0,
	R5_ALLOC_MORE = 1,
	R5_DID_ALLOC = 2,
	R5C_LOG_TIGHT = 3,
	R5C_LOG_CRITICAL = 4,
	R5C_EXTRA_PAGE_IN_USE = 5,
};

enum r5c_journal_mode {
	R5C_JOURNAL_MODE_WRITE_THROUGH = 0,
	R5C_JOURNAL_MODE_WRITE_BACK = 1,
};

enum r5dev_flags {
	R5_UPTODATE = 0,
	R5_LOCKED = 1,
	R5_DOUBLE_LOCKED = 2,
	R5_OVERWRITE = 3,
	R5_Insync = 4,
	R5_Wantread = 5,
	R5_Wantwrite = 6,
	R5_Overlap = 7,
	R5_ReadNoMerge = 8,
	R5_ReadError = 9,
	R5_ReWrite = 10,
	R5_Expanded = 11,
	R5_Wantcompute = 12,
	R5_Wantfill = 13,
	R5_Wantdrain = 14,
	R5_WantFUA = 15,
	R5_SyncIO = 16,
	R5_WriteError = 17,
	R5_MadeGood = 18,
	R5_ReadRepl = 19,
	R5_MadeGoodRepl = 20,
	R5_NeedReplace = 21,
	R5_WantReplace = 22,
	R5_Discard = 23,
	R5_SkipCopy = 24,
	R5_InJournal = 25,
	R5_OrigPageUPTDODATE = 26,
};

enum r5l_io_unit_state {
	IO_UNIT_RUNNING = 0,
	IO_UNIT_IO_START = 1,
	IO_UNIT_IO_END = 2,
	IO_UNIT_STRIPE_END = 3,
};

enum r5l_payload_type {
	R5LOG_PAYLOAD_DATA = 0,
	R5LOG_PAYLOAD_PARITY = 1,
	R5LOG_PAYLOAD_FLUSH = 2,
};

enum ramfs_param {
	Opt_mode___5 = 0,
};

enum rapl_unit_quirk {
	RAPL_UNIT_QUIRK_NONE = 0,
	RAPL_UNIT_QUIRK_INTEL_HSW = 1,
	RAPL_UNIT_QUIRK_INTEL_SPR = 2,
};

enum rate_control_capabilities {
	RATE_CTRL_CAPA_VHT_EXT_NSS_BW = 1,
	RATE_CTRL_CAPA_AMPDU_TRIGGER = 2,
};

enum rate_info_bw {
	RATE_INFO_BW_20 = 0,
	RATE_INFO_BW_5 = 1,
	RATE_INFO_BW_10 = 2,
	RATE_INFO_BW_40 = 3,
	RATE_INFO_BW_80 = 4,
	RATE_INFO_BW_160 = 5,
	RATE_INFO_BW_HE_RU = 6,
	RATE_INFO_BW_320 = 7,
	RATE_INFO_BW_EHT_RU = 8,
	RATE_INFO_BW_1 = 9,
	RATE_INFO_BW_2 = 10,
	RATE_INFO_BW_4 = 11,
	RATE_INFO_BW_8 = 12,
	RATE_INFO_BW_16 = 13,
};

enum rate_info_flags {
	RATE_INFO_FLAGS_MCS = 1,
	RATE_INFO_FLAGS_VHT_MCS = 2,
	RATE_INFO_FLAGS_SHORT_GI = 4,
	RATE_INFO_FLAGS_DMG = 8,
	RATE_INFO_FLAGS_HE_MCS = 16,
	RATE_INFO_FLAGS_EDMG = 32,
	RATE_INFO_FLAGS_EXTENDED_SC_DMG = 64,
	RATE_INFO_FLAGS_EHT_MCS = 128,
	RATE_INFO_FLAGS_S1G_MCS = 256,
};

enum rate_modulation {
	RATE_MODE_CCK = 0,
	RATE_MODE_OFDM = 1,
	RATE_MODE_HT_MIX = 2,
	RATE_MODE_HT_GREENFIELD = 3,
};

enum rc5_state {
	STATE_INACTIVE___4 = 0,
	STATE_BIT_START = 1,
	STATE_BIT_END = 2,
	STATE_CHECK_RC5X = 3,
	STATE_FINISHED___2 = 4,
};

enum rc6_mode {
	RC6_MODE_0 = 0,
	RC6_MODE_6A = 1,
	RC6_MODE_UNKNOWN = 2,
};

enum rc6_state {
	STATE_INACTIVE___5 = 0,
	STATE_PREFIX_SPACE = 1,
	STATE_HEADER_BIT_START___2 = 2,
	STATE_HEADER_BIT_END___2 = 3,
	STATE_TOGGLE_START = 4,
	STATE_TOGGLE_END = 5,
	STATE_BODY_BIT_START___2 = 6,
	STATE_BODY_BIT_END___2 = 7,
	STATE_FINISHED___3 = 8,
};

enum rc_driver_type {
	RC_DRIVER_SCANCODE = 0,
	RC_DRIVER_IR_RAW = 1,
	RC_DRIVER_IR_RAW_TX = 2,
};

enum rc_filter_type {
	RC_FILTER_NORMAL = 0,
	RC_FILTER_WAKEUP = 1,
	RC_FILTER_MAX = 2,
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum reconstruct_states {
	reconstruct_state_idle = 0,
	reconstruct_state_prexor_drain_run = 1,
	reconstruct_state_drain_run = 2,
	reconstruct_state_run = 3,
	reconstruct_state_prexor_drain_result = 4,
	reconstruct_state_drain_result = 5,
	reconstruct_state_result = 6,
};

enum recovery_flags {
	MD_RECOVERY_NEEDED = 0,
	MD_RECOVERY_RUNNING = 1,
	MD_RECOVERY_INTR = 2,
	MD_RECOVERY_DONE = 3,
	MD_RECOVERY_FROZEN = 4,
	MD_RECOVERY_WAIT = 5,
	MD_RECOVERY_ERROR = 6,
	MD_RECOVERY_SYNC = 7,
	MD_RECOVERY_REQUESTED = 8,
	MD_RECOVERY_CHECK = 9,
	MD_RECOVERY_RECOVER = 10,
	MD_RECOVERY_RESHAPE = 11,
	MD_RESYNCING_REMOTE = 12,
};

enum ref_state_type {
	REF_TYPE_PTR = 1,
	REF_TYPE_IRQ = 2,
	REF_TYPE_LOCK = 3,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum reg_request_treatment {
	REG_REQ_OK = 0,
	REG_REQ_IGNORE = 1,
	REG_REQ_INTERSECT = 2,
	REG_REQ_ALREADY_SET = 3,
};

enum reg_type {
	REG_TYPE_RM = 0,
	REG_TYPE_REG = 1,
	REG_TYPE_INDEX = 2,
	REG_TYPE_BASE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum reloc_stage {
	MOVE_DATA_EXTENTS = 0,
	UPDATE_DATA_PTRS = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum reshape_loc {
	LOC_NO_RESHAPE = 0,
	LOC_AHEAD_OF_RESHAPE = 1,
	LOC_INSIDE_RESHAPE = 2,
	LOC_BEHIND_RESHAPE = 3,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum retbleed_mitigation {
	RETBLEED_MITIGATION_NONE = 0,
	RETBLEED_MITIGATION_UNRET = 1,
	RETBLEED_MITIGATION_IBPB = 2,
	RETBLEED_MITIGATION_IBRS = 3,
	RETBLEED_MITIGATION_EIBRS = 4,
	RETBLEED_MITIGATION_STUFF = 5,
};

enum retbleed_mitigation_cmd {
	RETBLEED_CMD_OFF = 0,
	RETBLEED_CMD_AUTO = 1,
	RETBLEED_CMD_UNRET = 2,
	RETBLEED_CMD_IBPB = 3,
	RETBLEED_CMD_STUFF = 4,
};

enum rfds_mitigations {
	RFDS_MITIGATION_OFF = 0,
	RFDS_MITIGATION_VERW = 1,
	RFDS_MITIGATION_UCODE_NEEDED = 2,
};

enum rfkill_hard_block_reasons {
	RFKILL_HARD_BLOCK_SIGNAL = 1,
	RFKILL_HARD_BLOCK_NOT_OWNER = 2,
};

enum rfkill_type {
	RFKILL_TYPE_ALL = 0,
	RFKILL_TYPE_WLAN = 1,
	RFKILL_TYPE_BLUETOOTH = 2,
	RFKILL_TYPE_UWB = 3,
	RFKILL_TYPE_WIMAX = 4,
	RFKILL_TYPE_WWAN = 5,
	RFKILL_TYPE_GPS = 6,
	RFKILL_TYPE_FM = 7,
	RFKILL_TYPE_NFC = 8,
	NUM_RFKILL_TYPES = 9,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rs_action {
	RS_ACTION_STAY = 0,
	RS_ACTION_DOWNSCALE = -1,
	RS_ACTION_UPSCALE = 1,
};

enum rs_column {
	RS_COLUMN_LEGACY_ANT_A = 0,
	RS_COLUMN_LEGACY_ANT_B = 1,
	RS_COLUMN_SISO_ANT_A = 2,
	RS_COLUMN_SISO_ANT_B = 3,
	RS_COLUMN_SISO_ANT_A_SGI = 4,
	RS_COLUMN_SISO_ANT_B_SGI = 5,
	RS_COLUMN_MIMO2 = 6,
	RS_COLUMN_MIMO2_SGI = 7,
	RS_COLUMN_LAST = 7,
	RS_COLUMN_COUNT = 8,
	RS_COLUMN_INVALID = 9,
};

enum rs_column_mode {
	RS_INVALID = 0,
	RS_LEGACY = 1,
	RS_SISO = 2,
	RS_MIMO2 = 3,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt2800_eeprom_word {
	EEPROM_CHIP_ID = 0,
	EEPROM_VERSION = 1,
	EEPROM_MAC_ADDR_0 = 2,
	EEPROM_MAC_ADDR_1 = 3,
	EEPROM_MAC_ADDR_2 = 4,
	EEPROM_NIC_CONF0 = 5,
	EEPROM_NIC_CONF1 = 6,
	EEPROM_FREQ = 7,
	EEPROM_LED_AG_CONF = 8,
	EEPROM_LED_ACT_CONF = 9,
	EEPROM_LED_POLARITY = 10,
	EEPROM_NIC_CONF2 = 11,
	EEPROM_LNA = 12,
	EEPROM_RSSI_BG = 13,
	EEPROM_RSSI_BG2 = 14,
	EEPROM_TXMIXER_GAIN_BG = 15,
	EEPROM_RSSI_A = 16,
	EEPROM_RSSI_A2 = 17,
	EEPROM_TXMIXER_GAIN_A = 18,
	EEPROM_EIRP_MAX_TX_POWER = 19,
	EEPROM_TXPOWER_DELTA = 20,
	EEPROM_TXPOWER_BG1 = 21,
	EEPROM_TXPOWER_BG2 = 22,
	EEPROM_TSSI_BOUND_BG1 = 23,
	EEPROM_TSSI_BOUND_BG2 = 24,
	EEPROM_TSSI_BOUND_BG3 = 25,
	EEPROM_TSSI_BOUND_BG4 = 26,
	EEPROM_TSSI_BOUND_BG5 = 27,
	EEPROM_TXPOWER_A1 = 28,
	EEPROM_TXPOWER_A2 = 29,
	EEPROM_TXPOWER_INIT = 30,
	EEPROM_TSSI_BOUND_A1 = 31,
	EEPROM_TSSI_BOUND_A2 = 32,
	EEPROM_TSSI_BOUND_A3 = 33,
	EEPROM_TSSI_BOUND_A4 = 34,
	EEPROM_TSSI_BOUND_A5 = 35,
	EEPROM_TXPOWER_BYRATE = 36,
	EEPROM_BBP_START = 37,
	EEPROM_EXT_LNA2 = 38,
	EEPROM_EXT_TXPOWER_BG3 = 39,
	EEPROM_EXT_TXPOWER_A3 = 40,
	EEPROM_WORD_COUNT = 41,
};

enum rt2x00_capability_flags {
	REQUIRE_FIRMWARE = 0,
	REQUIRE_BEACON_GUARD = 1,
	REQUIRE_ATIM_QUEUE = 2,
	REQUIRE_DMA = 3,
	REQUIRE_COPY_IV = 4,
	REQUIRE_L2PAD = 5,
	REQUIRE_TXSTATUS_FIFO = 6,
	REQUIRE_TASKLET_CONTEXT = 7,
	REQUIRE_SW_SEQNO = 8,
	REQUIRE_HT_TX_DESC = 9,
	REQUIRE_PS_AUTOWAKE = 10,
	REQUIRE_DELAYED_RFKILL = 11,
	CAPABILITY_HW_BUTTON = 12,
	CAPABILITY_HW_CRYPTO = 13,
	CAPABILITY_POWER_LIMIT = 14,
	CAPABILITY_CONTROL_FILTERS = 15,
	CAPABILITY_CONTROL_FILTER_PSPOLL = 16,
	CAPABILITY_PRE_TBTT_INTERRUPT = 17,
	CAPABILITY_LINK_TUNING = 18,
	CAPABILITY_FRAME_TYPE = 19,
	CAPABILITY_RF_SEQUENCE = 20,
	CAPABILITY_EXTERNAL_LNA_A = 21,
	CAPABILITY_EXTERNAL_LNA_BG = 22,
	CAPABILITY_DOUBLE_ANTENNA = 23,
	CAPABILITY_BT_COEXIST = 24,
	CAPABILITY_VCO_RECALIBRATION = 25,
	CAPABILITY_EXTERNAL_PA_TX0 = 26,
	CAPABILITY_EXTERNAL_PA_TX1 = 27,
	CAPABILITY_RESTART_HW = 28,
};

enum rt2x00_chip_intf {
	RT2X00_CHIP_INTF_PCI = 0,
	RT2X00_CHIP_INTF_PCIE = 1,
	RT2X00_CHIP_INTF_USB = 2,
	RT2X00_CHIP_INTF_SOC = 3,
};

enum rt2x00_delayed_flags {
	DELAYED_UPDATE_BEACON = 0,
};

enum rt2x00_dump_type {
	DUMP_FRAME_RXDONE = 1,
	DUMP_FRAME_TX = 2,
	DUMP_FRAME_TXDONE = 3,
	DUMP_FRAME_BEACON = 4,
};

enum rt2x00_state_flags {
	DEVICE_STATE_PRESENT = 0,
	DEVICE_STATE_REGISTERED_HW = 1,
	DEVICE_STATE_INITIALIZED = 2,
	DEVICE_STATE_STARTED = 3,
	DEVICE_STATE_ENABLED_RADIO = 4,
	DEVICE_STATE_SCANNING = 5,
	DEVICE_STATE_FLUSHING = 6,
	DEVICE_STATE_RESET = 7,
	CONFIG_CHANNEL_HT40 = 8,
	CONFIG_POWERSAVING = 9,
	CONFIG_HT_DISABLED = 10,
	CONFIG_MONITORING = 11,
	TX_STATUS_READING = 12,
};

enum rt2x00usb_mode_offset {
	USB_MODE_RESET = 1,
	USB_MODE_UNPLUG = 2,
	USB_MODE_FUNCTION = 3,
	USB_MODE_TEST = 4,
	USB_MODE_SLEEP = 7,
	USB_MODE_FIRMWARE = 8,
	USB_MODE_WAKEUP = 9,
	USB_MODE_AUTORUN = 17,
};

enum rt2x00usb_vendor_request {
	USB_DEVICE_MODE = 1,
	USB_SINGLE_WRITE = 2,
	USB_SINGLE_READ = 3,
	USB_MULTI_WRITE = 6,
	USB_MULTI_READ = 7,
	USB_EEPROM_WRITE = 8,
	USB_EEPROM_READ = 9,
	USB_LED_CONTROL = 10,
	USB_RX_CONTROL = 12,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtl8125_registers {
	LEDSEL0 = 24,
	INT_CFG0_8125 = 52,
	IntrMask_8125 = 56,
	IntrStatus_8125 = 60,
	INT_CFG1_8125 = 122,
	LEDSEL2 = 132,
	LEDSEL1 = 134,
	TxPoll_8125 = 144,
	LEDSEL3 = 150,
	MAC0_BKP = 6624,
	RSS_CTRL_8125 = 17664,
	Q_NUM_CTRL_8125 = 18432,
	EEE_TXIDLE_TIMER_8125 = 24648,
};

enum rtl8152_flags {
	RTL8152_INACCESSIBLE = 0,
	RTL8152_SET_RX_MODE = 1,
	WORK_ENABLE = 2,
	RTL8152_LINK_CHG = 3,
	SELECTIVE_SUSPEND = 4,
	PHY_RESET = 5,
	SCHEDULE_TASKLET = 6,
	GREEN_ETHERNET = 7,
	RX_EPROTO = 8,
	IN_PRE_RESET = 9,
	PROBED_WITH_NO_ERRORS = 10,
	PROBE_SHOULD_RETRY = 11,
};

enum rtl8152_fw_fixup_cmd {
	FW_FIXUP_AND = 0,
	FW_FIXUP_OR = 1,
	FW_FIXUP_NOT = 2,
	FW_FIXUP_XOR = 3,
};

enum rtl8152_fw_flags {
	FW_FLAGS_USB = 0,
	FW_FLAGS_PLA = 1,
	FW_FLAGS_START = 2,
	FW_FLAGS_STOP = 3,
	FW_FLAGS_NC = 4,
	FW_FLAGS_NC1 = 5,
	FW_FLAGS_NC2 = 6,
	FW_FLAGS_UC2 = 7,
	FW_FLAGS_UC = 8,
	FW_FLAGS_SPEED_UP = 9,
	FW_FLAGS_VER = 10,
};

enum rtl8168_8101_registers {
	CSIDR = 100,
	CSIAR = 104,
	PMCH = 111,
	EPHYAR = 128,
	DLLPR = 208,
	DBG_REG = 209,
	TWSI = 210,
	MCU = 211,
	EFUSEAR = 220,
	MISC_1 = 242,
};

enum rtl8168_registers {
	LED_CTRL = 24,
	LED_FREQ = 26,
	EEE_LED = 27,
	ERIDR = 112,
	ERIAR = 116,
	EPHY_RXER_NUM = 124,
	OCPDR = 176,
	OCPAR = 180,
	GPHY_OCP = 184,
	RDSAR1 = 208,
	MISC = 240,
};

enum rtl_dash_type {
	RTL_DASH_NONE = 0,
	RTL_DASH_DP = 1,
	RTL_DASH_EP = 2,
	RTL_DASH_25_BP = 3,
};

enum rtl_desc_bit {
	DescOwn = -2147483648,
	RingEnd = 1073741824,
	FirstFrag = 536870912,
	LastFrag = 268435456,
};

enum rtl_flag {
	RTL_FLAG_TASK_RESET_PENDING = 0,
	RTL_FLAG_TASK_TX_TIMEOUT = 1,
	RTL_FLAG_MAX = 2,
};

enum rtl_fw_opcode {
	PHY_READ = 0,
	PHY_DATA_OR = 1,
	PHY_DATA_AND = 2,
	PHY_BJMPN = 3,
	PHY_MDIO_CHG = 4,
	PHY_CLEAR_READCOUNT = 7,
	PHY_WRITE = 8,
	PHY_READCOUNT_EQ_SKIP = 9,
	PHY_COMP_EQ_SKIPN = 10,
	PHY_COMP_NEQ_SKIPN = 11,
	PHY_WRITE_PREVIOUS = 12,
	PHY_SKIPN = 13,
	PHY_DELAY_MS = 14,
};

enum rtl_fw_type {
	RTL_FW_END = 0,
	RTL_FW_PLA = 1,
	RTL_FW_USB = 2,
	RTL_FW_PHY_START = 3,
	RTL_FW_PHY_STOP = 4,
	RTL_FW_PHY_NC = 5,
	RTL_FW_PHY_FIXUP = 6,
	RTL_FW_PHY_UNION_NC = 7,
	RTL_FW_PHY_UNION_NC1 = 8,
	RTL_FW_PHY_UNION_NC2 = 9,
	RTL_FW_PHY_UNION_UC2 = 10,
	RTL_FW_PHY_UNION_UC = 11,
	RTL_FW_PHY_UNION_MISC = 12,
	RTL_FW_PHY_SPEED_UP = 13,
	RTL_FW_PHY_VER = 14,
};

enum rtl_register_content {
	_2500bps = 1024,
	_1250bps = 512,
	_500bps = 256,
	_tx_flow = 64,
	_rx_flow = 32,
	_1000bps = 16,
	_100bps = 8,
	_10bps = 4,
	LINK_STATUS = 2,
	FULL_DUP = 1,
};

enum rtl_register_content___2 {
	SYSErr = 32768,
	PCSTimeout = 16384,
	SWInt = 256,
	TxDescUnavail = 128,
	RxFIFOOver = 64,
	LinkChg = 32,
	RxOverflow = 16,
	TxErr = 8,
	TxOK = 4,
	RxErr = 2,
	RxOK = 1,
	RxRWT = 4194304,
	RxRES = 2097152,
	RxRUNT = 1048576,
	RxCRC = 524288,
	StopReq = 128,
	CmdReset = 16,
	CmdRxEnb = 8,
	CmdTxEnb = 4,
	RxBufEmpty = 1,
	HPQ = 128,
	NPQ = 64,
	FSWInt = 1,
	Cfg9346_Lock = 0,
	Cfg9346_Unlock = 192,
	AcceptErr = 32,
	AcceptRunt = 16,
	AcceptBroadcast = 8,
	AcceptMulticast = 4,
	AcceptMyPhys = 2,
	AcceptAllPhys = 1,
	TxInterFrameGapShift = 24,
	TxDMAShift = 8,
	LEDS1 = 128,
	LEDS0 = 64,
	Speed_down = 16,
	MEMMAP = 8,
	IOMAP = 4,
	VPD = 2,
	PMEnable = 1,
	ClkReqEn = 128,
	MSIEnable = 32,
	PCI_Clock_66MHz = 1,
	PCI_Clock_33MHz = 0,
	MagicPacket = 32,
	LinkUp = 16,
	Jumbo_En0 = 4,
	Rdy_to_L23 = 2,
	Beacon_en = 1,
	Jumbo_En1 = 2,
	BWF = 64,
	MWF = 32,
	UWF = 16,
	Spi_en = 8,
	LanWake = 2,
	PMEStatus = 1,
	ASPM_en = 1,
	EnableBist = 32768,
	Mac_dbgo_oe = 16384,
	EnAnaPLL = 16384,
	Normal_mode = 8192,
	Force_half_dup = 4096,
	Force_rxflow_en = 2048,
	Force_txflow_en = 1024,
	Cxpl_dbg_sel = 512,
	ASF = 256,
	PktCntrDisable = 128,
	Mac_dbgo_sel = 28,
	RxVlan = 64,
	RxChkSum = 32,
	PCIDAC = 16,
	PCIMulRW = 8,
	TBI_Enable = 128,
	TxFlowCtrl = 64,
	RxFlowCtrl = 32,
	_1000bpsF = 16,
	_100bps___2 = 8,
	_10bps___2 = 4,
	LinkStatus = 2,
	FullDup = 1,
	CounterReset = 1,
	CounterDump = 8,
	MagicPacket_v2 = 65536,
};

enum rtl_registers {
	MAC0 = 0,
	MAC4 = 4,
	MAR0 = 8,
	CounterAddrLow = 16,
	CounterAddrHigh = 20,
	TxDescStartAddrLow = 32,
	TxDescStartAddrHigh = 36,
	TxHDescStartAddrLow = 40,
	TxHDescStartAddrHigh = 44,
	FLASH = 48,
	ERSR = 54,
	ChipCmd = 55,
	TxPoll = 56,
	IntrMask = 60,
	IntrStatus = 62,
	TxConfig = 64,
	RxConfig = 68,
	Cfg9346 = 80,
	Config0 = 81,
	Config1 = 82,
	Config2 = 83,
	Config3 = 84,
	Config4 = 85,
	Config5 = 86,
	PHYAR = 96,
	PHYstatus = 108,
	RxMaxSize = 218,
	CPlusCmd = 224,
	IntrMitigate = 226,
	RxDescAddrLow = 228,
	RxDescAddrHigh = 232,
	EarlyTxThres = 236,
	MaxTxPacketSize = 236,
	FuncEvent = 240,
	FuncEventMask = 244,
	FuncPresetState = 248,
	IBCR0 = 248,
	IBCR2 = 249,
	IBIMR0 = 250,
	IBISR0 = 251,
	FuncForceEvent = 252,
};

enum rtl_rx_desc_bit {
	PID1 = 262144,
	PID0 = 131072,
	IPFail = 65536,
	UDPFail = 32768,
	TCPFail = 16384,
	RxVlanTag = 65536,
};

enum rtl_tx_desc_bit {
	TD_LSO = 134217728,
	TxVlanTag = 131072,
};

enum rtl_tx_desc_bit_0 {
	TD0_TCP_CS = 65536,
	TD0_UDP_CS = 131072,
	TD0_IP_CS = 262144,
};

enum rtl_tx_desc_bit_1 {
	TD1_GTSENV4 = 67108864,
	TD1_GTSENV6 = 33554432,
	TD1_IPv6_CS = 268435456,
	TD1_IPv4_CS = 536870912,
	TD1_TCP_CS = 1073741824,
	TD1_UDP_CS = -2147483648,
};

enum rtl_version {
	RTL_VER_UNKNOWN = 0,
	RTL_VER_01 = 1,
	RTL_VER_02 = 2,
	RTL_VER_03 = 3,
	RTL_VER_04 = 4,
	RTL_VER_05 = 5,
	RTL_VER_06 = 6,
	RTL_VER_07 = 7,
	RTL_VER_08 = 8,
	RTL_VER_09 = 9,
	RTL_TEST_01 = 10,
	RTL_VER_10 = 11,
	RTL_VER_11 = 12,
	RTL_VER_12 = 13,
	RTL_VER_13 = 14,
	RTL_VER_14 = 15,
	RTL_VER_15 = 16,
	RTL_VER_MAX = 17,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rtw8822c_dpk_agc_phase {
	RTW_DPK_GAIN_CHECK = 0,
	RTW_DPK_GAIN_LARGE = 1,
	RTW_DPK_GAIN_LESS = 2,
	RTW_DPK_GL_LARGE = 3,
	RTW_DPK_GL_LESS = 4,
	RTW_DPK_LOSS_CHECK = 5,
	RTW_DPK_AGC_OUT = 6,
};

enum rtw8822c_dpk_one_shot_action {
	RTW_DPK_CAL_PWR = 0,
	RTW_DPK_GAIN_LOSS = 1,
	RTW_DPK_DO_DPK = 2,
	RTW_DPK_DPK_ON = 3,
	RTW_DPK_DAGC = 4,
	RTW_DPK_ACTION_MAX = 5,
};

enum rtw_bandwidth {
	RTW_CHANNEL_WIDTH_20 = 0,
	RTW_CHANNEL_WIDTH_40 = 1,
	RTW_CHANNEL_WIDTH_80 = 2,
	RTW_CHANNEL_WIDTH_160 = 3,
	RTW_CHANNEL_WIDTH_80_80 = 4,
	RTW_CHANNEL_WIDTH_5 = 5,
	RTW_CHANNEL_WIDTH_10 = 6,
};

enum rtw_bb_path {
	BB_PATH_A = 1,
	BB_PATH_B = 2,
	BB_PATH_C = 4,
	BB_PATH_D = 8,
	BB_PATH_AB = 3,
	BB_PATH_AC = 5,
	BB_PATH_AD = 9,
	BB_PATH_BC = 6,
	BB_PATH_BD = 10,
	BB_PATH_CD = 12,
	BB_PATH_ABC = 7,
	BB_PATH_ABD = 11,
	BB_PATH_ACD = 13,
	BB_PATH_BCD = 14,
	BB_PATH_ABCD = 15,
};

enum rtw_beacon_filter_offload_mode {
	BCN_FILTER_OFFLOAD_MODE_0 = 0,
	BCN_FILTER_OFFLOAD_MODE_1 = 1,
	BCN_FILTER_OFFLOAD_MODE_2 = 2,
	BCN_FILTER_OFFLOAD_MODE_3 = 3,
	BCN_FILTER_OFFLOAD_MODE_DEFAULT = 0,
};

enum rtw_bfee_role {
	RTW_BFEE_NONE = 0,
	RTW_BFEE_SU = 1,
	RTW_BFEE_MU = 2,
};

enum rtw_c2h_cmd_id {
	C2H_CCX_TX_RPT = 3,
	C2H_BT_INFO = 9,
	C2H_BT_MP_INFO = 11,
	C2H_BT_HID_INFO = 69,
	C2H_RA_RPT = 12,
	C2H_HW_FEATURE_REPORT = 25,
	C2H_WLAN_INFO = 39,
	C2H_WLAN_RFON = 50,
	C2H_BCN_FILTER_NOTIFY = 54,
	C2H_ADAPTIVITY = 55,
	C2H_SCAN_RESULT = 56,
	C2H_HW_FEATURE_DUMP = 253,
	C2H_HALMAC = 255,
};

enum rtw_c2h_cmd_id_ext {
	C2H_SCAN_STATUS_RPT = 3,
	C2H_CCX_RPT = 15,
	C2H_CHAN_SWITCH = 34,
};

enum rtw_channel_type {
	RTW_CHANNEL_PASSIVE = 0,
	RTW_CHANNEL_ACTIVE = 1,
	RTW_CHANNEL_RADAR = 2,
};

enum rtw_chip_type {
	RTW_CHIP_TYPE_8822B = 0,
	RTW_CHIP_TYPE_8822C = 1,
	RTW_CHIP_TYPE_8723D = 2,
	RTW_CHIP_TYPE_8821C = 3,
	RTW_CHIP_TYPE_8703B = 4,
	RTW_CHIP_TYPE_8821A = 5,
	RTW_CHIP_TYPE_8812A = 6,
};

enum rtw_chip_ver {
	RTW_CHIP_VER_CUT_A = 0,
	RTW_CHIP_VER_CUT_B = 1,
	RTW_CHIP_VER_CUT_C = 2,
	RTW_CHIP_VER_CUT_D = 3,
	RTW_CHIP_VER_CUT_E = 4,
	RTW_CHIP_VER_CUT_F = 5,
	RTW_CHIP_VER_CUT_G = 6,
};

enum rtw_coex_bt_state_cnt {
	COEX_CNT_BT_RETRY = 0,
	COEX_CNT_BT_REINIT = 1,
	COEX_CNT_BT_REENABLE = 2,
	COEX_CNT_BT_POPEVENT = 3,
	COEX_CNT_BT_SETUPLINK = 4,
	COEX_CNT_BT_IGNWLANACT = 5,
	COEX_CNT_BT_INQ = 6,
	COEX_CNT_BT_PAGE = 7,
	COEX_CNT_BT_ROLESWITCH = 8,
	COEX_CNT_BT_AFHUPDATE = 9,
	COEX_CNT_BT_INFOUPDATE = 10,
	COEX_CNT_BT_IQK = 11,
	COEX_CNT_BT_IQKFAIL = 12,
	COEX_CNT_BT_MAX = 13,
};

enum rtw_coex_wl_state_cnt {
	COEX_CNT_WL_SCANAP = 0,
	COEX_CNT_WL_CONNPKT = 1,
	COEX_CNT_WL_COEXRUN = 2,
	COEX_CNT_WL_NOISY0 = 3,
	COEX_CNT_WL_NOISY1 = 4,
	COEX_CNT_WL_NOISY2 = 5,
	COEX_CNT_WL_5MS_NOEXTEND = 6,
	COEX_CNT_WL_FW_NOTIFY = 7,
	COEX_CNT_WL_MAX = 8,
};

enum rtw_debug_mask {
	RTW_DBG_PCI = 1,
	RTW_DBG_TX = 2,
	RTW_DBG_RX = 4,
	RTW_DBG_PHY = 8,
	RTW_DBG_FW = 16,
	RTW_DBG_EFUSE = 32,
	RTW_DBG_COEX = 64,
	RTW_DBG_RFK = 128,
	RTW_DBG_REGD = 256,
	RTW_DBG_DEBUGFS = 512,
	RTW_DBG_PS = 1024,
	RTW_DBG_BF = 2048,
	RTW_DBG_WOW = 4096,
	RTW_DBG_CFO = 8192,
	RTW_DBG_PATH_DIV = 16384,
	RTW_DBG_ADAPTIVITY = 32768,
	RTW_DBG_HW_SCAN = 65536,
	RTW_DBG_STATE = 131072,
	RTW_DBG_SDIO = 262144,
	RTW_DBG_USB = 524288,
	RTW_DBG_UNEXP = 2147483648,
	RTW_DBG_ALL = 4294967295,
};

enum rtw_dm_cap {
	RTW_DM_CAP_NA = 0,
	RTW_DM_CAP_TXGAPK = 1,
	RTW_DM_CAP_NUM = 2,
};

enum rtw_dma_mapping {
	RTW_DMA_MAPPING_EXTRA = 0,
	RTW_DMA_MAPPING_LOW = 1,
	RTW_DMA_MAPPING_NORMAL = 2,
	RTW_DMA_MAPPING_HIGH = 3,
	RTW_DMA_MAPPING_MAX = 4,
	RTW_DMA_MAPPING_UNDEF = 5,
};

enum rtw_edcca_mode {
	RTW_EDCCA_NORMAL = 0,
	RTW_EDCCA_ADAPTIVITY = 1,
};

enum rtw_evm {
	RTW_EVM_OFDM = 0,
	RTW_EVM_1SS = 1,
	RTW_EVM_2SS_A = 2,
	RTW_EVM_2SS_B = 3,
	RTW_EVM_NUM = 4,
};

enum rtw_flags {
	RTW_FLAG_RUNNING = 0,
	RTW_FLAG_FW_RUNNING = 1,
	RTW_FLAG_SCANNING = 2,
	RTW_FLAG_POWERON = 3,
	RTW_FLAG_LEISURE_PS = 4,
	RTW_FLAG_LEISURE_PS_DEEP = 5,
	RTW_FLAG_DIG_DISABLE = 6,
	RTW_FLAG_BUSY_TRAFFIC = 7,
	RTW_FLAG_WOWLAN = 8,
	RTW_FLAG_RESTARTING = 9,
	RTW_FLAG_RESTART_TRIGGERING = 10,
	RTW_FLAG_FORCE_LOWEST_RATE = 11,
	NUM_OF_RTW_FLAGS = 12,
};

enum rtw_fw_feature {
	FW_FEATURE_SIG = 1,
	FW_FEATURE_LPS_C2H = 2,
	FW_FEATURE_LCLK = 4,
	FW_FEATURE_PG = 8,
	FW_FEATURE_TX_WAKE = 16,
	FW_FEATURE_BCN_FILTER = 32,
	FW_FEATURE_NOTIFY_SCAN = 64,
	FW_FEATURE_ADAPTIVITY = 128,
	FW_FEATURE_SCAN_OFFLOAD = 256,
	FW_FEATURE_MAX = 2147483648,
};

enum rtw_fw_feature_ext {
	FW_FEATURE_EXT_OLD_PAGE_NUM = 1,
};

enum rtw_fw_fifo_sel {
	RTW_FW_FIFO_SEL_TX = 0,
	RTW_FW_FIFO_SEL_RX = 1,
	RTW_FW_FIFO_SEL_RSVD_PAGE = 2,
	RTW_FW_FIFO_SEL_REPORT = 3,
	RTW_FW_FIFO_SEL_LLT = 4,
	RTW_FW_FIFO_SEL_RXBUF_FW = 5,
	RTW_FW_FIFO_MAX = 6,
};

enum rtw_fw_rf_type {
	FW_RF_1T2R = 0,
	FW_RF_2T4R = 1,
	FW_RF_2T2R = 2,
	FW_RF_2T3R = 3,
	FW_RF_1T1R = 4,
	FW_RF_2T2R_GREEN = 5,
	FW_RF_3T3R = 6,
	FW_RF_3T4R = 7,
	FW_RF_4T4R = 8,
	FW_RF_MAX_TYPE = 15,
};

enum rtw_fw_type {
	RTW_NORMAL_FW = 0,
	RTW_WOWLAN_FW = 1,
};

enum rtw_fwcd_item {
	RTW_FWCD_TLV = 0,
	RTW_FWCD_REG = 1,
	RTW_FWCD_ROM = 2,
	RTW_FWCD_IMEM = 3,
	RTW_FWCD_DMEM = 4,
	RTW_FWCD_EMEM = 5,
};

enum rtw_hci_type {
	RTW_HCI_TYPE_PCIE = 0,
	RTW_HCI_TYPE_USB = 1,
	RTW_HCI_TYPE_SDIO = 2,
	RTW_HCI_TYPE_UNDEFINE = 3,
};

enum rtw_hw_key_type {
	RTW_CAM_NONE = 0,
	RTW_CAM_WEP40 = 1,
	RTW_CAM_TKIP = 2,
	RTW_CAM_AES = 4,
	RTW_CAM_WEP104 = 5,
};

enum rtw_ip_sel {
	RTW_IP_SEL_PHY = 0,
	RTW_IP_SEL_MAC = 1,
	RTW_IP_SEL_DBI = 2,
	RTW_IP_SEL_UNDEF = 65535,
};

enum rtw_lps_deep_mode {
	LPS_DEEP_MODE_NONE = 0,
	LPS_DEEP_MODE_LCLK = 1,
	LPS_DEEP_MODE_PG = 2,
};

enum rtw_lps_mode {
	RTW_MODE_ACTIVE = 0,
	RTW_MODE_LPS = 1,
	RTW_MODE_WMM_PS = 2,
};

enum rtw_net_type {
	RTW_NET_NO_LINK = 0,
	RTW_NET_AD_HOC = 1,
	RTW_NET_MGD_LINKED = 2,
	RTW_NET_AP_MODE = 3,
};

enum rtw_packet_type {
	RTW_PACKET_PROBE_REQ = 0,
	RTW_PACKET_UNDEFINE = 2147483647,
};

enum rtw_pci_flags {
	RTW_PCI_FLAG_NAPI_RUNNING = 0,
	NUM_OF_RTW_PCI_FLAGS = 1,
};

enum rtw_phy_band_type {
	PHY_BAND_2G = 0,
	PHY_BAND_5G = 1,
};

enum rtw_phy_cck_pd_lv {
	CCK_PD_LV0 = 0,
	CCK_PD_LV1 = 1,
	CCK_PD_LV2 = 2,
	CCK_PD_LV3 = 3,
	CCK_PD_LV4 = 4,
	CCK_PD_LV_MAX = 5,
};

enum rtw_port {
	RTW_PORT_0 = 0,
	RTW_PORT_1 = 1,
	RTW_PORT_2 = 2,
	RTW_PORT_3 = 3,
	RTW_PORT_4 = 4,
	RTW_PORT_NUM = 5,
};

enum rtw_pwr_seq_cmd_delay_unit {
	RTW_PWR_DELAY_US = 0,
	RTW_PWR_DELAY_MS = 1,
};

enum rtw_pwr_state {
	RTW_RF_OFF = 0,
	RTW_RF_ON = 4,
	RTW_ALL_ON = 12,
};

enum rtw_rate_index {
	RTW_RATEID_BGN_40M_2SS = 0,
	RTW_RATEID_BGN_40M_1SS = 1,
	RTW_RATEID_BGN_20M_2SS = 2,
	RTW_RATEID_BGN_20M_1SS = 3,
	RTW_RATEID_GN_N2SS = 4,
	RTW_RATEID_GN_N1SS = 5,
	RTW_RATEID_BG = 6,
	RTW_RATEID_G = 7,
	RTW_RATEID_B_20M = 8,
	RTW_RATEID_ARFR0_AC_2SS = 9,
	RTW_RATEID_ARFR1_AC_1SS = 10,
	RTW_RATEID_ARFR2_AC_2G_1SS = 11,
	RTW_RATEID_ARFR3_AC_2G_2SS = 12,
	RTW_RATEID_ARFR4_AC_3SS = 13,
	RTW_RATEID_ARFR5_N_3SS = 14,
	RTW_RATEID_ARFR7_N_4SS = 15,
	RTW_RATEID_ARFR6_AC_4SS = 16,
};

enum rtw_rate_section {
	RTW_RATE_SECTION_CCK = 0,
	RTW_RATE_SECTION_OFDM = 1,
	RTW_RATE_SECTION_HT_1S = 2,
	RTW_RATE_SECTION_HT_2S = 3,
	RTW_RATE_SECTION_VHT_1S = 4,
	RTW_RATE_SECTION_VHT_2S = 5,
	RTW_RATE_SECTION_MAX = 6,
};

enum rtw_regd_state {
	RTW_REGD_STATE_WORLDWIDE = 0,
	RTW_REGD_STATE_PROGRAMMED = 1,
	RTW_REGD_STATE_SETTING = 2,
	RTW_REGD_STATE_NR = 3,
};

enum rtw_regulatory_domains {
	RTW_REGD_FCC = 0,
	RTW_REGD_MKK = 1,
	RTW_REGD_ETSI = 2,
	RTW_REGD_IC = 3,
	RTW_REGD_KCC = 4,
	RTW_REGD_ACMA = 5,
	RTW_REGD_CHILE = 6,
	RTW_REGD_UKRAINE = 7,
	RTW_REGD_MEXICO = 8,
	RTW_REGD_CN = 9,
	RTW_REGD_QATAR = 10,
	RTW_REGD_UK = 11,
	RTW_REGD_WW = 12,
	RTW_REGD_MAX = 13,
};

enum rtw_rf_band {
	RF_BAND_2G_CCK = 0,
	RF_BAND_2G_OFDM = 1,
	RF_BAND_5G_L = 2,
	RF_BAND_5G_M = 3,
	RF_BAND_5G_H = 4,
	RF_BAND_MAX = 5,
};

enum rtw_rf_path {
	RF_PATH_A = 0,
	RF_PATH_B = 1,
	RF_PATH_C = 2,
	RF_PATH_D = 3,
};

enum rtw_rf_type {
	RF_1T1R = 0,
	RF_1T2R = 1,
	RF_2T2R = 2,
	RF_2T3R = 3,
	RF_2T4R = 4,
	RF_3T3R = 5,
	RF_3T4R = 6,
	RF_4T4R = 7,
	RF_TYPE_MAX = 8,
};

enum rtw_rfe_fem {
	RTW_RFE_IFEM = 0,
	RTW_RFE_EFEM = 1,
	RTW_RFE_IFEM2G_EFEM5G = 2,
	RTW_RFE_NUM = 3,
};

enum rtw_rsvd_packet_type {
	RSVD_BEACON = 0,
	RSVD_DUMMY = 1,
	RSVD_PS_POLL = 2,
	RSVD_PROBE_RESP = 3,
	RSVD_NULL = 4,
	RSVD_QOS_NULL = 5,
	RSVD_LPS_PG_DPK = 6,
	RSVD_LPS_PG_INFO = 7,
	RSVD_PROBE_REQ = 8,
	RSVD_NLO_INFO = 9,
	RSVD_CH_INFO = 10,
};

enum rtw_rx_desc_enc {
	RX_DESC_ENC_NONE = 0,
	RX_DESC_ENC_WEP40 = 1,
	RX_DESC_ENC_TKIP_WO_MIC = 2,
	RX_DESC_ENC_TKIP_MIC = 3,
	RX_DESC_ENC_AES = 4,
	RX_DESC_ENC_WEP104 = 5,
};

enum rtw_rx_queue_type {
	RTW_RX_QUEUE_MPDU = 0,
	RTW_RX_QUEUE_C2H = 1,
	RTK_MAX_RX_QUEUE_NUM = 2,
};

enum rtw_sar_bands {
	RTW_SAR_BAND_0 = 0,
	RTW_SAR_BAND_1 = 1,
	RTW_SAR_BAND_3 = 2,
	RTW_SAR_BAND_4 = 3,
	RTW_SAR_BAND_NR = 4,
};

enum rtw_sar_sources {
	RTW_SAR_SOURCE_NONE = 0,
	RTW_SAR_SOURCE_COMMON = 1,
};

enum rtw_sc_offset {
	RTW_SC_DONT_CARE = 0,
	RTW_SC_20_UPPER = 1,
	RTW_SC_20_LOWER = 2,
	RTW_SC_20_UPMOST = 3,
	RTW_SC_20_LOWEST = 4,
	RTW_SC_40_UPPER = 9,
	RTW_SC_40_LOWER = 10,
};

enum rtw_scan_extra_id {
	RTW_SCAN_EXTRA_ID_DFS = 0,
};

enum rtw_scan_extra_info {
	RTW_SCAN_EXTRA_ACTION_SCAN = 0,
};

enum rtw_scan_notify_id {
	RTW_SCAN_NOTIFY_ID_PRESWITCH = 0,
	RTW_SCAN_NOTIFY_ID_POSTSWITCH = 1,
	RTW_SCAN_NOTIFY_ID_PROBE_PRETX = 2,
	RTW_SCAN_NOTIFY_ID_PROBE_ISSUETX = 3,
	RTW_SCAN_NOTIFY_ID_NULL0_PRETX = 4,
	RTW_SCAN_NOTIFY_ID_NULL0_ISSUETX = 5,
	RTW_SCAN_NOTIFY_ID_NULL0_POSTTX = 6,
	RTW_SCAN_NOTIFY_ID_NULL1_PRETX = 7,
	RTW_SCAN_NOTIFY_ID_NULL1_ISSUETX = 8,
	RTW_SCAN_NOTIFY_ID_NULL1_POSTTX = 9,
	RTW_SCAN_NOTIFY_ID_DWELLEXT = 10,
};

enum rtw_scan_report_code {
	RTW_SCAN_REPORT_SUCCESS = 0,
	RTW_SCAN_REPORT_ERR_PHYDM = 1,
	RTW_SCAN_REPORT_ERR_ID = 2,
	RTW_SCAN_REPORT_ERR_TX = 3,
	RTW_SCAN_REPORT_CANCELED = 16,
	RTW_SCAN_REPORT_CANCELED_EXT = 17,
	RTW_SCAN_REPORT_FW_DISABLED = 240,
};

enum rtw_snr {
	RTW_SNR_OFDM_A = 0,
	RTW_SNR_OFDM_B = 1,
	RTW_SNR_OFDM_C = 2,
	RTW_SNR_OFDM_D = 3,
	RTW_SNR_1SS_A = 4,
	RTW_SNR_1SS_B = 5,
	RTW_SNR_1SS_C = 6,
	RTW_SNR_1SS_D = 7,
	RTW_SNR_2SS_A = 8,
	RTW_SNR_2SS_B = 9,
	RTW_SNR_2SS_C = 10,
	RTW_SNR_2SS_D = 11,
	RTW_SNR_NUM = 12,
};

enum rtw_supported_band {
	RTW_BAND_2G = 1,
	RTW_BAND_5G = 2,
	RTW_BAND_60G = 4,
};

enum rtw_trx_desc_rate {
	DESC_RATE1M = 0,
	DESC_RATE2M = 1,
	DESC_RATE5_5M = 2,
	DESC_RATE11M = 3,
	DESC_RATE6M = 4,
	DESC_RATE9M = 5,
	DESC_RATE12M = 6,
	DESC_RATE18M = 7,
	DESC_RATE24M = 8,
	DESC_RATE36M = 9,
	DESC_RATE48M = 10,
	DESC_RATE54M = 11,
	DESC_RATEMCS0 = 12,
	DESC_RATEMCS1 = 13,
	DESC_RATEMCS2 = 14,
	DESC_RATEMCS3 = 15,
	DESC_RATEMCS4 = 16,
	DESC_RATEMCS5 = 17,
	DESC_RATEMCS6 = 18,
	DESC_RATEMCS7 = 19,
	DESC_RATEMCS8 = 20,
	DESC_RATEMCS9 = 21,
	DESC_RATEMCS10 = 22,
	DESC_RATEMCS11 = 23,
	DESC_RATEMCS12 = 24,
	DESC_RATEMCS13 = 25,
	DESC_RATEMCS14 = 26,
	DESC_RATEMCS15 = 27,
	DESC_RATEMCS16 = 28,
	DESC_RATEMCS17 = 29,
	DESC_RATEMCS18 = 30,
	DESC_RATEMCS19 = 31,
	DESC_RATEMCS20 = 32,
	DESC_RATEMCS21 = 33,
	DESC_RATEMCS22 = 34,
	DESC_RATEMCS23 = 35,
	DESC_RATEMCS24 = 36,
	DESC_RATEMCS25 = 37,
	DESC_RATEMCS26 = 38,
	DESC_RATEMCS27 = 39,
	DESC_RATEMCS28 = 40,
	DESC_RATEMCS29 = 41,
	DESC_RATEMCS30 = 42,
	DESC_RATEMCS31 = 43,
	DESC_RATEVHT1SS_MCS0 = 44,
	DESC_RATEVHT1SS_MCS1 = 45,
	DESC_RATEVHT1SS_MCS2 = 46,
	DESC_RATEVHT1SS_MCS3 = 47,
	DESC_RATEVHT1SS_MCS4 = 48,
	DESC_RATEVHT1SS_MCS5 = 49,
	DESC_RATEVHT1SS_MCS6 = 50,
	DESC_RATEVHT1SS_MCS7 = 51,
	DESC_RATEVHT1SS_MCS8 = 52,
	DESC_RATEVHT1SS_MCS9 = 53,
	DESC_RATEVHT2SS_MCS0 = 54,
	DESC_RATEVHT2SS_MCS1 = 55,
	DESC_RATEVHT2SS_MCS2 = 56,
	DESC_RATEVHT2SS_MCS3 = 57,
	DESC_RATEVHT2SS_MCS4 = 58,
	DESC_RATEVHT2SS_MCS5 = 59,
	DESC_RATEVHT2SS_MCS6 = 60,
	DESC_RATEVHT2SS_MCS7 = 61,
	DESC_RATEVHT2SS_MCS8 = 62,
	DESC_RATEVHT2SS_MCS9 = 63,
	DESC_RATEVHT3SS_MCS0 = 64,
	DESC_RATEVHT3SS_MCS1 = 65,
	DESC_RATEVHT3SS_MCS2 = 66,
	DESC_RATEVHT3SS_MCS3 = 67,
	DESC_RATEVHT3SS_MCS4 = 68,
	DESC_RATEVHT3SS_MCS5 = 69,
	DESC_RATEVHT3SS_MCS6 = 70,
	DESC_RATEVHT3SS_MCS7 = 71,
	DESC_RATEVHT3SS_MCS8 = 72,
	DESC_RATEVHT3SS_MCS9 = 73,
	DESC_RATEVHT4SS_MCS0 = 74,
	DESC_RATEVHT4SS_MCS1 = 75,
	DESC_RATEVHT4SS_MCS2 = 76,
	DESC_RATEVHT4SS_MCS3 = 77,
	DESC_RATEVHT4SS_MCS4 = 78,
	DESC_RATEVHT4SS_MCS5 = 79,
	DESC_RATEVHT4SS_MCS6 = 80,
	DESC_RATEVHT4SS_MCS7 = 81,
	DESC_RATEVHT4SS_MCS8 = 82,
	DESC_RATEVHT4SS_MCS9 = 83,
	DESC_RATE_MAX = 84,
};

enum rtw_tx_desc_queue_select {
	TX_DESC_QSEL_TID0 = 0,
	TX_DESC_QSEL_TID1 = 1,
	TX_DESC_QSEL_TID2 = 2,
	TX_DESC_QSEL_TID3 = 3,
	TX_DESC_QSEL_TID4 = 4,
	TX_DESC_QSEL_TID5 = 5,
	TX_DESC_QSEL_TID6 = 6,
	TX_DESC_QSEL_TID7 = 7,
	TX_DESC_QSEL_TID8 = 8,
	TX_DESC_QSEL_TID9 = 9,
	TX_DESC_QSEL_TID10 = 10,
	TX_DESC_QSEL_TID11 = 11,
	TX_DESC_QSEL_TID12 = 12,
	TX_DESC_QSEL_TID13 = 13,
	TX_DESC_QSEL_TID14 = 14,
	TX_DESC_QSEL_TID15 = 15,
	TX_DESC_QSEL_BEACON = 16,
	TX_DESC_QSEL_HIGH = 17,
	TX_DESC_QSEL_MGMT = 18,
	TX_DESC_QSEL_H2C = 19,
};

enum rtw_tx_queue_type {
	RTW_TX_QUEUE_BK = 0,
	RTW_TX_QUEUE_BE = 1,
	RTW_TX_QUEUE_VI = 2,
	RTW_TX_QUEUE_VO = 3,
	RTW_TX_QUEUE_BCN = 4,
	RTW_TX_QUEUE_MGMT = 5,
	RTW_TX_QUEUE_HI0 = 6,
	RTW_TX_QUEUE_H2C = 7,
	RTK_MAX_TX_QUEUE_NUM = 8,
};

enum rtw_txq_flags {
	RTW_TXQ_AMPDU = 0,
	RTW_TXQ_BLOCK_BA = 1,
};

enum rtw_vif_port_set {
	PORT_SET_MAC_ADDR = 1,
	PORT_SET_BSSID = 2,
	PORT_SET_NET_TYPE = 4,
	PORT_SET_AID = 8,
	PORT_SET_BCN_CTRL = 16,
};

enum rtw_wake_reason {
	RTW_WOW_RSN_RX_PTK_REKEY = 1,
	RTW_WOW_RSN_RX_GTK_REKEY = 2,
	RTW_WOW_RSN_RX_DEAUTH = 8,
	RTW_WOW_RSN_DISCONNECT = 16,
	RTW_WOW_RSN_RX_MAGIC_PKT = 33,
	RTW_WOW_RSN_RX_PATTERN_MATCH = 35,
	RTW_WOW_RSN_RX_NLO = 85,
};

enum rtw_wireless_set {
	WIRELESS_CCK = 1,
	WIRELESS_OFDM = 2,
	WIRELESS_HT = 4,
	WIRELESS_VHT = 8,
};

enum rtw_wlan_cpu {
	RTW_WCPU_11AC = 0,
	RTW_WCPU_11N = 1,
};

enum rtw_wow_flags {
	RTW_WOW_FLAG_EN_MAGIC_PKT = 0,
	RTW_WOW_FLAG_EN_REKEY_PKT = 1,
	RTW_WOW_FLAG_EN_DISCONNECT = 2,
	RTW_WOW_FLAG_MAX = 3,
};

enum rtw_wow_pattern_type {
	RTW_PATTERN_BROADCAST = 0,
	RTW_PATTERN_MULTICAST = 1,
	RTW_PATTERN_UNICAST = 2,
	RTW_PATTERN_VALID = 3,
	RTW_PATTERN_INVALID = 4,
};

enum ru_state {
	RU_SUSPENDED = 0,
	RU_RUNNING = 1,
	RU_UNINITIALIZED = -1,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_crypto {
	RX_CRYPTO_SUCCESS = 0,
	RX_CRYPTO_FAIL_ICV = 1,
	RX_CRYPTO_FAIL_MIC = 2,
	RX_CRYPTO_FAIL_KEY = 3,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum rxdone_entry_desc_flags {
	RXDONE_SIGNAL_PLCP = 1,
	RXDONE_SIGNAL_BITRATE = 2,
	RXDONE_SIGNAL_MCS = 4,
	RXDONE_MY_BSS = 8,
	RXDONE_CRYPTO_IV = 16,
	RXDONE_CRYPTO_ICV = 32,
	RXDONE_L2PAD = 64,
};

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum sanyo_state {
	STATE_INACTIVE___6 = 0,
	STATE_HEADER_SPACE___3 = 1,
	STATE_BIT_PULSE___3 = 2,
	STATE_BIT_SPACE___3 = 3,
	STATE_TRAILER_PULSE___3 = 4,
	STATE_TRAILER_SPACE___3 = 5,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_config_flags {
	SCAN_CONFIG_FLAG_ACTIVATE = 1,
	SCAN_CONFIG_FLAG_DEACTIVATE = 2,
	SCAN_CONFIG_FLAG_FORBID_CHUB_REQS = 4,
	SCAN_CONFIG_FLAG_ALLOW_CHUB_REQS = 8,
	SCAN_CONFIG_FLAG_SET_TX_CHAINS = 256,
	SCAN_CONFIG_FLAG_SET_RX_CHAINS = 512,
	SCAN_CONFIG_FLAG_SET_AUX_STA_ID = 1024,
	SCAN_CONFIG_FLAG_SET_ALL_TIMES = 2048,
	SCAN_CONFIG_FLAG_SET_EFFECTIVE_TIMES = 4096,
	SCAN_CONFIG_FLAG_SET_CHANNEL_FLAGS = 8192,
	SCAN_CONFIG_FLAG_SET_LEGACY_RATES = 16384,
	SCAN_CONFIG_FLAG_SET_MAC_ADDR = 32768,
	SCAN_CONFIG_FLAG_SET_FRAGMENTED = 65536,
	SCAN_CONFIG_FLAG_CLEAR_FRAGMENTED = 131072,
	SCAN_CONFIG_FLAG_SET_CAM_MODE = 262144,
	SCAN_CONFIG_FLAG_CLEAR_CAM_MODE = 524288,
	SCAN_CONFIG_FLAG_SET_PROMISC_MODE = 1048576,
	SCAN_CONFIG_FLAG_CLEAR_PROMISC_MODE = 2097152,
	SCAN_CONFIG_FLAG_SET_LMAC2_FRAGMENTED = 4194304,
	SCAN_CONFIG_FLAG_CLEAR_LMAC2_FRAGMENTED = 8388608,
};

enum scan_framework_client {
	SCAN_CLIENT_SCHED_SCAN = 1,
	SCAN_CLIENT_NETDETECT = 2,
	SCAN_CLIENT_ASSET_TRACKING = 4,
};

enum scb_cmd_hi {
	irq_mask_none = 0,
	irq_mask_all = 1,
	irq_sw_gen = 2,
};

enum scb_cmd_lo {
	cuc_nop = 0,
	ruc_start = 1,
	ruc_load_base = 6,
	cuc_start = 16,
	cuc_resume = 32,
	cuc_dump_addr = 64,
	cuc_dump_stats = 80,
	cuc_load_base = 96,
	cuc_dump_reset = 112,
};

enum scb_stat_ack {
	stat_ack_not_ours = 0,
	stat_ack_sw_gen = 4,
	stat_ack_rnr = 16,
	stat_ack_cu_idle = 32,
	stat_ack_frame_rx = 64,
	stat_ack_cu_cmd_done = 128,
	stat_ack_not_present = 255,
	stat_ack_rx = 84,
	stat_ack_tx = 160,
};

enum scb_status {
	rus_no_res = 8,
	rus_ready = 16,
	rus_mask = 60,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scrub_stripe_flags {
	SCRUB_STRIPE_FLAG_INITIALIZED = 0,
	SCRUB_STRIPE_FLAG_REPAIR_DONE = 1,
	SCRUB_STRIPE_FLAG_NO_REPORT = 2,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP___2 = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 10000,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 30000,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_OPS_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 29,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 29,
	SCX_OPI_CPU_HOTPLUG_END = 31,
	SCX_OPI_END = 31,
};

enum scx_ops_enable_state {
	SCX_OPS_ENABLING = 0,
	SCX_OPS_ENABLED = 1,
	SCX_OPS_DISABLING = 2,
	SCX_OPS_DISABLED = 3,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1,
	SCX_OPS_ENQ_LAST = 2,
	SCX_OPS_ENQ_EXITING = 4,
	SCX_OPS_SWITCH_PARTIAL = 8,
	SCX_OPS_ENQ_MIGRATION_DISABLED = 16,
	SCX_OPS_ALLOW_QUEUED_WAKEUP = 32,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536,
	SCX_OPS_ALL_FLAGS = 65599,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_CLK_VALID = 32,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum ser {
	SER_REQUIRED = 1,
	NO_SER = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum set_event_iter_type {
	SET_EVENT_FILE = 0,
	SET_EVENT_MOD = 1,
};

enum set_key_cmd {
	SET_KEY = 0,
	DISABLE_KEY = 1,
};

enum severity_level {
	MCE_NO_SEVERITY = 0,
	MCE_DEFERRED_SEVERITY = 1,
	MCE_UCNA_SEVERITY = 1,
	MCE_KEEP_SEVERITY = 2,
	MCE_SOME_SEVERITY = 3,
	MCE_AO_SEVERITY = 4,
	MCE_UC_SEVERITY = 5,
	MCE_AR_SEVERITY = 6,
	MCE_PANIC_SEVERITY = 7,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sharp_state {
	STATE_INACTIVE___7 = 0,
	STATE_BIT_PULSE___4 = 1,
	STATE_BIT_SPACE___4 = 2,
	STATE_TRAILER_PULSE___4 = 3,
	STATE_ECHO_SPACE = 4,
	STATE_TRAILER_SPACE___4 = 5,
};

enum shmem_param {
	Opt_gid___9 = 0,
	Opt_huge = 1,
	Opt_mode___6 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes = 5,
	Opt_size = 6,
	Opt_uid___8 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum show_regs_mode {
	SHOW_REGS_SHORT = 0,
	SHOW_REGS_USER = 1,
	SHOW_REGS_ALL = 2,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 38,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 39,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 40,
	SKB_DROP_REASON_TCP_RESET = 41,
	SKB_DROP_REASON_TCP_INVALID_SYN = 42,
	SKB_DROP_REASON_TCP_CLOSE = 43,
	SKB_DROP_REASON_TCP_FASTOPEN = 44,
	SKB_DROP_REASON_TCP_OLD_ACK = 45,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 46,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 47,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 48,
	SKB_DROP_REASON_TCP_OFO_DROP = 49,
	SKB_DROP_REASON_IP_OUTNOROUTES = 50,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 51,
	SKB_DROP_REASON_IPV6DISABLED = 52,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 53,
	SKB_DROP_REASON_NEIGH_FAILED = 54,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 55,
	SKB_DROP_REASON_NEIGH_DEAD = 56,
	SKB_DROP_REASON_TC_EGRESS = 57,
	SKB_DROP_REASON_SECURITY_HOOK = 58,
	SKB_DROP_REASON_QDISC_DROP = 59,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 60,
	SKB_DROP_REASON_QDISC_CONGESTED = 61,
	SKB_DROP_REASON_CAKE_FLOOD = 62,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 63,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 64,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 65,
	SKB_DROP_REASON_CPU_BACKLOG = 66,
	SKB_DROP_REASON_XDP = 67,
	SKB_DROP_REASON_TC_INGRESS = 68,
	SKB_DROP_REASON_UNHANDLED_PROTO = 69,
	SKB_DROP_REASON_SKB_CSUM = 70,
	SKB_DROP_REASON_SKB_GSO_SEG = 71,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 72,
	SKB_DROP_REASON_DEV_HDR = 73,
	SKB_DROP_REASON_DEV_READY = 74,
	SKB_DROP_REASON_FULL_RING = 75,
	SKB_DROP_REASON_NOMEM = 76,
	SKB_DROP_REASON_HDR_TRUNC = 77,
	SKB_DROP_REASON_TAP_FILTER = 78,
	SKB_DROP_REASON_TAP_TXFILTER = 79,
	SKB_DROP_REASON_ICMP_CSUM = 80,
	SKB_DROP_REASON_INVALID_PROTO = 81,
	SKB_DROP_REASON_IP_INADDRERRORS = 82,
	SKB_DROP_REASON_IP_INNOROUTES = 83,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 84,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 85,
	SKB_DROP_REASON_IP_LOCALNET = 86,
	SKB_DROP_REASON_IP_INVALID_DEST = 87,
	SKB_DROP_REASON_PKT_TOO_BIG = 88,
	SKB_DROP_REASON_DUP_FRAG = 89,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 90,
	SKB_DROP_REASON_FRAG_TOO_FAR = 91,
	SKB_DROP_REASON_TCP_MINTTL = 92,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 93,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 94,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 95,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 96,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 97,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 98,
	SKB_DROP_REASON_QUEUE_PURGE = 99,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 100,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 101,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 102,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 103,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 104,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 105,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 106,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 107,
	SKB_DROP_REASON_NO_TX_TARGET = 108,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 109,
	SKB_DROP_REASON_TUNNEL_TXINFO = 110,
	SKB_DROP_REASON_LOCAL_MAC = 111,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 112,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 113,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 114,
	SKB_DROP_REASON_MAX = 115,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_MAC80211_MONITOR = 2,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 3,
	SKB_DROP_REASON_SUBSYS_NUM = 4,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_NUM = 1,
};

enum skb_frame_desc_flags {
	SKBDESC_DMA_MAPPED_RX = 1,
	SKBDESC_DMA_MAPPED_TX = 2,
	SKBDESC_IV_STRIPPED = 4,
	SKBDESC_NOT_MAC80211 = 8,
	SKBDESC_DESC_IN_SKB = 16,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN = 0,
	PARTIAL = 1,
	UP = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum smca_bank_types {
	SMCA_LS = 0,
	SMCA_LS_V2 = 1,
	SMCA_IF = 2,
	SMCA_L2_CACHE = 3,
	SMCA_DE = 4,
	SMCA_RESERVED = 5,
	SMCA_EX = 6,
	SMCA_FP = 7,
	SMCA_L3_CACHE = 8,
	SMCA_CS = 9,
	SMCA_CS_V2 = 10,
	SMCA_PIE = 11,
	SMCA_UMC = 12,
	SMCA_UMC_V2 = 13,
	SMCA_MA_LLC = 14,
	SMCA_PB = 15,
	SMCA_PSP = 16,
	SMCA_PSP_V2 = 17,
	SMCA_SMU = 18,
	SMCA_SMU_V2 = 19,
	SMCA_MP5 = 20,
	SMCA_MPDMA = 21,
	SMCA_NBIO = 22,
	SMCA_PCIE = 23,
	SMCA_PCIE_V2 = 24,
	SMCA_XGMI_PCS = 25,
	SMCA_NBIF = 26,
	SMCA_SHUB = 27,
	SMCA_SATA = 28,
	SMCA_USB = 29,
	SMCA_USR_DP = 30,
	SMCA_USR_CP = 31,
	SMCA_GMI_PCS = 32,
	SMCA_XGMI_PHY = 33,
	SMCA_WAFL_PHY = 34,
	SMCA_GMI_PHY = 35,
	N_SMCA_BANK_TYPES = 36,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE___2 = 1,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum sony_state {
	STATE_INACTIVE___8 = 0,
	STATE_HEADER_SPACE___4 = 1,
	STATE_BIT_PULSE___5 = 2,
	STATE_BIT_SPACE___5 = 3,
	STATE_FINISHED___4 = 4,
};

enum spd_duplex {
	NWAY_10M_HALF = 0,
	NWAY_10M_FULL = 1,
	NWAY_100M_HALF = 2,
	NWAY_100M_FULL = 3,
	NWAY_1000M_FULL = 4,
	FORCE_10M_HALF = 5,
	FORCE_10M_FULL = 6,
	FORCE_100M_HALF = 7,
	FORCE_100M_FULL = 8,
	FORCE_1000M_FULL = 9,
	NWAY_2500M_FULL = 10,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_cast_to_kern_ctx = 7,
	KF_bpf_rdonly_cast = 8,
	KF_bpf_rcu_read_lock = 9,
	KF_bpf_rcu_read_unlock = 10,
	KF_bpf_rbtree_remove = 11,
	KF_bpf_rbtree_add_impl = 12,
	KF_bpf_rbtree_first = 13,
	KF_bpf_dynptr_from_skb = 14,
	KF_bpf_dynptr_from_xdp = 15,
	KF_bpf_dynptr_slice = 16,
	KF_bpf_dynptr_slice_rdwr = 17,
	KF_bpf_dynptr_clone = 18,
	KF_bpf_percpu_obj_new_impl = 19,
	KF_bpf_percpu_obj_drop_impl = 20,
	KF_bpf_throw = 21,
	KF_bpf_wq_set_callback_impl = 22,
	KF_bpf_preempt_disable = 23,
	KF_bpf_preempt_enable = 24,
	KF_bpf_iter_css_task_new = 25,
	KF_bpf_session_cookie = 26,
	KF_bpf_get_kmem_cache = 27,
	KF_bpf_local_irq_save = 28,
	KF_bpf_local_irq_restore = 29,
	KF_bpf_iter_num_new = 30,
	KF_bpf_iter_num_next = 31,
	KF_bpf_iter_num_destroy = 32,
};

enum spectre_v1_mitigation {
	SPECTRE_V1_MITIGATION_NONE = 0,
	SPECTRE_V1_MITIGATION_AUTO = 1,
};

enum spectre_v2_mitigation {
	SPECTRE_V2_NONE = 0,
	SPECTRE_V2_RETPOLINE = 1,
	SPECTRE_V2_LFENCE = 2,
	SPECTRE_V2_EIBRS = 3,
	SPECTRE_V2_EIBRS_RETPOLINE = 4,
	SPECTRE_V2_EIBRS_LFENCE = 5,
	SPECTRE_V2_IBRS = 6,
};

enum spectre_v2_mitigation_cmd {
	SPECTRE_V2_CMD_NONE = 0,
	SPECTRE_V2_CMD_AUTO = 1,
	SPECTRE_V2_CMD_FORCE = 2,
	SPECTRE_V2_CMD_RETPOLINE = 3,
	SPECTRE_V2_CMD_RETPOLINE_GENERIC = 4,
	SPECTRE_V2_CMD_RETPOLINE_LFENCE = 5,
	SPECTRE_V2_CMD_EIBRS = 6,
	SPECTRE_V2_CMD_EIBRS_RETPOLINE = 7,
	SPECTRE_V2_CMD_EIBRS_LFENCE = 8,
	SPECTRE_V2_CMD_IBRS = 9,
};

enum spectre_v2_user_cmd {
	SPECTRE_V2_USER_CMD_NONE = 0,
	SPECTRE_V2_USER_CMD_AUTO = 1,
	SPECTRE_V2_USER_CMD_FORCE = 2,
	SPECTRE_V2_USER_CMD_PRCTL = 3,
	SPECTRE_V2_USER_CMD_PRCTL_IBPB = 4,
	SPECTRE_V2_USER_CMD_SECCOMP = 5,
	SPECTRE_V2_USER_CMD_SECCOMP_IBPB = 6,
};

enum spectre_v2_user_mitigation {
	SPECTRE_V2_USER_NONE = 0,
	SPECTRE_V2_USER_STRICT = 1,
	SPECTRE_V2_USER_STRICT_PREFERRED = 2,
	SPECTRE_V2_USER_PRCTL = 3,
	SPECTRE_V2_USER_SECCOMP = 4,
};

enum spi_compare_returns {
	SPI_COMPARE_SUCCESS = 0,
	SPI_COMPARE_FAILURE = 1,
	SPI_COMPARE_SKIP_TEST = 2,
};

enum spi_signal_type {
	SPI_SIGNAL_UNKNOWN = 1,
	SPI_SIGNAL_SE = 2,
	SPI_SIGNAL_LVD = 3,
	SPI_SIGNAL_HVD = 4,
};

enum split_lock_detect_state {
	sld_off = 0,
	sld_warn = 1,
	sld_fatal = 2,
	sld_ratelimit = 3,
};

enum srbds_mitigations {
	SRBDS_MITIGATION_OFF = 0,
	SRBDS_MITIGATION_UCODE_NEEDED = 1,
	SRBDS_MITIGATION_FULL = 2,
	SRBDS_MITIGATION_TSX_OFF = 3,
	SRBDS_MITIGATION_HYPERVISOR = 4,
};

enum srso_mitigation {
	SRSO_MITIGATION_NONE = 0,
	SRSO_MITIGATION_UCODE_NEEDED = 1,
	SRSO_MITIGATION_SAFE_RET_UCODE_NEEDED = 2,
	SRSO_MITIGATION_MICROCODE = 3,
	SRSO_MITIGATION_SAFE_RET = 4,
	SRSO_MITIGATION_IBPB = 5,
	SRSO_MITIGATION_IBPB_ON_VMEXIT = 6,
};

enum srso_mitigation_cmd {
	SRSO_CMD_OFF = 0,
	SRSO_CMD_MICROCODE = 1,
	SRSO_CMD_SAFE_RET = 2,
	SRSO_CMD_IBPB = 3,
	SRSO_CMD_IBPB_ON_VMEXIT = 4,
};

enum ssb_mitigation {
	SPEC_STORE_BYPASS_NONE = 0,
	SPEC_STORE_BYPASS_DISABLE = 1,
	SPEC_STORE_BYPASS_PRCTL = 2,
	SPEC_STORE_BYPASS_SECCOMP = 3,
};

enum ssb_mitigation_cmd {
	SPEC_STORE_BYPASS_CMD_NONE = 0,
	SPEC_STORE_BYPASS_CMD_AUTO = 1,
	SPEC_STORE_BYPASS_CMD_ON = 2,
	SPEC_STORE_BYPASS_CMD_PRCTL = 3,
	SPEC_STORE_BYPASS_CMD_SECCOMP = 4,
};

enum sta_link_apply_mode {
	STA_LINK_MODE_NEW = 0,
	STA_LINK_MODE_STA_MODIFY = 1,
	STA_LINK_MODE_LINK_MODIFY = 2,
};

enum sta_notify_cmd {
	STA_NOTIFY_SLEEP = 0,
	STA_NOTIFY_AWAKE = 1,
};

enum sta_stats_type {
	STA_STATS_RATE_TYPE_INVALID = 0,
	STA_STATS_RATE_TYPE_LEGACY = 1,
	STA_STATS_RATE_TYPE_HT = 2,
	STA_STATS_RATE_TYPE_VHT = 3,
	STA_STATS_RATE_TYPE_HE = 4,
	STA_STATS_RATE_TYPE_S1G = 5,
	STA_STATS_RATE_TYPE_EHT = 6,
};

enum stack_type {
	STACK_TYPE_UNKNOWN = 0,
	STACK_TYPE_TASK = 1,
	STACK_TYPE_IRQ = 2,
	STACK_TYPE_SOFTIRQ = 3,
	STACK_TYPE_ENTRY = 4,
	STACK_TYPE_EXCEPTION = 5,
	STACK_TYPE_EXCEPTION_LAST = 10,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum station_parameters_apply_mask {
	STATION_PARAM_APPLY_UAPSD = 1,
	STATION_PARAM_APPLY_CAPABILITY = 2,
	STATION_PARAM_APPLY_PLINK_STATE = 4,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum stripe_result {
	STRIPE_SUCCESS = 0,
	STRIPE_RETRY = 1,
	STRIPE_SCHEDULE_AND_RETRY = 2,
	STRIPE_FAIL = 3,
	STRIPE_WAIT_RESHAPE = 4,
};

enum submit_disposition {
	ASYNC_TX_SUBMITTED = 0,
	ASYNC_TX_CHANNEL_SWITCH = 1,
	ASYNC_TX_DIRECT_SUBMIT = 2,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum survey_info_flags {
	SURVEY_INFO_NOISE_DBM = 1,
	SURVEY_INFO_IN_USE = 2,
	SURVEY_INFO_TIME = 4,
	SURVEY_INFO_TIME_BUSY = 8,
	SURVEY_INFO_TIME_EXT_BUSY = 16,
	SURVEY_INFO_TIME_RX = 32,
	SURVEY_INFO_TIME_TX = 64,
	SURVEY_INFO_TIME_SCAN = 128,
	SURVEY_INFO_TIME_BSS_RX = 256,
};

enum suspend_mode {
	PRESUSPEND = 0,
	PRESUSPEND_UNDO = 1,
	POSTSUSPEND = 2,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum sync_action {
	ACTION_RESYNC = 0,
	ACTION_RECOVER = 1,
	ACTION_CHECK = 2,
	ACTION_REPAIR = 3,
	ACTION_RESHAPE = 4,
	ACTION_FROZEN = 5,
	ACTION_IDLE = 6,
	NR_SYNC_ACTIONS = 7,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum syscall_work_bit {
	SYSCALL_WORK_BIT_SECCOMP = 0,
	SYSCALL_WORK_BIT_SYSCALL_TRACEPOINT = 1,
	SYSCALL_WORK_BIT_SYSCALL_TRACE = 2,
	SYSCALL_WORK_BIT_SYSCALL_EMU = 3,
	SYSCALL_WORK_BIT_SYSCALL_AUDIT = 4,
	SYSCALL_WORK_BIT_SYSCALL_USER_DISPATCH = 5,
	SYSCALL_WORK_BIT_SYSCALL_EXIT_TRAP = 6,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum taa_mitigations {
	TAA_MITIGATION_OFF = 0,
	TAA_MITIGATION_UCODE_NEEDED = 1,
	TAA_MITIGATION_VERW = 2,
	TAA_MITIGATION_TSX_DISABLED = 3,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
	TWA_FLAGS = 65280,
	TWAF_NO_ALLOC = 256,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tcp_bit_set {
	TCP_SYN_SET = 0,
	TCP_SYNACK_SET = 1,
	TCP_FIN_SET = 2,
	TCP_ACK_SET = 3,
	TCP_RST_SET = 4,
	TCP_NONE_SET = 5,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_CANCELING = 4,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_PREV_TEMP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 8,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 9,
	THERMAL_GENL_ATTR_TZ_MODE = 10,
	THERMAL_GENL_ATTR_TZ_NAME = 11,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 12,
	THERMAL_GENL_ATTR_TZ_GOV = 13,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 14,
	THERMAL_GENL_ATTR_CDEV = 15,
	THERMAL_GENL_ATTR_CDEV_ID = 16,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 18,
	THERMAL_GENL_ATTR_CDEV_NAME = 19,
	THERMAL_GENL_ATTR_GOV_NAME = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 23,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 24,
	THERMAL_GENL_ATTR_THRESHOLD = 25,
	THERMAL_GENL_ATTR_THRESHOLD_TEMP = 26,
	THERMAL_GENL_ATTR_THRESHOLD_DIRECTION = 27,
	__THERMAL_GENL_ATTR_MAX = 28,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	THERMAL_GENL_EVENT_THRESHOLD_ADD = 15,
	THERMAL_GENL_EVENT_THRESHOLD_DELETE = 16,
	THERMAL_GENL_EVENT_THRESHOLD_FLUSH = 17,
	THERMAL_GENL_EVENT_THRESHOLD_UP = 18,
	THERMAL_GENL_EVENT_THRESHOLD_DOWN = 19,
	__THERMAL_GENL_EVENT_MAX = 20,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	NR_TLB_FLUSH_REASONS = 5,
};

enum tlb_infos {
	ENTRIES = 0,
	NR_INFO = 1,
};

enum topo_types {
	INVALID_TYPE = 0,
	SMT_TYPE = 1,
	CORE_TYPE = 2,
	MAX_TYPE_0B = 3,
	MODULE_TYPE = 3,
	AMD_CCD_TYPE = 3,
	TILE_TYPE = 4,
	AMD_SOCKET_TYPE = 4,
	MAX_TYPE_80000026 = 5,
	DIE_TYPE = 5,
	DIEGRP_TYPE = 6,
	MAX_TYPE_1F = 7,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpc_action {
	TPC_ACTION_STAY = 0,
	TPC_ACTION_DECREASE = 1,
	TPC_ACTION_INCREASE = 2,
	TPC_ACTION_NO_RESTIRCTION = 3,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_NEED_RESCHED_LAZY = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_PAUSE_ON_TRACE = 16777216,
	TRACE_ITER_HASH_PTR = 33554432,
	TRACE_ITER_FUNCTION = 67108864,
	TRACE_ITER_FUNC_FORK = 134217728,
	TRACE_ITER_DISPLAY_GRAPH = 268435456,
	TRACE_ITER_STACKTRACE = 536870912,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_GRAPH_RETADDR_ENT = 12,
	TRACE_USER_STACK = 13,
	TRACE_BLK = 14,
	TRACE_BPUTS = 15,
	TRACE_HWLAT = 16,
	TRACE_OSNOISE = 17,
	TRACE_TIMERLAT = 18,
	TRACE_RAW_DATA = 19,
	TRACE_FUNC_REPEATS = 20,
	__TRACE_LAST_TYPE = 21,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum tsf_sync {
	TSF_SYNC_NONE = 0,
	TSF_SYNC_INFRA = 1,
	TSF_SYNC_ADHOC = 2,
	TSF_SYNC_AP_NONE = 3,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum tsx_ctrl_states {
	TSX_CTRL_ENABLE = 0,
	TSX_CTRL_DISABLE = 1,
	TSX_CTRL_RTM_ALWAYS_ABORT = 2,
	TSX_CTRL_NOT_SUPPORTED = 3,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum tunnel_encap_types {
	TUNNEL_ENCAP_NONE = 0,
	TUNNEL_ENCAP_FOU = 1,
	TUNNEL_ENCAP_GUE = 2,
	TUNNEL_ENCAP_MPLS = 3,
};

enum tx_csum_stat {
	TX_CSUM_SUCCESS = 0,
	TX_CSUM_TSO = 1,
	TX_CSUM_NONE = 2,
};

enum tx_queue_prio {
	TX_QUEUE_PRIO_HIGH = 0,
	TX_QUEUE_PRIO_LOW = 1,
};

enum txdone_entry_desc_flags {
	TXDONE_UNKNOWN = 0,
	TXDONE_SUCCESS = 1,
	TXDONE_FALLBACK = 2,
	TXDONE_FAILURE = 3,
	TXDONE_EXCESSIVE_RETRY = 4,
	TXDONE_AMPDU = 5,
	TXDONE_NO_ACK_REQ = 6,
};

enum txentry_desc_flags {
	ENTRY_TXD_RTS_FRAME = 0,
	ENTRY_TXD_CTS_FRAME = 1,
	ENTRY_TXD_GENERATE_SEQ = 2,
	ENTRY_TXD_FIRST_FRAGMENT = 3,
	ENTRY_TXD_MORE_FRAG = 4,
	ENTRY_TXD_REQ_TIMESTAMP = 5,
	ENTRY_TXD_BURST = 6,
	ENTRY_TXD_ACK = 7,
	ENTRY_TXD_RETRY_MODE = 8,
	ENTRY_TXD_ENCRYPT = 9,
	ENTRY_TXD_ENCRYPT_PAIRWISE = 10,
	ENTRY_TXD_ENCRYPT_IV = 11,
	ENTRY_TXD_ENCRYPT_MMIC = 12,
	ENTRY_TXD_HT_AMPDU = 13,
	ENTRY_TXD_HT_BW_40 = 14,
	ENTRY_TXD_HT_SHORT_GI = 15,
	ENTRY_TXD_HT_MIMO_PS = 16,
};

enum txop {
	TXOP_HTTXOP = 0,
	TXOP_PIFS = 1,
	TXOP_SIFS = 2,
	TXOP_BACKOFF = 3,
};

enum txq_info_flags {
	IEEE80211_TXQ_STOP = 0,
	IEEE80211_TXQ_AMPDU = 1,
	IEEE80211_TXQ_NO_AMSDU = 2,
	IEEE80211_TXQ_DIRTY = 3,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucode_state {
	UCODE_OK = 0,
	UCODE_NEW = 1,
	UCODE_NEW_SAFE = 2,
	UCODE_UPDATED = 3,
	UCODE_NFOUND = 4,
	UCODE_ERROR = 5,
	UCODE_TIMEOUT = 6,
	UCODE_OFFLINE = 7,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_COUNTS = 10,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum uncore_access_type {
	UNCORE_ACCESS_MSR = 0,
	UNCORE_ACCESS_MMIO = 1,
	UNCORE_ACCESS_PCI = 2,
	UNCORE_ACCESS_MAX = 3,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum uv_system_type {
	UV_NONE = 0,
	UV_LEGACY_APIC = 1,
	UV_X2APIC = 2,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_TSC = 1,
	VDSO_CLOCKMODE_PVCLOCK = 2,
	VDSO_CLOCKMODE_HVCLOCK = 3,
	VDSO_CLOCKMODE_MAX = 4,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum virtnet_xmit_type {
	VIRTNET_XMIT_TYPE_SKB = 0,
	VIRTNET_XMIT_TYPE_SKB_ORPHAN = 1,
	VIRTNET_XMIT_TYPE_XDP = 2,
	VIRTNET_XMIT_TYPE_XSK = 3,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	ALLOCSTALL_DMA = 8,
	ALLOCSTALL_DMA32 = 9,
	ALLOCSTALL_NORMAL = 10,
	ALLOCSTALL_MOVABLE = 11,
	PGSCAN_SKIP_DMA = 12,
	PGSCAN_SKIP_DMA32 = 13,
	PGSCAN_SKIP_NORMAL = 14,
	PGSCAN_SKIP_MOVABLE = 15,
	PGFREE = 16,
	PGACTIVATE = 17,
	PGDEACTIVATE = 18,
	PGLAZYFREE = 19,
	PGFAULT = 20,
	PGMAJFAULT = 21,
	PGLAZYFREED = 22,
	PGREFILL = 23,
	PGREUSE = 24,
	PGSTEAL_KSWAPD = 25,
	PGSTEAL_DIRECT = 26,
	PGSTEAL_KHUGEPAGED = 27,
	PGSCAN_KSWAPD = 28,
	PGSCAN_DIRECT = 29,
	PGSCAN_KHUGEPAGED = 30,
	PGSCAN_DIRECT_THROTTLE = 31,
	PGSCAN_ANON = 32,
	PGSCAN_FILE = 33,
	PGSTEAL_ANON = 34,
	PGSTEAL_FILE = 35,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 36,
	PGSCAN_ZONE_RECLAIM_FAILED = 37,
	PGINODESTEAL = 38,
	SLABS_SCANNED = 39,
	KSWAPD_INODESTEAL = 40,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 41,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 42,
	PAGEOUTRUN = 43,
	PGROTATED = 44,
	DROP_PAGECACHE = 45,
	DROP_SLAB = 46,
	OOM_KILL = 47,
	PGMIGRATE_SUCCESS = 48,
	PGMIGRATE_FAIL = 49,
	THP_MIGRATION_SUCCESS = 50,
	THP_MIGRATION_FAIL = 51,
	THP_MIGRATION_SPLIT = 52,
	COMPACTMIGRATE_SCANNED = 53,
	COMPACTFREE_SCANNED = 54,
	COMPACTISOLATED = 55,
	COMPACTSTALL = 56,
	COMPACTFAIL = 57,
	COMPACTSUCCESS = 58,
	KCOMPACTD_WAKE = 59,
	KCOMPACTD_MIGRATE_SCANNED = 60,
	KCOMPACTD_FREE_SCANNED = 61,
	UNEVICTABLE_PGCULLED = 62,
	UNEVICTABLE_PGSCANNED = 63,
	UNEVICTABLE_PGRESCUED = 64,
	UNEVICTABLE_PGMLOCKED = 65,
	UNEVICTABLE_PGMUNLOCKED = 66,
	UNEVICTABLE_PGCLEARED = 67,
	UNEVICTABLE_PGSTRANDED = 68,
	SWAP_RA = 69,
	SWAP_RA_HIT = 70,
	SWPIN_ZERO = 71,
	SWPOUT_ZERO = 72,
	ZSWPIN = 73,
	ZSWPOUT = 74,
	ZSWPWB = 75,
	DIRECT_MAP_LEVEL2_SPLIT = 76,
	DIRECT_MAP_LEVEL3_SPLIT = 77,
	NR_VM_EVENT_ITEMS = 78,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_flags {
	VMG_FLAG_DEFAULT = 0,
	VMG_FLAG_JUST_EXPAND = 1,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vmx_feature_leafs {
	MISC_FEATURES = 0,
	PRIMARY_CTLS = 1,
	SECONDARY_CTLS = 2,
	TERTIARY_CTLS_LOW = 3,
	TERTIARY_CTLS_HIGH = 4,
	NR_VMX_FEATURE_WORDS = 5,
};

enum vmx_l1d_flush_state {
	VMENTER_L1D_FLUSH_AUTO = 0,
	VMENTER_L1D_FLUSH_NEVER = 1,
	VMENTER_L1D_FLUSH_COND = 2,
	VMENTER_L1D_FLUSH_ALWAYS = 3,
	VMENTER_L1D_FLUSH_EPT_DISABLED = 4,
	VMENTER_L1D_FLUSH_NOT_REQUIRED = 5,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum wd_read_status {
	WD_READ_SUCCESS = 0,
	WD_READ_UNSTABLE = 1,
	WD_READ_SKIP = 2,
};

enum which_selector {
	FS = 0,
	GS = 1,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum wiphy_opmode_flag {
	STA_OPMODE_MAX_BW_CHANGED = 1,
	STA_OPMODE_SMPS_MODE_CHANGED = 2,
	STA_OPMODE_N_SS_CHANGED = 4,
};

enum wiphy_params_flags {
	WIPHY_PARAM_RETRY_SHORT = 1,
	WIPHY_PARAM_RETRY_LONG = 2,
	WIPHY_PARAM_FRAG_THRESHOLD = 4,
	WIPHY_PARAM_RTS_THRESHOLD = 8,
	WIPHY_PARAM_COVERAGE_CLASS = 16,
	WIPHY_PARAM_DYN_ACK = 32,
	WIPHY_PARAM_TXQ_LIMIT = 64,
	WIPHY_PARAM_TXQ_MEMORY_LIMIT = 128,
	WIPHY_PARAM_TXQ_QUANTUM = 256,
};

enum wiphy_vendor_command_flags {
	WIPHY_VENDOR_CMD_NEED_WDEV = 1,
	WIPHY_VENDOR_CMD_NEED_NETDEV = 2,
	WIPHY_VENDOR_CMD_NEED_RUNNING = 4,
};

enum wiphy_wowlan_support_flags {
	WIPHY_WOWLAN_ANY = 1,
	WIPHY_WOWLAN_MAGIC_PKT = 2,
	WIPHY_WOWLAN_DISCONNECT = 4,
	WIPHY_WOWLAN_SUPPORTS_GTK_REKEY = 8,
	WIPHY_WOWLAN_GTK_REKEY_FAILURE = 16,
	WIPHY_WOWLAN_EAP_IDENTITY_REQ = 32,
	WIPHY_WOWLAN_4WAY_HANDSHAKE = 64,
	WIPHY_WOWLAN_RFKILL_RELEASE = 128,
	WIPHY_WOWLAN_NET_DETECT = 256,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 300000,
	MAYDAY_INITIAL_TIMEOUT = 10,
	MAYDAY_INTERVAL = 100,
	CREATE_COOLDOWN = 1000,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 8192,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x86_hardware_subarch {
	X86_SUBARCH_PC = 0,
	X86_SUBARCH_LGUEST = 1,
	X86_SUBARCH_XEN = 2,
	X86_SUBARCH_INTEL_MID = 3,
	X86_SUBARCH_CE4100 = 4,
	X86_NR_SUBARCHS = 5,
};

enum x86_hypervisor_type {
	X86_HYPER_NATIVE = 0,
	X86_HYPER_VMWARE = 1,
	X86_HYPER_MS_HYPERV = 2,
	X86_HYPER_XEN_PV = 3,
	X86_HYPER_XEN_HVM = 4,
	X86_HYPER_KVM = 5,
	X86_HYPER_JAILHOUSE = 6,
	X86_HYPER_ACRN = 7,
};

enum x86_legacy_i8042_state {
	X86_LEGACY_I8042_PLATFORM_ABSENT = 0,
	X86_LEGACY_I8042_FIRMWARE_ABSENT = 1,
	X86_LEGACY_I8042_EXPECTED_PRESENT = 2,
};

enum x86_pf_error_code {
	X86_PF_PROT = 1,
	X86_PF_WRITE = 2,
	X86_PF_USER = 4,
	X86_PF_RSVD = 8,
	X86_PF_INSTR = 16,
	X86_PF_PK = 32,
	X86_PF_SHSTK = 64,
	X86_PF_SGX = 32768,
	X86_PF_RMP = 2147483648,
};

enum x86_regset_32 {
	REGSET32_GENERAL = 0,
	REGSET32_FP = 1,
	REGSET32_XFP = 2,
	REGSET32_XSTATE = 3,
	REGSET32_TLS = 4,
	REGSET32_IOPERM = 5,
};

enum x86_regset_64 {
	REGSET64_GENERAL = 0,
	REGSET64_FP = 1,
	REGSET64_IOPERM = 2,
	REGSET64_XSTATE = 3,
	REGSET64_SSP = 4,
};

enum x86_topology_cpu_type {
	TOPO_CPU_TYPE_PERFORMANCE = 0,
	TOPO_CPU_TYPE_EFFICIENCY = 1,
	TOPO_CPU_TYPE_UNKNOWN = 2,
};

enum x86_topology_domains {
	TOPO_SMT_DOMAIN = 0,
	TOPO_CORE_DOMAIN = 1,
	TOPO_MODULE_DOMAIN = 2,
	TOPO_TILE_DOMAIN = 3,
	TOPO_DIE_DOMAIN = 4,
	TOPO_DIEGRP_DOMAIN = 5,
	TOPO_PKG_DOMAIN = 6,
	TOPO_MAX_DOMAIN = 7,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xfeature {
	XFEATURE_FP = 0,
	XFEATURE_SSE = 1,
	XFEATURE_YMM = 2,
	XFEATURE_BNDREGS = 3,
	XFEATURE_BNDCSR = 4,
	XFEATURE_OPMASK = 5,
	XFEATURE_ZMM_Hi256 = 6,
	XFEATURE_Hi16_ZMM = 7,
	XFEATURE_PT_UNIMPLEMENTED_SO_FAR = 8,
	XFEATURE_PKRU = 9,
	XFEATURE_PASID = 10,
	XFEATURE_CET_USER = 11,
	XFEATURE_CET_KERNEL_UNUSED = 12,
	XFEATURE_RSRVD_COMP_13 = 13,
	XFEATURE_RSRVD_COMP_14 = 14,
	XFEATURE_LBR = 15,
	XFEATURE_RSRVD_COMP_16 = 16,
	XFEATURE_XTILE_CFG = 17,
	XFEATURE_XTILE_DATA = 18,
	XFEATURE_MAX = 19,
};

enum xfer_buf_dir {
	TO_XFER_BUF = 0,
	FROM_XFER_BUF = 1,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xmp_state {
	STATE_INACTIVE___9 = 0,
	STATE_LEADER_PULSE = 1,
	STATE_NIBBLE_SPACE = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xstate_copy_mode {
	XSTATE_COPY_FP = 0,
	XSTATE_COPY_FX = 1,
	XSTATE_COPY_XSAVE = 2,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_FREE_CMA_PAGES = 9,
	NR_VM_ZONE_STAT_ITEMS = 10,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	__MAX_NR_ZONES = 4,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zpool_mapmode {
	ZPOOL_MM_RW = 0,
	ZPOOL_MM_RO = 1,
	ZPOOL_MM_WO = 2,
	ZPOOL_MM_DEFAULT = 0,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

typedef _Bool bool;

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 compat_int_t;

typedef s32 compat_ssize_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef int initcall_entry_t;

typedef int insn_value_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef const int tracepoint_ptr_t;

typedef long __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long intptr_t;

typedef long mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long __s64;

typedef __s64 Elf64_Sxword;

typedef long long __kernel_loff_t;

typedef long long __kernel_time64_t;

typedef __s64 s64;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long qsize_t;

typedef __s64 time64_t;

typedef short __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef signed char __s8;

typedef __s8 s8;

typedef unsigned __int128 __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef u8 efi_bool_t;

typedef unsigned char insn_byte_t;

typedef u8 kprobe_opcode_t;

typedef __u8 mtrr_type;

typedef u8 retpoline_thunk_t[32];

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef u8 uprobe_opcode_t;

typedef __u8 virtio_net_ctrl_ack;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int UHWtype;

typedef __u32 __be32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 codel_time_t;

typedef __u32 comp2_t;

typedef u32 compat_caddr_t;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef unsigned int ieee80211_rx_result;

typedef unsigned int ieee80211_tx_result;

typedef unsigned int insn_attr_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef unsigned int iwl_ucode_tlv_api_t;

typedef unsigned int iwl_ucode_tlv_capa_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[92];

typedef __u32 nvme_submit_flags_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 phys_cpuid_t;

typedef __kernel_uid32_t projid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef unsigned long __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t HUF_CElt;

typedef unsigned long mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef unsigned long __kernel_old_dev_t;

typedef __kernel_ulong_t aio_context_t;

typedef unsigned long efi_status_t;

typedef unsigned long elf_greg_t;

typedef elf_greg_t elf_gregset_t[27];

typedef __kernel_ulong_t ino_t;

typedef unsigned long irq_hw_number_t;

typedef unsigned long kernel_ulong_t;

typedef unsigned long kimage_entry_t;

typedef unsigned long mce_banks_t[1];

typedef mpi_limb_t *mpi_ptr_t;

typedef unsigned long netmem_ref;

typedef unsigned long old_sigset_t;

typedef unsigned long p4dval_t;

typedef unsigned long perf_trace_t[1024];

typedef unsigned long pgdval_t;

typedef unsigned long pgprotval_t;

typedef unsigned long pmdval_t;

typedef unsigned long pte_marker;

typedef unsigned long pteval_t;

typedef unsigned long pudval_t;

typedef unsigned long uLong;

typedef unsigned long uintptr_t;

typedef unsigned long ulg;

typedef unsigned long ulong;

typedef unsigned long vm_flags_t;

typedef unsigned long long __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef U64 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_integer;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef unsigned long long cycles_t;

typedef u64 dma_addr_t;

typedef unsigned long long ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 hfn_t;

typedef u64 hpa_t;

typedef u64 io_req_flags_t;

typedef hfn_t kvm_pfn_t;

typedef unsigned long long llu;

typedef u64 netdev_features_t;

typedef u64 pci_bus_addr_t;

typedef u64 phys_addr_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 unative_t;

typedef u64 upf_t;

typedef unsigned short __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef unsigned short ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef unsigned short __kernel_gid16_t;

typedef unsigned short __kernel_sa_family_t;

typedef unsigned short __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef __u16 bitmap_counter_t;

typedef u16 blk_short_t;

typedef __u16 comp_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef unsigned short pci_bus_flags_t;

typedef unsigned short pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef unsigned short u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef __u16 uio_meta_flags_t;

typedef unsigned short umode_t;

typedef unsigned short ushort;

typedef u16 wchar_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short ncount[256];
	FSE_DTable dtable[0];
} FSE_DecompressWksp;

typedef struct {
	unsigned short newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	rankValCol_t rankVal[12];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16 base;
	U16 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

typedef struct {
	int counter;
} atomic_t;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct dentry;

struct file;

typedef struct {
	struct list_head list;
	unsigned long flags;
	int offset;
	int size;
	char *magic;
	char *mask;
	const char *interpreter;
	char *name;
	struct dentry *dentry;
	struct file *interp_file;
	refcount_t users;
} Node;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

struct seqDef_s;

typedef struct seqDef_s seqDef;

typedef struct {
	seqDef *sequencesStart;
	seqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} seqStore_t;

typedef struct {
	symbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	symbolEncodingType_e llType;
	symbolEncodingType_e ofType;
	symbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	seqStore_t fullSeqStoreChunk;
	seqStore_t firstHalfSeqStore;
	seqStore_t secondHalfSeqStore;
	seqStore_t currSeqStore;
	seqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_paramSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} rawSeqStore_t;

struct ZSTD_matchState_t;

typedef struct ZSTD_matchState_t ZSTD_matchState_t;

struct ZSTD_matchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	U16 *tagTable;
	U32 hashCache[8];
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	U32 forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_matchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const rawSeqStore_t *ldmSeqStore;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_matchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	unsigned long long frameContentSize;
	unsigned long long windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ZSTD_frameHeader;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	unsigned long long ingested;
	unsigned long long consumed;
	unsigned long long produced;
	unsigned long long flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t compressedSize;
	unsigned long long decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	rawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_sequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_sequencePosition;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	unsigned long fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

struct page;

typedef union {
	unsigned long addr;
	struct page *page;
	dma_addr_t dma;
} addr_conv_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct {
	__be64 a;
	__be64 b;
} be128;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void __attribute__((btf_type_tag("user"))) *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	int *lock;
	unsigned long flags;
} class_core_lock_t;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

typedef struct {
	void *lock;
} class_irq_t;

typedef struct {
	void *lock;
	unsigned long flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_jump_label_lock_t;

typedef struct {
	void *lock;
} class_preempt_notrace_t;

typedef struct {
	void *lock;
} class_preempt_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	unsigned long flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	void *lock;
} class_rcu_tasks_trace_t;

struct pin_cookie {};

struct rq_flags {
	unsigned long flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	unsigned long flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	unsigned short val;
} code;

typedef struct {
	unsigned long bits[1];
} dma_cap_mask_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	unsigned long *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_status_t (*get_time)(efi_time_t *, efi_time_cap_t *);
		efi_status_t (*set_time)(efi_time_t *);
		efi_status_t (*get_wakeup_time)(efi_bool_t *, efi_bool_t *, efi_time_t *);
		efi_status_t (*set_wakeup_time)(efi_bool_t, efi_time_t *);
		efi_status_t (*set_virtual_address_map)(unsigned long, unsigned long, u32, efi_memory_desc_t *);
		void *convert_pointer;
		efi_status_t (*get_variable)(efi_char16_t *, efi_guid_t *, u32 *, unsigned long *, void *);
		efi_status_t (*get_next_variable)(unsigned long *, efi_char16_t *, efi_guid_t *);
		efi_status_t (*set_variable)(efi_char16_t *, efi_guid_t *, u32, unsigned long, void *);
		efi_status_t (*get_next_high_mono_count)(u32 *);
		void (*reset_system)(int, efi_status_t, unsigned long, efi_char16_t *);
		efi_status_t (*update_capsule)(efi_capsule_header_t **, unsigned long, unsigned long);
		efi_status_t (*query_capsule_caps)(efi_capsule_header_t **, unsigned long, u64 *, int *);
		efi_status_t (*query_variable_info)(u32, u64 *, u64 *, u64 *);
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

typedef struct {
	efi_table_hdr_t hdr;
	u64 fw_vendor;
	u32 fw_revision;
	u32 __pad1;
	u64 con_in_handle;
	u64 con_in;
	u64 con_out_handle;
	u64 con_out;
	u64 stderr_handle;
	u64 stderr;
	u64 runtime;
	u64 boottime;
	u32 nr_tables;
	u32 __pad2;
	u64 tables;
} efi_system_table_64_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		unsigned long fw_vendor;
		u32 fw_revision;
		unsigned long con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		unsigned long con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		unsigned long stderr_handle;
		unsigned long stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		unsigned long nr_tables;
		unsigned long tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	unsigned long *in;
	unsigned long *out;
	unsigned long *ex;
	unsigned long *res_in;
	unsigned long *res_out;
	unsigned long *res_ex;
} fd_set_bits;

typedef struct {
	atomic64_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	unsigned short lmi;
	unsigned short dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		unsigned long counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	unsigned long v;
} freeptr_t;

typedef struct {
	unsigned long key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int __nmi_count;
	unsigned int apic_timer_irqs;
	unsigned int irq_spurious_count;
	unsigned int icr_read_retry_count;
	unsigned int x86_platform_ipis;
	unsigned int apic_perf_irqs;
	unsigned int apic_irq_work_irqs;
	unsigned int irq_resched_count;
	unsigned int irq_call_count;
	unsigned int irq_tlb_count;
	unsigned int irq_thermal_count;
	unsigned int irq_threshold_count;
	unsigned int irq_deferred_error_count;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_paramSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64 rolling;
	U64 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {} lockdep_map_p;

struct optimistic_spin_queue {
	atomic_t tail;
};

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct ldt_struct;

struct vdso_image;

typedef struct {
	u64 ctx_id;
	atomic64_t tlb_gen;
	struct rw_semaphore ldt_usr_sem;
	struct ldt_struct *ldt;
	unsigned long flags;
	struct mutex lock;
	void __attribute__((btf_type_tag("user"))) *vdso;
	const struct vdso_image *vdso_image;
	atomic_t perf_rdpmc_allowed;
	u16 pkey_allocation_map;
	s16 execute_only_pkey;
} mm_context_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	unsigned long bits[16];
} nodemask_t;

typedef struct {
	p4dval_t p4d;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u64 val;
} pfn_t;

typedef struct {
	pgdval_t pgd;
} pgd_t;

typedef struct {
	pmdval_t pmd;
} pmd_t;

typedef struct {
	unsigned long bits[4];
} pnp_irq_mask_t;

struct net;

typedef struct {
	struct net __attribute__((btf_type_tag("rcu"))) *net;
} possible_net_t;

typedef struct {
	pteval_t pte;
} pte_t;

typedef struct {
	pudval_t pud;
} pud_t;

typedef struct {
	unsigned short encoding;
	unsigned short parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char __attribute__((btf_type_tag("user"))) *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

struct encoded_page;

typedef union {
	struct page **pages;
	struct folio **folios;
	struct encoded_page **encoded_pages;
} release_pages_arg;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	unsigned long sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	unsigned long val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	unsigned short loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	unsigned short loopback;
	unsigned int slot_map;
} te1_settings;

struct mm_struct;

typedef struct {
	struct mm_struct *mm;
} temp_mm_state_t;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	unsigned short dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

typedef struct {
	__u8 b[16];
} uuid_le;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_frameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

union IO_APIC_reg_00 {
	u32 raw;
	struct {
		u32 __reserved_2: 14;
		u32 LTS: 1;
		u32 delivery_type: 1;
		u32 __reserved_1: 8;
		u32 ID: 8;
	} bits;
};

union IO_APIC_reg_01 {
	u32 raw;
	struct {
		u32 version: 8;
		u32 __reserved_2: 7;
		u32 PRQ: 1;
		u32 entries: 8;
		u32 __reserved_1: 8;
	} bits;
};

union IO_APIC_reg_02 {
	u32 raw;
	struct {
		u32 __reserved_2: 24;
		u32 arbitration: 4;
		u32 __reserved_1: 4;
	} bits;
};

union IO_APIC_reg_03 {
	u32 raw;
	struct {
		u32 boot_DT: 1;
		u32 __reserved_1: 31;
	} bits;
};

struct IO_APIC_route_entry {
	union {
		struct {
			u64 vector: 8;
			u64 delivery_mode: 3;
			u64 dest_mode_logical: 1;
			u64 delivery_status: 1;
			u64 active_low: 1;
			u64 irr: 1;
			u64 is_level: 1;
			u64 masked: 1;
			u64 reserved_0: 15;
			u64 reserved_1: 17;
			u64 virt_destid_8_14: 7;
			u64 destid_0_7: 8;
		};
		struct {
			u64 ir_shared_0: 8;
			u64 ir_zero: 3;
			u64 ir_index_15: 1;
			u64 ir_shared_1: 5;
			u64 ir_reserved_0: 31;
			u64 ir_format: 1;
			u64 ir_index_0_14: 15;
		};
		struct {
			u64 w1: 32;
			u64 w2: 32;
		};
	};
};

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table __attribute__((btf_type_tag("rcu"))) *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator __attribute__((btf_type_tag("rcu"))) *rate_est;
	struct gnet_stats_basic_sync __attribute__((btf_type_tag("percpu"))) *cpu_bstats;
	struct gnet_stats_queue __attribute__((btf_type_tag("percpu"))) *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	unsigned long state;
	unsigned long state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long privdata[0];
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, unsigned long, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, unsigned long);
	void (*qlen_notify)(struct Qdisc *, unsigned long);
	unsigned long (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, unsigned long *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, unsigned long, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, unsigned long, struct netlink_ext_ack *);
	unsigned long (*bind_tcf)(struct Qdisc *, unsigned long, u32);
	void (*unbind_tcf)(struct Qdisc *, unsigned long);
	int (*dump)(struct Qdisc *, unsigned long, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, unsigned long, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct RR_CL_s {
	__u8 location[8];
};

struct RR_NM_s {
	__u8 flags;
	char name[0];
};

struct RR_PL_s {
	__u8 location[8];
};

struct RR_PN_s {
	__u8 dev_high[8];
	__u8 dev_low[8];
};

struct RR_PX_s {
	__u8 mode[8];
	__u8 n_links[8];
	__u8 uid[8];
	__u8 gid[8];
};

struct RR_RR_s {
	__u8 flags[1];
};

struct SL_component {
	__u8 flags;
	__u8 len;
	__u8 text[0];
};

struct RR_SL_s {
	__u8 flags;
	struct SL_component link;
};

struct stamp {
	__u8 time[7];
};

struct RR_TF_s {
	__u8 flags;
	struct stamp times[0];
};

struct RR_ZF_s {
	__u8 algorithm[2];
	__u8 parms[2];
	__u8 real_size[8];
};

struct RxDesc {
	__le32 opts1;
	__le32 opts2;
	__le64 addr;
};

struct SU_CE_s {
	__u8 extent[8];
	__u8 offset[8];
	__u8 size[8];
};

struct SU_ER_s {
	__u8 len_id;
	__u8 len_des;
	__u8 len_src;
	__u8 ext_ver;
	__u8 data[0];
};

struct SU_SP_s {
	__u8 magic[2];
	__u8 skip;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	unsigned long __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct device;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool async_in_progress: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct dev_iommu;

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct dev_msi_info msi;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_skip_sync: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	unsigned long last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	unsigned short max_cmd_len;
	int this_id;
	int can_queue;
	short cmd_per_lun;
	unsigned short sg_tablesize;
	unsigned short sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	unsigned long dma_boundary;
	unsigned long virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	unsigned int no_highmem: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	unsigned long base;
	unsigned long io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	unsigned long hostdata[0];
};

struct TxDesc {
	__le32 opts1;
	__le32 opts2;
	__le64 addr;
};

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_paramSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_sequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_paramSwitch_e useBlockSplitter;
	ZSTD_paramSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSize;
	unsigned long long pledgedSrcSizePlusOne;
	unsigned long long consumedSrcSize;
	unsigned long long producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	seqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	rawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	U32 *entropyWorkspace;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	ZSTD_matchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_paramSwitch_e useRowMatchFinder;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_frameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	int bmi2;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

struct __aio_sigset {
	const sigset_t __attribute__((btf_type_tag("user"))) *sigmask;
	size_t sigsetsize;
};

struct fred_cs {
	u64 cs: 16;
	u64 sl: 2;
	u64 wfe: 1;
};

struct fred_ss {
	u64 ss: 16;
	u64 sti: 1;
	u64 swevent: 1;
	u64 nmi: 1;
	int: 13;
	u64 vector: 8;
	short: 8;
	u64 type: 4;
	char: 4;
	u64 enclave: 1;
	u64 lm: 1;
	u64 nested: 1;
	char: 1;
	u64 insnlen: 4;
};

struct pt_regs {
	unsigned long r15;
	unsigned long r14;
	unsigned long r13;
	unsigned long r12;
	unsigned long bp;
	unsigned long bx;
	unsigned long r11;
	unsigned long r10;
	unsigned long r9;
	unsigned long r8;
	unsigned long ax;
	unsigned long cx;
	unsigned long dx;
	unsigned long si;
	unsigned long di;
	unsigned long orig_ax;
	unsigned long ip;
	union {
		u16 cs;
		u64 csx;
		struct fred_cs fred_cs;
	};
	unsigned long flags;
	unsigned long sp;
	union {
		u16 ss;
		u64 ssx;
		struct fred_ss fred_ss;
	};
};

struct __arch_ftrace_regs {
	struct pt_regs regs;
};

struct __arch_relative_insn {
	u8 op;
	s32 raddr;
} __attribute__((packed));

struct __bridge_info {
	__u64 designated_root;
	__u64 bridge_id;
	__u32 root_path_cost;
	__u32 max_age;
	__u32 hello_time;
	__u32 forward_delay;
	__u32 bridge_max_age;
	__u32 bridge_hello_time;
	__u32 bridge_forward_delay;
	__u8 topology_change;
	__u8 topology_change_detected;
	__u8 root_port;
	__u8 stp_enabled;
	__u32 ageing_time;
	__u32 gc_interval;
	__u32 hello_timer_value;
	__u32 tcn_timer_value;
	__u32 topology_change_timer_value;
	__u32 gc_timer_value;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
};

struct __fat_dirent {
	long d_ino;
	__kernel_off_t d_off;
	unsigned short d_reclen;
	char d_name[256];
};

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
};

struct __fdb_entry {
	__u8 mac_addr[6];
	__u8 port_no;
	__u8 is_local;
	__u32 ageing_timer_value;
	__u8 port_hi;
	__u8 pad0;
	__u16 unused;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long offset;
	long long freq;
	long long maxerror;
	long long esterror;
	int status;
	long long constant;
	long long precision;
	long long tolerance;
	struct __kernel_timex_timeval time;
	long long tick;
	long long ppsfreq;
	long long jitter;
	int shift;
	long long stabil;
	long long jitcnt;
	long long calcnt;
	long long errcnt;
	long long stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct __large_struct {
	unsigned long buf[100];
};

struct nft_payload {
	enum nft_payload_bases base: 8;
	u8 offset;
	u8 len;
	u8 dreg;
};

struct nft_meta {
	enum nft_meta_keys key: 8;
	u8 len;
	union {
		u8 dreg;
		u8 sreg;
	};
};

struct nft_expr_ops;

struct __nft_expr {
	const struct nft_expr_ops *ops;
	union {
		struct nft_payload payload;
		struct nft_meta meta;
	};
};

struct __old_kernel_stat {
	unsigned short st_dev;
	unsigned short st_ino;
	unsigned short st_mode;
	unsigned short st_nlink;
	unsigned short st_uid;
	unsigned short st_gid;
	unsigned short st_rdev;
	unsigned int st_size;
	unsigned int st_atime;
	unsigned int st_mtime;
	unsigned int st_ctime;
};

struct __port_info {
	__u64 designated_root;
	__u64 designated_bridge;
	__u16 port_id;
	__u16 designated_port;
	__u32 path_cost;
	__u32 designated_cost;
	__u8 state;
	__u8 top_change_ack;
	__u8 config_pending;
	__u8 unused0;
	__u32 message_age_timer_value;
	__u32 forward_delay_timer_value;
	__u32 hold_timer_value;
};

union sigval {
	int sival_int;
	void __attribute__((btf_type_tag("user"))) *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void __attribute__((btf_type_tag("user"))) *_addr;
		union {
			int _trapno;
			short _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void __attribute__((btf_type_tag("user"))) *_lower;
				void __attribute__((btf_type_tag("user"))) *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				unsigned long _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long _band;
		int _fd;
	} _sigpoll;
	struct {
		void __attribute__((btf_type_tag("user"))) *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
};

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
};

union __u128_halves {
	u128 full;
	struct {
		u64 low;
		u64 high;
	};
};

struct __una_u32 {
	u32 x;
};

struct inode;

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct __attribute__((btf_type_tag("user"))) *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __va_list_tag {
	unsigned int gp_offset;
	unsigned int fp_offset;
	void *overflow_arg_area;
	void *reg_save_area;
};

typedef __builtin_va_list va_list;

struct net_device;

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

struct _cache_table {
	unsigned char descriptor;
	char cache_type;
	short size;
};

union _cpuid4_leaf_eax {
	struct {
		enum _cache_type type: 5;
		unsigned int level: 3;
		unsigned int is_self_initializing: 1;
		unsigned int is_fully_associative: 1;
		unsigned int reserved: 4;
		unsigned int num_threads_sharing: 12;
		unsigned int num_cores_on_die: 6;
	} split;
	u32 full;
};

union _cpuid4_leaf_ebx {
	struct {
		unsigned int coherency_line_size: 12;
		unsigned int physical_line_partition: 10;
		unsigned int ways_of_associativity: 10;
	} split;
	u32 full;
};

union _cpuid4_leaf_ecx {
	struct {
		unsigned int number_of_sets: 32;
	} split;
	u32 full;
};

struct amd_northbridge;

struct _cpuid4_info_regs {
	union _cpuid4_leaf_eax eax;
	union _cpuid4_leaf_ebx ebx;
	union _cpuid4_leaf_ecx ecx;
	unsigned int id;
	unsigned long size;
	struct amd_northbridge *nb;
};

struct jump_entry;

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		unsigned long type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

struct static_key_true {
	struct static_key key;
};

struct static_key_false {
	struct static_key key;
};

struct _ddebug {
	const char *modname;
	const char *function;
	const char *filename;
	const char *format;
	unsigned int lineno: 18;
	unsigned int class_id: 6;
	unsigned int flags: 8;
	union {
		struct static_key_true dd_key_true;
		struct static_key_false dd_key_false;
	} key;
};

struct ddebug_class_map;

struct _ddebug_info {
	struct _ddebug *descs;
	struct ddebug_class_map *classes;
	unsigned int num_descs;
	unsigned int num_classes;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _fpx_sw_bytes {
	__u32 magic1;
	__u32 extended_size;
	__u64 xfeatures;
	__u32 xstate_size;
	__u32 padding[7];
};

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed));

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct timer_list {
	struct hlist_node entry;
	unsigned long expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
};

struct _thermal_state {
	u64 next_check;
	u64 last_interrupt_time;
	struct delayed_work therm_work;
	unsigned long count;
	unsigned long last_count;
	unsigned long max_time_ms;
	unsigned long total_time_ms;
	bool rate_control_active;
	bool new_event;
	u8 level;
	u8 sample_index;
	u8 sample_count;
	u8 average;
	u8 baseline_temp;
	u8 temp_samples[3];
};

struct _tlb_table {
	unsigned char descriptor;
	char tlb_type;
	unsigned int entries;
	char info[128];
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

struct ac6_iter_state {
	struct seq_net_private p;
	struct net_device *dev;
};

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
};

struct acct {
	char ac_flag;
	char ac_version;
	__u16 ac_uid16;
	__u16 ac_gid16;
	__u16 ac_tty;
	__u32 ac_btime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_etime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	__u16 ac_ahz;
	__u32 ac_exitcode;
	char ac_comm[17];
	__u8 ac_etime_hi;
	__u16 ac_etime_lo;
	__u32 ac_uid;
	__u32 ac_gid;
};

typedef struct acct acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct scatterlist;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	void (*dst_free)(struct scatterlist *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	unsigned int reqsize;
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int slen;
	unsigned int dlen;
	u32 flags;
	void *__ctx[0];
};

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	void (*set_charged)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, unsigned long, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block __attribute__((btf_type_tag("rcu"))) *next;
	int priority;
};

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	unsigned long long state;
	struct notifier_block battery_nb;
};

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
};

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
};

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
};

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
};

struct acpi_battery {
	struct mutex lock;
	struct mutex sysfs_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	unsigned long update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	unsigned long flags;
};

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
};

struct acpi_bit_register_info {
	u8 parent_register;
	u8 bit_position;
	u16 access_bit_mask;
};

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct input_dev;

struct acpi_button {
	unsigned int type;
	struct input_dev *input;
	char phys[32];
	unsigned long pushed;
	int last_state;
	ktime_t last_time;
	bool suspended;
	bool lid_state_initialized;
};

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed));

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
};

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct address_space;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*read_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
};

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
};

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
};

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
};

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
};

struct acpi_data_table_mapping {
	void *pointer;
};

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
};

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
};

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
};

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
};

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
};

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
};

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
};

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
};

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
};

union acpi_name_union {
	u32 integer;
	char ascii[4];
};

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
};

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
};

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
};

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
};

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	char *path;
	u8 *data;
	u32 length;
	u32 name;
};

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
};

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
};

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
};

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct acpi_dev_match_info {
	struct acpi_device_id hid[2];
	const char *uid;
	s64 hrv;
};

struct acpi_dev_walk_context {
	int (*fn)(struct acpi_device *, void *);
	void *data;
};

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
};

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
};

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
};

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
};

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
};

struct acpi_device_power_state {
	struct list_head resources;
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} flags;
	int power;
	int latency;
};

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
};

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
};

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
};

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
};

struct acpi_device_perf_flags {
	u8 reserved: 8;
};

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
};

struct proc_dir_entry;

struct acpi_device_dir {
	struct proc_dir_entry *entry;
};

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_device_software_nodes;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	struct acpi_device_software_nodes *swnodes;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void __attribute__((btf_type_tag("rcu"))) *xa_head;
};

struct ida {
	struct xarray xa;
};

struct acpi_device_bus_id {
	const char *bus_id;
	struct ida instance_ida;
	struct list_head node;
};

struct acpi_pnp_device_id {
	u32 length;
	char *string;
};

struct acpi_pnp_device_id_list {
	u32 count;
	u32 list_size;
	struct acpi_pnp_device_id ids[0];
};

struct acpi_device_info {
	u32 info_size;
	u32 name;
	acpi_object_type type;
	u8 param_count;
	u16 valid;
	u8 flags;
	u8 highest_dstates[4];
	u8 lowest_dstates[5];
	u64 address;
	struct acpi_pnp_device_id hardware_id;
	struct acpi_pnp_device_id unique_id;
	struct acpi_pnp_device_id class_code;
	struct acpi_pnp_device_id_list compatible_id_list;
};

typedef int (*acpi_op_add)(struct acpi_device *);

typedef void (*acpi_op_remove)(struct acpi_device *);

typedef void (*acpi_op_notify)(struct acpi_device *, u32);

struct acpi_device_ops {
	acpi_op_add add;
	acpi_op_remove remove;
	acpi_op_notify notify;
};

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} flags;
	u8 power;
	u8 performance;
	int latency;
};

struct acpi_device_physical_node {
	struct list_head node;
	struct device *dev;
	unsigned int node_id;
	bool put_online: 1;
};

struct acpi_device_properties {
	struct list_head list;
	const guid_t *guid;
	union acpi_object *properties;
	void **bufs;
};

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} value;
	};
};

struct software_node;

struct software_node_ref_args {
	const struct software_node *node;
	unsigned int nargs;
	u64 args[8];
};

struct acpi_device_software_node_port {
	char port_name[9];
	u32 data_lanes[8];
	u32 lane_polarities[9];
	u64 link_frequencies[8];
	unsigned int port_nr;
	bool crs_csi2_local;
	struct property_entry port_props[2];
	struct property_entry ep_props[8];
	struct software_node_ref_args remote_ep[1];
};

struct acpi_device_software_nodes {
	struct property_entry dev_props[6];
	struct software_node *nodes;
	const struct software_node **nodeptrs;
	struct acpi_device_software_node_port *ports;
	unsigned int num_ports;
};

struct acpi_table_desc;

struct acpi_evaluate_info;

struct acpi_device_walk_info {
	struct acpi_table_desc *table_desc;
	struct acpi_evaluate_info *evaluate_info;
	u32 device_count;
	u32 num_STA;
	u32 num_INI;
};

struct of_device_id;

struct dev_pm_ops;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

struct acpi_driver {
	char name[80];
	char class[80];
	const struct acpi_device_id *ids;
	unsigned int flags;
	struct acpi_device_ops ops;
	struct device_driver drv;
};

struct transaction;

struct acpi_ec {
	acpi_handle handle;
	int gpe;
	int irq;
	unsigned long command_addr;
	unsigned long data_addr;
	bool global_lock;
	unsigned long flags;
	unsigned long reference_count;
	struct mutex mutex;
	wait_queue_head_t wait;
	struct list_head list;
	struct transaction *curr;
	spinlock_t lock;
	struct work_struct work;
	unsigned long timestamp;
	enum acpi_ec_event_state event_state;
	unsigned int events_to_process;
	unsigned int events_in_progress;
	unsigned int queries_in_progress;
	bool busy_polling;
	unsigned int polling_guard;
};

struct transaction {
	const u8 *wdata;
	u8 *rdata;
	unsigned short irq_count;
	u8 command;
	u8 wi;
	u8 ri;
	u8 wlen;
	u8 rlen;
	u8 flags;
};

struct acpi_ec_query_handler;

struct acpi_ec_query {
	struct transaction transaction;
	struct work_struct work;
	struct acpi_ec_query_handler *handler;
	struct acpi_ec *ec;
};

typedef int (*acpi_ec_query_func)(void *);

struct acpi_ec_query_handler {
	struct list_head node;
	acpi_ec_query_func func;
	acpi_handle handle;
	void *data;
	u8 query_bit;
	struct kref kref;
};

union acpi_predefined_info;

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
};

struct acpi_exception_info {
	char *name;
};

struct acpi_fadt_info {
	const char *name;
	u16 address64;
	u16 address32;
	u16 length;
	u8 default_length;
	u8 flags;
};

struct acpi_generic_address;

struct acpi_fadt_pm_info {
	struct acpi_generic_address *target;
	u16 source;
	u8 register_num;
};

struct acpi_fan_fif {
	u8 revision;
	u8 fine_grain_ctrl;
	u8 step_size;
	u8 low_speed_notification;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct acpi_fan_fps;

struct thermal_cooling_device;

struct acpi_fan {
	bool acpi4;
	struct acpi_fan_fif fif;
	struct acpi_fan_fps *fps;
	int fps_count;
	struct thermal_cooling_device *cdev;
	struct device_attribute fst_speed;
	struct device_attribute fine_grain_control;
};

struct acpi_fan_fps {
	u64 control;
	u64 trip_point;
	u64 speed;
	u64 noise_level;
	u64 power;
	char name[20];
	struct device_attribute dev_attr;
};

struct acpi_fan_fst {
	u64 revision;
	u64 control;
	u64 speed;
};

struct acpi_ffh_info {
	u64 offset;
	u64 length;
};

typedef u32 (*acpi_event_handler)(void *);

struct acpi_fixed_event_handler {
	acpi_event_handler handler;
	void *context;
};

struct acpi_fixed_event_info {
	u8 status_register_id;
	u8 enable_register_id;
	u16 status_bit_mask;
	u16 enable_bit_mask;
};

struct acpi_ged_device {
	struct device *dev;
	struct list_head event_list;
};

struct acpi_ged_event {
	struct list_head node;
	struct device *dev;
	unsigned int gsi;
	unsigned int irq;
	acpi_handle handle;
};

struct acpi_ged_handler_info {
	struct acpi_ged_handler_info *next;
	u32 int_id;
	struct acpi_namespace_node *evt_method;
};

struct acpi_generic_address {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_width;
	u64 address;
} __attribute__((packed));

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
};

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
};

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
};

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
};

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
};

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
};

struct acpi_global_notify_handler;

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
};

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
};

struct acpi_genl_event {
	acpi_device_class device_class;
	char bus_id[15];
	u32 type;
	u32 data;
};

typedef acpi_status (*acpi_walk_callback)(acpi_handle, u32, void *, void **);

struct acpi_get_devices_info {
	acpi_walk_callback user_function;
	void *context;
	const char *hid;
};

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
};

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
};

struct acpi_gpe_xrupt_info;

struct acpi_gpe_register_info;

struct acpi_gpe_event_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
};

struct acpi_gpe_block_status_context {
	struct acpi_gpe_register_info *gpe_skip_register_info;
	u8 gpe_skip_mask;
	u8 retval;
};

struct acpi_gpe_device_info {
	u32 index;
	u32 next_block_base_index;
	acpi_status status;
	struct acpi_namespace_node *gpe_device;
};

struct acpi_gpe_handler_info;

struct acpi_gpe_notify_info;

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
};

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
};

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
};

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
};

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
};

struct acpi_gpe_walk_info {
	struct acpi_namespace_node *gpe_device;
	struct acpi_gpe_block_info *gpe_block;
	u16 count;
	acpi_owner_id owner_id;
	u8 execute_by_owner_id;
};

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
};

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	unsigned int line_index;
	bool active_low;
};

struct acpi_handle_list {
	u32 count;
	acpi_handle *handles;
};

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
};

struct acpi_hmat_structure {
	u16 type;
	u16 reserved;
	u32 length;
};

typedef int (*acpi_hp_notify)(struct acpi_device *, u32);

typedef void (*acpi_hp_uevent)(struct acpi_device *, u32);

typedef void (*acpi_hp_fixup)(struct acpi_device *);

struct acpi_hotplug_context {
	struct acpi_device *self;
	acpi_hp_notify notify;
	acpi_hp_uevent uevent;
	acpi_hp_fixup fixup;
};

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
};

struct acpi_hp_work {
	struct work_struct work;
	struct acpi_device *adev;
	u32 src;
};

struct acpi_init_walk_info {
	u32 table_index;
	u32 object_count;
	u32 method_count;
	u32 serial_method_count;
	u32 non_serial_method_count;
	u32 serialized_method_count;
	u32 device_count;
	u32 op_region_count;
	u32 field_count;
	u32 buffer_count;
	u32 package_count;
	u32 op_region_init;
	u32 field_init;
	u32 buffer_init;
	u32 package_init;
	acpi_owner_id owner_id;
};

struct acpi_interface_info {
	char *name;
	struct acpi_interface_info *next;
	u8 flags;
	u8 value;
};

struct acpi_io_attribute {
	u8 range_type;
	u8 translation;
	u8 translation_type;
	u8 reserved1;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct acpi_ioremap {
	struct list_head list;
	void *virt;
	acpi_physical_address phys;
	acpi_size size;
	union {
		unsigned long refcount;
		struct rcu_work rwork;
	} track;
};

struct acpi_lpat {
	int temp;
	int raw;
};

struct acpi_lpat_conversion_table {
	struct acpi_lpat *lpat;
	int lpat_count;
};

struct acpi_lpi_state {
	u32 min_residency;
	u32 wake_latency;
	u32 flags;
	u32 arch_flags;
	u32 res_cnt_freq;
	u32 enable_parent_state;
	u64 address;
	u8 index;
	u8 entry_method;
	char desc[32];
};

struct acpi_lpi_states_array {
	unsigned int size;
	unsigned int composite_states_size;
	struct acpi_lpi_state *entries;
	struct acpi_lpi_state *composite_states[8];
};

struct acpi_lpit_header {
	u32 type;
	u32 length;
	u16 unique_id;
	u16 reserved;
	u32 flags;
};

struct acpi_lpit_native {
	struct acpi_lpit_header header;
	struct acpi_generic_address entry_trigger;
	u32 residency;
	u32 latency;
	struct acpi_generic_address residency_counter;
	u64 counter_frequency;
};

struct acpi_subtable_header {
	u8 type;
	u8 length;
};

struct acpi_madt_core_pic {
	struct acpi_subtable_header header;
	u8 version;
	u32 processor_id;
	u32 core_id;
	u32 flags;
} __attribute__((packed));

struct acpi_madt_generic_distributor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 gic_id;
	u64 base_address;
	u32 global_irq_base;
	u8 version;
	u8 reserved2[3];
};

struct acpi_madt_generic_interrupt {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 cpu_interface_number;
	u32 uid;
	u32 flags;
	u32 parking_version;
	u32 performance_interrupt;
	u64 parked_address;
	u64 base_address;
	u64 gicv_base_address;
	u64 gich_base_address;
	u32 vgic_interrupt;
	u64 gicr_base_address;
	u64 arm_mpidr;
	u8 efficiency_class;
	u8 reserved2[1];
	u16 spe_interrupt;
	u16 trbe_interrupt;
} __attribute__((packed));

struct acpi_madt_interrupt_override {
	struct acpi_subtable_header header;
	u8 bus;
	u8 source_irq;
	u32 global_irq;
	u16 inti_flags;
} __attribute__((packed));

struct acpi_madt_interrupt_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u8 type;
	u8 id;
	u8 eid;
	u8 io_sapic_vector;
	u32 global_irq;
	u32 flags;
};

struct acpi_madt_io_apic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 address;
	u32 global_irq_base;
};

struct acpi_madt_io_sapic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 global_irq_base;
	u64 address;
};

struct acpi_madt_local_apic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u32 lapic_flags;
};

struct acpi_madt_local_apic_nmi {
	struct acpi_subtable_header header;
	u8 processor_id;
	u16 inti_flags;
	u8 lint;
} __attribute__((packed));

struct acpi_madt_local_apic_override {
	struct acpi_subtable_header header;
	u16 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_madt_local_sapic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u8 eid;
	u8 reserved[3];
	u32 lapic_flags;
	u32 uid;
	char uid_string[0];
};

struct acpi_madt_local_x2apic {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 local_apic_id;
	u32 lapic_flags;
	u32 uid;
};

struct acpi_madt_local_x2apic_nmi {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 uid;
	u8 lint;
	u8 reserved[3];
};

struct acpi_madt_multiproc_wakeup {
	struct acpi_subtable_header header;
	u16 version;
	u32 reserved;
	u64 mailbox_address;
	u64 reset_vector;
};

struct acpi_madt_multiproc_wakeup_mailbox {
	u16 command;
	u16 reserved;
	u32 apic_id;
	u64 wakeup_vector;
	u8 reserved_os[2032];
	u8 reserved_firmware[2048];
};

struct acpi_madt_nmi_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 global_irq;
};

struct acpi_madt_rintc {
	struct acpi_subtable_header header;
	u8 version;
	u8 reserved;
	u32 flags;
	u64 hart_id;
	u32 uid;
	u32 ext_intc_id;
	u64 imsic_addr;
	u32 imsic_size;
} __attribute__((packed));

struct acpi_mcfg_allocation {
	u64 address;
	u16 pci_segment;
	u8 start_bus_number;
	u8 end_bus_number;
	u32 reserved;
};

struct acpi_mem_mapping {
	acpi_physical_address physical_address;
	u8 *logical_address;
	acpi_size length;
	struct acpi_mem_mapping *next_mm;
};

struct acpi_mem_space_context {
	u32 length;
	acpi_physical_address address;
	struct acpi_mem_mapping *cur_mm;
	struct acpi_mem_mapping *first_mm;
};

struct acpi_memory_attribute {
	u8 write_protect;
	u8 caching;
	u8 range_type;
	u8 translation;
};

struct acpi_mutex_info {
	void *mutex;
	u32 use_count;
	u64 thread_id;
};

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed));

struct acpi_namestring_info {
	const char *external_name;
	const char *next_external_char;
	char *internal_name;
	u32 length;
	u32 num_segments;
	u32 num_carats;
	u8 fully_qualified;
};

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
};

struct acpi_offsets {
	size_t offset;
	u8 mode;
};

struct acpi_opcode_info {
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
};

typedef void (*acpi_osd_exec_callback)(void *);

struct acpi_os_dpc {
	acpi_osd_exec_callback function;
	void *context;
	struct work_struct work;
};

struct acpi_osc_context {
	char *uuid_str;
	int rev;
	struct acpi_buffer cap;
	struct acpi_buffer ret;
};

struct acpi_osi_config {
	u8 default_disabling;
	unsigned int linux_enable: 1;
	unsigned int linux_dmi: 1;
	unsigned int linux_cmdline: 1;
	unsigned int darwin_enable: 1;
	unsigned int darwin_dmi: 1;
	unsigned int darwin_cmdline: 1;
};

struct acpi_osi_entry {
	char string[64];
	bool enable;
};

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
};

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed));

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
};

struct acpi_pcc_info {
	u8 subspace_id;
	u16 length;
	u8 *internal_buffer;
};

struct acpi_pcct_ext_pcc_master {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved1;
	u64 base_address;
	u32 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u32 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_set_mask;
	u64 reserved2;
	struct acpi_generic_address cmd_complete_register;
	u64 cmd_complete_mask;
	struct acpi_generic_address cmd_update_register;
	u64 cmd_update_preserve_mask;
	u64 cmd_update_set_mask;
	struct acpi_generic_address error_status_register;
	u64 error_status_mask;
} __attribute__((packed));

struct acpi_pcct_ext_pcc_shared_memory {
	u32 signature;
	u32 flags;
	u32 length;
	u32 command;
};

struct acpi_pcct_hw_reduced {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pcct_hw_reduced_type2 {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_write_mask;
} __attribute__((packed));

struct acpi_pcct_shared_memory {
	u32 signature;
	u16 command;
	u16 status;
};

struct acpi_pcct_subspace {
	struct acpi_subtable_header header;
	u8 reserved[6];
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pci_device {
	acpi_handle device;
	struct acpi_pci_device *next;
};

struct acpi_pci_id {
	u16 segment;
	u16 bus;
	u16 device;
	u16 function;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	unsigned long flags;
	unsigned long desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct pci_dev;

struct acpi_pci_ioapic {
	acpi_handle root_handle;
	acpi_handle handle;
	u32 gsi_base;
	struct resource res;
	struct pci_dev *pdev;
	struct list_head list;
};

struct acpi_pci_link_irq {
	u32 active;
	u8 triggering;
	u8 polarity;
	u8 resource_type;
	u8 possible_count;
	u32 possible[16];
	u8 initialized: 1;
	u8 reserved: 7;
};

struct acpi_pci_link {
	struct list_head list;
	struct acpi_device *device;
	struct acpi_pci_link_irq irq;
	int refcnt;
};

struct pci_bus;

struct acpi_pci_root {
	struct acpi_device *device;
	struct pci_bus *bus;
	u16 segment;
	int bridge_type;
	struct resource secondary;
	u32 osc_support_set;
	u32 osc_control_set;
	u32 osc_ext_support_set;
	u32 osc_ext_control_set;
	phys_addr_t mcfg_addr;
};

struct acpi_pci_root_ops;

struct acpi_pci_root_info {
	struct acpi_pci_root *root;
	struct acpi_device *bridge;
	struct acpi_pci_root_ops *ops;
	struct list_head resources;
	char name[16];
};

struct pci_ops;

struct acpi_pci_root_ops {
	struct pci_ops *pci_ops;
	int (*init_info)(struct acpi_pci_root_info *);
	void (*release_info)(struct acpi_pci_root_info *);
	int (*prepare_resources)(struct acpi_pci_root_info *);
};

struct acpi_pci_routing_table {
	u32 length;
	u32 pin;
	u64 address;
	u32 source_index;
	union {
		char pad[4];
		struct {
			struct {} __Empty_source;
			char source[0];
		};
	};
};

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
};

struct acpi_platform_list {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
	char *table;
	enum acpi_predicate pred;
	char *reason;
	u32 data;
};

struct acpi_pld_info {
	u8 revision;
	u8 ignore_color;
	u8 red;
	u8 green;
	u8 blue;
	u16 width;
	u16 height;
	u8 user_visible;
	u8 dock;
	u8 lid;
	u8 panel;
	u8 vertical_position;
	u8 horizontal_position;
	u8 shape;
	u8 group_orientation;
	u8 group_token;
	u8 group_position;
	u8 bay;
	u8 ejectable;
	u8 ospm_eject_required;
	u8 cabinet_number;
	u8 card_cage_number;
	u8 reference;
	u8 rotation;
	u8 order;
	u8 reserved;
	u16 vertical_offset;
	u16 horizontal_offset;
};

struct acpi_port_info {
	char *name;
	u16 start;
	u16 end;
	u8 osi_dependency;
};

struct acpi_power_dependent_device {
	struct device *dev;
	struct list_head node;
};

struct acpi_power_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_power_resource {
	struct acpi_device device;
	struct list_head list_node;
	u32 system_level;
	u32 order;
	unsigned int ref_count;
	u8 state;
	struct mutex resource_lock;
	struct list_head dependents;
};

struct acpi_power_resource_entry {
	struct list_head node;
	struct acpi_power_resource *resource;
};

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
};

struct acpi_predefined_names {
	const char *name;
	u8 type;
	char *val;
};

struct acpi_prmt_handler_info {
	u16 revision;
	u16 length;
	u8 handler_guid[16];
	u64 handler_address;
	u64 static_data_buffer_address;
	u64 acpi_param_buffer_address;
} __attribute__((packed));

struct acpi_prmt_module_header {
	u16 revision;
	u16 length;
};

struct acpi_prmt_module_info {
	u16 revision;
	u16 length;
	u8 module_guid[16];
	u16 major_rev;
	u16 minor_rev;
	u16 handler_info_count;
	u32 handler_info_offset;
	u64 mmio_list_pointer;
} __attribute__((packed));

struct acpi_probe_entry;

typedef bool (*acpi_probe_entry_validate_subtbl)(struct acpi_subtable_header *, struct acpi_probe_entry *);

struct acpi_table_header;

typedef int (*acpi_tbl_table_handler)(struct acpi_table_header *);

union acpi_subtable_headers;

typedef int (*acpi_tbl_entry_handler)(union acpi_subtable_headers *, const unsigned long);

struct acpi_probe_entry {
	__u8 id[5];
	__u8 type;
	acpi_probe_entry_validate_subtbl subtable_valid;
	union {
		acpi_tbl_table_handler probe_table;
		acpi_tbl_entry_handler probe_subtbl;
	};
	kernel_ulong_t driver_data;
};

struct acpi_processor_flags {
	u8 power: 1;
	u8 performance: 1;
	u8 throttling: 1;
	u8 limit: 1;
	u8 bm_control: 1;
	u8 bm_check: 1;
	u8 has_cst: 1;
	u8 has_lpi: 1;
	u8 power_setup_done: 1;
	u8 bm_rld_set: 1;
	u8 previously_online: 1;
};

struct acpi_processor_cx {
	u8 valid;
	u8 type;
	u32 address;
	u8 entry_method;
	u8 index;
	u32 latency;
	u8 bm_sts_skip;
	char desc[32];
};

struct acpi_processor_power {
	int count;
	union {
		struct acpi_processor_cx states[8];
		struct acpi_lpi_state lpi_states[8];
	};
	int timer_broadcast_on_state;
};

struct acpi_tsd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

typedef struct cpumask *cpumask_var_t;

struct acpi_processor_tx {
	u16 power;
	u16 performance;
};

struct acpi_processor_tx_tss;

struct acpi_processor;

struct acpi_processor_throttling {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_tx_tss *states_tss;
	struct acpi_tsd_package domain_info;
	cpumask_var_t shared_cpu_map;
	int (*acpi_processor_get_throttling)(struct acpi_processor *);
	int (*acpi_processor_set_throttling)(struct acpi_processor *, int, bool);
	u32 address;
	u8 duty_offset;
	u8 duty_width;
	u8 tsd_valid_flag;
	unsigned int shared_type;
	struct acpi_processor_tx states[16];
};

struct acpi_processor_lx {
	int px;
	int tx;
};

struct acpi_processor_limit {
	struct acpi_processor_lx state;
	struct acpi_processor_lx thermal;
	struct acpi_processor_lx user;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

struct freq_constraints;

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

struct acpi_processor_performance;

struct acpi_processor {
	acpi_handle handle;
	u32 acpi_id;
	phys_cpuid_t phys_id;
	u32 id;
	u32 pblk;
	int performance_platform_limit;
	int throttling_platform_limit;
	struct acpi_processor_flags flags;
	struct acpi_processor_power power;
	struct acpi_processor_performance *performance;
	struct acpi_processor_throttling throttling;
	struct acpi_processor_limit limit;
	struct thermal_cooling_device *cdev;
	struct device *dev;
	struct freq_qos_request perflib_req;
	struct freq_qos_request thermal_req;
};

struct acpi_processor_errata {
	u8 smp;
	struct {
		u8 throttle: 1;
		u8 fdma: 1;
		u8 reserved: 6;
		u32 bmisx;
	} piix4;
};

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct acpi_processor_px;

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
};

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
};

struct acpi_processor_throttling_arg {
	struct acpi_processor *pr;
	int target_state;
	bool force;
};

struct acpi_processor_tx_tss {
	u64 freqpercentage;
	u64 power;
	u64 transition_latency;
	u64 control;
	u64 status;
};

struct acpi_prt_entry {
	struct acpi_pci_id id;
	u8 pin;
	acpi_handle link;
	u32 index;
};

struct acpi_reg_walk_info {
	u32 function;
	u32 reg_run_count;
	acpi_adr_space_type space_id;
};

typedef acpi_status (*acpi_repair_function)(struct acpi_evaluate_info *, union acpi_operand_object **);

struct acpi_repair_info {
	char name[4];
	acpi_repair_function repair_function;
};

struct acpi_resource_irq {
	u8 descriptor_length;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	union {
		u8 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u8 interrupts[0];
		};
	};
};

struct acpi_resource_dma {
	u8 type;
	u8 bus_master;
	u8 transfer;
	u8 channel_count;
	union {
		u8 channel;
		struct {
			struct {} __Empty_channels;
			u8 channels[0];
		};
	};
};

struct acpi_resource_start_dependent {
	u8 descriptor_length;
	u8 compatibility_priority;
	u8 performance_robustness;
};

struct acpi_resource_io {
	u8 io_decode;
	u8 alignment;
	u8 address_length;
	u16 minimum;
	u16 maximum;
} __attribute__((packed));

struct acpi_resource_fixed_io {
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_dma {
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct acpi_resource_vendor {
	u16 byte_length;
	u8 byte_data[0];
};

struct acpi_resource_vendor_typed {
	u16 byte_length;
	u8 uuid_subtype;
	u8 uuid[16];
	u8 byte_data[0];
} __attribute__((packed));

struct acpi_resource_end_tag {
	u8 checksum;
};

struct acpi_resource_memory24 {
	u8 write_protect;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct acpi_resource_memory32 {
	u8 write_protect;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_memory32 {
	u8 write_protect;
	u32 address;
	u32 address_length;
} __attribute__((packed));

union acpi_resource_attribute {
	struct acpi_memory_attribute mem;
	struct acpi_io_attribute io;
	u8 type_specific;
};

struct acpi_resource_source {
	u8 index;
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_address16 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address16_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address32 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address32_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address64_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_extended_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	u8 revision_ID;
	struct acpi_address64_attribute address;
	u64 type_specific;
} __attribute__((packed));

struct acpi_resource_extended_irq {
	u8 producer_consumer;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	struct acpi_resource_source resource_source;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct acpi_resource_generic_register {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_resource_gpio {
	u8 revision_id;
	u8 connection_type;
	u8 producer_consumer;
	u8 pin_config;
	u8 shareable;
	u8 wake_capable;
	u8 io_restriction;
	u8 triggering;
	u8 polarity;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_i2c_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 access_mode;
	u16 slave_address;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_spi_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 wire_mode;
	u8 device_polarity;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_uart_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 endian;
	u8 data_bits;
	u8 stop_bits;
	u8 flow_control;
	u8 parity;
	u8 lines_enabled;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u32 default_baud_rate;
} __attribute__((packed));

struct acpi_resource_csi2_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 local_port_instance;
	u8 phy_type;
} __attribute__((packed));

struct acpi_resource_common_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_function {
	u8 revision_id;
	u8 pin_config;
	u8 shareable;
	u16 function_number;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_label {
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_pin_group {
	u8 revision_id;
	u8 producer_consumer;
	u16 pin_table_length;
	u16 vendor_length;
	u16 *pin_table;
	struct acpi_resource_label resource_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_function {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u16 function_number;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_clock_input {
	u8 revision_id;
	u8 mode;
	u8 scale;
	u16 frequency_divisor;
	u32 frequency_numerator;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
};

union acpi_resource_data {
	struct acpi_resource_irq irq;
	struct acpi_resource_dma dma;
	struct acpi_resource_start_dependent start_dpf;
	struct acpi_resource_io io;
	struct acpi_resource_fixed_io fixed_io;
	struct acpi_resource_fixed_dma fixed_dma;
	struct acpi_resource_vendor vendor;
	struct acpi_resource_vendor_typed vendor_typed;
	struct acpi_resource_end_tag end_tag;
	struct acpi_resource_memory24 memory24;
	struct acpi_resource_memory32 memory32;
	struct acpi_resource_fixed_memory32 fixed_memory32;
	struct acpi_resource_address16 address16;
	struct acpi_resource_address32 address32;
	struct acpi_resource_address64 address64;
	struct acpi_resource_extended_address64 ext_address64;
	struct acpi_resource_extended_irq extended_irq;
	struct acpi_resource_generic_register generic_reg;
	struct acpi_resource_gpio gpio;
	struct acpi_resource_i2c_serialbus i2c_serial_bus;
	struct acpi_resource_spi_serialbus spi_serial_bus;
	struct acpi_resource_uart_serialbus uart_serial_bus;
	struct acpi_resource_csi2_serialbus csi2_serial_bus;
	struct acpi_resource_common_serialbus common_serial_bus;
	struct acpi_resource_pin_function pin_function;
	struct acpi_resource_pin_config pin_config;
	struct acpi_resource_pin_group pin_group;
	struct acpi_resource_pin_group_function pin_group_function;
	struct acpi_resource_pin_group_config pin_group_config;
	struct acpi_resource_clock_input clock_input;
	struct acpi_resource_address address;
};

struct acpi_resource {
	u32 type;
	u32 length;
	union acpi_resource_data data;
};

struct acpi_rsconvert_info {
	u8 opcode;
	u8 resource_offset;
	u8 aml_offset;
	u8 value;
};

struct acpi_rw_lock {
	void *writer_mutex;
	void *reader_mutex;
	u32 num_readers;
};

struct acpi_s2idle_dev_ops {
	struct list_head list_node;
	void (*prepare)(void);
	void (*check)(void);
	void (*restore)(void);
};

struct acpi_scan_clear_dep_work {
	struct work_struct work;
	struct acpi_device *adev;
};

struct acpi_scan_handler {
	struct list_head list_node;
	const struct acpi_device_id *ids;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*post_eject)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
};

typedef u32 (*acpi_sci_handler)(void *);

struct acpi_sci_handler_info {
	struct acpi_sci_handler_info *next;
	acpi_sci_handler address;
	void *context;
};

struct acpi_signal_fatal_info {
	u32 type;
	u32 code;
	u32 argument;
};

typedef acpi_status (*acpi_object_converter)(struct acpi_namespace_node *, union acpi_operand_object *, union acpi_operand_object **);

struct acpi_simple_repair_info {
	char name[4];
	u32 unexpected_btypes;
	u32 package_index;
	acpi_object_converter object_converter;
};

struct acpi_srat_cpu_affinity {
	struct acpi_subtable_header header;
	u8 proximity_domain_lo;
	u8 apic_id;
	u32 flags;
	u8 local_sapic_eid;
	u8 proximity_domain_hi[3];
	u32 clock_domain;
};

struct acpi_srat_generic_affinity {
	struct acpi_subtable_header header;
	u8 reserved;
	u8 device_handle_type;
	u32 proximity_domain;
	u8 device_handle[16];
	u32 flags;
	u32 reserved1;
};

struct acpi_srat_gicc_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} __attribute__((packed));

struct acpi_srat_mem_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u64 base_address;
	u64 length;
	u32 reserved1;
	u32 flags;
	u64 reserved2;
} __attribute__((packed));

struct acpi_srat_rintc_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
};

struct acpi_srat_x2apic_cpu_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 apic_id;
	u32 flags;
	u32 clock_domain;
	u32 reserved2;
};

struct acpi_subtable_entry {
	union acpi_subtable_headers *hdr;
	enum acpi_subtable_type type;
};

union acpi_subtable_headers {
	struct acpi_subtable_header common;
	struct acpi_hmat_structure hmat;
	struct acpi_prmt_module_header prmt;
	struct acpi_cedt_header cedt;
	struct acpi_cdat_header cdat;
};

typedef int (*acpi_tbl_entry_handler_arg)(union acpi_subtable_headers *, void *, const unsigned long);

struct acpi_subtable_proc {
	int id;
	acpi_tbl_entry_handler handler;
	acpi_tbl_entry_handler_arg handler_arg;
	void *arg;
	int count;
};

struct acpi_table_attr {
	struct bin_attribute attr;
	char name[4];
	int instance;
	char filename[8];
	struct list_head node;
};

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
};

struct acpi_table_bert {
	struct acpi_table_header header;
	u32 region_length;
	u64 address;
};

struct acpi_table_boot {
	struct acpi_table_header header;
	u8 cmos_index;
	u8 reserved[3];
};

struct acpi_table_ccel {
	struct acpi_table_header header;
	u8 CCtype;
	u8 Ccsub_type;
	u16 reserved;
	u64 log_area_minimum_length;
	u64 log_area_start_address;
};

struct acpi_table_cdat {
	u32 length;
	u8 revision;
	u8 checksum;
	u8 reserved[6];
	u32 sequence;
};

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
};

struct acpi_table_ecdt {
	struct acpi_table_header header;
	struct acpi_generic_address control;
	struct acpi_generic_address data;
	u32 uid;
	u8 gpe;
	u8 id[0];
} __attribute__((packed));

struct acpi_table_facs {
	char signature[4];
	u32 length;
	u32 hardware_signature;
	u32 firmware_waking_vector;
	u32 global_lock;
	u32 flags;
	u64 xfirmware_waking_vector;
	u8 version;
	u8 reserved[3];
	u32 ospm_flags;
	u8 reserved1[24];
};

struct acpi_table_fadt {
	struct acpi_table_header header;
	u32 facs;
	u32 dsdt;
	u8 model;
	u8 preferred_profile;
	u16 sci_interrupt;
	u32 smi_command;
	u8 acpi_enable;
	u8 acpi_disable;
	u8 s4_bios_request;
	u8 pstate_control;
	u32 pm1a_event_block;
	u32 pm1b_event_block;
	u32 pm1a_control_block;
	u32 pm1b_control_block;
	u32 pm2_control_block;
	u32 pm_timer_block;
	u32 gpe0_block;
	u32 gpe1_block;
	u8 pm1_event_length;
	u8 pm1_control_length;
	u8 pm2_control_length;
	u8 pm_timer_length;
	u8 gpe0_block_length;
	u8 gpe1_block_length;
	u8 gpe1_base;
	u8 cst_control;
	u16 c2_latency;
	u16 c3_latency;
	u16 flush_size;
	u16 flush_stride;
	u8 duty_offset;
	u8 duty_width;
	u8 day_alarm;
	u8 month_alarm;
	u8 century;
	u16 boot_flags;
	u8 reserved;
	u32 flags;
	struct acpi_generic_address reset_register;
	u8 reset_value;
	u16 arm_boot_flags;
	u8 minor_revision;
	u64 Xfacs;
	u64 Xdsdt;
	struct acpi_generic_address xpm1a_event_block;
	struct acpi_generic_address xpm1b_event_block;
	struct acpi_generic_address xpm1a_control_block;
	struct acpi_generic_address xpm1b_control_block;
	struct acpi_generic_address xpm2_control_block;
	struct acpi_generic_address xpm_timer_block;
	struct acpi_generic_address xgpe0_block;
	struct acpi_generic_address xgpe1_block;
	struct acpi_generic_address sleep_control;
	struct acpi_generic_address sleep_status;
	u64 hypervisor_id;
} __attribute__((packed));

struct acpi_table_hpet {
	struct acpi_table_header header;
	u32 id;
	struct acpi_generic_address address;
	u8 sequence;
	u16 minimum_tick;
	u8 flags;
} __attribute__((packed));

struct acpi_table_list {
	struct acpi_table_desc *tables;
	u32 current_table_count;
	u32 max_table_count;
	u8 flags;
};

struct acpi_table_lpit {
	struct acpi_table_header header;
};

struct acpi_table_madt {
	struct acpi_table_header header;
	u32 address;
	u32 flags;
};

struct acpi_table_mcfg {
	struct acpi_table_header header;
	u8 reserved[8];
};

struct acpi_table_pcct {
	struct acpi_table_header header;
	u32 flags;
	u64 reserved;
};

struct acpi_table_rsdp {
	char signature[8];
	u8 checksum;
	char oem_id[6];
	u8 revision;
	u32 rsdt_physical_address;
	u32 length;
	u64 xsdt_physical_address;
	u8 extended_checksum;
	u8 reserved[3];
} __attribute__((packed));

struct acpi_table_slit {
	struct acpi_table_header header;
	u64 locality_count;
	u8 entry[0];
} __attribute__((packed));

struct acpi_table_spcr {
	struct acpi_table_header header;
	u8 interface_type;
	u8 reserved[3];
	struct acpi_generic_address serial_port;
	u8 interrupt_type;
	u8 pc_interrupt;
	u32 interrupt;
	u8 baud_rate;
	u8 parity;
	u8 stop_bits;
	u8 flow_control;
	u8 terminal_type;
	u8 language;
	u16 pci_device_id;
	u16 pci_vendor_id;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u32 pci_flags;
	u8 pci_segment;
	u32 uart_clk_freq;
	u32 precise_baudrate;
	u16 name_space_string_length;
	u16 name_space_string_offset;
	char name_space_string[0];
} __attribute__((packed));

struct acpi_table_srat {
	struct acpi_table_header header;
	u32 table_revision;
	u64 reserved;
};

struct acpi_table_stao {
	struct acpi_table_header header;
	u8 ignore_uart;
} __attribute__((packed));

struct acpi_thermal_trip {
	unsigned long temp_dk;
	struct acpi_handle_list devices;
};

struct acpi_thermal_passive {
	struct acpi_thermal_trip trip;
	unsigned long tc1;
	unsigned long tc2;
	unsigned long delay;
};

struct acpi_thermal_active {
	struct acpi_thermal_trip trip;
};

struct acpi_thermal_trips {
	struct acpi_thermal_passive passive;
	struct acpi_thermal_active active[10];
};

struct thermal_zone_device;

struct acpi_thermal {
	struct acpi_device *device;
	acpi_bus_id name;
	unsigned long temp_dk;
	unsigned long last_temp_dk;
	unsigned long polling_frequency;
	volatile u8 zombie;
	struct acpi_thermal_trips trips;
	struct thermal_zone_device *thermal_zone;
	int kelvin_offset;
	struct work_struct thermal_check_work;
	struct mutex thermal_check_lock;
	refcount_t thermal_check_count;
};

struct acpi_vendor_uuid {
	u8 subtype;
	u8 data[16];
};

struct acpi_vendor_walk_info {
	struct acpi_vendor_uuid *uuid;
	struct acpi_buffer *buffer;
	acpi_status status;
};

struct acpi_wakeup_handler {
	struct list_head list_node;
	bool (*wakeup)(void *);
	void *context;
};

typedef acpi_status (*acpi_parse_downwards)(struct acpi_walk_state *, union acpi_parse_object **);

typedef acpi_status (*acpi_parse_upwards)(struct acpi_walk_state *);

struct acpi_walk_state {
	struct acpi_walk_state *next;
	u8 descriptor_type;
	u8 walk_type;
	u16 opcode;
	u8 next_op_info;
	u8 num_operands;
	u8 operand_index;
	acpi_owner_id owner_id;
	u8 last_predicate;
	u8 current_result;
	u8 return_used;
	u8 scope_depth;
	u8 pass_number;
	u8 namespace_override;
	u8 result_size;
	u8 result_count;
	u8 *aml;
	u32 arg_types;
	u32 method_breakpoint;
	u32 user_breakpoint;
	u32 parse_flags;
	struct acpi_parse_state parser_state;
	u32 prev_arg_types;
	u32 arg_count;
	u16 method_nesting_depth;
	u8 method_is_nested;
	struct acpi_namespace_node arguments[7];
	struct acpi_namespace_node local_variables[8];
	union acpi_operand_object *operands[9];
	union acpi_operand_object **params;
	u8 *aml_last_while;
	union acpi_operand_object **caller_return_desc;
	union acpi_generic_state *control_state;
	struct acpi_namespace_node *deferred_node;
	union acpi_operand_object *implicit_return_obj;
	struct acpi_namespace_node *method_call_node;
	union acpi_parse_object *method_call_op;
	union acpi_operand_object *method_desc;
	struct acpi_namespace_node *method_node;
	char *method_pathname;
	union acpi_parse_object *op;
	const struct acpi_opcode_info *op_info;
	union acpi_parse_object *origin;
	union acpi_operand_object *result_obj;
	union acpi_generic_state *results;
	union acpi_operand_object *return_desc;
	union acpi_generic_state *scope_info;
	union acpi_parse_object *prev_op;
	union acpi_parse_object *next_op;
	struct acpi_thread_state *thread;
	acpi_parse_downwards descending_callback;
	acpi_parse_upwards ascending_callback;
};

struct pnp_dev;

struct acpipnp_parse_option_s {
	struct pnp_dev *dev;
	unsigned int option_flags;
};

struct action_cache {
	unsigned long allow_native[8];
};

struct hist_trigger_data;

struct tracing_map_elt;

struct trace_buffer;

struct ring_buffer_event;

struct action_data;

typedef void (*action_fn_t)(struct hist_trigger_data *, struct tracing_map_elt *, struct trace_buffer *, void *, struct ring_buffer_event *, void *, struct action_data *, u64 *);

typedef bool (*check_track_val_fn_t)(u64, u64);

struct synth_event;

struct hist_field;

struct action_data {
	enum handler_id handler;
	enum action_id action;
	char *action_name;
	action_fn_t fn;
	unsigned int n_params;
	char *params[64];
	unsigned int var_ref_idx[64];
	struct synth_event *synth_event;
	bool use_trace_keyword;
	char *synth_event_name;
	union {
		struct {
			char *event;
			char *event_system;
		} match_data;
		struct {
			char *var_str;
			struct hist_field *var_ref;
			struct hist_field *track_var;
			check_track_val_fn_t check_val;
			action_fn_t save_data;
		} track_data;
	};
};

struct action_devres {
	void *data;
	void (*action)(void *);
};

struct rb_root {
	struct rb_node *rb_node;
};

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
};

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	struct rb_root_cached i_mmap;
	unsigned long nrpages;
	unsigned long writeback_index;
	const struct address_space_operations *a_ops;
	unsigned long flags;
	errseq_t wb_err;
	spinlock_t i_private_lock;
	struct list_head i_private_list;
	struct rw_semaphore i_mmap_rwsem;
	void *i_private_data;
};

struct writeback_control;

struct readahead_control;

struct kiocb;

struct iov_iter;

struct swap_info_struct;

struct address_space_operations {
	int (*writepage)(struct page *, struct writeback_control *);
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct folio **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct folio *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_folio)(struct address_space *, struct folio *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
};

struct adjust_trip_data {
	struct acpi_thermal *tz;
	u32 event;
};

struct crypto_aead;

struct aead_request;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	struct crypto_alg base;
};

struct crypto_sync_skcipher;

struct aead_geniv_ctx {
	spinlock_t lock;
	struct crypto_aead *child;
	struct crypto_sync_skcipher *sknull;
	u8 salt[0];
};

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	};
	struct work_struct free_work;
	void *__ctx[0];
};

struct aead_instance {
	void (*free)(struct aead_instance *);
	union {
		struct {
			char head[64];
			struct crypto_instance base;
		} s;
		struct aead_alg alg;
	};
};

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	void *__ctx[0];
};

struct aes_sc {
	__le64 pn;
};

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
};

struct agg_tx_status {
	__le16 status;
	__le16 sequence;
};

struct aggregate_control {
	long *aggregate;
	long *local;
	long *pending;
	long *ppending;
	long *cstat;
	long *cstat_prev;
	int size;
};

struct component_master_ops;

struct component_match;

struct aggregate_device {
	struct list_head node;
	bool bound;
	const struct component_master_ops *ops;
	struct device *parent;
	struct component_match *match;
};

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
};

struct ahash_request;

struct crypto_ahash;

struct ahash_alg {
	int (*init)(struct ahash_request *);
	int (*update)(struct ahash_request *);
	int (*final)(struct ahash_request *);
	int (*finup)(struct ahash_request *);
	int (*digest)(struct ahash_request *);
	int (*export)(struct ahash_request *, void *);
	int (*import)(struct ahash_request *, const void *);
	int (*setkey)(struct crypto_ahash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_ahash *);
	void (*exit_tfm)(struct crypto_ahash *);
	int (*clone_tfm)(struct crypto_ahash *, struct crypto_ahash *);
	struct hash_alg_common halg;
};

struct ahash_instance {
	void (*free)(struct ahash_instance *);
	union {
		struct {
			char head[96];
			struct crypto_instance base;
		} s;
		struct ahash_alg alg;
	};
};

struct ahash_request {
	struct crypto_async_request base;
	unsigned int nbytes;
	struct scatterlist *src;
	u8 *result;
	void *priv;
	void *__ctx[0];
};

struct ahci_cmd_hdr {
	__le32 opts;
	__le32 status;
	__le32 tbl_addr;
	__le32 tbl_addr_hi;
	__le32 reserved[4];
};

struct ata_link;

struct ahci_em_priv {
	enum sw_activity blink_policy;
	struct timer_list timer;
	unsigned long saved_activity;
	unsigned long activity;
	unsigned long led_state;
	struct ata_link *link;
};

struct reset_control;

struct regulator;

struct clk_bulk_data;

struct phy___2;

struct ata_port;

struct ata_host;

struct ahci_host_priv {
	unsigned int flags;
	u32 mask_port_map;
	void *mmio;
	u32 cap;
	u32 cap2;
	u32 version;
	u32 port_map;
	u32 saved_cap;
	u32 saved_cap2;
	u32 saved_port_map;
	u32 saved_port_cap[32];
	u32 em_loc;
	u32 em_buf_sz;
	u32 em_msg_type;
	u32 remapped_nvme;
	bool got_runtime_pm;
	unsigned int n_clks;
	struct clk_bulk_data *clks;
	unsigned int f_rsts;
	struct reset_control *rsts;
	struct regulator **target_pwrs;
	struct regulator *ahci_regulator;
	struct regulator *phy_regulator;
	struct phy___2 **phys;
	unsigned int nports;
	void *plat_data;
	unsigned int irq;
	void (*start_engine)(struct ata_port *);
	int (*stop_engine)(struct ata_port *);
	irqreturn_t (*irq_handler)(int, void *);
	int (*get_irq_vector)(struct ata_host *, int);
};

struct ahci_port_priv {
	struct ata_link *active_link;
	struct ahci_cmd_hdr *cmd_slot;
	dma_addr_t cmd_slot_dma;
	void *cmd_tbl;
	dma_addr_t cmd_tbl_dma;
	void *rx_fis;
	dma_addr_t rx_fis_dma;
	unsigned int ncq_saw_d2h: 1;
	unsigned int ncq_saw_dmas: 1;
	unsigned int ncq_saw_sdb: 1;
	spinlock_t lock;
	u32 intr_mask;
	bool fbs_supported;
	bool fbs_enabled;
	int fbs_last_dev;
	struct ahci_em_priv em_priv[15];
	char *irq_desc;
};

struct ahci_sg {
	__le32 addr;
	__le32 addr_hi;
	__le32 reserved;
	__le32 flags_size;
};

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	};
};

struct cred;

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
};

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
};

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
};

typedef int kiocb_cancel_fn(struct kiocb *);

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
};

struct kioctx;

struct eventfd_ctx;

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	};
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
};

struct poll_table_struct;

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
};

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
};

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
};

struct aio_waiter {
	struct wait_queue_entry w;
	size_t min_nr;
};

struct airtime_info {
	u64 rx_airtime;
	u64 tx_airtime;
	unsigned long last_active;
	s32 deficit;
	atomic_t aql_tx_pending;
	u32 aql_limit_low;
	u32 aql_limit_high;
};

struct akcipher_request;

struct crypto_akcipher;

struct akcipher_alg {
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	struct crypto_alg base;
};

struct akcipher_instance {
	void (*free)(struct akcipher_instance *);
	union {
		struct {
			char head[56];
			struct crypto_instance base;
		} s;
		struct akcipher_alg alg;
	};
};

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	void *__ctx[0];
};

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	void (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
};

struct timerqueue_head {
	struct rb_root_cached rb_root;
};

struct timespec64;

struct alarm_base {
	spinlock_t lock;
	struct timerqueue_head timerqueue;
	ktime_t (*get_ktime)(void);
	void (*get_timespec)(struct timespec64 *);
	clockid_t base_clockid;
};

struct alert_data {
	unsigned short addr;
	enum i2c_alert_protocol type;
	unsigned int data;
};

struct alias_prop {
	struct list_head link;
	const char *alias;
	struct device_node *np;
	int id;
	char stem[0];
};

struct alloc_chunk_ctl {
	u64 start;
	u64 type;
	int num_stripes;
	int sub_stripes;
	int dev_stripes;
	int devs_max;
	int devs_min;
	int devs_increment;
	int ncopies;
	int nparity;
	u64 max_stripe_size;
	u64 max_chunk_size;
	u64 dev_extent_min;
	u64 stripe_size;
	u64 chunk_size;
	int ndevs;
};

struct zonelist;

struct zoneref;

struct alloc_context {
	struct zonelist *zonelist;
	nodemask_t *nodemask;
	struct zoneref *preferred_zoneref;
	int migratetype;
	enum zone_type highest_zoneidx;
	bool spread_dirty_pages;
};

struct codetag {
	unsigned int flags;
	unsigned int lineno;
	const char *modname;
	const char *function;
	const char *filename;
};

struct alloc_tag_counters;

struct alloc_tag {
	struct codetag ct;
	struct alloc_tag_counters __attribute__((btf_type_tag("percpu"))) *counters;
};

struct alloc_tag_counters {
	u64 bytes;
	u64 calls;
};

struct alt_instr {
	s32 instr_offset;
	s32 repl_offset;
	union {
		struct {
			u32 cpuid: 16;
			u32 flags: 16;
		};
		u32 ft_flags;
	};
	u8 instrlen;
	u8 replacementlen;
} __attribute__((packed));

struct amd_aperf_mperf {
	u64 aperf;
	u64 mperf;
	u64 tsc;
};

struct amd_chipset_type {
	enum amd_chipset_gen gen;
	u8 rev;
};

struct amd_chipset_info {
	struct pci_dev *nb_dev;
	struct pci_dev *smbus_dev;
	int nb_type;
	struct amd_chipset_type sb_type;
	int isoc_reqs;
	int probe_count;
	bool need_pll_quirk;
};

struct amd_cpudata {
	int cpu;
	struct freq_qos_request req[2];
	u64 cppc_req_cached;
	u32 highest_perf;
	u32 nominal_perf;
	u32 lowest_nonlinear_perf;
	u32 lowest_perf;
	u32 prefcore_ranking;
	u32 min_limit_perf;
	u32 max_limit_perf;
	u32 min_limit_freq;
	u32 max_limit_freq;
	u32 max_freq;
	u32 min_freq;
	u32 nominal_freq;
	u32 lowest_nonlinear_freq;
	struct amd_aperf_mperf cur;
	struct amd_aperf_mperf prev;
	u64 freq;
	bool boost_supported;
	bool hw_prefcore;
	s16 epp_cached;
	u32 policy;
	u64 cppc_cap1_cached;
	bool suspended;
	s16 epp_default;
};

struct amd_hostbridge {
	u32 bus;
	u32 slot;
	u32 device;
};

struct amd_l3_cache {
	unsigned int indices;
	u8 subcaches[4];
};

struct amd_lps0_hid_device_data {
	const bool check_off_by_one;
};

struct event_constraint {
	union {
		unsigned long idxmsk[1];
		u64 idxmsk64;
	};
	u64 code;
	u64 cmask;
	int weight;
	int overlap;
	int flags;
	unsigned int size;
};

struct perf_event;

struct amd_nb {
	int nb_id;
	int refcnt;
	struct perf_event *owners[64];
	struct event_constraint event_constraints[64];
};

struct amd_nb_bus_dev_range {
	u8 bus;
	u8 dev_base;
	u8 dev_limit;
};

struct amd_northbridge {
	struct pci_dev *root;
	struct pci_dev *misc;
	struct pci_dev *link;
	struct amd_l3_cache l3_cache;
};

struct amd_northbridge_info {
	u16 num;
	u64 flags;
	struct amd_northbridge *nb;
};

union amd_uncore_info;

struct amd_uncore_pmu;

struct amd_uncore {
	union amd_uncore_info __attribute__((btf_type_tag("percpu"))) *info;
	struct amd_uncore_pmu *pmus;
	unsigned int num_pmus;
	bool init_done;
	void (*scan)(struct amd_uncore *, unsigned int);
	int (*init)(struct amd_uncore *, unsigned int);
	void (*move)(struct amd_uncore *, unsigned int);
	void (*free)(struct amd_uncore *, unsigned int);
};

struct amd_uncore_ctx {
	int refcnt;
	int cpu;
	struct perf_event **events;
	struct hlist_node node;
};

union amd_uncore_info {
	struct {
		u64 aux_data: 32;
		u64 num_pmcs: 8;
		u64 gid: 8;
		u64 cid: 8;
	} split;
	u64 full;
};

struct cpumask {
	unsigned long bits[128];
};

typedef struct cpumask cpumask_t;

struct perf_cpu_pmu_context;

struct perf_event_pmu_context;

struct kmem_cache;

struct perf_output_handle;

struct pmu {
	struct list_head entry;
	struct module *module;
	struct device *dev;
	struct device *parent;
	const struct attribute_group **attr_groups;
	const struct attribute_group **attr_update;
	const char *name;
	int type;
	int capabilities;
	unsigned int scope;
	int __attribute__((btf_type_tag("percpu"))) *pmu_disable_count;
	struct perf_cpu_pmu_context __attribute__((btf_type_tag("percpu"))) *cpu_pmu_context;
	atomic_t exclusive_cnt;
	int task_ctx_nr;
	int hrtimer_interval_ms;
	unsigned int nr_addr_filters;
	void (*pmu_enable)(struct pmu *);
	void (*pmu_disable)(struct pmu *);
	int (*event_init)(struct perf_event *);
	void (*event_mapped)(struct perf_event *, struct mm_struct *);
	void (*event_unmapped)(struct perf_event *, struct mm_struct *);
	int (*add)(struct perf_event *, int);
	void (*del)(struct perf_event *, int);
	void (*start)(struct perf_event *, int);
	void (*stop)(struct perf_event *, int);
	void (*read)(struct perf_event *);
	void (*start_txn)(struct pmu *, unsigned int);
	int (*commit_txn)(struct pmu *);
	void (*cancel_txn)(struct pmu *);
	int (*event_idx)(struct perf_event *);
	void (*sched_task)(struct perf_event_pmu_context *, bool);
	struct kmem_cache *task_ctx_cache;
	void (*swap_task_ctx)(struct perf_event_pmu_context *, struct perf_event_pmu_context *);
	void * (*setup_aux)(struct perf_event *, void **, int, bool);
	void (*free_aux)(void *);
	long (*snapshot_aux)(struct perf_event *, struct perf_output_handle *, unsigned long);
	int (*addr_filters_validate)(struct list_head *);
	void (*addr_filters_sync)(struct perf_event *);
	int (*aux_output_match)(struct perf_event *);
	bool (*filter)(struct pmu *, int);
	int (*check_period)(struct perf_event *, u64);
};

struct amd_uncore_pmu {
	char name[16];
	int num_counters;
	int rdpmc_base;
	u32 msr_base;
	int group;
	cpumask_t active_mask;
	struct pmu pmu;
	struct amd_uncore_ctx * __attribute__((btf_type_tag("percpu"))) *ctx;
};

struct aml_resource_small_header {
	u8 descriptor_type;
};

struct aml_resource_large_header {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_irq {
	u8 descriptor_type;
	u16 irq_mask;
	u8 flags;
} __attribute__((packed));

struct aml_resource_dma {
	u8 descriptor_type;
	u8 dma_channel_mask;
	u8 flags;
};

struct aml_resource_start_dependent {
	u8 descriptor_type;
	u8 flags;
};

struct aml_resource_end_dependent {
	u8 descriptor_type;
};

struct aml_resource_io {
	u8 descriptor_type;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u8 alignment;
	u8 address_length;
};

struct aml_resource_fixed_io {
	u8 descriptor_type;
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct aml_resource_fixed_dma {
	u8 descriptor_type;
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct aml_resource_vendor_small {
	u8 descriptor_type;
};

struct aml_resource_end_tag {
	u8 descriptor_type;
	u8 checksum;
};

struct aml_resource_memory24 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_generic_register {
	u8 descriptor_type;
	u16 resource_length;
	u8 address_space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct aml_resource_vendor_large {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed));

struct aml_resource_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_fixed_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 address;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address16 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
} __attribute__((packed));

struct aml_resource_address32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
} __attribute__((packed));

struct aml_resource_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
} __attribute__((packed));

struct aml_resource_extended_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u8 revision_ID;
	u8 reserved;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
	u64 type_specific;
} __attribute__((packed));

struct aml_resource_extended_irq {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u8 interrupt_count;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct aml_resource_gpio {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 connection_type;
	u16 flags;
	u16 int_flags;
	u8 pin_config;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_i2c_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u16 slave_address;
} __attribute__((packed));

struct aml_resource_spi_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
} __attribute__((packed));

struct aml_resource_uart_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 default_baud_rate;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u8 parity;
	u8 lines_enabled;
} __attribute__((packed));

struct aml_resource_csi2_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_common_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed));

struct aml_resource_pin_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config;
	u16 function_number;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 pin_table_offset;
	u16 label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 function_number;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_pin_group_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed));

struct aml_resource_clock_input {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 frequency_divisor;
	u32 frequency_numerator;
} __attribute__((packed));

struct aml_resource_address {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
} __attribute__((packed));

union aml_resource {
	u8 descriptor_type;
	struct aml_resource_small_header small_header;
	struct aml_resource_large_header large_header;
	struct aml_resource_irq irq;
	struct aml_resource_dma dma;
	struct aml_resource_start_dependent start_dpf;
	struct aml_resource_end_dependent end_dpf;
	struct aml_resource_io io;
	struct aml_resource_fixed_io fixed_io;
	struct aml_resource_fixed_dma fixed_dma;
	struct aml_resource_vendor_small vendor_small;
	struct aml_resource_end_tag end_tag;
	struct aml_resource_memory24 memory24;
	struct aml_resource_generic_register generic_reg;
	struct aml_resource_vendor_large vendor_large;
	struct aml_resource_memory32 memory32;
	struct aml_resource_fixed_memory32 fixed_memory32;
	struct aml_resource_address16 address16;
	struct aml_resource_address32 address32;
	struct aml_resource_address64 address64;
	struct aml_resource_extended_address64 ext_address64;
	struct aml_resource_extended_irq extended_irq;
	struct aml_resource_gpio gpio;
	struct aml_resource_i2c_serialbus i2c_serial_bus;
	struct aml_resource_spi_serialbus spi_serial_bus;
	struct aml_resource_uart_serialbus uart_serial_bus;
	struct aml_resource_csi2_serialbus csi2_serial_bus;
	struct aml_resource_common_serialbus common_serial_bus;
	struct aml_resource_pin_function pin_function;
	struct aml_resource_pin_config pin_config;
	struct aml_resource_pin_group pin_group;
	struct aml_resource_pin_group_function pin_group_function;
	struct aml_resource_pin_group_config pin_group_config;
	struct aml_resource_clock_input clock_input;
	struct aml_resource_address address;
	u32 dword_item;
	u16 word_item;
	u8 byte_item;
};

struct kobj_uevent_env;

struct kobj_ns_type_operations;

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
};

struct transport_container;

struct transport_class {
	struct class class;
	int (*setup)(struct transport_container *, struct device *, struct device *);
	int (*configure)(struct transport_container *, struct device *, struct device *);
	int (*remove)(struct transport_container *, struct device *, struct device *);
};

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
};

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	unsigned long flags;
};

struct anon_transport_class {
	struct transport_class tclass;
	struct attribute_container container;
};

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	unsigned long num_children;
	unsigned long num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
};

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	unsigned long rb_subtree_last;
};

struct anon_vma_name {
	struct kref kref;
	char name[0];
};

struct antenna_setup {
	enum antenna rx;
	enum antenna tx;
	u8 rx_chain_num;
	u8 tx_chain_num;
};

struct apd_private_data;

struct apd_device_desc {
	unsigned int fixed_clk_rate;
	struct property_entry *properties;
	int (*setup)(struct apd_private_data *);
};

struct clk;

struct apd_private_data {
	struct clk *clk;
	struct acpi_device *adev;
	const struct apd_device_desc *dev_desc;
};

struct aperfmperf {
	seqcount_t seq;
	unsigned long last_update;
	u64 acnt;
	u64 mcnt;
	u64 aperf;
	u64 mperf;
};

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
};

struct api_context {
	struct completion done;
	int status;
};

struct apic {
	void (*eoi)(void);
	void (*native_eoi)(void);
	void (*write)(u32, u32);
	u32 (*read)(u32);
	void (*wait_icr_idle)(void);
	u32 (*safe_wait_icr_idle)(void);
	void (*send_IPI)(int, int);
	void (*send_IPI_mask)(const struct cpumask *, int);
	void (*send_IPI_mask_allbutself)(const struct cpumask *, int);
	void (*send_IPI_allbutself)(int);
	void (*send_IPI_all)(int);
	void (*send_IPI_self)(int);
	u32 disable_esr: 1;
	u32 dest_mode_logical: 1;
	u32 x2apic_set_max_apicid: 1;
	u32 nmi_to_offline_cpu: 1;
	u32 (*calc_dest_apicid)(unsigned int);
	u64 (*icr_read)(void);
	void (*icr_write)(u32, u32);
	u32 max_apic_id;
	int (*probe)(void);
	int (*acpi_madt_oem_check)(char *, char *);
	void (*init_apic_ldr)(void);
	u32 (*cpu_present_to_apicid)(int);
	u32 (*get_apic_id)(u32);
	int (*wakeup_secondary_cpu)(u32, unsigned long);
	int (*wakeup_secondary_cpu_64)(u32, unsigned long);
	char *name;
};

struct irq_cfg {
	unsigned int dest_apicid;
	unsigned int vector;
};

struct apic_chip_data {
	struct irq_cfg hw_irq_cfg;
	unsigned int vector;
	unsigned int prev_vector;
	unsigned int cpu;
	unsigned int prev_cpu;
	unsigned int irq;
	struct hlist_node clist;
	unsigned int move_in_progress: 1;
	unsigned int is_managed: 1;
	unsigned int can_reserve: 1;
	unsigned int has_reserved: 1;
};

union apic_ir {
	unsigned long map[4];
	u32 regs[8];
};

struct apic_override {
	void (*eoi)(void);
	void (*native_eoi)(void);
	void (*write)(u32, u32);
	u32 (*read)(u32);
	void (*send_IPI)(int, int);
	void (*send_IPI_mask)(const struct cpumask *, int);
	void (*send_IPI_mask_allbutself)(const struct cpumask *, int);
	void (*send_IPI_allbutself)(int);
	void (*send_IPI_all)(int);
	void (*send_IPI_self)(int);
	u64 (*icr_read)(void);
	void (*icr_write)(u32, u32);
	int (*wakeup_secondary_cpu)(u32, unsigned long);
	int (*wakeup_secondary_cpu_64)(u32, unsigned long);
};

struct apm_bios_info {
	__u16 version;
	__u16 cseg;
	__u32 offset;
	__u16 cseg_16;
	__u16 dseg;
	__u16 flags;
	__u16 cseg_len;
	__u16 cseg_16_len;
	__u16 dseg_len;
};

struct workqueue_attrs;

struct pool_workqueue;

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
};

struct arc4_ctx {
	u32 S[256];
	u32 x;
	u32 y;
};

struct arch_elf_state {};

struct arch_hw_breakpoint {
	unsigned long address;
	unsigned long mask;
	u8 len;
	u8 type;
};

struct arch_hybrid_cpu_scale {
	unsigned long capacity;
	unsigned long freq_ratio;
};

struct arch_io_reserve_memtype_wc_devres {
	resource_size_t start;
	resource_size_t size;
};

struct lbr_entry {
	u64 from;
	u64 to;
	u64 info;
};

struct arch_lbr_state {
	u64 lbr_ctl;
	u64 lbr_depth;
	u64 ler_from;
	u64 ler_to;
	u64 ler_info;
	struct lbr_entry entries[0];
};

struct arch_optimized_insn {
	kprobe_opcode_t copied_insn[4];
	kprobe_opcode_t *insn;
	size_t size;
};

struct kprobe;

struct arch_specific_insn {
	kprobe_opcode_t *insn;
	unsigned int boostable: 1;
	unsigned char size;
	union {
		unsigned char opcode;
		struct {
			unsigned char type;
		} jcc;
		struct {
			unsigned char type;
			unsigned char asize;
		} loop;
		struct {
			unsigned char reg;
		} indirect;
	};
	s32 rel32;
	void (*emulate_op)(struct kprobe *, struct pt_regs *);
	int tp_len;
};

struct arch_tlbflush_unmap_batch {
	struct cpumask cpumask;
};

struct uprobe_xol_ops;

struct arch_uprobe {
	union {
		u8 insn[16];
		u8 ixol[16];
	};
	const struct uprobe_xol_ops *ops;
	union {
		struct {
			s32 offs;
			u8 ilen;
			u8 opc1;
		} branch;
		struct {
			u8 fixups;
			u8 ilen;
		} defparam;
		struct {
			u8 reg_offset;
			u8 ilen;
		} push;
	};
};

struct arch_uprobe_task {
	unsigned long saved_scratch_register;
	unsigned int saved_trap_nr;
	unsigned int saved_tf;
};

struct arch_vdso_time_data {};

struct in6_addr;

struct arg_dev_net_ip {
	struct net *net;
	struct in6_addr *addr;
};

struct arg_netdev_event {
	const struct net_device *dev;
	union {
		unsigned char nh_flags;
		unsigned long event;
	};
};

struct args_askumount {
	__u32 may_umount;
};

struct args_expire {
	__u32 how;
};

struct args_fail {
	__u32 token;
	__s32 status;
};

struct args_in {
	__u32 type;
};

struct args_out {
	__u32 devid;
	__u32 magic;
};

struct args_ismountpoint {
	union {
		struct args_in in;
		struct args_out out;
	};
};

struct args_openmount {
	__u32 devid;
};

struct args_protosubver {
	__u32 sub_version;
};

struct args_protover {
	__u32 version;
};

struct args_ready {
	__u32 token;
};

struct args_requester {
	__u32 uid;
	__u32 gid;
};

struct args_setpipefd {
	__s32 pipefd;
};

struct args_timeout {
	__u64 timeout;
};

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
};

struct arppayload {
	unsigned char mac_src[6];
	unsigned char ip_src[4];
	unsigned char mac_dst[6];
	unsigned char ip_dst[4];
};

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} __empty_sa_data;
			char sa_data[0];
		};
	};
};

struct arpreq {
	struct sockaddr arp_pa;
	struct sockaddr arp_ha;
	int arp_flags;
	struct sockaddr arp_netmask;
	char arp_dev[16];
};

struct in_addr {
	__be32 s_addr;
};

struct arpt_devaddr_info {
	char addr[16];
	char mask[16];
};

struct arpt_arp {
	struct in_addr src;
	struct in_addr tgt;
	struct in_addr smsk;
	struct in_addr tmsk;
	__u8 arhln;
	__u8 arhln_mask;
	struct arpt_devaddr_info src_devaddr;
	struct arpt_devaddr_info tgt_devaddr;
	__be16 arpop;
	__be16 arpop_mask;
	__be16 arhrd;
	__be16 arhrd_mask;
	__be16 arpro;
	__be16 arpro_mask;
	char iniface[16];
	char outiface[16];
	unsigned char iniface_mask[16];
	unsigned char outiface_mask[16];
	__u8 flags;
	__u16 invflags;
};

struct xt_counters {
	__u64 pcnt;
	__u64 bcnt;
};

struct arpt_entry {
	struct arpt_arp arp;
	__u16 target_offset;
	__u16 next_offset;
	unsigned int comefrom;
	struct xt_counters counters;
	unsigned char elems[0];
};

struct trace_array;

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu __attribute__((btf_type_tag("percpu"))) *data;
	u64 time_start;
	int cpu;
};

typedef int (*asn1_action_t)(void *, size_t, unsigned char, const void *, size_t);

struct asn1_decoder {
	const unsigned char *machine;
	size_t machlen;
	const asn1_action_t *actions;
};

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	unsigned long nr_leaves_on_tree;
};

struct assoc_array_node;

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
};

struct assoc_array_ops;

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} set[2];
	struct {
		u8 *p;
		u8 to;
	} set_parent_slot[1];
	u8 segment_cache[17];
};

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	unsigned long nr_leaves_on_branch;
};

struct assoc_array_ops {
	unsigned long (*get_key_chunk)(const void *, int);
	unsigned long (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
};

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	unsigned long index_key[0];
};

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		unsigned long sc_segments;
		unsigned long dissimilarity;
	} wrong_shortcut;
};

struct asym_cap_data {
	struct list_head link;
	struct callback_head rcu;
	unsigned long capacity;
	unsigned long cpus[0];
};

struct asymmetric_key_id {
	unsigned short len;
	unsigned char data[0];
};

struct asymmetric_key_ids {
	void *id[3];
};

struct key_preparsed_payload;

struct asymmetric_key_parser {
	struct list_head link;
	struct module *owner;
	const char *name;
	int (*parse)(struct key_preparsed_payload *);
};

struct key;

struct seq_file;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct public_key_signature;

struct asymmetric_key_subtype {
	struct module *owner;
	const char *name;
	unsigned short name_len;
	void (*describe)(const struct key *, struct seq_file *);
	void (*destroy)(void *, void *);
	int (*query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*verify_signature)(const struct key *, const struct public_key_signature *);
};

struct usb_dev_state;

struct pid;

struct urb;

struct usb_memory;

struct async {
	struct list_head asynclist;
	struct usb_dev_state *ps;
	struct pid *pid;
	const struct cred *cred;
	unsigned int signr;
	unsigned int ifnum;
	void __attribute__((btf_type_tag("user"))) *userbuffer;
	void __attribute__((btf_type_tag("user"))) *userurb;
	sigval_t userurb_sigval;
	struct urb *urb;
	struct usb_memory *usbm;
	unsigned int mem_usage;
	int status;
	u8 bulk_addr;
	u8 bulk_status;
};

struct btrfs_work;

typedef void (*btrfs_func_t)(struct btrfs_work *);

typedef void (*btrfs_ordered_func_t)(struct btrfs_work *, bool);

struct btrfs_workqueue;

struct btrfs_work {
	btrfs_func_t func;
	btrfs_ordered_func_t ordered_func;
	struct work_struct normal_work;
	struct list_head ordered_list;
	struct btrfs_workqueue *wq;
	unsigned long flags;
};

struct btrfs_inode;

struct cgroup_subsys_state;

struct async_cow;

struct async_chunk {
	struct btrfs_inode *inode;
	struct folio *locked_folio;
	u64 start;
	u64 end;
	blk_opf_t write_flags;
	struct list_head extents;
	struct cgroup_subsys_state *blkcg_css;
	struct btrfs_work work;
	struct async_cow *async_cow;
};

struct async_cow {
	atomic_t num_chunks;
	struct async_chunk chunks[0];
};

struct async_domain {
	struct list_head pending;
	unsigned int registered: 1;
};

typedef void (*async_func_t)(void *, async_cookie_t);

struct async_entry {
	struct list_head domain_list;
	struct list_head global_list;
	struct work_struct work;
	async_cookie_t cookie;
	async_func_t func;
	void *data;
	struct async_domain *domain;
};

struct async_extent {
	u64 start;
	u64 ram_size;
	u64 compressed_size;
	struct folio **folios;
	unsigned long nr_folios;
	int compress_type;
	struct list_head list;
};

struct io_poll {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	int retries;
	struct wait_queue_entry wait;
};

struct async_poll {
	struct io_poll poll;
	struct io_poll *double_poll;
};

struct async_scan_data {
	struct list_head list;
	struct Scsi_Host *shost;
	struct completion prev_finished;
};

struct nvme_ctrl;

struct async_scan_info {
	struct nvme_ctrl *ctrl;
	atomic_t next_nsid;
	__le32 *ns_list;
};

struct btrfs_device;

struct btrfs_io_context;

struct btrfs_io_stripe {
	struct btrfs_device *dev;
	u64 physical;
	u64 length;
	bool rst_search_commit_root;
	struct btrfs_io_context *bioc;
};

struct btrfs_bio;

struct async_submit_bio {
	struct btrfs_bio *bbio;
	struct btrfs_io_context *bioc;
	struct btrfs_io_stripe smap;
	int mirror_num;
	struct btrfs_work work;
};

typedef void (*dma_async_tx_callback)(void *);

struct dma_async_tx_descriptor;

struct async_submit_ctl {
	enum async_tx_flags flags;
	struct dma_async_tx_descriptor *depend_tx;
	dma_async_tx_callback cb_fn;
	void *cb_param;
	void *scribble;
};

struct ata_acpi_drive {
	u32 pio;
	u32 dma;
};

struct ata_acpi_gtf {
	u8 tf[7];
};

struct ata_acpi_gtm {
	struct ata_acpi_drive drive[2];
	u32 flags;
};

struct ata_device;

struct ata_acpi_hotplug_context {
	struct acpi_hotplug_context hp;
	union {
		struct ata_port *ap;
		struct ata_device *dev;
	} data;
};

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
};

struct ata_cdl {
	u8 desc_log_buf[512];
	u8 ncq_sense_log_buf[1024];
};

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	u64 start_lba;
	u64 num_lbas;
};

struct ata_cpr_log {
	u8 nr_cpr;
	struct ata_cpr cpr[0];
};

struct ata_dev_quirks_entry {
	const char *model_num;
	const char *model_rev;
	unsigned int quirks;
};

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
};

struct ata_ering {
	int cursor;
	struct ata_ering_entry ring[32];
};

struct scsi_device;

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int quirks;
	unsigned long flags;
	struct scsi_device *sdev;
	void *private_data;
	union acpi_object *gtf_cache;
	unsigned int gtf_filter;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	unsigned long unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	union {
		u16 id[256];
		u32 gscr[128];
	};
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	struct ata_cdl *cdl;
	int spdn_cnt;
	struct ata_ering ering;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u8 sector_buf[512];
};

struct ata_eh_cmd_timeout_ent {
	const u8 *commands;
	const unsigned int *timeouts;
};

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
};

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	unsigned long last_reset;
};

struct ata_force_param {
	const char *name;
	u8 cbl;
	u8 spd_limit;
	unsigned int xfer_mask;
	unsigned int quirk_on;
	unsigned int quirk_off;
	u16 lflags_on;
	u16 lflags_off;
};

struct ata_force_ent {
	int port;
	int device;
	struct ata_force_param param;
};

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	unsigned long flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
};

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
};

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
};

struct ata_internal {
	struct scsi_transport_template t;
	struct device_attribute private_port_attrs[3];
	struct device_attribute private_link_attrs[3];
	struct device_attribute private_dev_attrs[9];
	struct transport_container link_attr_cont;
	struct transport_container dev_attr_cont;
	struct device_attribute *link_attrs[4];
	struct device_attribute *port_attrs[4];
	struct device_attribute *dev_attrs[10];
};

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
};

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct ata_device device[2];
	unsigned long last_lpm_change;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct ata_taskfile {
	unsigned long flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	};
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	};
	u32 auxiliary;
};

struct scatterlist {
	unsigned long page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
};

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct scsi_cmnd;

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	unsigned long flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
};

struct ata_port_stats {
	unsigned long unhandled_irq;
	unsigned long idle_irq;
	unsigned long rw_reqbuf;
};

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	unsigned long flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 64;
	long: 64;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	struct ata_acpi_gtm __acpi_init_gtm;
	long: 64;
	long: 64;
};

struct ata_port_info {
	unsigned long flags;
	unsigned long link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
};

typedef int (*ata_prereset_fn_t)(struct ata_link *, unsigned long);

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, unsigned long);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
	ata_prereset_fn_t pmp_prereset;
	ata_reset_fn_t pmp_softreset;
	ata_reset_fn_t pmp_hardreset;
	ata_postreset_fn_t pmp_postreset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
};

struct ata_show_ering_arg {
	char *buf;
	int written;
};

struct ata_timing {
	unsigned short mode;
	unsigned short setup;
	unsigned short act8b;
	unsigned short rec8b;
	unsigned short cyc8b;
	unsigned short active;
	unsigned short recover;
	unsigned short dmack_hold;
	unsigned short cycle;
	unsigned short udma;
};

struct ata_xfer_ent {
	int shift;
	int bits;
	u8 base;
};

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	unsigned long flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
};

struct vivaldi_data {
	u32 function_row_physmap[24];
	unsigned int num_function_row_keys;
};

struct atkbd {
	struct ps2dev ps2dev;
	struct input_dev *dev;
	char name[64];
	char phys[32];
	unsigned short id;
	unsigned short keycode[512];
	unsigned long force_release_mask[8];
	unsigned char set;
	bool translated;
	bool extra;
	bool write;
	bool softrepeat;
	bool softraw;
	bool scroll;
	bool enabled;
	unsigned char emul;
	bool resend;
	bool release;
	unsigned long xl_bit;
	unsigned int last;
	unsigned long time;
	unsigned long err_count;
	struct delayed_work event_work;
	unsigned long event_jiffies;
	unsigned long event_mask;
	struct mutex mutex;
	struct vivaldi_data vdata;
};

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block __attribute__((btf_type_tag("rcu"))) *head;
};

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, const struct bin_attribute *, int);
	size_t (*bin_size)(struct kobject *, const struct bin_attribute *, int);
	struct attribute **attrs;
	union {
		struct bin_attribute **bin_attrs;
		const struct bin_attribute * const *bin_attrs_new;
	};
};

struct audit_ntp_data {};

struct crypto_spawn {
	struct list_head list;
	struct crypto_alg *alg;
	union {
		struct crypto_instance *inst;
		struct crypto_spawn *next;
	};
	const struct crypto_type *frontend;
	u32 mask;
	bool dead;
	bool registered;
};

struct crypto_ahash_spawn {
	struct crypto_spawn base;
};

struct crypto_skcipher_spawn {
	struct crypto_spawn base;
};

struct authenc_esn_instance_ctx {
	struct crypto_ahash_spawn auth;
	struct crypto_skcipher_spawn enc;
};

struct authenc_esn_request_ctx {
	struct scatterlist src[2];
	struct scatterlist dst[2];
	char tail[0];
};

struct authenc_instance_ctx {
	struct crypto_ahash_spawn auth;
	struct crypto_skcipher_spawn enc;
	unsigned int reqoff;
};

struct authenc_request_ctx {
	struct scatterlist src[2];
	struct scatterlist dst[2];
	char tail[0];
};

struct autofs_dev_ioctl {
	__u32 ver_major;
	__u32 ver_minor;
	__u32 size;
	__s32 ioctlfd;
	union {
		struct args_protover protover;
		struct args_protosubver protosubver;
		struct args_openmount openmount;
		struct args_ready ready;
		struct args_fail fail;
		struct args_setpipefd setpipefd;
		struct args_timeout timeout;
		struct args_requester requester;
		struct args_expire expire;
		struct args_askumount askumount;
		struct args_ismountpoint ismountpoint;
	};
	char path[0];
};

struct autofs_fs_context {
	kuid_t uid;
	kgid_t gid;
	int pgrp;
	bool pgrp_set;
};

struct autofs_sb_info;

struct autofs_info {
	struct dentry *dentry;
	int flags;
	struct completion expire_complete;
	struct list_head active;
	struct list_head expiring;
	struct autofs_sb_info *sbi;
	unsigned long exp_timeout;
	unsigned long last_used;
	int count;
	kuid_t uid;
	kgid_t gid;
	struct callback_head rcu;
};

struct autofs_packet_hdr {
	int proto_version;
	int type;
};

struct autofs_packet_expire {
	struct autofs_packet_hdr hdr;
	int len;
	char name[256];
};

struct autofs_packet_expire_multi {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

struct autofs_packet_missing {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
};

union autofs_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_packet_missing missing;
	struct autofs_packet_expire expire;
	struct autofs_packet_expire_multi expire_multi;
};

struct super_block;

struct autofs_wait_queue;

struct autofs_sb_info {
	u32 magic;
	int pipefd;
	struct file *pipe;
	struct pid *oz_pgrp;
	int version;
	int sub_version;
	int min_proto;
	int max_proto;
	unsigned int flags;
	unsigned long exp_timeout;
	unsigned int type;
	struct super_block *sb;
	struct mutex wq_mutex;
	struct mutex pipe_mutex;
	spinlock_t fs_lock;
	struct autofs_wait_queue *queues;
	spinlock_t lookup_lock;
	struct list_head active_list;
	struct list_head expiring_list;
	struct callback_head rcu;
};

struct autofs_v5_packet {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	__u32 dev;
	__u64 ino;
	__u32 uid;
	__u32 gid;
	__u32 pid;
	__u32 tgid;
	__u32 len;
	char name[256];
};

typedef struct autofs_v5_packet autofs_packet_expire_direct_t;

typedef struct autofs_v5_packet autofs_packet_expire_indirect_t;

typedef struct autofs_v5_packet autofs_packet_missing_direct_t;

typedef struct autofs_v5_packet autofs_packet_missing_indirect_t;

union autofs_v5_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_v5_packet v5_packet;
	autofs_packet_missing_indirect_t missing_indirect;
	autofs_packet_expire_indirect_t expire_indirect;
	autofs_packet_missing_direct_t missing_direct;
	autofs_packet_expire_direct_t expire_direct;
};

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		};
		u64 hash_len;
	};
	const unsigned char *name;
};

struct autofs_wait_queue {
	wait_queue_head_t queue;
	struct autofs_wait_queue *next;
	autofs_wqt_t wait_queue_token;
	struct qstr name;
	u32 offset;
	u32 dev;
	u64 ino;
	kuid_t uid;
	kgid_t gid;
	pid_t pid;
	pid_t tgid;
	int status;
	unsigned int wait_ctr;
};

struct backing_aio {
	struct kiocb iocb;
	refcount_t ref;
	struct kiocb *orig_iocb;
	void (*end_write)(struct kiocb *, ssize_t);
	struct work_struct work;
	long res;
};

struct percpu_counter {
	raw_spinlock_t lock;
	s64 count;
	struct list_head list;
	s32 __attribute__((btf_type_tag("percpu"))) *counters;
};

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
};

struct percpu_ref_data;

struct percpu_ref {
	unsigned long percpu_count_ptr;
	struct percpu_ref_data *data;
};

struct backing_dev_info;

struct bdi_writeback {
	struct backing_dev_info *bdi;
	unsigned long state;
	unsigned long last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	struct percpu_counter stat[4];
	unsigned long bw_time_stamp;
	unsigned long dirtied_stamp;
	unsigned long written_stamp;
	unsigned long write_bandwidth;
	unsigned long avg_write_bandwidth;
	unsigned long dirty_ratelimit;
	unsigned long balanced_dirty_ratelimit;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	};
};

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	unsigned long ra_pages;
	unsigned long io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	unsigned long last_bdp_sleep;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
};

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
};

struct file_ra_state {
	unsigned long start;
	unsigned int size;
	unsigned int async_size;
	unsigned int ra_pages;
	unsigned int mmap_miss;
	loff_t prev_pos;
};

struct file_operations;

struct fown_struct;

struct hlist_head;

struct file {
	file_ref_t f_ref;
	spinlock_t f_lock;
	fmode_t f_mode;
	const struct file_operations *f_op;
	struct address_space *f_mapping;
	void *private_data;
	struct inode *f_inode;
	unsigned int f_flags;
	unsigned int f_iocb_flags;
	const struct cred *f_cred;
	struct path f_path;
	union {
		struct mutex f_pos_lock;
		u64 f_pipe;
	};
	loff_t f_pos;
	struct fown_struct *f_owner;
	errseq_t f_wb_err;
	errseq_t f_sb_err;
	struct hlist_head *f_ep;
	union {
		struct callback_head f_task_work;
		struct llist_node f_llist;
		struct file_ra_state f_ra;
		freeptr_t f_freeptr;
	};
};

struct backing_file {
	struct file file;
	union {
		struct path user_path;
		freeptr_t bf_freeptr;
	};
};

struct backing_file_ctx {
	const struct cred *cred;
	void (*accessed)(struct file *);
	void (*end_write)(struct kiocb *, ssize_t);
};

struct backlight_properties {
	int brightness;
	int max_brightness;
	int power;
	enum backlight_type type;
	unsigned int state;
	enum backlight_scale scale;
};

struct backlight_ops;

struct backlight_device {
	struct backlight_properties props;
	struct mutex update_lock;
	struct mutex ops_lock;
	const struct backlight_ops *ops;
	struct notifier_block fb_notif;
	struct list_head entry;
	struct device dev;
	bool fb_bl_on[32];
	int use_count;
};

struct backlight_ops {
	unsigned int options;
	int (*update_status)(struct backlight_device *);
	int (*get_brightness)(struct backlight_device *);
	bool (*controls_device)(struct backlight_device *, struct device *);
};

struct btrfs_lru_cache_entry {
	struct list_head lru_list;
	u64 key;
	u64 gen;
	struct list_head list;
};

struct backref_cache_entry {
	struct btrfs_lru_cache_entry entry;
	u64 root_ids[17];
	int num_roots;
};

struct send_ctx;

struct backref_ctx {
	struct send_ctx *sctx;
	u64 found;
	u64 cur_objectid;
	u64 cur_offset;
	u64 extent_len;
	u64 bytenr;
	u64 backref_owner;
	u64 backref_offset;
};

struct bpf_verifier_env;

struct backtrack_state {
	struct bpf_verifier_env *env;
	u32 frame;
	u32 reg_masks[8];
	u64 stack_masks[8];
};

struct badblocks {
	struct device *dev;
	int count;
	int unacked_exist;
	int shift;
	u64 *page;
	int changed;
	seqlock_t lock;
	sector_t sector;
	sector_t size;
};

struct badblocks_context {
	sector_t start;
	sector_t len;
	int ack;
};

struct balance_callback {
	struct balance_callback *next;
	void (*func)(struct rq *);
};

struct batadv_unicast_packet {
	__u8 packet_type;
	__u8 version;
	__u8 ttl;
	__u8 ttvn;
	__u8 dest[6];
};

struct batch_u16 {
	u16 entropy[48];
	local_lock_t lock;
	unsigned long generation;
	unsigned int position;
};

struct batch_u32 {
	u32 entropy[24];
	local_lock_t lock;
	unsigned long generation;
	unsigned int position;
};

struct batch_u64 {
	u64 entropy[12];
	local_lock_t lock;
	unsigned long generation;
	unsigned int position;
};

struct batch_u8 {
	u8 entropy[96];
	local_lock_t lock;
	unsigned long generation;
	unsigned int position;
};

struct bd_holder_disk {
	struct list_head list;
	struct kobject *holder_dir;
	int refcnt;
};

struct gendisk;

struct request_queue;

struct disk_stats;

struct blk_holder_ops;

struct partition_meta_info;

struct block_device {
	sector_t bd_start_sect;
	sector_t bd_nr_sectors;
	struct gendisk *bd_disk;
	struct request_queue *bd_queue;
	struct disk_stats __attribute__((btf_type_tag("percpu"))) *bd_stats;
	unsigned long bd_stamp;
	atomic_t __bd_flags;
	dev_t bd_dev;
	struct address_space *bd_mapping;
	atomic_t bd_openers;
	spinlock_t bd_size_lock;
	void *bd_claiming;
	void *bd_holder;
	const struct blk_holder_ops *bd_holder_ops;
	struct mutex bd_holder_lock;
	int bd_holders;
	struct kobject *bd_holder_dir;
	atomic_t bd_fsfreeze_count;
	struct mutex bd_fsfreeze_mutex;
	struct partition_meta_info *bd_meta_info;
	int bd_writers;
	struct device bd_device;
};

struct hlist_head {
	struct hlist_node *first;
};

struct posix_acl;

struct inode_operations;

struct file_lock_context;

struct pipe_inode_info;

struct cdev;

struct fsnotify_mark_connector;

struct inode {
	umode_t i_mode;
	unsigned short i_opflags;
	kuid_t i_uid;
	kgid_t i_gid;
	unsigned int i_flags;
	struct posix_acl *i_acl;
	struct posix_acl *i_default_acl;
	const struct inode_operations *i_op;
	struct super_block *i_sb;
	struct address_space *i_mapping;
	unsigned long i_ino;
	union {
		const unsigned int i_nlink;
		unsigned int __i_nlink;
	};
	dev_t i_rdev;
	loff_t i_size;
	time64_t i_atime_sec;
	time64_t i_mtime_sec;
	time64_t i_ctime_sec;
	u32 i_atime_nsec;
	u32 i_mtime_nsec;
	u32 i_ctime_nsec;
	u32 i_generation;
	spinlock_t i_lock;
	unsigned short i_bytes;
	u8 i_blkbits;
	enum rw_hint i_write_hint;
	blkcnt_t i_blocks;
	u32 i_state;
	struct rw_semaphore i_rwsem;
	unsigned long dirtied_when;
	unsigned long dirtied_time_when;
	struct hlist_node i_hash;
	struct list_head i_io_list;
	struct bdi_writeback *i_wb;
	int i_wb_frn_winner;
	u16 i_wb_frn_avg_time;
	u16 i_wb_frn_history;
	struct list_head i_lru;
	struct list_head i_sb_list;
	struct list_head i_wb_list;
	union {
		struct hlist_head i_dentry;
		struct callback_head i_rcu;
	};
	atomic64_t i_version;
	atomic64_t i_sequence;
	atomic_t i_count;
	atomic_t i_dio_count;
	atomic_t i_writecount;
	atomic_t i_readcount;
	union {
		const struct file_operations *i_fop;
		void (*free_inode)(struct inode *);
	};
	struct file_lock_context *i_flctx;
	struct address_space i_data;
	union {
		struct list_head i_devices;
		int i_linklen;
	};
	union {
		struct pipe_inode_info *i_pipe;
		struct cdev *i_cdev;
		char *i_link;
		unsigned int i_dir_seq;
	};
	__u32 i_fsnotify_mask;
	struct fsnotify_mark_connector __attribute__((btf_type_tag("rcu"))) *i_fsnotify_marks;
	void *i_private;
};

struct bdev_inode {
	struct block_device bdev;
	struct inode vfs_inode;
};

struct ieee80211_meshconf_ie;

struct cfg80211_mbssid_elems;

struct cfg80211_rnr_elems;

struct beacon_data {
	u8 *head;
	u8 *tail;
	int head_len;
	int tail_len;
	struct ieee80211_meshconf_ie *meshconf;
	u16 cntdwn_counter_offsets[2];
	u8 cntdwn_current_counter;
	struct cfg80211_mbssid_elems *mbssid_ies;
	struct cfg80211_rnr_elems *rnr_ies;
	struct callback_head callback_head;
};

struct bfq_sched_data;

struct bfq_queue;

struct bfq_entity {
	struct rb_node rb_node;
	bool on_st_or_in_serv;
	u64 start;
	u64 finish;
	struct rb_root *tree;
	u64 min_start;
	int service;
	int budget;
	int allocated;
	int dev_weight;
	int weight;
	int new_weight;
	int orig_weight;
	struct bfq_entity *parent;
	struct bfq_sched_data *my_sched_data;
	struct bfq_sched_data *sched_data;
	int prio_changed;
	bool in_groups_with_pending_reqs;
	struct bfq_queue *last_bfqq_created;
};

struct bfq_ttime {
	u64 last_end_request;
	u64 ttime_total;
	unsigned long ttime_samples;
	u64 ttime_mean;
};

struct bfq_data;

struct request;

struct bfq_weight_counter;

struct bfq_io_cq;

struct bfq_queue {
	int ref;
	int stable_ref;
	struct bfq_data *bfqd;
	unsigned short ioprio;
	unsigned short ioprio_class;
	unsigned short new_ioprio;
	unsigned short new_ioprio_class;
	u64 last_serv_time_ns;
	unsigned int inject_limit;
	unsigned long decrease_time_jif;
	struct bfq_queue *new_bfqq;
	struct rb_node pos_node;
	struct rb_root *pos_root;
	struct rb_root sort_list;
	struct request *next_rq;
	int queued[2];
	int meta_pending;
	struct list_head fifo;
	struct bfq_entity entity;
	struct bfq_weight_counter *weight_counter;
	int max_budget;
	unsigned long budget_timeout;
	int dispatched;
	unsigned long flags;
	struct list_head bfqq_list;
	struct bfq_ttime ttime;
	u64 io_start_time;
	u64 tot_idle_time;
	u32 seek_history;
	struct hlist_node burst_list_node;
	sector_t last_request_pos;
	unsigned int requests_within_timer;
	pid_t pid;
	struct bfq_io_cq *bic;
	unsigned long wr_cur_max_time;
	unsigned long soft_rt_next_start;
	unsigned long last_wr_start_finish;
	unsigned int wr_coeff;
	unsigned long last_idle_bklogged;
	unsigned long service_from_backlogged;
	unsigned long service_from_wr;
	unsigned long wr_start_at_switch_to_srt;
	unsigned long split_time;
	unsigned long first_IO_time;
	unsigned long creation_time;
	struct bfq_queue *waker_bfqq;
	struct bfq_queue *tentative_waker_bfqq;
	unsigned int num_waker_detections;
	u64 waker_detection_started;
	struct hlist_node woken_list_node;
	struct hlist_head woken_list;
	unsigned int actuator_idx;
};

struct blk_independent_access_range {
	struct kobject kobj;
	sector_t sector;
	sector_t nr_sectors;
};

struct bfq_group;

struct bfq_data {
	struct request_queue *queue;
	struct list_head dispatch;
	struct bfq_group *root_group;
	struct rb_root_cached queue_weights_tree;
	unsigned int num_groups_with_pending_reqs;
	unsigned int busy_queues[3];
	int wr_busy_queues;
	int queued;
	int tot_rq_in_driver;
	int rq_in_driver[8];
	bool nonrot_with_queueing;
	int max_rq_in_driver;
	int hw_tag_samples;
	int hw_tag;
	int budgets_assigned;
	struct hrtimer idle_slice_timer;
	struct bfq_queue *in_service_queue;
	sector_t last_position;
	sector_t in_serv_last_pos;
	u64 last_completion;
	struct bfq_queue *last_completed_rq_bfqq;
	struct bfq_queue *last_bfqq_created;
	u64 last_empty_occupied_ns;
	bool wait_dispatch;
	struct request *waited_rq;
	bool rqs_injected;
	u64 first_dispatch;
	u64 last_dispatch;
	ktime_t last_budget_start;
	ktime_t last_idling_start;
	unsigned long last_idling_start_jiffies;
	int peak_rate_samples;
	u32 sequential_samples;
	u64 tot_sectors_dispatched;
	u32 last_rq_max_size;
	u64 delta_from_first;
	u32 peak_rate;
	int bfq_max_budget;
	struct list_head active_list[8];
	struct list_head idle_list;
	u64 bfq_fifo_expire[2];
	unsigned int bfq_back_penalty;
	unsigned int bfq_back_max;
	u32 bfq_slice_idle;
	int bfq_user_max_budget;
	unsigned int bfq_timeout;
	bool strict_guarantees;
	unsigned long last_ins_in_burst;
	unsigned long bfq_burst_interval;
	int burst_size;
	struct bfq_entity *burst_parent_entity;
	unsigned long bfq_large_burst_thresh;
	bool large_burst;
	struct hlist_head burst_list;
	bool low_latency;
	unsigned int bfq_wr_coeff;
	unsigned int bfq_wr_rt_max_time;
	unsigned int bfq_wr_min_idle_time;
	unsigned long bfq_wr_min_inter_arr_async;
	unsigned int bfq_wr_max_softrt_rate;
	u64 rate_dur_prod;
	struct bfq_queue oom_bfqq;
	spinlock_t lock;
	struct bfq_io_cq *bio_bic;
	struct bfq_queue *bio_bfqq;
	unsigned int word_depths[4];
	unsigned int full_depth_shift;
	unsigned int num_actuators;
	sector_t sector[8];
	sector_t nr_sectors[8];
	struct blk_independent_access_range ia_ranges[8];
	unsigned int actuator_load_threshold;
};

struct blkcg_gq;

struct blkg_policy_data {
	struct blkcg_gq *blkg;
	int plid;
	bool online;
};

struct bfq_service_tree {
	struct rb_root active;
	struct rb_root idle;
	struct bfq_entity *first_idle;
	struct bfq_entity *last_idle;
	u64 vtime;
	unsigned long wsum;
};

struct bfq_sched_data {
	struct bfq_entity *in_service_entity;
	struct bfq_entity *next_in_service;
	struct bfq_service_tree service_tree[3];
	unsigned long bfq_class_idle_last_service;
};

struct blkg_rwstat {
	struct percpu_counter cpu_cnt[5];
	atomic64_t aux_cnt[5];
};

struct bfqg_stats {
	struct blkg_rwstat bytes;
	struct blkg_rwstat ios;
};

struct bfq_group {
	struct blkg_policy_data pd;
	refcount_t ref;
	struct bfq_entity entity;
	struct bfq_sched_data sched_data;
	struct bfq_data *bfqd;
	struct bfq_queue *async_bfqq[128];
	struct bfq_queue *async_idle_bfqq[8];
	struct bfq_entity *my_entity;
	int active_entities;
	int num_queues_with_pending_reqs;
	struct rb_root rq_pos_tree;
	struct bfqg_stats stats;
};

struct blkcg;

struct blkcg_policy_data {
	struct blkcg *blkcg;
	int plid;
};

struct bfq_group_data {
	struct blkcg_policy_data pd;
	unsigned int weight;
};

struct io_context;

struct io_cq {
	struct request_queue *q;
	struct io_context *ioc;
	union {
		struct list_head q_node;
		struct kmem_cache *__rcu_icq_cache;
	};
	union {
		struct hlist_node ioc_node;
		struct callback_head __rcu_head;
	};
	unsigned int flags;
};

struct bfq_iocq_bfqq_data {
	bool saved_has_short_ttime;
	bool saved_IO_bound;
	u64 saved_io_start_time;
	u64 saved_tot_idle_time;
	bool saved_in_large_burst;
	bool was_in_burst_list;
	unsigned int saved_weight;
	unsigned long saved_wr_coeff;
	unsigned long saved_last_wr_start_finish;
	unsigned long saved_service_from_wr;
	unsigned long saved_wr_start_at_switch_to_srt;
	unsigned int saved_wr_cur_max_time;
	struct bfq_ttime saved_ttime;
	u64 saved_last_serv_time_ns;
	unsigned int saved_inject_limit;
	unsigned long saved_decrease_time_jif;
	struct bfq_queue *stable_merge_bfqq;
	bool stably_merged;
};

struct bfq_io_cq {
	struct io_cq icq;
	struct bfq_queue *bfqq[16];
	int ioprio;
	uint64_t blkcg_serial_nr;
	struct bfq_iocq_bfqq_data bfqq_data[8];
	unsigned int requests;
};

struct bfq_weight_counter {
	unsigned int weight;
	unsigned int num_active;
	struct rb_node weights_node;
};

struct bgl_lock {
	spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bh_accounting {
	int nr;
	int ratelimit;
};

struct bh_lru {
	struct buffer_head *bhs[16];
};

struct bictcp {
	u32 cnt;
	u32 last_max_cwnd;
	u32 last_cwnd;
	u32 last_time;
	u32 bic_origin_point;
	u32 bic_K;
	u32 delay_min;
	u32 epoch_start;
	u32 ack_cnt;
	u32 tcp_cwnd;
	u16 unused;
	u8 sample_cnt;
	u8 found;
	u32 round_start;
	u32 end_seq;
	u32 last_ack;
	u32 curr_rtt;
};

struct binfmt_misc {
	struct list_head entries;
	rwlock_t entries_lock;
	bool enabled;
};

struct bvec_iter {
	sector_t bi_sector;
	unsigned int bi_size;
	unsigned int bi_idx;
	unsigned int bi_bvec_done;
} __attribute__((packed));

struct bio;

typedef void bio_end_io_t(struct bio *);

struct bio_issue {
	u64 value;
};

struct bio_vec {
	struct page *bv_page;
	unsigned int bv_len;
	unsigned int bv_offset;
};

struct bio_set;

struct bio {
	struct bio *bi_next;
	struct block_device *bi_bdev;
	blk_opf_t bi_opf;
	unsigned short bi_flags;
	unsigned short bi_ioprio;
	enum rw_hint bi_write_hint;
	blk_status_t bi_status;
	atomic_t __bi_remaining;
	struct bvec_iter bi_iter;
	union {
		blk_qc_t bi_cookie;
		unsigned int __bi_nr_segments;
	};
	bio_end_io_t *bi_end_io;
	void *bi_private;
	struct blkcg_gq *bi_blkg;
	struct bio_issue bi_issue;
	u64 bi_iocost_cost;
	unsigned short bi_vcnt;
	unsigned short bi_max_vecs;
	atomic_t __bi_cnt;
	struct bio_vec *bi_io_vec;
	struct bio_set *bi_pool;
	struct bio_vec bi_inline_vecs[0];
};

struct bio_alloc_cache {
	struct bio *free_list;
	struct bio *free_list_irq;
	unsigned int nr;
	unsigned int nr_irq;
};

struct bio_integrity_payload {
	struct bio *bip_bio;
	struct bvec_iter bip_iter;
	unsigned short bip_vcnt;
	unsigned short bip_max_vcnt;
	unsigned short bip_flags;
	u16 app_tag;
	struct bvec_iter bio_iter;
	struct work_struct bip_work;
	struct bio_vec *bip_vec;
	struct bio_vec bip_inline_vecs[0];
};

struct bio_list {
	struct bio *head;
	struct bio *tail;
};

struct iovec {
	void __attribute__((btf_type_tag("user"))) *iov_base;
	__kernel_size_t iov_len;
};

struct kvec;

struct folio_queue;

struct iov_iter {
	u8 iter_type;
	bool nofault;
	bool data_source;
	size_t iov_offset;
	union {
		struct iovec __ubuf_iovec;
		struct {
			union {
				const struct iovec *__iov;
				const struct kvec *kvec;
				const struct bio_vec *bvec;
				const struct folio_queue *folioq;
				struct xarray *xarray;
				void __attribute__((btf_type_tag("user"))) *ubuf;
			};
			size_t count;
		};
	};
	union {
		unsigned long nr_segs;
		u8 folioq_slot;
		loff_t xarray_start;
	};
};

struct bio_map_data {
	bool is_our_pages: 1;
	bool is_null_mapped: 1;
	struct iov_iter iter;
	struct iovec iov[0];
};

struct bio_post_read_ctx {
	struct bio *bio;
	struct work_struct work;
	unsigned int cur_step;
	unsigned int enabled_steps;
};

typedef void *mempool_alloc_t(gfp_t, void *);

typedef void mempool_free_t(void *, void *);

struct mempool_s {
	spinlock_t lock;
	int min_nr;
	int curr_nr;
	void **elements;
	void *pool_data;
	mempool_alloc_t *alloc;
	mempool_free_t *free;
	wait_queue_head_t wait;
};

typedef struct mempool_s mempool_t;

struct bio_set {
	struct kmem_cache *bio_slab;
	unsigned int front_pad;
	struct bio_alloc_cache __attribute__((btf_type_tag("percpu"))) *cache;
	mempool_t bio_pool;
	mempool_t bvec_pool;
	unsigned int back_pad;
	spinlock_t rescue_lock;
	struct bio_list rescue_list;
	struct work_struct rescue_work;
	struct workqueue_struct *rescue_workqueue;
	struct hlist_node cpuhp_dead;
};

struct bio_slab {
	struct kmem_cache *slab;
	unsigned int slab_ref;
	unsigned int slab_size;
	char name[8];
};

struct bios_value_u32 {
	u8 table_source;
	u8 table_revision;
	u8 reserved[2];
	__le32 value;
};

struct biovec_slab {
	int nr_vecs;
	char *name;
	struct kmem_cache *slab;
};

struct bitmap_page;

struct bitmap_counts {
	spinlock_t lock;
	struct bitmap_page *bp;
	unsigned long pages;
	unsigned long missing_pages;
	unsigned long chunkshift;
	unsigned long chunks;
};

struct bitmap_storage {
	struct file *file;
	struct page *sb_page;
	unsigned long sb_index;
	struct page **filemap;
	unsigned long *filemap_attr;
	unsigned long file_pages;
	unsigned long bytes;
};

struct mddev;

struct bitmap {
	struct bitmap_counts counts;
	struct mddev *mddev;
	__u64 events_cleared;
	int need_sync;
	struct bitmap_storage storage;
	unsigned long flags;
	int allclean;
	atomic_t behind_writes;
	unsigned long behind_writes_used;
	unsigned long daemon_lastrun;
	unsigned long last_end_sync;
	atomic_t pending_writes;
	wait_queue_head_t write_wait;
	wait_queue_head_t overflow_wait;
	wait_queue_head_t behind_wait;
	struct kernfs_node *sysfs_can_clear;
	int cluster_slot;
};

struct md_bitmap_stats;

struct bitmap_operations {
	bool (*enabled)(struct mddev *);
	int (*create)(struct mddev *, int);
	int (*resize)(struct mddev *, sector_t, int, bool);
	int (*load)(struct mddev *);
	void (*destroy)(struct mddev *);
	void (*flush)(struct mddev *);
	void (*write_all)(struct mddev *);
	void (*dirty_bits)(struct mddev *, unsigned long, unsigned long);
	void (*unplug)(struct mddev *, bool);
	void (*daemon_work)(struct mddev *);
	void (*start_behind_write)(struct mddev *);
	void (*end_behind_write)(struct mddev *);
	void (*wait_behind_writes)(struct mddev *);
	int (*startwrite)(struct mddev *, sector_t, unsigned long);
	void (*endwrite)(struct mddev *, sector_t, unsigned long);
	bool (*start_sync)(struct mddev *, sector_t, sector_t *, bool);
	void (*end_sync)(struct mddev *, sector_t, sector_t *);
	void (*cond_end_sync)(struct mddev *, sector_t, bool);
	void (*close_sync)(struct mddev *);
	void (*update_sb)(void *);
	int (*get_stats)(void *, struct md_bitmap_stats *);
	void (*sync_with_cluster)(struct mddev *, sector_t, sector_t, sector_t, sector_t);
	void * (*get_from_slot)(struct mddev *, int);
	int (*copy_from_slot)(struct mddev *, int, sector_t *, sector_t *, bool);
	void (*set_pages)(void *, unsigned long);
	void (*free)(void *);
};

struct bitmap_page {
	char *map;
	unsigned int hijacked: 1;
	unsigned int pending: 1;
	unsigned int count: 30;
};

struct bitmap_super_s {
	__le32 magic;
	__le32 version;
	__u8 uuid[16];
	__le64 events;
	__le64 events_cleared;
	__le64 sync_size;
	__le32 state;
	__le32 chunksize;
	__le32 daemon_sleep;
	__le32 write_behind;
	__le32 sectors_reserved;
	__le32 nodes;
	__u8 cluster_name[64];
	__u8 pad[120];
};

typedef struct bitmap_super_s bitmap_super_t;

struct bitmap_unplug_work {
	struct work_struct work;
	struct bitmap *bitmap;
	struct completion *done;
};

struct blacklist_entry {
	struct list_head next;
	char *buf;
};

struct blake2b_state {
	u64 h[8];
	u64 t[2];
	u64 f[2];
	u8 buf[128];
	unsigned int buflen;
	unsigned int outlen;
};

struct blake2b_tfm_ctx {
	u8 key[64];
	unsigned int keylen;
};

struct blake2s_state {
	u32 h[8];
	u32 t[2];
	u32 f[2];
	u8 buf[64];
	unsigned int buflen;
	unsigned int outlen;
};

struct blk_crypto_config {
	enum blk_crypto_mode_num crypto_mode;
	unsigned int data_unit_size;
	unsigned int dun_bytes;
};

struct blk_crypto_key {
	struct blk_crypto_config crypto_cfg;
	unsigned int data_unit_size_bits;
	unsigned int size;
	u8 raw[64];
};

struct blk_crypto_profile;

struct blk_crypto_ll_ops {
	int (*keyslot_program)(struct blk_crypto_profile *, const struct blk_crypto_key *, unsigned int);
	int (*keyslot_evict)(struct blk_crypto_profile *, const struct blk_crypto_key *, unsigned int);
};

struct blk_crypto_keyslot;

struct blk_crypto_profile {
	struct blk_crypto_ll_ops ll_ops;
	unsigned int max_dun_bytes_supported;
	unsigned int modes_supported[5];
	struct device *dev;
	unsigned int num_slots;
	struct rw_semaphore lock;
	struct lock_class_key lockdep_key;
	wait_queue_head_t idle_slots_wait_queue;
	struct list_head idle_slots;
	spinlock_t idle_slots_lock;
	struct hlist_head *slot_hashtable;
	unsigned int log_slot_ht_size;
	struct blk_crypto_keyslot *slots;
};

struct blk_expired_data {
	bool has_timedout_rq;
	unsigned long next;
	unsigned long timeout_start;
};

struct blk_flush_queue {
	spinlock_t mq_flush_lock;
	unsigned int flush_pending_idx: 1;
	unsigned int flush_running_idx: 1;
	blk_status_t rq_status;
	unsigned long flush_pending_since;
	struct list_head flush_queue[2];
	unsigned long flush_data_in_flight;
	struct request *flush_rq;
};

struct blk_holder_ops {
	void (*mark_dead)(struct block_device *, bool);
	void (*sync)(struct block_device *);
	int (*freeze)(struct block_device *);
	int (*thaw)(struct block_device *);
};

struct blk_ia_range_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_independent_access_range *, char *);
};

struct blk_independent_access_ranges {
	struct kobject kobj;
	bool sysfs_registered;
	unsigned int nr_ia_ranges;
	struct blk_independent_access_range ia_range[0];
};

struct blk_integrity {
	unsigned char flags;
	enum blk_integrity_checksum csum_type;
	unsigned char tuple_size;
	unsigned char pi_offset;
	unsigned char interval_exp;
	unsigned char tag_size;
};

struct blk_io_trace {
	__u32 magic;
	__u32 sequence;
	__u64 time;
	__u64 sector;
	__u32 bytes;
	__u32 action;
	__u32 pid;
	__u32 device;
	__u32 cpu;
	__u16 error;
	__u16 pdu_len;
};

struct blk_io_trace_remap {
	__be32 device_from;
	__be32 device_to;
	__be64 sector_from;
};

struct rq_qos_ops;

struct rq_qos {
	const struct rq_qos_ops *ops;
	struct gendisk *disk;
	enum rq_qos_id id;
	struct rq_qos *next;
	struct dentry *debugfs_dir;
};

struct blk_iolatency {
	struct rq_qos rqos;
	struct timer_list timer;
	bool enabled;
	atomic_t enable_cnt;
	struct work_struct enable_work;
};

struct blk_iou_cmd {
	int res;
	bool nowait;
};

struct blk_major_name {
	struct blk_major_name *next;
	int major;
	char name[16];
	void (*probe)(dev_t);
};

struct rq_list;

struct blk_mq_ctx;

struct blk_mq_hw_ctx;

struct blk_mq_alloc_data {
	struct request_queue *q;
	blk_mq_req_flags_t flags;
	unsigned int shallow_depth;
	blk_opf_t cmd_flags;
	req_flags_t rq_flags;
	unsigned int nr_tags;
	struct rq_list *cached_rqs;
	struct blk_mq_ctx *ctx;
	struct blk_mq_hw_ctx *hctx;
};

struct blk_mq_ctxs;

struct blk_mq_ctx {
	struct {
		spinlock_t lock;
		struct list_head rq_lists[3];
		long: 64;
	};
	unsigned int cpu;
	unsigned short index_hw[3];
	struct blk_mq_hw_ctx *hctxs[3];
	struct request_queue *queue;
	struct blk_mq_ctxs *ctxs;
	struct kobject kobj;
	long: 64;
};

struct blk_mq_ctxs {
	struct kobject kobj;
	struct blk_mq_ctx __attribute__((btf_type_tag("percpu"))) *queue_ctx;
};

struct seq_operations;

struct blk_mq_debugfs_attr {
	const char *name;
	umode_t mode;
	int (*show)(void *, struct seq_file *);
	ssize_t (*write)(void *, const char __attribute__((btf_type_tag("user"))) *, size_t, loff_t *);
	const struct seq_operations *seq_ops;
};

struct sbitmap_word;

struct sbitmap {
	unsigned int depth;
	unsigned int shift;
	unsigned int map_nr;
	bool round_robin;
	struct sbitmap_word *map;
	unsigned int __attribute__((btf_type_tag("percpu"))) *alloc_hint;
};

typedef struct wait_queue_entry wait_queue_entry_t;

struct blk_mq_hw_ctx {
	struct {
		spinlock_t lock;
		struct list_head dispatch;
		unsigned long state;
		long: 64;
		long: 64;
		long: 64;
		long: 64;
	};
	struct delayed_work run_work;
	cpumask_var_t cpumask;
	int next_cpu;
	int next_cpu_batch;
	unsigned long flags;
	void *sched_data;
	struct request_queue *queue;
	struct blk_flush_queue *fq;
	void *driver_data;
	struct sbitmap ctx_map;
	struct blk_mq_ctx *dispatch_from;
	unsigned int dispatch_busy;
	unsigned short type;
	unsigned short nr_ctx;
	struct blk_mq_ctx **ctxs;
	spinlock_t dispatch_wait_lock;
	wait_queue_entry_t dispatch_wait;
	atomic_t wait_index;
	struct blk_mq_tags *tags;
	struct blk_mq_tags *sched_tags;
	unsigned int numa_node;
	unsigned int queue_num;
	atomic_t nr_active;
	struct hlist_node cpuhp_online;
	struct hlist_node cpuhp_dead;
	struct kobject kobj;
	struct dentry *debugfs_dir;
	struct dentry *sched_debugfs_dir;
	struct list_head hctx_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct blk_mq_hw_ctx_sysfs_entry {
	struct attribute attr;
	ssize_t (*show)(struct blk_mq_hw_ctx *, char *);
};

struct blk_mq_queue_data;

struct io_comp_batch;

struct blk_mq_ops {
	blk_status_t (*queue_rq)(struct blk_mq_hw_ctx *, const struct blk_mq_queue_data *);
	void (*commit_rqs)(struct blk_mq_hw_ctx *);
	void (*queue_rqs)(struct rq_list *);
	int (*get_budget)(struct request_queue *);
	void (*put_budget)(struct request_queue *, int);
	void (*set_rq_budget_token)(struct request *, int);
	int (*get_rq_budget_token)(struct request *);
	enum blk_eh_timer_return (*timeout)(struct request *);
	int (*poll)(struct blk_mq_hw_ctx *, struct io_comp_batch *);
	void (*complete)(struct request *);
	int (*init_hctx)(struct blk_mq_hw_ctx *, void *, unsigned int);
	void (*exit_hctx)(struct blk_mq_hw_ctx *, unsigned int);
	int (*init_request)(struct blk_mq_tag_set *, struct request *, unsigned int, unsigned int);
	void (*exit_request)(struct blk_mq_tag_set *, struct request *, unsigned int);
	void (*cleanup_rq)(struct request *);
	bool (*busy)(struct request_queue *);
	void (*map_queues)(struct blk_mq_tag_set *);
	void (*show_rq)(struct seq_file *, struct request *);
};

struct elevator_type;

struct blk_mq_qe_pair {
	struct list_head node;
	struct request_queue *q;
	struct elevator_type *type;
};

struct blk_mq_queue_data {
	struct request *rq;
	bool last;
};

struct sbq_wait_state;

struct sbitmap_queue {
	struct sbitmap sb;
	unsigned int wake_batch;
	atomic_t wake_index;
	struct sbq_wait_state *ws;
	atomic_t ws_active;
	unsigned int min_shallow_depth;
	atomic_t completion_cnt;
	atomic_t wakeup_cnt;
};

struct blk_mq_tags {
	unsigned int nr_tags;
	unsigned int nr_reserved_tags;
	unsigned int active_queues;
	struct sbitmap_queue bitmap_tags;
	struct sbitmap_queue breserved_tags;
	struct request **rqs;
	struct request **static_rqs;
	struct list_head page_list;
	spinlock_t lock;
};

struct rq_list {
	struct request *head;
	struct request *tail;
};

struct blk_plug {
	struct rq_list mq_list;
	struct rq_list cached_rqs;
	u64 cur_ktime;
	unsigned short nr_ios;
	unsigned short rq_count;
	bool multiple_queues;
	bool has_elevator;
	struct list_head cb_list;
};

struct blk_plug_cb;

typedef void (*blk_plug_cb_fn)(struct blk_plug_cb *, bool);

struct blk_plug_cb {
	struct list_head list;
	blk_plug_cb_fn callback;
	void *data;
};

struct blk_queue_stats {
	struct list_head callbacks;
	spinlock_t lock;
	int accounting;
};

struct blk_rq_stat {
	u64 mean;
	u64 min;
	u64 max;
	u32 nr_samples;
	u64 batch;
};

struct blk_rq_wait {
	struct completion done;
	blk_status_t ret;
};

struct blk_stat_callback {
	struct list_head list;
	struct timer_list timer;
	struct blk_rq_stat __attribute__((btf_type_tag("percpu"))) *cpu_stat;
	int (*bucket_fn)(const struct request *);
	unsigned int buckets;
	struct blk_rq_stat *stat;
	void (*timer_fn)(struct blk_stat_callback *);
	void *data;
	struct callback_head rcu;
};

struct rchan;

struct blk_trace {
	int trace_state;
	struct rchan *rchan;
	unsigned long __attribute__((btf_type_tag("percpu"))) *sequence;
	unsigned char __attribute__((btf_type_tag("percpu"))) *msg_data;
	u16 act_mask;
	u64 start_lba;
	u64 end_lba;
	u32 pid;
	u32 dev;
	struct dentry *dir;
	struct list_head running_list;
	atomic_t dropped;
};

struct blk_user_trace_setup {
	char name[32];
	__u16 act_mask;
	__u32 buf_size;
	__u32 buf_nr;
	__u64 start_lba;
	__u64 end_lba;
	__u32 pid;
};

struct blk_zone {
	__u64 start;
	__u64 len;
	__u64 wp;
	__u8 type;
	__u8 cond;
	__u8 non_seq;
	__u8 reset;
	__u8 resv[4];
	__u64 capacity;
	__u8 reserved[24];
};

struct cgroup_subsys;

struct cgroup_subsys_state {
	struct cgroup *cgroup;
	struct cgroup_subsys *ss;
	struct percpu_ref refcnt;
	struct list_head sibling;
	struct list_head children;
	struct list_head rstat_css_node;
	int id;
	unsigned int flags;
	u64 serial_nr;
	atomic_t online_cnt;
	struct work_struct destroy_work;
	struct rcu_work destroy_rwork;
	struct cgroup_subsys_state *parent;
	int nr_descendants;
};

struct llist_head;

struct blkcg {
	struct cgroup_subsys_state css;
	spinlock_t lock;
	refcount_t online_pin;
	atomic_t congestion_count;
	struct xarray blkg_tree;
	struct blkcg_gq __attribute__((btf_type_tag("rcu"))) *blkg_hint;
	struct hlist_head blkg_list;
	struct blkcg_policy_data *cpd[6];
	struct list_head all_blkcgs_node;
	struct llist_head __attribute__((btf_type_tag("percpu"))) *lhead;
	struct list_head cgwb_list;
};

struct blkg_iostat {
	u64 bytes[3];
	u64 ios[3];
};

struct blkg_iostat_set {
	struct u64_stats_sync sync;
	struct blkcg_gq *blkg;
	struct llist_node lnode;
	int lqueued;
	struct blkg_iostat cur;
	struct blkg_iostat last;
};

struct blkcg_gq {
	struct request_queue *q;
	struct list_head q_node;
	struct hlist_node blkcg_node;
	struct blkcg *blkcg;
	struct blkcg_gq *parent;
	struct percpu_ref refcnt;
	bool online;
	struct blkg_iostat_set __attribute__((btf_type_tag("percpu"))) *iostat_cpu;
	struct blkg_iostat_set iostat;
	struct blkg_policy_data *pd[6];
	spinlock_t async_bio_lock;
	struct bio_list async_bios;
	union {
		struct work_struct async_bio_work;
		struct work_struct free_work;
	};
	atomic_t use_delay;
	atomic64_t delay_nsec;
	atomic64_t delay_start;
	u64 last_delay;
	int last_use;
	struct callback_head callback_head;
};

typedef struct blkcg_policy_data *blkcg_pol_alloc_cpd_fn(gfp_t);

typedef void blkcg_pol_free_cpd_fn(struct blkcg_policy_data *);

typedef struct blkg_policy_data *blkcg_pol_alloc_pd_fn(struct gendisk *, struct blkcg *, gfp_t);

typedef void blkcg_pol_init_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_online_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_offline_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_free_pd_fn(struct blkg_policy_data *);

typedef void blkcg_pol_reset_pd_stats_fn(struct blkg_policy_data *);

typedef void blkcg_pol_stat_pd_fn(struct blkg_policy_data *, struct seq_file *);

struct cftype;

struct blkcg_policy {
	int plid;
	struct cftype *dfl_cftypes;
	struct cftype *legacy_cftypes;
	blkcg_pol_alloc_cpd_fn *cpd_alloc_fn;
	blkcg_pol_free_cpd_fn *cpd_free_fn;
	blkcg_pol_alloc_pd_fn *pd_alloc_fn;
	blkcg_pol_init_pd_fn *pd_init_fn;
	blkcg_pol_online_pd_fn *pd_online_fn;
	blkcg_pol_offline_pd_fn *pd_offline_fn;
	blkcg_pol_free_pd_fn *pd_free_fn;
	blkcg_pol_reset_pd_stats_fn *pd_reset_stats_fn;
	blkcg_pol_stat_pd_fn *pd_stat_fn;
};

struct blkdev_dio {
	union {
		struct kiocb *iocb;
		struct task_struct *waiter;
	};
	size_t size;
	atomic_t ref;
	unsigned int flags;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct bio bio;
	long: 64;
};

struct blkg_conf_ctx {
	char *input;
	char *body;
	struct block_device *bdev;
	struct blkcg_gq *blkg;
};

struct blkg_rwstat_sample {
	u64 cnt[5];
};

struct blkpg_ioctl_arg {
	int op;
	int flags;
	int datalen;
	void __attribute__((btf_type_tag("user"))) *data;
};

struct blkpg_partition {
	long long start;
	long long length;
	int pno;
	char devname[64];
	char volname[64];
};

typedef int (*report_zones_cb)(struct blk_zone *, unsigned int, void *);

struct hd_geometry;

struct pr_ops;

struct block_device_operations {
	void (*submit_bio)(struct bio *);
	int (*poll_bio)(struct bio *, struct io_comp_batch *, unsigned int);
	int (*open)(struct gendisk *, blk_mode_t);
	void (*release)(struct gendisk *);
	int (*ioctl)(struct block_device *, blk_mode_t, unsigned int, unsigned long);
	int (*compat_ioctl)(struct block_device *, blk_mode_t, unsigned int, unsigned long);
	unsigned int (*check_events)(struct gendisk *, unsigned int);
	void (*unlock_native_capacity)(struct gendisk *);
	int (*getgeo)(struct block_device *, struct hd_geometry *);
	int (*set_read_only)(struct block_device *, bool);
	void (*free_disk)(struct gendisk *);
	void (*swap_slot_free_notify)(struct block_device *, unsigned long);
	int (*report_zones)(struct gendisk *, sector_t, unsigned int, report_zones_cb, void *);
	char * (*devnode)(struct gendisk *, umode_t *);
	int (*get_unique_id)(struct gendisk *, u8 *, enum blk_unique_id);
	struct module *owner;
	const struct pr_ops *pr_ops;
	int (*alternative_gpt_sector)(struct gendisk *, sector_t *);
};

struct blockgroup_lock {
	struct bgl_lock locks[128];
};

struct blocking_notifier_head {
	struct rw_semaphore rwsem;
	struct notifier_block __attribute__((btf_type_tag("rcu"))) *head;
};

struct mem_zone_bm_rtree;

struct rtree_node;

struct bm_position {
	struct mem_zone_bm_rtree *zone;
	struct rtree_node *node;
	unsigned long node_pfn;
	unsigned long cur_pfn;
	int node_bit;
};

struct boot_e820_entry {
	__u64 addr;
	__u64 size;
	__u32 type;
} __attribute__((packed));

struct screen_info {
	__u8 orig_x;
	__u8 orig_y;
	__u16 ext_mem_k;
	__u16 orig_video_page;
	__u8 orig_video_mode;
	__u8 orig_video_cols;
	__u8 flags;
	__u8 unused2;
	__u16 orig_video_ega_bx;
	__u16 unused3;
	__u8 orig_video_lines;
	__u8 orig_video_isVGA;
	__u16 orig_video_points;
	__u16 lfb_width;
	__u16 lfb_height;
	__u16 lfb_depth;
	__u32 lfb_base;
	__u32 lfb_size;
	__u16 cl_magic;
	__u16 cl_offset;
	__u16 lfb_linelength;
	__u8 red_size;
	__u8 red_pos;
	__u8 green_size;
	__u8 green_pos;
	__u8 blue_size;
	__u8 blue_pos;
	__u8 rsvd_size;
	__u8 rsvd_pos;
	__u16 vesapm_seg;
	__u16 vesapm_off;
	__u16 pages;
	__u16 vesa_attributes;
	__u32 capabilities;
	__u32 ext_lfb_base;
	__u8 _reserved[2];
} __attribute__((packed));

struct ist_info {
	__u32 signature;
	__u32 command;
	__u32 event;
	__u32 perf_level;
};

struct sys_desc_table {
	__u16 length;
	__u8 table[14];
};

struct olpc_ofw_header {
	__u32 ofw_magic;
	__u32 ofw_version;
	__u32 cif_handler;
	__u32 irq_desc_table;
};

struct edid_info {
	unsigned char dummy[128];
};

struct efi_info {
	__u32 efi_loader_signature;
	__u32 efi_systab;
	__u32 efi_memdesc_size;
	__u32 efi_memdesc_version;
	__u32 efi_memmap;
	__u32 efi_memmap_size;
	__u32 efi_systab_hi;
	__u32 efi_memmap_hi;
};

struct setup_header {
	__u8 setup_sects;
	__u16 root_flags;
	__u32 syssize;
	__u16 ram_size;
	__u16 vid_mode;
	__u16 root_dev;
	__u16 boot_flag;
	__u16 jump;
	__u32 header;
	__u16 version;
	__u32 realmode_swtch;
	__u16 start_sys_seg;
	__u16 kernel_version;
	__u8 type_of_loader;
	__u8 loadflags;
	__u16 setup_move_size;
	__u32 code32_start;
	__u32 ramdisk_image;
	__u32 ramdisk_size;
	__u32 bootsect_kludge;
	__u16 heap_end_ptr;
	__u8 ext_loader_ver;
	__u8 ext_loader_type;
	__u32 cmd_line_ptr;
	__u32 initrd_addr_max;
	__u32 kernel_alignment;
	__u8 relocatable_kernel;
	__u8 min_alignment;
	__u16 xloadflags;
	__u32 cmdline_size;
	__u32 hardware_subarch;
	__u64 hardware_subarch_data;
	__u32 payload_offset;
	__u32 payload_length;
	__u64 setup_data;
	__u64 pref_address;
	__u32 init_size;
	__u32 handover_offset;
	__u32 kernel_info_offset;
} __attribute__((packed));

struct edd_device_params {
	__u16 length;
	__u16 info_flags;
	__u32 num_default_cylinders;
	__u32 num_default_heads;
	__u32 sectors_per_track;
	__u64 number_of_sectors;
	__u16 bytes_per_sector;
	__u32 dpte_ptr;
	__u16 key;
	__u8 device_path_info_length;
	__u8 reserved2;
	__u16 reserved3;
	__u8 host_bus_type[4];
	__u8 interface_type[8];
	union {
		struct {
			__u16 base_address;
			__u16 reserved1;
			__u32 reserved2;
		} isa;
		struct {
			__u8 bus;
			__u8 slot;
			__u8 function;
			__u8 channel;
			__u32 reserved;
		} pci;
		struct {
			__u64 reserved;
		} ibnd;
		struct {
			__u64 reserved;
		} xprs;
		struct {
			__u64 reserved;
		} htpt;
		struct {
			__u64 reserved;
		} unknown;
	} interface_path;
	union {
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} ata;
		struct {
			__u8 device;
			__u8 lun;
			__u8 reserved1;
			__u8 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} atapi;
		struct {
			__u16 id;
			__u64 lun;
			__u16 reserved1;
			__u32 reserved2;
		} __attribute__((packed)) scsi;
		struct {
			__u64 serial_number;
			__u64 reserved;
		} usb;
		struct {
			__u64 eui;
			__u64 reserved;
		} i1394;
		struct {
			__u64 wwid;
			__u64 lun;
		} fibre;
		struct {
			__u64 identity_tag;
			__u64 reserved;
		} i2o;
		struct {
			__u32 array_number;
			__u32 reserved1;
			__u64 reserved2;
		} raid;
		struct {
			__u8 device;
			__u8 reserved1;
			__u16 reserved2;
			__u32 reserved3;
			__u64 reserved4;
		} sata;
		struct {
			__u64 reserved1;
			__u64 reserved2;
		} unknown;
	} device_path;
	__u8 reserved4;
	__u8 checksum;
} __attribute__((packed));

struct edd_info {
	__u8 device;
	__u8 version;
	__u16 interface_support;
	__u16 legacy_max_cylinder;
	__u8 legacy_max_head;
	__u8 legacy_sectors_per_track;
	struct edd_device_params params;
};

struct boot_params {
	struct screen_info screen_info;
	struct apm_bios_info apm_bios_info;
	__u8 _pad2[4];
	__u64 tboot_addr;
	struct ist_info ist_info;
	__u64 acpi_rsdp_addr;
	__u8 _pad3[8];
	__u8 hd0_info[16];
	__u8 hd1_info[16];
	struct sys_desc_table sys_desc_table;
	struct olpc_ofw_header olpc_ofw_header;
	__u32 ext_ramdisk_image;
	__u32 ext_ramdisk_size;
	__u32 ext_cmd_line_ptr;
	__u8 _pad4[112];
	__u32 cc_blob_address;
	struct edid_info edid_info;
	struct efi_info efi_info;
	__u32 alt_mem_k;
	__u32 scratch;
	__u8 e820_entries;
	__u8 eddbuf_entries;
	__u8 edd_mbr_sig_buf_entries;
	__u8 kbd_status;
	__u8 secure_boot;
	__u8 _pad5[2];
	__u8 sentinel;
	__u8 _pad6[1];
	struct setup_header hdr;
	__u8 _pad7[36];
	__u32 edd_mbr_sig_buffer[16];
	struct boot_e820_entry e820_table[128];
	__u8 _pad8[48];
	struct edd_info eddbuf[6];
	__u8 _pad9[276];
};

struct boot_params_to_save {
	unsigned int start;
	unsigned int len;
};

struct boot_triggers {
	const char *event;
	char *trigger;
};

struct bp_slots_histogram {
	atomic_t count[4];
};

struct bp_cpuinfo {
	unsigned int cpu_pinned;
	struct bp_slots_histogram tsk_pinned;
};

struct text_poke_loc;

struct bp_patching_desc {
	struct text_poke_loc *vec;
	int nr_entries;
	atomic_t refs;
};

struct bpf_map_ops;

struct btf_record;

struct btf;

struct obj_cgroup;

struct btf_type;

struct bpf_map {
	const struct bpf_map_ops *ops;
	struct bpf_map *inner_map_meta;
	enum bpf_map_type map_type;
	u32 key_size;
	u32 value_size;
	u32 max_entries;
	u64 map_extra;
	u32 map_flags;
	u32 id;
	struct btf_record *record;
	int numa_node;
	u32 btf_key_type_id;
	u32 btf_value_type_id;
	u32 btf_vmlinux_value_type_id;
	struct btf *btf;
	struct obj_cgroup *objcg;
	char name[16];
	struct mutex freeze_mutex;
	atomic64_t refcnt;
	atomic64_t usercnt;
	union {
		struct work_struct work;
		struct callback_head rcu;
	};
	atomic64_t writecnt;
	struct {
		const struct btf_type *attach_func_proto;
		spinlock_t lock;
		enum bpf_prog_type type;
		bool jited;
		bool xdp_has_frags;
	} owner;
	bool bypass_spec_v1;
	bool frozen;
	bool free_after_mult_rcu_gp;
	bool free_after_rcu_gp;
	atomic64_t sleepable_refcnt;
	s64 __attribute__((btf_type_tag("percpu"))) *elem_count;
};

struct range_tree {
	struct rb_root_cached it_root;
	struct rb_root_cached range_size_root;
};

struct vm_struct;

struct bpf_arena {
	struct bpf_map map;
	u64 user_vm_start;
	u64 user_vm_end;
	struct vm_struct *kern_vm;
	struct range_tree rt;
	struct list_head vma_list;
	struct mutex lock;
};

struct bpf_array_aux;

struct bpf_array {
	struct bpf_map map;
	u32 elem_size;
	u32 index_mask;
	struct bpf_array_aux *aux;
	union {
		struct {
			struct {} __empty_value;
			char value[0];
		};
		struct {
			struct {} __empty_ptrs;
			void *ptrs[0];
		};
		struct {
			struct {} __empty_pptrs;
			void __attribute__((btf_type_tag("percpu"))) *pptrs[0];
		};
	};
};

struct bpf_array_aux {
	struct list_head poke_progs;
	struct bpf_map *map;
	struct mutex poke_mutex;
	struct work_struct work;
};

struct bpf_prog;

struct bpf_async_cb {
	struct bpf_map *map;
	struct bpf_prog *prog;
	void __attribute__((btf_type_tag("rcu"))) *callback_fn;
	void *value;
	union {
		struct callback_head rcu;
		struct work_struct delete_work;
	};
	u64 flags;
};

struct bpf_spin_lock {
	__u32 val;
};

struct bpf_hrtimer;

struct bpf_work;

struct bpf_async_kern {
	union {
		struct bpf_async_cb *cb;
		struct bpf_hrtimer *timer;
		struct bpf_work *work;
	};
	struct bpf_spin_lock lock;
};

struct btf_func_model {
	u8 ret_size;
	u8 ret_flags;
	u8 nr_args;
	u8 arg_size[12];
	u8 arg_flags[12];
};

struct bpf_attach_target_info {
	struct btf_func_model fmodel;
	long tgt_addr;
	struct module *tgt_mod;
	const char *tgt_name;
	const struct btf_type *tgt_type;
};

union bpf_attr {
	struct {
		__u32 map_type;
		__u32 key_size;
		__u32 value_size;
		__u32 max_entries;
		__u32 map_flags;
		__u32 inner_map_fd;
		__u32 numa_node;
		char map_name[16];
		__u32 map_ifindex;
		__u32 btf_fd;
		__u32 btf_key_type_id;
		__u32 btf_value_type_id;
		__u32 btf_vmlinux_value_type_id;
		__u64 map_extra;
		__s32 value_type_btf_obj_fd;
		__s32 map_token_fd;
	};
	struct {
		__u32 map_fd;
		__u64 key;
		union {
			__u64 value;
			__u64 next_key;
		};
		__u64 flags;
	};
	struct {
		__u64 in_batch;
		__u64 out_batch;
		__u64 keys;
		__u64 values;
		__u32 count;
		__u32 map_fd;
		__u64 elem_flags;
		__u64 flags;
	} batch;
	struct {
		__u32 prog_type;
		__u32 insn_cnt;
		__u64 insns;
		__u64 license;
		__u32 log_level;
		__u32 log_size;
		__u64 log_buf;
		__u32 kern_version;
		__u32 prog_flags;
		char prog_name[16];
		__u32 prog_ifindex;
		__u32 expected_attach_type;
		__u32 prog_btf_fd;
		__u32 func_info_rec_size;
		__u64 func_info;
		__u32 func_info_cnt;
		__u32 line_info_rec_size;
		__u64 line_info;
		__u32 line_info_cnt;
		__u32 attach_btf_id;
		union {
			__u32 attach_prog_fd;
			__u32 attach_btf_obj_fd;
		};
		__u32 core_relo_cnt;
		__u64 fd_array;
		__u64 core_relos;
		__u32 core_relo_rec_size;
		__u32 log_true_size;
		__s32 prog_token_fd;
		__u32 fd_array_cnt;
	};
	struct {
		__u64 pathname;
		__u32 bpf_fd;
		__u32 file_flags;
		__s32 path_fd;
	};
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_bpf_fd;
		__u32 attach_type;
		__u32 attach_flags;
		__u32 replace_bpf_fd;
		union {
			__u32 relative_fd;
			__u32 relative_id;
		};
		__u64 expected_revision;
	};
	struct {
		__u32 prog_fd;
		__u32 retval;
		__u32 data_size_in;
		__u32 data_size_out;
		__u64 data_in;
		__u64 data_out;
		__u32 repeat;
		__u32 duration;
		__u32 ctx_size_in;
		__u32 ctx_size_out;
		__u64 ctx_in;
		__u64 ctx_out;
		__u32 flags;
		__u32 cpu;
		__u32 batch_size;
	} test;
	struct {
		union {
			__u32 start_id;
			__u32 prog_id;
			__u32 map_id;
			__u32 btf_id;
			__u32 link_id;
		};
		__u32 next_id;
		__u32 open_flags;
	};
	struct {
		__u32 bpf_fd;
		__u32 info_len;
		__u64 info;
	} info;
	struct {
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 query_flags;
		__u32 attach_flags;
		__u64 prog_ids;
		union {
			__u32 prog_cnt;
			__u32 count;
		};
		__u64 prog_attach_flags;
		__u64 link_ids;
		__u64 link_attach_flags;
		__u64 revision;
	} query;
	struct {
		__u64 name;
		__u32 prog_fd;
		__u64 cookie;
	} raw_tracepoint;
	struct {
		__u64 btf;
		__u64 btf_log_buf;
		__u32 btf_size;
		__u32 btf_log_size;
		__u32 btf_log_level;
		__u32 btf_log_true_size;
		__u32 btf_flags;
		__s32 btf_token_fd;
	};
	struct {
		__u32 pid;
		__u32 fd;
		__u32 flags;
		__u32 buf_len;
		__u64 buf;
		__u32 prog_id;
		__u32 fd_type;
		__u64 probe_offset;
		__u64 probe_addr;
	} task_fd_query;
	struct {
		union {
			__u32 prog_fd;
			__u32 map_fd;
		};
		union {
			__u32 target_fd;
			__u32 target_ifindex;
		};
		__u32 attach_type;
		__u32 flags;
		union {
			__u32 target_btf_id;
			struct {
				__u64 iter_info;
				__u32 iter_info_len;
			};
			struct {
				__u64 bpf_cookie;
			} perf_event;
			struct {
				__u32 flags;
				__u32 cnt;
				__u64 syms;
				__u64 addrs;
				__u64 cookies;
			} kprobe_multi;
			struct {
				__u32 target_btf_id;
				__u64 cookie;
			} tracing;
			struct {
				__u32 pf;
				__u32 hooknum;
				__s32 priority;
				__u32 flags;
			} netfilter;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} tcx;
			struct {
				__u64 path;
				__u64 offsets;
				__u64 ref_ctr_offsets;
				__u64 cookies;
				__u32 cnt;
				__u32 flags;
				__u32 pid;
			} uprobe_multi;
			struct {
				union {
					__u32 relative_fd;
					__u32 relative_id;
				};
				__u64 expected_revision;
			} netkit;
		};
	} link_create;
	struct {
		__u32 link_fd;
		union {
			__u32 new_prog_fd;
			__u32 new_map_fd;
		};
		__u32 flags;
		union {
			__u32 old_prog_fd;
			__u32 old_map_fd;
		};
	} link_update;
	struct {
		__u32 link_fd;
	} link_detach;
	struct {
		__u32 type;
	} enable_stats;
	struct {
		__u32 link_fd;
		__u32 flags;
	} iter_create;
	struct {
		__u32 prog_fd;
		__u32 map_fd;
		__u32 flags;
	} prog_bind_map;
	struct {
		__u32 flags;
		__u32 bpffs_fd;
	} token_create;
};

struct bpf_binary_header {
	u32 size;
	long: 0;
	u8 image[0];
};

struct bpf_bloom_filter {
	struct bpf_map map;
	u32 bitset_mask;
	u32 hash_seed;
	u32 nr_hash_funcs;
	unsigned long bitset[0];
};

struct bpf_bprintf_buffers {
	char bin_args[512];
	char buf[1024];
};

struct bpf_bprintf_data {
	u32 *bin_args;
	char *buf;
	bool get_bin_args;
	bool get_buf;
};

struct bpf_btf_info {
	__u64 btf;
	__u32 btf_size;
	__u32 id;
	__u64 name;
	__u32 name_len;
	__u32 kernel_btf;
};

struct btf_field;

struct bpf_call_arg_meta {
	struct bpf_map *map_ptr;
	bool raw_mode;
	bool pkt_access;
	u8 release_regno;
	int regno;
	int access_size;
	int mem_size;
	u64 msize_max_value;
	int ref_obj_id;
	int dynptr_id;
	int map_uid;
	int func_id;
	struct btf *btf;
	u32 btf_id;
	struct btf *ret_btf;
	u32 ret_btf_id;
	u32 subprogno;
	struct btf_field *kptr_field;
	s64 const_map_key;
};

struct bpf_cand_cache {
	const char *name;
	u32 name_len;
	u16 kind;
	u16 cnt;
	struct {
		const struct btf *btf;
		u32 id;
	} cands[0];
};

struct bpf_run_ctx {};

struct bpf_prog_array_item;

struct bpf_cg_run_ctx {
	struct bpf_run_ctx run_ctx;
	const struct bpf_prog_array_item *prog_item;
	int retval;
};

struct bpf_cgroup_dev_ctx {
	__u32 access_type;
	__u32 major;
	__u32 minor;
};

struct bpf_link_ops;

struct bpf_link {
	atomic64_t refcnt;
	u32 id;
	enum bpf_link_type type;
	const struct bpf_link_ops *ops;
	struct bpf_prog *prog;
	bool sleepable;
	union {
		struct callback_head rcu;
		struct work_struct work;
	};
};

struct bpf_cgroup_link {
	struct bpf_link link;
	struct cgroup *cgroup;
	enum bpf_attach_type type;
};

struct bpf_cgroup_storage_key {
	__u64 cgroup_inode_id;
	__u32 attach_type;
};

struct bpf_storage_buffer;

struct bpf_cgroup_storage_map;

struct bpf_cgroup_storage {
	union {
		struct bpf_storage_buffer *buf;
		void __attribute__((btf_type_tag("percpu"))) *percpu_buf;
	};
	struct bpf_cgroup_storage_map *map;
	struct bpf_cgroup_storage_key key;
	struct list_head list_map;
	struct list_head list_cg;
	struct rb_node node;
	struct callback_head rcu;
};

struct bpf_cgroup_storage_map {
	struct bpf_map map;
	spinlock_t lock;
	struct rb_root root;
	struct list_head list;
};

struct bpf_lru_list {
	struct list_head lists[3];
	unsigned int counts[2];
	struct list_head *next_inactive_rotation;
	raw_spinlock_t lock;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_lru_locallist;

struct bpf_common_lru {
	struct bpf_lru_list lru_list;
	struct bpf_lru_locallist __attribute__((btf_type_tag("percpu"))) *local_list;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct bpf_core_accessor {
	__u32 type_id;
	__u32 idx;
	const char *name;
};

struct bpf_core_cand {
	const struct btf *btf;
	__u32 id;
};

struct bpf_core_cand_list {
	struct bpf_core_cand *cands;
	int len;
};

struct bpf_verifier_log;

struct bpf_core_ctx {
	struct bpf_verifier_log *log;
	const struct btf *btf;
};

struct bpf_core_relo {
	__u32 insn_off;
	__u32 type_id;
	__u32 access_str_off;
	enum bpf_core_relo_kind kind;
};

struct bpf_core_relo_res {
	__u64 orig_val;
	__u64 new_val;
	bool poison;
	bool validate;
	bool fail_memsz_adjust;
	__u32 orig_sz;
	__u32 orig_type_id;
	__u32 new_sz;
	__u32 new_type_id;
};

struct bpf_core_spec {
	const struct btf *btf;
	struct bpf_core_accessor spec[64];
	__u32 root_type_id;
	enum bpf_core_relo_kind relo_kind;
	int len;
	int raw_spec[64];
	int raw_len;
	__u32 bit_offset;
};

struct bpf_cpu_map_entry;

struct bpf_cpu_map {
	struct bpf_map map;
	struct bpf_cpu_map_entry __attribute__((btf_type_tag("rcu"))) **cpu_map;
};

struct bpf_cpumap_val {
	__u32 qsize;
	union {
		int fd;
		__u32 id;
	} bpf_prog;
};

struct xdp_bulk_queue;

struct ptr_ring;

struct bpf_cpu_map_entry {
	u32 cpu;
	int map_id;
	struct xdp_bulk_queue __attribute__((btf_type_tag("percpu"))) *bulkq;
	struct ptr_ring *queue;
	struct task_struct *kthread;
	struct bpf_cpumap_val value;
	struct bpf_prog *prog;
	struct completion kthread_running;
	struct rcu_work free_work;
};

struct bpf_cpumask {
	cpumask_t cpumask;
	refcount_t usage;
};

struct bpf_crypto_type;

struct bpf_crypto_ctx {
	const struct bpf_crypto_type *type;
	void *tfm;
	u32 siv_len;
	struct callback_head rcu;
	refcount_t usage;
};

struct bpf_crypto_params {
	char type[14];
	u8 reserved[2];
	char algo[128];
	u8 key[256];
	u32 key_len;
	u32 authsize;
};

struct bpf_crypto_type {
	void * (*alloc_tfm)(const char *);
	void (*free_tfm)(void *);
	int (*has_algo)(const char *);
	int (*setkey)(void *, const u8 *, unsigned int);
	int (*setauthsize)(void *, unsigned int);
	int (*encrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	int (*decrypt)(void *, const u8 *, u8 *, unsigned int, u8 *);
	unsigned int (*ivsize)(void *);
	unsigned int (*statesize)(void *);
	u32 (*get_flags)(void *);
	struct module *owner;
	char name[14];
};

struct bpf_crypto_type_list {
	const struct bpf_crypto_type *type;
	struct list_head list;
};

struct bpf_ct_opts {
	s32 netns_id;
	s32 error;
	u8 l4proto;
	u8 dir;
	u16 ct_zone_id;
	u8 ct_zone_dir;
	u8 reserved[3];
};

struct bpf_ctx_arg_aux {
	u32 offset;
	enum bpf_reg_type reg_type;
	struct btf *btf;
	u32 btf_id;
};

struct sock;

struct skb_ext;

struct sk_buff {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
			union {
				struct net_device *dev;
				unsigned long dev_scratch;
			};
		};
		struct rb_node rbnode;
		struct list_head list;
		struct llist_node ll_node;
	};
	struct sock *sk;
	union {
		ktime_t tstamp;
		u64 skb_mstamp_ns;
	};
	char cb[48];
	union {
		struct {
			unsigned long _skb_refdst;
			void (*destructor)(struct sk_buff *);
		};
		struct list_head tcp_tsorted_anchor;
		unsigned long _sk_redir;
	};
	unsigned long _nfct;
	unsigned int len;
	unsigned int data_len;
	__u16 mac_len;
	__u16 hdr_len;
	__u16 queue_mapping;
	__u8 __cloned_offset[0];
	__u8 cloned: 1;
	__u8 nohdr: 1;
	__u8 fclone: 2;
	__u8 peeked: 1;
	__u8 head_frag: 1;
	__u8 pfmemalloc: 1;
	__u8 pp_recycle: 1;
	__u8 active_extensions;
	union {
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 nf_trace: 1;
			__u8 redirected: 1;
			__u8 slow_gro: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		};
		struct {
			__u8 __pkt_type_offset[0];
			__u8 pkt_type: 3;
			__u8 ignore_df: 1;
			__u8 dst_pending_confirm: 1;
			__u8 ip_summed: 2;
			__u8 ooo_okay: 1;
			__u8 __mono_tc_offset[0];
			__u8 tstamp_type: 2;
			__u8 tc_at_ingress: 1;
			__u8 tc_skip_classify: 1;
			__u8 remcsum_offload: 1;
			__u8 csum_complete_sw: 1;
			__u8 csum_level: 2;
			__u8 inner_protocol_type: 1;
			__u8 l4_hash: 1;
			__u8 sw_hash: 1;
			__u8 wifi_acked_valid: 1;
			__u8 wifi_acked: 1;
			__u8 no_fcs: 1;
			__u8 encapsulation: 1;
			__u8 encap_hdr_csum: 1;
			__u8 csum_valid: 1;
			__u8 ndisc_nodetype: 2;
			__u8 nf_trace: 1;
			__u8 redirected: 1;
			__u8 slow_gro: 1;
			__u8 unreadable: 1;
			__u16 tc_index;
			u16 alloc_cpu;
			union {
				__wsum csum;
				struct {
					__u16 csum_start;
					__u16 csum_offset;
				};
			};
			__u32 priority;
			int skb_iif;
			__u32 hash;
			union {
				u32 vlan_all;
				struct {
					__be16 vlan_proto;
					__u16 vlan_tci;
				};
			};
			union {
				unsigned int napi_id;
				unsigned int sender_cpu;
			};
			union {
				__u32 mark;
				__u32 reserved_tailroom;
			};
			union {
				__be16 inner_protocol;
				__u8 inner_ipproto;
			};
			__u16 inner_transport_header;
			__u16 inner_network_header;
			__u16 inner_mac_header;
			__be16 protocol;
			__u16 transport_header;
			__u16 network_header;
			__u16 mac_header;
		} headers;
	};
	sk_buff_data_t tail;
	sk_buff_data_t end;
	unsigned char *head;
	unsigned char *data;
	unsigned int truesize;
	refcount_t users;
	struct skb_ext *extensions;
};

struct xdp_md {
	__u32 data;
	__u32 data_end;
	__u32 data_meta;
	__u32 ingress_ifindex;
	__u32 rx_queue_index;
	__u32 egress_ifindex;
};

struct xdp_rxq_info;

struct xdp_txq_info;

struct xdp_buff {
	void *data;
	void *data_end;
	void *data_meta;
	void *data_hard_start;
	struct xdp_rxq_info *rxq;
	struct xdp_txq_info *txq;
	u32 frame_sz;
	u32 flags;
};

struct bpf_sock {
	__u32 bound_dev_if;
	__u32 family;
	__u32 type;
	__u32 protocol;
	__u32 mark;
	__u32 priority;
	__u32 src_ip4;
	__u32 src_ip6[4];
	__u32 src_port;
	__be16 dst_port;
	__u32 dst_ip4;
	__u32 dst_ip6[4];
	__u32 state;
	__s32 rx_queue_mapping;
};

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
};

struct proto;

struct inet_timewait_death_row;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		};
	};
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	};
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		};
	};
	unsigned short skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	};
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		unsigned long skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	};
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	};
	unsigned short skc_tx_queue_mapping;
	unsigned short skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	};
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	};
};

struct page_frag {
	struct page *page;
	__u32 offset;
	__u32 size;
};

struct sock_cgroup_data {
	struct cgroup *cgroup;
	u32 classid;
};

struct dst_entry;

struct sk_filter;

struct socket_wq;

struct socket;

struct mem_cgroup;

struct sock_reuseport;

struct bpf_local_storage;

struct sock {
	struct sock_common __sk_common;
	__u8 __cacheline_group_begin__sock_write_rx[0];
	atomic_t sk_drops;
	__s32 sk_peek_off;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} sk_backlog;
	__u8 __cacheline_group_end__sock_write_rx[0];
	__u8 __cacheline_group_begin__sock_read_rx[0];
	struct dst_entry __attribute__((btf_type_tag("rcu"))) *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	u16 sk_busy_poll_budget;
	u8 sk_prefer_busy_poll;
	u8 sk_userlocks;
	int sk_rcvbuf;
	struct sk_filter __attribute__((btf_type_tag("rcu"))) *sk_filter;
	union {
		struct socket_wq __attribute__((btf_type_tag("rcu"))) *sk_wq;
		struct socket_wq *sk_wq_raw;
	};
	void (*sk_data_ready)(struct sock *);
	long sk_rcvtimeo;
	int sk_rcvlowat;
	__u8 __cacheline_group_end__sock_read_rx[0];
	__u8 __cacheline_group_begin__sock_read_rxtx[0];
	int sk_err;
	struct socket *sk_socket;
	struct mem_cgroup *sk_memcg;
	__u8 __cacheline_group_end__sock_read_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_rxtx[0];
	socket_lock_t sk_lock;
	u32 sk_reserved_mem;
	int sk_forward_alloc;
	u32 sk_tsflags;
	__u8 __cacheline_group_end__sock_write_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_tx[0];
	int sk_write_pending;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	unsigned long sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	};
	struct sk_buff_head sk_write_queue;
	u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	struct page_frag sk_frag;
	struct timer_list sk_timer;
	unsigned long sk_pacing_rate;
	atomic_t sk_zckey;
	atomic_t sk_tskey;
	__u8 __cacheline_group_end__sock_write_tx[0];
	__u8 __cacheline_group_begin__sock_read_tx[0];
	unsigned long sk_max_pacing_rate;
	long sk_sndtimeo;
	u32 sk_priority;
	u32 sk_mark;
	struct dst_entry __attribute__((btf_type_tag("rcu"))) *sk_dst_cache;
	netdev_features_t sk_route_caps;
	u16 sk_gso_type;
	u16 sk_gso_max_segs;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	u32 sk_txhash;
	u8 sk_pacing_shift;
	bool sk_use_task_frag;
	__u8 __cacheline_group_end__sock_read_tx[0];
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_shutdown;
	u16 sk_type;
	u16 sk_protocol;
	unsigned long sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	ktime_t sk_stamp;
	int sk_disconnects;
	u8 sk_tx