/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr_Cyrl_BA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Средње вријеме по Гриничу",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Апија, стандардно вријеме",
               "",
               "Апија, љетње вријеме",
               "",
               "Апија вријеме",
               "",
            };
        final String[] Cook = new String[] {
               "Кукова Острва, стандардно вријеме",
               "",
               "Кукова Острва, полуљетње вријеме",
               "",
               "Кукова Острва вријеме",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба, стандардно вријеме",
               "CST",
               "Куба, љетње вријеме",
               "CDT",
               "Куба",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиџи, стандардно вријеме",
               "",
               "Фиџи, љетње вријеме",
               "",
               "Фиџи вријеме",
               "",
            };
        final String[] Gulf = new String[] {
               "Заливско вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд, стандардно вријеме",
               "",
               "Ховд, љетње вријеме",
               "",
               "Ховд вријеме",
               "",
            };
        final String[] Iran = new String[] {
               "Иран, стандардно вријеме",
               "",
               "Иран, љетње вријеме",
               "",
               "Иран вријеме",
               "",
            };
        final String[] Niue = new String[] {
               "Нијуе вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск, стандардно вријеме",
               "",
               "Омск, љетње вријеме",
               "",
               "Омск вријеме",
               "",
            };
        final String[] Peru = new String[] {
               "Перу, стандардно вријеме",
               "",
               "Перу, љетње вријеме",
               "",
               "Перу вријеме",
               "",
            };
        final String[] Truk = new String[] {
               "Чук вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "острво Вејк вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чиле, стандардно вријеме",
               "",
               "Чиле, љетње вријеме",
               "",
               "Чиле вријеме",
               "",
            };
        final String[] China = new String[] {
               "Кинеско стандардно вријеме",
               "CST",
               "Кина, љетње вријеме",
               "CDT",
               "Кина вријеме",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокосова (Килинг) острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дејвис вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Индијско стандардно вријеме",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Јапанско стандардно вријеме",
               "JST",
               "Јапанско љетње вријеме",
               "JDT",
               "Јапанско вријеме",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корејско стандардно вријеме",
               "KST",
               "Корејско љетње вријеме",
               "KST",
               "Корејско вријеме",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа, стандардно вријеме",
               "SST",
               "Самоа, љетње вријеме",
               "SST",
               "Самоа вријеме",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Шова вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга, стандардно вријеме",
               "",
               "Тонга, љетње вријеме",
               "",
               "Тонга вријеме",
               "",
            };
        final String[] Alaska = new String[] {
               "Аљаска, стандардно вријеме",
               "AKST",
               "Аљаска, љетње вријеме",
               "AKDT",
               "Аљаска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазон, стандардно вријеме",
               "",
               "Амазон, љетње вријеме",
               "",
               "Амазон вријеме",
               "",
            };
        final String[] Azores = new String[] {
               "Азори, стандардно вријеме",
               "",
               "Азори, љетње вријеме",
               "",
               "Азори вријеме",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Брунеј Дарусалум вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ускршња острва, стандардно вријеме",
               "",
               "Ускршња острва, љетње вријеме",
               "",
               "Ускршња острва вријеме",
               "",
            };
        final String[] Guyana = new String[] {
               "Гвајана вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Израелско стандардно вријеме",
               "IST",
               "Израелско љетње вријеме",
               "IDT",
               "Израелско вријеме",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Кошре вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Мосон вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва, стандардно вријеме",
               "MSK",
               "Москва, љетње вријеме",
               "MSK",
               "Москва вријеме",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понпеј вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Тахити вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тајпеј, стандардно вријеме",
               "CST",
               "Тајпеј, љетње вријеме",
               "CDT",
               "Тајпеј вријеме",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "острва Валис и Футуна вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабијско стандардно вријеме",
               "",
               "Арабијско љетње вријеме",
               "",
               "Арабијско вријеме",
               "",
            };
        final String[] Armenia = new String[] {
               "Јерменија, стандардно вријеме",
               "",
               "Јерменија, љетње вријеме",
               "",
               "Јерменија вријеме",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливија вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатам, стандардно вријеме",
               "",
               "Чатам, љетње вријеме",
               "",
               "Чатам вријеме",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Координисано универзално вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Еквадор вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбије вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузија, стандардно вријеме",
               "",
               "Грузија, љетње вријеме",
               "",
               "Грузија вријеме",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркуцк, стандардно вријеме",
               "",
               "Иркуцк, љетње вријеме",
               "",
               "Иркуцк вријеме",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан, стандардно вријеме",
               "",
               "Магадан, љетње вријеме",
               "",
               "Магадан вријеме",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мјанмар вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "острво Норфолк, стандардно вријеме",
               "",
               "острво Норфолк, љетње вријеме",
               "",
               "острво Норфолк вријеме",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Нороња, стандардно вријеме",
               "",
               "Фернандо де Нороња, љетње вријеме",
               "",
               "Фернандо де Нороња вријеме",
               "",
            };
        final String[] Reunion = new String[] {
               "Реунион вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломонска Острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвај, стандардно вријеме",
               "",
               "Уругвај, љетње вријеме",
               "",
               "Уругвај вријеме",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату, стандардно вријеме",
               "",
               "Вануату, љетње вријеме",
               "",
               "Вануату вријеме",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Јакутск, стандардно вријеме",
               "",
               "Јакутск, љетње вријеме",
               "",
               "Јакутск вријеме",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантско стандардно вријеме",
               "AST",
               "Атлантско љетње вријеме",
               "AST",
               "Атлантско вријеме",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилија, стандардно вријеме",
               "",
               "Бразилија, љетње вријеме",
               "",
               "Бразилија вријеме",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморо вријеме",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбија, стандардно вријеме",
               "",
               "Колумбија, љетње вријеме",
               "",
               "Колумбија вријеме",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолкландска Острва, стандардно вријеме",
               "",
               "Фолкландска Острва, љетње вријеме",
               "",
               "Фолкландска Острва вријеме",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малезија вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Малдиви вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан Батор, стандардно вријеме",
               "",
               "Улан Батор, љетње вријееме",
               "",
               "Улан Батор вријеме",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан, стандардно вријеме",
               "PKT",
               "Пакистан, љетње вријеме",
               "PKST",
               "Пакистан вријеме",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвај, стандардно вријеме",
               "",
               "Парагвај, љетње вријеме",
               "",
               "Парагвај вријеме",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкерн вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Сахалин, стандардно вријеме",
               "",
               "Сахалин, љетње вријеме",
               "",
               "Сахалин вријеме",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина, стандардно вријеме",
               "",
               "Аргентина, љетње вријеме",
               "",
               "Аргентина вријеме",
               "",
            };
        final String[] Christmas = new String[] {
               "Божићно острво вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагос вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Хонг Конг, стандардно вријеме",
               "HKT",
               "Хонг Конг, љетње вријеме",
               "HKST",
               "Хонг Конг вријеме",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокина вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргистан вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хов, стандардно вријеме",
               "",
               "Лорд Хов, љетње вријеме",
               "",
               "Лорд Хов вријеме",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркиз вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маурицијус, стандардно вријеме",
               "",
               "Маурицијус, љетње вријеме",
               "",
               "Маурицијус вријеме",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур, стандардно вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венецуела вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Волгоград, стандардно вријеме",
               "MSK",
               "Волгоград, љетње вријеме",
               "MSK",
               "Волгоград вријеме",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Азербејџан, стандардно вријеме",
               "",
               "Азербејџан, љетње вријеме",
               "",
               "Азербејџан вријеме",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш, стандардно вријеме",
               "",
               "Бангладеш, љетње вријеме",
               "",
               "Бангладеш вријеме",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Зеленортска Острва, стандардно вријеме",
               "",
               "Зеленортска Острва, љетње вријеме",
               "",
               "Зеленортска Острва вријеме",
               "",
            };
        final String[] East_Timor = new String[] {
               "Источни Тимор вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстанско вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сејшели вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таџикистан вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистан, стандардно вријеме",
               "",
               "Узбекистан, љетње вријеме",
               "",
               "Узбекистан вријеме",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Авганистан вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Краснојарск, стандардно вријеме",
               "",
               "Краснојарск, љетње вријеме",
               "",
               "Краснојарск вријеме",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Нови Зеланд, стандардно вријеме",
               "NZST",
               "Нови Зеланд, љетње вријеме",
               "NZDT",
               "Нови Зеланд вријеме",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Новосибирск, стандардно вријеме",
               "",
               "Новосибирск, љетње вријеме",
               "",
               "Новосибирск вријеме",
               "",
            };
        final String[] Philippines = new String[] {
               "Филипини, стандардно вријеме",
               "PST",
               "Филипини, љетње вријеме",
               "PDT",
               "Филипини вријеме",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток, стандардно вријеме",
               "",
               "Владивосток, љетње вријеме",
               "",
               "Владивосток вријеме",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Индијско океанско вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Линијска острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Њуфаундленд, стандардно вријеме",
               "NST",
               "Њуфаундленд, љетње вријеме",
               "NDT",
               "Њуфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистан, стандардно вријеме",
               "",
               "Туркменистан, љетње вријеме",
               "",
               "Туркменистан вријеме",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Француска Гвајана вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Нова Каледонија, стандардно вријеме",
               "",
               "Нова Каледонија, љетње вријеме",
               "",
               "Нова Каледонија вријеме",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Јужна Џорџија вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Јекатеринбург, стандардно вријеме",
               "",
               "Јекатеринбург, љетње вријеме",
               "",
               "Јекатеринбург вријеме",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Централно-афричко вријеме",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Источно-афричко вријеме",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Западно-афричко стандардно вријеме",
               "WAT",
               "Западно-афричко љетње вријеме",
               "WAT",
               "Западно-афричко вријеме",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Димон д’Ирвил вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Средњоевропско стандардно вријеме",
               "CET",
               "Средњоевропско љетње вријеме",
               "CEST",
               "Средњоевропско вријеме",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Источноевропско стандардно вријеме",
               "EET",
               "Источноевропско љетње вријеме",
               "EEST",
               "Источноевропско вријеме",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Западноевропско стандардно вријеме",
               "WET",
               "Западноевропско љетње вријеме",
               "WEST",
               "Западноевропско вријеме",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексички Пацифик, стандардно вријеме",
               "MST",
               "Мексички Пацифик, љетње вријеме",
               "MDT",
               "Мексички Пацифик",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Јужно-афричко вријеме",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Сјеверноамеричко централно стандардно вријеме",
               "CST",
               "Сјеверноамеричко централно љетње вријеме",
               "CDT",
               "Сјеверноамеричко централно вријеме",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Сјеверноамеричко источно стандардно вријеме",
               "EST",
               "Сјеверноамеричко источно љетње вријеме",
               "EST",
               "Сјеверноамеричко источно вријеме",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Сјеверноамеричко пацифичко стандардно вријеме",
               "PST",
               "Сјеверноамеричко пацифичко летње вријеме",
               "PDT",
               "Сјеверноамеричко пацифичко вријеме",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Француско јужно и антарктичко вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилбертова острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Хавајско-алеутско стандардно вријеме",
               "HST",
               "Хавајско-алеутско љетње вријеме",
               "HST",
               "Хавајско-алеутско вријеме",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен Пјер и Микелон, стандардно вријеме",
               "",
               "Сен Пјер и Микелон, љетње вријеме",
               "",
               "Сен Пјер и Микелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Сјеверноамеричко планинско стандардно вријеме",
               "MST",
               "Сјеверноамеричко планинско љетње вријеме",
               "MST",
               "Сјеверноамеричко планинско вријеме",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалска Острва вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа Нова Гвинеја вријеме",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Аустралијско централно стандардно вријеме",
               "ACST",
               "Аустралијско централно љетње вријеме",
               "ACDT",
               "Аустралијско централно вријеме",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Аустралијско источно стандардно вријеме",
               "AEST",
               "Аустралијско источно љетње вријеме",
               "AEDT",
               "Аустралијско источно вријеме",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Аустралијско западно стандардно вријеме",
               "AWST",
               "Аустралијско западно љетње вријеме",
               "AWDT",
               "Аустралијско западно вријеме",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Централно-индонезијско вријеме",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Источно-индонезијско вријеме",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Западно-индонезијско вријеме",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Аустралијско централно западно стандардно вријеме",
               "",
               "Аустралијско централно западно љетње вријеме",
               "",
               "Аустралијско централно западно вријеме",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Ирска, стандардно вријеме",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Координисано универзално вријеме",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Ирска, стандардно вријеме",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Средње вријеме по Гриничу",
                    "GMT",
                    "Британија, љетње вријеме",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Pacific/Niue", "Нијуе" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Regina", "Реџајна" },
            { "timezone.excity.America/Resolute", "Резолут" },
            { "timezone.excity.America/St_Johns", "Сент Џонс" },
            { "timezone.excity.America/St_Thomas", "Сент Томас" },
            { "timezone.excity.America/Louisville", "Луивил" },
            { "timezone.excity.America/Puerto_Rico", "Порторико" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгјир" },
            { "timezone.excity.America/Indianapolis", "Индијанаполис" },
            { "timezone.excity.America/Scoresbysund", "Итокортормит" },
            { "timezone.excity.Antarctica/Macquarie", "Маквори" },
            { "timezone.excity.America/Indiana/Vevay", "Виви, Индијана" },
            { "timezone.excity.America/Port_of_Spain", "Порт ов Спејн" },
            { "timezone.excity.America/St_Barthelemy", "Сен Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Свифт Карент" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсенс, Индијана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Димон д’Ирвил" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бјула, Сјеверна Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Центар, Сјеверна Дакота" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нови Салем, Сјеверна Дакота" },
        };
        return data;
    }
}
