//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfont?language=objc)
///
/// This is toll-free bridged with `NSFont`.
#[doc(alias = "CTFontRef")]
#[repr(C)]
pub struct CTFont {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTFont {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTFont"> for CTFont {}
);

unsafe impl ConcreteType for CTFont {
    /// Returns the type identifier for Core Text font references.
    ///
    /// Returns: The identifier for the opaque type CTFontRef.
    #[doc(alias = "CTFontGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTFontGetTypeID() -> CFTypeID;
        }
        unsafe { CTFontGetTypeID() }
    }
}

extern "C" {
    /// kCTFontCopyrightNameKey
    ///
    /// The name specifier for the copyright name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontcopyrightnamekey?language=objc)
    pub static kCTFontCopyrightNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontFamilyNameKey
    ///
    /// The name specifier for the family name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfamilynamekey?language=objc)
    pub static kCTFontFamilyNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontSubFamilyNameKey
    ///
    /// The name specifier for the subfamily name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontsubfamilynamekey?language=objc)
    pub static kCTFontSubFamilyNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontStyleNameKey
    ///
    /// The name specifier for the style name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontstylenamekey?language=objc)
    pub static kCTFontStyleNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontUniqueNameKey
    ///
    /// The name specifier for the unique name.
    ///
    /// Note that this name is often not unique and should not be
    /// assumed to be truly unique.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontuniquenamekey?language=objc)
    pub static kCTFontUniqueNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontFullNameKey
    ///
    /// The name specifier for the full name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfullnamekey?language=objc)
    pub static kCTFontFullNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontVersionNameKey
    ///
    /// The name specifier for the version name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontversionnamekey?language=objc)
    pub static kCTFontVersionNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontPostScriptNameKey
    ///
    /// The name specifier for the PostScript name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontpostscriptnamekey?language=objc)
    pub static kCTFontPostScriptNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontTrademarkNameKey
    ///
    /// The name specifier for the trademark name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttrademarknamekey?language=objc)
    pub static kCTFontTrademarkNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontManufacturerNameKey
    ///
    /// The name specifier for the manufacturer name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanufacturernamekey?language=objc)
    pub static kCTFontManufacturerNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontDesignerNameKey
    ///
    /// The name specifier for the designer name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdesignernamekey?language=objc)
    pub static kCTFontDesignerNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontDescriptionNameKey
    ///
    /// The name specifier for the description name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdescriptionnamekey?language=objc)
    pub static kCTFontDescriptionNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontVendorURLNameKey
    ///
    /// The name specifier for the vendor url name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvendorurlnamekey?language=objc)
    pub static kCTFontVendorURLNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontDesignerURLNameKey
    ///
    /// The name specifier for the designer url name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontdesignerurlnamekey?language=objc)
    pub static kCTFontDesignerURLNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontLicenseNameKey
    ///
    /// The name specifier for the license name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontlicensenamekey?language=objc)
    pub static kCTFontLicenseNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontLicenseURLNameKey
    ///
    /// The name specifier for the license url name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontlicenseurlnamekey?language=objc)
    pub static kCTFontLicenseURLNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontSampleTextNameKey
    ///
    /// The name specifier for the sample text name string.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontsampletextnamekey?language=objc)
    pub static kCTFontSampleTextNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontPostScriptCIDNameKey
    ///
    /// The name specifier for the PostScript CID name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontpostscriptcidnamekey?language=objc)
    pub static kCTFontPostScriptCIDNameKey: &'static CFString;
}

impl CTFont {
    /// Returns a new font reference for the given name.
    ///
    ///
    /// This function uses font descriptor matching so only registered fonts can be returned; see CTFontManager.h for more information. If you are trying to create a system UI font (with name beginning with a "."), you should use CTFontCreateUIFontForLanguage() or appropriate AppKit/UIKit APIs instead.
    ///
    ///
    /// Parameter `name`: The font name for which you wish to create a new font reference. A valid PostScript name is preferred, although other font name types will be matched in a fallback manner. Any font name beginning with a "." is reserved for the system and should not be used here.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default font size of 12.0 will be used.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the identity matrix will be used. Optional.
    ///
    ///
    /// Returns: This function will return a CTFontRef that best matches the name provided with size and matrix attributes. The name parameter is the only required parameters, and default values will be used for unspecified parameters. A best match will be found if all parameters cannot be matched identically.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithName")]
    #[inline]
    pub unsafe fn with_name(
        name: &CFString,
        size: CGFloat,
        matrix: *const CGAffineTransform,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithName(
                name: &CFString,
                size: CGFloat,
                matrix: *const CGAffineTransform,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateWithName(name, size, matrix) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new font reference that best matches the font descriptor.
    ///
    ///
    /// Parameter `descriptor`: A font descriptor containing attributes that specify the requested font.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified and the font descriptor does not specify the size, the default font size of 12.0 will be used.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the identity matrix will be used. Optional.
    ///
    ///
    /// Returns: This function will return a CTFontRef that best matches the attributes provided with the font descriptor. The size and matrix parameters will override any specified in the font descriptor, unless they are unspecified. A best match font will always be returned, and default values will be used for any unspecified.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithFontDescriptor")]
    #[cfg(feature = "CTFontDescriptor")]
    #[inline]
    pub unsafe fn with_font_descriptor(
        descriptor: &CTFontDescriptor,
        size: CGFloat,
        matrix: *const CGAffineTransform,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithFontDescriptor(
                descriptor: &CTFontDescriptor,
                size: CGFloat,
                matrix: *const CGAffineTransform,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateWithFontDescriptor(descriptor, size, matrix) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

/// Options for descriptor match and font creation.
///
/// Prevents automatic font activation from taking place.
/// This option is available only on macOS and will be deprecated on other platforms in the future.
///
/// Prevents automatic font download from taking place.
///
/// Font matching will prefer to match Apple system fonts.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CTFontOptions: CFOptionFlags {
        #[doc(alias = "kCTFontOptionsDefault")]
        const Default = 0;
        #[doc(alias = "kCTFontOptionsPreventAutoActivation")]
        const PreventAutoActivation = 1<<0;
        #[doc(alias = "kCTFontOptionsPreventAutoDownload")]
        const PreventAutoDownload = 1<<1;
        #[doc(alias = "kCTFontOptionsPreferSystemFont")]
        const PreferSystemFont = 1<<2;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CTFont {
    /// Returns a new font reference for the given name.
    ///
    ///
    /// This function uses font descriptor matching so only registered fonts can be returned; see CTFontManager.h for more information. If you are trying to create a system UI font (with name beginning with a "."), you should use CTFontCreateUIFontForLanguage() or appropriate AppKit/UIKit APIs instead.
    ///
    ///
    /// Parameter `name`: The font name for which you wish to create a new font reference. A valid PostScript name is preferred, although other font name types will be matched in a fallback manner. Any font name beginning with a "." is reserved for the system and should not be used here.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default font size of 12.0 will be used.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the identity matrix will be used. Optional.
    ///
    ///
    /// Parameter `options`: Options flags.
    ///
    ///
    /// Returns: This function will return a CTFontRef that best matches the name provided with size and matrix attributes. The name parameter is the only required parameters, and default values will be used for unspecified parameters. A best match will be found if all parameters cannot be matched identically.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithNameAndOptions")]
    #[inline]
    pub unsafe fn with_name_and_options(
        name: &CFString,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        options: CTFontOptions,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithNameAndOptions(
                name: &CFString,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                options: CTFontOptions,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateWithNameAndOptions(name, size, matrix, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new font reference that best matches the font descriptor.
    ///
    ///
    /// Parameter `descriptor`: A font descriptor containing attributes that specify the requested font.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default font size of 12.0 will be used.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the identity matrix will be used. Optional.
    ///
    ///
    /// Parameter `options`: Options flags.
    ///
    ///
    /// Returns: This function will return a CTFontRef that best matches the attributes provided with the font descriptor. The size and matrix parameters will override any specified in the font descriptor, unless they are unspecified. A best match font will always be returned, and default values will be used for any unspecified.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithFontDescriptorAndOptions")]
    #[cfg(feature = "CTFontDescriptor")]
    #[inline]
    pub unsafe fn with_font_descriptor_and_options(
        descriptor: &CTFontDescriptor,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        options: CTFontOptions,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithFontDescriptorAndOptions(
                descriptor: &CTFontDescriptor,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                options: CTFontOptions,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret =
            unsafe { CTFontCreateWithFontDescriptorAndOptions(descriptor, size, matrix, options) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

/// These constants represent the specific user interface purpose to specify for font creation.
///
/// Use these constants with CTFontCreateUIFontForLanguage to indicate the intended user interface usage of the font reference to be created.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontuifonttype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontUIFontType(pub u32);
impl CTFontUIFontType {
    #[doc(alias = "kCTFontUIFontNone")]
    pub const None: Self = Self(4294967295);
    #[doc(alias = "kCTFontUIFontUser")]
    pub const User: Self = Self(0);
    #[doc(alias = "kCTFontUIFontUserFixedPitch")]
    pub const UserFixedPitch: Self = Self(1);
    #[doc(alias = "kCTFontUIFontSystem")]
    pub const System: Self = Self(2);
    #[doc(alias = "kCTFontUIFontEmphasizedSystem")]
    pub const EmphasizedSystem: Self = Self(3);
    #[doc(alias = "kCTFontUIFontSmallSystem")]
    pub const SmallSystem: Self = Self(4);
    #[doc(alias = "kCTFontUIFontSmallEmphasizedSystem")]
    pub const SmallEmphasizedSystem: Self = Self(5);
    #[doc(alias = "kCTFontUIFontMiniSystem")]
    pub const MiniSystem: Self = Self(6);
    #[doc(alias = "kCTFontUIFontMiniEmphasizedSystem")]
    pub const MiniEmphasizedSystem: Self = Self(7);
    #[doc(alias = "kCTFontUIFontViews")]
    pub const Views: Self = Self(8);
    #[doc(alias = "kCTFontUIFontApplication")]
    pub const Application: Self = Self(9);
    #[doc(alias = "kCTFontUIFontLabel")]
    pub const Label: Self = Self(10);
    #[doc(alias = "kCTFontUIFontMenuTitle")]
    pub const MenuTitle: Self = Self(11);
    #[doc(alias = "kCTFontUIFontMenuItem")]
    pub const MenuItem: Self = Self(12);
    #[doc(alias = "kCTFontUIFontMenuItemMark")]
    pub const MenuItemMark: Self = Self(13);
    #[doc(alias = "kCTFontUIFontMenuItemCmdKey")]
    pub const MenuItemCmdKey: Self = Self(14);
    #[doc(alias = "kCTFontUIFontWindowTitle")]
    pub const WindowTitle: Self = Self(15);
    #[doc(alias = "kCTFontUIFontPushButton")]
    pub const PushButton: Self = Self(16);
    #[doc(alias = "kCTFontUIFontUtilityWindowTitle")]
    pub const UtilityWindowTitle: Self = Self(17);
    #[doc(alias = "kCTFontUIFontAlertHeader")]
    pub const AlertHeader: Self = Self(18);
    #[doc(alias = "kCTFontUIFontSystemDetail")]
    pub const SystemDetail: Self = Self(19);
    #[doc(alias = "kCTFontUIFontEmphasizedSystemDetail")]
    pub const EmphasizedSystemDetail: Self = Self(20);
    #[doc(alias = "kCTFontUIFontToolbar")]
    pub const Toolbar: Self = Self(21);
    #[doc(alias = "kCTFontUIFontSmallToolbar")]
    pub const SmallToolbar: Self = Self(22);
    #[doc(alias = "kCTFontUIFontMessage")]
    pub const Message: Self = Self(23);
    #[doc(alias = "kCTFontUIFontPalette")]
    pub const Palette: Self = Self(24);
    #[doc(alias = "kCTFontUIFontToolTip")]
    pub const ToolTip: Self = Self(25);
    #[doc(alias = "kCTFontUIFontControlContent")]
    pub const ControlContent: Self = Self(26);
    #[deprecated = "Deprecated"]
    pub const kCTFontNoFontType: Self = Self(CTFontUIFontType::None.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontUserFontType: Self = Self(CTFontUIFontType::User.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontUserFixedPitchFontType: Self = Self(CTFontUIFontType::UserFixedPitch.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontSystemFontType: Self = Self(CTFontUIFontType::System.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontEmphasizedSystemFontType: Self = Self(CTFontUIFontType::EmphasizedSystem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontSmallSystemFontType: Self = Self(CTFontUIFontType::SmallSystem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontSmallEmphasizedSystemFontType: Self =
        Self(CTFontUIFontType::SmallEmphasizedSystem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMiniSystemFontType: Self = Self(CTFontUIFontType::MiniSystem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMiniEmphasizedSystemFontType: Self =
        Self(CTFontUIFontType::MiniEmphasizedSystem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontViewsFontType: Self = Self(CTFontUIFontType::Views.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontApplicationFontType: Self = Self(CTFontUIFontType::Application.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontLabelFontType: Self = Self(CTFontUIFontType::Label.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMenuTitleFontType: Self = Self(CTFontUIFontType::MenuTitle.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMenuItemFontType: Self = Self(CTFontUIFontType::MenuItem.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMenuItemMarkFontType: Self = Self(CTFontUIFontType::MenuItemMark.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMenuItemCmdKeyFontType: Self = Self(CTFontUIFontType::MenuItemCmdKey.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontWindowTitleFontType: Self = Self(CTFontUIFontType::WindowTitle.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontPushButtonFontType: Self = Self(CTFontUIFontType::PushButton.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontUtilityWindowTitleFontType: Self =
        Self(CTFontUIFontType::UtilityWindowTitle.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontAlertHeaderFontType: Self = Self(CTFontUIFontType::AlertHeader.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontSystemDetailFontType: Self = Self(CTFontUIFontType::SystemDetail.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontEmphasizedSystemDetailFontType: Self =
        Self(CTFontUIFontType::EmphasizedSystemDetail.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontToolbarFontType: Self = Self(CTFontUIFontType::Toolbar.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontSmallToolbarFontType: Self = Self(CTFontUIFontType::SmallToolbar.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontMessageFontType: Self = Self(CTFontUIFontType::Message.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontPaletteFontType: Self = Self(CTFontUIFontType::Palette.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontToolTipFontType: Self = Self(CTFontUIFontType::ToolTip.0);
    #[deprecated = "Deprecated"]
    pub const kCTFontControlContentFontType: Self = Self(CTFontUIFontType::ControlContent.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontUIFontType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontUIFontType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CTFont {
    /// Returns the special UI font for the given language and UI type.
    ///
    ///
    /// Parameter `uiType`: A uiType constant specifying the intended UI use for the requested font reference.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default size for the requested uiType is used.
    ///
    ///
    /// Parameter `language`: Language identifier to select a font for a particular localization. If unspecified, the current system language is used. The format of the language identifier should conform to UTS #35.
    ///
    ///
    /// Returns: This function returns the correct font for various UI uses. The only required parameter is the uiType selector, unspecified optional parameters will use default values.
    #[doc(alias = "CTFontCreateUIFontForLanguage")]
    #[inline]
    pub unsafe fn new_ui_font_for_language(
        ui_type: CTFontUIFontType,
        size: CGFloat,
        language: Option<&CFString>,
    ) -> Option<CFRetained<CTFont>> {
        extern "C-unwind" {
            fn CTFontCreateUIFontForLanguage(
                ui_type: CTFontUIFontType,
                size: CGFloat,
                language: Option<&CFString>,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateUIFontForLanguage(ui_type, size, language) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a new font with additional attributes based on the original font.
    ///
    ///
    /// This function provides a mechanism to quickly change attributes on a given font reference in response to user actions. For instance, the size can be changed in response to a user manipulating a size slider.
    ///
    ///
    /// Parameter `font`: Original font reference to base new font on.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the original font's size will be preserved.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the original font matrix will be preserved. Optional.
    ///
    ///
    /// Parameter `attributes`: A font descriptor containing additional attributes that the new font should contain.
    ///
    ///
    /// Returns: Returns a new font reference converted from the original with the specified attributes.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateCopyWithAttributes")]
    #[cfg(feature = "CTFontDescriptor")]
    #[inline]
    pub unsafe fn copy_with_attributes(
        &self,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        attributes: Option<&CTFontDescriptor>,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateCopyWithAttributes(
                font: &CTFont,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                attributes: Option<&CTFontDescriptor>,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateCopyWithAttributes(self, size, matrix, attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new font based on the original font with the specified symbolic traits.
    ///
    ///
    /// Parameter `font`: Original font reference on which to base the new font.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the original font's size will be preserved.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the original font matrix will be preserved. Optional.
    ///
    ///
    /// Parameter `symTraitValue`: The value of the symbolic traits. This bitfield is used to indicate the desired value for the traits specified by the symTraitMask parameter. Used in conjunction, they can allow for trait removal as well as addition.
    ///
    ///
    /// Parameter `symTraitMask`: The mask bits of the symbolic traits. This bitfield is used to indicate the traits that should be changed.
    ///
    ///
    /// Returns: Returns a new font reference in the same family with the given symbolic traits, or NULL if none found in the system.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateCopyWithSymbolicTraits")]
    #[cfg(feature = "CTFontTraits")]
    #[inline]
    pub unsafe fn copy_with_symbolic_traits(
        &self,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        sym_trait_value: CTFontSymbolicTraits,
        sym_trait_mask: CTFontSymbolicTraits,
    ) -> Option<CFRetained<CTFont>> {
        extern "C-unwind" {
            fn CTFontCreateCopyWithSymbolicTraits(
                font: &CTFont,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                sym_trait_value: CTFontSymbolicTraits,
                sym_trait_mask: CTFontSymbolicTraits,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe {
            CTFontCreateCopyWithSymbolicTraits(self, size, matrix, sym_trait_value, sym_trait_mask)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a new font in the specified family based on the traits of the original font.
    ///
    ///
    /// Parameter `font`: Original font reference to base new font on.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the original font's size will be preserved.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the original font matrix will be preserved. Optional.
    ///
    ///
    /// Parameter `family`: The name of the desired family.
    ///
    ///
    /// Returns: Returns a new font reference with the original traits in the given family. NULL if non found in the system.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateCopyWithFamily")]
    #[inline]
    pub unsafe fn copy_with_family(
        &self,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        family: &CFString,
    ) -> Option<CFRetained<CTFont>> {
        extern "C-unwind" {
            fn CTFontCreateCopyWithFamily(
                font: &CTFont,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                family: &CFString,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateCopyWithFamily(self, size, matrix, family) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a new font reference that can best map the given string range based on the current font.
    ///
    ///
    /// This function is to be used when the current font does not cover the given range of the string. The current font itself will not be returned, but preference is given to fonts in its cascade list.
    ///
    ///
    /// Parameter `currentFont`: The current font that contains a valid cascade list.
    ///
    ///
    /// Parameter `string`: A unicode string containing characters that cannot be encoded by the current font.
    ///
    ///
    /// Parameter `range`: A CFRange specifying the range of the string that needs to be mapped.
    ///
    ///
    /// Returns: This function returns the best substitute font that can encode the specified string range.
    ///
    ///
    /// See also: CTFontCopyCharacterSet
    ///
    /// See also: CTFontGetGlyphsForCharacters
    ///
    /// See also: kCTFontCascadeListAttribute
    #[doc(alias = "CTFontCreateForString")]
    #[inline]
    pub unsafe fn for_string(&self, string: &CFString, range: CFRange) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateForString(
                current_font: &CTFont,
                string: &CFString,
                range: CFRange,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateForString(self, string, range) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a new font reference that can best map the given string range based on the current font and language specified.
    ///
    ///
    /// The current font itself can be returned if it covers the string provided.
    ///
    ///
    /// Parameter `currentFont`: The current font that contains a valid cascade list.
    ///
    ///
    /// Parameter `string`: A unicode string containing characters that cannot be encoded by the current font.
    ///
    ///
    /// Parameter `range`: A CFRange specifying the range of the string that needs to be mapped.
    ///
    ///
    /// Parameter `language`: Language identifier to select a font for a particular localization. If unspecified, the current system language is used. The format of the language identifier should conform to UTS #35.
    ///
    ///
    /// Returns: This function returns the best substitute font that can encode the specified string range.
    ///
    ///
    /// See also: CTFontCopyCharacterSet
    ///
    /// See also: CTFontGetGlyphsForCharacters
    ///
    /// See also: kCTFontCascadeListAttribute
    #[doc(alias = "CTFontCreateForStringWithLanguage")]
    #[inline]
    pub unsafe fn for_string_with_language(
        &self,
        string: &CFString,
        range: CFRange,
        language: Option<&CFString>,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateForStringWithLanguage(
                current_font: &CTFont,
                string: &CFString,
                range: CFRange,
                language: Option<&CFString>,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateForStringWithLanguage(self, string, range, language) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the normalized font descriptors for the given font reference.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a normalized font descriptor for a font. The font descriptor contains enough information to recreate this font at a later time.
    #[doc(alias = "CTFontCopyFontDescriptor")]
    #[cfg(feature = "CTFontDescriptor")]
    #[inline]
    pub unsafe fn font_descriptor(&self) -> CFRetained<CTFontDescriptor> {
        extern "C-unwind" {
            fn CTFontCopyFontDescriptor(font: &CTFont) -> Option<NonNull<CTFontDescriptor>>;
        }
        let ret = unsafe { CTFontCopyFontDescriptor(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the value associated with an arbitrary attribute.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `attribute`: The requested attribute.
    ///
    ///
    /// Returns: This function returns a retained reference to an arbitrary attribute. If the requested attribute is not present, NULL is returned. Refer to the attribute definitions for documentation as to how each attribute is packaged as a CFType.
    #[doc(alias = "CTFontCopyAttribute")]
    #[inline]
    pub unsafe fn attribute(&self, attribute: &CFString) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CTFontCopyAttribute(font: &CTFont, attribute: &CFString) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CTFontCopyAttribute(self, attribute) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the point size of the font reference.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the point size of the given font reference. This is the point size provided when the font was created.
    #[doc(alias = "CTFontGetSize")]
    #[inline]
    pub unsafe fn size(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetSize(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetSize(self) }
    }

    /// Returns the transformation matrix of the font.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the transformation matrix for this given font reference. This is the matrix that was provided when the font was created.
    #[doc(alias = "CTFontGetMatrix")]
    #[inline]
    pub unsafe fn matrix(&self) -> CGAffineTransform {
        extern "C-unwind" {
            fn CTFontGetMatrix(font: &CTFont) -> CGAffineTransform;
        }
        unsafe { CTFontGetMatrix(self) }
    }

    /// Returns the symbolic font traits.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the symbolic traits of the font. This is equivalent to the kCTFontSymbolicTrait of traits dictionary. See CTFontTraits.h for a definition of the font traits.
    #[doc(alias = "CTFontGetSymbolicTraits")]
    #[cfg(feature = "CTFontTraits")]
    #[inline]
    pub unsafe fn symbolic_traits(&self) -> CTFontSymbolicTraits {
        extern "C-unwind" {
            fn CTFontGetSymbolicTraits(font: &CTFont) -> CTFontSymbolicTraits;
        }
        unsafe { CTFontGetSymbolicTraits(self) }
    }

    /// Returns the font traits dictionary.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the font traits dictionary. Individual traits can be accessed with the trait key constants. See CTFontTraits.h for a definition of the font traits.
    #[doc(alias = "CTFontCopyTraits")]
    #[inline]
    pub unsafe fn traits(&self) -> CFRetained<CFDictionary> {
        extern "C-unwind" {
            fn CTFontCopyTraits(font: &CTFont) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CTFontCopyTraits(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Return an ordered list of CTFontDescriptorRef's for font fallback derived from the system default fallback according to the given language preferences, making a reasonable attempt to match the given font's style, weight, and width.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `languagePrefList`: An array of language identifiers as CFString values, in decreasing order of preference.
    ///
    ///
    /// Returns: The ordered list of fallback fonts - ordered array of CTFontDescriptors.
    ///
    /// # Safety
    ///
    /// `language_pref_list` generic must be of the correct type.
    #[doc(alias = "CTFontCopyDefaultCascadeListForLanguages")]
    #[inline]
    pub unsafe fn default_cascade_list_for_languages(
        &self,
        language_pref_list: Option<&CFArray>,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCopyDefaultCascadeListForLanguages(
                font: &CTFont,
                language_pref_list: Option<&CFArray>,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopyDefaultCascadeListForLanguages(self, language_pref_list) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the PostScript name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the PostScript name of the font.
    #[doc(alias = "CTFontCopyPostScriptName")]
    #[inline]
    pub unsafe fn post_script_name(&self) -> CFRetained<CFString> {
        extern "C-unwind" {
            fn CTFontCopyPostScriptName(font: &CTFont) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyPostScriptName(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the family name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the family name of the font.
    #[doc(alias = "CTFontCopyFamilyName")]
    #[inline]
    pub unsafe fn family_name(&self) -> CFRetained<CFString> {
        extern "C-unwind" {
            fn CTFontCopyFamilyName(font: &CTFont) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyFamilyName(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the display name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the full name of the font.
    #[doc(alias = "CTFontCopyFullName")]
    #[inline]
    pub unsafe fn full_name(&self) -> CFRetained<CFString> {
        extern "C-unwind" {
            fn CTFontCopyFullName(font: &CTFont) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyFullName(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the display name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the localized display name of the font.
    #[doc(alias = "CTFontCopyDisplayName")]
    #[inline]
    pub unsafe fn display_name(&self) -> CFRetained<CFString> {
        extern "C-unwind" {
            fn CTFontCopyDisplayName(font: &CTFont) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyDisplayName(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns a reference to the requested name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `nameKey`: The name specifier. See name specifier constants.
    ///
    ///
    /// Returns: This function creates the requested name for the font, or NULL if the font does not have an entry for the requested name. The Unicode version of the name will be preferred, otherwise the first available will be used.
    #[doc(alias = "CTFontCopyName")]
    #[inline]
    pub unsafe fn name(&self, name_key: &CFString) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CTFontCopyName(font: &CTFont, name_key: &CFString) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyName(self, name_key) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a reference to a localized font name.
    ///
    ///
    /// Localized names are necessary for presentation to a human but are rarely appropriate for programmatic use. CoreText provides localizations for common names but will not attempt any sort of automated translation.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `nameKey`: A name specifier listed in "Font Constants", for example kCTFontStyleNameKey. Name keys present in dictionaries (such as those for axes or features) are handled not by this function but by the functions returning those dictionaries.
    ///
    ///
    /// Parameter `actualLanguage`: Pointer to a CFStringRef to receive the language identifier of the returned name string. The format of the language identifier will conform to UTS #35.
    /// If CoreText can supply its own localized string where the font cannot, this value will be NULL.
    ///
    ///
    /// Returns: This function returns a specific localized name from the font reference. The name is localized based on the user's global language precedence. If the font does not have an entry for the requested name, NULL will be returned. The matched language will be returned in the caller's buffer.
    ///
    ///
    /// See also: CTFontCopyVariationAxes
    ///
    /// See also: CTFontCopyFeatures
    ///
    /// # Safety
    ///
    /// `actual_language` must be a valid pointer or null.
    #[doc(alias = "CTFontCopyLocalizedName")]
    #[inline]
    pub unsafe fn localized_name(
        &self,
        name_key: &CFString,
        actual_language: *mut *const CFString,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CTFontCopyLocalizedName(
                font: &CTFont,
                name_key: &CFString,
                actual_language: *mut *const CFString,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyLocalizedName(self, name_key, actual_language) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the Unicode character set of the font.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to the font's character set. This character set covers the nominal referenced by the font's Unicode cmap table (or equivalent).
    #[doc(alias = "CTFontCopyCharacterSet")]
    #[inline]
    pub unsafe fn character_set(&self) -> CFRetained<CFCharacterSet> {
        extern "C-unwind" {
            fn CTFontCopyCharacterSet(font: &CTFont) -> Option<NonNull<CFCharacterSet>>;
        }
        let ret = unsafe { CTFontCopyCharacterSet(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Returns the best string encoding for legacy format support.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the best string encoding for the font.
    #[doc(alias = "CTFontGetStringEncoding")]
    #[inline]
    pub unsafe fn string_encoding(&self) -> CFStringEncoding {
        extern "C-unwind" {
            fn CTFontGetStringEncoding(font: &CTFont) -> CFStringEncoding;
        }
        unsafe { CTFontGetStringEncoding(self) }
    }

    /// Returns an array of languages supported by the font.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a retained reference to an array of languages supported by the font. The array contains language identifier strings as CFStringRefs. The format of the language identifier will conform to UTS #35.
    #[doc(alias = "CTFontCopySupportedLanguages")]
    #[inline]
    pub unsafe fn supported_languages(&self) -> CFRetained<CFArray> {
        extern "C-unwind" {
            fn CTFontCopySupportedLanguages(font: &CTFont) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopySupportedLanguages(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Performs basic character-to-glyph mapping.
    ///
    ///
    /// This function only provides the nominal mapping as specified by the font's Unicode cmap (or equivalent); such mapping does not constitute proper Unicode layout: it is the caller's responsibility to handle the Unicode properties of the characters.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `characters`: An array of characters (UTF-16 code units). Non-BMP characters must be encoded as surrogate pairs.
    ///
    ///
    /// Parameter `glyphs`: A pointer to a buffer to receive the glyphs. Glyphs for non-BMP characters are sparse: the first glyph corresponds to the full character and the second glyph will be 0.
    ///
    ///
    /// Parameter `count`: The capacity of both the characters and glyphs arrays.
    ///
    ///
    /// Returns: The return value indicates whether all provided characters were successfully mapped. A return value of true indicates that the font mapped all characters. A return value of false indicates that some or all of the characters were not mapped; glyphs for unmapped characters will be 0 (with the exception of those corresponding non-BMP characters as described above).
    ///
    ///
    /// See also: CTFontCopyCharacterSet
    ///
    /// # Safety
    ///
    /// - `characters` must be a valid pointer.
    /// - `glyphs` must be a valid pointer.
    #[doc(alias = "CTFontGetGlyphsForCharacters")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn glyphs_for_characters(
        &self,
        characters: NonNull<UniChar>,
        glyphs: NonNull<CGGlyph>,
        count: CFIndex,
    ) -> bool {
        extern "C-unwind" {
            fn CTFontGetGlyphsForCharacters(
                font: &CTFont,
                characters: NonNull<UniChar>,
                glyphs: NonNull<CGGlyph>,
                count: CFIndex,
            ) -> bool;
        }
        unsafe { CTFontGetGlyphsForCharacters(self, characters, glyphs, count) }
    }

    /// Returns the scaled font ascent metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font ascent metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetAscent")]
    #[inline]
    pub unsafe fn ascent(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetAscent(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetAscent(self) }
    }

    /// Returns the scaled font descent metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font descent metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetDescent")]
    #[inline]
    pub unsafe fn descent(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetDescent(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetDescent(self) }
    }

    /// Returns the scaled font leading metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font leading metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetLeading")]
    #[inline]
    pub unsafe fn leading(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetLeading(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetLeading(self) }
    }

    /// Returns the units per em metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the units per em of the font.
    #[doc(alias = "CTFontGetUnitsPerEm")]
    #[inline]
    pub unsafe fn units_per_em(&self) -> c_uint {
        extern "C-unwind" {
            fn CTFontGetUnitsPerEm(font: &CTFont) -> c_uint;
        }
        unsafe { CTFontGetUnitsPerEm(self) }
    }

    /// Returns the number of glyphs.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the number of glyphs in the font.
    #[doc(alias = "CTFontGetGlyphCount")]
    #[inline]
    pub unsafe fn glyph_count(&self) -> CFIndex {
        extern "C-unwind" {
            fn CTFontGetGlyphCount(font: &CTFont) -> CFIndex;
        }
        unsafe { CTFontGetGlyphCount(self) }
    }

    /// Returns the scaled bounding box.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This will return the design bounding box of the font, which is the rectangle defined by xMin, yMin, xMax, and yMax values for the font.
    #[doc(alias = "CTFontGetBoundingBox")]
    #[inline]
    pub unsafe fn bounding_box(&self) -> CGRect {
        extern "C-unwind" {
            fn CTFontGetBoundingBox(font: &CTFont) -> CGRect;
        }
        unsafe { CTFontGetBoundingBox(self) }
    }

    /// Returns the scaled underline position.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font underline position metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetUnderlinePosition")]
    #[inline]
    pub unsafe fn underline_position(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetUnderlinePosition(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetUnderlinePosition(self) }
    }

    /// Returns the scaled underline thickness metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font underline thickness metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetUnderlineThickness")]
    #[inline]
    pub unsafe fn underline_thickness(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetUnderlineThickness(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetUnderlineThickness(self) }
    }

    /// Returns the slant angle of the font.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the transformed slant angle of the font. This is equivalent to the italic or caret angle with any skew from the transformation matrix applied.
    #[doc(alias = "CTFontGetSlantAngle")]
    #[inline]
    pub unsafe fn slant_angle(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetSlantAngle(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetSlantAngle(self) }
    }

    /// Returns the cap height metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font cap height metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetCapHeight")]
    #[inline]
    pub unsafe fn cap_height(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetCapHeight(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetCapHeight(self) }
    }

    /// Returns the X height metric.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns the font X height metric scaled based on the point size and matrix of the font reference.
    #[doc(alias = "CTFontGetXHeight")]
    #[inline]
    pub unsafe fn x_height(&self) -> CGFloat {
        extern "C-unwind" {
            fn CTFontGetXHeight(font: &CTFont) -> CGFloat;
        }
        unsafe { CTFontGetXHeight(self) }
    }

    /// Returns the CGGlyph for the specified glyph name.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyphName`: The glyph name as a CFString.
    ///
    ///
    /// Returns: The glyph with the specified name or 0 if the name is not recognized; this glyph can be used with other Core Text glyph data accessors or with Quartz.
    #[doc(alias = "CTFontGetGlyphWithName")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn glyph_with_name(&self, glyph_name: &CFString) -> CGGlyph {
        extern "C-unwind" {
            fn CTFontGetGlyphWithName(font: &CTFont, glyph_name: &CFString) -> CGGlyph;
        }
        unsafe { CTFontGetGlyphWithName(self, glyph_name) }
    }

    /// Returns the name for the specified glyph.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyph`: The glyph.
    ///
    ///
    /// Returns: The glyph name as a CFString or NULL if the glyph is invalid.
    ///
    ///
    /// See also: CTFontGetGlyphWithName
    #[doc(alias = "CTFontCopyNameForGlyph")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn name_for_glyph(&self, glyph: CGGlyph) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CTFontCopyNameForGlyph(font: &CTFont, glyph: CGGlyph) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CTFontCopyNameForGlyph(self, glyph) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Calculates the bounding rects for an array of glyphs and returns the overall bounding rect for the run.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `orientation`: The intended drawing orientation of the glyphs. Used to determined which glyph metrics to return.
    ///
    ///
    /// Parameter `glyphs`: An array of count number of glyphs.
    ///
    ///
    /// Parameter `boundingRects`: An array of count number of CGRects to receive the computed glyph rects. Can be NULL, in which case only the overall bounding rect is calculated.
    ///
    ///
    /// Parameter `count`: The capacity of the glyphs and boundingRects buffers.
    ///
    ///
    /// Returns: This function returns the overall bounding rectangle for an array or run of glyphs. The bounding rects of the individual glyphs are returned through the boundingRects parameter. These are the design metrics from the font transformed in font space.
    ///
    /// # Safety
    ///
    /// - `glyphs` must be a valid pointer.
    /// - `bounding_rects` must be a valid pointer or null.
    #[doc(alias = "CTFontGetBoundingRectsForGlyphs")]
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn bounding_rects_for_glyphs(
        &self,
        orientation: CTFontOrientation,
        glyphs: NonNull<CGGlyph>,
        bounding_rects: *mut CGRect,
        count: CFIndex,
    ) -> CGRect {
        extern "C-unwind" {
            fn CTFontGetBoundingRectsForGlyphs(
                font: &CTFont,
                orientation: CTFontOrientation,
                glyphs: NonNull<CGGlyph>,
                bounding_rects: *mut CGRect,
                count: CFIndex,
            ) -> CGRect;
        }
        unsafe { CTFontGetBoundingRectsForGlyphs(self, orientation, glyphs, bounding_rects, count) }
    }

    /// Calculates the optical bounding rects for an array of glyphs and returns the overall optical bounding rect for the run.
    ///
    ///
    /// Fonts may specify the optical edges of glyphs that can be used to make the edges of lines of text line up in a more visually pleasing way. This function returns bounding rects corresponding to this information if present in a font, otherwise it returns typographic bounding rects (composed of the font's ascent and descent and a glyph's advance width).
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyphs`: An array of count number of glyphs.
    ///
    ///
    /// Parameter `boundingRects`: An array of count number of CGRects to receive the computed glyph rects. Can be NULL, in which case only the overall bounding rect is calculated.
    ///
    ///
    /// Parameter `count`: The capacity of the glyphs and boundingRects buffers.
    ///
    ///
    /// Parameter `options`: Reserved, set to zero.
    ///
    ///
    /// Returns: This function returns the overall bounding rectangle for an array or run of glyphs. The bounding rects of the individual glyphs are returned through the boundingRects parameter. These are the design metrics from the font transformed in font space.
    ///
    /// # Safety
    ///
    /// - `glyphs` must be a valid pointer.
    /// - `bounding_rects` must be a valid pointer or null.
    #[doc(alias = "CTFontGetOpticalBoundsForGlyphs")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn optical_bounds_for_glyphs(
        &self,
        glyphs: NonNull<CGGlyph>,
        bounding_rects: *mut CGRect,
        count: CFIndex,
        options: CFOptionFlags,
    ) -> CGRect {
        extern "C-unwind" {
            fn CTFontGetOpticalBoundsForGlyphs(
                font: &CTFont,
                glyphs: NonNull<CGGlyph>,
                bounding_rects: *mut CGRect,
                count: CFIndex,
                options: CFOptionFlags,
            ) -> CGRect;
        }
        unsafe { CTFontGetOpticalBoundsForGlyphs(self, glyphs, bounding_rects, count, options) }
    }

    /// Calculates the advances for an array of glyphs and returns the summed advance.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `orientation`: The intended drawing orientation of the glyphs. Used to determined which glyph metrics to return.
    ///
    ///
    /// Parameter `glyphs`: An array of count number of glyphs.
    ///
    ///
    /// Parameter `advances`: An array of count number of CGSize to receive the computed glyph advances. Can be NULL, in which case only the overall advance is calculated.
    ///
    ///
    /// Parameter `count`: The capacity of the glyphs and advances buffers.
    ///
    ///
    /// Returns: This function returns the summed glyph advance of an array of glyphs. Individual glyph advances are passed back via the advances parameter. These are the ideal metrics for each glyph scaled and transformed in font space.
    ///
    /// # Safety
    ///
    /// - `glyphs` must be a valid pointer.
    /// - `advances` must be a valid pointer or null.
    #[doc(alias = "CTFontGetAdvancesForGlyphs")]
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn advances_for_glyphs(
        &self,
        orientation: CTFontOrientation,
        glyphs: NonNull<CGGlyph>,
        advances: *mut CGSize,
        count: CFIndex,
    ) -> c_double {
        extern "C-unwind" {
            fn CTFontGetAdvancesForGlyphs(
                font: &CTFont,
                orientation: CTFontOrientation,
                glyphs: NonNull<CGGlyph>,
                advances: *mut CGSize,
                count: CFIndex,
            ) -> c_double;
        }
        unsafe { CTFontGetAdvancesForGlyphs(self, orientation, glyphs, advances, count) }
    }

    /// Calculates the offset from the default (horizontal) origin to the vertical origin for an array of glyphs.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyphs`: An array of count number of glyphs.
    ///
    ///
    /// Parameter `translations`: An array of count number of CGSize to receive the computed origin offsets.
    ///
    ///
    /// Parameter `count`: The capacity of the glyphs and translations buffers.
    ///
    /// # Safety
    ///
    /// - `glyphs` must be a valid pointer.
    /// - `translations` must be a valid pointer.
    #[doc(alias = "CTFontGetVerticalTranslationsForGlyphs")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn vertical_translations_for_glyphs(
        &self,
        glyphs: NonNull<CGGlyph>,
        translations: NonNull<CGSize>,
        count: CFIndex,
    ) {
        extern "C-unwind" {
            fn CTFontGetVerticalTranslationsForGlyphs(
                font: &CTFont,
                glyphs: NonNull<CGGlyph>,
                translations: NonNull<CGSize>,
                count: CFIndex,
            );
        }
        unsafe { CTFontGetVerticalTranslationsForGlyphs(self, glyphs, translations, count) }
    }

    /// Creates a path for the specified glyph.
    ///
    ///
    /// Creates a path from the outlines of the glyph for the specified font. The path will reflect the font point size, matrix, and transform parameter, in that order. The transform parameter will most commonly be used to provide a translation to the desired glyph origin.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyph`: The glyph.
    ///
    ///
    /// Parameter `matrix`: An affine transform applied to the path. Can be NULL, in which case CGAffineTransformIdentity will be used.
    ///
    ///
    /// Returns: A retained CGPath reference containing the glyph outlines or NULL if there is no such glyph or it has no outline.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreatePathForGlyph")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn path_for_glyph(
        &self,
        glyph: CGGlyph,
        matrix: *const CGAffineTransform,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CTFontCreatePathForGlyph(
                font: &CTFont,
                glyph: CGGlyph,
                matrix: *const CGAffineTransform,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CTFontCreatePathForGlyph(self, glyph, matrix) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// kCTFontVariationAxisIdentifierKey
    ///
    /// Key to get the variation axis identifier.
    ///
    /// This key is used with a variation axis dictionary to get the axis identifier value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxisidentifierkey?language=objc)
    pub static kCTFontVariationAxisIdentifierKey: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxisMinimumValueKey
    ///
    /// Key to get the variation axis minimum value.
    ///
    /// This key is used with a variation axis dictionary to get the minimum axis value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxisminimumvaluekey?language=objc)
    pub static kCTFontVariationAxisMinimumValueKey: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxisMaximumValueKey
    ///
    /// Key to get the variation axis maximum value.
    ///
    /// This key is used with a variation axis dictionary to get the maximum axis value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxismaximumvaluekey?language=objc)
    pub static kCTFontVariationAxisMaximumValueKey: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxisDefaultValueKey
    ///
    /// Key to get the variation axis default value.
    ///
    /// This key is used with a variation axis dictionary to get the default axis value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxisdefaultvaluekey?language=objc)
    pub static kCTFontVariationAxisDefaultValueKey: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxisNameKey
    ///
    /// Key to get the variation axis name string.
    ///
    /// This key is used with a variation axis dictionary to get the variation axis name.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxisnamekey?language=objc)
    pub static kCTFontVariationAxisNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontVariationAxisHiddenKey
    ///
    /// Key to get the hidden axis flag.
    ///
    /// This key contains a CFBoolean value that is true when the font designer recommends the axis not be exposed directly to end users in application interfaces.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontvariationaxishiddenkey?language=objc)
    pub static kCTFontVariationAxisHiddenKey: &'static CFString;
}

impl CTFont {
    /// Returns an array of variation axis dictionaries.
    ///
    /// Each variation axis dictionary contains the five kCTFontVariationAxis* keys above, and kCTFontVariationAxisNameKey values will be localized when supported by the font; for programmatic uses kCTFontVariationAxesAttribute may be used instead.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: An array of variation axis dictionaries or null if the font does not support variations.
    ///
    ///
    /// See also: kCTFontVariationAxesAttribute
    #[doc(alias = "CTFontCopyVariationAxes")]
    #[inline]
    pub unsafe fn variation_axes(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCopyVariationAxes(font: &CTFont) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopyVariationAxes(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a variation dictionary.
    ///
    /// This function describes the current configuration of a variation font: a dictionary of number values with variation identifier number keys. As of macOS 10.12 and iOS 10.0, only non-default values (as determined by the variation axis) are returned.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a variation dictionary or null if the font does not support variations.
    ///
    ///
    /// See also: kCTFontVariationAxisIdentifierKey
    ///
    /// See also: kCTFontVariationAxisDefaultValueKey
    #[doc(alias = "CTFontCopyVariation")]
    #[inline]
    pub unsafe fn variation(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CTFontCopyVariation(font: &CTFont) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CTFontCopyVariation(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// kCTFontOpenTypeFeatureTag
    ///
    /// Key to get the OpenType feature tag.
    ///
    /// This key can be used with a font feature dictionary to get the tag as a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontopentypefeaturetag?language=objc)
    pub static kCTFontOpenTypeFeatureTag: &'static CFString;
}

extern "C" {
    /// kCTFontOpenTypeFeatureValue
    ///
    /// Key to get the OpenType feature value.
    ///
    /// This key can be used with a font feature dictionary to get the value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontopentypefeaturevalue?language=objc)
    pub static kCTFontOpenTypeFeatureValue: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureTypeIdentifierKey
    ///
    /// Key to get the font feature type value.
    ///
    /// This key can be used with a font feature dictionary to get the type identifier as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturetypeidentifierkey?language=objc)
    pub static kCTFontFeatureTypeIdentifierKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureTypeNameKey
    ///
    /// Key to get the font feature name.
    ///
    /// This key can be used with a font feature dictionary to get the localized type name string as a CFString.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturetypenamekey?language=objc)
    pub static kCTFontFeatureTypeNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureTypeExclusiveKey
    ///
    /// Key to get the font feature exclusive setting.
    ///
    /// This key can be used with a font feature dictionary to get the the exclusive setting of the feature as a CFBoolean. The value associated with this key indicates whether the feature selectors associated with this type should be mutually exclusive.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturetypeexclusivekey?language=objc)
    pub static kCTFontFeatureTypeExclusiveKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureTypeSelectorsKey
    ///
    /// Key to get the font feature selectors.
    ///
    /// This key can be used with a font feature dictionary to get the array of font feature selectors as a CFArrayRef. This is an array of selector dictionaries that contain the values for the following selector keys.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturetypeselectorskey?language=objc)
    pub static kCTFontFeatureTypeSelectorsKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSelectorIdentifierKey
    ///
    /// Key to get the font feature selector identifier.
    ///
    /// This key can be used with a selector dictionary corresponding to a feature type to obtain the selector identifier value as a CFNumberRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeatureselectoridentifierkey?language=objc)
    pub static kCTFontFeatureSelectorIdentifierKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSelectorNameKey
    ///
    /// Key to get the font feature selector name.
    ///
    /// This key is used with a selector dictionary to get the localized name string for the selector as a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeatureselectornamekey?language=objc)
    pub static kCTFontFeatureSelectorNameKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSelectorDefaultKey
    ///
    /// Key to get the font feature selector default setting value.
    ///
    /// This key is used with a selector dictionary to get the default indicator for the selector. This value is a CFBooleanRef which if present and true indicates that this selector is the default setting for the current feature type.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeatureselectordefaultkey?language=objc)
    pub static kCTFontFeatureSelectorDefaultKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSelectorSettingKey
    ///
    /// Key to get or specify the current feature setting.
    ///
    /// This key is used with a selector dictionary to get or specify the current setting for the selector. This value is a CFBooleanRef to indicate whether this selector is on or off. If this key is not present, the default setting is used.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeatureselectorsettingkey?language=objc)
    pub static kCTFontFeatureSelectorSettingKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureSampleTextKey
    ///
    /// Key to get the font feature sample text.
    ///
    /// This key can be used with a font feature dictionary to get the localized sample text as a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturesampletextkey?language=objc)
    pub static kCTFontFeatureSampleTextKey: &'static CFString;
}

extern "C" {
    /// kCTFontFeatureTooltipTextKey
    ///
    /// Key to get the font feature tooltip text.
    ///
    /// This key can be used with a font feature dictionary to get the localized tooltip text as a CFStringRef.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontfeaturetooltiptextkey?language=objc)
    pub static kCTFontFeatureTooltipTextKey: &'static CFString;
}

impl CTFont {
    /// Returns an array of font features
    ///
    ///
    /// The returned value describes the features available for the provided font. Each array value is a feature dictionary describing a feature type, with related selector dictionaries in an array under the kCTFontFeatureTypeSelectorsKey.
    /// While CoreText supports AAT and OpenType font features, they are preferentially represented as AAT features owing to their more formal structure: individual feature types can be either exclusive or non-exclusive, which indicates whether one or more of its selectors can be simultaneously enabled. Where possible features are elaborated with their OpenType feature tag and value, which can occur within both type or selector dictionaries depending on the feature's mapping to an AAT type and selector pair.
    /// Names are localized according to the preferred langauges of the caller and therefore are not appropriate for programmatically identifying features.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns an array of font feature dictionaries for the font reference.
    #[doc(alias = "CTFontCopyFeatures")]
    #[inline]
    pub unsafe fn features(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCopyFeatures(font: &CTFont) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopyFeatures(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns an array of font feature setting tuples
    ///
    ///
    /// A setting tuple is a dictionary of a kCTFontFeatureTypeIdentifierKey key-value pair and a kCTFontFeatureSelectorIdentifierKey key-value pair. Each tuple corresponds to an enabled non-default setting. It is the caller's responsibility to handle exclusive and non-exclusive settings as necessary.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Returns: This function returns a normalized array of font feature setting dictionaries. The array will only contain the non-default settings that should be applied to the font, or NULL if the default settings should be used.
    #[doc(alias = "CTFontCopyFeatureSettings")]
    #[inline]
    pub unsafe fn feature_settings(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCopyFeatureSettings(font: &CTFont) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopyFeatureSettings(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns a CGFontRef and attributes.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `attributes`: A pointer to a CTFontDescriptorRef to receive a font descriptor containing additional attributes. Can be NULL. Must be released by caller.
    ///
    ///
    /// Returns: This function returns a CGFontRef for the given font reference. Additional attributes from the font will be passed back as a font descriptor via the attributes parameter. The result must be released by the caller.
    ///
    /// # Safety
    ///
    /// `attributes` must be a valid pointer or null.
    #[doc(alias = "CTFontCopyGraphicsFont")]
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn graphics_font(
        &self,
        attributes: *mut *const CTFontDescriptor,
    ) -> CFRetained<CGFont> {
        extern "C-unwind" {
            fn CTFontCopyGraphicsFont(
                font: &CTFont,
                attributes: *mut *const CTFontDescriptor,
            ) -> Option<NonNull<CGFont>>;
        }
        let ret = unsafe { CTFontCopyGraphicsFont(self, attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Creates a new font reference from a CGFontRef.
    ///
    ///
    /// Parameter `graphicsFont`: A valid CGFontRef.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default font size of 12.0 will be used.
    ///
    ///
    /// Parameter `matrix`: The transformation matrix for the font. If unspecified, the identity matrix will be used. Optional.
    ///
    ///
    /// Parameter `attributes`: A CTFontDescriptorRef containing additional attributes that should be matched. Optional.
    ///
    ///
    /// Returns: This function returns a new font reference for an existing CGFontRef with the specified size, matrix, and additional attributes.
    ///
    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithGraphicsFont")]
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[inline]
    pub unsafe fn with_graphics_font(
        graphics_font: &CGFont,
        size: CGFloat,
        matrix: *const CGAffineTransform,
        attributes: Option<&CTFontDescriptor>,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithGraphicsFont(
                graphics_font: &CGFont,
                size: CGFloat,
                matrix: *const CGAffineTransform,
                attributes: Option<&CTFontDescriptor>,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateWithGraphicsFont(graphics_font, size, matrix, attributes) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/atsfontref?language=objc)
pub type ATSFontRef = u32;

impl CTFont {
    /// Returns a font reference for the given Quickdraw instance.
    ///
    ///
    /// This function is provided for compatibility support between Core Text and clients needing to support Quickdraw font references.
    ///
    ///
    /// Parameter `name`: The Quickdraw font name. If NULL or zero length, an identifier must be specified instead.
    ///
    ///
    /// Parameter `identifier`: The Quickdraw font identifier. If 0, a name must be specified instead.
    ///
    ///
    /// Parameter `style`: The Quickdraw font style.
    ///
    ///
    /// Parameter `size`: The point size for the font reference. If 0.0 is specified, the default size of 12.0 is used.
    ///
    ///
    /// Returns: This function returns the best font instance matching the Quickdraw instance information.
    ///
    /// # Safety
    ///
    /// `name` must be a valid pointer or null.
    #[doc(alias = "CTFontCreateWithQuickdrawInstance")]
    #[deprecated = "Quickdraw font references are deprecated"]
    #[inline]
    pub unsafe fn with_quickdraw_instance(
        name: ConstStr255Param,
        identifier: i16,
        style: u8,
        size: CGFloat,
    ) -> CFRetained<CTFont> {
        extern "C-unwind" {
            fn CTFontCreateWithQuickdrawInstance(
                name: ConstStr255Param,
                identifier: i16,
                style: u8,
                size: CGFloat,
            ) -> Option<NonNull<CTFont>>;
        }
        let ret = unsafe { CTFontCreateWithQuickdrawInstance(name, identifier, style, size) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablebase?language=objc)
pub const kCTFontTableBASE: c_uint = 0x42415345;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecbdt?language=objc)
pub const kCTFontTableCBDT: c_uint = 0x43424454;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecblc?language=objc)
pub const kCTFontTableCBLC: c_uint = 0x43424c43;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecff?language=objc)
pub const kCTFontTableCFF: c_uint = 0x43464620;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecff2?language=objc)
pub const kCTFontTableCFF2: c_uint = 0x43464632;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecolr?language=objc)
pub const kCTFontTableCOLR: c_uint = 0x434f4c52;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecpal?language=objc)
pub const kCTFontTableCPAL: c_uint = 0x4350414c;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttabledsig?language=objc)
pub const kCTFontTableDSIG: c_uint = 0x44534947;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableebdt?language=objc)
pub const kCTFontTableEBDT: c_uint = 0x45424454;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableeblc?language=objc)
pub const kCTFontTableEBLC: c_uint = 0x45424c43;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableebsc?language=objc)
pub const kCTFontTableEBSC: c_uint = 0x45425343;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablegdef?language=objc)
pub const kCTFontTableGDEF: c_uint = 0x47444546;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablegpos?language=objc)
pub const kCTFontTableGPOS: c_uint = 0x47504f53;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablegsub?language=objc)
pub const kCTFontTableGSUB: c_uint = 0x47535542;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehvar?language=objc)
pub const kCTFontTableHVAR: c_uint = 0x48564152;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablejstf?language=objc)
pub const kCTFontTableJSTF: c_uint = 0x4a535446;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableltsh?language=objc)
pub const kCTFontTableLTSH: c_uint = 0x4c545348;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemath?language=objc)
pub const kCTFontTableMATH: c_uint = 0x4d415448;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemerg?language=objc)
pub const kCTFontTableMERG: c_uint = 0x4d455247;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemvar?language=objc)
pub const kCTFontTableMVAR: c_uint = 0x4d564152;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableos2?language=objc)
pub const kCTFontTableOS2: c_uint = 0x4f532f32;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablepclt?language=objc)
pub const kCTFontTablePCLT: c_uint = 0x50434c54;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablestat?language=objc)
pub const kCTFontTableSTAT: c_uint = 0x53544154;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablesvg?language=objc)
pub const kCTFontTableSVG: c_uint = 0x53564720;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablevdmx?language=objc)
pub const kCTFontTableVDMX: c_uint = 0x56444d58;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablevorg?language=objc)
pub const kCTFontTableVORG: c_uint = 0x564f5247;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablevvar?language=objc)
pub const kCTFontTableVVAR: c_uint = 0x56564152;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablezapf?language=objc)
pub const kCTFontTableZapf: c_uint = 0x5a617066;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableacnt?language=objc)
pub const kCTFontTableAcnt: c_uint = 0x61636e74;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableankr?language=objc)
pub const kCTFontTableAnkr: c_uint = 0x616e6b72;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableavar?language=objc)
pub const kCTFontTableAvar: c_uint = 0x61766172;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablebdat?language=objc)
pub const kCTFontTableBdat: c_uint = 0x62646174;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablebhed?language=objc)
pub const kCTFontTableBhed: c_uint = 0x62686564;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablebloc?language=objc)
pub const kCTFontTableBloc: c_uint = 0x626c6f63;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablebsln?language=objc)
pub const kCTFontTableBsln: c_uint = 0x62736c6e;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecidg?language=objc)
pub const kCTFontTableCidg: c_uint = 0x63696467;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecmap?language=objc)
pub const kCTFontTableCmap: c_uint = 0x636d6170;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecvar?language=objc)
pub const kCTFontTableCvar: c_uint = 0x63766172;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablecvt?language=objc)
pub const kCTFontTableCvt: c_uint = 0x63767420;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefdsc?language=objc)
pub const kCTFontTableFdsc: c_uint = 0x66647363;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefeat?language=objc)
pub const kCTFontTableFeat: c_uint = 0x66656174;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefmtx?language=objc)
pub const kCTFontTableFmtx: c_uint = 0x666d7478;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefond?language=objc)
pub const kCTFontTableFond: c_uint = 0x666f6e64;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefpgm?language=objc)
pub const kCTFontTableFpgm: c_uint = 0x6670676d;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablefvar?language=objc)
pub const kCTFontTableFvar: c_uint = 0x66766172;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablegasp?language=objc)
pub const kCTFontTableGasp: c_uint = 0x67617370;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableglyf?language=objc)
pub const kCTFontTableGlyf: c_uint = 0x676c7966;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablegvar?language=objc)
pub const kCTFontTableGvar: c_uint = 0x67766172;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehdmx?language=objc)
pub const kCTFontTableHdmx: c_uint = 0x68646d78;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehead?language=objc)
pub const kCTFontTableHead: c_uint = 0x68656164;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehhea?language=objc)
pub const kCTFontTableHhea: c_uint = 0x68686561;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehmtx?language=objc)
pub const kCTFontTableHmtx: c_uint = 0x686d7478;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablehsty?language=objc)
pub const kCTFontTableHsty: c_uint = 0x68737479;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablejust?language=objc)
pub const kCTFontTableJust: c_uint = 0x6a757374;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablekern?language=objc)
pub const kCTFontTableKern: c_uint = 0x6b65726e;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablekerx?language=objc)
pub const kCTFontTableKerx: c_uint = 0x6b657278;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablelcar?language=objc)
pub const kCTFontTableLcar: c_uint = 0x6c636172;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableloca?language=objc)
pub const kCTFontTableLoca: c_uint = 0x6c6f6361;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableltag?language=objc)
pub const kCTFontTableLtag: c_uint = 0x6c746167;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemaxp?language=objc)
pub const kCTFontTableMaxp: c_uint = 0x6d617870;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemeta?language=objc)
pub const kCTFontTableMeta: c_uint = 0x6d657461;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemort?language=objc)
pub const kCTFontTableMort: c_uint = 0x6d6f7274;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablemorx?language=objc)
pub const kCTFontTableMorx: c_uint = 0x6d6f7278;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablename?language=objc)
pub const kCTFontTableName: c_uint = 0x6e616d65;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableopbd?language=objc)
pub const kCTFontTableOpbd: c_uint = 0x6f706264;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablepost?language=objc)
pub const kCTFontTablePost: c_uint = 0x706f7374;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableprep?language=objc)
pub const kCTFontTablePrep: c_uint = 0x70726570;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttableprop?language=objc)
pub const kCTFontTableProp: c_uint = 0x70726f70;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablesbit?language=objc)
pub const kCTFontTableSbit: c_uint = 0x73626974;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablesbix?language=objc)
pub const kCTFontTableSbix: c_uint = 0x73626978;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttabletrak?language=objc)
pub const kCTFontTableTrak: c_uint = 0x7472616b;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablevhea?language=objc)
pub const kCTFontTableVhea: c_uint = 0x76686561;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablevmtx?language=objc)
pub const kCTFontTableVmtx: c_uint = 0x766d7478;
/// [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfonttablexref?language=objc)
pub const kCTFontTableXref: c_uint = 0x78726566;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfonttabletag?language=objc)
pub type CTFontTableTag = FourCharCode;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfonttableoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontTableOptions(pub u32);
bitflags::bitflags! {
    impl CTFontTableOptions: u32 {
        #[doc(alias = "kCTFontTableOptionNoOptions")]
        const NoOptions = 0;
        #[doc(alias = "kCTFontTableOptionExcludeSynthetic")]
#[deprecated = "Unsupported"]
        const ExcludeSynthetic = 1<<0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontTableOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontTableOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CTFont {
    /// Returns an array of font table tags.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `options`: The options used when copying font tables.
    ///
    ///
    /// Returns: This function returns an array of CTFontTableTag values for the given font and the supplied options. The returned set will contain unboxed values, which may be extracted like so:
    /// <code>
    /// CTFontTableTag tag = (CTFontTableTag)(uintptr_t)CFArrayGetValueAtIndex(tags, index);
    /// </code>
    #[doc(alias = "CTFontCopyAvailableTables")]
    #[inline]
    pub unsafe fn available_tables(
        &self,
        options: CTFontTableOptions,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CTFontCopyAvailableTables(
                font: &CTFont,
                options: CTFontTableOptions,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CTFontCopyAvailableTables(self, options) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Determine whether a table is present in a font.
    ///
    /// This is a convenience function to avoid requesting an array of table tags or any table data. It behaves according as if using `kCTFontTableOptionNoOptions`.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `tag`: The font table identifier as a CTFontTableTag.
    ///
    ///
    /// Returns: Returns true if the call was successful and the requested table is present.
    #[doc(alias = "CTFontHasTable")]
    #[inline]
    pub unsafe fn has_table(&self, tag: CTFontTableTag) -> bool {
        extern "C-unwind" {
            fn CTFontHasTable(font: &CTFont, tag: CTFontTableTag) -> bool;
        }
        unsafe { CTFontHasTable(self, tag) }
    }

    /// Returns a reference to the font table data.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `table`: The font table identifier as a CTFontTableTag.
    ///
    ///
    /// Parameter `options`: The options used when copying font table.
    ///
    ///
    /// Returns: This function returns a retained reference to the font table data as CFDataRef or NULL if the table is not present.
    #[doc(alias = "CTFontCopyTable")]
    #[inline]
    pub unsafe fn table(
        &self,
        table: CTFontTableTag,
        options: CTFontTableOptions,
    ) -> Option<CFRetained<CFData>> {
        extern "C-unwind" {
            fn CTFontCopyTable(
                font: &CTFont,
                table: CTFontTableTag,
                options: CTFontTableOptions,
            ) -> Option<NonNull<CFData>>;
        }
        let ret = unsafe { CTFontCopyTable(self, table, options) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Renders the given glyphs from the CTFont at the given positions in the CGContext.
    ///
    /// This function will modify the CGContext's font, text size, and text matrix if specified in the CTFont. These attributes will not be restored.
    /// The given glyphs should be the result of proper Unicode text layout operations (such as CTLine). Results from CTFontGetGlyphsForCharacters (or similar APIs) do not perform any Unicode text layout.
    ///
    ///
    /// Parameter `font`: The font to render glyphs from. If the font has a size or matrix attribute, the CGContext will be set with these values.
    ///
    ///
    /// Parameter `glyphs`: The glyphs to be rendered. See above discussion of how the glyphs should be derived.
    ///
    ///
    /// Parameter `positions`: The positions (origins) for each glyph. The positions are in user space. The number of positions passed in must be equivalent to the number of glyphs.
    ///
    ///
    /// Parameter `count`: The number of glyphs to be rendered from the glyphs array.
    ///
    ///
    /// Parameter `context`: CGContext used to render the glyphs.
    ///
    /// # Safety
    ///
    /// - `glyphs` must be a valid pointer.
    /// - `positions` must be a valid pointer.
    #[doc(alias = "CTFontDrawGlyphs")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn draw_glyphs(
        &self,
        glyphs: NonNull<CGGlyph>,
        positions: NonNull<CGPoint>,
        count: usize,
        context: &CGContext,
    ) {
        extern "C-unwind" {
            fn CTFontDrawGlyphs(
                font: &CTFont,
                glyphs: NonNull<CGGlyph>,
                positions: NonNull<CGPoint>,
                count: usize,
                context: &CGContext,
            );
        }
        unsafe { CTFontDrawGlyphs(self, glyphs, positions, count, context) }
    }

    /// Returns caret positions within a glyph.
    ///
    /// This function is used to obtain caret positions for a specific glyph.
    /// The return value is the max number of positions possible, and the function
    /// will populate the caller's positions buffer with available positions if possible.
    /// This function may not be able to produce positions if the font does not
    /// have the appropriate data, in which case it will return 0.
    ///
    ///
    /// Parameter `font`: The font reference.
    ///
    ///
    /// Parameter `glyph`: The glyph.
    ///
    ///
    /// Parameter `positions`: A buffer of at least maxPositions to receive the ligature caret positions for
    /// the glyph.
    ///
    ///
    /// Parameter `maxPositions`: The maximum number of positions to return.
    ///
    ///
    /// Returns: Returns the number of caret positions for the specified glyph.
    ///
    /// # Safety
    ///
    /// `positions` must be a valid pointer or null.
    #[doc(alias = "CTFontGetLigatureCaretPositions")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn ligature_caret_positions(
        &self,
        glyph: CGGlyph,
        positions: *mut CGFloat,
        max_positions: CFIndex,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CTFontGetLigatureCaretPositions(
                font: &CTFont,
                glyph: CGGlyph,
                positions: *mut CGFloat,
                max_positions: CFIndex,
            ) -> CFIndex;
        }
        unsafe { CTFontGetLigatureCaretPositions(self, glyph, positions, max_positions) }
    }
}

extern "C" {
    /// kCTBaselineClassRoman
    ///
    ///
    /// Key to reference the Roman baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Roman baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclassroman?language=objc)
    pub static kCTBaselineClassRoman: &'static CFString;
}

extern "C" {
    /// kCTBaselineClassIdeographicCentered
    ///
    ///
    /// Key to reference the Ideographic Centered baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Ideographic Centered baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclassideographiccentered?language=objc)
    pub static kCTBaselineClassIdeographicCentered: &'static CFString;
}

extern "C" {
    /// kCTBaselineClassIdeographicLow
    ///
    ///
    /// Key to reference the Ideographic Low baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Ideographic Low baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclassideographiclow?language=objc)
    pub static kCTBaselineClassIdeographicLow: &'static CFString;
}

extern "C" {
    /// kCTBaselineClassIdeographicHigh
    ///
    ///
    /// Key to reference the Ideographic High baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Ideographic High baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclassideographichigh?language=objc)
    pub static kCTBaselineClassIdeographicHigh: &'static CFString;
}

extern "C" {
    /// kCTBaselineClassHanging
    ///
    ///
    /// Key to reference the Hanging baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Hanging baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclasshanging?language=objc)
    pub static kCTBaselineClassHanging: &'static CFString;
}

extern "C" {
    /// kCTBaselineClassMath
    ///
    ///
    /// Key to reference the Math baseline class.
    ///
    ///
    /// This key can be used with a baseline info dictionary to offset to the Math baseline as a CFNumberRef float. It can also be used as the value for kCTBaselineClassAttributeName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineclassmath?language=objc)
    pub static kCTBaselineClassMath: &'static CFString;
}

extern "C" {
    /// kCTBaselineReferenceFont
    ///
    ///
    /// Key to reference a font for the reference baseline.
    ///
    ///
    /// This key can be used to specify a font for the reference baseline. The value is a CTFontRef or the kCTBaselineOriginalFont constant.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselinereferencefont?language=objc)
    pub static kCTBaselineReferenceFont: &'static CFString;
}

extern "C" {
    /// kCTBaselineOriginalFont
    ///
    ///
    /// Use the original font for setting the reference baseline.
    ///
    ///
    /// This constant can be used as the value for kCTBaselineReferenceFont to specify that the original font should be used for the reference baseline.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctbaselineoriginalfont?language=objc)
    pub static kCTBaselineOriginalFont: &'static CFString;
}

impl CTFont {
    #[doc(alias = "CTFontGetTypographicBoundsForAdaptiveImageProvider")]
    #[cfg(all(feature = "CTRunDelegate", feature = "objc2"))]
    #[inline]
    pub unsafe fn typographic_bounds_for_adaptive_image_provider(
        &self,
        provider: Option<&ProtocolObject<dyn CTAdaptiveImageProviding>>,
    ) -> CGRect {
        extern "C-unwind" {
            fn CTFontGetTypographicBoundsForAdaptiveImageProvider(
                font: &CTFont,
                provider: Option<&ProtocolObject<dyn CTAdaptiveImageProviding>>,
            ) -> CGRect;
        }
        unsafe { CTFontGetTypographicBoundsForAdaptiveImageProvider(self, provider) }
    }

    #[doc(alias = "CTFontDrawImageFromAdaptiveImageProviderAtPoint")]
    #[cfg(all(
        feature = "CTRunDelegate",
        feature = "objc2",
        feature = "objc2-core-graphics"
    ))]
    #[inline]
    pub unsafe fn draw_image_from_adaptive_image_provider_at_point(
        &self,
        provider: &ProtocolObject<dyn CTAdaptiveImageProviding>,
        point: CGPoint,
        context: &CGContext,
    ) {
        extern "C-unwind" {
            fn CTFontDrawImageFromAdaptiveImageProviderAtPoint(
                font: &CTFont,
                provider: &ProtocolObject<dyn CTAdaptiveImageProviding>,
                point: CGPoint,
                context: &CGContext,
            );
        }
        unsafe { CTFontDrawImageFromAdaptiveImageProviderAtPoint(self, provider, point, context) }
    }
}

#[deprecated = "renamed to `CTFont::with_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithName(
    name: &CFString,
    size: CGFloat,
    matrix: *const CGAffineTransform,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithName(
            name: &CFString,
            size: CGFloat,
            matrix: *const CGAffineTransform,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateWithName(name, size, matrix) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(feature = "CTFontDescriptor")]
#[deprecated = "renamed to `CTFont::with_font_descriptor`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithFontDescriptor(
    descriptor: &CTFontDescriptor,
    size: CGFloat,
    matrix: *const CGAffineTransform,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithFontDescriptor(
            descriptor: &CTFontDescriptor,
            size: CGFloat,
            matrix: *const CGAffineTransform,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateWithFontDescriptor(descriptor, size, matrix) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::with_name_and_options`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithNameAndOptions(
    name: &CFString,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    options: CTFontOptions,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithNameAndOptions(
            name: &CFString,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            options: CTFontOptions,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateWithNameAndOptions(name, size, matrix, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(feature = "CTFontDescriptor")]
#[deprecated = "renamed to `CTFont::with_font_descriptor_and_options`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithFontDescriptorAndOptions(
    descriptor: &CTFontDescriptor,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    options: CTFontOptions,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithFontDescriptorAndOptions(
            descriptor: &CTFontDescriptor,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            options: CTFontOptions,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret =
        unsafe { CTFontCreateWithFontDescriptorAndOptions(descriptor, size, matrix, options) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::new_ui_font_for_language`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateUIFontForLanguage(
    ui_type: CTFontUIFontType,
    size: CGFloat,
    language: Option<&CFString>,
) -> Option<CFRetained<CTFont>> {
    extern "C-unwind" {
        fn CTFontCreateUIFontForLanguage(
            ui_type: CTFontUIFontType,
            size: CGFloat,
            language: Option<&CFString>,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateUIFontForLanguage(ui_type, size, language) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CTFontDescriptor")]
#[deprecated = "renamed to `CTFont::copy_with_attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateCopyWithAttributes(
    font: &CTFont,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    attributes: Option<&CTFontDescriptor>,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateCopyWithAttributes(
            font: &CTFont,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            attributes: Option<&CTFontDescriptor>,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateCopyWithAttributes(font, size, matrix, attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(feature = "CTFontTraits")]
#[deprecated = "renamed to `CTFont::copy_with_symbolic_traits`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateCopyWithSymbolicTraits(
    font: &CTFont,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    sym_trait_value: CTFontSymbolicTraits,
    sym_trait_mask: CTFontSymbolicTraits,
) -> Option<CFRetained<CTFont>> {
    extern "C-unwind" {
        fn CTFontCreateCopyWithSymbolicTraits(
            font: &CTFont,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            sym_trait_value: CTFontSymbolicTraits,
            sym_trait_mask: CTFontSymbolicTraits,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe {
        CTFontCreateCopyWithSymbolicTraits(font, size, matrix, sym_trait_value, sym_trait_mask)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::copy_with_family`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateCopyWithFamily(
    font: &CTFont,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    family: &CFString,
) -> Option<CFRetained<CTFont>> {
    extern "C-unwind" {
        fn CTFontCreateCopyWithFamily(
            font: &CTFont,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            family: &CFString,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateCopyWithFamily(font, size, matrix, family) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::for_string`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateForString(
    current_font: &CTFont,
    string: &CFString,
    range: CFRange,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateForString(
            current_font: &CTFont,
            string: &CFString,
            range: CFRange,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateForString(current_font, string, range) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::for_string_with_language`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateForStringWithLanguage(
    current_font: &CTFont,
    string: &CFString,
    range: CFRange,
    language: Option<&CFString>,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateForStringWithLanguage(
            current_font: &CTFont,
            string: &CFString,
            range: CFRange,
            language: Option<&CFString>,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateForStringWithLanguage(current_font, string, range, language) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(feature = "CTFontDescriptor")]
#[deprecated = "renamed to `CTFont::font_descriptor`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyFontDescriptor(
    font: &CTFont,
) -> CFRetained<CTFontDescriptor> {
    extern "C-unwind" {
        fn CTFontCopyFontDescriptor(font: &CTFont) -> Option<NonNull<CTFontDescriptor>>;
    }
    let ret = unsafe { CTFontCopyFontDescriptor(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::attribute`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyAttribute(
    font: &CTFont,
    attribute: &CFString,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CTFontCopyAttribute(font: &CTFont, attribute: &CFString) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CTFontCopyAttribute(font, attribute) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::size`"]
    pub fn CTFontGetSize(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::matrix`"]
    pub fn CTFontGetMatrix(font: &CTFont) -> CGAffineTransform;
}

extern "C-unwind" {
    #[cfg(feature = "CTFontTraits")]
    #[deprecated = "renamed to `CTFont::symbolic_traits`"]
    pub fn CTFontGetSymbolicTraits(font: &CTFont) -> CTFontSymbolicTraits;
}

#[deprecated = "renamed to `CTFont::traits`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyTraits(font: &CTFont) -> CFRetained<CFDictionary> {
    extern "C-unwind" {
        fn CTFontCopyTraits(font: &CTFont) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CTFontCopyTraits(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::default_cascade_list_for_languages`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyDefaultCascadeListForLanguages(
    font: &CTFont,
    language_pref_list: Option<&CFArray>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCopyDefaultCascadeListForLanguages(
            font: &CTFont,
            language_pref_list: Option<&CFArray>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopyDefaultCascadeListForLanguages(font, language_pref_list) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::post_script_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyPostScriptName(font: &CTFont) -> CFRetained<CFString> {
    extern "C-unwind" {
        fn CTFontCopyPostScriptName(font: &CTFont) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyPostScriptName(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::family_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyFamilyName(font: &CTFont) -> CFRetained<CFString> {
    extern "C-unwind" {
        fn CTFontCopyFamilyName(font: &CTFont) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyFamilyName(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::full_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyFullName(font: &CTFont) -> CFRetained<CFString> {
    extern "C-unwind" {
        fn CTFontCopyFullName(font: &CTFont) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyFullName(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::display_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyDisplayName(font: &CTFont) -> CFRetained<CFString> {
    extern "C-unwind" {
        fn CTFontCopyDisplayName(font: &CTFont) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyDisplayName(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyName(
    font: &CTFont,
    name_key: &CFString,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CTFontCopyName(font: &CTFont, name_key: &CFString) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyName(font, name_key) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::localized_name`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyLocalizedName(
    font: &CTFont,
    name_key: &CFString,
    actual_language: *mut *const CFString,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CTFontCopyLocalizedName(
            font: &CTFont,
            name_key: &CFString,
            actual_language: *mut *const CFString,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyLocalizedName(font, name_key, actual_language) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::character_set`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyCharacterSet(
    font: &CTFont,
) -> CFRetained<CFCharacterSet> {
    extern "C-unwind" {
        fn CTFontCopyCharacterSet(font: &CTFont) -> Option<NonNull<CFCharacterSet>>;
    }
    let ret = unsafe { CTFontCopyCharacterSet(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::string_encoding`"]
    pub fn CTFontGetStringEncoding(font: &CTFont) -> CFStringEncoding;
}

#[deprecated = "renamed to `CTFont::supported_languages`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopySupportedLanguages(font: &CTFont) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn CTFontCopySupportedLanguages(font: &CTFont) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopySupportedLanguages(font) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::glyphs_for_characters`"]
    pub fn CTFontGetGlyphsForCharacters(
        font: &CTFont,
        characters: NonNull<UniChar>,
        glyphs: NonNull<CGGlyph>,
        count: CFIndex,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::ascent`"]
    pub fn CTFontGetAscent(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::descent`"]
    pub fn CTFontGetDescent(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::leading`"]
    pub fn CTFontGetLeading(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::units_per_em`"]
    pub fn CTFontGetUnitsPerEm(font: &CTFont) -> c_uint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::glyph_count`"]
    pub fn CTFontGetGlyphCount(font: &CTFont) -> CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::bounding_box`"]
    pub fn CTFontGetBoundingBox(font: &CTFont) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::underline_position`"]
    pub fn CTFontGetUnderlinePosition(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::underline_thickness`"]
    pub fn CTFontGetUnderlineThickness(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::slant_angle`"]
    pub fn CTFontGetSlantAngle(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::cap_height`"]
    pub fn CTFontGetCapHeight(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::x_height`"]
    pub fn CTFontGetXHeight(font: &CTFont) -> CGFloat;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::glyph_with_name`"]
    pub fn CTFontGetGlyphWithName(font: &CTFont, glyph_name: &CFString) -> CGGlyph;
}

#[cfg(feature = "objc2-core-graphics")]
#[deprecated = "renamed to `CTFont::name_for_glyph`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyNameForGlyph(
    font: &CTFont,
    glyph: CGGlyph,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CTFontCopyNameForGlyph(font: &CTFont, glyph: CGGlyph) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CTFontCopyNameForGlyph(font, glyph) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[deprecated = "renamed to `CTFont::bounding_rects_for_glyphs`"]
    pub fn CTFontGetBoundingRectsForGlyphs(
        font: &CTFont,
        orientation: CTFontOrientation,
        glyphs: NonNull<CGGlyph>,
        bounding_rects: *mut CGRect,
        count: CFIndex,
    ) -> CGRect;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::optical_bounds_for_glyphs`"]
    pub fn CTFontGetOpticalBoundsForGlyphs(
        font: &CTFont,
        glyphs: NonNull<CGGlyph>,
        bounding_rects: *mut CGRect,
        count: CFIndex,
        options: CFOptionFlags,
    ) -> CGRect;
}

extern "C-unwind" {
    #[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
    #[deprecated = "renamed to `CTFont::advances_for_glyphs`"]
    pub fn CTFontGetAdvancesForGlyphs(
        font: &CTFont,
        orientation: CTFontOrientation,
        glyphs: NonNull<CGGlyph>,
        advances: *mut CGSize,
        count: CFIndex,
    ) -> c_double;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::vertical_translations_for_glyphs`"]
    pub fn CTFontGetVerticalTranslationsForGlyphs(
        font: &CTFont,
        glyphs: NonNull<CGGlyph>,
        translations: NonNull<CGSize>,
        count: CFIndex,
    );
}

#[cfg(feature = "objc2-core-graphics")]
#[deprecated = "renamed to `CTFont::path_for_glyph`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreatePathForGlyph(
    font: &CTFont,
    glyph: CGGlyph,
    matrix: *const CGAffineTransform,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CTFontCreatePathForGlyph(
            font: &CTFont,
            glyph: CGGlyph,
            matrix: *const CGAffineTransform,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CTFontCreatePathForGlyph(font, glyph, matrix) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::variation_axes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyVariationAxes(
    font: &CTFont,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCopyVariationAxes(font: &CTFont) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopyVariationAxes(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::variation`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyVariation(
    font: &CTFont,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CTFontCopyVariation(font: &CTFont) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CTFontCopyVariation(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::features`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyFeatures(font: &CTFont) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCopyFeatures(font: &CTFont) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopyFeatures(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CTFont::feature_settings`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyFeatureSettings(
    font: &CTFont,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCopyFeatureSettings(font: &CTFont) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopyFeatureSettings(font) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
#[deprecated = "renamed to `CTFont::graphics_font`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyGraphicsFont(
    font: &CTFont,
    attributes: *mut *const CTFontDescriptor,
) -> CFRetained<CGFont> {
    extern "C-unwind" {
        fn CTFontCopyGraphicsFont(
            font: &CTFont,
            attributes: *mut *const CTFontDescriptor,
        ) -> Option<NonNull<CGFont>>;
    }
    let ret = unsafe { CTFontCopyGraphicsFont(font, attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[cfg(all(feature = "CTFontDescriptor", feature = "objc2-core-graphics"))]
#[deprecated = "renamed to `CTFont::with_graphics_font`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithGraphicsFont(
    graphics_font: &CGFont,
    size: CGFloat,
    matrix: *const CGAffineTransform,
    attributes: Option<&CTFontDescriptor>,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithGraphicsFont(
            graphics_font: &CGFont,
            size: CGFloat,
            matrix: *const CGAffineTransform,
            attributes: Option<&CTFontDescriptor>,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateWithGraphicsFont(graphics_font, size, matrix, attributes) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::with_quickdraw_instance`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCreateWithQuickdrawInstance(
    name: ConstStr255Param,
    identifier: i16,
    style: u8,
    size: CGFloat,
) -> CFRetained<CTFont> {
    extern "C-unwind" {
        fn CTFontCreateWithQuickdrawInstance(
            name: ConstStr255Param,
            identifier: i16,
            style: u8,
            size: CGFloat,
        ) -> Option<NonNull<CTFont>>;
    }
    let ret = unsafe { CTFontCreateWithQuickdrawInstance(name, identifier, style, size) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CTFont::available_tables`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyAvailableTables(
    font: &CTFont,
    options: CTFontTableOptions,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CTFontCopyAvailableTables(
            font: &CTFont,
            options: CTFontTableOptions,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CTFontCopyAvailableTables(font, options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTFont::has_table`"]
    pub fn CTFontHasTable(font: &CTFont, tag: CTFontTableTag) -> bool;
}

#[deprecated = "renamed to `CTFont::table`"]
#[inline]
pub unsafe extern "C-unwind" fn CTFontCopyTable(
    font: &CTFont,
    table: CTFontTableTag,
    options: CTFontTableOptions,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CTFontCopyTable(
            font: &CTFont,
            table: CTFontTableTag,
            options: CTFontTableOptions,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CTFontCopyTable(font, table, options) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::draw_glyphs`"]
    pub fn CTFontDrawGlyphs(
        font: &CTFont,
        glyphs: NonNull<CGGlyph>,
        positions: NonNull<CGPoint>,
        count: usize,
        context: &CGContext,
    );
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTFont::ligature_caret_positions`"]
    pub fn CTFontGetLigatureCaretPositions(
        font: &CTFont,
        glyph: CGGlyph,
        positions: *mut CGFloat,
        max_positions: CFIndex,
    ) -> CFIndex;
}

extern "C-unwind" {
    #[cfg(all(feature = "CTRunDelegate", feature = "objc2"))]
    #[deprecated = "renamed to `CTFont::typographic_bounds_for_adaptive_image_provider`"]
    pub fn CTFontGetTypographicBoundsForAdaptiveImageProvider(
        font: &CTFont,
        provider: Option<&ProtocolObject<dyn CTAdaptiveImageProviding>>,
    ) -> CGRect;
}

extern "C-unwind" {
    #[cfg(all(
        feature = "CTRunDelegate",
        feature = "objc2",
        feature = "objc2-core-graphics"
    ))]
    #[deprecated = "renamed to `CTFont::draw_image_from_adaptive_image_provider_at_point`"]
    pub fn CTFontDrawImageFromAdaptiveImageProviderAtPoint(
        font: &CTFont,
        provider: &ProtocolObject<dyn CTAdaptiveImageProviding>,
        point: CGPoint,
        context: &CGContext,
    );
}
