/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.SignatureAttribute;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.TypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistParameterDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistTypeParameter;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javassistmodel.JavassistUtils;

public class JavassistMethodLikeDeclarationAdapter {
    private CtBehavior ctBehavior;
    private TypeSolver typeSolver;
    private ResolvedMethodLikeDeclaration declaration;
    private SignatureAttribute.MethodSignature methodSignature;

    public JavassistMethodLikeDeclarationAdapter(CtBehavior ctBehavior, TypeSolver typeSolver, ResolvedMethodLikeDeclaration declaration) {
        this.ctBehavior = ctBehavior;
        this.typeSolver = typeSolver;
        this.declaration = declaration;
        try {
            String signature = ctBehavior.getGenericSignature();
            if (signature == null) {
                signature = ctBehavior.getSignature();
            }
            this.methodSignature = SignatureAttribute.toMethodSignature((String)signature);
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
    }

    public int getNumberOfParams() {
        return this.methodSignature.getParameterTypes().length;
    }

    public ResolvedParameterDeclaration getParam(int i) {
        boolean variadic = false;
        if ((this.ctBehavior.getModifiers() & 0x80) > 0) {
            variadic = i == this.methodSignature.getParameterTypes().length - 1;
        }
        Optional<String> paramName = JavassistUtils.extractParameterName(this.ctBehavior, i);
        ResolvedType type = JavassistUtils.signatureTypeToType(this.methodSignature.getParameterTypes()[i], this.typeSolver, this.declaration);
        return new JavassistParameterDeclaration(type, this.typeSolver, variadic, (String)paramName.orElse(null));
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        if (this.ctBehavior.getGenericSignature() == null) {
            return new ArrayList<ResolvedTypeParameterDeclaration>();
        }
        return Arrays.stream(this.methodSignature.getTypeParameters()).map(jasTp -> new JavassistTypeParameter((SignatureAttribute.TypeParameter)jasTp, this.declaration, this.typeSolver)).collect(Collectors.toList());
    }

    public int getNumberOfSpecifiedExceptions() {
        ExceptionsAttribute exceptionsAttribute = this.ctBehavior.getMethodInfo().getExceptionsAttribute();
        if (exceptionsAttribute == null) {
            return 0;
        }
        String[] exceptions = exceptionsAttribute.getExceptions();
        return exceptions == null ? 0 : exceptions.length;
    }

    public ResolvedType getSpecifiedException(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(String.format("index < 0: %d", index));
        }
        ExceptionsAttribute exceptionsAttribute = this.ctBehavior.getMethodInfo().getExceptionsAttribute();
        if (exceptionsAttribute == null) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: 0", index));
        }
        String[] exceptions = exceptionsAttribute.getExceptions();
        if (exceptions == null || index >= exceptions.length) {
            throw new IllegalArgumentException(String.format("No exception with index %d. Number of exceptions: %d", index, this.getNumberOfSpecifiedExceptions()));
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = this.typeSolver.solveType(exceptions[index]);
        return new ReferenceTypeImpl(typeDeclaration, Collections.emptyList());
    }

    public ResolvedType getReturnType() {
        return JavassistUtils.signatureTypeToType(this.methodSignature.getReturnType(), this.typeSolver, this.declaration);
    }
}

