//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// G4UnitsMessenger
//
// Author: Michel Maire, 1998
// --------------------------------------------------------------------

#include "G4UnitsMessenger.hh"

#include "G4UIcmdWithoutParameter.hh"
#include "G4UIdirectory.hh"
#include "G4UnitsTable.hh"

// --------------------------------------------------------------------
G4UnitsMessenger::G4UnitsMessenger()
{
  UnitsTableDir = new G4UIdirectory("/units/");
  UnitsTableDir->SetGuidance("Available units.");

  ListCmd = new G4UIcmdWithoutParameter("/units/list", this);
  ListCmd->SetGuidance("full list of available units.");
}

// --------------------------------------------------------------------
G4UnitsMessenger::~G4UnitsMessenger()
{
  delete ListCmd;
  delete UnitsTableDir;
}

// --------------------------------------------------------------------
void G4UnitsMessenger::SetNewValue(G4UIcommand* command, G4String)
{
  if (command == ListCmd) {
    G4UnitDefinition::PrintUnitsTable();
  }
}
