// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_ACCESSIBLETEXT_H
#define _GTKMM_ACCESSIBLETEXT_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2024 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/interface.h>
#include <glibmm/bytes.h>
#include <vector>
#include <gtk/gtk.h> // for GtkAccessibleTextRange


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkAccessibleTextInterface GtkAccessibleTextInterface;
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkAccessibleText = struct _GtkAccessibleText;
using GtkAccessibleTextClass = struct _GtkAccessibleTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API AccessibleText_Class; } // namespace Gtk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class GTKMM_API Widget;

/** An interface for accessible objects containing formatted text.
 *
 * The %Gtk::AccessibleText interface is meant to be implemented by accessible
 * objects that have text formatted with attributes, or non-trivial text contents.
 *
 * You should use the Gtk::Accessible::Property::LABEL or the
 * Gtk::Accessible::Property::DESCRIPTION properties for accessible
 * objects containing simple, unformatted text.
 *
 * @newin{4,14}
 */

class GTKMM_API AccessibleText : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = AccessibleText;
  using CppClassType = AccessibleText_Class;
  using BaseObjectType = GtkAccessibleText;
  using BaseClassType = GtkAccessibleTextInterface;

  // noncopyable
  AccessibleText(const AccessibleText&) = delete;
  AccessibleText& operator=(const AccessibleText&) = delete;

private:
  friend class AccessibleText_Class;
  static CppClassType accessibletext_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  AccessibleText();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit AccessibleText(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit AccessibleText(GtkAccessibleText* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  AccessibleText(AccessibleText&& src) noexcept;
  AccessibleText& operator=(AccessibleText&& src) noexcept;

  ~AccessibleText() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkAccessibleText*       gobj()       { return reinterpret_cast<GtkAccessibleText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkAccessibleText* gobj() const { return reinterpret_cast<GtkAccessibleText*>(gobject_); }

private:


public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var Granularity::CHARACTER
   * Use the boundary between
   * characters (including non-printing characters).
   * 
   *  @var Granularity::WORD
   * Use the boundary between words,
   * starting from the beginning of the current word and ending at the
   * beginning of the next word.
   * 
   *  @var Granularity::SENTENCE
   * Use the boundary between
   * sentences, starting from the beginning of the current sentence and
   * ending at the beginning of the next sentence.
   * 
   *  @var Granularity::LINE
   * Use the boundary between lines,
   * starting from the beginning of the current line and ending at the
   * beginning of the next line.
   * 
   *  @var Granularity::PARAGRAPH
   * Use the boundary between
   * paragraphs, starting from the beginning of the current paragraph and
   * ending at the beginning of the next paragraph.
   */
   /** The granularity for queries about the text contents of a Gtk::AccessibleText
   * implementation.
   * 
   * @newin{4,14}
   *
   * @ingroup gtkmmEnums
   */
  enum class Granularity
  {
    CHARACTER,
    WORD,
    SENTENCE,
    LINE,
    PARAGRAPH
  };


  /** 
   *  @var ContentChange::INSERT
   * Contents change as the result of
   * an insert operation.
   * 
   *  @var ContentChange::REMOVE
   * Contents change as the result of
   * a remove operation.
   */
   /** The type of contents change operation.
   * 
   * @newin{4,14}
   *
   * @ingroup gtkmmEnums
   */
  enum class ContentChange
  {
    INSERT,
    REMOVE
  };


  /** Updates the position of the caret.
   * 
   * Implementations of the `Gtk::AccessibleText` interface should call this
   * function every time the caret has moved, in order to notify assistive
   * technologies.
   * 
   * @newin{4,14}
   */
  void update_caret_position();
  
  /** Updates the boundary of the selection.
   * 
   * Implementations of the `Gtk::AccessibleText` interface should call this
   * function every time the selection has moved, in order to notify assistive
   * technologies.
   * 
   * @newin{4,14}
   */
  void update_selection_bound();
  
  /** Notifies assistive technologies of a change in contents.
   * 
   * Implementations of the `Gtk::AccessibleText` interface should call this
   * function every time their contents change as the result of an operation,
   * like an insertion or a removal.
   * 
   * @note If the change is a deletion, this function must be called *before*
   * removing the contents, if it is an insertion, it must be called *after*
   * inserting the new contents.
   * 
   * @newin{4,14}
   * 
   * @param change The type of change in the contents.
   * @param start The starting offset of the change, in characters.
   * @param end The end offset of the change, in characters.
   */
  void update_contents(ContentChange change, unsigned int start, unsigned int end);

protected:
 

  /** Retrieve the current contents of the accessible object within
   * the given range.
   *
   * If @a end is G_MAXUINT, the end of the range is the full content
   * of the accessible object.
   *
   * @param start The beginning of the range, in characters.
   * @param end The end of the range, in characters.
   * @returns The requested slice of the contents of the
   *   accessible object, as UTF-8. Note that the slice does not have to
   *   be NUL-terminated.
   *
   * @newin{4,14}
   */
    virtual Glib::RefPtr<Glib::Bytes> get_contents_vfunc(unsigned int start, unsigned int end) const;


  /** Retrieve the current contents of the accessible object starting
   * from the given offset, and using the given granularity.
   *
   * The @a start and @a end values contain the boundaries of the text.
   *
   * @param offset The offset, in characters.
   * @param granularity The granularity of the query.
   * @param[out] start The start of the range, in characters.
   * @param[out] end The end of the range, in characters.
   * @returns The requested slice of the contents of the
   *   accessible object, as UTF-8. Note that the slice does not have to
   *   be NUL-terminated.
   *
   * @newin{4,14}
   */
    virtual Glib::RefPtr<Glib::Bytes> get_contents_at_vfunc(unsigned int offset, Granularity granularity, unsigned int* start, unsigned int* end) const;


  /** Retrieves the position of the caret inside the accessible object.
   *
   * @returns The position of the caret, in characters.
   *
   * @newin{4,14}
   */
    virtual unsigned int get_caret_position_vfunc() const;


  /** Retrieves the selection ranges in the accessible object.
   *
   * If this function returns <tt>true</tt>, @a n_ranges will be set to a value
   * greater than or equal to one, and @a ranges will be set to a newly
   * allocated array of struct GtkAccessibleTextRange.
   *
   * @param[out] n_ranges The number of selection ranges.
   * @param[out] ranges (optional) (array length=n_ranges) (transfer container) The selection ranges.
   * @returns <tt>true</tt> if there is at least one selection inside the
   *   accessible object, and <tt>false</tt> otherwise.
   *
   * @newin{4,14}
   */
    virtual bool get_selection_vfunc(gsize* n_ranges, GtkAccessibleTextRange** ranges) const;


  /** Retrieves the text attributes inside the accessible object.
   *
   * Each attribute is composed by:
   *
   * - a range
   * - a name
   * - a value
   *
   * It is left to the implementation to determine the serialization format
   * of the value to a string.
   *
   * GTK provides support for various text attribute names and values, but
   * implementations of this interface are free to add their own attributes.
   *
   * If this function returns <tt>true</tt>, @a n_ranges will be set to a value
   * greater than or equal to one, @a ranges will be set to a newly
   * allocated array of struct GtkAccessibleTextRange.
   *
   * @param offset The offset, in characters.
   * @param[out] n_ranges The number of attributes.
   * @param[out] ranges (array length=n_ranges) (optional) (transfer container)
   *             The ranges of the attributes inside the accessible object.
   * @param[out] attribute_names (array zero-terminated=1) (optional) (transfer full)
   *             The names of the attributes inside the accessible object.
   * @param[out] attribute_values (array zero-terminated=1) (optional) (transfer full)
   *             The values of the attributes inside the accessible object.
   * @returns <tt>true</tt> if the accessible object has at least one attribute,
   *   and <tt>false</tt> otherwise.
   *
   * @newin{4,14}
   */
    virtual bool get_attributes_vfunc(unsigned int offset, gsize* n_ranges, GtkAccessibleTextRange** ranges, char*** attribute_names, char*** attribute_values) const;


  /** Retrieves the default text attributes inside the accessible object.
   *
   * Each attribute is composed by:
   *
   * - a name
   * - a value
   *
   * It is left to the implementation to determine the serialization format
   * of the value to a string.
   *
   * GTK provides support for various text attribute names and values, but
   * implementations of this interface are free to add their own attributes.
   *
   * @param[out] attribute_names (array zero-terminated=1) (optional) (transfer full)
   *             The names of the default attributes inside the accessible object.
   * @param[out] attribute_values (array zero-terminated=1) (optional) (transfer full)
   *             The values of the default attributes inside the accessible object.
   *
   * @newin{4,14}
   */
    virtual void get_default_attributes_vfunc(char*** attribute_names, char*** attribute_values) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::AccessibleText::Granularity> : public Glib::Value_Enum<Gtk::AccessibleText::Granularity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::AccessibleText::ContentChange> : public Glib::Value_Enum<Gtk::AccessibleText::ContentChange>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AccessibleText
   */
  GTKMM_API
  Glib::RefPtr<Gtk::AccessibleText> wrap(GtkAccessibleText* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_ACCESSIBLETEXT_H */

