package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigurationPrice invokes the sae.DescribeConfigurationPrice API synchronously
func (client *Client) DescribeConfigurationPrice(request *DescribeConfigurationPriceRequest) (response *DescribeConfigurationPriceResponse, err error) {
	response = CreateDescribeConfigurationPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigurationPriceWithChan invokes the sae.DescribeConfigurationPrice API asynchronously
func (client *Client) DescribeConfigurationPriceWithChan(request *DescribeConfigurationPriceRequest) (<-chan *DescribeConfigurationPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigurationPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigurationPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigurationPriceWithCallback invokes the sae.DescribeConfigurationPrice API asynchronously
func (client *Client) DescribeConfigurationPriceWithCallback(request *DescribeConfigurationPriceRequest, callback func(response *DescribeConfigurationPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigurationPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigurationPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigurationPriceRequest is the request struct for api DescribeConfigurationPrice
type DescribeConfigurationPriceRequest struct {
	*requests.RoaRequest
	Memory requests.Integer `position:"Query" name:"Memory"`
	Cpu    requests.Integer `position:"Query" name:"Cpu"`
}

// DescribeConfigurationPriceResponse is the response struct for api DescribeConfigurationPrice
type DescribeConfigurationPriceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeConfigurationPriceRequest creates a request to invoke DescribeConfigurationPrice API
func CreateDescribeConfigurationPriceRequest() (request *DescribeConfigurationPriceRequest) {
	request = &DescribeConfigurationPriceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeConfigurationPrice", "/pop/v1/paas/configurationPrice", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeConfigurationPriceResponse creates a response to parse from DescribeConfigurationPrice response
func CreateDescribeConfigurationPriceResponse() (response *DescribeConfigurationPriceResponse) {
	response = &DescribeConfigurationPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
