package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateABTestExperiment invokes the opensearch.UpdateABTestExperiment API synchronously
func (client *Client) UpdateABTestExperiment(request *UpdateABTestExperimentRequest) (response *UpdateABTestExperimentResponse, err error) {
	response = CreateUpdateABTestExperimentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateABTestExperimentWithChan invokes the opensearch.UpdateABTestExperiment API asynchronously
func (client *Client) UpdateABTestExperimentWithChan(request *UpdateABTestExperimentRequest) (<-chan *UpdateABTestExperimentResponse, <-chan error) {
	responseChan := make(chan *UpdateABTestExperimentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateABTestExperiment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateABTestExperimentWithCallback invokes the opensearch.UpdateABTestExperiment API asynchronously
func (client *Client) UpdateABTestExperimentWithCallback(request *UpdateABTestExperimentRequest, callback func(response *UpdateABTestExperimentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateABTestExperimentResponse
		var err error
		defer close(result)
		response, err = client.UpdateABTestExperiment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateABTestExperimentRequest is the request struct for api UpdateABTestExperiment
type UpdateABTestExperimentRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	ExperimentId     requests.Integer `position:"Path" name:"experimentId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// UpdateABTestExperimentResponse is the response struct for api UpdateABTestExperiment
type UpdateABTestExperimentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateUpdateABTestExperimentRequest creates a request to invoke UpdateABTestExperiment API
func CreateUpdateABTestExperimentRequest() (request *UpdateABTestExperimentRequest) {
	request = &UpdateABTestExperimentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateABTestExperiment", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]/experiments/[experimentId]", "opensearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateABTestExperimentResponse creates a response to parse from UpdateABTestExperiment response
func CreateUpdateABTestExperimentResponse() (response *UpdateABTestExperimentResponse) {
	response = &UpdateABTestExperimentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
