package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGroupTag invokes the oam.DeleteGroupTag API synchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptag.html
func (client *Client) DeleteGroupTag(request *DeleteGroupTagRequest) (response *DeleteGroupTagResponse, err error) {
	response = CreateDeleteGroupTagResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGroupTagWithChan invokes the oam.DeleteGroupTag API asynchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupTagWithChan(request *DeleteGroupTagRequest) (<-chan *DeleteGroupTagResponse, <-chan error) {
	responseChan := make(chan *DeleteGroupTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGroupTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGroupTagWithCallback invokes the oam.DeleteGroupTag API asynchronously
// api document: https://help.aliyun.com/api/oam/deletegrouptag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGroupTagWithCallback(request *DeleteGroupTagRequest, callback func(response *DeleteGroupTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGroupTagResponse
		var err error
		defer close(result)
		response, err = client.DeleteGroupTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGroupTagRequest is the request struct for api DeleteGroupTag
type DeleteGroupTagRequest struct {
	*requests.RpcRequest
	GroupTagId *[]string `position:"Query" name:"GroupTagId"  type:"Repeated"`
}

// DeleteGroupTagResponse is the response struct for api DeleteGroupTag
type DeleteGroupTagResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGroupTagRequest creates a request to invoke DeleteGroupTag API
func CreateDeleteGroupTagRequest() (request *DeleteGroupTagRequest) {
	request = &DeleteGroupTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "DeleteGroupTag", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteGroupTagResponse creates a response to parse from DeleteGroupTag response
func CreateDeleteGroupTagResponse() (response *DeleteGroupTagResponse) {
	response = &DeleteGroupTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
