package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySuperDeviceGroup invokes the iot.QuerySuperDeviceGroup API synchronously
func (client *Client) QuerySuperDeviceGroup(request *QuerySuperDeviceGroupRequest) (response *QuerySuperDeviceGroupResponse, err error) {
	response = CreateQuerySuperDeviceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySuperDeviceGroupWithChan invokes the iot.QuerySuperDeviceGroup API asynchronously
func (client *Client) QuerySuperDeviceGroupWithChan(request *QuerySuperDeviceGroupRequest) (<-chan *QuerySuperDeviceGroupResponse, <-chan error) {
	responseChan := make(chan *QuerySuperDeviceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySuperDeviceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySuperDeviceGroupWithCallback invokes the iot.QuerySuperDeviceGroup API asynchronously
func (client *Client) QuerySuperDeviceGroupWithCallback(request *QuerySuperDeviceGroupRequest, callback func(response *QuerySuperDeviceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySuperDeviceGroupResponse
		var err error
		defer close(result)
		response, err = client.QuerySuperDeviceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySuperDeviceGroupRequest is the request struct for api QuerySuperDeviceGroup
type QuerySuperDeviceGroupRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	GroupId       string `position:"Query" name:"GroupId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QuerySuperDeviceGroupResponse is the response struct for api QuerySuperDeviceGroup
type QuerySuperDeviceGroupResponse struct {
	*responses.BaseResponse
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	Code         string                      `json:"Code" xml:"Code"`
	ErrorMessage string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySuperDeviceGroup `json:"Data" xml:"Data"`
}

// CreateQuerySuperDeviceGroupRequest creates a request to invoke QuerySuperDeviceGroup API
func CreateQuerySuperDeviceGroupRequest() (request *QuerySuperDeviceGroupRequest) {
	request = &QuerySuperDeviceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySuperDeviceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySuperDeviceGroupResponse creates a response to parse from QuerySuperDeviceGroup response
func CreateQuerySuperDeviceGroupResponse() (response *QuerySuperDeviceGroupResponse) {
	response = &QuerySuperDeviceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
