package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportCredentials invokes the csb.ImportCredentials API synchronously
// api document: https://help.aliyun.com/api/csb/importcredentials.html
func (client *Client) ImportCredentials(request *ImportCredentialsRequest) (response *ImportCredentialsResponse, err error) {
	response = CreateImportCredentialsResponse()
	err = client.DoAction(request, response)
	return
}

// ImportCredentialsWithChan invokes the csb.ImportCredentials API asynchronously
// api document: https://help.aliyun.com/api/csb/importcredentials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImportCredentialsWithChan(request *ImportCredentialsRequest) (<-chan *ImportCredentialsResponse, <-chan error) {
	responseChan := make(chan *ImportCredentialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportCredentials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportCredentialsWithCallback invokes the csb.ImportCredentials API asynchronously
// api document: https://help.aliyun.com/api/csb/importcredentials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ImportCredentialsWithCallback(request *ImportCredentialsRequest, callback func(response *ImportCredentialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportCredentialsResponse
		var err error
		defer close(result)
		response, err = client.ImportCredentials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportCredentialsRequest is the request struct for api ImportCredentials
type ImportCredentialsRequest struct {
	*requests.RpcRequest
	Data  string           `position:"Body" name:"Data"`
	CsbId requests.Integer `position:"Query" name:"CsbId"`
}

// ImportCredentialsResponse is the response struct for api ImportCredentials
type ImportCredentialsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateImportCredentialsRequest creates a request to invoke ImportCredentials API
func CreateImportCredentialsRequest() (request *ImportCredentialsRequest) {
	request = &ImportCredentialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "ImportCredentials", "", "")
	request.Method = requests.POST
	return
}

// CreateImportCredentialsResponse creates a response to parse from ImportCredentials response
func CreateImportCredentialsResponse() (response *ImportCredentialsResponse) {
	response = &ImportCredentialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
