package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FetchPhotos invokes the cloudphoto.FetchPhotos API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchphotos.html
func (client *Client) FetchPhotos(request *FetchPhotosRequest) (response *FetchPhotosResponse, err error) {
	response = CreateFetchPhotosResponse()
	err = client.DoAction(request, response)
	return
}

// FetchPhotosWithChan invokes the cloudphoto.FetchPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FetchPhotosWithChan(request *FetchPhotosRequest) (<-chan *FetchPhotosResponse, <-chan error) {
	responseChan := make(chan *FetchPhotosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FetchPhotos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FetchPhotosWithCallback invokes the cloudphoto.FetchPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/fetchphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FetchPhotosWithCallback(request *FetchPhotosRequest, callback func(response *FetchPhotosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FetchPhotosResponse
		var err error
		defer close(result)
		response, err = client.FetchPhotos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FetchPhotosRequest is the request struct for api FetchPhotos
type FetchPhotosRequest struct {
	*requests.RpcRequest
	Size      requests.Integer `position:"Query" name:"Size"`
	LibraryId string           `position:"Query" name:"LibraryId"`
	OrderBy   string           `position:"Query" name:"OrderBy"`
	StoreName string           `position:"Query" name:"StoreName"`
	State     string           `position:"Query" name:"State"`
	Page      requests.Integer `position:"Query" name:"Page"`
	Order     string           `position:"Query" name:"Order"`
}

// FetchPhotosResponse is the response struct for api FetchPhotos
type FetchPhotosResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Action     string  `json:"Action" xml:"Action"`
	Photos     []Photo `json:"Photos" xml:"Photos"`
}

// CreateFetchPhotosRequest creates a request to invoke FetchPhotos API
func CreateFetchPhotosRequest() (request *FetchPhotosRequest) {
	request = &FetchPhotosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "FetchPhotos", "cloudphoto", "openAPI")
	return
}

// CreateFetchPhotosResponse creates a response to parse from FetchPhotos response
func CreateFetchPhotosResponse() (response *FetchPhotosResponse) {
	response = &FetchPhotosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
