package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJoinRuleList invokes the aegis.DescribeJoinRuleList API synchronously
// api document: https://help.aliyun.com/api/aegis/describejoinrulelist.html
func (client *Client) DescribeJoinRuleList(request *DescribeJoinRuleListRequest) (response *DescribeJoinRuleListResponse, err error) {
	response = CreateDescribeJoinRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJoinRuleListWithChan invokes the aegis.DescribeJoinRuleList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describejoinrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeJoinRuleListWithChan(request *DescribeJoinRuleListRequest) (<-chan *DescribeJoinRuleListResponse, <-chan error) {
	responseChan := make(chan *DescribeJoinRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJoinRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJoinRuleListWithCallback invokes the aegis.DescribeJoinRuleList API asynchronously
// api document: https://help.aliyun.com/api/aegis/describejoinrulelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeJoinRuleListWithCallback(request *DescribeJoinRuleListRequest, callback func(response *DescribeJoinRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJoinRuleListResponse
		var err error
		defer close(result)
		response, err = client.DescribeJoinRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJoinRuleListRequest is the request struct for api DescribeJoinRuleList
type DescribeJoinRuleListRequest struct {
	*requests.RpcRequest
	WarnLevel   string           `position:"Query" name:"WarnLevel"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Remark      requests.Integer `position:"Query" name:"remark"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// DescribeJoinRuleListResponse is the response struct for api DescribeJoinRuleList
type DescribeJoinRuleListResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	PageInfo     PageInfo           `json:"PageInfo" xml:"PageInfo"`
	JoinRuleList []JoinRuleListItem `json:"JoinRuleList" xml:"JoinRuleList"`
}

// CreateDescribeJoinRuleListRequest creates a request to invoke DescribeJoinRuleList API
func CreateDescribeJoinRuleListRequest() (request *DescribeJoinRuleListRequest) {
	request = &DescribeJoinRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeJoinRuleList", "vipaegis", "openAPI")
	return
}

// CreateDescribeJoinRuleListResponse creates a response to parse from DescribeJoinRuleList response
func CreateDescribeJoinRuleListResponse() (response *DescribeJoinRuleListResponse) {
	response = &DescribeJoinRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
