package apimanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessIDName enumerates the values for access id name.
type AccessIDName string

const (
	// AccessIDNameAccess ...
	AccessIDNameAccess AccessIDName = "access"
	// AccessIDNameGitAccess ...
	AccessIDNameGitAccess AccessIDName = "gitAccess"
)

// PossibleAccessIDNameValues returns an array of possible values for the AccessIDName const type.
func PossibleAccessIDNameValues() []AccessIDName {
	return []AccessIDName{AccessIDNameAccess, AccessIDNameGitAccess}
}

// AlwaysLog enumerates the values for always log.
type AlwaysLog string

const (
	// AlwaysLogAllErrors Always log all erroneous request regardless of sampling settings.
	AlwaysLogAllErrors AlwaysLog = "allErrors"
)

// PossibleAlwaysLogValues returns an array of possible values for the AlwaysLog const type.
func PossibleAlwaysLogValues() []AlwaysLog {
	return []AlwaysLog{AlwaysLogAllErrors}
}

// ApimIdentityType enumerates the values for apim identity type.
type ApimIdentityType string

const (
	// ApimIdentityTypeNone ...
	ApimIdentityTypeNone ApimIdentityType = "None"
	// ApimIdentityTypeSystemAssigned ...
	ApimIdentityTypeSystemAssigned ApimIdentityType = "SystemAssigned"
	// ApimIdentityTypeSystemAssignedUserAssigned ...
	ApimIdentityTypeSystemAssignedUserAssigned ApimIdentityType = "SystemAssigned, UserAssigned"
	// ApimIdentityTypeUserAssigned ...
	ApimIdentityTypeUserAssigned ApimIdentityType = "UserAssigned"
)

// PossibleApimIdentityTypeValues returns an array of possible values for the ApimIdentityType const type.
func PossibleApimIdentityTypeValues() []ApimIdentityType {
	return []ApimIdentityType{ApimIdentityTypeNone, ApimIdentityTypeSystemAssigned, ApimIdentityTypeSystemAssignedUserAssigned, ApimIdentityTypeUserAssigned}
}

// APIType enumerates the values for api type.
type APIType string

const (
	// APITypeHTTP ...
	APITypeHTTP APIType = "http"
	// APITypeSoap ...
	APITypeSoap APIType = "soap"
	// APITypeWebsocket ...
	APITypeWebsocket APIType = "websocket"
)

// PossibleAPITypeValues returns an array of possible values for the APIType const type.
func PossibleAPITypeValues() []APIType {
	return []APIType{APITypeHTTP, APITypeSoap, APITypeWebsocket}
}

// AppType enumerates the values for app type.
type AppType string

const (
	// AppTypeDeveloperPortal User create request was sent by new developer portal.
	AppTypeDeveloperPortal AppType = "developerPortal"
	// AppTypePortal User create request was sent by legacy developer portal.
	AppTypePortal AppType = "portal"
)

// PossibleAppTypeValues returns an array of possible values for the AppType const type.
func PossibleAppTypeValues() []AppType {
	return []AppType{AppTypeDeveloperPortal, AppTypePortal}
}

// AsyncOperationStatus enumerates the values for async operation status.
type AsyncOperationStatus string

const (
	// AsyncOperationStatusFailed ...
	AsyncOperationStatusFailed AsyncOperationStatus = "Failed"
	// AsyncOperationStatusInProgress ...
	AsyncOperationStatusInProgress AsyncOperationStatus = "InProgress"
	// AsyncOperationStatusStarted ...
	AsyncOperationStatusStarted AsyncOperationStatus = "Started"
	// AsyncOperationStatusSucceeded ...
	AsyncOperationStatusSucceeded AsyncOperationStatus = "Succeeded"
)

// PossibleAsyncOperationStatusValues returns an array of possible values for the AsyncOperationStatus const type.
func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return []AsyncOperationStatus{AsyncOperationStatusFailed, AsyncOperationStatusInProgress, AsyncOperationStatusStarted, AsyncOperationStatusSucceeded}
}

// AuthorizationMethod enumerates the values for authorization method.
type AuthorizationMethod string

const (
	// AuthorizationMethodDELETE ...
	AuthorizationMethodDELETE AuthorizationMethod = "DELETE"
	// AuthorizationMethodGET ...
	AuthorizationMethodGET AuthorizationMethod = "GET"
	// AuthorizationMethodHEAD ...
	AuthorizationMethodHEAD AuthorizationMethod = "HEAD"
	// AuthorizationMethodOPTIONS ...
	AuthorizationMethodOPTIONS AuthorizationMethod = "OPTIONS"
	// AuthorizationMethodPATCH ...
	AuthorizationMethodPATCH AuthorizationMethod = "PATCH"
	// AuthorizationMethodPOST ...
	AuthorizationMethodPOST AuthorizationMethod = "POST"
	// AuthorizationMethodPUT ...
	AuthorizationMethodPUT AuthorizationMethod = "PUT"
	// AuthorizationMethodTRACE ...
	AuthorizationMethodTRACE AuthorizationMethod = "TRACE"
)

// PossibleAuthorizationMethodValues returns an array of possible values for the AuthorizationMethod const type.
func PossibleAuthorizationMethodValues() []AuthorizationMethod {
	return []AuthorizationMethod{AuthorizationMethodDELETE, AuthorizationMethodGET, AuthorizationMethodHEAD, AuthorizationMethodOPTIONS, AuthorizationMethodPATCH, AuthorizationMethodPOST, AuthorizationMethodPUT, AuthorizationMethodTRACE}
}

// BackendProtocol enumerates the values for backend protocol.
type BackendProtocol string

const (
	// BackendProtocolHTTP The Backend is a RESTful service.
	BackendProtocolHTTP BackendProtocol = "http"
	// BackendProtocolSoap The Backend is a SOAP service.
	BackendProtocolSoap BackendProtocol = "soap"
)

// PossibleBackendProtocolValues returns an array of possible values for the BackendProtocol const type.
func PossibleBackendProtocolValues() []BackendProtocol {
	return []BackendProtocol{BackendProtocolHTTP, BackendProtocolSoap}
}

// BearerTokenSendingMethod enumerates the values for bearer token sending method.
type BearerTokenSendingMethod string

const (
	// BearerTokenSendingMethodAuthorizationHeader ...
	BearerTokenSendingMethodAuthorizationHeader BearerTokenSendingMethod = "authorizationHeader"
	// BearerTokenSendingMethodQuery ...
	BearerTokenSendingMethodQuery BearerTokenSendingMethod = "query"
)

// PossibleBearerTokenSendingMethodValues returns an array of possible values for the BearerTokenSendingMethod const type.
func PossibleBearerTokenSendingMethodValues() []BearerTokenSendingMethod {
	return []BearerTokenSendingMethod{BearerTokenSendingMethodAuthorizationHeader, BearerTokenSendingMethodQuery}
}

// BearerTokenSendingMethods enumerates the values for bearer token sending methods.
type BearerTokenSendingMethods string

const (
	// BearerTokenSendingMethodsAuthorizationHeader Access token will be transmitted in the Authorization
	// header using Bearer schema
	BearerTokenSendingMethodsAuthorizationHeader BearerTokenSendingMethods = "authorizationHeader"
	// BearerTokenSendingMethodsQuery Access token will be transmitted as query parameters.
	BearerTokenSendingMethodsQuery BearerTokenSendingMethods = "query"
)

// PossibleBearerTokenSendingMethodsValues returns an array of possible values for the BearerTokenSendingMethods const type.
func PossibleBearerTokenSendingMethodsValues() []BearerTokenSendingMethods {
	return []BearerTokenSendingMethods{BearerTokenSendingMethodsAuthorizationHeader, BearerTokenSendingMethodsQuery}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceBuiltIn ...
	CertificateSourceBuiltIn CertificateSource = "BuiltIn"
	// CertificateSourceCustom ...
	CertificateSourceCustom CertificateSource = "Custom"
	// CertificateSourceKeyVault ...
	CertificateSourceKeyVault CertificateSource = "KeyVault"
	// CertificateSourceManaged ...
	CertificateSourceManaged CertificateSource = "Managed"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceBuiltIn, CertificateSourceCustom, CertificateSourceKeyVault, CertificateSourceManaged}
}

// CertificateStatus enumerates the values for certificate status.
type CertificateStatus string

const (
	// CertificateStatusCompleted ...
	CertificateStatusCompleted CertificateStatus = "Completed"
	// CertificateStatusFailed ...
	CertificateStatusFailed CertificateStatus = "Failed"
	// CertificateStatusInProgress ...
	CertificateStatusInProgress CertificateStatus = "InProgress"
)

// PossibleCertificateStatusValues returns an array of possible values for the CertificateStatus const type.
func PossibleCertificateStatusValues() []CertificateStatus {
	return []CertificateStatus{CertificateStatusCompleted, CertificateStatusFailed, CertificateStatusInProgress}
}

// ClientAuthenticationMethod enumerates the values for client authentication method.
type ClientAuthenticationMethod string

const (
	// ClientAuthenticationMethodBasic Basic Client Authentication method.
	ClientAuthenticationMethodBasic ClientAuthenticationMethod = "Basic"
	// ClientAuthenticationMethodBody Body based Authentication method.
	ClientAuthenticationMethodBody ClientAuthenticationMethod = "Body"
)

// PossibleClientAuthenticationMethodValues returns an array of possible values for the ClientAuthenticationMethod const type.
func PossibleClientAuthenticationMethodValues() []ClientAuthenticationMethod {
	return []ClientAuthenticationMethod{ClientAuthenticationMethodBasic, ClientAuthenticationMethodBody}
}

// Confirmation enumerates the values for confirmation.
type Confirmation string

const (
	// ConfirmationInvite Send an e-mail inviting the user to sign-up and complete registration.
	ConfirmationInvite Confirmation = "invite"
	// ConfirmationSignup Send an e-mail to the user confirming they have successfully signed up.
	ConfirmationSignup Confirmation = "signup"
)

// PossibleConfirmationValues returns an array of possible values for the Confirmation const type.
func PossibleConfirmationValues() []Confirmation {
	return []Confirmation{ConfirmationInvite, ConfirmationSignup}
}

// ConnectivityStatusType enumerates the values for connectivity status type.
type ConnectivityStatusType string

const (
	// ConnectivityStatusTypeFailure ...
	ConnectivityStatusTypeFailure ConnectivityStatusType = "failure"
	// ConnectivityStatusTypeInitializing ...
	ConnectivityStatusTypeInitializing ConnectivityStatusType = "initializing"
	// ConnectivityStatusTypeSuccess ...
	ConnectivityStatusTypeSuccess ConnectivityStatusType = "success"
)

// PossibleConnectivityStatusTypeValues returns an array of possible values for the ConnectivityStatusType const type.
func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return []ConnectivityStatusType{ConnectivityStatusTypeFailure, ConnectivityStatusTypeInitializing, ConnectivityStatusTypeSuccess}
}

// ContentFormat enumerates the values for content format.
type ContentFormat string

const (
	// ContentFormatOpenapi The contents are inline and Content Type is a OpenAPI 3.0 YAML Document.
	ContentFormatOpenapi ContentFormat = "openapi"
	// ContentFormatOpenapijson The contents are inline and Content Type is a OpenAPI 3.0 JSON Document.
	ContentFormatOpenapijson ContentFormat = "openapi+json"
	// ContentFormatOpenapijsonLink The OpenAPI 3.0 JSON document is hosted on a publicly accessible internet
	// address.
	ContentFormatOpenapijsonLink ContentFormat = "openapi+json-link"
	// ContentFormatOpenapiLink The OpenAPI 3.0 YAML document is hosted on a publicly accessible internet
	// address.
	ContentFormatOpenapiLink ContentFormat = "openapi-link"
	// ContentFormatSwaggerJSON The contents are inline and Content Type is a OpenAPI 2.0 JSON Document.
	ContentFormatSwaggerJSON ContentFormat = "swagger-json"
	// ContentFormatSwaggerLinkJSON The OpenAPI 2.0 JSON document is hosted on a publicly accessible internet
	// address.
	ContentFormatSwaggerLinkJSON ContentFormat = "swagger-link-json"
	// ContentFormatWadlLinkJSON The WADL document is hosted on a publicly accessible internet address.
	ContentFormatWadlLinkJSON ContentFormat = "wadl-link-json"
	// ContentFormatWadlXML The contents are inline and Content type is a WADL document.
	ContentFormatWadlXML ContentFormat = "wadl-xml"
	// ContentFormatWsdl The contents are inline and the document is a WSDL/Soap document.
	ContentFormatWsdl ContentFormat = "wsdl"
	// ContentFormatWsdlLink The WSDL document is hosted on a publicly accessible internet address.
	ContentFormatWsdlLink ContentFormat = "wsdl-link"
)

// PossibleContentFormatValues returns an array of possible values for the ContentFormat const type.
func PossibleContentFormatValues() []ContentFormat {
	return []ContentFormat{ContentFormatOpenapi, ContentFormatOpenapijson, ContentFormatOpenapijsonLink, ContentFormatOpenapiLink, ContentFormatSwaggerJSON, ContentFormatSwaggerLinkJSON, ContentFormatWadlLinkJSON, ContentFormatWadlXML, ContentFormatWsdl, ContentFormatWsdlLink}
}

// DataMaskingMode enumerates the values for data masking mode.
type DataMaskingMode string

const (
	// DataMaskingModeHide Hide the presence of an entity.
	DataMaskingModeHide DataMaskingMode = "Hide"
	// DataMaskingModeMask Mask the value of an entity.
	DataMaskingModeMask DataMaskingMode = "Mask"
)

// PossibleDataMaskingModeValues returns an array of possible values for the DataMaskingMode const type.
func PossibleDataMaskingModeValues() []DataMaskingMode {
	return []DataMaskingMode{DataMaskingModeHide, DataMaskingModeMask}
}

// ExportFormat enumerates the values for export format.
type ExportFormat string

const (
	// ExportFormatOpenapi Export the Api Definition in OpenAPI 3.0 Specification as YAML document to Storage
	// Blob.
	ExportFormatOpenapi ExportFormat = "openapi-link"
	// ExportFormatOpenapiJSON Export the Api Definition in OpenAPI 3.0 Specification as JSON document to
	// Storage Blob.
	ExportFormatOpenapiJSON ExportFormat = "openapi+json-link"
	// ExportFormatSwagger Export the Api Definition in OpenAPI 2.0 Specification as JSON document to the
	// Storage Blob.
	ExportFormatSwagger ExportFormat = "swagger-link"
	// ExportFormatWadl Export the Api Definition in WADL Schema to Storage Blob.
	ExportFormatWadl ExportFormat = "wadl-link"
	// ExportFormatWsdl Export the Api Definition in WSDL Schema to Storage Blob. This is only supported for
	// APIs of Type `soap`
	ExportFormatWsdl ExportFormat = "wsdl-link"
)

// PossibleExportFormatValues returns an array of possible values for the ExportFormat const type.
func PossibleExportFormatValues() []ExportFormat {
	return []ExportFormat{ExportFormatOpenapi, ExportFormatOpenapiJSON, ExportFormatSwagger, ExportFormatWadl, ExportFormatWsdl}
}

// ExportResultFormat enumerates the values for export result format.
type ExportResultFormat string

const (
	// ExportResultFormatOpenAPI Export the API Definition in OpenAPI Specification 3.0 to Storage Blob.
	ExportResultFormatOpenAPI ExportResultFormat = "openapi-link"
	// ExportResultFormatSwagger The API Definition is exported in OpenAPI Specification 2.0 format to the
	// Storage Blob.
	ExportResultFormatSwagger ExportResultFormat = "swagger-link-json"
	// ExportResultFormatWadl Export the API Definition in WADL Schema to Storage Blob.
	ExportResultFormatWadl ExportResultFormat = "wadl-link-json"
	// ExportResultFormatWsdl The API Definition is exported in WSDL Schema to Storage Blob. This is only
	// supported for APIs of Type `soap`
	ExportResultFormatWsdl ExportResultFormat = "wsdl-link+xml"
)

// PossibleExportResultFormatValues returns an array of possible values for the ExportResultFormat const type.
func PossibleExportResultFormatValues() []ExportResultFormat {
	return []ExportResultFormat{ExportResultFormatOpenAPI, ExportResultFormatSwagger, ExportResultFormatWadl, ExportResultFormatWsdl}
}

// GrantType enumerates the values for grant type.
type GrantType string

const (
	// GrantTypeAuthorizationCode Authorization Code Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.1.
	GrantTypeAuthorizationCode GrantType = "authorizationCode"
	// GrantTypeClientCredentials Client Credentials Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.4.
	GrantTypeClientCredentials GrantType = "clientCredentials"
	// GrantTypeImplicit Implicit Code Grant flow as described https://tools.ietf.org/html/rfc6749#section-4.2.
	GrantTypeImplicit GrantType = "implicit"
	// GrantTypeResourceOwnerPassword Resource Owner Password Grant flow as described
	// https://tools.ietf.org/html/rfc6749#section-4.3.
	GrantTypeResourceOwnerPassword GrantType = "resourceOwnerPassword"
)

// PossibleGrantTypeValues returns an array of possible values for the GrantType const type.
func PossibleGrantTypeValues() []GrantType {
	return []GrantType{GrantTypeAuthorizationCode, GrantTypeClientCredentials, GrantTypeImplicit, GrantTypeResourceOwnerPassword}
}

// GroupType enumerates the values for group type.
type GroupType string

const (
	// GroupTypeCustom ...
	GroupTypeCustom GroupType = "custom"
	// GroupTypeExternal ...
	GroupTypeExternal GroupType = "external"
	// GroupTypeSystem ...
	GroupTypeSystem GroupType = "system"
)

// PossibleGroupTypeValues returns an array of possible values for the GroupType const type.
func PossibleGroupTypeValues() []GroupType {
	return []GroupType{GroupTypeCustom, GroupTypeExternal, GroupTypeSystem}
}

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// HostnameTypeDeveloperPortal ...
	HostnameTypeDeveloperPortal HostnameType = "DeveloperPortal"
	// HostnameTypeManagement ...
	HostnameTypeManagement HostnameType = "Management"
	// HostnameTypePortal ...
	HostnameTypePortal HostnameType = "Portal"
	// HostnameTypeProxy ...
	HostnameTypeProxy HostnameType = "Proxy"
	// HostnameTypeScm ...
	HostnameTypeScm HostnameType = "Scm"
)

// PossibleHostnameTypeValues returns an array of possible values for the HostnameType const type.
func PossibleHostnameTypeValues() []HostnameType {
	return []HostnameType{HostnameTypeDeveloperPortal, HostnameTypeManagement, HostnameTypePortal, HostnameTypeProxy, HostnameTypeScm}
}

// HTTPCorrelationProtocol enumerates the values for http correlation protocol.
type HTTPCorrelationProtocol string

const (
	// HTTPCorrelationProtocolLegacy Inject Request-Id and Request-Context headers with request correlation
	// data. See
	// https://github.com/dotnet/corefx/blob/master/src/System.Diagnostics.DiagnosticSource/src/HttpCorrelationProtocol.md.
	HTTPCorrelationProtocolLegacy HTTPCorrelationProtocol = "Legacy"
	// HTTPCorrelationProtocolNone Do not read and inject correlation headers.
	HTTPCorrelationProtocolNone HTTPCorrelationProtocol = "None"
	// HTTPCorrelationProtocolW3C Inject Trace Context headers. See https://w3c.github.io/trace-context.
	HTTPCorrelationProtocolW3C HTTPCorrelationProtocol = "W3C"
)

// PossibleHTTPCorrelationProtocolValues returns an array of possible values for the HTTPCorrelationProtocol const type.
func PossibleHTTPCorrelationProtocolValues() []HTTPCorrelationProtocol {
	return []HTTPCorrelationProtocol{HTTPCorrelationProtocolLegacy, HTTPCorrelationProtocolNone, HTTPCorrelationProtocolW3C}
}

// IdentityProviderType enumerates the values for identity provider type.
type IdentityProviderType string

const (
	// IdentityProviderTypeAad Azure Active Directory as Identity provider.
	IdentityProviderTypeAad IdentityProviderType = "aad"
	// IdentityProviderTypeAadB2C Azure Active Directory B2C as Identity provider.
	IdentityProviderTypeAadB2C IdentityProviderType = "aadB2C"
	// IdentityProviderTypeFacebook Facebook as Identity provider.
	IdentityProviderTypeFacebook IdentityProviderType = "facebook"
	// IdentityProviderTypeGoogle Google as Identity provider.
	IdentityProviderTypeGoogle IdentityProviderType = "google"
	// IdentityProviderTypeMicrosoft Microsoft Live as Identity provider.
	IdentityProviderTypeMicrosoft IdentityProviderType = "microsoft"
	// IdentityProviderTypeTwitter Twitter as Identity provider.
	IdentityProviderTypeTwitter IdentityProviderType = "twitter"
)

// PossibleIdentityProviderTypeValues returns an array of possible values for the IdentityProviderType const type.
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return []IdentityProviderType{IdentityProviderTypeAad, IdentityProviderTypeAadB2C, IdentityProviderTypeFacebook, IdentityProviderTypeGoogle, IdentityProviderTypeMicrosoft, IdentityProviderTypeTwitter}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// KeyTypePrimary ...
	KeyTypePrimary KeyType = "primary"
	// KeyTypeSecondary ...
	KeyTypeSecondary KeyType = "secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{KeyTypePrimary, KeyTypeSecondary}
}

// LoggerType enumerates the values for logger type.
type LoggerType string

const (
	// LoggerTypeApplicationInsights Azure Application Insights as log destination.
	LoggerTypeApplicationInsights LoggerType = "applicationInsights"
	// LoggerTypeAzureEventHub Azure Event Hub as log destination.
	LoggerTypeAzureEventHub LoggerType = "azureEventHub"
	// LoggerTypeAzureMonitor Azure Monitor
	LoggerTypeAzureMonitor LoggerType = "azureMonitor"
)

// PossibleLoggerTypeValues returns an array of possible values for the LoggerType const type.
func PossibleLoggerTypeValues() []LoggerType {
	return []LoggerType{LoggerTypeApplicationInsights, LoggerTypeAzureEventHub, LoggerTypeAzureMonitor}
}

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// NameAvailabilityReasonAlreadyExists ...
	NameAvailabilityReasonAlreadyExists NameAvailabilityReason = "AlreadyExists"
	// NameAvailabilityReasonInvalid ...
	NameAvailabilityReasonInvalid NameAvailabilityReason = "Invalid"
	// NameAvailabilityReasonValid ...
	NameAvailabilityReasonValid NameAvailabilityReason = "Valid"
)

// PossibleNameAvailabilityReasonValues returns an array of possible values for the NameAvailabilityReason const type.
func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return []NameAvailabilityReason{NameAvailabilityReasonAlreadyExists, NameAvailabilityReasonInvalid, NameAvailabilityReasonValid}
}

// NotificationName enumerates the values for notification name.
type NotificationName string

const (
	// NotificationNameAccountClosedPublisher The following email recipients and users will receive email
	// notifications when developer closes his account.
	NotificationNameAccountClosedPublisher NotificationName = "AccountClosedPublisher"
	// NotificationNameBCC The following recipients will receive blind carbon copies of all emails sent to
	// developers.
	NotificationNameBCC NotificationName = "BCC"
	// NotificationNameNewApplicationNotificationMessage The following email recipients and users will receive
	// email notifications when new applications are submitted to the application gallery.
	NotificationNameNewApplicationNotificationMessage NotificationName = "NewApplicationNotificationMessage"
	// NotificationNameNewIssuePublisherNotificationMessage The following email recipients and users will
	// receive email notifications when a new issue or comment is submitted on the developer portal.
	NotificationNameNewIssuePublisherNotificationMessage NotificationName = "NewIssuePublisherNotificationMessage"
	// NotificationNamePurchasePublisherNotificationMessage The following email recipients and users will
	// receive email notifications about new API product subscriptions.
	NotificationNamePurchasePublisherNotificationMessage NotificationName = "PurchasePublisherNotificationMessage"
	// NotificationNameQuotaLimitApproachingPublisherNotificationMessage The following email recipients and
	// users will receive email notifications when subscription usage gets close to usage quota.
	NotificationNameQuotaLimitApproachingPublisherNotificationMessage NotificationName = "QuotaLimitApproachingPublisherNotificationMessage"
	// NotificationNameRequestPublisherNotificationMessage The following email recipients and users will
	// receive email notifications about subscription requests for API products requiring approval.
	NotificationNameRequestPublisherNotificationMessage NotificationName = "RequestPublisherNotificationMessage"
)

// PossibleNotificationNameValues returns an array of possible values for the NotificationName const type.
func PossibleNotificationNameValues() []NotificationName {
	return []NotificationName{NotificationNameAccountClosedPublisher, NotificationNameBCC, NotificationNameNewApplicationNotificationMessage, NotificationNameNewIssuePublisherNotificationMessage, NotificationNamePurchasePublisherNotificationMessage, NotificationNameQuotaLimitApproachingPublisherNotificationMessage, NotificationNameRequestPublisherNotificationMessage}
}

// OperationNameFormat enumerates the values for operation name format.
type OperationNameFormat string

const (
	// OperationNameFormatName API_NAME;rev=API_REVISION - OPERATION_NAME
	OperationNameFormatName OperationNameFormat = "Name"
	// OperationNameFormatURL HTTP_VERB URL
	OperationNameFormatURL OperationNameFormat = "Url"
)

// PossibleOperationNameFormatValues returns an array of possible values for the OperationNameFormat const type.
func PossibleOperationNameFormatValues() []OperationNameFormat {
	return []OperationNameFormat{OperationNameFormatName, OperationNameFormatURL}
}

// PolicyContentFormat enumerates the values for policy content format.
type PolicyContentFormat string

const (
	// PolicyContentFormatRawxml The contents are inline and Content type is a non XML encoded policy document.
	PolicyContentFormatRawxml PolicyContentFormat = "rawxml"
	// PolicyContentFormatRawxmlLink The policy document is not Xml encoded and is hosted on a http endpoint
	// accessible from the API Management service.
	PolicyContentFormatRawxmlLink PolicyContentFormat = "rawxml-link"
	// PolicyContentFormatXML The contents are inline and Content type is an XML document.
	PolicyContentFormatXML PolicyContentFormat = "xml"
	// PolicyContentFormatXMLLink The policy XML document is hosted on a http endpoint accessible from the API
	// Management service.
	PolicyContentFormatXMLLink PolicyContentFormat = "xml-link"
)

// PossiblePolicyContentFormatValues returns an array of possible values for the PolicyContentFormat const type.
func PossiblePolicyContentFormatValues() []PolicyContentFormat {
	return []PolicyContentFormat{PolicyContentFormatRawxml, PolicyContentFormatRawxmlLink, PolicyContentFormatXML, PolicyContentFormatXMLLink}
}

// PolicyExportFormat enumerates the values for policy export format.
type PolicyExportFormat string

const (
	// PolicyExportFormatRawxml The contents are inline and Content type is a non XML encoded policy document.
	PolicyExportFormatRawxml PolicyExportFormat = "rawxml"
	// PolicyExportFormatXML The contents are inline and Content type is an XML document.
	PolicyExportFormatXML PolicyExportFormat = "xml"
)

// PossiblePolicyExportFormatValues returns an array of possible values for the PolicyExportFormat const type.
func PossiblePolicyExportFormatValues() []PolicyExportFormat {
	return []PolicyExportFormat{PolicyExportFormatRawxml, PolicyExportFormatXML}
}

// PolicyScopeContract enumerates the values for policy scope contract.
type PolicyScopeContract string

const (
	// PolicyScopeContractAll ...
	PolicyScopeContractAll PolicyScopeContract = "All"
	// PolicyScopeContractAPI ...
	PolicyScopeContractAPI PolicyScopeContract = "Api"
	// PolicyScopeContractOperation ...
	PolicyScopeContractOperation PolicyScopeContract = "Operation"
	// PolicyScopeContractProduct ...
	PolicyScopeContractProduct PolicyScopeContract = "Product"
	// PolicyScopeContractTenant ...
	PolicyScopeContractTenant PolicyScopeContract = "Tenant"
)

// PossiblePolicyScopeContractValues returns an array of possible values for the PolicyScopeContract const type.
func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return []PolicyScopeContract{PolicyScopeContractAll, PolicyScopeContractAPI, PolicyScopeContractOperation, PolicyScopeContractProduct, PolicyScopeContractTenant}
}

// PortalRevisionStatus enumerates the values for portal revision status.
type PortalRevisionStatus string

const (
	// PortalRevisionStatusCompleted Portal's revision publishing completed.
	PortalRevisionStatusCompleted PortalRevisionStatus = "completed"
	// PortalRevisionStatusFailed Portal's revision publishing failed.
	PortalRevisionStatusFailed PortalRevisionStatus = "failed"
	// PortalRevisionStatusPending Portal's revision has been queued.
	PortalRevisionStatusPending PortalRevisionStatus = "pending"
	// PortalRevisionStatusPublishing Portal's revision is being published.
	PortalRevisionStatusPublishing PortalRevisionStatus = "publishing"
)

// PossiblePortalRevisionStatusValues returns an array of possible values for the PortalRevisionStatus const type.
func PossiblePortalRevisionStatusValues() []PortalRevisionStatus {
	return []PortalRevisionStatus{PortalRevisionStatusCompleted, PortalRevisionStatusFailed, PortalRevisionStatusPending, PortalRevisionStatusPublishing}
}

// ProductState enumerates the values for product state.
type ProductState string

const (
	// ProductStateNotPublished ...
	ProductStateNotPublished ProductState = "notPublished"
	// ProductStatePublished ...
	ProductStatePublished ProductState = "published"
)

// PossibleProductStateValues returns an array of possible values for the ProductState const type.
func PossibleProductStateValues() []ProductState {
	return []ProductState{ProductStateNotPublished, ProductStatePublished}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "https"
	// ProtocolWs ...
	ProtocolWs Protocol = "ws"
	// ProtocolWss ...
	ProtocolWss Protocol = "wss"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS, ProtocolWs, ProtocolWss}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "created"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreated}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic Supported scale type automatic.
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "automatic"
	// ResourceSkuCapacityScaleTypeManual Supported scale type manual.
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "manual"
	// ResourceSkuCapacityScaleTypeNone Scaling not supported.
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "none"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// SamplingType enumerates the values for sampling type.
type SamplingType string

const (
	// SamplingTypeFixed Fixed-rate sampling.
	SamplingTypeFixed SamplingType = "fixed"
)

// PossibleSamplingTypeValues returns an array of possible values for the SamplingType const type.
func PossibleSamplingTypeValues() []SamplingType {
	return []SamplingType{SamplingTypeFixed}
}

// SkuCapacityScaleType enumerates the values for sku capacity scale type.
type SkuCapacityScaleType string

const (
	// SkuCapacityScaleTypeAutomatic ...
	SkuCapacityScaleTypeAutomatic SkuCapacityScaleType = "Automatic"
	// SkuCapacityScaleTypeManual ...
	SkuCapacityScaleTypeManual SkuCapacityScaleType = "Manual"
	// SkuCapacityScaleTypeNone ...
	SkuCapacityScaleTypeNone SkuCapacityScaleType = "None"
)

// PossibleSkuCapacityScaleTypeValues returns an array of possible values for the SkuCapacityScaleType const type.
func PossibleSkuCapacityScaleTypeValues() []SkuCapacityScaleType {
	return []SkuCapacityScaleType{SkuCapacityScaleTypeAutomatic, SkuCapacityScaleTypeManual, SkuCapacityScaleTypeNone}
}

// SkuRestrictionsReasonCode enumerates the values for sku restrictions reason code.
type SkuRestrictionsReasonCode string

const (
	// SkuRestrictionsReasonCodeNotAvailableForSubscription ...
	SkuRestrictionsReasonCodeNotAvailableForSubscription SkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// SkuRestrictionsReasonCodeQuotaID ...
	SkuRestrictionsReasonCodeQuotaID SkuRestrictionsReasonCode = "QuotaId"
)

// PossibleSkuRestrictionsReasonCodeValues returns an array of possible values for the SkuRestrictionsReasonCode const type.
func PossibleSkuRestrictionsReasonCodeValues() []SkuRestrictionsReasonCode {
	return []SkuRestrictionsReasonCode{SkuRestrictionsReasonCodeNotAvailableForSubscription, SkuRestrictionsReasonCodeQuotaID}
}

// SkuRestrictionsType enumerates the values for sku restrictions type.
type SkuRestrictionsType string

const (
	// SkuRestrictionsTypeLocation ...
	SkuRestrictionsTypeLocation SkuRestrictionsType = "Location"
	// SkuRestrictionsTypeZone ...
	SkuRestrictionsTypeZone SkuRestrictionsType = "Zone"
)

// PossibleSkuRestrictionsTypeValues returns an array of possible values for the SkuRestrictionsType const type.
func PossibleSkuRestrictionsTypeValues() []SkuRestrictionsType {
	return []SkuRestrictionsType{SkuRestrictionsTypeLocation, SkuRestrictionsTypeZone}
}

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// SkuTypeBasic Basic SKU of Api Management.
	SkuTypeBasic SkuType = "Basic"
	// SkuTypeConsumption Consumption SKU of Api Management.
	SkuTypeConsumption SkuType = "Consumption"
	// SkuTypeDeveloper Developer SKU of Api Management.
	SkuTypeDeveloper SkuType = "Developer"
	// SkuTypeIsolated Isolated SKU of Api Management.
	SkuTypeIsolated SkuType = "Isolated"
	// SkuTypePremium Premium SKU of Api Management.
	SkuTypePremium SkuType = "Premium"
	// SkuTypeStandard Standard SKU of Api Management.
	SkuTypeStandard SkuType = "Standard"
)

// PossibleSkuTypeValues returns an array of possible values for the SkuType const type.
func PossibleSkuTypeValues() []SkuType {
	return []SkuType{SkuTypeBasic, SkuTypeConsumption, SkuTypeDeveloper, SkuTypeIsolated, SkuTypePremium, SkuTypeStandard}
}

// SoapAPIType enumerates the values for soap api type.
type SoapAPIType string

const (
	// SoapAPITypeSoapPassThrough Imports the Soap API having a SOAP front end.
	SoapAPITypeSoapPassThrough SoapAPIType = "soap"
	// SoapAPITypeSoapToRest Imports a SOAP API having a RESTful front end.
	SoapAPITypeSoapToRest SoapAPIType = "http"
	// SoapAPITypeWebSocket Imports the Soap API having a Websocket front end.
	SoapAPITypeWebSocket SoapAPIType = "websocket"
)

// PossibleSoapAPITypeValues returns an array of possible values for the SoapAPIType const type.
func PossibleSoapAPITypeValues() []SoapAPIType {
	return []SoapAPIType{SoapAPITypeSoapPassThrough, SoapAPITypeSoapToRest, SoapAPITypeWebSocket}
}

// State enumerates the values for state.
type State string

const (
	// StateClosed The issue was closed.
	StateClosed State = "closed"
	// StateOpen The issue is opened.
	StateOpen State = "open"
	// StateProposed The issue is proposed.
	StateProposed State = "proposed"
	// StateRemoved The issue was removed.
	StateRemoved State = "removed"
	// StateResolved The issue is now resolved.
	StateResolved State = "resolved"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateClosed, StateOpen, StateProposed, StateRemoved, StateResolved}
}

// StoreName enumerates the values for store name.
type StoreName string

const (
	// StoreNameCertificateAuthority ...
	StoreNameCertificateAuthority StoreName = "CertificateAuthority"
	// StoreNameRoot ...
	StoreNameRoot StoreName = "Root"
)

// PossibleStoreNameValues returns an array of possible values for the StoreName const type.
func PossibleStoreNameValues() []StoreName {
	return []StoreName{StoreNameCertificateAuthority, StoreNameRoot}
}

// SubscriptionState enumerates the values for subscription state.
type SubscriptionState string

const (
	// SubscriptionStateActive ...
	SubscriptionStateActive SubscriptionState = "active"
	// SubscriptionStateCancelled ...
	SubscriptionStateCancelled SubscriptionState = "cancelled"
	// SubscriptionStateExpired ...
	SubscriptionStateExpired SubscriptionState = "expired"
	// SubscriptionStateRejected ...
	SubscriptionStateRejected SubscriptionState = "rejected"
	// SubscriptionStateSubmitted ...
	SubscriptionStateSubmitted SubscriptionState = "submitted"
	// SubscriptionStateSuspended ...
	SubscriptionStateSuspended SubscriptionState = "suspended"
)

// PossibleSubscriptionStateValues returns an array of possible values for the SubscriptionState const type.
func PossibleSubscriptionStateValues() []SubscriptionState {
	return []SubscriptionState{SubscriptionStateActive, SubscriptionStateCancelled, SubscriptionStateExpired, SubscriptionStateRejected, SubscriptionStateSubmitted, SubscriptionStateSuspended}
}

// TemplateName enumerates the values for template name.
type TemplateName string

const (
	// TemplateNameAccountClosedDeveloper ...
	TemplateNameAccountClosedDeveloper TemplateName = "accountClosedDeveloper"
	// TemplateNameApplicationApprovedNotificationMessage ...
	TemplateNameApplicationApprovedNotificationMessage TemplateName = "applicationApprovedNotificationMessage"
	// TemplateNameConfirmSignUpIdentityDefault ...
	TemplateNameConfirmSignUpIdentityDefault TemplateName = "confirmSignUpIdentityDefault"
	// TemplateNameEmailChangeIdentityDefault ...
	TemplateNameEmailChangeIdentityDefault TemplateName = "emailChangeIdentityDefault"
	// TemplateNameInviteUserNotificationMessage ...
	TemplateNameInviteUserNotificationMessage TemplateName = "inviteUserNotificationMessage"
	// TemplateNameNewCommentNotificationMessage ...
	TemplateNameNewCommentNotificationMessage TemplateName = "newCommentNotificationMessage"
	// TemplateNameNewDeveloperNotificationMessage ...
	TemplateNameNewDeveloperNotificationMessage TemplateName = "newDeveloperNotificationMessage"
	// TemplateNameNewIssueNotificationMessage ...
	TemplateNameNewIssueNotificationMessage TemplateName = "newIssueNotificationMessage"
	// TemplateNamePasswordResetByAdminNotificationMessage ...
	TemplateNamePasswordResetByAdminNotificationMessage TemplateName = "passwordResetByAdminNotificationMessage"
	// TemplateNamePasswordResetIdentityDefault ...
	TemplateNamePasswordResetIdentityDefault TemplateName = "passwordResetIdentityDefault"
	// TemplateNamePurchaseDeveloperNotificationMessage ...
	TemplateNamePurchaseDeveloperNotificationMessage TemplateName = "purchaseDeveloperNotificationMessage"
	// TemplateNameQuotaLimitApproachingDeveloperNotificationMessage ...
	TemplateNameQuotaLimitApproachingDeveloperNotificationMessage TemplateName = "quotaLimitApproachingDeveloperNotificationMessage"
	// TemplateNameRejectDeveloperNotificationMessage ...
	TemplateNameRejectDeveloperNotificationMessage TemplateName = "rejectDeveloperNotificationMessage"
	// TemplateNameRequestDeveloperNotificationMessage ...
	TemplateNameRequestDeveloperNotificationMessage TemplateName = "requestDeveloperNotificationMessage"
)

// PossibleTemplateNameValues returns an array of possible values for the TemplateName const type.
func PossibleTemplateNameValues() []TemplateName {
	return []TemplateName{TemplateNameAccountClosedDeveloper, TemplateNameApplicationApprovedNotificationMessage, TemplateNameConfirmSignUpIdentityDefault, TemplateNameEmailChangeIdentityDefault, TemplateNameInviteUserNotificationMessage, TemplateNameNewCommentNotificationMessage, TemplateNameNewDeveloperNotificationMessage, TemplateNameNewIssueNotificationMessage, TemplateNamePasswordResetByAdminNotificationMessage, TemplateNamePasswordResetIdentityDefault, TemplateNamePurchaseDeveloperNotificationMessage, TemplateNameQuotaLimitApproachingDeveloperNotificationMessage, TemplateNameRejectDeveloperNotificationMessage, TemplateNameRequestDeveloperNotificationMessage}
}

// UserState enumerates the values for user state.
type UserState string

const (
	// UserStateActive User state is active.
	UserStateActive UserState = "active"
	// UserStateBlocked User is blocked. Blocked users cannot authenticate at developer portal or call API.
	UserStateBlocked UserState = "blocked"
	// UserStateDeleted User account is closed. All identities and related entities are removed.
	UserStateDeleted UserState = "deleted"
	// UserStatePending User account is pending. Requires identity confirmation before it can be made active.
	UserStatePending UserState = "pending"
)

// PossibleUserStateValues returns an array of possible values for the UserState const type.
func PossibleUserStateValues() []UserState {
	return []UserState{UserStateActive, UserStateBlocked, UserStateDeleted, UserStatePending}
}

// Verbosity enumerates the values for verbosity.
type Verbosity string

const (
	// VerbosityError Only traces with 'severity' set to 'error' will be sent to the logger attached to this
	// diagnostic instance.
	VerbosityError Verbosity = "error"
	// VerbosityInformation Traces with 'severity' set to 'information' and 'error' will be sent to the logger
	// attached to this diagnostic instance.
	VerbosityInformation Verbosity = "information"
	// VerbosityVerbose All the traces emitted by trace policies will be sent to the logger attached to this
	// diagnostic instance.
	VerbosityVerbose Verbosity = "verbose"
)

// PossibleVerbosityValues returns an array of possible values for the Verbosity const type.
func PossibleVerbosityValues() []Verbosity {
	return []Verbosity{VerbosityError, VerbosityInformation, VerbosityVerbose}
}

// VersioningScheme enumerates the values for versioning scheme.
type VersioningScheme string

const (
	// VersioningSchemeHeader The API Version is passed in a HTTP header.
	VersioningSchemeHeader VersioningScheme = "Header"
	// VersioningSchemeQuery The API Version is passed in a query parameter.
	VersioningSchemeQuery VersioningScheme = "Query"
	// VersioningSchemeSegment The API Version is passed in a path segment.
	VersioningSchemeSegment VersioningScheme = "Segment"
)

// PossibleVersioningSchemeValues returns an array of possible values for the VersioningScheme const type.
func PossibleVersioningSchemeValues() []VersioningScheme {
	return []VersioningScheme{VersioningSchemeHeader, VersioningSchemeQuery, VersioningSchemeSegment}
}

// VersioningScheme1 enumerates the values for versioning scheme 1.
type VersioningScheme1 string

const (
	// VersioningScheme1Header ...
	VersioningScheme1Header VersioningScheme1 = "Header"
	// VersioningScheme1Query ...
	VersioningScheme1Query VersioningScheme1 = "Query"
	// VersioningScheme1Segment ...
	VersioningScheme1Segment VersioningScheme1 = "Segment"
)

// PossibleVersioningScheme1Values returns an array of possible values for the VersioningScheme1 const type.
func PossibleVersioningScheme1Values() []VersioningScheme1 {
	return []VersioningScheme1{VersioningScheme1Header, VersioningScheme1Query, VersioningScheme1Segment}
}

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal The service is part of Virtual Network and it is accessible from Internet.
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal The service is part of Virtual Network and it is only accessible from within
	// the virtual network.
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone The service is not part of any Virtual Network.
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// PossibleVirtualNetworkTypeValues returns an array of possible values for the VirtualNetworkType const type.
func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return []VirtualNetworkType{VirtualNetworkTypeExternal, VirtualNetworkTypeInternal, VirtualNetworkTypeNone}
}
